
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `koken02224`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]albums`
--

CREATE TABLE `[[dbprefix]]albums` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `old_slug` text,
  `summary` varchar(255) DEFAULT NULL,
  `description` text,
  `sort` varchar(255) DEFAULT 'manual ASC',
  `visibility` tinyint(1) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '1',
  `left_id` int(11) NOT NULL,
  `right_id` int(11) NOT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `featured_on` int(10) DEFAULT NULL,
  `featured_order` int(11) DEFAULT NULL,
  `total_count` int(11) NOT NULL DEFAULT '0',
  `video_count` int(11) NOT NULL DEFAULT '0',
  `published_on` int(10) DEFAULT NULL,
  `created_on` int(10) NOT NULL,
  `modified_on` int(10) NOT NULL,
  `album_type` tinyint(1) NOT NULL DEFAULT '0',
  `internal_id` char(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `deleted` (`deleted`),
  KEY `level` (`level`),
  KEY `left_id` (`left_id`),
  KEY `right_id` (`right_id`),
  KEY `total_count` (`total_count`),
  KEY `video_count` (`video_count`),
  KEY `created_on` (`created_on`),
  KEY `published_on` (`published_on`),
  KEY `modified_on` (`modified_on`),
  KEY `album_type` (`album_type`),
  KEY `internal_id` (`internal_id`),
  KEY `featured_featured_order` (`featured`,`featured_order`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]applications`
--

CREATE TABLE `[[dbprefix]]applications` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `nonce` varchar(32) DEFAULT NULL,
  `token` varchar(32) DEFAULT NULL,
  `role` varchar(10) DEFAULT 'read',
  `name` varchar(255) DEFAULT NULL,
  `created_on` int(11) NOT NULL,
  `single_use` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `nonce` (`nonce`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `album_count` int(11) NOT NULL DEFAULT '0',
  `text_count` int(11) NOT NULL DEFAULT '0',
  `content_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `album_count` (`album_count`),
  KEY `content_count` (`content_count`),
  KEY `text_count` (`text_count`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content`
--

CREATE TABLE `[[dbprefix]]content` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `old_slug` text,
  `filename` varchar(255) DEFAULT NULL,
  `caption` text,
  `visibility` tinyint(1) NOT NULL DEFAULT '0',
  `max_download` tinyint(1) NOT NULL DEFAULT '0',
  `license` char(3) NOT NULL DEFAULT 'all',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `featured_order` int(11) DEFAULT NULL,
  `favorite_order` int(11) DEFAULT NULL,
  `favorite` tinyint(1) NOT NULL DEFAULT '0',
  `favorited_on` int(10) DEFAULT NULL,
  `featured_on` int(10) DEFAULT NULL,
  `uploaded_on` int(10) NOT NULL,
  `captured_on` int(10) NOT NULL,
  `published_on` int(10) DEFAULT NULL,
  `modified_on` int(10) NOT NULL,
  `file_modified_on` int(10) NOT NULL,
  `focal_point` varchar(255) DEFAULT NULL,
  `filesize` int(11) NOT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `aspect_ratio` decimal(5,3) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `file_type` tinyint(1) NOT NULL DEFAULT '0',
  `lg_preview` varchar(255) DEFAULT NULL,
  `internal_id` char(32) NOT NULL,
  `has_exif` tinyint(1) NOT NULL DEFAULT '0',
  `has_iptc` tinyint(1) NOT NULL DEFAULT '0',
  `source` varchar(255) DEFAULT NULL,
  `source_url` varchar(255) DEFAULT NULL,
  `html` text,
  `storage_url` varchar(255) DEFAULT NULL,
  `storage_url_midsize` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `title` (`title`),
  KEY `deleted` (`deleted`),
  KEY `uploaded_on` (`uploaded_on`),
  KEY `captured_on` (`captured_on`),
  KEY `modified_on` (`modified_on`),
  KEY `published_on` (`published_on`),
  KEY `filesize` (`filesize`),
  KEY `file_type` (`file_type`),
  KEY `has_iptc` (`has_iptc`),
  KEY `has_exif` (`has_exif`),
  KEY `width` (`width`),
  KEY `height` (`height`),
  KEY `aspect_ratio` (`aspect_ratio`),
  KEY `featured_featured_order` (`featured`,`featured_order`),
  KEY `favorite_favorite_order` (`favorite`,`favorite_order`),
  KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]drafts`
--

CREATE TABLE `[[dbprefix]]drafts` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `path` varchar(255) DEFAULT NULL,
  `live_data` mediumtext,
  `data` mediumtext NOT NULL,
  `current` tinyint(1) NOT NULL DEFAULT '0',
  `draft` tinyint(1) NOT NULL DEFAULT '0',
  `created_on` int(10) NOT NULL,
  `modified_on` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `current` (`current`),
  KEY `draft` (`draft`),
  KEY `created_on` (`created_on`),
  KEY `modified_on` (`modified_on`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]drafts`
--

INSERT INTO `[[dbprefix]]drafts` VALUES
(1, 'elementary', '{"navigation":{"items":[{"auto":"home","front":true,"path":"\\/home\\/"},{"auto":"timeline"},{"auto":"albums"},{"auto":"contents"},{"auto":"essays"}],"groups":[{"key":"footer","label":"Footer","items":[{"auto":"home","front":true,"path":"\\/home\\/"},{"auto":"albums"},{"auto":"contents"},{"auto":"essays"}]},{"key":"aside_links","label":"Aside links","items":[]}]}}', '{"navigation":{"items":[{"auto":"home","front":true,"path":"\\/home\\/"},{"auto":"timeline"},{"auto":"albums"},{"auto":"contents"},{"auto":"essays"}],"groups":[{"key":"footer","label":"Footer","items":[{"auto":"home","front":true,"path":"\\/home\\/"},{"auto":"albums"},{"auto":"contents"},{"auto":"essays"}]},{"key":"aside_links","label":"Aside links","items":[]}]}}', 1, 1, [[timestamp]], [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]history`
--

CREATE TABLE `[[dbprefix]]history` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `message` text,
  `created_on` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]history`
--

INSERT INTO `[[dbprefix]]history` VALUES
(1, 1, 's:14:"system:install";', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_albums_categories`
--

CREATE TABLE `[[dbprefix]]join_albums_categories` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `album_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `album_id` (`album_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_albums_content`
--

CREATE TABLE `[[dbprefix]]join_albums_content` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `album_id` int(11) NOT NULL,
  `content_id` int(11) NOT NULL,
  `order` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `album_id` (`album_id`),
  KEY `content_id` (`content_id`),
  KEY `order` (`order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_albums_covers`
--

CREATE TABLE `[[dbprefix]]join_albums_covers` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `album_id` int(11) NOT NULL,
  `cover_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `album_id` (`album_id`),
  KEY `cover_id` (`cover_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_albums_tags`
--

CREATE TABLE `[[dbprefix]]join_albums_tags` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) NOT NULL,
  `album_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_id` (`tag_id`),
  KEY `album_id` (`album_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_albums_text`
--

CREATE TABLE `[[dbprefix]]join_albums_text` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `album_id` int(11) NOT NULL,
  `text_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `album_id` (`album_id`),
  KEY `text_id` (`text_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_categories_content`
--

CREATE TABLE `[[dbprefix]]join_categories_content` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_categories_text`
--

CREATE TABLE `[[dbprefix]]join_categories_text` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `text_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `text_id` (`text_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_content_tags`
--

CREATE TABLE `[[dbprefix]]join_content_tags` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) NOT NULL,
  `content_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_id` (`tag_id`),
  KEY `content_id` (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]join_tags_text`
--

CREATE TABLE `[[dbprefix]]join_tags_text` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) NOT NULL,
  `text_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `text_id` (`text_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `path` varchar(255) DEFAULT NULL,
  `setup` tinyint(1) NOT NULL DEFAULT '1',
  `data` longtext,
  PRIMARY KEY (`id`),
  KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `value` text,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=44 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, 'site_timezone', 'America/New_York'),
(2, 'console_show_notifications', 'yes'),
(3, 'console_enable_keyboard_shortcuts', 'yes'),
(4, 'uploading_default_license', 'all'),
(5, 'uploading_default_visibility', 'public'),
(6, 'uploading_default_album_visibility', 'public'),
(7, 'uploading_default_max_download_size', 'none'),
(8, 'uploading_publish_on_captured_date', 'false'),
(9, 'site_title', '[[admin_fname]] [[admin_lname]]'),
(10, 'site_page_title', '[[admin_fname]] [[admin_lname]]'),
(11, 'site_tagline', 'Your site tagline'),
(12, 'site_copyright', '© [[admin_fname]] [[admin_lname]]'),
(13, 'site_description', ''),
(14, 'site_keywords', 'photography, [[admin_fname]] [[admin_lname]]'),
(15, 'site_date_format', 'F j, Y'),
(16, 'site_time_format', 'g:i a'),
(17, 'site_privacy', 'public'),
(18, 'site_hidpi', 'true'),
(19, 'site_url', 'default'),
(20, 'use_default_labels_links', 'true'),
(21, 'uuid', '[[uuid]]'),
(22, 'retain_image_metadata', 'false'),
(23, 'image_use_defaults', 'true'),
(24, 'image_tiny_quality', '80'),
(25, 'image_small_quality', '80'),
(26, 'image_medium_quality', '85'),
(27, 'image_medium_large_quality', '85'),
(28, 'image_large_quality', '85'),
(29, 'image_xlarge_quality', '90'),
(30, 'image_huge_quality', '90'),
(31, 'image_tiny_sharpening', '0.7'),
(32, 'image_small_sharpening', '0.6'),
(33, 'image_medium_sharpening', '0.6'),
(34, 'image_medium_large_sharpening', '0.6'),
(35, 'image_large_sharpening', '0.6'),
(36, 'image_xlarge_sharpening', '0.3'),
(37, 'image_huge_sharpening', '0'),
(38, 'last_upload', 'false'),
(39, 'last_migration', '42'),
(40, 'has_toured', '0'),
(41, 'email_handler', 'DDI_Email'),
(42, 'email_delivery_address', '[[admin_email]]'),
(43, 'image_processing_library', 'convert');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]slugs`
--

CREATE TABLE `[[dbprefix]]slugs` (
  `id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tags`
--

CREATE TABLE `[[dbprefix]]tags` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `created_on` int(10) NOT NULL,
  `modified_on` int(10) NOT NULL,
  `last_used` int(10) DEFAULT NULL,
  `album_count` int(11) NOT NULL DEFAULT '0',
  `text_count` int(11) NOT NULL DEFAULT '0',
  `content_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]text`
--

CREATE TABLE `[[dbprefix]]text` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` text,
  `draft_title` text,
  `slug` varchar(255) DEFAULT NULL,
  `old_slug` text,
  `featured_image_id` int(10) DEFAULT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `featured_on` int(10) DEFAULT NULL,
  `featured_order` int(11) DEFAULT NULL,
  `custom_featured_image` varchar(255) DEFAULT NULL,
  `content` longtext,
  `draft` longtext,
  `excerpt` varchar(255) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `page_type` int(1) NOT NULL DEFAULT '0',
  `published_on` int(10) DEFAULT NULL,
  `created_on` int(10) NOT NULL,
  `modified_on` int(10) NOT NULL,
  `internal_id` char(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`),
  KEY `created_on` (`created_on`),
  KEY `modified_on` (`modified_on`),
  KEY `published_on` (`published_on`),
  KEY `page_type` (`page_type`),
  KEY `internal_id` (`internal_id`),
  KEY `featured_image_id` (`featured_image_id`),
  KEY `slug` (`slug`),
  KEY `featured_featured_order` (`featured`,`featured_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]trash`
--

CREATE TABLE `[[dbprefix]]trash` (
  `id` varchar(255) NOT NULL,
  `data` text,
  `created_on` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]urls`
--

CREATE TABLE `[[dbprefix]]urls` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `data` text,
  `created_on` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]urls`
--

INSERT INTO `[[dbprefix]]urls` VALUES
(1, 'a:10:{i:0;a:2:{s:4:"type";s:7:"content";s:4:"data";a:4:{s:8:"singular";s:7:"Content";s:6:"plural";s:7:"Content";s:5:"order";s:17:"published_on DESC";s:3:"url";s:4:"slug";}}i:1;a:2:{s:4:"type";s:8:"favorite";s:4:"data";a:3:{s:8:"singular";s:8:"Favorite";s:6:"plural";s:9:"Favorites";s:5:"order";s:10:"manual ASC";}}i:2;a:2:{s:4:"type";s:7:"feature";s:4:"data";a:3:{s:8:"singular";s:7:"Feature";s:6:"plural";s:8:"Features";s:5:"order";s:10:"manual ASC";}}i:3;a:2:{s:4:"type";s:5:"album";s:4:"data";a:4:{s:8:"singular";s:5:"Album";s:6:"plural";s:6:"Albums";s:5:"order";s:10:"manual ASC";s:3:"url";s:4:"slug";}}i:4;a:2:{s:4:"type";s:3:"set";s:4:"data";a:3:{s:8:"singular";s:3:"Set";s:6:"plural";s:4:"Sets";s:5:"order";s:9:"title ASC";}}i:5;a:2:{s:4:"type";s:5:"essay";s:4:"data";a:4:{s:8:"singular";s:5:"Essay";s:6:"plural";s:6:"Essays";s:5:"order";s:17:"published_on DESC";s:3:"url";s:9:"date+slug";}}i:6;a:2:{s:4:"type";s:4:"page";s:4:"data";a:3:{s:8:"singular";s:4:"Page";s:6:"plural";s:5:"Pages";s:3:"url";s:4:"slug";}}i:7;a:2:{s:4:"type";s:3:"tag";s:4:"data";a:2:{s:8:"singular";s:3:"Tag";s:6:"plural";s:4:"Tags";}}i:8;a:2:{s:4:"type";s:8:"category";s:4:"data";a:2:{s:8:"singular";s:8:"Category";s:6:"plural";s:10:"Categories";}}i:9;a:2:{s:4:"type";s:8:"timeline";s:4:"data";a:2:{s:8:"singular";s:8:"Timeline";s:6:"plural";s:8:"Timeline";}}}', [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `password` varchar(60) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `created_on` int(10) NOT NULL,
  `modified_on` int(10) NOT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `public_first_name` varchar(255) DEFAULT NULL,
  `public_last_name` varchar(255) DEFAULT NULL,
  `public_display` varchar(255) DEFAULT 'both',
  `public_email` varchar(255) DEFAULT NULL,
  `twitter` varchar(255) DEFAULT NULL,
  `facebook` varchar(255) DEFAULT NULL,
  `google` varchar(255) DEFAULT NULL,
  `internal_id` char(32) NOT NULL,
  `remember_me` char(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `password` (`password`),
  KEY `email` (`email`),
  KEY `internal_id` (`internal_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_pass]]', '[[admin_email]]', [[timestamp]], [[timestamp]], '[[admin_fname]]', '[[admin_lname]]', '[[admin_fname]]', '[[admin_lname]]', 'both', '[[admin_email]]', NULL, NULL, NULL, '[[internal_id]]', NULL);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
