

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_jobber20`
--

-- --------------------------------------------------------

--
-- Table structure for table `admin`
--

CREATE TABLE `admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(16) NOT NULL,
  `password` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `admin`
--

INSERT INTO `admin` VALUES
(1, '[[admin_username]]', '[[admin_pass]]');

-- --------------------------------------------------------

--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `var_name` varchar(32) NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `keywords` text NOT NULL,
  `category_order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_order` (`category_order`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='programming/design/admin/etc.' AUTO_INCREMENT=15 ;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` VALUES
(1, 'Programmers', 'programmers', '', '', '', 7),
(2, 'Designers', 'designers', '', '', '', 3),
(3, 'Administrators', 'administrators', '', '', '', 0),
(7, 'Marketers', 'marketers', '', '', '', 2),
(5, 'Testers', 'testers', '', '', '', 5),
(6, 'Editors', 'editors', '', '', '', 1),
(8, 'Managers', 'managers', '', '', '', 4),
(9, 'Consultants', 'consultants', '', '', '', 6);

-- --------------------------------------------------------

--
-- Table structure for table `cities`
--

CREATE TABLE `cities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `ascii_name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=73 ;

--
-- Dumping data for table `cities`
--

INSERT INTO `cities` VALUES
(1, 'London', 'London'),
(2, 'Buenos Aires', 'Buenos-Aires'),
(3, 'New York', 'New-York'),
(4, 'Tokyo', 'Tokyo'),
(5, 'Cairo', 'Cairo');

-- --------------------------------------------------------

--
-- Table structure for table `hits`
--

CREATE TABLE `hits` (
  `job_id` int(10) unsigned NOT NULL,
  `created_on` datetime NOT NULL,
  `ip` varchar(15) NOT NULL,
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `hits`
--

INSERT INTO `hits` VALUES
(1, '2014-04-14 08:46:00', '127.0.0.1');

-- --------------------------------------------------------

--
-- Table structure for table `i18n_langs`
--

CREATE TABLE `i18n_langs` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `code` varchar(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `i18n_langs`
--

INSERT INTO `i18n_langs` VALUES
(1, 'English', 'en');

-- --------------------------------------------------------

--
-- Table structure for table `i18n_translations`
--

CREATE TABLE `i18n_translations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `lang_id` tinyint(3) unsigned NOT NULL,
  `item` text NOT NULL,
  `value` text NOT NULL,
  `field_type` varchar(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`,`lang_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=281 ;

--
-- Dumping data for table `i18n_translations`
--

INSERT INTO `i18n_translations` VALUES
(1, 0, 1, 'header', '', ''),
(2, 1, 1, 'name', 'jobber', ''),
(3, 1, 1, 'title', 'IT jobs', ''),
(4, 1, 1, 'home', 'Home', ''),
(5, 1, 1, 'rss_alt', 'RSS', ''),
(6, 1, 1, 'rss_title', 'Subscribe to the RSS feed', ''),
(7, 1, 1, 'seen_recently', 'Seen recently', ''),
(8, 0, 1, 'search', '', ''),
(9, 8, 1, 'default', 'Search for a job', ''),
(10, 8, 1, 'example', '(e.g. &quot;ajax&quot;, &quot;designer, london&quot;, &quot;php, chicago&quot;)', ''),
(11, 8, 1, 'submit', 'Post a new job', ''),
(12, 8, 1, 'submit_title', 'Post a new job', ''),
(13, 0, 1, 'footer', '', ''),
(14, 13, 1, 'column_use', 'Use', ''),
(15, 13, 1, 'new_job', 'Post a new job', ''),
(16, 13, 1, 'new_job_title', 'Post a new job', ''),
(17, 13, 1, 'rss', 'RSS Feeds', ''),
(18, 13, 1, 'rss_title', 'RSS Feeds', ''),
(19, 13, 1, 'column_find', 'Find out more', ''),
(20, 13, 1, 'column_misc', 'Misc', ''),
(21, 13, 1, 'companies', 'Companies', ''),
(22, 13, 1, 'companies_title', 'Companies', ''),
(23, 13, 1, 'cities_title', 'Cities', ''),
(24, 13, 1, 'cities', 'Cities', ''),
(25, 13, 1, 'widgets', 'Widgets', ''),
(26, 13, 1, 'widgets_title', 'Widgets', ''),
(27, 13, 1, 'powered_by', 'Proudly powered by', ''),
(28, 0, 1, 'sidebar', '', ''),
(29, 28, 1, 'menu_title', 'Navigation', ''),
(30, 28, 1, 'other_cities', 'Other cities', ''),
(31, 0, 1, 'jobs', '', ''),
(32, 31, 1, 'html_title', '{0} at {1} / {2}', ''),
(33, 31, 1, 'activated_success', 'Job ad was successfully activated.', ''),
(34, 31, 1, 'delete_success', 'Your job ad was deleted.', ''),
(35, 31, 1, 'confirmation_success', 'Your job ad was published.', ''),
(36, 31, 1, 'confirmation_error', 'Your job ad was cancelled.', ''),
(37, 31, 1, 'publish_success', 'Congratulations, your job ad was published!', ''),
(38, 31, 1, 'add_success', 'Your job ad was successfully posted!', ''),
(39, 31, 1, 'type_error', 'Please enter the job type.', ''),
(40, 31, 1, 'title_error', 'Please enter job title.', ''),
(41, 31, 1, 'description_error', 'Please enter job description.', ''),
(42, 31, 1, 'email_error', 'Please enter your e-mail.', ''),
(43, 31, 1, 'email_invalid', 'The E-mail address is invalid', ''),
(44, 31, 1, 'job_title_error', 'Please enter job title.', ''),
(45, 31, 1, 'job_description_error', 'Please enter job description.', ''),
(46, 31, 1, 'job_email_error', 'Please enter your e-mail.', ''),
(47, 31, 1, 'title_edit', 'Edit your job ad', ''),
(48, 31, 1, 'title_new', 'Post a new job', ''),
(49, 31, 1, 'report_fake', 'Is this job ad fake?', ''),
(50, 31, 1, 'report_it', 'Report it!', ''),
(51, 31, 1, 'published_at', 'Published at {0}', ''),
(52, 31, 1, 'viewed', 'Viewed: {0} times', ''),
(53, 31, 1, 'no_job', 'There are currently no available jobs for', ''),
(54, 31, 1, 'no_job_found', 'No jobs were found.', ''),
(55, 31, 1, 'preposition_at', 'at', ''),
(56, 31, 1, 'location_anywhere', 'Anywhere', ''),
(57, 31, 1, 'recent_jobs', 'Recent jobs at', ''),
(58, 31, 1, 'company_undisclosed', 'Undisclosed', ''),
(59, 31, 1, 'all_jobs', 'View all jobs at', ''),
(60, 0, 1, 'alljobs', '', ''),
(61, 60, 1, 'all_jobs', 'All jobs', ''),
(62, 60, 1, 'no_jobs', 'The are currently no available jobs.', ''),
(63, 0, 1, 'apply', '', ''),
(64, 63, 1, 'apply_message', '&raquo; Apply now', ''),
(65, 63, 1, 'name_error', 'Please enter your name.', ''),
(66, 63, 1, 'email_error', 'Please enter your e-mail.', ''),
(67, 63, 1, 'msg_error', 'Please enter a message.', ''),
(68, 63, 1, 'cv_error', 'Resume/CV size can be maximum 3 MB.', ''),
(69, 63, 1, 'email_invalid', 'The E-mail address is invalid', ''),
(70, 63, 1, 'success', 'Congratulations, your application has been sent! Best of luck to you!', ''),
(71, 63, 1, 'old_ad', 'This job ad has been posted over {0} days ago...', ''),
(72, 63, 1, 'name_label', 'Your name', ''),
(73, 63, 1, 'email_label', 'Your e-mail', ''),
(74, 63, 1, 'message_label', 'Message<br />or letter of intention', ''),
(75, 63, 1, 'cv_label', 'Upload resume/CV', ''),
(76, 63, 1, 'cv_info', 'Max. 3 MB. Recommended formats: PDF, RTF, DOC, ODT. ', ''),
(77, 63, 1, 'cancel', 'cancel', ''),
(78, 63, 1, 'submit', 'Send my application', ''),
(79, 63, 1, 'or', 'or', ''),
(80, 63, 1, 'error_apply_timeout_not_passed', 'Your application was not sent because {0} minutes must pass before you can apply again.', ''),
(81, 63, 1, 'error_sending_mail', 'There was an error sending your application to the employer.', ''),
(82, 63, 1, 'errro_apply_data_invalid', 'Your application form contains errors. Please correct them and try again.', ''),
(83, 0, 1, 'captcha', '', ''),
(84, 83, 1, 'captcha_error', 'Incorrect code.', ''),
(85, 83, 1, 'captcha_title', 'Anti-spam', ''),
(86, 0, 1, 'category', '', ''),
(87, 86, 1, 'title_part1', 'Are you looking for', ''),
(88, 86, 1, 'title_part2', 'jobs?', ''),
(89, 86, 1, 'display_only', 'Only display', ''),
(90, 86, 1, 'jobs_for', 'Jobs for', ''),
(91, 0, 1, 'companies', '', ''),
(92, 91, 1, 'page_title', 'Companies who published here', ''),
(93, 91, 1, 'title', 'Companies that published here', ''),
(94, 91, 1, 'are_you_looking', 'Are you looking for jobs at', ''),
(95, 91, 1, 'meta_part1', 'Job postings by', ''),
(96, 91, 1, 'meta_part2', 'Free jobs ads!', ''),
(97, 91, 1, 'total', 'Total', ''),
(98, 91, 1, 'companies', 'companies', ''),
(99, 91, 1, 'jobs_at', 'Jobs at', ''),
(100, 91, 1, 'jobs_at_undisclosed', 'Jobs at undisclosed companies', ''),
(101, 0, 1, 'contact', '', ''),
(102, 101, 1, 'name_error', 'Please fill in your name', ''),
(103, 101, 1, 'email_error', 'You must fill in your E-mail address', ''),
(104, 101, 1, 'msg_error', 'Please fill in a message', ''),
(105, 101, 1, 'attach_error', 'Attachment size can be 3 MB at maximum', ''),
(106, 101, 1, 'send_error', 'Your message could not be sent. Try again?', ''),
(107, 101, 1, 'name_label', 'Your name', ''),
(108, 101, 1, 'email_label', 'Your e-mail', ''),
(109, 101, 1, 'message_label', 'Message', ''),
(110, 101, 1, 'attachment_label', 'Attachment (optional)', ''),
(111, 101, 1, 'submit', 'Send message', ''),
(112, 0, 1, 'stats', '', ''),
(113, 112, 1, 'last_50_posts', 'Online applications, last 50 displayed', ''),
(114, 112, 1, 'last_50_searches', 'Site searches, last 50 displayed', ''),
(115, 112, 1, 'average', 'avg', ''),
(116, 112, 1, 'maximum', 'max', ''),
(117, 112, 1, 'last_7_days', 'last 7 days', ''),
(118, 112, 1, 'total', 'total', ''),
(119, 0, 1, 'subscriptions', '', ''),
(120, 119, 1, 'all_jobs', 'All jobs', ''),
(121, 119, 1, 'keywords', 'Only notify of job postings containing the following keywords:', ''),
(122, 119, 1, 'manage_title', 'Manage Your Subscriptions', ''),
(123, 119, 1, 'removed_message', 'You have been subsccessfully unsubscribed from all job notifications.', ''),
(124, 119, 1, 'removed_title', 'Done', ''),
(125, 119, 1, 'remove_subscriber', 'Unsubscribe from all', ''),
(126, 119, 1, 'save_settings', 'Confirm & save settings', ''),
(127, 119, 1, 'subscribe_categories_title', 'Subscribe to:', ''),
(128, 119, 1, 'subscribe_email_label', 'Your e-mail', ''),
(129, 119, 1, 'subscribe_message', 'Subscribe to new job announcements', ''),
(130, 119, 1, 'subscribe_title', 'Subscribe to new job announcements', ''),
(131, 119, 1, 'subscribe_submit', 'Subscribe', ''),
(132, 119, 1, 'updated_message', 'Your subscription settings have been updated!', ''),
(133, 0, 1, 'sitemap', '', ''),
(134, 133, 1, 'title', 'Sitemap', ''),
(135, 133, 1, 'jobs', 'Jobs for', ''),
(136, 133, 1, 'use', 'Use it', ''),
(137, 133, 1, 'more', 'Find out more', ''),
(138, 0, 1, 'notfound', '', ''),
(139, 138, 1, 'message', 'We''re sorry, but the page you were looking for could not be found.', ''),
(140, 138, 1, 'back', 'Go back to category', ''),
(141, 0, 1, 'homepage', '', ''),
(142, 141, 1, 'spotlight_jobs', 'Spotlight Jobs', ''),
(143, 141, 1, 'recent_jobs', 'Most recent job offers', ''),
(144, 141, 1, 'popular_jobs', 'Most applied to IT jobs', ''),
(145, 141, 1, 'at', 'at', ''),
(146, 141, 1, 'in', 'in', ''),
(147, 141, 1, 'applicants', 'applicants', ''),
(148, 141, 1, 'applicant', 'applicant', ''),
(149, 141, 1, 'no_jobs', 'No jobs, yet', ''),
(150, 141, 1, 'sidebar_totaljobs', 'total jobs', ''),
(151, 141, 1, 'sidebar_for', 'for', ''),
(152, 141, 1, 'view_all_jobs', 'View all &raquo;', ''),
(153, 0, 1, 'recommend', '', ''),
(154, 153, 1, 'title', 'Recommend to a friend', ''),
(155, 153, 1, 'friend_email_label', 'Friend''s e-mail', ''),
(156, 153, 1, 'your_email_label', 'Your e-mail', ''),
(157, 153, 1, 'submit', 'Send', ''),
(158, 0, 1, 'publish', '', ''),
(159, 158, 1, 'step1', 'Step 1: Write', ''),
(160, 158, 1, 'step2', 'Step 2: Verify', ''),
(161, 158, 1, 'step3', 'Step 3: Confirm', ''),
(162, 158, 1, 'form_error', 'Please revise the form...', ''),
(163, 158, 1, 'job_details', 'Job details', ''),
(164, 158, 1, 'title_label', 'Title', ''),
(165, 158, 1, 'title_info', 'e.g. ''PHP Developer'', ''UI designer''', ''),
(166, 158, 1, 'summary_label', 'Summary', ''),
(167, 158, 1, 'summary_info', 'optional, might be used in lists, search results etc', ''),
(168, 158, 1, 'location_label', 'Location', ''),
(169, 158, 1, 'other', 'other', ''),
(170, 158, 1, 'where', 'where ?', ''),
(171, 158, 1, 'where_info', 'e.g. ''London, UK''', ''),
(172, 158, 1, 'description_label', 'Description', ''),
(173, 158, 1, 'result', 'Final result', ''),
(174, 158, 1, 'company', 'Hiring company or person', ''),
(175, 158, 1, 'name_label', 'Name', ''),
(176, 158, 1, 'website_label', 'Website', ''),
(177, 158, 1, 'websiter_info', 'e.g. ''www.google.com''', ''),
(178, 158, 1, 'email_label', 'E-mail', ''),
(179, 158, 1, 'email_info1', 'not published', ''),
(180, 158, 1, 'email_info2', 'Online applications will be sent to this address.', ''),
(181, 158, 1, 'step1_submit', 'Step 2: Verify ad', ''),
(182, 158, 1, 'step2_info', 'If you changed your mind, you may', ''),
(183, 158, 1, 'step2_cancel', 'cancel posting this ad', ''),
(184, 158, 1, 'save', 'Save changes', ''),
(185, 158, 1, 'publish', 'Publish this ad', ''),
(186, 158, 1, 'edit', 'Edit it', ''),
(187, 158, 1, 'edit_success', 'Your job ad was edited successfully', ''),
(188, 158, 1, 'view', 'View the new job ad', ''),
(189, 158, 1, 'options_title', 'Edit or deactivate your ad', ''),
(190, 158, 1, 'options_info', 'If you need to edit or deactivate this ad, use the following links', ''),
(191, 158, 1, 'deactivate', 'Deactivate ad', ''),
(192, 158, 1, 'success_message', 'Your job was posted, but since this is the first time you post with this e-mail address, we need to manually verify it.<br />Thank you for your patience, as the ad should be published ASAP. We''ll send you an e-mail when that happens. <br /><br />From now on, every ad you post with this e-mail address will instantly be published.<br />', ''),
(193, 158, 1, 'congratulations', 'Congratulations, your job ad was published', ''),
(194, 158, 1, 'location_pick_from_list', 'Pick one from the list', ''),
(195, 158, 1, 'apply_online', '<strong>Allow Online Applications</strong> (If you are unchecking it, then add a description on how to apply online above)', ''),
(196, 0, 1, 'manage', '', ''),
(197, 196, 1, 'html_title', 'Online Job Manager', ''),
(198, 196, 1, 'manage_jobs', 'Online Job Manager', ''),
(199, 196, 1, 'error', 'Error', ''),
(200, 196, 1, 'invalid_auth', 'You don''t have any active jobs. If you think this is wrong, please check the email sent to you when you posted a job.', ''),
(201, 196, 1, 'new_job_title', 'Post a new job', ''),
(202, 196, 1, 'view_applicants', 'View applicants', ''),
(203, 196, 1, 'view_job_applicants', 'View job applicants', ''),
(204, 196, 1, 'edit', 'Edit', ''),
(205, 196, 1, 'edit_job', 'Edit job', ''),
(206, 196, 1, 'deactivate', 'Deactivate', ''),
(207, 196, 1, 'deactivate_job', 'Deactivate job', ''),
(208, 0, 1, 'applications', '', ''),
(209, 208, 1, 'title', 'Job applicants', ''),
(210, 208, 1, 'name', 'Name', ''),
(211, 208, 1, 'email', 'E-mail', ''),
(212, 208, 1, 'date', 'Date', ''),
(213, 208, 1, 'cv', 'Resume', ''),
(214, 208, 1, 'download', 'Download', ''),
(215, 208, 1, 'download_cv', 'Download resume', ''),
(216, 208, 1, 'no_applicants', 'No job applicants yet.', ''),
(217, 0, 1, 'rss', '', ''),
(218, 217, 1, 'title', 'RSS', ''),
(219, 217, 1, 'intro', 'Choose one of the following feeds:', ''),
(220, 217, 1, 'all_categories', 'Feed for all job categories', ''),
(221, 217, 1, 'for', 'Feed for', ''),
(222, 0, 1, 'js', '', ''),
(223, 222, 1, 'location_pick_from_list', 'Pick one from the list', ''),
(224, 222, 1, 'location_other', 'other', ''),
(225, 222, 1, 'send_to_friend_successful', 'Your message was sent. Let''s hope it doesn''t get marked as spam!', ''),
(226, 222, 1, 'send_to_friend_unsuccessful', 'Your message could not be sent. Did you enter both addresses?', ''),
(227, 222, 1, 'report_spam_successful', 'Thank you, your vote was registered and is highly appreciated!', ''),
(228, 222, 1, 'report_spam_unsuccessful', 'Thank you for your intention, but your vote could not be registered.', ''),
(229, 222, 1, 'delete_job_confirmation_question', 'Are you sure you want to delete this post?', ''),
(230, 222, 1, 'subscribe_successful', 'Thank you! You should receive an e-mail shortly. Please follow instructions in that e-mail to confirm your subscription.', ''),
(231, 222, 1, 'subscribe_unsuccessful', 'We are sorry, but something went wrong and your subscription request was not processed.', ''),
(232, 0, 1, 'jobscity', '', ''),
(233, 232, 1, 'page_title', 'Overview of cities', ''),
(234, 232, 1, 'title', 'Cities with jobs available', ''),
(235, 232, 1, 'total', 'Total', ''),
(236, 232, 1, 'cities', 'cities', ''),
(237, 232, 1, 'jobs_at', 'Jobs in', ''),
(238, 232, 1, 'jobs_in', 'Jobs in', ''),
(239, 232, 1, 'no_jobs_in', 'The are currently no jobs in', ''),
(240, 232, 1, 'sidebar_jobs_in', 'in', ''),
(241, 232, 1, 'other_cities', 'Other cities', ''),
(242, 232, 1, 'jobs', 'jobs', ''),
(243, 232, 1, 'jobs_in_other_cities', 'Jobs in other cities', ''),
(244, 232, 1, 'no_jobs_in_other_cities', 'The are currently no available jobs.', ''),
(245, 0, 1, 'email_SendToFriend', '', ''),
(246, 245, 1, 'subject', 'I''m recommending you a job ad', ''),
(247, 245, 1, 'message', '-- \nYou''ve received this e-mail from {YOUR_EMAIL}', 'textarea'),
(248, 0, 1, 'email_ApplyOnline', '', ''),
(249, 248, 1, 'subject', '[ {SITE_NAME} ] I wish to apply for {JOB_TITLE}', ''),
(250, 248, 1, 'message', '-- \nThis e-mail is an application sent from {JOB_URL}', 'textarea'),
(251, 0, 1, 'email_PublishToAdmin_firstPost', '', ''),
(252, 251, 1, 'subject', '[ {SITE_NAME} ] New job: {JOB_TITLE}', ''),
(253, 251, 1, 'message', 'Activate ad {JOB_ACTIVATE_URL}\n\n			\n		\n			\n{JOB_URL}\n\n {JOB_TITLE} at {JOB_COMPANY}\n\n {JOB_DESCRIPTION}\n\n URL: {JOB_URL}\n\n---\n Published by: {JOB_POSTER_EMAIL}\n\n---\n Edit: {JOB_EDIT_URL}\n\n Deactivate: {JOB_DEACTIVATE_URL}\n\n View job applications: {JOB_APPLICANTS_URL}\n\n\n---\n IP: {JOB_POSTER_IP}\n\n Date: {JOB_POST_DATE}', 'textarea'),
(254, 0, 1, 'email_PublishToAdmin', '', ''),
(255, 254, 1, 'subject', '[ {SITE_NAME} ] New job: {JOB_TITLE}', ''),
(256, 254, 1, 'message', '{JOB_URL}\n\n {JOB_TITLE} at {JOB_COMPANY}\n\n {JOB_DESCRIPTION}\n\n URL: {JOB_URL}\n\n---\n Published by: {JOB_POSTER_EMAIL}\n\n---\n Edit: {JOB_EDIT_URL}\n\n Deactivate: {JOB_DEACTIVATE_URL}\n\n View job applications: {JOB_APPLICANTS_URL}\n\n\n---\n IP: {JOB_POSTER_IP}\n\n Date: {JOB_POST_DATE}', 'textarea'),
(257, 0, 1, 'email_PublishPendingToUser', '', ''),
(258, 257, 1, 'subject', 'Your ad on {SITE_NAME}', ''),
(259, 257, 1, 'message', 'Hello! :)\n\n\nWe apologize for the inconvenience, but since this is the first time you post with this e-mail address, we need to manually verify it.\n\nThank you for your patience, as the ad should be published ASAP. We''ll send you an e-mail when that happens!\n\n\nFrom now on, every ad you post with this e-mail address will instantly be published.\n\n\n-- \nThank you for using our service!\n\nThe Team', 'textarea'),
(260, 0, 1, 'email_PublishToUser', '', ''),
(261, 260, 1, 'subject', 'Your ad on {SITE_NAME} was published', ''),
(262, 260, 1, 'message', 'Hello! :)\n\n\nYour ad was published and is available at {JOB_URL}\n\n\n---\nEdit it: {JOB_EDIT_URL}\n\nDeactivate it: {JOB_DEACTIVATE_URL}\n\nManage all jobs: {JOB_MANAGE_URL}\n\nView job applications: {JOB_APPLICANTS_URL}\n\n\n-- \nThank you for using our service!\n\n The {SITE_NAME} Team', 'textarea'),
(263, 0, 1, 'email_ReportSpam', '', ''),
(264, 263, 1, 'subject', '[SPAM on {SITE_NAME}] {JOB_TITLE}', ''),
(265, 263, 1, 'message', 'Following ad was reported as false/spam: \n---\n\n\n{JOB_URL}\n\n\n {JOB_TITLE} at {JOB_COMPANY}\n\n\n {JOB_DESCRIPTION}\n\n\n---\n Published by: {JOB_POSTER_EMAIL}\n\n---\nEdit: {JOB_EDIT_URL}\n\n Deactivate: {JOB_DEACTIVATE_URL}\n\n---\nIP: {JOB_POSTER_IP}\n\n Date: {JOB_POST_DATE}', 'textarea'),
(266, 0, 1, 'email_Contact', '', ''),
(267, 266, 1, 'subject', '[{SITE_NAME}] contact', ''),
(268, 266, 1, 'message', '---\n Sent by: {SENDER_NAME} <{SENDER_EMAIL}>\n\n IP: {SENDER_IP}\n\n Date: {SEND_DATE}', 'textarea'),
(269, 0, 1, 'email_SubscriptionJobPosted', '', ''),
(270, 269, 1, 'subject', '[ {SITE_NAME} ] New job ad has been posted', ''),
(271, 269, 1, 'message', 'Hello!\n\n\nA new job ad has been posted on {SITE_NAME} website:\n\n\n{JOB_TITLE}\n\n{JOB_SUMMARY}\n\n\nTo view the ad or apply for this job, please visit the following page:\n\n{JOB_URL}\n\n\nYou are receiving these notifications because you have subscribed to them. If you want to adjust your subscription preferences, or unsubscribe altogether, you can visit the following page:\n\n\n{MANAGE_URL}\n\n\n-- \n\nThank you for using our service!\n\n The {SITE_NAME} Team', 'textarea'),
(272, 0, 1, 'email_SubscriptionPleaseConfirm', '', ''),
(273, 272, 1, 'subject', '[ {SITE_NAME} ] Please confirm your subscription', ''),
(274, 272, 1, 'message', 'Hello!\n\n\nSomeone tried to subscribe you to new job announcements from the {SITE_NAME} website ({SITE_URL}).\n\n\nTo validate this subscription, or adjust the subscription settings, please visit the following page:\n\n{MANAGE_URL}\n\n\nIf you did not request this, you can either ignore this message, or still visit the page and click the Unsubscribe All button to remove yourself from our database.\n\n\nFor your information, the person who initiated this change used the following IP address: {SENDER_IP}.\n\n\n-- \n\nThank you for using our service!\n\n The {SITE_NAME} Team', 'textarea'),
(275, 0, 1, 'email_SubscriptionRemoved', '', ''),
(276, 275, 1, 'subject', '[ {SITE_NAME} ] You have been unsubscribed', ''),
(277, 275, 1, 'message', 'Hello!\n\n\nYou have been unsubscribed from all job announcements from the {SITE_NAME} website ({SITE_URL}).\n\n\nYou can subscribe again anytime.\n\n\nFor your information, the person who initiated this change used the following IP address: {SENDER_IP}.\n\n\n-- \n\nThank you for using our service!\n\n The {SITE_NAME} Team', 'textarea'),
(278, 0, 1, 'email_SubscriptionUpdated', '', ''),
(279, 278, 1, 'subject', '[ {SITE_NAME} ] Your subscription settings have been updated', ''),
(280, 278, 1, 'message', 'Hello!\n\n\nThe preferences of your subscription to new job announcements from the {SITE_NAME} website ({SITE_URL}) have been updated.\n\n\nIf you would ever want to adjust your subscription preferences again, or unsubscribe from all announcements altogether, you can visit the following page:\n{MANAGE_URL}\n\n\nFor your information, the person who initiated this change uses the following IP address: {SENDER_IP}.\n\n\n-- \n\nThank you for using our service!\n\n The {SITE_NAME} Team', 'textarea');

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `title` varchar(100) DEFAULT '',
  `summary` varchar(255) DEFAULT NULL,
  `description` text,
  `company` varchar(150) DEFAULT '',
  `city_id` int(11) DEFAULT NULL,
  `url` varchar(150) DEFAULT NULL,
  `apply` varchar(200) DEFAULT '',
  `created_on` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_temp` tinyint(4) NOT NULL,
  `is_active` tinyint(4) NOT NULL,
  `views_count` int(11) NOT NULL,
  `auth` varchar(32) NOT NULL,
  `outside_location` varchar(150) NOT NULL,
  `poster_email` varchar(100) NOT NULL,
  `apply_online` tinyint(4) NOT NULL,
  `spotlight` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_id` (`type_id`),
  KEY `category_id` (`category_id`),
  KEY `city_id` (`city_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `jobs`
--

INSERT INTO `jobs` VALUES
(1, 1, 1, 'web developer', NULL, 'We\\''re a startup searching for a cool web developer that masters following technologies:\r\n* php, mysql\r\n* javascript, dom, ajax\r\n* html, css\r\n\r\nPerson should also have a good sense of user behavior.\r\n\r\nExcellent payment! ;)', 'Foo Inc.', NULL, 'http://www.fooinc.com', '', '2014-04-14 07:48:26', 0, 1, 11, 'f1acd80152446f4cf8a0bb8242398be7', 'sss', 'jobs@fooinc.com', 1, 1),
(2, 3, 2, 'Illustrator/Photoshop expert', NULL, 'Could you redraw in Illustrator da Vinci\\''s Gioconda, blindfolded?\r\nLet us know! :)', 'UnrealExpectations', NULL, 'http://unrealexpectations.com', '', '2014-04-14 07:48:26', 0, 1, 6, '6ebcfde637d98a9738c024c6074e945d', '', 'jobs@unrealexpectations.com', 1, 0),
(4, 1, 1, 'web developer 3', NULL, 'We\\''re a startup searching for a cool web developer that masters following technologies:\r\n* php, mysql\r\n* javascript, dom, ajax\r\n* html, css\r\n\r\nPerson should also have a good sense of user behavior.\r\n\r\nExcellent payment! ;)', 'Foo Inc.', NULL, 'http://www.fooinc.com', '', '2014-04-14 07:48:26', 0, 1, 8, 'f1acd80152446f4cf8a0bb8242398be7', 'London, UK', 'jobs@fooinc.com', 1, 1),
(5, 1, 1, 'web developer 2', NULL, 'We\\''re a startup searching for a cool web developer that masters following technologies:\r\n* php, mysql\r\n* javascript, dom, ajax\r\n* html, css\r\n\r\nPerson should also have a good sense of user behavior.\r\n\r\nExcellent payment! ;)', 'Foo Inc.', NULL, 'http://www.fooinc.com', '', '2014-04-14 07:48:26', 0, 1, 6, 'f1acd80152446f4cf8a0bb8242398be7', 'London, UK', 'jobs@fooinc.com', 1, 0),
(11, 1, 3, 'nice developer needed', NULL, 'asdfsd', 'temp name', 1, 'http://google.com', '', '2014-04-14 07:48:26', 0, 1, 2, '2e3f1e857af3a4e191f453d747fbf212', '', 'jobs@fooinc.com', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `job_applications`
--

CREATE TABLE `job_applications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` int(10) unsigned NOT NULL,
  `name` varchar(150) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `cv_path` varchar(255) DEFAULT NULL,
  `message` text,
  `created_on` datetime NOT NULL,
  `ip` varchar(15) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `links`
--

CREATE TABLE `links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `parent` int(11) NOT NULL,
  `link_order` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `links`
--

INSERT INTO `links` VALUES
(1, 'widgets', 'Site widget', 'Would you like to display our latest jobs on your site?', 14, 1),
(2, 'about', 'About Us', 'More information about us.', 14, 2),
(3, 'contact', 'Contact', 'Don''t hesitate to contact us!', 14, 3),
(4, 'post', 'Post a new job', 'Post a new job for free!', 17, 4),
(5, 'widgets', 'Site widget', 'Would you like to display our latest jobs on your site?', 17, 5),
(6, 'rss', 'RSS Feeds', 'An overview of all our available RSS Feeds.', 17, 6),
(7, 'about', 'About Us', 'More information about us.', 18, 7),
(8, 'contact', 'Contact', 'Don''t hesitate to contact us!', 18, 8),
(9, 'companies', 'Companies', 'An overview of all available companies.', 19, 9),
(10, 'cities', 'Cities', 'An overview of all available cities.', 19, 10),
(11, 'sitemap', 'Sitemap', 'Sitemap.', 19, 11),
(14, 'primary', 'Primary Menu', 'The primary menu for your Jobberbase theme. By default this menu is located at the top', 0, 0),
(15, 'secondary', 'Secondary Menu', 'The secondary menu for your Jobberbase theme. By default this menu is located in the sidebar', 0, 1),
(16, 'footer', 'Footer Menu', 'The footer menu for your Jobberbase theme', 0, 2),
(17, '', 'Use:', '', 16, 0),
(18, '', 'Find out more:', '', 16, 1),
(19, '', 'Misc:', '', 16, 2);

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `page_title` varchar(255) NOT NULL,
  `keywords` text NOT NULL,
  `description` text NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `has_form` enum('0','1') NOT NULL,
  `accepts_files` enum('0','1') NOT NULL,
  `form_message` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` VALUES
(1, 'about', 'About Us', '', '', 'About Us', '<h4>Hello!</h4>\r\n<p>This job board is an open source implementation of <a href="http://www.jobber.ro/">www.jobber.ro</a>.</p>\r\n<p>Don''t hesitate to&nbsp;contact us!</p>', '0', '0', ''),
(2, 'contact', 'Contact Us', '', '', 'We really appreciate feedback!', '<p>E-mail us at <strong>hello [at] domain [dot] com</strong> or use the form below:</p>', '1', '0', '<p>Thank you for your message! :)</p>');

-- --------------------------------------------------------

--
-- Table structure for table `searches`
--

CREATE TABLE `searches` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `keywords` varchar(100) NOT NULL,
  `created_on` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT NULL,
  `name` varchar(64) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  `data_type` varchar(255) DEFAULT NULL,
  `input_type` varchar(255) DEFAULT NULL,
  `input_options` text,
  `validation` text,
  `value` longtext,
  `extradata` blob,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=55 ;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` VALUES
(1, 1, 'site_name', 'Site name', 'The name of your JobBoard, used in various templates.', NULL, NULL, NULL, 'not_empty', '[[site_name]]', NULL, 1),
(2, 5, 'admin_email', 'Admin Email', 'The email companies will receive mail from.', NULL, NULL, NULL, 'not_empty|is_email', '[[admin_email]]', NULL, 1),
(3, 5, 'notify_email', 'Notify Email', 'The email for receiving new job postings.', NULL, NULL, NULL, 'not_empty|is_email', '[[admin_email]]', NULL, 2),
(4, 6, 'theme', 'Theme', 'Pick the theme to use for the frontend.', NULL, 'available_themes', NULL, 'not_empty', 'default', NULL, 4),
(5, 7, 'html_title', 'HTML Title', 'The HTML title for the homepage.', NULL, NULL, NULL, NULL, NULL, NULL, 1),
(6, 7, 'meta_keywords', 'Site keywords', 'Meta Keywords. Useful for Search Engine Optimization (separate by comma).', NULL, NULL, NULL, NULL, NULL, NULL, 2),
(7, 7, 'meta_description', 'Site description', 'Meta Description Tag. Useful for Search Engine Optimization.', NULL, 'text_area', NULL, NULL, NULL, NULL, 3),
(8, 1, 'max_cv_size', 'Max CV filesize', 'The maximum filesize for uploaded CV''s in bytes (Update accordingly in translations.ini)', NULL, NULL, NULL, 'not_empty|is_number', '3145728', NULL, 8),
(9, 1, 'file_upload_dir', 'Upload Directory', 'Upload directory to temporarily save CV''s. Must be writable.', NULL, NULL, NULL, 'not_empty', 'uploads/', NULL, 9),
(10, 4, 'apply_delay', 'Apply delay', 'The number of minutes that must pass between applications from the same IP address', NULL, NULL, NULL, 'not_empty|is_number', '0', NULL, 10),
(11, 1, 'old_job_notify', 'Old Job Notify', 'No. of days after which a job should be reported as old. Use 0 to disable this functionality.', 'integer', NULL, NULL, 'not_empty', '40', NULL, 11),
(12, 6, 'date_format', 'Date format', 'The format in which dates are displayed. %d = day, %m = month, %Y = 4 digit year. Follow <a href="http://dev.mysql.com/doc/refman/5.0/en/date-and-time-functions.html#function_date-format" target="_blank">this link</a> for more formatting options.', NULL, NULL, NULL, 'not_empty', '%d-%m-%Y', NULL, 12),
(13, 6, 'date_time_format', 'Date / Time format', 'The format in which times are displayed. %d = day, %m = month, %Y = 4 digit year, %H = 24-hour and %i = minute. Follow <a href="http://dev.mysql.com/doc/refman/5.0/en/date-and-time-functions.html#function_date-format" target="_blank">this link</a> for more formatting options.', NULL, NULL, NULL, 'not_empty', '%d-%m-%Y %H:%i', NULL, 13),
(14, 6, 'sidebar_show_what', 'Sidebar - show', 'Either cities or categories can be shown in the sidebar', NULL, 'select', 'categories|cities', 'not_empty|is_alpha', 'categories', NULL, 14),
(15, 6, 'sidebar_only_cities_with_at_least_number_of_jobs', 'Sidebar - only cities with at least X jobs', 'If the sidebar is configured to show cities, then only show cities that have at least the specified number of jobs available.', 'integer', NULL, NULL, 'non_empty', '1', NULL, 15),
(16, 1, 'enable_new_jobs', 'Enable Job Posting', 'By turning this off, the only way to add jobs is through the admin-panel.', 'boolean', 'radiobutton', 'no|yes', NULL, '1', NULL, 16),
(17, 2, 'jobs_per_page', 'Jobs per page', 'The amount of jobs per page, before pagination is called.', 'integer', NULL, NULL, 'not_empty', '50', NULL, 1),
(18, 2, 'jobs_per_search', 'Jobs per search', 'The amount of jobs per page when searching.', 'integer', NULL, NULL, 'not_empty', '25', NULL, 2),
(19, 2, 'spotlight_jobs', 'Spotlight Jobs #', 'Amount of Spotlight Jobs to display on the front page.', 'integer', NULL, NULL, 'not_empty', '3', NULL, 3),
(20, 2, 'latest_jobs', 'Latest Jobs #', 'Amount of latest jobs to show on the front page.', 'integer', NULL, NULL, 'not_empty', '7', NULL, 4),
(21, 2, 'most_applied_jobs', 'Most Applied to #', 'Amount of most-applied-to jobs to show on the front page.', 'integer', NULL, NULL, 'not_empty', '7', NULL, 5),
(22, 2, 'search_method', 'Search Method', 'Choose which search method to use. ''Alternate'' checks every keyword to appear in either the title, description or cityname.', NULL, 'radiobutton', 'classic|alternate', NULL, 'classic', NULL, 6),
(23, 3, 'url_cities', 'Cities Cloud', 'The URL for the City Cloud page.', NULL, NULL, NULL, 'not_empty|is_url_string', 'cities', NULL, 1),
(24, 3, 'url_companies', 'Companies Cloud', 'The URL for the Company Cloud page.', NULL, NULL, NULL, 'not_empty|is_url_string', 'companies', NULL, 2),
(25, 3, 'url_job', 'Job Details', 'The URL for the Job Details page.', NULL, NULL, NULL, 'not_empty|is_url_string', 'job', NULL, 3),
(26, 3, 'url_jobs', 'Jobs per Category', 'The URL for the Jobs per Category pages.', NULL, NULL, NULL, 'not_empty|is_url_string', 'jobs', NULL, 4),
(27, 3, 'url_jobs_at_company', 'Jobs per Company', 'The URL for the Jobs per Company pages.', NULL, NULL, NULL, 'not_empty|is_url_string', 'jobs-at', NULL, 5),
(28, 3, 'url_jobs_in_city', 'Jobs per City', 'The URL for the Jobs per City pages.', NULL, NULL, NULL, 'not_empty|is_url_string', 'jobs-in', NULL, 6),
(29, 4, 'enable_recaptcha', 'Enable ReCaptcha', 'Before enabling ReCaptcha, make sure to add your private and public key.', 'boolean', 'radiobutton', 'no|yes', NULL, '0', NULL, 1),
(30, 4, 'captcha_public_key', 'Captcha Public Key', 'You can register these keys for free at recaptcha.net.', NULL, NULL, NULL, NULL, 'PUBLIC_KEY', NULL, 2),
(31, 4, 'captcha_private_key', 'Captcha Private Key', 'You can register these keys for free at recaptcha.net.', NULL, NULL, NULL, NULL, 'PRIVATE_KEY', NULL, 3),
(32, 5, 'mailer_mailer', 'Mailer', 'Send mails with PHP''s mail() function or through SMTP', NULL, 'select', 'mail|smtp', 'not_empty', 'mail', NULL, 1),
(33, 5, 'mailer_encoding', 'Mail encoding', 'The mail''s encoding (default is utf-8, change only if it is not working correctly)', NULL, NULL, NULL, 'not_empty', 'utf-8', NULL, 2),
(34, 5, 'mailer_smtp_host', 'SMTP host name', 'Host name (for example, smtp.example.com)', NULL, NULL, NULL, NULL, NULL, NULL, 3),
(35, 5, 'mailer_smtp_port', 'SMTP port', 'Port (default is 25, change only if you know what you are doing)', 'integer', NULL, NULL, 'not_empty', '25', NULL, 4),
(36, 5, 'mailer_smtp_requires_authentication', 'SMTP authentication', 'Is authentication required for SMTP?', 'boolean', 'radiobutton', 'no|yes', NULL, '0', NULL, 5),
(37, 5, 'mailer_smtp_secure_connection_prefix', 'SMTP secure connection prefix', 'SMTP secure connection prefix. Leave empty if not specified for your host.', NULL, 'select', '|ssl|tls', NULL, '', NULL, 6),
(38, 5, 'mailer_smtp_username', 'SMTP user name', 'User name (for example, user@example.com)', NULL, NULL, NULL, NULL, NULL, NULL, 7),
(39, 5, 'mailer_smtp_password', 'SMTP password', 'Password', NULL, NULL, NULL, NULL, NULL, NULL, 8),
(40, 4, 'report_post_after', 'Report Post Delay', 'No of Minutes after which a user is allowed to report same post after the previous report.', NULL, NULL, NULL, 'not_empty|is_number', '10', NULL, 8),
(41, 4, 'post_notify_on', 'When to send Mail?', 'Send mail only after this number of reports on a post.', 'integer', NULL, NULL, 'not_empty', '2', NULL, 9),
(42, 4, 'enable_captcha_on_post_page', 'Enable ReCaptcha on post page', 'Enable spam protection on the post a job page.', 'boolean', 'radiobutton', 'no|yes', NULL, '0', NULL, 4),
(43, 4, 'enable_captcha_on_apply_page', 'Enable ReCaptcha on apply page', 'Enable spam protection on the apply to a job page.', 'boolean', 'radiobutton', 'no|yes', NULL, '1', NULL, 5),
(44, 4, 'enable_captcha_on_contact_page', 'Enable ReCaptcha on contact page', 'Enable spam protection on the contact page.', 'boolean', 'radiobutton', 'no|yes', NULL, '0', NULL, 6),
(45, 1, 'enable_new_post_moderation', 'Enable Job Moderation', 'If enabled, the administrator must always activate the very first job posted by a hiring person/company. From there on, every job posted with the same email address will be automatically activated.', 'boolean', 'radiobutton', 'no|yes', NULL, '1', NULL, 17),
(46, 1, 'timezone', 'Timezone', 'Please select your timezone', NULL, 'timezones', NULL, 'not_empty', 'Europe/London', '', 5),
(47, 6, 'site_logo', 'Site logo', 'Upload your logo', NULL, 'file', NULL, NULL, '', 'PNG\r\n\Z\n\0\0\0\rIHDR\0\0w\0\0\0R\0\0\0d\0\0PLTE\0\0\0lllDyYTKGDt߶''''$֌谮T\Z&TRQ}yv¼:75sTPjJDmizucك}d`6õeb]!Eͽ?=>0-,궣rl{v͂ebspm~[WT|b\\sZT膁}%ɛIDBd۬mQKݼB:7PGEkdbƽ~0++gEA5|so<20WTRƴb\\Z(#"yt꥓jeļuZW\0\0丵\nKJI)(''tlj{\\X|ykKIC?=!\ZqRMuq}||lhekRR989rqqPLJ䶲dccإ̑庶ŀb^kkRRJ333̽|{hWTᜅΨZZ[{x{kcss! !!zts[JGsJJCCBJ::¯7''&B31כ{˴\rƿ彺7\0\0\04tRNS\0KW"e\0\04IDATx흋sGG(J"cY5Jc\r+1Z^(vkI=uxZq%`;8A	b\r:ו/JquJn{zFWP.\ZM?_}=B\0Hpj=IbR`^Ɔeْ$qaq{bBlYRsK]G\ZpOt,h\\=3[X͂h{8[eN%.Z̓> 1w{M Y[E0pNJݾe]GBg`bѨ%+]7448غLh\0ѡw}ؾ֊ºBȴ5''d8xݡ{	_j91u.~0&,H1s#%ϙrMhbݔIZRqm?DV!?N]ln;:vAa,>-(_\nKVʙä\Z1¯dZw4J''$f430Сv<T;tp{||XDri7Yl)kaShI\\v2%$̹mfXJzYc\\;_m\Z3,/7q om]l>8PkZ	?әԚxRlߤ̹SF''vF5/t5CC{?mP7+o[\\>=\rw}\nzVxj:b*clOP9L:ݶ(7ˬk''s+	8?lmQkDcmytjN]<w.\r%U3[I,m.Q3i7!kj J|,2}m;\0oSte2(PB$Z8pUS/?H$\\J:ƥ[Q5޴k{?0ނLw@L|>P[}D+3bZIxZ0+vMȥψ^>rpd)GI#W\n/fĽ9[;UWW@Ga5oZ۾ǵذ{&T7KzLgqE$tٸ^+9".ad[kׯ==ݱOuwwvn''K&X*ahM닀c^rGr\ZC;8!Mōw.j\n''Í"d75^rFA({bff棏Puq`o;˝5e{1Z=Z\0-"[a[\0M.MUpu*@E>On=*37HG";?O6Fn1_\r8>ɂ4:%A3.1@Dpb:#Aq_utxX&P7/rϐ?\\)Vǌz?;=1&X7.18\\^nN(y\r꭛6,9_ӵt9M`UPGTN\0}Ɩ53,F0ǝK`n&fGUK/1xTbage>gTpptsdo]oe"\rw~]͏*W܂:܋VuL;zqFŽ;wpSχ;P	Ю#6xjL\0;~m_''\0yv&\rWδXT:tndW\\\Zh캵[X\r?ͲoAVa\\Xm(cʝ>YY7\0dhڵK2\Zֿ:2~R~ʽt\\~v3i<Ϊ-;aKU-5w}8r@''{`Ed]IVo2ำK/oIl~/֒exj&VKRqۻ2<~j9܄''\0_6dMr\r9E/f}ub*(q}l,B{9F@qeY4>bXuN[ۮ(o~g*3;~uX.6b9?gImGrWw\0c7۵Je-ۅ{g6=T£1!.`W:c<vtR(NsJ́1~Yz̚:?E瞼;/M+bvt0}PEo )&1~a|#zIU92>TI	VK\ntX=\0}''NW\0~iJ,G\nŏ|[MOp,HĴԬv즓j%ȏdyg''	\\Rrs#zkS8_7lvu*/7=A\\ѤS/̍NpJJ`+k%b?>PG{\0	yk9ne|מh)ˍS3qjr\Za9lE?O\0޸Mz4U[gKjăOiF"ABk׿f~''+O&\Z	L}[?+Nnp<_J\0Nr)aVF-oyA4m\nk#k19''T ._@GOw\0oaFzLHΥho4sړH,-b1]e :1KxEkH	H`콲wj{ݞ?P!}(("q5AUwh_uj	\\Czxa''(\Z5%nn`q9l"ʟ.Q+1EwbGmy\nrHbp睛\r!r}m{+**fn=].{$iϼT6|r2Onvgxs=W&tԧG|YQ&o\0p0:g:''/J̔e]Yn	eUt<Z^4~bQAxY@k\nc<Ao8pQbN]0-s\Z4Ą&\Z;S/	"e_eeUEӟqpWXl\0C-d\\Q[<9GaQZ w0/;uggMSोϮA*p7DVO8Pa	^wğ@_Cղ<֐Srk~uW\nbp9zee~lz|3Dس~jkG7$Bdfxqs%k!%E%te*bA.ӑfܝm <&Ꝫ,G#8(5\\$QM,4Ng|)sQ4$DBD4ߣLh6W\Zxaab;B;z6mOi^#Glwidr9gȋ\n:I_¨*7Kd3}V\n#H`]FNzdȗCfRՓpzTɰZQ2n:+1$~[CK]h8$ajCF_EXJM2ںȺ[>\\Sk=u5W=I!(n,DCՒKUVl}+ 1pm\\.sOAeO!\\WρJ<*	+''KaRzU˭IWA<<z!J85ՅӟpwnJz HZCH0r+/29qG(nd3h7P W?/m&gdaϪ(r\\qq%)YGb?7.D!*ܣd%tAv-^ra,UpZ\Z"t0ưxIY+X*3X.Zd\r8pmAtU6لM ;*\\\\==rl|]dRtAȪf*N"qb\\(]w冔;]%Xv\rJ<^]!Qѡ%rZ+h\ZbIG2m	#Gw>j9	VB;]n@5W.Tqt,9idZt#\0q\r幓A5J􂗲ryVOX;^2\0W	%r5XNkAG,`h"iLlulOo5E\Z^f7|{Vn|`=n\\z)[Hr''Q^ 3GsQ<%Ȯ\rerwRo0pw_aS!.G<(L+V6لip\rV''^ܶ闙jߣ(+;jKzXa˰:yp<h%Cx#7jQhd%qXC\\ʺ{Vr\Z2J[73eV[j04-3HAq`ՔE#( %Kkۅ5j+[e&ܯW]9wpo>#oV\ZDќ&?+H֛0>RwuQ8,p+_''`(!Μƃ\rF(*\rYm\r=Gy,c''9UBQB/)$\\e&WPY|DNg;n\nX43\Z&.\nBNh<5:S5m>]uoB8?rژ P;S!)=bW~ p_I"lPy3&5rWK2.C%=$غ$6d(/10	哇_}p֊5k?Wő===\nGgO/f^rqt}&"[9Б!tǋ.rf>	N^/urs$rr#tpiiU"W)''sB{z6όWgҲ㖐/?5nkw\nK}m) 㮘<!_\\+2m\re"TR/CUYl:\\(xccْss}b\r//\n?@}M&[_ww}vmڼpJӑm)wnUa''޸zቲ_w%nKe_}k_%hn^յx{<%\rWOm/k=~㱿?3\0GV~-c~7rwwg迲MI[%pK6ޏu>X64A2oCC9ue|znɸ''n޼y֮]{?o{E":rʒ\0\0\0\0IENDB`', 1),
(50, 7, 'google_analytics_code', 'Google Analytics Code', 'Enter you Google Analytics code here', NULL, NULL, NULL, NULL, '', NULL, 5),
(51, 1, 'keep_uploaded_cvs', 'Keep uploaded CV''s', 'Keep the CV''s that applicants upload. If on, the CV''s can be downloaded from admin area. Otherwise they will be deleted right after sending application emails.', 'boolean', 'radiobutton', 'no|yes', NULL, '0', NULL, 10),
(52, 1, 'home_page_content', 'Home page', 'Pick the page, the content of which you want to be shown on the home page. Leave empty if you only want to show job lists there.', NULL, 'available_pages', NULL, NULL, '', NULL, 6),
(53, 4, 'enable_captcha_on_admin_login_page', 'Enable ReCaptcha on admin login page', 'Protect the admin area with ReCaptcha.', 'boolean', 'radiobutton', 'no|yes', NULL, '0', NULL, 7),
(54, 1, 'subscribe_page_content', 'Subscribe page', 'Pick the page, the content of which you want to be shown on the subscribe page. Leave empty if you only want to show the subscribe form there.', NULL, 'available_pages', NULL, NULL, '', NULL, 7);

-- --------------------------------------------------------

--
-- Table structure for table `settings_categories`
--

CREATE TABLE `settings_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `var_name` varchar(255) NOT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `settings_categories`
--

INSERT INTO `settings_categories` VALUES
(1, 'Main Settings', 'main', 'The main settings for your JobberBase installation. This includes settings such as site name, meta-tags etc.'),
(2, 'Search / Pagination Settings', 'search-and-pagination', 'Settings that change the amount of jobs to display per page and which search method to use.'),
(3, 'URL Rewrite Settings', 'url-rewrite', 'You can easily change the structure of various URLs with these settings.'),
(4, 'Spam / Security Settings', 'anti-spam', 'JobberBase has built-in Spam prevention features which help you to combat spam job posts.'),
(5, 'Mailer Settings', 'mail', 'You can setup the route through which emails are sent (SMTP, for example).'),
(6, 'Look & Feel Settings', 'look-and-feel', 'Change your logo, pick a theme + other UI settings.'),
(7, 'SEO', 'seo', 'Titles, keywords, description, Google Analytics...');

-- --------------------------------------------------------

--
-- Table structure for table `spam_reports`
--

CREATE TABLE `spam_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `the_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip` varchar(15) NOT NULL,
  `job_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `subscribers`
--

CREATE TABLE `subscribers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `auth` varchar(32) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `subscriber_mail_log`
--

CREATE TABLE `subscriber_mail_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `job_id` int(11) NOT NULL,
  `job_title` varchar(100) NOT NULL,
  `job_summary` varchar(255) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions`
--

CREATE TABLE `subscriptions` (
  `subscriber_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `confirmed` tinyint(1) NOT NULL,
  UNIQUE KEY `subscriber_id` (`subscriber_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `types`
--

CREATE TABLE `types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) NOT NULL,
  `var_name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='full-time/freelance' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `types`
--

INSERT INTO `types` VALUES
(1, 'Full-time', 'fulltime'),
(2, 'Part-time', 'parttime'),
(3, 'Freelance', 'freelance');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
