<?php
/* ############################################################ *\
 ----------------------------------------------------------------
@package	jocow community builder.
@copyright	Copyright (C) 2009 jocow.com.  All Rights Reserved.
@license	see http://jocow.com/license
 ----------------------------------------------------------------
\* ############################################################ */

class polls extends story{
	// test1 => select options
	public $list_type = 'ul';
	function __construct() {
		global $nav,$ubase;
		$this->hooks(array('writestory','writestorypost','viewstory'));
		$nav[] = url('polls',t('Poll'));
		parent::story();
		$this->label_title = t('Poll question');
		$this->tags = 1;
		$this->stories_from_cat = t('Lasted polls in this category');
		$this->write_story = t('New poll');	
		$this->allow_vote = $this->who_voted = 0;
		$this->act_write = t('started a poll');
	}
	
	function hook_liststories() {
		c(button(['uri'=>$this->name.'/writestory', 'type'=>'link', 'title'=>$this->write_story, 'icon_name'=>'plus']));
		section_close();
	}

	function hook_writestory($row) {
		$output = '<p>
							'.label(t('Type')).'
								<label><input type="radio" name="stype" value="0" checked /> '.t('Single selection').
								'</label>
								<label><input type="radio" name="stype" value="1" /> '.t('Multiple selection').'</label>
								</p>';
		for($i=1;$i<=10;$i++) {
			$output .= '<p>
			'.label(t('Option').$i).'
			<input type="text" style="width:300px;border-radius:5px" name="opts[]" />
			</p>';
		}
		return $output;
	}
	
	
	function hook_writestorypost(&$story) {
		//get_r('stype');
		foreach($_POST['opts'] as $opt) {
			if (strlen($opt)) {
				$options[] = array('flag'=>$opt,'num'=>0);
			}
		}
		if (count($options) < 2) {
			form_stop('You need to set at least 2 options!');
		}
		$story['text1'] = serialize($options);
		$story['var1'] = $_POST['stype'];
	}
	
	function hook_viewstory($row) {
		global $uhome;
		$opts = unserialize($row['text1']);
		$votes = explode(',',$row['text2']);
		$votes_total = count($votes);
		$output = '<form name="opt" action="'.url($this->name.'/vote').'" class="ajaxform" method="post">';
		$i = 1;
		foreach ($opts as $opt) {
			$votes_num += $opt['num'];
		}
		if (!$votes_num) {
			$votes_num = 1;
		}
		foreach($opts as $key => $opt) {
			$num = ceil($opt['num']/$votes_num*10);
			$pbar = '<img src="'.$uhome.'/modules/polls/poll_l.gif" />';
			for ($i=0; $i<=$num; $i++) {
				$pbar .= '<img src="'.$uhome.'/modules/polls/poll_m.gif" />';
			}
			$pbar .= '<img src="'.$uhome.'/modules/polls/poll_r.gif" /> ';
			if (!$row['var1']) {
				$output .= '<label style="display:block"><input type="radio" name="opts[]" value="'.$key.'" id="opt'.$i.'" /> '.$pbar.htmlspecialchars($opt['flag']).'<span class="sub">('.t('{1} votes',$opt['num']).')</span></label>';
			}
			else {
				$output .= '<label style="display:block;height:30px"><input type="checkbox" name="opts[]" value="'.$key.'" id="opt'.$i.'" /> '.$pbar.htmlspecialchars($opt['flag']).'<span class="sub">('.t('{1} votes',$opt['num']).')</span></label>';
			}
			$i++;
		}
		$output .= '<input type="submit"  value="'.t('Vote').'" />
		<input type="hidden" name="sid" value="'.$row['id'].'" />
		</form>';
		return $output;
	}
	
	function vote() {
		global $client;
		do_auth(2);
		if (!$story = valid_story($_POST['sid'])) {
			return_err('wrong sid');
		}
		$ori_opts = unserialize($story['text1']);
		$uids = explode(',',$story['text2']);
		if (in_array($client['id'],$uids)) {
			return_err(t('You have voted before'));
		}
		//print_r($_POST);exit;
		foreach ($ori_opts as $key=>$ori_opt) {
			if (is_array($_POST['opts']) && in_array($key,$_POST['opts'])) {
				$ori_opts[$key]['num'] = $ori_opts[$key]['num'] + 1;
			}
		}
		$update_story = [
			'id'=>$story['id'],
			'text1' => serialize($ori_opts),
			'text2' => $story['text2'].','.$client['id'],
		];
		sql_update($update_story,tb().'stories');
		form_go('polls/viewstory/'.$story['id']);
	}
	
	function story_form_content2($row = array()) {
		return '<p>'.label(t('Description')).'<textarea name="form_content" class="form-control" >'.htmlspecialchars($row['content']).'</textarea></p>';
	}
	
	function theme_story_footer($row) {
		$votes = explode(',',$row['text2']);
		$output .= '<div class="tab_thing">'.t('{1} votes',(count($votes)-1)).'</div>';
		//$output .= '<div class="tab_thing">'.$this->list_views($row).'</div>';
		//$output .= '<div class="tab_thing">'.$this->list_comments($row).'</div>';
		return $output;
	}


	function ajax_error($msg) {
		echo '<div style="color:red">'.$msg.'</div>';
		echo polls::ajax_form();
		exit;
	}
	
	
}
