
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `jcow142`
--

-- --------------------------------------------------------

--
-- Table structure for table `jcow_accounts`
--

CREATE TABLE `jcow_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fbid` bigint(20) NOT NULL DEFAULT '0',
  `email` varchar(120) NOT NULL DEFAULT '',
  `lastact` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `username` varchar(25) NOT NULL DEFAULT '',
  `fullname` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `level` tinyint(4) NOT NULL DEFAULT '0',
  `points` int(11) NOT NULL DEFAULT '0',
  `avatar` varchar(50) NOT NULL DEFAULT '',
  `signature` text,
  `blurbs` text,
  `profile_permission` tinyint(4) NOT NULL DEFAULT '0',
  `location` varchar(100) NOT NULL DEFAULT '',
  `lastlogin` int(11) NOT NULL DEFAULT '0',
  `ipaddress` varchar(30) NOT NULL DEFAULT '',
  `chpass` varchar(10) NOT NULL DEFAULT '',
  `disabled` tinyint(4) NOT NULL DEFAULT '0',
  `intr` text,
  `gender` tinyint(4) NOT NULL DEFAULT '0',
  `about_me` text,
  `birthyear` int(4) NOT NULL DEFAULT '0',
  `birthmonth` tinyint(2) NOT NULL DEFAULT '0',
  `birthday` tinyint(2) NOT NULL DEFAULT '0',
  `hide_age` tinyint(1) NOT NULL DEFAULT '0',
  `reg_code` varchar(8) NOT NULL DEFAULT '',
  `forum_posts` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `roles` varchar(255) NOT NULL DEFAULT '',
  `country` varchar(50) NOT NULL DEFAULT '',
  `locale` varchar(50) NOT NULL DEFAULT '',
  `state` varchar(50) NOT NULL DEFAULT '',
  `jcowsess` char(12) NOT NULL DEFAULT '',
  `token` varchar(32) NOT NULL DEFAULT '',
  `wall_id` int(11) NOT NULL DEFAULT '0',
  `followers` int(11) NOT NULL DEFAULT '0',
  `settings` text,
  `var1` varchar(255) NOT NULL DEFAULT '',
  `var2` varchar(255) NOT NULL DEFAULT '',
  `var3` varchar(255) NOT NULL DEFAULT '',
  `var4` varchar(255) NOT NULL DEFAULT '',
  `var5` varchar(255) NOT NULL DEFAULT '',
  `var6` varchar(255) NOT NULL DEFAULT '',
  `var7` varchar(255) NOT NULL DEFAULT '',
  `pass` varchar(32) NOT NULL DEFAULT '',
  `hide_me` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `lastlogin` (`lastlogin`),
  KEY `email` (`email`),
  KEY `fbid` (`fbid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `jcow_accounts`
--

INSERT INTO `jcow_accounts` VALUES
(1, 0, '[[admin_email]]', 0, [[timestamp]], '[[admin_username]]', 'admin', '[[admin_pass]]', 0, 0, '', NULL, NULL, 0, '', [[timestamp]], '', '', 0, NULL, 1, NULL, 1990, 0, 0, 1, '', 0, 0, '3', '', '', '', '', '', 0, 0, NULL, '', '', '', '', '', '', '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `jcow_banned`
--

CREATE TABLE `jcow_banned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL DEFAULT '',
  `ip1` varchar(3) NOT NULL DEFAULT '',
  `ip2` varchar(3) NOT NULL DEFAULT '',
  `ip3` varchar(3) NOT NULL DEFAULT '',
  `ip4` varchar(3) NOT NULL DEFAULT '',
  `created` int(11) NOT NULL DEFAULT '0',
  `expired` int(11) NOT NULL DEFAULT '0',
  `operator` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_blacks`
--

CREATE TABLE `jcow_blacks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `bid` int(11) NOT NULL DEFAULT '0',
  `bname` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`bid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_cache`
--

CREATE TABLE `jcow_cache` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `content` text COLLATE utf8_unicode_ci,
  `expired` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_chatrooms`
--

CREATE TABLE `jcow_chatrooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `fid` int(11) NOT NULL DEFAULT '0',
  `content` text,
  `updated` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `request_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_comments`
--

CREATE TABLE `jcow_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `target_id` varchar(20) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  `message` text,
  `created` int(11) NOT NULL DEFAULT '0',
  `stream_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `target_id` (`target_id`),
  KEY `stream_id` (`stream_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_disliked`
--

CREATE TABLE `jcow_disliked` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `stream_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`stream_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_favorites`
--

CREATE TABLE `jcow_favorites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `fuid` int(11) NOT NULL DEFAULT '0',
  `fapp` varchar(100) NOT NULL DEFAULT '',
  `fsid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`fuid`,`fsid`,`created`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_followers`
--

CREATE TABLE `jcow_followers` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `fid` int(11) NOT NULL DEFAULT '0',
  KEY `uid` (`uid`,`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_footer_pages`
--

CREATE TABLE `jcow_footer_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `content` text,
  `weight` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `jcow_footer_pages`
--

INSERT INTO `jcow_footer_pages` VALUES
(1, 'About Us', 'About Us', 'You(admin) can edit this page from "Admin CP"-"Footer Pages".', 1),
(2, 'Contact Us', 'Contact Us', 'You(admin) can edit this page from "Admin CP"-"Footer Pages".', 2);

-- --------------------------------------------------------

--
-- Table structure for table `jcow_forums`
--

CREATE TABLE `jcow_forums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `weight` int(11) NOT NULL DEFAULT '0',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type_pic` varchar(255) NOT NULL DEFAULT '',
  `description` tinytext,
  `rules` text,
  `forum_type` varchar(50) NOT NULL DEFAULT '0',
  `threads` int(11) NOT NULL DEFAULT '0',
  `posts` int(11) NOT NULL DEFAULT '0',
  `lastpostname` varchar(32) NOT NULL DEFAULT '',
  `lastposttopicid` int(11) NOT NULL DEFAULT '0',
  `lastposttopic` varchar(70) NOT NULL DEFAULT '',
  `lastpostcreated` int(11) NOT NULL DEFAULT '0',
  `moderator` varchar(255) NOT NULL DEFAULT '',
  `settings` text,
  `fmembers` int(11) NOT NULL DEFAULT '0',
  `image` varchar(250) NOT NULL DEFAULT '',
  `read_roles` varchar(255) NOT NULL DEFAULT '',
  `upload_roles` varchar(255) NOT NULL DEFAULT '',
  `thread_roles` varchar(255) NOT NULL DEFAULT '',
  `reply_roles` varchar(255) NOT NULL DEFAULT '',
  `moderators` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `belong_id` (`parent_id`),
  KEY `order_num` (`weight`),
  KEY `type_class` (`forum_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `jcow_forums`
--

INSERT INTO `jcow_forums` VALUES
(7, 1, 0, 'General Category', '', '', '', 'category', 0, 0, '', 0, '', 0, '', '', 0, '', '', '', '', '', ''),
(8, 1, 7, 'General Forum', '', 'This is a general forum', '', 'forum', 0, 0, '', 0, '', 0, '', '', 0, '', '1|2', '2', '2', '2', '');

-- --------------------------------------------------------

--
-- Table structure for table `jcow_forum_attachments`
--

CREATE TABLE `jcow_forum_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `tid` int(11) NOT NULL DEFAULT '0',
  `uri` varchar(100) NOT NULL DEFAULT '',
  `des` varchar(255) NOT NULL DEFAULT '',
  `size` int(11) NOT NULL DEFAULT '0',
  `orginal_name` varchar(255) NOT NULL DEFAULT '',
  `downloads` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `tid` (`tid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_forum_polls`
--

CREATE TABLE `jcow_forum_polls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tid` int(11) NOT NULL DEFAULT '0',
  `question` varchar(100) NOT NULL DEFAULT '',
  `created` int(11) NOT NULL DEFAULT '0',
  `options` text,
  `timeout` int(11) NOT NULL DEFAULT '0',
  `options_per_user` tinyint(4) NOT NULL DEFAULT '0',
  `voters` text,
  `total` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tid` (`tid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_forum_posts`
--

CREATE TABLE `jcow_forum_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tid` bigint(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `message` text,
  `created` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(30) NOT NULL DEFAULT '',
  `is_first` tinyint(4) NOT NULL DEFAULT '0',
  `attach` int(11) NOT NULL DEFAULT '0',
  `bbcode_off` tinyint(4) NOT NULL DEFAULT '0',
  `emote_off` tinyint(4) NOT NULL DEFAULT '0',
  `got_attach` tinyint(4) NOT NULL DEFAULT '0',
  `stream_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tid` (`tid`),
  KEY `author_id` (`uid`),
  KEY `stream_id` (`stream_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_forum_subscribes`
--

CREATE TABLE `jcow_forum_subscribes` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `tid` int(11) NOT NULL DEFAULT '0',
  KEY `uid` (`uid`,`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_forum_threads`
--

CREATE TABLE `jcow_forum_threads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fid` int(11) NOT NULL DEFAULT '0',
  `old_fid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(50) NOT NULL DEFAULT '',
  `topic` varchar(255) NOT NULL DEFAULT '',
  `views` int(11) NOT NULL DEFAULT '0',
  `posts` int(11) NOT NULL DEFAULT '0',
  `closed` smallint(1) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `lastpostusername` varchar(255) NOT NULL DEFAULT '0',
  `lastpostcreated` int(10) NOT NULL DEFAULT '0',
  `icon` tinyint(4) NOT NULL DEFAULT '0',
  `thread_type` tinyint(1) NOT NULL DEFAULT '0',
  `thread_lock` tinyint(1) NOT NULL DEFAULT '0',
  `got_poll` tinyint(11) NOT NULL DEFAULT '0',
  `got_attach` tinyint(4) NOT NULL DEFAULT '0',
  `stressed` tinyint(4) NOT NULL DEFAULT '0',
  `digg` int(11) NOT NULL DEFAULT '0',
  `dugg` int(11) NOT NULL DEFAULT '0',
  `votes` text,
  PRIMARY KEY (`id`),
  KEY `fid` (`fid`),
  KEY `thread_type` (`thread_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_friends`
--

CREATE TABLE `jcow_friends` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `fid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  KEY `uid` (`uid`,`fid`),
  KEY `fid` (`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_friend_reqs`
--

CREATE TABLE `jcow_friend_reqs` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `fid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(200) NOT NULL DEFAULT '',
  KEY `uid` (`uid`,`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_groups`
--

CREATE TABLE `jcow_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uri` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `slogan` varchar(200) NOT NULL DEFAULT '',
  `creatorid` int(11) NOT NULL DEFAULT '0',
  `creator` varchar(50) NOT NULL DEFAULT '',
  `description` text,
  `members` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `logo` varchar(100) NOT NULL DEFAULT '',
  `private` tinyint(4) NOT NULL DEFAULT '0',
  `needapproval` tinyint(4) NOT NULL DEFAULT '0',
  `posts` int(11) NOT NULL DEFAULT '0',
  `topics` int(11) NOT NULL DEFAULT '0',
  `lastptime` int(11) NOT NULL DEFAULT '0',
  `lastpname` varchar(50) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `custom_css` text,
  `style_ids` varchar(50) NOT NULL DEFAULT '',
  `category` char(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `creatorid` (`creatorid`),
  KEY `uri` (`uri`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=21 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_group_categories`
--

CREATE TABLE `jcow_group_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `groups` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_group_members`
--

CREATE TABLE `jcow_group_members` (
  `gid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `nickname` varchar(20) NOT NULL DEFAULT '',
  `about_me` text,
  `hide_profile` tinyint(1) NOT NULL DEFAULT '0',
  KEY `gid` (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_group_members_pending`
--

CREATE TABLE `jcow_group_members_pending` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `gid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `ignored` tinyint(4) NOT NULL DEFAULT '0',
  KEY `uid` (`uid`,`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_group_polls`
--

CREATE TABLE `jcow_group_polls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tid` int(11) NOT NULL DEFAULT '0',
  `question` varchar(100) NOT NULL DEFAULT '',
  `created` int(11) NOT NULL DEFAULT '0',
  `options` text,
  `timeout` int(11) NOT NULL DEFAULT '0',
  `options_per_user` tinyint(4) NOT NULL DEFAULT '0',
  `voters` text,
  `total` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tid` (`tid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_group_postcats`
--

CREATE TABLE `jcow_group_postcats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_group_posts`
--

CREATE TABLE `jcow_group_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL DEFAULT '0',
  `tid` bigint(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(50) NOT NULL DEFAULT '',
  `rtid` int(11) NOT NULL DEFAULT '0',
  `rid` int(11) NOT NULL DEFAULT '0',
  `rname` varchar(100) NOT NULL DEFAULT '',
  `message` text,
  `created` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(30) NOT NULL DEFAULT '',
  `attach` int(11) NOT NULL DEFAULT '0',
  `bbcode_off` tinyint(4) NOT NULL DEFAULT '0',
  `emote_off` tinyint(4) NOT NULL DEFAULT '0',
  `got_attach` tinyint(4) NOT NULL DEFAULT '0',
  `topic` varchar(100) NOT NULL DEFAULT '',
  `is_first` tinyint(4) NOT NULL DEFAULT '0',
  `replies` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tid` (`tid`),
  KEY `uid` (`uid`),
  KEY `gid` (`gid`),
  KEY `rtid` (`rtid`),
  KEY `rid` (`rid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=100 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_group_topics`
--

CREATE TABLE `jcow_group_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL DEFAULT '0',
  `old_fid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(50) NOT NULL DEFAULT '',
  `topic` varchar(255) NOT NULL DEFAULT '',
  `views` int(11) NOT NULL DEFAULT '0',
  `posts` int(11) NOT NULL DEFAULT '0',
  `closed` smallint(1) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `lastpostusername` varchar(255) NOT NULL DEFAULT '0',
  `lastpostcreated` int(11) NOT NULL DEFAULT '0',
  `icon` tinyint(4) NOT NULL DEFAULT '0',
  `thread_type` tinyint(1) NOT NULL DEFAULT '0',
  `thread_lock` tinyint(1) NOT NULL DEFAULT '0',
  `got_poll` tinyint(11) NOT NULL DEFAULT '0',
  `got_attach` tinyint(4) NOT NULL DEFAULT '0',
  `stressed` tinyint(4) NOT NULL DEFAULT '0',
  `digg` int(11) NOT NULL DEFAULT '0',
  `dugg` int(11) NOT NULL DEFAULT '0',
  `votes` text,
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=32 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_gvars`
--

CREATE TABLE `jcow_gvars` (
  `gkey` varchar(50) NOT NULL DEFAULT '',
  `gvalue` text,
  KEY `gkey` (`gkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jcow_gvars`
--

INSERT INTO `jcow_gvars` VALUES
('theme_folder', 'themes/default'),
('cf_var1', 'disabled'),
('cf_var2', 'disabled'),
('cf_var3', 'disabled'),
('cf_var4', 'disabled'),
('cf_var5', 'disabled'),
('cf_var6', 'disabled'),
('cf_var7', 'disabled'),
('jcow_version', '4.0'),
('app_music_disable', '0'),
('story_access', 'all'),
('profile_access', 'all'),
('site_slogan', '[[site_desc]]'),
('ad_block_content_top', ''),
('ad_block_content_bottom', ''),
('site_name', '[[site_name]]'),
('site_email', '[[admin_email]]'),
('block_top', ''),
('block_bottom', ''),
('menu_icon_style', 'colored'),
('edition', 'ce'),
('only_invited', '0'),
('session_lived', '1267784005'),
('permission_etheme', '2'),
('permission_atheme', '2|11'),
('private_network', '0'),
('theme_tpl', 'default'),
('theme_css', '1.css'),
('hide_ad_roles', '3'),
('acc_verify', '0'),
('permission_upload', '2'),
('permission_comment', '2'),
('permission_add', '2'),
('permission_browse', '1|2'),
('permission_feed', '1|2'),
('theme_block_adsbar', 'Go to "Admin CP" - "Themes" - "Manage Blocks" to edit this message.'),
('limit_posting_num', '5'),
('app_music', '0');

-- --------------------------------------------------------

--
-- Table structure for table `jcow_im`
--

CREATE TABLE `jcow_im` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_id` int(11) NOT NULL DEFAULT '0',
  `to_id` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `message` text,
  `created` int(11) NOT NULL DEFAULT '0',
  `hasread` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `from_id` (`from_id`,`to_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_invites`
--

CREATE TABLE `jcow_invites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `code` varchar(15) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_langs`
--

CREATE TABLE `jcow_langs` (
  `lang_from` varchar(255) NOT NULL DEFAULT '',
  `lang_to` text,
  `lang` varchar(20) NOT NULL DEFAULT '',
  KEY `lang_from` (`lang_from`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_liked`
--

CREATE TABLE `jcow_liked` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `stream_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `stream_id` (`stream_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_limit_posting`
--

CREATE TABLE `jcow_limit_posting` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `act` varchar(50) NOT NULL DEFAULT '',
  KEY `uid` (`uid`,`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_mentions`
--

CREATE TABLE `jcow_mentions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `stream_id` int(11) NOT NULL DEFAULT '0',
  `wall_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_menu`
--

CREATE TABLE `jcow_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `tab_name` varchar(50) NOT NULL DEFAULT '',
  `weight` int(11) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `app` varchar(50) NOT NULL DEFAULT '',
  `actived` tinyint(1) NOT NULL DEFAULT '0',
  `type` varchar(25) NOT NULL DEFAULT '',
  `protected` tinyint(1) NOT NULL DEFAULT '0',
  `allowed_roles` text,
  `icon` varchar(255) NOT NULL DEFAULT '',
  `parent` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=143 ;

--
-- Dumping data for table `jcow_menu`
--

INSERT INTO `jcow_menu` VALUES
(14, 'My feed', 'Latest', 1, 'feed', 'feed', 1, 'app', 0, '1', '', ''),
(18, 'My account', 'My information', 20, 'account', 'account', 1, 'personal', 0, '', '', ''),
(19, 'Avatar', '', 34, 'account/avatar', 'account', 1, 'tab', 0, '', '', 'account'),
(21, 'Privacy', '', 36, 'account/privacy', 'account', 1, 'tab', 0, '', '', 'account'),
(22, 'Password', '', 37, 'account/cpassword', 'account', 1, 'tab', 0, '', '', 'account'),
(23, 'Invite', '', 20, 'invite', 'invite', 1, 'crossplatform', 0, '', 'mi-person_add', ''),
(105, 'Settings', '', 43, 'account/settings', 'account', 1, 'tab', 0, '1,2', '', 'account'),
(106, 'Messages', '', 44, 'message/inbox', 'message', 1, 'app', 0, '1,2', '', ''),
(132, 'Members', 'Browse', 48, 'browse', 'browse', 1, 'crossplatform', 1, '1,2', 'mi-person_search', ''),
(133, 'Hot', '', 49, 'feed/hot', 'feed', 1, 'tab', 0, '1,2', '', 'feed'),
(134, 'New', '', 50, 'feed/newest', 'feed', 1, 'tab', 0, '1,2', '', 'feed'),
(135, 'Following', '', 51, 'feed/following', 'feed', 1, 'tab', 0, '1,2', '', 'feed'),
(136, 'Blogs', 'Hot', 52, 'blogs', 'blogs', 1, 'crossplatform', 0, '1,2', 'mi-article', ''),
(137, 'Featured', '', 53, 'blogs/featured', 'blogs', 1, 'tab', 0, '1,2', '', 'blogs'),
(138, 'New', '', 54, 'blogs/all', 'blogs', 1, 'tab', 0, '1,2', '', 'blogs'),
(139, 'My blog', '', 55, 'blogs/mine', 'blogs', 1, 'personal', 0, '1,2', '', 'jcow_base'),
(140, 'Polls', 'Community', 56, 'polls', 'polls', 1, 'community', 0, '1,2', 'mi-poll', ''),
(141, 'Connections', '', 57, 'polls/following', 'polls', 1, 'tab', 0, '1,2', '', 'polls'),
(142, 'Mine', '', 58, 'polls/mine', 'polls', 1, 'tab', 0, '1,2', '', 'polls');

-- --------------------------------------------------------

--
-- Table structure for table `jcow_messages`
--

CREATE TABLE `jcow_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `message` text,
  `from_id` int(11) NOT NULL DEFAULT '0',
  `to_id` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `hasread` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `from_id` (`from_id`,`to_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=25 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_messages_sent`
--

CREATE TABLE `jcow_messages_sent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `message` text,
  `from_id` int(11) NOT NULL DEFAULT '0',
  `to_id` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `hasread` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `from_id` (`from_id`,`to_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_modules`
--

CREATE TABLE `jcow_modules` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `actived` tinyint(1) NOT NULL DEFAULT '0',
  `hooking` tinyint(4) NOT NULL DEFAULT '0',
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jcow_modules`
--

INSERT INTO `jcow_modules` VALUES
('browse', 1, 0),
('feed', 1, 0),
('dashboard', 1, 1),
('account', 1, 0),
('admin', 1, 1),
('u', 1, 0),
('member', 1, 0),
('follow', 1, 0),
('friends', 1, 0),
('jquery', 1, 0),
('language', 1, 0),
('message', 1, 0),
('notifications', 1, 0),
('preference', 1, 0),
('report', 1, 0),
('rss', 1, 0),
('search', 1, 0),
('invite', 1, 0),
('apps', 1, 0),
('blacklist', 1, 0),
('update', 1, 0),
('blogs', 1, 1),
('chatbar', 1, 1),
('cache', 1, 1),
('mobile', 1, 1),
('polls', 1, 1),
('hashtags', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `jcow_notes`
--

CREATE TABLE `jcow_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `uri` varchar(200) NOT NULL DEFAULT '',
  `message` text,
  `from_uid` int(11) NOT NULL DEFAULT '0',
  `hasread` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_pages`
--

CREATE TABLE `jcow_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uri` varchar(30) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  `logo` varchar(100) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `style_ids` text,
  `custom_css` text,
  `background` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(25) NOT NULL DEFAULT '',
  `description` text,
  `users` int(11) NOT NULL DEFAULT '0',
  `updated` int(11) NOT NULL DEFAULT '0',
  `var1` varchar(255) NOT NULL DEFAULT '',
  `var2` varchar(255) NOT NULL DEFAULT '',
  `var3` varchar(255) NOT NULL DEFAULT '',
  `text1` text,
  `text2` text,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `uri` (`uri`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `jcow_pages`
--

INSERT INTO `jcow_pages` VALUES
(1, 'admin', 1, 0, '', '', NULL, NULL, '', 'u', NULL, 0, 0, '', '', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `jcow_page_users`
--

CREATE TABLE `jcow_page_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`,`uid`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_page_visitors`
--

CREATE TABLE `jcow_page_visitors` (
  `pid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `updated` int(11) NOT NULL DEFAULT '0',
  KEY `pid_uid` (`pid`,`uid`),
  KEY `pid_updated` (`pid`,`updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_pending_review`
--

CREATE TABLE `jcow_pending_review` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `content` text,
  `uri` varchar(255) NOT NULL DEFAULT '',
  `post_id` varchar(50) NOT NULL DEFAULT '',
  `created` int(11) NOT NULL DEFAULT '0',
  `ignored` tinyint(4) NOT NULL DEFAULT '0',
  `stream_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `post_id` (`post_id`),
  KEY `stream_id` (`stream_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_points`
--

CREATE TABLE `jcow_points` (
  `uid` int(11) NOT NULL,
  `type` text NOT NULL,
  `points` int(11) NOT NULL,
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_profiles`
--

CREATE TABLE `jcow_profiles` (
  `id` int(11) NOT NULL DEFAULT '0',
  `style_ids` varchar(255) NOT NULL DEFAULT '',
  `custom_css` text,
  `background` varchar(100) NOT NULL DEFAULT '',
  `videoid` int(11) NOT NULL DEFAULT '0',
  `favorites` int(11) NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_profile_comments`
--

CREATE TABLE `jcow_profile_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `target_id` int(11) NOT NULL DEFAULT '0',
  `message` text,
  `created` int(11) NOT NULL DEFAULT '0',
  `stream_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `stream_id` (`stream_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_reports`
--

CREATE TABLE `jcow_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `message` text,
  `hasread` tinyint(1) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_requests`
--

CREATE TABLE `jcow_requests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `question` text,
  `answer` text,
  `created` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_roles`
--

CREATE TABLE `jcow_roles` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jcow_roles`
--

INSERT INTO `jcow_roles` VALUES
(1, 'Guest'),
(2, 'General member'),
(3, 'Administrator');

-- --------------------------------------------------------

--
-- Table structure for table `jcow_shortcuts`
--

CREATE TABLE `jcow_shortcuts` (
  `uid` int(11) NOT NULL,
  `page_id` int(11) NOT NULL,
  `weight` int(11) NOT NULL,
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jcow_shortcuts`
--

INSERT INTO `jcow_shortcuts` VALUES
(1, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `jcow_spammers`
--

CREATE TABLE `jcow_spammers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userkey` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `created` int(11) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `userkey` (`userkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_spammers_cloud`
--

CREATE TABLE `jcow_spammers_cloud` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userkey` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `created` int(11) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `userkey` (`userkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_status_photos`
--

CREATE TABLE `jcow_status_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `uri` varchar(100) NOT NULL DEFAULT '',
  `des` varchar(255) NOT NULL DEFAULT '',
  `thumb` varchar(100) NOT NULL DEFAULT '',
  `size` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sid` (`sid`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_stories`
--

CREATE TABLE `jcow_stories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `sticky` tinyint(4) NOT NULL DEFAULT '0',
  `closed` tinyint(4) NOT NULL DEFAULT '0',
  `title` varchar(120) NOT NULL DEFAULT '',
  `thumbnail` varchar(255) NOT NULL DEFAULT '',
  `content` text,
  `uid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `lastreply` int(11) NOT NULL DEFAULT '0',
  `lastreplyuname` varchar(50) NOT NULL DEFAULT '',
  `lastreplyuid` int(11) NOT NULL DEFAULT '0',
  `updated` int(11) NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  `comments` int(11) NOT NULL DEFAULT '0',
  `stream_id` int(11) NOT NULL DEFAULT '0',
  `app` varchar(50) NOT NULL DEFAULT '',
  `digg` int(11) NOT NULL DEFAULT '0',
  `dugg` int(11) NOT NULL DEFAULT '0',
  `photos` int(11) NOT NULL DEFAULT '0',
  `tags` varchar(255) NOT NULL DEFAULT '',
  `featured` tinyint(4) NOT NULL DEFAULT '0',
  `var1` varchar(255) NOT NULL DEFAULT '',
  `var2` varchar(255) NOT NULL DEFAULT '',
  `var3` varchar(255) NOT NULL DEFAULT '',
  `var4` varchar(255) NOT NULL DEFAULT '',
  `var5` varchar(255) NOT NULL DEFAULT '',
  `int1` int(11) NOT NULL DEFAULT '0',
  `int2` int(11) NOT NULL DEFAULT '0',
  `text1` text,
  `text2` text,
  `blob1` blob,
  `rating` text,
  `page_id` int(11) NOT NULL DEFAULT '0',
  `page_type` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `app` (`app`),
  KEY `uid` (`uid`),
  KEY `page_id` (`page_id`),
  KEY `cid` (`cid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=79 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_story_categories`
--

CREATE TABLE `jcow_story_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(150) NOT NULL DEFAULT '',
  `description` text,
  `weight` int(11) NOT NULL DEFAULT '0',
  `app` varchar(50) NOT NULL DEFAULT '',
  `var1` varchar(255) NOT NULL DEFAULT '',
  `var2` varchar(255) NOT NULL DEFAULT '',
  `var3` varchar(255) NOT NULL DEFAULT '',
  `var4` varchar(255) NOT NULL DEFAULT '',
  `var5` varchar(255) NOT NULL DEFAULT '',
  `uri` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `app` (`app`),
  KEY `weight` (`weight`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_story_cat_groups`
--

CREATE TABLE `jcow_story_cat_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `app` varchar(50) NOT NULL DEFAULT '',
  `weight` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_story_photos`
--

CREATE TABLE `jcow_story_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `uri` varchar(100) NOT NULL DEFAULT '',
  `des` varchar(255) NOT NULL DEFAULT '',
  `thumb` varchar(100) NOT NULL DEFAULT '',
  `size` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `sid` (`sid`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=48 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_streams`
--

CREATE TABLE `jcow_streams` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text,
  `wall_id` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `comments` int(11) NOT NULL DEFAULT '0',
  `attachment` text,
  `created` int(11) NOT NULL DEFAULT '0',
  `updated` int(11) NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `app` varchar(20) NOT NULL DEFAULT '',
  `aid` int(11) NOT NULL DEFAULT '0',
  `hide` tinyint(1) NOT NULL DEFAULT '0',
  `likes` int(11) NOT NULL DEFAULT '0',
  `dislikes` int(11) NOT NULL DEFAULT '0',
  `stuff_id` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `data` text,
  PRIMARY KEY (`id`),
  KEY `app` (`app`),
  KEY `aid` (`aid`),
  KEY `jcow_streams_wall_id` (`wall_id`),
  KEY `stuff_id` (`stuff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_subscr`
--

CREATE TABLE `jcow_subscr` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `item_number` varchar(32) NOT NULL DEFAULT '',
  `status` varchar(25) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  `timeline` int(11) NOT NULL DEFAULT '0',
  KEY `id` (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_tags`
--

CREATE TABLE `jcow_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `app` varchar(25) NOT NULL DEFAULT '',
  `num` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_tag_ids`
--

CREATE TABLE `jcow_tag_ids` (
  `tid` int(11) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL DEFAULT '0',
  KEY `tid` (`tid`,`sid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_texts`
--

CREATE TABLE `jcow_texts` (
  `tkey` varchar(50) NOT NULL DEFAULT '',
  `tvalue` text,
  KEY `tkey` (`tkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jcow_texts`
--

INSERT INTO `jcow_texts` VALUES
('welcome_pm', 'Hello %username%!\r\nThank you for your registeration!\r\nPlease invite your friends to join our community.'),
('welcome_email', 'Dear %username%,\r\nWelcome to %sitelink%!\r\nYour login email is: %email%\r\nOur URL is:\r\n%sitelink%'),
('welcome_msg', 'Welcome to our Community!'),
('rules_conditions', 'none'),
('footermsg', 'Your footer here..'),
('locations', 'Afghanistan  \r\nAlbania  \r\nAlgeria  \r\nAmerican Samoa  \r\nAndorra  \r\nAngola  \r\nAnguilla  \r\nAntarctica  \r\nAntigua and Barbuda  \r\nArgentina  \r\nArmenia  \r\nAruba  \r\nAustralia  \r\nAustria  \r\nAzerbaidjan  \r\nBahamas  \r\nBahrain  \r\nBangladesh  \r\nBarbados  \r\nBelarus  \r\nBelgium  \r\nBelize  \r\nBenin  \r\nBermuda  \r\nBhutan  \r\nBolivia  \r\nBosnia-Herzegovina  \r\nBotswana  \r\nBouvet Island  \r\nBrazil  \r\nBrunei Darussalam  \r\nBulgaria  \r\nBurkina Faso  \r\nBurundi  \r\nCambodia  \r\nCameroon  \r\nCanada  \r\nCape Verde  \r\nCayman Islands  \r\nCentral African Republic  \r\nChad  \r\nChile  \r\nChina  \r\nChristmas Island  \r\nCocos Islands  \r\nColombia  \r\nComoros  \r\nCongo  \r\nCook Islands  \r\nCosta Rica  \r\nCroatia  \r\nCuba  \r\nCyprus  \r\nCzech Republic  \r\nDenmark  \r\nDjibouti  \r\nDominica  \r\nDominican Republic  \r\nEast Timor  \r\nEcuador  \r\nEgypt  \r\nEl Salvador  \r\nEquatorial Guinea  \r\nEstonia  \r\nEthiopia  \r\nFalkland Islands  \r\nFaroe Islands  \r\nFiji  \r\nFinland  \r\nFormer Czechoslovakia  \r\nFrance  \r\nFrench Guyana  \r\nGabon  \r\nGambia  \r\nGeorgia  \r\nGermany  \r\nGhana  \r\nGibraltar  \r\nGreat Britain  \r\nGreece  \r\nGreenland  \r\nGrenada  \r\nGuadeloupe  \r\nGuam  \r\nGuatemala  \r\nGuinea  \r\nGuinea Bissau  \r\nGuyana  \r\nHaiti  \r\nHonduras  \r\nHong Kong  \r\nHungary  \r\nIceland  \r\nIndia  \r\nIndonesia  \r\nIran  \r\nIraq  \r\nIreland  \r\nIsrael  \r\nItaly  \r\nIvory Coast  \r\nJamaica  \r\nJapan  \r\nJordan  \r\nKazakhstan  \r\nKenya  \r\nKiribati  \r\nKuwait  \r\nKyrgyzstan  \r\nLaos  \r\nLatvia  \r\nLebanon  \r\nLesotho  \r\nLiberia  \r\nLibya  \r\nLiechtenstein  \r\nLithuania  \r\nLuxembourg  \r\nMacau  \r\nMacedonia  \r\nMadagascar  \r\nMalawi  \r\nMalaysia  \r\nMaldives  \r\nMali  \r\nMalta  \r\nMarshall Islands  \r\nMartinique  \r\nMauritania  \r\nMauritius  \r\nMayotte  \r\nMexico  \r\nMicronesia  \r\nMoldavia  \r\nMonaco  \r\nMongolia  \r\nMontserrat  \r\nMorocco  \r\nMozambique  \r\nMyanmar  \r\nNamibia  \r\nNauru  \r\nNepal  \r\nNetherlands  \r\nNetherlands Antilles  \r\nNeutral Zone  \r\nNew Caledonia  \r\nNew Zealand  \r\nNicaragua  \r\nNiger  \r\nNigeria  \r\nNiue  \r\nNorfolk Island  \r\nNorth Korea  \r\nNorway  \r\nOman  \r\nPakistan  \r\nPalau  \r\nPanama  \r\nPapua New Guinea  \r\nParaguay  \r\nPeru  \r\nPhilippines  \r\nPitcairn Island  \r\nPoland  \r\nPolynesia  \r\nPortugal  \r\nPuerto Rico  \r\nQatar  \r\nReunion  \r\nRomania  \r\nRussian Federation  \r\nRwanda  \r\nSaint Helena  \r\nSaint Lucia  \r\nSaint Vincent and Grenadines  \r\nSamoa  \r\nSan Marino  \r\nSaudi Arabia  \r\nSenegal  \r\nSeychelles  \r\nSierra Leone  \r\nSingapore  \r\nSlovak Republic  \r\nSlovenia  \r\nSolomon Islands  \r\nSomalia  \r\nSouth Africa  \r\nSouth Korea  \r\nSpain  \r\nSri Lanka  \r\nSudan  \r\nSuriname  \r\nSwaziland  \r\nSweden  \r\nSwitzerland  \r\nSyria  \r\nTadjikistan  \r\nTaiwan  \r\nTanzania  \r\nThailand  \r\nTogo  \r\nTokelau  \r\nTonga  \r\nTrinidad and Tobago  \r\nTunisia  \r\nTurkey  \r\nTurkmenistan  \r\nTuvalu  \r\nUganda  \r\nUkraine  \r\nUnited Arab Emirates  \r\nUnited Kingdom  \r\nUnited States  \r\nUruguay  \r\nUzbekistan  \r\nVanuatu  \r\nVatican City State  \r\nVenezuela  \r\nVietnam  \r\nVirgin Islands (British)  \r\nVirgin Islands (USA)  \r\nWallis and Futuna Islands  \r\nWestern Sahara  \r\nYemen  \r\nYugoslavia  \r\nZaire  \r\nZambia  \r\nZimbabwe');

-- --------------------------------------------------------

--
-- Table structure for table `jcow_tmp`
--

CREATE TABLE `jcow_tmp` (
  `tkey` varchar(70) NOT NULL DEFAULT '',
  `tcontent` text,
  KEY `tkey` (`tkey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_topics`
--

CREATE TABLE `jcow_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `stories` int(11) NOT NULL DEFAULT '0',
  `followers` int(11) NOT NULL DEFAULT '0',
  `updated` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(4) NOT NULL DEFAULT '0',
  `description` text,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `stories` (`stories`),
  KEY `featured` (`featured`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_topics_followed`
--

CREATE TABLE `jcow_topics_followed` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `tid` int(11) NOT NULL DEFAULT '0',
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_topic_ids`
--

CREATE TABLE `jcow_topic_ids` (
  `tid` int(11) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL DEFAULT '0',
  KEY `tid` (`tid`,`sid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_user_crafts`
--

CREATE TABLE `jcow_user_crafts` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `hash` varchar(5) NOT NULL DEFAULT '',
  `created` int(11) NOT NULL DEFAULT '0',
  KEY `uid` (`uid`,`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_var_cache`
--

CREATE TABLE `jcow_var_cache` (
  `name` varchar(60) NOT NULL DEFAULT '',
  `content` varchar(255) NOT NULL DEFAULT '',
  `created` int(11) NOT NULL DEFAULT '0',
  KEY `name` (`name`,`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_votes`
--

CREATE TABLE `jcow_votes` (
  `sid` int(11) NOT NULL DEFAULT '0',
  `created` int(11) NOT NULL DEFAULT '0',
  `rate` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  KEY `sid` (`sid`,`uid`),
  KEY `created` (`created`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `jcow_wiki_versions`
--

CREATE TABLE `jcow_wiki_versions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `sid` int(11) NOT NULL,
  `created` int(11) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `tags` text NOT NULL,
  `note` text NOT NULL,
  `type` text NOT NULL,
  `status` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sid` (`sid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
