<?php
if (!$dbtype) {
	$dbtype = 'MySQL';
}

function dbhold($t = '') {
	return '';
}
class ResultSet {
	var $result;
	var $total_rows;
	var $fetched_rows;

	function set_result( $res ) {
		$this->result = $res;
	}

	function get_result() {
		return $this->result;
	}

	function set_total_rows( $rows ) {
		$this->total_rows = $rows;
	}

	function get_total_rows() {
		return $this->total_rows;
	}

	function set_fetched_rows( $rows ) {
		$this->fetched_rows = $rows;
	}

	function get_fetched_rows() {
		return $this->fetched_rows;
	}

	function increment_fetched_rows() {
		$this->fetched_rows = $this->fetched_rows + 1;
	}
}

// custom

function sql_insert($att, $table_name, $arg = 0) {
	if (function_exists('insertc')) {
		$att = insertc($att, $table_name);
	}
	// insert
	foreach ($att as $key=>$val) {
		if ($key == 'nid') $ned = 1;
		$keys .= isset($keys) ? ','.$key : $key;
		$vals .= $vals?",'$val'":"'$val'";
	}
	$q = "insert into $table_name($keys) values($vals)";
	return sql_query($q);
}


function sql_update($att, $table_name, $arg = 0) {
	// update
	foreach ($att as $key=>$val) {
		if ($key != 'id') {
			$sets .= $sets?",$key='$val'":"$key='$val'";
		}
	}
	if (is_array($arg)) {
		foreach ($arg as $key=>$val) {
			$wheres .= $wheres ? " and $key='$val'" : "$key='$val'";
		}
	}
	if ($att['id']) {
		$wheres = " id='{$att['id']}'";
	}
	if (!$wheres) {
		return false;
	}
	$q = "update $table_name set $sets where $wheres";
	return sql_query($q);
}


function sql_connect($host, $user, $password, $db, $creat_db = 0)
{
    
global $dbtype;
switch ($dbtype) {

    case "MySQL":
        $dbi=mysqli_connect($host, $user, $password,$db);
		if (!$dbi)
			die("cannot connect to mysql server");
		/*
		if (!mysqli_set_charset($dbi, "utf8mb4")) {
		    printf("Error loading character set utf8: %s\n", mysqli_error($link));
		    exit();
		} else {
		    //printf("Current character set: %s\n", mysqli_character_set_name($link));
		}
		*/
        return $dbi;
    break;

    case "postgresql":
         $dbi=@pg_connect("host=$host user=$user password=$password port=5432 dbname=$db");
         if (!$dbi) {
         	die('site not found');
         }
         return $dbi;
    break;;

    default:
    break;;
    }

}

function sql_logout($id)
{
global $dbtype;
switch ($dbtype) {

    case "MySQL":
        $dbi=@mysqli_close($id);
        return $dbi;
    break;;

    case "mSQL":
         $dbi=@msql_close($id);
         return $dbi;
    break;;

    case "PostgreSQL":
    case "PostgreSQL_local":
         $dbi=@pg_close($id);
         return $dbi;
    break;;
  
    case "ODBC":
    case "ODBC_Adabas":
         $dbi=@odbc_close($id);
         return $dbi;  
    break;;

    case "Interbase":
         $dbi=@ibase_close($id);
         return $dbi;
    break;;

    case "Sybase":
        $dbi=@sybase_close($id);
        return $dbi;
    break;;

    default:
    break;;
    }
}



function insert_id($connection = false)
{
	global $dbtype,$conn;
    if ($dbtype == 'postgresql') {
    	$res = sql_query("select LASTVAL() as id", $connection);
        $row = sql_fetch_array($res);
        return $row['id'];
    }
    else {
		return mysqli_insert_id($conn);
	}
}

function sql_query($query,$connection = false)
{

    global $dbtype,$conn,$config;
    if (!$connection) {
    	$connection = $conn;
    }
    if ($dbtype == 'postgresql') {
    	$res = pg_query($connection,$query);
    	if (!$res) {
    		if (is_app()) {
	            return_err($query.'SQL err:'.pg_last_error($connection));
	        }
	        else {
	        	echo $query;
	        	echo '<br /><br />SQL err:'.pg_last_error($connection);
	        	exit;
	        }
        }
    }
    else {
		if (!$res = mysqli_query($conn,$query)) {
			if (is_app()) {
				return_err('SQL ERROR:'.$query.' err:'.mysqli_error($conn));
			}
			else {
				echo $query;
	        	echo '<br /><br />SQL err:'.mysqli_error($conn);
	        	exit;
			}
		}
	}
    return $res;

}

function sql_string($str) {
    global $conn;
    return safe($str);
}

/*
 * sql_num_rows($res)
 * given a result identifier, returns the number of affected rows
 */

function sql_counts($res)
{
global $dbtype;
switch ($dbtype) {
 
    case "MySQL":
        $rows=@mysqli_num_rows($res);
        return $rows;
    break;;

    case "postgresql":
        return pg_num_rows($res);
    break;;
        
    default:
    break;;
    }
}


function sql_fetch_row(&$res, $nr=0)
{
global $dbtype,$q;
switch ($dbtype) {

    case "MySQL":
        $row = mysqli_fetch_row($res);
        return $row;
    break;;

    case "mSQL":
        $row = msql_fetch_row($res);
        return $row;
    break;;

    case "PostgreSQL":
    case "PostgreSQL_local":
	if ( $res->get_total_rows() > $res->get_fetched_rows() ) {
		$row = pg_fetch_row($res->get_result(), $res->get_fetched_rows() );
		$res->increment_fetched_rows();
		return $row;
	} else {
		return false;
	}
    break;;

    case "ODBC":
    case "ODBC_Adabas":
        $row = array();
        $cols = odbc_fetch_into($res, $nr, $row);
        return $row;
    break;;

    case "Interbase":
        $row = ibase_fetch_row($res);
        return $row;
    break;;

    case "Sybase":
        $row = sybase_fetch_row($res);
        return $row;
    break;;

    default:
    break;;
    }
}


function sql_fetch_array(&$res, $nr=0)
{
global $dbtype;
switch ($dbtype) {
	case "postgresql":
		$row = pg_fetch_array($res,NULL,PGSQL_ASSOC);
		return $row;
    case "MySQL":
        $row = mysqli_fetch_array($res, MYSQLI_ASSOC);
        return $row;
    break;;
    }
}


?>