$( document ).ready(function() {
	$("#chatlist").css("height",($(window).height()-200)+"px");
	function fitlayout(callback) {
		if ($hidemenu) {
			$("#jcow_main").css({"max-width":"1095px"});
			$("#jcow_sec_menu").hide();
			if ($(window).width() > 1100) {
				$("#jcow_primary_menu").show();
			}
			else {
				$("#jcow_primary_menu").hide();
			}
		}
		else {
			if ($(window).width() > 1100) {
				$("#h_uname").show();
				$("#h_search").hide();
				$("#jcow_app_menu").css('box-shadow', 'none');
				$("#jcow_app_menu").show();
				$("#jcow_sec_menu").hide();
				$("#jcow_primary_menu").show();
			}
			else {
				$("#h_uname").hide();
				$("#h_search").show();
				$("#jcow_app_menu").hide();
				$("#jcow_app_menu").css('box-shadow', '5px 5px 8px #ccc');
				$("#jcow_sec_menu").show();
				$("#jcow_primary_menu").hide();
			}
		}
		if ($(window).width() > 900) {
			$("#menu").show();
		}
		else {
			$("#menu").hide();
		}
		
		
		if (typeof callback === "function") {
			callback();
		}
	}
	var toolbarOptions = [];
	if ($images_enabled) {
		toolbarOptions = [
		 { 'header': [1,2,3,4] },
		{ 'list': 'ordered'}, { 'list': 'bullet' },'bold', 'italic','image', 'blockquote','code-block','clean'
		];
	}
	else {
		toolbarOptions = [
		 { 'header': [1,2,3,4] },
		{ 'list': 'ordered'}, { 'list': 'bullet' },'bold', 'italic', 'blockquote','code-block','clean'
		];
	}
	if ($(".richtextarea").length) {
		var quill = new Quill( ".richtextarea", {
	    theme: "snow",
	    modules: {
		    toolbar: toolbarOptions,
		    imageUploader: {
	              upload: file => {
	                return new Promise((resolve, reject) => {
	                  const formData = new FormData();
	                  formData.append("file", file);
	                  $(document).find(":submit").prop('disabled', true);
	                  fetch(
	                    $baseurl+"/index.php?p=jquery/uploadimg",
	                    {
	                      method: "POST",
	                      body: formData
	                    }
	                  )
	                    .then(response => response.json())
	                    .then(result => {
	                      console.log(result);
	                      resolve(result.data.uri);
	                      $(document).find(":submit").prop('disabled', false);
	                    })
	                    .catch(error => {
	                      reject("Upload failed");
	                      console.error("Error:", error);
	                      $(document).find(":submit").prop('disabled', false);
	                    });
	                });
	              }
	            }
		  }
	  });
	}
	$("#show_jcow_app_menu").click(function() {
		$("#jcow_app_menu").show();
		return false;
	});
	$(document).mouseup(function (e) {
	    var container = $("#jcow_app_menu");
	    if (!container.is(e.target)  && container.has(e.target).length === 0)  {
	    	if ($("#jcow_sec_menu").is(":visible")) {
	        	container.hide();
	        }
	    }
	});
	$(window).load(function(){
		$('.grid').masonry({
	  columnWidth: 215,
		  itemSelector: '.grid-item'
		});
	});
	$(document).ready(function(){
		fitlayout();
	});
	
	$(window).resize(function() {
	  fitlayout();
	});

	autosize($(".form_message"));

	$('.jcow_select').selectpicker({
		dropdownAlignRight:true
	});

	

	$(document).on("click",".repost_profile",function() {
		$('#shareModal').modal('show');
		$("#share_content").html("<div style='padding:50px;font-size:30px'><i class=\"fa fa-lg fa-spinner fa-spin\"></i></div>");
		var sid = $(this).attr("sid");
		$.get($baseurl+"/index.php?p=feed/share/"+sid,
		  function(data){
			$("#share_content").html(data);
			init_story_img_thumb();
			},"html"
		);
		return false;
	});
	$(document).on("click",".share_post",function() {
		var sid = $(this).attr("sid");
		var block = $(this).closest(".block_content");
		var msg = block.find(".share_msg").val();
		var pageid = block.find("option:selected").val();
		$(this).parent().html("<i class=\"fa fa-lg fa-spinner fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=feed/sharepost/"+sid,
			{msg:msg,pageid:pageid},
		  function(data){
			$("#share_content").html(data);
			setTimeout(function() {$('#shareModal').modal('hide');}, 1000);
			},"html"
		);
		return false;
	});

	$(document).on("click",".chatbox",function() {
		$("#dmodal_title").html($(this).attr("ctitle"));
		$("#msgsend").attr("uid",$(this).attr("uid"));
		$('#chatModal').modal('show');
		$("#chatlist").html("<i class=\"fa fa-spinner fa-spin\"></i>");
		return false;
	});
	
	$(document).on("click",".chatbox_btn",function() {
		$("#dmodal_title").html($(this).attr("ctitle"));
		$("#msgsend").attr("uid",$(this).attr("uid"));
		$('#chatModal').modal('show');
		$("#chatlist").html("<i class=\"fa fa-spinner fa-spin\"></i>");
		return false;
	});

	
	var chatupdatehandle = 0;
	$('#chatModal').on('show.bs.modal', function (e) {
		update_chatlist();
		chatupdatehandle = window.setInterval(function(){
		  update_chatlist();
		}, 2000);
	});
	function update_chatlist() {
		$.post($baseurl+"/index.php?p=message/ajax_list_output/"+$("#msgsend").attr("uid"),
		  function(data){
		  	if (data.length != $("#chatlist").html().length) {
			  	$("#chatlist").html(data);
			  	$("#chatlist").scrollTop($("#chatlist").prop("scrollHeight"));
			  }
			},"html"
		);
	}

	$('#chatModal').on('shown.bs.modal', function (e) {
		$("#msgcontent").focus();
		$("#chatlist").scrollTop($("#chatlist").prop("scrollHeight"));
	});
	$('#chatModal').on('hide.bs.modal', function (e) {
		window.clearInterval(chatupdatehandle);
	});
	if ($("#jcow_msg_new").is(":empty")) {
		$("#jcow_msg_new").hide();
	}
	if ($("#jcow_note_new").is(":empty")) {
		$("#jcow_note_new").hide();
	}
	$("#jcow_note_new").bind("DOMSubtreeModified",function(){
		if ($(this).is(":empty")) {
			$(this).hide();
		}
		else {
			$(this).show();
		}
	});
	$("#jcow_msg_new").bind("DOMSubtreeModified",function(){
		if ($(this).is(":empty")) {
			$(this).hide();
		}
		else {
			$(this).show();
		}
	});

	$("#msgcontent").keypress(function(e) {
		if(e.which == 13) {
			$("#msgsend").click();
		}
	});

	$(document).on("click",".ajax_post", function() {
		var btn = $(this);
		var text = btn.html();
		if (btn.attr("disabled")) {
			return false;
		}
		console.log('ap');
		
		btn.attr("disabled", "disabled")
		btn.html('<i class=\"fa fa-spinner fa-pulse fa-fw\"></i>');
		setTimeout(function() {
			btn.html(text);
			btn.attr("disabled", false)
		},1000)
		
		var data = $(this).data();
		$.post(data.url,
			data,
		  function(res){
		  	console.log(res);
		  	if (res.status == 'ok') {
			  	if (res.act == 'url') {
			  		window.location.href = res.url;
			  	}
			  }
			else {
				alert(res.message);
				btn.html(text);
				btn.attr("disabled", false)
			}
			},"json"
		).fail(function(response) {
		    console.log(response.responseText);
		    btn.html(text);
			btn.attr("disabled", false)
		});
		
		return false;
	})

	$(document).on("click","#msgsend",function() {
		var message = $("#msgcontent");
		var uid = $(this).attr("uid");
		if (!message.val().length) {
			message.focus();
			message.fadeOut(100).fadeIn(100).fadeOut(100).fadeIn(100);
			return false;
		}
		$("#chatopt").hide();
		$("#chatloading").html("<i class=\"fa fa-spinner fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=message/ajax_post",
		{uid:uid,text:message.val()},
		  function(data){
		  	message.val("");
		  	$("#chatloading").html("");
		  	$("#chatopt").show();
		  	$("#chatlist").html(data);
		  	$("#chatlist").scrollTop($("#chatlist").prop("scrollHeight"));
			},"html"
		);
		return false;
	});


	$("a[href$=notifications]").click(function() {
		var link = $(this);
	    var dialog = $("#notificationbox");
	    if (!dialog.is(":visible")) {
	    	$("#jcow_note_new").html("");
	    	dialog.html("<center><i class=\"fa fa-2x fa-spinner fa-spin\"></i></center>");
		    dialog.css("top", link.position().top + 30);
		    dialog.css("left", link.position().left - 305);
		    dialog.css("position", "fixed");
		    $.post($baseurl+"/index.php?p=notifications/ajax",
			  function(data){
				dialog.html(data);
				},"html"
			);
		    dialog.show();
		}
		return false;
	});
	$(".up_msg").click(function() {
		var link = $(this);
	    var dialog = $("#notificationbox");
	    if (!dialog.is(":visible")) {
	    	$("#jcow_msg_new").html("");
	    	dialog.html("<center><i class=\"fa fa-2x fa-spinner fa-spin\"></i></center>");
		    dialog.css("top", link.position().top + 30);
		    dialog.css("left", link.position().left - 305);
		    dialog.css("position", "fixed");
		    $.post($baseurl+"/index.php?p=message/ajax_note",
			  function(data){
				dialog.html(data);
				},"html"
			);
		    dialog.show();
		}
		return false;
	});



	$(document).on("click",".quick_comment",function() {
		var ubox = $(this).closest(".block_content");
		ubox.find(".quick_comment_form").css("display","block");
		var scbox = ubox.find(".commentmessage");
		if (!scbox.val().length && $(this).attr("uname").length) {
			scbox.focus().val( "@"+$(this).attr("uname")+" ");
		}
		else {
			scbox.focus();
		}
		scbox.next().show();
		return false;
			
	});
	$(document).on("click",".stream_hot_btn",function() {
		var sid = $(this).attr("sid");
		cbox = $(this).parent();
		cbox.html("<i class=\"fa fa-spinner fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=jquery/stream_hot_btn",
		{sid:sid},
		  function(data){
			cbox.html(data);
			},"html"
		);
		return false;
	});
	$(document).on("click",".story_feature_btn",function() {
		var sid = $(this).attr("sid");
		cbox = $(this).parent();
		cbox.html("<i class=\"fa fa-spinner fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=jquery/story_feature_btn",
		{sid:sid},
		  function(data){
			cbox.html(data);
			},"html"
		);
		return false;
	});
	$(document).on("click",".quick_reply",function() {
			var qcform = $(this).parents(".user_comment").parent().find(".quick_comment_form");
			qcform.css("display","block");
			var scbox = qcform.find(".commentmessage");
			if ($(this).attr("uname").length) {
				scbox.focus().val( "@"+$(this).attr("uname")+" ");
			}
			else {
				scbox.focus().val("");
			}
			return false;
			
	});
	$(document).on("click",".commentmessage",function() {
		return false;
			if (!$(this).val().length && $(this).attr("uname").length) {
				$(this).val( "@"+$(this).attr("uname")+" ");
			}
			return false;
			
	});
	$(document).on("click",".comment_smile_btn",function() {
		var cmt = $(this).prev();
		$(document).find(".jcow_live_cmt").removeClass("jcow_live_cmt");
		cmt.addClass("jcow_live_cmt");
		if (!cmt.val().length && cmt.attr("uname").length) {
			cmt.val( "@"+cmt.attr("uname")+" ");
		}
		if (!$(this).hasClass("smile_atd")) {
			$(this).popover({ 
			    html : true,
			    placement:"left",
			    trigger:"focus",
			    content: function() {
			      return $("#jcow_smile_opt").html();
			    }
			  }).popover("show");
			$(this).addClass("smile_atd");
		}
		return false;
	});
	$(document).on("click",".jcow_emoji",function() {
		var cmt = $(document).find(".jcow_live_cmt");
		cmt.focus().val(cmt.val()+" emoji"+$(this).attr("eid")+" ");
	});
	
	$(document).mouseup(function (e) {
	    var container = $("#notificationbox");
	    if (!container.is(e.target) && container.has(e.target).length === 0) {
	        container.hide();
	    }
	    if (!$("#searchbar").is(e.target)) {
	        $("#searchresultbox").hide();
	    }
	});

	$(document).keypress(function(e) {
	  if(e.which == 13) {
	  	if ($(e.target).hasClass("commentmessage")) {
	   		var thiscomment = $(e.target).parents(".quick_comment_form");
			var thisform = $(e.target).parents(".jcow_comment_box");
			var mbox = thiscomment.find(".commentmessage");
			if (mbox[0].value != "") {
				thiscomment.hide();
				var cbox = thiscomment.next().next();
				var tbox = thiscomment.next();
				var img_token = thiscomment.find(".img_pre").attr("token");
				cbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
				$.post($baseurl+"/index.php?p=jquery/comment_publish",
				{text:mbox[0].value,target_id:tbox[0].value,img_token:img_token},
				  function(data){
					cbox.html("");
					thisform.before(data);
					mbox.val("");
					init_story_img_thumb();
					},"html"
				);
				return false;
			}
	   	}
	  }
	});
	$(document).on("click",".jcow-btn-disabled",function() {
		return false;
	});
	$(document).on("click",".jcow-btn-post",function() {
		console.log('clicked');
		var confirm_msg = $(this).attr("confirm_msg");
		if (confirm_msg) {
			r = confirm(confirm_msg);
			if (!r) {
				return false;
			}
		}
		var btn = $(this);
		btn.append('<i class="fa fa-spinner fa-lg fa-spin"></i>');
		btn.removeClass("jcow-btn-post");
		btn.addClass("jcow-btn-disabled");
		var q = {};
		var aq = $(this).attr("q");
		if (aq != undefined && aq) {
			try {
				q = JSON.parse(aq);
			}
			catch(e) {
				console.log('json err:',e)
			}
		}
		var action = $(this).attr("action");
		$.post(action, q, function(data) {
			btn.find(".fa-spinner").remove();
			if (data.status == 'ok') {
				console.log("done!");
				if (typeof data.item_action == 'object') {
					handle_item_action(data.item_action);
				}
				if (data.btn_message) {
					btn.replaceWith(data.btn_message)
				}
				if (btn.attr("post_title")) {
					btn.html( btn.attr("post_title") );
				}
				else {
					btn.html("done");
				}
				if (data.act == 'remove_section') {
					btn.closest(".block").slideUp();
				}
			}
			else {
				btn.removeClass("jcow-btn-disabled");
				btn.addClass("jcow-btn-post");
				alert('something wrong'+data.msg);
			}
		},"json").fail(function(xhr) {
        console.log('e:', xhr['responseText']);
    });
		return false;
	});

	function handle_item_action(action) {
		console.log('action:', action.type);
		switch(action.type) {
			case 'hide':
				console.log('hide item',action.key);
				$(document).find("#"+action.key).slideUp();
				break;
		}
	}

	$(document).on("click",".signup_btn",function() {
		$('#signupform_msg').hide();
		$('#signupform').modal('show');
		return false;
	});
	$(document).on("click",".signup_btn_ref",function() {
		$('#signupform_msg').show()
		$('#signupform').modal('show');
		return false;
	});

	$(document).on("click",".stream_delete",function() {
		var parentdd = $(this).parents(".user_post_1");
		var sid = $(this).attr("sid");
		$(this).after("<i class=\"fa fa-spinner fa-lg fa-spin\"></i> deleting..");
		$(this).hide();
		$.get($baseurl+"/index.php?p=jquery/stream_delete/"+sid, function(data) {
			parentdd.hide("slow");
		});
		return false;
	});

	$(document).on("click",".comment_delete",function() {
		var parentdd = $(this).parents(".user_comment");
		var cid = $(this).attr("cid");
		$(this).after("<i class=\"fa fa-spinner fa-lg fa-spin\"></i> deleting..");
		$(this).hide();
		$.get($baseurl+"/index.php?p=jquery/comment_delete/"+cid, function(data) {
			parentdd.hide("slow");
		});
		return false;
	});
	
	
	$(document).on("click",".dolike",function() {
		var cbox = $(this).parent();
		var sid = $(this).attr("sid");
		cbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=jquery/dolike",
		{target_id:sid},
		  function(data){
			cbox.html("");
			cbox.html(data);
			},"html"
		);
		return false;
	});
	$(document).on("click",".dodislike",function() {
		var cbox = $(this).parent();
		var sid = $(this).attr("sid");
		$(this).parent().css("display","none");
		cbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=jquery/dodislike",
		{target_id:sid},
		  function(data){
			cbox.html("");
			cbox.html(data);
			},"html"
		);
		return false;
	});

	$(".dofollow").click(function() {
		var page_id = $(this).attr("page_id");
		var tbox = $(this).parent();
		tbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=follow/dofollow",
		{pageid:page_id},
		  function(data){
			tbox.html("");
			tbox.html(data);
			$("a[page_id="+page_id+"]").hide();
			},"html"
		);
		return false;
	});
	$(".tag_follow").click(function() {
		var tid = $(this).attr("tid");
		var tbox = $(this).parent();
		tbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=hashtags/follow",
		{tid:tid},
		  function(data){
			tbox.html("");
			tbox.html(data);
			$("a[tid="+tid+"]").hide();
			},"html"
		);
		return false;
	});
	$(".tag_unfollow").click(function() {
		var tid = $(this).attr("tid");
		var tbox = $(this).parent();
		tbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=hashtags/unfollow",
		{tid:tid},
		  function(data){
			tbox.html("");
			tbox.html(data);
			$("a[tid="+tid+"]").hide();
			},"html"
		);
		return false;
	});
	$(".doadd").click(function() {
		var userid = $(this).attr("userid");
		var tbox = $(this).parent();
		tbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=friends/ajax_add",
		{userid:userid},
		  function(data){
			tbox.html(data);
			$("a[userid="+userid+"]").hide();
			},"html"
		);
		return false;
	});
	$(document).on("click",".events_engage",function() {
		var sid = $(this).attr("eventid");
		var engage = $(this).attr("engage");
		var tbox = $(this).parent();
		$("a[eventid="+sid+"]").hide();
		tbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=events/ajax_engage",
		{sid:sid,engage:engage},
		  function(data){
			tbox.html(data);
			},"html"
		);
		return false;
	});
	$(document).on("click",".join_group",function() {
		var gid = $(this).attr("groupid");
		var tbox = $(this).parent();
		$("a[groupid="+gid+"]").hide();
		tbox.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i>");
		$.post($baseurl+"/index.php?p=groups/ajax_join",
		{gid:gid},
		  function(data){
			tbox.html(data);
			},"html"
		);
		return false;
	});

	$(".menu li.menugen").mouseover(function() {
		$(this).removeClass("menugen");
		$(this).addClass("menuhover");
	});
	$(".menu li.menugen").mouseout(function() {
		$(this).removeClass("menuhover");
		$(this).addClass("menugen");
	});
	$("a[rel*=facebox]").facebox();
	$(document).on("click",".deleteuser",function() {
		uid = $(this).attr("uid");
		$.facebox({ ajax: $baseurl+"/index.php?p=jquery/deleteuser/"+uid });
		return false;
	});
	$(document).on("click",".stream_opt",function() {
		$(this).hide();
		$(this).prev().slideDown();
	});
	$(".jcow_buttonflag").click(function() {
		$(this).prev().click();
	});
	$(".jcow_buttonflag").css("cursor","pointer");
	$(document).on("click", ".jcow_ajax_btn", function() {
		var act = $(this).attr("act");
		var btn = $(this);
		btn.prop('disabled', true);
		btn.html("<i class=\"fa fa-spinner fa-spin\"></i>");
		$.get(act, function(data) {
			if (data.length < 50) {
				btn.html(data);
			}
			else {
				console.log(data);
			}
		})
	});

	$("#privacy_selector_public").click(function() {
				$("#privacy_input").val("1");
				$(this).hide();
				$(document).find(".share_tags").slideUp();
				$("#privacy_selector_friends").fadeIn("slow");
				return false;
			});
			$("#privacy_selector_friends").click(function() {
				$("#privacy_input").val("0");
				$(this).hide();
				$(document).find(".share_tags").slideDown();
				$("#privacy_selector_public").fadeIn();
				return false;
			});
			
			$(document).on("keyup",".form_message",function() {
				var rbox = $(this).closest(".jcow_share_box").find(".charsRemaining");
				var form_message = $(this);
				var max = parseInt($(this).attr("maxlength"));
				if($(this).val().length > max){
					$(this).val($(this).val().substr(0, $(this).attr("maxlength")));
				}
				if($(this).val().length > 0) {
					rbox.html("You have <strong>" + (max - $(this).val().length) + "</strong> characters remaining");
				}
				else {
					rbox.html("");
				}
			});
			$(document).on("click",".sbl_live",function() {
				$(this).closest(".jcow_share_box").find(".form_message").focus();
				return false;
			});
			$(document).on("click",".sbl_gen",function() {
				if ($(this).closest(".jcow_share_box").find(".form_message").val().length) {
					var res = confirm("discard status editing?");
					if (res) {
						return true;
					}
					else {
						return false;
					}
				}
			});
			$("#status_photo_button").click( function() {
				$(this).hide();
				$("#status_photo_file").attr("disabled",false);
				$("#status_photo_box").show();
				$("#status_photo_file").click();
				return false;
			});
			$("#status_photo_cancel").click( function() {
				$("#status_photo_file").attr("disabled",true);
				$("#status_photo_box").hide();
				$("#status_photo_button").show("fast");
				return false;
			});
			$("#status_photo_file").bind("change", function() {
				var extension = this.files[0].name.substr( (this.files[0].name.lastIndexOf('.') +1) );
				extension = extension.toLowerCase();
				if (extension != "jpg") {
					$("#status_photo_file").attr("disabled",true);
					$("#status_photo_box").hide();
					$("#status_photo_button").show();
					alert("Sorry, only JPG file is accepted");
					return false;
					}
			});

			$("#cancel_form").click(function() {
				$("#stream_att").show();
			});

			$(document).on("click",".youtube-btn",function() {
				var youtubeid = $(this).attr("youtubeid");
				$(this).removeClass("youtube-btn");
		        $(this).html("<iframe  src='//www.youtube.com/embed/"+youtubeid+"?autoplay=1' frameborder='0' allowfullscreen></iframe>");
			});
			$("#searchbar_btn").click(function() {
				$("#searchform").submit();
			});
			$(".top_search_box").on("shown.bs.dropdown", function(){
				$("#top_search_input").focus();
			});

			function clear_link_preview() {
				$("#link_title").val("");
				$("#link_url").val("");
				$("#link_image").val("");
				$("#link_des").val("");
				$("#link_status").val("");
				$("#link_preview").html("");
				$("#link_remove").hide();
			}

			$("#link_remove").click(function() {
					clear_link_preview();
					$(".jcow_sf_img_btn").show();
					$(".jcow_sf_video_btn").show();
					return false;
				});
	$(".form_message").on("paste",function() {
		if (previewlink && !$("#quick_img_file").val() && $("#link_status").val() != "shown") {
			$("#quick_img").hide();
			setTimeout(function() {
				var match_url = /\b(https?):\/\/([\-A-Z0-9.]+)(\/[\-A-Z0-9+&@#\/%=~_|!:,.;]*)?(\?[\-A-Z0-9+&@#\/%=~_|!:,.;]*)?/i;
			    if (match_url.test($(".form_message").val())) {
					var url = $(".form_message").val().match(match_url)[0];
					console.log('url:',url);
					$("#link_loading").html("<i class=\"fa fa-spinner fa-pulse fa-3x fa-fw\"></i>");
					var r_url = $baseurl+"/index.php?p=jquery/get_url_content&u="
			          + encodeURIComponent(url);
			        console.log(r_url);
					$.getJSON(r_url
				 	 , function(data) {
				 	 	$("#link_loading").html("");
				 	 	if (data.status != 'ok') {
				 	 		console.log(data.msg);
				 	 		return;
				 	 	}
				 	 	if (data.json) {
				 	 		var j = JSON.parse(data.json);
				 	 		update_preview_box({url:url, title:j.title,image:j.thumbnail_url});
				 	 		return;
				 	 	}
				 	 	var s = $("<html/>").append(data.html);
				 	 	var og_title = s.find('meta[property="og:title"]').attr("content");
				 	 	var og_image = s.find('meta[property="og:image"]').attr("content");
				 	 	var og_des = s.find('meta[property="og:description"]').attr("content");
						
				 	 	$("#link_loading").html("");
				      if (og_title && og_title.length > 0) {
				      	update_preview_box({url:url, title:og_title,image:og_image,des:og_des})
				      } else {
				      	console.log(data)
				      };
					});
				}
			},500);
		}
	});

	function update_preview_box(opt) {
		console.log("ogtitle:"+opt.title);
		console.log("ogimage:"+opt.image);
		console.log("og_des:"+opt.des);
		$(".jcow_sf_img_btn").hide();
      	$(".jcow_sf_video_btn").hide();
      	$("#link_remove").show();
      	$("#link_title").val(opt.title);
      	$("#link_url").val(opt.url);
        if (opt.image && opt.image.length > 0) {
        	$("#link_preview").append("<img src=\""+opt.image+"\" style=\"width:100%;height:auto\" />");
        	$("#link_image").val(opt.image);
        }
        $("#link_preview").append("<h3>"+opt.title+"</h3");
        if (opt.des && opt.des.length > 0) {
        	$("#link_preview").append("<div class=\"sub\">"+opt.des+"</div>");
        	$("#link_des").val(opt.des);
        	$("#link_status").val("shown");
        }
	}

	var search_xhr;
	$("#searchbar").keyup(function() {
		var search = $(this);
		if (search.val().length>0) {
			clearTimeout(search_xhr);
			search_xhr = setTimeout(function() {
			    var dialog = $("#searchresultbox");
		    	$("#sr_spin").html("<center><i class=\"fa fa-2x fa-spinner fa-spin\"></i></center>");
		    	dialog.width( search.width());
			    dialog.css("top", $("#searchform").position().top + 30);
			    dialog.css("left", $("#searchform").position().left);
			    dialog.show();
			    $.get( "index.php?p=search/ajax_search&q="+search.val(), function( data ) {
			    	$("#sr_spin").html("");
				  $("#sr_results").html( data);
				});
			},500);
		}
	});

	$(document).on("click",".form_submit",function() {
		var sharebox = $(this).closest(".jcow_share_box");
		var form_message = sharebox.find(".form_message");

		if (!$.trim(form_message.val()) && !sharebox.find(".img_pre").length) {
			form_message.fadeOut(100).fadeIn(100).fadeOut(100).fadeIn(100);
			return false;
		}
		sharebox.find(".spanstatus").html("<i class=\"fa fa-spinner fa-pulse fa-3x fa-fw\"></i>");
		sharebox.find(".jcow_share_box_content").slideUp();
		var img_tokens = '';
		sharebox.find(".img_pre").each(function() {
			img_tokens = img_tokens+','+$(this).attr("token");
			$(this).remove();
		});
		video_token = sharebox.find(".video_token").val();
		$.ajax({
		       url: $baseurl+"/index.php?p=streampublish",
		       type : "POST",
		       data : {
		       		status_text:sharebox.find(".form_message").val(),
		       		home_page_id:sharebox.find(".home_page_id :selected").val(),
		       		img_tokens:img_tokens,
		       		video_token:video_token,
		       		page_id:sharebox.find(".page_id").val(),
		       		checkin_name:sharebox.find(".autocompleteinput").val(),
		       		video_url:sharebox.find(".video_input").val(),
		       		link_url:$("#link_url").val(),
		       		link_title:$("#link_title").val(),
		       		link_image:$("#link_image").val(),
		       		link_des:$("#link_des").val()
		   		},
		       success : function(data) {
		       		sharebox.find(".form_message").val("");
		       		sharebox.find(".form_message").css("height","52px");
		       		sharebox.find(".charsRemaining").html("");
		       		sharebox.find(".checkin_name").val("");
		       		sharebox.find(".video_input").val("");
		       		sharebox.find(".spanstatus").html("");
		       		sharebox.find(".video_upload_msg").html("");
		       		sharebox.find(".video_preview").hide();
		       		sharebox.find(".jcow_sf_video_btn").removeClass("att_btn_on");
		       		sharebox.find(".jcow_sf_checkin_btn").removeClass("att_btn_on");
		       		sharebox.find(".jcow_sf_img_btn").show();
					sharebox.find(".jcow_sf_video_btn").show();
					sharebox.find(".form_submit_box").hide();
		       		clear_link_preview();
		       		sharebox.closest(".block").after("<div class=\"block\"><div class=\"block_content\">"+data+"</div></div>");
		       		sharebox.find(".jcow_share_box_content").slideDown(function() {
		       			init_story_img_thumb();
		       		});
		       		//obj = $.parseJSON(data);
		       }
		});

	});
	$(document).on("focus",".form_message",function() {
		var sharebox = $(this).closest(".jcow_share_box");
		sharebox.find(".form_submit_box").fadeIn();
		if (!$(this).val().length) {
			$(this).val(
				sharebox.find(".preset").val()
				);
		}
	});
	$(document).on("click", ".commentpic_btn", function(e) {
		var quick_comment_form = $(this).closest(".quick_comment_form");
		var img_type = quick_comment_form.find(".img_type").val();
		if (!$images_enabled) {
			alert('"Images" module not enabled');
			return false;
		}
		quick_comment_form.find(".cmt_img").click();
		return false;
	});
	$(document).on("change", ".video_upload", function() {
		var share_box = $(this).closest(".jcow_share_box");
		share_box.find(".video_preview").show();
		share_box.find(".jcow_sf_video_btn").hide();
		share_box.find(".jcow_sf_img_btn").hide();
		if ($(this)[0].files[0].size > 1024*1024*$max_video_size) {
			alert('Please upload video that less than ' + $max_video_size + ' Mb' );
			share_box.find(".video_preview").hide();
			share_box.find(".jcow_sf_img_btn").show();
			share_box.find(".jcow_sf_video_btn").show();
			video_input.val("");
			return false;
		}
		share_box.find(".form_submit").prop("disabled",true);
		var form1 = share_box.find('form');
		var form_data = new FormData(form1[0]);
		var pgs = share_box.find('progress');
		var video_upload_msg = share_box.find(".video_upload_msg");
		$.ajax({
	        // Your server script to process the upload
	        url: "index.php?p=jquery/uploadvideo",
	        type: 'POST',
	        data: form_data,
	        cache: false,
	        contentType: false,
	        processData: false,
	        xhr: function() {
	            var myXhr = $.ajaxSettings.xhr();
	            if (myXhr.upload) {
	                // For handling the progress of the upload
	                myXhr.upload.addEventListener('progress', function(e) {
	                    if (e.lengthComputable) {
	                        pgs.attr({
	                            value: e.loaded,
	                            max: e.total,
	                        });
	                    }
	                } , false);
	            }
	            return myXhr;
	        },
	        success     : function(data, textStatus, jqXHR){
            	video_upload_msg.html(data);
            	share_box.find(".form_submit").prop("disabled",false);
       		},
       		error: function (rezzzzzzzzzz, status, error) {
		        console.log(request.responseText);
		        console.log(error);
		        share_box.find(".form_submit").prop("disabled",false);
		    }
		});
	});
	$(document).on("change", ".cmt_img", function() {
		for(var i=0; i< this.files.length; i++){
			var file = this.files[i];
			var commentbox = $(this).closest(".quick_comment_form");
			var img_type = commentbox.find(".img_type").val();
			var page_id = commentbox.find(".page_id").val();
			var previewbox = commentbox.find(".cmt_img_preview");
			var ext = $(this).val().split(".").pop().toLowerCase();
			if (ext != "jpg" && ext != "gif" && ext != "png" && ext != "jpeg") {
				alert("Please select jpg/gif/png file"+ext);
				return false;
			}
			if (file.size > 1024*1024*100) {
				alert("Please select file less than 100M");
				return false;
			}
			commentbox.find(".commentpic_btn").hide();

			var formData = new FormData();
			formData.append("file", file);
			formData.append("img_type", img_type);
			formData.append("page_id", page_id);
			previewbox.append("<div  class=\"img_pre img_loading\"><i class=\"fa fa-spinner fa-pulse fa-3x fa-fw\"></i></div>");
			$.ajax({
			       url: "index.php?p=jquery/uploadimg",
			       type : "POST",
			       data : formData,
			       processData: false,
			       contentType: false,
			       success : function(data) {
			       		previewbox.find(".img_loading").remove();
			       		try {
						  obj = $.parseJSON(data);
						  console.log('obj:',obj)
						}
						catch (err) {
						  alert(data)
						}
						if (img_type == 'cover') {
							console.log("set bg:", obj.data.uri);
							$(".jcow_cover_content").css("background-image","url("+obj.data.uri+")");
							$(".jcow_cover_content").css("background-size","cover");
						}
						else if (img_type == 'logo' ) {
							console.log("set bg:", obj.data.uri);
							$("#jcow_cover_avatar").find("a").html("<img src='"+obj.data.uri+"' width='160' height='auto' />");
						}
						else {
				           previewbox.append("<div class=\"img_pre\" token=\""+obj.data.token+"\"><img src=\""+obj.data.thumb+"\" /><a href=\"#\" class=\"cmt_img_pre_remove\"><i class=\"fa fa-remove\"></i> Remove</a></div>");
				           commentbox.find(".commentmessage").click();
				           commentbox.find(".commentmessage").focus();
				        }

			       }
			});
		}
	});
	$(document).on("click",".cmt_img_pre_remove",function() {
		var commentbox = $(this).closest(".quick_comment_form");
		$(this).closest(".img_pre").remove();
		commentbox.find(".commentpic_btn").show();
		return false;
	});

	$(document).on("click", ".jcow_sf_img_btn", function() {
		if (!$images_enabled) {
			alert('"Images" module not enabled');
			return false;
		}
		$(this).closest(".jcow_share_box").find(".form_submit_box").show();
		$(this).closest(".jcow_share_box").find(".jcow_sf_img").click();
		return false;
	});
	$(document).on("change", ".jcow_sf_img", function() {
		var inputfile = this;
		for(var i=0; i< this.files.length; i++){
			var file = this.files[i];
			var sharebox = $(this).closest(".jcow_share_box");
			var previewbox = sharebox.find(".img_preview");
			var ext = $(this).val().split(".").pop().toLowerCase();
			if (ext != "jpg" && ext != "gif" && ext != "png" && ext != "jpeg") {
				alert("Please select jpg/gif/png file"+ext);
				return false;
			}
			if (file.size > 1024*1024*$max_photo_size) {
				alert("Please select file less than "+$max_photo_size+" Mb");
				return false;
			}
			maxnum = 10;
			sharebox.find(".jcow_sf_video_btn").hide();
			var thisbtn = sharebox.find(".jcow_sf_img_btn");
			if (thisbtn.attr("maxnum")) {
				maxnum =thisbtn.attr("maxnum");
			}
			var img_num = previewbox.find(".img_pre").length + 1;
			console.log(thisbtn.attr("maxnum"),img_num);
			if (img_num >= maxnum) {
				thisbtn.hide();
			}
			var formData = new FormData();
			formData.append("file", file);
			previewbox.append("<div  class=\"img_pre img_loading\"><i class=\"fa fa-spinner fa-pulse fa-3x fa-fw\"></i></div>");
			$.ajax({
			       url: "index.php?p=jquery/uploadimg",
			       type : "POST",
			       data : formData,
			       processData: false,  
			       contentType: false,
			       success : function(data) {
			       		previewbox.find(".img_loading").remove();
			       		try {
						  obj = $.parseJSON(data);
						  if (obj.status != 'ok') {
						  	alert(obj.msg);
						  	return false;
						  }
						}
						catch (err) {
						  alert(data)
						}
			       		inputfile.value="";

			           previewbox.append("<div class=\"img_pre\" token=\""+obj.data.token+"\"><img src=\""+obj.data.thumb+"\" /><a href=\"#\" class=\"img_pre_remove\"><i class=\"fa fa-remove\"></i> Remove</a></div>");
			           if (fbody = sharebox.parents(".ajaxform").find(".form_content")) {
			           	fbody.val( fbody.val() + "\n" + "{image"+img_num+"}");
			           }
			       }
			});
		}
	});
	
	$(document).on("click",".img_pre_remove",function() {
		var sharebox = $(this).closest(".jcow_share_box");
		$(this).closest(".img_pre").remove();
		if (sharebox.find(".img_pre").length <= 3) {
			sharebox.find(".jcow_sf_img_btn").show();
		}
		if (!sharebox.find(".img_pre").length) {
			sharebox.find(".jcow_sf_video_btn").show();
		}
		return false;
	});
	$(document).on("click",".test_img",function() {
		$(this).closest(".jcow_share_box").find(".img_pre").each(function() {
			$(".img_preview").append("<br />"+$(this).attr("token"));
		});
		return false;
	});
	$(document).on("click",".jcow_sf_checkin_btn",function() {
		$(this).closest(".jcow_share_box").find(".form_submit_box").show();
		var checkin_input = $(this).closest(".jcow_share_box").find(".checkin_preview");
		var checkin_btn = $(this);
		checkin_input.slideToggle("fast",function() {
			if (checkin_input.is(":visible")) {
				checkin_input.find("input").focus();
				checkin_btn.addClass("att_btn_on");
			}
			else {
				checkin_btn.removeClass("att_btn_on");
				checkin_input.val("");
			}
		});
		return false;
	});

	$(document).on("click",".jcow_sf_video_btn",function() {
		var share_box = $(this).closest(".jcow_share_box");
		share_box.find(".form_submit_box").show();
		share_box.find(".video_upload").click();
		return false;
	});

	$(document).on("submit",".ajaxform",function() {
		var thisform = $(this);
		var formData = new FormData();
		$.each($(this).find("input[type='file']"), function(i, tag) {
        	$.each($(tag)[0].files, function(i, file) {
	            formData.append(tag.name, file);
	        });
	    });
	    var params = $(this).serializeArray();
	    $.each(params, function (i, val) {
	        formData.append(val.name, val.value);
	    });
	    var img_tokens = "";
	    $(this).find(".img_pre").each(function() {
			img_tokens = img_tokens+','+$(this).attr("token");
		});
		formData.append("img_tokens", img_tokens);
		formData.append("is_ajax",'1');
		if (quill && quill.root.innerHTML) {
			formData.append("form_content",quill.root.innerHTML);
		}
		var action = $(this).attr("action");
		if (!action.match(/index\.php/) && !action.match(/^http/) ) {
			action = $baseurl+'/index.php?p='+action;
		}
		var btn = $(this).find("[type=submit]");
	    $.ajax({
	        url: action,
	        type: 'POST',
	        data: formData,
	        async: false,
	        cache: false,
	        dataType: "json",
	        processData: false,
	        contentType: false,
	        async: true,
	        beforeSend: function() {
	        	$("#overlay").show();
	        },
	        success: function (data) {
	        	console.log('data:',data);

	        	$("#overlay").hide();
	        	if (data.url && !data.url.match(/^http/)) {
	        		data.url = $ubase +  data.url;
	        	}
	        	if (data.act == 'redirect') {
	        		if (!data.url) {
	        			alert('no url');
	        			return false;
	        		}
	        		window.location.href = data.url;
	        	}
	        	else if (data.act == 'push') {
	        		window.location.href = $ubase + data.uri;
	        	}
	        	else if (data.act == 'reload') {
	        		window.location.reload(); 
	        	}
	        	else {
	        		thisform.find(".alert-danger").remove();
		        	btn.before('<div class="alert alert-danger" role="alert">'+data.msg+'</div>');
		        }
	        },
	        error: function(data) {
	        	$("#overlay").hide();
	        	console.log('action:',action,'text:',data.responseText);
	        	thisform.find(".alert-danger").remove();
	        	if (data.responseText.length < 200) {
			        btn.before('<div class="alert alert-danger" role="alert">'+data.responseText+'</div>');
			    }
	        }
	        
	    });
	    return false;
	});

	$(document).on("click",".morestream_button",function() {
		var morestream_box = $(this).closest(".morestream_box");
		$(this).remove();
		var stream_type = $(this).attr("stream_type");
		var stream_num = $(this).attr("stream_num");
		var stream_offset = $(this).attr("stream_offset");
		var target_id = $(this).attr("target_id");
		var tag_id = $(this).attr("tag_id");

		morestream_box.html("<i class=\"fa fa-spinner fa-lg fa-spin\"></i> loading..");
		$.post($baseurl+"/index.php?p=feed/feedmoreactivities",
					{offset:stream_offset,type:stream_type,num:stream_num,target_id:target_id,tag_id:tag_id},
					  function(data){
						morestream_box.closest(".block").before(data);
						morestream_box.closest(".block").remove();
						init_story_img_thumb();
						},"html"
					);
		return false;
	});

	$(document).on('click','.copytext', function() {
		var btn = $(this);
		var text = $(this).prev();
		text.select();
		document.execCommand("copy");
		btn.after('<div>Copied!</div>');
		setTimeout(function(){
			btn.next().fadeOut();
		},500);
	});
	$(document).on('click','.textstring', function() {
		$(this).select();
	});
	
	$(window).bind("scroll", function () {
		if( $(".morestream_button").is(":visible") && $(".morestream_button").attr("stream_offset") < 20) {
			if (  $(window).scrollTop() > ($(".morestream_button").offset().top - $(window).height() )   ) {
				$(".morestream_button").click();
			}
		}
	});

	$(document).on("click",".jcow_btn",function() {
		var url = $(this).attr("href");
		var btn = $(this);
		btn.removeAttr("href");
		btn.removeClass("jcow_btn");
		btn.html("<i class=\"fa fa-spinner fa-spin\"></i>");
		$.ajax({
			url:url,
			success:function(data) {
				btn.html(data);
			}
		});
		return false;
	});

	function init_story_img_thumb() {
		$(document).find('.story_img_gallery').each(function() {
			$(this).magnificPopup({
				delegate: 'a',
			    type: 'image',
				gallery: {
		          enabled:true
		        }
			});
		});
		$(document).find('.story_img_gallery').removeClass("story_img_gallery");
	}
	init_story_img_thumb();

});


function doModal(title='',Content='') {
    html =  '<div id="dynamicModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="confirm-modal" data-keyboard="false" >';
    html += '<div class="modal-dialog">';
    html += '<div class="modal-content">';
    html += '<div style="height:20px;padding:5px;">';
    html += ' <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
    html += '</div>';
    html += '<div class="modal-body">';
    if (title.length) {
    	html += '<div style="font-size:20px;margin:10px">'+title+'</div>';
    }
    html += Content;
    html += '</div>';
    html += '</div>';  // dialog
    html += '</div>';  // footer
    html += '</div>';  // modalWindow
    $('body').append(html);
    $("#dynamicModal").modal();
    $("#dynamicModal").modal('show');

    $('#dynamicModal').on('hidden.bs.modal', function (e) {
        $(this).remove();
    });
    return false;
}


function ytVidId(url) {
  var p = /^(?:https?:\/\/)?(?:www\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|v\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/;
  var is_youtube_url = (url.match(p)) ? true : false;
  console.log(url, 'is_youtube_url:', is_youtube_url);
  return is_youtube_url;
}


function js_check_all(formobj)
{
	exclude = new Array();
	exclude[0] = 'keepattachments';
	exclude[1] = 'allbox';
	exclude[2] = 'removeall';
	js_toggle_all(formobj, 'checkbox', '', exclude, formobj.allbox.checked);
}

function js_toggle_all(formobj, formtype, option, exclude, setto)
{
	for (var i =0; i < formobj.elements.length; i++)
	{
		var elm = formobj.elements[i];
		if (elm.type == formtype)
		{
			switch (formtype)
			{
				case 'radio':
					if (elm.value == option) 
					{
						elm.checked = setto;
					}
				break;
				case 'select-one':
					elm.selectedIndex = setto;
				break;
				default:
					elm.checked = setto;
				break;
			}
		}
	}
}

function imposeMaxLength(Object, MaxLen)
				{
				  return (Object.value.length <= MaxLen);
				}


function copyToClipboard(text) {
    if (window.clipboardData && window.clipboardData.setData) {
        // Internet Explorer-specific code path to prevent textarea being shown while dialog is visible.
        return window.clipboardData.setData("Text", text);

    }
    else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
        var textarea = document.createElement("textarea");
        textarea.textContent = text;
        textarea.style.position = "fixed";  // Prevent scrolling to bottom of page in Microsoft Edge.
        document.body.appendChild(textarea);
        textarea.select();
        try {
            return document.execCommand("copy");  // Security exception may be thrown by some browsers.
        }
        catch (ex) {
            console.warn("Copy to clipboard failed.", ex);
            return false;
        }
        finally {
            document.body.removeChild(textarea);
        }
    }
}




