<?php
/* ############################################################ *\
 ----------------------------------------------------------------
Jcow Software (http://www.jcow.net)
IS NOT FREE SOFTWARE
http://www.jcow.net/commercial_license
Copyright (C) 2009 - 2019 jcow.net.  All Rights Reserved.
 ----------------------------------------------------------------
\* ############################################################ */

class feed{

	function __construct() {
		global $config;
		$config['hide_ad'] = false;
	}
	
	function index($page = 0) {
		global $sections;
		set_title(t('News feed'));
		enable_jcow_inline_ad();
		global $client,$captcha,$tab_menu, $config;

		//$tab_menu = array();
		if (!$client['id']) {
			if (is_app()) return_loginfail();
			global $content, $db, $apps, $client, $settings,$tab_menu,$parr;
			enable_jcow_inline_ad();

			feed_activity_get(0,15,0,0,1,'latest');
			feed_sidebar();

			stop_here();
		}
		if (!get_gvar('custom_logo') && allow_access(3)) {
			c(url('admin/themes#img','<i class="fa fa-upload"></i> Upload your own site LOGO'));
			section_close();
		}
		if ($client['id'] && $client['disabled']) {
			c(alert_verify());
		}
		if ($client['avatar'] == 'undefined.jpg') {
			$uf[] = url('account/avatar', t('Avatar picture'));
		}


		$res = sql_query("select fid from jcow_friends where uid='{$client['id']}' limit 20");
		while ($row = sql_fetch_array($res)) {
			$uids[] = $row['fid'];
		}
		if (is_array($uids) && count($uids)>0) {
			$i=0;
			$res = sql_query("select distinct f.fid,u.* from jcow_friends as f left join jcow_accounts as u on u.id=f.fid where f.uid in (".implode(',',$uids).") order by u.lastlogin limit 30");
			while ($user = sql_fetch_array($res)) {
				if ($user['id']>0 && $i < 3 && $user['id'] != $client['id']) {
					if (is_custom()) {
						$res2 = sql_query("select * from jcow_followers where uid='{$client['id']}' and fid='{$user['id']}' ");
						if (!sql_counts($res2) ) {
							if ($user['avatar']) {
								$user['avatar'] = correct_avatar_path($user['avatar']);
							}
							$people_suggest .= listing_box(
									array('name'=>h($user['fullname']),'img'=>$user['avatar'],'link'=>url('u/'.$user['username']),'des'=>'<div style="white-space: nowrap;">'.t('{1} mutual friend(s)',$row['num']).'</div><span><a href="#" class="jcow-btn jcow-btn-post jcow-btn-default" post_title="Followed" action="index.php?p=follow/dofollow&uid='.$user['id'].'" ><i class="fa fa-user-plus"></i> '.t('Follow').'</a></span>'
								));
							$i++;
						}
					}
					else {
						$res2 = sql_query("select * from jcow_friends where uid='{$client['id']}' and fid='{$user['id']}' ");
						$res3 = sql_query("select * from jcow_friend_reqs where uid='{$client['id']}' and fid='{$user['id']}' ");
						if (!sql_counts($res2) && !sql_counts($res3)) {
							$res4 = sql_query("select count(*) as num from jcow_friends where uid='{$user['id']}' and fid in 
								(select fid from jcow_friends where uid='{$client['id']}')
								");
							$row = sql_fetch_array($res4);
							if ($user['avatar']) {
								$user['avatar'] = correct_avatar_path($user['avatar']);
							}
							$people_suggest .= listing_box(
									array('name'=>h($user['fullname']),'img'=>$user['avatar'],'link'=>url('u/'.$user['username']),'des'=>'<div style="white-space: nowrap;">'.t('{1} mutual friend(s)',$row['num']).'</div><span><a href="#" class="jcow-btn jcow-btn-post jcow-btn-default" action="index.php?p=friends/ajax_add/'.$user['id'].'" post_title="Request sent"><i class="fa fa-user-plus"></i> '.t('Add Friend').'</a></span>'
								));
							$i++;
						}
					}
				}
			}
		}
		$contribute_btns = [];
		if (module_actived('questions')) {
			$contribute_btns[] = button(['type'=>'link','title'=>t('Ask Question'),'uri'=>'questions/writestory']);
		}
		if (module_actived('blogs')) {
			$contribute_btns[] = button(['type'=>'link','title'=>t('Write Blog'),'uri'=>'blogs/writestory']);
		}
		if (module_actived('events')) {
			$contribute_btns[] = button(['type'=>'link','title'=>t('Start Event'),'uri'=>'events/writestory']);
		}
		if (module_actived('classifieds2')) {
			$contribute_btns[] = button(['type'=>'link','title'=>t('Sell Stuff'),'uri'=>'classifieds2/addlisting']);
		}

		if (get_gvar('points_enabled') && $client['id']) {
			$your_points = 0;
			$point_list = [];
			$res = sql_query("select * from jcow_points where uid='{$client['id']}'");
			while ($row = sql_fetch_array($res)) {
				$your_points += $row['points'];
				$point_list[] = $row['type'].': '.$row['points'].'';
			}
			if ($your_points) {
				$point_lists = '('.implode(', ',$point_list).')';
			}
			ass(array('title'=>t('Your points'),'content'=>'
				Total: <strong>'.$your_points.'</strong> '.$point_lists.'
				'));
		}
		if ($people_suggest) {
			if (is_mobile()) {
				c('<div style="font-weight:bold;color:#999">'.t('People you may know').'</div>'.$people_suggest);
				section_close();
			}
			else {
				ass(array('title'=>t('People you may know'),'content'=>$people_suggest));
			}
		}
		
		$title_color = $config['title_color'] ? $config['title_color'] : '#b8301c';
		new_header(
			Text(get_gvar('site_name'),['style'=>
				style(['font-size'=>'25px','color'=>$title_color])
				])
		,['platforms'=>['app']]);
		new_section(status_form());
		if (count($contribute_btns)) {
			new_section(
				row($contribute_btns, ['style'=>style(['overflow'=>'auto'])] ), 
				['platforms'=>['web']]
			);
			//c(implode($contribute_btns));
			//section_close();
		}
		show_feed('latest');
	}
	function setdefault($filter = 'hot') {
		if (preg_match("/^[a-z]+$/",$filter)) {
			save_u_settings(array('feed_filter'=>$filter));
		}
		redirect(url('feed'));
	}

	function newest() {
		show_feed('newest');
	}
	function following() {
		show_feed('following');
	}

	function explore() {
		global $client;
		$num = 10;
		c(feed_activity_get(0,$num,0,0,1,'hot').' ');
		if (module_actived('topics')) {
			$res = sql_query("select * from jcow_topics  where featured>0 order by stories limit 20");
			while ($tag = sql_fetch_array($res)) {
				$tags .= '<a href="'.url('topics/topic/'.$tag['id']).'" class="jcow_tags">'.h($tag['name']).'</a>';
			}
			ass(array('title'=>url('topics',t('Community tags')),'content'=>$tags));
		}
	}

	function share($stream_id) {
		global $client;
		if (!$client['id']) die('need login');
		// selector
		$res = sql_query("select * from jcow_pages where uid='{$client['id']}' and type='u'");
		$page = sql_fetch_array($res);
		$options .= '<option value="'.$page['id'].'">'.t('My Profile').'</option>';
		$options .= '<optgroup label="Groups">';
		$res = sql_query("select p.* from jcow_page_users as u left join jcow_pages as p on p.id=u.pid where u.uid='{$client['id']}' and p.type='group' order by p.updated DESC limit 100");
		while ($group = sql_fetch_array($res) ) {
			$options .= '<option value="'.$group['id'].'">'.h($group['name']).'</option>';
		}
		$options .= '</optgroup>';
		$options .= '<optgroup label="Pages">';
		$res = sql_query("select p.* from jcow_page_users as u left join jcow_pages as p on p.id=u.pid where u.uid='{$client['id']}' and p.type='page' order by p.updated DESC limit 100");
		while ($page = sql_fetch_array($res) ) {
			$options .= '<option value="'.$page['id'].'">'.h($page['name']).'</option>';
		}
		$options .= '</optgroup>';

		if (is_numeric($stream_id) && $stream_id > 0) {
			$res = sql_query("select s.*,u.username,u.avatar,p.uid as wall_uid from jcow_streams as s left join jcow_accounts as u on u.id=s.uid left join jcow_pages as p on p.id=s.wall_id where s.id='$stream_id' and s.hide!=1 ".sa('s','e'));
			$stream = sql_fetch_array($res);
			$stream['attachment'] = unserialize($stream['attachment']);
			if ($stream['type'] == 1) {
				if (!$client['id']) {
					echo t('Access denied');
					exit;
				}
				$res = sql_query("select * from jcow_friends where uid='{$client['id']}' and fid='{$stream['uid']}'");
				if (!sql_counts($res)) {
					echo t('Access denied');
					exit;
				}
			}
			echo '<div class="block"><div class="block_content">
			<div style="background:#eee">
			Share to: 
				<div style="width:60%;display:inline-block">
				 <select name="pageid" class="input-sm form-control pageid">'.$options.'</select>
				</div>
			
			<textarea class="form-control share_msg" rows=2 placeholder="'.t('Say something about this').'"></textarea>
			</div>
				<div class="stream_quote">
				'.stream_display($stream,'preview',0,0,0,array('share_preview'=>1)).'
				</div>
			<div><button class="btn btn-block btn-primary share_post" sid="'.$stream_id.'">Post</button></div>
			</div></div>';
		}
		else {
			echo 'feed not found';
		}
		exit;
	}

	function sharepost($stream_id) {
		global $client;
		if (!$client['id']) die('need login');
		if (!is_numeric($_POST['pageid'])) die('no pageid');
		if (is_numeric($stream_id) && $stream_id > 0) {
			$res = sql_query("select s.*,u.username,u.avatar,p.uid as wall_uid from jcow_streams as s left join jcow_accounts as u on u.id=s.uid left join jcow_pages as p on p.id=s.wall_id where s.id='$stream_id' and s.hide!=1 ".sa('s','e'));
			$stream = sql_fetch_array($res);
			if (!$stream['id']) die('stream not found');
			$res = sql_query("select * from jcow_pages where id='{$_POST['pageid']}' ".sa('','e'));
			$page = sql_fetch_array($res);
			if (!$page['id']) die('page not found');
			if ($page['type'] == 'u' || $page['type'] == 'page') {
				if ($page['uid'] != $client['id']) {
					die('access denied');
				}
			}
			$new_stream = [
				'message'=>$_POST['msg'],
				'wall_id'=>$_POST['pageid'],
				'uid'=>$client['id'],
				'created'=>time(),
				'app'=>'repost',
				'aid'=>$stream_id,
			];
			sql_insert($new_stream,'jcow_streams');

			echo '<div style="padding:100px 0;text-align:center;font-size:20px;background:#ccc"><i class="fa fa-lg fa-check"></i> Shared successfully!</div>';
		}
		else {
			echo 'feed not found';
		}
		exit;
	}

	function savepages() {
		global $client;
		need_login();
		if (!count($_POST['pageids'])) {
			sys_back('No page selected');
		}
		foreach($_POST['pageids'] as $page_id) {
			$res = sql_query("select * from jcow_pages where id='$page_id'");
			$page = sql_fetch_array($res);
			if ($page['id']) {
				if ($page['type'] == 'u') {
					$res2 = sql_query("select * from jcow_accounts where id='{$page['uid']}'");
					$user = sql_fetch_array($res2);
					if ($user['id']) {
						$res3 = sql_query("select * from jcow_followers where uid='{$client['id']}' and fid='{$user['id']}' limit 1");
						if (!sql_counts($res3)) {
							$follow['uid'] = $client['id'];
							$follow['fid'] = $user['id'];
							sql_insert($follow, tb().'followers');
							sql_query("update jcow_accounts set followers=followers+1 where id='{$user['id']}'");
						}
					}
				}
				else {
					$res2 = sql_query("select * from jcow_page_users where pid='{$page['id']}' and uid='{$client['id']}'");
					if (!sql_counts($res2)) {
						sql_query("insert into jcow_page_users (uid,pid) values ('{$client['id']}','{$page['id']}')");
						sql_query("update jcow_pages set users=users+1 where id='{$page['id']}'");
					}
				}
			}
		}
		redirect('feed',1);
	}

	function mentions() {
		need_login();
		global $content, $db, $apps, $client, $settings;
		$lastread_key = 'feed_mr'.$client['id'];
		$timeline = set_tmp($lastread_key,time());
		$num = 10;
		feed_activity_get($client['id'],$num,0,0,1,'mentions');
		ass(array('title'=>t('My account'),'content'=>dashboard_my_account()));

	}

	function likes() {
		need_login();
		global $content, $db, $apps, $client, $settings;
		$num = 10;
		c(feed_activity_get($client['id'],$num,0,0,1,'likes'));
	}

	function edit($sid) {
		global $client,$miniblog_maximum;
		if (!$client['id']) die("please login");
		if (!is_numeric($sid)) die('no sid');
		$res = sql_query("select * from jcow_streams where id='$sid'");
		$row = sql_fetch_array($res);
		if (!$row['id']) return_err('no sid or access denied');
		if ($row['uid'] != $client['id'] && !allow_access(3)) {
			return_err('access denied');
		}

		if ($_POST['step'] == 'post') {
			if (!$_POST['text'] && $_POST['status_text']) {
				$_POST['text'] = $_POST['status_text'];
			}
			if (is_app()) {
				sql_query("update jcow_streams set message='{$_POST['text']}' where id='$sid'");
				return_ok(['act'=>'goback_refresh','msg'=>t('Saved')]);
			}
			sql_query("update jcow_streams set message='{$_POST['message']}' where id='$sid'");
			if ($row['stuff_id']) {
				$sid = $row['stuff_id'];
			}
			redirect('feed/view/'.$sid, 1);
		}

		if (is_app()) {
			return_data(['feed'=>$row]);
		}

		new_section('<form method="post" action="'.url('feed/edit/'.$sid).'">
			<textarea name="message" class="form-control" maxlength='.$miniblog_maximum.'>'.h($row['message']).'</textarea>
			<input type="submit" class="button" value=" '.t('Save').' " />
			<input type="hidden" name="step" value="post" />
			</form>
			');
		stop_here();
	}

	function view($stream_id=0) {
		global $client;
		if (is_numeric($stream_id) && $stream_id > 0) {
			$res = sql_query("select s.*,u.username,u.avatar,p.uid as wall_uid from jcow_streams as s left join jcow_accounts as u on u.id=s.uid left join jcow_pages as p on p.id=s.wall_id where ".sa('s')." s.id='$stream_id' and s.hide!=1 ");
			$stream = sql_fetch_array($res);
			if (!$stream['id']) return_err('stream no found');
			$stream['attachment'] = unserialize($stream['attachment']);
			if ($stream['type'] == 1) {
				if (!$client['id']) {
					return_err(t('Access denied'));
				}
				if ($client['id'] != $stream['uid']) {
					$res = sql_query("select * from jcow_friends where uid='{$client['id']}' and fid='{$stream['uid']}'");
					if (!sql_counts($res)) {
						return_err(t('Access denied'));
					}
				}
			}
			new_section(stream_display($stream,['comment_num'=>100,'is_detail'=>true],0,0,200));
			$title = utf8_substr($stream['s'],140);
			if ($stream['aid']>0) {
				$res = sql_query("select * from jcow_stories where id='{$stream['aid']}'");
				$row = sql_fetch_array($res);
				if ($row['id']) {
					$title = $row['title'];
					set_story_og_tag($row['id']);
				}
			}
			set_title(h($title));
			render(['comment_form'=>[
				'action'=>'jquery/comment_publish',
				'formParams'=>['target_id'=>$stream['id']]
			]]);
		}
		else {
			return_err('no id');
		}
	}


	function hot($page = 0) {
		show_feed('hot');
	}

	function latest($page = 0) {
		global $content, $db, $apps, $client, $settings,$tab_menu,$parr;
		need_login();
		enable_jcow_inline_ad();
		if ($client['id']) {
			c(stream_form($client['id'],array(),'',array('fromhome'=>1)));
			section_close();
			ass(array('title'=>t('My account'),'content'=>dashboard_my_account()));
		}
		c(feed_activity_get(0,15,0,0,1,'latest').' ');
	}

	function feedmoreactivities() {
		global $client,$jml_sections;
		if ($_POST['type'] == 'latest') {
			echo feed_activity_get(0,$_POST['num'],$_POST['offset'],$_POST['target_id'],1,$_POST['type'],array('direct_output'=>1));
		}
		elseif ($_POST['type'] == 'hashtag') {
			echo feed_activity_get(0,$_POST['num'],$_POST['offset'],$_POST['target_id'],1,'hashtag',['tag_id'=>$_POST['tag_id'],'direct_output'=>1]);
		}
		else {
			do_auth(2);
			echo feed_activity_get($client['id'],$_POST['num'],$_POST['offset'],$_POST['target_id'],1,$_POST['type'],array('direct_output'=>1));
		}
		exit;
	}
	function all($page = 0) {
		global $client;
		if ($client['id']) {
			ass(array('title'=>t('My account'),'content'=>dashboard_my_account()));
		}
		enable_jcow_inline_ad();
		set_title(t('News feed'));
		global $content, $db, $apps, $client, $settings;
		if ($client['id']) {
			c(stream_form($client['id'],array(),'',array('fromhome'=>1)));
			section_close();
		}
		$num = 10;
		c(activity_get(0,$num,0,0,1));
	}
}

function show_feed($type = 'latest') {
	global $tab_menu;
	$next_offset = 0;
	if (is_app()) {
		$num = 7 + valid_offset($_GET['offset']);
		$res = feed_activity_get(0,$num,0,0,1,$type);
		if ($res['i'] > $res['num'] && $_GET['offset'] < 50) {
			$next_offset = $_GET['offset'] + 7;
		}
	}
	else {
		feed_activity_get(0,10,0,0,1,$type);
		feed_sidebar();
		$widgets = array();
		if (is_array($hooks)) {
			foreach ($hooks as $hook) {
				$hook_func = $hook.'_widget';
				$hook_func($widgets);
			}
		}
		foreach($widgets as $key=>$widget) {
			$callback = $widget['callback'];
			if (function_exists($callback)) {
				$return = $callback();
				ass(array('title'=>h($widget['name']),
					'content'=>$return));
			}
		}
	}
	if (is_app()) {
		array_unshift($tab_menu, ['name'=>t('Latest'), 'path'=>'feed']);
	}
	render(['tabs'=>$tab_menu,'next_offset'=>$next_offset]);
}
function feed_sidebar() {

	$hooks = check_hooks('widget');
	$widgets = array();
	if (is_array($hooks)) {
		foreach ($hooks as $hook) {
			$hook_func = $hook.'_widget';
			$hook_func($widgets);
		}
	}
	foreach($widgets as $key=>$widget) {
		$callback = $widget['callback'];
		if (function_exists($callback)) {
			$return = $callback();
			ass(array('title'=>h($widget['name']),
				'content'=>$return));
		}
	}
}
