
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `jCore`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_ads`
--

CREATE TABLE `[[dbprefix]]_ads` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Location` varchar(255) NOT NULL DEFAULT '',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `URL` varchar(255) NOT NULL DEFAULT '',
  `AdCode` mediumtext,
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `BlockID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `StartDate` date DEFAULT NULL,
  `EndDate` date DEFAULT NULL,
  `ShowOn` varchar(15) DEFAULT NULL,
  `Deactivated` tinyint(1) NOT NULL DEFAULT '0',
  `Shown` int(10) unsigned NOT NULL DEFAULT '0',
  `Clicked` int(10) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ShowOn` (`ShowOn`),
  KEY `OrderID` (`OrderID`),
  KEY `BlockID` (`BlockID`),
  KEY `StartDate` (`StartDate`),
  KEY `EndDate` (`EndDate`),
  KEY `Deactivated` (`Deactivated`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_ads`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_bfprotection`
--

CREATE TABLE `[[dbprefix]]_bfprotection` (
  `Username` varchar(100) NOT NULL DEFAULT '',
  `IP` decimal(39,0) NOT NULL DEFAULT '0',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  KEY `IP` (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_bfprotection`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_bfprotectionbans`
--

CREATE TABLE `[[dbprefix]]_bfprotectionbans` (
  `IP` decimal(39,0) NOT NULL DEFAULT '0',
  `EndTimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Usernames` mediumtext,
  KEY `IP` (`IP`),
  KEY `EndTimeStamp` (`EndTimeStamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_bfprotectionbans`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_blocks`
--

CREATE TABLE `[[dbprefix]]_blocks` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `TemplateID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `LayoutID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Content` mediumtext,
  `BlockID` varchar(100) NOT NULL DEFAULT '',
  `Class` varchar(255) NOT NULL DEFAULT '',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `TypeID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `SubBlockOfID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `PageIDs` varchar(255) NOT NULL,
  `PageExcept` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `LanguageIDs` varchar(255) NOT NULL DEFAULT '',
  `LanguageExcept` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ViewableBy` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Caching` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `CacheOnlyForGuests` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `CacheRefreshTime` smallint(5) unsigned NOT NULL DEFAULT '10',
  `CacheContent` longtext,
  `CacheTimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Limit` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `SubBlockOfID` (`SubBlockOfID`),
  KEY `TypeID` (`TypeID`),
  KEY `Deactivated` (`Deactivated`),
  KEY `OrderID` (`OrderID`),
  KEY `ViewableBy` (`ViewableBy`),
  KEY `TemplateID` (`TemplateID`),
  KEY `LayoutID` (`LayoutID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `[[dbprefix]]_blocks`
--

INSERT INTO `[[dbprefix]]_blocks` VALUES(1, 0, 0, 'Background', '', 'background', '', 0, 0, 0, '', 0, '', 0, 0, 0, 0, 10, '', '0000-00-00 00:00:00', 0, 1);
INSERT INTO `[[dbprefix]]_blocks` VALUES(2, 0, 0, 'Website', '', 'website', '', 0, 0, 1, '', 0, '', 0, 0, 0, 0, 10, '', '2010-08-10 19:03:37', 0, 1);
INSERT INTO `[[dbprefix]]_blocks` VALUES(3, 0, 0, 'Header Menu', '<div class=''bookmarking''>\r\n<script type="text/javascript">addthis_pub = ''pijulius'';</script>\r\n<a class=''normallink'' href="http://www.addthis.com/bookmark.php" onmouseover="return addthis_open(this, '''', ''[URL]'', ''[TITLE]'')" onmouseout="addthis_close()" onclick="return addthis_sendto()"><img src="http://s9.addthis.com/button1-bm.gif" width="125" height="16" style="border: 0;" alt="Bookmark and Share this" /></a><script type="text/javascript" src="http://s7.addthis.com/js/152/addthis_widget.js"></script>\r\n</div>', 'header-menu', '', 0, 3, 2, 'A', 1, '', 0, 0, 0, 0, 10, '', '[[regtime]]', 0, 1);
INSERT INTO `[[dbprefix]]_blocks` VALUES(4, 0, 0, 'Header', '<div class=''logo''>\r\n<a href=''%SITE_URL%''></a>\r\n<div class=''slogan''></div>\r\n</div>\r\n<div class=''header-image''>\r\n<a class=''tipsy'' href=''http://sea-weed.deviantart.com/'' target=''_blank'' title=''Picture Copyright &copy; by Iliana (~sea-weed)''>&copy;</a>\r\n</div>', 'header', '', 0, 0, 2, 'A', 1, '', 0, 0, 0, 0, 10, '', '[[regtime]]', 0, 2);
INSERT INTO `[[dbprefix]]_blocks` VALUES(5, 0, 0, 'Content', '', 'content', '', 0, 0, 2, '', 0, '', 0, 0, 0, 0, 10, '', '2010-08-10 19:03:37', 0, 3);
INSERT INTO `[[dbprefix]]_blocks` VALUES(6, 0, 0, 'Sidebar', '', 'sidebar', '', 0, 0, 5, 'A', 1, '', 0, 0, 0, 0, 10, '', '[[regtime]]', 0, 1);
INSERT INTO `[[dbprefix]]_blocks` VALUES(7, 0, 0, 'Side Menu', '<h2 class=''sidebar-title''>Navigation</h2>\r\n', 'side-menu', '', 0, 3, 6, '', 0, '', 0, 0, 0, 0, 10, '', '0000-00-00 00:00:00', 0, 1);
INSERT INTO `[[dbprefix]]_blocks` VALUES(8, 0, 0, 'Content Bar', '', 'content-bar', '', 0, 0, 5, '', 0, '', 0, 0, 0, 0, 10, '', '2010-08-25 18:26:42', 0, 2);
INSERT INTO `[[dbprefix]]_blocks` VALUES(9, 0, 0, 'Page Content', '', 'pagecontent', '', 0, 1, 8, '', 0, '', 0, 0, 0, 0, 10, '', '2010-08-25 17:45:03', 0, 1);
INSERT INTO `[[dbprefix]]_blocks` VALUES(10, 0, 0, 'Clear Booth', '', '', 'clear-both', 0, 0, 5, '', 0, '', 0, 0, 0, 0, 10, '', '2010-08-25 18:26:42', 0, 3);
INSERT INTO `[[dbprefix]]_blocks` VALUES(11, 0, 0, 'Footer', '<div class=''footercontent''>\r\n<div class=''copyright''>\r\nCopyright %NOW_YEAR% &copy; %PAGE_TITLE%<br />Powered by <a href=''http://jcore.net'' target=''_blank''>jCore</a>\r\n</div>\r\n</div>', 'footer', '', 0, 0, 0, '', 0, '', 0, 0, 0, 0, 10, '', '2010-08-10 19:02:33', 0, 2);
INSERT INTO `[[dbprefix]]_blocks` VALUES(12, 0, 0, 'Admin Menu', '<ul id=''main-menu''><li class=''menu''><a href=''%SITE_URL%admin/''><span>{translate}Admin Home{/translate}</span></a></li><li class=''menu''><a href=''%SITE_URL%'' target=''_blank''><span>{translate}View Website{/translate}</span></a></li><li class=''menu''><a href=''http://jcore.net/help'' target=''_blank''><span>{translate}Get Help{/translate}</span></a></li><li class=''menu''><a href=''http://jcore.net'' target=''_blank''><span>jCore.net</span></a></li></ul>', 'header-menu', '', 0, 0, 2, 'A', 0, '', 0, 0, 0, 0, 10, '', '0000-00-00 00:00:00', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_dynamicformfields`
--

CREATE TABLE `[[dbprefix]]_dynamicformfields` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `FormID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Name` varchar(255) NOT NULL DEFAULT '',
  `TypeID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ValueType` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `Values` text,
  `Required` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Searchable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ViewableBy` smallint(5) unsigned NOT NULL DEFAULT '0',
  `DataPreview` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `PlaceholderText` varchar(255) NOT NULL DEFAULT '',
  `TooltipText` varchar(255) NOT NULL DEFAULT '',
  `AdditionalText` varchar(255) NOT NULL DEFAULT '',
  `Attributes` varchar(255) NOT NULL DEFAULT '',
  `Style` varchar(255) NOT NULL DEFAULT '',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  `Protected` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `FormID` (`FormID`),
  KEY `OrderID` (`OrderID`),
  KEY `ViewableBy` (`ViewableBy`),
  KEY `Searchable` (`Searchable`),
  KEY `DataPreview` (`DataPreview`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=33 ;

--
-- Dumping data for table `[[dbprefix]]_dynamicformfields`
--

INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(1, 1, 'Title', 'Title', 1, 1, NULL, 1, 1, 0, 0, '', '', '', '', 'width: 350px;', 1, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(2, 1, 'Content', 'Content', 19, 6, NULL, 0, 1, 0, 0, '', '', '', '', 'height: 400px;', 2, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(3, 1, 'Blogging Options', '', 13, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 3, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(4, 1, 'Created on', 'TimeStamp', 16, 4, NULL, 0, 0, 0, 0, '', '', '', '', 'width: 170px;', 4, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(5, 1, 'Path', 'Path', 1, 1, NULL, 0, 0, 0, 0, '', '', '', '', 'width: 300px;', 5, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(6, 1, 'Keywords', 'Keywords', 1, 1, NULL, 0, 1, 0, 0, '', 'e.g. oranges, lemons, limes', '', '', 'width: 250px;', 7, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(7, 1, 'Link to URL', 'URL', 1, 7, NULL, 0, 0, 0, 0, '', 'e.g. http://domain.com', '', '', 'width: 300px;', 6, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(8, 1, ' ', '', 14, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 8, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(9, 1, 'Announcement Options', '', 13, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 9, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(10, 1, 'Start Date', 'StartDate', 17, 5, NULL, 0, 0, 0, 0, '', '', '', '', 'width: 100px;', 10, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(11, 1, 'End Date', 'EndDate', 17, 5, NULL, 0, 0, 0, 0, '', '', '', '', 'width: 100px;', 11, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(12, 1, ' ', '', 14, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 13, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(13, 1, 'Display Options', '', 13, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 14, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(14, 1, 'Display On Mainpage', 'OnMainPage', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 18, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(15, 1, 'In Block', 'BlockID', 5, 2, NULL, 0, 0, 0, 0, '', '', '', '', '', 14, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(16, 1, 'Partial Content', 'PartialContent', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 16, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(17, 1, 'Display Related Posts', 'DisplayRelatedPosts', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 19, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(18, 1, ' ', '', 14, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 20, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(19, 1, 'Rating Options', '', 13, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 21, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(20, 1, 'Enable Rating', 'EnableRating', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 22, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(21, 1, 'Enable Guest Rating', 'EnableGuestRating', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 23, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(22, 1, ' ', '', 14, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 24, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(23, 1, 'Comments Options', '', 13, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 25, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(24, 1, 'Enable Comments', 'EnableComments', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 26, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(25, 1, 'Enable Guest Comments', 'EnableGuestComments', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 27, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(26, 1, ' ', '', 14, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 28, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(27, 1, 'Additional Options', '', 13, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 29, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(28, 1, 'Deactivated', 'Deactivated', 3, 10, NULL, 0, 0, 0, 0, '', '', '<span class=''comment'' style=''text-decoration: line-through;''>(marked with strike through)</span>', '', '', 30, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(29, 1, 'Order', 'OrderID', 1, 2, NULL, 0, 0, 0, 0, '', '', '', '', 'width: 50px;', 31, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(30, 1, ' ', '', 14, 0, NULL, 0, 0, 0, 0, '', '', '', '', '', 32, 0);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(31, 1, 'Not Searchable', 'NotSearchable', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 17, 1);
INSERT INTO `[[dbprefix]]_dynamicformfields` VALUES(32, 1, 'Hide when Expired', 'HideExpired', 3, 10, NULL, 0, 0, 0, 0, '', '', '', '', '', 12, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_dynamicforms`
--

CREATE TABLE `[[dbprefix]]_dynamicforms` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(255) NOT NULL DEFAULT '',
  `FormID` varchar(255) NOT NULL DEFAULT '',
  `Method` varchar(10) NOT NULL DEFAULT 'post',
  `SendNotificationEmail` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `SendNotificationEmailTo` varchar(100) NOT NULL DEFAULT '',
  `SendAutoResponse` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `AutoResponseFrom` varchar(255) NOT NULL DEFAULT '',
  `AutoResponseSubject` varchar(255) NOT NULL DEFAULT '',
  `AutoResponseMessage` mediumtext,
  `LocaleFile` varchar(255) NOT NULL DEFAULT '',
  `SQLTable` varchar(100) NOT NULL DEFAULT '',
  `Protected` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ProtectedSQLTable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `BrowseDataURL` varchar(255) NOT NULL DEFAULT '',
  `SuccessMessage` text,
  PRIMARY KEY (`ID`),
  KEY `FormID` (`FormID`),
  KEY `Protected` (`Protected`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_dynamicforms`
--

INSERT INTO `[[dbprefix]]_dynamicforms` VALUES(1, 'Posts', 'posts', 'post', 0, '', 0, '', '', NULL, '', 'posts', 1, 1, '?path=admin/content/postsatglance', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_favoritelinks`
--

CREATE TABLE `[[dbprefix]]_favoritelinks` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(100) NOT NULL DEFAULT '',
  `Link` varchar(255) NOT NULL DEFAULT '',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Deactivated` (`Deactivated`),
  KEY `OrderID` (`OrderID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]_favoritelinks`
--

INSERT INTO `[[dbprefix]]_favoritelinks` VALUES(1, 'Pages / Posts', '?path=admin/content/pages', 0, 1);
INSERT INTO `[[dbprefix]]_favoritelinks` VALUES(2, 'Modules', '?path=admin/modules', 0, 2);
INSERT INTO `[[dbprefix]]_favoritelinks` VALUES(3, 'Settings', '?path=admin/site/settings', 0, 3);
INSERT INTO `[[dbprefix]]_favoritelinks` VALUES(4, 'Users', '?path=admin/members/users', 0, 4);
INSERT INTO `[[dbprefix]]_favoritelinks` VALUES(5, 'Template', '?path=admin/site/template', 0, 5);
INSERT INTO `[[dbprefix]]_favoritelinks` VALUES(6, 'View Website', '/', 0, 6);
INSERT INTO `[[dbprefix]]_favoritelinks` VALUES(7, 'Logout', '?logout=1', 0, 7);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_languages`
--

CREATE TABLE `[[dbprefix]]_languages` (
  `ID` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(100) NOT NULL DEFAULT '',
  `Path` varchar(255) NOT NULL DEFAULT '',
  `Locale` varchar(10) NOT NULL DEFAULT 'en_US',
  `Default` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Path` (`Path`),
  KEY `Default` (`Default`),
  KEY `Deactivated` (`Deactivated`),
  KEY `OrderID` (`OrderID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_languages`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_layouts`
--

CREATE TABLE `[[dbprefix]]_layouts` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(150) NOT NULL DEFAULT '',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `TemplateID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Deactivated` (`Deactivated`),
  KEY `OrderID` (`OrderID`),
  KEY `TemplateID` (`TemplateID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_layouts`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_massemails`
--

CREATE TABLE `[[dbprefix]]_massemails` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `From` varchar(255) NOT NULL DEFAULT '',
  `To` text,
  `Subject` varchar(255) NOT NULL DEFAULT '',
  `Message` mediumtext,
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `EmailsSentOut` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `UserID` (`UserID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_massemails`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_menuitems`
--

CREATE TABLE `[[dbprefix]]_menuitems` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(150) NOT NULL DEFAULT '',
  `Path` varchar(255) NOT NULL DEFAULT '',
  `Link` varchar(255) NOT NULL DEFAULT '',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ViewableBy` smallint(5) unsigned NOT NULL DEFAULT '0',
  `SubMenuItemOfID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `MenuID` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `LanguageID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  `PageID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Deactivated` (`Deactivated`),
  KEY `SubMenuItemOfID` (`SubMenuItemOfID`),
  KEY `OrderID` (`OrderID`),
  KEY `Path` (`Path`),
  KEY `MenuID` (`MenuID`),
  KEY `LanguageID` (`LanguageID`),
  KEY `ViewableBy` (`ViewableBy`),
  KEY `PageID` (`PageID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]_menuitems`
--

INSERT INTO `[[dbprefix]]_menuitems` VALUES(1, 'Home', 'home', '', 0, 0, 0, 2, 0, 1, 1);
INSERT INTO `[[dbprefix]]_menuitems` VALUES(2, 'What next?', 'what-next', '', 0, 0, 0, 2, 0, 2, 2);
INSERT INTO `[[dbprefix]]_menuitems` VALUES(3, 'Home', 'home', '', 0, 0, 0, 1, 0, 1, 1);
INSERT INTO `[[dbprefix]]_menuitems` VALUES(4, 'What next?', 'what-next', '', 0, 0, 0, 1, 0, 2, 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_menus`
--

CREATE TABLE `[[dbprefix]]_menus` (
  `ID` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Name` varchar(100) NOT NULL DEFAULT '',
  `IncludeNewPages` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `BlockID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `BlockID` (`BlockID`),
  KEY `OrderID` (`OrderID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_menus`
--

INSERT INTO `[[dbprefix]]_menus` VALUES(1, 'Top Menu', 'main-menu', 0, 3, 1);
INSERT INTO `[[dbprefix]]_menus` VALUES(2, 'Right Menu', 'right-menu', 1, 7, 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_modules`
--

CREATE TABLE `[[dbprefix]]_modules` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) NOT NULL DEFAULT '',
  `Installed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Searchable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `jQueryPlugins` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `Searchable` (`Searchable`),
  KEY `Name` (`Name`),
  KEY `Deactivated` (`Deactivated`),
  KEY `Installed` (`Installed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_modules`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_noteattachments`
--

CREATE TABLE `[[dbprefix]]_noteattachments` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  `Location` varchar(255) NOT NULL DEFAULT '',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `HumanMimeType` varchar(255) NOT NULL DEFAULT '',
  `FileSize` int(10) unsigned NOT NULL DEFAULT '0',
  `NoteID` int(10) unsigned NOT NULL DEFAULT '1',
  `Downloads` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `OrderID` (`OrderID`),
  KEY `NoteID` (`NoteID`),
  KEY `TimeStamp` (`TimeStamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_noteattachments`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_notecomments`
--

CREATE TABLE `[[dbprefix]]_notecomments` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `NoteID` int(10) unsigned NOT NULL DEFAULT '0',
  `UserName` varchar(100) NOT NULL DEFAULT '',
  `Email` varchar(100) NOT NULL DEFAULT '',
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `Comment` text,
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `IP` decimal(39,0) NOT NULL DEFAULT '0',
  `SubCommentOfID` int(10) unsigned NOT NULL DEFAULT '0',
  `Rating` smallint(6) NOT NULL DEFAULT '0',
  `Pending` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `NoteID` (`NoteID`),
  KEY `UserName` (`UserName`),
  KEY `UserID` (`UserID`),
  KEY `Pending` (`Pending`),
  KEY `SubCommentOfID` (`SubCommentOfID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_notecomments`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_notecommentsratings`
--

CREATE TABLE `[[dbprefix]]_notecommentsratings` (
  `CommentID` int(10) unsigned NOT NULL DEFAULT '0',
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `IP` decimal(39,0) NOT NULL DEFAULT '0',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Rating` tinyint(1) NOT NULL DEFAULT '0',
  KEY `CommentID` (`CommentID`),
  KEY `UserID` (`UserID`),
  KEY `IP` (`IP`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `Rating` (`Rating`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_notecommentsratings`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_notes`
--

CREATE TABLE `[[dbprefix]]_notes` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(255) NOT NULL DEFAULT '',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `DueDate` date DEFAULT NULL,
  `Content` mediumtext,
  `Comments` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Attachments` smallint(5) unsigned NOT NULL DEFAULT '0',
  `StatusID` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `StatusID` (`StatusID`),
  KEY `DueDate` (`DueDate`),
  KEY `UserID` (`UserID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_notes`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_notificationemails`
--

CREATE TABLE `[[dbprefix]]_notificationemails` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `EmailID` varchar(100) NOT NULL DEFAULT '',
  `Subject` varchar(255) NOT NULL DEFAULT '',
  `Body` mediumtext,
  PRIMARY KEY (`ID`),
  KEY `EmailID` (`EmailID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_notificationemails`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_pageforms`
--

CREATE TABLE `[[dbprefix]]_pageforms` (
  `PageID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `FormID` smallint(5) unsigned NOT NULL DEFAULT '0',
  KEY `PageID` (`PageID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_pageforms`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_pagemodules`
--

CREATE TABLE `[[dbprefix]]_pagemodules` (
  `PageID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ModuleID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ModuleItemID` int(10) NOT NULL DEFAULT '0',
  KEY `MenuID` (`PageID`),
  KEY `ModuleID` (`ModuleID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_pagemodules`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_pages`
--

CREATE TABLE `[[dbprefix]]_pages` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(150) NOT NULL DEFAULT '',
  `Path` varchar(255) NOT NULL DEFAULT '',
  `PostKeywords` varchar(255) NOT NULL DEFAULT '',
  `SEOTitle` varchar(255) NOT NULL DEFAULT '',
  `SEODescription` text,
  `SEOKeywords` varchar(255) NOT NULL DEFAULT '',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `AccessibleBy` smallint(5) unsigned NOT NULL DEFAULT '0',
  `SubPageOfID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `LanguageID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `LayoutID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Limit` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `Posts` smallint(5) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Path` (`Path`),
  KEY `Deactivated` (`Deactivated`),
  KEY `SubMenuOfID` (`SubPageOfID`),
  KEY `OrderID` (`OrderID`),
  KEY `LanguageID` (`LanguageID`),
  KEY `ViewableBy` (`AccessibleBy`),
  KEY `LayoutID` (`LayoutID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_pages`
--

INSERT INTO `[[dbprefix]]_pages` VALUES(1, 'Home', 'home', '', '', NULL, '', 0, 0, 0, 0, 0, 0, 1, 1);
INSERT INTO `[[dbprefix]]_pages` VALUES(2, 'What next?', 'what-next', '', '', NULL, '', 0, 0, 0, 0, 0, 0, 1, 2);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_postattachments`
--

CREATE TABLE `[[dbprefix]]_postattachments` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  `Location` varchar(255) NOT NULL DEFAULT '',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `HumanMimeType` varchar(255) NOT NULL DEFAULT '',
  `FileSize` int(10) unsigned NOT NULL DEFAULT '0',
  `PostID` int(10) unsigned NOT NULL DEFAULT '1',
  `Downloads` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `OrderID` (`OrderID`),
  KEY `PostID` (`PostID`),
  KEY `TimeStamp` (`TimeStamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_postattachments`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_postcomments`
--

CREATE TABLE `[[dbprefix]]_postcomments` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PostID` int(10) unsigned NOT NULL DEFAULT '0',
  `UserName` varchar(100) NOT NULL DEFAULT '',
  `Email` varchar(100) NOT NULL DEFAULT '',
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `Comment` text,
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `IP` decimal(39,0) NOT NULL DEFAULT '0',
  `SubCommentOfID` int(10) unsigned NOT NULL DEFAULT '0',
  `Rating` smallint(6) NOT NULL DEFAULT '0',
  `Pending` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `PostID` (`PostID`),
  KEY `UserName` (`UserName`),
  KEY `UserID` (`UserID`),
  KEY `Pending` (`Pending`),
  KEY `SubCommentOfID` (`SubCommentOfID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_postcomments`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_postcommentsratings`
--

CREATE TABLE `[[dbprefix]]_postcommentsratings` (
  `CommentID` int(10) unsigned NOT NULL DEFAULT '0',
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `IP` decimal(39,0) NOT NULL DEFAULT '0',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Rating` tinyint(1) NOT NULL DEFAULT '0',
  KEY `CommentID` (`CommentID`),
  KEY `UserID` (`UserID`),
  KEY `IP` (`IP`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `Rating` (`Rating`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_postcommentsratings`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_postkeywords`
--

CREATE TABLE `[[dbprefix]]_postkeywords` (
  `Keyword` varchar(100) NOT NULL DEFAULT '',
  `Counter` smallint(5) unsigned NOT NULL DEFAULT '0',
  `PageIDs` varchar(255) NOT NULL DEFAULT '',
  KEY `Counter` (`Counter`),
  KEY `MenuItemIDs` (`PageIDs`),
  KEY `Keyword` (`Keyword`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_postkeywords`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_postpictures`
--

CREATE TABLE `[[dbprefix]]_postpictures` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  `Location` varchar(255) NOT NULL DEFAULT '',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `URL` varchar(255) NOT NULL DEFAULT '',
  `PostID` int(10) unsigned NOT NULL DEFAULT '1',
  `Views` int(10) unsigned NOT NULL DEFAULT '0',
  `Thumbnail` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `OrderID` (`OrderID`),
  KEY `PostID` (`PostID`),
  KEY `TimeStamp` (`TimeStamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_postpictures`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_postratings`
--

CREATE TABLE `[[dbprefix]]_postratings` (
  `PostID` int(10) unsigned NOT NULL DEFAULT '0',
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `IP` decimal(39,0) NOT NULL DEFAULT '0',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Rating` tinyint(1) NOT NULL DEFAULT '0',
  KEY `Rating` (`Rating`),
  KEY `PostID` (`PostID`),
  KEY `UserID` (`UserID`),
  KEY `IP` (`IP`),
  KEY `TimeStamp` (`TimeStamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_postratings`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_posts`
--

CREATE TABLE `[[dbprefix]]_posts` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PageID` mediumint(8) unsigned NOT NULL,
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Path` varchar(255) NOT NULL DEFAULT '',
  `URL` varchar(255) NOT NULL DEFAULT '',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `StartDate` date DEFAULT NULL,
  `EndDate` date DEFAULT NULL,
  `HideExpired` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Content` mediumtext,
  `Keywords` varchar(255) NOT NULL DEFAULT '',
  `Views` int(10) unsigned NOT NULL DEFAULT '0',
  `Comments` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Pictures` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Attachments` smallint(5) unsigned NOT NULL DEFAULT '0',
  `EnableComments` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `EnableGuestComments` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Rating` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `EnableRating` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `EnableGuestRating` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `PartialContent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `NotSearchable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `OnMainPage` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `DisplayRelatedPosts` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `BlockID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `LanguageID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `MenuID` (`PageID`),
  KEY `Deactivated` (`Deactivated`),
  KEY `OrderID` (`OrderID`),
  KEY `OnMainPage` (`OnMainPage`),
  KEY `StartDate` (`StartDate`),
  KEY `EndDate` (`EndDate`),
  KEY `Path` (`Path`),
  KEY `BlockID` (`BlockID`),
  KEY `UserID` (`UserID`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `NotSearchable` (`NotSearchable`),
  KEY `HideExpired` (`HideExpired`),
  KEY `LanguageID` (`LanguageID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]_posts`
--

INSERT INTO `[[dbprefix]]_posts` VALUES(1, 1, 'Welcome to jCore', 'welcome-to-jcore', '', '[[regtime]]', NULL, NULL, 0, '<p>Welcome to jCore, if you see this message it meens you have successfully set up jCore on your server and you can now start customizing this site.</p>\r\n<p>To access the admin area just click here:<br />\r\n<a href="%SITE_URL%admin">%SITE_URL%admin</a> &nbsp;</p>\r\n<p>Your login information to the admin are:<br />\r\n<strong>Username</strong>: [[admin_username]]<br />\r\n<strong>Password</strong>: The one you just entered</p>\r\n<div class="tooltip notification"><span>IMPORTANT: Please change your password as soon as possible in the admin (Member Management -&gt; Users)</span></div>\r\n<p>Have fun.</p>', '', 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1);
INSERT INTO `[[dbprefix]]_posts` VALUES(2, 2, 'What to do next', 'what-to-do-next', '', '[[regtime]]', NULL, NULL, 0, '<p>As on the first page noted, the first thing you should do is to change your admin password (and or username if you want to), then you can go to the Content Management area and start setting up your menu items like About, News, Contact and so on. You can add as many posts (content) as you wish under a menu item. To read more about the content management feature please see <a target="_blank" href="http://jcore.net/features/content-management">Features -&gt; Content Management</a></p>\r\n<p>The second thing you should do when menus are set up is to look in the Site Layout &amp;&nbsp;Functionality and start setting up your own Blocks (Layout Blocks). Layout blocks are the div tags that you will be able to customize from css and js. Each block can have unlimited subblocks and you can even limit them to show it only for a defined menu and/or language. To lear more about blocks please see <a target="_blank" href="http://jcore.net/features/dynamic-web-20-layout">Features -&gt; Dynamic Web 2.0 Layout</a></p>\r\n<p>Once all your blocks are set up and you have the site''s design done from css/js you can start adding custom modules/content to your site, if you have any questions please see the <a target="_blank" href="http://jcore.net/features">Features</a> section.</p>', '', 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_ptprotectionbans`
--

CREATE TABLE `[[dbprefix]]_ptprotectionbans` (
  `UserID` mediumint(8) NOT NULL DEFAULT '0',
  `EndTimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `IPs` mediumtext,
  KEY `UserID` (`UserID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_ptprotectionbans`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_rssfeeds`
--

CREATE TABLE `[[dbprefix]]_rssfeeds` (
  `ID` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(255) NOT NULL DEFAULT '',
  `FeedURL` varchar(255) NOT NULL DEFAULT '',
  `Deactivated` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `OrderID` mediumint(9) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `Deactivated` (`Deactivated`),
  KEY `OrderID` (`OrderID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_rssfeeds`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_settings`
--

CREATE TABLE `[[dbprefix]]_settings` (
  `ID` varchar(100) NOT NULL DEFAULT '',
  `Value` mediumtext,
  `TypeID` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `OrderID` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `OrderID` (`OrderID`),
  KEY `TypeID` (`TypeID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_settings`
--

INSERT INTO `[[dbprefix]]_settings` VALUES('Page_Title', 'jCore - the Webmaster''s Multisite CMS', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Picture_Thumbnail_Height', '0', 2, 2);
INSERT INTO `[[dbprefix]]_settings` VALUES('Meta_Keywords', 'jcore, cms, content management system, php, mysql, lamp, web cms', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Meta_Description', 'jCore is the web Content Management System build especially for webmasters to easily maintenance multiple websites', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Webmaster_Email', 'support@jcore.net', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Webmaster_BCC_Email', '', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Picture_Thumbnail_Width', '150', 2, 2);
INSERT INTO `[[dbprefix]]_settings` VALUES('Page_Settings', '', 0, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Picture_Settings', '', 0, 2);
INSERT INTO `[[dbprefix]]_settings` VALUES('Brute_Force_Protection', '', 0, 3);
INSERT INTO `[[dbprefix]]_settings` VALUES('Brute_Force_Maximum_Failure_Attempts', '5', 2, 3);
INSERT INTO `[[dbprefix]]_settings` VALUES('Brute_Force_Protection_Time_Minutes', '60', 2, 3);
INSERT INTO `[[dbprefix]]_settings` VALUES('Brute_Force_Maximum_Failure_Attempts_Before_TwoWeeks_Ban', '30', 2, 3);
INSERT INTO `[[dbprefix]]_settings` VALUES('Brute_Force_Email_Notification', '1', 3, 3);
INSERT INTO `[[dbprefix]]_settings` VALUES('Password_Trading_Protection', '', 0, 4);
INSERT INTO `[[dbprefix]]_settings` VALUES('Password_Trading_Maximum_Simultaneous_Logins', '3', 2, 4);
INSERT INTO `[[dbprefix]]_settings` VALUES('Password_Trading_Protection_Time_Minutes', '60', 2, 4);
INSERT INTO `[[dbprefix]]_settings` VALUES('Password_Trading_Email_Notification', '1', 3, 4);
INSERT INTO `[[dbprefix]]_settings` VALUES('Maintenance_Settings', '', 0, 5);
INSERT INTO `[[dbprefix]]_settings` VALUES('Maintenance_Website_Suspended', '0', 3, 5);
INSERT INTO `[[dbprefix]]_settings` VALUES('Maintenance_Suspend_Text', '<html>\r\n<head>\r\n<title>Site Under Maintenance</title>\r\n</head>\r\n<body>\r\n<div style=''margin: 100px auto; border: solid 1px #CCCCCC; width: 500px; padding: 10px; text-align: center; font-family: Arial, Helvetica, Sans-serif;''>\r\n<h1>Site under maintenance</h1>\r\n<p>We are currently making enhancements and/or fixing issues. We appreciate your patience during this time, and encourage you to return here shortly.</p>\r\n</div>\r\n</body>\r\n</html>', 4, 5);
INSERT INTO `[[dbprefix]]_settings` VALUES('Maintenance_Notification_Text', '', 4, 5);
INSERT INTO `[[dbprefix]]_settings` VALUES('Page_TimeZone', 'Europe/London', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Page_Charset', 'utf-8', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Page_404_Error_Text', '<div class=''posts''>\r\n<div class=''post selected''>\r\n<h1 class=''post-title''>\r\nAddress Not Found\r\n<span>{url}uri{/url}</span>\r\n</h1>\r\n<div class=''post-content''>\r\n<p>\r\nUnfortunately the page you are looking for can''t be found on the server {url}server{/url}.\r\n</p>\r\n<p>\r\nSuggestions:\r\n</p>\r\n<ul>\r\n<li>Check the spelling of the address you typed.</li>\r\n<li>Are you certain this page exists? The link may have expired.</li>\r\n<li>If you are still having problems, please visit the <b>Main Page</b>.</li>\r\n</ul>\r\n<div class=''button''>\r\n<a href=''%SITE_URL%''>Main Page</a>\r\n</div>\r\n<div class=''clear-both''></div>\r\n</div>\r\n</div>\r\n</div>', 4, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Functionality_Settings', '', 0, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Ajax_Paging', '0', 3, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_Settings', '', 0, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_Use_SMTP', '0', 3, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_Use_SSL_SMTP', '0', 3, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_SMTP_Host', 'localhost', 1, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_SMTP_Port', '25', 1, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_SMTP_Username', '', 1, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_SMTP_Password', '', 1, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Blog_Ping_On_New_Posts', '0', 3, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Blog_Ping_Servers', 'http://rpc.pingomatic.com/', 1, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('jQuery_Settings', '', 0, 9);
INSERT INTO `[[dbprefix]]_settings` VALUES('jQuery_Load_Plugins', 'cookie, loading, mailme, rating, ajaxlinks, ajaxform, lightbox, fctoggle, tabby, ui, ui.datepicker, colorpicker, tipsy, dropdownmenu', 1, 9);
INSERT INTO `[[dbprefix]]_settings` VALUES('Picture_Watermark', '0', 3, 2);
INSERT INTO `[[dbprefix]]_settings` VALUES('Picture_Watermark_Text', 'Copyright (c) 2009', 1, 2);
INSERT INTO `[[dbprefix]]_settings` VALUES('Picture_Watermark_Text_Font', 'fonts/arial.ttf', 1, 2);
INSERT INTO `[[dbprefix]]_settings` VALUES('Picture_Watermark_Logo', '', 1, 2);
INSERT INTO `[[dbprefix]]_settings` VALUES('Picture_Watermark_Position', '100% 100%', 1, 2);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Settings', '', 0, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Code_Length', '7', 1, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Font', 'fonts/VeraSansBold.ttf', 1, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Font_Size', '30', 1, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Random_Lines', '7', 1, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Foreground_Color', '#000000', 10, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Background_Color', '#ffffc8', 10, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Default_Locale', 'en_US', 1, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Brute_Force_Protection_Enabled', '1', 3, 3);
INSERT INTO `[[dbprefix]]_settings` VALUES('Password_Trading_Protection_Enabled', '1', 3, 4);
INSERT INTO `[[dbprefix]]_settings` VALUES('Admin_Settings', '', 0, 11);
INSERT INTO `[[dbprefix]]_settings` VALUES('Admin_Items_Counter_Enabled', '1', 3, 11);
INSERT INTO `[[dbprefix]]_settings` VALUES('jQuery_Load_Admin_Plugins', '', 1, 9);
INSERT INTO `[[dbprefix]]_settings` VALUES('jQuery_Disabled', '', 3, 9);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Random_Words', '1', 3, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Security_Image_Random_Fonts', '', 3, 10);
INSERT INTO `[[dbprefix]]_settings` VALUES('Registrations_Suspended', '', 3, 5);
INSERT INTO `[[dbprefix]]_settings` VALUES('Logins_Suspended', '', 3, 5);
INSERT INTO `[[dbprefix]]_settings` VALUES('Minimum_Password_Length', '5', 1, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Comments_Settings', '', 0, 8);
INSERT INTO `[[dbprefix]]_settings` VALUES('Moderated_Comments', '', 3, 8);
INSERT INTO `[[dbprefix]]_settings` VALUES('Moderated_Comments_By_Approval', '', 3, 8);
INSERT INTO `[[dbprefix]]_settings` VALUES('Moderated_Comments_Pending_Minutes', '0', 1, 8);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_PGP_Encrypt', '0', 3, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_PGP_Public_Keys_Directory', '/home/user/pgpkeys/', 1, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Email_PGP_Binary', '/usr/bin/gpg', 1, 7);
INSERT INTO `[[dbprefix]]_settings` VALUES('Admin_Favorite_Links_Enabled', '1', 3, 11);
INSERT INTO `[[dbprefix]]_settings` VALUES('Username_Changes_Disabled', '0', 3, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Page_Date_Format', '%a, %d %b %Y', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Page_Time_Format', '%H:%M:%S %Z', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Page_First_Weekday', 'Sunday', 1, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Avatars_Disabled', '0', 3, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Avatars_Size', '64', 1, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Default_Avatar_URL', '', 1, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Website_Template', '', 5, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Website_Template_SetForAdmin', '0', 5, 1);
INSERT INTO `[[dbprefix]]_settings` VALUES('Instant_User_Registration', '0', 3, 6);
INSERT INTO `[[dbprefix]]_settings` VALUES('Manual_Gettext', '0', 3, 6);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_templates`
--

CREATE TABLE `[[dbprefix]]_templates` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) NOT NULL DEFAULT '',
  `Installed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `jQueryPlugins` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `Name` (`Name`),
  KEY `Installed` (`Installed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_templates`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_usergrouppermissions`
--

CREATE TABLE `[[dbprefix]]_usergrouppermissions` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `GroupID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Path` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `PermissionTypeID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `UserID` (`GroupID`),
  KEY `Path` (`Path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_usergrouppermissions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_usergroups`
--

CREATE TABLE `[[dbprefix]]_usergroups` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `GroupName` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_usergroups`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_userlogins`
--

CREATE TABLE `[[dbprefix]]_userlogins` (
  `SessionID` varchar(100) NOT NULL DEFAULT '',
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `FromIP` decimal(39,0) NOT NULL DEFAULT '0',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `KeepIt` tinyint(4) NOT NULL DEFAULT '0',
  KEY `UserID` (`UserID`),
  KEY `SessionID` (`SessionID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_userlogins`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_userpermissions`
--

CREATE TABLE `[[dbprefix]]_userpermissions` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `Path` varchar(255) NOT NULL DEFAULT '',
  `PermissionTypeID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `UserID` (`UserID`),
  KEY `Path` (`Path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]_userpermissions`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_userrequests`
--

CREATE TABLE `[[dbprefix]]_userrequests` (
  `UserID` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `RequestTypeID` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `RequestID` varchar(100) NOT NULL DEFAULT '',
  `FromIP` decimal(39,0) NOT NULL DEFAULT '0',
  `Data` text,
  KEY `UserID` (`UserID`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `RequestID` (`RequestID`),
  KEY `FromIP` (`FromIP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_userrequests`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_users`
--

CREATE TABLE `[[dbprefix]]_users` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `GroupID` smallint(5) unsigned NOT NULL DEFAULT '0',
  `UserName` varchar(100) NOT NULL DEFAULT '',
  `Password` varchar(100) NOT NULL DEFAULT '',
  `Email` varchar(100) NOT NULL DEFAULT '',
  `Website` varchar(255) NOT NULL DEFAULT '',
  `TimeStamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `StayLoggedIn` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `LastVisitTimeStamp` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Admin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `IP` decimal(39,0) NOT NULL DEFAULT '0',
  `Suspended` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ShowAvatar` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `DisableNotificationEmails` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `SkipIPCheck` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `UserName` (`UserName`),
  KEY `Email` (`Email`),
  KEY `TimeStamp` (`TimeStamp`),
  KEY `Admin` (`Admin`),
  KEY `Suspended` (`Suspended`),
  KEY `GroupID` (`GroupID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_users`
--

INSERT INTO `[[dbprefix]]_users` VALUES(1, 0, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', 'http://jcore.net', '[[regtime]]', 0, '[[regtime]]', 1, '0', 0, 1, 0, 0);
