<?php
include_once(dirname(__FILE__)."/helper.php");
$install_values=get_install_values();
$languages=get_languages();
?>
<form method="post" action="<?=base_url()?>install/install.php" validate-form="true" validation-error="Please check marked fields" ajax-form="true" callback="install.setActiveForm(this);install.processResponse(response);">
	<input type="hidden" name="step" value="3" />
	<div class="installation-internal-form">			
		<div class="inline-form-row">
			<div class="column-6">
				<label for="language">Default Language</label>
			</div>
			<div class="column-6">
				<select name="language" id="language" class="full-width" required-field="true" validation="[not-empty]">
					<option value="">- Please Select -</option>
					<?php
					for($i=0;$i<count($languages);$i++){
					?>
					<option value="<?=$languages[$i]->name?>" <?=$install_values->preferences['language']==$languages[$i]->name || ($install_values->preferences['language']=="" && $languages[$i]->name=="english")?"selected=\"selected\"":""?>><?=$languages[$i]->title?></option>
					<?php
					}
					?>
				</select>
			</div>
			<div class="clearfix"></div>
		</div>
		<div class="inline-form-row">
			<div class="column-6">
				<label for="main_title">Main Page Title</label>
			</div>
			<div class="column-6">
				<input type="text" id="main_title" name="main_title" class="full-width" required-field="true" validation="[not-empty]" value="<?=$install_values->preferences['main_title']!=""?$install_values->preferences['main_title']:"iQDesk Engine v.3.0"?>" />
			</div>
			<div class="clearfix"></div>
		</div>
		<div class="inline-form-row">
			<div class="column-6">
				<label for="page_title_delimiter">Page Title Delimiter</label>
			</div>
			<div class="column-6">
				<input type="text" id="page_title_delimiter" name="page_title_delimiter" class="full-width" value="<?=$install_values->preferences['page_title_delimiter']!=""?$install_values->preferences['page_title_delimiter']:"::"?>" />
			</div>
			<div class="clearfix"></div>
		</div>
		<div class="inline-form-row">
			<div class="column-6">
				<label>Color Scheme</label>
			</div>
			<div class="column-6">
				<div class="installation-color-scheme-row">
					<input type="radio" name="color_scheme" value="green" id="green_color_scheme" <?=$install_values->preferences['color_scheme']=="green" || $install_values->preferences['color_scheme']==""?"checked=\"checked\"":""?> />
					<label for="green_color_scheme" tooltip-text="<img src='<?=base_url()?>assets/images/green-theme.png' style='width:280px;height:156px;' />">Green</label>
				</div>
				<div class="installation-color-scheme-row">
					<input type="radio" name="color_scheme" value="red" id="red_color_scheme" <?=$install_values->preferences['color_scheme']=="red"?"checked=\"checked\"":""?> />
					<label for="red_color_scheme" tooltip-text="<img src='<?=base_url()?>assets/images/red-theme.png' style='width:280px;height:156px;' />">Red</label>
				</div>				
			</div>
			<div class="clearfix"></div>
		</div>
		<div class="form-error-handler" error-handler="true"></div>
	</div>
	<div class="modal-footer">
		<input type="button" value="Previous" class="button medium-button secondary-button" onclick="install.prevStep();" />
		<input type="submit" value="Next" class="button medium-button primary-button" />
	</div>			
</form>