<?php
session_start();
function base_url(){
	$root_url=(isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS'])?"https":"http")."://".$_SERVER['SERVER_NAME']."/";
	$self_parts=explode("/",$_SERVER['PHP_SELF']);
	foreach($self_parts as $index=>$part) {
		if ($index>0 && $index<count($self_parts)-1) {
			$root_url.=$part."/";
		}
	}
	$root_url=str_replace("/install","",$root_url);
	return $root_url;
}

function generate_table_prefix(){
	$return="";
	$allowed_chars="qwertyuiopasdfghjklzxcvbnm1234567890";
	for($i=0;$i<4;$i++){
		$return.=substr($allowed_chars,rand(0,mb_strlen($allowed_chars)-1),1);
	}
	$return.="_";
	return $return;
}

function get_install_values(){
	$return=new stdClass;
	$return->sql=array(
		"dbdriver"=>"",
		"hostname"=>"",
		"database"=>"",
		"username"=>"",
		"password"=>"",
		"dbprefix"=>""
	);
	$return->user=array(
		"username"=>"",
		"password"=>"",
		"full_name"=>"",
		"email"=>""
	);
	$return->preferences=array(
		"language"=>"",
		"main_title"=>"",
		"page_title_delimiter"=>"",
		"color_scheme"=>""	
	);
	if (isset($_SESSION['install_values'])) {
		$install_values=$_SESSION['install_values'];
	} else {
		$install_values=new stdClass;
	}
	if (isset($install_values->sql)) {
		if (is_array($install_values->sql)) {
			foreach($install_values->sql as $key=>$value) {
				$return->sql[$key]=$value;
			}
		}
	}
	if (isset($install_values->user)) {
		if (is_array($install_values->user)) {
			foreach($install_values->user as $key=>$value) {
				$return->user[$key]=$value;
			}
		}	
	}
	if (isset($install_values->preferences)) {
		if (is_array($install_values->preferences)) {
			foreach($install_values->preferences as $key=>$value) {
				$return->preferences[$key]=$value;
			}
		}		
	}
	return $return;
}

function store_install_values($install_values){
	$_SESSION['install_values']=$install_values;
}

function check_sql_connection($data){
	$return=false;
	if (isset($data['hostname']) && isset($data['username']) && isset($data['password'])) {
		if (@mysql_pconnect($data['hostname'],$data['username'],$data['password'])) $return=true;
	}
	return $return;
}

function check_database_connection($data){
	$return=false;
	if (isset($data['database'])) {
		if (@mysql_select_db($data['database'])) $return=true;
	}
	return $return;
}

function check_database_config_file(){
	$return=false;
	$file=dirname(__FILE__)."/../application/config/database.php";
	if (file_exists($file)) {
		if (is_writeable($file)) $return=true;
	}
	return $return;
}

function get_languages(){
	define("BASEPATH",1);
	$dir=dirname(__FILE__)."/../application/language/";
	$dh=opendir($dir);
	$languages=array();
	while ($f=readdir($dh)) {
		if ($f!="." && $f!=".." && $f!=".DS_Store") {
			$temp[]=$f;
		}
	}
	$k=0;
	for($i=0;$i<count($temp);$i++) {
		if (file_exists($dir.$temp[$i]."/main_lang.php")) {
			include($dir.$temp[$i]."/main_lang.php");
			$languages[$k]=new stdClass;
			$languages[$k]->name=$temp[$i];
			$languages[$k]->title=$lang['_lang_name'];
			$k++;
		}
	}
	return $languages;
}

function check_main_config_file(){
	$return=false;
	$file=dirname(__FILE__)."/../application/config/config.php";
	if (file_exists($file)) {
		if (is_writeable($file)) $return=true;
	}
	return $return;
}

function check_theme_config_file(){
	$return=false;
	$file=dirname(__FILE__)."/../application/config/theme.php";
	if (file_exists($file)) {
		if (is_writeable($file)) $return=true;
	}
	return $return;
}

function delete_folder($path){
	$return=true;
	if(file_exists($path) && is_dir($path)) {
		$dir=opendir($path);
		while(false!==($element=readdir($dir))) {
			if($element!='.' && $element!='..') {
				$tmp=$path.'/'.$element;
				@chmod($tmp,0777);
				if(is_dir($tmp)){
					$return=delete_folder($tmp);
				} elseif(file_exists($tmp)) {
					if ($tmp!=dirname(__FILE__)."/step_4.php" && $tmp!=dirname(__FILE__)."/helper.php") {
						if (!@unlink($tmp)) $return=false;
					}
				}
			}
		}
		closedir($dir);
		if(file_exists($path)){
			if ($path!=dirname(__FILE__)) {
				if (!@rmdir($path)) $return=false;
			} else {
				if (!is_writable($path)) $return=false;
			}
		}
	}
	return $return;
}
?>