Install=function(){

	this._current_step=0;
	this._active_form=false;
	
	this.setStep=function(step){
		this._current_step=step;
		$(".installation-visual-steps-box").addClass("install-step-"+this._current_step);
		return this;
	}
	
	this.setActiveForm=function(form) {
		this._active_form=$(form);
	}
	
	this.prevStep=function(){
		if (this._current_step>1) {
			this._current_step--;
			$(".installation-visual-steps-box").addClass("install-step-"+this._current_step);
			var _form_wrapper=$("#installation-wrapper");
			if (_form_wrapper.length>0) {
				var _form_loader=_form_wrapper.find(".ajax-form-loader");
				if (_form_loader.length==0) {
					_form_wrapper.append('<div class="ajax-form-loader"><span class="grey-middle-loader">'+lang['loading']+'</span></div>');
					_form_loader=_form_wrapper.find(".ajax-form-loader");
				}
				_form_loader.fadeTo(300,1);
			}			
			$.get(base_url+"install/step_"+this._current_step+".php",{},function(data){
				$("#current-step-container").html(data);
				visualHelpers.init();
				if (_form_loader.length>0) {
					_form_loader.fadeTo(300,0,function(){
						$(this).remove();
					});
				}			
			});
		}
	}
	
	this.processResponse=function(response) {
		var _data=$.parseJSON(response);
		if (_data.result=="error") {
			var _error_handler=this._active_form.find("*[error-handler='true']");
			var _error_text=_data.response;
			if (_error_handler.length>0) {
				if (_error_handler.css("display")!="none") {
					_error_handler.slideUp(0);		
				}
				_error_handler.html(_error_text);
				_error_handler.slideDown(300);					
			}
		} else {
			$("#current-step-container").html(_data.response);
			visualHelpers.init();
			this._current_step++;
			$(".installation-visual-steps-box").addClass("install-step-"+this._current_step);
		}
	}

	return this;

}