

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `simple_invoices2011`
--

-- --------------------------------------------------------

--
-- Table structure for table `si_biller`
--

CREATE TABLE `si_biller` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL DEFAULT '1',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `street_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `street_address2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zip_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile_phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `footer` text COLLATE utf8_unicode_ci,
  `paypal_business_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paypal_notify_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `paypal_return_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `eway_customer_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8_unicode_ci,
  `custom_field1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enabled` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`domain_id`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `si_biller`
--

INSERT INTO `si_biller` VALUES(1, 1, 'Mr Plough', '43 Evergreen Terace', '', 'Springfield', 'NY', '90245', '', '04 5689 0456', '0456 4568 8966', '04 5689 8956', 'homer@mrplough.com', 'ubuntulogo.png', '', '', '', '', '', '', '', '', '7898-87987-87', '', '1');
INSERT INTO `si_biller` VALUES(2, 1, 'Homer Simpson', '43 Evergreen Terace', NULL, 'Springfield', 'NY', '90245', NULL, '04 5689 0456', '0456 4568 8966', '04 5689 8956', 'homer@yahoo.com', NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '1');
INSERT INTO `si_biller` VALUES(3, 1, 'The Beer Baron', '43 Evergreen Terace', NULL, 'Springfield', 'NY', '90245', NULL, '04 5689 0456', '0456 4568 8966', '04 5689 8956', 'beerbaron@yahoo.com', NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '1');
INSERT INTO `si_biller` VALUES(4, 1, 'Fawlty Towers', '13 Seaside Drive', NULL, 'Torquay', 'Brixton on Avon', '65894', 'United Kingdom', '089 6985 4569', '0425 5477 8789', '089 6985 4568', 'penny@fawltytowers.co.uk', NULL, NULL, '', '', '', '', NULL, NULL, NULL, NULL, NULL, '1');

-- --------------------------------------------------------

--
-- Table structure for table `si_cron`
--

CREATE TABLE `si_cron` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recurrence` int(11) NOT NULL,
  `recurrence_type` varchar(11) COLLATE utf8_unicode_ci NOT NULL,
  `email_biller` int(1) DEFAULT NULL,
  `email_customer` int(1) DEFAULT NULL,
  PRIMARY KEY (`domain_id`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `si_cron_log`
--

CREATE TABLE `si_cron_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL,
  `cron_id` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `run_date` date NOT NULL,
  PRIMARY KEY (`domain_id`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `si_customers`
--

CREATE TABLE `si_customers` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL DEFAULT '1',
  `attention` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `street_address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `street_address2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zip_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile_phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `credit_card_holder_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `credit_card_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `credit_card_expiry_month` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `credit_card_expiry_year` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8_unicode_ci,
  `custom_field1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enabled` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`domain_id`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `si_customers`
--

INSERT INTO `si_customers` VALUES(1, 1, 'Moe Sivloski', 'Moes Tavern', '45 Main Road', '', 'Springfield', 'NY', '65891', '', '04 1234 5698', '', '04 5689 4566', 'moe@moestavern.com', '', '', '', '', '<p><strong>Moe&#39;s Tavern</strong> is a fictional <a href=&#39;http://en.wikipedia.org/wiki/Bar_%28establishment%29&#39; title=&#39;Bar (establishment)&#39;>bar</a> seen on <em><a href=&#39;http://en.wikipedia.org/wiki/The_Simpsons&#39; title=&#39;The Simpsons&#39;>The Simpsons</a></em>. The owner of the bar is <a href=&#39;http://en.wikipedia.org/wiki/Moe_Szyslak&#39; title=&#39;Moe Szyslak&#39;>Moe Szyslak</a>.</p> <p>In The Simpsons world, it is located on the corner of Walnut Street, neighboring King Toot&#39;s Music Store, across the street is the Moeview Motel, and a factory formerly owned by <a href=&#39;http://en.wikipedia.org/wiki/Bart_Simpson&#39; title=&#39;Bart Simpson&#39;>Bart Simpson</a>, until it collapsed. The inside of the bar has a few pool tables and a dartboard. It is very dank and &quot;smells like <a href=&#39;http://en.wikipedia.org/wiki/Urine&#39; title=&#39;Urine&#39;>tinkle</a>.&quot; Because female customers are so rare, Moe frequently uses the women&#39;s restroom as an office. Moe claimed that there haven&#39;t been any ladies at Moe&#39;s since <a href=&#39;http://en.wikipedia.org/wiki/1979&#39; title=&#39;1979&#39;>1979</a> (though earlier episodes show otherwise). A jar of pickled eggs perpetually stands on the bar. Another recurring element is a rat problem. This can be attributed to the episode <a href=&#39;http://en.wikipedia.org/wiki/Homer%27s_Enemy&#39; title=&#39;Homer&#39;s Enemy&#39;>Homer&#39;s Enemy</a> in which Bart&#39;s factory collapses, and the rats are then shown to find a new home at Moe&#39;s. In &quot;<a href=&#39;http://en.wikipedia.org/wiki/Who_Shot_Mr._Burns&#39; title=&#39;Who Shot Mr. Burns&#39;>Who Shot Mr. Burns</a>,&quot; Moe&#39;s Tavern was forced to close down because Mr. Burns&#39; slant-drilling operation near the tavern caused unsafe pollution. It was stated in the &quot;<a href=&#39;http://en.wikipedia.org/wiki/Flaming_Moe%27s&#39; title=&#39;Flaming Moe&#39;s&#39;>Flaming Moe&#39;s</a>&quot; episode that Moe&#39;s Tavern was on Walnut Street. The phone number would be 76484377, since in &quot;<a href=&#39;http://en.wikipedia.org/wiki/Homer_the_Smithers&#39; title=&#39;Homer the Smithers&#39;>Homer the Smithers</a>,&quot; Mr. Burns tried to call Smithers but did not know his phone number. He tried the buttons marked with the letters for Smithers and called Moe&#39;s. In &quot;<a href=&#39;http://en.wikipedia.org/wiki/Principal_Charming&#39; title=&#39;Principal Charming&#39;>Principal Charming</a>&quot; Bart is asked to call Homer by Principal Skinner, the number visible on the card is WORK: KLondike 5-6832 HOME: KLondike 5-6754 MOE&#39;S TAVERN: KLondike 5-1239 , Moe answers the phone and Bart asks for Homer Sexual. The bar serves <a href=&#39;http://en.wikipedia.org/wiki/Duff_Beer&#39; title=&#39;Duff Beer&#39;>Duff Beer</a> and Red Tick Beer, a beer flavored with dogs.</p>', '', '', '', '', '1');
INSERT INTO `si_customers` VALUES(2, 1, 'Mr Burns', 'Springfield Power Plant', '4 Power Plant Drive', '', 'Springfield', 'NY', '90210', '', '04 1235 5698', '', '04 5678 7899', 'mburns@spp.com', '', '', '', '', '<p><strong>Springfield Nuclear Power Plant</strong> is a fictional electricity generating facility in the <a href=&#39;http://en.wikipedia.org/wiki/Television&#39; title=&#39;Television&#39;>television</a> <a href=&#39;http://en.wikipedia.org/wiki/Animated_cartoon&#39; title=&#39;Animated cartoon&#39;>animated cartoon</a> series <em><a href=&#39;http://en.wikipedia.org/wiki/The_Simpsons&#39; title=&#39;The Simpsons&#39;>The Simpsons</a></em>. The plant has a <a href=&#39;http://en.wikipedia.org/wiki/Monopoly&#39; title=&#39;Monopoly&#39;>monopoly</a> on the city of <a href=&#39;http://en.wikipedia.org/wiki/Springfield_%28The_Simpsons%29&#39; title=&#39;Springfield (The Simpsons)&#39;>Springfield&#39;s</a> energy supply, but is sometimes mismanaged and endangers much of the town with its presence.</p> <p>Based on the plant&#39;s appearance and certain episode plots, it likely houses only a single &quot;unit&quot; or reactor (although, judging from the number of <a href=&#39;http://en.wikipedia.org/wiki/Containment_building&#39; title=&#39;Containment building&#39;>containment buildings</a> and <a href=&#39;http://en.wikipedia.org/wiki/Cooling_tower&#39; title=&#39;Cooling tower&#39;>cooling towers</a>, there is a chance it may have two). In one episode an emergency occurs and Homer resorts to the manual, which begins &quot;Congratulations on your purchase of a Fissionator 1952 Slow-Fission Reactor&quot;.</p> <p>The plant is poorly maintained, largely due to owner Montgomery Burns&#39; miserliness. Its <a href=&#39;http://en.wikipedia.org/wiki/Nuclear_safety&#39; title=&#39;Nuclear safety&#39;>safety record</a> is appalling, with various episodes showing luminous rats in the bowels of the building, pipes and drums leaking radioactive waste, the disposal of waste in a children&#39;s playground, <a href=&#39;http://en.wikipedia.org/wiki/Plutonium&#39; title=&#39;Plutonium&#39;>plutonium</a> used as a paperweight, cracked cooling towers (fixed in one episode using a piece of <a href=&#39;http://en.wikipedia.org/wiki/Chewing_gum&#39; title=&#39;Chewing gum&#39;>Chewing gum</a>), dangerously high <a href=&#39;http://en.wikipedia.org/wiki/Geiger_counter&#39; title=&#39;Geiger counter&#39;>Geiger counter</a> readings around the perimeter of the plant, and even a giant spider. In the opening credits a bar of some <a href=&#39;http://en.wikipedia.org/wiki/Radioactive&#39; title=&#39;Radioactive&#39;>radioactive</a> substance is trapped in Homer&#39;s overalls and later disposed of in the street.</p>', '13245-789798', '', '', '', '1');
INSERT INTO `si_customers` VALUES(3, 1, 'Kath Day-Knight', 'Kath and Kim Pty Ltd', '82 Fountain Drive', '', 'Fountain Lakes', 'VIC', '3567', 'Australia', '03 9658 7456', '', '03 9658 7457', 'kath@kathandkim.com.au', '', '', '', '', 'Kath Day-Knight (<a href=&#39;http://en.wikipedia.org/wiki/Jane_Turner&#39; title=&#39;Jane Turner&#39;>Jane Turner</a>) is an &#39;empty nester&#39; divorc&eacute;e who wants to enjoy time with her &quot;hunk o&#39; spunk&quot; Kel Knight (<a href=&#39;http://en.wikipedia.org/wiki/Glenn_Robbins&#39; title=&#39;Glenn Robbins&#39;>Glenn Robbins</a>), a local &quot;purveyor of fine meats&quot;, but whose lifestyle is often cramped by the presence of her self-indulgent and spoilt rotten twenty-something daughter Kim Craig <a href=&#39;http://en.wikipedia.org/wiki/List_of_French_phrases_used_by_English_speakers#I_.E2.80.93_Q&#39; title=&#39;List of French phrases used by English speakers&#39;>n&eacute;e</a> Day (<a href=&#39;http://en.wikipedia.org/wiki/Gina_Riley&#39; title=&#39;Gina Riley&#39;>Gina Riley</a>). Kim enjoys frequent and lengthy periods of spiteful estrangement from her forgiving husband Brett Craig (<a href=&#39;http://en.wikipedia.org/wiki/Peter_Rowsthorn&#39; title=&#39;Peter Rowsthorn&#39;>Peter Rowsthorn</a>) for imagined slights and misdemeanors, followed by loving reconciliations with him. During Kim and Brett&#39;s frequent rough patches Kim usually seeks solace from her servile &quot;second best friend&quot; Sharon Strzelecki (<a href=&#39;http://en.wikipedia.org/wiki/Magda_Szubanski&#39; title=&#39;Magda Szubanski&#39;>Magda Szubanski</a>), screaming abuse at Sharon for minor infractions while issuing her with intricately-instructed tasks, such as stalking Brett. Kim and Brett had a baby in the final episode of the second series whom they named Epponnee-Raelene Kathleen Darlene Charlene Craig, shortened to Epponnee-Rae.', '13245-789798', '', '', '', '1');

-- --------------------------------------------------------

--
-- Table structure for table `si_custom_fields`
--

CREATE TABLE `si_custom_fields` (
  `cf_id` int(11) NOT NULL AUTO_INCREMENT,
  `cf_custom_field` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf_custom_label` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cf_display` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `domain_id` int(11) NOT NULL,
  PRIMARY KEY (`cf_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=17 ;

--
-- Dumping data for table `si_custom_fields`
--

INSERT INTO `si_custom_fields` VALUES(1, 'biller_cf1', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(2, 'biller_cf2', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(3, 'biller_cf3', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(4, 'biller_cf4', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(5, 'customer_cf1', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(6, 'customer_cf2', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(7, 'customer_cf3', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(8, 'customer_cf4', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(9, 'product_cf1', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(10, 'product_cf2', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(11, 'product_cf3', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(12, 'product_cf4', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(13, 'invoice_cf1', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(14, 'invoice_cf2', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(15, 'invoice_cf3', NULL, '0', 1);
INSERT INTO `si_custom_fields` VALUES(16, 'invoice_cf4', NULL, '0', 1);

-- --------------------------------------------------------

--
-- Table structure for table `si_extensions`
--

CREATE TABLE `si_extensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `enabled` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `si_extensions`
--

INSERT INTO `si_extensions` VALUES(1, 0, 'core', 'Core part of Simple Invoices - always enabled', '1');

-- --------------------------------------------------------

--
-- Table structure for table `si_index`
--

CREATE TABLE `si_index` (
  `id` int(11) NOT NULL,
  `node` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sub_node` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sub_node_2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `domain_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `si_index`
--

INSERT INTO `si_index` VALUES(1, 'invoice', '1', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `si_inventory`
--

CREATE TABLE `si_inventory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` decimal(25,6) NOT NULL,
  `cost` decimal(25,6) DEFAULT NULL,
  `date` date NOT NULL,
  `note` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`domain_id`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `si_invoices`
--

CREATE TABLE `si_invoices` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `index_id` int(11) NOT NULL,
  `domain_id` int(11) NOT NULL DEFAULT '1',
  `biller_id` int(10) NOT NULL DEFAULT '0',
  `customer_id` int(10) NOT NULL DEFAULT '0',
  `type_id` int(10) NOT NULL DEFAULT '0',
  `preference_id` int(10) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `custom_field1` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`domain_id`,`id`),
  KEY `domain_id` (`domain_id`),
  KEY `biller_id` (`biller_id`),
  KEY `customer_id` (`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `si_invoices`
--

INSERT INTO `si_invoices` VALUES(1, 1, 1, 4, 3, 2, 1, '2008-12-30 00:00:00', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `si_invoice_items`
--

CREATE TABLE `si_invoice_items` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(10) NOT NULL DEFAULT '0',
  `quantity` decimal(25,6) NOT NULL DEFAULT '0.000000',
  `product_id` int(10) DEFAULT '0',
  `unit_price` decimal(25,6) DEFAULT '0.000000',
  `tax_amount` decimal(25,6) DEFAULT '0.000000',
  `gross_total` decimal(25,6) DEFAULT '0.000000',
  `description` text COLLATE utf8_unicode_ci,
  `total` decimal(25,6) DEFAULT '0.000000',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `si_invoice_items`
--

INSERT INTO `si_invoice_items` VALUES(1, 1, '1.000000', 5, '125.000000', '12.500000', '125.000000', '', '137.500000');
INSERT INTO `si_invoice_items` VALUES(2, 1, '1.000000', 3, '125.000000', '12.500000', '125.000000', '', '137.500000');
INSERT INTO `si_invoice_items` VALUES(3, 1, '1.000000', 2, '140.000000', '0.000000', '140.000000', '', '140.000000');
INSERT INTO `si_invoice_items` VALUES(4, 1, '1.000000', 2, '140.000000', '14.000000', '140.000000', '', '154.000000');
INSERT INTO `si_invoice_items` VALUES(5, 1, '1.000000', 1, '150.000000', '0.000000', '150.000000', '', '150.000000');

-- --------------------------------------------------------

--
-- Table structure for table `si_invoice_item_tax`
--

CREATE TABLE `si_invoice_item_tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_item_id` int(11) NOT NULL,
  `tax_id` int(11) NOT NULL,
  `tax_type` varchar(1) COLLATE utf8_unicode_ci NOT NULL,
  `tax_rate` decimal(25,6) NOT NULL,
  `tax_amount` decimal(25,6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `si_invoice_item_tax`
--

INSERT INTO `si_invoice_item_tax` VALUES(1, 1, 3, '%', '10.000000', '12.500000');
INSERT INTO `si_invoice_item_tax` VALUES(2, 2, 1, '%', '10.000000', '12.500000');
INSERT INTO `si_invoice_item_tax` VALUES(3, 3, 4, '%', '0.000000', '0.000000');
INSERT INTO `si_invoice_item_tax` VALUES(4, 4, 1, '%', '10.000000', '14.000000');
INSERT INTO `si_invoice_item_tax` VALUES(5, 5, 4, '%', '0.000000', '0.000000');

-- --------------------------------------------------------

--
-- Table structure for table `si_invoice_type`
--

CREATE TABLE `si_invoice_type` (
  `inv_ty_id` int(11) NOT NULL AUTO_INCREMENT,
  `inv_ty_description` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`inv_ty_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `si_invoice_type`
--

INSERT INTO `si_invoice_type` VALUES(1, 'Total');
INSERT INTO `si_invoice_type` VALUES(2, 'Itemised');
INSERT INTO `si_invoice_type` VALUES(3, 'Consulting');

-- --------------------------------------------------------

--
-- Table structure for table `si_log`
--

CREATE TABLE `si_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `userid` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `sqlquerie` text COLLATE utf8_unicode_ci NOT NULL,
  `last_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=24 ;

-- --------------------------------------------------------

--
-- Table structure for table `si_payment`
--

CREATE TABLE `si_payment` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ac_inv_id` int(11) NOT NULL,
  `ac_amount` decimal(25,6) NOT NULL,
  `ac_notes` text COLLATE utf8_unicode_ci NOT NULL,
  `ac_date` datetime NOT NULL,
  `ac_payment_type` int(10) NOT NULL DEFAULT '1',
  `domain_id` int(11) NOT NULL,
  `online_payment_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`domain_id`,`id`),
  KEY `domain_id` (`domain_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `si_payment_types`
--

CREATE TABLE `si_payment_types` (
  `pt_id` int(10) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL DEFAULT '1',
  `pt_description` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `pt_enabled` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  PRIMARY KEY (`domain_id`,`pt_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `si_payment_types`
--

INSERT INTO `si_payment_types` VALUES(1, 1, 'Cash', '1');
INSERT INTO `si_payment_types` VALUES(2, 1, 'Credit Card', '1');

-- --------------------------------------------------------

--
-- Table structure for table `si_preferences`
--

CREATE TABLE `si_preferences` (
  `pref_id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL DEFAULT '1',
  `pref_description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_currency_sign` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_inv_heading` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_inv_wording` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_inv_detail_heading` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_inv_detail_line` text COLLATE utf8_unicode_ci,
  `pref_inv_payment_method` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_inv_payment_line1_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_inv_payment_line1_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_inv_payment_line2_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_inv_payment_line2_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pref_enabled` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `status` int(1) NOT NULL,
  `locale` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `index_group` int(11) NOT NULL,
  `currency_code` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  `include_online_payment` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency_position` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`domain_id`,`pref_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `si_preferences`
--

INSERT INTO `si_preferences` VALUES(1, 1, 'Invoice', '$', 'Invoice', 'Invoice', 'Details', 'Payment is to be made within 14 days of the invoice being sent', 'Electronic Funds Transfer', 'Account name', 'H. & M. Simpson', 'Account number:', '0123-4567-7890', '1', 1, 'en_GB', 'en_GB', 1, 'USD', NULL, 'left');
INSERT INTO `si_preferences` VALUES(2, 1, 'Receipt', '$', 'Receipt', 'Receipt', 'Details', '<br />This transaction has been paid in full, please keep this receipt as proof of purchase.<br /> Thank you', '', '', '', '', '', '1', 1, 'en_GB', 'en_GB', 1, 'USD', NULL, 'left');
INSERT INTO `si_preferences` VALUES(3, 1, 'Estimate', '$', 'Estimate', 'Estimate', 'Details', '<br />This is an estimate of the final value of services rendered.<br />Thank you', '', '', '', '', '', '1', 1, 'en_GB', 'en_GB', 1, 'USD', NULL, 'left');
INSERT INTO `si_preferences` VALUES(4, 1, 'Quote', '$', 'Quote', 'Quote', 'Details', '<br />This is a quote of the final value of services rendered.<br />Thank you', '', '', '', '', '', '1', 1, 'en_GB', 'en_GB', 1, 'USD', NULL, 'left');

-- --------------------------------------------------------

--
-- Table structure for table `si_products`
--

CREATE TABLE `si_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL DEFAULT '1',
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `unit_price` decimal(25,6) DEFAULT '0.000000',
  `default_tax_id` int(11) DEFAULT NULL,
  `default_tax_id_2` int(11) DEFAULT NULL,
  `cost` decimal(25,6) DEFAULT '0.000000',
  `reorder_level` int(11) DEFAULT NULL,
  `custom_field1` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8_unicode_ci NOT NULL,
  `enabled` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`domain_id`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `si_products`
--

INSERT INTO `si_products` VALUES(1, 1, 'Hourly charge', '150.000000', 1, 0, '0.000000', 0, '', '', '', '', '', '1', 1);
INSERT INTO `si_products` VALUES(2, 1, 'Accounting services', '140.000000', 1, 0, '0.000000', 0, '', '', '', '', '', '1', 1);
INSERT INTO `si_products` VALUES(3, 1, 'Ploughing service', '125.000000', 1, 0, '0.000000', 0, '', '', '', '', '', '1', 1);
INSERT INTO `si_products` VALUES(4, 1, 'Bootleg homebrew', '15.500000', 1, 0, '0.000000', 0, '', '', '', '', '', '1', 1);
INSERT INTO `si_products` VALUES(5, 1, 'Accomodation', '125.500000', 1, 0, '0.000000', 0, '', '', '', '', '', '1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `si_sql_patchmanager`
--

CREATE TABLE `si_sql_patchmanager` (
  `sql_id` int(11) NOT NULL AUTO_INCREMENT,
  `sql_patch_ref` int(11) NOT NULL,
  `sql_patch` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `sql_release` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sql_statement` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`sql_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=798 ;

--
-- Dumping data for table `si_sql_patchmanager`
--

INSERT INTO `si_sql_patchmanager` VALUES(1, 1, 'Create sql_patchmanger table', '20060514', 'CREATE TABLE si_sql_patchmanager (sql_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,sql_patch_ref VARCHAR( 50 ) NOT NULL ,sql_patch VARCHAR( 255 ) NOT NULL ,sql_release VARCHAR( 25 ) NOT NULL ,sql_statement TEXT NOT NULL) ENGINE = MYISAM ');
INSERT INTO `si_sql_patchmanager` VALUES(2, 2, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(3, 3, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(4, 4, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(5, 5, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(6, 6, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(7, 7, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(8, 8, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(9, 9, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(10, 10, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(11, 11, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(12, 12, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(13, 13, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(14, 14, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(15, 15, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(16, 16, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(17, 17, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(18, 18, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(19, 19, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(20, 20, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(21, 21, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(22, 22, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(23, 23, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(24, 24, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(25, 25, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(26, 26, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(27, 27, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(28, 28, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(29, 29, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(30, 30, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(31, 31, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(32, 32, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(33, 33, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(34, 34, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(35, 35, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(36, 36, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(37, 0, 'Start', '20060514', '');
INSERT INTO `si_sql_patchmanager` VALUES(38, 37, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(39, 38, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(40, 39, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(41, 40, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(42, 41, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(43, 42, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(44, 43, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(45, 44, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(46, 45, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(47, 46, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(48, 47, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(49, 48, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(50, 49, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(51, 50, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(52, 51, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(53, 52, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(54, 53, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(599, 54, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(600, 55, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(601, 56, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(602, 57, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(603, 58, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(604, 59, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(605, 60, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(606, 61, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(607, 62, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(608, 63, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(609, 64, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(610, 65, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(611, 66, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(612, 67, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(613, 68, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(614, 69, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(615, 70, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(616, 71, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(617, 72, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(618, 73, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(619, 74, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(620, 75, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(621, 76, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(622, 77, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(623, 78, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(624, 79, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(625, 80, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(626, 81, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(627, 82, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(628, 83, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(629, 84, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(630, 85, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(631, 86, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(632, 87, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(633, 88, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(634, 89, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(635, 90, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(636, 91, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(637, 92, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(638, 93, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(639, 94, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(640, 95, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(641, 96, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(642, 97, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(643, 98, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(644, 99, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(645, 100, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(646, 101, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(647, 102, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(648, 103, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(649, 104, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(650, 105, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(651, 106, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(652, 107, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(653, 108, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(654, 109, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(655, 110, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(656, 111, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(657, 112, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(658, 113, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(659, 114, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(660, 115, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(661, 116, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(662, 117, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(663, 118, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(664, 119, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(665, 120, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(666, 121, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(667, 122, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(668, 123, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(669, 124, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(670, 125, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(671, 126, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(672, 127, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(673, 128, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(674, 129, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(675, 130, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(676, 131, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(677, 132, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(678, 133, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(679, 134, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(680, 135, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(681, 136, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(682, 137, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(683, 138, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(684, 139, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(685, 140, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(686, 141, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(687, 142, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(688, 143, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(689, 144, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(690, 145, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(691, 146, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(692, 147, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(693, 148, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(694, 149, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(695, 150, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(696, 151, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(697, 152, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(698, 153, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(699, 154, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(700, 155, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(701, 156, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(702, 157, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(703, 158, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(704, 159, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(705, 160, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(706, 161, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(707, 162, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(708, 163, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(709, 164, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(710, 165, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(711, 166, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(712, 167, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(713, 168, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(714, 169, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(715, 170, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(716, 171, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(717, 172, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(718, 173, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(719, 174, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(720, 175, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(721, 176, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(722, 177, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(723, 178, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(724, 179, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(725, 180, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(726, 181, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(727, 182, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(728, 183, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(729, 184, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(730, 185, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(731, 186, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(732, 187, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(733, 188, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(734, 189, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(735, 190, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(736, 191, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(737, 192, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(738, 193, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(739, 194, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(740, 195, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(741, 196, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(742, 197, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(743, 198, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(744, 199, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(745, 200, 'Update extensions table', '20090529', 'UPDATE si_extensions SET id = 0 WHERE name = core LIMIT 1');
INSERT INTO `si_sql_patchmanager` VALUES(746, 201, 'Set domain_id on system defaults table to 1', '20090622', 'UPDATE si_system_defaults SET domain_id = 1');
INSERT INTO `si_sql_patchmanager` VALUES(747, 202, 'Set extension_id on system defaults table to 1', '20090622', 'UPDATE si_system_defaults SET extension_id = 1');
INSERT INTO `si_sql_patchmanager` VALUES(748, 203, 'Move all old consulting style invoices to itemised', '20090704', 'UPDATE si_invoices SET type_id = 2 where type_id = 3');
INSERT INTO `si_sql_patchmanager` VALUES(749, 204, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(750, 205, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(751, 206, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(752, 207, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(753, 208, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(754, 209, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(755, 210, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(756, 210, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(757, 211, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(758, 212, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(759, 213, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(760, 214, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(761, 215, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(762, 216, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(763, 217, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(764, 218, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(765, 219, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(766, 220, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(767, 221, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(768, 222, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(769, 223, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(770, 224, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(771, 225, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(772, 226, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(773, 227, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(774, 228, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(775, 229, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(776, 230, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(777, 231, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(778, 232, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(779, 233, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(780, 234, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(781, 235, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(782, 236, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(783, 237, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(784, 238, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(785, 239, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(786, 240, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(787, 241, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(788, 242, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(789, 243, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(790, 244, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(791, 245, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(792, 246, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(793, 247, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(794, 248, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(795, 249, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(796, 250, '', '', '');
INSERT INTO `si_sql_patchmanager` VALUES(797, 251, '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `si_system_defaults`
--

CREATE TABLE `si_system_defaults` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `domain_id` int(5) NOT NULL DEFAULT '0',
  `extension_id` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`domain_id`,`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=24 ;

--
-- Dumping data for table `si_system_defaults`
--

INSERT INTO `si_system_defaults` VALUES(1, 'biller', '4', 1, 1);
INSERT INTO `si_system_defaults` VALUES(2, 'customer', '3', 1, 1);
INSERT INTO `si_system_defaults` VALUES(3, 'tax', '1', 1, 1);
INSERT INTO `si_system_defaults` VALUES(4, 'preference', '1', 1, 1);
INSERT INTO `si_system_defaults` VALUES(5, 'line_items', '5', 1, 1);
INSERT INTO `si_system_defaults` VALUES(6, 'template', 'default', 1, 1);
INSERT INTO `si_system_defaults` VALUES(7, 'payment_type', '1', 1, 1);
INSERT INTO `si_system_defaults` VALUES(8, 'language', '[[language]]', 1, 1);
INSERT INTO `si_system_defaults` VALUES(9, 'dateformate', 'Y-m-d', 1, 1);
INSERT INTO `si_system_defaults` VALUES(10, 'spreadsheet', 'xls', 1, 1);
INSERT INTO `si_system_defaults` VALUES(11, 'wordprocessor', 'doc', 1, 1);
INSERT INTO `si_system_defaults` VALUES(12, 'pdfscreensize', '800', 1, 1);
INSERT INTO `si_system_defaults` VALUES(13, 'pdfpapersize', 'A4', 1, 1);
INSERT INTO `si_system_defaults` VALUES(14, 'pdfleftmargin', '15', 1, 1);
INSERT INTO `si_system_defaults` VALUES(15, 'pdfrightmargin', '15', 1, 1);
INSERT INTO `si_system_defaults` VALUES(16, 'pdftopmargin', '15', 1, 1);
INSERT INTO `si_system_defaults` VALUES(17, 'pdfbottommargin', '15', 1, 1);
INSERT INTO `si_system_defaults` VALUES(18, 'emailhost', 'localhost', 1, 1);
INSERT INTO `si_system_defaults` VALUES(19, 'emailusername', '', 1, 1);
INSERT INTO `si_system_defaults` VALUES(20, 'emailpassword', '', 1, 1);
INSERT INTO `si_system_defaults` VALUES(21, 'logging', '0', 1, 1);
INSERT INTO `si_system_defaults` VALUES(22, 'delete', 'N', 1, 1);
INSERT INTO `si_system_defaults` VALUES(23, 'tax_per_line_item', '1', 1, 1);
INSERT INTO `si_system_defaults` VALUES(24, 'inventory', '0', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `si_tax`
--

CREATE TABLE `si_tax` (
  `tax_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_percentage` decimal(25,6) DEFAULT '0.000000',
  `type` varchar(1) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_enabled` varchar(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `domain_id` int(11) NOT NULL,
  PRIMARY KEY (`domain_id`,`tax_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `si_tax`
--

INSERT INTO `si_tax` VALUES(1, 'GST', '10.000000', '%', '1', 1);
INSERT INTO `si_tax` VALUES(2, 'VAT', '10.000000', '%', '1', 1);
INSERT INTO `si_tax` VALUES(3, 'Sales Tax', '10.000000', '%', '1', 1);
INSERT INTO `si_tax` VALUES(4, 'No Tax', '0.000000', '%', '1', 1);
INSERT INTO `si_tax` VALUES(5, 'Postage', '20.000000', '$', '1', 1);

-- --------------------------------------------------------

--
-- Table structure for table `si_user`
--

CREATE TABLE `si_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `domain_id` int(11) NOT NULL DEFAULT '0',
  `password` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enabled` int(1) NOT NULL,
  PRIMARY KEY (`domain_id`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `si_user`
--

INSERT INTO `si_user` VALUES(1, '[[admin_email]]', 1, 1, '[[admin_pass]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `si_user_domain`
--

CREATE TABLE `si_user_domain` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `si_user_domain`
--

INSERT INTO `si_user_domain` VALUES(1, 'default');

-- --------------------------------------------------------

--
-- Table structure for table `si_user_role`
--

CREATE TABLE `si_user_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `si_user_role`
--

INSERT INTO `si_user_role` VALUES(1, 'administrator');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
