
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `testimppage`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]administrator`
--

CREATE TABLE `[[dbprefix]]administrator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL DEFAULT '',
  `hash` text NOT NULL,
  `email` varchar(255) NOT NULL DEFAULT '',
  `resetSecret` varchar(32) DEFAULT NULL,
  `resetTime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]administrator`
--

INSERT INTO `[[dbprefix]]administrator` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_queue`
--

CREATE TABLE `[[dbprefix]]email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` mediumtext NOT NULL,
  `to` varchar(255) NOT NULL,
  `toName` varchar(255) DEFAULT NULL,
  `from` varchar(255) NOT NULL,
  `fromName` varchar(255) DEFAULT NULL,
  `subject` varchar(255) NOT NULL,
  `immediate` tinyint(1) NOT NULL DEFAULT '0',
  `html` tinyint(1) NOT NULL,
  `send` timestamp NULL DEFAULT NULL,
  `lock` varchar(32) DEFAULT NULL,
  `lockedAt` timestamp NULL DEFAULT NULL,
  `files` mediumtext,
  `fileNames` mediumtext,
  `fileMimeTypes` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]inline_value_global`
--

CREATE TABLE `[[dbprefix]]inline_value_global` (
  `plugin` varchar(100) NOT NULL,
  `key` varchar(100) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`plugin`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]inline_value_language`
--

CREATE TABLE `[[dbprefix]]inline_value_language` (
  `plugin` varchar(100) NOT NULL,
  `key` varchar(100) NOT NULL,
  `languageId` int(11) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`plugin`,`key`,`languageId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]inline_value_page`
--

CREATE TABLE `[[dbprefix]]inline_value_page` (
  `plugin` varchar(100) NOT NULL,
  `key` varchar(100) NOT NULL,
  `pageId` int(11) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`plugin`,`key`,`pageId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]language`
--

CREATE TABLE `[[dbprefix]]language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `abbreviation` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `languageOrder` double NOT NULL DEFAULT '0',
  `isVisible` int(1) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL,
  `textDirection` varchar(10) NOT NULL DEFAULT 'ltr',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]language`
--

INSERT INTO `[[dbprefix]]language` VALUES
(1, 'EN', 'English', 2, 1, '', 'en', 'ltr');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log`
--

CREATE TABLE `[[dbprefix]]log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `level` varchar(255) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `context` mediumtext,
  PRIMARY KEY (`id`),
  KEY `time` (`time`),
  KEY `message` (`message`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]log`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page`
--

CREATE TABLE `[[dbprefix]]page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `languageCode` varchar(6) CHARACTER SET latin1 COLLATE latin1_general_ci DEFAULT NULL,
  `urlPath` varchar(140) DEFAULT NULL,
  `parentId` int(11) DEFAULT NULL,
  `pageOrder` double NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `metaTitle` mediumtext,
  `keywords` mediumtext,
  `description` mediumtext,
  `type` varchar(255) NOT NULL DEFAULT 'default',
  `alias` varchar(255) DEFAULT NULL,
  `layout` varchar(255) DEFAULT NULL,
  `redirectUrl` varchar(255) DEFAULT NULL,
  `isVisible` tinyint(1) NOT NULL DEFAULT '0',
  `isDisabled` tinyint(1) NOT NULL DEFAULT '0',
  `isSecured` tinyint(1) NOT NULL DEFAULT '0',
  `isDeleted` tinyint(1) NOT NULL DEFAULT '0',
  `isBlank` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Open page in new window',
  `createdAt` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updatedAt` timestamp NULL DEFAULT NULL,
  `deletedAt` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`urlPath`,`languageCode`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]page`
--

INSERT INTO `[[dbprefix]]page` VALUES
(1, 'en', NULL, 0, 0, 'Menu1', NULL, NULL, NULL, 'default', 'menu1', 'main.php', NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL),
(2, 'en', NULL, 0, 1, 'Menu2', NULL, NULL, NULL, 'default', 'menu2', 'main.php', NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL),
(3, 'en', NULL, 0, 2, 'Menu3', NULL, NULL, NULL, 'default', 'menu3', 'main.php', NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL),
(4, 'en', 'home/', 1, 0, 'Home', NULL, NULL, NULL, 'default', NULL, 'home.php', NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL),
(5, 'en', 'lorem-ipsumy/', 1, 1, 'Lorem ipsum', NULL, NULL, NULL, 'default', NULL, NULL, NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL),
(6, 'en', 'page1/', 2, 0, 'Page1', NULL, NULL, NULL, 'default', NULL, NULL, NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL),
(7, 'en', 'page2/', 2, 1, 'Page2', NULL, NULL, NULL, 'default', NULL, NULL, NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL),
(8, 'en', 'example1/', 3, 0, 'Example 1', NULL, NULL, NULL, 'default', NULL, NULL, NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL),
(9, 'en', 'example2/', 3, 1, 'Example 2', NULL, NULL, NULL, 'default', NULL, NULL, NULL, 1, 0, 0, 0, 0, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]page_storage`
--

CREATE TABLE `[[dbprefix]]page_storage` (
  `pageId` int(10) unsigned NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  UNIQUE KEY `pageKey` (`pageId`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]permission`
--

CREATE TABLE `[[dbprefix]]permission` (
  `administratorId` int(11) NOT NULL DEFAULT '0',
  `permission` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`administratorId`,`permission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]permission`
--

INSERT INTO `[[dbprefix]]permission` VALUES
(1, 'Super admin');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugin`
--

CREATE TABLE `[[dbprefix]]plugin` (
  `title` varchar(100) NOT NULL,
  `name` varchar(30) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `version` decimal(10,2) NOT NULL,
  `isActive` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]plugin`
--

INSERT INTO `[[dbprefix]]plugin` VALUES
('Application', 'Application', 1.00, 1),
('Colorbox', 'Colorbox', 1.00, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_file`
--

CREATE TABLE `[[dbprefix]]repository_file` (
  `fileId` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `plugin` varchar(255) NOT NULL,
  `baseDir` varchar(255) NOT NULL,
  `instanceId` int(11) NOT NULL COMMENT 'Unique identificator. Tells in which part of the module the file is used. Teoretically there could be two identical records. The same module binds the same file to the same instance. For example: gallery widget adds the same photo twice.',
  `createdAt` int(11) NOT NULL COMMENT 'Time, when this module started to use this resource.',
  PRIMARY KEY (`fileId`),
  KEY `filename` (`filename`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='File usage table. Track which modules uses which files' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]repository_reflection`
--

CREATE TABLE `[[dbprefix]]repository_reflection` (
  `reflectionId` int(11) NOT NULL AUTO_INCREMENT,
  `options` text CHARACTER SET ascii COLLATE ascii_bin NOT NULL,
  `optionsFingerprint` char(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL COMMENT 'unique cropping options key',
  `original` varchar(255) NOT NULL,
  `reflection` varchar(255) NOT NULL COMMENT 'Cropped version of original file.',
  `createdAt` int(11) NOT NULL,
  PRIMARY KEY (`reflectionId`),
  KEY `optionsFingerprint` (`optionsFingerprint`,`original`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cropped versions of original image file' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]revision`
--

CREATE TABLE `[[dbprefix]]revision` (
  `revisionId` int(11) NOT NULL AUTO_INCREMENT,
  `pageId` int(11) NOT NULL DEFAULT '0',
  `isPublished` tinyint(1) NOT NULL DEFAULT '0',
  `createdAt` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`revisionId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]revision`
--

INSERT INTO `[[dbprefix]]revision` VALUES
(1, 4, 1, '[[regtime]]'),
(2, 5, 1, '[[regtime]]'),
(3, 4, 0, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]storage`
--

CREATE TABLE `[[dbprefix]]storage` (
  `plugin` varchar(40) NOT NULL,
  `key` varchar(100) NOT NULL,
  `value` text NOT NULL,
  UNIQUE KEY `pluginkey` (`plugin`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]storage`
--

INSERT INTO `[[dbprefix]]storage` VALUES
('Admin', 'failedLogins', '[]'),
('Config', 'Config.automaticCron', '"1"'),
('Config', 'Config.availableFonts', '"Arial,Arial,Helvetica,sans-serif\\nArial Black,Arial Black,Gadget,sans-serif\\nComic Sans MS,Comic Sans MS,cursive\\nCourier New,Courier New,Courier,monospace\\nGeorgia,Georgia,serif\\nImpact,Charcoal,sans-serif\\nLucida Console,Monaco,monospace\\nLucida Sans Unicode,Lucida Grande,sans-serif\\nPalatino Linotype,Book Antiqua,Palatino,serif\\nTahoma,Geneva,sans-serif\\nTimes New Roman,Times,serif\\nTrebuchet MS,Helvetica,sans-serif\\nVerdana,Geneva,sans-serif\\nGill Sans,Geneva,sans-serif"'),
('Config', 'Config.cronPassword', '[[ConfigcronPassword]]'),
('Config', 'Config.defaultImageQuality', '80'),
('Config', 'Config.en.websiteEmail', '"[[admin_email]]"'),
('Config', 'Config.en.websiteTitle', '"[[sn]]"'),
('Config', 'Config.gmapsApiKey', ''),
('Config', 'Config.lightboxHeight', '600'),
('Config', 'Config.lightboxWidth', '800'),
('Config', 'Config.reservedDirs', '["file","install","Ip","Plugin","update","Theme","index.php","admin","admin.php"]'),
('Config', 'Config.trailingSlash', '1'),
('Config', 'Content.widgetGalleryHeight', '200'),
('Config', 'Content.widgetGalleryQuality', '90'),
('Config', 'Content.widgetGalleryWidth', '200'),
('Config', 'Content.widgetImageHeight', '800'),
('Config', 'Content.widgetImageWidth', '1160'),
('Config', 'Design.themeDirs', '""'),
('Config', 'Email.hourlyLimit', '100'),
('Config', 'Pages.hideNewPages', '0'),
('Cron', 'lastExecutionEnd', '[[timestamp]]'),
('Cron', 'lastExecutionStart', '[[timestamp]]'),
('Ip', 'cachedBaseUrl', '"[[cachedBaseUrl]]\\/"'),
('Ip', 'cacheVersion', '1'),
('Ip', 'dbVersion', '101'),
('Ip', 'getImpressPagesSupport', '"1"'),
('Ip', 'lastSystemMessageSent', ''),
('Ip', 'lastSystemMessageShown', ''),
('Ip', 'theme', '"Air"'),
('Ip', 'version', '"5.0.3"'),
('Ip', 'websiteId', '"[[websiteId]]"');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]theme_storage`
--

CREATE TABLE `[[dbprefix]]theme_storage` (
  `theme` varchar(100) NOT NULL,
  `key` varchar(100) NOT NULL,
  `value` varchar(255) NOT NULL,
  UNIQUE KEY `themeKey` (`theme`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]widget`
--

CREATE TABLE `[[dbprefix]]widget` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `skin` varchar(25) NOT NULL,
  `data` text NOT NULL,
  `revisionId` int(11) NOT NULL,
  `languageId` int(11) NOT NULL,
  `blockName` varchar(25) NOT NULL,
  `position` double NOT NULL,
  `isVisible` tinyint(1) NOT NULL DEFAULT '1',
  `isDeleted` tinyint(1) NOT NULL DEFAULT '0',
  `createdAt` int(11) NOT NULL COMMENT 'unix timestamp',
  `updatedAt` int(11) NOT NULL,
  `deletedAt` int(11) DEFAULT NULL COMMENT 'unix timestamp',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]widget`
--

INSERT INTO `[[dbprefix]]widget` VALUES
(1, 'Heading', 'default', '{"title":"Homepage","level":"1"}', 1, 0, 'main', 50, 1, 0, [[timestamp]], [[timestamp]], NULL),
(2, 'Text', 'default', '{"text":"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec accumsan, tellus posuere sodales rhoncus, nulla nulla dignissim leo, ac consectetur elit mauris quis leo. Phasellus odio orci, ultricies sit amet tristique ac, varius at nisi. Vivamus eros massa, aliquet at sem ut, placerat interdum elit. Vivamus nisi augue, auctor eget malesuada vel, pulvinar eget orci. Quisque sit amet posuere augue. Aenean sodales augue non aliquam molestie. Nunc feugiat aliquam orci a aliquet. Aenean fermentum enim a luctus posuere. Mauris elementum facilisis urna, a adipiscing tortor congue vel. Nullam facilisis ultrices quam. Donec nunc orci, ullamcorper hendrerit nunc a, fringilla rhoncus est. Suspendisse laoreet posuere sapien.<\\/span>\\u00a0<\\/p>"}', 1, 0, 'main', 90, 1, 0, [[timestamp]], [[timestamp]], NULL),
(3, 'Heading', 'default', '{"title":"Page content","level":"1"}', 2, 0, 'main', 50, 1, 0, [[timestamp]], [[timestamp]], NULL),
(4, 'Text', 'default', '{"text":"<p><span>Aliquam erat volutpat. Donec rutrum venenatis dignissim. Duis eu neque in neque venenatis tincidunt sit amet sed velit. Pellentesque quis luctus orci. Phasellus sed aliquam risus, eu varius sapien. Etiam ac adipiscing enim, eu molestie erat. Donec sodales pulvinar lorem, ut sagittis purus suscipit nec. In id velit nec nisi porta egestas. Maecenas rutrum felis vel nunc varius, vel ornare lectus dignissim. Maecenas vitae ante dui. Maecenas sollicitudin dolor at enim porttitor, eu placerat nulla adipiscing. Morbi sed varius nisi, sed posuere risus. Ut velit urna, dignissim ac lobortis id, sollicitudin non libero. Donec arcu massa, facilisis ut sapien et, aliquet porta dui.<\\/span>\\u00a0<\\/p>"}', 2, 0, 'main', 90, 1, 0, [[timestamp]], [[timestamp]], NULL),
(5, 'Heading', 'default', '{"title":"Homepage","level":"1"}', 3, 0, 'main', 50, 1, 0, [[timestamp]], [[timestamp]], NULL),
(6, 'Text', 'default', '{"text":"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec accumsan, tellus posuere sodales rhoncus, nulla nulla dignissim leo, ac consectetur elit mauris quis leo. Phasellus odio orci, ultricies sit amet tristique ac, varius at nisi. Vivamus eros massa, aliquet at sem ut, placerat interdum elit. Vivamus nisi augue, auctor eget malesuada vel, pulvinar eget orci. Quisque sit amet posuere augue. Aenean sodales augue non aliquam molestie. Nunc feugiat aliquam orci a aliquet. Aenean fermentum enim a luctus posuere. Mauris elementum facilisis urna, a adipiscing tortor congue vel. Nullam facilisis ultrices quam. Donec nunc orci, ullamcorper hendrerit nunc a, fringilla rhoncus est. Suspendisse laoreet posuere sapien.<\\/span>\\u00a0<\\/p>"}', 3, 0, 'main', 90, 1, 0, [[timestamp]], [[timestamp]], NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]widget_order`
--

CREATE TABLE `[[dbprefix]]widget_order` (
  `widgetName` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `widgetName` (`widgetName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]widget_order`
--

INSERT INTO `[[dbprefix]]widget_order` VALUES
('Divider', 30),
('File', 60),
('Gallery', 50),
('Heading', 10),
('Html', 80),
('Image', 40),
('Map', 100),
('Text', 20),
('Video', 90);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
