<?php

namespace Ip\Internal\Admin;


class AdminController extends \Ip\Controller
{
    public function removeAdminIsAutogeneratedAjax()
    {
        ipRequest()->mustBePost();

        // Removing temporary data
        ipStorage()->remove('Ip', 'adminIsAutogenerated');

        // If user wants to change credentials, redirecting to Administrators list
        if (ipRequest()->getPost('action') == 'change') {
            // todo: redirect and automatically select user and open popup
            $redirect = ipActionUrl(
                    array('aa' => 'Administrators.index')
                ) . "#/hash=&administrator=" . \Ip\Internal\Admin\Backend::userId();

            \Ip\Internal\System\Model::sendUsageStatistics(array('action' => 'Install.adminChange'));
            return \Ip\Response\JsonRpc::result(array('redirect' => $redirect));
        }

        \Ip\Internal\System\Model::sendUsageStatistics(array('action' => 'Install.adminKeep'));
        return \Ip\Response\JsonRpc::result(array('close' => 1));
    }
}
