
rule heuristic_php_suspicious_log
{
    strings:
        $a = "@error_reporting(0)"
        $b = "@set_time_limit(0)"
        $c = "gzinflate(substr"
        $d = "ini_set('error_log', NULL"
        $e = "ini_set('log_errors', 0)"
    condition:
        $a and ($b or $c or $d or $e)
}

rule heuristic_php_uploader
{
    strings:
        $a = /@file_put_contents.{,80},base64_decode\(file_get_contents\($_POST\["."\]\)\)\);/
    condition:
        any of them
}

rule heuristic_php_suspicious
{
    strings:
        $a = /[^ ]=str_ireplace\(".","","/
    condition:
        PHP_MAGIC and $a in (0..30)
}

rule heuristic_php_dictionary
{
    strings:
        // Matches:
        //<?php
        //$blnop = 'sl7xmgrdtb59uenp2o#i\'ak6vf-_31*H40yc';$mswus = Array();$mswus[] = $blnop[9].$blnop[23]...
        $dictionary_decode = /^<\?php\n\$\w{1,9} = '([^\n']|\\'){26,62}';\$\w{1,9} = Array\(\);\$\w{1,9}\[] = \$\w{1,9}\[/
    condition:
        any of them
}

rule heuristic_base64_inject
{
    strings:
        $re1 = /(eval|system)\(base64_decode\(/
    condition:
        any of them
}
rule php_obfuscated_eval
{
    strings:
        $a = "eval($___"
        $b = /eval(\(str_rot13)?\(gzinflate\(/
        $c = "eval(${$s20}"
        $d = "eval(pack("
        $e = "eval(gzuncompress"
        $f = "eval(gzinflate(base64_decode"
        $g = "eval (gzinflate(base64_decode"
        $h = /eval\(\/\*\d{1,5}\*\/String\.fromCharCode/
    condition:
        PHP and any of them
}

rule heuristic_php_obfuscated_variables
{
    strings:
        $a = /(\$[O0]{6}\{\d{1,2}\}\.){6,}/
    condition:
        PHP and $a
}

rule php_heuristic_ico
{
    strings:
        // $_rlkxp = basename/*mu*/(/*6bh*/trim/*n3u*/
        $include_ico = /<\?php\n\$_[a-z0-9]{1,12} = basename\/\*[a-z0-9]{1,12}\*\/\(\/\*/
    condition:
        $include_ico at 0
}

