-- MySQL dump 10.13  Distrib 5.6.46, for Linux (x86_64)
--
-- Host: localhost    Database: helpdezk1110
-- ------------------------------------------------------
-- Server version	5.6.46

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `bbd_tbmessage`
--

DROP TABLE IF EXISTS `bbd_tbmessage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bbd_tbmessage` (
  `idmessage` int(11) NOT NULL AUTO_INCREMENT,
  `idtopic` int(11) NOT NULL,
  `idperson` int(11) NOT NULL,
  `title` varchar(100) DEFAULT NULL,
  `description` text,
  `dtcreate` datetime DEFAULT NULL,
  `dtstart` datetime DEFAULT NULL,
  `dtend` datetime DEFAULT NULL,
  `sendemail` varchar(1) NOT NULL,
  `showin` varchar(1) NOT NULL,
  `emailsent` int(1) DEFAULT '0',
  PRIMARY KEY (`idmessage`),
  KEY `fk_bbd_tbmessage_bbd_topic1` (`idtopic`),
  KEY `fk_bbd_tbmessage_tbperson1` (`idperson`),
  CONSTRAINT `fk_bbd_tbmessage_bbd_topic1` FOREIGN KEY (`idtopic`) REFERENCES `bbd_topic` (`idtopic`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bbd_tbmessage_tbperson1` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bbd_tbmessage`
--

LOCK TABLES `bbd_tbmessage` WRITE;
/*!40000 ALTER TABLE `bbd_tbmessage` DISABLE KEYS */;
INSERT INTO `bbd_tbmessage` VALUES (1,1,1,'Email sending issue .','The email service (SMTP) has problems when sending emails. But receiving emails (POP / IMAP) is working normally.Our infrastructure team is working to resolve the issue as quickly as possible.','2016-02-25 19:48:56','2019-12-26 19:48:00','2046-10-12 01:00:00','N','3',0);
/*!40000 ALTER TABLE `bbd_tbmessage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bbd_tbread`
--

DROP TABLE IF EXISTS `bbd_tbread`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bbd_tbread` (
  `idread` int(11) NOT NULL AUTO_INCREMENT,
  `dtread` datetime NOT NULL,
  `idperson` int(11) NOT NULL,
  `idmessage` int(11) NOT NULL,
  PRIMARY KEY (`idread`),
  KEY `fk_bbd_tbread_tbperson1` (`idperson`),
  CONSTRAINT `fk_bbd_tbread_tbperson1` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bbd_tbread`
--

LOCK TABLES `bbd_tbread` WRITE;
/*!40000 ALTER TABLE `bbd_tbread` DISABLE KEYS */;
/*!40000 ALTER TABLE `bbd_tbread` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bbd_topic`
--

DROP TABLE IF EXISTS `bbd_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bbd_topic` (
  `idtopic` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `default_display` varchar(10) DEFAULT NULL,
  `fl_emailsent` varchar(1) DEFAULT 'N',
  PRIMARY KEY (`idtopic`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bbd_topic`
--

LOCK TABLES `bbd_topic` WRITE;
/*!40000 ALTER TABLE `bbd_topic` DISABLE KEYS */;
INSERT INTO `bbd_topic` VALUES (1,'Servers','','N');
/*!40000 ALTER TABLE `bbd_topic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bbd_topic_company`
--

DROP TABLE IF EXISTS `bbd_topic_company`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bbd_topic_company` (
  `idtopiccompany` int(11) NOT NULL AUTO_INCREMENT,
  `idtopic` int(11) NOT NULL,
  `idcompany` int(11) NOT NULL,
  PRIMARY KEY (`idtopiccompany`),
  KEY `idtopic` (`idtopic`),
  KEY `idcompany` (`idcompany`),
  CONSTRAINT `bbd_topic_company_ibfk_1` FOREIGN KEY (`idtopic`) REFERENCES `bbd_topic` (`idtopic`),
  CONSTRAINT `bbd_topic_company_ibfk_2` FOREIGN KEY (`idcompany`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bbd_topic_company`
--

LOCK TABLES `bbd_topic_company` WRITE;
/*!40000 ALTER TABLE `bbd_topic_company` DISABLE KEYS */;
/*!40000 ALTER TABLE `bbd_topic_company` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bbd_topic_group`
--

DROP TABLE IF EXISTS `bbd_topic_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bbd_topic_group` (
  `idtopicgroup` int(11) NOT NULL AUTO_INCREMENT,
  `idtopic` int(11) NOT NULL,
  `idgroup` int(11) NOT NULL,
  PRIMARY KEY (`idtopicgroup`),
  KEY `idtopic` (`idtopic`),
  KEY `idgroup` (`idgroup`),
  CONSTRAINT `bbd_topic_group_ibfk_1` FOREIGN KEY (`idtopic`) REFERENCES `bbd_topic` (`idtopic`),
  CONSTRAINT `bbd_topic_group_ibfk_2` FOREIGN KEY (`idgroup`) REFERENCES `hdk_tbgroup` (`idgroup`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bbd_topic_group`
--

LOCK TABLES `bbd_topic_group` WRITE;
/*!40000 ALTER TABLE `bbd_topic_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `bbd_topic_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bbd_topiccustomer`
--

DROP TABLE IF EXISTS `bbd_topiccustomer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bbd_topiccustomer` (
  `idtopiccustomer` int(11) NOT NULL,
  `idperson` int(11) NOT NULL,
  `idtopic` int(11) NOT NULL,
  PRIMARY KEY (`idtopiccustomer`),
  KEY `fk_bbd_topiccustomer_tbperson1` (`idperson`),
  KEY `fk_bbd_topiccustomer_bbd_topic1` (`idtopic`),
  CONSTRAINT `fk_bbd_topiccustomer_bbd_topic1` FOREIGN KEY (`idtopic`) REFERENCES `bbd_topic` (`idtopic`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_bbd_topiccustomer_tbperson1` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bbd_topiccustomer`
--

LOCK TABLES `bbd_topiccustomer` WRITE;
/*!40000 ALTER TABLE `bbd_topiccustomer` DISABLE KEYS */;
/*!40000 ALTER TABLE `bbd_topiccustomer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dsh_tbcategory`
--

DROP TABLE IF EXISTS `dsh_tbcategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dsh_tbcategory` (
  `idcategory` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `index` int(11) DEFAULT NULL,
  `status` char(1) DEFAULT 'A',
  PRIMARY KEY (`idcategory`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dsh_tbcategory`
--

LOCK TABLES `dsh_tbcategory` WRITE;
/*!40000 ALTER TABLE `dsh_tbcategory` DISABLE KEYS */;
INSERT INTO `dsh_tbcategory` VALUES (1,'Helpdezk',0,'A');
/*!40000 ALTER TABLE `dsh_tbcategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dsh_tbcategory_has_widget`
--

DROP TABLE IF EXISTS `dsh_tbcategory_has_widget`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dsh_tbcategory_has_widget` (
  `idcategory` int(11) DEFAULT NULL,
  `idwidget` int(11) DEFAULT NULL,
  KEY `FK_dsh_tbcategory_has_widget` (`idwidget`),
  KEY `FK1_dsh_tbcategory_has_widget` (`idcategory`),
  CONSTRAINT `FK1_dsh_tbcategory_has_widget` FOREIGN KEY (`idcategory`) REFERENCES `dsh_tbcategory` (`idcategory`) ON DELETE CASCADE,
  CONSTRAINT `FK_dsh_tbcategory_has_widget` FOREIGN KEY (`idwidget`) REFERENCES `dsh_tbwidget` (`idwidget`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dsh_tbcategory_has_widget`
--

LOCK TABLES `dsh_tbcategory_has_widget` WRITE;
/*!40000 ALTER TABLE `dsh_tbcategory_has_widget` DISABLE KEYS */;
INSERT INTO `dsh_tbcategory_has_widget` VALUES (1,1),(1,3),(1,3);
/*!40000 ALTER TABLE `dsh_tbcategory_has_widget` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dsh_tbwidget`
--

DROP TABLE IF EXISTS `dsh_tbwidget`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dsh_tbwidget` (
  `idwidget` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `dbhost` varchar(45) DEFAULT NULL,
  `dbuser` varchar(45) DEFAULT NULL,
  `dbpass` varchar(45) DEFAULT NULL,
  `dbname` varchar(45) DEFAULT NULL,
  `field1` varchar(200) DEFAULT NULL,
  `field2` varchar(200) DEFAULT NULL,
  `field3` varchar(200) DEFAULT NULL,
  `field4` varchar(200) DEFAULT NULL,
  `field5` varchar(200) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `creator` varchar(100) DEFAULT NULL,
  `controller` varchar(100) DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  `index` int(11) DEFAULT NULL,
  `status` char(1) DEFAULT 'A',
  PRIMARY KEY (`idwidget`),
  KEY `idx_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dsh_tbwidget`
--

LOCK TABLES `dsh_tbwidget` WRITE;
/*!40000 ALTER TABLE `dsh_tbwidget` DISABLE KEYS */;
INSERT INTO `dsh_tbwidget` VALUES (1,'Hard Users','','','','','2013','6','','','','Most active users','Rogerio Albandes','hdk_harduser','hard user.jpg',0,'A'),(2,'Requests in Stock','','','','','1800000','12','','','','Requests  in stock , in the last 30 days','Rogerio Albandes','hdk_requestassets','Estoque de Solicitacoes.jpg',0,'A'),(3,'Service Level Agreement','','','','','','','','','','Service Level Agreement','Rogerio Albandes','hdk_sla','sla.jpg',0,'A');
/*!40000 ALTER TABLE `dsh_tbwidget` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dsh_tbwidgetusuario`
--

DROP TABLE IF EXISTS `dsh_tbwidgetusuario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dsh_tbwidgetusuario` (
  `idwidgetusuario` int(11) NOT NULL AUTO_INCREMENT,
  `idusuario` int(10) unsigned NOT NULL,
  `widgets` blob,
  PRIMARY KEY (`idwidgetusuario`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dsh_tbwidgetusuario`
--

LOCK TABLES `dsh_tbwidgetusuario` WRITE;
/*!40000 ALTER TABLE `dsh_tbwidgetusuario` DISABLE KEYS */;
/*!40000 ALTER TABLE `dsh_tbwidgetusuario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_base_attachment`
--

DROP TABLE IF EXISTS `hdk_base_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_base_attachment` (
  `idattachment` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(200) NOT NULL,
  `idbase` int(11) NOT NULL,
  `real_filename` varchar(200) NOT NULL,
  PRIMARY KEY (`idattachment`),
  KEY `fk_idbase_tbperson` (`idbase`),
  CONSTRAINT `fk_idbase_tbperson` FOREIGN KEY (`idbase`) REFERENCES `hdk_base_knowledge` (`idbase`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_base_attachment`
--

LOCK TABLES `hdk_base_attachment` WRITE;
/*!40000 ALTER TABLE `hdk_base_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_base_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_base_category`
--

DROP TABLE IF EXISTS `hdk_base_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_base_category` (
  `idcategory` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `idcategory_reference` int(11) DEFAULT NULL,
  PRIMARY KEY (`idcategory`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_base_category`
--

LOCK TABLES `hdk_base_category` WRITE;
/*!40000 ALTER TABLE `hdk_base_category` DISABLE KEYS */;
INSERT INTO `hdk_base_category` VALUES (1,'Definir Categoria',0),(17,'ccc',0),(94,'Siare',0),(95,'CRM - Syonet',0),(96,'WEON',0),(97,'Hardware',0),(98,'Windows',111),(99,'QlikView',0),(100,'Windows XP',98),(101,'Windows Vista',98),(102,'Windows 7',98),(103,'AntiVirus',0),(106,'SENHAS',0),(107,'Internet',0),(110,'PROGRAMAS',0),(111,'&acirc;&euro;&oelig;Esta opera&Atilde;&sect;&Atilde;&pound;o foi cancelada devido &Atilde;&nbsp;s re',98),(112,'Senha Desp Adriano',106);
/*!40000 ALTER TABLE `hdk_base_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_base_knowledge`
--

DROP TABLE IF EXISTS `hdk_base_knowledge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_base_knowledge` (
  `idbase` int(11) NOT NULL AUTO_INCREMENT,
  `idcategory` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `problem` blob NOT NULL,
  `solution` blob NOT NULL,
  `date_register` datetime NOT NULL,
  `idperson` int(11) NOT NULL,
  `date_edit` datetime DEFAULT NULL,
  `idperson_edit` int(11) DEFAULT NULL,
  `faq` int(1) DEFAULT '0',
  PRIMARY KEY (`idbase`),
  KEY `fk_idcategory_hdk_base_category` (`idcategory`),
  KEY `fk_idperson_edit_tbperson` (`idperson_edit`),
  KEY `fk_idperson_tbperson` (`idperson`),
  KEY `idx_1` (`idbase`,`idcategory`,`idperson`,`idperson_edit`,`name`),
  CONSTRAINT `fk_idcategory_hdk_base_category` FOREIGN KEY (`idcategory`) REFERENCES `hdk_base_category` (`idcategory`) ON DELETE CASCADE,
  CONSTRAINT `fk_idperson_edit_tbperson` FOREIGN KEY (`idperson_edit`) REFERENCES `tbperson` (`idperson`),
  CONSTRAINT `fk_idperson_tbperson` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_base_knowledge`
--

LOCK TABLES `hdk_base_knowledge` WRITE;
/*!40000 ALTER TABLE `hdk_base_knowledge` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_base_knowledge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbaddinfo`
--

DROP TABLE IF EXISTS `hdk_tbaddinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbaddinfo` (
  `idaddinfo` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  PRIMARY KEY (`idaddinfo`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbaddinfo`
--

LOCK TABLES `hdk_tbaddinfo` WRITE;
/*!40000 ALTER TABLE `hdk_tbaddinfo` DISABLE KEYS */;
INSERT INTO `hdk_tbaddinfo` VALUES (1,'Erro no Sistema'),(2,'Erro do Usu&Atilde;&iexcl;rio');
/*!40000 ALTER TABLE `hdk_tbaddinfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbapproval_rule`
--

DROP TABLE IF EXISTS `hdk_tbapproval_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbapproval_rule` (
  `idapproval` int(10) NOT NULL AUTO_INCREMENT,
  `iditem` int(3) DEFAULT NULL,
  `idservice` int(3) DEFAULT NULL,
  `idperson` int(10) DEFAULT NULL,
  `order` int(10) DEFAULT '1',
  `fl_recalculate` int(1) DEFAULT '0',
  PRIMARY KEY (`idapproval`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbapproval_rule`
--

LOCK TABLES `hdk_tbapproval_rule` WRITE;
/*!40000 ALTER TABLE `hdk_tbapproval_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbapproval_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbattendance_way`
--

DROP TABLE IF EXISTS `hdk_tbattendance_way`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbattendance_way` (
  `idattendanceway` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `way` varchar(100) NOT NULL,
  PRIMARY KEY (`idattendanceway`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbattendance_way`
--

LOCK TABLES `hdk_tbattendance_way` WRITE;
/*!40000 ALTER TABLE `hdk_tbattendance_way` DISABLE KEYS */;
INSERT INTO `hdk_tbattendance_way` VALUES (1,'Internal'),(2,'External'),(3,'Remote Controll');
/*!40000 ALTER TABLE `hdk_tbattendance_way` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbconfig`
--

DROP TABLE IF EXISTS `hdk_tbconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbconfig` (
  `idconfig` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` blob,
  `idconfigcategory` int(10) unsigned DEFAULT NULL,
  `session_name` varchar(50) DEFAULT NULL,
  `field_type` varchar(200) DEFAULT NULL,
  `status` char(1) DEFAULT 'A',
  `smarty` varchar(120) NOT NULL,
  `value` varchar(200) DEFAULT NULL,
  `allowremove` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`idconfig`),
  KEY `FK_hdk_tbconfig` (`idconfigcategory`),
  CONSTRAINT `FK_hdk_tbconfig` FOREIGN KEY (`idconfigcategory`) REFERENCES `hdk_tbconfig_category` (`idconfigcategory`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbconfig`
--

LOCK TABLES `hdk_tbconfig` WRITE;
/*!40000 ALTER TABLE `hdk_tbconfig` DISABLE KEYS */;
INSERT INTO `hdk_tbconfig` VALUES (1,'USUARIO: Notificar usu&aacuterio quando uma solicita&ccedil&atildeo for assumida.','',3,'NEW_ASSUMED_MAIL','checkbox','A','Email_request_assumed','1','N'),(2,'USUARIO: Notificar usu&aacuterio ao encerrar a solicita&ccedil&atildeo','',3,'FINISH_MAIL','checkbox','A','Email_request_finished','1','N'),(3,'USUARIO: Notificar usu&aacuterio ao rejeitar a solicita&ccedil&atildeo','',3,'REJECTED_MAIL','checkbox','A','Email_request_rejected','1','N'),(4,'Enviar email ao avaliar','',3,'EM_EVALUATED','checkbox','A','Email_request_evaluated','1','N'),(13,'USUARIO: Enviar notifica&ccedil&atildeo ao incluir novo apontamento','',3,'USER_NEW_NOTE_MAIL','checkbox','A','Email_request_apont_user','1','N'),(16,'ATENDENTE: Notificar atendentes respons&aacuteveis ao cadastrar uma nova solicita&ccedil&atildeo','',3,'NEW_REQUEST_OPERATOR_MAIL','checkbox','A','Email_request_record','1','N'),(18,'Permitir que os atendentes excluam apontamentos','',1,'SES_IND_DELETE_NOTE','checkbox','A','sys_allow_delete_note','1','N'),(20,'Qtde de prorroga&ccedil&otildees na data de vencimento (0 = Nunca, [Em branco] = Sem limites, [Acima de 0] = Qtd. de prorroga&ccedil&otildees)','',1,'SES_QT_PRORROGATION','input','A','sys_prorogation_qt','2','N'),(23,'Permitir reabertura de solicita&ccedil&otildees','',1,'SES_IND_REOPEN','checkbox','A','sys_allow_reopen','1','N'),(33,'Obrigar o atendente a informar o tempo gasto na tarefas.','',1,'SES_IND_ENTER_TIME','checkbox','A','sys_enter_time','0','N'),(34,'Permitir que os atendentes assumam solicita&ccedil&otildees repassadas ou assumidas por outro atendente.','',1,'SES_IND_ASSUME_OTHER','checkbox','A','sys_allow_assume_others','1','N'),(43,'ATENDENTE: Enviar notifica&ccedil&atildeo ao incluir novo apontamento','',3,'OPERATOR_NEW_NOTE','checkbox','A','Email_request_apont_operator','1','N'),(44,'Ao abrir uma nova solicitaÃ¯Â¿Â½Ã¯Â¿Â½o iniciar o timer','',1,'SES_IND_TIMER_OPENING','checkbox','A','sys_start_timer','1','N'),(49,'NÃƒÂ£o mostrar prazo de entrega no grid do solicitante atÃƒÂ© que um atendente tenha assumido a solicitaÃƒÂ§ÃƒÂ£o','',10,'SES_HIDE_GRID_PERIOD','checkbox','A','sys_expire_date_user_grid','1','N'),(50,'Ao assumir ou repassar solicita&ccedil&otildees, trazer marcada a op&ccedil&atildeo: \"Desejo que meu grupo continue visualizando a solicita&ccedil&atildeo\"','',10,'SES_SHARE_VIEW','checkbox','A','sys_show_group_view_checkbox','1','N'),(62,'ATENDENTE: Enviar notifica&ccedil&atildeo quando uma solita&ccedil&atildeo for reaberta','',3,'REQUEST_REOPENED','checkbox','A','Email_request_reopened','1','N'),(63,'Send email notification for the requests status','',1,'SEND_EMAILS','checkbox','A','sys_email_notification','1','N'),(64,'Order requests ASC','',10,'SES_ORDER_ASC','checkbox','A','sys_sort_asc','1','N'),(65,'Email Host','',5,'EM_HOSTNAME','','A','em_hostname','mail.helpdezk.org','N'),(66,'Domain','',5,'EM_DOMAIN','','A','em_domain','helpdezk.org','N'),(67,'Email user','',5,'EM_USER','','A','em_user','no-reply@helpdezk.org','N'),(68,'User password','',5,'EM_PASSWORD','','A','em_password','LambruscO','N'),(69,'Sender email','',5,'EM_SENDER','','A','em_sender','no-reply@helpdezk.org','N'),(70,'Requires authentication','',5,'EM_AUTH','','A','em_auth','1','N'),(71,'Email Header','',11,'EM_HEADER','','A','em_header','','N'),(72,'Email Footer','<p>\n	&nbsp;</p>\n<div>\n	___________________________________________</div>\n<div>\n	Helpdezk Demo Version - Pipegrep Software&nbsp;</div>\n<p>\n	&nbsp;</p>\n',11,'EM_FOOTER','','A','em_footer','','N'),(73,'POP Host','',12,'POP_HOST','','A','pop_host','pop.gmail.com','N'),(74,'POP Port','',12,'POP_PORT','','A','pop_port','993','N'),(75,'POP Type','',12,'POP_TYPE','','A','pop_type','GMAIL','N'),(76,'Success Log','',5,'EM_SUCCESS_LOG','','A','em_success_log','1','N'),(77,'Failure Log','',5,'EM_FAILURE_LOG','','A','em_failure_log','1','N'),(78,'Solicitar a aprovaÃ§Ã£o do usuÃ¡rio apÃ³s o encerramento da solicitaÃ§Ã£o','',10,'SES_APROVE','checkbox','A','ses_aprove','0','N'),(79,'Ao Aprovar, solicitar que o usuÃƒÂ¡rio responda o questionÃ¡rio de avaliaÃ§Ã£o do atendimento','',10,'SES_EVALUATE','checkbox','A','ses_evaluate','0','N'),(80,'Enable maintenance mode','',5,'SES_MAINTENANCE','checkbox','A','ses_maintenance','0','N'),(81,'Maintenance message','',5,'SES_MAINTENANCE_MSG','','A','ses_maintenance_msg','\n	We&#39;re doing maintenance, be back soon !!!!\n','N'),(82,'ATENDENTE: Notificar atendentes respons&aacuteveis ao repassar uma solicita&ccedil&atildeo','',3,'REPASS_REQUEST_OPERATOR_MAIL','checkbox','A','Email_request_repass','1','N'),(83,'UsuÃ¡rio administrador visualizar todas solicitaÃ§Ãµes','',10,'SES_ADM_VIEW_REQUEST','checkbox','A','sys_adm_view_request','1','N'),(84,'Para abrir nova solicitaÃ§Ã£o o usuÃ¡rio nÃ£o poderÃ¡ ter solicitaÃ§Ãµes para aprovaÃ§Ã£o','',1,'SES_OPEN_NEW_REQUEST','checkbox','A','sys_open_new_request','1','N'),(85,'Permitir atendente inserir apontamento sem descriÃ§Ã£o','',1,'SES_EMPTY_NOTE','checkbox','A','sys_empty_note','1','N'),(86,'ATENDENTE: Notificar atendente de solita&ccedil&atildeo para aprova&ccedil&atildeo.','',3,'SES_REQUEST_APPROVE','checkbox','A','Email_request_approve','1','N'),(87,'Email Title','',5,'EM_TITLE','','A','em_title','[HELPDEZK - Demo Version]','N'),(88,'Permitir reabertura de solicita&ccedil&otildees por usu&aacuterio','',1,'SES_IND_REOPEN_USER','checkbox','A','sys_allow_reopen_user','1','N'),(90,'Utilizar controle de equipamento (os, etiqueta e serial)','',1,'SES_IND_EQUIPMENT','checkbox','A','sys_use_equipment','0','N'),(91,'Define session time','',1,'SES_TIME_SESSION','input','A','sys_time_session','7200','N'),(92,'LDAP/AD Server','',13,'SES_LDAP_SERVER','input','A','ldap_server',' ','N'),(93,'LDAP Distinguished Names','',13,'SES_LDAP_DN','input','A','ldap_dn',' ','N'),(94,'LDAP/AD Server','',13,'SES_LDAP_SERVER','input','A','ldap_server',' ','N'),(95,'LDAP Distinguished Names','',13,'SES_LDAP_DN','input','A','ldap_dn',' ','N'),(96,'POP Domain','',12,'POP_DOMAIN','','A','pop_domain','demo.com.br','N'),(97,'Mostrar nÃºmero de telefone, ramal e celular na solicitaÃ§Ã£o','',10,'SES_REQUEST_SHOW_PHONE','checkbox','A','ses_request_show_phone','1','N'),(98,'Definir tempo de auto atualizar grid dos atendents [0 = n?o atualizar]','',10,'SES_REFRESH_OPERATOR_GRID','input','A','ses_refresh_opertor_grid','0','N'),(99,'LDAP Domain','',13,'SES_LDAP_DOMAIN','','A','ldap_domain','','N'),(100,'LDAP Field ID','',13,'SES_LDAP_FIELD','','A','ldap_field','uid','N'),(101,'LDAP or AD','',13,'SES_LDAP_AD','','A','Type','1','N'),(104,'Email Port','',5,'EM_PORT','','A','em_port','','N'),(105,'State default','',5,'STATE_DEFAULT','input','A','state_default','1','N'),(107,'NÃƒÂ£o mostrar prazo de entrega e status no dashboard do solicitante atÃƒÂ© que um atendente tenha assumido a solicitaÃƒÂ§ÃƒÂ£o','',10,'SES_HIDE_DASH_PERIOD','checkbox','A','sys_expire_date_user_dash','1','N'),(108,'When open request, do not show area, type, item service default. User chooses regardless of default value.','',1,'TKT_DONT_SHOW_DEFAULT','checkbox','A','sys_dont_show_default','0','N'),(109,'Show user dashboard','',1,'SES_USER_DASHBOARD','checkbox','A','sys_user_dashboard','1','N'),(110,'Show operator dashboard','',1,'SES_OPERATOR_DASHBOARD','checkbox','A','sys_operator_dashboard','1','N');
/*!40000 ALTER TABLE `hdk_tbconfig` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbconfig_category`
--

DROP TABLE IF EXISTS `hdk_tbconfig_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbconfig_category` (
  `idconfigcategory` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `smarty` varchar(250) DEFAULT NULL,
  `flgsetup` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`idconfigcategory`),
  KEY `COD_CATEGORIA` (`idconfigcategory`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbconfig_category`
--

LOCK TABLES `hdk_tbconfig_category` WRITE;
/*!40000 ALTER TABLE `hdk_tbconfig_category` DISABLE KEYS */;
INSERT INTO `hdk_tbconfig_category` VALUES (1,'Funcionalidades do Sistema','System_features','Y'),(2,'PermissÃ¯Â¿Â½es para Analista','','N'),(3,'NotificaÃ¯Â¿Â½Ã¯Â¿Â½es de E-mail','','N'),(4,'UsuÃ¯Â¿Â½rios','','N'),(5,'Geral','','N'),(6,'PatrimÃ¯Â¿Â½nio','','N'),(7,'IntegraÃ¯Â¿Â½Ã¯Â¿Â½o com SMTP/LDAP/MS Active Directory','','Y'),(8,'InventÃ¯Â¿Â½rio','','N'),(9,'Inventario','','N'),(10,'Outros itens','Other_items','Y'),(11,'Email Templates','','N'),(12,'POP Server','','N'),(13,'Integration with LDAP/MS Active Directory','Integration_ldap','N'),(14,'Integration with LDAP/MS Active Directory','Integration_ldap','N');
/*!40000 ALTER TABLE `hdk_tbconfig_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbconfig_has_template`
--

DROP TABLE IF EXISTS `hdk_tbconfig_has_template`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbconfig_has_template` (
  `idconfig` int(4) NOT NULL,
  `idtemplate` int(4) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbconfig_has_template`
--

LOCK TABLES `hdk_tbconfig_has_template` WRITE;
/*!40000 ALTER TABLE `hdk_tbconfig_has_template` DISABLE KEYS */;
INSERT INTO `hdk_tbconfig_has_template` VALUES (1,1),(2,2),(3,3),(4,4),(13,13),(16,16),(43,43),(86,7),(82,21),(62,8);
/*!40000 ALTER TABLE `hdk_tbconfig_has_template` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbconfig_user`
--

DROP TABLE IF EXISTS `hdk_tbconfig_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbconfig_user` (
  `idconfiguser` int(11) NOT NULL AUTO_INCREMENT,
  `idperson` int(11) DEFAULT NULL,
  `lang` varchar(10) DEFAULT NULL,
  `theme` varchar(100) DEFAULT NULL,
  `grid_operator` varchar(255) DEFAULT '[0,0,0,0,0,0,0,0,0,0,0,0,0,0]',
  `grid_operator_width` varchar(255) DEFAULT '[22,8,85,105,70,115,90,90,80,130,80,80,55,100]',
  `grid_user` varchar(255) DEFAULT '[0,0,0,0,0,0,0,0]',
  `grid_user_width` varchar(255) DEFAULT '[26,75,100,240,200,100,130,145]',
  PRIMARY KEY (`idconfiguser`),
  KEY `fk_PerConf` (`idperson`),
  CONSTRAINT `fk_PerConf` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB AUTO_INCREMENT=274 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbconfig_user`
--

LOCK TABLES `hdk_tbconfig_user` WRITE;
/*!40000 ALTER TABLE `hdk_tbconfig_user` DISABLE KEYS */;
INSERT INTO `hdk_tbconfig_user` VALUES (260,1,'','','[0,0,0,0,0,0,0,0,0,0,0,0,0,0]','[22,8,85,105,70,115,90,90,80,130,80,80,55,100]','[0,0,0,0,0,0,0,0]','[26,75,100,240,200,100,130,145]'),(261,1061,'','','[0,0,0,0,0,0,0,0,0,0,0,0,0,0]','[22,8,85,105,70,115,90,90,80,130,80,80,55,100]','[0,0,0,0,0,0,0,0]','[26,75,100,240,200,100,130,145]'),(273,1078,'','','[0,0,0,0,0,0,0,0,0,0,0,0,0,0]','[22,8,85,105,70,115,90,90,80,130,80,80,55,100]','[0,0,0,0,0,0,0,0]','[26,75,100,240,200,100,130,145]');
/*!40000 ALTER TABLE `hdk_tbconfig_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbcore_area`
--

DROP TABLE IF EXISTS `hdk_tbcore_area`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbcore_area` (
  `idarea` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  `default` int(1) DEFAULT '0',
  PRIMARY KEY (`idarea`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbcore_area`
--

LOCK TABLES `hdk_tbcore_area` WRITE;
/*!40000 ALTER TABLE `hdk_tbcore_area` DISABLE KEYS */;
INSERT INTO `hdk_tbcore_area` VALUES (10,'IT','A',1),(11,'Internal Communication','A',0);
/*!40000 ALTER TABLE `hdk_tbcore_area` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbcore_default`
--

DROP TABLE IF EXISTS `hdk_tbcore_default`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbcore_default` (
  `idcoredefault` int(11) NOT NULL AUTO_INCREMENT,
  `table` char(50) NOT NULL DEFAULT '',
  `default` int(11) DEFAULT '0',
  PRIMARY KEY (`idcoredefault`),
  KEY `table` (`table`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=2730;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbcore_default`
--

LOCK TABLES `hdk_tbcore_default` WRITE;
/*!40000 ALTER TABLE `hdk_tbcore_default` DISABLE KEYS */;
INSERT INTO `hdk_tbcore_default` VALUES (1,'area',1),(2,'type',14),(3,'item',132),(4,'service',269),(5,'type',6),(6,'type',33);
/*!40000 ALTER TABLE `hdk_tbcore_default` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbcore_item`
--

DROP TABLE IF EXISTS `hdk_tbcore_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbcore_item` (
  `iditem` int(11) NOT NULL AUTO_INCREMENT,
  `idtype` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  `selected` int(11) NOT NULL DEFAULT '0',
  `classify` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`iditem`),
  KEY `FK_hdk_tbcore_item` (`idtype`),
  CONSTRAINT `FK_hdk_tbcore_item` FOREIGN KEY (`idtype`) REFERENCES `hdk_tbcore_type` (`idtype`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbcore_item`
--

LOCK TABLES `hdk_tbcore_item` WRITE;
/*!40000 ALTER TABLE `hdk_tbcore_item` DISABLE KEYS */;
INSERT INTO `hdk_tbcore_item` VALUES (50,28,'Office Domain','A',0,0),(55,29,'Advertising Poster','A',0,0),(56,29,'Company Signage','A',0,0),(57,32,'Pictures','A',0,0),(58,33,'SCM - Supply Chain Management','A',0,0),(59,33,'CRM - Customer Relationship Management','A',0,0),(60,34,'IoT Dashboard','A',0,0),(61,35,'System Access','A',0,0),(62,36,'Laser printer','A',0,0),(63,37,'There is no Internet Access','A',0,0),(64,37,'DNS Server Problems','A',0,0),(65,37,'Modem & Router Issues','A',0,0),(66,37,'IP Address Exhaustion','A',0,0),(67,37,'Other connectivity issues','A',0,0);
/*!40000 ALTER TABLE `hdk_tbcore_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbcore_reason`
--

DROP TABLE IF EXISTS `hdk_tbcore_reason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbcore_reason` (
  `idreason` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `idservice` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`idreason`),
  KEY `idservice` (`idservice`),
  CONSTRAINT `hdk_tbcore_reason_ibfk_1` FOREIGN KEY (`idservice`) REFERENCES `hdk_tbcore_service` (`idservice`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=16384 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbcore_reason`
--

LOCK TABLES `hdk_tbcore_reason` WRITE;
/*!40000 ALTER TABLE `hdk_tbcore_reason` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbcore_reason` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbcore_service`
--

DROP TABLE IF EXISTS `hdk_tbcore_service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbcore_service` (
  `idservice` int(11) NOT NULL AUTO_INCREMENT,
  `iditem` int(11) NOT NULL,
  `idpriority` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  `selected` int(11) NOT NULL DEFAULT '0',
  `classify` int(11) NOT NULL DEFAULT '1',
  `time_attendance` int(11) NOT NULL DEFAULT '0',
  `hours_attendance` int(11) NOT NULL DEFAULT '0',
  `days_attendance` int(11) NOT NULL DEFAULT '0',
  `ind_hours_minutes` char(1) NOT NULL DEFAULT 'H',
  PRIMARY KEY (`idservice`),
  KEY `FK_hdk_tbcore_service` (`iditem`),
  CONSTRAINT `FK_hdk_tbcore_service` FOREIGN KEY (`iditem`) REFERENCES `hdk_tbcore_item` (`iditem`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbcore_service`
--

LOCK TABLES `hdk_tbcore_service` WRITE;
/*!40000 ALTER TABLE `hdk_tbcore_service` DISABLE KEYS */;
INSERT INTO `hdk_tbcore_service` VALUES (85,50,3,'Add client computers to domain','A',0,0,0,0,1,'H'),(86,50,2,'Add user to domain','A',0,0,0,2,0,'H'),(87,50,3,'Map Drive on Server','A',0,0,0,0,1,'H'),(88,50,1,'Change user password','A',0,0,0,30,0,'M'),(89,55,5,'Create a new','A',0,0,0,0,12,'H'),(90,55,3,'Print Out','A',0,0,0,3,0,'H'),(91,56,3,'Print Out','A',0,0,0,6,0,'H'),(92,57,3,'Take pictures','A',0,0,0,2,0,'H'),(93,57,2,'Print pictures','A',0,0,0,1,0,'H'),(94,57,5,'Store pictures in the cloud','A',0,0,0,0,20,'H'),(95,58,2,'Go live ','A',0,0,0,1,0,'H'),(96,58,2,'Restore ','A',0,0,0,1,0,'H'),(97,59,2,'Go live','A',0,0,0,1,0,'H'),(98,59,2,'Restore','A',0,0,0,1,0,'H'),(99,60,3,'Create widget','A',0,0,0,0,2,'H'),(100,60,3,'Change widget','A',0,0,0,0,1,'H'),(101,60,1,'Delete widget','A',0,0,0,1,0,'H'),(102,61,2,'Change password','A',0,0,0,1,0,'H'),(103,61,2,'Change access profile','A',0,0,0,1,0,'H'),(104,61,2,'Create login','A',0,0,0,1,0,'H'),(105,61,2,'Password unlock ','A',0,0,0,1,0,'H'),(106,61,2,'Error accessing system','A',0,0,0,1,0,'H'),(107,61,2,'Connection failed / Time out','A',0,0,0,1,0,'H'),(108,62,1,'Knead paper','A',0,0,0,1,0,'H'),(109,62,2,'To set up','A',0,0,0,1,0,'H'),(110,62,2,'Uninstall','A',0,0,0,1,0,'H'),(111,62,2,'Poor/smudged/flawed printing','A',0,0,0,1,0,'H'),(112,62,2,'Install','A',0,0,0,1,0,'H'),(113,63,1,'Fix the problem','A',0,0,0,1,0,'H'),(114,64,1,'Fix the problem','A',0,0,0,1,0,'H'),(115,65,1,'Fix the problem','A',0,0,0,30,0,'M'),(116,66,1,'Fix the problem','A',0,0,0,30,0,'M'),(117,67,1,'Fix the problem','A',0,0,0,30,0,'M');
/*!40000 ALTER TABLE `hdk_tbcore_service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbcore_type`
--

DROP TABLE IF EXISTS `hdk_tbcore_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbcore_type` (
  `idtype` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  `selected` char(1) NOT NULL DEFAULT '0',
  `classify` char(1) NOT NULL DEFAULT '1',
  `idarea` int(11) NOT NULL,
  PRIMARY KEY (`idtype`),
  KEY `FK_hdk_tbcore_type` (`idarea`),
  CONSTRAINT `FK_hdk_tbcore_type` FOREIGN KEY (`idarea`) REFERENCES `hdk_tbcore_area` (`idarea`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbcore_type`
--

LOCK TABLES `hdk_tbcore_type` WRITE;
/*!40000 ALTER TABLE `hdk_tbcore_type` DISABLE KEYS */;
INSERT INTO `hdk_tbcore_type` VALUES (28,'Network','A','0','0',10),(29,'Visual Programming','A','0','0',11),(32,'Photographic Collection','A','0','0',11),(33,'Change','A','0','0',10),(34,'Dashboards','A','0','0',10),(35,'BI - QlikView','A','0','0',10),(36,'Hardware','A','0','0',10),(37,'Internet Access','A','0','0',10);
/*!40000 ALTER TABLE `hdk_tbcore_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbcostcenter`
--

DROP TABLE IF EXISTS `hdk_tbcostcenter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbcostcenter` (
  `idcostcenter` int(11) NOT NULL AUTO_INCREMENT,
  `idperson` int(11) NOT NULL,
  `cod_costcenter` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`idcostcenter`),
  KEY `FK_hdk_tbcostcenter` (`idperson`),
  CONSTRAINT `FK_hdk_tbcostcenter` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbcostcenter`
--

LOCK TABLES `hdk_tbcostcenter` WRITE;
/*!40000 ALTER TABLE `hdk_tbcostcenter` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbcostcenter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbdepartment`
--

DROP TABLE IF EXISTS `hdk_tbdepartment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbdepartment` (
  `iddepartment` int(11) NOT NULL AUTO_INCREMENT,
  `idperson` int(11) NOT NULL,
  `cod_area` int(11) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`iddepartment`),
  KEY `FK_hdk_tbdepartment` (`idperson`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbdepartment`
--

LOCK TABLES `hdk_tbdepartment` WRITE;
/*!40000 ALTER TABLE `hdk_tbdepartment` DISABLE KEYS */;
INSERT INTO `hdk_tbdepartment` VALUES (76,1038,0,'Infrastructure','A'),(77,1038,0,'Internal Communication','A'),(78,1038,0,'Advertising and Marketing','A');
/*!40000 ALTER TABLE `hdk_tbdepartment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbdepartment_has_person`
--

DROP TABLE IF EXISTS `hdk_tbdepartment_has_person`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbdepartment_has_person` (
  `idperson` int(4) NOT NULL,
  `iddepartment` int(4) NOT NULL,
  KEY `FK_tbperson_has_juridical` (`idperson`),
  KEY `FK_tbdepartmet_has_person` (`iddepartment`),
  CONSTRAINT `FK_tbdepartmet_has_person` FOREIGN KEY (`iddepartment`) REFERENCES `hdk_tbdepartment` (`iddepartment`),
  CONSTRAINT `FK_tbperson_has_juridical` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbdepartment_has_person`
--

LOCK TABLES `hdk_tbdepartment_has_person` WRITE;
/*!40000 ALTER TABLE `hdk_tbdepartment_has_person` DISABLE KEYS */;
INSERT INTO `hdk_tbdepartment_has_person` VALUES (1061,76),(1078,78);
/*!40000 ALTER TABLE `hdk_tbdepartment_has_person` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbdownload`
--

DROP TABLE IF EXISTS `hdk_tbdownload`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbdownload` (
  `iddownload` int(4) NOT NULL AUTO_INCREMENT,
  `iddownloadcategory` int(4) NOT NULL,
  `name` varchar(25) NOT NULL,
  `description` blob NOT NULL,
  `file_name` varchar(250) NOT NULL,
  `date` date NOT NULL,
  `download_file_name` varchar(250) NOT NULL,
  `file_url` varchar(250) DEFAULT NULL,
  `version_description` varchar(100) NOT NULL,
  `restricted` char(1) NOT NULL DEFAULT 'N',
  `instruction` blob,
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`iddownload`),
  KEY `FK_hdk_tbdownload` (`iddownloadcategory`),
  CONSTRAINT `FK_hdk_tbdownload` FOREIGN KEY (`iddownloadcategory`) REFERENCES `hdk_tbdownload_category` (`iddownloadcategory`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbdownload`
--

LOCK TABLES `hdk_tbdownload` WRITE;
/*!40000 ALTER TABLE `hdk_tbdownload` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbdownload` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbdownload_category`
--

DROP TABLE IF EXISTS `hdk_tbdownload_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbdownload_category` (
  `iddownloadcategory` int(4) NOT NULL AUTO_INCREMENT,
  `category` varchar(200) NOT NULL,
  PRIMARY KEY (`iddownloadcategory`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbdownload_category`
--

LOCK TABLES `hdk_tbdownload_category` WRITE;
/*!40000 ALTER TABLE `hdk_tbdownload_category` DISABLE KEYS */;
INSERT INTO `hdk_tbdownload_category` VALUES (1,'General Files'),(2,'Text Files'),(3,'Image Files'),(4,'Music'),(5,'PDF'),(6,'PHP'),(7,'HTML'),(8,'Overall Instructions'),(9,'Rules');
/*!40000 ALTER TABLE `hdk_tbdownload_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbevaluation`
--

DROP TABLE IF EXISTS `hdk_tbevaluation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbevaluation` (
  `idevaluation` int(11) NOT NULL AUTO_INCREMENT,
  `idquestion` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  `icon_name` varchar(25) NOT NULL,
  `checked` int(1) DEFAULT '0',
  PRIMARY KEY (`idevaluation`),
  KEY `FK_hdk_tbevaluation` (`idquestion`),
  CONSTRAINT `FK_hdk_tbevaluation` FOREIGN KEY (`idquestion`) REFERENCES `hdk_tbevaluationquestion` (`idquestion`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbevaluation`
--

LOCK TABLES `hdk_tbevaluation` WRITE;
/*!40000 ALTER TABLE `hdk_tbevaluation` DISABLE KEYS */;
INSERT INTO `hdk_tbevaluation` VALUES (1,2,'Ruim','A','ico_ruim.gif',0),(2,2,'MÃƒÂ©dio','A','ico_regular.gif',0),(3,2,'Bom','A','ico_bom.gif',0),(4,2,'Muito Bom','A','ico_otimo.gif',1);
/*!40000 ALTER TABLE `hdk_tbevaluation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbevaluation_icon`
--

DROP TABLE IF EXISTS `hdk_tbevaluation_icon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbevaluation_icon` (
  `idevaluation_icon` int(4) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(50) NOT NULL,
  PRIMARY KEY (`idevaluation_icon`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbevaluation_icon`
--

LOCK TABLES `hdk_tbevaluation_icon` WRITE;
/*!40000 ALTER TABLE `hdk_tbevaluation_icon` DISABLE KEYS */;
INSERT INTO `hdk_tbevaluation_icon` VALUES (1,'dinheiro.jpg'),(2,'tattoo_desenho.jpg');
/*!40000 ALTER TABLE `hdk_tbevaluation_icon` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbevaluation_token`
--

DROP TABLE IF EXISTS `hdk_tbevaluation_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbevaluation_token` (
  `idtoken` int(11) NOT NULL AUTO_INCREMENT,
  `code_request` varchar(20) NOT NULL,
  `token` varchar(40) NOT NULL,
  PRIMARY KEY (`idtoken`),
  KEY `FK_code_request` (`code_request`),
  CONSTRAINT `FK_code_request` FOREIGN KEY (`code_request`) REFERENCES `hdk_tbrequest` (`code_request`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbevaluation_token`
--

LOCK TABLES `hdk_tbevaluation_token` WRITE;
/*!40000 ALTER TABLE `hdk_tbevaluation_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbevaluation_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbevaluationquestion`
--

DROP TABLE IF EXISTS `hdk_tbevaluationquestion`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbevaluationquestion` (
  `idquestion` int(11) NOT NULL AUTO_INCREMENT,
  `question` varchar(200) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`idquestion`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbevaluationquestion`
--

LOCK TABLES `hdk_tbevaluationquestion` WRITE;
/*!40000 ALTER TABLE `hdk_tbevaluationquestion` DISABLE KEYS */;
INSERT INTO `hdk_tbevaluationquestion` VALUES (2,'Como voce avalia o atendimento feito pelo atendente?','A');
/*!40000 ALTER TABLE `hdk_tbevaluationquestion` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbexecutionorder_person`
--

DROP TABLE IF EXISTS `hdk_tbexecutionorder_person`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbexecutionorder_person` (
  `idexecutionorder` int(4) NOT NULL AUTO_INCREMENT,
  `code_request` varchar(20) NOT NULL,
  `idperson` int(4) NOT NULL,
  `exorder` int(3) NOT NULL,
  PRIMARY KEY (`idexecutionorder`),
  KEY `FK_hdk_tbexecutionorder_person` (`idperson`),
  KEY `FK_hdk_tbexecutionorder_person2` (`code_request`),
  CONSTRAINT `FK_hdk_tbexecutionorder_person` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbexecutionorder_person`
--

LOCK TABLES `hdk_tbexecutionorder_person` WRITE;
/*!40000 ALTER TABLE `hdk_tbexecutionorder_person` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbexecutionorder_person` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbexternalfield`
--

DROP TABLE IF EXISTS `hdk_tbexternalfield`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbexternalfield` (
  `idexternalfield` int(11) NOT NULL AUTO_INCREMENT,
  `idexternalsettings` int(11) NOT NULL,
  `fieldname` varchar(255) DEFAULT 'NULL',
  `VALUE` varchar(255) DEFAULT 'NULL',
  PRIMARY KEY (`idexternalfield`,`idexternalsettings`),
  KEY `IDX_hdk_tbexternalfield_fieldname` (`fieldname`),
  KEY `FK_hdk_tbexternalfield_hdk_tbexternalsettings_idexternallsetting` (`idexternalsettings`),
  CONSTRAINT `FK_hdk_tbexternalfield_hdk_tbexternalsettings_idexternallsetting` FOREIGN KEY (`idexternalsettings`) REFERENCES `hdk_tbexternalsettings` (`idexternalsetting`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=8192 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbexternalfield`
--

LOCK TABLES `hdk_tbexternalfield` WRITE;
/*!40000 ALTER TABLE `hdk_tbexternalfield` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbexternalfield` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbexternallapp`
--

DROP TABLE IF EXISTS `hdk_tbexternallapp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbexternallapp` (
  `idexternalapp` int(11) NOT NULL AUTO_INCREMENT,
  `appname` varchar(255) DEFAULT 'NULL',
  `url` varchar(255) DEFAULT 'NULL',
  PRIMARY KEY (`idexternalapp`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=16384 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbexternallapp`
--

LOCK TABLES `hdk_tbexternallapp` WRITE;
/*!40000 ALTER TABLE `hdk_tbexternallapp` DISABLE KEYS */;
INSERT INTO `hdk_tbexternallapp` VALUES (50,'Trello','https://api.trello.com'),(51,'Pushover','https://api.pushover.net/1/messages.json');
/*!40000 ALTER TABLE `hdk_tbexternallapp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbexternalsettings`
--

DROP TABLE IF EXISTS `hdk_tbexternalsettings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbexternalsettings` (
  `idexternalsetting` int(11) NOT NULL AUTO_INCREMENT,
  `idexternalapp` int(11) DEFAULT NULL,
  `idperson` int(11) DEFAULT NULL,
  PRIMARY KEY (`idexternalsetting`),
  UNIQUE KEY `UK_hdk_tbexternalsettings` (`idexternalapp`,`idperson`),
  KEY `FK_hdk_tbexternalsettings_tbperson_idperson` (`idperson`),
  CONSTRAINT `FK_hdk_tbexternalsettings_hdk_tbexternallapp_idexternalapp` FOREIGN KEY (`idexternalapp`) REFERENCES `hdk_tbexternallapp` (`idexternalapp`),
  CONSTRAINT `FK_hdk_tbexternalsettings_tbperson_idperson` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=16384 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbexternalsettings`
--

LOCK TABLES `hdk_tbexternalsettings` WRITE;
/*!40000 ALTER TABLE `hdk_tbexternalsettings` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbexternalsettings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbgetemail`
--

DROP TABLE IF EXISTS `hdk_tbgetemail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbgetemail` (
  `idgetemail` int(11) NOT NULL AUTO_INCREMENT,
  `serverurl` varchar(60) DEFAULT NULL,
  `servertype` varchar(10) DEFAULT NULL,
  `serverport` char(5) DEFAULT NULL,
  `emailacct` varchar(100) DEFAULT NULL,
  `user` varchar(80) DEFAULT NULL,
  `password` char(30) DEFAULT NULL,
  `ind_create_user` int(1) DEFAULT '0',
  `ind_delete_server` int(1) DEFAULT '1',
  `idservice` int(11) DEFAULT NULL,
  `filter_from` varchar(200) DEFAULT NULL,
  `filter_subject` varchar(200) DEFAULT NULL,
  `login_layout` varchar(1) DEFAULT NULL,
  `email_response_as_note` int(1) DEFAULT '0',
  PRIMARY KEY (`idgetemail`),
  KEY `FK_hdk_tbgetemail` (`idservice`),
  CONSTRAINT `FK_hdk_tbgetemail` FOREIGN KEY (`idservice`) REFERENCES `hdk_tbcore_service` (`idservice`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbgetemail`
--

LOCK TABLES `hdk_tbgetemail` WRITE;
/*!40000 ALTER TABLE `hdk_tbgetemail` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbgetemail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbgetemaildepartment`
--

DROP TABLE IF EXISTS `hdk_tbgetemaildepartment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbgetemaildepartment` (
  `idgetemaildepartment` int(11) NOT NULL AUTO_INCREMENT,
  `idgetemail` int(11) DEFAULT NULL,
  `iddepartment` int(11) DEFAULT NULL,
  PRIMARY KEY (`idgetemaildepartment`),
  KEY `FK_hdk_tbgetemaildepartment` (`iddepartment`),
  KEY `FK_hdk_tbgetemaildepartment_IDGETEMAIL` (`idgetemail`),
  CONSTRAINT `FK_hdk_tbgetemaildepartment` FOREIGN KEY (`iddepartment`) REFERENCES `hdk_tbdepartment` (`iddepartment`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_hdk_tbgetemaildepartment_IDGETEMAIL` FOREIGN KEY (`idgetemail`) REFERENCES `hdk_tbgetemail` (`idgetemail`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbgetemaildepartment`
--

LOCK TABLES `hdk_tbgetemaildepartment` WRITE;
/*!40000 ALTER TABLE `hdk_tbgetemaildepartment` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbgetemaildepartment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbgroup`
--

DROP TABLE IF EXISTS `hdk_tbgroup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbgroup` (
  `idgroup` int(11) NOT NULL AUTO_INCREMENT,
  `idperson` int(11) NOT NULL,
  `level` char(3) NOT NULL,
  `idcustomer` int(11) NOT NULL,
  `repass_only` char(1) NOT NULL DEFAULT 'N',
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`idgroup`),
  KEY `FK_hdk_tbgroup` (`idcustomer`),
  KEY `FK_hdk_tbgroup_IDPERSON` (`idperson`),
  CONSTRAINT `FK_hdk_tbgroup` FOREIGN KEY (`idcustomer`) REFERENCES `tbperson` (`idperson`),
  CONSTRAINT `FK_hdk_tbgroup_IDPERSON` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbgroup`
--

LOCK TABLES `hdk_tbgroup` WRITE;
/*!40000 ALTER TABLE `hdk_tbgroup` DISABLE KEYS */;
INSERT INTO `hdk_tbgroup` VALUES (50,1054,'1',1038,'N','A'),(51,1055,'1',1038,'N','A'),(54,1058,'1',1038,'N','A'),(55,1059,'1',1038,'N','A'),(56,1060,'1',1038,'N','A'),(57,1073,'1',1038,'N','A'),(58,1074,'1',1038,'N','A');
/*!40000 ALTER TABLE `hdk_tbgroup` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbgroup_has_person`
--

DROP TABLE IF EXISTS `hdk_tbgroup_has_person`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbgroup_has_person` (
  `idperson` int(4) NOT NULL,
  `idgroup` int(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbgroup_has_person`
--

LOCK TABLES `hdk_tbgroup_has_person` WRITE;
/*!40000 ALTER TABLE `hdk_tbgroup_has_person` DISABLE KEYS */;
INSERT INTO `hdk_tbgroup_has_person` VALUES (272,3),(275,3),(279,3),(278,3),(611,3),(276,3),(273,3),(607,4),(613,4),(117,4),(612,4),(608,4),(611,4),(609,4),(652,4),(277,3),(881,4),(881,3),(613,3),(117,3),(609,3),(932,4),(932,3),(949,4),(949,3),(1025,6),(1024,6),(1025,28),(1024,28),(1025,5),(1024,5),(1024,30),(1024,31),(1025,29),(1024,29),(992,6),(1025,35),(1025,34),(1025,37),(1052,43),(1051,42),(1061,56),(1061,50),(1061,51),(1061,58);
/*!40000 ALTER TABLE `hdk_tbgroup_has_person` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbgroup_has_service`
--

DROP TABLE IF EXISTS `hdk_tbgroup_has_service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbgroup_has_service` (
  `idgroup` int(4) NOT NULL,
  `idservice` int(4) NOT NULL,
  KEY `COD_GRUPO` (`idgroup`),
  KEY `FK_SERVICO_X_GRUPO_SERVICO` (`idservice`),
  CONSTRAINT `FK_hdk_tbgroup_has_service` FOREIGN KEY (`idgroup`) REFERENCES `hdk_tbgroup` (`idgroup`),
  CONSTRAINT `FK_hdk_tbgroup_has_service2` FOREIGN KEY (`idservice`) REFERENCES `hdk_tbcore_service` (`idservice`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbgroup_has_service`
--

LOCK TABLES `hdk_tbgroup_has_service` WRITE;
/*!40000 ALTER TABLE `hdk_tbgroup_has_service` DISABLE KEYS */;
INSERT INTO `hdk_tbgroup_has_service` VALUES (50,85),(50,86),(50,87),(50,88),(57,89),(57,90),(57,91),(57,92),(57,93),(57,94),(58,95),(58,96),(58,97),(58,98),(58,99),(58,100),(58,101),(58,102),(58,103),(58,104),(58,105),(58,106),(58,107),(56,108),(56,109),(56,110),(56,111),(56,112),(50,113),(50,114),(50,115),(50,116),(50,117);
/*!40000 ALTER TABLE `hdk_tbgroup_has_service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbnote`
--

DROP TABLE IF EXISTS `hdk_tbnote`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbnote` (
  `idnote` int(10) NOT NULL AUTO_INCREMENT,
  `code_request` bigint(16) unsigned DEFAULT NULL,
  `idperson` int(10) unsigned DEFAULT NULL,
  `description` blob,
  `entry_date` datetime DEFAULT NULL,
  `minutes` float DEFAULT NULL,
  `start_hour` varchar(8) DEFAULT NULL,
  `finish_hour` varchar(8) DEFAULT NULL,
  `IND_CHAMADO` int(10) unsigned DEFAULT NULL,
  `execution_date` datetime DEFAULT NULL,
  `hour_type` int(3) unsigned DEFAULT NULL,
  `service_value` float(10,4) DEFAULT NULL,
  `public` int(1) unsigned DEFAULT '1',
  `idtype` int(3) unsigned DEFAULT NULL,
  `ip_adress` varchar(30) DEFAULT NULL,
  `callback` int(1) DEFAULT '0',
  `flag_opened` tinyint(1) DEFAULT NULL,
  `code_email` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idnote`),
  KEY `COD_SOLICITACAO` (`code_request`),
  KEY `COD_TIPO` (`idtype`),
  KEY `COD_USUARIO` (`idperson`),
  KEY `DAT_CADASTRO` (`entry_date`),
  KEY `idx_entry_date` (`entry_date`)
) ENGINE=InnoDB AUTO_INCREMENT=18430 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbnote`
--

LOCK TABLES `hdk_tbnote` WRITE;
/*!40000 ALTER TABLE `hdk_tbnote` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbnote` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbnote_attachments`
--

DROP TABLE IF EXISTS `hdk_tbnote_attachments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbnote_attachments` (
  `idnote_attachments` int(10) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) DEFAULT ' ',
  PRIMARY KEY (`idnote_attachments`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbnote_attachments`
--

LOCK TABLES `hdk_tbnote_attachments` WRITE;
/*!40000 ALTER TABLE `hdk_tbnote_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbnote_attachments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbnote_has_attachments`
--

DROP TABLE IF EXISTS `hdk_tbnote_has_attachments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbnote_has_attachments` (
  `idnote` int(10) NOT NULL,
  `idnote_attachments` int(10) NOT NULL,
  KEY `idnote` (`idnote`),
  KEY `idnote_attachments` (`idnote_attachments`),
  CONSTRAINT `hdk_tbnote_has_attachments_ibfk_1` FOREIGN KEY (`idnote`) REFERENCES `hdk_tbnote` (`idnote`),
  CONSTRAINT `hdk_tbnote_has_attachments_ibfk_2` FOREIGN KEY (`idnote_attachments`) REFERENCES `hdk_tbnote_attachments` (`idnote_attachments`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbnote_has_attachments`
--

LOCK TABLES `hdk_tbnote_has_attachments` WRITE;
/*!40000 ALTER TABLE `hdk_tbnote_has_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbnote_has_attachments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbnote_type`
--

DROP TABLE IF EXISTS `hdk_tbnote_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbnote_type` (
  `idtypenote` int(4) unsigned NOT NULL,
  `description` varchar(60) DEFAULT NULL,
  `available` int(1) unsigned DEFAULT NULL,
  PRIMARY KEY (`idtypenote`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbnote_type`
--

LOCK TABLES `hdk_tbnote_type` WRITE;
/*!40000 ALTER TABLE `hdk_tbnote_type` DISABLE KEYS */;
INSERT INTO `hdk_tbnote_type` VALUES (1,'{$smarty.config.apont_tipo_visivel_user}',1),(2,'{$smarty.config.apont_tipo_visivel_only_attendance}',1),(3,'{$smarty.config.apont_tipo_criado__pelo_sistema}',0),(4,'{$smarty.config.apont_tipo_aprovacao_solicitacao}',0);
/*!40000 ALTER TABLE `hdk_tbnote_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbpriority`
--

DROP TABLE IF EXISTS `hdk_tbpriority`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbpriority` (
  `idpriority` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL,
  `order` int(11) NOT NULL,
  `color` varchar(8) NOT NULL,
  `default` int(11) NOT NULL DEFAULT '0',
  `vip` int(11) NOT NULL DEFAULT '0',
  `limit_hours` int(11) NOT NULL DEFAULT '0',
  `limit_days` int(11) NOT NULL DEFAULT '0',
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`idpriority`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbpriority`
--

LOCK TABLES `hdk_tbpriority` WRITE;
/*!40000 ALTER TABLE `hdk_tbpriority` DISABLE KEYS */;
INSERT INTO `hdk_tbpriority` VALUES (1,'Critical',8,'#660000',0,0,1,0,'A'),(2,'High',16,'#ff0000',0,0,4,0,'A'),(3,'Average',32,'#ffcc33',0,0,8,0,'A'),(4,'Low',32,'#66ff66',1,0,24,0,'A'),(5,'Planned',5,'#3399ff',0,0,0,15,'N');
/*!40000 ALTER TABLE `hdk_tbpriority` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbproperty`
--

DROP TABLE IF EXISTS `hdk_tbproperty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbproperty` (
  `idproperty` int(11) NOT NULL AUTO_INCREMENT,
  `idcategory` int(11) DEFAULT NULL,
  `idperson` int(11) DEFAULT NULL,
  `idcompany` int(11) DEFAULT NULL,
  `iddepartment` int(11) DEFAULT NULL,
  `situation` int(11) DEFAULT NULL,
  `idprovider` int(11) DEFAULT NULL,
  `idmanufacturer` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `tag_number` varchar(50) DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  `serial_number` varchar(50) DEFAULT NULL,
  `location` varchar(100) DEFAULT NULL,
  `purchasing_date` date DEFAULT NULL,
  `receipt_number` varchar(50) DEFAULT NULL,
  `warranty_date` date DEFAULT NULL,
  `observations` blob,
  `entry_date` date DEFAULT NULL,
  `idcostcenter` int(11) DEFAULT NULL,
  `days_attendance` int(11) DEFAULT NULL,
  `hours_attendance` int(11) DEFAULT NULL,
  `maintenance_date` date DEFAULT NULL,
  `ip_number` varchar(25) DEFAULT NULL,
  `mac_adress` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`idproperty`),
  KEY `FK2_hdk_tbproperty` (`idperson`),
  KEY `FK3_hdk_tbproperty` (`iddepartment`),
  KEY `FK1_hdk_tbproperty` (`idprovider`),
  KEY `FK5_hdk_tbproperty` (`idmanufacturer`),
  KEY `FK6_hdk_tbproperty` (`idcompany`),
  KEY `FK_hdk_tbproperty` (`idcategory`),
  KEY `FK4_hdk_tbproperty` (`idcostcenter`),
  CONSTRAINT `FK1_hdk_tbproperty` FOREIGN KEY (`idprovider`) REFERENCES `hdk_tbproperty_provider` (`idprovider`),
  CONSTRAINT `FK2_hdk_tbproperty` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`),
  CONSTRAINT `FK3_hdk_tbproperty` FOREIGN KEY (`iddepartment`) REFERENCES `hdk_tbdepartment` (`iddepartment`),
  CONSTRAINT `FK4_hdk_tbproperty` FOREIGN KEY (`idcostcenter`) REFERENCES `hdk_tbcostcenter` (`idcostcenter`),
  CONSTRAINT `FK5_hdk_tbproperty` FOREIGN KEY (`idmanufacturer`) REFERENCES `hdk_tbproperty_manufacturer` (`idmanufacturer`),
  CONSTRAINT `FK6_hdk_tbproperty` FOREIGN KEY (`idcompany`) REFERENCES `tbperson` (`idperson`),
  CONSTRAINT `FK_hdk_tbproperty` FOREIGN KEY (`idcategory`) REFERENCES `hdk_tbproperty_category` (`idcategory`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbproperty`
--

LOCK TABLES `hdk_tbproperty` WRITE;
/*!40000 ALTER TABLE `hdk_tbproperty` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbproperty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbproperty_category`
--

DROP TABLE IF EXISTS `hdk_tbproperty_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbproperty_category` (
  `idcategory` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`idcategory`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbproperty_category`
--

LOCK TABLES `hdk_tbproperty_category` WRITE;
/*!40000 ALTER TABLE `hdk_tbproperty_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbproperty_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbproperty_manufacturer`
--

DROP TABLE IF EXISTS `hdk_tbproperty_manufacturer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbproperty_manufacturer` (
  `idmanufacturer` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`idmanufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbproperty_manufacturer`
--

LOCK TABLES `hdk_tbproperty_manufacturer` WRITE;
/*!40000 ALTER TABLE `hdk_tbproperty_manufacturer` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbproperty_manufacturer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbproperty_provider`
--

DROP TABLE IF EXISTS `hdk_tbproperty_provider`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbproperty_provider` (
  `idprovider` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`idprovider`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbproperty_provider`
--

LOCK TABLES `hdk_tbproperty_provider` WRITE;
/*!40000 ALTER TABLE `hdk_tbproperty_provider` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbproperty_provider` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbreason`
--

DROP TABLE IF EXISTS `hdk_tbreason`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbreason` (
  `idreason` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `idservice` int(11) NOT NULL,
  `reason` varchar(100) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  PRIMARY KEY (`idreason`),
  KEY `FK_hdk_tbreason` (`idservice`),
  CONSTRAINT `FK_hdk_tbreason` FOREIGN KEY (`idservice`) REFERENCES `hdk_tbcore_service` (`idservice`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbreason`
--

LOCK TABLES `hdk_tbreason` WRITE;
/*!40000 ALTER TABLE `hdk_tbreason` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbreason` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest`
--

DROP TABLE IF EXISTS `hdk_tbrequest`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest` (
  `idrequest` int(11) NOT NULL AUTO_INCREMENT,
  `code_request` varchar(20) NOT NULL,
  `subject` blob NOT NULL,
  `description` blob NOT NULL,
  `idtype` int(11) NOT NULL,
  `iditem` int(11) NOT NULL,
  `idservice` int(11) NOT NULL,
  `idreason` int(11) unsigned DEFAULT NULL,
  `idpriority` int(11) NOT NULL,
  `idsource` int(11) NOT NULL,
  `idperson_creator` int(11) DEFAULT NULL COMMENT 'id da pessoa que abriu a solicitacao em nome de outra, sÃ¯Â¿Â½ Ã¯Â¿Â½ preenchido nesse tipo de situaÃ¯Â¿Â½Ã¯Â¿Â½o',
  `entry_date` datetime NOT NULL COMMENT 'data em que foi registrada no sistema',
  `service_value` float DEFAULT NULL,
  `os_number` varchar(20) DEFAULT NULL,
  `label` varchar(20) DEFAULT NULL,
  `extensions_number` varchar(2) DEFAULT '0' COMMENT 'numero de vezes que foi prorrogada',
  `idperson_juridical` mediumint(5) DEFAULT NULL COMMENT 'id da empresa do usuario',
  `serial_number` varchar(20) DEFAULT NULL,
  `idattendance_way` smallint(6) unsigned DEFAULT NULL COMMENT 'forma de atendimento',
  `expire_date` datetime DEFAULT NULL,
  `code_group` mediumint(9) DEFAULT NULL COMMENT 'esta coluna Ã¯Â¿Â½ para dizer para qual grupo que sera designado o atendimento',
  `code_email` varchar(240) DEFAULT NULL,
  `idperson_owner` mediumint(9) NOT NULL COMMENT 'esta coluna o id de quem necessita do serviÃ¯Â¿Â½o, que pode nao ser o mesmo que abriu',
  `idstatus` tinyint(2) DEFAULT NULL COMMENT 'aqui ficara o id do status atual da solicitacao',
  `flag_opened` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'essa coluna mostra se o atendente ja viu a solicitacao nova sem assumir',
  PRIMARY KEY (`idrequest`,`code_request`),
  UNIQUE KEY `request_code` (`code_request`),
  UNIQUE KEY `IDX_CODE_EMAIL` (`code_email`),
  KEY `FK_idtype` (`idtype`),
  KEY `FK_iditem` (`iditem`),
  KEY `FK_idservice` (`idservice`),
  KEY `FK_idreason` (`idreason`),
  KEY `FK_idpriority` (`idpriority`),
  KEY `FK_idsource` (`idsource`),
  KEY `FK_idperson_creator` (`idperson_creator`),
  KEY `idx_1` (`code_request`,`idperson_owner`,`idstatus`),
  KEY `idx_2` (`code_request`,`idstatus`),
  CONSTRAINT `FK_iditem` FOREIGN KEY (`iditem`) REFERENCES `hdk_tbcore_item` (`iditem`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_idperson_creator` FOREIGN KEY (`idperson_creator`) REFERENCES `tbperson` (`idperson`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_idpriority` FOREIGN KEY (`idpriority`) REFERENCES `hdk_tbpriority` (`idpriority`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_idreason` FOREIGN KEY (`idreason`) REFERENCES `hdk_tbcore_reason` (`idreason`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_idservice` FOREIGN KEY (`idservice`) REFERENCES `hdk_tbcore_service` (`idservice`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_idsource` FOREIGN KEY (`idsource`) REFERENCES `hdk_tbsource` (`idsource`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_idtype` FOREIGN KEY (`idtype`) REFERENCES `hdk_tbcore_type` (`idtype`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest`
--

LOCK TABLES `hdk_tbrequest` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_addinfo`
--

DROP TABLE IF EXISTS `hdk_tbrequest_addinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_addinfo` (
  `idrequest_addinfo` int(11) NOT NULL AUTO_INCREMENT,
  `idaddinfo` int(11) NOT NULL,
  `code_request` varchar(20) NOT NULL,
  PRIMARY KEY (`idrequest_addinfo`),
  KEY `fk_addinfo_idaddinfo_hdk_tbaddinfo` (`idaddinfo`),
  KEY `fk_addinfo_code_request_hdk_tbrequest` (`code_request`),
  CONSTRAINT `fk_addinfo_code_request_hdk_tbrequest` FOREIGN KEY (`code_request`) REFERENCES `hdk_tbrequest` (`code_request`),
  CONSTRAINT `fk_addinfo_idaddinfo_hdk_tbaddinfo` FOREIGN KEY (`idaddinfo`) REFERENCES `hdk_tbaddinfo` (`idaddinfo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_addinfo`
--

LOCK TABLES `hdk_tbrequest_addinfo` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_addinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_addinfo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_approval`
--

DROP TABLE IF EXISTS `hdk_tbrequest_approval`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_approval` (
  `request_code` bigint(16) NOT NULL,
  `idapproval` int(10) DEFAULT NULL,
  `idnote` int(10) DEFAULT NULL,
  `idperson` int(10) NOT NULL DEFAULT '0',
  `order` int(2) NOT NULL DEFAULT '0',
  `fl_rejected` int(1) NOT NULL DEFAULT '0',
  `fl_recalculate` int(1) NOT NULL DEFAULT '0',
  `idrequestapproval` int(4) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`idrequestapproval`),
  KEY `FK_hdk_tbrequest_approval` (`idapproval`),
  CONSTRAINT `FK_hdk_tbrequest_approval` FOREIGN KEY (`idapproval`) REFERENCES `hdk_tbapproval_rule` (`idapproval`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_approval`
--

LOCK TABLES `hdk_tbrequest_approval` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_approval` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_approval` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_attachment`
--

DROP TABLE IF EXISTS `hdk_tbrequest_attachment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_attachment` (
  `idrequest_attachment` int(11) NOT NULL AUTO_INCREMENT,
  `code_request` varchar(20) DEFAULT NULL,
  `file_name` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`idrequest_attachment`),
  KEY `FK_id_request_attachment` (`code_request`),
  CONSTRAINT `FK_hdk_tbrequest_attachment` FOREIGN KEY (`code_request`) REFERENCES `hdk_tbrequest` (`code_request`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_attachment`
--

LOCK TABLES `hdk_tbrequest_attachment` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_attachment` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_attachment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_change_expire`
--

DROP TABLE IF EXISTS `hdk_tbrequest_change_expire`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_change_expire` (
  `idchangeexpire` int(11) NOT NULL AUTO_INCREMENT,
  `code_request` varchar(20) NOT NULL,
  `reason` blob,
  `idperson` int(11) NOT NULL,
  `changedate` date NOT NULL,
  PRIMARY KEY (`idchangeexpire`),
  KEY `FK_chexpire_code_request` (`code_request`),
  KEY `FK_chexpire_idperson` (`idperson`),
  CONSTRAINT `FK_chexpire_code_request` FOREIGN KEY (`code_request`) REFERENCES `hdk_tbrequest` (`code_request`),
  CONSTRAINT `FK_chexpire_idperson` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_change_expire`
--

LOCK TABLES `hdk_tbrequest_change_expire` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_change_expire` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_change_expire` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_code`
--

DROP TABLE IF EXISTS `hdk_tbrequest_code`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_code` (
  `cod_request` varchar(20) NOT NULL,
  `cod_month` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_code`
--

LOCK TABLES `hdk_tbrequest_code` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_code` DISABLE KEYS */;
INSERT INTO `hdk_tbrequest_code` VALUES ('7',201208),('109',201209),('72',201210),('27',201211),('4',201301),('2',201405),('265',201406),('412',201407),('367',201408),('360',201409),('358',201410),('315',201411),('269',201412),('326',201501),('326',201502),('352',201503),('157',201504),('20',201602),('3',201905),('4',201906),('2',201907),('2',201908),('12',201909),('9',201911),('62',201912);
/*!40000 ALTER TABLE `hdk_tbrequest_code` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_dates`
--

DROP TABLE IF EXISTS `hdk_tbrequest_dates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_dates` (
  `idrequestdate` int(11) NOT NULL AUTO_INCREMENT,
  `code_request` varchar(20) NOT NULL,
  `forwarded_date` datetime DEFAULT NULL,
  `approval_date` datetime DEFAULT NULL,
  `finish_date` datetime DEFAULT NULL,
  `rejection_date` datetime DEFAULT NULL,
  `assume_date` datetime DEFAULT NULL,
  PRIMARY KEY (`idrequestdate`),
  KEY `FK_hdk_tbrequest_dates` (`code_request`),
  CONSTRAINT `FK_hdk_tbrequest_dates` FOREIGN KEY (`code_request`) REFERENCES `hdk_tbrequest` (`code_request`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_dates`
--

LOCK TABLES `hdk_tbrequest_dates` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_dates` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_dates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_emailcron`
--

DROP TABLE IF EXISTS `hdk_tbrequest_emailcron`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_emailcron` (
  `idrequest_emailcron` int(11) NOT NULL AUTO_INCREMENT,
  `code_request` varchar(20) DEFAULT NULL,
  `date_in` datetime DEFAULT NULL,
  `date_out` datetime DEFAULT NULL,
  `send` tinyint(1) DEFAULT NULL,
  `operation` varchar(20) DEFAULT NULL,
  `reason` varchar(250) DEFAULT 'NULL',
  PRIMARY KEY (`idrequest_emailcron`),
  KEY `code_request` (`code_request`),
  KEY `date_in` (`date_in`),
  KEY `date_out` (`date_out`),
  KEY `send` (`send`),
  CONSTRAINT `hdk_tbrequest_emailcron_ibfk_2` FOREIGN KEY (`code_request`) REFERENCES `hdk_tbrequest` (`code_request`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=564;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_emailcron`
--

LOCK TABLES `hdk_tbrequest_emailcron` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_emailcron` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_emailcron` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_evaluation`
--

DROP TABLE IF EXISTS `hdk_tbrequest_evaluation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_evaluation` (
  `idrequestevaluation` int(11) NOT NULL AUTO_INCREMENT,
  `idevaluation` int(11) NOT NULL,
  `code_request` varchar(20) NOT NULL,
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`idrequestevaluation`),
  KEY `FK_hdk_tbrequest_evaluation` (`idevaluation`),
  KEY `CODE_REQUEST_IDX` (`code_request`),
  CONSTRAINT `FK_hdk_tbrequest_evaluation` FOREIGN KEY (`idevaluation`) REFERENCES `hdk_tbevaluation` (`idevaluation`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3124 DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_evaluation`
--

LOCK TABLES `hdk_tbrequest_evaluation` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_evaluation` DISABLE KEYS */;
INSERT INTO `hdk_tbrequest_evaluation` VALUES (3123,4,'201909000001','2019-09-18 13:31:44');
/*!40000 ALTER TABLE `hdk_tbrequest_evaluation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_has_tbproperty`
--

DROP TABLE IF EXISTS `hdk_tbrequest_has_tbproperty`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_has_tbproperty` (
  `idrequest` int(11) DEFAULT NULL,
  `idproperty` int(11) DEFAULT NULL,
  `label` varchar(20) DEFAULT NULL,
  `serial_number` varchar(20) DEFAULT NULL,
  KEY `FK_idrequest_property` (`idrequest`),
  KEY `FK_idproperty_request` (`idproperty`),
  CONSTRAINT `FK_idproperty_request` FOREIGN KEY (`idproperty`) REFERENCES `hdk_tbproperty` (`idproperty`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_idrequest_property` FOREIGN KEY (`idrequest`) REFERENCES `hdk_tbrequest` (`idrequest`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_has_tbproperty`
--

LOCK TABLES `hdk_tbrequest_has_tbproperty` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_has_tbproperty` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_has_tbproperty` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_in_charge`
--

DROP TABLE IF EXISTS `hdk_tbrequest_in_charge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_in_charge` (
  `idrequest_in_charge` int(11) NOT NULL AUTO_INCREMENT,
  `code_request` varchar(20) NOT NULL,
  `id_in_charge` int(11) NOT NULL,
  `type` varchar(1) NOT NULL COMMENT 'aqui sera o tipo de responsÃ¯Â¿Â½vel, analista ou grupo de atendimento, definido por O(operator) ou G(group)',
  `ind_in_charge` varchar(1) DEFAULT NULL,
  `ind_repass` varchar(1) NOT NULL DEFAULT 'N',
  `ind_track` smallint(1) DEFAULT '0' COMMENT 'Aqui vai ficar marcado se o grupo continua vizualizando apÃ¯Â¿Â½s alguÃ¯Â¿Â½m assumir',
  `ind_operator_aux` smallint(1) DEFAULT '0',
  PRIMARY KEY (`idrequest_in_charge`),
  KEY `FK_idrequest` (`code_request`),
  KEY `FK_id_person_in_charge` (`id_in_charge`),
  KEY `idx_1` (`code_request`,`id_in_charge`,`ind_in_charge`),
  KEY `idx_2` (`id_in_charge`,`ind_in_charge`),
  KEY `idx_3` (`ind_in_charge`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_in_charge`
--

LOCK TABLES `hdk_tbrequest_in_charge` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_in_charge` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_in_charge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_log`
--

DROP TABLE IF EXISTS `hdk_tbrequest_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cod_request` varchar(20) NOT NULL,
  `date` datetime NOT NULL,
  `idstatus` mediumint(9) NOT NULL,
  `idperson` mediumint(9) NOT NULL,
  `reopened` char(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `NewIndex1` (`cod_request`),
  KEY `idx_1` (`cod_request`,`idperson`),
  CONSTRAINT `FK_hdk_tbrequest_log` FOREIGN KEY (`cod_request`) REFERENCES `hdk_tbrequest` (`code_request`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_log`
--

LOCK TABLES `hdk_tbrequest_log` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_repassed`
--

DROP TABLE IF EXISTS `hdk_tbrequest_repassed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_repassed` (
  `date` datetime NOT NULL,
  `idnote` int(10) NOT NULL,
  `code_request` varchar(20) NOT NULL,
  KEY `FK_hdk_tbrequest_repassed` (`code_request`),
  KEY `FK_hdk_tbrequest_repassed2` (`idnote`),
  CONSTRAINT `FK_hdk_tbrequest_repassed` FOREIGN KEY (`code_request`) REFERENCES `hdk_tbrequest` (`code_request`),
  CONSTRAINT `idnote_fk_idnote` FOREIGN KEY (`idnote`) REFERENCES `hdk_tbnote` (`idnote`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_repassed`
--

LOCK TABLES `hdk_tbrequest_repassed` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_repassed` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_repassed` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbrequest_times`
--

DROP TABLE IF EXISTS `hdk_tbrequest_times`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbrequest_times` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `CODE_REQUEST` varchar(20) NOT NULL,
  `MIN_OPENING_TIME` float NOT NULL,
  `MIN_ATTENDANCE_TIME` float NOT NULL,
  `MIN_EXPENDED_TIME` float NOT NULL,
  `MIN_TELEPHONE_TIME` float NOT NULL,
  `MIN_CLOSURE_TIME` float NOT NULL,
  PRIMARY KEY (`ID`,`CODE_REQUEST`),
  KEY `FK_hdk_tbrequest_times` (`CODE_REQUEST`),
  CONSTRAINT `FK_hdk_tbrequest_times` FOREIGN KEY (`CODE_REQUEST`) REFERENCES `hdk_tbrequest` (`code_request`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbrequest_times`
--

LOCK TABLES `hdk_tbrequest_times` WRITE;
/*!40000 ALTER TABLE `hdk_tbrequest_times` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbrequest_times` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbsource`
--

DROP TABLE IF EXISTS `hdk_tbsource`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbsource` (
  `idsource` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `icon` varchar(100) NOT NULL,
  PRIMARY KEY (`idsource`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbsource`
--

LOCK TABLES `hdk_tbsource` WRITE;
/*!40000 ALTER TABLE `hdk_tbsource` DISABLE KEYS */;
INSERT INTO `hdk_tbsource` VALUES (1,'Helpdezk','hpdx.ico'),(2,'Telephone','fone.ico'),(3,'Email','mail.ico'),(8,'Webservice','web.ico');
/*!40000 ALTER TABLE `hdk_tbsource` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbstatus`
--

DROP TABLE IF EXISTS `hdk_tbstatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbstatus` (
  `idstatus` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `user_view` varchar(40) NOT NULL,
  `color` varchar(8) NOT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  `idstatus_source` int(2) NOT NULL DEFAULT '3',
  PRIMARY KEY (`idstatus`),
  KEY `idx_1` (`idstatus_source`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbstatus`
--

LOCK TABLES `hdk_tbstatus` WRITE;
/*!40000 ALTER TABLE `hdk_tbstatus` DISABLE KEYS */;
INSERT INTO `hdk_tbstatus` VALUES (1,'1 - New','1 - Awaiting Service','#ff0033','A',1),(2,'2 - Repassed','2 - Passed on to another Attendant','#0033ff','A',1),(3,'3 - On Attendance','3 - In attendance','#0033ff','A',3),(4,'6 - Waiting for Approval','6 - Waiting my approval','#6600cc','A',4),(5,'7 - Finished','7 - Ticket completed','#339900','A',5),(6,'8 - Rejected','8 - Unable to fulfill ','#339900','A',6),(11,'9 - Canceled by user','9 - Canceled','#339900','A',3),(50,'4 - Waiting for customer','4 - Awaiting Your Opinion','#ffcc66','A',3),(51,'5 - Waiting for supplier','5 - In attendance','#ffcc66','A',3);
/*!40000 ALTER TABLE `hdk_tbstatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbtemplate_email`
--

DROP TABLE IF EXISTS `hdk_tbtemplate_email`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbtemplate_email` (
  `idtemplate` int(3) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `description` blob,
  PRIMARY KEY (`idtemplate`),
  KEY `IX_TEMPLATE_EMAIL_CD_TEMPL` (`idtemplate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbtemplate_email`
--

LOCK TABLES `hdk_tbtemplate_email` WRITE;
/*!40000 ALTER TABLE `hdk_tbtemplate_email` DISABLE KEYS */;
INSERT INTO `hdk_tbtemplate_email` VALUES (1,'Request assumed by operator # $REQUEST','<p><font face=\"Arial, Helvetica, sans-serif\" size=\"2\">The request number <strong><u>$REQUEST</u></strong> was assumed in $ASSUME<br/>\n<strong>Requester</strong>: $REQUESTER<br/>\n<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Subject:</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $SUBJECT<br/>\n<strong>Entry Date:</strong> $RECORD<br/>\n</font><strong>Operator In Charge:</strong> $INCHARGE<br/>\n</font></p>\n<p><font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Description:</strong> $DESCRIPTION </font></p>\n<p><font face=\"Arial, Helvetica, sans-serif\" size=\"2\">$LINK_USER</font></p>\n<p><font face=\"Arial\" size=\"2\"><strong>Notes:</strong><br/>\n$NT_USER</font></p>'),(2,'Request closed # $REQUEST','<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\">Dear Sr.(Ms.)<strong> </strong>$REQUESTER<strong>, </strong>the request number $REQUEST&nbsp; was closed in $FINISH_DATE<strong>.</strong></font></p>\n<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Requester</strong>: $REQUESTER<br />\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Subject:</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $SUBJECT<br />\n	<strong>Entry Date:</strong> $RECORD</font><br />\n	<strong>Operator In Charge:</strong> $INCHARGE</font></p>\n<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\">$LINK_USER</font></p>\n<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Description:</strong> $DESCRIPTION </font></p>\n<p>\n	<font face=\"Arial\" size=\"2\"><strong>Notes:</strong><br />\n	$NT_USER</font></p>\n'),(3,'Request rejected # $REQUEST','<p><font size=\"2\"><font face=\"Arial\">The request number <strong><u>$REQUEST</u></strong> was rejected in $REJECTION.<br>\n</font></font></p><p><font size=\"2\"><font face=\"Arial\"><strong>Requester</strong>: $REQUESTER<br>\n<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Subject:</strong>'),(4,'Request evaluated # $REQUEST','<p>\n	<font size=\"2\"><font face=\"Arial\">N. <strong><u>$REQUEST</u></strong> .<br />\n	<strong>Subject:</strong> $SUBJECT<br />\n	<strong>User:</strong> $REQUESTER<br />\n	<strong>Entry Date:</strong> $RECORD<br />\n	<strong>Description:</strong> $DESCRIPTION<br />\n	<strong>In Charge:</strong> $INCHARGE</font></font></p>\n<p>\n	<strong>Evaluation: </strong>$EVALUATION</p>\n<p>\n	<font size=\"2\"><strong>Phone:</strong> $PHONE</font><font size=\"2\"><strong> - Branch:</strong> $BRANCH</font></p>\n<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\">$LINK_OPERATOR</font></p>\n<p>\n	<font size=\"2\"><font face=\"Arial\"><strong>Notes:</strong><br />\n	$NT_OPERATOR</font></font></p>\n'),(7,'New request to approve # $REQUEST','<p>\n	<font size=\"2\"><font face=\"Arial\">N. <strong><u>$LINK_OPERATOR</u></strong> .<br />\n	<strong>Subject:</strong> $SUBJECT<br />\n	<strong>User:</strong> $REQUESTER<br />\n	<strong>Entry Date:</strong> $RECORD<br />\n	<strong>Description:</strong> $DESCRIPTION<br />\n	<strong>In Charge:</strong> $INCHARGE</font></font></p>\n<p>\n	<font size=\"2\"><strong>Phone:</strong> $PHONE</font><font size=\"2\"><strong> - Branch:</strong> $BRANCH</font></p>\n'),(8,'Request reopened # $REQUEST','<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\">Dear Sr.(Ms.)<strong> </strong>$INCHARGE<strong>, </strong>the request number $REQUEST&nbsp; was reopened in $DATE<strong>.</strong></font></p>\n<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Requester</strong>: $REQUESTER<br />\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Subject:</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $SUBJECT<br />\n	<strong>Entry Date:</strong> $RECORD</font><br />\n	<strong>Operator In Charge:</strong> $INCHARGE</font></p>\n<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\">$LINK_USER</font></p>\n<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Description:</strong> $DESCRIPTION </font></p>\n<p>\n	<font face=\"Arial\" size=\"2\"><strong>Notes:</strong><br />\n	$NT_USER</font></p>\n'),(13,'New note added to the request # $REQUEST','<p><font size=\"2\"><font face=\"Arial\">The request number <strong><u>$REQUEST</u></strong>&nbsp;received another note.<br/>\n<strong>Requester</strong>: $REQUESTER<br/>\n<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Subject:</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $SUBJECT<br/>\n<strong>Entry Date:</strong> $RECORD<br/>\n</font></font></font><font size=\"2\"><font face=\"Arial\"><strong>Operator In Charge:</strong> $INCHARGE<br/>\n<strong>Description:</strong> $DESCRIPTION&nbsp;</font></font>&nbsp;</p>\n<p><font face=\"Arial, Helvetica, sans-serif\" size=\"2\">$LINK_USER<a href=\"$LINK_USER\" target=\"helpdesk\"></a></font></p>\n<p><font face=\"Arial\" size=\"2\"><strong>Notes:</strong><br/>\n$NT_USER</font></p>'),(16,'New request recorded # $REQUEST','<p>\n	<font size=\"2\"><font face=\"Arial\">N. <strong><u>$REQUEST</u></strong> .<br />\n	<strong>Subject:</strong> $SUBJECT<br />\n	<strong>User:</strong> $REQUESTER<br />\n	<strong>Entry Date:</strong> $RECORD<br />\n	<strong>Description:</strong> $DESCRIPTION<br />\n	<strong>In Charge:</strong> $INCHARGE</font></font></p>\n<p>\n	<font size=\"2\"><strong>Phone:</strong> $PHONE</font><font size=\"2\"><strong> - Branch:</strong> $BRANCH</font></p>\n<p>\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\">$LINK_OPERATOR</font></p>\n<p>\n	<font size=\"2\"><font face=\"Arial\"><strong>Notes:</strong><br />\n	$NT_OPERATOR</font></font></p>\n'),(21,'Request repassed # $REQUEST','<p>\n	<font size=\"2\"><font face=\"Arial\">N. <strong><u>$LINK_OPERATOR</u></strong>.<br />\n	<strong>Subject:</strong> $SUBJECT<br />\n	<strong>User:</strong> $REQUESTER<br />\n	<strong>Entry Date:</strong> $RECORD<br />\n	<strong>Description:</strong> $DESCRIPTION<br />\n	<strong>In Charge:</strong> $INCHARGE</font></font></p>\n<p>\n	<font size=\"2\"><strong>Phone:</strong> $PHONE</font><font size=\"2\"><strong> - Branch:</strong> $BRANCH</font></p>\n<p>\n	<font size=\"2\"><font face=\"Arial\"><strong>Notes:</strong><br />\n	$NT_OPERATOR</font></font></p>\n'),(43,'A new note was recorded by an user # $REQUEST','<p>\n	<font size=\"2\"><font face=\"Arial\">The request number: <strong><u>$REQUEST</u></strong>&nbsp;received another note.</font></font><br />\n	&nbsp;</p>\n<p>\n	<font size=\"2\"><font face=\"Arial\"><span style=\"color:#000000;\"><strong>Requester</strong>:</span> $REQUESTER<br />\n	<font face=\"Arial, Helvetica, sans-serif\" size=\"2\"><strong>Subject:</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; $SUBJECT<br />\n	<strong>Entry Date:</strong> $RECORD</font></font></font><br />\n	<font size=\"2\"><font face=\"Arial\"><strong>Operator In Charge:</strong> $INCHARGE<br />\n	<strong>Descri&ccedil;&atilde;o:</strong> $DESCRIPTION </font> </font></p>\n<p>\n	<font size=\"2\"><font face=\"Arial, Helvetica, sans-serif\" size=\"2\">$LINK_OPERATOR</font></font></p>\n<p>\n	&nbsp;</p>\n<p>\n	<font face=\"Arial\" size=\"2\"><strong>Notes:</strong><br />\n	$NT_USER</font></p>\n\n');
/*!40000 ALTER TABLE `hdk_tbtemplate_email` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbtrigger`
--

DROP TABLE IF EXISTS `hdk_tbtrigger`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbtrigger` (
  `idtrigger` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idtrigger`),
  KEY `FK_hdk_tbtrigger_hdk_tbevaluation_idevaluation` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbtrigger`
--

LOCK TABLES `hdk_tbtrigger` WRITE;
/*!40000 ALTER TABLE `hdk_tbtrigger` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbtrigger` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbtrigger_group`
--

DROP TABLE IF EXISTS `hdk_tbtrigger_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbtrigger_group` (
  `idtriggergroup` int(11) NOT NULL AUTO_INCREMENT,
  `idtrigger` int(11) DEFAULT NULL,
  `idgroup` int(11) DEFAULT NULL,
  `condgroup` char(3) DEFAULT NULL,
  PRIMARY KEY (`idtriggergroup`),
  KEY `FK_hdk_trigger_group_hdk_tbtrigger_idtrigger` (`idtrigger`),
  KEY `FK_hdk_trigger_group_hdk_tbgroup_idgroup` (`idgroup`),
  CONSTRAINT `FK_hdk_trigger_group_hdk_tbgroup_idgroup` FOREIGN KEY (`idgroup`) REFERENCES `hdk_tbgroup` (`idgroup`),
  CONSTRAINT `FK_hdk_trigger_group_hdk_tbtrigger_idtrigger` FOREIGN KEY (`idtrigger`) REFERENCES `hdk_tbtrigger` (`idtrigger`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbtrigger_group`
--

LOCK TABLES `hdk_tbtrigger_group` WRITE;
/*!40000 ALTER TABLE `hdk_tbtrigger_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbtrigger_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbtrigger_priority`
--

DROP TABLE IF EXISTS `hdk_tbtrigger_priority`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbtrigger_priority` (
  `idtriggerpriority` int(11) DEFAULT NULL,
  `idtrigger` int(11) DEFAULT NULL,
  `idpriority` int(11) DEFAULT NULL,
  `condpriority` char(3) DEFAULT NULL,
  KEY `FK_hdk_tbtrigger_priority_hdk_tbtrigger_idtrigger` (`idtrigger`),
  KEY `FK_hdk_tbtrigger_priority_hdk_tbpriority_idpriority` (`idpriority`),
  CONSTRAINT `FK_hdk_tbtrigger_priority_hdk_tbpriority_idpriority` FOREIGN KEY (`idpriority`) REFERENCES `hdk_tbpriority` (`idpriority`),
  CONSTRAINT `FK_hdk_tbtrigger_priority_hdk_tbtrigger_idtrigger` FOREIGN KEY (`idtrigger`) REFERENCES `hdk_tbtrigger` (`idtrigger`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbtrigger_priority`
--

LOCK TABLES `hdk_tbtrigger_priority` WRITE;
/*!40000 ALTER TABLE `hdk_tbtrigger_priority` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbtrigger_priority` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbtrigger_status`
--

DROP TABLE IF EXISTS `hdk_tbtrigger_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbtrigger_status` (
  `idtriggerstatus` int(11) DEFAULT NULL,
  `idtrigger` int(11) DEFAULT NULL,
  `idstatus` int(11) DEFAULT NULL,
  `condstatus` char(3) DEFAULT NULL,
  KEY `FK_hdk_trigger_status_hdk_tbtrigger_idtrigger` (`idtrigger`),
  KEY `FK_hdk_trigger_status_hdk_tbstatus_idstatus` (`idstatus`),
  CONSTRAINT `FK_hdk_trigger_status_hdk_tbstatus_idstatus` FOREIGN KEY (`idstatus`) REFERENCES `hdk_tbstatus` (`idstatus`),
  CONSTRAINT `FK_hdk_trigger_status_hdk_tbtrigger_idtrigger` FOREIGN KEY (`idtrigger`) REFERENCES `hdk_tbtrigger` (`idtrigger`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbtrigger_status`
--

LOCK TABLES `hdk_tbtrigger_status` WRITE;
/*!40000 ALTER TABLE `hdk_tbtrigger_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbtrigger_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbviewbyurl`
--

DROP TABLE IF EXISTS `hdk_tbviewbyurl`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbviewbyurl` (
  `idviewbyurl` int(11) DEFAULT NULL,
  `idperson` int(11) DEFAULT NULL,
  `code_request` varchar(20) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `lifecycle` datetime DEFAULT NULL,
  KEY `FK_hdk_tbviewbyurl_tbperson_idperson` (`idperson`),
  KEY `FK_hdk_tbviewbyurl_hdk_tbrequest_code_request` (`code_request`),
  CONSTRAINT `FK_hdk_tbviewbyurl_hdk_tbrequest_code_request` FOREIGN KEY (`code_request`) REFERENCES `hdk_tbrequest` (`code_request`),
  CONSTRAINT `FK_hdk_tbviewbyurl_tbperson_idperson` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbviewbyurl`
--

LOCK TABLES `hdk_tbviewbyurl` WRITE;
/*!40000 ALTER TABLE `hdk_tbviewbyurl` DISABLE KEYS */;
/*!40000 ALTER TABLE `hdk_tbviewbyurl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbwork_calendar`
--

DROP TABLE IF EXISTS `hdk_tbwork_calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbwork_calendar` (
  `num_day_week` int(1) unsigned NOT NULL,
  `business_day` int(1) unsigned DEFAULT '0',
  `begin_morning` varchar(4) DEFAULT '0800',
  `end_morning` varchar(4) DEFAULT '1200',
  `begin_afternoon` varchar(4) DEFAULT '1300',
  `end_afternoon` varchar(4) DEFAULT '1800',
  PRIMARY KEY (`num_day_week`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbwork_calendar`
--

LOCK TABLES `hdk_tbwork_calendar` WRITE;
/*!40000 ALTER TABLE `hdk_tbwork_calendar` DISABLE KEYS */;
INSERT INTO `hdk_tbwork_calendar` VALUES (0,0,'0800','1200','1300','1800'),(1,1,'0800','1200','1300','1800'),(2,1,'0800','1200','1300','1800'),(3,1,'0800','1200','1300','1800'),(4,1,'0800','1200','1300','1800'),(5,1,'0800','1200','1300','1700'),(6,0,'0800','1200','1300','1800');
/*!40000 ALTER TABLE `hdk_tbwork_calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hdk_tbwork_calendar_new`
--

DROP TABLE IF EXISTS `hdk_tbwork_calendar_new`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hdk_tbwork_calendar_new` (
  `num_day_week` int(1) unsigned NOT NULL,
  `business_day` int(1) unsigned DEFAULT '0',
  `begin_morning` time NOT NULL,
  `end_morning` time NOT NULL,
  `begin_afternoon` time NOT NULL,
  `end_afternoon` time NOT NULL,
  PRIMARY KEY (`num_day_week`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hdk_tbwork_calendar_new`
--

LOCK TABLES `hdk_tbwork_calendar_new` WRITE;
/*!40000 ALTER TABLE `hdk_tbwork_calendar_new` DISABLE KEYS */;
INSERT INTO `hdk_tbwork_calendar_new` VALUES (0,0,'07:30:00','12:00:00','13:00:00','17:30:00'),(1,1,'07:30:00','12:00:00','13:00:00','17:30:00'),(2,1,'07:30:00','12:00:00','13:00:00','17:30:00'),(3,1,'07:30:00','12:00:00','13:00:00','17:30:00'),(4,1,'07:30:00','12:00:00','13:00:00','17:30:00'),(5,1,'07:30:00','12:00:00','13:00:00','16:30:00'),(6,0,'07:30:00','12:00:00','13:00:00','17:30:00');
/*!40000 ALTER TABLE `hdk_tbwork_calendar_new` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Temporary table structure for view `hdk_viewnotesdata`
--

DROP TABLE IF EXISTS `hdk_viewnotesdata`;
/*!50001 DROP VIEW IF EXISTS `hdk_viewnotesdata`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `hdk_viewnotesdata` AS SELECT 
 1 AS `idnote`,
 1 AS `code_request`,
 1 AS `idperson`,
 1 AS `name`,
 1 AS `entry_date`,
 1 AS `execution_date`,
 1 AS `start_hour`,
 1 AS `finish_hour`,
 1 AS `minutes`,
 1 AS `idtype`,
 1 AS `IND_CHAMADO`,
 1 AS `ip_adress`,
 1 AS `public`,
 1 AS `hour_type`,
 1 AS `service_value`,
 1 AS `callback`,
 1 AS `description`*/;
SET character_set_client = @saved_cs_client;

--
-- Temporary table structure for view `hdk_viewrequestdata`
--

DROP TABLE IF EXISTS `hdk_viewrequestdata`;
/*!50001 DROP VIEW IF EXISTS `hdk_viewrequestdata`*/;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
/*!50001 CREATE VIEW `hdk_viewrequestdata` AS SELECT 
 1 AS `code_request`,
 1 AS `expire_date`,
 1 AS `entry_date`,
 1 AS `flag_opened`,
 1 AS `subject`,
 1 AS `idperson_owner`,
 1 AS `idperson_creator`,
 1 AS `name_creator`,
 1 AS `phone_number`,
 1 AS `cel_phone`,
 1 AS `branch_number`,
 1 AS `idcompany`,
 1 AS `idsource`,
 1 AS `extensions_number`,
 1 AS `source`,
 1 AS `idstatus`,
 1 AS `idattendance_way`,
 1 AS `os_number`,
 1 AS `serial_number`,
 1 AS `label`,
 1 AS `description`,
 1 AS `company`,
 1 AS `status`,
 1 AS `type`,
 1 AS `idtype`,
 1 AS `iditem`,
 1 AS `item`,
 1 AS `idservice`,
 1 AS `service`,
 1 AS `priority`,
 1 AS `idpriority`,
 1 AS `ind_in_charge`,
 1 AS `id_in_charge`,
 1 AS `in_charge`,
 1 AS `color`,
 1 AS `personname`,
 1 AS `email`,
 1 AS `phone`,
 1 AS `branch`,
 1 AS `typeincharge`,
 1 AS `department`,
 1 AS `iddepartment`,
 1 AS `source_name`,
 1 AS `idarea`,
 1 AS `AREA`,
 1 AS `reason`,
 1 AS `idreason`,
 1 AS `way_name`*/;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `tbaccesstype`
--

DROP TABLE IF EXISTS `tbaccesstype`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbaccesstype` (
  `idaccesstype` int(4) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  PRIMARY KEY (`idaccesstype`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbaccesstype`
--

LOCK TABLES `tbaccesstype` WRITE;
/*!40000 ALTER TABLE `tbaccesstype` DISABLE KEYS */;
INSERT INTO `tbaccesstype` VALUES (1,'access'),(2,'new'),(3,'edit'),(4,'delete'),(5,'export'),(6,'email'),(7,'sms');
/*!40000 ALTER TABLE `tbaccesstype` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbaddress`
--

DROP TABLE IF EXISTS `tbaddress`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbaddress` (
  `idaddress` int(11) NOT NULL AUTO_INCREMENT,
  `idperson` int(11) NOT NULL,
  `idcity` int(11) NOT NULL,
  `idneighborhood` int(11) NOT NULL,
  `idstreet` int(11) NOT NULL,
  `idtypeaddress` int(11) NOT NULL,
  `number` varchar(9) DEFAULT NULL,
  `complement` varchar(45) DEFAULT NULL,
  `zipcode` varchar(11) DEFAULT NULL,
  PRIMARY KEY (`idaddress`),
  KEY `fk_tbaddress_tbperson1` (`idperson`),
  KEY `fk_tbaddress_tbcity1` (`idcity`),
  KEY `fk_tbaddress_tbneighborhood1` (`idneighborhood`),
  KEY `fk_tbaddress_tbstreet1` (`idstreet`),
  KEY `fk_tbaddress_tbtypeaddress1` (`idtypeaddress`),
  CONSTRAINT `fk_tbaddress_tbcity1` FOREIGN KEY (`idcity`) REFERENCES `tbcity` (`idcity`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tbaddress_tbneighborhood1` FOREIGN KEY (`idneighborhood`) REFERENCES `tbneighborhood` (`idneighborhood`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tbaddress_tbperson1` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tbaddress_tbstreet1` FOREIGN KEY (`idstreet`) REFERENCES `tbstreet` (`idstreet`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tbaddress_tbtypeaddress1` FOREIGN KEY (`idtypeaddress`) REFERENCES `tbtypeaddress` (`idtypeaddress`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=960 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbaddress`
--

LOCK TABLES `tbaddress` WRITE;
/*!40000 ALTER TABLE `tbaddress` DISABLE KEYS */;
INSERT INTO `tbaddress` VALUES (937,1038,1,1,1,3,'','',''),(945,1061,1,1,1,2,'','',''),(959,1078,1,1,1,2,'','','');
/*!40000 ALTER TABLE `tbaddress` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbcity`
--

DROP TABLE IF EXISTS `tbcity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbcity` (
  `idcity` int(11) NOT NULL AUTO_INCREMENT,
  `idstate` int(11) NOT NULL,
  `name` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`idcity`),
  UNIQUE KEY `idstate` (`idstate`,`name`),
  KEY `idx_tbcity_name` (`name`),
  KEY `fk_tbcity_tbstate1` (`idstate`),
  CONSTRAINT `fk_tbcity_tbstate1` FOREIGN KEY (`idstate`) REFERENCES `tbstate` (`idstate`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=21556 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbcity`
--

LOCK TABLES `tbcity` WRITE;
/*!40000 ALTER TABLE `tbcity` DISABLE KEYS */;
INSERT INTO `tbcity` VALUES (1,1,'Choose'),(21555,1098,'Alabaster');
/*!40000 ALTER TABLE `tbcity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbcompany`
--

DROP TABLE IF EXISTS `tbcompany`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbcompany` (
  `idcompany` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`idcompany`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbcompany`
--

LOCK TABLES `tbcompany` WRITE;
/*!40000 ALTER TABLE `tbcompany` DISABLE KEYS */;
INSERT INTO `tbcompany` VALUES (1,'Demo Company');
/*!40000 ALTER TABLE `tbcompany` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbconfig`
--

DROP TABLE IF EXISTS `tbconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbconfig` (
  `idconfig` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` blob,
  `idconfigcategory` int(10) unsigned DEFAULT NULL,
  `session_name` varchar(50) DEFAULT NULL,
  `field_type` varchar(200) DEFAULT NULL,
  `status` char(1) DEFAULT 'A',
  `smarty` varchar(120) NOT NULL,
  `value` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`idconfig`),
  UNIQUE KEY `hdk_tbconfig_session_idx` (`session_name`),
  KEY `idconfigcategory` (`idconfigcategory`),
  CONSTRAINT `tbconfig_ibfk_1` FOREIGN KEY (`idconfigcategory`) REFERENCES `tbconfig_category` (`idconfigcategory`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=321 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbconfig`
--

LOCK TABLES `tbconfig` WRITE;
/*!40000 ALTER TABLE `tbconfig` DISABLE KEYS */;
INSERT INTO `tbconfig` VALUES (5,'Email Title','',5,'EM_TITLE','','A','em_title','[DEMO SERVICEDESK]'),(65,'Email Host','',5,'EM_HOSTNAME','','A','em_hostname','smtp.gmail.com'),(66,'Domain','',5,'EM_DOMAIN','','A','em_domain','foo.in'),(67,'Email user','',5,'EM_USER','','A','em_user','noreply@foo.in'),(68,'User password','',5,'EM_PASSWORD','','A','em_password','PassworDemo'),(69,'Sender email','',5,'EM_SENDER','','A','em_sender','noreply@foo.in'),(70,'Requires authentication','',5,'EM_AUTH','','A','em_auth','1'),(71,'Email Header','<p><br></p>',11,'EM_HEADER','','A','em_header',''),(72,'Email Footer','<p><br></p>',11,'EM_FOOTER','','A','em_footer',''),(73,'POP Host','',12,'POP_HOST','','A','pop_host','imap.google.com'),(74,'POP Port','',12,'POP_PORT','','A','pop_port','993'),(75,'POP Type','',12,'POP_TYPE','','A','pop_type','GMAIL'),(76,'Success Log','',5,'EM_SUCCESS_LOG','','A','em_success_log','1'),(77,'Failure Log','',5,'EM_FAILURE_LOG','','A','em_failure_log','1'),(80,'Enable maintenance mode','',5,'SES_MAINTENANCE','checkbox','A','ses_maintenance','0'),(81,'Maintenance message','',5,'SES_MAINTENANCE_MSG','','A','ses_maintenance_msg','\n	We are undergoing maintenance, we will be back soon !\n'),(85,'Define session time','',1,'SES_TIME_SESSION','input','A','sys_time_session','3720'),(86,'LDAP/AD Server','',13,'SES_LDAP_SERVER','input','A','ldap_server','ldap.testathon.net'),(87,'LDAP Distinguished Names','',13,'SES_LDAP_DN','input','A','ldap_dn','OU=users,DC=testathon,DC=net'),(90,'LDAP Domain','',13,'SES_LDAP_DOMAIN','','A','ldap_domain',''),(91,'LDAP Field ID','',13,'SES_LDAP_FIELD','','A','ldap_field','uid'),(92,'LDAP or AD','',13,'SES_LDAP_AD','','A','Type','1'),(98,'Google two factor authentication','',1,'SES_GOOGLE_2FA','checkbox','A','sys_2FAuthentication','0'),(99,'POP Domain','',12,'POP_DOMAIN','','A','pop_domain','foo.in'),(102,'Email By Cron','',5,'EM_BY_CRON','checkbox','A','em_email_by_cron','0'),(103,'Email PORT','',5,'EM_PORT','NULL','A','em_port','587'),(104,'General Log','',5,'LOG_GENERAL','','A','log_general','1'),(105,'Email Log','',5,'LOG_EMAIL','','A','log_email','1'),(106,'Host Log','',5,'LOG_HOST','','A','log_host','local'),(107,'Remote Server Log','',5,'LOG_REMOTE_SERVER','input','A','log_remote_server','10.42.44.203'),(108,'Log Level','',5,'LOG_LEVEL','input','A','log_level','7'),(112,'Tracker Status','',5,'TRACKER_STATUS','checkbox','A','tracker_status','1'),(113,'Country default','',5,'COUNTRY_DEFAULT','input','A','country_default','227'),(114,'Email Secure','Use TLS',5,'EM_TLS','checkbox','A','email_tls','1');
/*!40000 ALTER TABLE `tbconfig` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbconfig_category`
--

DROP TABLE IF EXISTS `tbconfig_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbconfig_category` (
  `idconfigcategory` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `smarty` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`idconfigcategory`),
  KEY `idx_category` (`idconfigcategory`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=1260;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbconfig_category`
--

LOCK TABLES `tbconfig_category` WRITE;
/*!40000 ALTER TABLE `tbconfig_category` DISABLE KEYS */;
INSERT INTO `tbconfig_category` VALUES (1,'Funcionalidades do Sistema','System_features'),(2,'PermissÃ¯Â¿Â½es para Analista',''),(3,'NotificaÃ§Ã´es de E-mail',''),(4,'UsuÃ¡rios',''),(5,'Geral',''),(6,'PatrimÃ´nioio',''),(7,'IntegraÃ§Ã£o com SMTP/LDAP/MS Active Directory',''),(8,'InventÃ¡rio',''),(9,'Inventario',''),(10,'Outros itens','Other_items'),(11,'Email Templates',''),(12,'POP Server',''),(13,'Integration with LDAP/MS Active Directory','Integration_ldap');
/*!40000 ALTER TABLE `tbconfig_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbcountry`
--

DROP TABLE IF EXISTS `tbcountry`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbcountry` (
  `idcountry` int(11) NOT NULL AUTO_INCREMENT,
  `iso` varchar(2) DEFAULT NULL,
  `name` varchar(80) DEFAULT NULL,
  `iso3` varchar(3) DEFAULT NULL,
  `printablename` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`idcountry`),
  UNIQUE KEY `code_UNIQUE` (`iso`)
) ENGINE=InnoDB AUTO_INCREMENT=241 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbcountry`
--

LOCK TABLES `tbcountry` WRITE;
/*!40000 ALTER TABLE `tbcountry` DISABLE KEYS */;
INSERT INTO `tbcountry` VALUES (1,'AA','Choose','AAA','Choose'),(2,'AF','AFGHANISTAN','AFG','Afghanistan'),(3,'AL','ALBANIA','ALB','Albania'),(4,'DZ','ALGERIA','DZA','Algeria'),(5,'AS','AMERICAN SAMOA','ASM','American Samoa'),(6,'AD','ANDORRA','AND','Andorra'),(7,'AO','ANGOLA','AGO','Angola'),(8,'AI','ANGUILLA','AIA','Anguilla'),(9,'AQ','ANTARCTICA','','Antarctica'),(10,'AG','ANTIGUA AND BARBUDA','ATG','Antigua and Barbuda'),(11,'AR','ARGENTINA','ARG','Argentina'),(12,'AM','ARMENIA','ARM','Armenia'),(13,'AW','ARUBA','ABW','Aruba'),(14,'AU','AUSTRALIA','AUS','Australia'),(15,'AT','AUSTRIA','AUT','Austria'),(16,'AZ','AZERBAIJAN','AZE','Azerbaijan'),(17,'BS','BAHAMAS','BHS','Bahamas'),(18,'BH','BAHRAIN','BHR','Bahrain'),(19,'BD','BANGLADESH','BGD','Bangladesh'),(20,'BB','BARBADOS','BRB','Barbados'),(21,'BY','BELARUS','BLR','Belarus'),(22,'BE','BELGIUM','BEL','Belgium'),(23,'BZ','BELIZE','BLZ','Belize'),(24,'BJ','BENIN','BEN','Benin'),(25,'BM','BERMUDA','BMU','Bermuda'),(26,'BT','BHUTAN','BTN','Bhutan'),(27,'BO','BOLIVIA','BOL','Bolivia'),(28,'BA','BOSNIA AND HERZEGOVINA','BIH','Bosnia and Herzegovina'),(29,'BW','BOTSWANA','BWA','Botswana'),(30,'BV','BOUVET ISLAND','','Bouvet Island'),(31,'BR','BRAZIL','BRA','Brazil'),(32,'IO','BRITISH INDIAN OCEAN TERRITORY','','British Indian Ocean Territory'),(33,'BN','BRUNEI DARUSSALAM','BRN','Brunei Darussalam'),(34,'BG','BULGARIA','BGR','Bulgaria'),(35,'BF','BURKINA FASO','BFA','Burkina Faso'),(36,'BI','BURUNDI','BDI','Burundi'),(37,'KH','CAMBODIA','KHM','Cambodia'),(38,'CM','CAMEROON','CMR','Cameroon'),(39,'CA','CANADA','CAN','Canada'),(40,'CV','CAPE VERDE','CPV','Cape Verde'),(41,'KY','CAYMAN ISLANDS','CYM','Cayman Islands'),(42,'CF','CENTRAL AFRICAN REPUBLIC','CAF','Central African Republic'),(43,'TD','CHAD','TCD','Chad'),(44,'CL','CHILE','CHL','Chile'),(45,'CN','CHINA','CHN','China'),(46,'CX','CHRISTMAS ISLAND','','Christmas Island'),(47,'CC','COCOS (KEELING) ISLANDS','','Cocos (Keeling) Islands'),(48,'CO','COLOMBIA','COL','Colombia'),(49,'KM','COMOROS','COM','Comoros'),(50,'CG','CONGO','COG','Congo'),(51,'CD','CONGO, THE DEMOCRATIC REPUBLIC OF THE','COD','Congo, the Democratic Republic of the'),(52,'CK','COOK ISLANDS','COK','Cook Islands'),(53,'CR','COSTA RICA','CRI','Costa Rica'),(54,'CI','COTE D\'IVOIRE','CIV','Cote D\'Ivoire'),(55,'HR','CROATIA','HRV','Croatia'),(56,'CU','CUBA','CUB','Cuba'),(57,'CY','CYPRUS','CYP','Cyprus'),(58,'CZ','CZECH REPUBLIC','CZE','Czech Republic'),(59,'DK','DENMARK','DNK','Denmark'),(60,'DJ','DJIBOUTI','DJI','Djibouti'),(61,'DM','DOMINICA','DMA','Dominica'),(62,'DO','DOMINICAN REPUBLIC','DOM','Dominican Republic'),(63,'EC','ECUADOR','ECU','Ecuador'),(64,'EG','EGYPT','EGY','Egypt'),(65,'SV','EL SALVADOR','SLV','El Salvador'),(66,'GQ','EQUATORIAL GUINEA','GNQ','Equatorial Guinea'),(67,'ER','ERITREA','ERI','Eritrea'),(68,'EE','ESTONIA','EST','Estonia'),(69,'ET','ETHIOPIA','ETH','Ethiopia'),(70,'FK','FALKLAND ISLANDS (MALVINAS)','FLK','Falkland Islands (Malvinas)'),(71,'FO','FAROE ISLANDS','FRO','Faroe Islands'),(72,'FJ','FIJI','FJI','Fiji'),(73,'FI','FINLAND','FIN','Finland'),(74,'FR','FRANCE','FRA','France'),(75,'GF','FRENCH GUIANA','GUF','French Guiana'),(76,'PF','FRENCH POLYNESIA','PYF','French Polynesia'),(77,'TF','FRENCH SOUTHERN TERRITORIES','','French Southern Territories'),(78,'GA','GABON','GAB','Gabon'),(79,'GM','GAMBIA','GMB','Gambia'),(80,'GE','GEORGIA','GEO','Georgia'),(81,'DE','GERMANY','DEU','Germany'),(82,'GH','GHANA','GHA','Ghana'),(83,'GI','GIBRALTAR','GIB','Gibraltar'),(84,'GR','GREECE','GRC','Greece'),(85,'GL','GREENLAND','GRL','Greenland'),(86,'GD','GRENADA','GRD','Grenada'),(87,'GP','GUADELOUPE','GLP','Guadeloupe'),(88,'GU','GUAM','GUM','Guam'),(89,'GT','GUATEMALA','GTM','Guatemala'),(90,'GN','GUINEA','GIN','Guinea'),(91,'GW','GUINEA-BISSAU','GNB','Guinea-Bissau'),(92,'GY','GUYANA','GUY','Guyana'),(93,'HT','HAITI','HTI','Haiti'),(94,'HM','HEARD ISLAND AND MCDONALD ISLANDS','','Heard Island and Mcdonald Islands'),(95,'VA','HOLY SEE (VATICAN CITY STATE)','VAT','Holy See (Vatican City State)'),(96,'HN','HONDURAS','HND','Honduras'),(97,'HK','HONG KONG','HKG','Hong Kong'),(98,'HU','HUNGARY','HUN','Hungary'),(99,'IS','ICELAND','ISL','Iceland'),(100,'IN','INDIA','IND','India'),(101,'ID','INDONESIA','IDN','Indonesia'),(102,'IR','IRAN, ISLAMIC REPUBLIC OF','IRN','Iran, Islamic Republic of'),(103,'IQ','IRAQ','IRQ','Iraq'),(104,'IE','IRELAND','IRL','Ireland'),(105,'IL','ISRAEL','ISR','Israel'),(106,'IT','ITALY','ITA','Italy'),(107,'JM','JAMAICA','JAM','Jamaica'),(108,'JP','JAPAN','JPN','Japan'),(109,'JO','JORDAN','JOR','Jordan'),(110,'KZ','KAZAKHSTAN','KAZ','Kazakhstan'),(111,'KE','KENYA','KEN','Kenya'),(112,'KI','KIRIBATI','KIR','Kiribati'),(113,'KP','KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF','PRK','Korea, Democratic People\'s Republic of'),(114,'KR','KOREA, REPUBLIC OF','KOR','Korea, Republic of'),(115,'KW','KUWAIT','KWT','Kuwait'),(116,'KG','KYRGYZSTAN','KGZ','Kyrgyzstan'),(117,'LA','LAO PEOPLE\'S DEMOCRATIC REPUBLIC','LAO','Lao People\'s Democratic Republic'),(118,'LV','LATVIA','LVA','Latvia'),(119,'LB','LEBANON','LBN','Lebanon'),(120,'LS','LESOTHO','LSO','Lesotho'),(121,'LR','LIBERIA','LBR','Liberia'),(122,'LY','LIBYAN ARAB JAMAHIRIYA','LBY','Libyan Arab Jamahiriya'),(123,'LI','LIECHTENSTEIN','LIE','Liechtenstein'),(124,'LT','LITHUANIA','LTU','Lithuania'),(125,'LU','LUXEMBOURG','LUX','Luxembourg'),(126,'MO','MACAO','MAC','Macao'),(127,'MK','MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF','MKD','Macedonia, the Former Yugoslav Republic of'),(128,'MG','MADAGASCAR','MDG','Madagascar'),(129,'MW','MALAWI','MWI','Malawi'),(130,'MY','MALAYSIA','MYS','Malaysia'),(131,'MV','MALDIVES','MDV','Maldives'),(132,'ML','MALI','MLI','Mali'),(133,'MT','MALTA','MLT','Malta'),(134,'MH','MARSHALL ISLANDS','MHL','Marshall Islands'),(135,'MQ','MARTINIQUE','MTQ','Martinique'),(136,'MR','MAURITANIA','MRT','Mauritania'),(137,'MU','MAURITIUS','MUS','Mauritius'),(138,'YT','MAYOTTE','','Mayotte'),(139,'MX','MEXICO','MEX','Mexico'),(140,'FM','MICRONESIA, FEDERATED STATES OF','FSM','Micronesia, Federated States of'),(141,'MD','MOLDOVA, REPUBLIC OF','MDA','Moldova, Republic of'),(142,'MC','MONACO','MCO','Monaco'),(143,'MN','MONGOLIA','MNG','Mongolia'),(144,'MS','MONTSERRAT','MSR','Montserrat'),(145,'MA','MOROCCO','MAR','Morocco'),(146,'MZ','MOZAMBIQUE','MOZ','Mozambique'),(147,'MM','MYANMAR','MMR','Myanmar'),(148,'NA','NAMIBIA','NAM','Namibia'),(149,'NR','NAURU','NRU','Nauru'),(150,'NP','NEPAL','NPL','Nepal'),(151,'NL','NETHERLANDS','NLD','Netherlands'),(152,'AN','NETHERLANDS ANTILLES','ANT','Netherlands Antilles'),(153,'NC','NEW CALEDONIA','NCL','New Caledonia'),(154,'NZ','NEW ZEALAND','NZL','New Zealand'),(155,'NI','NICARAGUA','NIC','Nicaragua'),(156,'NE','NIGER','NER','Niger'),(157,'NG','NIGERIA','NGA','Nigeria'),(158,'NU','NIUE','NIU','Niue'),(159,'NF','NORFOLK ISLAND','NFK','Norfolk Island'),(160,'MP','NORTHERN MARIANA ISLANDS','MNP','Northern Mariana Islands'),(161,'NO','NORWAY','NOR','Norway'),(162,'OM','OMAN','OMN','Oman'),(163,'PK','PAKISTAN','PAK','Pakistan'),(164,'PW','PALAU','PLW','Palau'),(165,'PS','PALESTINIAN TERRITORY, OCCUPIED','','Palestinian Territory, Occupied'),(166,'PA','PANAMA','PAN','Panama'),(167,'PG','PAPUA NEW GUINEA','PNG','Papua New Guinea'),(168,'PY','PARAGUAY','PRY','Paraguay'),(169,'PE','PERU','PER','Peru'),(170,'PH','PHILIPPINES','PHL','Philippines'),(171,'PN','PITCAIRN','PCN','Pitcairn'),(172,'PL','POLAND','POL','Poland'),(173,'PT','PORTUGAL','PRT','Portugal'),(174,'PR','PUERTO RICO','PRI','Puerto Rico'),(175,'QA','QATAR','QAT','Qatar'),(176,'RE','REUNION','REU','Reunion'),(177,'RO','ROMANIA','ROM','Romania'),(178,'RU','RUSSIAN FEDERATION','RUS','Russian Federation'),(179,'RW','RWANDA','RWA','Rwanda'),(180,'SH','SAINT HELENA','SHN','Saint Helena'),(181,'KN','SAINT KITTS AND NEVIS','KNA','Saint Kitts and Nevis'),(182,'LC','SAINT LUCIA','LCA','Saint Lucia'),(183,'PM','SAINT PIERRE AND MIQUELON','SPM','Saint Pierre and Miquelon'),(184,'VC','SAINT VINCENT AND THE GRENADINES','VCT','Saint Vincent and the Grenadines'),(185,'WS','SAMOA','WSM','Samoa'),(186,'SM','SAN MARINO','SMR','San Marino'),(187,'ST','SAO TOME AND PRINCIPE','STP','Sao Tome and Principe'),(188,'SA','SAUDI ARABIA','SAU','Saudi Arabia'),(189,'SN','SENEGAL','SEN','Senegal'),(190,'CS','SERBIA AND MONTENEGRO','','Serbia and Montenegro'),(191,'SC','SEYCHELLES','SYC','Seychelles'),(192,'SL','SIERRA LEONE','SLE','Sierra Leone'),(193,'SG','SINGAPORE','SGP','Singapore'),(194,'SK','SLOVAKIA','SVK','Slovakia'),(195,'SI','SLOVENIA','SVN','Slovenia'),(196,'SB','SOLOMON ISLANDS','SLB','Solomon Islands'),(197,'SO','SOMALIA','SOM','Somalia'),(198,'ZA','SOUTH AFRICA','ZAF','South Africa'),(199,'GS','SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS','','South Georgia and the South Sandwich Islands'),(200,'ES','SPAIN','ESP','Spain'),(201,'LK','SRI LANKA','LKA','Sri Lanka'),(202,'SD','SUDAN','SDN','Sudan'),(203,'SR','SURINAME','SUR','Suriname'),(204,'SJ','SVALBARD AND JAN MAYEN','SJM','Svalbard and Jan Mayen'),(205,'SZ','SWAZILAND','SWZ','Swaziland'),(206,'SE','SWEDEN','SWE','Sweden'),(207,'CH','SWITZERLAND','CHE','Switzerland'),(208,'SY','SYRIAN ARAB REPUBLIC','SYR','Syrian Arab Republic'),(209,'TW','TAIWAN, PROVINCE OF CHINA','TWN','Taiwan, Province of China'),(210,'TJ','TAJIKISTAN','TJK','Tajikistan'),(211,'TZ','TANZANIA, UNITED REPUBLIC OF','TZA','Tanzania, United Republic of'),(212,'TH','THAILAND','THA','Thailand'),(213,'TL','TIMOR-LESTE','','Timor-Leste'),(214,'TG','TOGO','TGO','Togo'),(215,'TK','TOKELAU','TKL','Tokelau'),(216,'TO','TONGA','TON','Tonga'),(217,'TT','TRINIDAD AND TOBAGO','TTO','Trinidad and Tobago'),(218,'TN','TUNISIA','TUN','Tunisia'),(219,'TR','TURKEY','TUR','Turkey'),(220,'TM','TURKMENISTAN','TKM','Turkmenistan'),(221,'TC','TURKS AND CAICOS ISLANDS','TCA','Turks and Caicos Islands'),(222,'TV','TUVALU','TUV','Tuvalu'),(223,'UG','UGANDA','UGA','Uganda'),(224,'UA','UKRAINE','UKR','Ukraine'),(225,'AE','UNITED ARAB EMIRATES','ARE','United Arab Emirates'),(226,'GB','UNITED KINGDOM','GBR','United Kingdom'),(227,'US','UNITED STATES','USA','United States'),(228,'UM','UNITED STATES MINOR OUTLYING ISLANDS','','United States Minor Outlying Islands'),(229,'UY','URUGUAY','URY','Uruguay'),(230,'UZ','UZBEKISTAN','UZB','Uzbekistan'),(231,'VU','VANUATU','VUT','Vanuatu'),(232,'VE','VENEZUELA','VEN','Venezuela'),(233,'VN','VIET NAM','VNM','Viet Nam'),(234,'VG','VIRGIN ISLANDS, BRITISH','VGB','Virgin Islands, British'),(235,'VI','VIRGIN ISLANDS, U.S.','VIR','Virgin Islands, U.s.'),(236,'WF','WALLIS AND FUTUNA','WLF','Wallis and Futuna'),(237,'EH','WESTERN SAHARA','ESH','Western Sahara'),(238,'YE','YEMEN','YEM','Yemen'),(239,'ZM','ZAMBIA','ZMB','Zambia'),(240,'ZW','ZIMBABWE','ZWE','Zimbabwe');
/*!40000 ALTER TABLE `tbcountry` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbdefaultpermission`
--

DROP TABLE IF EXISTS `tbdefaultpermission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbdefaultpermission` (
  `iddefaultpermission` int(4) NOT NULL AUTO_INCREMENT,
  `idaccesstype` int(4) NOT NULL,
  `idprogram` int(4) NOT NULL,
  `allow` char(4) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`iddefaultpermission`),
  KEY `FK_tbdefaultpermission` (`idaccesstype`),
  KEY `FK_tbdefaultpermission2` (`idprogram`),
  CONSTRAINT `FK_tbdefaultpermission` FOREIGN KEY (`idaccesstype`) REFERENCES `tbaccesstype` (`idaccesstype`),
  CONSTRAINT `FK_tbdefaultpermission2` FOREIGN KEY (`idprogram`) REFERENCES `tbprogram` (`idprogram`)
) ENGINE=InnoDB AUTO_INCREMENT=264 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbdefaultpermission`
--

LOCK TABLES `tbdefaultpermission` WRITE;
/*!40000 ALTER TABLE `tbdefaultpermission` DISABLE KEYS */;
INSERT INTO `tbdefaultpermission` VALUES (1,1,1,'Y'),(2,2,1,'Y'),(3,3,1,'Y'),(4,4,1,'Y'),(5,1,2,'Y'),(6,2,2,'Y'),(7,3,2,'Y'),(8,4,2,'Y'),(9,1,3,'Y'),(10,2,3,'Y'),(11,3,3,'Y'),(12,4,3,'Y'),(13,1,4,'Y'),(14,2,4,'Y'),(15,3,4,'Y'),(16,4,4,'Y'),(25,1,7,'Y'),(26,2,7,'Y'),(27,3,7,'Y'),(28,4,7,'Y'),(33,1,9,'Y'),(34,2,9,'Y'),(35,3,9,'Y'),(36,4,9,'Y'),(45,1,12,'Y'),(46,2,12,'Y'),(47,3,12,'Y'),(48,4,12,'Y'),(57,1,16,'Y'),(58,2,16,'Y'),(59,3,16,'Y'),(60,4,16,'Y'),(69,1,23,'Y'),(70,2,23,'Y'),(71,3,23,'Y'),(72,4,23,'Y'),(77,5,2,'Y'),(85,1,32,'Y'),(86,2,32,'Y'),(87,3,32,'Y'),(182,1,61,'Y'),(183,2,61,'Y'),(184,3,61,'Y'),(185,4,61,'Y'),(224,1,73,'Y'),(225,2,73,'Y'),(226,5,73,'Y'),(227,1,74,'Y'),(228,2,74,'Y'),(229,3,74,'Y'),(230,4,74,'Y'),(231,5,74,'Y'),(245,1,79,'Y'),(246,2,79,'Y'),(247,3,79,'Y'),(248,4,79,'Y'),(254,1,81,'Y'),(255,2,81,'Y'),(256,3,81,'Y'),(257,4,81,'Y'),(258,5,81,'Y'),(259,6,81,'Y'),(260,1,82,'Y'),(261,2,82,'Y'),(262,3,82,'Y'),(263,4,82,'Y');
/*!40000 ALTER TABLE `tbdefaultpermission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbdepartment`
--

DROP TABLE IF EXISTS `tbdepartment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbdepartment` (
  `iddepartment` int(11) NOT NULL AUTO_INCREMENT,
  `idcompany` int(11) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`iddepartment`),
  KEY `fk_tbdepartment_tbcompany1` (`idcompany`),
  CONSTRAINT `fk_tbdepartment_tbcompany1` FOREIGN KEY (`idcompany`) REFERENCES `tbcompany` (`idcompany`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbdepartment`
--

LOCK TABLES `tbdepartment` WRITE;
/*!40000 ALTER TABLE `tbdepartment` DISABLE KEYS */;
INSERT INTO `tbdepartment` VALUES (1,1,'IT');
/*!40000 ALTER TABLE `tbdepartment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbdeploy`
--

DROP TABLE IF EXISTS `tbdeploy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbdeploy` (
  `iddeploy` int(11) NOT NULL AUTO_INCREMENT,
  `gitserver` char(100) DEFAULT NULL,
  `dttrigger` datetime DEFAULT NULL,
  `dtdone` datetime DEFAULT NULL,
  PRIMARY KEY (`iddeploy`),
  KEY `dtdone` (`dtdone`),
  KEY `dttrigger` (`dttrigger`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbdeploy`
--

LOCK TABLES `tbdeploy` WRITE;
/*!40000 ALTER TABLE `tbdeploy` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbdeploy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbemail`
--

DROP TABLE IF EXISTS `tbemail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbemail` (
  `idemail` int(11) NOT NULL AUTO_INCREMENT,
  `idmodule` int(11) NOT NULL,
  `from` varchar(255) DEFAULT NULL COMMENT 'According to RFC 5321',
  `to` varchar(255) DEFAULT NULL COMMENT 'According to RFC 5321',
  `subject` varchar(255) DEFAULT NULL,
  `body` blob,
  PRIMARY KEY (`idemail`),
  KEY `IDX_tbemail_from` (`from`),
  KEY `IDX_tbemail_idmodule` (`idmodule`),
  KEY `IDX_tbemail_subject` (`subject`),
  KEY `IDX_tbemail_to` (`to`),
  CONSTRAINT `FK_tbemail_tbmodule_idmodule` FOREIGN KEY (`idmodule`) REFERENCES `tbmodule` (`idmodule`)
) ENGINE=InnoDB AUTO_INCREMENT=1913 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbemail`
--

LOCK TABLES `tbemail` WRITE;
/*!40000 ALTER TABLE `tbemail` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbemail` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbholiday`
--

DROP TABLE IF EXISTS `tbholiday`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbholiday` (
  `idholiday` int(4) NOT NULL AUTO_INCREMENT,
  `holiday_date` date NOT NULL,
  `holiday_description` varchar(50) NOT NULL,
  PRIMARY KEY (`idholiday`)
) ENGINE=InnoDB AUTO_INCREMENT=160 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbholiday`
--

LOCK TABLES `tbholiday` WRITE;
/*!40000 ALTER TABLE `tbholiday` DISABLE KEYS */;
INSERT INTO `tbholiday` VALUES (16,'2020-01-01','First day of the year'),(20,'2020-04-07','Independence Day'),(32,'2020-12-25','Christmas'),(152,'2020-01-20','Martin Luther King\'s birthday'),(153,'2020-01-16','Washington\'s Birthday'),(154,'2020-05-25','Memorial Day'),(155,'2020-09-07','Labor Day'),(156,'2020-10-12','Columbu\'s Day'),(157,'2020-11-11','Veterans Day'),(158,'2020-11-26','Thanksgiving Day'),(159,'2020-02-17','President\'s Day');
/*!40000 ALTER TABLE `tbholiday` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbholiday_has_company`
--

DROP TABLE IF EXISTS `tbholiday_has_company`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbholiday_has_company` (
  `idholiday` int(4) NOT NULL,
  `idperson` int(11) NOT NULL,
  KEY `fk_idholiday_tbholiday_has_company` (`idholiday`),
  KEY `fk_idperson_tbholiday_has_company` (`idperson`),
  CONSTRAINT `fk_idholiday_tbholiday_has_company` FOREIGN KEY (`idholiday`) REFERENCES `tbholiday` (`idholiday`),
  CONSTRAINT `fk_idperson_tbholiday_has_company` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbholiday_has_company`
--

LOCK TABLES `tbholiday_has_company` WRITE;
/*!40000 ALTER TABLE `tbholiday_has_company` DISABLE KEYS */;
INSERT INTO `tbholiday_has_company` VALUES (159,1038);
/*!40000 ALTER TABLE `tbholiday_has_company` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbjuridicalperson`
--

DROP TABLE IF EXISTS `tbjuridicalperson`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbjuridicalperson` (
  `idjuridicalperson` int(11) NOT NULL AUTO_INCREMENT,
  `idperson` int(11) NOT NULL,
  `ein_cnpj` varchar(18) DEFAULT NULL,
  `iestadual` varchar(20) DEFAULT NULL,
  `contact_person` varchar(80) DEFAULT NULL,
  `observation` blob,
  PRIMARY KEY (`idjuridicalperson`),
  KEY `fk_tbjuridicalperson_tbperson1` (`idperson`),
  CONSTRAINT `fk_tbjuridicalperson_tbperson1` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbjuridicalperson`
--

LOCK TABLES `tbjuridicalperson` WRITE;
/*!40000 ALTER TABLE `tbjuridicalperson` DISABLE KEYS */;
INSERT INTO `tbjuridicalperson` VALUES (6,1038,'07452272/000171','','Gustavo Silveira','');
/*!40000 ALTER TABLE `tbjuridicalperson` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblocale`
--

DROP TABLE IF EXISTS `tblocale`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tblocale` (
  `idlocale` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idlocale`),
  UNIQUE KEY `UK_tblocale_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=611 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblocale`
--

LOCK TABLES `tblocale` WRITE;
/*!40000 ALTER TABLE `tblocale` DISABLE KEYS */;
INSERT INTO `tblocale` VALUES (1,'ab','Abkasies'),(3,'ace','Achinese'),(4,'ada','Adangme'),(5,'ady','Adyghe'),(6,'aa','Afar'),(7,'afh','Afrihili'),(8,'af','Afrikaans'),(9,'agq','Aghem'),(10,'ain','Ainu'),(11,'ak','Akan'),(12,'akk','Akkadian'),(13,'ach','Akoli'),(14,'bss','Akoose'),(15,'akz','Alabama'),(16,'sq','Albanees'),(17,'ale','Aleut'),(18,'arq','Algerian Arabic'),(19,'en_US','American English'),(20,'ase','American Sign Language'),(21,'am','Amharies'),(22,'anp','Angika'),(23,'egy','Antieke Egipties'),(24,'grc','Antieke Grieks'),(25,'njo','Ao Naga'),(26,'ar','Arabies'),(27,'an','Aragonese'),(28,'arc','Aramees'),(29,'aro','Araona'),(30,'arp','Arapaho'),(31,'arw','Arawak'),(32,'hy','Armeens'),(33,'rup','Aromanian'),(34,'frp','Arpitan'),(35,'as','Assamees'),(36,'ast','Asturian'),(37,'asa','Asu'),(38,'cch','Atsam'),(39,'en_AU','Australian English'),(40,'de_AT','Austrian German'),(41,'av','Avaric'),(42,'ae','Avestan'),(43,'awa','Awadhi'),(44,'ay','Aymara'),(45,'az','Azerbeidjans'),(46,'bfq','Badaga'),(47,'ksf','Bafia'),(48,'bfd','Bafut'),(49,'bqi','Bakhtiari'),(50,'ban','Balinese'),(51,'bal','Baluchi'),(52,'bm','Bambara'),(53,'bax','Bamun'),(54,'bjn','Banjar'),(55,'bas','Basaa'),(56,'eu','Baskies'),(57,'ba','Baskir'),(58,'bbc','Batak Toba'),(59,'bar','Bavarian'),(60,'bej','Beja'),(61,'bem','Bemba'),(62,'bez','Bena'),(63,'bn','Bengaals'),(64,'bew','Betawi'),(65,'bho','Bhojpuri'),(66,'bik','Bikol'),(67,'bin','Bini'),(68,'my','Birmaans'),(69,'bpy','Bishnupriya'),(70,'bi','Bislama'),(71,'byn','Blin'),(72,'zbl','Blissymbols'),(73,'brx','Bodo'),(74,'bs','Bosnies'),(75,'brh','Brahui'),(76,'bra','Braj'),(77,'pt_BR','Brazilian Portuguese'),(78,'br','Bretons'),(79,'en_GB','British English'),(80,'bug','Buginese'),(81,'bg','Bulgaars'),(82,'bum','Bulu'),(83,'bua','Buriat'),(84,'cad','Caddo'),(85,'frc','Cajun French'),(86,'en_CA','Canadian English'),(87,'fr_CA','Canadian French'),(88,'yue','Cantonese'),(89,'cps','Capiznon'),(90,'car','Carib'),(91,'cay','Cayuga'),(92,'ceb','Cebuano'),(93,'dtp','Central Dusun'),(94,'esu','Central Yupik'),(95,'shu','Chadian Arabic'),(96,'chg','Chagatai'),(97,'ch','Chamorro'),(98,'ce','Chechen'),(99,'chr','Cherokees'),(100,'chy','Cheyenne'),(101,'chb','Chibcha'),(102,'qug','Chimborazo Highland Quichua'),(103,'chn','Chinook Jargon'),(104,'chp','Chipewyan'),(105,'cho','Choctaw'),(106,'cu','Church Slavic'),(107,'chk','Chuukese'),(108,'cv','Chuvash'),(109,'nwc','Classical Newari'),(110,'syc','Classical Syriac'),(111,'ksh','Colognian'),(112,'swb','Comorian'),(113,'cop','Coptic'),(114,'cr','Cree'),(115,'mus','Creek'),(116,'crh','Crimean Turkish'),(117,'dak','Dakota'),(118,'dar','Dargwa'),(119,'dzg','Dazaga'),(120,'da','Deens'),(121,'del','Delaware'),(122,'din','Dinka'),(123,'dv','Divehi'),(124,'doi','Dogri'),(125,'dgr','Dogrib'),(126,'dua','Duala'),(127,'de','Duits'),(128,'dyu','Dyula'),(129,'dz','Dzongkha'),(130,'frs','Eastern Frisian'),(131,'efi','Efik'),(132,'arz','Egyptian Arabic'),(133,'eka','Ekajuk'),(134,'elx','Elamite'),(135,'ebu','Embu'),(136,'egl','Emilian'),(137,'en','Engels'),(138,'myv','Erzya'),(139,'eo','Esperanto'),(140,'et','Estnies'),(141,'pt_PT','European Portuguese'),(142,'es_ES','European Spanish'),(143,'ee','Ewe'),(144,'ewo','Ewondo'),(145,'ext','Extremaduran'),(146,'fan','Fang'),(147,'fat','Fanti'),(148,'fo','Faroees'),(149,'fj','Fidjiaans'),(150,'hif','Fiji Hindi'),(151,'fil','Filippyns'),(152,'fi','Fins'),(153,'fon','Fon'),(154,'gur','Frafra'),(155,'fr','Frans'),(156,'fur','Friulian'),(157,'ff','Fulah'),(158,'gaa','Gaa'),(159,'gag','Gagauz'),(160,'gl','Galisies'),(161,'gan','Gan Chinese'),(162,'lg','Ganda'),(163,'gay','Gayo'),(164,'gba','Gbaya'),(165,'zxx','Geen linguistiese inhoud'),(166,'gez','Geez'),(167,'ka','Georgies'),(168,'aln','Gheg Albanian'),(169,'bbj','Ghomala'),(170,'glk','Gilaki'),(171,'gil','Gilbertese'),(172,'gom','Goan Konkani'),(173,'gu','Goedjarati'),(174,'gon','Gondi'),(175,'gor','Gorontalo'),(176,'got','Goties'),(177,'grb','Grebo'),(178,'el','Grieks'),(179,'gn','Guarani'),(180,'guz','Gusii'),(181,'gwi','Gwich?in'),(182,'hai','Haida'),(183,'ht','HaÃ¯tiaans'),(184,'hak','Hakka Chinese'),(185,'ha','Hausa'),(186,'haw','Hawaiies'),(187,'he','Hebreeus'),(188,'hz','Herero'),(189,'hil','Hiligaynon'),(190,'hi','Hindi'),(191,'ho','Hiri Motu'),(192,'hit','Hittite'),(193,'hmn','Hmong'),(194,'hu','Hongaars'),(195,'hsb','Hoog-Sorbies'),(196,'hup','Hupa'),(197,'iba','Iban'),(198,'ibb','Ibibio'),(199,'io','Ido'),(200,'ga','Iers'),(201,'ig','Igbo'),(202,'ilo','Iloko'),(203,'smn','Inari Sami'),(204,'id','Indonesies'),(205,'izh','Ingrian'),(206,'inh','Ingush'),(207,'iu','InnuÃ¯ties'),(208,'ia','Interlingua'),(209,'ie','Interlingue'),(210,'ik','Inupiaq'),(211,'it','Italiaans'),(212,'jam','Jamaican Creole English'),(213,'ja','Japannees'),(214,'jv','Javaans'),(215,'yi','Jiddisj'),(216,'kaj','Jju'),(217,'dyo','Jola-Fonyi'),(218,'jrb','Judeo-Arabic'),(219,'jpr','Judeo-Persian'),(220,'jut','Jutish'),(221,'quc','Kâ€™icheâ€™'),(222,'kbd','Kabardian'),(223,'kea','Kabuverdianu'),(224,'kab','Kabyle'),(225,'kac','Kachin'),(226,'kgp','Kaingang'),(227,'kkj','Kako'),(228,'kl','Kalaallisut'),(229,'kln','Kalenjin'),(230,'xal','Kalmyk'),(231,'kam','Kamba'),(232,'kbl','Kanembu'),(233,'kn','Kannada'),(234,'kr','Kanuri'),(235,'kaa','Kara-Kalpak'),(236,'krc','Karachay-Balkar'),(237,'krl','Karelian'),(238,'csb','Kashubian'),(239,'ks','Kasjmirs'),(240,'ca','Katalaans'),(241,'kaw','Kawi'),(242,'kk','Kazaks'),(243,'ken','Kenyang'),(244,'kha','Khasi'),(245,'km','Khmer'),(246,'kho','Khotanese'),(247,'khw','Khowar'),(248,'ki','Kikuyu'),(249,'kmb','Kimbundu'),(250,'krj','Kinaray-a'),(251,'ky','Kirgisies'),(252,'kiu','Kirmanjki'),(253,'tlh','Klingon'),(254,'ku','Koerdies'),(255,'bkm','Kom'),(256,'kv','Komi'),(257,'koi','Komi-Permyaks'),(258,'kg','Kongolees'),(259,'kok','Konkani'),(260,'ko','Koreaans'),(261,'kw','Kornies'),(262,'kfo','Koro'),(263,'co','Korsikaans'),(264,'kos','Kosraean'),(265,'avk','Kotava'),(266,'khq','Koyra Chiini'),(267,'ses','Koyraboro Senni'),(268,'kpe','Kpelle'),(269,'kri','Krio'),(270,'hr','Kroaties'),(271,'kj','Kuanyama'),(272,'kum','Kumyk'),(273,'kru','Kurukh'),(274,'kut','Kutenai'),(275,'nmg','Kwasio'),(276,'lad','Ladino'),(277,'dsb','Lae Sorbies'),(278,'lah','Lahnda'),(279,'lkt','Lakota'),(280,'lam','Lamba'),(281,'lag','Langi'),(282,'lo','Lao'),(283,'ltg','Latgalian'),(284,'es_419','Latin American Spanish'),(285,'la','Latyn'),(286,'lzz','Laz'),(287,'lv','Letties'),(288,'lez','Lezghian'),(289,'lij','Ligurian'),(290,'li','Limburgish'),(291,'ln','Lingaals'),(292,'lfn','Lingua Franca Nova'),(293,'lt','Litaus'),(294,'lzh','Literary Chinese'),(295,'liv','Livonian'),(296,'jbo','Lojban'),(297,'lmo','Lombard'),(298,'nds','Low German'),(299,'sli','Lower Silesian'),(300,'loz','Lozi'),(301,'lu','Luba-Katanga'),(302,'lua','Luba-Lulua'),(303,'lui','Luiseno'),(304,'smj','Lule Sami'),(305,'lun','Lunda'),(306,'luo','Luo'),(307,'lb','Luxemburgs'),(308,'luy','Luyia'),(309,'mde','Maba'),(310,'jmc','Machame'),(311,'mad','Madurese'),(312,'maf','Mafa'),(313,'mag','Magahi'),(314,'vmf','Main-Franconian'),(315,'mai','Maithili'),(316,'mak','Makasar'),(317,'mgh','Makhuwa-Meetto'),(318,'kde','Makonde'),(319,'ml','Malabaars'),(320,'ms','Maleis'),(321,'mg','Malgassies'),(322,'mt','Maltees'),(323,'mnc','Manchu'),(324,'mdr','Mandar'),(325,'man','Mandingo'),(326,'mni','Manipuri'),(327,'gv','Manx'),(328,'mi','Maori'),(329,'arn','Mapuche'),(330,'mr','Marathi'),(331,'chm','Mari'),(332,'mh','Marshallese'),(333,'mwr','Marwari'),(334,'mas','Masai'),(335,'mk','Masedonies'),(336,'mzn','Mazanderani'),(337,'byv','Medumba'),(338,'men','Mende'),(339,'mwv','Mentawai'),(340,'mer','Meru'),(341,'mgo','Metaâ€™'),(342,'es_MX','Mexican Spanish'),(343,'mic','Micmac'),(344,'dum','Middle Dutch'),(345,'enm','Middle English'),(346,'frm','Middle French'),(347,'gmh','Middle High German'),(348,'mga','Middle Irish'),(349,'nan','Min Nan Chinese'),(350,'min','Minangkabau'),(351,'xmf','Mingrelian'),(352,'mwl','Mirandese'),(353,'lus','Mizo'),(354,'ar_001','Moderne Standaard Arabies'),(355,'moh','Mohawk'),(356,'mdf','Moksha'),(357,'ro_MD','Moldawies'),(358,'lol','Mongo'),(359,'mn','Mongools'),(360,'mfe','Morisjen'),(361,'ary','Moroccan Arabic'),(362,'mos','Mossi'),(363,'mua','Mundang'),(364,'ttt','Muslim Tat'),(365,'mye','Myene'),(366,'nqo','Nâ€™Ko'),(367,'naq','Nama'),(368,'na','Nauru'),(369,'nv','Navajo'),(370,'ng','Ndonga'),(371,'nap','Neapolitan'),(372,'nl','Nederlands'),(373,'ne','Nepalees'),(374,'new','Newari'),(375,'sba','Ngambay'),(376,'nnh','Ngiemboon'),(377,'jgo','Ngomba'),(378,'yrl','Nheengatu'),(379,'nia','Nias'),(380,'niu','Niuean'),(381,'nog','Nogai'),(382,'nd','Noord-Ndebele'),(383,'nso','Noord-Sotho'),(384,'se','Noordelike Sami'),(385,'nb','Noorse BokmÃ¥l'),(386,'nn','Noorweegse Nynorsk'),(387,'frr','Northern Frisian'),(388,'no','Norwegian'),(389,'nov','Novial'),(390,'nus','Nuer'),(391,'nym','Nyamwezi'),(392,'ny','Nyanja'),(393,'nyn','Nyankole'),(394,'tog','Nyasa Tonga'),(395,'nyo','Nyoro'),(396,'nzi','Nzima'),(397,'uk','OekraÃ¯ens'),(398,'ur','Oerdoe'),(399,'uz','Oezbeeks'),(400,'oj','Ojibwa'),(401,'oc','Oksitaans'),(402,'ang','Old English'),(403,'fro','Old French'),(404,'goh','Old High German'),(405,'sga','Old Irish'),(406,'non','Old Norse'),(407,'peo','Old Persian'),(408,'pro','Old ProvenÃ§al'),(409,'und','Onbekende of ongeldige taal'),(410,'or','Oriya'),(411,'om','Oromo'),(412,'osa','Osage'),(413,'os','Osseties'),(414,'ota','Ottoman Turkish'),(415,'pal','Pahlavi'),(416,'pfl','Palatine German'),(417,'pau','Palauan'),(418,'pi','Pali'),(419,'pam','Pampanga'),(420,'pa','Pandjabi'),(421,'pag','Pangasinan'),(422,'pap','Papiamento'),(423,'ps','Pasjto'),(424,'pdc','Pennsylvania German'),(425,'fa','Persies'),(426,'phn','Phoenician'),(427,'pcd','Picard'),(428,'pms','Piedmontese'),(429,'pdt','Plautdietsch'),(430,'pon','Pohnpeian'),(431,'pnt','Pontic'),(432,'pl','Pools'),(433,'pt','Portugees'),(434,'prg','Prussian'),(435,'qu','Quechua'),(436,'raj','Rajasthani'),(437,'rap','Rapanui'),(438,'rar','Rarotongan'),(439,'rm','Reto-Romaans'),(440,'rif','Riffian'),(441,'ro','Roemeens'),(442,'rgn','Romagnol'),(443,'rom','Romany'),(444,'rof','Rombo'),(445,'root','Root'),(446,'rtm','Rotuman'),(447,'rug','Roviana'),(448,'rn','Rundi'),(449,'ru','Russies'),(450,'rue','Rusyn'),(451,'rwk','Rwa'),(452,'rw','Rwandees'),(453,'ssy','Saho'),(454,'sah','Sakha'),(455,'sam','Samaritan Aramaic'),(456,'saq','Samburu'),(457,'sm','Samoaans'),(458,'sgs','Samogitian'),(459,'sad','Sandawe'),(460,'sg','Sango'),(461,'sbp','Sangu'),(462,'sa','Sanskrit'),(463,'sat','Santali'),(464,'sc','Sardinian'),(465,'sas','Sasak'),(466,'sdc','Sassarese Sardinian'),(467,'stq','Saterland Frisian'),(468,'saz','Saurashtra'),(469,'sco','Scots'),(470,'sly','Selayar'),(471,'sel','Selkup'),(472,'seh','Sena'),(473,'see','Seneca'),(474,'tzm','Sentraal Atlas Tamazight'),(475,'sh','Serbo-Croatian'),(476,'srr','Serer'),(477,'sei','Seri'),(478,'sr','Serwies'),(479,'ksb','Shambala'),(480,'shn','Shan'),(481,'sn','Shona'),(482,'ii','Sichuan Yi'),(483,'scn','Sicilian'),(484,'sid','Sidamo'),(485,'bla','Siksika'),(486,'szl','Silesian'),(487,'zh_Hans','Simplified Chinese'),(488,'sd','Sindhi'),(489,'si','Sinhala'),(490,'cgg','Sjiga'),(491,'zh','Sjinees'),(492,'sms','Skolt Sami'),(493,'gd','Skotse Gallies'),(494,'den','Slave'),(495,'sk','Slowaaks'),(496,'sl','Sloweens'),(497,'xog','Soga'),(498,'sog','Sogdien'),(499,'so','Somalies'),(500,'snk','Soninke'),(501,'ckb','Sorani Koerdies'),(502,'azb','South Azerbaijani'),(503,'alt','Southern Altai'),(504,'es','Spaans'),(505,'srn','Sranan Tongo'),(506,'zgh','Standaard Marokkaanse Tamazight'),(507,'nr','Suid-Ndebele'),(508,'sma','Suid-Sami'),(509,'st','Suid-Sotho'),(510,'suk','Sukuma'),(511,'sux','Sumerian'),(512,'su','Sundanees'),(513,'sus','Susu'),(514,'sw','Swahili'),(515,'swc','Swahili (Kongo)'),(516,'ss','Swazi'),(517,'sv','Sweeds'),(518,'fr_CH','Swiss French'),(519,'gsw','Switserse Duits'),(520,'de_CH','Switserse hoog-Duits'),(521,'syr','Syriac'),(522,'shi','Tachelhit'),(523,'tg','Tadzjieks'),(524,'tl','Tagalog'),(525,'ty','Tahities'),(526,'dav','Taita'),(527,'tly','Talysh'),(528,'tmh','Tamashek'),(529,'ta','Tamil'),(530,'trv','Taroko'),(531,'twq','Tasawaq'),(532,'tt','Tataars'),(533,'te','Telugu'),(534,'ter','Tereno'),(535,'teo','Teso'),(536,'tet','Tetum'),(537,'th','Thai'),(538,'bo','Tibettaans'),(539,'tig','Tigre'),(540,'ti','Tigrinya'),(541,'tem','Timne'),(542,'tiv','Tiv'),(543,'tli','Tlingit'),(544,'tum','Toemboeka'),(545,'tpi','Tok Pisin'),(546,'tkl','Tokelau'),(547,'to','Tongaans'),(548,'fit','Tornedalen Finnish'),(549,'zh_Hant','Traditional Chinese'),(550,'tkr','Tsakhur'),(551,'tsd','Tsakonian'),(552,'tsi','Tsimshian'),(553,'cs','Tsjeggies'),(554,'ts','Tsonga'),(555,'tn','Tswana'),(556,'tcy','Tulu'),(557,'aeb','Tunisian Arabic'),(558,'tk','Turkmeens'),(559,'tr','Turks'),(560,'tru','Turoyo'),(561,'tvl','Tuvalu'),(562,'tyv','Tuvinian'),(563,'tw','Twi'),(564,'kcg','Tyap'),(565,'udm','Udmurt'),(566,'uga','Ugaritic'),(567,'ug','Uighur'),(568,'umb','Umbundu'),(569,'vai','Vai'),(570,'mul','Veelvuldige tale'),(571,'ve','Venda'),(572,'vec','Venetian'),(573,'vep','Veps'),(574,'vi','ViÃ«t`name`,es'),(575,'nl_BE','Vlaams'),(576,'vo','VolapÃ¼k'),(577,'vro','VÃµro'),(578,'vot','Votic'),(579,'vun','Vunjo'),(580,'cy','Wallies'),(581,'wa','Walloon'),(582,'wae','Walser'),(583,'war','Waray'),(584,'wbp','Warlpiri'),(585,'was','Washo'),(586,'guc','Wayuu'),(587,'fy','Wes-Fries'),(588,'vls','West Flemish'),(589,'mrj','Western Mari'),(590,'be','Wit-Russies'),(591,'wal','Wolaytta'),(592,'wo','Wolof'),(593,'wuu','Wu Chinese'),(594,'xh','Xhosa'),(595,'hsn','Xiang Chinese'),(596,'yav','Yangben'),(597,'yao','Yao'),(598,'yap','Yapese'),(599,'ybb','Yemba'),(600,'yo','Yoruba'),(601,'is','Yslands'),(602,'zap','Zapotec'),(603,'dje','Zarma'),(604,'zza','Zaza'),(605,'zea','Zeelandic'),(606,'zen','Zenaga'),(607,'za','Zhuang'),(608,'zu','Zoeloe'),(609,'gbz','Zoroastrian Dari'),(610,'zun','Zuni');
/*!40000 ALTER TABLE `tblocale` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblocation`
--

DROP TABLE IF EXISTS `tblocation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tblocation` (
  `idLocation` int(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  PRIMARY KEY (`idLocation`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblocation`
--

LOCK TABLES `tblocation` WRITE;
/*!40000 ALTER TABLE `tblocation` DISABLE KEYS */;
INSERT INTO `tblocation` VALUES (1,'Head Office'),(2,'Branch Office'),(3,'Warehouse');
/*!40000 ALTER TABLE `tblocation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblogos`
--

DROP TABLE IF EXISTS `tblogos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tblogos` (
  `idlogo` int(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `height` int(4) NOT NULL,
  `width` int(4) NOT NULL,
  `file_name` varchar(50) NOT NULL,
  PRIMARY KEY (`idlogo`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblogos`
--

LOCK TABLES `tblogos` WRITE;
/*!40000 ALTER TABLE `tblogos` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblogos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbmodule`
--

DROP TABLE IF EXISTS `tbmodule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbmodule` (
  `idmodule` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `index` int(11) DEFAULT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  `path` varchar(20) DEFAULT NULL,
  `smarty` varchar(50) DEFAULT NULL,
  `class` varchar(50) DEFAULT NULL,
  `headerlogo` varchar(255) DEFAULT NULL,
  `reportslogo` varchar(255) DEFAULT NULL,
  `tableprefix` char(3) DEFAULT NULL,
  `defaultmodule` char(4) DEFAULT NULL,
  PRIMARY KEY (`idmodule`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbmodule`
--

LOCK TABLES `tbmodule` WRITE;
/*!40000 ALTER TABLE `tbmodule` DISABLE KEYS */;
INSERT INTO `tbmodule` VALUES (1,'Admin',0,'A','admin','adm_Navbar_name','','adm_header.png','','',''),(2,'Helpdezk',0,'A','helpdezk','hdk_Navbar_name','','','','hdk','YES'),(3,'Dashboard',0,'I','dsn','DSN_Navbar_name','','','','','');
/*!40000 ALTER TABLE `tbmodule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbnaturalperson`
--

DROP TABLE IF EXISTS `tbnaturalperson`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbnaturalperson` (
  `idnaturalperson` int(11) NOT NULL AUTO_INCREMENT,
  `idperson` int(11) NOT NULL,
  `ssn_cpf` varchar(15) DEFAULT NULL,
  `rg` varchar(20) DEFAULT NULL,
  `rgoexp` varchar(15) DEFAULT NULL,
  `dtbirth` date DEFAULT NULL,
  `mother` varchar(80) DEFAULT NULL,
  `father` varchar(80) DEFAULT NULL,
  `gender` varchar(1) DEFAULT NULL,
  PRIMARY KEY (`idnaturalperson`),
  KEY `fk_tbnaturalperson_tbperson1` (`idperson`),
  CONSTRAINT `fk_tbnaturalperson_tbperson1` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=955 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbnaturalperson`
--

LOCK TABLES `tbnaturalperson` WRITE;
/*!40000 ALTER TABLE `tbnaturalperson` DISABLE KEYS */;
INSERT INTO `tbnaturalperson` VALUES (940,1061,'03507219042','','','1997-09-25','','','M'),(954,1078,'','','','0000-00-00','','','');
/*!40000 ALTER TABLE `tbnaturalperson` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbnatureperson`
--

DROP TABLE IF EXISTS `tbnatureperson`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbnatureperson` (
  `idnatureperson` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL COMMENT 'fisica ou juridica\n',
  PRIMARY KEY (`idnatureperson`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbnatureperson`
--

LOCK TABLES `tbnatureperson` WRITE;
/*!40000 ALTER TABLE `tbnatureperson` DISABLE KEYS */;
INSERT INTO `tbnatureperson` VALUES (1,'natural'),(2,'juridical');
/*!40000 ALTER TABLE `tbnatureperson` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbneighborhood`
--

DROP TABLE IF EXISTS `tbneighborhood`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbneighborhood` (
  `idneighborhood` int(11) NOT NULL AUTO_INCREMENT,
  `idcity` int(11) NOT NULL,
  `name` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`idneighborhood`),
  KEY `fk_tbneighborhood_tbcity1` (`idcity`),
  KEY `idx_1` (`name`),
  CONSTRAINT `fk_tbneighborhood_tbcity1` FOREIGN KEY (`idcity`) REFERENCES `tbcity` (`idcity`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbneighborhood`
--

LOCK TABLES `tbneighborhood` WRITE;
/*!40000 ALTER TABLE `tbneighborhood` DISABLE KEYS */;
INSERT INTO `tbneighborhood` VALUES (1,1,'Choose');
/*!40000 ALTER TABLE `tbneighborhood` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbpermission`
--

DROP TABLE IF EXISTS `tbpermission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbpermission` (
  `idpermission` int(4) NOT NULL AUTO_INCREMENT,
  `idaccesstype` int(4) NOT NULL,
  `idprogram` int(4) NOT NULL,
  `idperson` int(4) NOT NULL,
  `allow` char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`idpermission`),
  KEY `FK_tbpermission` (`idperson`),
  KEY `FK_tbpermission2` (`idaccesstype`),
  KEY `FK_tbpermission3` (`idprogram`),
  CONSTRAINT `FK_tbpermission` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`),
  CONSTRAINT `FK_tbpermission2` FOREIGN KEY (`idaccesstype`) REFERENCES `tbaccesstype` (`idaccesstype`),
  CONSTRAINT `FK_tbpermission3` FOREIGN KEY (`idprogram`) REFERENCES `tbprogram` (`idprogram`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbpermission`
--

LOCK TABLES `tbpermission` WRITE;
/*!40000 ALTER TABLE `tbpermission` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbpermission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbperson`
--

DROP TABLE IF EXISTS `tbperson`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbperson` (
  `idperson` int(11) NOT NULL AUTO_INCREMENT,
  `idtypelogin` int(11) NOT NULL,
  `idtypeperson` int(11) NOT NULL,
  `idnatureperson` int(11) NOT NULL,
  `idtheme` int(11) NOT NULL,
  `name` varchar(60) NOT NULL,
  `login` varchar(45) DEFAULT NULL,
  `password` varchar(45) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `dtcreate` datetime DEFAULT NULL,
  `status` char(1) NOT NULL DEFAULT 'A',
  `user_vip` char(1) NOT NULL DEFAULT 'N',
  `phone_number` varchar(30) DEFAULT NULL,
  `cel_phone` varchar(30) DEFAULT NULL,
  `branch_number` varchar(10) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `cod_location` int(4) DEFAULT NULL,
  `time_value` float DEFAULT NULL,
  `overtime` float DEFAULT NULL,
  `change_pass` int(1) DEFAULT '0',
  `token` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`idperson`),
  KEY `fk_tbperson_tblogintype` (`idtypelogin`),
  KEY `fk_tbperson_tbtypeperson1` (`idtypeperson`),
  KEY `fk_tbperson_tbtheme1` (`idtheme`),
  KEY `idx_tbperson_name` (`name`),
  KEY `fk_tbperson_tbnatureperson1` (`idnatureperson`),
  KEY `idx_1` (`login`),
  KEY `fk_person_location` (`cod_location`),
  CONSTRAINT `fk_person_location` FOREIGN KEY (`cod_location`) REFERENCES `tblocation` (`idLocation`),
  CONSTRAINT `fk_tbperson_tblogintype` FOREIGN KEY (`idtypelogin`) REFERENCES `tbtypelogin` (`idtypelogin`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tbperson_tbnatureperson1` FOREIGN KEY (`idnatureperson`) REFERENCES `tbnatureperson` (`idnatureperson`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tbperson_tbtheme1` FOREIGN KEY (`idtheme`) REFERENCES `tbtheme` (`idtheme`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_tbperson_tbtypeperson1` FOREIGN KEY (`idtypeperson`) REFERENCES `tbtypeperson` (`idtypeperson`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1079 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbperson`
--

LOCK TABLES `tbperson` WRITE;
/*!40000 ALTER TABLE `tbperson` DISABLE KEYS */;
INSERT INTO `tbperson` VALUES (1,3,1,1,1,'HD Admin','[[admin_username]]','[[admin_pass]]','[[admin_email]]','[[regtime]]','A','N','','','','',0,0,0,0,''),(1038,3,4,2,1,'Demo Company','','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','2019-10-18 13:44:37','A','N','5331994000','','','',0,0,0,0,''),(1054,3,6,1,1,'IT - Infrastructure','','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','0000-00-00 00:00:00','A','N','','','','',0,0,0,0,''),(1055,3,6,1,1,'NOC - Network Operations Center','','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','0000-00-00 00:00:00','A','N','','','','',0,0,0,0,''),(1058,3,6,1,1,'HR - Human Resources','','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','0000-00-00 00:00:00','A','N','','','','',0,0,0,0,''),(1059,3,6,1,1,'Marketing','','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','0000-00-00 00:00:00','A','N','','','','',0,0,0,0,''),(1060,3,6,1,1,'Hardware Handling','','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','0000-00-00 00:00:00','A','N','','','','',0,0,0,0,''),(1061,3,3,1,1,'Demo Operator','operator','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','2019-12-05 17:24:25','A','N','','984014872','','',0,0,0,0,''),(1073,3,6,1,1,'Merchandising Operations','','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','0000-00-00 00:00:00','A','N','','','','',0,0,0,0,''),(1074,3,6,1,1,'Software Handling','','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','0000-00-00 00:00:00','A','N','','','','',0,0,0,0,''),(1078,3,2,1,1,'Demo User','user','81dc9bdb52d04dc20036dbd8313ed055','demo@helpdezk.cc','2019-12-25 21:41:04','A','N','','','','',1,0,0,0,'');
/*!40000 ALTER TABLE `tbperson` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbperson_plus`
--

DROP TABLE IF EXISTS `tbperson_plus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbperson_plus` (
  `idpersonplus` int(11) NOT NULL AUTO_INCREMENT,
  `idtypepersonplus` int(11) DEFAULT NULL,
  `idperson` int(11) DEFAULT NULL,
  `login` varchar(100) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idpersonplus`),
  UNIQUE KEY `NewIndex1` (`idtypepersonplus`,`idperson`),
  KEY `FK_tbperson_plus_person_FK` (`idperson`),
  CONSTRAINT `FK_tbperson_plus` FOREIGN KEY (`idtypepersonplus`) REFERENCES `tbtypeperson_plus` (`idtypepersonplus`) ON DELETE CASCADE,
  CONSTRAINT `FK_tbperson_plus_person_FK` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`) ON DELETE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbperson_plus`
--

LOCK TABLES `tbperson_plus` WRITE;
/*!40000 ALTER TABLE `tbperson_plus` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbperson_plus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbpersontypes`
--

DROP TABLE IF EXISTS `tbpersontypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbpersontypes` (
  `idperson` int(11) NOT NULL,
  `idtypeperson` int(11) NOT NULL,
  PRIMARY KEY (`idperson`,`idtypeperson`),
  KEY `idtypeperson` (`idtypeperson`),
  CONSTRAINT `tbpersontypes_ibfk_1` FOREIGN KEY (`idperson`) REFERENCES `tbperson` (`idperson`),
  CONSTRAINT `tbpersontypes_ibfk_2` FOREIGN KEY (`idtypeperson`) REFERENCES `tbtypeperson` (`idtypeperson`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbpersontypes`
--

LOCK TABLES `tbpersontypes` WRITE;
/*!40000 ALTER TABLE `tbpersontypes` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbpersontypes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbprogram`
--

DROP TABLE IF EXISTS `tbprogram`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbprogram` (
  `idprogram` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `controller` varchar(20) NOT NULL,
  `idprogramcategory` int(11) NOT NULL,
  `index` int(11) DEFAULT NULL,
  `status` char(1) NOT NULL,
  `smarty` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`idprogram`),
  KEY `fk_tbprogramcategory` (`idprogramcategory`),
  CONSTRAINT `FK_tbprogramct` FOREIGN KEY (`idprogramcategory`) REFERENCES `tbprogramcategory` (`idprogramcategory`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbprogram`
--

LOCK TABLES `tbprogram` WRITE;
/*!40000 ALTER TABLE `tbprogram` DISABLE KEYS */;
INSERT INTO `tbprogram` VALUES (1,'People & Companies','person/',1,0,'A','pgr_people'),(2,'Holidays','holidays/',1,0,'A','pgr_holidays'),(3,'Programs','program/',1,0,'A','pgr_programs'),(4,'Modules','modules/',1,0,'A','pgr_modules'),(7,'Groups','hdkGroup',2,0,'A','pgr_groups'),(9,'Departments','hdkDepartment',2,0,'A','pgr_departments'),(12,'Services','hdkService',2,0,'A','pgr_services'),(16,'Request Reason','hdkReason',2,0,'A','pgr_req_reason'),(23,'Email Configuration','hdkEmailConfig',2,0,'A','pgr_email_config'),(32,'Type Person Permission','typepersonpermission',1,0,'A','pgr_type_permission'),(61,'Logos','logos/',17,0,'A','pgr_logos'),(73,'Warnings','hdkWarning/',2,0,'A','pgr_warnings'),(74,'Widgets','widget/',19,0,'A','pgr_dash_widgets'),(79,'Requests by email','hdkRequestEmail/',2,0,'A','pgr_email_request'),(81,'Vocabulary ','vocabulary',1,0,'A','pgr_vocabulary'),(82,'System Features','features',17,0,'A','pgr_sys_features');
/*!40000 ALTER TABLE `tbprogram` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbprogramcategory`
--

DROP TABLE IF EXISTS `tbprogramcategory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbprogramcategory` (
  `idprogramcategory` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `idmodule` int(11) NOT NULL,
  `smarty` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`idprogramcategory`),
  KEY `FK_tbprogramcategory` (`idmodule`),
  CONSTRAINT `FK_tbprogramcategory` FOREIGN KEY (`idmodule`) REFERENCES `tbmodule` (`idmodule`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbprogramcategory`
--

LOCK TABLES `tbprogramcategory` WRITE;
/*!40000 ALTER TABLE `tbprogramcategory` DISABLE KEYS */;
INSERT INTO `tbprogramcategory` VALUES (1,'Records',1,'cat_records'),(2,'Records',2,'cat_records'),(13,'Reports',2,'cat_reports'),(17,'Config',1,'cat_config'),(18,'Database',2,'cat_database'),(19,'Records',3,'cat_records');
/*!40000 ALTER TABLE `tbprogramcategory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbscreen`
--

DROP TABLE IF EXISTS `tbscreen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbscreen` (
  `idscreen` int(11) NOT NULL AUTO_INCREMENT,
  `idmodule` int(11) DEFAULT NULL,
  `formid` varchar(50) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`idscreen`),
  UNIQUE KEY `UK_tbscreen` (`idmodule`,`formid`),
  CONSTRAINT `FK_tbscreen_tbmodule_idmodule` FOREIGN KEY (`idmodule`) REFERENCES `tbmodule` (`idmodule`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=16384;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbscreen`
--

LOCK TABLES `tbscreen` WRITE;
/*!40000 ALTER TABLE `tbscreen` DISABLE KEYS */;
INSERT INTO `tbscreen` VALUES (1,2,'persondata_form','Scrren used to update person data by user');
/*!40000 ALTER TABLE `tbscreen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbscreen_permission`
--

DROP TABLE IF EXISTS `tbscreen_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbscreen_permission` (
  `idscreenpermission` int(11) NOT NULL AUTO_INCREMENT,
  `idscreen` int(11) DEFAULT NULL,
  `idtypeperson` int(11) DEFAULT NULL,
  `fieldid` varchar(50) NOT NULL,
  `enable` char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`idscreenpermission`),
  KEY `FK_tbscreen_permission_tbscreen_idscreen` (`idscreen`),
  KEY `FK_tbscreen_permission_tbtypeperson_idtypeperson` (`idtypeperson`),
  CONSTRAINT `FK_tbscreen_permission_tbscreen_idscreen` FOREIGN KEY (`idscreen`) REFERENCES `tbscreen` (`idscreen`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_tbscreen_permission_tbtypeperson_idtypeperson` FOREIGN KEY (`idtypeperson`) REFERENCES `tbtypeperson` (`idtypeperson`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 AVG_ROW_LENGTH=5461;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbscreen_permission`
--

LOCK TABLES `tbscreen_permission` WRITE;
/*!40000 ALTER TABLE `tbscreen_permission` DISABLE KEYS */;
INSERT INTO `tbscreen_permission` VALUES (1,1,2,'person_name','N'),(2,1,2,'ssn_cpf','Y'),(3,1,2,'person_cellphone','Y');
/*!40000 ALTER TABLE `tbscreen_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbstate`
--

DROP TABLE IF EXISTS `tbstate`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbstate` (
  `idstate` int(11) NOT NULL AUTO_INCREMENT,
  `idcountry` int(11) NOT NULL,
  `abbr` varchar(15) DEFAULT NULL,
  `name` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`idstate`),
  KEY `fk_tbstate_tbcountry1` (`idcountry`),
  CONSTRAINT `fk_tbstate_tbcountry1` FOREIGN KEY (`idcountry`) REFERENCES `tbcountry` (`idcountry`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=1099 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbstate`
--

LOCK TABLES `tbstate` WRITE;
/*!40000 ALTER TABLE `tbstate` DISABLE KEYS */;
INSERT INTO `tbstate` VALUES (1,1,'AA','Choose'),(1098,227,'AL','Alabama');
/*!40000 ALTER TABLE `tbstate` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbstreet`
--

DROP TABLE IF EXISTS `tbstreet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbstreet` (
  `idstreet` int(11) NOT NULL AUTO_INCREMENT,
  `idtypestreet` int(11) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`idstreet`),
  KEY `fk_tbstreet_tbtypestreet1` (`idtypestreet`),
  CONSTRAINT `fk_tbstreet_tbtypestreet1` FOREIGN KEY (`idtypestreet`) REFERENCES `tbtypestreet` (`idtypestreet`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbstreet`
--

LOCK TABLES `tbstreet` WRITE;
/*!40000 ALTER TABLE `tbstreet` DISABLE KEYS */;
INSERT INTO `tbstreet` VALUES (1,1,'Choose'),(60,309,'Bennett Dr');
/*!40000 ALTER TABLE `tbstreet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbteste`
--

DROP TABLE IF EXISTS `tbteste`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbteste` (
  `idex` int(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `age` int(3) NOT NULL,
  PRIMARY KEY (`idex`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbteste`
--

LOCK TABLES `tbteste` WRITE;
/*!40000 ALTER TABLE `tbteste` DISABLE KEYS */;
INSERT INTO `tbteste` VALUES (1,'teste 2',123),(2,'Alejandro',20),(3,'Deivisson',26),(5,'Fulano 5',54);
/*!40000 ALTER TABLE `tbteste` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbtheme`
--

DROP TABLE IF EXISTS `tbtheme`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbtheme` (
  `idtheme` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`idtheme`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbtheme`
--

LOCK TABLES `tbtheme` WRITE;
/*!40000 ALTER TABLE `tbtheme` DISABLE KEYS */;
INSERT INTO `tbtheme` VALUES (1,'Mq Theme'),(2,'Usbs Theme');
/*!40000 ALTER TABLE `tbtheme` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbtracker`
--

DROP TABLE IF EXISTS `tbtracker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbtracker` (
  `idtracker` int(11) NOT NULL AUTO_INCREMENT,
  `idemail` int(11) NOT NULL,
  `campaign` varchar(255) DEFAULT NULL,
  `ipaddress` varchar(39) DEFAULT NULL,
  `php_self` varchar(255) DEFAULT NULL COMMENT 'The filename of the currently executing script, relative to the document root',
  `http_user_agent` varchar(255) DEFAULT NULL COMMENT 'This is a string denoting the user agent being which is accessing the page',
  `http_referer` varchar(255) DEFAULT NULL COMMENT 'The address of the page (if any) which referred the user agent to the current page.',
  `request_uri` varchar(255) DEFAULT NULL COMMENT 'The URI which was given in order to access this page',
  `request_time` int(11) DEFAULT NULL COMMENT 'The timestamp of the start of the request',
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`idtracker`),
  KEY `IDX_tbtracker_date` (`date`),
  KEY `IDX_tbtracker_campaign` (`campaign`),
  KEY `FK_tbtracker` (`idemail`),
  CONSTRAINT `FK_tbtracker` FOREIGN KEY (`idemail`) REFERENCES `tbemail` (`idemail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbtracker`
--

LOCK TABLES `tbtracker` WRITE;
/*!40000 ALTER TABLE `tbtracker` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbtracker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbtypeaddress`
--

DROP TABLE IF EXISTS `tbtypeaddress`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbtypeaddress` (
  `idtypeaddress` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`idtypeaddress`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbtypeaddress`
--

LOCK TABLES `tbtypeaddress` WRITE;
/*!40000 ALTER TABLE `tbtypeaddress` DISABLE KEYS */;
INSERT INTO `tbtypeaddress` VALUES (1,'Choose'),(2,'residential'),(3,'commercial');
/*!40000 ALTER TABLE `tbtypeaddress` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbtypelogin`
--

DROP TABLE IF EXISTS `tbtypelogin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbtypelogin` (
  `idtypelogin` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`idtypelogin`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbtypelogin`
--

LOCK TABLES `tbtypelogin` WRITE;
/*!40000 ALTER TABLE `tbtypelogin` DISABLE KEYS */;
INSERT INTO `tbtypelogin` VALUES (1,'POP'),(2,'AD'),(3,'HD'),(4,'REQUEST');
/*!40000 ALTER TABLE `tbtypelogin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbtypeperson`
--

DROP TABLE IF EXISTS `tbtypeperson`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbtypeperson` (
  `idtypeperson` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `permissiongroup` char(1) DEFAULT 'N',
  PRIMARY KEY (`idtypeperson`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbtypeperson`
--

LOCK TABLES `tbtypeperson` WRITE;
/*!40000 ALTER TABLE `tbtypeperson` DISABLE KEYS */;
INSERT INTO `tbtypeperson` VALUES (1,'admin','N'),(2,'user','N'),(3,'operator','N'),(4,'costumer','N'),(5,'partner','N'),(6,'group','N');
/*!40000 ALTER TABLE `tbtypeperson` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbtypeperson_plus`
--

DROP TABLE IF EXISTS `tbtypeperson_plus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbtypeperson_plus` (
  `idtypepersonplus` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`idtypepersonplus`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbtypeperson_plus`
--

LOCK TABLES `tbtypeperson_plus` WRITE;
/*!40000 ALTER TABLE `tbtypeperson_plus` DISABLE KEYS */;
INSERT INTO `tbtypeperson_plus` VALUES (1,'Google'),(2,'Facebook');
/*!40000 ALTER TABLE `tbtypeperson_plus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbtypepersonpermission`
--

DROP TABLE IF EXISTS `tbtypepersonpermission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbtypepersonpermission` (
  `idpermissiongroup` int(4) NOT NULL AUTO_INCREMENT,
  `idprogram` int(4) NOT NULL,
  `idtypeperson` int(4) NOT NULL,
  `idaccesstype` int(4) NOT NULL,
  `allow` char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (`idpermissiongroup`),
  KEY `FK_tbpermissiongroup` (`idprogram`),
  KEY `FK_tbpermissiongroup2` (`idtypeperson`),
  KEY `FK_tbpermissiongroup3` (`idaccesstype`),
  CONSTRAINT `FK_tbpermissiongroup` FOREIGN KEY (`idprogram`) REFERENCES `tbprogram` (`idprogram`),
  CONSTRAINT `FK_tbpermissiongroup2` FOREIGN KEY (`idtypeperson`) REFERENCES `tbtypeperson` (`idtypeperson`),
  CONSTRAINT `FK_tbpermissiongroup3` FOREIGN KEY (`idaccesstype`) REFERENCES `tbaccesstype` (`idaccesstype`)
) ENGINE=InnoDB AUTO_INCREMENT=1055 DEFAULT CHARSET=latin1 CHECKSUM=1 DELAY_KEY_WRITE=1 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbtypepersonpermission`
--

LOCK TABLES `tbtypepersonpermission` WRITE;
/*!40000 ALTER TABLE `tbtypepersonpermission` DISABLE KEYS */;
INSERT INTO `tbtypepersonpermission` VALUES (1,1,1,1,'Y'),(2,1,2,1,'N'),(3,1,3,1,'Y'),(4,1,4,1,'N'),(5,1,5,1,'N'),(6,1,1,2,'Y'),(7,1,2,2,'N'),(8,1,3,2,'Y'),(9,1,4,2,'N'),(10,1,5,2,'N'),(11,1,1,3,'Y'),(12,1,2,3,'N'),(13,1,3,3,'Y'),(14,1,4,3,'N'),(15,1,5,3,'N'),(16,1,1,4,'Y'),(17,1,2,4,'N'),(18,1,3,4,'N'),(19,1,4,4,'N'),(20,1,5,4,'N'),(21,2,1,1,'Y'),(22,2,2,1,'N'),(23,2,3,1,'N'),(24,2,4,1,'N'),(25,2,5,1,'N'),(26,2,1,2,'Y'),(27,2,2,2,'N'),(28,2,3,2,'N'),(29,2,4,2,'N'),(30,2,5,2,'N'),(31,2,1,3,'Y'),(32,2,2,3,'N'),(33,2,3,3,'N'),(34,2,4,3,'N'),(35,2,5,3,'N'),(36,2,1,4,'Y'),(37,2,2,4,'N'),(38,2,3,4,'N'),(39,2,4,4,'N'),(40,2,5,4,'N'),(41,3,1,1,'Y'),(42,3,2,1,'N'),(43,3,3,1,'N'),(44,3,4,1,'N'),(45,3,5,1,'N'),(46,3,1,2,'Y'),(47,3,2,2,'N'),(48,3,3,2,'N'),(49,3,4,2,'N'),(50,3,5,2,'N'),(51,3,1,3,'Y'),(52,3,2,3,'N'),(53,3,3,3,'N'),(54,3,4,3,'N'),(55,3,5,3,'N'),(56,3,1,4,'Y'),(57,3,2,4,'N'),(58,3,3,4,'N'),(59,3,4,4,'N'),(60,3,5,4,'N'),(61,4,1,1,'Y'),(62,4,2,1,'N'),(63,4,3,1,'N'),(64,4,4,1,'N'),(65,4,5,1,'N'),(66,4,1,2,'Y'),(67,4,2,2,'N'),(68,4,3,2,'N'),(69,4,4,2,'N'),(70,4,5,2,'N'),(71,4,1,3,'Y'),(72,4,2,3,'N'),(73,4,3,3,'N'),(74,4,4,3,'N'),(75,4,5,3,'N'),(76,4,1,4,'Y'),(77,4,2,4,'N'),(78,4,3,4,'N'),(79,4,4,4,'N'),(80,4,5,4,'N'),(121,7,1,1,'Y'),(122,7,2,1,'N'),(123,7,3,1,'N'),(124,7,4,1,'N'),(125,7,5,1,'N'),(126,7,1,2,'Y'),(127,7,2,2,'N'),(128,7,3,2,'N'),(129,7,4,2,'N'),(130,7,5,2,'N'),(131,7,1,3,'Y'),(132,7,2,3,'N'),(133,7,3,3,'N'),(134,7,4,3,'N'),(135,7,5,3,'N'),(136,7,1,4,'Y'),(137,7,2,4,'N'),(138,7,3,4,'N'),(139,7,4,4,'N'),(140,7,5,4,'N'),(161,9,1,1,'Y'),(162,9,2,1,'N'),(163,9,3,1,'N'),(164,9,4,1,'N'),(165,9,5,1,'N'),(166,9,1,2,'Y'),(167,9,2,2,'N'),(168,9,3,2,'N'),(169,9,4,2,'N'),(170,9,5,2,'N'),(171,9,1,3,'Y'),(172,9,2,3,'N'),(173,9,3,3,'N'),(174,9,4,3,'N'),(175,9,5,3,'N'),(176,9,1,4,'Y'),(177,9,2,4,'N'),(178,9,3,4,'N'),(179,9,4,4,'N'),(180,9,5,4,'N'),(221,12,1,1,'Y'),(222,12,2,1,'N'),(223,12,3,1,'N'),(224,12,4,1,'N'),(225,12,5,1,'N'),(226,12,1,2,'Y'),(227,12,2,2,'N'),(228,12,3,2,'N'),(229,12,4,2,'N'),(230,12,5,2,'N'),(231,12,1,3,'Y'),(232,12,2,3,'N'),(233,12,3,3,'N'),(234,12,4,3,'N'),(235,12,5,3,'N'),(236,12,1,4,'Y'),(237,12,2,4,'N'),(238,12,3,4,'N'),(239,12,4,4,'N'),(240,12,5,4,'N'),(281,16,1,1,'Y'),(282,16,2,1,'N'),(283,16,3,1,'N'),(284,16,4,1,'N'),(285,16,5,1,'N'),(286,16,1,2,'Y'),(287,16,2,2,'N'),(288,16,3,2,'N'),(289,16,4,2,'N'),(290,16,5,2,'N'),(291,16,1,3,'Y'),(292,16,2,3,'N'),(293,16,3,3,'N'),(294,16,4,3,'N'),(295,16,5,3,'N'),(296,16,1,4,'Y'),(297,16,2,4,'N'),(298,16,3,4,'N'),(299,16,4,4,'N'),(300,16,5,4,'N'),(341,23,1,1,'Y'),(342,23,2,1,'N'),(343,23,3,1,'N'),(344,23,4,1,'N'),(345,23,5,1,'N'),(346,23,1,2,'Y'),(347,23,2,2,'N'),(348,23,3,2,'N'),(349,23,4,2,'N'),(350,23,5,2,'N'),(351,23,1,3,'Y'),(352,23,2,3,'N'),(353,23,3,3,'N'),(354,23,4,3,'N'),(355,23,5,3,'N'),(356,23,1,4,'Y'),(357,23,2,4,'N'),(358,23,3,4,'N'),(359,23,4,4,'N'),(360,23,5,4,'N'),(381,2,1,5,'Y'),(382,2,2,5,'N'),(383,2,3,5,'N'),(384,2,4,5,'N'),(385,2,5,5,'N'),(386,32,1,1,'Y'),(387,32,1,2,'Y'),(388,32,1,3,'Y'),(592,61,1,1,'Y'),(593,61,2,1,'N'),(594,61,3,1,'N'),(595,61,4,1,'N'),(596,61,5,1,'N'),(597,61,1,2,'Y'),(598,61,2,2,'N'),(599,61,3,2,'N'),(600,61,4,2,'N'),(601,61,5,2,'N'),(602,61,1,3,'Y'),(603,61,2,3,'N'),(604,61,3,3,'N'),(605,61,4,3,'N'),(606,61,5,3,'N'),(607,61,1,4,'N'),(608,61,2,4,'N'),(609,61,3,4,'N'),(610,61,4,4,'N'),(611,61,5,4,'N'),(840,73,1,1,'Y'),(841,73,2,1,'N'),(842,73,3,1,'N'),(843,73,4,1,'N'),(844,73,5,1,'N'),(845,73,6,1,'N'),(846,73,1,2,'Y'),(847,73,2,2,'N'),(848,73,3,2,'N'),(849,73,4,2,'N'),(850,73,5,2,'N'),(851,73,6,2,'N'),(852,73,1,5,'Y'),(853,73,2,5,'N'),(854,73,3,5,'N'),(855,73,4,5,'N'),(856,73,5,5,'N'),(857,73,6,5,'N'),(858,74,1,1,'Y'),(859,74,1,2,'Y'),(860,74,1,3,'Y'),(861,74,1,4,'Y'),(862,74,1,5,'N'),(941,79,1,1,'Y'),(942,79,2,1,'N'),(943,79,3,1,'N'),(944,79,4,1,'N'),(945,79,5,1,'N'),(946,79,6,1,'N'),(947,79,1,2,'Y'),(948,79,2,2,'N'),(949,79,3,2,'N'),(950,79,4,2,'N'),(951,79,5,2,'N'),(952,79,6,2,'N'),(953,79,1,3,'Y'),(954,79,2,3,'N'),(955,79,3,3,'N'),(956,79,4,3,'N'),(957,79,5,3,'N'),(958,79,6,3,'N'),(959,79,1,4,'Y'),(960,79,2,4,'N'),(961,79,3,4,'N'),(962,79,4,4,'N'),(963,79,5,4,'N'),(964,79,6,4,'N'),(995,81,1,1,'Y'),(996,81,2,1,'N'),(997,81,3,1,'N'),(998,81,4,1,'N'),(999,81,5,1,'N'),(1000,81,6,1,'N'),(1001,81,1,2,'Y'),(1002,81,2,2,'N'),(1003,81,3,2,'N'),(1004,81,4,2,'N'),(1005,81,5,2,'N'),(1006,81,6,2,'N'),(1007,81,1,3,'Y'),(1008,81,2,3,'N'),(1009,81,3,3,'N'),(1010,81,4,3,'N'),(1011,81,5,3,'N'),(1012,81,6,3,'N'),(1013,81,1,4,'Y'),(1014,81,2,4,'N'),(1015,81,3,4,'N'),(1016,81,4,4,'N'),(1017,81,5,4,'N'),(1018,81,6,4,'N'),(1019,81,1,5,'N'),(1020,81,2,5,'N'),(1021,81,3,5,'N'),(1022,81,4,5,'N'),(1023,81,5,5,'N'),(1024,81,6,5,'N'),(1025,81,1,6,'N'),(1026,81,2,6,'N'),(1027,81,3,6,'N'),(1028,81,4,6,'N'),(1029,81,5,6,'N'),(1030,81,6,6,'N'),(1031,82,1,1,'Y'),(1032,82,2,1,'N'),(1033,82,3,1,'N'),(1034,82,4,1,'N'),(1035,82,5,1,'N'),(1036,82,6,1,'N'),(1037,82,1,2,'Y'),(1038,82,2,2,'N'),(1039,82,3,2,'N'),(1040,82,4,2,'N'),(1041,82,5,2,'N'),(1042,82,6,2,'N'),(1043,82,1,3,'Y'),(1044,82,2,3,'N'),(1045,82,3,3,'N'),(1046,82,4,3,'N'),(1047,82,5,3,'N'),(1048,82,6,3,'N'),(1049,82,1,4,'Y'),(1050,82,2,4,'N'),(1051,82,3,4,'N'),(1052,82,4,4,'N'),(1053,82,5,4,'N'),(1054,82,6,4,'N');
/*!40000 ALTER TABLE `tbtypepersonpermission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbtypestreet`
--

DROP TABLE IF EXISTS `tbtypestreet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbtypestreet` (
  `idtypestreet` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `abbr` varchar(15) DEFAULT NULL,
  `location` char(20) DEFAULT NULL,
  PRIMARY KEY (`idtypestreet`)
) ENGINE=InnoDB AUTO_INCREMENT=340 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbtypestreet`
--

LOCK TABLES `tbtypestreet` WRITE;
/*!40000 ALTER TABLE `tbtypestreet` DISABLE KEYS */;
INSERT INTO `tbtypestreet` VALUES (1,'Choose','AAA','pt_BR'),(2,'Avenue','AVE','pt_BR'),(4,'Street','ST','pt_BR'),(5,'Alameda','AL','pt_BR'),(6,'Acesso','AC','pt_BR'),(7,'Adro','AD','pt_BR'),(8,'Aeroporto','ERA','pt_BR'),(9,'Alameda','AL','pt_BR'),(10,'Alto','AT','pt_BR'),(11,'Ã¯Â¿Â½rea','A','pt_BR'),(12,'Ã¯Â¿Â½rea Especial','AE','pt_BR'),(13,'ArtÃ¯Â¿Â½ria','ART','pt_BR'),(14,'Atalho','ATL','pt_BR'),(15,'Avenida','AV','pt_BR'),(16,'Avenida Contorno','AV-CONT','pt_BR'),(17,'Baixa','BX','pt_BR'),(18,'BalÃ¯Â¿Â½o','BLO','pt_BR'),(19,'BalneÃ¯Â¿Â½rio','BAL','pt_BR'),(20,'Beco','BC','pt_BR'),(21,'Belvedere','BELV','pt_BR'),(22,'Bloco','BL','pt_BR'),(23,'Bosque','BSQ','pt_BR'),(24,'Boulevard','BVD','pt_BR'),(25,'Buraco','BCO','pt_BR'),(26,'Cais','C','pt_BR'),(27,'CalÃ¯Â¿Â½ada','CALC','pt_BR'),(28,'Caminho','CAM','pt_BR'),(29,'Campo','CPO','pt_BR'),(30,'Canal','CAN','pt_BR'),(31,'ChÃ¯Â¿Â½cara','CH','pt_BR'),(32,'ChapadÃ¯Â¿Â½o','CHAP','pt_BR'),(33,'Circular','CIRC','pt_BR'),(34,'ColÃ¯Â¿Â½nia','COL','pt_BR'),(35,'Complexo ViÃ¯Â¿Â½rio','CMP-VR','pt_BR'),(36,'CondomÃ¯Â¿Â½nio','COND','pt_BR'),(37,'Conjunto','CJ','pt_BR'),(38,'Corredor','COR','pt_BR'),(39,'CÃ¯Â¿Â½rrego','CRG','pt_BR'),(40,'Descida','DSC','pt_BR'),(41,'Desvio','DSV','pt_BR'),(42,'Distrito','DT','pt_BR'),(43,'Elevada','EVD','pt_BR'),(44,'Entrada Particular','ENT-PART','pt_BR'),(45,'Entre Quadra','EQ','pt_BR'),(46,'Escada','ESC','pt_BR'),(47,'Esplanada','ESP','pt_BR'),(48,'EstaÃ¯Â¿Â½Ã¯Â¿Â½o','ETC','pt_BR'),(49,'Estacionamento','ESTC','pt_BR'),(50,'EstÃ¯Â¿Â½dio','ETD','pt_BR'),(51,'EstÃ¯Â¿Â½ncia','ETN','pt_BR'),(52,'Estrada','EST','pt_BR'),(53,'Estrada Municipal','EST-MUN','pt_BR'),(54,'Favela','FAV','pt_BR'),(55,'Fazenda','FAZ','pt_BR'),(56,'Feira','FRA','pt_BR'),(57,'Ferrovia','FER','pt_BR'),(58,'Fonte','FNT','pt_BR'),(59,'Forte','FTE','pt_BR'),(60,'Galeria','GAL','pt_BR'),(61,'Granja','GJA','pt_BR'),(62,'Habitacional','HAB','pt_BR'),(63,'Ilha','IA','pt_BR'),(64,'Jardim','JD','pt_BR'),(65,'Jardinete','JDE','pt_BR'),(66,'Ladeira','LD','pt_BR'),(67,'Lago','LG','pt_BR'),(68,'Lagoa','LGA','pt_BR'),(69,'Largo','LRG','pt_BR'),(70,'Loteamento','LOT','pt_BR'),(71,'Marina','MNA','pt_BR'),(72,'MÃ¯Â¿Â½dulo','MOD','pt_BR'),(73,'Monte','TEM','pt_BR'),(74,'Morro','MRO','pt_BR'),(75,'NÃ¯Â¿Â½cleo','NUC','pt_BR'),(76,'Parada','PDA','pt_BR'),(77,'Paradouro','PDO','pt_BR'),(78,'Paralela','PAR','pt_BR'),(79,'Parque','PRQ','pt_BR'),(80,'Passagem','PSG','pt_BR'),(81,'Passagem SubterrÃ¯Â¿Â½nea','PSC-SUB','pt_BR'),(82,'Passarela','PSA','pt_BR'),(83,'Passeio','PAS','pt_BR'),(84,'PÃ¯Â¿Â½tio','PAT','pt_BR'),(85,'Ponta','PNT','pt_BR'),(86,'Ponte','PTE','pt_BR'),(87,'Porto','PTO','pt_BR'),(88,'PraÃ¯Â¿Â½a','PC','pt_BR'),(89,'PraÃ¯Â¿Â½a de Esportes','PC-ESP','pt_BR'),(90,'Praia','PR','pt_BR'),(91,'Prolongamento','PRL','pt_BR'),(92,'Quadra','Q','pt_BR'),(93,'Quinta','QTA','pt_BR'),(94,'Ane Quintas','QTASRodo','pt_BR'),(95,'Ramal','RAM','pt_BR'),(96,'Rampa','RMP','pt_BR'),(97,'Recanto','REC','pt_BR'),(98,'Residencial','RES','pt_BR'),(99,'Reta','RET','pt_BR'),(100,'Retiro','RER','pt_BR'),(101,'Retorno','RTN','pt_BR'),(102,'Rodo Anel','ROD-AN','pt_BR'),(103,'Rodovia','ROD','pt_BR'),(104,'RotatÃ¯Â¿Â½ria','RTT','pt_BR'),(105,'RÃ¯Â¿Â½tula','ROT','pt_BR'),(106,'Rua','R','pt_BR'),(107,'Rua de LigaÃ¯Â¿Â½Ã¯Â¿Â½o','R-LIG','pt_BR'),(108,'Rua de Pedestre','R-PED','pt_BR'),(109,'ServidÃ¯Â¿Â½o','SRV','pt_BR'),(110,'Setor','ST','pt_BR'),(111,'SÃ¯Â¿Â½tio','SIT','pt_BR'),(112,'Subida','SUB','pt_BR'),(113,'Terminal','TER','pt_BR'),(114,'Travessa','TV','pt_BR'),(115,'Travessa Particular','TV-PART','pt_BR'),(116,'Trecho','TRC','pt_BR'),(117,'Trevo','TRV','pt_BR'),(118,'Trincheira','TCH','pt_BR'),(119,'TÃ¯Â¿Â½nel','TUN','pt_BR'),(120,'Unidade','UNID','pt_BR'),(121,'Vala','VAL','pt_BR'),(122,'Vale','VLE','pt_BR'),(123,'Variante','VRTE','pt_BR'),(124,'Vereda','VER','pt_BR'),(125,'Via','V','pt_BR'),(126,'Via de Acesso','V-AC','pt_BR'),(127,'Via de Pedestre','V-PED','pt_BR'),(128,'Via Elevado','V-EVD','pt_BR'),(129,'Via Expressa','V-EXP','pt_BR'),(130,'Viaduto','VD','pt_BR'),(131,'Viela','VLA','pt_BR'),(132,'Vila','VL','pt_BR'),(133,'Zigue-Zague','ZIG-ZAG','pt_BR'),(134,'ALLEY','ALY','en_US'),(135,'ANEX','ANX','en_US'),(136,'ARCADE','ARC','en_US'),(137,'AVENUE','AVE','en_US'),(138,'BAYOU','BYU','en_US'),(139,'BEACH','BCH','en_US'),(140,'BEND','BND','en_US'),(141,'BLUFF','BLF','en_US'),(142,'BLUFFS','BLFS','en_US'),(143,'BOTTOM','BTM','en_US'),(144,'BOULEVARD','BLVD','en_US'),(145,'BRANCH','BR','en_US'),(146,'BRIDGE','BRG','en_US'),(147,'BROOK','BRK','en_US'),(148,'BROOKS','BRKS','en_US'),(149,'BURG','BG','en_US'),(150,'BURGS','BGS','en_US'),(151,'BYPASS','BYP','en_US'),(152,'CAMP','CP','en_US'),(153,'CANYON','CYN','en_US'),(154,'CAPE','CPE','en_US'),(155,'CAUSEWAY','CSWY','en_US'),(156,'CENTER','CTR','en_US'),(157,'CENTERS','CTRS','en_US'),(158,'CIRCLE','CIR','en_US'),(159,'CIRCLES','CIRS','en_US'),(160,'CLIFF','CLF','en_US'),(161,'CLIFFS','CLFS','en_US'),(162,'CLUB','CLB','en_US'),(163,'COMMON','CMN','en_US'),(164,'COMMONS','CMNS','en_US'),(165,'CORNER','COR','en_US'),(166,'CORNERS','CORS','en_US'),(167,'COURSE','CRSE','en_US'),(168,'COURT','CT','en_US'),(169,'COURTS','CTS','en_US'),(170,'COVE','CV','en_US'),(171,'COVES','CVS','en_US'),(172,'CREEK','CRK','en_US'),(173,'CRESCENT','CRES','en_US'),(174,'CREST','CRST','en_US'),(175,'CROSSING','XING','en_US'),(176,'CROSSROAD','XRD','en_US'),(177,'CROSSROADS','XRDS','en_US'),(178,'CURVE ','CURV','en_US'),(179,'DALE','DL','en_US'),(180,'DAM','DM','en_US'),(181,'DIVIDE','DV','en_US'),(182,'DRIVE','DR','en_US'),(183,'DRIVES','DRS','en_US'),(184,'ESTATE','EST','en_US'),(185,'ESTATES','ESTS','en_US'),(186,'EXPRESSWAY','EXPY','en_US'),(187,'EXTENSION','EXT','en_US'),(188,'EXTENSIONS','EXTS','en_US'),(189,'FALL','FALL','en_US'),(190,'FALLS','FLS','en_US'),(191,'FERRY','FRY','en_US'),(192,'FIELD','FLD','en_US'),(193,'FIELDS','FLDS','en_US'),(194,'FLAT','FLT','en_US'),(195,'FLATS','FLTS','en_US'),(196,'FORD','FRD','en_US'),(197,'FORDS','FRDS','en_US'),(198,'FOREST','FRST','en_US'),(199,'FORGE','FRG','en_US'),(200,'FORGES','FRGS','en_US'),(201,'FORK','FRK','en_US'),(202,'FORKS','FRKS','en_US'),(203,'FORT','FT','en_US'),(204,'FREEWAY','FWY','en_US'),(205,'GARDEN','GDN','en_US'),(206,'GARDENS','GDNS','en_US'),(207,'GATEWAY','GTWY','en_US'),(208,'GLEN','GLN','en_US'),(209,'GLENS','GLNS','en_US'),(210,'GREEN','GRN','en_US'),(211,'GREENS','GRNS','en_US'),(212,'GROVE','GRV','en_US'),(213,'GROVES','GRVS','en_US'),(214,'HARBOR','HBR','en_US'),(215,'HARBORS','HBRS','en_US'),(216,'HAVEN','HVN','en_US'),(217,'HEIGHTS','HTS','en_US'),(218,'HIGHWAY','HWY','en_US'),(219,'HILL','HL','en_US'),(220,'HILLS','HLS','en_US'),(221,'HOLLOW','HOLW','en_US'),(222,'INLET','INLT','en_US'),(223,'ISLAND','IS','en_US'),(224,'ISLANDS','ISS','en_US'),(225,'ISLE','ISLE','en_US'),(226,'JUNCTION','JCT','en_US'),(227,'JUNCTIONS','JCTS','en_US'),(228,'KEY','KY','en_US'),(229,'KEYS','KYS','en_US'),(230,'KNOLL','KNL ','en_US'),(231,'KNOLLS','KNLS','en_US'),(232,'LAKE','LK','en_US'),(233,'LAKES','LKS','en_US'),(234,'LAND','LAND','en_US'),(235,'LANDING','LNDG','en_US'),(236,'LANE','LN','en_US'),(237,'LIGHT','LGT','en_US'),(238,'LIGHTS','LGTS','en_US'),(239,'LOAF','LF','en_US'),(240,'LOCK','LCK','en_US'),(241,'LOCKS','LCKS','en_US'),(242,'LODGE','LDG','en_US'),(243,'LOOP','LOOP','en_US'),(244,'MALL','MALL','en_US'),(245,'MANOR','MNR','en_US'),(246,'MANORS','MNRS','en_US'),(247,'MEADOW','MDW','en_US'),(248,'MEADOWS','MDWS','en_US'),(249,'MEWS','MEWS','en_US'),(250,'MILL','ML','en_US'),(251,'MILLS','MLS','en_US'),(252,'MISSION','MSN','en_US'),(253,'MOTORWAY','MTWY','en_US'),(254,'MOUNT','MT','en_US'),(255,'MOUNTAIN','MTN','en_US'),(256,'MOUNTAINS','MTNS','en_US'),(257,'NECK','NCK','en_US'),(258,'ORCHARD','ORCH','en_US'),(259,'OVAL','OVAL','en_US'),(260,'OVERPASS','OPAS','en_US'),(261,'PARK','PARK','en_US'),(262,'PARKS','PARK','en_US'),(263,'PARKWAY','PKWY','en_US'),(264,'PARKWAYS','PKWY','en_US'),(265,'PASS','PASS','en_US'),(266,'PASSAGE','PSGE','en_US'),(267,'PATH','PATH','en_US'),(268,'PIKE','PIKE','en_US'),(269,'PINE','PNE ','en_US'),(270,'PINES','PNES','en_US'),(271,'PLACE','PL','en_US'),(272,'PLAIN','PLN','en_US'),(273,'PLAINS','PLNS','en_US'),(274,'PLAZA','PLZ','en_US'),(275,'POINT','PT','en_US'),(276,'POINTS','PTS','en_US'),(277,'PORT','PRT','en_US'),(278,'PORTS','PRTS','en_US'),(279,'PRAIRIE','PR','en_US'),(280,'RADIAL','RADL','en_US'),(281,'RAMP','RAMP','en_US'),(282,'RANCH','RNCH','en_US'),(283,'RAPID','RPD','en_US'),(284,'RAPIDS','RPDS','en_US'),(285,'REST','RST','en_US'),(286,'RIDGE','RDG','en_US'),(287,'RIDGES','RDGS','en_US'),(288,'RIVER','RIV','en_US'),(289,'ROAD','RD','en_US'),(290,'ROADS','RDS','en_US'),(291,'ROUTE','RTE','en_US'),(292,'ROW','ROW','en_US'),(293,'RUE','RUE','en_US'),(294,'RUN','RUN','en_US'),(295,'SHOAL','SHL','en_US'),(296,'SHOALS','SHLS','en_US'),(297,'SHORE','SHR','en_US'),(298,'SHORES','SHRS','en_US'),(299,'SKYWAY','SKWY','en_US'),(300,'SPRING','SPG','en_US'),(301,'SPRINGS','SPGS','en_US'),(302,'SPUR','SPUR','en_US'),(303,'SPURS','SPUR','en_US'),(304,'SQUARE','SQ','en_US'),(305,'SQUARES','SQS','en_US'),(306,'STATION','STA','en_US'),(307,'STRAVENUE','STRA','en_US'),(308,'STREAM','STRM','en_US'),(309,'STREET','ST','en_US'),(310,'STREETS','STS','en_US'),(311,'SUMMIT','SMT','en_US'),(312,'TERRACE','TER','en_US'),(313,'THROUGHWAY','TRWY','en_US'),(314,'TRACE','TRCE','en_US'),(315,'TRACK','TRAK','en_US'),(316,'TRAFFICWAY','TRFY','en_US'),(317,'TRAIL','TRL','en_US'),(318,'TRAILER','TRLR','en_US'),(319,'TUNNEL','TUNL','en_US'),(320,'TURNPIKE','TPKE','en_US'),(321,'UNDERPASS','UPAS','en_US'),(322,'UNION','UN','en_US'),(323,'UNIONS','UNS','en_US'),(324,'VALLEY','VLY','en_US'),(325,'VALLEYS','VLYS','en_US'),(326,'VIADUCT','VIA','en_US'),(327,'VIEW','VW','en_US'),(328,'VIEWS','VWS','en_US'),(329,'VILLAGE','VLG','en_US'),(330,'VILLAGES','VLGS','en_US'),(331,'VILLE','VL','en_US'),(332,'VISTA','VIS','en_US'),(333,'WALK','WALK','en_US'),(334,'WALKS','WALK','en_US'),(335,'WALL','WALL','en_US'),(336,'WAY','WAY','en_US'),(337,'WAYS','WAYS','en_US'),(338,'WELL','WL','en_US'),(339,'WELLS','WLS','en_US');
/*!40000 ALTER TABLE `tbtypestreet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbvocabulary`
--

DROP TABLE IF EXISTS `tbvocabulary`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tbvocabulary` (
  `idvocabulary` int(11) NOT NULL AUTO_INCREMENT,
  `idlocale` int(11) DEFAULT NULL,
  `idmodule` int(11) DEFAULT NULL,
  `key_name` varchar(50) DEFAULT 'NULL',
  `key_value` varchar(255) DEFAULT NULL,
  `status` char(1) DEFAULT 'A',
  PRIMARY KEY (`idvocabulary`),
  UNIQUE KEY `UK_tbvocabulary_key` (`idlocale`,`key_name`),
  KEY `FK_tbvocabulary_tbmodule_idmodule` (`idmodule`),
  CONSTRAINT `FK_tbvocabulary_tblocale_idlocale` FOREIGN KEY (`idlocale`) REFERENCES `tblocale` (`idlocale`),
  CONSTRAINT `FK_tbvocabulary_tbmodule_idmodule` FOREIGN KEY (`idmodule`) REFERENCES `tbmodule` (`idmodule`)
) ENGINE=InnoDB AUTO_INCREMENT=2176 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbvocabulary`
--

LOCK TABLES `tbvocabulary` WRITE;
/*!40000 ALTER TABLE `tbvocabulary` DISABLE KEYS */;
INSERT INTO `tbvocabulary` VALUES (1,77,2,'adm_Navbar_name','Admin','A'),(2,77,2,'APP_apiUrlLabel','Url da API','A'),(3,77,2,'APP_areaLabel','Ãrea','A'),(4,77,2,'APP_attachLabel','Anexo','A'),(5,77,2,'APP_btnConfirm','Confirmar','A'),(6,77,2,'APP_btnLogin','ENTRE','A'),(7,77,2,'APP_cancelButton','Cancelar','A'),(8,77,2,'APP_changePassButton','Alterar Senha','A'),(9,77,2,'APP_ChangePassword_title','Nova Senha','A'),(10,77,2,'APP_cityLabel','Cidade','A'),(11,77,2,'APP_companyLabel','Empresa','A'),(12,77,2,'APP_configPage','ConfiguraÃ§Ãµes','A'),(13,77,2,'APP_Configuration_title','ConfiguraÃ§Ãµes','A'),(14,77,2,'APP_confirmButton','Confirmar','A'),(15,77,2,'APP_descriptionLabel','DescriÃ§Ã£o','A'),(16,77,2,'APP_exitLink','Sair','A'),(17,77,2,'APP_GetUrl_title','Seja bem-vindo!','A'),(18,77,2,'APP_homePage','InÃ­cio','A'),(19,77,2,'APP_Home_title','Tickets Abertos','A'),(20,77,2,'APP_inChargeLabel','Departamento','A'),(21,77,2,'APP_itemLabel','Item','A'),(22,77,2,'APP_keep','Manter-se conectado','A'),(23,77,2,'APP_Login_title','Login','A'),(24,77,2,'APP_nameLabel','Nome','A'),(25,77,2,'APP_newAttachLabel','Anexo','A'),(26,77,2,'APP_newNoteTitle','Inserir Apontamento','A'),(27,77,2,'APP_newRequestButton','Novo Ticket','A'),(28,77,2,'APP_NewTicket_title','Novo Ticket','A'),(29,77,2,'APP_notesTitle','Apontamentos','A'),(30,77,2,'APP_originLabel','Origem','A'),(31,77,2,'APP_passLabel','Digite sua nova senha','A'),(32,77,2,'APP_passPlaceholder','Senha','A'),(33,77,2,'APP_passRequired','Ã‰ obrigatÃ³rio inserir a senha.','A'),(34,77,2,'APP_phoneLabel','Telefone','A'),(35,77,2,'APP_reasonLabel','RazÃ£o','A'),(36,77,2,'APP_rememberPass','Esqueceu a senha?','A'),(37,77,2,'APP_RememberPassword_title','Esqueceu a Senha','A'),(38,77,2,'APP_requestDate','Prazo Final','A'),(39,77,2,'APP_requireArea','Ã‰ obrigatÃ³rio selecionar uma Ã¡rea.','A'),(40,77,2,'APP_requireDescription','Ã‰ obrigatÃ³rio inserir uma descriÃ§Ã£o.','A'),(41,77,2,'APP_requireEqualPass','As senhas devem ser iguais.','A'),(42,77,2,'APP_requireItem','Ã‰ obrigatÃ³rio selecionar um item.','A'),(43,77,2,'APP_requirePass','Ã‰ obrigatÃ³rio inserir a senha.','A'),(44,77,2,'APP_requireReason','Ã‰ obrigatÃ³rio selecionar uma razÃ£o.','A'),(45,77,2,'APP_requireService','Ã‰ obrigatÃ³rio selecionar um serviÃ§o.','A'),(46,77,2,'APP_requireTitle','Ã‰ obrigatorio inserir um tÃ­tulo.','A'),(47,77,2,'APP_requireType','Ã‰ obrigatÃ³rio selecionar um tipo.','A'),(48,77,2,'APP_requireUser','Ã‰ obrigatÃ³rio inserir o usuÃ¡rio.','A'),(49,77,2,'APP_sendButton','Enviar','A'),(50,77,2,'APP_serviceLabel','ServiÃ§o','A'),(51,77,2,'APP_ShowTicket_title','SolicitaÃ§Ã£o','A'),(52,77,2,'APP_stateLabel','Estado','A'),(53,77,2,'APP_statusLabel','Status','A'),(54,77,2,'APP_titleLabel','TÃ­tulo','A'),(55,77,2,'APP_typeLabel','Tipo','A'),(56,77,2,'APP_urlLabel','Url da API','A'),(57,77,2,'APP_urlPlaceholder','https://...','A'),(58,77,2,'APP_urlRequired','Ã‰ ObrigatÃ³rio inserir a URL.','A'),(59,77,2,'APP_userLabel','Digite seu nome de usuÃ¡rio','A'),(60,77,2,'APP_userPlaceholder','UsuÃ¡rio','A'),(61,77,2,'APP_userRequired','Ã‰ obrigatÃ³rio inserir o usuÃ¡rio.','A'),(62,77,2,'hdk_Navbar_name','HelpDEZK','A'),(63,77,2,'pgr_cost_center','Centro de Custos','A'),(64,77,2,'pgr_dash_widgets','Widgets','A'),(65,77,2,'pgr_downloads','Downloads','A'),(66,77,2,'pgr_email_config','Configura&ccedil;&atilde;o de Emails','A'),(67,77,2,'pgr_email_request','SolicitaÃ§Ãµes por Email','A'),(68,77,2,'pgr_evaluation','Avalia&ccedil;&atilde;o de Atendimento','A'),(69,77,2,'pgr_groups','Grupos','A'),(70,77,2,'pgr_holidays','Feriados','A'),(71,77,2,'pgr_import_people','Importa&ccedil;&atilde;o de Usu&aacute;rios','A'),(72,77,2,'pgr_import_services','Importar Cat&aacute;logo de Servi&ccedil;os','A'),(73,77,2,'pgr_logos','Logos','A'),(74,77,2,'pgr_modules','MÃ³dulos','A'),(75,77,2,'pgr_ope_aver_resptime','Tempo de resposta por atendente','A'),(76,77,2,'pgr_people','Pessoas & Empresas','A'),(77,77,2,'pgr_person_report','Relat&oacute;rio de Pessoas','A'),(78,77,2,'pgr_priority','Prioridade','A'),(79,77,2,'pgr_programs','Programas','A'),(80,77,2,'pgr_rejects_request','Solicita&ccedil;&otilde;es Rejeitadas','A'),(81,77,2,'pgr_request_department','SolicitaÃ§Ãµes por Departamentos','A'),(82,77,2,'pgr_request_operator','Solicita&ccedil;&otilde;es por Atendente','A'),(83,77,2,'pgr_request_status','Solicita&ccedil;&otilde;es por Status','A'),(84,77,2,'pgr_req_reason','Motivo de Abertura','A'),(85,77,2,'pgr_req_reports','Relat&oacute;rio de Solicita&ccedil;&otilde;es','A'),(86,77,2,'pgr_services','Servi&ccedil;os','A'),(87,77,2,'pgr_status','Status','A'),(88,77,2,'pgr_summarized_department','Resumido por Departamento','A'),(89,77,2,'pgr_summarized_operator','Resumido por Atendente','A'),(90,77,2,'pgr_sys_features','Funcionalidades do Sistema','A'),(91,77,2,'pgr_type_permission','Permiss&atilde;o por Tipo de Pessoa','A'),(92,77,2,'pgr_user_satisfaction','Satisfa&ccedil;&atilde;o do Usu&aacute;rio','A'),(93,77,2,'pgr_vocabulary','VocabulÃ¡rio','A'),(94,77,2,'pgr_warnings','Avisos','A'),(95,77,2,'pgr_worked_requests','Solicita&ccedil;&otilde;es Trabalhadas','A'),(96,77,2,'pgr_work_calendar','Calend&aacute;rio de Trabalho','A'),(97,77,2,'Abbreviation','Sigla','A'),(98,77,2,'Abilities','Habilidades','A'),(99,77,2,'Access','Accessar','A'),(100,77,2,'Access_denied','Acesso negado.','A'),(101,77,2,'Acess_level','N&iacute;vel de Acesso','A'),(102,77,2,'Activate','Ativar','A'),(103,77,2,'Add','Adicionar','A'),(104,77,2,'Added_notes','Apontamentos Inclusos','A'),(105,77,2,'address','EndereÃ§o','A'),(106,77,2,'Add_category','Adicionar Categoria','A'),(107,77,2,'Add_item','Adicionar Item','A'),(108,77,2,'add_new_feature','Adicionar Nova Funcionalidade','A'),(109,77,2,'Add_service','Adicionar Servi&ccedil;o','A'),(110,77,2,'Add_widget','Adicionar Widget','A'),(111,77,2,'admin_dashboard','Dashboard Administrativo','A'),(112,77,2,'adodb_version','VersÃ£o do Adodb:','A'),(113,77,2,'Adress','EndereÃ§o','A'),(114,77,2,'Alert_activated','Ativado com sucesso.','A'),(115,77,2,'Alert_activated_error','Falha ao ativar.','A'),(116,77,2,'Alert_add_config_categ_title','NÃ£o esqueÃ§a de acrescentar a entrada da categoria em \'app/lang/[idioma].txt\'','A'),(117,77,2,'Alert_add_feature_title','NÃ£o esqueÃ§a de acrescentar a entrada da funcionalidade em \'app/lang/[idioma].txt\'','A'),(118,77,2,'Alert_add_module_title','NÃ£o esqueÃ§a de acrescentar a entrada do mÃ³dulo em \'app/lang/[idioma].txt\'','A'),(119,77,2,'Alert_add_program_title','NÃ£o esqueÃ§a de acrescentar a entrada do programa em \'app/lang/[idioma].txt\'','A'),(120,77,2,'Alert_approve','VocÃª tem solicitaÃ§Ãµes aguardando aprovaÃ§Ã£o, quer aprova-las agora?','A'),(121,77,2,'Alert_Cancel_sucess','SolicitaÃ§Ã£o cancelada com sucesso','A'),(122,77,2,'Alert_change_password','Senha alterada com sucesso','A'),(123,77,2,'Alert_choose_area','Escolha a Ãrea','A'),(124,77,2,'Alert_choose_item','Escolha o Item','A'),(125,77,2,'Alert_choose_service','Escolha o ServiÃ§o','A'),(126,77,2,'Alert_choose_type','Escolha o Tipo','A'),(127,77,2,'Alert_close_request','SolicitaÃ§Ã£o encerrada com sucesso','A'),(128,77,2,'Alert_deactivated','Desativado com sucesso.','A'),(129,77,2,'Alert_deactivated_error','Falha ao desativar.','A'),(130,77,2,'Alert_deleted','Deletado com sucesso.','A'),(131,77,2,'Alert_deleted_error','Falha ao deletar.','A'),(132,77,2,'Alert_deleted_note','Apontamento excluido','A'),(133,77,2,'Alert_department_person','Este Departamento possui usuÃ¡rios vinculados.<br> Para deletÃ¡-lo, Ã© necessÃ¡rio mover os usuÃ¡rios para um novo departamento.  <br>Selecione o Departamento destino.','A'),(134,77,2,'Alert_different_passwords','Senhas diferentes','A'),(135,77,2,'Alert_dont_delete_area','Esta Ã¡rea estÃ¡ vinculada a uma ou a vÃ¡rias solicitaÃ§Ãµes.<br> NÃ£o Ã© possÃ­vel realizar esta operaÃ§Ã£o.','A'),(136,77,2,'Alert_dont_delete_item','Este item estÃ¡ vinculado a uma ou a vÃ¡rias solicitaÃ§Ãµes.<br> NÃ£o Ã© possÃ­vel realizar esta operaÃ§Ã£o.','A'),(137,77,2,'Alert_dont_delete_service','Este serviÃ§o estÃ¡ vinculado a uma ou a vÃ¡rias solicitaÃ§Ãµes.<br> NÃ£o Ã© possÃ­vel realizar esta operaÃ§Ã£o.','A'),(138,77,2,'Alert_dont_delete_type','Este tipo estÃ¡ vinculado a uma ou a vÃ¡rias solicitaÃ§Ãµes.<br> NÃ£o Ã© possÃ­vel realizar esta operaÃ§Ã£o.','A'),(139,77,2,'Alert_empty_note','Preencha o corpo do apontamento','A'),(140,77,2,'Alert_empty_reason','Preencha o motivo','A'),(141,77,2,'Alert_empty_subject','Preencha o assunto da solicita&ccedil;&atilde;o','A'),(142,77,2,'Alert_external_settings_OK','ConfiguraÃ§Ãµes Externas Salvas com Sucesso !!!','A'),(143,77,2,'Alert_failure','NÃ£o foi possivel inserir','A'),(144,77,2,'Alert_field_required','Este campo Ã© obrigatÃ³rio','A'),(145,77,2,'Alert_follow_repass','Escolha uma das opÃ§Ãµes sobre o acompanhamento.','A'),(146,77,2,'Alert_get_data','NÃ£o foi possÃ­vel obter os dados','A'),(147,77,2,'Alert_import_services_nofile_failure','NÃ£o foi possÃ­vel importar !! Anexe o arquivo .','A'),(148,77,2,'Alert_inserted','Inserido com sucesso','A'),(149,77,2,'Alert_invalid_email','Formato de E-mail invÃ¡lido','A'),(150,77,2,'Alert_note_sucess','Apontamento inserido com sucesso','A'),(151,77,2,'Alert_not_match_new_pass','A nova senha nÃ£o pode ser igual Ã  senha atual!','A'),(152,77,2,'Alert_reopen_sucess','SolicitaÃ§Ã£o Reaberta com sucesso','A'),(153,77,2,'Alert_select_one','Por favor, selecione 1 item','A'),(154,77,2,'Alert_success_update','Dados atualizados com sucesso','A'),(155,77,2,'Alert_sucess_category','Categoria cadastrada com sucesso','A'),(156,77,2,'Alert_sucess_module','MÃ³dulo cadastrado com sucesso','A'),(157,77,2,'Alert_sucess_repass','Repassada com sucesso!','A'),(158,77,2,'Alert_wrong_extension_csv','ExtensÃ£o de arquivo invÃ¡lido. Ã‰ permitido apenas arquivos com extensÃ£o CSV.','A'),(159,77,2,'all','Todos','A'),(160,77,2,'and','e','A'),(161,77,2,'Approve_no','NÃ£o.','A'),(162,77,2,'Approve_obs','Sim, com observaÃ§Ãµes.','A'),(163,77,2,'Approve_text','VocÃª aprova o atendimento do atendente?','A'),(164,77,2,'Approve_yes','Sim.','A'),(165,77,2,'April','Abril','A'),(166,77,2,'Area','&Aacute;rea','A'),(167,77,2,'Area_edit','Editar &Aacute;rea','A'),(168,77,2,'Area_insert','Cadastrar &Aacute;rea','A'),(169,77,2,'Area_name','Nome da &Aacute;rea','A'),(170,77,2,'Assumed_successfully','Assumida com sucesso!','A'),(171,77,2,'Assume_request','Assumir Solicita&ccedil;&atilde;o','A'),(172,77,2,'Attach','Anexar','A'),(173,77,2,'Attachments','Anexos','A'),(174,77,2,'Attendance','Atendimento','A'),(175,77,2,'Attendance_time','Tempo para Atendimento','A'),(176,77,2,'Attendants_by_group','Visualizar atendentes por grupo','A'),(177,77,2,'Attend_level','N&iacute;vel de Atendimento','A'),(178,77,2,'Attend_time','Tempo de Atendimento','A'),(179,77,2,'Att_way','Fornecedor','A'),(180,77,2,'Att_way_min','Fornecedor','A'),(181,77,2,'Att_way_new','Novo Tipo de Atendimento','A'),(182,77,2,'August','Agosto','A'),(183,77,2,'auxiliary_operator_include','Incluir Atendente Auxiliar','A'),(184,77,2,'Available','Dispon&iacute;vel','A'),(185,77,2,'Available_for','Dispon&iacute;vel para','A'),(186,77,2,'Available_text','D&iacute;sponivel para cadastro na solicita&ccedil;&atilde;o.','A'),(187,77,2,'Average','Moderada','A'),(188,77,2,'Back_btn','Voltar','A'),(189,77,2,'Bar_hide','Esconder Barra','A'),(190,77,2,'Bar_show','Mostrar Barra','A'),(191,77,2,'Birth_date','Nascimento','A'),(192,77,2,'Branch','Ramal','A'),(193,77,2,'btn_assume','Assumir','A'),(194,77,2,'btn_cancel','Cancela','A'),(195,77,2,'btn_close','Encerrar','A'),(196,77,2,'Btn_evaluate','Avaliar','A'),(197,77,2,'btn_ope_aux','Atendente Auxiliar','A'),(198,77,2,'btn_reject','Rejeitar','A'),(199,77,2,'btn_reopen','Reabrir','A'),(200,77,2,'btn_save_changes','Salvar Altera&ccedil;&otilde;es','A'),(201,77,2,'btn_submit','Enviar','A'),(202,77,2,'btn_update_userdata','Atualize seus dados','A'),(203,77,2,'By_company','por empresa','A'),(204,77,2,'By_group','por grupo','A'),(205,77,2,'Cancel_btn','Cancelar','A'),(206,77,2,'Categories','Categorias','A'),(207,77,2,'Category','Categoria','A'),(208,77,2,'Category_insert','Inserir Categoria','A'),(209,77,2,'cat_config','Config','A'),(210,77,2,'cat_records','Cadastros','A'),(211,77,2,'cat_reports','Relat&oacute;rios','A'),(212,77,2,'Change','Alterar','A'),(213,77,2,'Change_date','Alterar Data','A'),(214,77,2,'Change_password','Alterar Senha','A'),(215,77,2,'Change_password_required','Obrigar usuÃ¡rio alterar senha.','A'),(216,77,2,'Change_permissions','Alterar Permiss&otilde;es','A'),(217,77,2,'Choose_format','Escolha o formato que vocÃª deseja exportar o relatÃ³rio.','A'),(218,77,2,'City','Cidade','A'),(219,77,2,'Classification','Classifica&ccedil;&atilde;o','A'),(220,77,2,'Classification_text','Configurar este item como \'sem classifica&ccedil;&atilde;o\'.','A'),(221,77,2,'Client','Cliente','A'),(222,77,2,'Close','Fechar','A'),(223,77,2,'Closed','Encerrados','A'),(224,77,2,'Code','C&oacute;digo','A'),(225,77,2,'Color','Cor','A'),(226,77,2,'Company','Empresa','A'),(227,77,2,'Complement','Complemento','A'),(228,77,2,'Confirm_close','Encerrar solicitaÃ§Ã£o?','A'),(229,77,2,'Confirm_password','Repita a Senha','A'),(230,77,2,'conf_approvals','Configurar AprovaÃ§Ãµes','A'),(231,77,2,'Contact_person','Pessoa para contato','A'),(232,77,2,'Controller','Controller','A'),(233,77,2,'copy','Copiar','A'),(234,77,2,'Country','Pa&iacute;s','A'),(235,77,2,'country_default','PaÃ­s PadrÃ£o','A'),(236,77,2,'cpf','CPF','A'),(237,77,2,'Create_user','Criar usu&aacute;rio','A'),(238,77,2,'Create_user_msg','Criar novo usuÃ¡rio, caso nÃ£o exista no Helpdezk.','A'),(239,77,2,'Current_date','Data Atual','A'),(240,77,2,'Current_time','Hora Atual','A'),(241,77,2,'Dashboard','Dashboard','A'),(242,77,2,'Dashboard_SLAFulfillment','Cumprido','A'),(243,77,2,'Dashboard_SLANotFulfillment','N&atilde;o cumprido','A'),(244,77,2,'Dashboard_UpdatedDaily','Atualizado diariamente','A'),(245,77,2,'Date','Data','A'),(246,77,2,'Day','dia','A'),(247,77,2,'Days','Dias','A'),(248,77,2,'Deactivate','Desativar','A'),(249,77,2,'December','Dezembro','A'),(250,77,2,'Default','Padr&atilde;o','A'),(251,77,2,'Default_department','Depart. padrÃ£o','A'),(252,77,2,'Default_department_msg','vocÃª pode adicionar mais departamentos no programa Inserir Departamento','A'),(253,77,2,'Default_text','Ao abrir uma nova solicita&ccedil;&atilde;o usar este Item como padr&atilde;o.','A'),(254,77,2,'Delete','Deletar','A'),(255,77,2,'Delete_emails','Deletar emails','A'),(256,77,2,'Delete_emails_msg','Deletar emails quando baixar do servidor.','A'),(257,77,2,'Delete_module','Tem certeza de que deseja excluir este mÃ³dulo?','A'),(258,77,2,'Delete_record','Tem certeza de que deseja excluir este cadastro?','A'),(259,77,2,'Delete_widget','Tem certeza de que deseja excluir este widget?','A'),(260,77,2,'Delimiter','Separador','A'),(261,77,2,'Department','Departamento','A'),(262,77,2,'Departments','Departamentos','A'),(263,77,2,'Department_exists','Departamento j&aacute; cadastrado!','A'),(264,77,2,'Department_name','Nome do Departamento','A'),(265,77,2,'Description','Descri&ccedil;&atilde;o','A'),(266,77,2,'Domain','Dom&iacute;nio','A'),(267,77,2,'Downloads','Downloads','A'),(268,77,2,'Drag_image_msg','Arraste<br> o arquivo<br> com a imagem<br> ou<br> clique aqui.','A'),(269,77,2,'Drag_import_file_msg','<br>Arraste o arquivo com os dados <br> ou <br> clique aqui.','A'),(270,77,2,'Drag_widget','Arraste seus widgets aqui','A'),(271,77,2,'dropzone_File_Too_Big','Excedeu o tamanho mÃ¡ximo {{filesize}}','A'),(272,77,2,'dropzone_invalid_dimension','A imagem tem que ser quadrada','A'),(273,77,2,'dropzone_remove_file','Remover arquivo','A'),(274,77,2,'dropzone_user_photot_message','<br>Para atualizar sua foto, <br> arraste o arquivo com a imagem<br> ou<br> clique aqui.<br><br>A imagem tem que ser quadrada !!!','A'),(275,77,2,'dsh_installer_dir','DiretÃ³rio installer','A'),(276,77,2,'dsh_msg_installer','Por questÃµes de seguranÃ§a, por favor, remova o diretÃ³rio  <b>installer/</b> do seu servidor!!!','A'),(277,77,2,'dsh_warning','Alerta','A'),(278,77,2,'edit','Editar','A'),(279,77,2,'Editor_Placeholder_description','Insira aqui a descriÃ§Ã£o da solicitaÃ§Ã£o ...','A'),(280,77,2,'Editor_Placeholder_insert','Insira aqui seu apontamento ...','A'),(281,77,2,'Editor_Placeholder_reason','Insira aqui o motivo...','A'),(282,77,2,'Editor_Placeholder_solution','Insira aqui a soluÃ§Ã£o da solicitaÃ§Ã£o...','A'),(283,77,2,'Edit_btn','Editar','A'),(284,77,2,'Edit_failure','N&atilde;o foi poss&iacute;vel editar','A'),(285,77,2,'Edit_layout','Editar Layout','A'),(286,77,2,'Edit_sucess','Editado com sucesso!','A'),(287,77,2,'EIN_CNPJ','CNPJ','A'),(288,77,2,'email','E-mail','A'),(289,77,2,'Email_byCron','Envia os e-mails das solicitaÃ§Ãµes pela cron','A'),(290,77,2,'Email_config','Configurar Email','A'),(291,77,2,'Email_host','Host de email','A'),(292,77,2,'Email_sender','Remetente do email','A'),(293,77,2,'Empty','Sem Itens','A'),(294,77,2,'Environment_settings','ConfiguraÃ§Ãµes do Ambiente','A'),(295,77,2,'Equipment','Equipamento','A'),(296,77,2,'ERP_Code','CÃ³digo','A'),(297,77,2,'ERP_Log','Log','A'),(298,77,2,'Error','Erro!','A'),(299,77,2,'Error_insert_note','Erro ao inserir apontamento','A'),(300,77,2,'Error_Number_columns','N&uacute;mero de colunas na linha % do arquivo inv&aacute;lida. Importa&ccedil;&atilde;o cancelada !!!','A'),(301,77,2,'Execution_date','Data de Execu&ccedil;&atilde;o','A'),(302,77,2,'Expire_date','Prazo para Atendimento','A'),(303,77,2,'Expire_date_sucess','Prazo alterado com sucesso','A'),(304,77,2,'Export','Exportar','A'),(305,77,2,'external_hostname','Nome do host externo:','A'),(306,77,2,'external_ip','EndereÃ§o Ip Externo:','A'),(307,77,2,'Extra','Extra','A'),(308,77,2,'Failure_logs','Logs de erro','A'),(309,77,2,'Feature_remove','Remover funcionalidade','A'),(310,77,2,'February','Fevereiro','A'),(311,77,2,'Female','Feminino','A'),(312,77,2,'File','Arquivo','A'),(313,77,2,'File_CSV','Arquivo CSV.','A'),(314,77,2,'File_PDF','Arquivo PDF.','A'),(315,77,2,'File_XLS','Arquivo XLS.','A'),(316,77,2,'Fill','Preencher','A'),(317,77,2,'Fill_adress','Endere&ccedil;o?','A'),(318,77,2,'Filter_by_sender','Filtro por Remetente','A'),(319,77,2,'Filter_by_subject','Filtro por Assunto','A'),(320,77,2,'Finished_alt','Encerrou','A'),(321,77,2,'Finish_btn','Encerrar','A'),(322,77,2,'Finish_date','Data Final','A'),(323,77,2,'Footer','Rodap&eacute;','A'),(324,77,2,'Friday','Sexta-Feira','A'),(325,77,2,'From','De','A'),(326,77,2,'Gender','Sexo','A'),(327,77,2,'Generated','Gerado','A'),(328,77,2,'grd_expired','Vencidas','A'),(329,77,2,'grd_expired_n_assumed','Vencidas n&atilde;o assumidas','A'),(330,77,2,'grd_expiring','Vencendo','A'),(331,77,2,'grd_expiring_today','Vencendo Hoje','A'),(332,77,2,'grd_show_all','Mostrar todas','A'),(333,77,2,'grd_show_group','Mostrar as do meu grupo','A'),(334,77,2,'grd_show_only_mine','Mostrar as minhas','A'),(335,77,2,'Grid_all','Todas','A'),(336,77,2,'Grid_all_tickets','Todas as solicitaÃ§Ãµes','A'),(337,77,2,'Grid_being_attended','Em atendimento','A'),(338,77,2,'Grid_being_attended_tickets','SolicitaÃ§Ãµes em atendimento','A'),(339,77,2,'Grid_expire_date','Prazo Final','A'),(340,77,2,'Grid_finished','Encerradas','A'),(341,77,2,'Grid_finished_tickets','SolicitaÃ§Ãµes Atendidas e Encerradas','A'),(342,77,2,'Grid_incharge','Respons&aacute;vel','A'),(343,77,2,'Grid_new','Novas','A'),(344,77,2,'Grid_new_tickets','SolicitaÃ§Ãµes novas','A'),(345,77,2,'Grid_opening_date','Data de Abertura','A'),(346,77,2,'Grid_rejected','Rejeitadas','A'),(347,77,2,'Grid_rejected_tickets','SolicitaÃ§Ãµes Rejeitadas','A'),(348,77,2,'Grid_reload','Recarregar','A'),(349,77,2,'Grid_status','Status','A'),(350,77,2,'Grid_subject','Assunto','A'),(351,77,2,'Grid_view','Ver','A'),(352,77,2,'Grid_waiting_approve_msg','Existem solicitaÃ§Ãµes aguardando sua aprovaÃ§Ã£o. <br/> VocÃª nÃ£o poderÃ¡ abrir novos chamados antes de aprovÃ¡-las.','A'),(353,77,2,'Grid_waiting_my_approval','Aguardando minha aprova&ccedil;&atilde;o','A'),(354,77,2,'Grid_waiting_my_approval_tickets','SolicitaÃ§Ãµes aguardando aprova&ccedil;&atilde;o','A'),(355,77,2,'Group','Grupo','A'),(356,77,2,'Groups','Grupos','A'),(357,77,2,'Groups_by_service','Visualizar grupos por servi&ccedil;o','A'),(358,77,2,'Group_name','Nome do Grupo','A'),(359,77,2,'Group_operators','Atendentes do Grupo','A'),(360,77,2,'Group_still_viewing','Desejo que meu grupo continue visualizando a solicita&ccedil;&atilde;o','A'),(361,77,2,'hdk_exceed_max_file_size','Este arquivo nÃ£o serÃ¡ processado. Excede o tamanho mÃ¡ximo de upload: {{maxFilesize}}MB','A'),(362,77,2,'hdk_remove_file','Remover Arquivo','A'),(363,77,2,'Header','Cabe&ccedil;alho','A'),(364,77,2,'helpdezk_path','Caminho do Helpdezk:','A'),(365,77,2,'helpdezk_version','VersÃ£o do Helpdezk:','A'),(366,77,2,'Holiday','Feriado','A'),(367,77,2,'Holidays','Feriados','A'),(368,77,2,'Holiday_des','Nome do Feriado','A'),(369,77,2,'Holiday_import','Importar Feriados','A'),(370,77,2,'Home','In&iacute;cio','A'),(371,77,2,'Hour','Hora','A'),(372,77,2,'Hours','Horas','A'),(373,77,2,'Import','Importar','A'),(374,77,2,'Important_notices','Avisos Importantes','A'),(375,77,2,'Import_error_file','NÃ£o foi possÃ­vel gravar o arquivo para importaÃ§Ã£o.','A'),(376,77,2,'Import_failure','N&aatilde;o foi poss&iacute;vel importar.','A'),(377,77,2,'Import_layout_error','Erro no layout do arquivo de importaÃ§Ã£o - nÃºmero de colunas errado.','A'),(378,77,2,'Import_not_writable','NÃ£o tem permissÃ£o para salvar o arquivo de importaÃ§Ã£o','A'),(379,77,2,'Import_successfull','Importado com sucesso','A'),(380,77,2,'Import_to','Importar para','A'),(381,77,2,'Info_header_logo','O logo do topo dever&aacute; ter 35px de altura, imagens maiores ser&atilde;o redimencionadas.','A'),(382,77,2,'Info_login_logo','O logo da pÃ¡gina de login deve ter 70px de altura, imagens maiores ser&atilde;o redimencionadas.','A'),(383,77,2,'Info_reports_logo','O logo de relat&oacute;rios deve ter 40px de altura, imagens maiores ser&atilde;o redimencionadas.','A'),(384,77,2,'Initial_date','Data Inicial','A'),(385,77,2,'Insert_note','Inserir Apontamento','A'),(386,77,2,'Integration_ldap','IntegraÃ§Ã£o com LDAP/AD','A'),(387,77,2,'Item','Item','A'),(388,77,2,'Item_edit','Editar Item','A'),(389,77,2,'Item_insert','Cadastrar Item','A'),(390,77,2,'Item_name','Nome do Item','A'),(391,77,2,'itens','itens','A'),(392,77,2,'January','Janeiro','A'),(393,77,2,'jquery_version','VersÃ£o do Jquery:','A'),(394,77,2,'July','Julho','A'),(395,77,2,'June','Junho','A'),(396,77,2,'juridical','Jur&iacute;dica','A'),(397,77,2,'key_no_accents_no_whitespace','Key name nÃ£o pode conter acentos ou espaÃ§os em branco','A'),(398,77,2,'lbl_auxiliary_operator','Atendente(s) Auxiliar(es)','A'),(399,77,2,'Lbl_photo','Foto','A'),(400,77,2,'lbl_session_name','Nome VariÃ¡vel de SessÃ£o','A'),(401,77,2,'lbl_value','Valor','A'),(402,77,2,'ldap_dn','Distinguished Names','A'),(403,77,2,'ldap_domain','Dom&iacute;nio','A'),(404,77,2,'ldap_field','Objeto AD/LDAP','A'),(405,77,2,'ldap_field_obs','Campo onde &eacute; armazenado o usu&aacute;rio.','A'),(406,77,2,'ldap_server','Servidor','A'),(407,77,2,'List_comp_groups','Lista de empresas e seus grupos:','A'),(408,77,2,'Loading','Carregando...','A'),(409,77,2,'Location','Localiza&ccedil;&atilde;o','A'),(410,77,2,'Location_insert','Cadastrar Localiza&ccedil;&atilde;o','A'),(411,77,2,'Lock_text','VocÃª estÃ¡ em tela de bloqueio. O aplicativo principal foi desligado e vocÃª precisa acessar a tela de login para voltar ao aplicativo.','A'),(412,77,2,'Lock_unlock','Desbloquear','A'),(413,77,2,'Login','Login','A'),(414,77,2,'Login_cant_create_user','Cant create User !!!!','A'),(415,77,2,'Login_error_error','Senha incorreta, digite novamente.','A'),(416,77,2,'Login_error_secret','Token incorreto, tente novamente !!!','A'),(417,77,2,'Login_exists','Login j&aacute; cadastrado!','A'),(418,77,2,'Login_layout','Layout de Login','A'),(419,77,2,'Login_page_logo','Logo da p&aacute;gina de Login','A'),(420,77,2,'Login_type','Tipo de Login','A'),(421,77,2,'Login_user_inactive','UsuÃ¡rio inativo, entre em contato com o administrador.','A'),(422,77,2,'Login_user_not_exist','Usu&aacute;rio n&atilde;o existe, verifique a digita&ccedil;&atilde;o!','A'),(423,77,2,'Logos_Title','Logos','A'),(424,77,2,'logout','Sair','A'),(425,77,2,'log_email','Logs de E-mail','A'),(426,77,2,'log_general','Logs Gerais','A'),(427,77,2,'log_host','Tipo de Host','A'),(428,77,2,'log_level','Nivel de Log','A'),(429,77,2,'log_remote_server','Servidor Remoto','A'),(430,77,2,'Lost_password','Esqueci minha senha','A'),(431,77,2,'Lost_password_ad','N&atilde;o Ã© poss&iacute;vel recuperar senha no Active Directory, contate o administrador do sistema.','A'),(432,77,2,'Lost_password_body','<br><br><br><p>Informamos que sua nova senha de acesso Ã©: <b>$pass</b> <br>Esta &eacute; uma mensagem autom&aacute;tica, por favor, n&atilde;o responda.</p><br><br><br><br>','A'),(433,77,2,'Lost_password_err','Falha ao enviar nova senha.','A'),(434,77,2,'Lost_password_log','Enviado e-mail com nova senha - ','A'),(435,77,2,'Lost_password_master','Senha do usuario master nÃ£o pode ser trocada','A'),(436,77,2,'Lost_password_not','Usu&aacute;rio inexistente ','A'),(437,77,2,'Lost_password_pop','N&atilde;o Ã© poss&iacute;vel recuperar senha com autentica&ccedil;&atilde;o POP, contate o administrador do sistema.','A'),(438,77,2,'Lost_password_subject','Lembrete de Senha','A'),(439,77,2,'Lost_password_suc','Nova senha enviada com sucesso.','A'),(440,77,2,'Maintenance','ManutenÃ§Ã£o','A'),(441,77,2,'Male','Masculino','A'),(442,77,2,'Manage_fail_import_file','Falha ao importar o arquivo csv com os dados.','A'),(443,77,2,'Manage_fail_move_file','Falha ao mover o arquivo de dados.\\nVerifique as permissÃµes no diretÃ³rio de anexos e tente novamente','A'),(444,77,2,'Manage_fail_open_file_in','Falha ao abrir o arquivo de dados em ','A'),(445,77,2,'Manage_fail_open_file_per','\\nVerifique as permissÃµes e tente novamente.','A'),(446,77,2,'Manage_instructions','FaÃ§a download das instru&ccedil;&otilde;es para importa&ccedil;&atilde;o: ','A'),(447,77,2,'Manage_layout_service','Layout de Importa&ccedil;&atilde;o de Servi&ccedil;o','A'),(448,77,2,'Manage_layout_service_file','Layout-Importacao-Servicos.pdf','A'),(449,77,2,'Manage_service_already_registered','jÃ¡ estÃ¡ cadastrado.','A'),(450,77,2,'Manage_service_and_group','e o grupo ','A'),(451,77,2,'Manage_service_area','Cadastrada nova Ã¡rea -> CÃ³digo: ','A'),(452,77,2,'Manage_service_area_fail','Falha ao cadastrar a Ã¡rea de atendimento ','A'),(453,77,2,'Manage_service_column_6','A coluna 6 deve conter apenas valor numÃ©rico. Foi informado o valor ','A'),(454,77,2,'Manage_service_company_fail','Na coluna 8 Ã© obrigatÃ³rio um nome de empresa vÃ¡lido. A empresa % nÃ£o estÃ¡ cadastrada !','A'),(455,77,2,'Manage_service_completed','Processo finalizado com sucesso','A'),(456,77,2,'Manage_service_default_pri','foi relacionado com prioridade padrÃ£o, pois a prioridade informada ','A'),(457,77,2,'Manage_service_fail','Falha ao cadastrar o serviÃ§o ','A'),(458,77,2,'Manage_service_fail_code','Falha ao determinar o cÃ³digo do serviÃ§o ','A'),(459,77,2,'Manage_service_fail_rel','Falha ao cadastrar a relaÃ§Ã£o entre o serviÃ§o ','A'),(460,77,2,'Manage_service_finalized_line','Finalizada a linha ','A'),(461,77,2,'Manage_service_group_fail','Falha ao cadastrar o grupo na tabela pessoa: ','A'),(462,77,2,'Manage_service_group_fail2','Falha ao cadastrar o grupo de atendimento','A'),(463,77,2,'Manage_service_group_register','! Cadastrado novo grupo de atendimento -> C?digo:','A'),(464,77,2,'Manage_service_group_using','* Utilizando grupo existente -> Codigo ','A'),(465,77,2,'Manage_service_imp_canceled','. ImportaÃ§Ã£o cancelada!','A'),(466,77,2,'Manage_service_inf_line','informada na linha ','A'),(467,77,2,'Manage_service_inf_on_line','informado na linha ','A'),(468,77,2,'Manage_service_in_service','no serviÃ§o ','A'),(469,77,2,'Manage_service_item','Cadastrado novo item -> ','A'),(470,77,2,'Manage_service_item_fail','Falha ao cadastrar o item de atendimento ','A'),(471,77,2,'Manage_service_line','linha ','A'),(472,77,2,'Manage_service_not_identify_priority','NÃ£o foi possivel identificar tempo de atendimento da prioridade na linha ','A'),(473,77,2,'Manage_service_not_registered','NÃ£o estÃ¡ cadastrado ou nÃ£o Ã© atendente. Linha ','A'),(474,77,2,'Manage_service_on_line',', na linha ','A'),(475,77,2,'Manage_service_pri_no_exist','nÃ£o existe no sistema.','A'),(476,77,2,'Manage_service_register_service','Cadastrado novo serviÃ§o ','A'),(477,77,2,'Manage_service_type','Cadastrado novo TIPO -> CÃ³digo: ','A'),(478,77,2,'Manage_service_type_fail','Falha ao cadastrar o tipo de atendimento ','A'),(479,77,2,'Manage_service_using_area','Utilizando Ã¡rea existente -> CÃ³digo: ','A'),(480,77,2,'Manage_service_using_item','Utilizando item existente -> CÃ³digo: ','A'),(481,77,2,'Manage_service_using_type','Utilizando tipo existente -> CÃ³digo: ','A'),(482,77,2,'Mange_service_order',', ordem','A'),(483,77,2,'March','Mar&ccedil;o','A'),(484,77,2,'May','Maio','A'),(485,77,2,'Messages','Mensagens','A'),(486,77,2,'Message_title','VocÃª tem $$ novas mensagens.','A'),(487,77,2,'Minutes','Minutos','A'),(488,77,2,'Mobile_phone','Celular','A'),(489,77,2,'Module','M&oacute;dulo','A'),(490,77,2,'Modules','M&oacute;dulos','A'),(491,77,2,'Module_default','M&oacute;dulo Padr&atilde;o','A'),(492,77,2,'Module_insert','Cadastrar M&oacute;dulo','A'),(493,77,2,'Module_name','Nome do M&oacute;dulo','A'),(494,77,2,'module_not_delete','Este mÃ³dulo nÃ£o pode ser excluÃ­do','A'),(495,77,2,'module_not_disable','Este mÃ³dulo nÃ£o pode ser desativado','A'),(496,77,2,'module_not_edit','Este mÃ³dulo nÃ£o pode ser editado','A'),(497,77,2,'Module_path','Caminho do M&oacute;dulo','A'),(498,77,2,'Monday','Segunda-Feira','A'),(499,77,2,'Month','M&ecirc;s','A'),(500,77,2,'mother','Nome da MÃ£e','A'),(501,77,2,'Msg_change_operation','Aten&ccedil;&atilde;o, ao editar os tipos de opera&ccedil;&atilde;o &eacute; necess&aacute;rio setar novamente as permiss&otilde;es do programa \'Permiss&atilde;o por Tipo de Pessoa\'.','A'),(502,77,2,'mysql_version','VersÃ£o do mysql:','A'),(503,77,2,'My_Tickets','Minhas SolicitaÃ§Ãµes','A'),(504,77,2,'Name','Nome','A'),(505,77,2,'National_holiday','Feriado Nacional','A'),(506,77,2,'natural','F&iacute;sica','A'),(507,77,2,'Neighborhood','Bairro','A'),(508,77,2,'New','Novo','A'),(509,77,2,'New_category','Nova Categoria','A'),(510,77,2,'New_date','Nova Data','A'),(511,77,2,'new_feature','Nova Funcionalidade','A'),(512,77,2,'New_messages','Novas mensagens','A'),(513,77,2,'New_password','Nova Senha','A'),(514,77,2,'New_request','Nova Solicita&ccedil;&atilde;o','A'),(515,77,2,'New_time','Nova Hora','A'),(516,77,2,'No','N&atilde;o','A'),(517,77,2,'Normal','Normal','A'),(518,77,2,'Note','Apontamento','A'),(519,77,2,'Note_msg','Inserir apontamentos ao responder emails.','A'),(520,77,2,'Notification','Notifica&ccedil;&atilde;o','A'),(521,77,2,'Not_available_yet','Ainda n&atilde;o dipon&iacute;vel','A'),(522,77,2,'November','Novembro','A'),(523,77,2,'No_abilities','N&atilde;o h&aacute; habilidades relacionadas','A'),(524,77,2,'No_data','Sem dados.','A'),(525,77,2,'No_notices','Nenhum aviso importante no momento.','A'),(526,77,2,'no_permission_edit','VocÃª nÃ£o possui permissÃ£o para ediÃ§Ã£o','A'),(527,77,2,'No_result','Nenhum registro encontrado.','A'),(528,77,2,'Number','N&uacute;mero','A'),(529,77,2,'Obrigatory_time','Preenchimento de tempo gasto com a tarefa obrigatÃ³rio','A'),(530,77,2,'Observation','Observa&ccedil;&atilde;o','A'),(531,77,2,'October','Outubro','A'),(532,77,2,'of','de','A'),(533,77,2,'Ok_btn','Ok','A'),(534,77,2,'Only_operator','Somente atendente','A'),(535,77,2,'on_time','No prazo','A'),(536,77,2,'Opened_by','Aberta por','A'),(537,77,2,'Opening_date','Data de Abertura','A'),(538,77,2,'Operation','Opera&ccedil;&atilde;o','A'),(539,77,2,'Operations','Opera&ccedil;&otilde;es','A'),(540,77,2,'Operator','Atendente','A'),(541,77,2,'Operator_groups','Grupos do Atendente','A'),(542,77,2,'Option_only_attendant_active','OpÃ§Ã£o somente para atendentes ativos','A'),(543,77,2,'Option_only_operator','OpÃ§Ã£o somente para atendentes','A'),(544,77,2,'Other_items','Outros Itens','A'),(545,77,2,'overdue','Atrasado','A'),(546,77,2,'Overtime','Hora Extra','A'),(547,77,2,'Page','P&aacute;ginas','A'),(548,77,2,'Page_header_logo','Logo do cabe&ccedil;alho','A'),(549,77,2,'Password','Senha','A'),(550,77,2,'PDF_code','CÃ³digo','A'),(551,77,2,'PDF_Page','PÃ¡gina','A'),(552,77,2,'PDF_person_report','RelatÃ³rio de Pessoa','A'),(553,77,2,'people','Pessoas & Empresas','A'),(554,77,2,'Permissions','Permiss&otilde;es','A'),(555,77,2,'Permission_error','Erro durante a opera&ccedil;&atilde;o','A'),(556,77,2,'Permission_Groups','PermissÃ£o','A'),(557,77,2,'Permission_Groups_Select','Selecione o Grupo de PermissÃ£o','A'),(558,77,2,'pgr_departments','Departamentos','A'),(559,77,2,'pgr_erp_emailtemplate','E-mail Templates','A'),(560,77,2,'Phone','Telefone','A'),(561,77,2,'php_version','VersÃ£o do php:','A'),(562,77,2,'Placeholder_subject','Insira o assunto','A'),(563,77,2,'Placeholder_zipcode','Insira o Cep','A'),(564,77,2,'plh_category_description','Informe o nome da Categoria','A'),(565,77,2,'plh_controller_description','Informe o Controller do Programa','A'),(566,77,2,'plh_holiday_date','Informe a data do Feriado','A'),(567,77,2,'plh_holiday_description','Informe a descriÃ§Ã£o do Feriado','A'),(568,77,2,'plh_module_description','Informe o nome do MÃ³dulo','A'),(569,77,2,'plh_module_path','Informe o caminho do MÃ³dulo','A'),(570,77,2,'plh_module_prefix','Informe o prefixo de tabela','A'),(571,77,2,'plh_program_description','Informe o nome do Programa','A'),(572,77,2,'plh_smarty_variable','Informe a vari&aacute;vel smarty','A'),(573,77,2,'Pop_server','Servidor POP','A'),(574,77,2,'Port','Porta','A'),(575,77,2,'Previous_year','Ano Anterior','A'),(576,77,2,'Print','Imprimir','A'),(577,77,2,'Priority','Prioridade','A'),(578,77,2,'Processing','Processando','A'),(579,77,2,'Program','Programa','A'),(580,77,2,'Programs','Programas','A'),(581,77,2,'pushover','ConfiguraÃ§Ãµes Pushover API','A'),(582,77,2,'Reason','Motivo','A'),(583,77,2,'Reason_no_registered','Sem motivo cadastrado','A'),(584,77,2,'Recalculate','Recalcular','A'),(585,77,2,'Recalculate_msg_chk','Recalcular tempo de atendimento apÃ³s o fim das aprovaÃ§Ãµes','A'),(586,77,2,'records','Cadastros','A'),(587,77,2,'Register_btn','Registrar','A'),(588,77,2,'Rejected','Rejeitadas','A'),(589,77,2,'Reject_btn','Rejeitar','A'),(590,77,2,'Reject_sucess','SolicitaÃ§Ã£o Rejeitada','A'),(591,77,2,'Related_abilities','Habilidades Relacionadas','A'),(592,77,2,'reload_request','Recarregar dados ','A'),(593,77,2,'Remove','Remover','A'),(594,77,2,'Repassed','Repassada','A'),(595,77,2,'Repass_btn','Repassar','A'),(596,77,2,'Repass_request_only','Apenas Repassar Chamados','A'),(597,77,2,'Repass_request_to','Repassar solicita&ccedil;&atilde;o para','A'),(598,77,2,'Reports_logo','Logo dos Relat&oacute;rios','A'),(599,77,2,'Request','Solicita&ccedil;&atilde;o','A'),(600,77,2,'Requests','Solicita&ccedil;&otilde;es','A'),(601,77,2,'Request_approve','Existem solicitaÃ§Ãµes aguardando sua aprovaÃ§Ã£o. <br/> VocÃª nÃ£o poderÃ¡ abrir novos chamados antes de aprovÃ¡-las.<br/> Deseja aprova-las agora?','A'),(602,77,2,'Request_approve_app','Aprovar Solicita&ccedil;&atilde;o','A'),(603,77,2,'Request_assumed','Solicita&ccedil;&atilde;o Assumida','A'),(604,77,2,'Request_canceled','Solicita&ccedil;&atilde;o Cancelada','A'),(605,77,2,'Request_closed','Solicita&ccedil;&atilde;o Encerrada','A'),(606,77,2,'Request_code','C&oacute;digo da Solicita&ccedil;&atilde;o','A'),(607,77,2,'Request_not_approve','A solicita&ccedil;&atilde;o n&atilde;o foi aprovada.','A'),(608,77,2,'Request_opened','Solicita&ccedil;&atilde;o Cadastrada','A'),(609,77,2,'Request_owner','Solicitante','A'),(610,77,2,'Request_rejected','Solicita&ccedil;&atilde;o n&atilde;o pode ser atendida: ','A'),(611,77,2,'Request_reopened','Solicita&ccedil;&atilde;o Reaberta','A'),(612,77,2,'Request_repassed','Solicita&ccedil;&atilde;o Repassada ','A'),(613,77,2,'Request_reprove_app','Reprovar Solicita&ccedil;&atilde;o','A'),(614,77,2,'Request_return_app','Retornar &agrave; fase anterior','A'),(615,77,2,'Request_waiting_approval','Aguardando aprovaÃ§Ã£o do usu&aacute;rio','A'),(616,77,2,'Requires_Autentication','Autentica&ccedil;&atilde;o obrigat&oacute;ria','A'),(617,77,2,'rg','RG','A'),(618,77,2,'role','Cargo','A'),(619,77,2,'Saturday','S&eacute;bado','A'),(620,77,2,'Save','Salvar','A'),(621,77,2,'Save_changes_sucess','AlteraÃ§Ãµes salvas','A'),(622,77,2,'Search','Buscar','A'),(623,77,2,'Second','segundo','A'),(624,77,2,'seconds','segundos','A'),(625,77,2,'Select','Selecione','A'),(626,77,2,'Select_acess_level','Selecione N&iacute;vel de Acesso','A'),(627,77,2,'Select_area','Selecione uma &Aacute;rea','A'),(628,77,2,'Select_category','Selecione uma categoria','A'),(629,77,2,'Select_company','Selecione a empresa','A'),(630,77,2,'Select_country','Selecione o Pa&iacute;s','A'),(631,77,2,'Select_department','Selecione o departamento','A'),(632,77,2,'Select_group','Selecione um grupo','A'),(633,77,2,'Select_group_operator','Selecione um grupo ou atendente.','A'),(634,77,2,'Select_location','Selecione a LocalizaÃ§Ã£o','A'),(635,77,2,'Select_module','Selecione o mÃ³dulo','A'),(636,77,2,'Select_priority','Selecione uma Prioridade','A'),(637,77,2,'Select_street','Selecione o EndereÃ§o','A'),(638,77,2,'Send','ENVIAR ','A'),(639,77,2,'Send_alerts_email','Sim, envie este alerta por e-mail.','A'),(640,77,2,'Send_alerts_topic_email','Sim, envie alertas deste tÃ³pico por email.','A'),(641,77,2,'Send_email','Enviar email','A'),(642,77,2,'September','Setembro','A'),(643,77,2,'Serial_number','N&ordm; s&eacute;rie','A'),(644,77,2,'Server','Servidor','A'),(645,77,2,'Service','Servi&ccedil;o','A'),(646,77,2,'Service_edit','Editar Servi&ccedil;o','A'),(647,77,2,'Service_insert','Cadastrar Servi&ccedil;o','A'),(648,77,2,'Service_name','Nome do Servi&ccedil;o','A'),(649,77,2,'Service_order_number','N&ordm; do documento','A'),(650,77,2,'Service_order_number_min','N&ordm; do doc.','A'),(651,77,2,'Settings','ConfiguraÃ§Ãµes','A'),(652,77,2,'Set_repass_groups','Configurar grupos de repasse','A'),(653,77,2,'show','Mostrar','A'),(654,77,2,'Show_attendants_title','Exibir atendentes por grupo','A'),(655,77,2,'Show_groups_services_title','Exibir grupos por servi&ccedil;os','A'),(656,77,2,'Show_in','Mostrar em','A'),(657,77,2,'Smarty','Vari&aacute;vel Smarty','A'),(658,77,2,'smarty_version','VersÃ£o do Smarty: ','A'),(659,77,2,'SMS','SMS','A'),(660,77,2,'Solution','Solu&ccedil;&atilde;o','A'),(661,77,2,'Source','Origem','A'),(662,77,2,'Started','Iniciou','A'),(663,77,2,'State','Estado','A'),(664,77,2,'status','Status','A'),(665,77,2,'Still_viewing','Desejo continuar visualizando a solicita&ccedil;&atilde;o.','A'),(666,77,2,'Stop_viewing','N&atilde;o acompanhar.','A'),(667,77,2,'Subject','Assunto','A'),(668,77,2,'Success_logs','Logs de sucesso','A'),(669,77,2,'summary','Resumo do CurrÃ­culo','A'),(670,77,2,'Sunday','Domingo','A'),(671,77,2,'sys_2FAuthentication','Usar autenticaÃ§Ã£o em duas etapas','A'),(672,77,2,'sys_session_time_lbl','Tempo duraÃ§Ã£o da SessÃ£o do Sistema','A'),(673,77,2,'sys_time_session','Tempo que ir&aacute; durar a sess&atilde;o do sistema. Valor em segundos. Se n&atilde;o definido ser&aacute; de 10 minutos.','A'),(674,77,2,'Table_prefix','Prefixo de Tabela','A'),(675,77,2,'Tag_min','N&ordm; de patrim.','A'),(676,77,2,'Tckt_cancel_request','Confirma cancelamento da solicitaÃ§Ã£o ?','A'),(677,77,2,'Tckt_delete_note','Confirma exclusÃ£o do apontamento ?','A'),(678,77,2,'Tckt_del_note_failure','NÃ£o possÃ­vel excluir o apontamento !','A'),(679,77,2,'Tckt_drop_file','Arraste os arquivos para upload ou clique aqui !','A'),(680,77,2,'Tckt_evaluated_success','SolicitaÃ§Ã£o avaliada com sucesso !','A'),(681,77,2,'Tckt_finish_request','Encerrar','A'),(682,77,2,'Tckt_incharge','Respons&aacute;vel','A'),(683,77,2,'Tckt_opened','SolicitaÃ§Ã£o aberta','A'),(684,77,2,'Tckt_reopen_request','Confirma reabertura da solicitaÃ§Ã£o ?','A'),(685,77,2,'Tckt_Request','Solicita&ccedil;&atilde;o','A'),(686,77,2,'Tck_new_ticket','Nova SolicitaÃ§Ã£o','A'),(687,77,2,'Tck_Open','SolicitaÃ§Ãµes em aberto','A'),(688,77,2,'Tck_title','SolicitaÃ§Ãµes','A'),(689,77,2,'Template_edit','Editar Template','A'),(690,77,2,'Thursday','Quinta-Feira','A'),(691,77,2,'timeouttext','Sua sess&atilde;o vai expirar em','A'),(692,77,2,'Time_expended','Tempo gasto na tarefa','A'),(693,77,2,'Time_return','Tempo liga&ccedil;&atilde;o de retorno (callback)','A'),(694,77,2,'Time_value','Valor da Hora','A'),(695,77,2,'Title','T&iacute;tulo','A'),(696,77,2,'tlt_span_group','Solicita&ccedil;&otilde;es do Grupo','A'),(697,77,2,'tlt_span_my','Minhas Solicita&ccedil;&otilde;es','A'),(698,77,2,'tlt_span_track_group','Acompanhada pelo grupo','A'),(699,77,2,'tlt_span_track_me','Acompanhada por mim','A'),(700,77,2,'to','para','A'),(701,77,2,'tooltip_city','Adicionar nova cidade','A'),(702,77,2,'tooltip_delete_area','Deletar Ã¡rea','A'),(703,77,2,'tooltip_delete_item','Deletar item','A'),(704,77,2,'tooltip_delete_service','Deletar serviÃ§o','A'),(705,77,2,'tooltip_delete_type','Deletar tipo','A'),(706,77,2,'tooltip_list_items','Listar Itens','A'),(707,77,2,'tooltip_list_services','Listar ServiÃ§os','A'),(708,77,2,'tooltip_neighborhood','Adicionar novo bairro','A'),(709,77,2,'tooltip_state','Adicionar novo estado','A'),(710,77,2,'tooltip_street','Adicionar novo endereÃ§o','A'),(711,77,2,'Topic','T&oacute;pico','A'),(712,77,2,'Topic_edit','Editar T&oacute;pico','A'),(713,77,2,'Total','Total','A'),(714,77,2,'Total_holidays','Total de feriados de','A'),(715,77,2,'Total_minutes','Total minutos','A'),(716,77,2,'tracker_status','Rastrear E-mails','A'),(717,77,2,'trello','ConfiguraÃ§Ãµes Trello API','A'),(718,77,2,'trello_boards','Quadros','A'),(719,77,2,'trello_cards','CartÃµes','A'),(720,77,2,'trello_description','DescriÃ§Ã£o do CartÃ£o','A'),(721,77,2,'trello_integration','IntegraÃ§Ã£o com o Trello','A'),(722,77,2,'trello_key','Chave','A'),(723,77,2,'trello_lists','Listas','A'),(724,77,2,'trello_title','TÃ­tulo do CartÃ£o','A'),(725,77,2,'trello_token','Token','A'),(726,77,2,'trello_tooltip_card','Adicionar novo cartÃ£o','A'),(727,77,2,'Tuesday','Ter&ccedil;a-Feira','A'),(728,77,2,'twitter','Twitter','A'),(729,77,2,'Type','Tipo','A'),(730,77,2,'Type_adress','Logradouro','A'),(731,77,2,'Type_edit','Editar Tipo','A'),(732,77,2,'Type_insert','Cadastrar Tipo','A'),(733,77,2,'Type_name','Nome do Tipo','A'),(734,77,2,'type_user_operator','Atendente','A'),(735,77,2,'type_user_user','Usu&aacute;rio','A'),(736,77,2,'until','at&eacute;','A'),(737,77,2,'Until_closed','At&eacute; ser encerrado','A'),(738,77,2,'Update','Atualizar','A'),(739,77,2,'User','Usu&aacute;rio','A'),(740,77,2,'UserData','Dados do usuÃ¡rio','A'),(741,77,2,'user_external_settings','ConfiguraÃ§Ãµes Externas','A'),(742,77,2,'User_login','Login do usu&aacute;rio','A'),(743,77,2,'user_profile','Perfil','A'),(744,77,2,'Valid','V&aacute;lido de','A'),(745,77,2,'Validity_Standard','Validade Padr&atilde;o','A'),(746,77,2,'Valid_until','V&aacute;lido at&eacute;','A'),(747,77,2,'Value_exists','Valor inserido jÃ¡ estÃ¡ cadastrado','A'),(748,77,2,'Var_assume','Data que foi assumida','A'),(749,77,2,'Var_branch','Ramal do usu&aacute;rio','A'),(750,77,2,'Var_date','Data do email','A'),(751,77,2,'Var_description','Descri&ccedil;&atilde;o da solicita&ccedil;&atilde;o','A'),(752,77,2,'Var_evaluation','AvaliaÃ§Ã£o dada pelo usu&aacute;rio!','A'),(753,77,2,'Var_expire','Data de validade','A'),(754,77,2,'Var_finish','Data que foi finalizada','A'),(755,77,2,'Var_incharge','Nome do respons&aacute;vel','A'),(756,77,2,'Var_link_evaluation','Link para avaliaÃ§Ã£o sem login.','A'),(757,77,2,'Var_link_operator','Link para a p&aacute;gina da solicita&ccedil;&atilde;o (atendente)','A'),(758,77,2,'Var_link_user','Link para a p&aacute;gina da solicita&ccedil;&atilde;o (usu&aacute;rio)','A'),(759,77,2,'Var_nt_operator','Apontamentos que somente os atendentes podem ver','A'),(760,77,2,'Var_nt_user','Apontamentos que usu&aacute;rios podem ver','A'),(761,77,2,'Var_phone','Telefone do usu&aacute;rio','A'),(762,77,2,'Var_record','Data de cadastro','A'),(763,77,2,'Var_rejection','Data que foi rejeitada','A'),(764,77,2,'Var_request','Data da solicita&ccedil;&atilde;o','A'),(765,77,2,'Var_requester','Nome do solicitante','A'),(766,77,2,'Var_status','Status da solicita&ccedil;&atilde;o','A'),(767,77,2,'Var_subject','Assunto da solicita&ccedil;&atilde;o','A'),(768,77,2,'Var_user','Usu&aacute;rio logado no sistema','A'),(769,77,2,'Version','Vers&atilde;o','A'),(770,77,2,'View_groups','Visualizar grupos','A'),(771,77,2,'VIP_user','Usu&aacute;rio VIP','A'),(772,77,2,'Visible','Vis&iacute;vel','A'),(773,77,2,'vocabulary_key_exists','Esta key jÃ¡ existe','A'),(774,77,2,'vocabulary_key_name','Key Name','A'),(775,77,2,'vocabulary_key_value','Key Value','A'),(776,77,2,'vocabulary_locale','Locale','A'),(777,77,2,'Waiting_for_approval','Aguardando aprova&ccedil;&atilde;o','A'),(778,77,2,'Warning_new_topic','Novo T&oacute;pico','A'),(779,77,2,'Wednesday','Quarta-Feira','A'),(780,77,2,'Widget','Widget','A'),(781,77,2,'Yes','Sim','A'),(782,77,2,'Zipcode','Cep','A'),(783,19,2,'adm_Navbar_name','Admin','A'),(784,19,2,'APP_apiUrlLabel','Url da API','A'),(785,19,2,'APP_areaLabel','Ãrea','A'),(786,19,2,'APP_attachLabel','Anexo','A'),(787,19,2,'APP_btnConfirm','Confirmar','A'),(788,19,2,'APP_btnLogin','ENTRE','A'),(789,19,2,'APP_cancelButton','Cancelar','A'),(790,19,2,'APP_changePassButton','Alterar Senha','A'),(791,19,2,'APP_ChangePassword_title','Nova Senha','A'),(792,19,2,'APP_cityLabel','Cidade','A'),(793,19,2,'APP_companyLabel','Empresa','A'),(794,19,2,'APP_configPage','ConfiguraÃ§Ãµes','A'),(795,19,2,'APP_Configuration_title','ConfiguraÃ§Ãµes','A'),(796,19,2,'APP_confirmButton','Confirmar','A'),(797,19,2,'APP_descriptionLabel','DescriÃ§Ã£o','A'),(798,19,2,'APP_exitLink','Sair','A'),(799,19,2,'APP_GetUrl_title','Seja bem-vindo!','A'),(800,19,2,'APP_homePage','InÃ­cio','A'),(801,19,2,'APP_Home_title','Tickets Abertos','A'),(802,19,2,'APP_inChargeLabel','Departamento','A'),(803,19,2,'APP_itemLabel','Item','A'),(804,19,2,'APP_keep','Manter-se conectado','A'),(805,19,2,'APP_Login_title','Login','A'),(806,19,2,'APP_nameLabel','Nome','A'),(807,19,2,'APP_newAttachLabel','Anexo','A'),(808,19,2,'APP_newNoteTitle','Inserir Apontamento','A'),(809,19,2,'APP_newRequestButton','Novo Ticket','A'),(810,19,2,'APP_NewTicket_title','Novo Ticket','A'),(811,19,2,'APP_notesTitle','Apontamentos','A'),(812,19,2,'APP_originLabel','Origem','A'),(813,19,2,'APP_passLabel','Digite sua nova senha','A'),(814,19,2,'APP_passPlaceholder','Senha','A'),(815,19,2,'APP_passRequired','Ã‰ obrigatÃ³rio inserir a senha.','A'),(816,19,2,'APP_phoneLabel','Telefone','A'),(817,19,2,'APP_reasonLabel','RazÃ£o','A'),(818,19,2,'APP_rememberPass','Esqueceu a senha?','A'),(819,19,2,'APP_RememberPassword_title','Esqueceu a Senha','A'),(820,19,2,'APP_requestDate','Prazo Final','A'),(821,19,2,'APP_requireArea','Ã‰ obrigatÃ³rio selecionar uma Ã¡rea.','A'),(822,19,2,'APP_requireDescription','Ã‰ obrigatÃ³rio inserir uma descriÃ§Ã£o.','A'),(823,19,2,'APP_requireEqualPass','As senhas devem ser iguais.','A'),(824,19,2,'APP_requireItem','Ã‰ obrigatÃ³rio selecionar um item.','A'),(825,19,2,'APP_requirePass','Ã‰ obrigatÃ³rio inserir a senha.','A'),(826,19,2,'APP_requireReason','Ã‰ obrigatÃ³rio selecionar uma razÃ£o.','A'),(827,19,2,'APP_requireService','Ã‰ obrigatÃ³rio selecionar um serviÃ§o.','A'),(828,19,2,'APP_requireTitle','Ã‰ obrigatorio inserir um tÃ­tulo.','A'),(829,19,2,'APP_requireType','Ã‰ obrigatÃ³rio selecionar um tipo.','A'),(830,19,2,'APP_requireUser','Ã‰ obrigatÃ³rio inserir o usuÃ¡rio.','A'),(831,19,2,'APP_sendButton','Enviar','A'),(832,19,2,'APP_serviceLabel','ServiÃ§o','A'),(833,19,2,'APP_ShowTicket_title','SolicitaÃ§Ã£o','A'),(834,19,2,'APP_stateLabel','Estado','A'),(835,19,2,'APP_statusLabel','Status','A'),(836,19,2,'APP_titleLabel','TÃ­tulo','A'),(837,19,2,'APP_typeLabel','Tipo','A'),(838,19,2,'APP_urlLabel','Url da API','A'),(839,19,2,'APP_urlPlaceholder','https://...','A'),(840,19,2,'APP_urlRequired','Ã‰ ObrigatÃ³rio inserir a URL.','A'),(841,19,2,'APP_userLabel','Digite seu nome de usuÃ¡rio','A'),(842,19,2,'APP_userPlaceholder','UsuÃ¡rio','A'),(843,19,2,'APP_userRequired','Ã‰ obrigatÃ³rio inserir o usuÃ¡rio.','A'),(844,19,2,'hdk_Navbar_name','HelpDEZK','A'),(845,19,2,'pgr_cost_center','Cost Center','A'),(846,19,2,'pgr_dash_widgets','Widgets','A'),(847,19,2,'pgr_downloads','Downloads','A'),(848,19,2,'pgr_email_config','Email Configuration','A'),(849,19,2,'pgr_email_request','Requests by Email','A'),(850,19,2,'pgr_evaluation','Evaluation','A'),(851,19,2,'pgr_groups','Groups','A'),(852,19,2,'pgr_holidays','Holidays','A'),(853,19,2,'pgr_import_people','Users Import','A'),(854,19,2,'pgr_import_services','Import Services Catalog','A'),(855,19,2,'pgr_logos','Logos','A'),(856,19,2,'pgr_modules','Modules','A'),(857,19,2,'pgr_ope_aver_resptime','Operator Average Response Time','A'),(858,19,2,'pgr_people','People & Companies','A'),(859,19,2,'pgr_person_report','Person Report','A'),(860,19,2,'pgr_priority','Priority','A'),(861,19,2,'pgr_programs','Programs','A'),(862,19,2,'pgr_rejects_request','Reject Requests','A'),(863,19,2,'pgr_request_department','Request by Department','A'),(864,19,2,'pgr_request_operator','Requests by Operator','A'),(865,19,2,'pgr_request_status','Requests by Status','A'),(866,19,2,'pgr_req_reason','Request Reason','A'),(867,19,2,'pgr_req_reports','Total Requests Report','A'),(868,19,2,'pgr_services','Services','A'),(869,19,2,'pgr_status','Status','A'),(870,19,2,'pgr_summarized_department','Summarized by Department','A'),(871,19,2,'pgr_summarized_operator','Summarized by Operator','A'),(872,19,2,'pgr_sys_features','System Features','A'),(873,19,2,'pgr_type_permission','Type Person Permission','A'),(874,19,2,'pgr_user_satisfaction','User Satisfaction','A'),(875,19,2,'pgr_vocabulary','Vocabulary','A'),(876,19,2,'pgr_warnings','Warnings','A'),(877,19,2,'pgr_worked_requests','Worked Requests','A'),(878,19,2,'pgr_work_calendar','Work Calendar','A'),(879,19,2,'Abbreviation','Abbreviation','A'),(880,19,2,'Abilities','Abilities','A'),(881,19,2,'Access','Access','A'),(882,19,2,'Access_denied','Access denied.','A'),(883,19,2,'Acess_level','Access Level','A'),(884,19,2,'Activate','Activate','A'),(885,19,2,'Add','Add','A'),(886,19,2,'Added_notes','Added Notes','A'),(887,19,2,'Add_category','Add Category','A'),(888,19,2,'Add_item','Add Item','A'),(889,19,2,'add_new_feature','Add New Feature','A'),(890,19,2,'Add_service','Add Service','A'),(891,19,2,'Add_widget','Add Widget','A'),(892,19,2,'admin_dashboard','Administration Dashboard','A'),(893,19,2,'adodb_version','Adodb Version:','A'),(894,19,2,'Adress','Address','A'),(895,19,2,'Alert_activated','Succesfully activated.','A'),(896,19,2,'Alert_activated_error','Failure to activate.','A'),(897,19,2,'Alert_add_config_categ_title','Don\'t forget to add the category entry in \'app/lang/[idioma].txt\'','A'),(898,19,2,'Alert_add_feature_title','Don\'t forget to add the feature entry in \'app/lang/[idioma].txt\'','A'),(899,19,2,'Alert_add_module_title','Don\'t forget to add the module entry to \'app/lang/[idioma].txt\'','A'),(900,19,2,'Alert_add_program_title','Do not forget to add the program entry in \'app/lang/[idioma].txt\'','A'),(901,19,2,'Alert_approve','You have requests waiting for approval, do you want to approve them now?','A'),(902,19,2,'Alert_Cancel_sucess','Request succesfully canceled','A'),(903,19,2,'Alert_change_password','Password changed successfully','A'),(904,19,2,'Alert_choose_area','Please choose an area','A'),(905,19,2,'Alert_choose_item','Please choose an item','A'),(906,19,2,'Alert_choose_service','Please choose a service','A'),(907,19,2,'Alert_choose_type','Please choose a type','A'),(908,19,2,'Alert_close_request','Request finished','A'),(909,19,2,'Alert_deactivated','Succesfully deactivated.','A'),(910,19,2,'Alert_deactivated_error','Failure to desactivate.','A'),(911,19,2,'Alert_deleted','Succesfully Deleted.','A'),(912,19,2,'Alert_deleted_error','Failure to delete.','A'),(913,19,2,'Alert_deleted_note','Note deleted','A'),(914,19,2,'Alert_department_person','This Department has linked users. <br> To delete it, you need to move users to a new department. <br> Select the destination Department.','A'),(915,19,2,'Alert_different_passwords','Passwords do not match','A'),(916,19,2,'Alert_dont_delete_area','This area is linked to one or several requests. <br> This operation cannot be performed.','A'),(917,19,2,'Alert_dont_delete_item','This item is linked to one or several requests. <br> This operation cannot be performed.','A'),(918,19,2,'Alert_dont_delete_service','This service is bound to one or several requests. <br> This operation cannot be performed.','A'),(919,19,2,'Alert_dont_delete_type','This type is linked to one or several requests. <br> This operation cannot be performed.','A'),(920,19,2,'Alert_empty_note','Please fill the note\'s body','A'),(921,19,2,'Alert_empty_reason','Fill in the reason','A'),(922,19,2,'Alert_empty_subject','Please fill the request\'s subject','A'),(923,19,2,'Alert_external_settings_OK','Successfully Saved External Settings !!!','A'),(924,19,2,'Alert_failure','Couldn\'t insert','A'),(925,19,2,'Alert_field_required','This field is required.','A'),(926,19,2,'Alert_follow_repass','Choose one of the options on the follow.','A'),(927,19,2,'Alert_get_data','Unable to get data','A'),(928,19,2,'Alert_import_services_nofile_failure','Could not import !! Attach the file .','A'),(929,19,2,'Alert_inserted','Succesfully Inserted','A'),(930,19,2,'Alert_invalid_email','Invalid Email Format','A'),(931,19,2,'Alert_note_sucess','Note succesfully inserted','A'),(932,19,2,'Alert_not_match_new_pass','The new password cannot be the same as the current password!','A'),(933,19,2,'Alert_reopen_sucess','Request reopened','A'),(934,19,2,'Alert_select_one','Please select 1 item','A'),(935,19,2,'Alert_success_update','Data updated successfully','A'),(936,19,2,'Alert_sucess_category','Category successfully registered','A'),(937,19,2,'Alert_sucess_module','Module succesfully inserted.','A'),(938,19,2,'Alert_sucess_repass','Succesfully repassed!','A'),(939,19,2,'Alert_wrong_extension_csv','Invalid file extension. Are permitted only files with the extension CSV','A'),(940,19,2,'all','All','A'),(941,19,2,'and','and','A'),(942,19,2,'Approve_no','No.','A'),(943,19,2,'Approve_obs','Yes, with observation.','A'),(944,19,2,'Approve_text','Do you approve the operators attendance?','A'),(945,19,2,'Approve_yes','Yes.','A'),(946,19,2,'April','April','A'),(947,19,2,'Area','Area','A'),(948,19,2,'Area_edit','Edit Area','A'),(949,19,2,'Area_insert','Insert Area','A'),(950,19,2,'Area_name','Area\'s name','A'),(951,19,2,'Assumed_successfully','Assumed successfully!','A'),(952,19,2,'Assume_request','Assume Request','A'),(953,19,2,'Attach','Attach','A'),(954,19,2,'Attachments','Attachments','A'),(955,19,2,'Attendance','Attendance','A'),(956,19,2,'Attendance_time','Attendance time','A'),(957,19,2,'Attendants_by_group','View operators by group','A'),(958,19,2,'Attend_level','Attendance level','A'),(959,19,2,'Attend_time','Attendance Time','A'),(960,19,2,'Att_way','Attendance Way','A'),(961,19,2,'Att_way_min','Atend. Way','A'),(962,19,2,'Att_way_new','New Atend. Way','A'),(963,19,2,'August','August','A'),(964,19,2,'auxiliary_operator_include','Include Auxiliary Operator','A'),(965,19,2,'Available','Available','A'),(966,19,2,'Available_for','Available for','A'),(967,19,2,'Available_text','Available for record on request.','A'),(968,19,2,'Average','Average','A'),(969,19,2,'Back_btn','Back','A'),(970,19,2,'Bar_hide','Hide Bar','A'),(971,19,2,'Bar_show','Show Bar','A'),(972,19,2,'Birth_date','Birth Date','A'),(973,19,2,'Branch','Branch','A'),(974,19,2,'btn_assume','Assume','A'),(975,19,2,'btn_cancel','Cancel','A'),(976,19,2,'btn_close','Close','A'),(977,19,2,'Btn_evaluate','Evaluate','A'),(978,19,2,'btn_ope_aux','Operator Auxiliary','A'),(979,19,2,'btn_reject','Reject','A'),(980,19,2,'btn_reopen','Reopen','A'),(981,19,2,'btn_save_changes','Save Changes','A'),(982,19,2,'btn_submit','Submit','A'),(983,19,2,'btn_update_userdata','Update your data ','A'),(984,19,2,'By_company','by company','A'),(985,19,2,'By_group','by group','A'),(986,19,2,'Cancel_btn','Cancel','A'),(987,19,2,'Categories','Categories','A'),(988,19,2,'Category','Category','A'),(989,19,2,'Category_insert','Category Insert','A'),(990,19,2,'cat_config','Config','A'),(991,19,2,'cat_records','Records','A'),(992,19,2,'cat_reports','Reports','A'),(993,19,2,'Change','Change','A'),(994,19,2,'Change_date','Change Date','A'),(995,19,2,'Change_password','Change Password','A'),(996,19,2,'Change_password_required','Forcing user to change password.','A'),(997,19,2,'Change_permissions','Change Permissions','A'),(998,19,2,'Choose_format','Choose the format you want to export your report.','A'),(999,19,2,'City','City','A'),(1000,19,2,'Classification','Classification','A'),(1001,19,2,'Classification_text','Set this item as \'Classification Free\'.','A'),(1002,19,2,'Client','Costumer','A'),(1003,19,2,'Close','Close','A'),(1004,19,2,'Closed','Closed','A'),(1005,19,2,'Code','Code','A'),(1006,19,2,'Color','Color','A'),(1007,19,2,'Company','Company','A'),(1008,19,2,'Complement','Complement','A'),(1009,19,2,'Confirm_close','Close request?','A'),(1010,19,2,'Confirm_password','Confirm Password','A'),(1011,19,2,'conf_approvals','Configure Approvals','A'),(1012,19,2,'Contact_person','Contact Person','A'),(1013,19,2,'Controller','Controller','A'),(1014,19,2,'Country','Country','A'),(1015,19,2,'country_default','Default Country','A'),(1016,19,2,'cpf','SSN','A'),(1017,19,2,'Create_user','Create user','A'),(1018,19,2,'Create_user_msg','Create new user if this not exist in the Helpdezk.','A'),(1019,19,2,'Current_date','Current Date','A'),(1020,19,2,'Current_time','Current Time','A'),(1021,19,2,'Dashboard','Dashboard','A'),(1022,19,2,'Dashboard_SLAFulfillment','Fulfillment','A'),(1023,19,2,'Dashboard_SLANotFulfillment','Not Fulfillment','A'),(1024,19,2,'Dashboard_UpdatedDaily','Updated daily','A'),(1025,19,2,'Date','Date','A'),(1026,19,2,'Day','day','A'),(1027,19,2,'Days','Days','A'),(1028,19,2,'Deactivate','Deactivate','A'),(1029,19,2,'December','December','A'),(1030,19,2,'Default','Default','A'),(1031,19,2,'Default_department','Default Department','A'),(1032,19,2,'Default_department_msg','you can add more departments in the department\'s insert program','A'),(1033,19,2,'Default_text','Use this priority as default when a request is opened.','A'),(1034,19,2,'Delete','Delete','A'),(1035,19,2,'Delete_emails','Delete emails','A'),(1036,19,2,'Delete_emails_msg','Delete emails from the server when downloading.','A'),(1037,19,2,'Delete_module','Are you sure you want to delete this module?','A'),(1038,19,2,'Delete_record','Are you sure you want to delete this entry?','A'),(1039,19,2,'Delete_widget','Are you sure you want to delete this widget?','A'),(1040,19,2,'Delimiter','Delimiter','A'),(1041,19,2,'Department','Departament','A'),(1042,19,2,'Departments','Departaments','A'),(1043,19,2,'Department_exists','Department already recorded!','A'),(1044,19,2,'Department_name','Departament\'s name','A'),(1045,19,2,'Description','Description','A'),(1046,19,2,'Domain','Domain','A'),(1047,19,2,'Downloads','Downloads','A'),(1048,19,2,'Drag_image_msg','Drag the file with the image<br> or<br> click here.','A'),(1049,19,2,'Drag_import_file_msg','<br>Drag the file with the data<br> or<br> click here.','A'),(1050,19,2,'Drag_widget','Drag your widgets here','A'),(1051,19,2,'dropzone_File_Too_Big','Excedeu o tamanho mÃ¡ximo {{filesize}}','A'),(1052,19,2,'dropzone_invalid_dimension','A imagem tem que ser quadrada','A'),(1053,19,2,'dropzone_remove_file','Remover arquivo','A'),(1054,19,2,'dropzone_user_photot_message','<br> To your upload photo, just drag the file with the image click here. <br> <br> The image has to be square !!!','A'),(1055,19,2,'dsh_installer_dir','Installer directory','A'),(1056,19,2,'dsh_msg_installer','For security reasons, please remove <b>installer/</b> directory from your server !!!','A'),(1057,19,2,'dsh_warning','Warning','A'),(1058,19,2,'edit','Edit','A'),(1059,19,2,'Editor_Placeholder_description','Insert your descrition here ...','A'),(1060,19,2,'Editor_Placeholder_insert','Insert your note here ...','A'),(1061,19,2,'Editor_Placeholder_reason','Enter reason here...','A'),(1062,19,2,'Editor_Placeholder_solution','Enter request solution here...','A'),(1063,19,2,'Edit_btn','Edit','A'),(1064,19,2,'Edit_failure','Can\'t Edit!','A'),(1065,19,2,'Edit_layout','Edit Layout','A'),(1066,19,2,'Edit_sucess','Succesfully edited!','A'),(1067,19,2,'EIN_CNPJ','EIN','A'),(1068,19,2,'email','E-mail','A'),(1069,19,2,'Email_byCron','Send the emails of the requests by cron','A'),(1070,19,2,'Email_config','Email Configuration','A'),(1071,19,2,'Email_host','Email host','A'),(1072,19,2,'Email_sender','Email sender','A'),(1073,19,2,'Empty','No Items','A'),(1074,19,2,'Environment_settings','Environment Settings','A'),(1075,19,2,'Equipment','Equipment','A'),(1076,19,2,'ERP_Code','Code','A'),(1077,19,2,'ERP_Log','Log','A'),(1078,19,2,'Error','Error!','A'),(1079,19,2,'Error_insert_note','Error when inserting note','A'),(1080,19,2,'Error_Number_columns','Number of columns on line % of the file is invalid. Import canceled !!!','A'),(1081,19,2,'Execution_date','Execution Date','A'),(1082,19,2,'Expire_date','Expiry Date','A'),(1083,19,2,'Expire_date_sucess','Expire date changed successfully!','A'),(1084,19,2,'Export','Export','A'),(1085,19,2,'external_hostname','External Host Name:','A'),(1086,19,2,'external_ip','External Ip Address:','A'),(1087,19,2,'Extra','Extra','A'),(1088,19,2,'Failure_logs','Failure logs','A'),(1089,19,2,'Feature_remove','Remove Feature','A'),(1090,19,2,'February','February','A'),(1091,19,2,'Female','Female','A'),(1092,19,2,'File','File','A'),(1093,19,2,'File_CSV','CSV file.','A'),(1094,19,2,'File_PDF','PDF file.','A'),(1095,19,2,'File_XLS','XLS dile.','A'),(1096,19,2,'Fill','Fill','A'),(1097,19,2,'Fill_adress','Fill Adress?','A'),(1098,19,2,'Filter_by_sender','Filter by Sender','A'),(1099,19,2,'Filter_by_subject','Filter by Subject','A'),(1100,19,2,'Finished_alt','Finished','A'),(1101,19,2,'Finish_btn','Finish','A'),(1102,19,2,'Finish_date','Finish Date','A'),(1103,19,2,'Footer','Footer','A'),(1104,19,2,'Friday','Friday','A'),(1105,19,2,'From','From','A'),(1106,19,2,'Gender','Gender','A'),(1107,19,2,'Generated','Generated','A'),(1108,19,2,'grd_expired','Expired','A'),(1109,19,2,'grd_expired_n_assumed','Expired not assumed','A'),(1110,19,2,'grd_expiring','Expiring','A'),(1111,19,2,'grd_expiring_today','Expiring today','A'),(1112,19,2,'grd_show_all','Show all','A'),(1113,19,2,'grd_show_group','Show from my groups','A'),(1114,19,2,'grd_show_only_mine','Show only mine','A'),(1115,19,2,'Grid_all','All','A'),(1116,19,2,'Grid_all_tickets','All tickets','A'),(1117,19,2,'Grid_being_attended','Being attended','A'),(1118,19,2,'Grid_being_attended_tickets','Being attended Tickets','A'),(1119,19,2,'Grid_expire_date','Deadline','A'),(1120,19,2,'Grid_finished','Closed','A'),(1121,19,2,'Grid_finished_tickets','Closed Tickets','A'),(1122,19,2,'Grid_incharge','In charge','A'),(1123,19,2,'Grid_new','New','A'),(1124,19,2,'Grid_new_tickets','New tickets','A'),(1125,19,2,'Grid_opening_date','Entry Date','A'),(1126,19,2,'Grid_rejected','Rejected','A'),(1127,19,2,'Grid_rejected_tickets','Rejected Tickets','A'),(1128,19,2,'Grid_reload','Grid Reload','A'),(1129,19,2,'Grid_status','Status','A'),(1130,19,2,'Grid_subject','Subject','A'),(1131,19,2,'Grid_view','View','A'),(1132,19,2,'Grid_waiting_my_approval','Waiting my approval','A'),(1133,19,2,'Grid_waiting_my_approval_tickets','Waiting approval Tickets ','A'),(1134,19,2,'Group','Group','A'),(1135,19,2,'Groups','Groups','A'),(1136,19,2,'Groups_by_service','View groups by services','A'),(1137,19,2,'Group_name','Group\'s name','A'),(1138,19,2,'Group_operators','Group Operators','A'),(1139,19,2,'Group_still_viewing','I want my group to keep viewing this request','A'),(1140,19,2,'hdk_exceed_max_file_size','This file will not be processed. Exceeds maximum upload size: {{maxFilesize}}MB','A'),(1141,19,2,'hdk_remove_file','Remove File','A'),(1142,19,2,'Header','Header','A'),(1143,19,2,'helpdezk_path','Helpdezk Path:','A'),(1144,19,2,'helpdezk_version','Helpdezk Version:','A'),(1145,19,2,'Holiday','Holiday','A'),(1146,19,2,'Holidays','Holidays','A'),(1147,19,2,'Holiday_des','Holiday Description','A'),(1148,19,2,'Holiday_import','Holiday\'s Import','A'),(1149,19,2,'Home','Home','A'),(1150,19,2,'Hour','Hour','A'),(1151,19,2,'Hours','Hours','A'),(1152,19,2,'Import','Import','A'),(1153,19,2,'Important_notices','Important Notices','A'),(1154,19,2,'Import_error_file','Unable to write file for import.','A'),(1155,19,2,'Import_failure','Couldn\'t Import','A'),(1156,19,2,'Import_layout_error','Import file layout error - wrong number of columns.','A'),(1157,19,2,'Import_not_writable','Not allowed to save import file','A'),(1158,19,2,'Import_successfull','Successfully Imported','A'),(1159,19,2,'Import_to','Import to','A'),(1160,19,2,'Info_header_logo','Header logo must have 35pixels in height, all images with different proportions will be resized.','A'),(1161,19,2,'Info_login_logo','Login page logo must have 70pixels in height, all images with different proportions will be resized.','A'),(1162,19,2,'Info_reports_logo','Reports logo must have 40pixels in height, all images with different proportions will be resized.','A'),(1163,19,2,'Initial_date','Initial Date','A'),(1164,19,2,'Insert_note','Insert Note','A'),(1165,19,2,'Integration_ldap','LDAP/AD Integration','A'),(1166,19,2,'Item','Item','A'),(1167,19,2,'Item_edit','Item Edit','A'),(1168,19,2,'Item_insert','Item Insert','A'),(1169,19,2,'Item_name','Item\'s name','A'),(1170,19,2,'itens','items','A'),(1171,19,2,'January','January','A'),(1172,19,2,'jquery_version','Jquery Version:','A'),(1173,19,2,'July','July','A'),(1174,19,2,'June','June','A'),(1175,19,2,'juridical','Juridical','A'),(1176,19,2,'key_no_accents_no_whitespace','Key name cannot contain accents or blanks','A'),(1177,19,2,'Lbl_photo','Photo','A'),(1178,19,2,'lbl_session_name','Session Variable Name','A'),(1179,19,2,'lbl_value','Value','A'),(1180,19,2,'ldap_dn','Distinguished Names','A'),(1181,19,2,'ldap_domain','Domain','A'),(1182,19,2,'ldap_field','Object AD/LDAP','A'),(1183,19,2,'ldap_field_obs','Field where the user is stored.','A'),(1184,19,2,'ldap_server','Server ','A'),(1185,19,2,'List_comp_groups','List of companies and their groups:','A'),(1186,19,2,'Loading','Loading...','A'),(1187,19,2,'Location','Location','A'),(1188,19,2,'Location_insert','Location Insert','A'),(1189,19,2,'Lock_text','Your are in lock screen. Main app was shut down and you need to go the login screen  to go back to app.','A'),(1190,19,2,'Lock_unlock','Unlock','A'),(1191,19,2,'Login','Login','A'),(1192,19,2,'Login_cant_create_user','Cant create User !!!!','A'),(1193,19,2,'Login_error_error','Wrong password, please try again.','A'),(1194,19,2,'Login_error_secret','Wrong token, please try again !!!','A'),(1195,19,2,'Login_exists','Login already recorded!','A'),(1196,19,2,'Login_layout','Layout Login','A'),(1197,19,2,'Login_page_logo','Login Page Logo','A'),(1198,19,2,'Login_type','Login Type','A'),(1199,19,2,'Login_user_inactive','Inactive user, please talk with one administrator.','A'),(1200,19,2,'Login_user_not_exist','User don\'t exist, please check your typing!','A'),(1201,19,2,'Logos_Title','Logos','A'),(1202,19,2,'logout','Log out','A'),(1203,19,2,'log_email','Email Logs','A'),(1204,19,2,'log_general','General Logs','A'),(1205,19,2,'log_host','Host Type','A'),(1206,19,2,'log_level','Log Level','A'),(1207,19,2,'log_remote_server','Remote Server','A'),(1208,19,2,'Lost_password','I forgot my password','A'),(1209,19,2,'Lost_password_ad','It is not possible to recovery the password in the Active Directory, contact the System Administrator.','A'),(1210,19,2,'Lost_password_body','<br><br><br><p>We inform you that your new password is: <b>$pass</b> <br>This is an automatically message, please do not answer.</p><br><br><br><br>','A'),(1211,19,2,'Lost_password_err','Falha ao enviar nova senha.','A'),(1212,19,2,'Lost_password_log','Sent e-mail lost password - ','A'),(1213,19,2,'Lost_password_master','User master password can not be changed','A'),(1214,19,2,'Lost_password_not','User don\'t exist, please check your typing','A'),(1215,19,2,'Lost_password_pop','It is not possible to recovery the password at POP mode, contact the System Administrator.','A'),(1216,19,2,'Lost_password_subject','Password Reminder','A'),(1217,19,2,'Lost_password_suc','New password send with success. ','A'),(1218,19,2,'Maintenance','Maintenance','A'),(1219,19,2,'Male','Male','A'),(1220,19,2,'Manage_fail_import_file','Failed to import the csv file with the data.','A'),(1221,19,2,'Manage_fail_move_file','Failed to move file data.\\nCheck the permissions on attachments directory and try again.','A'),(1222,19,2,'Manage_fail_open_file_in','Failed to open the data file in ','A'),(1223,19,2,'Manage_fail_open_file_per','\\nCheck the permissions and try again.','A'),(1224,19,2,'Manage_instructions','Download the instructions for importing: ','A'),(1225,19,2,'Manage_layout_service','Layout Import Services','A'),(1226,19,2,'Manage_layout_service_file','Layout-Import-Services.pdf','A'),(1227,19,2,'Manage_service_already_registered','is already registered.','A'),(1228,19,2,'Manage_service_and_group','and the group ','A'),(1229,19,2,'Manage_service_area','Registered new area -> Code:','A'),(1230,19,2,'Manage_service_area_fail','Failed to register the service area ','A'),(1231,19,2,'Manage_service_column_6','Column 6 must contain only numeric value. The value was entered ','A'),(1232,19,2,'Manage_service_company_fail','Column 8 is required a valid filename company. The company % is not registered!','A'),(1233,19,2,'Manage_service_completed','Process completed successfully','A'),(1234,19,2,'Manage_service_default_pri','was associated with default priority, because the priority informed ','A'),(1235,19,2,'Manage_service_fail','Fails to enroll the service ','A'),(1236,19,2,'Manage_service_fail_code','Failed to determine the service code ','A'),(1237,19,2,'Manage_service_fail_rel','Failed to register the relationship between service ','A'),(1238,19,2,'Manage_service_finalized_line','Finalized the line ','A'),(1239,19,2,'Manage_service_group_fail','Failed to register the group in person table: ','A'),(1240,19,2,'Manage_service_group_fail2','Failed to register the service group','A'),(1241,19,2,'Manage_service_group_register','! Joined new service group -> Code ','A'),(1242,19,2,'Manage_service_group_using','* Using existing group -> Code ','A'),(1243,19,2,'Manage_service_imp_canceled','. Import canceled!','A'),(1244,19,2,'Manage_service_inf_line','given in row ','A'),(1245,19,2,'Manage_service_inf_on_line','entered on line ','A'),(1246,19,2,'Manage_service_in_service','in service ','A'),(1247,19,2,'Manage_service_item','Joined new item -> ','A'),(1248,19,2,'Manage_service_item_fail','Failed to register the service item ','A'),(1249,19,2,'Manage_service_line','line ','A'),(1250,19,2,'Manage_service_not_identify_priority','Unable to identify the priority service time on line ','A'),(1251,19,2,'Manage_service_not_registered','Is not registered or is not attending. Line ','A'),(1252,19,2,'Manage_service_on_line',', on line ','A'),(1253,19,2,'Manage_service_pri_no_exist','does not exist in the system.','A'),(1254,19,2,'Manage_service_register_service','Joined new service ','A'),(1255,19,2,'Manage_service_type','Joined new TYPE -> Code: ','A'),(1256,19,2,'Manage_service_type_fail','Failed to register the type of care ','A'),(1257,19,2,'Manage_service_using_area','Using existing area -> Code: ','A'),(1258,19,2,'Manage_service_using_item','Using existing item -> Code ','A'),(1259,19,2,'Manage_service_using_type','Using existing type -> ','A'),(1260,19,2,'Mange_service_order',', order','A'),(1261,19,2,'March','March','A'),(1262,19,2,'May','May','A'),(1263,19,2,'Messages','Messages','A'),(1264,19,2,'Message_title','You have $$ new messages .','A'),(1265,19,2,'Minutes','Minutes','A'),(1266,19,2,'Mobile_phone','Mobile Phone','A'),(1267,19,2,'Module','Module','A'),(1268,19,2,'Modules','Modules','A'),(1269,19,2,'Module_default','Default module','A'),(1270,19,2,'Module_insert','Module Insert','A'),(1271,19,2,'Module_name','Module\'s name','A'),(1272,19,2,'module_not_delete','This module cannot be deleted','A'),(1273,19,2,'module_not_disable','This module cannot be disabled','A'),(1274,19,2,'module_not_edit','This module cannot be edited','A'),(1275,19,2,'Module_path','Module path','A'),(1276,19,2,'Monday','Monday','A'),(1277,19,2,'Month','Month','A'),(1278,19,2,'Msg_change_operation','Warning! If you want change the operations permissions you need set the permissions again at program \'Type Person Permission\'','A'),(1279,19,2,'mysql_version','Mysql Version:','A'),(1280,19,2,'My_Tickets','My Tickets','A'),(1281,19,2,'Name','Name','A'),(1282,19,2,'National_holiday','National Holiday','A'),(1283,19,2,'natural','Natural','A'),(1284,19,2,'Neighborhood','Neighborhood','A'),(1285,19,2,'New','New','A'),(1286,19,2,'New_category','New Category','A'),(1287,19,2,'New_date','New Date','A'),(1288,19,2,'new_feature','New Feature','A'),(1289,19,2,'New_messages','New messages','A'),(1290,19,2,'New_password','New Password','A'),(1291,19,2,'New_request','New Request','A'),(1292,19,2,'New_time','New Time','A'),(1293,19,2,'No','No','A'),(1294,19,2,'Normal','Normal','A'),(1295,19,2,'Note','Note','A'),(1296,19,2,'Note_msg','Insert notes when answer emails.','A'),(1297,19,2,'Notification','Notification','A'),(1298,19,2,'Not_available_yet','Not available yet','A'),(1299,19,2,'November','November','A'),(1300,19,2,'No_abilities','There\'s no abilities related','A'),(1301,19,2,'No_data','No data.','A'),(1302,19,2,'No_notices','No important notice at the moment.','A'),(1303,19,2,'no_permission_edit','You don\'t have permission to edit','A'),(1304,19,2,'No_result','No results found.','A'),(1305,19,2,'Number','Number','A'),(1306,19,2,'Obrigatory_time','Please fill the time expended in this activity','A'),(1307,19,2,'Observation','Observation','A'),(1308,19,2,'October','October','A'),(1309,19,2,'of','of','A'),(1310,19,2,'Ok_btn','Ok','A'),(1311,19,2,'Only_operator','Only operator','A'),(1312,19,2,'on_time','On Time','A'),(1313,19,2,'Opened_by','Opened By','A'),(1314,19,2,'Opening_date','Entry Date','A'),(1315,19,2,'Operation','Operation','A'),(1316,19,2,'Operations','Operations','A'),(1317,19,2,'Operator','Operator','A'),(1318,19,2,'Operator_groups','Operator Groups','A'),(1319,19,2,'Option_only_attendant_active','Active Attendants Only Option','A'),(1320,19,2,'Option_only_operator','Option only for operators','A'),(1321,19,2,'Other_items','Other Options','A'),(1322,19,2,'overdue','Overdue','A'),(1323,19,2,'Overtime','Overtime','A'),(1324,19,2,'Page','Page','A'),(1325,19,2,'Page_header_logo','Page Header Logo','A'),(1326,19,2,'Password','Password','A'),(1327,19,2,'PDF_code','Code','A'),(1328,19,2,'PDF_Page','Page','A'),(1329,19,2,'PDF_person_report','Person Report','A'),(1330,19,2,'people','People & Companies','A'),(1331,19,2,'Permissions','Permissions','A'),(1332,19,2,'Permission_error','Error during operation','A'),(1333,19,2,'Permission_Groups','Permission','A'),(1334,19,2,'Permission_Groups_Select','Select the Permission Group','A'),(1335,19,2,'pgr_departments','Departments','A'),(1336,19,2,'pgr_erp_emailtemplate','E-mail Templates','A'),(1337,19,2,'Phone','Phone','A'),(1338,19,2,'php_version','Php Version:','A'),(1339,19,2,'Placeholder_subject','Enter the subject','A'),(1340,19,2,'Placeholder_zipcode','Enter de Zipcode','A'),(1341,19,2,'plh_category_description','Enter Category Name','A'),(1342,19,2,'plh_controller_description','Inform the Program Controller','A'),(1343,19,2,'plh_holiday_date','Enter Holiday Date','A'),(1344,19,2,'plh_holiday_description','Enter Holiday Description','A'),(1345,19,2,'plh_module_description','Enter Module Name','A'),(1346,19,2,'plh_module_path','Enter Module Path','A'),(1347,19,2,'plh_module_prefix','Enter the table prefix','A'),(1348,19,2,'plh_program_description','Enter Program Name','A'),(1349,19,2,'plh_smarty_variable','Enter the smarty variable','A'),(1350,19,2,'Pop_server','POP Server','A'),(1351,19,2,'Port','Port','A'),(1352,19,2,'Previous_year','Previous Year','A'),(1353,19,2,'Print','Print','A'),(1354,19,2,'Priority','Priority','A'),(1355,19,2,'Processing','Processing','A'),(1356,19,2,'Program','Program','A'),(1357,19,2,'Programs','Programs','A'),(1358,19,2,'pushover','PushOver API Configuration','A'),(1359,19,2,'Reason','Reason','A'),(1360,19,2,'Reason_no_registered','No registered reason','A'),(1361,19,2,'Recalculate','Recalculate','A'),(1362,19,2,'Recalculate_msg_chk','Recalculate service time after the end of the approvals','A'),(1363,19,2,'records','Records','A'),(1364,19,2,'Register_btn','Register','A'),(1365,19,2,'Rejected','Rejected','A'),(1366,19,2,'Reject_btn','Reject','A'),(1367,19,2,'Reject_sucess','Request Rejected','A'),(1368,19,2,'Related_abilities','Related Abilities','A'),(1369,19,2,'reload_request','Reload request data','A'),(1370,19,2,'Remove','Remove','A'),(1371,19,2,'Repassed','Repassed','A'),(1372,19,2,'Repass_btn','Repass','A'),(1373,19,2,'Repass_request_only','Only repass requests','A'),(1374,19,2,'Repass_request_to','Repass request to','A'),(1375,19,2,'Reports_logo','Reports Logo','A'),(1376,19,2,'Request','Request','A'),(1377,19,2,'Requests','Requests','A'),(1378,19,2,'Request_approve','There are requests waiting for approval. <br/> You can not open new requests before approving it.','A'),(1379,19,2,'Request_approve_app','Request Approve','A'),(1380,19,2,'Request_assumed','Request Assumed','A'),(1381,19,2,'Request_canceled','Request Canceled','A'),(1382,19,2,'Request_closed','Request Closed','A'),(1383,19,2,'Request_code','Request Code','A'),(1384,19,2,'Request_not_approve','The request was not approved','A'),(1385,19,2,'Request_opened','Request Opened','A'),(1386,19,2,'Request_owner','Request Owner','A'),(1387,19,2,'Request_rejected','Request Could not be attended: ','A'),(1388,19,2,'Request_reopened','Request Reopened ','A'),(1389,19,2,'Request_repassed','Request Repassed ','A'),(1390,19,2,'Request_reprove_app','Request Reprove','A'),(1391,19,2,'Request_return_app','Return to the previous phase','A'),(1392,19,2,'Request_waiting_approval','Waiting for user`s approval','A'),(1393,19,2,'Requires_Autentication','Requires autentication','A'),(1394,19,2,'Saturday','Saturday','A'),(1395,19,2,'Save','Save','A'),(1396,19,2,'Save_changes_sucess','Changes Saved','A'),(1397,19,2,'Search','Search','A'),(1398,19,2,'Second','second','A'),(1399,19,2,'seconds','seconds','A'),(1400,19,2,'Select','Select','A'),(1401,19,2,'Select_acess_level','Choose Acess Level','A'),(1402,19,2,'Select_area','Choose an area','A'),(1403,19,2,'Select_category','Choose a category','A'),(1404,19,2,'Select_company','Choose a company','A'),(1405,19,2,'Select_country','Choose country','A'),(1406,19,2,'Select_department','Chose a department','A'),(1407,19,2,'Select_group','Selecione um grupo','A'),(1408,19,2,'Select_group_operator','Select a group or operator.','A'),(1409,19,2,'Select_location','Choose Location','A'),(1410,19,2,'Select_module','Select the module','A'),(1411,19,2,'Select_priority','Choose a priority','A'),(1412,19,2,'Select_street','Choose Address','A'),(1413,19,2,'Send','S E N D ','A'),(1414,19,2,'Send_alerts_email','Yes, send this alert by email.','A'),(1415,19,2,'Send_alerts_topic_email','Yes, send alerts by email for this topic.','A'),(1416,19,2,'Send_email','Send email','A'),(1417,19,2,'September','September','A'),(1418,19,2,'Serial_number','Serial Number','A'),(1419,19,2,'Server','Server','A'),(1420,19,2,'Service','Service','A'),(1421,19,2,'Service_edit','Service Edit','A'),(1422,19,2,'Service_insert','Service Insert','A'),(1423,19,2,'Service_name','Service\'s Name','A'),(1424,19,2,'Service_order_number','OS Number','A'),(1425,19,2,'Service_order_number_min','OS Number','A'),(1426,19,2,'Settings','Settings','A'),(1427,19,2,'Set_repass_groups','Set repass groups','A'),(1428,19,2,'show','Show','A'),(1429,19,2,'Show_attendants_title','Show operators by group','A'),(1430,19,2,'Show_groups_services_title','View groups by service','A'),(1431,19,2,'Show_in','Show in','A'),(1432,19,2,'Smarty','Smarty\'s Variable','A'),(1433,19,2,'smarty_version','Smarty Version:','A'),(1434,19,2,'SMS','SMS','A'),(1435,19,2,'Solution','Solution','A'),(1436,19,2,'Source','Source','A'),(1437,19,2,'Started','Started','A'),(1438,19,2,'State','State','A'),(1439,19,2,'status','Status','A'),(1440,19,2,'Still_viewing','I want to keep viewing this request.','A'),(1441,19,2,'Stop_viewing','Stop viewing this request.','A'),(1442,19,2,'Subject','Subject','A'),(1443,19,2,'Success_logs','Success logs','A'),(1444,19,2,'Sunday','Sunday','A'),(1445,19,2,'sys_2FAuthentication','Use two-step authentication','A'),(1446,19,2,'sys_session_time_lbl','Time System Session Duration','A'),(1447,19,2,'sys_time_session','Time that will last the session system. Value in seconds. If not set will be 10 minutes.','A'),(1448,19,2,'Table_prefix','Table prefix','A'),(1449,19,2,'Tag_min','Tag','A'),(1450,19,2,'Tckt_cancel_request','Confirm  cancel request ?','A'),(1451,19,2,'Tckt_delete_note','Confirm  delete request note?','A'),(1452,19,2,'Tckt_del_note_failure','Could not delete the note !','A'),(1453,19,2,'Tckt_drop_file','Drop files to upload (or click here)!','A'),(1454,19,2,'Tckt_evaluated_success','Request evaluated successfully !','A'),(1455,19,2,'Tckt_finish_request','Close','A'),(1456,19,2,'Tckt_incharge','In charge','A'),(1457,19,2,'Tckt_opened','Ticket opened','A'),(1458,19,2,'Tckt_reopen_request','Confirm  reopen request ?','A'),(1459,19,2,'Tckt_Request','Ticket;','A'),(1460,19,2,'Tck_new_ticket','New Ticket','A'),(1461,19,2,'Tck_Open','Open Tickets ','A'),(1462,19,2,'Tck_title','Tickets','A'),(1463,19,2,'Template_edit','Edit Template','A'),(1464,19,2,'Thursday','Thursday','A'),(1465,19,2,'timeouttext','Your session will expire in','A'),(1466,19,2,'Time_expended','Time Expended in task','A'),(1467,19,2,'Time_return','Time return link (callback)','A'),(1468,19,2,'Time_value','Time Value','A'),(1469,19,2,'Title','Title','A'),(1470,19,2,'tlt_span_group','Requests from my group','A'),(1471,19,2,'tlt_span_my','My Requests','A'),(1472,19,2,'tlt_span_track_group','Track by group','A'),(1473,19,2,'tlt_span_track_me','Track by me','A'),(1474,19,2,'to','to','A'),(1475,19,2,'tooltip_city','Add new city','A'),(1476,19,2,'tooltip_delete_area','Delete Area','A'),(1477,19,2,'tooltip_delete_item','Delete Item','A'),(1478,19,2,'tooltip_delete_service','Delete Service','A'),(1479,19,2,'tooltip_delete_type','Delete Type','A'),(1480,19,2,'tooltip_list_items','List Items','A'),(1481,19,2,'tooltip_list_services','List Services','A'),(1482,19,2,'tooltip_neighborhood','Add new neighborhood','A'),(1483,19,2,'tooltip_state','Add new state','A'),(1484,19,2,'tooltip_street','Add new address','A'),(1485,19,2,'Topic','Topic','A'),(1486,19,2,'Topic_edit','Topic Edit','A'),(1487,19,2,'Total','Total','A'),(1488,19,2,'Total_holidays','Total Holidays','A'),(1489,19,2,'Total_minutes','Total minutes','A'),(1490,19,2,'tracker_status','Track Emails','A'),(1491,19,2,'trello','Trello API Configuration','A'),(1492,19,2,'trello_boards','Boards','A'),(1493,19,2,'trello_cards','Cards','A'),(1494,19,2,'trello_description','Card Description','A'),(1495,19,2,'trello_integration','Trello Integration','A'),(1496,19,2,'trello_key','Key','A'),(1497,19,2,'trello_lists','Lists','A'),(1498,19,2,'trello_title','Card Title','A'),(1499,19,2,'trello_token','Token','A'),(1500,19,2,'trello_tooltip_card','Add new card','A'),(1501,19,2,'Tuesday','Tuesday','A'),(1503,19,2,'Type_adress','Type adress','A'),(1504,19,2,'Type_edit','Type Edit','A'),(1505,19,2,'Type_insert','Insert Type','A'),(1506,19,2,'Type_name','Type\'s name','A'),(1507,19,2,'type_user_operator','Operator','A'),(1508,19,2,'type_user_user','User','A'),(1509,19,2,'until','until','A'),(1510,19,2,'Until_closed','Until closed','A'),(1511,19,2,'Update','Update','A'),(1512,19,2,'User','User','A'),(1513,19,2,'UserData','User data','A'),(1514,19,2,'user_external_settings','External Settings','A'),(1515,19,2,'User_login','User login','A'),(1516,19,2,'user_profile','Profile','A'),(1517,19,2,'Valid','Valid','A'),(1518,19,2,'Validity_Standard','Validity Standard','A'),(1519,19,2,'Valid_until','Valid until','A'),(1520,19,2,'Value_exists','Entered value is already registered','A'),(1521,19,2,'Var_assume','Assume Date','A'),(1522,19,2,'Var_branch','User\'s branch phone number','A'),(1523,19,2,'Var_date','Date when the email is sent','A'),(1524,19,2,'Var_description','Request Description','A'),(1525,19,2,'Var_evaluation','Evaluation given by the user','A'),(1526,19,2,'Var_expire','Expire Date','A'),(1527,19,2,'Var_finish','Finish Date','A'),(1528,19,2,'Var_incharge','In charge','A'),(1529,19,2,'Var_link_evaluation','Link to evaluate without login.','A'),(1530,19,2,'Var_link_operator','Link to the request page (operator)','A'),(1531,19,2,'Var_link_user','Link to the request page (user)','A'),(1532,19,2,'Var_nt_operator','Notes that only operators can see','A'),(1533,19,2,'Var_nt_user','Notes that users can see','A'),(1534,19,2,'Var_phone','User\'s Phone','A'),(1535,19,2,'Var_record','Entry Date','A'),(1536,19,2,'Var_rejection','Rejection Date','A'),(1537,19,2,'Var_request','Request Code','A'),(1538,19,2,'Var_requester','Requester Name','A'),(1539,19,2,'Var_status','Request Status','A'),(1540,19,2,'Var_subject','Request Subject','A'),(1541,19,2,'Var_user','Logged User','A'),(1542,19,2,'Version','Version','A'),(1543,19,2,'View_groups','View groups','A'),(1544,19,2,'VIP_user','VIP user','A'),(1545,19,2,'Visible','Visible','A'),(1546,19,2,'vocabulary_key_exists','This key already exists','A'),(1547,19,2,'vocabulary_key_name','Key Name','A'),(1548,19,2,'vocabulary_key_value','Key Value','A'),(1549,19,2,'vocabulary_locale','Locale','A'),(1550,19,2,'Waiting_for_approval','Waiting for approval','A'),(1551,19,2,'Warning_new_topic','New Topic','A'),(1552,19,2,'Wednesday','Wednesday','A'),(1553,19,2,'Widget','Widget','A'),(1554,19,2,'Yes','Yes ','A'),(1555,19,2,'Zipcode','Zipcode','A'),(1556,559,2,'pgr_people','?nsanlar ve ?irketler','A'),(1557,559,2,'pgr_holidays','Bayram','A'),(1558,559,2,'pgr_programs','Programlar','A'),(1559,559,2,'pgr_modules','ModÃ¼ller','A'),(1560,559,2,'pgr_type_permission','Ki?i ?zni yaz?n','A'),(1561,559,2,'pgr_downloads','?ndirme','A'),(1562,559,2,'pgr_logos','logolar','A'),(1563,559,2,'pgr_status','durum','A'),(1564,559,2,'pgr_priority','Ã¶ncelik','A'),(1565,559,2,'pgr_groups','Gruplar','A'),(1566,559,2,'pgr_evaluation','De?erlendirme','A'),(1567,559,2,'pgr_cost_center','Ã¶deme merkezi','A'),(1568,559,2,'pgr_services','Hizmetler','A'),(1569,559,2,'pgr_req_reason','Talep Nedeni','A'),(1570,559,2,'pgr_email_config','E-posta Yap?land?rma','A'),(1571,559,2,'pgr_email_request','E-posta ile ?stekler','A'),(1572,559,2,'pgr_sys_features','sistem Ã¶zellikleri','A'),(1573,559,2,'pgr_person_report','ki?i Raporu','A'),(1574,559,2,'pgr_req_reports','istekler Raporu','A'),(1575,559,2,'pgr_ope_aver_resptime','OperatÃ¶r Ortalama Tepki SÃ¼resi','A'),(1576,559,2,'pgr_request_department','bÃ¶lÃ¼mÃ¼ taraf?ndan Talebi','A'),(1577,559,2,'pgr_rejects_request','?stekleri reddet','A'),(1578,559,2,'pgr_request_status','Duruma gÃ¶re ?stekler','A'),(1579,559,2,'pgr_request_operator','??letmeci taraf?ndan ?stekler','A'),(1580,559,2,'pgr_summarized_operator','??letmeci taraf?ndan Ã¶zetlenen','A'),(1581,559,2,'pgr_summarized_department','bÃ¶lÃ¼mÃ¼ taraf?ndan Ã¶zetlenen','A'),(1582,559,2,'pgr_user_satisfaction','kullan?c? Memnuniyeti','A'),(1583,559,2,'pgr_dash_widgets','widget\'lar','A'),(1584,559,2,'pgr_warnings','Uyar?lar','A'),(1585,559,2,'pgr_import_people','Kullan?c?lar ?thalat','A'),(1586,559,2,'pgr_work_calendar','Ã§al??ma Takvimi','A'),(1587,559,2,'pgr_import_services','?thalat Hizmetleri Katalog','A'),(1588,559,2,'Abbreviation','K?saltma','A'),(1589,559,2,'Abilities','Yetenekleri','A'),(1590,559,2,'Access','Eri?im','A'),(1591,559,2,'Access_denied','Eri?im reddedildi.','A'),(1592,559,2,'Acess_level','eri?im Seviyesi','A'),(1593,559,2,'Activate','etkinle?tirmek','A'),(1594,559,2,'Add','Eklemek','A'),(1595,559,2,'Add_category','Kategori ekle','A'),(1596,559,2,'Add_item','Ã¶?e eklemek','A'),(1597,559,2,'Add_service','Hizmet ekle','A'),(1598,559,2,'Add_widget','Widget ekleyin','A'),(1599,559,2,'Added_notes','Eklenen Notlar','A'),(1600,559,2,'Adress','Adres','A'),(1601,559,2,'Alert_activated','Ba?ar?yla Ã§al??t?r?ld?.','A'),(1602,559,2,'Alert_activated_error','Ba?ar?s?zl?k etkinle?tirmek iÃ§in.','A'),(1603,559,2,'Alert_approve','Sen, onay iÃ§in bekleyen iste?iniz var ?imdi onlar? onaylamak istiyor musunuz?','A'),(1604,559,2,'Alert_choose_area','bir alan seÃ§iniz','A'),(1605,559,2,'Alert_choose_item','Bir Ã¶?eyi seÃ§iniz','A'),(1606,559,2,'Alert_choose_service','bir hizmet seÃ§iniz','A'),(1607,559,2,'Alert_choose_type','Bir tÃ¼rÃ¼ seÃ§iniz','A'),(1608,559,2,'Alert_deactivated','Ba?ar?yla devre d???.','A'),(1609,559,2,'Alert_deactivated_error','Ba?ar?s?zl?k desactivate iÃ§in.','A'),(1610,559,2,'Alert_deleted','Ba?ar?yla silinmi?.','A'),(1611,559,2,'Alert_deleted_error','silmek iÃ§in ba?ar?s?zl?k.','A'),(1612,559,2,'Alert_different_passwords','?ifreler e?le?medi','A'),(1613,559,2,'Alert_empty_note','Ã¶notas?n?n vÃ¼cudunu doldurunuz','A'),(1614,559,2,'Alert_empty_subject','iste?in konuyu doldurunuz','A'),(1615,559,2,'Alert_failure','eklemek olamazd?','A'),(1616,559,2,'Alert_change_password','Parola ba?ar?yla de?i?tirildi','A'),(1617,559,2,'Alert_inserted','ba?ar?yla Eklenen','A'),(1618,559,2,'Alert_select_one','1 Ã¶?e seÃ§iniz','A'),(1619,559,2,'Alert_sucess_module','ModÃ¼l ba?ar?yla tak?l?.','A'),(1620,559,2,'Alert_sucess_repass','Ba?ar?yla repassed!','A'),(1621,559,2,'Alert_follow_repass','takip seÃ§eneklerden birini seÃ§in.','A'),(1622,559,2,'Alert_wrong_extension_csv','GeÃ§ersiz dosya uzant?s?. uzatma CSV ile dosyalar? izin verilir','A'),(1623,559,2,'all','Her?ey','A'),(1624,559,2,'Approve_text','E?er operatÃ¶rler kat?l?m? onayl?yor musunuz?','A'),(1625,559,2,'Approve_no','Yok hay?r.','A'),(1626,559,2,'Approve_obs','Evet, gÃ¶zlem.','A'),(1627,559,2,'Approve_yes','Evet.','A'),(1628,559,2,'and','ve','A'),(1629,559,2,'Area','alan','A'),(1630,559,2,'Area_insert','Ekle Alan?','A'),(1631,559,2,'Area_edit','DÃ¼zenleme Alan?','A'),(1632,559,2,'Area_name','Yrenin ad?','A'),(1633,559,2,'Assume_request','?ste?i varsayal?m','A'),(1634,559,2,'Assumed_successfully','Ba?ar?yla varsayarsak!','A'),(1635,559,2,'Att_way','Seyirci Yolu','A'),(1636,559,2,'Att_way_min','Al?yorlar. yol','A'),(1637,559,2,'Att_way_new','Yeni al?yorlar. yol','A'),(1638,559,2,'Attach','ili?tirmek','A'),(1639,559,2,'Attachments','Ekler','A'),(1640,559,2,'Attend_level','Seyirci seviyesi','A'),(1641,559,2,'Attend_time','Seyirci Zaman','A'),(1642,559,2,'Attendance','kat?l?m','A'),(1643,559,2,'Attendance_time','Seyirci zaman','A'),(1644,559,2,'Attendants_by_group','grup taraf?ndan gÃ¶rÃ¼nÃ¼m operatÃ¶rleri','A'),(1645,559,2,'Available','Mevcut','A'),(1646,559,2,'Available_for','?Ã§in uygun','A'),(1647,559,2,'Available_text','?stek Ã¼zerine kay?t iÃ§in kullan?labilir.','A'),(1648,559,2,'Back_btn','Arka','A'),(1649,559,2,'Birth_date','Do?um gÃ¼nÃ¼','A'),(1650,559,2,'Branch','?ube','A'),(1651,559,2,'Bar_show','Show Bar','A'),(1652,559,2,'Bar_hide','gizle Bar','A'),(1653,559,2,'By_group','grubu ile','A'),(1654,559,2,'By_company','?irket taraf?ndan','A'),(1655,559,2,'Cancel_btn','?ptal etmek','A'),(1656,559,2,'Category','Kategori','A'),(1657,559,2,'Category_insert','Kategori Ekle','A'),(1658,559,2,'Change','De?i?iklik','A'),(1659,559,2,'Change_date','Tarihi de?i?tir','A'),(1660,559,2,'Change_password','?ifre de?i?tir','A'),(1661,559,2,'Change_password_required','?ifresini de?i?tirmek iÃ§in kullan?c? zorlamak.','A'),(1662,559,2,'Change_permissions','?zinleri de?i?tir','A'),(1663,559,2,'City','?ehir','A'),(1664,559,2,'Classification','s?n?fland?rma','A'),(1665,559,2,'Classification_text','\'S?n?fland?rma Free\' olarak bu Ã¶?eyi ayarlay?n.','A'),(1666,559,2,'Client','kostÃ¼mcÃ¼','A'),(1667,559,2,'Closed','Kapal?','A'),(1668,559,2,'Code','kod','A'),(1669,559,2,'Color','Renk','A'),(1670,559,2,'Company','?irket','A'),(1671,559,2,'Complement','tamamlay?c?','A'),(1672,559,2,'Confirm_close','Kapat istek?','A'),(1673,559,2,'Confirm_password','?ifreyi Onayla','A'),(1674,559,2,'Contact_person','?lgili ki?i','A'),(1675,559,2,'Controller','kontrolr','A'),(1676,559,2,'conf_approvals','Yap?land?rma Onaylar','A'),(1677,559,2,'Country','Ã¼lke','A'),(1678,559,2,'cpf','SSN','A'),(1679,559,2,'Create_user','Kullan?c? olu?tur','A'),(1680,559,2,'Create_user_msg','Bu Helpdezk bulunmayan e?er yeni bir kullan?c? olu?turun.','A'),(1681,559,2,'Current_date','GeÃ§erli tarih','A'),(1682,559,2,'Current_time','?imdiki zaman','A'),(1683,559,2,'Choose_format','Raporunuzu vermek istedi?iniz biÃ§imi seÃ§in.','A'),(1684,559,2,'Close','Kapat','A'),(1685,559,2,'Dashboard','gÃ¶sterge paneli','A'),(1686,559,2,'Date','tarih','A'),(1687,559,2,'Days','gÃ¼nler','A'),(1688,559,2,'Deactivate','Devre d??? b?rakmak','A'),(1689,559,2,'Default','Varsay?lan','A'),(1690,559,2,'Default_department','varsay?lan bÃ¶lÃ¼mÃ¼','A'),(1691,559,2,'Default_department_msg','E?er bÃ¶lÃ¼mÃ¼n ekleme program?nda daha fazla bÃ¶lÃ¼mler ekleyebilir','A'),(1692,559,2,'Default_text','bir istek aÃ§?ld???nda varsay?lan olarak bu Ã¶nceli?i kullan?n.','A'),(1693,559,2,'Delete','silmek','A'),(1694,559,2,'Delete_emails','e-postalar? silin','A'),(1695,559,2,'Delete_emails_msg','indirirken sunucudan e-postalar? silmek.','A'),(1696,559,2,'Delimiter','S?n?rlay?c?','A'),(1697,559,2,'Department','Departament','A'),(1698,559,2,'Department_exists','bÃ¶lÃ¼m Ã¶nceden kaydedilmi?!','A'),(1699,559,2,'Department_name','Departament ad?','A'),(1700,559,2,'Departments','Departaments','A'),(1701,559,2,'Description','AÃ§?klama','A'),(1702,559,2,'Domain','domain','A'),(1703,559,2,'Downloads','?ndirme','A'),(1704,559,2,'Drag_widget','Burada widget sÃ¼rÃ¼kleyin','A'),(1705,559,2,'Delete_widget','Bu widget\'? silmek istedi?inizden emin misiniz?','A'),(1706,559,2,'EIN_CNPJ','EIN','A'),(1707,559,2,'edit','DÃ¼zenleme','A'),(1708,559,2,'Edit_btn','DÃ¼zenleme','A'),(1709,559,2,'Edit_sucess','Ba?ar?yla dÃ¼zenlenmi?!','A'),(1710,559,2,'Edit_failure','Edit olamaz!','A'),(1711,559,2,'Edit_layout','DÃ¼zenleme DÃ¼zeni','A'),(1712,559,2,'email','E-posta','A'),(1713,559,2,'Email_host','e-posta sahibi','A'),(1714,559,2,'Email_config','E-posta Yap?land?rma','A'),(1715,559,2,'Email_sender','E-posta gÃ¶nderen','A'),(1716,559,2,'Empty','hiÃ§bir ÃœrÃ¼nleri','A'),(1717,559,2,'Equipment','ekipman','A'),(1718,559,2,'Error','Hata!','A'),(1719,559,2,'Expire_date','Son kullanma tarihi','A'),(1720,559,2,'Expire_date_sucess','YÃ¼rÃ¼rlÃ¼k sÃ¼resi ba?ar?yla de?i?tirildi!','A'),(1721,559,2,'Execution_date','?nfaz tarihi','A'),(1722,559,2,'Export','?hracat','A'),(1723,559,2,'Extra','Ekstra','A'),(1724,559,2,'Female','Kad?n','A'),(1725,559,2,'Failure_logs','ba?ar?s?zl?k gÃ¼nlÃ¼kleri','A'),(1726,559,2,'File','Dosya','A'),(1727,559,2,'File_PDF','PDF dosyas?.','A'),(1728,559,2,'File_XLS','XLS dile.','A'),(1729,559,2,'File_CSV','CSV dosyas?.','A'),(1730,559,2,'Fill_adress','Adres doldurun?','A'),(1731,559,2,'Filter_by_sender','GÃ¶nderene gÃ¶re filtreleme','A'),(1732,559,2,'Filter_by_subject','Konu Filtre','A'),(1733,559,2,'Finish_btn','Biti?','A'),(1734,559,2,'Finished_alt','bitirdi','A'),(1735,559,2,'Footer','Altbilgi','A'),(1736,559,2,'From','itibaren','A'),(1737,559,2,'Generated','olu?turulan','A'),(1738,559,2,'Gender','Cinsiyet','A'),(1739,559,2,'Group','grup','A'),(1740,559,2,'Group_name','Grubun ad?','A'),(1741,559,2,'Group_operators','Grup OperatÃ¶rleri','A'),(1742,559,2,'Group_still_viewing','Benim grup bu iste?i inceleyen tutmak istiyorum','A'),(1743,559,2,'Groups','Gruplar','A'),(1744,559,2,'Header','Ã¼stbilgi','A'),(1745,559,2,'Holiday','Tatil','A'),(1746,559,2,'Holidays','Bayram','A'),(1747,559,2,'Holiday_des','tatil AÃ§?klamas?','A'),(1748,559,2,'Holiday_import','Bayram?n ?thalat','A'),(1749,559,2,'Home','Ev','A'),(1750,559,2,'Hours','Saatler','A'),(1751,559,2,'Hour','Saat','A'),(1752,559,2,'Info_header_logo','Header logo yÃ¼ksekli?i 35pixels olmal?d?r, farkl? oranlarda tÃ¼m gÃ¶rÃ¼ntÃ¼leri yeniden boyutland?r?l?r.','A'),(1753,559,2,'Info_login_logo','yÃ¼ksekli?i 70pixels olmal?d?r Oturum aÃ§ma sayfas? logosu, farkl? oranlarda tÃ¼m gÃ¶rÃ¼ntÃ¼leri yeniden boyutland?r?l?r.','A'),(1754,559,2,'Info_reports_logo','logo yÃ¼ksekli?i 40pixels olmal?d?r raporlar?n?n, farkl? oranlarda tÃ¼m gÃ¶rÃ¼ntÃ¼leri yeniden boyutland?r?l?r.','A'),(1755,559,2,'Import','?thalat','A'),(1756,559,2,'Import_to','?thalat','A'),(1757,559,2,'Import_successfull','ba?ar?yla ?thal','A'),(1758,559,2,'Import_failure','?thalat olamazd?','A'),(1759,559,2,'Insert_note','Ekle Not','A'),(1760,559,2,'Integration_ldap','LDAP / AD Entegrasyonu','A'),(1761,559,2,'Item_insert','Ã¶?e Ekle','A'),(1762,559,2,'Item_edit','Ã¶?e DÃ¼zenleme','A'),(1763,559,2,'Item_name','Ã¶?enin ad?','A'),(1764,559,2,'itens','Ã¼rÃ¼n','A'),(1765,559,2,'juridical','tÃ¼zel','A'),(1766,559,2,'ldap_server','sunucu','A'),(1767,559,2,'ldap_dn','Ay?rt edici ad?','A'),(1768,559,2,'ldap_domain','domain','A'),(1769,559,2,'ldap_field','Ã¶nesne AD / LDAP','A'),(1770,559,2,'ldap_field_obs','Kullan?c? depoland??? alan?.','A'),(1771,559,2,'List_comp_groups','?irketler ve onlar?n gruplar?n?n listesi:','A'),(1772,559,2,'Loading','YÃ¼kleniyor...','A'),(1773,559,2,'Login','Oturum aÃ§','A'),(1774,559,2,'Login_exists','Oturum Ã¶nceden kaydedilmi?!','A'),(1775,559,2,'Login_page_logo','Giri? Sayfas? Logosu','A'),(1776,559,2,'Login_type','Giri? TÃ¼rÃ¼','A'),(1777,559,2,'Login_layout','DÃ¼zen Giri?i','A'),(1778,559,2,'Login_user_not_exist','Kullan?c? yoktur, yazarak kontrol edin!','A'),(1779,559,2,'Login_error_error','Yanl?? ?ifre, lÃ¼tfen tekrar deneyin.','A'),(1780,559,2,'Login_user_inactive','Inaktif kullan?c?, bir yÃ¶netici ile konu?mak lÃ¼tfen.','A'),(1781,559,2,'Location','yer','A'),(1782,559,2,'Location_insert','Yer Ekle','A'),(1783,559,2,'Lost_password','?ifremi Unuttum','A'),(1784,559,2,'Lost_password_suc','Yeni ?ifre ba?ar? ile gÃ¶nderin.','A'),(1785,559,2,'Lost_password_err','Yeni ?ifreyi gÃ¶nderilemedi.','A'),(1786,559,2,'Lost_password_ad','Bu kurtarma Active Directory ?ifre mÃ¼mkÃ¼n de?ildir, Sistem YÃ¶neticisine ba?vurun.','A'),(1787,559,2,'Lost_password_pop','Bu sistem yÃ¶netici ile ileti?im, kurtarma POP modunda ?ifre mÃ¼mkÃ¼n de?ildir.','A'),(1788,559,2,'Lost_password_master','Kullan?c? ana ?ifre de?i?tirilemez','A'),(1789,559,2,'Lost_password_not','Kullan?c? yazarak kontrol edin, yoktur','A'),(1790,559,2,'Lost_password_subject','?ifre hat?rlat?c?','A'),(1791,559,2,'Lost_password_body','<br> <p> Size yeni ?ifrenizi oldu?unu bildirmek. $ <b> geÃ§mesi </ b> <br> Bu otomatik olarak mesaj, cevap yok lÃ¼tfen </ p> <br > <br>','A'),(1792,559,2,'Lost_password_log','gÃ¶nderilen e-posta ?ifresini kaybetti -','A'),(1793,559,2,'Manage_fail_import_file','veri ile csv dosyas?n? al?namad?.','A'),(1794,559,2,'Manage_fail_move_file','dosya verileri ta??mak iÃ§in ba?ar?s?z oldu. \\ nGÃ¼venlik ekleri dizin Ã¼zerinde izinleri ve yeniden deneyin.','A'),(1795,559,2,'Manage_fail_open_file_in','veri dosyas? aÃ§?lamad?','A'),(1796,559,2,'Manage_fail_open_file_per','\\ NGÃ¼venlik izinleri ve yeniden deneyin.','A'),(1797,559,2,'Manage_service_area','yeni bir alan Kay?tl? -> Kod:','A'),(1798,559,2,'Manage_service_using_area','Mevcut alan? kullanarak -> Kod:','A'),(1799,559,2,'Manage_service_area_fail','hizmet alan?n? kaydedilemedi','A'),(1800,559,2,'Manage_service_inf_line','sat?rda verilmi?tir','A'),(1801,559,2,'Manage_service_imp_canceled','. ?thalat iptal edildi!','A'),(1802,559,2,'Manage_service_type','Kat?l?m yeni T?P -> Kod:','A'),(1803,559,2,'Manage_service_type_fail','bak?m tÃ¼rÃ¼nÃ¼ kaydedemedi','A'),(1804,559,2,'Manage_service_using_type','Mevcut tÃ¼rÃ¼nÃ¼ kullanarak ->','A'),(1805,559,2,'Manage_service_item','yeni Ã¶?e kat?ld? ->','A'),(1806,559,2,'Manage_service_item_fail','Servis Ã¶?esini kaydedilemedi','A'),(1807,559,2,'Manage_service_using_item','Mevcut Ã¶?esini kullanarak -> Kod','A'),(1808,559,2,'Manage_service_company_fail','SÃ¼tun 8 geÃ§erli bir dosya ismi ?irketi gereklidir. ?irket% kay?tl? de?il!','A'),(1809,559,2,'Manage_service_group_fail','ki?i masada grubu kaydedemedi:','A'),(1810,559,2,'Manage_service_group_fail2','hizmet grubu kaydedilemedi','A'),(1811,559,2,'Manage_service_group_register','! Yeni hizmet grubuna kat?ld? -> Kod','A'),(1812,559,2,'Manage_service_group_using','* Mevcut grup kullanarak -> Kod','A'),(1813,559,2,'Manage_service_default_pri','Ã¶ncelik haberdar Ã§Ã¼nkÃ¼, varsay?lan Ã¶nceli?i ile ili?kili','A'),(1814,559,2,'Manage_service_pri_no_exist','sistemde mevcut de?il.','A'),(1815,559,2,'Manage_service_fail_code','Servis kod belirlemek iÃ§in Ba?ar?s?z','A'),(1816,559,2,'Manage_service_on_line',', internet Ã¼zerinden','A'),(1817,559,2,'Manage_service_line','hat','A'),(1818,559,2,'Manage_service_already_registered','zaten kay?tl?.','A'),(1819,559,2,'Manage_service_column_6','SÃ¼tun 6 yaln?zca say?sal de?er iÃ§ermelidir. de?eri girildi','A'),(1820,559,2,'Manage_service_fail','hizmet kay?t ba?ar?s?z','A'),(1821,559,2,'Manage_service_inf_on_line','sat?r?nda girilen','A'),(1822,559,2,'Manage_service_register_service','Kat?l?m yeni hizmet','A'),(1823,559,2,'Manage_service_fail_rel','hizmet aras?ndaki ili?kiyi kaydedemedi','A'),(1824,559,2,'Manage_service_and_group','ve grup','A'),(1825,559,2,'Manage_service_not_registered','kay?tl? de?il ya da kat?l?yor de?ildir. Hat','A'),(1826,559,2,'Manage_service_in_service','serviste','A'),(1827,559,2,'Mange_service_order',', sipari?','A'),(1828,559,2,'Manage_service_finalized_line','Ã§izgi kesinle?mi?','A'),(1829,559,2,'Manage_service_completed','SÃ¼reÃ§ ba?ar?yla tamamland?','A'),(1830,559,2,'Manage_service_not_identify_priority','on line Ã¶ncelikli hizmet sÃ¼resini tan?mlamak iÃ§in aÃ§?lam?yor','A'),(1831,559,2,'Manage_instructions','ithalat? iÃ§in talimatlar? indirin:','A'),(1832,559,2,'Manage_layout_service','DÃ¼zen ?thalat Hizmetleri','A'),(1833,559,2,'Manage_layout_service_file','DÃ¼zen-?thalat Services.pdf','A'),(1834,559,2,'Male','Erkek','A'),(1835,559,2,'Maintenance','Bak?m','A'),(1836,559,2,'Minutes','dakika','A'),(1837,559,2,'Mobile_phone','Cep telefonu','A'),(1838,559,2,'Module','modÃ¼l','A'),(1839,559,2,'Module_insert','modÃ¼l Ekle','A'),(1840,559,2,'Module_name','ModÃ¼l ad?','A'),(1841,559,2,'Modules','ModÃ¼ller','A'),(1842,559,2,'Month','Ay','A'),(1843,559,2,'Msg_change_operation','Uyar?! E?er operasyon izinlerini de?i?tirmek isterseniz program?n \'TÃ¼r Ki?i ?zni\' tekrar izinlerini ayarlamak gerekir','A'),(1844,559,2,'Categories','Kategoriler','A'),(1845,559,2,'Name','isim','A'),(1846,559,2,'natural','Do?al','A'),(1847,559,2,'National_holiday','Ulusal tatil','A'),(1848,559,2,'Neighborhood','Kom?uluk','A'),(1849,559,2,'New','yeni','A'),(1850,559,2,'New_category','Yeni kategori','A'),(1851,559,2,'New_date','yeni Tarih','A'),(1852,559,2,'New_time','Yeni zaman','A'),(1853,559,2,'New_password','Yeni ?ifre','A'),(1854,559,2,'New_request','Yeni istek','A'),(1855,559,2,'No_abilities','ilgili herhangi yetenekler var','A'),(1856,559,2,'No_data','Veri yok.','A'),(1857,559,2,'Note','Ã¶not','A'),(1858,559,2,'Note_msg','Ã¶ne zaman cevap e-postalar notlar? yerle?tirin.','A'),(1859,559,2,'Not_available_yet','HenÃ¼z mevcut de?il','A'),(1860,559,2,'No_result','SonuÃ§ bulunamad?.','A'),(1861,559,2,'No','Yok hay?r','A'),(1862,559,2,'Notification','Bildirim','A'),(1863,559,2,'Number','Ã¶numara','A'),(1864,559,2,'Obrigatory_time','Bu etkinlikte harcanan zaman? doldurunuz','A'),(1865,559,2,'Observation','GÃ¶zlem','A'),(1866,559,2,'of','aras?nda','A'),(1867,559,2,'Ok_btn','Tamam','A'),(1868,559,2,'Only_operator','sadece operatÃ¶r','A'),(1869,559,2,'Option_only_operator','sadece operatÃ¶rler iÃ§in SeÃ§enek','A'),(1870,559,2,'Opened_by','ile aÃ§?ld?','A'),(1871,559,2,'Operations','Operasyonlar','A'),(1872,559,2,'Operator','?ebeke','A'),(1873,559,2,'Operator_groups','operatÃ¶r Gruplar?','A'),(1874,559,2,'Opening_date','Giri? tarihi','A'),(1875,559,2,'Overtime','Mesai','A'),(1876,559,2,'Print','bask?','A'),(1877,559,2,'Page','Sayfa','A'),(1878,559,2,'Page_header_logo','Sayfa Header Logo','A'),(1879,559,2,'Password','Parola','A'),(1880,559,2,'people','?nsanlar ve ?irketler','A'),(1881,559,2,'Permissions','?zinler','A'),(1882,559,2,'Permission_error','operasyon s?ras?nda hata','A'),(1883,559,2,'Port','Liman','A'),(1884,559,2,'Phone','Telefon','A'),(1885,559,2,'Pop_server','POP Sunucusu','A'),(1886,559,2,'Previous_year','GeÃ§en y?l','A'),(1887,559,2,'Priority','Ã¶ncelik','A'),(1888,559,2,'Programs','Programlar','A'),(1889,559,2,'PDF_person_report','ki?i Raporu','A'),(1890,559,2,'PDF_code','kod','A'),(1891,559,2,'PDF_Page','Sayfa','A'),(1892,559,2,'Widget','Widget','A'),(1893,559,2,'Reason','Ã¶neden','A'),(1894,559,2,'Recalculate_msg_chk','onaylar?n bitiminden sonra servis sÃ¼resini yeniden hesapla','A'),(1895,559,2,'Recalculate','Yeniden Hesapla','A'),(1896,559,2,'Remove','Kald?r','A'),(1897,559,2,'Register_btn','Kay?t olmak','A'),(1898,559,2,'Related_abilities','?lgili Yetenekler','A'),(1899,559,2,'Repass_btn','geri gitmek','A'),(1900,559,2,'Repassed','Geri gÃ¶nderildi','A'),(1901,559,2,'Repass_request_only','Sadece istekleri geri gitmek','A'),(1902,559,2,'Repass_request_to','iÃ§in geri gitmek iste?i','A'),(1903,559,2,'Rejected','reddedilen','A'),(1904,559,2,'Reports_logo','Raporlar Logo','A'),(1905,559,2,'Request','?stek','A'),(1906,559,2,'Requests','istekler','A'),(1907,559,2,'Request_assumed','Talep Tahmini','A'),(1908,559,2,'Request_approve_app','Onayla istek formu','A'),(1909,559,2,'Request_reprove_app','Talep reprove','A'),(1910,559,2,'Request_return_app','Bir Ã¶nceki faza dÃ¶nÃ¼?','A'),(1911,559,2,'Request_rejected','Talep kat?ld? edilemedi:','A'),(1912,559,2,'Request_repassed','Talep Repassed','A'),(1913,559,2,'Request_reopened','Talep Reopened','A'),(1914,559,2,'Request_closed','Talep Kapal?','A'),(1915,559,2,'Request_canceled','Talep ?ptal Edildi','A'),(1916,559,2,'Request_opened','Talep AÃ§?ld?','A'),(1917,559,2,'Request_code','?stek kodu','A'),(1918,559,2,'Request_owner','Talep Sahibi','A'),(1919,559,2,'Request_not_approve','istek kabul edilmedi','A'),(1920,559,2,'Request_approve','Onay bekleyen istekleri vard?r. <br/> Bunu onaylamadan Ã¶nce yeni istekleri aÃ§?lam?yor.','A'),(1921,559,2,'Request_waiting_approval','`?n onay bekliyor','A'),(1922,559,2,'Requires_Autentication','Do?rulamas? gerektirir','A'),(1923,559,2,'Smarty','Smarty De?i?ken','A'),(1924,559,2,'Save','Kay?t etmek','A'),(1925,559,2,'Search','Arama','A'),(1926,559,2,'Set_repass_groups','Set geri gitmek gruplar?','A'),(1927,559,2,'Select','seÃ§mek','A'),(1928,559,2,'Select_acess_level','Eri?im Seviye SeÃ§','A'),(1929,559,2,'Select_area','bir alan seÃ§in','A'),(1930,559,2,'Select_category','Bir kategori seÃ§in','A'),(1931,559,2,'Select_company','Bir ?irket','A'),(1932,559,2,'Select_department','Bir bÃ¶lÃ¼mÃ¼ seÃ§ti','A'),(1933,559,2,'Select_group','SBir grup seÃ§in','A'),(1934,559,2,'Select_priority','Bir Ã¶ncelik seÃ§in','A'),(1935,559,2,'Select_module','modÃ¼lÃ¼nÃ¼ seÃ§in','A'),(1936,559,2,'Select_group_operator','Bir grup veya operatÃ¶rÃ¼ seÃ§in.','A'),(1937,559,2,'Send','GÃ–NDER','A'),(1938,559,2,'Send_email','Eposta gÃ¶nder','A'),(1939,559,2,'Serial_number','Seri numaras?','A'),(1940,559,2,'Service','Hizmet','A'),(1941,559,2,'Server','sunucu','A'),(1942,559,2,'Service_insert','servis Ekle','A'),(1943,559,2,'Service_edit','hizmet DÃ¼zenleme','A'),(1944,559,2,'Service_name','Hizmet Ad?','A'),(1945,559,2,'Groups_by_service','Hizmetlere gÃ¶re gÃ¶rÃ¼ntÃ¼le gruplar?','A'),(1946,559,2,'Send_alerts_topic_email','Evet, bu konu iÃ§in e-posta ile uyar? gÃ¶ndermek.','A'),(1947,559,2,'Send_alerts_email','Evet, e-posta yoluyla bu uyar? gÃ¶nderir.','A'),(1948,559,2,'Service_order_number','??letim Numaras?','A'),(1949,559,2,'Service_order_number_min','??letim Numaras?','A'),(1950,559,2,'Show_attendants_title','grup taraf?ndan gÃ¶ster operatÃ¶rleri','A'),(1951,559,2,'show','GÃ¶ster','A'),(1952,559,2,'Show_in','gÃ¶ster','A'),(1953,559,2,'SMS','SMS','A'),(1954,559,2,'Solution','Ã‡Ã¶zÃ¼m','A'),(1955,559,2,'Source','Kaynak','A'),(1956,559,2,'Started','ba?lad?','A'),(1957,559,2,'State','Belirtmek, bildirmek','A'),(1958,559,2,'status','durum','A'),(1959,559,2,'Still_viewing','Ben bu iste?i incelemeye devam etmek istiyorum.','A'),(1960,559,2,'Stop_viewing','Bu iste?i inceleyen durdurun.','A'),(1961,559,2,'Subject','konu','A'),(1962,559,2,'Success_logs','ba?ar? gÃ¼nlÃ¼kleri','A'),(1963,559,2,'Tag_min','Etiket','A'),(1964,559,2,'Template_edit','?ablon DÃ¼zenle','A'),(1965,559,2,'Time_expended','Ã¶zaman gÃ¶rev Harcanan','A'),(1966,559,2,'Time_value','Ã¶zaman De?eri','A'),(1967,559,2,'Title','Ba?l?k','A'),(1968,559,2,'tlt_span_group','Grubuma gelen talepler','A'),(1969,559,2,'tlt_span_my','benim ?stekler','A'),(1970,559,2,'tlt_span_track_group','grup taraf?ndan Takip','A'),(1971,559,2,'tlt_span_track_me','Bana gÃ¶re ParÃ§a','A'),(1972,559,2,'to','iÃ§in','A'),(1973,559,2,'Topic','konu','A'),(1974,559,2,'Topic_edit','Konu DÃ¼zenleme','A'),(1975,559,2,'Total_minutes','Toplam dakikalar','A'),(1976,559,2,'Total','Genel Toplam','A'),(1977,559,2,'Total_holidays','Toplam Tatiller','A'),(1979,559,2,'Type_adress','Tip adresi','A'),(1980,559,2,'Type_edit','DÃ¼zenle TÃ¼r','A'),(1981,559,2,'Type_insert','Ekle Tipi','A'),(1982,559,2,'Type_name','TÃ¼rÃ¼nÃ¼n ad?','A'),(1983,559,2,'Update','GÃ¼ncelle?tirme','A'),(1984,559,2,'User','kullan?c?','A'),(1985,559,2,'User_login','Kullan?c? Giri?i','A'),(1986,559,2,'Until_closed','kapanana kadar','A'),(1987,559,2,'Validity_Standard','GeÃ§erlilik Standart','A'),(1988,559,2,'Valid','GeÃ§erli','A'),(1989,559,2,'Valid_until','geÃ§erli kadar','A'),(1990,559,2,'Version','versiyon','A'),(1991,559,2,'Visible','GÃ¶zle gÃ¶rÃ¼lÃ¼r','A'),(1992,559,2,'VIP_user','VIP kullan?c?','A'),(1993,559,2,'View_groups','gÃ¶rÃ¼nÃ¼m gruplar?','A'),(1994,559,2,'Yes','Evet','A'),(1995,559,2,'Waiting_for_approval','onay bekleniyor','A'),(1996,559,2,'Warning_new_topic','Yeni Konu','A'),(1997,559,2,'Zipcode','Posta kodu','A'),(1998,559,2,'Normal','normal','A'),(1999,559,2,'Monday','Pazartesi','A'),(2000,559,2,'Tuesday','Sal?','A'),(2001,559,2,'Wednesday','Ã‡ar?amba','A'),(2002,559,2,'Thursday','Per?embe','A'),(2003,559,2,'Friday','Cuma','A'),(2004,559,2,'Saturday','Cumartesi','A'),(2005,559,2,'Sunday','Pazar','A'),(2006,559,2,'January','Ocak ay?','A'),(2007,559,2,'February','?ubat ay?','A'),(2008,559,2,'March','Mart','A'),(2009,559,2,'April','Ã¶nisan','A'),(2010,559,2,'May','May?s ay?','A'),(2011,559,2,'June','Haziran','A'),(2012,559,2,'July','Temmuz','A'),(2013,559,2,'August','A?ustos','A'),(2014,559,2,'September','EylÃ¼l','A'),(2015,559,2,'October','Ekim','A'),(2016,559,2,'November','Kas?m','A'),(2017,559,2,'December','Aral?k','A'),(2018,559,2,'type_user_user','kullan?c?','A'),(2019,559,2,'type_user_operator','?ebeke','A'),(2020,559,2,'Var_user','Kay?tl? Kullan?c?','A'),(2021,559,2,'Var_phone','Kullan?c?n?n Telefon','A'),(2022,559,2,'Var_branch','Kullan?c? ?ube telefon numaras?','A'),(2023,559,2,'Var_date','E-posta gÃ¶nderilir tarihi','A'),(2024,559,2,'Var_request','?stek kodu','A'),(2025,559,2,'Var_subject','Talep Konusu','A'),(2026,559,2,'Var_description','Talep AÃ§?klama','A'),(2027,559,2,'Var_record','Giri? tarihi','A'),(2028,559,2,'Var_expire','Son kullanma tarihi','A'),(2029,559,2,'Var_assume','Tarihi varsayal?m','A'),(2030,559,2,'Var_finish','Biti? tarihi','A'),(2031,559,2,'Var_rejection','Reddetme tarihi','A'),(2032,559,2,'Var_status','Talep Durumu','A'),(2033,559,2,'Var_requester','?stekte Ad','A'),(2034,559,2,'Var_incharge','Sorumlu','A'),(2035,559,2,'Var_nt_operator','Sadece operatÃ¶rler gÃ¶rebilir belirtiyor','A'),(2036,559,2,'Var_nt_user','kullan?c?lar gÃ¶rebilir belirtiyor','A'),(2037,559,2,'Var_link_operator','istek sayfaya link (operatÃ¶r)','A'),(2038,559,2,'Var_link_user','istek sayfaya link (kullan?c?)','A'),(2039,559,2,'Var_evaluation','Kullan?c? taraf?ndan verilen de?erlendirme','A'),(2040,559,2,'Var_link_evaluation','Ba?lant? giri? yapmadan de?erlendirmek.','A'),(2041,559,2,'auxiliary_operator_include','Yard?mc? Operator ekleyin','A'),(2042,559,2,'btn_save_changes','De?i?iklikleri Kaydet','A'),(2043,559,2,'btn_assume','Ã¼stlenmek','A'),(2044,559,2,'btn_reject','reddetmek','A'),(2045,559,2,'btn_close','Kapat','A'),(2046,559,2,'btn_reopen','yeniden aÃ§mak','A'),(2047,559,2,'btn_ope_aux','operatÃ¶r Yard?mc?','A'),(2048,559,2,'Other_items','Di?er seÃ§enekler','A'),(2049,559,2,'sys_time_session','oturum sistemini sÃ¼recek zaman?. saniyeler iÃ§inde de?er. E?er 10 dakika olacak ayarlanmam??.','A'),(2050,559,2,'grd_show_only_mine','Sadece beni gÃ¶ster','A'),(2051,559,2,'grd_show_group','Benim gruplar? gÃ¶ster','A'),(2052,559,2,'grd_show_all','TÃ¼mÃ¼nÃ¼ gÃ¶ster','A'),(2053,559,2,'grd_expiring','Bitmek','A'),(2054,559,2,'grd_expiring_today','bugÃ¼n sÃ¼resi dolan','A'),(2055,559,2,'grd_expired','SÃ¼resi doldu','A'),(2056,559,2,'grd_expired_n_assumed','kazanmam?? sÃ¼resi dolmu?','A'),(2057,559,2,'cat_records','kay?tlar','A'),(2058,559,2,'cat_config','Yap?land?rma','A'),(2059,559,2,'cat_reports','Raporlar','A'),(2060,559,2,'pgr_departments','bÃ¶lÃ¼mler','A'),(2061,559,2,'seconds','saniye','A'),(2062,559,2,'reload_request','istek verileri gÃ¼ncelle','A'),(2063,559,2,'Error_insert_note','Hata notu ekleyerek','A'),(2064,559,2,'Alert_Cancel_sucess','Talep ba?ar?yla iptal edildi','A'),(2065,559,2,'Alert_note_sucess','ba?ar?yla tak?l? Not','A'),(2066,559,2,'Alert_close_request','bitmi? talep','A'),(2067,559,2,'Alert_reopen_sucess','Talep aÃ§?ld?','A'),(2068,559,2,'Alert_deleted_note','Ã¶not silindi','A'),(2069,559,2,'Fill','doldurmak','A'),(2070,559,2,'Reject_sucess','Talep Reddedildi','A'),(2071,559,2,'Reject_btn','reddetmek','A'),(2072,559,2,'Save_changes_sucess','De?i?iklikler kaydedildi','A'),(2073,559,2,'Initial_date','ilk Tarih','A'),(2074,559,2,'Finish_date','Biti? tarihi','A'),(2075,559,2,'Average','Ortalama','A'),(2076,559,2,'Dashboard_SLAFulfillment','yerine getirme','A'),(2077,559,2,'Dashboard_SLANotFulfillment','de?il yerine getirilmesi','A'),(2078,559,2,'Dashboard_UpdatedDaily','gÃ¼nlÃ¼k gÃ¼ncellendi','A'),(2079,77,2,'Ends_in','Termina em','A'),(2080,19,2,'Ends_in','Ends in','A'),(2081,77,2,'Annual','Anual','A'),(2082,19,2,'Annual','Annual','A'),(2083,19,2,'Active_tickets','Active tickets','A'),(2084,77,2,'Active_tickets','Tickets ativos','A'),(2085,77,2,'Waiting','Aguardando','A'),(2086,19,2,'Waiting','Waiting','A'),(2087,19,2,'User_tickets','User\'s ticket','A'),(2088,77,2,'User_tickets','Tickets do usu&aacute;rio','A'),(2089,19,2,'Closed_tickets','Closed tickets','A'),(2090,77,2,'Closed_tickets','Tickets fechados','A'),(2091,19,2,'Closed_status','Closed Status','A'),(2092,77,2,'Closed_status','Status dos fechados','A'),(2093,19,2,'Assigned','Assigned','A'),(2094,77,2,'Assigned','Atribu&iacute;das','A'),(2095,19,1,'sys_user_dashboard','Show user dashboard','A'),(2096,77,1,'sys_user_dashboard','Mostrar dashboard do usu&aacute;rio','A'),(2097,19,1,'sys_operator_dashboard','Show operator dashboard','A'),(2098,77,1,'sys_operator_dashboard','Mostrar dashboard do atendente','A'),(2099,19,1,'System_features','System features','A'),(2100,77,1,'System_features','Funcionalidades do Sistema','A'),(2101,19,1,'sys_allow_assume_others','Allow attendants to take on requests passed on assumed by another attendant.','A'),(2102,77,1,'sys_allow_assume_others','Permitir que os atendentes assumam solicita&ccedil&otildees repassadas ou assumidas por outro atendente.','A'),(2103,19,1,'sys_allow_delete_note','Allow attendants to delete notes','A'),(2104,77,1,'sys_allow_delete_note','Permitir que os atendentes excluam apontamentos','A'),(2105,19,1,'sys_dont_show_default','When open request, do not show area, type, item service default. User chooses regardless of default value.','A'),(2106,77,1,'sys_dont_show_default','Ao abrir a solicita&ccedil;&atilde;o, n&atilde;o mostrar &aacute;rea, tipo,item e servi&ccedil;o padr&atilde;o. O usu&aacute;rio escolhe independentemente do valor padr&atilde;o.','A'),(2107,77,1,'sys_use_equipment','Utilizar controle de equipamento (os, etiqueta e serial)','A'),(2108,19,1,'sys_use_equipment','Use equipment control (os, label serial)','A'),(2109,77,1,'sys_allow_reopen_user','Permitir reabertura de solicita&ccedil&otildees por usu&aacuterio','A'),(2110,19,1,'sys_allow_reopen_user','Allow reopening of requests per user','A'),(2111,77,1,'sys_empty_note','Permitir que o atendente insira apontamento sem descri&ccedil;&atilde;o','A'),(2112,19,1,'sys_empty_note','Allow the attendant to enter an appointment without a description','A'),(2113,77,1,'sys_open_new_request','Para abrir uma nova solicita&ccedil;&atilde;o o usu&aacute;rio n&atilde;o poder&aacute; ter solicita&ccedil;&otilde;es para aprovar','A'),(2114,19,1,'sys_open_new_request','To open a new request the user will not be able to have requests to approve','A'),(2115,77,1,'sys_prorogation_qt','Qtde de prorroga&ccedil&otildees na data de vencimento (0 = Nunca, [Em branco] = Sem limites, [Acima de 0] = Qtd. de prorroga&ccedil&otildees)','A'),(2116,19,1,'sys_prorogation_qt','Number of extensions on the due date (0 = Never, [Blank] = No limits, [Over 0] = Number of extensions)','A'),(2117,77,1,'sys_allow_reopen','Permitir reabertura de solicita&ccedil&otildees','A'),(2118,19,1,'sys_allow_reopen','Allow request reopening','A'),(2119,19,1,'sys_email_notification','Send email notification when changing the status of requests','A'),(2120,77,1,'sys_email_notification','Enviar notifica&ccedil;&atilde;o por e-mail quando alterar o status das solicita&ccedil;&otilde;es','A'),(2121,77,1,'sys_start_timer','Ao abrir uma nova solicita&ccedil;&atilde;o iniciar o timer','A'),(2122,19,1,'sys_start_timer','When opening a new request start the timer','A'),(2123,77,1,'sys_enter_time','Obrigar o atendente a informar o tempo gasto na tarefas.','A'),(2124,19,1,'sys_enter_time','Force the attendant to report the time spent on tasks.','A'),(2125,77,1,'sys_expire_date_user_dash','N&atilde;o mostrar prazo de entrega e status no dashboard do solicitante at&eacute; que um atendente tenha assumido a solicita&ccedil;&atilde;o','A'),(2126,19,1,'sys_expire_date_user_dash','Do not show dead line status on the requester\'s dashboard until an attendant has taken over the request','A'),(2127,77,1,'ses_refresh_opertor_grid','Definir tempo de refresh do grid dos atendentes [0 = n&atilde;o atualizar], em minutos','A'),(2128,19,1,'ses_refresh_opertor_grid','Set grid refresh time for attendants [0 = do not ], in minutes','A'),(2129,77,1,'ses_request_show_phone','Mostrar n&uacute;mero de telefone, ramal e celular na solicita&ccedil;&atilde;o','A'),(2130,19,1,'ses_request_show_phone','Show phone number, extension mobile phone number in the request','A'),(2131,77,1,'sys_sort_asc','Ordenar as solicita&ccedil;&otilde;es em sentido ascendente [ASC]','A'),(2132,19,1,'sys_sort_asc','Sort requests upwards [ASC]','A'),(2133,77,1,'sys_expire_date_user_grid','N&atilde;o mostrar prazo de entrega no grid do solicitante at&eacute; que um atendente tenha assumido a solicita&ccedil;&atilde;o','A'),(2134,19,1,'sys_expire_date_user_grid','Do not show delivery time on the user\'s grid until an attendant has taken over the request','A'),(2135,77,1,'sys_show_group_view_checkbox','Ao assumir ou repassar solicita&ccedil&otildees, trazer marcada a op&ccedil&atildeo: Desejo que meu grupo continue visualizando a solicita&ccedil&atildeo','A'),(2136,19,1,'sys_show_group_view_checkbox','When accepting forwarding requests, bring the option marked: I wish my group to continue viewing the request','A'),(2137,77,1,'ses_evaluate','Quando uma solicita&ccedil;&atilde;o &eacute; aprovada pelo usu&aacute;rio, solicitar que responda o question&aacute;rio de avalia&ccedil;&atilde;o do atendimento','A'),(2138,19,1,'ses_evaluate','When a request is approved by the user, ask them to answer the service evaluation questionnaire','A'),(2139,77,1,'ses_aprove','Solicitar a aprova&ccedil;&atilde;o do usu&aacute;rio ap&oacute;s o encerramento da solicita&ccedil;&atilde;o','A'),(2140,19,1,'ses_aprove','Request user approval after request closure','A'),(2141,77,1,'sys_adm_view_request','Usu&aacute;rio administrador visualiza todas solicita&ccedil;&otilde;es','A'),(2142,19,1,'sys_adm_view_request','Admin user views all requests','A'),(2143,19,2,'Type','Type','A'),(2144,77,2,'Email_request_assumed','USU&Aacute;RIO: Notificar usu&aacuterio quando uma solicita&ccedil&atildeo for assumida.','A'),(2145,19,2,'Email_request_assumed','USER: Notify user when a request is assumed.','A'),(2146,77,2,'Email_request_finished','USU&Aacute;RIO: Notificar o usu&aacuterio quando sua solicita&ccedil&atildeo for encerrada','A'),(2147,19,2,'Email_request_finished','USER: Notify the user when their request is closed','A'),(2148,77,2,'Email_request_rejected','USU&Aacute;RIO: Notificar usu&aacuterio quando sua solicita&ccedil&atildeo for rejeitada','A'),(2149,19,2,'Email_request_rejected','USER: Notify user when their request is rejected','A'),(2150,77,2,'Email_request_evaluated','ATENDENTE: Enviar e-mail quando uma solicita&ccedil;&atilde;o for avaliada','A'),(2151,19,2,'Email_request_evaluated','OPERATOR: Send email when a request is evaluated','A'),(2152,77,2,'Email_request_apont_user','USU&Aacute;RIO: Enviar notifica&ccedil&atildeo quando for inclu&iacute;do um novo apontamento','A'),(2153,19,2,'Email_request_apont_user','USER: Send notification when a new note is added','A'),(2156,77,2,'Email_request_record','ATENDENTE: Notificar atendentes respons&aacuteveis quando uma nova solicitaÃ§&atildeo Ã© criada','A'),(2157,19,2,'Email_request_record','OPERATOR: Notify responsible operators when a new request is created','A'),(2158,77,2,'Email_request_apont_operator','ATENDENTE: Enviar notifica&ccedil&atildeo quando um novo apontamento &eacute; adicionado','A'),(2159,19,2,'Email_request_apont_operator','OPERATOR: Send notification when a new note is added','A'),(2160,77,2,'Email_request_reopened','ATENDENTE: Enviar notifica&ccedil&atildeo quando uma solita&ccedil&atildeo for reaberta','A'),(2161,19,2,'Email_request_reopened','OPERATOR: Send notification when a request is reopened','A'),(2162,77,2,'Email_request_repass','ATENDENTE: Notificar atendentes respons&aacuteveis quando uma solicita&ccedil&atildeo &eacute; repassada','A'),(2163,19,2,'Email_request_repass','OPERATOR: Notify responsible operators when a request is forwarded','A'),(2164,77,2,'Email_request_approve','ATENDENTE: Notificar atendente quando uma solita&ccedil&atildeo for aprovada','A'),(2165,19,2,'Email_request_approve','OPERATOR: Notify the attendant when a request is approved','A'),(2166,19,1,'Language_utilities','Language utilities','A'),(2167,77,1,'Language_utilities','Utilit&aacute;rios de idioma','A'),(2168,77,1,'Last_update','&Uacute;ltima atualiza&ccedil;&atilde;o','A'),(2169,19,1,'Last_update','Last','A'),(2170,19,1,'Action','Action','A'),(2171,77,1,'Action','A&ccedil;&atilde;o','A'),(2172,19,1,'Update_vocabulary','Renew Vocabulary','A'),(2173,77,1,'Update_vocabulary','Atualizar VocabulÃ¡rio','A'),(2174,19,1,'Clear_smarty_cache','Clear Smarty Cache','A'),(2175,77,1,'Clear_smarty_cache','Limpar Cache do Smarty','A');
/*!40000 ALTER TABLE `tbvocabulary` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'helpdezk1110'
--
/*!50003 DROP FUNCTION IF EXISTS `pipeFormatCnpj` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeFormatCnpj`( cnpj varchar(20)) RETURNS varchar(18) CHARSET utf8
BEGIN     DECLARE l_ret VARCHAR(18);     SET cnpj = REPLACE(cnpj,'.','');     SET cnpj = REPLACE(cnpj,'-','');     SET cnpj = REPLACE(cnpj,' ','');     SET cnpj = TRIM(cnpj);     SET l_ret = cnpj;     SET l_ret = CONCAT(MID(l_ret,1,2),'.',MID(l_ret,3,3),'.',MID(l_ret,6,3),'/',MID(l_ret,9,4),'-',MID(l_ret,13,2));     RETURN l_ret;   END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeFormatCpf` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeFormatCpf`( cpf varchar(20)) RETURNS varchar(14) CHARSET utf8
BEGIN   	DECLARE l_ret VARCHAR(14);   	SET cpf = REPLACE(cpf,'.','');   	SET cpf = REPLACE(cpf,'-','');   	SET cpf = REPLACE(cpf,' ','');   	SET cpf = TRIM(cpf);   	SET l_ret = cpf;   	SET l_ret = CONCAT(MID(l_ret,1,3),'.',MID(l_ret,4,3),'.',MID(l_ret,7,3),'-',MID(l_ret,10,2));   	RETURN l_ret;    END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeFormatCurrency` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeFormatCurrency`( timezone varchar(255),  val varchar(255)) RETURNS varchar(100) CHARSET latin1
BEGIN 	    DECLARE RET VARCHAR(100); 	    IF (timezone = 'pt_BR' ) THEN 		SET RET = ( SELECT REPLACE (REPLACE (REPLACE (FORMAT(val, 2), '.', '|'),',','.' ),'|',',' ) ); 	    ELSEIF (timezone = 'en_US' ) THEN 		SET RET = ( SELECT FORMAT (val,2) ); 	    END IF; 	    RETURN RET; 	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeFormatDate` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeFormatDate`( timezone varchar(255),  val varchar(255)) RETURNS varchar(100) CHARSET latin1
BEGIN 	    DECLARE RET VARCHAR(100); 	    IF (timezone = 'pt_BR' ) THEN 		SET RET = ( SELECT DATE_FORMAT(val, '%d/%m/%Y') ); 	    ELSEIF (timezone = 'en_US' ) THEN 		SET RET = ( SELECT DATE_FORMAT(val, '%m/%d/%Y') ); 	    END IF; 	    RETURN RET; 	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeFormatDateTime` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeFormatDateTime`( timezone varchar(255),  val varchar(255)) RETURNS varchar(100) CHARSET latin1
BEGIN 	    DECLARE RET VARCHAR(100); 	    IF (timezone = 'pt_BR' ) THEN 		SET RET = ( SELECT DATE_FORMAT(val, '%d/%m/%Y %H:%i:%S') ); 	    ELSEIF (timezone = 'en_US' ) THEN 		SET RET = ( SELECT DATE_FORMAT(val, '%m/%d/%Y %H:%i:%S' ) ); 	    END IF; 	    RETURN RET; 	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeGetAge` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeGetAge`( data_nascimento datetime) RETURNS int(11)
BEGIN     DECLARE idade INT;     DECLARE ano_atual INT;     DECLARE mes_atual INT;     DECLARE dia_atual INT;     DECLARE ano INT;     DECLARE mes INT;     DECLARE dia INT;     SET ano_atual = YEAR(CURDATE());     SET mes_atual = MONTH( CURDATE());     SET dia_atual = DAY( CURDATE());     SET ano = YEAR( data_nascimento );     SET mes = MONTH( data_nascimento );     SET dia = DAY( data_nascimento );     SET idade = ano_atual - ano;     IF( mes > mes_atual ) THEN             SET idade = idade - 1;     END IF;     IF( mes = mes_atual AND dia > dia_atual ) THEN             SET idade = idade - 1;     END IF;     RETURN idade; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeIsAddressOk` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeIsAddressOk`( id_person int(11)) RETURNS binary(1)
BEGIN    IF (SELECT count(idaddress) FROM tbaddress WHERE  idperson = id_person AND (idcity=1 OR idneighborhood=1 OR idstreet=1)) > 0  THEN     return FALSE;   else     return TRUE;   end if; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeLatinToUtf8` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeLatinToUtf8`( texto char(255)) RETURNS char(255) CHARSET latin1
RETURN CONVERT(CAST(CONVERT(texto USING  latin1) AS BINARY) USING utf8) ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeMask` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeMask`( unformatted_value bigint(20),  format_string char(32)) RETURNS char(32) CHARSET latin1
BEGIN DECLARE input_len TINYINT; DECLARE output_len TINYINT; DECLARE temp_char CHAR; SET input_len = LENGTH(unformatted_value); SET output_len = LENGTH(format_string); WHILE ( output_len > 0 ) DO   SET temp_char = SUBSTR(format_string, output_len, 1);   IF ( temp_char = '#' ) THEN     IF ( input_len > 0 ) THEN       SET format_string = INSERT(format_string, output_len, 1, SUBSTR(unformatted_value, input_len, 1));       SET input_len = input_len - 1;     ELSE       SET format_string = INSERT(format_string, output_len, 1, '0');     END IF;   END IF;   SET output_len = output_len - 1; END WHILE; RETURN format_string; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP FUNCTION IF EXISTS `pipeTableExists` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE FUNCTION `pipeTableExists`( tablename varchar(45)) RETURNS tinyint(1)
BEGIN     DECLARE existe  TINYINT(1) DEFAULT 0;     SELECT COUNT(*) INTO existe     FROM information_schema.tables      WHERE table_schema =  DATABASE()     AND table_name =  tablename;     RETURN existe; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `adm_createConfigTables` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `adm_createConfigTables`(IN prefix varchar(5))
BEGIN 		 		SET @tableCatName = CONCAT(prefix,'_tbconfig_category'); 		SET @tableConfigName = CONCAT(prefix,'_tbconfig'); 		 		 		SET @drop1 = CONCAT('DROP TABLE IF EXISTS ', @tableCatName); 		 		PREPARE stmt FROM @drop1; 		EXECUTE stmt; 		DEALLOCATE PREPARE stmt; 		 		SET @qry1 = CONCAT('CREATE TABLE ', 					@tableCatName, 				   '(idconfigcategory INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,\n\t\t\t\t\t`name` VARCHAR(250) DEFAULT NULL,\n\t\t\t\t\tsmarty VARCHAR(250) DEFAULT NULL,\n\t\t\t\t\tPRIMARY KEY (idconfigcategory),\n\t\t\t\t\tINDEX COD_CATEGORIA (idconfigcategory))' 		 		); 		 		PREPARE stmt1 FROM @qry1; 		EXECUTE stmt1; 		DEALLOCATE PREPARE stmt1; 		 		SET @drop2 = CONCAT('DROP TABLE IF EXISTS ', @tableConfigName); 		 		PREPARE stmt2 FROM @drop2; 		EXECUTE stmt2; 		DEALLOCATE PREPARE stmt2; 		 		 		SET @qry2 = CONCAT("CREATE TABLE ", 					@tableConfigName, 				   "(idconfig INT(3) UNSIGNED NOT NULL AUTO_INCREMENT,\n\t\t\t\t    `name` VARCHAR(250) DEFAULT NULL,\n\t\t\t\t    description BLOB DEFAULT NULL,\n\t\t\t\t    idconfigcategory INT(10) UNSIGNED DEFAULT NULL,\n\t\t\t\t    session_name VARCHAR(50) DEFAULT NULL,\n\t\t\t\t    field_type VARCHAR(200) DEFAULT NULL,\n\t\t\t\t    `status` CHAR(1) DEFAULT 'A',\n\t\t\t\t    smarty VARCHAR(120) NOT NULL,\n\t\t\t\t    `value` VARCHAR(200) DEFAULT NULL,\n\t\t\t\t    PRIMARY KEY (idconfig),\n\t\t\t\t    UNIQUE INDEX ",@tableConfigName,"_session_idx (session_name),\n\t\t\t\t    CONSTRAINT FK_",@tableConfigName," FOREIGN KEY (idconfigcategory)\n\t\t\t\t    REFERENCES ",@tableCatName," (idconfigcategory) ON DELETE RESTRICT ON UPDATE RESTRICT\n\t\t\t\t\t)" 		 		); 		 		PREPARE stmt3 FROM @qry2; 		EXECUTE stmt3; 		DEALLOCATE PREPARE stmt3; 		            	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `delete_all_requests` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `delete_all_requests`()
delete_request:BEGIN 		DELETE FROM hdk_tbrequest_dates  ; 		DELETE FROM hdk_tbevaluation_token; 		DELETE FROM hdk_tbrequest_times  ; 		DELETE FROM hdk_tbrequest_log  ; 		DELETE FROM hdk_tbrequest_repassed  ; 		DELETE FROM hdk_tbrequest_in_charge; 		DELETE FROM hdk_tbrequest_attachment  ; 		DELETE FROM hdk_tbrequest_change_expire ; 		DELETE FROM hdk_tbrequest  ;     END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `delete_request` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `delete_request`(IN code_ID varchar(20), OUT msg varchar(100))
delete_request:BEGIN 	DECLARE num_requests INT; 	SELECT COUNT(idrequest) INTO num_requests FROM  hdk_tbrequest WHERE code_request = code_ID; 	IF ( num_requests = 0 ) THEN 		SET msg = "Request doesn´t exist !!!" ; 		LEAVE delete_request ; 	ELSE 		DELETE FROM hdk_tbrequest_dates WHERE code_request = code_ID ; 		DELETE FROM hdk_tbevaluation_token WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest_times WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest_log WHERE cod_request = code_ID ; 		DELETE FROM hdk_tbrequest_repassed WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest_attachment WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest_change_expire WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest WHERE code_request = code_ID ; 		SET msg = "Request deleted !!!" ; 	END IF;     END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `delete_requests_for_user` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `delete_requests_for_user`(IN person_ID int(11))
delete_request:begin 	  DECLARE code_ID VARCHAR(20); 	  DECLARE no_more_rows BOOLEAN; 	  DECLARE loop_cntr INT DEFAULT 0; 	  DECLARE num_rows INT DEFAULT 0; 	  DECLARE requests_cur CURSOR FOR 	  SELECT 	     code_request 	  FROM 	     hdk_tbrequest 	  WHERE idperson_creator = person_ID ; 	  DECLARE CONTINUE HANDLER FOR NOT FOUND 	  SET no_more_rows = TRUE; 	  OPEN requests_cur; 	  select FOUND_ROWS() into num_rows; 	  the_loop: LOOP 		fetch requests_cur into code_ID; 		IF no_more_rows THEN 			CLOSE requests_cur; 			LEAVE the_loop; 		END IF; 		call delete_request(code_ID,@msg); 		SET loop_cntr = loop_cntr + 1; 	  END LOOP the_loop; 	  select loop_cntr as messsage; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `delete_user_without_requests` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `delete_user_without_requests`(IN person_ID int(11), OUT msg varchar(100))
delete_user:BEGIN 	DECLARE num_requests INT; 	DECLARE num_user INT; 	SELECT COUNT(*) INTO num_user FROM tbperson WHERE idperson = person_ID ; 	IF ( num_user = 0 ) THEN 		SET msg = "User not exists !!!" ; 		LEAVE delete_user ; 	END IF; 	IF NOT EXISTS (SELECT * FROM tbperson WHERE idperson = person_ID AND idtypeperson = 2) THEN 		SET msg = "Person exists, but is not a user  !!!" ; 		LEAVE delete_user ; 	END IF; 	SELECT COUNT(idrequest) INTO num_requests FROM  hdk_tbrequest WHERE idperson_creator = person_ID; 	IF ( num_requests = 0 ) THEN 		DELETE FROM tbaddress  WHERE idperson = person_ID ; 		DELETE FROM tbnaturalperson  WHERE idperson = person_ID ; 		DELETE FROM tbjuridicalperson  WHERE idperson = person_ID ; 		DELETE FROM hdk_tbdepartment_has_person  WHERE idperson = person_ID ; 		DELETE FROM hdk_tbconfig_user  WHERE idperson = person_ID ; 		DELETE FROM tbperson  WHERE idperson = person_ID ; 		SET msg = "User deleted !!!" ; 	ELSE 		SET msg = "User have requests - Not deleted !!!" ; 	END IF;     END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_deleteAllAreaTypeItemService` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_deleteAllAreaTypeItemService`()
BEGIN 		DELETE FROM hdk_tbrequest_dates  ; 		DELETE FROM hdk_tbevaluation_token; 		DELETE FROM hdk_tbrequest_times  ; 		DELETE FROM hdk_tbrequest_log  ; 		DELETE FROM hdk_tbrequest_repassed  ; 		DELETE FROM hdk_tbrequest_in_charge; 		DELETE FROM hdk_tbrequest_attachment  ; 		DELETE FROM hdk_tbrequest_change_expire ; 		DELETE FROM hdk_tbrequest_emailcron; 		DELETE FROM hdk_tbrequest  ;     END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_deleteAllRequests` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_deleteAllRequests`()
BEGIN 		DELETE FROM hdk_tbrequest_dates  ; 		DELETE FROM hdk_tbevaluation_token; 		DELETE FROM hdk_tbrequest_times  ; 		DELETE FROM hdk_tbrequest_log  ; 		DELETE FROM hdk_tbrequest_repassed  ; 		DELETE FROM hdk_tbrequest_in_charge; 		DELETE FROM hdk_tbrequest_attachment  ; 		DELETE FROM hdk_tbrequest_change_expire ; 		DELETE FROM hdk_tbrequest_emailcron; 		DELETE FROM hdk_tbrequest  ;     END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_deleteAreaTypeItemService` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_deleteAreaTypeItemService`(IN lista varchar(200))
BEGIN     SET @LIST=lista;  	DELETE FROM hdk_tbreason WHERE idservice IN (SELECT idservice FROM `hdk_tbcore_service` WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST)))) ; 	DELETE FROM hdk_tbgroup_has_service WHERE idservice IN (SELECT idservice FROM `hdk_tbcore_service` WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST)))) ; 	DELETE FROM hdk_tbgetemaildepartment WHERE idgetemail IN (SELECT idgetemail FROM  hdk_tbgetemail WHERE idservice IN (SELECT idservice FROM `hdk_tbcore_service` WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST))))) ; 	DELETE FROM hdk_tbgetemail WHERE idservice IN (SELECT idservice FROM `hdk_tbcore_service` WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST)))) ; 	DELETE FROM hdk_tbcore_service WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST))); 	DELETE FROM hdk_tbcore_item WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST)); 	DELETE FROM hdk_tbcore_type WHERE FIND_IN_SET(idarea,@LIST); 	DELETE FROM hdk_tbcore_area WHERE FIND_IN_SET(idarea,@LIST); END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_deleteModule` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_deleteModule`(IN moduleID int(11))
hdk_deleteModule:BEGIN 	DECLARE num_modules INT; 	SELECT COUNT(idmodule) INTO num_modules FROM  tbmodule WHERE idmodule = moduleID; 	IF ( num_modules = 0 ) THEN 		LEAVE hdk_deleteModule ; 	ELSE 		DELETE FROM `tbdefaultpermission` WHERE idprogram IN (SELECT idprogram FROM tbprogram WHERE idprogramcategory IN (SELECT idprogramcategory FROM  tbprogramcategory WHERE idmodule = moduleID)); 		DELETE FROM `tbpermission` WHERE idprogram IN (SELECT idprogram FROM tbprogram WHERE idprogramcategory IN (SELECT idprogramcategory FROM  tbprogramcategory WHERE idmodule = moduleID)); 		DELETE FROM `tbtypepersonpermission` WHERE idprogram IN (SELECT idprogram FROM tbprogram WHERE idprogramcategory IN (SELECT idprogramcategory FROM  tbprogramcategory WHERE idmodule = moduleID)); 		DELETE FROM tbprogram WHERE idprogramcategory IN (SELECT idprogramcategory FROM  tbprogramcategory WHERE idmodule = moduleID); 		DELETE FROM `tbprogramcategory` WHERE idmodule = moduleID; 		DELETE FROM `tbemail` WHERE `idmodule` = moduleID; 		DELETE FROM `tbmodule` WHERE `idmodule` = moduleID; 	END IF;		 END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_deleteNatureperson` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_deleteNatureperson`(IN personID int(11), IN flag int(11))
BEGIN 	 	   IF (flag = 1) THEN 		DELETE FROM tbjuridicalperson WHERE idperson = personID; 	   ELSE 		DELETE FROM tbnaturalperson WHERE idperson = personID; 	   END IF; 	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_deleteNote` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_deleteNote`(IN note_ID int(11))
hdk_deleteNote:BEGIN      	   	  DECLARE attach_ID VARCHAR(20); 	   	  DECLARE no_more_rows BOOLEAN; 	  DECLARE loop_cntr INT DEFAULT 0; 	  DECLARE num_rows INT DEFAULT 0; 	   	  DECLARE note_cur CURSOR FOR     SELECT        idnote_attachments      FROM       hdk_tbnote_has_attachments      WHERE idnote = note_ID ; 	   	  DECLARE CONTINUE HANDLER FOR NOT FOUND 	  SET no_more_rows = TRUE; 	   	   	  OPEN note_cur; 	  SELECT FOUND_ROWS() INTO num_rows; 	  the_loop: LOOP 		FETCH note_cur INTO attach_ID; 		IF no_more_rows THEN 			CLOSE note_cur; 			LEAVE the_loop; 		END IF; 		 		 		     DELETE FROM hdk_tbnote_has_attachments WHERE idnote_attachments = attach_ID;     DELETE FROM hdk_tbnote_attachments WHERE idnote_attachments = attach_ID;      		 		 		SET loop_cntr = loop_cntr + 1; 	  END LOOP the_loop; 	   	            DELETE FROM hdk_tbnote WHERE idnote =  note_ID ; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_insertAddress` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_insertAddress`(IN idPerson int(11), IN idCity int(11), IN idNeighborhood int(11), IN idTypeaddress int(11), IN number char(9), IN complement varchar(45), IN zipcode varchar(11), IN idTypeStreet int(11), IN nameStreet varchar(100), OUT insertId int(11))
BEGIN   CALL hdk_updateStreet(idTypeStreet,nameStreet,@output);   SET @idStreet = (SELECT @output AS idperson);   INSERT INTO tbaddress   (     idperson    ,idcity    ,idneighborhood    ,idstreet    ,idtypeaddress    ,number    ,complement    ,zipcode   )   VALUES   (     idPerson     ,idCity     ,idNeighborhood     ,@idStreet     ,idTypeaddress     ,number     ,complement     ,zipcode    );   SET insertId := LAST_INSERT_ID(); END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_insertNoteAttachments` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_insertNoteAttachments`(IN note_ID int(11), IN file_NAME varchar(255), OUT noteatt_ID int(11))
BEGIN  START TRANSACTION;    INSERT INTO hdk_tbnote_attachments (filename) VALUES  (file_NAME) ;    set noteatt_ID := LAST_INSERT_ID();    INSERT INTO hdk_tbnote_has_attachments (idnote,idnote_attachments)	VALUES (note_ID,noteatt_ID);  COMMIT; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_insertPersonPermission` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_insertPersonPermission`(IN program_ID int(11), IN person_ID int(11), IN accesstype_ID int(11), IN perm char(1))
BEGIN IF EXISTS (SELECT idpermission FROM tbpermission WHERE idprogram = program_ID AND idperson = person_ID AND idaccesstype = accesstype_ID) THEN         UPDATE           tbpermission         SET           allow = perm         WHERE idprogram    = program_ID           AND idperson = person_ID           AND idaccesstype = accesstype_ID ; ELSE         INSERT INTO tbpermission (idaccesstype, idprogram, idperson, allow)         VALUES           (             accesstype_ID,             program_ID,             person_ID,             perm           ) ; END IF; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_insertTypePersonPermission` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_insertTypePersonPermission`(IN program_ID int(11), IN typeperson_ID int(11), IN accesstype_ID int(11), IN perm char(1))
BEGIN IF EXISTS (SELECT idpermissiongroup FROM tbtypepersonpermission WHERE idprogram = program_ID AND idtypeperson = typeperson_ID AND idaccesstype = accesstype_ID) THEN         UPDATE           tbtypepersonpermission         SET           allow = perm         WHERE idprogram    = program_ID           AND idtypeperson = typeperson_ID           AND idaccesstype = accesstype_ID ; ELSE         INSERT INTO tbtypepersonpermission (idprogram, idtypeperson, idaccesstype,allow)         VALUES           (             program_ID,             typeperson_ID,             accesstype_ID,             perm           ) ; END IF; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_insUpdJuridicalPerson` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_insUpdJuridicalPerson`(IN personID int(11), IN nameIN varchar(80), IN ein_cnpjIN varchar(18), IN iestadualIN varchar(20), IN contactIN varchar(80), IN observationIN blob)
BEGIN 		 		DECLARE juridicalpersonIDTmp INT; 		 		IF EXISTS (SELECT idjuridicalperson FROM tbjuridicalperson WHERE idperson = personID) THEN 			SELECT idjuridicalperson INTO juridicalpersonIDTmp FROM tbjuridicalperson WHERE idperson = personID; 			 			UPDATE tbjuridicalperson  			   SET `name` = nameIN, 			       ein_cnpj = ein_cnpjIN, 			       iestadual = iestadualIN, 			       contact_person = contactIN, 			       observation = observationIN 			 WHERE idjuridicalperson = juridicalpersonIDTmp; 		ELSE 			INSERT INTO tbjuridicalperson (idperson, 						       `name`, 						       ein_cnpj, 						       iestadual, 						       contact_person, 						       observation) 			VALUES(personID, 			       nameIN, 			       ein_cnpjIN, 			       iestadualIN, 			       contactIN, 			       observationIN); 		END IF; 	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_insUpdNaturalPerson` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_insUpdNaturalPerson`(IN personID int(11), IN nameIN varchar(80), IN ssn_cpfIN varchar(15), IN rgIN varchar(20), IN rgoexpIN varchar(15), IN dtbirthIN date, IN motherIN varchar(80), IN fatherIN varchar(80), IN genderIN varchar(1))
BEGIN 		 		DECLARE naturalpersonIDTmp INT; 		 		IF EXISTS (SELECT idnaturalperson FROM tbnaturalperson WHERE idperson = personID) THEN 			SELECT idnaturalperson INTO naturalpersonIDTmp FROM tbnaturalperson WHERE idperson = personID; 			 			UPDATE tbnaturalperson  			   SET `name` = nameIN, 			       ssn_cpf = ssn_cpfIN, 			       rg = rgIN, 			       rgoexp = rgoexpIN, 			       dtbirth = dtbirthIN, 			       mother = motherIN, 			       father = fatherIN, 			       gender = genderIN 			 WHERE idnaturalperson = naturalpersonIDTmp; 		ELSE 			INSERT INTO tbnaturalperson (idperson, 						     `name`, 						     ssn_cpf, 						     rg, 						     rgoexp, 						     dtbirth, 						     mother, 						     father, 						     gender) 			VALUES(personID, 			       nameIN, 			       ssn_cpfIN, 			       rgIN, 			       rgoexpIN, 			       dtbirthIN, 			       motherIN, 			       fatherIN, 			       genderIN); 		END IF; 	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_insUpdPerson` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_insUpdPerson`(IN idtypeloginIN int(11), IN idtypepersonIN int(11), IN idnaturepersonIN int(11), IN idthemeIN int(11), IN person_name varchar(60), IN loginIN varchar(45), IN passwordIN varchar(45), IN emailIN varchar(45), IN dtcreateIN datetime, IN statusIN char(1), IN user_vipIN char(1), IN telephoneIN varchar(30), IN cellphoneIN varchar(30), IN branch_numberIN varchar(10), IN time_valueIN float, IN overtimeIN float, IN idcityIN int(11), IN idneighborhoodIN int(11), IN idstreetIN int(11), IN idtypestreetIN int(11), IN numberIN varchar(9), IN complementIN varchar(45), IN zipcodeIN varchar(11), IN ssn_cpfIN varchar(15), IN dtbirthIN date, IN genderIN varchar(1), IN iddepartmentIN int(11))
BEGIN 		DECLARE person_IDTmp INT; 		DECLARE naturalperson_IDTmp INT; 		DECLARE address_IDTmp INT; 		DECLARE idtmp INT; 		 		IF EXISTS (SELECT idperson FROM tbperson WHERE login = login) THEN 			SELECT idperson INTO person_IDTmp FROM tbperson WHERE login = loginIN; 			 			UPDATE 	tbperson 			   SET 	idtypelogin = idtypeloginIN, 				idtypeperson = idtypepersonIN, 				idnatureperson = idnatureIN, 				idtheme = idthemeIN, 				`name` = person_name, 				login = loginIN, 				`password` = MD5(passwordIN), 				email = emailIN, 				dtcreate = dtcreateIN, 				`status` = statusIN, 				user_vip = user_vipIN, 				phone_number = telephoneIN, 				cel_phone = cellphoneIN, 				branch_number = branch_numberIN, 				time_value = time_valueIN, 				overtime = overtimeIN 			 WHERE	idperson = person_IDTmp; 			  			 IF EXISTS (SELECT idnaturalperson FROM tbnaturalperson WHERE idperson = person_IDTmp) THEN 				SELECT idnaturalperson INTO naturalperson_IDTmp FROM tbnaturalperson WHERE idperson = person_IDTmp; 				 				UPDATE 	tbnaturalperson 				   SET 	ssn_cpf = ssn_cpfIN, 					dtbirth = dtbirthIN, 					gender = genderIN 				 WHERE	idnaturalperson = naturalperson_IDTmp; 			 ELSE 				INSERT INTO tbnaturalperson (idperson,ssn_cpf,dtbirth,gender) 				     VALUES (person_IDTmp,ssn_cpfIN,dtbirthIN,genderIN); 			 END IF; 			  			 IF EXISTS (SELECT idaddress FROM tbaddress WHERE idperson = person_IDTmp) THEN 				SELECT idaddress INTO address_IDTmp FROM tbaddress WHERE idperson = person_IDTmp; 				 				UPDATE 	tbaddress 				   SET 	idcity = idcityIN, 					idneighborhood = idneighborhoodIN, 					idstreet = idstreetIN, 					idtypeaddress = idtypestreetIN, 					number = numberIN, 					complement = complementIN, 					zipcode = zipcodeIN 				 WHERE	idaddress = address_IDTmp; 			 ELSE 				INSERT INTO tbaddress (idperson,idcity,idneighborhood,idstreet,idtypeaddress,number,complement,zipcode) 				     VALUES (person_IDTmp,idcityIN,idneighborhoodIN,idstreetIN,idtypestreetIN,numberIN,complementIN,zipcodeIN); 			 END IF; 			  			 IF EXISTS (SELECT idperson FROM hdk_tbdepartment_has_person WHERE idperson = person_IDTmp) THEN 				 				UPDATE 	hdk_tbdepartment_has_person 				   SET 	iddepartment = iddepartmentIN 				 WHERE	idperson = person_IDTmp; 			 ELSE 				INSERT INTO hdk_tbdepartment_has_person (idperson,iddepartment) 				     VALUES (person_IDTmp,iddepartmentIN); 			 END IF; 		 		ELSE 			INSERT INTO tbperson (idtypelogin,idtypeperson,idnatureperson,idtheme,`name`,login, 					      `password`,email,dtcreate,`status`,user_vip,phone_number,cel_phone, 					      branch_number,time_value,overtime) 			     VALUES (idtypeloginIN,idtypepersonIN,idnatureIN,idthemeIN,person_name,loginIN, 				     MD5(passwordIN),emailIN,dtcreateIN,statusIN,user_vipIN,telephoneIN,cellphoneIN, 				     branch_numberIN,time_valueIN,overtimeIN); 			 			SET idtmp = LAST_INSERT_ID(); 			 			INSERT INTO tbnaturalperson (idperson,ssn_cpf,dtbirth,gender) 				     VALUES (idtmp,ssn_cpfIN,dtbirthIN,genderIN);	      			 			INSERT INTO tbaddress (idperson,idcity,idneighborhood,idstreet,idtypeaddress,number,complement,zipcode) 			     VALUES (idtmp,idcityIN,idneighborhoodIN,idstreetIN,idtypestreetIN,numberIN,complementIN,zipcodeIN); 			      			INSERT INTO hdk_tbdepartment_has_person (idperson,iddepartment) 				     VALUES (idtmp,iddepartmentIN); 			 		END IF; 	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_updateAddress` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_updateAddress`(IN id_person int(11), IN id_city int(11), IN id_neighborhood int(11), IN number char(9), IN complement varchar(45), IN zipcode varchar(11), IN id_typeStreet int(11), IN name_street varchar(100))
BEGIN   CALL hdk_updateStreet(id_typeStreet,name_street,@output);   SET @id_street = (SELECT @output AS idperson);   UPDATE tbaddress      SET idcity = id_city                    ,idneighborhood = id_neighborhood       ,idstreet = @id_street                  ,number = number                       ,complement = complement               ,zipcode = zipcode                     WHERE idperson = id_person ; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_updateCity` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_updateCity`(IN stateId int(11), IN nameCity varchar(60), OUT insertId int(11))
BEGIN 		SET @id = (SELECT tbcity.idcity FROM tbcity WHERE tbcity.name = nameCity AND tbcity.idstate = stateId); 		  IF @id IS NULL THEN 		     		    INSERT INTO tbcity (idstate,`name`) VALUES (stateId, nameCity); 		    SET insertId := LAST_INSERT_ID(); 		     		  ELSE 		     		    SET insertId := @id; 		 END IF; 	END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_updateNeighborhood` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_updateNeighborhood`(IN cityId int(11), IN nameNeighborhood varchar(100), OUT insertId int(11))
BEGIN   set @id = (select tbneighborhood.idneighborhood from tbneighborhood where tbneighborhood.name = nameNeighborhood AND tbneighborhood.idcity = cityId);   IF @id IS NULL THEN          INSERT INTO tbneighborhood (idcity,name) VALUES (cityId, nameNeighborhood);     SET insertId := LAST_INSERT_ID();        ELSE          SET insertId := @id;   END IF; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hdk_updateStreet` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hdk_updateStreet`(IN idTypeStreet int(11), IN nameStreet varchar(100), OUT insertId int(11))
BEGIN   SET @id = (SELECT tbstreet.idstreet FROM tbstreet WHERE tbstreet.idtypestreet = idTypeStreet AND tbstreet.name = nameStreet );   IF @id IS NULL  THEN     INSERT INTO tbstreet (`name`, idtypestreet) VALUES (nameStreet, idTypeStreet);     SET insertId := LAST_INSERT_ID();   ELSE     SET insertId := @id;   END IF; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hkd_deleteRequestsForUser` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hkd_deleteRequestsForUser`(IN person_ID int(11))
delete_request:BEGIN 	  DECLARE code_ID VARCHAR(20); 	  DECLARE no_more_rows BOOLEAN; 	  DECLARE loop_cntr INT DEFAULT 0; 	  DECLARE num_rows INT DEFAULT 0; 	  DECLARE requests_cur CURSOR FOR 	  SELECT 	     code_request 	  FROM 	     hdk_tbrequest 	  WHERE idperson_creator = person_ID ; 	  DECLARE CONTINUE HANDLER FOR NOT FOUND 	  SET no_more_rows = TRUE; 	  OPEN requests_cur; 	  SELECT FOUND_ROWS() INTO num_rows; 	  the_loop: LOOP 		FETCH requests_cur INTO code_ID; 		IF no_more_rows THEN 			CLOSE requests_cur; 			LEAVE the_loop; 		END IF; 		CALL delete_request(code_ID,@msg); 		SET loop_cntr = loop_cntr + 1; 	  END LOOP the_loop; 	  SELECT loop_cntr AS messsage; END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 DROP PROCEDURE IF EXISTS `hkd_deleteUserWithoutRequests` */;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = latin1 */ ;
/*!50003 SET character_set_results = latin1 */ ;
/*!50003 SET collation_connection  = latin1_swedish_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
CREATE PROCEDURE `hkd_deleteUserWithoutRequests`(IN person_ID int(11), OUT msg varchar(100))
delete_user:BEGIN 	DECLARE num_requests INT; 	DECLARE num_user INT; 	SELECT COUNT(*) INTO num_user FROM tbperson WHERE idperson = person_ID ; 	IF ( num_user = 0 ) THEN 		SET msg = "User not exists !!!" ; 		LEAVE delete_user ; 	END IF; 	IF NOT EXISTS (SELECT * FROM tbperson WHERE idperson = person_ID AND idtypeperson = 2) THEN 		SET msg = "Person exists, but is not a user  !!!" ; 		LEAVE delete_user ; 	END IF; 	SELECT COUNT(idrequest) INTO num_requests FROM  hdk_tbrequest WHERE idperson_creator = person_ID; 	IF ( num_requests = 0 ) THEN 		DELETE FROM tbaddress  WHERE idperson = person_ID ; 		DELETE FROM tbnaturalperson  WHERE idperson = person_ID ; 		DELETE FROM tbjuridicalperson  WHERE idperson = person_ID ; 		DELETE FROM hdk_tbdepartment_has_person  WHERE idperson = person_ID ; 		DELETE FROM hdk_tbconfig_user  WHERE idperson = person_ID ; 		DELETE FROM tbperson  WHERE idperson = person_ID ; 		SET msg = "User deleted !!!" ; 	ELSE 		SET msg = "User have requests - Not deleted !!!" ; 	END IF;     END ;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Final view structure for view `hdk_viewnotesdata`
--

/*!50001 DROP VIEW IF EXISTS `hdk_viewnotesdata`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = latin1 */;
/*!50001 SET character_set_results     = latin1 */;
/*!50001 SET collation_connection      = latin1_swedish_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 SQL SECURITY DEFINER */
/*!50001 VIEW `hdk_viewnotesdata` AS (select `n`.`idnote` AS `idnote`,`n`.`code_request` AS `code_request`,`n`.`idperson` AS `idperson`,`p`.`name` AS `name`,`n`.`entry_date` AS `entry_date`,`n`.`execution_date` AS `execution_date`,`n`.`start_hour` AS `start_hour`,`n`.`finish_hour` AS `finish_hour`,`n`.`minutes` AS `minutes`,`n`.`idtype` AS `idtype`,`n`.`IND_CHAMADO` AS `IND_CHAMADO`,`n`.`ip_adress` AS `ip_adress`,`n`.`public` AS `public`,`n`.`hour_type` AS `hour_type`,`n`.`service_value` AS `service_value`,`n`.`callback` AS `callback`,`n`.`description` AS `description` from (`hdk_tbnote` `n` join `tbperson` `p`) where (`p`.`idperson` = `n`.`idperson`)) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;

--
-- Final view structure for view `hdk_viewrequestdata`
--

/*!50001 DROP VIEW IF EXISTS `hdk_viewrequestdata`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = latin1 */;
/*!50001 SET character_set_results     = latin1 */;
/*!50001 SET collation_connection      = latin1_swedish_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 SQL SECURITY DEFINER */
/*!50001 VIEW `hdk_viewrequestdata` AS (select `req`.`code_request` AS `code_request`,`req`.`expire_date` AS `expire_date`,`req`.`entry_date` AS `entry_date`,`req`.`flag_opened` AS `flag_opened`,`req`.`subject` AS `subject`,`req`.`idperson_owner` AS `idperson_owner`,`req`.`idperson_creator` AS `idperson_creator`,`cre`.`name` AS `name_creator`,`cre`.`phone_number` AS `phone_number`,`cre`.`cel_phone` AS `cel_phone`,`cre`.`branch_number` AS `branch_number`,`req`.`idperson_juridical` AS `idcompany`,`req`.`idsource` AS `idsource`,`req`.`extensions_number` AS `extensions_number`,`source`.`name` AS `source`,`req`.`idstatus` AS `idstatus`,`req`.`idattendance_way` AS `idattendance_way`,`req`.`os_number` AS `os_number`,`req`.`serial_number` AS `serial_number`,`req`.`label` AS `label`,`req`.`description` AS `description`,`comp`.`name` AS `company`,`stat`.`user_view` AS `status`,`rtype`.`name` AS `type`,`rtype`.`idtype` AS `idtype`,`item`.`iditem` AS `iditem`,`item`.`name` AS `item`,`serv`.`idservice` AS `idservice`,`serv`.`name` AS `service`,`prio`.`name` AS `priority`,`prio`.`idpriority` AS `idpriority`,`inch`.`ind_in_charge` AS `ind_in_charge`,`inch`.`id_in_charge` AS `id_in_charge`,`resp`.`name` AS `in_charge`,`prio`.`color` AS `color`,`pers`.`name` AS `personname`,`pers`.`email` AS `email`,`pers`.`phone_number` AS `phone`,`pers`.`branch_number` AS `branch`,`inch`.`type` AS `typeincharge`,`dep`.`name` AS `department`,`dep`.`iddepartment` AS `iddepartment`,`source`.`name` AS `source_name`,`are`.`idarea` AS `idarea`,`are`.`name` AS `AREA`,(select `reason`.`reason` from `hdk_tbcore_reason` where (`hdk_tbcore_reason`.`idreason` = `req`.`idreason`)) AS `reason`,`req`.`idreason` AS `idreason`,(select `hdk_tbattendance_way`.`way` from `hdk_tbattendance_way` where (`hdk_tbattendance_way`.`idattendanceway` = `req`.`idattendance_way`)) AS `way_name` from ((((((((((((((((`hdk_tbrequest` `req` join `tbperson` `pers`) join `tbperson` `comp`) join `tbperson` `resp`) join `tbperson` `cre`) join `hdk_tbdepartment` `dep`) join `hdk_tbcore_type` `rtype`) join `hdk_tbcore_service` `serv`) join `hdk_tbcore_area` `are`) join `hdk_tbpriority` `prio`) join `hdk_tbcore_item` `item`) join `hdk_tbstatus` `stat`) join `hdk_tbsource` `source`) join `hdk_tbdepartment_has_person` `dep_pers`) join `hdk_tbrequest_in_charge` `inch`) left join `hdk_tbreason` `reason` on((`req`.`idreason` = `reason`.`idreason`))) left join `hdk_tbgroup` `grp` on((`resp`.`idperson` = `grp`.`idperson`))) where ((`req`.`idperson_owner` = `pers`.`idperson`) and (`req`.`idperson_creator` = `cre`.`idperson`) and (`req`.`idstatus` = `stat`.`idstatus`) and (`req`.`idperson_juridical` = `comp`.`idperson`) and (`req`.`idtype` = `rtype`.`idtype`) and (`req`.`idservice` = `serv`.`idservice`) and (`req`.`idpriority` = `prio`.`idpriority`) and (`req`.`idsource` = `source`.`idsource`) and (`req`.`code_request` = `inch`.`code_request`) and (`req`.`iditem` = `item`.`iditem`) and (`dep`.`iddepartment` = `dep_pers`.`iddepartment`) and (`pers`.`idperson` = `dep_pers`.`idperson`) and (`are`.`idarea` = `rtype`.`idarea`) and (`inch`.`id_in_charge` = `resp`.`idperson`) and (`inch`.`ind_in_charge` = 1))) */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-01-25 11:07:20
