DROP PROCEDURE IF EXISTS `adm_createConfigTables` 
CREATE  PROCEDURE `adm_createConfigTables` (IN prefix varchar(5))  BEGIN 		 		SET @tableCatName = CONCAT(prefix,'_tbconfig_category'); 		SET @tableConfigName = CONCAT(prefix,'_tbconfig'); 		 		 		SET @drop1 = CONCAT('DROP TABLE IF EXISTS ', @tableCatName); 		 		PREPARE stmt FROM @drop1; 		EXECUTE stmt; 		DEALLOCATE PREPARE stmt; 		 		SET @qry1 = CONCAT('CREATE TABLE ', 					@tableCatName, 				   '(idconfigcategory INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,\n\t\t\t\t\t`name` VARCHAR(250) DEFAULT NULL,\n\t\t\t\t\tsmarty VARCHAR(250) DEFAULT NULL,\n\t\t\t\t\tPRIMARY KEY (idconfigcategory),\n\t\t\t\t\tINDEX COD_CATEGORIA (idconfigcategory))' 		 		); 		 		PREPARE stmt1 FROM @qry1; 		EXECUTE stmt1; 		DEALLOCATE PREPARE stmt1; 		 		SET @drop2 = CONCAT('DROP TABLE IF EXISTS ', @tableConfigName); 		 		PREPARE stmt2 FROM @drop2; 		EXECUTE stmt2; 		DEALLOCATE PREPARE stmt2; 		 		 		SET @qry2 = CONCAT("CREATE TABLE ", 					@tableConfigName, 				   "(idconfig INT(3) UNSIGNED NOT NULL AUTO_INCREMENT,\n\t\t\t\t    `name` VARCHAR(250) DEFAULT NULL,\n\t\t\t\t    description BLOB DEFAULT NULL,\n\t\t\t\t    idconfigcategory INT(10) UNSIGNED DEFAULT NULL,\n\t\t\t\t    session_name VARCHAR(50) DEFAULT NULL,\n\t\t\t\t    field_type VARCHAR(200) DEFAULT NULL,\n\t\t\t\t    `status` CHAR(1) DEFAULT 'A',\n\t\t\t\t    smarty VARCHAR(120) NOT NULL,\n\t\t\t\t    `value` VARCHAR(200) DEFAULT NULL,\n\t\t\t\t    PRIMARY KEY (idconfig),\n\t\t\t\t    UNIQUE INDEX ",@tableConfigName,"_session_idx (session_name),\n\t\t\t\t    CONSTRAINT FK_",@tableConfigName," FOREIGN KEY (idconfigcategory)\n\t\t\t\t    REFERENCES ",@tableCatName," (idconfigcategory) ON DELETE RESTRICT ON UPDATE RESTRICT\n\t\t\t\t\t)" 		 		); 		 		PREPARE stmt3 FROM @qry2; 		EXECUTE stmt3; 		DEALLOCATE PREPARE stmt3; 		            	END


DROP PROCEDURE IF EXISTS `delete_all_requests` 
CREATE  PROCEDURE `delete_all_requests`()  delete_request:BEGIN 		DELETE FROM hdk_tbrequest_dates  ; 		DELETE FROM hdk_tbevaluation_token; 		DELETE FROM hdk_tbrequest_times  ; 		DELETE FROM hdk_tbrequest_log  ; 		DELETE FROM hdk_tbrequest_repassed  ; 		DELETE FROM hdk_tbrequest_in_charge; 		DELETE FROM hdk_tbrequest_attachment  ; 		DELETE FROM hdk_tbrequest_change_expire ; 		DELETE FROM hdk_tbrequest  ;     END



DROP PROCEDURE IF EXISTS `delete_request` 
CREATE  PROCEDURE `delete_request` (IN code_ID varchar(20), OUT msg varchar(100))  delete_request:BEGIN 	DECLARE num_requests INT; 	SELECT COUNT(idrequest) INTO num_requests FROM  hdk_tbrequest WHERE code_request = code_ID; 	IF ( num_requests = 0 ) THEN 		SET msg = "Request doesn´t exist !!!" ; 		LEAVE delete_request ; 	ELSE 		DELETE FROM hdk_tbrequest_dates WHERE code_request = code_ID ; 		DELETE FROM hdk_tbevaluation_token WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest_times WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest_log WHERE cod_request = code_ID ; 		DELETE FROM hdk_tbrequest_repassed WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest_attachment WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest_change_expire WHERE code_request = code_ID ; 		DELETE FROM hdk_tbrequest WHERE code_request = code_ID ; 		SET msg = "Request deleted !!!" ; 	END IF;     END


DROP PROCEDURE IF EXISTS `delete_requests_for_user` 
CREATE  PROCEDURE `delete_requests_for_user` (IN person_ID int(11))  delete_request:begin 	  DECLARE code_ID VARCHAR(20); 	  DECLARE no_more_rows BOOLEAN; 	  DECLARE loop_cntr INT DEFAULT 0; 	  DECLARE num_rows INT DEFAULT 0; 	  DECLARE requests_cur CURSOR FOR 	  SELECT 	     code_request 	  FROM 	     hdk_tbrequest 	  WHERE idperson_creator = person_ID ; 	  DECLARE CONTINUE HANDLER FOR NOT FOUND 	  SET no_more_rows = TRUE; 	  OPEN requests_cur; 	  select FOUND_ROWS() into num_rows; 	  the_loop: LOOP 		fetch requests_cur into code_ID; 		IF no_more_rows THEN 			CLOSE requests_cur; 			LEAVE the_loop; 		END IF; 		call delete_request(code_ID,@msg); 		SET loop_cntr = loop_cntr + 1; 	  END LOOP the_loop; 	  select loop_cntr as messsage; END


DROP PROCEDURE IF EXISTS `delete_user_without_requests` 
CREATE  PROCEDURE `delete_user_without_requests` (IN person_ID int(11), OUT msg varchar(100))  delete_user:BEGIN 	DECLARE num_requests INT; 	DECLARE num_user INT; 	SELECT COUNT(*) INTO num_user FROM tbperson WHERE idperson = person_ID ; 	IF ( num_user = 0 ) THEN 		SET msg = "User not exists !!!" ; 		LEAVE delete_user ; 	END IF; 	IF NOT EXISTS (SELECT * FROM tbperson WHERE idperson = person_ID AND idtypeperson = 2) THEN 		SET msg = "Person exists, but is not a user  !!!" ; 		LEAVE delete_user ; 	END IF; 	SELECT COUNT(idrequest) INTO num_requests FROM  hdk_tbrequest WHERE idperson_creator = person_ID; 	IF ( num_requests = 0 ) THEN 		DELETE FROM tbaddress  WHERE idperson = person_ID ; 		DELETE FROM tbnaturalperson  WHERE idperson = person_ID ; 		DELETE FROM tbjuridicalperson  WHERE idperson = person_ID ; 		DELETE FROM hdk_tbdepartment_has_person  WHERE idperson = person_ID ; 		DELETE FROM hdk_tbconfig_user  WHERE idperson = person_ID ; 		DELETE FROM tbperson  WHERE idperson = person_ID ; 		SET msg = "User deleted !!!" ; 	ELSE 		SET msg = "User have requests - Not deleted !!!" ; 	END IF;     END


DROP PROCEDURE IF EXISTS `hdk_deleteAllAreaTypeItemService` 
CREATE  PROCEDURE `hdk_deleteAllAreaTypeItemService`()  BEGIN 		DELETE FROM hdk_tbrequest_dates  ; 		DELETE FROM hdk_tbevaluation_token; 		DELETE FROM hdk_tbrequest_times  ; 		DELETE FROM hdk_tbrequest_log  ; 		DELETE FROM hdk_tbrequest_repassed  ; 		DELETE FROM hdk_tbrequest_in_charge; 		DELETE FROM hdk_tbrequest_attachment  ; 		DELETE FROM hdk_tbrequest_change_expire ; 		DELETE FROM hdk_tbrequest_emailcron; 		DELETE FROM hdk_tbrequest  ;     END



DROP PROCEDURE IF EXISTS `hdk_deleteAllRequests` 
CREATE  PROCEDURE `hdk_deleteAllRequests`()  BEGIN 		DELETE FROM hdk_tbrequest_dates  ; 		DELETE FROM hdk_tbevaluation_token; 		DELETE FROM hdk_tbrequest_times  ; 		DELETE FROM hdk_tbrequest_log  ; 		DELETE FROM hdk_tbrequest_repassed  ; 		DELETE FROM hdk_tbrequest_in_charge; 		DELETE FROM hdk_tbrequest_attachment  ; 		DELETE FROM hdk_tbrequest_change_expire ; 		DELETE FROM hdk_tbrequest_emailcron; 		DELETE FROM hdk_tbrequest  ;     END



DROP PROCEDURE IF EXISTS `hdk_deleteNatureperson` 
CREATE  PROCEDURE `hdk_deleteNatureperson` (IN personID int(11), IN flag int(11))  BEGIN 	 	   IF (flag = 1) THEN 		DELETE FROM tbjuridicalperson WHERE idperson = personID; 	   ELSE 		DELETE FROM tbnaturalperson WHERE idperson = personID; 	   END IF; 	END


DROP PROCEDURE IF EXISTS `hdk_insertAddress` 
CREATE  PROCEDURE `hdk_insertAddress` (IN idPerson int(11), IN idCity int(11), IN idNeighborhood int(11), IN idTypeaddress int(11), IN number char(9), IN complement varchar(45), IN zipcode varchar(11), IN idTypeStreet int(11), IN nameStreet varchar(100), OUT insertId int(11))  BEGIN   CALL hdk_updateStreet(idTypeStreet,nameStreet,@output);   SET @idStreet = (SELECT @output AS idperson);   INSERT INTO tbaddress   (     idperson    ,idcity    ,idneighborhood    ,idstreet    ,idtypeaddress    ,number    ,complement    ,zipcode   )   VALUES   (     idPerson     ,idCity     ,idNeighborhood     ,@idStreet     ,idTypeaddress     ,number     ,complement     ,zipcode    );   SET insertId := LAST_INSERT_ID(); END


DROP PROCEDURE IF EXISTS `hdk_deleteAreaTypeItemService` 
CREATE  PROCEDURE `hdk_deleteAreaTypeItemService` (IN lista varchar(200))  BEGIN     SET @LIST=lista;  	DELETE FROM hdk_tbreason WHERE idservice IN (SELECT idservice FROM `hdk_tbcore_service` WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST)))) ; 	DELETE FROM hdk_tbgroup_has_service WHERE idservice IN (SELECT idservice FROM `hdk_tbcore_service` WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST)))) ; 	DELETE FROM hdk_tbgetemaildepartment WHERE idgetemail IN (SELECT idgetemail FROM  hdk_tbgetemail WHERE idservice IN (SELECT idservice FROM `hdk_tbcore_service` WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST))))) ; 	DELETE FROM hdk_tbgetemail WHERE idservice IN (SELECT idservice FROM `hdk_tbcore_service` WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST)))) ; 	DELETE FROM hdk_tbcore_service WHERE iditem IN (SELECT iditem FROM `hdk_tbcore_item` WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST))); 	DELETE FROM hdk_tbcore_item WHERE idtype IN (SELECT idtype FROM `hdk_tbcore_type` WHERE FIND_IN_SET(idarea,@LIST)); 	DELETE FROM hdk_tbcore_type WHERE FIND_IN_SET(idarea,@LIST); 	DELETE FROM hdk_tbcore_area WHERE FIND_IN_SET(idarea,@LIST); END


DROP PROCEDURE IF EXISTS `hdk_deleteModule` 
CREATE  PROCEDURE `hdk_deleteModule` (IN moduleID int(11))  hdk_deleteModule:BEGIN 	DECLARE num_modules INT; 	SELECT COUNT(idmodule) INTO num_modules FROM  tbmodule WHERE idmodule = moduleID; 	IF ( num_modules = 0 ) THEN 		LEAVE hdk_deleteModule ; 	ELSE 		DELETE FROM `tbdefaultpermission` WHERE idprogram IN (SELECT idprogram FROM tbprogram WHERE idprogramcategory IN (SELECT idprogramcategory FROM  tbprogramcategory WHERE idmodule = moduleID)); 		DELETE FROM `tbpermission` WHERE idprogram IN (SELECT idprogram FROM tbprogram WHERE idprogramcategory IN (SELECT idprogramcategory FROM  tbprogramcategory WHERE idmodule = moduleID)); 		DELETE FROM `tbtypepersonpermission` WHERE idprogram IN (SELECT idprogram FROM tbprogram WHERE idprogramcategory IN (SELECT idprogramcategory FROM  tbprogramcategory WHERE idmodule = moduleID)); 		DELETE FROM tbprogram WHERE idprogramcategory IN (SELECT idprogramcategory FROM  tbprogramcategory WHERE idmodule = moduleID); 		DELETE FROM `tbprogramcategory` WHERE idmodule = moduleID; 		DELETE FROM `tbemail` WHERE `idmodule` = moduleID; 		DELETE FROM `tbmodule` WHERE `idmodule` = moduleID; 	END IF;		 END


DROP PROCEDURE IF EXISTS `hdk_deleteNote` 
CREATE  PROCEDURE `hdk_deleteNote` (IN note_ID int(11))  hdk_deleteNote:BEGIN      	   	  DECLARE attach_ID VARCHAR(20); 	   	  DECLARE no_more_rows BOOLEAN; 	  DECLARE loop_cntr INT DEFAULT 0; 	  DECLARE num_rows INT DEFAULT 0; 	   	  DECLARE note_cur CURSOR FOR     SELECT        idnote_attachments      FROM       hdk_tbnote_has_attachments      WHERE idnote = note_ID ; 	   	  DECLARE CONTINUE HANDLER FOR NOT FOUND 	  SET no_more_rows = TRUE; 	   	   	  OPEN note_cur; 	  SELECT FOUND_ROWS() INTO num_rows; 	  the_loop: LOOP 		FETCH note_cur INTO attach_ID; 		IF no_more_rows THEN 			CLOSE note_cur; 			LEAVE the_loop; 		END IF; 		 		 		     DELETE FROM hdk_tbnote_has_attachments WHERE idnote_attachments = attach_ID;     DELETE FROM hdk_tbnote_attachments WHERE idnote_attachments = attach_ID;      		 		 		SET loop_cntr = loop_cntr + 1; 	  END LOOP the_loop; 	   	            DELETE FROM hdk_tbnote WHERE idnote =  note_ID ; END


DROP PROCEDURE IF EXISTS `hdk_insertNoteAttachments` 
CREATE  PROCEDURE `hdk_insertNoteAttachments` (IN note_ID int(11), IN file_NAME varchar(255), OUT noteatt_ID int(11))  BEGIN  START TRANSACTION;    INSERT INTO hdk_tbnote_attachments (filename) VALUES  (file_NAME) ;    set noteatt_ID := LAST_INSERT_ID();    INSERT INTO hdk_tbnote_has_attachments (idnote,idnote_attachments)	VALUES (note_ID,noteatt_ID);  COMMIT; END


DROP PROCEDURE IF EXISTS `hdk_insertPersonPermission` 
CREATE  PROCEDURE `hdk_insertPersonPermission` (IN program_ID int(11), IN person_ID int(11), IN accesstype_ID int(11), IN perm char(1))  BEGIN IF EXISTS (SELECT idpermission FROM tbpermission WHERE idprogram = program_ID AND idperson = person_ID AND idaccesstype = accesstype_ID) THEN         UPDATE           tbpermission         SET           allow = perm         WHERE idprogram    = program_ID           AND idperson = person_ID           AND idaccesstype = accesstype_ID ; ELSE         INSERT INTO tbpermission (idaccesstype, idprogram, idperson, allow)         VALUES           (             accesstype_ID,             program_ID,             person_ID,             perm           ) ; END IF; END


DROP PROCEDURE IF EXISTS `hdk_insertTypePersonPermission` 
CREATE  PROCEDURE `hdk_insertTypePersonPermission` (IN program_ID int(11), IN typeperson_ID int(11), IN accesstype_ID int(11), IN perm char(1))  BEGIN IF EXISTS (SELECT idpermissiongroup FROM tbtypepersonpermission WHERE idprogram = program_ID AND idtypeperson = typeperson_ID AND idaccesstype = accesstype_ID) THEN         UPDATE           tbtypepersonpermission         SET           allow = perm         WHERE idprogram    = program_ID           AND idtypeperson = typeperson_ID           AND idaccesstype = accesstype_ID ; ELSE         INSERT INTO tbtypepersonpermission (idprogram, idtypeperson, idaccesstype,allow)         VALUES           (             program_ID,             typeperson_ID,             accesstype_ID,             perm           ) ; END IF; END


DROP PROCEDURE IF EXISTS `hdk_updateAddress` 
CREATE  PROCEDURE `hdk_updateAddress` (IN id_person int(11), IN id_city int(11), IN id_neighborhood int(11), IN number char(9), IN complement varchar(45), IN zipcode varchar(11), IN id_typeStreet int(11), IN name_street varchar(100))  BEGIN   CALL hdk_updateStreet(id_typeStreet,name_street,@output);   SET @id_street = (SELECT @output AS idperson);   UPDATE tbaddress      SET idcity = id_city                    ,idneighborhood = id_neighborhood       ,idstreet = @id_street                  ,number = number                       ,complement = complement               ,zipcode = zipcode                     WHERE idperson = id_person ; END


DROP PROCEDURE IF EXISTS `hdk_updateCity` 
CREATE  PROCEDURE `hdk_updateCity` (IN stateId int(11), IN nameCity varchar(60), OUT insertId int(11))  BEGIN 		SET @id = (SELECT tbcity.idcity FROM tbcity WHERE tbcity.name = nameCity AND tbcity.idstate = stateId); 		  IF @id IS NULL THEN 		     		    INSERT INTO tbcity (idstate,`name`) VALUES (stateId, nameCity); 		    SET insertId := LAST_INSERT_ID(); 		     		  ELSE 		     		    SET insertId := @id; 		 END IF; 	END


DROP PROCEDURE IF EXISTS `hdk_updateNeighborhood` 
CREATE  PROCEDURE `hdk_updateNeighborhood` (IN cityId int(11), IN nameNeighborhood varchar(100), OUT insertId int(11))  BEGIN   set @id = (select tbneighborhood.idneighborhood from tbneighborhood where tbneighborhood.name = nameNeighborhood AND tbneighborhood.idcity = cityId);   IF @id IS NULL THEN          INSERT INTO tbneighborhood (idcity,name) VALUES (cityId, nameNeighborhood);     SET insertId := LAST_INSERT_ID();        ELSE          SET insertId := @id;   END IF; END


DROP PROCEDURE IF EXISTS `hdk_updateStreet` 
CREATE  PROCEDURE `hdk_updateStreet` (IN idTypeStreet int(11), IN nameStreet varchar(100), OUT insertId int(11))  BEGIN   SET @id = (SELECT tbstreet.idstreet FROM tbstreet WHERE tbstreet.idtypestreet = idTypeStreet AND tbstreet.name = nameStreet );   IF @id IS NULL  THEN     INSERT INTO tbstreet (`name`, idtypestreet) VALUES (nameStreet, idTypeStreet);     SET insertId := LAST_INSERT_ID();   ELSE     SET insertId := @id;   END IF; END


DROP FUNCTION IF EXISTS `pipeFormatCnpj` 
CREATE  FUNCTION `pipeFormatCnpj` ( cnpj varchar(20))  RETURNS varchar(18) CHARSET utf8  BEGIN     DECLARE l_ret VARCHAR(18);     SET cnpj = REPLACE(cnpj,'.','');     SET cnpj = REPLACE(cnpj,'-','');     SET cnpj = REPLACE(cnpj,' ','');     SET cnpj = TRIM(cnpj);     SET l_ret = cnpj;     SET l_ret = CONCAT(MID(l_ret,1,2),'.',MID(l_ret,3,3),'.',MID(l_ret,6,3),'/',MID(l_ret,9,4),'-',MID(l_ret,13,2));     RETURN l_ret;   END


DROP PROCEDURE IF EXISTS `hdk_insUpdJuridicalPerson` 
CREATE  PROCEDURE `hdk_insUpdJuridicalPerson` (IN personID int(11), IN nameIN varchar(80), IN ein_cnpjIN varchar(18), IN iestadualIN varchar(20), IN contactIN varchar(80), IN observationIN blob)  BEGIN 		 		DECLARE juridicalpersonIDTmp INT; 		 		IF EXISTS (SELECT idjuridicalperson FROM tbjuridicalperson WHERE idperson = personID) THEN 			SELECT idjuridicalperson INTO juridicalpersonIDTmp FROM tbjuridicalperson WHERE idperson = personID; 			 			UPDATE tbjuridicalperson  			   SET `name` = nameIN, 			       ein_cnpj = ein_cnpjIN, 			       iestadual = iestadualIN, 			       contact_person = contactIN, 			       observation = observationIN 			 WHERE idjuridicalperson = juridicalpersonIDTmp; 		ELSE 			INSERT INTO tbjuridicalperson (idperson, 						       `name`, 						       ein_cnpj, 						       iestadual, 						       contact_person, 						       observation) 			VALUES(personID, 			       nameIN, 			       ein_cnpjIN, 			       iestadualIN, 			       contactIN, 			       observationIN); 		END IF; 	END


DROP PROCEDURE IF EXISTS `hdk_insUpdNaturalPerson` 
CREATE  PROCEDURE `hdk_insUpdNaturalPerson` (IN personID int(11), IN nameIN varchar(80), IN ssn_cpfIN varchar(15), IN rgIN varchar(20), IN rgoexpIN varchar(15), IN dtbirthIN date, IN motherIN varchar(80), IN fatherIN varchar(80), IN genderIN varchar(1))  BEGIN 		 		DECLARE naturalpersonIDTmp INT; 		 		IF EXISTS (SELECT idnaturalperson FROM tbnaturalperson WHERE idperson = personID) THEN 			SELECT idnaturalperson INTO naturalpersonIDTmp FROM tbnaturalperson WHERE idperson = personID; 			 			UPDATE tbnaturalperson  			   SET `name` = nameIN, 			       ssn_cpf = ssn_cpfIN, 			       rg = rgIN, 			       rgoexp = rgoexpIN, 			       dtbirth = dtbirthIN, 			       mother = motherIN, 			       father = fatherIN, 			       gender = genderIN 			 WHERE idnaturalperson = naturalpersonIDTmp; 		ELSE 			INSERT INTO tbnaturalperson (idperson, 						     `name`, 						     ssn_cpf, 						     rg, 						     rgoexp, 						     dtbirth, 						     mother, 						     father, 						     gender) 			VALUES(personID, 			       nameIN, 			       ssn_cpfIN, 			       rgIN, 			       rgoexpIN, 			       dtbirthIN, 			       motherIN, 			       fatherIN, 			       genderIN); 		END IF; 	END


DROP PROCEDURE IF EXISTS `hdk_insUpdPerson` 
CREATE  PROCEDURE `hdk_insUpdPerson` (IN idtypeloginIN int(11), IN idtypepersonIN int(11), IN idnaturepersonIN int(11), IN idthemeIN int(11), IN person_name varchar(60), IN loginIN varchar(45), IN passwordIN varchar(45), IN emailIN varchar(45), IN dtcreateIN datetime, IN statusIN char(1), IN user_vipIN char(1), IN telephoneIN varchar(30), IN cellphoneIN varchar(30), IN branch_numberIN varchar(10), IN time_valueIN float, IN overtimeIN float, IN idcityIN int(11), IN idneighborhoodIN int(11), IN idstreetIN int(11), IN idtypestreetIN int(11), IN numberIN varchar(9), IN complementIN varchar(45), IN zipcodeIN varchar(11), IN ssn_cpfIN varchar(15), IN dtbirthIN date, IN genderIN varchar(1), IN iddepartmentIN int(11))  BEGIN 		DECLARE person_IDTmp INT; 		DECLARE naturalperson_IDTmp INT; 		DECLARE address_IDTmp INT; 		DECLARE idtmp INT; 		 		IF EXISTS (SELECT idperson FROM tbperson WHERE login = login) THEN 			SELECT idperson INTO person_IDTmp FROM tbperson WHERE login = loginIN; 			 			UPDATE 	tbperson 			   SET 	idtypelogin = idtypeloginIN, 				idtypeperson = idtypepersonIN, 				idnatureperson = idnatureIN, 				idtheme = idthemeIN, 				`name` = person_name, 				login = loginIN, 				`password` = MD5(passwordIN), 				email = emailIN, 				dtcreate = dtcreateIN, 				`status` = statusIN, 				user_vip = user_vipIN, 				phone_number = telephoneIN, 				cel_phone = cellphoneIN, 				branch_number = branch_numberIN, 				time_value = time_valueIN, 				overtime = overtimeIN 			 WHERE	idperson = person_IDTmp; 			  			 IF EXISTS (SELECT idnaturalperson FROM tbnaturalperson WHERE idperson = person_IDTmp) THEN 				SELECT idnaturalperson INTO naturalperson_IDTmp FROM tbnaturalperson WHERE idperson = person_IDTmp; 				 				UPDATE 	tbnaturalperson 				   SET 	ssn_cpf = ssn_cpfIN, 					dtbirth = dtbirthIN, 					gender = genderIN 				 WHERE	idnaturalperson = naturalperson_IDTmp; 			 ELSE 				INSERT INTO tbnaturalperson (idperson,ssn_cpf,dtbirth,gender) 				     VALUES (person_IDTmp,ssn_cpfIN,dtbirthIN,genderIN); 			 END IF; 			  			 IF EXISTS (SELECT idaddress FROM tbaddress WHERE idperson = person_IDTmp) THEN 				SELECT idaddress INTO address_IDTmp FROM tbaddress WHERE idperson = person_IDTmp; 				 				UPDATE 	tbaddress 				   SET 	idcity = idcityIN, 					idneighborhood = idneighborhoodIN, 					idstreet = idstreetIN, 					idtypeaddress = idtypestreetIN, 					number = numberIN, 					complement = complementIN, 					zipcode = zipcodeIN 				 WHERE	idaddress = address_IDTmp; 			 ELSE 				INSERT INTO tbaddress (idperson,idcity,idneighborhood,idstreet,idtypeaddress,number,complement,zipcode) 				     VALUES (person_IDTmp,idcityIN,idneighborhoodIN,idstreetIN,idtypestreetIN,numberIN,complementIN,zipcodeIN); 			 END IF; 			  			 IF EXISTS (SELECT idperson FROM hdk_tbdepartment_has_person WHERE idperson = person_IDTmp) THEN 				 				UPDATE 	hdk_tbdepartment_has_person 				   SET 	iddepartment = iddepartmentIN 				 WHERE	idperson = person_IDTmp; 			 ELSE 				INSERT INTO hdk_tbdepartment_has_person (idperson,iddepartment) 				     VALUES (person_IDTmp,iddepartmentIN); 			 END IF; 		 		ELSE 			INSERT INTO tbperson (idtypelogin,idtypeperson,idnatureperson,idtheme,`name`,login, 					      `password`,email,dtcreate,`status`,user_vip,phone_number,cel_phone, 					      branch_number,time_value,overtime) 			     VALUES (idtypeloginIN,idtypepersonIN,idnatureIN,idthemeIN,person_name,loginIN, 				     MD5(passwordIN),emailIN,dtcreateIN,statusIN,user_vipIN,telephoneIN,cellphoneIN, 				     branch_numberIN,time_valueIN,overtimeIN); 			 			SET idtmp = LAST_INSERT_ID(); 			 			INSERT INTO tbnaturalperson (idperson,ssn_cpf,dtbirth,gender) 				     VALUES (idtmp,ssn_cpfIN,dtbirthIN,genderIN);	      			 			INSERT INTO tbaddress (idperson,idcity,idneighborhood,idstreet,idtypeaddress,number,complement,zipcode) 			     VALUES (idtmp,idcityIN,idneighborhoodIN,idstreetIN,idtypestreetIN,numberIN,complementIN,zipcodeIN); 			      			INSERT INTO hdk_tbdepartment_has_person (idperson,iddepartment) 				     VALUES (idtmp,iddepartmentIN); 			 		END IF; 	END


DROP FUNCTION IF EXISTS `pipeFormatCpf` 
CREATE  FUNCTION `pipeFormatCpf` ( cpf varchar(20))  RETURNS varchar(14) CHARSET utf8  BEGIN   	DECLARE l_ret VARCHAR(14);   	SET cpf = REPLACE(cpf,'.','');   	SET cpf = REPLACE(cpf,'-','');   	SET cpf = REPLACE(cpf,' ','');   	SET cpf = TRIM(cpf);   	SET l_ret = cpf;   	SET l_ret = CONCAT(MID(l_ret,1,3),'.',MID(l_ret,4,3),'.',MID(l_ret,7,3),'-',MID(l_ret,10,2));   	RETURN l_ret;    END


DROP FUNCTION IF EXISTS `pipeFormatCurrency` 
CREATE  FUNCTION `pipeFormatCurrency` ( timezone varchar(255),  val varchar(255))  RETURNS varchar(100) CHARSET latin1  BEGIN 	    DECLARE RET VARCHAR(100); 	    IF (timezone = 'pt_BR' ) THEN 		SET RET = ( SELECT REPLACE (REPLACE (REPLACE (FORMAT(val, 2), '.', '|'),',','.' ),'|',',' ) ); 	    ELSEIF (timezone = 'en_US' ) THEN 		SET RET = ( SELECT FORMAT (val,2) ); 	    END IF; 	    RETURN RET; 	END


DROP FUNCTION IF EXISTS `pipeFormatDate` 
CREATE  FUNCTION `pipeFormatDate` ( timezone varchar(255),  val varchar(255))  RETURNS varchar(100) CHARSET latin1  BEGIN 	    DECLARE RET VARCHAR(100); 	    IF (timezone = 'pt_BR' ) THEN 		SET RET = ( SELECT DATE_FORMAT(val, '%d/%m/%Y') ); 	    ELSEIF (timezone = 'en_US' ) THEN 		SET RET = ( SELECT DATE_FORMAT(val, '%m/%d/%Y') ); 	    END IF; 	    RETURN RET; 	END


DROP FUNCTION IF EXISTS `pipeFormatDateTime` 
CREATE  FUNCTION `pipeFormatDateTime` ( timezone varchar(255),  val varchar(255))  RETURNS varchar(100) CHARSET latin1  BEGIN 	    DECLARE RET VARCHAR(100); 	    IF (timezone = 'pt_BR' ) THEN 		SET RET = ( SELECT DATE_FORMAT(val, '%d/%m/%Y %H:%i:%S') ); 	    ELSEIF (timezone = 'en_US' ) THEN 		SET RET = ( SELECT DATE_FORMAT(val, '%m/%d/%Y %H:%i:%S' ) ); 	    END IF; 	    RETURN RET; 	END


DROP FUNCTION IF EXISTS `pipeGetAge` 
CREATE  FUNCTION `pipeGetAge` ( data_nascimento datetime)  RETURNS int(11)  BEGIN     DECLARE idade INT;     DECLARE ano_atual INT;     DECLARE mes_atual INT;     DECLARE dia_atual INT;     DECLARE ano INT;     DECLARE mes INT;     DECLARE dia INT;     SET ano_atual = YEAR(CURDATE());     SET mes_atual = MONTH( CURDATE());     SET dia_atual = DAY( CURDATE());     SET ano = YEAR( data_nascimento );     SET mes = MONTH( data_nascimento );     SET dia = DAY( data_nascimento );     SET idade = ano_atual - ano;     IF( mes > mes_atual ) THEN             SET idade = idade - 1;     END IF;     IF( mes = mes_atual AND dia > dia_atual ) THEN             SET idade = idade - 1;     END IF;     RETURN idade; END


DROP PROCEDURE IF EXISTS `hkd_deleteRequestsForUser` 
CREATE  PROCEDURE `hkd_deleteRequestsForUser` (IN person_ID int(11))  delete_request:BEGIN 	  DECLARE code_ID VARCHAR(20); 	  DECLARE no_more_rows BOOLEAN; 	  DECLARE loop_cntr INT DEFAULT 0; 	  DECLARE num_rows INT DEFAULT 0; 	  DECLARE requests_cur CURSOR FOR 	  SELECT 	     code_request 	  FROM 	     hdk_tbrequest 	  WHERE idperson_creator = person_ID ; 	  DECLARE CONTINUE HANDLER FOR NOT FOUND 	  SET no_more_rows = TRUE; 	  OPEN requests_cur; 	  SELECT FOUND_ROWS() INTO num_rows; 	  the_loop: LOOP 		FETCH requests_cur INTO code_ID; 		IF no_more_rows THEN 			CLOSE requests_cur; 			LEAVE the_loop; 		END IF; 		CALL delete_request(code_ID,@msg); 		SET loop_cntr = loop_cntr + 1; 	  END LOOP the_loop; 	  SELECT loop_cntr AS messsage; END


DROP PROCEDURE IF EXISTS `hkd_deleteUserWithoutRequests` 
CREATE  PROCEDURE `hkd_deleteUserWithoutRequests` (IN person_ID int(11), OUT msg varchar(100))  delete_user:BEGIN 	DECLARE num_requests INT; 	DECLARE num_user INT; 	SELECT COUNT(*) INTO num_user FROM tbperson WHERE idperson = person_ID ; 	IF ( num_user = 0 ) THEN 		SET msg = "User not exists !!!" ; 		LEAVE delete_user ; 	END IF; 	IF NOT EXISTS (SELECT * FROM tbperson WHERE idperson = person_ID AND idtypeperson = 2) THEN 		SET msg = "Person exists, but is not a user  !!!" ; 		LEAVE delete_user ; 	END IF; 	SELECT COUNT(idrequest) INTO num_requests FROM  hdk_tbrequest WHERE idperson_creator = person_ID; 	IF ( num_requests = 0 ) THEN 		DELETE FROM tbaddress  WHERE idperson = person_ID ; 		DELETE FROM tbnaturalperson  WHERE idperson = person_ID ; 		DELETE FROM tbjuridicalperson  WHERE idperson = person_ID ; 		DELETE FROM hdk_tbdepartment_has_person  WHERE idperson = person_ID ; 		DELETE FROM hdk_tbconfig_user  WHERE idperson = person_ID ; 		DELETE FROM tbperson  WHERE idperson = person_ID ; 		SET msg = "User deleted !!!" ; 	ELSE 		SET msg = "User have requests - Not deleted !!!" ; 	END IF;     END


DROP FUNCTION IF EXISTS `pipeIsAddressOk` 
CREATE  FUNCTION `pipeIsAddressOk` ( id_person int(11))  RETURNS binary(1)  BEGIN    IF (SELECT count(idaddress) FROM tbaddress WHERE  idperson = id_person AND (idcity=1 OR idneighborhood=1 OR idstreet=1)) > 0  THEN     return FALSE;   else     return TRUE;   end if; END


DROP FUNCTION IF EXISTS `pipeLatinToUtf8` 
CREATE  FUNCTION `pipeLatinToUtf8` ( texto char(255))  RETURNS char(255) CHARSET latin1  RETURN CONVERT(CAST(CONVERT(texto USING  latin1) AS BINARY) USING utf8)


DROP FUNCTION IF EXISTS `pipeMask` 
CREATE  FUNCTION `pipeMask` ( unformatted_value bigint(20),  format_string char(32))  RETURNS char(32) CHARSET latin1  BEGIN DECLARE input_len TINYINT; DECLARE output_len TINYINT; DECLARE temp_char CHAR; SET input_len = LENGTH(unformatted_value); SET output_len = LENGTH(format_string); WHILE ( output_len > 0 ) DO   SET temp_char = SUBSTR(format_string, output_len, 1);   IF ( temp_char = '#' ) THEN     IF ( input_len > 0 ) THEN       SET format_string = INSERT(format_string, output_len, 1, SUBSTR(unformatted_value, input_len, 1));       SET input_len = input_len - 1;     ELSE       SET format_string = INSERT(format_string, output_len, 1, '0');     END IF;   END IF;   SET output_len = output_len - 1; END WHILE; RETURN format_string; END


DROP FUNCTION IF EXISTS `pipeTableExists` 
CREATE  FUNCTION `pipeTableExists` ( tablename varchar(45))  RETURNS tinyint(1)  BEGIN     DECLARE existe  TINYINT(1) DEFAULT 0;     SELECT COUNT(*) INTO existe     FROM information_schema.tables      WHERE table_schema =  DATABASE()     AND table_name =  tablename;     RETURN existe; END


