-- 
-- Database: `hcl`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]activity`
-- 

CREATE TABLE `[[dbprefix]]activity` (
  `id` int(255) NOT NULL auto_increment,
  `timestamp` int(255) default NULL,
  `operatorid` varchar(255) NOT NULL default '',
  `status` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]activity`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]assigns`
-- 

CREATE TABLE `[[dbprefix]]assigns` (
  `id` int(255) NOT NULL auto_increment,
  `departmentid` int(255) NOT NULL default '0',
  `operatorid` int(255) NOT NULL default '0',
  `poll` int(255) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]assigns`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]canned`
-- 

CREATE TABLE `[[dbprefix]]canned` (
  `id` int(255) NOT NULL auto_increment,
  `departmentid` int(255) NOT NULL default '0',
  `operatorid` int(255) NOT NULL default '0',
  `subject` varchar(255) NOT NULL default '',
  `message` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]canned`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]chat`
-- 

CREATE TABLE `[[dbprefix]]chat` (
  `id` int(255) NOT NULL auto_increment,
  `chatid` int(255) NOT NULL default '0',
  `operatorid` int(255) NOT NULL default '0',
  `timestamp` int(255) default NULL,
  `message` text NOT NULL,
  `x` char(1) NOT NULL default '',
  `operator` int(1) NOT NULL default '0',
  `guest` int(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]chat`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]cobrowse`
-- 

CREATE TABLE `[[dbprefix]]cobrowse` (
  `id` int(255) NOT NULL auto_increment,
  `chatid` int(255) NOT NULL default '0',
  `page` text NOT NULL,
  `notified` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]cobrowse`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]coforms`
-- 

CREATE TABLE `[[dbprefix]]coforms` (
  `id` int(255) NOT NULL auto_increment,
  `chatid` int(255) NOT NULL default '0',
  `receivedg` tinyint(1) NOT NULL default '0',
  `receivedo` tinyint(1) NOT NULL default '0',
  `type` text NOT NULL,
  `name` text NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]coforms`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]comarker`
-- 

CREATE TABLE `[[dbprefix]]comarker` (
  `id` int(255) NOT NULL auto_increment,
  `chatid` int(255) NOT NULL default '0',
  `x` int(255) NOT NULL default '0',
  `y` int(255) NOT NULL default '0',
  `type` varchar(255) NOT NULL default '',
  `clear` tinyint(1) NOT NULL default '0',
  `receivedg` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]comarker`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]departments`
-- 

CREATE TABLE `[[dbprefix]]departments` (
  `id` int(255) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `visible` int(1) NOT NULL default '1',
  `order` int(255) NOT NULL default '1',
  `email` varchar(255) NOT NULL default '',
  `email_host` varchar(255) NOT NULL default '',
  `email_port` int(5) NOT NULL default '25',
  `email_username` varchar(255) NOT NULL default '',
  `email_password` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]departments`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]files`
-- 

CREATE TABLE `[[dbprefix]]files` (
  `id` int(255) NOT NULL auto_increment,
  `chatid` int(255) default NULL,
  `file` blob NOT NULL,
  `type` varchar(255) NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `size` varchar(255) NOT NULL default '0 kb',
  `status` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]files`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]footprints`
-- 

CREATE TABLE `[[dbprefix]]footprints` (
  `id` int(255) NOT NULL auto_increment,
  `timestamp` int(255) default NULL,
  `chatid` int(255) NOT NULL default '0',
  `page` text NOT NULL,
  `cobrowse` tinyint(1) NOT NULL default '0',
  `current` int(1) NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `chatid` (`chatid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]footprints`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]hotpages`
-- 

CREATE TABLE `[[dbprefix]]hotpages` (
  `id` int(255) NOT NULL auto_increment,
  `page` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]hotpages`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]notes`
-- 

CREATE TABLE `[[dbprefix]]notes` (
  `id` int(255) NOT NULL auto_increment,
  `timestamp` int(255) default '0',
  `operatorid` int(255) NOT NULL default '0',
  `subject` varchar(255) NOT NULL default '',
  `message` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]notes`
-- 

INSERT INTO `[[dbprefix]]notes` VALUES (1, [[timestamp]], 1, 'Welcome to Help Center Live', 'Hi, Thanks for choosing Help Center Live. It looks like it is your first time here, so you need to start by changing your username and password. To do this, you will need to enter the System Configuration panel.<br /><br />- Click System Configuration above.<br />- Click Operators in the main menu.<br />- Click Edit on the right of Default User (admin).<br />- Fill out your information, make sure you change the username and password.<br />- Click Edit at the bottom of the form.<br /><br />You now need to create a Department using the System Configuration.<br /><br />Once you have done that, assign yourself to the department you created in the Assigns section of the System Configuration.<br /><br />Now generate the code and place it on the pages you wish to monitor.<br /><br />You are now ready to start providing live support, so click Launch Request Monitor when you Exit System Configuration.');

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]operators`
-- 

CREATE TABLE `[[dbprefix]]operators` (
  `id` int(255) NOT NULL auto_increment,
  `username` varchar(255) NOT NULL default '',
  `password` varchar(255) NOT NULL default '',
  `firstname` varchar(255) NOT NULL default '',
  `lastname` varchar(255) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `level` int(1) NOT NULL default '0',
  `timestamp` int(255) default '0',
  `autosave` int(1) NOT NULL default '1',
  `showpic` int(1) NOT NULL default '0',
  `status` int(1) NOT NULL default '0',
  `sounds` int(1) NOT NULL default '1',
  `picture` blob NOT NULL,
  `accepts` int(255) NOT NULL default '0',
  `declines` int(255) NOT NULL default '0',
  `accepts_transfer` int(255) NOT NULL default '0',
  `declines_transfer` int(255) NOT NULL default '0',
  `accepts_opchat` int(255) NOT NULL default '0',
  `declines_opchat` int(255) NOT NULL default '0',
  `initiates` int(255) NOT NULL default '0',
  `onlinetime` int(255) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]operators`
-- 

INSERT INTO `[[dbprefix]]operators` VALUES (1, '[[admin_username]]', '[[admin_pass]]', 'Default', 'User', '[[admin_email]]', 0, 0, 1, 0, 0, 1, '', 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]polling`
-- 

CREATE TABLE `[[dbprefix]]polling` (
  `id` int(255) NOT NULL auto_increment,
  `chatid` int(255) NOT NULL default '0',
  `assignid` int(255) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]polling`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]reviews`
-- 

CREATE TABLE `[[dbprefix]]reviews` (
  `id` int(255) NOT NULL auto_increment,
  `operatorid` int(255) NOT NULL default '0',
  `chatid` int(255) NOT NULL default '0',
  `transcriptid` int(255) NOT NULL default '0',
  `timestamp` int(255) NOT NULL default '0',
  `rating` int(1) NOT NULL default '0',
  `review` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]reviews`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]sessions`
-- 

CREATE TABLE `[[dbprefix]]sessions` (
  `id` int(255) NOT NULL auto_increment,
  `chatid` int(255) NOT NULL default '0',
  `assignid` int(255) default NULL,
  `departmentid` int(255) default NULL,
  `operatorid` int(255) default NULL,
  `nick` varchar(255) default NULL,
  `alert` varchar(20) NOT NULL default '',
  `timeo` int(255) NOT NULL default '0',
  `timeg` int(255) NOT NULL default '0',
  `typeo` int(255) NOT NULL default '0',
  `typeg` int(255) NOT NULL default '0',
  `transfer` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]sessions`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]stats_referrers`
-- 

CREATE TABLE `[[dbprefix]]stats_referrers` (
  `id` int(255) NOT NULL auto_increment,
  `chatid` int(255) NOT NULL default '0',
  `timestamp` int(255) NOT NULL default '0',
  `url` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]stats_referrers`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]stats_visitors`
-- 

CREATE TABLE `[[dbprefix]]stats_visitors` (
  `id` int(255) NOT NULL auto_increment,
  `timestamp` int(255) NOT NULL default '0',
  `visits` int(255) NOT NULL default '0',
  `hits` int(255) NOT NULL default '0',
  `requests` int(255) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]stats_visitors`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]system`
-- 

CREATE TABLE `[[dbprefix]]system` (
  `id` int(255) NOT NULL auto_increment,
  `timestamp` int(255) default NULL,
  `operatorid` int(255) NOT NULL default '0',
  `chatid` int(255) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]system`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]traffic`
-- 

CREATE TABLE `[[dbprefix]]traffic` (
  `id` int(255) NOT NULL auto_increment,
  `timestamp` int(255) default NULL,
  `ip` varchar(255) NOT NULL default '',
  `useragent` text,
  `hostname` varchar(255) NOT NULL default '',
  `referrer` text,
  `requests` int(255) NOT NULL default '0',
  `visits` int(255) NOT NULL default '1',
  `start` int(255) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]traffic`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `[[dbprefix]]transcripts`
-- 

CREATE TABLE `[[dbprefix]]transcripts` (
  `id` int(255) NOT NULL auto_increment,
  `timestamp` int(255) default NULL,
  `chatid` int(255) NOT NULL default '0',
  `operatorid` int(255) NOT NULL default '0',
  `departmentid` int(255) NOT NULL default '0',
  `guest` varchar(255) NOT NULL default '',
  `hostname` varchar(255) NOT NULL default '',
  `transcript` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `[[dbprefix]]transcripts`
-- 

