<?php
//Settingsarray.php

//For the language
function removephp(&$var)
{
	$var = str_replace('.php', '', $var);
}
//Here's the array...
$settingsarray = array
(
	"Security" => array
	(
		"admin_password" => array
		(
			"title" => "Administrator Password",
			"default" => "5a8dccb220de5c6775c873ead6ff2e43",
			"description" => "Your administrator password.  Please be aware that an md5sum of the md5sum of this password is visible to anyone who wants to find it, but it will be secure enough for all practical purposes.",
			"type" => "password",
			"empty" => "false"
		),
		"global_password" => array
		(
			"title" => "Global Password",
			"default" => "5a8dccb220de5c6775c873ead6ff2e43",
			"description" => "Do you want to require a password to log into this chat room?  If not, then leave this at nothing.  If so, set it to this password.  Please be aware that an md5sum of the md5sum of this password is visible to anyone who wants to find it, but it will be secure enough for all practical purposes.",
			"type" => "password"
		),
		"moderator_password" => array
		(
			"title" => "Moderator Password",
			"default" => "5a8dccb220de5c6775c873ead6ff2e43",
			"description" => "Anyone who knows this password may become a moderator at the login page.  Please be aware that an md5sum of the md5sum of this password is visible to anyone who wants to find it, but it will be secure enough for all practical purposes.",
			"type" => "password"
		)
	),
	"Database Info" => array
	(
		"db_type" => array
		(
			"title" => "Database",
			"default" => "The Hablator",
			"description" => "SQLite needs no setup, though FlatFile is slightly more compatible and MySQL is slightly faster.  If you use MySQL, make sure to edit 'db.mysql.php' to include your login information.  If you use FlatFile, make sure to change the permissions of everything in the 'db' folder to be writable by everybody.",
			"type" => "command",
			"command" => "return array('SQLite', 'FlatFile', 'MySQL');"
		),
		"db_name" => array
		(
			"title" => "Database Name",
			"default" => "hablator",
			"description" => "Normally, this does not need to change.  If you would like to install The Hablator multiple times on one server, and are using the SQLite database change this for each installation or strange things may start to happen in the future.  If you are using a MySQL database, this should be the name of your database.  In most cases, though, this does nothing whatsoever.",
			"type" => "string"
		),
	),
	"Site Information" => array
	(
		"title" => array
		(
			"title" => "Main Page Title",
			"default" => "The Hablator",
			"description" => "This is the title of the index.php page",
			"type" => "string"
		),
		"site_title" => array
		(
			"title" => "Site Title",
			"default" => "Leonard Bernstein for President",
			"description" => "The title of you web site",
			"type" => "string"
		),
		"site_url" => array
		(
			"title" => "Site URL",
			"default" => "http://BernsteinForPresident.com",
			"description" => "The url of your site (don't forget  http://)",
			"type" => "string"
		),
		"desired_language" => array
		(
			"title" => "Desired Language",
			"default" => "english.php",
			"description" => "The name the language file you wish to use.  This only translates the frontend.  Available translations can be found in the 'languages' folder.  See README.txt if you would like to make a new translation.",
			"type" => "command",
			"command" => "\$array = array_diff( scandir( 'languages' ), Array( \".\", \"..\" ) ); array_walk(\$array, 'removephp'); return \$array;" 
		)
	),
	"Logging" => array
	(
		"enable_user_logging" => array
		(
			"title" => "Enable User Logging",
			"default" => true,
			"description" => "Whether or not to log when a user logs in (the user's login name, Agent string, and IP address will be logged)",
			"type" => "bool"
		),
		"enable_history_logging" => array
		(
			"title" => "Enable History Logging",
			"default" => true,
			"description" => "When there is not enough room on the user's screen to display the complete history, do you want to delete everything that has been said or keep it in a log for the administrator to see (if he/she desires)?",
			"type" => "bool"
		)
	),
	"Username and Message Limits" => array
	(
		"enable_smileys" => array
		(
			"title" => "Enable Smileys",
			"default" => true,
			"description" => "Quite honestly, I have no idea why anyone would disable this, but I suppose if you are grumpy, stuffy, and boring, this may be a good thing for you to disable.",
			"type" => "bool"
		),
		"use_badword_filter" => array
		(
			"title" => "Use Bad Words Filter",
			"default" => false,
			"description" => "The bad word filter allows you to filter specific words.  Please note that this will have no effect unless you edit badwords.txt to contain the words you would like to filter.  One word per line, please!",
			"type" => "bool"
		),
		"badword_words" => array
		(
			"title" => "Bad Words",
			"default" => "gershwin,copland,sondheim",
			"description" => "A comma separated list of bad words to filter, if the bad word filter is enabled.",
			"type" => "string"
		),
		"username_limit" => array
		(
			"title" => "Username Character Limit",
			"default" => 0,
			"description" => "This is the maximum number of characters a username can be.  0 means no limit.",
			"type" => "int"
		),
		"message_limit" => array
		(
			"title" => "Message Character Limit",
			"default" => 0,
			"description" => "This is the maximum number of characters a message can be.  0 means no limit",
			"type" => "int"
		),

	),
	"Features" => array
	(

		"lighton" => array
		(
			"title" => "Enable Typing Light",
			"default" => true,
			"description" => "This tells The Hablator whether or not to use the feature that will flash a light on when the user is typing, so others know if any other user is typing.  This slows down the server SLIGHTLY, which is why I am providing the option to disable it.",
			"type" => "bool"
		),
		"newpost_alert" => array
		(
			"title" => "Alert on New Post",
			"default" => true,
			"description" => "When a post is displayed, an unobtrusive notification will let the user know.  This notification will be halted when the user moves the mouse.",
			"type" => "bool"
		),
		"online_features" => array
		(
			"title" => "Online Features",
			"default" => true,
			"description" => "Disable this if this server does not have Internet access.  It will disable some features (most notably translations) that require Internet access.",
			"type" => "bool"
		),
		"message_notification" => array
		(
			"title" => "New Message Notification",
			"default" => "marquee",
			"description" => "This is how users will be notified of new messages.",
			"type" => "command",
			"command" => "return array('None', 'Marquee', 'Flash', 'Dialog');" 
		),
		"allow_uploads" => array
		(
			"title" => "Allow Uploads",
			"default" => true,
			"description" => "Uploads are a very useful feature in many situations, but if you don't want people messing around with it, you can turn it off.",
			"type" => "bool"
		)
	),
	"Advanced" => array
	(
		"display_habfooter" => array
		(
			"title" => "Display Footer",
			"default" => true,
			"description" => "Whether or not to display the footer that says 'The Hablator'.  I would appreciate it if you displayed this, but it is by no means necessary",
			"type" => "bool"
		),
		"userlist_format" => array
		(
			"title" => "Userlist Format",
			"default" => "%l <b>%u</b>: %t",
			"description" => "This string tells The Hablator how to display the list of logged on users.  This uses a replacement table.  The following symbols will be replaced with the elements described below: <br />%u - The user's name <br />%t - The user's login time <br />%d - The user's login date <br />%o - The user's operating system <br />%p - The  logo for the user's operating system <br />%b - The user's browser <br />%i - The user's ip address<br />%m - Whether or not the user is a moderator <br />%l - The user's typing light",
			"type" => "string"
		),
		"logout_timeout" => array
		(
			"title" => "Logout Timeout",
			"default" => 360,
			"description" => "This is the amount of time (in seconds) to keep a user logged in after the computer stops requesting updates.  A high number is not recommended, as users will not be officially logged out until they hit the 'log out' button.",
			"type" => "int"
		),
		"upload_filetypes" => array
		(
			"title" => "Allowed Upload Filetypes",
			"default" => "doc,docx,odt,xls,xlsx,ods,ppt,pptx,odp,txt,pdf,jpg,jpeg,gif,png,mp3,ogg",
			"description" => "A comma separated list of allowed file upload types.",
			"type" => "string"
		),
		"posts_updateperiod" => array
		(
			"title" => "Posts Update Period",
			"default" => 1000,
			"description" => "This is how often the list of posted messages will be updated, in milliseconds.  The lower this number is, the slower The Hablator will run and the more stress will be put on your server.  The higher this number is, the more up-to-date the conversation will be.  1000 is the recommended value.",
			"type" => "int"
		),
		"userlist_updateperiod" => array
		(
			"title" => "Additionals Update Period",
			"default" => 10000,
			"description" => "This is how often the other dynamic features, such as the list of users and the list of topics will be updated.  The lower this number is, the slower The Hablator will run and the more stress will be put on your server.  The higher this number is, the more up-to-date the conversation will be.  10000 is the recommended value.",
			"type" => "int"
		),
		"history_lines" => array
		(
			"title" => "History Lines",
			"default" => 10,
			"description" => "How many lines of chat history would you like people to see at a time?",
			"type" => "int"
		),
		"line_height" => array
		(
			"title" => "Line Height",
			"default" => 22,
			"description" => "How high should each line be in the chat window?",
			"type" => "int"
		)
	)
);