<?php
require_once('lib/GTranslate.php');

class habtranslate extends GTranslate
{
	public function __call($name,$args)
	{
		$languages_list = explode("_to_",strtolower($name));
		if(!$this->gtranslatelanguage($languages_list[0]))
		{
			$function = $languages_list[0].'_to_en';
			$args[0] = $this->$function($args[0]);
			$languages_list[0] = 'en';
		}
		if(!$this->gtranslatelanguage($languages_list[1]))
		{
			$function = $languages_list[0].'_to_en';
			$args[0] = $this->$function($args[0]);
			$languages_list[0] = 'en';
			$function = $languages_list[0].'_to_'.$languages_list[1];
			return $this->$function($args[0]);
		}

		$string = $args[0];
		return $this->query($languages_list,$string);
	}
	public function gtranslatelanguage($language)
	{
		$language_list = $this->available_languages;

		if(!in_array($language, $language_list))
			return false;

		return true;
	}
	function en_to_ps($content) {
		//Thank you to Dougal Campbell.  This "translation" comes from
		//the Joomla! plugin "tfsjoomla".
		$patterns = array( 
				'%\bmy\b%' => 'me',
				'%\bboss\b%' => 'admiral',
				'%\bmanager\b%' => 'admiral',
				'%\b[Cc]aptain\b%' => "Cap'n",
				'%\bmyself\b%' => 'meself',
				'%\byour\b%' => 'yer',
				'%\byou\b%' => 'ye',
				'%\bfriend\b%' => 'matey',
				'%\bfriends\b%' => 'maties',
				'%\bco[-]?worker\b%' => 'shipmate',
				'%\bco[-]?workers\b%' => 'shipmates',
				'%\bpeople\b%' => 'scallywags',
				'%\bearlier\b%' => 'afore',
				'%\bold\b%' => 'auld',
				'%\bthe\b%' => "th'",
				'%\bof\b%' =>  "o'",
				"%\bdon't\b%" => "dern't",
				'%\bdo not\b%' => "dern't",
				'%\bnever\b%' => "ne'er",
				'%\bever\b%' => "e'er",
				'%\bover\b%' => "o'er",
				'%\bYes\b%' => 'Aye',
				'%\bNo\b%' => 'Nay',
				'%\bYeah\b%' => 'Aye',
				'%\byeah\b%' => 'aye',
				"%\bdon't know\b%" => "dinna",
				"%\bdidn't know\b%" => "did nay know",
				"%\bhadn't\b%" => "ha'nae",
				"%\bdidn't\b%"=>  "di'nae",
				"%\bwasn't\b%" => "weren't",
				"%\bhaven't\b%" => "ha'nae",
				'%\bfor\b%' => 'fer',
				'%\bbetween\b%' => 'betwixt',
				'%\baround\b%' => "aroun'",
				'%\bto\b%' => "t'",
				"%\bit's\b%" => "'tis",
				'%\bwoman\b%' => 'wench',
				'%\bwomen\b%' => 'wenches',
				'%\blady\b%' => 'wench',
				'%\bwife\b%' => 'lady',
				'%\bgirl\b%' => 'lass',
				'%\bgirls\b%' => 'lassies',
				'%\bguy\b%' => 'lubber',
				'%\bman\b%' => 'lubber',
				'%\bfellow\b%' => 'lubber',
				'%\bdude\b%' => 'lubber',
				'%\bboy\b%' => 'lad',
				'%\bboys\b%' => 'laddies',
				'%\bchildren\b%' => 'little sandcrabs',
				'%\bkids\b%' => 'minnows',
				'%\bhim\b%' => 'that scurvey dog',
				'%\bher\b%' => 'that comely wench',
				'%\bhim\.\b%' => 'that drunken sailor',
				'%\bHe\b%' => 'The ornery cuss',
				'%\bShe\b%' => 'The winsome lass',
				"%\bhe's\b%" => 'he be',
				"%\bshe's\b%" => 'she be',
				'%\bwas\b%' => "were bein'",
				'%\bHey\b%' => 'Avast',
				'%\bher\.\b%' => 'that lovely lass',
				'%\bfood\b%' => 'chow',
				'%\bmoney\b%' => 'dubloons',
				'%\bdollars\b%' => 'pieces of eight',
				'%\bcents\b%' => 'shillings',
				'%\broad\b%' => 'sea',
				'%\broads\b%' => 'seas',
				'%\bstreet\b%' => 'river',
				'%\bstreets\b%' => 'rivers',
				'%\bhighway\b%' => 'ocean',
				'%\bhighways\b%' => 'oceans',
				'%\binterstate\b%' => 'high sea',
				'%\bprobably\b%' => 'likely',
				'%\bidea\b%' => 'notion',
				'%\bcar\b%' => 'boat',
				'%\bcars\b%' => 'boats',
				'%\btruck\b%' => 'schooner',
				'%\btrucks\b%' => 'schooners',
				'%\bSUV\b%' => 'ship',
				'%\bairplane\b%' => 'flying machine',
				'%\bjet\b%' => 'flying machine',
				'%\bmachine\b%' => 'contraption',
				'%\bdriving\b%' => 'sailing',
				'%\bunderstand\b%' => 'reckon',
				'%\bdrive\b%' => 'sail',
				'%\bdied\b%' => 'snuffed it',
				'/ing\b/' => "in'",
				'/ings\b/' => "in's",
				// These next two do cool random substitutions
				'/(\.\s)/e' => '$this->avast("$0",1)',
				'/(\?\s)/e' => '$this->avast("$0",1)',
				'/(\!\s)/e' => '$this->avast("$0",1)'
				);
	
		// Replace the words:
		$content = $this->array_apply_regexp($patterns,$content);

		return $content;
	}
	function ps_to_en($content) {
	
		$patterns = array( 
				// Remove the cool random substitutions
				", avast" => '',
				" Ahoy!" => '',
				", and a bottle of rum" => '',
				", by Blackbeard's sword" => '',
				", by Davy Jones' locker" => '',
				" Walk the plank!" => '',
				" Aarrr!" => '',
				" Yaaarrrrr!" => '',
				", pass the grog" => '',
				", and dinna spare the whip" => '',
				", with a chest full of booty" => '',
				", and a bucket o' chum" => '',
				", we'll keel-haul ye!" => '',
				" Shiver me timbers!" => '',
				"shiver me timers" => '',
				" And hoist the mainsail!" => '',
				" And swab the deck!" => '',
				", ye scurvey dog" => '',
				" Fire the cannons!" => '',
				", to be sure" => '',
				", I'll warrant ye" => '',
				", on a dead man's chest" => '',
				" Load the cannons!" => '',
				" Prepare to be boarded!" => '',
				", I'll warrant ye" => '',
				" Ye'll be sleepin' with the fishes!" => '',
				" The sharks will eat well tonight!" => '',
				" Oho!" => '',
				" Fetch me spyglass!" => '',
				//Normal words
				'me' => 'my',
				'admiral' => 'boss',
				'Cap\'n' => "Captain",
				'cap\'n' => "captain",
				'meself' => 'myself',
				' yer' => 'your',
				' ye' => 'you',
				'matey' => 'friend',
				'maties' => 'friends',
				'shipmate' => 'co-worker',
				'shipmates' => 'co-workers',
				'scallywags' => 'people',
				'afore%' => 'earlier',
				'auld' => 'old',
				' th\'' => "the",
				' o\'' =>  "of",
				"dern't" => "don't",
				'ne\'er' => "never",
				'e\'er' => "ever",
				'o\'er' => "over",
				'Aye' => 'Yes',
				'Nay' => 'No',
				"dinna" => "don't know",
				"did nay know" => "didn't know",
				"ha'nae" => "hadn't",
				"di'nae"=>  "didn't",
				"weren't" => "wasn't",
				'fer' => 'for',
				'betwixt' => 'between',
				'aroun\'' => "around",
				' t\'' => "to",
				"'tis" => "it's",
				'wench' => 'woman',
				'wenches' => 'women',
				'lady' => 'wife',
				'lass' => 'girl',
				'lassies' => 'girls',
				'lubber' => 'guy',
				'lad' => 'boy',
				'laddies' => 'boys',
				'little sandcrabs' => 'children',
				'minnows' => 'kids',
				'that scurvey dog' => 'him',
				'that comely wench' => 'her',
				'that drunken sailor' => 'him.',
				'That ornery cuss' => 'He',
				'The winsome lass' => 'She',
				"he be" => 'he\'s',
				"she be" => 'she\'s',
				'were bein\'' => "was",
				'Avast' => 'Hey',
				'that lovely lass' => 'her.',
				'chow' => 'food',
				'dubloons' => 'money',
				'pieces of eight' => 'dollars',
				'shillings' => 'cents',
				'sea' => 'broad',
				'seas' => 'broads',
				'river' => 'street',
				'rivers' => 'streets',
				'ocean' => 'highway',
				'oceans' => 'highways',
				'high sea' => 'interstate',
				'likely' => 'probably',
				'notion' => 'idea',
				'boat' => 'car',
				'boats' => 'cars',
				'schooner' => 'truck',
				'schooners' => 'truckss',
				'ship' => 'SUV',
				'flying machine' => 'airplane',
				'contraption' => 'machine',
				'sailing' => 'driving',
				'reckon' => 'understand',
				'sail' => 'drive',
				'snuffed it' => 'died',
				"in'" => "ing",
				'in\'s' => "ings",
				//My own stuff :)
				'I be' => 'I am',
				'You be' => 'You are',
				'We be' => 'We are'
				);
	
		// Replace the words:
		$content = $this->array_replace($patterns,$content);
		//Get rid of all those yaarr's.
		$content = preg_replace('%\b[y]*[a]+[r]+[g]*[h]*\b%', 'I\'m a pirate', $content);

		return $content;
	}
	
	// support function for pirate()
	// this could probably be refactored to make it more generic, allowing
	// different filters to pass their own patterns in.
	function avast($stub = '',$chance = 5) {
		$shouts = array(
					", avast$stub",
					"$stub Ahoy!",
					", and a bottle of rum!",
					", by Blackbeard's sword$stub",
					", by Davy Jones' locker$stub",
					"$stub Walk the plank!",
					"$stub Aarrr!",
					"$stub Yaaarrrrr!",
					", pass the grog!",
					", and dinna spare the whip!",
					", with a chest full of booty$stub",
					", and a bucket o' chum$stub",
					", we'll keel-haul ye!",
					"$stub Shiver me timbers!",
					"$stub And hoist the mainsail!",
					"$stub And swab the deck!",
					", ye scurvey dog$stub",
					"$stub Fire the cannons!",
					", to be sure$stub",
					", I'll warrant ye$stub",
					", on a dead man's chest!",
					"$stub Load the cannons!",
					"$stub Prepare to be boarded!",
					", I'll warrant ye$stub",
					"$stub Ye'll be sleepin' with the fishes!",
					"$stub The sharks will eat well tonight!",
					"$stub Oho!",
					"$stub Fetch me spyglass!",
					);
					
		shuffle($shouts);
		
		return (((1 == rand(1,$chance))?array_shift($shouts):$stub) . ' ');
	}
	function array_apply_regexp($patterns,$content) {
		// Extract the values:
		$keys = array_keys($patterns);
		$values = array_values($patterns);
		
		// Replace the words:
		$content = preg_replace($keys,$values,$content);
	
		return $content;
	}
	function array_replace($patterns, $content, $switch=0) {

		if($switch == 0)
		{
			$keys = array_keys($patterns);
			$values = array_values($patterns);	
		}
		else
		{
			$values = array_keys($patterns);
			$keys = array_values($patterns);	
		}
		// Replace the words:
		$content = str_replace($keys,$values,$content);
	
		return $content;
	}
	function en_to_l3($text)
	{
		$replacements = array(
			'a' => '4',
			'b' => '6',
			'i' => '1',
			'z' => '2',
			's' => '5',
			'e' => '3',
			'q' => '9',
			'o' => '0',
			't' => '7',
			'cker' => 'xor',
			'beginner' => 'n006',
			'the' => 'teh',
			'beaten' => 'p4wn3d',
			'defeated' => '0wn3d'
			);
		$text = $this->array_replace($replacements, $text);
		return strtoupper($text);
	}
	function l3_to_en($text)
	{
		$replacements = array(
			'a' => '4',
			'b' => '6',
			'i' => '1',
			'z' => '2',
			's' => '5',
			'e' => '3',
			'q' => '9',
			'o' => '0',
			't' => '7',
			'cker' => 'xor',
			'beginner' => 'n006',
			'the' => 'teh',
			'beaten' => 'p4wn3d',
			'defeated' => '0wn3d'
			);
		$text = $this->array_replace($replacements, $text, 1);
		return strtolower($text);
	}
	function en_to_pg($text)
	{
		//Upper case (no pun intended)
		$text = preg_replace('%\b([A-Z])([a-z]*)\b%e', "strtoupper(substr('\\2', 0, 1)).substr('\\2', 1).strtolower('\\1').'ay'", $text);
		//All caps case (" ")
		$text = preg_replace('%\b([A-Z])([A-Z]*)\b%', '\2\1AY', $text);
		//Lower case (again)
		$text = preg_replace('%\b([a-z])([A-Za-z]*)\b%', '\2\1ay', $text);

		return $text;
	}
	function pg_to_en($text)
	{
		$text = preg_replace('%\b([A-Z])([a-z]*)([a-z])ay\b%e', "strtoupper('\\3').strtolower('\\1\\2')", $text);
		$text = preg_replace('%\b([A-Z]*)([A-Z])AY\b%', '\2\1', $text);
		$text = preg_replace('%\b([a-z]*)([A-Za-z])ay\b%', '\2\1', $text);

		return $text;
	}

}
?>