<?php
//The code for a SQLite database


//Table definitions
//$posttable, $userstable, $topictable, $uploadtable
$tables = array(
'posts' => 'posttable',
'users' => 'userstable',
'topics' => 'topictable',
'uploads' => 'uploadtable'
);

$posttable = array(
'POST_ID' => 'id',
'POST_TEXT' => 'text',
'POST_TIME' => 'time',
'POST_DATE' => 'date',
'POST_TIMESTAMP' => 'timestamp',
'POST_USERID' => 'userid',
'POST_TOPIC' => 'topic',
'POST_LANGUAGE' => 'language'
);

$userstable = array(
'USERS_ID' => 'id',
'USERS_NAME' => 'name',
'USERS_LOGIN_TIME' => 'login_time',
'USERS_LOGIN_DATE' => 'login_date',
'USERS_TIMESTAMP' => 'timestamp',
'USERS_OS' => 'os',
'USERS_BROWSER' => 'browser',
'USERS_IP' => 'ip',
'USERS_LAST_PING' => 'last_ping',
'USERS_FIRST_POST' => 'first_post',
'USERS_LAST_POST' => 'last_post',
'USERS_MODERATOR' => 'moderator',
'USERS_COMPAT' => 'compat',
'USERS_LANGUAGE' => 'language',
'USERS_TYPING' => 'typing'
);

$topictable = array(
'TOPIC_ID' => 'id',
'TOPIC_TITLE' => 'title',
'TOPIC_STYLE' => 'style'
);
$uploadtable = array(
'UPLOAD_ID' => 'id',
'UPLOAD_NAME' => 'name',
'UPLOAD_TITLE' => 'title',
'UPLOAD_EXTENSION' => 'extension',
);

//Define these definitions
foreach($posttable as $id => $value)
{
	define($id, $value);
}
foreach($userstable as $id => $value)
{
	define($id, $value);
}
foreach($topictable as $id => $value)
{
	define($id, $value);
}
foreach($uploadtable as $id => $value)
{
	define($id, $value);
}


$db = sqlite_open($db_name, 666);
if(!$db)
	die('SQLite Error!');

//Return an array indexed by the column headers defined in the ffabstraction arrays
function db_selectunique($dbname, $key, $value)
{
	global $db;
	$dbname = db_escapestring($dbname);
	//$key = db_escapestring($key);
	$value = db_escapestring($value);
	$query = "SELECT * FROM $dbname WHERE $key = '$value' LIMIT 1";
	//die($query);
	$result = sqlite_query($query, $db) or die(sqlite_error_string(sqlite_last_error($db)).' (from selectunique)');
	if(!$result) return;
	return sqlite_fetch_array($result);
}
//return an array of all of the sub-arrays.  The main array doesn't need a specific index, but the sub-arrays need to be indexed by the column headers defined in the ffabstraction arrays
function db_selectwhere($dbname, $wherekey, $wherecomp, $wherevalue, $orderby, $ascdesc, $limit=-1, $comparison=DEFAULT_COMPARISON)
{
	global $db;
	$dbname = db_escapestring($dbname);
	$wherekey = db_escapestring($wherekey);
	$wherevalue = db_escapestring($wherevalue);
	$query = "SELECT * FROM $dbname WHERE $wherekey $wherecomp '$wherevalue' ORDER BY $orderby $ascdesc";
	//die($query);

	if($limit != -1) $query .= " LIMIT $limit";
	$result = sqlite_query($query, $db) or die(sqlite_error_string(sqlite_last_error($db)).' (from selectwhere)');
	while(($returnarray[] = sqlite_fetch_array($result)) || array_pop($returnarray)); 
	//die(print_r($returnarray));
	return $returnarray;
}
//No return value
function db_updatewhere($dbname, $newkey, $newvalue, $wherekey, $wherecomp, $wherevalue)
{
	global $db;
	$dbname = db_escapestring($dbname);
	//$wherekey = db_escapestring($wherekey);
	$wherevalue = db_escapestring($wherevalue);
	//$newkey = db_escapestring($newkey);
	$newvalue = db_escapestring($newvalue);
	$query = "UPDATE $dbname SET $newkey = '$newvalue' WHERE $wherekey $wherecomp '$wherevalue'";
	//die($query);
	sqlite_query($query, $db) or die(sqlite_error_string(sqlite_last_error($db)).' (from updatewhere)');
}
//return an array of all of the sub-arrays.  The main array doesn't need a specific index, but the sub-arrays need to be indexed by the column headers defined in the ffabstraction arrays
function db_selectall($dbname)
{
	global $db;
	$dbname = db_escapestring($dbname);
	$query = "SELECT * FROM $dbname";
	$result = sqlite_query($query, $db) or die(sqlite_error_string(sqlite_last_error($db)).' (from selectall)');
	while(($returnarray[] = sqlite_fetch_array($result)) || array_pop($returnarray)); 
	//die(print_r($returnarray));
	return $returnarray;
}
//return nothing
function db_deletewhere($dbname, $wherekey, $wherecomp, $wherevalue, $comparison=DEFAULT_COMPARISON)
{
	global $db;
	$dbname = db_escapestring($dbname);
	$wherekey = db_escapestring($wherekey);
	$wherevalue = db_escapestring($wherevalue);
	$query = "DELETE FROM $dbname WHERE $wherekey $wherecomp '$wherevalue'";
	//die($query);
	sqlite_query($query, $db) or die(sqlite_error_string(sqlite_last_error($db)).' (from deletewhere)');
}
//return nothing
function db_insertautoid($dbname, $idkey, $insert)
{
	db_insert($dbname, $insert);
}
//return nothing
function db_insert($dbname, $insert)
{
	global $db;
	$dbname = db_escapestring($dbname);
	//$insert = db_escapestring($insert);
	//die(print_r($insert));

	//ugly hack for now
	if($dbname == 'posts')
		unset($insert[POST_ID]);
	else if($dbname == 'uploads')
		unset($insert[UPLOAD_ID]);

	foreach($insert as $key => $insertvalue)
	{
		$insert[$key] = db_escapestring($insertvalue);
	}

	$keys = array_keys($insert);
	$values = array_values($insert);

	if(is_array($insert))
	{
		$keys = implode(", ", $keys);
		$values = implode("', '", $values);
	}
	$query = "INSERT INTO $dbname ($keys) VALUES('$values')";
	//die($query);
	sqlite_query($query, $db) or die(sqlite_error_string(sqlite_last_error($db)).' (from insert)');
}
//return nothing
function db_deleteall($dbname)
{
	global $db;
	$dbname = db_escapestring($dbname);
	$query = "DELETE * FROM $dbname";
}
//Gets the most recent auto-id inserted
function db_lastid()
{
	$newposts = db_selectwhere('posts', POST_ID, '>', '-1', POST_ID, 'DESC');
	//echo $newposts[0][POST_ID];
	return $newposts[0][POST_ID];
}
//return nothing, not needed for all dbs
function db_maketable($table, $tablename, $autoinc=false)
{
	global $database_name, $db;
	array_shift($table);
	$tables = implode($table, "\" TEXT, \"");

	//$sql = "CREATE TABLE `$database_name`.`posts` (
	//`idfield` INT NOT NULL AUTO_INCREMENT ,
	//PRIMARY KEY ( `idfield` )
	//)";
	$autoinc = ($autoinc) ? 'AUTOINCREMENT' : '';
	$type1 = ($autoinc) ? 'INTEGER' : 'VARCHAR(50)';

	$query = "CREATE TABLE \"$tablename\" (
	\"id\" $type1 $autoinc,
	\"$tables\" TEXT,
	PRIMARY KEY (\"id\")
	)";
	//die($query);
	//CREATE TABLE `db`.`table` (
	//`field1` INT NOT NULL AUTO_INCREMENT ,
	//`field2` TEXT,
	//`field3` TEXT,
	//`field4` TEXT,
	//PRIMARY KEY ( `field1` )
	//)
	//die($query);

	sqlite_exec($query, $db);


}
//May not be needed for some DBs
function db_escapestring($string)
{
//	$string = str_replace("'", "\'", $string);
	$string = sqlite_escape_string($string);
	return $string;
}
//Sets up the DB.  This may be empty for some DBs.
function db_init()
{
	global $posttable, $userstable, $topictable, $uploadtable, $database_name, $db;


	$query = sqlite_query($db, "SELECT name FROM sqlite_master WHERE type='table'");
	$tables = sqlite_fetch_array($query);
	if($tables == null)
	{
		db_maketable($posttable, 'posts', true);
		db_maketable($userstable, 'users', false);
		db_maketable($topictable, 'topics', false);
		db_maketable($uploadtable, 'uploads', true);
		postalert('Welcome to The Hablator');
	}
}
/*
	$keys = array_keys($insert);
	$values = array_values($insert);
	if(is_array($insert))
	{
		$keys = implode(", ", $keys);
		$values = implode("', '", $values);
	}
	try
	{
		$queryupdate
		foreach($insert as $key => $value)
		{
			if($queryupdate) $queryupdate .= ',';
			$queryupdate .= "$key = $value";
		}
		$query = "UPDATE $dbname SET $queryupdate";
	}
*/
?>