<?php
//Funtions for a flatfile database
require_once('lib/flatfile.php');

//Table definitions
//$posttable, $userstable, $topictable, $uploadtable
$tables = array(
'posts' => 'posttable',
'users' => 'userstable',
'topics' => 'topictable',
'uploads' => 'uploadtable'
);

$posttable = array(
'POST_ID' => '0',
'POST_TEXT' => '1',
'POST_TIME' => '2',
'POST_DATE' => '3',
'POST_TIMESTAMP' => '4',
'POST_USERID' => '5',
'POST_TOPIC' => '6',
'POST_LANGUAGE' => '7'
);

$userstable = array(
'USERS_ID' => '0',
'USERS_NAME' => '1',
'USERS_LOGIN_TIME' => '2',
'USERS_LOGIN_DATE' => '3',
'USERS_TIMESTAMP' => '4',
'USERS_OS' => '5',
'USERS_BROWSER' => '6',
'USERS_IP' => '7',
'USERS_LAST_PING' => '8',
'USERS_FIRST_POST' => '9',
'USERS_LAST_POST' => '10',
'USERS_MODERATOR' => '11',
'USERS_COMPAT' => '12',
'USERS_LANGUAGE' => '13',
'USERS_TYPING' => '14'
);

$topictable = array(
'TOPIC_ID' => '0',
'TOPIC_TITLE' => '1',
'TOPIC_STYLE' => '2'
);
$uploadtable = array(
'UPLOAD_ID' => '0',
'UPLOAD_NAME' => '1',
'UPLOAD_TITLE' => '2',
'UPLOAD_EXTENSION' => '3',
);

//Define these definitions
foreach($posttable as $id => $value)
{
	define($id, $value);
}
foreach($userstable as $id => $value)
{
	define($id, $value);
}
foreach($topictable as $id => $value)
{
	define($id, $value);
}
foreach($uploadtable as $id => $value)
{
	define($id, $value);
}


$db = new Flatfile();
$db->datadir='db/';
function db_selectunique($dbname, $key, $value)
{
	global $db;
	return $db->selectUnique($dbname.'.txt', $key, $value);
}
function db_selectwhere($dbname, $wherekey, $wherecomp, $wherevalue, $orderby, $ascdesc, $limit=-1, $comparison=DEFAULT_COMPARISON)
{
	global $db;
	if($ascdesc == 'ASC') $ascdesc = ASCENDING;
	if($ascdesc == 'DESC') $ascdesc = DESCENDING;
	return $db->selectwhere($dbname.'.txt', new SimpleWhereClause($wherekey, $wherecomp, $wherevalue, $comparison), $limit, new OrderBy($orderby, $ascdesc));
}
function db_updatewhere($dbname, $newkey, $newvalue, $wherekey, $wherecomp, $wherevalue)
{
	global $db;
	return $db->updateSetWhere($dbname.'.txt', array($newkey => $newvalue), new SimpleWhereClause($wherekey, $wherecomp, $wherevalue));
}
function db_selectall($dbname)
{
	global $db;
	return $db->selectAll($dbname.'.txt');
}
function db_deletewhere($dbname, $wherekey, $wherecomp, $wherevalue, $comparison=DEFAULT_COMPARISON)
{
	global $db;
	return $db->deleteWhere($dbname.'.txt', new SimpleWhereClause($wherekey, $wherecomp, $wherevalue, $comparison));
}
function db_insertautoid($dbname, $idkey, $insert)
{
	global $db;
	return $db->insertWithAutoId($dbname.'.txt', $idkey, $insert);
}
function db_insert($dbname, $insert)
{
	global $db;
	return $db->insert($dbname.'.txt', $insert);
}
function db_deleteall($dbname)
{
	global $db;
	return $db->deleteAll($dbname.'.txt');
}
function db_lastid()
{
	$newposts = db_selectall('posts');
	return (string)count($newposts);
}
function db_init()
{
}
?>