<?php
require('db.php');
require_once('settings.php');


//Null password
define('NO_PASSWORD', '74be16979710d4c4e7c6647856088456');



//Our global flatfile object

session_start();


$languages = array(
	"en" => "English (none)",
	"sq" => "Albanian",
	"ar" => "Arabic",
	"bg" => "Bulgarian",
	"ca" => "Catalan",
	"zh-CN" => "Chinese",
	"hr" => "Croatian",
	"cs" => "Czech",
	"da" => "Danish",
	"nl" => "Dutch",
	"et" => "Estonian",
	"tl" => "Filipino",
	"fi" => "Finnish",
	"fr" => "French",
	"gl" => "Galician",
	"de" => "German",
	"el" => "Greek",
	"iw" => "Hebrew",
	"hi" => "Hindi",
	"hu" => "Hungarian",
	"id" => "Indonesian",
	"it" => "Italian",
	"ja" => "Japanese",
	"ko" => "Korean",
	"lv" => "Latvian",
	"l3" => "Leet",
	"lt" => "Lithuanian",
	"mt" => "Maltese",
	"no" => "Norwegian",
	"pg" => "Pig Latin",
	"ps" => "Pirate",
	"pl" => "Polish",
	"pt" => "Portuguese",
	"ro" => "Romanian",
	"ru" => "Russian",
	"sr" => "Serbian",
	"sk" => "Slovak",
	"sl" => "Slovenian",
	"es" => "Spanish",
	"sv" => "Swedish",
	"th" => "Thai",
	"tr" => "Turkish",
	"uk" => "Ukrainian",
	"vi" => "Vietnamese",
);

//POST FUNCTIONS!!!


//Returns the assigned username. Wait... that's a dumb thing to return.  Never mind.
//Note to self: used to echo, now returns
function post($text, $topic=1)
{
	if($text !== '' && idtouser(md5(session_id())) != null)
	{
		session_start();
		if($text === '0') $text = '&#48;';
		$newpost[POST_ID] = '0';
		$newpost[POST_TEXT] = $text;
		$newpost[POST_TIME] = date('h:i A');
		$newpost[POST_DATE] = date('m/d/Y');
		$newpost[POST_TIMESTAMP] = vsprintf("%d.%d", gettimeofday());
		$newpost[POST_USERID] = md5(session_id());
		$newpost[POST_TOPIC] = $topic;
		$newpost[POST_LANGUAGE] = getlanguage();

		db_insertautoid('posts', POST_ID, $newpost);

		return (string)'0';
	}
	else if(md5(session_id()) == null) return (string)'1';
}
//Checks whether new posts are available
function checkposts()
{
	session_start();
	$newposts = '';

	//Translation
	$userlanguage = getlanguage();
	//echo getlastpost();


	$newposts = db_selectwhere('posts', POST_ID, '>', getlastpost(), POST_TIMESTAMP, 'DESC', -1, NUMERIC_COMPARISON);

	if(sizeof($newposts) != 0)
	{

		$size = sizeof($newposts);
		require_once('settings.php');

		foreach ($newposts as $key => $post)
		{
			//echo $post[POST_TEXT];
			$isme = false;
			if(substr($post[POST_TEXT], 0, 4) == '/me ')
			{
				$post[POST_TEXT] = substr($post[POST_TEXT], 3);
				$isme = true;
			}
			$username = idtouser($post[POST_USERID]);
			if(!$username) 
				$username = language('language_expired');
			$posttext = ($userlanguage == $post[POST_LANGUAGE]) ? $post[POST_TEXT] : translate($post[POST_TEXT], $post[POST_LANGUAGE], $userlanguage, $trans);
			$posttopic = $post[POST_TOPIC];
			if(!$posttopic) $posttopic = 1;
			$poststyle = getstyle($post[POST_TOPIC]);
			if($post[POST_USERID] == -1) 
				echo "<div><i>$posttext</i></div>\n";
			else if($isme) 
				echo "<b><div class=\"topic$posttopic\" style=\" $poststyle\">$username ".$posttext."</div></b>\n";
			else if($post[POST_USERID] == md5(session_id())) 
				echo "<div class=\"topic$posttopic\"><b style=\"color: #666666;\">$username</b>:&nbsp;<span  style=\"$poststyle\">$posttext</span></div>\n";
			else 
				echo "<div class=\"topic$posttopic\"><b>$username</b>:&nbsp;<span style=\"$poststyle\">$posttext</span></div>\n";
		}
		setlastpost();

	}

	//If they post, don't log them out!
	setlastping();
}
function purgeoldposts()
{
	$all = db_selectall('users');
	if($all == null)
		db_deleteall('posts');
}
function postalert($text)
{
	global $desired_language;
	if($text != '')
	{
		$newpost[POST_ID] = '0';
		$newpost[POST_TEXT] = $text;
		$newpost[POST_TIME] = date('h:i A');
		$newpost[POST_DATE] = date('m/d/Y');
		$newpost[POST_TIMESTAMP] = vsprintf("%d.%d", gettimeofday());
		$newpost[POST_USERID] = '-1';
		$newpost[POST_TOPIC] = '1';
		$newpost[POST_LANGUAGE] = $desired_language;

		db_insertautoid('posts', POST_ID, $newpost);
	}
}
/*function getcurrentpost()
{
	$newposts = db_selectall('posts');
	echo $newposts[1][POST_ID];
	return (string)count($newposts);
}*/
function getcurrentpost()
{
	return db_lastid();
}

//USER FUNCTIONS!!!


//Returns the final user ID
function adduser($desired_username, $moderator=0)
{
	//next line newly added... needed?
	session_start();
	require_once('lib/browser_detection.php');
	$all = db_selectall('users');
	if(db_selectunique('users', USERS_NAME, $desired_username) != null)
	{
		$i = '1';
		while(db_selectunique('users', USERS_NAME, $desired_username.$i) != null)
			$i++;
		$desired_username = $desired_username.$i;
	}
	$language = (convertlanguage($_POST['lang'])) ? $_POST['lang'] : 'en';
	$browser = new Browser;
	$newuser[USERS_ID] = md5(session_id());
	$newuser[USERS_NAME] = $desired_username;
	$newuser[USERS_LOGIN_TIME] = date('h:i A');
	$newuser[USERS_LOGIN_DATE] = date('m/d/Y');
	$newuser[USERS_TIMESTAMP] = time();
	$newuser[USERS_OS] = $browser->Platform;
	$newuser[USERS_BROWSER] = $browser->Name;
	$newuser[USERS_IP] = $_SERVER['REMOTE_ADDR'];
	$newuser[USERS_LAST_PING] = vsprintf("%d.%d", gettimeofday());
	$newuser[USERS_FIRST_POST] = getcurrentpost();
	$newuser[USERS_LAST_POST] = getcurrentpost();
	$newuser[USERS_MODERATOR] = $moderator;
	$newuser[USERS_COMPAT] = ($_POST['compatibility']) ? '1' : '0'; 
	$newuser[USERS_LANGUAGE] = $language;
	db_insert('users', $newuser);
	return session_id();
}

function removeuser($userid)
{
	db_deletewhere('users', USERS_ID, '=', $userid, INTEGER_COMPARISON);
}

function idtouser($id)
{
	$userrow = db_selectunique('users', USERS_ID, $id);
	if ($id == -1)
		return 'System';
	else if($userrow[USERS_NAME] != "") return $userrow[USERS_NAME];
}

function usertoid($username)
{
	$userrow = db_selectunique('users', USERS_NAME, $username);
	return $userrow[USERS_ID];
}

function setlastping()
{
	db_updatewhere('users', USERS_LAST_PING, vsprintf("%d.%d", gettimeofday()), USERS_ID, '=', md5(session_id()));
}

function getlastping()
{
	$userrow = db_selectunique('users', USERS_ID, md5(session_id()));
	return $userrow[USERS_LAST_PING];
}

function loadusers()
{
	include('settings.php');
	$userrows = db_selectall('users');
	$symbols = array('%u', '%t', '%d', '%o', '%p', '%b', '%i', '%m', '%l');
	$ismoderator = ismoderator();
	foreach($userrows as $userrow)
	{
		$usersos = $userrow[USERS_OS];
		if(strpos($usersos, 'Windows') !== false)
			$ospic = 'img/windows.gif';
		else if(strpos($usersos, 'Mac') !== false)
			$ospic = 'img/mac.gif';
		else if(strpos($usersos, 'Linux') !== false)
			$ospic = 'img/gnulinux.gif';
		else if(strpos($usersos, 'BSD') !== false)
			$ospic = 'img/bsd.gif';
		else if(strpos($usersos, 'Wii') !== false)
			$ospic = 'img/wii.gif';
		else
			$ospic = 'img/unknown.gif';
		$moderator = ($userrow[USERS_MODERATOR]) ? '<img src=\'img/mod.gif\' title=\'Moderator\' />' : '';
		$replacements = array($userrow[USERS_NAME], $userrow[USERS_LOGIN_TIME], $userrow[USERS_LOGIN_DATE], $userrow[USERS_OS], "<img src='$ospic' />", $userrow[USERS_BROWSER], $userrow[USERS_IP], $moderator, "<img src=\"img/off.gif\" id=\"typing{$userrow[USERS_ID]}\" name=\"typing{$userrow[USERS_ID]}\" class=\"typinglight\">");

		if(!$lighton)
			$userlist_format = str_replace('%l', '', $userlist_format);
		if($ismoderator)
			echo str_replace($symbols, $replacements, $userlist_format)." <a href=\"#\" onclick=\"logout_user('{$userrow[USERS_ID]}')\"><img src=\"img/x.gif\" title=\"Log out\" /></a> <br />\n";
		else
			echo str_replace($symbols, $replacements, $userlist_format)." <br />\n";
	}
}
function purgeoldusers()
{
	include('settings.php');
	db_deleteWhere('users', USERS_LAST_PING, '<', time() - $logout_timeout, NUMERIC_COMPARISON);
}
function updatesession()
{
	require('settings.php');
	//Note to self: this was below as well  || $_SESSION['sessionlastping'] == null and it used $_session[lastping]
	if(getlastping() + $logout_timeout < time() || session_id() == '')
	{
		return false;
	}
	else 
	{
		$_SESSION['sessionlastping'] = time();
		return true;
	}
}
//Note to self; was a part of below function def: $post='LAST'
function getlastpost()
{
	$userrow = db_selectunique('users', USERS_ID, md5(session_id()));
	//die(print_r($userrow));
	return $userrow[USERS_LAST_POST];
}
function getfirstpost()
{
	$userrow = db_selectunique('users', USERS_ID, md5(session_id()));
	//setlastpost();
	return $userrow[USERS_FIRST_POST];
}
function setlastpost()
{
	db_updatewhere('users', USERS_LAST_POST, getcurrentpost(), USERS_ID, '=', md5(session_id()));
}
function ismoderator()
{
	$userrow = db_selectunique('users', USERS_ID, md5(session_id()));
	//setlastpost();
	return $userrow[USERS_MODERATOR];
}
function moderatorshow($string)
{
	if(ismoderator())
		eval("$string();");
	else
		echo '';
}
function iscompat()
{
	$userrow = db_selectunique('users', USERS_ID, md5(session_id()));
	//setlastpost();
	return $userrow[USERS_COMPAT];
}
function getlanguage()
{
	$userrow = db_selectunique('users', USERS_ID, md5(session_id()));
	//setlastpost();
	return $userrow[USERS_LANGUAGE];
}
function loggedin()
{
	$userrow = db_selectunique('users', USERS_ID, md5(session_id()));
	return ($userrow) ? true : false;
}

function settyping($istyping)
{
	db_updatewhere('users', USERS_TYPING, (int)$istyping, USERS_ID, '=', md5(session_id()));
}
function gettypingstring()
{
	$users = db_selectall('users');
	$result = '';
	foreach($users as $user)
	{
		if($user[USERS_TYPING])
			$result .= $user[USERS_ID];
	}
	return $result;
}
function getusercount()
{
	return count(db_selectall('users'));
}

//TOPIC FUNCTIONS!!!


function printtopics()
{
	$topicrows = db_selectall('topics');
	$ismoderator = ismoderator();

	echo "<input type=\"radio\" name=\"topic\" id=\"topic1\" value=\"1\" checked=\"yes\" /><label for=\"topic1\">".language('language_default')."</label> \n<div class=\"hide\"><input type=\"checkbox\" name=\"hidetopic1\" id=\"hidetopic1\" onchange=\"topichide('1')\" />".language('language_hide')."</div>\n";
	foreach($topicrows as $topicrow)
	{
		$topicid = $topicrow[TOPIC_ID];
		$topictitle = stripslashes($topicrow[TOPIC_TITLE]);
		$topicstyle = $topicrow[TOPIC_STYLE];

		if($ismoderator)
			echo "<input type=\"radio\" name=\"topic\" id=\"topic$topicid\" value=\"$topicid\" /><label style=\"$topicstyle\" for=\"topic$topicid\">$topictitle</label> <a href=\"#\" onclick=\"delete_topic('$topicid')\"><img src=\"img/x.gif\" title=\"Delete\" /></a> \n<div class=\"hide\"><input type=\"checkbox\" name=\"hidetopic$topicid\" id=\"hidetopic$topicid\" onchange=\"topichide('$topicid')\" />".language('language_hide')."</div>\n";
		else
			echo "<input type=\"radio\" name=\"topic\" id=\"topic$topicid\" value=\"$topicid\" /><label style=\"$topicstyle\" for=\"topic$topicid\">$topictitle</label>\n<div class=\"hide\"><input type=\"checkbox\" name=\"hidetopic$topicid\" id=\"hidetopic$topicid\" onchange=\"topichide('$topicid')\" />".language('language_hide')."</div>\n";
	}
}
function newtopic($title, $style)
{
	$topic[TOPIC_ID] =  substr(md5(rand().time()), 0, 8);
	$topic[TOPIC_TITLE] = $title;
	$topic[TOPIC_STYLE] = $style;
	db_insert('topics', $topic);
}
function removetopic($topicid)
{
	db_deletewhere('topics', TOPIC_ID, '=', $topicid, INTEGER_COMPARISON);
}
function getstyle($id)
{
	$topicrow = db_selectunique('topics', TOPIC_ID, $id);
	return $topicrow[TOPIC_STYLE];
}


//UPLOADS

function saveupload($id, $title, $extension)
{
	global $allow_uploads;
	if($allow_uploads == 0) die(json_encode(array('message' => 'Uploads not allowed')));
	$upload[UPLOAD_ID] = 0;
	$upload[UPLOAD_NAME] = $id;
	$upload[UPLOAD_TITLE] = $title;
	$upload[UPLOAD_EXTENSION] = $extension;
	db_insertautoid('uploads', UPLOAD_ID, $upload);
	echo json_encode(array('success' => true));
}
function getuploadname($id)
{
	$topicrow = db_selectunique('uploads', UPLOAD_ID, $id);
	return $topicrow[UPLOAD_NAME].'.'.$topicrow[UPLOAD_EXTENSION];
}
function getuploadextension($id)
{
	$topicrow = db_selectunique('uploads', UPLOAD_ID, $id);
	return $topicrow[UPLOAD_EXTENSION];
}
function getuploadtitle($id)
{
	$topicrow = db_selectUnique('uploads', UPLOAD_ID, $id);
	return $topicrow[UPLOAD_TITLE].'.'.$topicrow[UPLOAD_EXTENSION];
}
function printdownloads()
{
	global $allow_uploads;
	if($allow_uploads == 0) die('Uploads not allowed');
	$downloadrows = db_selectall('uploads');
	$ismoderator = ismoderator();
	foreach($downloadrows as $downloadrow)
	{
		$downloadid = $downloadrow[UPLOAD_ID];
		$downloadtitle = stripslashes($downloadrow[UPLOAD_TITLE]);
		echo "<a href=\"functions.php?action=download&file=$downloadid\">$downloadtitle</a>";
		if($ismoderator)
			echo "&nbsp;<a href=\"#\" onclick=\"delete_upload('$downloadid')\"><img src=\"img/x.gif\" title=\"Delete\" /></a>";
		echo "<br />\n";
	}
}
function removeupload($uploadid)
{
	$upload = db_selectunique('uploads', UPLOAD_ID, $uploadid);
	unlink('uploads/'.$upload[UPLOAD_NAME].'.'.$upload[UPLOAD_EXTENSION]);
	db_deletewhere('uploads', UPLOAD_ID, '=', $uploadid, INTEGER_COMPARISON);
}

//COMPATIBILITY MODE


function compat_getposts()
{
	$newposts = '';

	//Translation
	$userlanguage = getlanguage();

	$newposts = db_selectwhere('posts', POST_ID, '>', getfirstpost(), POST_TIMESTAMP, 'DESC', -1, NUMERIC_COMPARISON);
	//Do this right after checking for the posts to keep everything current
	setlastping();

	if (sizeof($newposts)!=0)
	{
		$size = sizeof($newposts);
		require_once('settings.php');

		foreach ($newposts as $key => $post)
		{
			//echo $post[POST_TEXT];
			$isme = false;
			if(substr($post[POST_TEXT], 0, 4) == '/me ')
			{
				$post[POST_TEXT] = substr($post[POST_TEXT], 3);
				$isme = true;
			}
			$username = idtouser($post[POST_USERID]);
			if(!$username) 
				$username = language('language_expired');
			$posttext = ($userlanguage == $post[POST_LANGUAGE]) ? $post[POST_TEXT] : translate($post[POST_TEXT], $post[POST_LANGUAGE], $userlanguage, $trans);
			$posttopic = $post[POST_TOPIC];
			if(!$posttopic) $posttopic = 1;
			$poststyle = getstyle($post[POST_TOPIC]);
			if($post[POST_USERID] == -1) 
				echo "<div><i>$posttext</i></div>\n";
			else if($isme) 
				echo "<b><div class=\"topic$posttopic\" style=\" $poststyle\">$username ".$posttext."</div></b>\n";
			else if($post[POST_USERID] == md5(session_id())) 
				echo "<div class=\"topic$posttopic\"><b style=\"color: #666666;\">$username</b>:&nbsp;<span  style=\"$poststyle\">$posttext</span></div>\n";
			else 
				echo "<div class=\"topic$posttopic\"><b>$username</b>:&nbsp;<span style=\"$poststyle\">$posttext</span></div>\n";
		}
		setlastpost();
		
	}
}


?>