<?php

// upgrade.inc.php
// database upgrade procedures

class Upgrade {

  // get current schema version, or 0 if table is missing
  function get_schema_version() {
    global $db;
    $res = $db->getOne('select schema_version from `!`', array(DB_PREFIX . 'schema_version'));
    if (PEAR::isError($res))
      $res = 0;               // assume failure is due to missing table
    return $res;
  }

  // upgrade database to latest version
  function do_upgrade() {
    $v = $this->get_schema_version();
    if ($v < 1) $this->do_upgrade_1();
    if ($v < 2) $this->do_upgrade_2();
    if ($v < 3) $this->do_upgrade_3();
    if ($v < 4) $this->do_upgrade_4();
    if ($v < 5) $this->do_upgrade_5();
    if ($v < 6) $this->do_upgrade_6();
    if ($v < 7) $this->do_upgrade_7();
    if ($v < 8) $this->do_upgrade_8();
    if ($v < 9) $this->do_upgrade_9();
    if ($v < 10) $this->do_upgrade_10();
    if ($v < 11) $this->do_upgrade_11();
    if ($v < 12) $this->do_upgrade_12();
    if ($v < 13) $this->do_upgrade_13();
    if ($v < 14) $this->do_upgrade_14();
    if ($v < 15) $this->do_upgrade_15();
    if ($v < 16) $this->do_upgrade_16();
    if ($v < 17) $this->do_upgrade_17();
    if ($v < 18) $this->do_upgrade_18();
    if ($v < 19) $this->do_upgrade_19();
    if ($v < 20) $this->do_upgrade_20();
    if ($v < 21) $this->do_upgrade_21();
    if ($v < 22) $this->do_upgrade_22();
    if ($v < 23) $this->do_upgrade_23();
    if ($v < 24) $this->do_upgrade_24();
    if ($v < 25) $this->do_upgrade_25();
    if ($v < 26) $this->do_upgrade_26();
    if ($v < 27) $this->do_upgrade_27();
    if ($v < 28) $this->do_upgrade_28();
    if ($v < 29) $this->do_upgrade_29();
  }

  // upgrade schema to version 1
  function do_upgrade_1() {
    $tbl = DB_PREFIX . 'grids';
    $this->query('update ! set `pixel_price` = `pixel_price`*100.0', array($tbl));

    $tbl = DB_PREFIX . 'regions';
    $this->query('alter table `!` add `alt` varchar(255) not null default \'\'', array($tbl));

    $tbl = DB_PREFIX . 'settings';
    $this->query('alter table `!` add `site_description` mediumtext null default \'\'', array($tbl));
    $this->query('alter table `!` add `use_fckeditor` tinyint(1) null default 0', array($tbl));
    $this->query('alter table `!` add `interlaced_images` tinyint(1) null default 0', array($tbl));
    $this->query('alter table `!` add `site_down` tinyint(1) null default 0', array($tbl));
    $this->query('update `!` set `site_down`=1 where `id`=1', array($tbl));

    $tbl = DB_PREFIX . 'users';
    $this->query('create table `!` (
      `id` int not null auto_increment,
      `email` varchar(255) not null default \'\',
      `pass` varchar(100) not null default \'\',
      `first_name` varchar(100) not null default \'\',
      `last_name` varchar(100) not null default \'\',
      `created_at` datetime not null,
      `is_confirmed` tinyint(1) not null default 0,
      `digest` varchar(32) not null default \'\',
      unique (`email`),
      primary key (`id`)
    ) character set utf8', array($tbl));

    $tbl = DB_PREFIX . 'email_templates';
    $this->query('
      insert into `!` (`id`, `email_key`, `name`, `parameters`) values 
        (3, \'signup_confirm\', \'Account Signup Confirmation\', \'[site_name], [confirm_url], [first_name], [last_name]\'),
        (4, \'tell_a_friend\', \'Tell a Friend\', \'[site_name], [site_url], [from_name]\'),
        (5, \'retrieve_password\', \'Retrieve Password\', \'[site_name], [login_url], [email], [password]\')
    ', array($tbl));

    $tbl = DB_PREFIX . 'snippets';
    $this->query('
      insert into `!` (`snippet_key`, `snippet_seq`, `language_id`, `snippet_text`, `is_internal`) values 
        (\'signup_confirm_subject\', 0, 1, \'Activate Your [site_name] Account\', 1),
        (\'signup_confirm_body\', 0, 1, \'Dear [first_name] [last_name],\r\n\r\nThank you for creating an account at [site_name].\r\nIn order to activate your account, you must confirm your ownership of this E-Mail address by visiting this link:\r\n[confirm_url]\r\n\r\nSincerely,\r\n[site_name] Administrator\', 1),
        (\'tell_a_friend_subject\', 0, 1, \'Check Out [site_name]\', 1),
        (\'tell_a_friend_body\', 0, 1, \'I thought you might be interested in this new site:\r\n\r\n[site_name]\r\n\r\nYou can find it at [site_url]\r\n\r\nSincerely,\r\n[from_name]\', 1),
        (\'retrieve_password_subject\', 0, 1, \'Your Password for [site_name]\', 1),
        (\'retrieve_password_body\', 0, 1, \'Here are your login details for [site_name]:\r\n\r\nE-Mail Address: [email]\r\nPassword: [password]\r\n\r\nYou may log in at [login_url]\r\n\r\nSincerely,\r\n[site_name] Administrator\', 1)
    ', array($tbl));

    $tbl = DB_PREFIX . 'payment_modules';
    $this->query('delete from ! where `module_key`<>\'paypal\'', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('
      create table `!` (
        `id` int not null auto_increment,
        `schema_version` int not null default 0,
        primary key (`id`)
      ) character set utf8
    ', array($tbl));
    $this->query('insert into `!` (`id`, `schema_version`) values (1, 1)', array($tbl));
  }

  // upgrade schema to version 2
  function do_upgrade_2() {

    $tbl = DB_PREFIX . 'blog_articles';
    $this->query('
      create table `!` (
        `id` int not null auto_increment,
        `created_at` datetime not null,
        primary key (`id`)
      ) character set utf8
    ', array($tbl));

    $tbl = DB_PREFIX . 'blog_comments';
    $tbl2 = DB_PREFIX . 'blog_articles';
    $this->query('
      create table `!` (
        `id` int not null auto_increment,
        `blog_article_id` int not null default 0 references `!` (`id`),
        `author` varchar(255) not null default \'\',
        `body` mediumtext not null default \'\',
        `created_at` datetime not null,
        primary key (`id`)
      ) character set utf8;
    ', array($tbl, $tbl2));

    $tbl = DB_PREFIX . 'email_templates';
    $this->query('
      insert into `!` (`id`, `email_key`, `name`, `parameters`) values 
        (6, \'region_approval_notification\', \'(Admin) Region Approval Notification\', \'[site_name], [region_id], [region_url], [payment_method], [payment_id], [payment_url], [user_id], [user_url]\'),
        (7, \'cc_split_digits\', \'(Admin) Credit Card Split Digits\', \'[site_name], [payment_id], [payment_url], [cc_digits]\')
    ', array($tbl));

    $tbl = DB_PREFIX . 'payment_modules';
    $this->query('alter table `!` add `display_order` int not null default 0', array($tbl));
    $this->query('
      delete from `!` where `module_key` = \'cc\'
    ', array($tbl));
    $this->query('
      insert into `!` (`name`, `module_key`, `class_file`, `formfile`, `is_enabled`) values 
          (\'Credit Card\', \'cc\', \'cc.php\', \'frmcc.tpl\', 0)
    ', array($tbl));

    $tbl = DB_PREFIX . 'settings';
    $this->query('alter table `!` add `blog_comments` tinyint(1)  null default 0', array($tbl));

    $tbl = DB_PREFIX . 'snippets';
    $this->query('
      insert into `!` (`snippet_key`, `snippet_seq`, `language_id`, `snippet_text`, `is_internal`) values 
        (\'region_approval_notification_subject\', 0, 1, \'[site_name] Region Approval Required\', 1),
        (\'region_approval_notification_body\', 0, 1, \'A region has been purchased on [site_name].\r\nThe pixels are in "pending" status awaiting your approval.\r\n\r\nRegion ID:      [region_id]\r\nRegion URL:     [region_url]\r\nPayment Method: [payment_method]\r\nPayment ID:     [payment_id]\r\nPayment URL:    [payment_url]\r\nUser ID:        [user_id]\r\nUser URL:       [user_url]\', 1),
        (\'cc_split_digits_subject\', 0, 1, \'[site_name] Credit Card Split Digits\', 1),
        (\'cc_split_digits_body\', 0, 1, \'A credit card payment has been made on [site_name].\r\nFor security purposes, only part of the credit card number has been\r\nstored in the database. This email provides the missing digits.\r\n\r\nPayment ID:  [payment_id]\r\nPayment URL: [payment_url]\r\nCC Digits:   [cc_digits]\', 1)
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('update `!` set `schema_version` = 2', array($tbl));
  }

  // upgrade schema to version 3
  function do_upgrade_3() {

    $tbl = DB_PREFIX . 'newsletters';
    $this->query('
      create table `!` (
        `id` int not null auto_increment,
        `created_at` datetime not null,
        primary key (`id`)
      ) character set utf8
    ', array($tbl));

    $tbl = DB_PREFIX . 'payment_modules';
    $this->query('
      delete from `!` where `module_key` in (\'authorizenet\', \'nochex\', \'psigate\')
    ', array($tbl));
    $this->query('
      insert into `!` (`name`, `module_key`, `class_file`, `formfile`, `is_enabled`) values 
          (\'Authorize.Net\', \'authorizenet\', \'authorizenet.php\', \'frmauthorizenet.tpl\', 0),
          (\'NOCHEX\', \'nochex\', \'nochex.php\', \'frmnochex.tpl\', 0),
          (\'PSiGate\', \'psigate\', \'psigate.php\', \'frmpsigate.tpl\', 0)
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 3)', array($tbl));

  }

  // upgrade schema to version 4
  function do_upgrade_4() {

    $tbl = DB_PREFIX . 'payment_modules';
    $this->query('
      delete from `!` where `module_key` in (\'ipayment\')
    ', array($tbl));
    $this->query('
      insert into `!` (`name`, `module_key`, `class_file`, `formfile`, `is_enabled`) values 
          (\'ipayment.de\', \'ipayment\', \'ipayment.php\', \'frmipayment.tpl\', 0)
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 4)', array($tbl));

  }

  // upgrade schema to version 5
  function do_upgrade_5()
  {

    $tbl = DB_PREFIX . 'payment_modules';
    $this->query('
      delete from `!` where `module_key` in (\'secpay\', \'pm2checkout\')
    ', array($tbl));
    $this->query('
      insert into `!` (`name`, `module_key`, `class_file`, `formfile`, `is_enabled`) values 
          (\'SECPay\', \'secpay\', \'secpay.php\', \'frmsecpay.tpl\', 0),
          (\'2Checkout\', \'pm2checkout\', \'pm2checkout.php\', \'frmpm2checkout.tpl\', 0)
    ', array($tbl));

    $tbl = DB_PREFIX . 'payment_configs';
    $this->query('
      alter table `!` 
        drop column `configuration_title`,
        drop column `configuration_description`,
        drop column `configuration_group_id`,
        drop column `sort_order`,
        drop column `last_modified`,
        drop column `date_added`,
        drop column `use_function`,
        drop column `set_function`
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 5)', array($tbl));

  }

  // upgrade schema to version 6
  function do_upgrade_6() {

    $tbl = DB_PREFIX . 'grids';
    $this->query('
      alter table `!` 
      add column `grid_transparency` int not null default 0,
      add column `background_image` longblob null,
      add column `background_thumbnail_image` longblob null
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 6)', array($tbl));

  }

  // upgrade schema to version 7
  function do_upgrade_7(){ 

    // mark all grids as dirty, since grid file naming scheme has changed
    $tbl = DB_PREFIX . 'grids';
    $this->query('
      update `!` set `is_dirty` = 1
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 7)', array($tbl));

  }

  // upgrade schema to version 8
  function do_upgrade_8(){

    $tbl = DB_PREFIX . 'grids';
    $this->query('
      alter table `!` 
      add column `region_max_width` int not null default 0,
      add column `region_max_height` int not null default 0
    ', array($tbl));

    $tbl = DB_PREFIX . 'settings';
    $this->query('
      alter table !
      add column `palette_images` tinyint(1) null default 0
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 8)', array($tbl));

  }

  // upgrade schema to version 9
  function do_upgrade_9() {

    // language text digests to change as a result of change to digest
    // algorithm. this list represents the 1.0.3 version texts that need
    // a digest change. the list is augmented by examining the english
    // texts already present in the language_texts table.
    $digests = array(
      '980fceacd152379ff8871edb8d489b58' => 'f2174ebd1875527abe46f1fe2782e761',
      '3d20c6d289cd48997610e150a95d61b3' => 'b7c0f5c88cb24f6f957d16a141f7b35f',
      'ae9bd6d814f2945e4722f38959c988c9' => '7d102b34bca77d98da5f32fec4e7fe2a',
      'cd80e0d91a69bd06be03735425102e2e' => '5ac272b74089a85e706873a025f1f929',
      'c58868f758ae5c1b265d9a4fe1ebe8e6' => '396174fcd62305830c9f0d78ace8e38c',
      'd490d0e18f350ebbb9a6e165f33873aa' => '6a6b93c0ba67083cb9aaed5f5fff2698',
      '7ef1d39889064c08712100b3bc68e0e9' => '88388c4c3bf5a6af4c23fd2d8d4f2923',
      '18b4a88aeeb2d760a270fb03ada21b4a' => '2a71ea143a1405497007e10b7ddc5253',
      'ab2961b8fa623f9eb7b6b4f584d970ec' => '1fecaa43ef33ed8ede57c234d2016e4b',
      'cb69611c856dfe1a41ed814c5c1ff059' => 'e3f7f54834cb55663cfc8daa3e1296da',
      '716ba987efff9ea6c2f3073101a63cc3' => '1a33eaccf125c602d613dfd2619f1546',
      'b8b2be4f6abdfe1dad73eb8fcf4915c0' => '524f80b32e3c7e846f94b7c5d775208e',
      'e70a4639f06b91adc13bebdc0eb091c7' => 'd5b88e6656ce6e5998b9816284fef16b',
      'c6e67dceda56511bdef51d9dc12ca64f' => 'b4eb4e49176872cff5d0d58129a9336b',
      '2e2f3e042ac273587018b5d3b3a64fd5' => '712bd47cf0934a7240b43b79d9f0667f',
      '92da1b7876b9773e70d007e1e41070dd' => '94917ab8c61c926e7cb40cfc68cb8928',
      'f870e8dabfffc1e66b3feea2aa8b84ae' => '49c3ba4130a88f7ab532f142fba92efe',
      '0a1aad7496d2a75b323ef04d5b8d16ce' => '063233c7ddc14c12cc803274c2978852',
      '11f3dc0e8c2cf042754a1c095af1466a' => 'fb24df5535e7d367bab0b56f4ce8e661',
      'f8eadaa71914dcd7ea770da90bdde987' => '473c68a65e7b4c0f718c24ca82572480',
      '6180dbf6ecdf9bb6a33199904877c247' => '776ce18ce0df318a12121c92afab7279',
      '0707c5bf75a5ea7302c44d61d7dec7a2' => 'e472d07f9c5160054406659749857591',
      'c941498c7c259298be1f23b636b3c481' => 'ff5c08e44e4c7a76922a5cd8e0c99e79',
    );

    $tbl = DB_PREFIX . 'language_texts';
    // find digests that need to be changed
    $res = $this->query('select `digest`, `language_text` from `!` where `language_id`=1', array($tbl));
    while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)) {
      $s = preg_replace('/^\s+/', '', $row['language_text']);
      $s = preg_replace('/\s+$/', '', $s);
      $s = preg_replace('/\s+/', ' ', $s);
      $new_digest = md5($s);
      if ($new_digest != $row['digest'])
        $digests[$row['digest']] = $new_digest;
    }
    $res->free();
    // now change those digests by language, removing any duplicates
    // due to whitespace differences only
    foreach ($digests as $old => $new) {
      $res = $this->query('select digest from `!` where `digest`=? limit 0,1',
        array($tbl, $new));
      if ($res->numRows() == 0) {
        $this->query('update `!` set `digest`=? where `digest`=?',
          array($tbl, $new, $old));
      }
      else {
        $this->query('delete from `!` where `digest`=?',
          array($tbl, $old));
      }
    }

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 9)', array($tbl));

  }

  // upgrade schema to version 10
  function do_upgrade_10() {

    $tbl = DB_PREFIX . 'payment_modules';
    $this->query('
      delete from `!` where `module_key` in (\'egold\')
    ', array($tbl));
    $this->query('
      insert into `!` (`name`, `module_key`, `class_file`, `formfile`, `is_enabled`) values 
          (\'E-Gold\', \'egold\', \'egold.php\', \'frmegold.tpl\', 0)
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 10)', array($tbl));

  }

  // upgrade schema to version 11
  function do_upgrade_11() {

    $tbl = DB_PREFIX . 'blog_articles';
    $this->query('alter table `!` alter `created_at` set default \'0000-00-00 00:00:00\'', array($tbl));

    $tbl = DB_PREFIX . 'blog_comments';
    $this->query('alter table `!` alter `created_at` set default \'0000-00-00 00:00:00\'', array($tbl));

    $tbl = DB_PREFIX . 'newsletters';
    $this->query('alter table `!` alter `created_at` set default \'0000-00-00 00:00:00\'', array($tbl));

    $tbl = DB_PREFIX . 'regions';
    $this->query('alter table `!` alter `created_on` set default \'0000-00-00 00:00:00\'', array($tbl));

    $tbl = DB_PREFIX . 'payments';
    $this->query('alter table `!` alter `completed_at` set default \'0000-00-00 00:00:00\'', array($tbl));

    $tbl = DB_PREFIX . 'payments';
    $this->query('alter table `!` alter `verified_at` set default \'0000-00-00 00:00:00\'', array($tbl));

    $tbl = DB_PREFIX . 'users';
    $this->query('alter table `!` alter `created_at` set default \'0000-00-00 00:00:00\'', array($tbl));

    $tbl = DB_PREFIX . 'grids';
    $this->query('
      alter table `!` 
      add `expire_days` int not null default 0, 
      add `reminder_days` int not null default 0, 
      add `purge_days` int not null default 0
    ', array($tbl));

    $tbl = DB_PREFIX . 'regions';
    $this->query('
      alter table `!` 
      add `expires_at` datetime not null default \'0000-00-00 00:00:00\', 
      add `reminder_at` datetime not null default \'0000-00-00 00:00:00\', 
      add `purge_at` datetime not null default \'0000-00-00 00:00:00\'
    ', array($tbl));

    $tbl = DB_PREFIX . 'settings';
    $this->query('
      alter table `!` 
      add `expires_check_at` datetime  null default \'0000-00-00 00:00:00\'
    ', array($tbl));

    $tbl = DB_PREFIX . 'email_templates';
    $this->query('
      insert into `!` (`email_key`, `name`, `parameters`) values 
        (\'renewal_reminder\', \'Renewal Reminder\', \'[site_name],[url],[update_url],[expires_at],[purge_at],[email]\')
    ', array($tbl));

    $tbl = DB_PREFIX . 'snippets';
    $this->query('
      insert into `!` (`snippet_key`, `snippet_seq`, `language_id`, `snippet_text`, `is_internal`) values 
        (\'renewal_reminder_subject\', 0, 1, \'Your Pixels at [site_name] will expire soon\', 1),
        (\'renewal_reminder_body\', 0, 1, \'Dear Customer\r\n\r\nYour Pixels for [url] at [site_name] will expire at [expires_at]\r\n\r\nPlease use the following link to renew your pixels now:\r\n[update_url]\r\n\r\n(You will need to provide your e-mail address, [email], when using this link, to confirm your identity.)\r\n\r\nYou must renew your pixels before [purge_at], or they will be permanently removed.\r\n\r\nSincerely,\r\n[site_name] Administrator\', 1)
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 11)', array($tbl));

  }

  // upgrade schema to version 12
  function do_upgrade_12()
  {

    $tbl = DB_PREFIX . 'settings';
    $this->query('
      alter table `!` 
      add `multiple_grid_pages` tinyint(1) null default 0,
      add `grid_columns` int  null default 1
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 12)', array($tbl));

  }

  // upgrade schema to version 13
  function do_upgrade_13()
  {

    $tbl = DB_PREFIX . 'settings';
    $this->query('
      alter table `!` 
      add `rss_latest_pixels` int not null default 10,
      add `rss_top_pixels` int not null default 10,
      add `rss_blog_articles` int not null default 10
    ', array($tbl));
    $this->query('
      update `!` set
      `rss_latest_pixels` = 10,
      `rss_top_pixels` = 10,
      `rss_blog_articles` = 10
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 13)', array($tbl));

  }

  // upgrade schema to version 14
  function do_upgrade_14()
  {

    $tbl = DB_PREFIX . 'settings';
    $this->query('
      alter table `!` 
      add `pixel_list_by_clicks` tinyint(1) null default 1
    ', array($tbl));
    $this->query('
      update `!` set
      `pixel_list_by_clicks` = 1
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 14)', array($tbl));

  }

  // upgrade schema to version 15
  function do_upgrade_15()
  {

    $tbl = DB_PREFIX . 'link_banners';
    $this->query('
      create table `!` (
        `id` int not null auto_increment,
        `html` text not null default \'\',
        `image` longblob null,
        `mime_type` varchar(255) not null default \'\',
        primary key (`id`)
      ) character set utf8
    ', array($tbl));

    $tbl = DB_PREFIX . 'link_links';
    $this->query('
      create table `!` (
        `id` int not null auto_increment,
        `html` text not null default \'\',
        primary key (`id`)
      ) character set utf8
    ', array($tbl));

    $tbl = DB_PREFIX . 'settings';
    $this->query('
      alter table `!` add `link_to_us_enabled` tinyint(1) null default 0
    ', array($tbl));

    $tbl = DB_PREFIX . 'settings';
    $this->query('
      update `!` set `link_to_us_enabled`=1
    ', array($tbl));

    $tbl = DB_PREFIX . 'link_links';
    $this->query('
      insert into `!` (`id`, `html`)
      values (1, \'<a href="[site_url]" target="_blank">[site_name]</a>\')
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 15)', array($tbl));

  }

  // upgrade schema to version 16
  function do_upgrade_16() {

    $tbl = DB_PREFIX . 'payment_modules';
    $this->query('
      delete from `!` where `module_key` in (\'offline\')
    ', array($tbl));
    $this->query('
      insert into `!` (`name`, `module_key`, `class_file`, `formfile`, `is_enabled`) values 
          (\'Offline Payment\', \'offline\', \'offline.php\', \'frmoffline.tpl\', 0)
    ', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 16)', array($tbl));

  }
  
  // upgrade schema to version 17
  function do_upgrade_17() {

    $tbl = DB_PREFIX . 'settings';
    $this->query('
      ALTER TABLE `!` ADD `seo_status` ENUM( \'standard\', \'optimized\', \'high_optimized\' ) NOT NULL DEFAULT \'standard\' AFTER `pixel_list_by_clicks`
    ', array($tbl));
                                                                                
    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 17)', array($tbl));
  }
  
  function do_upgrade_18(){
    $tbl = DB_PREFIX . 'settings';
    $this->query("ALTER TABLE `!` ADD `upload_images` ENUM( 'true', 'false' ) NULL DEFAULT 'true' ;", array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 18)', array($tbl));
  }

  // upgrade shema to version 19
  function do_upgrade_19(){
    $tbl = DB_PREFIX . 'grids';
    $this->query("ALTER TABLE `!` ADD `allow_free_paid` ENUM( 'true', 'false' ) NOT NULL DEFAULT 'false' ;", array($tbl));
    $this->query("ALTER TABLE `!` ADD `free_square` INT NOT NULL DEFAULT 0 ;", array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 19)', array($tbl));
  }
  
  // upgrade shema to version 20
  function do_upgrade_20(){
    $tbl = DB_PREFIX . 'settings';
    $this->query("ALTER TABLE `!` ADD `order_image_galleries` ENUM( 'ksort#SORT_REGULAR', 'ksort#SORT_NUMERIC', 'ksort#SORT_STRING', 'krsort#SORT_REGULAR', 'krsort#SORT_NUMERIC', 'krsort#SORT_STRING' ) NOT NULL DEFAULT 'ksort#SORT_REGULAR'", array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 20)', array($tbl));
  }
  
  
  // upgrade shema to version 21
  function do_upgrade_21(){
    $tbl = DB_PREFIX . 'grids';
    $this->query("ALTER TABLE `!` ADD `selectable_square_size` INT NOT NULL DEFAULT '10';", array($tbl));
    $tbl = DB_PREFIX . 'email_templates';
    $this->query("INSERT INTO `!` (`id`, `email_key`, `name`, `parameters`) VALUES 
(10, 'confirmation_free_pending', 'Confirmation for free customers (Pending) ', '[site_url],[banner_url],[site_name],[confirmation_number],[update_url]'),
(11, 'confirmation_customers_active', 'Confirmation for free customers (Active) ', '[site_url],[banner_url],[site_name],[confirmation_number],[update_url]');", array($tbl));

    $tbl = DB_PREFIX . 'snippets';
    $this->query("INSERT INTO `!` (`id`, `snippet_key`, `snippet_seq`, `language_id`, `snippet_text`, `is_internal`) VALUES (64, 'confirmation_free_pending_body', 0, 1, 'Dear Customer\r\n \r\nThank you for using our services. Your pixels will be activated shortly. Please place our code on your site:\r\n<a href=\"[site_url]\" target=\"_blank\"><img src=\"[banner_url]\" border=\"0\" alt=\"[site_name]\" /></a>\r\n \r\nYour confirmation number is [confirmation_number].\r\nYou may use the following link to update your pixels: [update_url]\r\n \r\n(You will need to provide your e-mail address, [email], when using this link, to confirm your identity.)\r\n \r\nSincerely,\r\n[site_name] Administrator', 0),
(63, 'confirmation_free_pending_subject', 0, 1, 'Confirmation', 0),
(62, 'confirmation_customers_active_body', 0, 1, 'Dear Customer,\r\n \r\nThank you for using our services,  your pixels are active now.\r\n \r\nPlease keep placing our code on your site:\r\n<a href=\"[site_url]\" target=\"_blank\"><img src=\"[banner_url]\" border=\"0\" alt=\"[site_name]\" /></a>\r\n \r\nYour confirmation number is [confirmation_number].\r\nYou may use the following link to update your pixels: [update_url]\r\n \r\n(You will need to provide your e-mail address, [email], when using this link, to confirm your identity.)\r\n \r\nSincerely,\r\n[site_name] Administrator', 0),
(61, 'confirmation_customers_active_subject', 0, 1, 'your pixels are activated', 0)", array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 21)', array($tbl));
  }

  //upgrade shema to version 22
  function do_upgrade_22(){
    $tbl = DB_PREFIX . 'options';
    $this->query("CREATE TABLE `!` (`group` VARCHAR( 20 ) NOT NULL ,`name` VARCHAR( 20 ) NOT NULL ,`value` BLOB NOT NULL ,PRIMARY KEY ( `group` , `name` )
)", array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 22)', array($tbl));
  }

  //upgrade schema to version 23
  //offline payment will be activated by default if there are now activated modules (activate on install)
  //image enable option for pixel list
  function do_upgrade_23(){
    $tbl = DB_PREFIX . 'settings';
    $this->query("ALTER TABLE `!` ADD `pixel_list_enable_images` ENUM( '0', '1' )  NULL DEFAULT '0'", array($tbl));
    /*
     * $payment_tbl = DB_PREFIX . 'payment_modules';
     *$res
     */
    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 23)', array($tbl));
  }

  //upgrade schema to version 24
  function do_upgrade_24(){
    $tbl = DB_PREFIX . 'grids';
    $this->query('ALTER TABLE `!` ADD `images_gallery` ENUM( \'0\', \'1\' ) NOT NULL DEFAULT \'1\'', array($tbl));
    $this->query('ALTER TABLE `!` ADD `region_min_width` SMALLINT NOT NULL DEFAULT \'0\' ', array($tbl));
    $this->query('ALTER TABLE `!` ADD `region_min_height` SMALLINT NOT NULL DEFAULT \'0\' ', array($tbl));
    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 24)', array($tbl));
  }

  //release 1.3.2
  function do_upgrade_25(){
    $tbl = DB_PREFIX . 'settings';
    $this->query('ALTER TABLE `!` ADD `grids_as_options` ENUM(\'0\', \'1\') DEFAULT \'0\'', array($tbl));
    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 25)', array($tbl));
  }

  //release 1.3.3
  function do_upgrade_26(){
    $tbl = DB_PREFIX . 'grids';
    $this->query('ALTER TABLE `!` ADD `back_links` ENUM( \'0\', \'1\' ) NOT NULL DEFAULT \'0\'', array($tbl));
    $this->query('ALTER TABLE `!` ADD `multi_get` ENUM( \'0\', \'1\' ) NOT NULL DEFAULT \'0\'', array($tbl));
    $this->query('ALTER TABLE `!` ADD `back_link` TEXT NOT NULL', array($tbl));
    $this->query('ALTER TABLE `!` ADD INDEX ( `back_links` )', array($tbl));
    
    $tbl = DB_PREFIX . 'regions';
    $this->query('ALTER TABLE `!` ADD `original_image` LONGBLOB NULL', array($tbl));
    $this->query('UPDATE `!` SET `original_image`=`image`', array($tbl));

    $tbl = DB_PREFIX . 'payments';
    $this->query('ALTER TABLE `!` ADD `data` TEXT NULL AFTER `id`', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 26)', array($tbl));
  }

  //release 1.3.5
  function do_upgrade_27(){
    $tbl = DB_PREFIX.'coupons';
    $this->query('
      CREATE TABLE `!` (
        `code` VARCHAR( 16 ) NOT NULL ,
        `valid` ENUM( \'0\', \'1\' ) NOT NULL DEFAULT \'1\',
        PRIMARY KEY ( `code` ) ,
        INDEX ( `valid` )
      )', array($tbl));
    
    $tbl = DB_PREFIX.'emails';
    $this->query('
      CREATE TABLE `!` (
        `email` VARCHAR( 255 ) NOT NULL ,
        PRIMARY KEY ( `email` )
      )', array($tbl));

    $tbl = DB_PREFIX.'categories';
    $this->query('
      CREATE TABLE `!` (
        `type` ENUM( \'grids\', \'regions\' ) NOT NULL DEFAULT \'grids\',
        `id` INT NOT NULL ,
        `name` VARCHAR( 100 ) NOT NULL ,
        PRIMARY KEY ( `type` , `id` )
      )', array($tbl));

    $tbl = DB_PREFIX . 'grids';
    $this->query('ALTER TABLE `!` ADD `category_id` INT NULL', array($tbl));
    $this->query('ALTER TABLE `!` ADD INDEX ( `category_id` )', array($tbl));

    $tbl = DB_PREFIX . 'regions';
    $this->query('ALTER TABLE `!` ADD `description` TEXT NULL', array($tbl));
    $this->query('ALTER TABLE `!` ADD `category_id` INT NULL', array($tbl));
    $this->query('ALTER TABLE `!` ADD INDEX ( `category_id` )', array($tbl));

    $tbl = DB_PREFIX . 'categories';
    $this->query('ALTER TABLE `!` CHANGE `id` `id` INT( 11 ) NOT NULL AUTO_INCREMENT', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 27)', array($tbl));
  }

  //release 1.3.6
  function do_upgrade_28(){
    $tbl = DB_PREFIX . 'users';
    $this->query('ALTER TABLE `!` ADD `user_page` TEXT NULL', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 28)', array($tbl));
  }
  
  //release 1.3.7
  function do_upgrade_29(){
    $tbl = DB_PREFIX . 'settings';
    $this->query('ALTER TABLE `!` CHANGE `approval_required` `approval_required` TINYINT( 1 ) NULL DEFAULT \'0\'', array($tbl));

    $tbl = DB_PREFIX . 'schema_version';
    $this->query('replace into `!` (`id`, `schema_version`) values (1, 29)', array($tbl));
  }
  
	// perform db query and raise any errors that occur. calls the global
  // show_error() function from install/install_funcs.php
  function query($sql, $params = array()) {
    global $db;

    $res = $db->query($sql, $params);
    if (PEAR::isError($res))
      show_error('An error occurred during the upgrade: ' . $res->getUserInfo());
    return $res;
  }

}