<?php

// step_6.php
// installation complete. make final preparations and launch application.

// clear smarty compiled templates and cache before
// launching application
require_once('Smarty.class.php');
$t = new Smarty;
$t->template_dir = PACKAGE_ROOT . SMARTY_TEMPLATE_DIR;
$t->compile_dir = PACKAGE_ROOT . SMARTY_COMPILE_DIR;
$t->cache_dir = PACKAGE_ROOT . SMARTY_CACHE_DIR;
$t->clear_all_cache();
@set_time_limit(300);
$dh = opendir(PACKAGE_ROOT . SMARTY_COMPILE_DIR);
while (($file = readdir($dh)) !== false) {
  $path = PACKAGE_ROOT . SMARTY_COMPILE_DIR . $file;
  if (is_file($path) && preg_match('/\.tpl\.php$/', $path))
    @unlink($path);
}
closedir($dh);

// copy the .htaccess file from the templates dir
// to other dirs that need to be restricted.
@copy(PACKAGE_ROOT . SMARTY_TEMPLATE_DIR . '/.htaccess',
  PACKAGE_ROOT . SMARTY_COMPILE_DIR . '/.htaccess');
@copy(PACKAGE_ROOT . SMARTY_TEMPLATE_DIR . '/.htaccess',
  PACKAGE_ROOT . SMARTY_CACHE_DIR . '/.htaccess');
@copy(PACKAGE_ROOT . SMARTY_TEMPLATE_DIR . '/.htaccess',
  PACKAGE_ROOT . TEMP_DIR . '/.htaccess');

// set application name/version, directories, 
// and installation completion status
update_config_file(array(
  'PACKAGE_NAME' => PACKAGE_NAME,
  'PACKAGE_VERSION' => PACKAGE_VERSION,
  'PACKAGE_ROOT' => PACKAGE_ROOT,
  'INCLUDES_DIR' => PACKAGE_ROOT . INCLUDES_DIR,
  'SMARTY_DIR' => PACKAGE_ROOT . SMARTY_DIR,
  'SMARTY_TEMPLATE_DIR' => PACKAGE_ROOT . SMARTY_TEMPLATE_DIR,
  'SMARTY_COMPILE_DIR' => PACKAGE_ROOT . SMARTY_COMPILE_DIR,
  'SMARTY_CACHE_DIR' => PACKAGE_ROOT . SMARTY_CACHE_DIR,
  'TEMP_DIR' => PACKAGE_ROOT . TEMP_DIR,
  'GRIDS_DIR' => PACKAGE_ROOT . GRIDS_DIR,
  'PEAR_DIR' => PACKAGE_ROOT . PEAR_DIR,
  'INSTALL_COMPLETED' => true,
));


// show final message
show_header();
?>
<h2 class="success">Installation Complete</h2>
<p><?php echo htmlspecialchars(PACKAGE_NAME) ?> is now ready to be used.</p>

<p>You should now delete the <tt>install.php</tt> file and the <tt><?php echo
htmlspecialchars(basename(INSTALL_DIR)) ?></tt> folder. These are not required
any longer.</p>

<p>You may also wish to adjust the permissions of the 
<tt><?php echo htmlspecialchars(SMARTY_TEMPLATE_DIR) ?></tt>, 
<tt><?php echo htmlspecialchars(SMARTY_COMPILE_DIR) ?></tt>, 
<tt><?php echo htmlspecialchars(TEMP_DIR) ?></tt>, and 
<tt><?php echo htmlspecialchars(SMARTY_COMPILE_DIR) ?></tt> folders to the
minimum required file-writing permissions for your server, and adjust the
permissions of the <tt>config.php</tt> file to the minimum required
file-reading permissions for your server. If you do not know how to do that,
or if you do not know what the minimum required permissions are, please
contact your website host.</p>

<p>You should now go to the Administrator's area to finish configuring
the application.</p>

<div class="box">
<p>The default Administrator login is:</p>
<ul>
  <li>User Name: <tt>admin</tt></li>
  <li>Password: <tt>admin</tt></li>
</ul>
</div>

<p><a href="admin/index.php">Go to <?php echo htmlspecialchars(PACKAGE_NAME) ?> Administration Now</a></p>
<?php
show_footer() 
?>
