<?php

// step_2.php
// database connection, table creation/updating

if ($_SERVER['REQUEST_METHOD'] == 'POST') do_post();
show_form();

// handle post of form. connect to the database and create or
// update the tables.
function do_post() 
{
  global $db, $utf8_ok;

  show_header();
  require_once('DB.php');

  // attempt to connect to the requested database
  $db = DB::connect(array(
    'username' => $_POST['user'],
    'password' => $_POST['password'],
    'hostspec' => $_POST['host'],
    'database' => $_POST['name'],
    'phptype' => 'mysql',
  ));

  // handle connection errors
  if (PEAR::isError($db)) {
    if ($db->getCode() == DB_ERROR_CONNECT_FAILED) {
      show_form('One of the following is invalid: Database Host, Database User,
      or Database Password or host. Please check these three values for
      accuracy and try again.<br /><br />Remember: the database username and
      password is usually NOT the same as your FTP username and password. For
      most servers, the host is <tt>localhost</tt>, but you may wish to check
      with your server administrator.');
    }
    if ($db->getCode() == DB_ERROR_NOSUCHDB) {

      $dbnames = array();

      // try to get a list of databases
      $db =& DB::Connect(array(
        'username' => $_POST['user'],
        'password' => $_POST['password'],
        'hostspec' => $_POST['host'],
        'database' => '',
        'phptype' => 'mysql',
      ));
      if (!PEAR::isError($db)) {
        $result =& $db->getAll('show databases');
        if (!$db->isError($result)) {
          foreach ($result as $k => $row) {
            $dbnames[] = '<li>' . $row[0] . '</li>';
          }
        }
      }
      if (count($dbnames)) {
        show_form('The specified Database Name does not exist. The following
        databases were found at this connection:<ul>' .
        implode('', $dbnames) . '</ul>');
      }
      show_form('The specified Database Name does not exist. You must create
      this database separately. Please check the name and try again.');
    }
    show_form('The database connection could not be established: ' .
      $db->getMessage());
  }

  // all communication with database will be in UTF-8
  // (no error checking; in case pre-4.1 MySQL)
  $res = $db->query("set names 'utf8'");
  $utf8_ok = !PEAR::isError($res);

  // disable strict SQL modes for MySQL 5.0.2+
  $db->query("set sql_mode=''");

  // create or update the tables
  define('DB_PREFIX', $_POST['dbPrefix']);

  // check to see if any tables with prefix already exist
  $res = $db->getOne('show tables like ?', array(DB_PREFIX . '%'));
  if (PEAR::isError($res))
    show_form('show tables command failed: '. $res->getUserInfo());

  // make sure table existence corresponds with new/update mode
  if ($res && $_POST['install_type'] == 'new')
    show_form('You requested a new installation, but one or more tables starting with the specified prefix already exist.');
  elseif (!$res && $_POST['install_type'] == 'upgrade')
    show_form('You requested an upgrade installation, but no tables starting with the specified prefix were found.');

  if ($_POST['install_type'] == 'new') {

    // handle new installation
    $error = execute_sql(INSTALL_DIR . 'tables.sql');
    if ($error) {
      error_log("Error creating tables: " . $error['info']);
      show_form("An error occurred while creating the database tables:<br/>" . $error['message'] . '<br/><pre>' . $error['info'] . '</pre>');
    }

    $error = execute_sql(INSTALL_DIR . 'initial_data.sql');
    if ($error) {
      error_log("Error creating tables: " . $error['info']);
      show_form("An error occurred while creating the database tables:<br/>" . $error['message'] . '<br/><pre>' . $error['info'] . '</pre>');
    }

  }

  // handle database upgrade
  require_once(INSTALL_DIR . 'upgrade.inc.php');
  $upgrade = new Upgrade;
  $upgrade->do_upgrade();

  // set the application config file variables
  update_config_file(array(
    'DB_HOST' => $_POST['host'],
    'DB_USER' => $_POST['user'],
    'DB_PASS' => $_POST['password'],
    'DB_NAME' => $_POST['name'],
    'DB_PREFIX' => $_POST['dbPrefix'],
  ));

  // show confirmation
  show_confirmation();
}

// show database info form
function show_form($errmsg = '') 
{
  // set defaults if not a repost
  if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    $_POST['install_type'] = 'new';
    $_POST['dbPrefix'] = PACKAGE_DEFAULT_TABLE_PREFIX;
    $_POST['host'] = 'localhost';
  }

  show_header();

?>
<script type="text/javascript">
<!--
function fieldsAreValid() {
	var f = document.forms[0];

	var formElements = f.elements;
	var numElements = f.elements.length;
	
	// determine if valid by comparing size
	// if size = 6 & is not number, then not valid input
	// if size = 10 & is not color code, then not valid input
		
	for ( var i = 0; i < numElements; i++ ) {
		var elemName = f.elements[i].name;
		var elemValue = f.elements[i].value;
		var elemSize = f.elements[i].size;
		var elemType = f.elements[i].type;
		
		// all fields are required
		if ( elemType == 'text' && elemName != 'password' && elemName != 'dbPrefix' ) {
		
			if ( elemValue == "" ) {
				alert( 'One or more required fields was left empty.' );
				f.elements[i].focus();
				return false;
			}
		}
		
	}
	
	// check if user checked 'backup' checkboxes
	
	if ( f.install_type[1].checked && ( f.backup_web.checked == false || f.backup_database.checked == false ) ) {
		alert( 'Please confirm that your web files and database have been backed up.' );
		f.backup_web.focus();
		return false;
	}
	return true;
}
//-->
</script>

<h2>Step 2: Database Configuration</h2>

<form method="post" action="install.php">

<p>Is this a new installation or upgrade from a previous version?</p>

<div class="box">
<table>
<tr>
  <td valign="top">
    <input type="radio" name="install_type" value="new" <?php if (@$_POST['install_type'] != 'upgrade') echo ' checked="checked"'; ?> />
  </td>
  <td>This is a NEW installation of <?php echo htmlspecialchars(PACKAGE_NAME) ?></td>
</tr>
<tr>
  <td valign="top">
    <input type="radio" name="install_type" value="upgrade" <?php if (@$_POST['install_type'] == 'upgrade') echo ' checked="checked"'; ?> />
  </td>
  <td>This is an upgrade for my current <?php echo htmlspecialchars(PACKAGE_NAME) ?> installation. The installer will add any fields missing from your current tables. Existing fields will NOT be removed. <strong>Be sure to specify the same
  table prefix below as in your original installation.</strong><br />
<input type="checkbox" name="backup_web" value="1" <?php if (@$_POST['backup_web']) echo ' checked="checked"'; ?> />  I have completely backed up my current <?php echo htmlspecialchars(PACKAGE_NAME) ?> web files.<br />
    <input type="checkbox" name="backup_database" value="1" <?php if (@$_POST['backup_database']) echo ' checked="checked"'; ?> />  I have completely backed up my database.<br />
  </td>
</tr>
</table>
<table>
<tr>
  <td class="label">Table Prefix:</td>
<td><input size="20" name="dbPrefix" value="<?php echo htmlspecialchars(@$_POST['dbPrefix']) ?>" /></td>
</tr>
</table>

<p>This prefix will be prepended to each table name created. You may leave this
blank if desired.</p>

</div>

<p>I need some information about how to connect to your database. If you do not
know this information, then please contact your website host or administrator.
Please note that this is probably NOT the same as your FTP login
information!</p>

<div class="box">
<?php if (@!empty($errmsg)) echo '<div class="error">', $errmsg, '</div>'; ?>
<table>

<tr>
  <td class="label">Database Host:</td>
  <td><input size="20" name="host" value="<?php echo htmlspecialchars(@$_POST['host']) ?>" /></td>
</tr>

<tr>
  <td class="label">Database User:</td>
  <td><input size="20" name="user" value="<?php echo htmlspecialchars(@$_POST['user']) ?>" /></td>
</tr>

<tr>
  <td class="label">Database Password:</td>
  <td><input type="password" size="20" name="password" value="<?php echo htmlspecialchars(@$_POST['password']) ?>" /></td>
</tr>

<tr>
  <td class="label">Database Name:</td>
  <td><input size="20" name="name" value="<?php echo htmlspecialchars(@$_POST['name']) ?>" /></td>
</tr>

</table>

</div>
<p style="text-align: right">
  <input type="hidden" name="step" value="2" />
  <input type="submit" value="Continue &gt;&gt;" onclick="javascript:return fieldsAreValid();" />
</p>
</form>
<?php
  show_footer();
  exit;
}

// show confirmation that table creation/update is complete
function show_confirmation() 
{
  show_header();
?>
<div class="box">
  <p class="success">The database connection was established successfully.</p>
  <p class="success">The database tables were created or updated successfully.</p>
  <p class="success">The application configuration file was updated successfully.</div>
<form method="get" action="install.php">
<p style="text-align: right">
  <input type="hidden" name="step" value="3" />
  <input type="submit" value="Continue &gt;&gt;" onclick="javascript:return fieldsAreValid();" />
</p>
</form>
<?php
  show_footer();
  exit;
}

// executes sql queries from a file
// on success, returns false. on error, returns an array containing error
// details.
function execute_sql($fileName)
{
  global $db, $utf8_ok;

  @set_time_limit(120);

  // read the data
  $fd = @fopen ($fileName, 'r');
  if ($fd === false)
    show_error("Unable to open SQL file '$fileName'");
  $data = fread($fd, filesize ($fileName));
  fclose($fd);

  // split into separate statements
  $queries = splitSql($data);

  // execute each statement
  foreach ($queries as $sql) {
    $sql = trim($sql);

    // skip comments
    if (empty($sql) || $sql[0] == '#' || substr($sql,0,2) == '--')
        continue;

    // set table prefix
    $sql = str_replace('[prefix]', DB_PREFIX, $sql);

    // if database doesn't support utf8, remove the character set declaration
    if (!$utf8_ok) $sql = str_replace('character set utf8', '', $sql);

    // execute the statement and handle errors
    $result = $db->query($sql);
    if ($db->isError($result)) {
      if ($result->code == DB_ERROR_ALREADY_EXISTS)
        continue;
      return array('info' => $result->userinfo, 'message'=> $result->message, 'code'=> $result->code );
    }
  }
  return false;
}

// split sql script into array of separate statements
function splitSql($sql)
{
  // strip comments (lines beginning with # or --)
  $sql = preg_replace('/^#.*/m', '', $sql);
  $sql = preg_replace('/^--.*/m', '', $sql);

  // break into statements on blank lines
  $sql = preg_replace('/\r/', '', $sql);
  $queries = preg_split('/\n\n+/', $sql, -1, PREG_SPLIT_NO_EMPTY);
  trim_array($queries);
 
  return $queries;
}

?>
