<?php

// intialize environment
set_magic_quotes_runtime(0);

// package-specific installation settings
require_once('install_config.php');

// support functions
require_once(INSTALL_DIR . 'install_funcs.php');

// strip slashes
if (get_magic_quotes_gpc()) {
  clean_array($_GET);
  clean_array($_POST);
  clean_array($_REQUEST);
  clean_array($_SERVER);
}

// trim surrounding whitespace on all request parameters
trim_array($_GET);
trim_array($_POST);
trim_array($_REQUEST);

// check for required PHP version
if (!have_required_php_version()) {
  show_header();
  echo '<p class="subtitle">Incorrect PHP version!</p>';
  echo '<p>This application requires PHP version ', PACKAGE_MIN_PHP_VERSION,
    ' or higher. You have version ' . phpversion() . '</p>';
  echo '<p>The installation cannot proceed.</p>';
  show_footer();
  exit();
}

// check for critcial required directories and files
$missing = array();
foreach ($PACKAGE_REQUIRED_DIRS as $k => $dir) {
  if (!is_dir(PACKAGE_ROOT . $dir)) {
    $missing[] = "Directory $dir";
  }
}
foreach ($PACKAGE_REQUIRED_FILES as $k => $file) {
  if (!is_file(PACKAGE_ROOT . $file)) {
    $missing[] = "File $file";
  }
}
if (!empty($missing)) {
  show_header();
  echo '<p class="subtitle">One or more critical application files is missing!</p>';
  echo '<p>Your installation is incomplete or corrupted. The following required item(s) are missing:</p>';
  echo '<ul>';
  foreach ($missing as $k => $entry) {
    echo '<li>', htmlspecialchars($entry), '</li>';
  }
  echo '</ul>';
  echo '<p>Please correct these error(s) and restart the installation.</p>';
  show_footer();
  exit();
}

// dispatch to appropriate page based on 'step' setting
$step = @$_REQUEST['step'];
if (!isset($step)) $step = 1;
if (!preg_match('/^[0-9.]+$/', $step)) {
  show_error('Invalid "step" ' . $step);
}
$fname = INSTALL_DIR . "step_$step.php";
if (!file_exists($fname)) {
  show_error('Invalid "step" ' . $step);
}
require($fname);

// returns true if required PHP version is present
function have_required_php_version() 
{
  if (function_exists('version_compare')) {
    $ok = version_compare(phpversion(), PACKAGE_MIN_PHP_VERSION, '>=');
  }
  else {
    $v1 = explode('.', phpversion());
    $v2 = explode('.', PACKAGE_MIN_PHP_VERSION);
    $ok = true;
    for ($i = 0; $i < count($v1); $i++) {
      if ($v1[$i] < $v2[$i])
        $ok = false;
      if ($v1[$i] > $v2[$i])
        break;
    }
  }
  return $ok;
}

?>
