<?php

// strip slashes recursively through array
function clean_array(&$arr) 
{
	foreach ($arr as $k => $v) {
		if (is_array($v))
			clean_array($arr[$k]);
		else
			$arr[$k] = stripslashes($v);
	}
}

// trim whitespace recursively through array
function trim_array(&$arr) 
{
	foreach ($arr as $k => $v) {
		if (is_array($v))
			trim_array($arr[$k]);
		else
			$arr[$k] = trim($v);
	}
}

// display an unexpected error message
function show_error($msg) 
{
  show_header();
  echo '<h2 class="error">Internal Error</h2>';
  echo '<p>The following unexpected error occurred:</p>';
  echo '<div class="box"><p class="error">', htmlspecialchars($msg), '</p></div>';
  show_footer();
  exit();
}

// show standard page header
function show_header() 
{
  require_once(INSTALL_DIR . 'install_header.php');
}

// show standard page footer
function show_footer() 
{
  require_once(INSTALL_DIR . 'install_footer.php');
}

// update the application config file by replacing define() statements
// with the corresponding statements from $replace.
function update_config_file($replace) 
{
  $path = PACKAGE_ROOT . PACKAGE_CONFIG_FILE;
  // read the file
  $lines = file($path);
  if ($lines === FALSE)
    show_error("Unable to read application configuration file $path");

  // change lines as appropriate
  $result = '';
  foreach ($lines as $k => $line) {
    preg_replace('/\r*$/', "\r", $line);
    if (preg_match('/^\s*define\s*\(\s*\'(\w+)\'/', $line, $matches)) {
      $name = $matches[1];
      if (isset($replace[$name])) {
        $val = $replace[$name];
        if ($val === true)
          $val = 'true';
        elseif ($val === false)
          $val = 'false';
        else
          $val ="'$val'";
        $line = "define('$name', $val);\r\n";
      }
    }
    $result .= $line;
  }

  // write the file contents back out
  $fp = @fopen($path, 'w');
  if ($fp === FALSE)
    show_error("Unable to update application config file $path");
  fwrite($fp, $result);
  fclose($fp);
}

?>
