<?php

// set these as appropriate for the package being installed
define('PACKAGE_NAME', 'GPix Pixel Ad Script');
define('PACKAGE_VERSION', '1.4.0');

// minimum PHP version required by the application
define('PACKAGE_MIN_PHP_VERSION', '4.0.6');

// application default table prefix
define('PACKAGE_DEFAULT_TABLE_PREFIX', 'mp_');

// application config file (relative to PACKAGE_ROOT)
define('PACKAGE_CONFIG_FILE', 'config.php');

// PEAR dirs (relative to PACKAGE_ROOT)
define('PEAR_DIR', 'libs/Pear/');
//value for republishing uncoment it if you have big images
//define('PUBLISH_MEMORY_LIMIT', '128M');

// Smarty dirs (relative to PACKAGE_ROOT)
define('SMARTY_DIR', 'libs/Smarty/');
define('SMARTY_TEMPLATE_DIR', 'templates/');
define('SMARTY_COMPILE_DIR', 'templates_c/');
define('SMARTY_CACHE_DIR', 'cache/');

// Other dirs (relative to PACKAGE_ROOT)
define('INCLUDES_DIR', 'includes/');
define('LIBS_DIR', 'libs/');
define('TEMP_DIR', 'temp/');
define('GRIDS_DIR', 'grids/');
define('USERFILES_DIR', 'UserFiles/');

// required application directories (relative to PACKAGE_ROOT)
$PACKAGE_REQUIRED_DIRS = array(
  SMARTY_CACHE_DIR,
  INCLUDES_DIR,
  LIBS_DIR,
  PEAR_DIR,
  SMARTY_DIR,
  TEMP_DIR,
  GRIDS_DIR,
  USERFILES_DIR,
  SMARTY_TEMPLATE_DIR,
  SMARTY_COMPILE_DIR,
);

// required application files (relative to PACKAGE_ROOT)
$PACKAGE_REQUIRED_FILES = array(
  PACKAGE_CONFIG_FILE,
  'index.php',
);

// set include path to application libs used by installer
ini_set('include_path', implode(PATH_SEPARATOR, array(
  '.', 
  PACKAGE_ROOT . SMARTY_DIR, 
  PACKAGE_ROOT . PEAR_DIR,
)));

?>
