<?php

class vBulletin_Integration extends Integration{
   var $settings;
  
  function setup() {
    if (isset($this->app) && is_object($this->app)) {
      $configuration_file_path = $this->app->variable_get('vBulletin', 'configuration_file');
      if (is_file($configuration_file_path)) {
        if (is_readable($configuration_file_path)) {
          include($configuration_file_path);
          $this->settings->db_user = $config['MasterServer']['username'];
          $this->settings->db_password = $config['MasterServer']['password'];
          $this->settings->db_host = $config['MasterServer']['servername'];
          $this->settings->db_name = $config['Database']['dbname'];
          $this->settings->db_prefix = $config['Database']['tableprefix'];
          $this->settings->db_driver = $config['Database']['dbtype'];
          $this->settings->cookie_prefix = $config['Misc']['cookieprefix'];
        }
      }
    }
  }
  
  function get_name() {
    return 'vBulletin';
  }
  
  function process_configuration_settings($settings) {
    parent::process_configuration_settings($settings);

    $configuration_file_path = $this->app->variable_get('vBulletin', 'configuration_file', false);

    if ($configuration_file_path) {
      if (is_file($configuration_file_path)) {
        if (is_readable($configuration_file_path)) {
          include_once($configuration_file_path);
        } else {
          $this->app->error('##Configuration is not readable##');
        }
      } else {
        $this->app->error('##Path to configuration file is wrong##');
      }

      if (!$this->app->variable_get('vBulletin', 'url') && strpos('http://', $this->app->variable_get('vBulletin', 'url')) === false && strpos('https://', $this->app->variable_get('vBulletin', 'url')) === false) {
        $this->app->error('##URL to your vBulletin installation need to have "https://" or "http://"##');
      }
    }
  }
  
  function get_configuration_page(){
    $this->setup();
    $this->smarty->assign('JConfig', $this->settings);

    return parent::get_configuration_page();
  }
  
  function prepare_session() {
    $this->setup();
    
    $this->vBulletin_db =& DB::connect(
      array(
        'username' => $this->settings->db_user,
        'password' => $this->settings->db_password,
        'hostspec' => $this->settings->db_host,
        'database' => $this->settings->db_name,
        'phptype' => $this->settings->db_driver,
      )
    );

    $cookie_name = $this->settings->cookie_prefix.'sessionhash';
    if (isset($_COOKIE[$cookie_name]) && $_COOKIE[$cookie_name]) {
      $user = $this->vBulletin_db->getRow('SELECT * FROM '.$this->settings->db_prefix.'session s RIGHT JOIN '.$this->settings->db_prefix.'user u ON(s.userid=u.userid) WHERE sessionhash = '.$this->vBulletin_db->quoteSmart($_COOKIE[$cookie_name]), DB_FETCHMODE_OBJECT);
      if (DB::isError($this->vBulletin_db)) {
        trigger_error('Unable to connect to database: ' . $this->vBulletin_db->getMessage(), E_USER_ERROR);
      }

      if ($user) {
        $user = array(
          'id' => $user->userid, 
          'email' => $user->email, 
          'pass' => md5($user->password), 
          'first_name' => $user->username, 
          'last_name' => '', 
        );
      } else {
        $user = false;
      }
      
      if ($user) {
        parent::prepare_user($user);
        parent::prepare_session((object)$user);
      } else {
        parent::prepare_clean_session();
      }
    } else {
      $user = false;
    }

    return $user;
  }
  
  function get_link($type) {
    switch($type) {
      case 'login':
        $link = $this->app->variable_get('vBulletin', 'url').'index.php';
      break;

      case 'register':
        $link = $this->app->variable_get('vBulletin', 'url').'register.php';
      break;

      case 'logout':
        $link = $this->app->variable_get('vBulletin', 'url').'login.php?do=logout';
      break;
    }

    return $link;
  }
}