<?php

class Mamba_Integration extends Integration{
   var $settings;
  
  function setup() {
    if (isset($this->app) && is_object($this->app)) {
      $configuration_file_path = $this->app->variable_get('Mamba', 'configuration_file');
      if (is_file($configuration_file_path)) {
        if (is_readable($configuration_file_path)) {
          include($configuration_file_path);
          $this->settings->db_host = $mosConfig_host;
          $this->settings->db_user = $mosConfig_user;
          $this->settings->db_pass = $mosConfig_password;
          $this->settings->db_name = $mosConfig_db;
          $this->settings->db_prefix = $mosConfig_dbprefix;
          $this->settings->site_name = $mosConfig_sitename;
        }
      }
    }
  }
  
  function get_name() {
    return 'Mamba';
  }
  
  function process_configuration_settings($settings) {
    parent::process_configuration_settings($settings);

    $configuration_file_path = $this->app->variable_get('Mamba', 'configuration_file');

    if ($configuration_file_path) {
      if (is_file($configuration_file_path)) {
        if (is_readable($configuration_file_path)) {
          include($configuration_file_path);
        } else {
          $this->app->error('##Configuration is not readable##');
        }
      } else {
        $this->app->error('##Path to configuration file is wrong##');
      }

      if ($this->app->variable_get('Mamba', 'url') && strpos($this->app->variable_get('Mamba', 'url'), 'http://') === false && strpos($this->app->variable_get('Mamba', 'url'), 'https://') === false) {
        $this->app->error('##URL to your Mamba installationneed to have "https://" or "http://"##');
      }
    }
  }
  
  function get_configuration_page(){
    $this->setup();
    $this->smarty->assign('Mamba', $this->settings);

    return parent::get_configuration_page();
  }
  
  function prepare_session() {
    $this->setup();

    $this->Mamba_db =& DB::connect(
      array(
        'username' => $this->settings->db_user,
        'password' => $this->settings->db_pass,
        'hostspec' => $this->settings->db_host,
        'database' => $this->settings->db_name,
        'phptype' => 'mysql'
      )
    );

    $cookie_id = md5('site'.trim($this->app->variable_get('Mamba', 'url'), '/'));
    if (isset($_COOKIE[$cookie_id]) && $_COOKIE[$cookie_id]) {
      $sql = 'SELECT * FROM '.$this->settings->db_prefix.'session s RIGHT JOIN '.$this->settings->db_prefix.'users u ON(s.userid=u.id) WHERE s.session_id = '.$this->Mamba_db->quoteSmart(md5($_COOKIE[$cookie_id].$_SERVER['REMOTE_ADDR']));
      $user = $this->Mamba_db->getRow($sql, DB_FETCHMODE_OBJECT);

      if (DB::isError($this->Mamba_db))
        trigger_error('Unable to connect to database: ' . $this->Mamba_db->getMessage(), E_USER_ERROR);
      
      if ($user) {
        $user = array(
          'id' => $user->id, 
          'email' => $user->email, 
          'pass' => md5($user->password), 
          'first_name' => $user->name, 
          'last_name' => '', 
        );
      } else {
        $user = false;
      }
      if ($user) {
        parent::prepare_user($user);
        parent::prepare_session((object)$user);
      } else {
        parent::prepare_clean_session();
      }
    } else {
      $user = false;
    }

    return $user;
  }
  
  function get_link($type) {
    switch($type) {
      case 'login':
        $link = $this->app->variable_get('Mamba', 'url').'index.php';
      break;

      case 'register':
        $link = $this->app->variable_get('Mamba', 'url').'index.php?option=com_registration&task=register';
      break;

      case 'logout':
        $link = $this->app->variable_get('Mamba', 'url').'/index.php?option=logout&op2=logout';
      break;
    }
    
    return $link;
  }
}