<?php

class Joomla_Integration extends Integration{
   var $settings;
  
  function setup() {
    if (isset($this->app) && is_object($this->app)) {
      $configuration_file_path = $this->app->variable_get('joomla', 'configuration_file');
      if (is_file($configuration_file_path)) {
        if (is_readable($configuration_file_path)) {
          include_once($configuration_file_path);
          $this->settings = new JConfig;
        }
      }
    }
  }
  
  function get_name() {
    return 'Joomla';
  }
  
  function process_configuration_settings($settings) {
    parent::process_configuration_settings($settings);

    $configuration_file_path = $this->app->variable_get('joomla', 'configuration_file');

    if ($configuration_file_path) {
      if (is_file($configuration_file_path)) {
        if (is_readable($configuration_file_path)) {
          include($configuration_file_path);
        } else {
          $this->app->error('##Configuration is not readable##');
        }
      } else {
        $this->app->error('##Path to configuration file is wrong##');
      }
      
      if (strpos($this->app->variable_get('joomla', 'url'), 'http://') === false && strpos($this->app->variable_get('joomla', 'url'), 'https://') === false) {
        $this->app->error('##URL to your joomla installationneed to have "https://" or "http://"##');
      }
    }
  }
  
  function get_configuration_page(){
    $this->setup();
    $this->smarty->assign('JConfig', $this->settings);

    return parent::get_configuration_page();
  }
  
  function prepare_session() {
    $this->setup();

    $this->joomla_db =& DB::connect(
      array(
        'username' => $this->settings->user,
        'password' => $this->settings->password,
        'hostspec' => $this->settings->host,
        'database' => $this->settings->db,
        'phptype' => $this->settings->dbtype
      )
    );

    $cookie_name = md5($this->getHash('site'));
    $session_id = isset($_COOKIE[$cookie_name]) ? $_COOKIE[$cookie_name] : null;
    if (!is_null($session_id)) {
      $user = $this->joomla_db->getRow('SELECT * FROM '.$this->settings->dbprefix.'session s RIGHT JOIN '.$this->settings->dbprefix.'users u ON(s.userid=u.id) WHERE session_id = '.$this->joomla_db->quoteSmart($session_id), DB_FETCHMODE_OBJECT);

      if (DB::isError($this->joomla_db))
        trigger_error('Unable to connect to database: ' . $this->joomla_db->getMessage(), E_USER_ERROR);
      
      if ($user) {
        $user = array(
          'id' => $user->id, 
          'email' => $user->email, 
          'pass' => md5($user->password), 
          'first_name' => $user->name, 
          'last_name' => '', 
        );
      } else {
        $user = false;
      }
      if ($user) {
        parent::prepare_user($user);
        parent::prepare_session((object)$user);
      } else {
        parent::prepare_clean_session();
      }
    } else {
      $user = false;
    }

    return $user;
  }
  
  function getHash($seed) {
    return md5( $this->settings->secret .  $seed  );
  }

}