<?php

class Drupal_Integration extends Integration{
   var $settings;
  
  function setup() {
    if (isset($this->app) && is_object($this->app)) {
      $configuration_file_path = $this->app->variable_get('Drupal', 'configuration_file');
      if (is_file($configuration_file_path)) {
        if (is_readable($configuration_file_path)) {
          $settings = $this->get_db_settings($configuration_file_path);
          $settings['db_prefix'] = $this->get_db_prefix($configuration_file_path);
          $settings['session_name'] = $this->get_session_name($configuration_file_path);
          $this->settings = (object)$settings;
        }
      }
    }
  }
  
  function get_session_name($configuration_file_path) {

    $file = file_get_contents($configuration_file_path);
    preg_match_all('/cookie_domain.*=.*\;/', $file, $settings_strings);
    $$cookie_domain = array_shift(array_shift($settings_strings));
    if (strpos('example.com', $db_settings_string)) {
      $cookie_domain = ini_get('session.cookie_domain');
    }
    
    if ($cookie_domain) {
      $session_name = $cookie_domain;
    } else {
      list( , $session_name) = explode('://', trim($this->app->variable_get('Drupal', 'url'), '/'), 2);
      if (ini_get('session.cookie_secure')) {
        $session_name .= 'SSL';
      }
      $session_name = 'SESS'. md5($session_name);
    }
    
    return $session_name;
  }


  function get_db_prefix($configuration_file_path) {
    $file = file_get_contents($configuration_file_path);
    preg_match_all('/db_prefix.*=.*\;/', $file, $db_settings_strings);
    $db_settings_strings = array_shift($db_settings_strings);
    
    foreach($db_settings_strings as $db_settings_string_tmp) {
      if (strpos($db_settings_string_tmp, 'main_') === false) {
        $db_settings_string = $db_settings_string_tmp;
      }
    }

    $db_settings_string = str_replace('db_prefix', '', $db_settings_string);
    $db_settings_string = str_replace('=', '', $db_settings_string);
    $db_settings_string = str_replace(';', '', $db_settings_string);
    $db_settings_string = str_replace('\'', '', $db_settings_string);
    $db_settings_string = trim($db_settings_string);
    
    return $db_settings_string;
  }

  function get_db_string($configuration_file_path) {
    $file = file_get_contents($configuration_file_path);
    preg_match_all('/db_url.*=.*\;/', $file, $db_settings_strings);
    $db_settings_strings = array_shift($db_settings_strings);
    foreach($db_settings_strings as $db_settings_string_tmp) {
      if (strpos($db_settings_string_tmp, 'username') === false && strpos($db_settings_string_tmp, 'password') === false) {
        $db_settings_string = $db_settings_string_tmp;
      }
    }
    
    return $db_settings_string;
  }
  
  function get_db_settings($configuration_file_path) {
    $db_settings_string = $this->get_db_string($configuration_file_path);
    
    if ($db_settings_string) {
      $db_settings_string = str_replace('db_url', '', $db_settings_string);
      $db_settings_string = str_replace('=', '', $db_settings_string);
      $db_settings_string = str_replace(';', '', $db_settings_string);
      $db_settings_string = trim($db_settings_string);
      $db_settings_string = trim($db_settings_string, '\'');
      
      list($db_type, $db_settings_string) = explode('://', $db_settings_string);
      list($db_user, $db_settings_string) = explode(':', $db_settings_string);
      list($db_pass, $db_settings_string) = explode('@', $db_settings_string);
      list($db_host, $db_name) = explode('/', $db_settings_string);
      $db_settings_string = array(
        'db_driver' => $db_type,
        'db_user' => $db_user,
        'db_pass' => $db_pass,
        'db_host' => $db_host,
        'db_name' => $db_name,
      );
    } else {
      $db_settings_string = false;
    }

    return $db_settings_string;
  }
  
  function get_name() {
    return 'Drupal';
  }
  
  function process_configuration_settings($settings) {
    parent::process_configuration_settings($settings);

    $configuration_file_path = $this->app->variable_get('Drupal', 'configuration_file', false);

    if ($configuration_file_path) {
      if (is_file($configuration_file_path)) {
        if (is_readable($configuration_file_path)) {
          $this->setup();
        } else {
          $this->app->error('##Configuration is not readable##');
        }
      } else {
        $this->app->error('##Path to configuration file is wrong##');
      }

      if ($this->app->variable_get('Drupal', 'url') && strpos($this->app->variable_get('Drupal', 'url'), 'http://') === false && strpos($this->app->variable_get('Drupal', 'url'), 'https://') === false) {
        $this->app->error('##URL to your Drupal installation need to have "https://" or "http://"##');
      }
    }
  }
  
  function get_configuration_page(){
    $this->setup();

    return parent::get_configuration_page();
  }
  
  function prepare_session() {
    $this->setup();
    
    $this->Drupal_db =& DB::connect(
      array(
        'username' => $this->settings->db_user,
        'password' => $this->settings->db_pass,
        'hostspec' => $this->settings->db_host,
        'database' => $this->settings->db_name,
        'phptype' => $this->settings->db_driver,
      )
    );

    $cookie_name = $this->settings->session_name;
    if (isset($_COOKIE[$cookie_name]) && $_COOKIE[$cookie_name]) {
      $user = $this->Drupal_db->getRow('SELECT * FROM '.$this->settings->db_prefix.'sessions s RIGHT JOIN '.$this->settings->db_prefix.'users u ON(s.uid=u.uid) WHERE s.sid = '.$this->Drupal_db->quoteSmart($_COOKIE[$cookie_name]), DB_FETCHMODE_OBJECT);

      if (DB::isError($this->Drupal_db)) {
        trigger_error('Unable to connect to database: ' . $this->Drupal_db->getMessage(), E_USER_ERROR);
      }

      if ($user) {
        $user = array(
          'id' => $user->uid, 
          'email' => $user->mail, 
          'pass' => md5($user->pass), 
          'first_name' => $user->name, 
          'last_name' => '', 
        );
      } else {
        $user = false;
      }
      
      if ($user) {
        parent::prepare_user($user);
        parent::prepare_session((object)$user);
      } else {
        parent::prepare_clean_session();
      }
    } else {
      $user = false;
    }

    return $user;
  }
  
  function get_link($type) {
    switch($type) {
      case 'login':
        $link = $this->app->variable_get('Drupal', 'url').'?q=user';
      break;

      case 'register':
        $link = $this->app->variable_get('Drupal', 'url').'?q=user/register';
      break;

      case 'logout':
        $link = $this->app->variable_get('Drupal', 'url').'?q=logout';
      break;
    }

    return $link;
  }
}