<?php

require_once('admin_config.php');
require_once('grid.class.php');
require_once('region.class.php');
require_once('util.class.php');

$tbl = new Region;
if (!isset($_REQUEST['id']))
  $app->abort('##expected id##');
$region = $tbl->get($_REQUEST['id']);

$tbl = new Grid;
$grid = $tbl->get($region->grid_id);

$template = 'admin/edit_region.tpl';

if ($app->is_post()) {
  if (@$_REQUEST['action'] == 'delete') {
    if (!@$_REQUEST['confirm']) {
      $smarty->display('admin/edit_region_confirm.tpl');
      exit;
    }
    $region->delete();
    $grid->is_dirty = 1;
    $grid->save();
    $app->redirect('/admin/maintain_regions.php', array('grid_id' => $grid->id));
  } elseif (@$_REQUEST['upload_image'] == 1) {
    // show form to upload image
    $_REQUEST['upload_image'] = 2;
    $predefined_images = Util::predefined_images();
    $smarty->assign_by_ref('predefined_images', $predefined_images);
    $template = 'admin/edit_region_upload.tpl';
  } elseif (@$_REQUEST['upload_image'] == 2) {
    // handle uploaded image
    if (@$_REQUEST['submit_button'] != 'Cancel') {
      if (!Util::process_image_upload($region->width, $region->height))
        $template = 'admin/edit_region_upload.tpl';
    }
  } else {
    // update region
    $region->status = @$_REQUEST['status'];
    $region->url = @$_REQUEST['url'];
    $region->title = @$_REQUEST['title'];
    $region->alt = @$_REQUEST['alt'];
    $region->email = @$_REQUEST['email'];
    $region->notes = @$_REQUEST['notes'];
    $region->image = @$_SESSION['image'];
    $region->original_image = @$_SESSION['original_image'];
    $region->clicks = @$_REQUEST['clicks'];
    $region->expires_at = @$_REQUEST['expires_at'];
    $region->description = @$_REQUEST['description'];
    $region->reminder_at = @$_REQUEST['reminder_at'];
    $region->purge_at = @$_REQUEST['purge_at'];
    $region->category_id = @(int)$_REQUEST['category_id'];
    if ($region->validate()) {
      if (isset($_REQUEST['send_confirmation']) && $_REQUEST['send_confirmation']) {
        require_once('get_pixels.inc.php');
        if ($grid->allow_free_paid == 'true'){
          $update_url_param = array('id' => $region->id);
          if (!$app->setting->user_accounts)
            $update_url_param['digest'] = $app->digest(array($region->id));

          $app->mail($region->email, 'confirmation_customers_active', array(
            '[site_url]' => $app->url('/'),
            '[banner_url]' => $grid->url(),
            '[site_name]' => $app->setting->site_name,
            '[confirmation_number]' => $region->id,
            '[update_url]' => $app->url('/update.php', $update_url_param, true, true)
            ));
        } else {
          send_purchase_confirmation($region, 0);
        }
        $app->error("Purchase confirmation sent");
      }
      else {
        $region->save();
        $grid->is_dirty = 1;
        $grid->save();
        unset($_SESSION['image']);
        $app->redirect('/admin/maintain_regions.php', array('grid_id' => $grid->id()));
      }
    }
  }
}
else {
  foreach ($region->attr() as $name => $val) {
    $_REQUEST[$name] = $val;
  }
  $_SESSION['image'] = $region->image;
  $_SESSION['original_image'] = $region->original_image;
}

if ($app->settings->categories->regions) {
  $categories_tmp = $db->getAll('SELECT id, name FROM `!` WHERE type=\'regions\'', array(DB_PREFIX.'categories'), DB_FETCHMODE_ASSOC);
  if (count($categories_tmp)) {
    $categories[''] = '';
    foreach($categories_tmp as $category) {
      $categories[$category['id']] = $category['name'];
    }

    $smarty->assign('categories', $categories);
  }
}
  
$smarty->assign('region', $region);
$smarty->assign('grid', $grid);
$smarty->display($template);

?>
