<?php

require_once('admin_config.php');
require_once('HTTP/Request.php');
require_once('region.class.php');
require_once('grid.class.php');


if ($app->is_post()) {
  @set_time_limit(0);
  
  $checker =& new HTTP_Request('', array('allowRedirects' => true, 'maxRedirects' => 10));
  $checker->addHeader('User-Agent', 'GPix backlink checker');
  $regions =& $db->query('SELECT * FROM `!` g RIGHT JOIN `!` r ON (g.id=r.grid_id) WHERE g.back_links=\'1\'', array(DB_PREFIX.'grids', DB_PREFIX.'regions'));

  $grids = array();
  
  $processed = 0;
  $regions_suspended = 0;
  $regions_active = 0;
  while ($row = $regions->fetchRow(DB_FETCHMODE_OBJECT)) {
    $region = new Region($row->id);
    $region->set_attr(array('_new_row' => false));
    $processed++;
    
    $checker->setURL($region->url);
    $checker->sendRequest();

    if ($checker->getResponseCode() == 200) {
      $grid = new Grid;
      $grid = $grid->get($region->grid_id);
      $grids[$region->grid_id] = true;
      if (preg_match('|'.$grid->back_link.'|', $checker->getResponseBody())) {
        $region->setStatus(REGION_ACTIVE);
        $region->save(false);
        $regions_active++;
      } else {
        $region->setStatus(REGION_SUSPENDED);
        $region->save(false);
        $regions_suspended++;
      }
    } else {
      $region->setStatus(REGION_SUSPENDED);
      $region->save(false);
      $regions_suspended++;
    }
  }

  $grid = new Grid;
  foreach ($grids as $k => $allow) {
    if ($allow) {
      $grid = $grid->get($k);
      $grid->publish(true);
    }
  }

  $smarty->clear_all_cache();
  $smarty->clear_compiled_tpl();
  
  $smarty->assign('grids', count($grids));
  $smarty->assign('regions', $processed);
  $smarty->assign('suspended', $regions_suspended);
  $smarty->assign('active', $regions_active);
  $smarty->display('admin/backlink_checker_results.tpl');
} else {
  $smarty->display('admin/backlink_checker.tpl');
}

?>