-- tables.sql
-- MySQL statements to recreate all application tables.
-- statements MUST be separated by blank lines.
-- the token '[prefix]' will be replaced with the chosen table
-- prefix at installation time.

-- NOTE: this file is frozen as of schema version 14
--       all additional changes to schema will be implemented
--       through upgrade.inc.php

create table `[prefix]admin_users` (
  `id` int not null auto_increment,
  `user` varchar(32) not null default '',
  `pass` varchar(32) not null default '',
  primary key (`id`)
) character set utf8;

create table `[prefix]blog_articles` (
  `id` int not null auto_increment,
  `created_at` datetime not null default '0000-00-00 00:00:00',
  primary key (`id`)
) character set utf8;

create table `[prefix]blog_comments` (
  `id` int not null auto_increment,
  `blog_article_id` int not null default 0 references `[prefix]blog_articles` (`id`),
  `author` varchar(255) not null default '',
  `body` mediumtext not null default '',
  `created_at` datetime not null default '0000-00-00 00:00:00',
  primary key (`id`)
) character set utf8;

create table `[prefix]languages` (
  `id` int not null auto_increment,
  `code` varchar(8) not null default '' unique,
  `name` varchar(30) not null default '',
  `decimal_point` varchar(8) not null default '',
  `thousands_separator` varchar(8) not null default '',
  primary key (`id`)
) character set utf8;

create table `[prefix]language_texts` (
  `id` int not null auto_increment,
  `language_id` int not null default 0 references `[prefix]languages` (`id`),
  `digest` varchar(32) not null default '',
  `language_text` mediumtext not null default '',
  unique (`language_id`, `digest`),
  primary key (`id`)
) character set utf8;

create table `[prefix]grids` (
  `id` int not null auto_increment,
  `name` varchar(32) not null default '',
  `display_order` int not null default 0,
  `width` int not null default 0,
  `height` int not null default 0,
  `grid_color` varchar(32) not null default '',
  `grid_transparency` int not null default 0,
  `background_color` varchar(32) not null default '',
  `background_image` longblob null,
  `background_thumbnail_image` longblob null,
  `pixel_price` decimal(10,2) not null default 0,
  `map` mediumtext not null default '',
  `pixels_used` int not null default 0,
  `is_dirty` tinyint(1) not null default 0,
  `region_max_width` int not null default 0,
  `region_max_height` int not null default 0,
  `expire_days` int not null default 0,
  `reminder_days` int not null default 0,
  `purge_days` int not null default 0,
  primary key (`id`)
) character set utf8;

create table `[prefix]newsletters` (
  `id` int not null auto_increment,
  `created_at` datetime not null default '0000-00-00 00:00:00',
  primary key (`id`)
) character set utf8;

create table `[prefix]payment_configs` (
  `configuration_id` int(11) not null auto_increment,
  `configuration_key` varchar(64) not null default '',
  `configuration_value` varchar(255) not null default '',
  `module_key` varchar(255) not null default '',
  unique (`configuration_key`),
  primary key  (`configuration_id`)
) character set utf8;

create table `[prefix]payment_modules` (
  `id` int(11) not null auto_increment,
  `name` varchar(255) not null default '',
  `module_key` varchar(255) not null default '',
  `class_file` varchar(255) not null default '',
  `formfile` varchar(255) not null default '',
  `is_enabled` tinyint(1) not null default 0,
  `display_order` int not null default 0,
  key `name` (`name`),
  primary key (`id`)
) character set utf8;

create table `[prefix]regions` (
  `id` int not null auto_increment,
  `grid_id` int not null default 0,
  `user_id` int not null default 0,
  `x` int not null default 0,
  `y` int not null default 0,
  `width` int not null default 0,
  `height` int not null default 0,
  `status` int not null default 0,
  `image` longblob null,
  `url` varchar(255) not null default '',
  `title` varchar(255) not null default '',
  `alt` varchar(255) not null default '',
  `email` varchar(255) not null default '',
  `notes` mediumtext not null default '',
  `created_on` datetime not null default '0000-00-00 00:00:00',
  `clicks` int not null default 0,
  `expires_at` datetime not null default '0000-00-00 00:00:00',
  `reminder_at` datetime not null default '0000-00-00 00:00:00',
  `purge_at` datetime not null default '0000-00-00 00:00:00',
  primary key (`id`)
) character set utf8;

create table `[prefix]settings` (
  `id` int not null auto_increment,
  `site_name` varchar(255) null default '',
  `site_description` mediumtext null default '',
  `currency_symbol` varchar(8) null default '',
  `user_accounts` tinyint(1) null default 0,
  `approval_required` tinyint(1) null default 0,
  `admin_email` varchar(255) null default '',
  `html_email` tinyint(1) null default 0,
  `use_fckeditor` tinyint(1) null default 0,
  `secret` varchar(100) null default '',
  `interlaced_images` tinyint(1) null default 0,
  `palette_images` tinyint(1) null default 0,
  `site_down` tinyint(1) null default 0,
  `blog_comments` tinyint(1) null default 0,
  `expires_check_at` datetime null default '0000-00-00 00:00:00',
  `multiple_grid_pages` tinyint(1) null default 0,
  `grid_columns` int null default 1,
  `rss_latest_pixels` int null default 10,
  `rss_top_pixels` int null default 10,
  `rss_blog_articles` int null default 10,
  `pixel_list_by_clicks` tinyint(1) null default 1,
  primary key (`id`)
) character set utf8;

create table `[prefix]snippets` (
  `id` int not null auto_increment,
  `snippet_key` varchar(100) not null default '',
  `snippet_seq` int not null default 0,
  `language_id` int not null default 0 references `[prefix]languages` (`id`),
  `snippet_text` mediumtext not null default '',
  `is_internal` tinyint(1) not null default 0,
  unique (`snippet_key`, `snippet_seq`, `language_id`),
  primary key (`id`)
) character set utf8;

create table `[prefix]email_templates` (
  `id` int not null auto_increment,
  `email_key` varchar(100) not null default '',
  `name` varchar(100) not null default '',
  `parameters` text not null default '',
  index (`email_key`),
  primary key (`id`)
) character set utf8;

create table `[prefix]payments` (
  `id` int not null auto_increment,
  `region_id` int not null default 0 references `[prefix]regions` (`id`),
  `user_id` int not null default 0,
  `email` varchar(255) not null default '',
  `amount` decimal(10,2) not null default 0,
  `payment_method` varchar(100) not null default '',
  `is_completed` tinyint(1) not null default 0,
  `completed_at` datetime not null default '0000-00-00 00:00:00',
  `is_verified` tinyint(1) not null default 0,
  `verified_at` datetime not null default '0000-00-00 00:00:00',
  `verified_vars` text not null default '',
  `is_error` tinyint(1) not null default 0,
  `txn_id` varchar(100) not null default '',
  `notes` mediumtext not null default '',
  primary key (`id`)
) character set utf8;

create table `[prefix]payment_ids` (
  `id` int not null auto_increment,
  `payment_id` int not null default 0,
  primary key (`id`)
) character set utf8;

create table `[prefix]users` (
  `id` int not null auto_increment,
  `email` varchar(255) not null default '',
  `pass` varchar(100) not null default '',
  `first_name` varchar(100) not null default '',
  `last_name` varchar(100) not null default '',
  `created_at` datetime not null default '0000-00-00 00:00:00',
  `is_confirmed` tinyint(1) not null default 0,
  `digest` varchar(32) not null default '',
  unique (`email`),
  primary key (`id`)
) character set utf8;

create table `[prefix]schema_version` (
  `id` int not null auto_increment,
  `schema_version` int not null default 0,
  primary key (`id`)
) character set utf8;

