<?php

// step_5.php
// install languages

// execute the DB_XXX defines created in step 2. we can't just
// require() the file, because it checks for some stuff that
// isn't ready yet.
$path = PACKAGE_ROOT . PACKAGE_CONFIG_FILE;
$lines = file($path);
if ($lines === FALSE)
  show_error("Unable to read application configuration file $path");
foreach ($lines as $k => $line) {
  if (preg_match("/define\('DB_/", $line)) eval($line);
}

// connect to database
require_once('DB.php');
$db = DB::connect(array(
  'username' => DB_USER,
  'password' => DB_PASS,
  'hostspec' => DB_HOST,
  'database' => DB_NAME,
  'phptype' => 'mysql',
));
if (PEAR::isError($db))
  show_error('Unable to connect to application database: '. $db->getUserInfo());
$res = $db->query("set names 'utf8'");

// build list of languages
$langs = array(
  'ar' => array('name' => 'Arabic'),
  'de' => array('name' => 'German'),
  'fr' => array('name' => 'French'),
  'he' => array('name' => 'Hebrew'),
  'hi' => array('name' => 'Hindi'),
  'it' => array('name' => 'Italian'),
  'ja' => array('name' => 'Japanese'),
  'ru' => array('name' => 'Russian'),
  'zh' => array('name' => 'Chinese'),
);

// mark the languages already installed
$tbl = DB_PREFIX . 'languages';
$res = $db->query('select `code` from `!`', array($tbl));
if (PEAR::isError($res))
  show_error('Query failed: '. $res->getUserInfo());
while ($row = $res->fetchRow(DB_FETCHMODE_ASSOC)) {
  if (isset($langs[$row['code']]))
    $langs[$row['code']]['installed'] = true;
}

// handle POST to install/update languages
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // install or update the selected languages
  foreach ($langs as $code => $v) {
    if (@$_REQUEST['lang'][$code] || @$v['installed'])
      install_language($code, @$v['installed']);
  }

  // go to next step
  header("Location: install.php?step=6");
  exit;
}

// otherwise, show input form
show_form();

// show input form
function show_form($errmsg = '') 
{
  global $db, $langs;

  show_header();
?>
<h2>Step 5: Install Additional Languages</h2>
<script type="text/javascript">
function fieldsAreValid() {
	var f = document.forms[0];
	return true;
}
</script>

<form method="post" action="install.php">

<div class="box">

<?php if (@!empty($errmsg)) echo '<div class="error">', $errmsg, '</div>'; ?>

<p>Please select the language(s) you want to install, if any. English is always installed by default.</p>

<p>If this is an upgrade installation, the language entry below will be checked if already installed. New texts for that language (if any) will be added, but your existing translation texts will be preserved.</p>

<p>
<?php foreach($langs as $code => $v) { ?>
<input type="checkbox" name="lang[<?php echo htmlspecialchars($code) ?>]"<?php if (@$v['installed']) echo 'checked="checked" disabled="disabled"' ?> /> <?php echo htmlspecialchars($code) ?> (<?php echo htmlspecialchars($v['name']) ?>)<br />
<?php } ?>
</p>

</div>
<p style="text-align: right">
  <input type="hidden" name="step" value="5" />
  <input type="submit" value="Continue &gt;&gt;" onclick="javascript:return fieldsAreValid();" />
</p>
</form>

<?php
  show_footer();
  exit;
}

// install or upgrade specified language
function install_language($code, $upgrade)
{
  @set_time_limit(300);

  // open the XML file
  $path = PACKAGE_ROOT . "install/lang_$code.xml";
  $fh = @fopen($path, 'rb');
  if (!$fh)
    show_error("Unable to open '$path'");

  // setup stream parser
  $xml = xml_parser_create('UTF-8');
  xml_parser_set_option($xml, XML_OPTION_CASE_FOLDING, false);
  xml_parser_set_option($xml, XML_OPTION_TARGET_ENCODING, 'UTF-8');
  $obj = new LangImportHandler;
  $obj->code = $code;
  $obj->upgrade = $upgrade;
  xml_set_object($xml, $obj);
  xml_set_element_handler($xml, 'start_element', 'end_element');
  xml_set_character_data_handler($xml, 'character_data');

  // parse the document in chunks
  while ($data = fread($fh, 4096)) {
    xml_parse($xml, $data, feof($fh))
      or show_error("XML Parsing Error in '" . $path . "': " . xml_error_string(xml_get_error_code($xml)) . ' Line:' . xml_get_current_line_number($xml) . ' Column:' . xml_get_current_column_number($xml) . '. Not all texts were imported.');
  }
  @fclose($fh);

  // free the parser
  xml_parser_free($xml);

  // report any application errors during parsing
  if (!empty($xml->errors))
    show_error(implode(' ', $xml->errors));
}

// class to receive SAX events while importing language texts
class LangImportHandler
{

  var $language_id;
  var $upgrade;
  var $errors;
  var $digest;
  var $text;

  function LangImportHandler()
  {
    $this->errors = array();
  }

  function start_element($parser, $tag, $attr)
  {
    global $db;

    if ($tag == 'language') {
      unset($this->digest);
      unset($this->text);
      if ($attr['code'] != $this->code)
        $this->errors[] = '&lt;language&gt; element does not match requested language to import';
      else {
        $tbl = DB_PREFIX . 'languages';
        if (!$this->upgrade) {
          $res = $db->query('
            insert into `!` (`code`, `name`, `decimal_point`, `thousands_separator`)
            values (?, ?, ?, ?)
          ', array($tbl, $this->code, $attr['name'], $attr['decimal_sep'], $attr['thousand_sep']));
          if (PEAR::isError($res))
            show_error('insert language failed: '. $res->getUserInfo());
        }
        $this->language_id = $db->getOne('
          select id from `!` where `code`=?
        ', array($tbl, $this->code));
        if (PEAR::isError($this->language_id))
          show_error('select language: '. $this->language_id->getUserInfo());
      }
    }
    if (!empty($this->errors)) return;
    if ($tag != 'text') return;
    $this->digest = $attr['digest'];
    $this->text = '';
  }

  function end_element($parser, $tag)
  {
    global $db;
    if (!empty($this->errors)) return;
    if ($tag != 'text') return;
    $this->text = trim($this->text);
    if (!empty($this->text)) {
      // insert the text, which fails if a text already exists
      // (i.e. we don't replace texts during an upgrade of existing
      // language; we only add new texts)
      $tbl = DB_PREFIX . 'language_texts';
      $res = $db->query('
        insert into `!` (`language_id`, `digest`, `language_text`)
        values (?, ?, ?)
      ', array($tbl, $this->language_id, $this->digest, $this->text));
      if (PEAR::isError($res) && $res->getCode() != DB_ERROR_CONSTRAINT && $res->getCode() != DB_ERROR_ALREADY_EXISTS)
        show_error('insert text failed: '. $res->getUserInfo());
    }
    unset($this->digest);
    unset($this->text);
  }

  function character_data($parser, $data)
  {
    if (!isset($this->digest)) return;
    $this->text .= $data;
  }

}

?>
