<?php

// step_4.php
// mail settings

// when posted, update config file
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  update_config_file(array(
    'MAIL_TYPE' => $_POST['mailType'],
    'SMTP_HOST' => $_POST['smtpHost'],
    'SMTP_PORT' => $_POST['smtpPort'],
    'SMTP_AUTH' => @$_POST['smtpAuth'],
    'SMTP_USER' => $_POST['smtpUser'],
    'SMTP_PASS' => $_POST['smtpPass'],
    'SM_PATH' => $_POST['smPath'],
  ));

  // go to next step
  header("Location: install.php?step=5");
  exit;
}

// otherwise, show input form
show_form();

// show input form
function show_form($errmsg = '') 
{
  // set defaults if not a repost
  if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    $_POST['mailType'] = 'mail';
    $_POST['smPath'] = preg_replace('/ .*/', '', @ini_get('sendmail_path'));
  }

  show_header();
?>
<h2>Step 4: Mail Settings</h2>
<script type="text/javascript">
function fieldsAreValid() {
	var f = document.forms[0];
	
	if ( f.mailType.value == 'smtp' && (f.smtpHost.value == '' || f.smtpPort.value == '' ) ) {
		alert( 'Please specify the SMTP host and port' );
		return false;
	}
	if ( f.mailType.value == 'sendmail' && f.smPath.value == '' ) {
		alert( 'Please specify the sendmail path' );
		return false;
	}
	
	if ( f.smtpAuth.checked && ( f.smtpUser.value == '' || f.smtpPass.value == '' ) ) {
		alert( 'Please specify the smtp user and password' );
		return false;
	}
	return true;
}
</script>

<form method="post" action="install.php">

<p>I need some information about how to send email from the application.  The
default settings will work in most cases.</p>

<div class="box">

<?php if (@!empty($errmsg)) echo '<div class="error"><p>', $errmsg, '</p></div>'; ?>

<table>

<tr>
  <td class="label">Send mail by:</td>
  <td><select name="mailType">
    <option value="mail"<?php if (@$_POST['mailType'] == 'mail') echo ' selected="selected"'; ?>>Standard Mail</option>
    <option value="sendmail"<?php if (@$_POST['mailType'] == 'sendmail') echo ' selected="selected"'; ?>>Sendmail</option>
    <option value="smtp"<?php if (@$_POST['mailType'] == 'smtp') echo ' selected="selected"'; ?>>SMTP</option>
  </select></td>
</tr>

<tr>
  <td class="label">SMTP Host:</td>
  <td><input size="20" name="smtpHost" /></td>
</tr>

<tr>
  <td class="label">SMTP Port:</td>
  <td><input name="smtpPort" value="25" size="4" /></td>
</tr>

<tr>
  <td class="label">Use SMTP Authenication:</td>
  <td><input type="checkbox" size="20" name="smtpAuth" value="1" /></td>
</tr>

<tr>
  <td class="label">SMTP User:</td>
  <td valign="top"><input size="20" name="smtpUser" /></td>
</tr>

<tr>
  <td class="label">SMTP Password:</td>
  <td><input size="20" name="smtpPass" /></td>
</tr>

<tr>
  <td class="label">Path to Sendmail:</td>
  <td><input size="20" name="smPath" value="<?php echo htmlspecialchars(@$_POST['smPath']) ?>" /></td>
</tr>

</table>

<p>You must input the path to Sendmail if you chose Sendmail above. If you do
not know this value, you should contact your website administrator.</p>

<p>If you choose the SMTP mail option, please note that some commercial mail
services, like Yahoo, GMail, and Hotmail, usually reject SMTP mail requests
from PHP scripts. You should not choose this option unless you control your own
SMTP mail server. In other words, using <i>smtp.mail.yahoo.com</i> will not
work.</p>

</div>
<p style="text-align: right">
  <input type="hidden" name="step" value="4" />
  <input type="submit" value="Continue &gt;&gt;" onclick="javascript:return fieldsAreValid();" />
</p>
</form>

<?php
  show_footer();
  exit;
}

?>
