<?php

// step_3.php
// set document root 

// when posted, update config file
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
  if (empty($_POST['docroot']))
    show_form('A non-blank document root is required.');
  update_config_file(array('DOC_ROOT' => $_POST['docroot']));
  header("Location: install.php?step=4");
  exit;
}

// otherwise, show input form
show_form();

// show input form
function show_form($errmsg = '') 
{
  $docroot = $_SERVER['SCRIPT_NAME'];
  if (!preg_match('/install.php$/', $docroot)) {
    $docroot = $_SERVER['PHP_SELF'];
    update_config_file(array('USE_PHP_SELF' => 1));
  }
  $docroot = str_replace('\\', '/', dirname($docroot));
  if (substr($docroot, -1, 1) != '/')
    $docroot .= '/';

  // set defaults if not a repost
  if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    $_POST['docroot'] = $docroot;
  }

  show_header();
?>
<h2>Step 3: Document root</h2>
<form method="post" action="install.php">

<p>I need to know how to construct URL's to your application.</p>

<div class="box">
<?php if (@!empty($errmsg)) echo '<div class="error"><p>', $errmsg, '</p></div>'; ?>
<table>
<tr>
  <td class="label">Document Root:</td>
  <td><input size="20" name="docroot" value="<?php echo htmlspecialchars(@$_POST['docroot']) ?>"/></td>
</tr>
</table>

<p>The document root is the "directory" portion of the URL for the home page of
the application. It is formed by taking the full URL of the home page and
removing <span style="color: blue">index.php</span>, the <span style="color:
blue">http://</span> prefix, and the domain name. For example, if the home page
for <?php echo htmlspecialchars(PACKAGE_NAME) ?> is at <span style="color:
blue">http://www.yoursite.com/gpix/index.php</span> then the Document
Root is <span style="color: blue">/gpix/</span>. Use <span
style="color: blue">/</span> if your entire domain is dedicated to <?php echo
htmlspecialchars(PACKAGE_NAME) ?>. Note: in most cases, the supplied default
will be correct.</p>

</div>
<p style="text-align: right">
  <input type="hidden" name="step" value="3" />
  <input type="submit" value="Continue &gt;&gt;" onclick="javascript:return fieldsAreValid();" />
</p>
</form>
<?php
  show_footer();
  exit;
}

?>
