-- initial_data.sql
-- MySQL statements to insert initial data into tables for a new installation.
-- statements MUST be separated by blank lines.
-- the token '[prefix]' will be replaced with the chosen table
-- prefix at installation time.

-- NOTE: this file is frozen as of schema version 14
--       all additional changes to schema will be implemented
--       through upgrade.inc.php

insert into `[prefix]settings` (`id`, `site_name`, `currency_symbol`, `use_fckeditor`, `secret`, `site_down`) values 
    (1, 'GPix Pixel Ad Site', '$', 1, 'changeme', 1);

insert into `[prefix]admin_users` (`id`, `user`, `pass`) values 
    (1, 'admin', md5('admin'));

insert into `[prefix]languages` (`id`, `code`, `name`, `decimal_point`, `thousands_separator`) values 
    (1, 'en', 'English', '.', ',');

insert into `[prefix]grids` (`id`, `name`, `display_order`, `width`, `height`, `grid_color`, `background_color`, `is_dirty`) values 
    (1, 'Main', 1, 1000, 1000, 'E0E0E0', 'F0F0F0', 1);

insert into `[prefix]email_templates` (`id`, `email_key`, `name`, `parameters`) values 
    (1, 'email_purchase_active', 'Purchase Confirmation (Active)', '[site_name], [confirmation_number], [update_url], [email]'),
    (2, 'email_purchase_pending', 'Purchase Confirmation (Pending)', '[site_name], [confirmation_number], [update_url], [email]'),
    (3, 'signup_confirm', 'Account Signup Confirmation', '[site_name], [confirm_url], [first_name], [last_name]'),
    (4, 'tell_a_friend', 'Tell a Friend', '[site_name], [site_url], [from_name]'),
    (5, 'retrieve_password', 'Retrieve Password', '[site_name], [login_url], [email], [password]'),
    (6, 'region_approval_notification', '(Admin) Region Approval Notification', '[site_name], [region_id], [region_url], [payment_method], [payment_id], [payment_url], [user_id], [user_url]'),
    (7, 'cc_split_digits', '(Admin) Credit Card Split Digits', '[site_name], [payment_id], [payment_url], [cc_digits]'),
    (8, 'renewal_reminder', 'Renewal Reminder', '[site_name],[url],[update_url],[expires_at],[purge_at],[email]');

insert into `[prefix]snippets` (`id`, `snippet_key`, `snippet_seq`, `language_id`, `snippet_text`, `is_internal`) values 
    (1, 'grid_title', 1, 1, 'Pixels', 1),
    (2, 'grid_button_name', 1, 1, 'Buy Pixels Now', 1),
    (3, 'grid_description', 1, 1, 'Click below to purchase pixels.', 1),
    (4, 'email_purchase_active_subject', 0, 1, 'Thank You for Your Pixel Purchase', 1),
    (5, 'email_purchase_active_body', 0, 1, 'Dear Customer\r\n\r\nThank you for your purchase; your pixels are active now.\r\n\r\nYour confirmation number is [confirmation_number].\r\n\r\nYou may use the following link to update your pixels:\r\n[update_url]\r\n\r\n(You will need to provide your e-mail address, [email], when using this link, to confirm your identity.)\r\n\r\nSincerely,\r\n[site_name] Administrator', 1),
    (6, 'email_purchase_pending_subject', 0, 1, 'Thank You for Your Pixel Purchase', 1),
    (7, 'email_purchase_pending_body', 0, 1, 'Dear Customer,\r\n\r\nThank you for your purchase; your pixels will be activiated shortly.\r\n\r\nYour confirmation number is [confirmation_number].\r\n\r\nYou may use the following link to update your pixels:\r\n[update_url]\r\n\r\n(You will need to provide your e-mail address, [email], when using this link, to confirm your identity.)\r\n\r\nSincerely,\r\n[site_name] Administrator', 1),
    (8, 'signup_confirm_subject', 0, 1, 'Activate Your [site_name] Account', 1),
    (9, 'signup_confirm_body', 0, 1, 'Dear [first_name] [last_name],\r\n\r\nThank you for creating an account at [site_name].\r\nIn order to activate your account, you must confirm your ownership of this E-Mail address by visiting this link:\r\n[confirm_url]\r\n\r\nSincerely,\r\n[site_name] Administrator', 1),
    (10, 'tell_a_friend_subject', 0, 1, 'Check Out [site_name]', 1),
    (11, 'tell_a_friend_body', 0, 1, 'I thought you might be interested in this new site:\r\n\r\n[site_name]\r\n\r\nYou can find it at [site_url]\r\n\r\nSincerely,\r\n[from_name]', 1),
    (12, 'retrieve_password_subject', 0, 1, 'Your Password for [site_name]', 1),
    (13, 'retrieve_password_body', 0, 1, 'Here are your login details for [site_name]:\r\n\r\nE-Mail Address: [email]\r\nPassword: [password]\r\n\r\nYou may log in at [login_url]\r\n\r\nSincerely,\r\n[site_name] Administrator', 1),
    (14, 'region_approval_notification_subject', 0, 1, '[site_name] Region Approval Required', 1),
    (15, 'region_approval_notification_body', 0, 1, 'A region has been purchased on [site_name].\r\nThe pixels are in "pending" status awaiting your approval.\r\n\r\nRegion ID:      [region_id]\r\nRegion URL:     [region_url]\r\nPayment Method: [payment_method]\r\nPayment ID:     [payment_id]\r\nPayment URL:    [payment_url]\r\nUser ID:        [user_id]\r\nUser URL:       [user_url]', 1),
    (16, 'cc_split_digits_subject', 0, 1, '[site_name] Credit Card Split Digits', 1),
    (17, 'cc_split_digits_body', 0, 1, 'A credit card payment has been made on [site_name].\r\nFor security purposes, only part of the credit card number has been\r\nstored in the database. This email provides the missing digits.\r\n\r\nPayment ID:  [payment_id]\r\nPayment URL: [payment_url]\r\nCC Digits:   [cc_digits]', 1),
    (18, 'renewal_reminder_subject', 0, 1, 'Your Pixels at [site_name] will expire soon', 1),
    (19, 'renewal_reminder_body', 0, 1, 'Dear Customer\r\n\r\nYour Pixels for [url] at [site_name] will expire at [expires_at]\r\n\r\nPlease use the following link to renew your pixels now:\r\n[update_url]\r\n\r\n(You will need to provide your e-mail address, [email], when using this link, to confirm your identity.)\r\n\r\nYou must renew your pixels before [purge_at], or they will be permanently removed.\r\n\r\nSincerely,\r\n[site_name] Administrator', 1);

insert into `[prefix]payment_modules` (`id`, `name`, `module_key`, `class_file`, `formfile`, `is_enabled`) values 
    (1, 'Credit Card', 'cc', 'cc.php', 'frmcc.tpl', 0),
    (2, 'PayPal', 'paypal', 'paypal.php', 'frmpaypal.tpl', 0),
    (3, 'Authorize.Net', 'authorizenet', 'authorizenet.php', 'frmauthorizenet.tpl', 0),
    (4, 'NOCHEX', 'nochex', 'nochex.php', 'frmnochex.tpl', 0),
    (5, 'PSiGate', 'psigate', 'psigate.php', 'frmpsigate.tpl', 0),
    (6, 'ipayment.de', 'ipayment', 'ipayment.php', 'frmipayment.tpl', 0),
    (7, 'SECPay', 'secpay', 'secpay.php', 'frmsecpay.tpl', 0),
    (8, '2Checkout', 'pm2checkout', 'pm2checkout.php', 'frmpm2checkout.tpl', 0),
    (9, 'E-Gold', 'egold', 'egold.php', 'frmegold.tpl', 0);

insert into `[prefix]schema_version` (`id`, `schema_version`) values
    (1, 14);
