<?php

class Integration {
  var $_dir;
  var $modules;
  var $modules_names;
  var $db;
  var $smarty;
  
  function Integration() {
    if (defined('INCLUDES_DIR')) {
      $this->_dir = INCLUDES_DIR.'modules/integrations';
    } else {
      $this->_dir = 'modules/integrations';
    }
    
    $this->modules = $this->get_avalaible_integrations();
  }
  
  function get_avalaible_integrations() {
    $dir = opendir($this->_dir);

    $modules = array();
    while (false !== ($file = readdir($dir))) {
      if (strpos($file, 'class.php')) {
        $modules[] = $file;
      }
    }
    
    return $modules;
  }
  
  function   get_avalaible_integrations_titles() {
    foreach($this->modules as $integration_module) {
      include_once($this->_dir.'/'.$integration_module);
      list($class_name) = explode('.', $integration_module);
      $class_name .= '_Integration';
      $integration_class = new $class_name;
      $this->modules_names[$integration_class->get_name()] = $integration_class->get_name();
    }
    
    return $this->modules_names;
  }
  
  function get_integration_class($class_name = null) {
    if (is_null($class_name)) {
      return $this;
    } else {
      include_once($this->_dir.'/'.$class_name.'.class.php');
      $class = $class_name.'_Integration';
      $integration_class = new $class;
      $integration_class->name = $class_name;
      
      return $integration_class;
    } 
  }
  
  function get_configuration_page(){
    if (isset($this->name)) {
      return $this->smarty->fetch('admin/modules/integration/'.strtolower($this->name).'_settings.tpl');
    } else {
      return 'Problem with inegration configuration';
    }
  }
  
  function process_configuration_settings($settings) {
    foreach($settings as $group => $group_settins) {
      if (is_array($group_settins)) {
        foreach($group_settins as $name => $value) {
           $this->app->settings->$group->$name = $value;
        }
      }
    }

    $this->smarty->clear_all_cache();
    $this->app->save_settings();
  }
  
  function prepare_session($user){
    $_SESSION['user_id'] = $user->id;
    $_SESSION['email'] = $user->email;
    $_SESSION['first_name'] = $user->first_name;
    $_SESSION['last_name'] = $user->last_name;
  }
  
  function prepare_user($user) {
    if (!$this->db->getOne('SELECT COUNT(*) FROM '.DB_PREFIX.'users WHERE id='.(int)$user['id'])) {
      array_walk($user, 'prepare_for_db', null);
      $sql = 'INSERT INTO '.DB_PREFIX.'users('.implode(',', array_keys($user)).', created_at, is_confirmed, digest) VALUES(\''.implode('\', \'', $user).'\', NOW(), 1, MD5(pass))';
      $this->db->query($sql);
    } else {
      return true;
    }
  }
  
  function prepare_clean_session() {
    if (isset($_SESSION['user_id']) && $_SESSION['user_id']) {
      unset($_SESSION['user_id']);
      unset($_SESSION['email']);
      unset($_SESSION['first_name']);
      unset($_SESSION['last_name']);
    }
  }
}