<?php
// get_pixels.php
// page controller for pixel purchase process

require_once('config.php');
require_once('grid.class.php');
//require_once('util.class.php');
require_once('get_pixels.inc.php');

$gp = new GetPixels();
if ($app->variable_get('get_pixels', 'cancel') &&  $gp->isResetRequested()) {
  $gp->reset();
}
$smarty->assign('gp', $gp);

$tbl = new Grid;

$payment_controller = 'get_pixels';

$step =& $_REQUEST['step'];

// check step to make sure we are moving forward through the steps
// and not skipping any steps
if (!isset($order_status)) $order_status = array();
if (!isset($order_status['step'])) $order_status['step'] = 1;

if ($step < 1) $step = 1;
if ($step > $order_status['step'])
  $app->redirect(false, array('step' => $order_status['step']));

if ($step <= 1) @clear_params(array_keys($order_status));
$order_status['step'] = $step;

$smarty->assign('lang', $lang);
$smarty->assign('step', $step);
$smarty->assign_by_ref('order_status', $order_status);

// step 1: select grid
if ($step <= 1) {
  if ($app->is_post()) {
    save_params('grid_id', 'free_paid');
    next_step();
  }
  else
    clear_params('grid_id', 'choose');
  clear_params('x', 'y', 'w', 'h', 'url', 'title', 'alt', 'email', 'region_id');
  unset($_SESSION['image']);
  $grids = $tbl->find_all('order by display_order');
  $smarty->assign('grids', $grids);
  $smarty->display('get_pixels.tpl', 'get_pixels|'.$cache_step.'|'.$cache_id);
  exit;
}
 
// fetch grid and make available to further steps
$grid_id = (int)param('grid_id');
$grid = $tbl->get($grid_id);
$smarty->assign('grid', $grid);

// step 2: select pixels
if ($step == 2) {
  $smarty->caching = 0;
  if ($app->is_post()) {
    if ($_REQUEST['w'] == 0 && count(get_saved_regions()) == 0){
      $smarty->caching = 0;
      $app->error('##Please select a region##');
    } elseif ($grid->region_max_width && $_REQUEST['w'] > $grid->region_max_width
      || $grid->region_max_height && $_REQUEST['h'] > $grid->region_max_height){
      $smarty->caching = 0;
      $app->error('##That region exceeds the maxium allowable size##');
    } elseif ((!empty($_REQUEST['w']) && !empty($_REQUEST['w'])) 
        && ($grid->region_min_width 
        && $_REQUEST['w'] < $grid->region_min_width
        || $grid->region_min_height 
        && $_REQUEST['h'] < $grid->region_min_height)){
      $smarty->caching = 0;
      $app->error('##That region lower than minimum allowable size##');
    } elseif (!$grid->is_free_region($_REQUEST['x'], $_REQUEST['y'], $_REQUEST['w'], $_REQUEST['h'])){
      $app->error('##That region overlaps one or more existing regions##');
    } elseif (!$grid->is_free_custom_regions(get_saved_regions(), array('x' => $_REQUEST['x'], 'y' => $_REQUEST['y'], 'w' => $_REQUEST['w'], 'h' => $_REQUEST['h']))){
      $app->error('##That region overlaps one or more selected regions##');
    } elseif (isset($_REQUEST['add_another_region']) && $_REQUEST['add_another_region'] == 1) {
      //process params
      save_params('x');
      save_params('y');
      save_params('w');
      save_params('h');
      save_new_region(param('x'), param('y'), param('w'), param('h'));
      $smarty->assign('regions', get_saved_regions());
      $smarty->clear_cache('get_pixels_region.tpl', 'get_pixels|'.$grid_id.'|'.$cache_id);
      $smarty->display('get_pixels_region.tpl', 'get_pixels|'.$grid_id.'|'.$cache_id);
      exit;
    } else {
      if (isset($_REQUEST['x'])) save_params('x');
      if (isset($_REQUEST['y'])) save_params('y');
      if (isset($_REQUEST['w'])) save_params('w');
      if (isset($_REQUEST['h'])) save_params('h');
      
      // continue without choose more areas. Need to set active in this case, because current values is empty(0)
      if (param('x') == 0 && param('y') == 0 && param('w') == 0 && param('h') == 0)
        set_active_region(get_latest_region());
      
      process_regions_amounts($grid);
      $square = param('w') * param('h');
      if ($grid->allow_free_paid && $grid->free_square >= param('w') * param('h') && param('free_paid') == 'free') {
        $_REQUEST['amount'] = 0;
      } else {
        $_REQUEST['amount'] =  $square * $grid->pixel_price / ($grid->selectable_square_size * $grid->selectable_square_size);
      }
      
      save_params('amount');
      set_region(0);
      next_step();
    }
  } elseif (isset($_REQUEST['remove_from_regions'])) {
      remove_selected_region((int)$_REQUEST['remove_from_regions']);
      $smarty->assign('regions', get_saved_regions());
      $smarty->clear_cache('get_pixels_region.tpl', 'get_pixels|'.$grid_id.'|'.$cache_id);
      $smarty->display('get_pixels_region.tpl', 'get_pixels|'.$grid_id.'|'.$cache_id);
  } else {
    clear_params('x', 'y', 'w', 'h', 'amount');
  }

  clear_params('url', 'title', 'alt', 'email', 'region_id');
  unset($_SESSION['image']);
  load_params('grid_id', 'free_paid');

  if (count(get_saved_regions()))
    $smarty->assign('regions', get_saved_regions());

  $smarty->display('get_pixels_region.tpl', 'get_pixels|'.$grid_id.'|'.$cache_id);
  exit;
}

// step 3: upload image
if ($step == 3) {
  if ($app->is_post()) {
    $smarty->caching = false;

    if (Util::process_image_upload(param('w'), param('h'))){
      if (count(get_saved_regions())) {
        save_param_for_region('image', $_SESSION['image']);
        save_param_for_region('original_image', $_SESSION['original_image']);
        unset($_SESSION['original_image']);
        unset($_SESSION['image']);
        if (get_procces_region_id() == count(get_saved_regions()) - 1 ) {
          set_region(0);
          next_step();
        } else {
        	load_params('w', 'h');
        	if ($grid->images_gallery) {
          	$predefined_images = Util::predefined_images();
        		$smarty->assign_by_ref('predefined_images', $predefined_images);
        	}
          set_region(get_procces_region_id()+1);
          $smarty->assign('current_region_id', get_procces_region_id()+1);
          $smarty->assign('regions_count', count(get_saved_regions()));
          $smarty->display('get_pixels_upload.tpl', 'get_pixels|image_choose|region|0|'.$cache_id);
          exit;
        }
      } else {
        next_step();
      }
    }
  }
  else
    unset($_SESSION['image']);
  clear_params('url', 'title', 'alt', 'email', 'region_id');
	load_params('w', 'h');
	if ($grid->images_gallery) {
  	$predefined_images = Util::predefined_images();
		$smarty->assign_by_ref('predefined_images', $predefined_images);
	}

  if (count(get_saved_regions())) {
    $smarty->assign('current_region_id', get_procces_region_id()+1);
    $smarty->assign('regions_count', count(get_saved_regions()));
    $smarty->display('get_pixels_upload.tpl', 'get_pixels|image_choose|region|0|'.$cache_id);
    exit;
  } else {
    $smarty->display('get_pixels_upload.tpl', 'get_pixels|image_choose|'.$cache_id);
    exit;
  }
  
} 

// step 4: show details form
if ($step == 4) {
  if ($app->is_post()) {
    if (empty($_REQUEST['url']) && empty($_REQUEST['skip_details']))
      $app->error('##A URL is required##');
    elseif (empty($_REQUEST['skip_details']) && !preg_match('/^https?:\/\/./', $_REQUEST['url']) && empty($_REQUEST['skip_details']))
      $app->error('##The URL must be an absolute URL starting with "http://" or "https://"##');
    else {
      if (empty($_REQUEST['skip_details']))
        save_params('url', 'title', 'alt', 'description');
      else {
        $_REQUEST['url'] = '';
        $_REQUEST['title'] = '';
        $_REQUEST['alt'] = '';
      }
      
      if (isset($_REQUEST['category_new']) && trim($_REQUEST['category_new'])) {
        $query_params = array(DB_PREFIX.'categories', htmlentities($_REQUEST['category_new']));
        $db->query('INSERT INTO `!`(name, type) VALUES(?, \'regions\')', $query_params);
        $_REQUEST['category_id'] = $db->getOne('SELECT LAST_INSERT_ID()');
      } else {
        $_REQUEST['category_id'] = @(int)$_REQUEST['category'];
      }
      
      if (count(get_saved_regions())) {
        if (get_procces_region_id() == count(get_saved_regions()) - 1 ) {
          set_region(0);
          next_step();
        } else {
          save_params('url', 'title', 'alt', 'description', 'category_id');
          set_region(get_procces_region_id()+1);
          save_param_for_region('url', param('url'));
          save_param_for_region('title', param('title'));
          save_param_for_region('alt', param('alt'));
          save_param_for_region('description', param('description'));
          save_param_for_region('category_id', param('category_id'));

          clear_params('url', 'title', 'alt', 'description', 'category_id');
          clear_params('email', 'region_id');
          load_params('w', 'h');

          $smarty->assign('current_region_id', get_procces_region_id()+1);
          $smarty->assign('regions_count', count(get_saved_regions()));
          $smarty->display('get_pixels_details.tpl');
          exit;
        }
      } else {
        //process discount
        if ($app->settings->discounts->enabled) {
          if (isset($_REQUEST['code'])) {
            // process coupons
            $code_is_valid = $db->getOne('SELECT valid FROM `!` WHERE code=?', array(DB_PREFIX.'coupons', $db->escapeSimple($_REQUEST['code'])));
            if ($code_is_valid) {
              $amount = param('amount');
              $discount = $amount * ($app->settings->discounts->percent / 100);
              $_REQUEST['discount'] = $discount;
              $_REQUEST['discount_code'] = $_REQUEST['code'];
              $_REQUEST['amount'] = $amount - $discount;
              save_params('discount', 'amount', 'discount_code');
            }
          }
        }

        save_params('url', 'title', 'alt', 'description', 'category_id');
        next_step();
      }
    }
  } else {
    clear_params('url', 'title', 'alt');
  }

  clear_params('discount');
  clear_params('email', 'region_id');
  load_params('w', 'h');
  
  if ($app->settings->categories->regions) {
    $categories_tmp = $db->getAll('SELECT id, name FROM `!` WHERE type=\'regions\'', array(DB_PREFIX.'categories'), DB_FETCHMODE_ASSOC);
    if (count($categories_tmp)) {
      $categories[''] = '';
      foreach($categories_tmp as $category) {
        $categories[$category['id']] = $category['name'];
      }

      $smarty->assign('categories', $categories);
    }
  }
  
  if (count(get_saved_regions())) {
    $smarty->assign('current_region_id', get_procces_region_id()+1);
    $smarty->assign('regions_count', count(get_saved_regions()));
  }
  $smarty->display('get_pixels_details.tpl');
  exit;
} 

// from this point forward, we must be logged in if user accounts enabled
if ($app->setting->user_accounts) {
  $app->check_login('<p>##Please log in before proceeding##</p>');
}

// step 5 (user accounts enabled): carry email from user account
if ($step == 5 && $app->setting->user_accounts) {
  $_REQUEST['email'] = @$_SESSION['email'];
  save_params('email');
  next_step();
}

// step 5 (no user accounts): show email form
if ($step == 5) {
  if ($app->is_post()) {
    if (empty($_REQUEST['email'])) {
      $app->error('##Please enter your e-mail address##');
    } elseif (!Util::valid_email($_REQUEST['email'])) {
      $app->error('##That does not appear to be a valid e-mail address##');
    } elseif (strtolower($_REQUEST['email_confirm']) != strtolower($_REQUEST['email'])) {
      $app->error('##Your re-entered email address does not match; please check##');
    } else {
      save_params('email');
      next_step();
    }
  }
  else
    clear_params('email');

  clear_params('region_id');
  load_params('w', 'h');
  $smarty->display('get_pixels_email.tpl');
  exit;
} 

//process email discount
if ($app->settings->discounts->enabled && !param('discount')) {
  // process email discount
  $email = (isset($_REQUEST['email']) ? $_REQUEST['email'] : param('email'));
  $email_have_discount = $db->getOne('SELECT COUNT(*) FROM `!` WHERE ? REGEXP email', array(DB_PREFIX.'emails', $db->escapeSimple($email)));
  if ($email_have_discount) {
    $amount = param('amount');
    $discount = $amount * ($app->settings->discounts->percent / 100);
    $_REQUEST['discount'] = $discount;
    $_REQUEST['amount'] = $amount - $discount;
    save_params('discount', 'amount');
  }
}

// step 6: get payment
if ($step == 6) {
  if ($app->is_post()) {
    if ($regions_count = count(get_saved_regions())) {
      $type = process_payment();
      for($i = 0; $i < $regions_count;$i++) {
        set_region($i);
        $_SESSION['image'] = $order_status['image'];
        $_SESSION['original_image'] = $order_status['original_image'];
        store_region();
      }
      unset($order_status['regions']);
    } else {
      $type = process_payment();
      store_region();
    };
    if ($type) {
      unset($order_status['regions']);

      if ($grid->allow_free_paid == 'true' && (param('w') * param('h') < $grid->free_square )) {
        // keep setting work, after moved it to options
        if (isset($app->settings->grids->approval_required)) {
          $app->setting->approval_required = $app->settings->grids->approval_required;
        }

        if ($app->setting->approval_required)
          $mail_key = 'confirmation_free_pending';
        else
          $mail_key = 'confirmation_customers_active';

        $app->mail(param('email'), $mail_key, array(
          '[site_url]' => $app->url('/'),
          '[banner_url]' => $grid->url(),
          '[site_name]' => $app->setting->site_name,
          '[confirmation_number]' => $order_status['region_id'],
          '[update_url]' => $app->url('/update.php', array('id' => $order_status['region_id'], 'digest' => $app->digest(array('id' => $order_status['region_id']))), true, true)
          )
        );
      }
      next_step();
    }
  }

  load_params('w', 'h', 'amount');

  allocate_payment_id();
  assign_payment_options();
  $smarty->assign('regions', get_saved_regions());
  $smarty->display('get_pixels_payment.tpl');
  exit;
} 

// step 7: thank you
if ($step == 7) {
  load_params('region_id');
  unset($_SESSION['order_status']);        // we can't go back from this step
  $smarty->clear_all_cache();
  $smarty->display('get_pixels_done.tpl');
  exit;
}

// if we get here, there is a problem
$app->abort("Invalid step value");

?>