<?php 

//Method taken from users/helpers/encryption.php

/* ------------------------------------------------------------------ *
 |  1.  ENGINE DETECTION                                              |
 * ------------------------------------------------------------------ */

/**
 * Returns the crypto engine to use: 'sodium', 'openssl', or null (none).
 */
function totp_crypto_engine(): ?string
{
    // Native libsodium
    if (function_exists('sodium_crypto_secretbox')) {
        return 'sodium';
    }

    // sodium_compat polyfill (global class ParagonIE_Sodium_Compat)
    if (class_exists('ParagonIE_Sodium_Compat')) {
        return 'sodium';
    }

    // PHP’s OpenSSL extension with AES-256-GCM
    if (
        defined('OPENSSL_VERSION_TEXT')
        && in_array(
            'aes-256-gcm',
            array_map('strtolower', openssl_get_cipher_methods()),
            true
        )
    ) {
        return 'openssl';
    }

    return null;
}

/* Generate 32-byte master key */
$rawKey       = random_bytes(32);
$b64Key       = base64_encode($rawKey);
$cryptoEngine = totp_crypto_engine();

echo '<cryptoEngine>'.$cryptoEngine.'</cryptoEngine>';
echo '<b64Key>'.$b64Key.'</b64Key>';

@unlink('gen_totp_key.php');

?>