<?php
/**
 * French Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2017  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: help_text.fr.php 7161 2017-08-12 18:20:51Z canajun2eh $
 */
if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
$pgv_lang["medialist_recursive_help"]   = "~#pgv_lang[medialist_recursive]#~<br />Quand cette option est cochée, la #pgv_lang[multi_title]# recherchera non seulement dans le répertoire sélectionné dans #pgv_lang[filter]#, mais également dans tous ses sous-répertoires. Dans le cas contraire, la recherche s'effectue seulement dans le répertoire sélectionné.<br /><br />Les titres des objets Multimédia trouvés sont ensuite examinés pour déterminer s'il contiennent le texte entré dans le champ #pgv_lang[filter]#.  Le résultat de ces deux actions détermine la liste des objets Multimédia à afficher.<br /><br />";
$pgv_lang["sortby_help"]                = "~#pgv_lang[sortby]#~<br />Choisissez l'ordre dans lequel vous souhaitez afficher les objets Multimédia.<br /><br />";
$pgv_lang["help_treenav.php"]           = "~#pgv_lang[interactive_tree]#~<br />Utilisez l' #pgv_lang[interactive_tree]# pour visualiser l'arbre familial complet d'une personne dans les deux directions. Cette vue est similaire celle du sablier  dans le sens où elle montre à la fois les ancêtres et les descendants d'une personne racine donnée. Ce diagramme vous offre une vue plus compacte en affichant des boites pour les couples et les familles au liey d'afficher simplement des individus. <br /><ul><li><b>Défilement</b><br />A chaque fois que le pointeur de votre souris se déplace sur une icône de mouvement, vous pouvez cliquer et déplacer l'arbre afin de voir d'autres parties de cet arbre. Tandis que vous déplacez l'arbre les générations futures s'étendent automatiquement jusqu'à ce qu'il n'y ait plus aucune génération à afficher dans cette direction. <br /></li><li><b>Zoom</b><br />Vous pouvez utiliser les icônes qui sont sur la partie gauche de l'arbre pour zoomer dans le sens de l'agrandissement ou de la réduction. Un zoom en réduction vous permettra de voir une plus grande partie de l'arbre sur votre écran. Au fur et à mesure que vous zoomez dans le sens d'une réduction, le texte devient de plus en plus difficile à lire; quand votre souris passe au-dessus d'une boite, vous obtenez une vue élargie du contenu de cette boite. <br /></li><li><b>Elargir les détails</b><br />EN cliquant sur n'importe quelle boite, vous élargissez la boite et vous obtenez une vue plus détaillée. Lorsque vous utilisez le mode d'expansion, si vous cliquez sur le nom d'une personne vous ouvrez sa page #pgv_lang[indi_info]# . En cliquant sur <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> vous redessinez l'arbre avec cette personne en tant que nouvel individu racine. En cliquant sur <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> vous êtes redirigé sur la page qui vous donne des détails sur la famille. <br /></li><li><b>Basculer vers  les épouses </b><br />L'icône <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> juste en dessous des boutons de zoom vous basculera vers l'affichage de toutes les épouses du côté descendance. Lorsque l'affichage est paramétré pour montrer les épouses multiples, toutes les épouses de cette personne apparaîtront dans la boite. Tous les enfants de cette personne aparaîtront aussi. Quand l'option d'affichage des épouses multiples est sur off, seule la dernière épouse de cette personne sera affichée. <br /></li><li><b>Arbre large</b><br />L' #pgv_lang[interactive_tree]# est accessible à partir de beaucoup de pages différentes y compris l'onglet Arbre sur la page #pgv_lang[indi_info]# et le bloc Diagrammes sur la page d'accueil. Lorsque l'on affiche l'arbre depuis l'une de ces autres pages, vous aurez également à votre disposition une icône représentant un arbre en-dessous des icônes de zoom. Si vous cliquez sur <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> vous serez dirigé vers la page #pgv_lang[interactive_tree]#.</li></ul><br />";
$pgv_lang["move_mediadirs_help"]        = "~#pgv_lang[move_mediadirs]#~<br />Lorsque le pare-feu (firewall) est activé, les fichiers Multi-Média peuvent être placés dans un répertoire du serveur qui n'est pas accessible à partir d'Internet.<br /><br />Ces boutons vous permettent de déplacer facilement une structure complète de répertoire de média entre les répertoires protégés (qui ne peuvent donc pas être visibles depuis Internet) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> et ceux qui sont normaux <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.<br /><br />";
$pgv_lang["setperms_help"]              = "~#pgv_lang[setperms]#~<br />Modifier de façon récursive les permissions des répertoires protégés (qui ne peuvent donc pas être visibles depuis Internet) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> et ceux qui sont normaux <b>#GLOBALS[MEDIA_DIRECTORY]#</b> en leur donnant les droits d'écriture ou de lecture uniquement.<br /><br />";
$pgv_lang["no_update_CHAN_help"]        = "~#pgv_lang[no_update_CHAN]#~<br />Les administrateurs doivent parfois nettoyer et corriger les données saisies par les utilisateurs. Par exemple, ils pourraient devoir corriger les coordonnées PLAC (lieux) pour y inclure le pays. Quand les administrateurs font de telles corrections, les informations sur le rédacteur original sont normalement remplacées. Ceci peut ne pas être souhaité.<br /><br />Quand cette option est choisie, PhpGedView conservera l'information originale au lieu de la remplacer avec celle de la session courante. Cette option choisie, les administrateurs ont également la capacité de modifier ou de supprimer l'information associée à la balise originale CHAN.<br /><br />";
$pgv_lang["edit_SOUR_EVEN_help"]        = "~#pgv_lang[source_events]#~<br /><br />Chaque source enregistre des événements spécifiques, généralement pour une période donnée de dates et pour une juridiction. Par exemple les événements consécutifs à un recensement et les événements enregistrés par l'église comme les naissances, les mariages ou les décès.<br /><br />Choisissez les événements qui sont enregistrés par cette source à partir de la liste d'événements proposée. La date doit être saisie dans un format tel que <i>DE 1900 À 1910</i>. La juridiction à saisir est le nom du lieu le plus précis cité dans la source. Par exemple, «Le Mans, Sarthe, Pays de la Loire, France» devrait être utilisé comme source pour les différents événements enregistrés dans la ville du Mans ou par défaut le nom du canton ou département dont dépend le lieu de l'événement.<br /><br />";
$pgv_lang["cache_life_help"]            = "~#pgv_lang[cache_life]#~<br /><br />Pour améliorer son exécution, ce bloc de la page d'accueil de PhpGedCom est sauvegardé comme fichier antémémoire. Vous pouvez spécifier la périodicité automatique de l'actualisation de ce bloc.<br /><br /><ul><li><b>-1</b> signifie que le fichier antémémoire n'est jamais actualisé automatiquement. Pour obtenir une version actualisée, vous devez supprimer tous les fichiers antémémoire.  Vous pouvez le faire grâce aux options de personnalisation de la page d'accueil.</li><li><b>0</b> (Zéro) signifie que ce bloc n'est jamais enregistré dans un fichier antémémoire, et chaque fois que ce bloc est affiché sur la page d'accueil de PhpGedView, vous visualiserez la dernière version mise à jour. Ce réglage est utilisé automatiquement pour un bloc d'informations qui change régulièrement, comme le bloc #pgv_lang[logged_in_users_block]# et le bloc #pgv_lang[random_media_block]#.</li><li><b>1</b> (Un) signifie qu'une mise à jour du fichier antémémoire de ce bloc est actualisée chaque jour, <b>2</b> signifie qu'une mise à jour du bloc d'infos est réalisée tous les deux jours, <b>7</b> signifie qu'une mise à jour du bloc est réalisée chaque semaine, etc...</li></ul><br /><br />";
$pgv_lang["clear_cache_help"]           = "~#pgv_lang[clear_cache]#~<br /><br />Afin d'améliorer les performances d'affichage, plusieurs blocs d'informations sur la page d'accueil de PhpGedView sont enregistrés comme fichiers antémémoire dans le répertoire index. Les fichiers antémémoire pour la plupart des blocs d'infos sont actualisés une fois par jour, mais il se peut que vous souhaitiez obtenir une actualisation manuelle immédiate.<br /><br />Ce bouton vous permet d'actualiser immédiatement les informations affichées et enregistrées dans le dossier temporaire si nécessaire.";
$pgv_lang["import_options_help"]        = "Vous pouvez sélectionner des options additionelles pour l'importation de ce fichier GEDCOM.";
$pgv_lang["verify_gedcom_help"]         = "Vous pouvez continuer le téléchargement et importation de ce fichier GEDCOM ou les annuler.";
$pgv_lang["add_gedcom_instructions"]    = "Entrez un nom de fichier pour ce nouveau GEDCOM. Le nouveau fichier GEDCOM sera créé dans le répertoire d'index : #INDEX_DIRECTORY#";
$pgv_lang["random_media_start_slide_help"]= "~#pgv_lang[random_media_start_slide]#~<br /><br />Implique que le diaporama se lance automatiquement au chargement de la page.<br /><br />Le diaporama modifie le contenu du bloc sans chargement préalable des informations depuis le serveur (méthode streaming) et sans actualisation complète de la page en cours.<br /><br />";
$pgv_lang["random_media_ajax_controls_help"]= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Vous pouvez utiliser ce réglage pour montrer ou cacher les boutons de commande du diaporama.<br /><br />Ces commandes permettent à l'utilisateur de passer aléatoirement à un autre objet ou de lancer aléatoirement les média comme un diaporama. Le diaporama modifie le contenu du bloc sans chargement préalable des informations depuis le serveur (méthode streaming) et sans actualisation complète de la page en cours.<br /><br />";
$pgv_lang["edit_add_unlinked_source_help"]= "~#pgv_lang[add_unlinked_source]#~<br /><br />Utilisez ce lien pour ajouter une nouvelle source à votre base de données sans lier cette source à une source d'une autre base de données.  La nouvelle source apparaîtra dans la liste des sources, mais n'apparaîtra sur aucun diagramme ou ailleurs dans le programme jusqu'à ce qu'elle soit liée à une source.";
$pgv_lang["link_person_id_help"]        = "~#pgv_lang[label_local_id]#~<br /><br />Dans ce champ vous saisissez l'identifiant (ID GEDCOM) de l'individu avec lequelle vous êtes lié (par exemple I100).";
$pgv_lang["link_gedcom_id_help"]        = "~#pgv_lang[label_gedcom_id]#~<br /><br />Utilisez cette section pour sélectionner la base de données externe (alternate database) qui contient l'individu auquel vous êtes lié.";
$pgv_lang["link_remote_site_help"]      = "~#pgv_lang[label_site]#~<br /><br />Dans cette section vous spécifiez les paramètres exigés pour se connecter au site à distance (serveur/site) et où sont enregistrées les données que vous liez. Vous avez la possibilité de choisir depuis une liste de sites distants connus que vous avez utilisés auparavant, ou de saisir #pgv_lang[label_site_url2]# et #pgv_lang[label_gedcom_id]# pour un nouveau site.<br /><br />Dans le champ <b>#pgv_lang[label_site_url2]#</b>, vous saisissez l'URL pour accèder aux web services (web services description file (WDSL)) qui indiquera à PhpGedView comment accèder aux données sur le site distant. Pour un site web distant PhpGedView, l'URL du fichier WSDL devrait être similaire à ceci : <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />Le champ <b>#pgv_lang[label_gedcom_id]#</b> est utilisé pour saisir l'identifiant de la base de données du site distant requis pour la connexion. Pour les sites web PhpGedView, c'est le nom du fichier GEDCOM.<br /><br />Les champs <b>#pgv_lang[label_username_id]#</b> et <b>#pgv_lang[label_password_id]#</b> sont obligatoires si la base de données les demande.<br /><br /><i>Note : les sites web distant PhpGedView doivent fonctionner sous la version 4.0 ou supérieure ; les versions antérieures ne le permettent pas.</i>";
$pgv_lang["link_remote_location_help"]  = "~#pgv_lang[label_location]#~<br /><br />Cette option vous permet de choisir si les données que vous liez à cet individu sont sur le même site mais d'une base de données généalogiques différente, ou si les données se trouvent sur un site distant accessible via Internet.<br /><br />Si l'individu est enregistré sur le même site, vous serez invité à sélectionner son identifiant (nom) et son ID (GEDCOM).<br /><br />Dans le cas d'un site distant, vous serez invité à saisir son URL, le nom de la base de données et l'ID (identifiant) de l'individu.";
$pgv_lang["link_remote_rel_help"]       = "~#pgv_lang[label_rel_to_current]#~<br /><br />Utilisez cette option pour choisir la relation entre l'individu distant et l'individu enregistré sur votre site.  Par exemple, si vous sélectionnez <i>Père</i>, cela signifie que l'individu enregistré sur le site distant est le père de l'individu enregistré localement.";
$pgv_lang["link_remote_help"]           = "~#pgv_lang[link_remote]#~<br /><br />Utilisez ce formulaire pour lier des individus à d'autres individus enregistrés sur d'autres sites ou sur d'autres bases de données généalogiques accessibles depuis votre copie de PhpGedView.<br /><br />Pour ajouter un tel lien, vous devez d'abord choisir le type de lien, ensuite choisir un site déjà référencé dans PhpGedView ou déclarer un nouveau site, et ensuite saisir l'ID sur le site de l'individu que vous souhaitez lier. PhpGedView téléchargera automatiquement les informations depuis le site distant si nécessaire. Les informations téléchargées <u>ne seront pas</u> intégrées à votre base de données généalogiques ; elles resteront à leur emplacement original mais seront affichées dans les différentes pages où les informations sur cet individu distant lié à votre base sont affichées.<br /><br />Reportez-vous au lien de l'aide à côté de chaque élément de la page pour plus d'informations. Vous pouvez également consulter le tutoriel en ligne (en anglais) à l'adressse suivante : <a href=\"http://wiki.phpgedview.net/en/index.php/How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/How_To:Remote_Link_Individuals_Across_Websites_And_Databases</a>.";
//-- Edit Interface
$pgv_lang["edit_ABBR_help"]             = "~Titre abrégé~<br /><br />Utilisez ce champ pour enregistrer une version abrégée d'un titre. Ce champ est utilisé en combinaison avec le champ titre des sources. Par défaut PGV utilisera en premier le titre et ensuite le titre abrégé.<br /><br />Selon les spécifications de GEDCOM 5.5, «Cette entrée doit fournir un titre court utilisé pour classer et rechercher les enregistrements de la source (pg 62).»<br /><br />Dans PhpGedView le titre abrégé est optionnel, mais dans d'autres programmes généalogiques, il est obligatoire.";
$pgv_lang["edit_ROMN_help"]             = "~Nom romanisé~<br /><br />Dans de nombreuses cultures, il est commun de porter un nom traditionnel écrit dans la langue traditionnelle et un nom romanisé qui pourra être écrit ou prononcé dans les langues d'origine latine, comme le français ou l'anglais.<br /><br />Si vous préférez utiliser un alphabet différent du latin, comme l'hébreu, le grec, le russe, le chinois ou l'arabe pour saisir le nom dans le champs standards du nom, alors vous pouvez utiliser ce champ pour saisir le nom utilisé en alphabet latin. Les deux versions du nom appairaîtront dans les listes et les diagrammes.<br /><br />Bien que ce champ soit marqué «Romanisé», il n'est pas limité aux caractères latins.  Ceci pourrait être utile avec des noms japonais pour lesquels trois alphabets différents peuvent être utilisés.";
$pgv_lang["edit__HEB_help"]             = "~Nom hébreu~<br /><br />Dans de nombreuses cultures, il est commun de porter un nom traditionnel écrit dans la langue traditionnelle et un nom romanisé qui pourra être écrit ou prononcé dans les langues d'origine latines, comme le français ou l'anglais.<br /><br />Si vous préférez utiliser un alphabet différent du latin, comme l'hébreu, le grec, le russe, le chinois ou l'arabe pour saisir le nom dans le champs standard du nom, alors vous pouvez utiliser ce champs pour saisir le nom utilisé en alphabet latin. Les deux versions du nom appairaîtront dans les listes et les diagrammes.<br /><br />Bien que ce champ soit marqué «Hébreu», il n'est pas limité aux caractères hébreux.";
$pgv_lang["edit_SEX_help"]              = "~#pgv_lang[sex]#~<br /><br />Choisissez le sexe approprié dans la liste déroulante. Choisissez <b>inconnu</b> si vous n'avez pas l'information.<br /><br />";
$pgv_lang["edit_NAME_help"]             = "~#pgv_lang[name]#~<br /><br />C'est le champ le plus important dans l'enregistrement du nom d'un individu. Ce champ peut être rempli automatiquement en remplissant les champs particuliers qui suivent, (méthode préférable), il est fourni de façon à ce que vous puissiez saisir ces informations selon vos préférences personnelles. Ce champ doit être saisi selon les standards de la norme GEDCOM 5.5.1, avec le nom de famille entouré de «/». Par exemple, le nom «John Robert Finlay Jr.» doit être entré : «John Robert /Finlay/ Jr.».<br /><br />";
$pgv_lang["edit_add_unlinked_person_help"]= "~#pgv_lang[add_unlinked_person]#~<br /><br />Utilisez ce formulaire pour ajouter une personne isolée.<br /><br />Quand vous ajoutez une personne isolée à votre arbre généalogique, la personne restera isolée tant que vous ne la relierez pas à une autre. Plus tard, vous pourrez lier des personnes ensemble à partir de l'onglet «#pgv_lang[relatives]#» de l'individu.";
$pgv_lang["edit_URL_help"]              = "Entrez l'adresse URL y compris le sigle http://.<br /><br />Une adresse URL ressemble à ceci : <b>http://www.phpgedview.net/</b> Laissez ce champ vide si vous ne souhaitez pas inclure une adresse URL.";
$pgv_lang["edit_EMAIL_help"]            = "Entrez l'adresse mail.<br /><br />Une adresse mail a la forme suivante : <b>nom@hotmail.com</b> Laissez ce champ en blanc si vous ne voulez pas inclure d'adresse mail.";
$pgv_lang["edit_FAX_help"]              = "Entrez le numero de FAX y compris le numéro du pays, et de la zone si il y a lieu.<br /><br />Laissez ce champ à blanc si vous ne voulez pas inclure de numéro FAX. Par exemple, un numéro de FAX en France doit être du type (sans le zero du début) :  +33 491422679 et un numéro aux USA ou au Canada doit être du type : +1 888 555-1212.";
$pgv_lang["edit_PHON_help"]             = "Entrez le numéro de téléphone y compris le numéro du pays, et de la zone si il y a lieu.<br /><br />Laissez ce champ en blanc si vous ne voulez pas inclure de numéro de téléphone. Par exemple, un numéro en France est du type (sans le zero du début) : +33 391322679 et un numéro aux USA ou au Canada du type : +1 888 555-1212.";
$pgv_lang["edit_ADDR_help"]             = "Entrez l'adresse dans le champ exactement comme si vous l'écriviez sur une enveloppe.<br /><br />Laissez ce champ à blanc si vous ne souhaitez pas inclure d'adresse.";
$pgv_lang["edit_GIVN_help"]             = "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]             = "~#factarray[SPFX]# HELP~<br /><br />Entrer les(s) préfixe(s) pour le nom de famille.<br />Exemple : «de la» pour Louis de la Martinière.<br /><br />Si la première lettre du préfixe est une majuscule, le nom sera trié sur ce préfixe :<br />«De la Martinière» sera classé à la lettre «D».<br />Inversement, pour une minuscule le tri se fera sur la première lettre du nom :<br />«de la Martinière» sera classé à la lettre «M».";
$pgv_lang["edit_SURN_help"]             = "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]             = "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]           = "~#factarray[_MARNM]#~<br /><br />Écrivez le nom de mariage pour cet individu en utilisant les mêmes règles de formatage qui s'appliquent au champ relatif au Nom. Ce champ est facultatif.<br /><br />Par exemple, si Marie Jane Brown a été mariée à John White, vous saisirez (sans guillemets naturellement)<ul><li>Usage américain :&nbsp;&nbsp;«Mary Jane Brown /White/»</li><li>Usage européen :&nbsp;&nbsp;«Mary Jane /White/»</li><li>Usage européen alternatif :&nbsp;&nbsp;«Mary Jane /White-Brown/» ou «Mary Jane /Brown-White/»</li></ul>Vous devriez faire ceci seulement si Mary Brown commençait à s'appeler par le nouveau nom après s'être mariée à John White. Dans quelques endroits, Québec (Canada) par exemple, il est illégal de changer les noms de cette façon.<br /><br />Les hommes changent parfois leur nom après le mariage, le plus souvent sous la forme composée (nom du mari et de la femme - mise en trait d'union) mais plus occasionnellement en prenant le nom de leur femme.";
$pgv_lang["edit_PEDI_help"]             = "~#factarray[PEDI]#~<br /><br />Ce champ décrit la relation entre l'enfant et sa famille. Les différentes possibilités sont les suivantes :<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;La relation entre l'enfant et sa famille ne peut pas être déterminée. Quand cette option est choisie, le champ #factarray[PEDI]# ne sera pas copié dans la base de données.<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;Cette option indique que l'enfant a un lien de naissance avec sa famille.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;Cette option indique que l'enfant a été adopté par sa famille.  Cela <i>n'indique pas</i> qu'il n'y aucun lien de sang entre l'enfant et sa famille ; cela indique que l'enfant a été adopté par la famille quelque temps après la naissance de l'enfant.<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;Cette option indique que l'enfant est un enfant adoptif de la famille.  Habituellement, il n'y aucun lien de sang entre l'enfant et sa famille.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;L'enfant a été uni à sa famille lors d'une cérémonie <i>d'union</i> SDJ.  Une cérémonie d'union est réalisée lorsque les parents se sont unis l'un à l'autre après la naissance de l'enfant. Les enfants qui sont nés après l'union des parents sont automatiquement unis à la famille.<br /><br /></li></ul>";
$pgv_lang["edit_AGNC_help"]             = "~#factarray[AGNC]#~<br /><br />L'organisation, l'institution, la corporation, la personne, ou toute autre entité qui a l'autorité.<br /><br />Par exemple, l'employeur d'une personne, ou une organisation/église qui a la responsabilité de la création et/ou de l'archivage des enregistrements.";
$pgv_lang["context_help"]               = "Une aide est disponible en cliquant sur le <b>»?»</b> des différents champs de la page.";
$pgv_lang["register_gedcomid_help"]     = "~#pgv_lang[gedcomid]#~<br /><br />Chaque personne figurant dans la base est identifiée par un numéro d'ID unique sur ce site. Si vous connaissez le numéro d'ID de votre enregistrement, entrez le ici. Si vous ne le connaissez pas ou ne pouvez pas le trouver à cause des règles de protections sur la vie privée, veuillez laisser assez de renseignements dans le champ Commentaires pour aider l'administrateur du site à vous identifier, afin de mettre à jour ce champ avec votre numéro d'ID.<br />";
$pgv_lang["register_comments_help"]     = "~#pgv_lang[comments]#~<br /><br />Utilisez ce champ pour dire à l'administrateur du site pourquoi vous souhaitez un compte et en quoi vous êtes concerné par les informations généalogiques présentées sur ce site. Vous pouvez aussi utiliser ce champ pour tout autre commentaire à l'attention de l'administrateur.<br />";
$pgv_lang["utf8_ansi_help"]             = "~Convertir format UTF-8 en format ANSI~<br /><br />Pour un affichage optimal sur Internet, PhpGedView utilise le codage des caractère en UTF-8. Certains programmes, Family Tree Maker par exemple, ne supportent pas l'importation de fichier GEDCOM encodés en UTF-8. Cocher cette case entrainera la conversion du fichier de l'<b>UTF-8</b> à l'<b>ANSI (ISO-8859-1)</b>.<br /><br />Le format dont vous avez besoin dépend donc du programme que vous utilisez pour ouvrir et importer votre GEDCOM. Si vous avez un doute, consultez la documentation de votre programme.<br /><br />Notez que pour conserver certains caractères spéciaux, vous devez garder le fichier en UTF-8 et le convertir avec la méthode appropriée de votre programme. Consultez votre éditeur ou l'auteur.<br /><br />";
$pgv_lang["remove_tags_help"]           = "~Supprimer les marqueurs PGV~<br /><br />Cocher cette option effacera tous les tags qui peuvent avoir été ajoutés par PhpGedView.<br /><br />Ces tags utilisés par PhpGedView comprennent le tag <b>_PGVU</b> qui identifie l'utilisateur ayant modifié un enregistrement en ligne et le tag <b>_THUM</b> qui indique à PhpGedView que l'image peut être utilisée comme miniature.<br /><br />Ces tags peuvent provoquer des erreurs à l'importation du fichier GEDCOM dans une autre appliquation de généalogie.<br /><br />";
$pgv_lang["download_zipped_help"]       = "~Télécharger le gedcom comme un fichier zip~<br /><br />Quand vous validez cette option, une copie du fichier GEDCOM sera comprimée dans le format ZIP avant le téléchargement. Ceci réduira sa taille considérablement, mais vous devrez employer un logiciel compatible (WINZIP par exemple) pour le décompresser puis l'utiliser.<br /><br />C'est une option utile pour télécharger des fichiers GEDCOM volumineux. En effet, il y a un risque que le temps de téléchargement d'un fichier non compressé excède le temps maximum d'exécution alloué par le système, ayant pour résultat un téléchargement incomplet du fichier.  L'option ZIP devrait réduire le temps de téléchargement de 75%.<br /><br />";
$pgv_lang["edit_NCHI_help"]             = "~#factarray[NCHI]# HELP~<br /><br />Entrer le nombre d'enfants pour cet individu ou cette famille. Ce champ est facultatif.<br /><br />";
$pgv_lang["edit_TIME_help"]             = "~#factarray[TIME]# HELP~<br /><br />Entrer l'heure de l'événement sous la forme HH:MM. Exemples : 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]             = "~#factarray[NOTE]# HELP~<br /><br />Une note est un texte libre qui s'affichera dans l'onglet Détails.<br /><br />";
$pgv_lang["edit_CEME_help"]             = "~#factarray[CEME]# HELP~<br /><br />Entrer le nom du cimetière où cette personne est enterrée. Exemple : Père-Lachaise.<br />La commune est à saisir dans le champ lieu.<br /><br />";
$pgv_lang["edit_ASSO_help"]             = "~#factarray[ASSO]# HELP~<br /><br />Entrer l'identifiant GEDCOM de la personne à associer.<br /><br />";
$pgv_lang["edit_RELA_help"]             = "~#factarray[RELA]# HELP~<br /><br />Choisir dans la liste le lien entre les deux personnes.<br />Exemple : en choisissant «Parrain», cela signifie que la personne associée est le parrain de l'individu sélectionné.<br /><br />";
$pgv_lang["show_spouse_help"]           = "~#pgv_lang[show_spouses]#~<br /><br />Par défaut, ce diagramme ne présente pas les conjoints pour les descendants, car cela rend celui-ci difficile à lire et à comprendre. Cochez cette option si vous voulez voir figurer les conjoints sur le diagramme.<br /><br />";
$pgv_lang["reorder_families_help"]      = "~#pgv_lang[reorder_families]#~<br /><br />Les membres d'une famille sont présentés sur l'onglet #pgv_lang[relatives]# dans l'ordre où ils apparaissent à l'intérieur des enregistrements individuels du fichier GEDCOM. Les familles ne sont pas triées par date de mariage, car celles-ci sont souvent inconnues, alors que <u>l'ordre</u> des mariages l'est. <br /><br />Cette option vous permet de changer l'ordre de présentation des familles dans l'onglet  #pgv_lang[relatives]#.  Si vous souhaitez trier les familles par date de mariage, cette option le fera automatiquement.<br /><br />";
$pgv_lang["autoContinue_help"]          = "~#pgv_lang[autoContinue]#~<br /><br />Lorsque PhpGedView détecte que la phase d'import du fichier GEDCOM demande plus de temps qu'autorisé par le paramètre temps limite, il fera apparaître le bouton <b>#pgv_lang[del_proceed]#</b> que vous devrez presser afin de continuer l'import.<br /><br />Lorsque cette option est sélectionnée à <b>#pgv_lang[yes]#</b>, PhpGedView pressera automatiquement le bouton <b>#pgv_lang[del_proceed]#</b> pour vous.  Cela vous évitera le travail ennuyeux qui vous oblige à presser ce bouton de manière répétée lorsque vous avez des imports de fichiers GEDCOM volumineux.<br /><br />";
$pgv_lang["firstname_i_help"]           = "~#pgv_lang[firstname_alpha_index]#~<br /><br />Le nom de famille que vous avez choisi concerne plus de #GLOBALS[SUBLIST_TRIGGER_I]# individus.<br /><br />Pour vous aider à trouver l'individu que vous souhaitez, la liste a été réduite aux noms commençant par la première lettre du nom que vous avez donné.  Ce sous-index alphabétique fonctionne de la même manière que l'index alphabétique des noms de famille.<br /><ul><li>Cliquez sur une lettre pour voir tous les prénoms qui commmencent par cette lettre.</li><li>Choisissez <b>#pgv_lang[NN]#</b> pour lister tous les individus avec des prénoms inconnus.</li><li>Ce choix <b>#pgv_lang[all]#</b> affichera une liste de tous les individus avec le nom de famille précédement sélectionné.</li></ul>Puisqu'il y a beaucoup de noms, cela peut prendre un bon moment pour que cette liste apparaisse à l'écran.<br /><br />";
$pgv_lang["firstname_f_help"]           = "~#pgv_lang[firstname_alpha_index]#~<br /><br />Le nom de famille que vous avez choisi concerne plus de #GLOBALS[SUBLIST_TRIGGER_F]# individus.<br /><br />Pour vous aider à trouver la famille que vous souhaitez, la liste a été réduite aux noms commençant par la première lettre du nom que vous avez donné.  Ce sous-index alphabétique fonctionne de la même manière que l'index alphabétique des noms de famille.<br /><ul><li>Cliquez sur une lettre pour voir tous les prénoms qui commmencent par cette lettre.</li><li>Choisissez <b>#pgv_lang[NN]#</b> pour lister tous les individus avec des prénoms inconnus.</li><li>Ce choix <b>#pgv_lang[all]#</b> affichera une liste de tous les familles avec le nom précédement sélectionné.</li></ul>Puisqu'il y a beaucoup de noms, cela peut prendre un bon moment pour que cette liste apparaisse à l'écran.<br /><br />";
$pgv_lang["edit_TYPE_help"]             = "~#factarray[TYPE]#~<br /><br />Le champ #factarray[TYPE]# vous permet de spécifier un évenement particulier. C'est un champ libre dans lequel vous pouvez entrer toute information que vous voulez mémoriser.<br /><br />";
$pgv_lang["edit_TEMP_help"]             = "~#factarray[TEMP]#~<br /><br />Pour des ordinations SDJ (Eglise de Jésus-Christ des saints des derniers jours), ce champ enregistre le nom du temple où il s'est déroulé.<br /><br />";
$pgv_lang["edit_STAT_help"]             = "~#factarray[STAT]#~<br /><br />C'est un champ optionnel qui est utilisé principalement pour les ordinations SDJ (Eglise de Jésus-Christ des saints des derniers jours) lorsqu'elles sont effectuées selon le logiciel TempleReady.<br /><br />";
$pgv_lang["edit__PRIM_help"]            = "~#factarray[_PRIM]#~<br /><br />Utilisez ce champ pour signaler que ce média est le média principal de l'individu auquel il est attaché. L'image principale est celle qui sera utilisée dans les diagrammes et sur la page de l'individu.<br /><br />";
$pgv_lang["edit__THUM_help"]            = "~#factarray[_THUM]#~<br /><br />C'est un champ PhpGedView qui permet de spécifier si une miniature doit être utilisée dans les diagrammes même si cette miniature n'existe pas.<br /><br />";
$pgv_lang["edit_TITL_help"]             = "~#factarray[TITL]#~<br /><br />Entrez un titre pour l'objet que vous mettez à jour. Si c'est un titre pour un objet multimédia, donnez un titre descriptif pour son identification par l'utilisateur.<br /><br />";
$pgv_lang["edit_FILE_help"]             = "~#factarray[FILE]#~<br /><br />C'est le champ le plus important pour l'enregistrement de l'objet multimédia. Il indique quel est le fichier à utiliser. Vous devez entrer au minimum le nom du fichier. En fonction de vos paramètres, plus d'information à propos de la localisation du fichier peut être utile.<br /><br />Vous pouvez utiliser le lien <b>#pgv_lang[find_media]#</b> pour vous aider à localiser les objets multimédia que vous avez déjà chargés sur le site.<br /><br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]             = "~#factarray[FORM]#~<br /><br />Il s'agit d'un champ optionnel qui peut être utilisé pour renseigner le type de fichier multimédia. Certains programmes généalogiques regardent ce champ pour déterminer comment traiter le fichier. De toute façon, comme les transferts de fichiers média entre systèmes ne sont pas toujours évidents, ce champ n'est pas très important.<br /><br />";
$pgv_lang["generate_thumb_help"]        = "~Générer les miniatures~<br /><br />Nous avons détecté que votre système est capable de générer automatiquement des miniatures pour certains type d'images (cela peut être les fichiers JPG, GIF, et PNG). Les types que votre système gère sont listés à coté de la case à cocher.<br /><br />En cliquant cette case, vous signalez au système que vous chargez des images de ce type et que vous désirez qu'il essaie de générer les miniatures correspondantes. Laissez cette case vide si vous chargez vos propres miniatures.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]         = "~#pgv_lang[add_note]#~<br /><br />Cette partie vous permet d'ajouter une note relative à l'évenement que vous mettez à jour. Les notes sont du texte libre, et la note apparaîtra dans la section <b>Faits et détails personnels</b> de la page de l'individu.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]         = "~#pgv_lang[add_source]#~<br /><br />Cette section vous permet d'ajouter une source concernant l'événement que vous mettez à jour.<br /><br />Dans le champ «source», entrez le numéro de la source si celle-ci existe déjà. Cliquez sur le lien <b>#pgv_lang[create_source]#</b> si vous désirez créer une nouvelle source. Dans le champ «Page», vous pouvez entrer les références (cote) ou toute autre information permettant de trouver la source. Dans le champ «Texte», vous pouvez entrer la transcription textuelle de la source.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]         = "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# Vous permet d'associer à un événement une personne du site. C'est une des façons d'enregistrer, par exemple, que quelqu'un est le parrain d'une autre personne.<br /><br />";
$pgv_lang["edit_QUAY_help"]             = "~#factarray[QUAY]#~<br /><br />Vous aviez l'habitude d'utiliser ce champ pour enregistrer la qualité ou la fiabilité des données trouvées dans cette source. Beaucoup de logiciels de généalogie utilisent un nombre pour ce champ, <b>2</b> signifie qu'il s'agit d'une source secondaire, <b>1</b> signifie que l'information est incertaine, et <b>0</b> signifie que la source n'est pas fiable.<br /><br />";
$pgv_lang["edit_PAGE_help"]             = "~#factarray[PAGE]#~<br /><br />Cote du document = toute information (<b>page</b>, <b>folio</b>) permettant de trouver l'information dans le document source.<br />À saisir sous la forme : <b>Champ1 : valeur1, Champ2 : valeur2, ...</b><br /><br />Exemple : <b>Film : 12, Page : 34, Acte : 56.</b><br /><br />";
$pgv_lang["edit_TEXT_help"]             = "~#factarray[TEXT]#~<br /><br />Dans ce champ, vous pouvez entrer des citations concernant cette source. Ce peut être la transcription textuelle, ou la description de ce qui se trouve dans le document.<br /><br />";
$pgv_lang["edit_SOUR_help"]             = "~#factarray[SOUR]#~<br /><br />Saisir dans ce champ le numero ID de la source associée à l'événement. Si la source que vous voulez associer existe déjà, la case de gauche listera l'ensemble des sources de la base, présentées par titre, vous permettant d'en sélectionnner une. Si la source que vous voulez associer est à créer, selectionnez la case de droite. Quand le champ est rempli, le titre de la source figure à droite du champ. Pour enlever une source, mettez le champ à blanc.<br /><br />";
$pgv_lang["edit_edit_raw_help"]         = "~#pgv_lang[edit_raw]#~<br /><br />Cette page vous permet de mettre à jour directement l'enregistrement du fichier GEDCOM. Utilisez cette possibilité avec précaution, car cela nécessite une bonne compréhension de la syntaxe GEDCOM 5.5.1. Pour plus d'information sur le standard GEDCOM 5.5.1, veuillez vous référer à l'aide.<br /><br />PhpGedView permet (c'est son rôle) de mettre à jour votre fichier GEDCOM au travers des différentes transactions, mais vous pouvez avoir besoin d'intervenir directement sur celui-ci. Ne le faites que quand vous ne pensez pas possible de passer par les possibilités de transactions fournies par PhpGedView.<br />À la mise à jour, la conformité de vos modifications est vérifiée par rapport aux standards de base de la norme GEDCOM, et le label CHAN est mis à jour.<br /><br /><br />";
$pgv_lang["add_from_clipboard_help"]    = "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView vous permet de copier des événements ou des données vers le presse-papier. Vous pouvez copier jusqu'à 5 événements et les stocker dans le presse-papier.  Depuis le menu d'ajout d'évenements par glisser-déposer, vous pouvez choisir de coller l'un de ces événements depuis le presse-papier dans l'enregistrement en cours d'édition. C'est très utile quand vous saisissez des faits ou événements similaires pour plusieurs individus ou des familles entières.<br /><br />";
$pgv_lang["edit_PLAC_help"]             = "~#factarray[PLAC]#~<br /><br />Les lieux doivent être saisis selon les standards généalogiques. Les lieux sont enregistrés par niveaux, allant du particulier au général, séparés par une virgule.<br />Par exemple, un endroit comme Bergerac en Dordogne s'écrit :<br /> «Bergerac, F24100, Dordogne, Aquitaine, France».<br />Examinons chaque partie de ce lieu, ou nous avons précisé 5 niveaux :<br /> «Bergerac» est le niveau le plus fin que nous ayons voulu indiquer, la commune. Viennent ensuite «F24100» le code postal (ou code INSEE de la commune selon les bases, le code INS en Belgique), puis «Dordogne» et «Aquitaine», le département et la région. Le pays clôture la liste comme étant le niveau le plus général. Nous aurions pu aussi, détailler plus, et faire précéder le niveau commune d'un niveau plus fin (lieu dit, par exemple), ayant alors 6 niveaux.<br />Si un niveau est inconnu (ou que vous ne pensiez pas utile de le préciser), il vous faut laisser l'emplacement vide entre les deux virgules correspondantes. Si par exemple vous ne connaissez pas la région, l'adresse suivante est valide :<br />«Lieu-dit, Begerac, F24100, Dordogne, , France».<br /> Supposons que vous sachiez uniquement que l'évenement que vous décrivez se passe en Dordogne, vous notez :<br />«, , , Dordogne, , France». <br /><br /> D'une base à l'autre, et d'un pays à l'autre, le nombre de niveaux, et la définition des niveaux varient, mais est définie une fois pour toute dans le fichier GEDCOM. Vous devez donc saisir le lieux conformément à ce qui est prévu dans le fichier GEDCOM sur lequel vous intervenez. Vous trouvez cette information sur la page «Liste des lieux», indiqué en bas ('Les lieux sont classés dans cet ordre :').<br /><br /> Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour trouver les lieux déjà existants dans la base.<br /> <br />";
$pgv_lang["edit_add_parent_help"]       = "~Ajout d'une mère ou d'un père~<br /><br />Avec cette page, vous pouvez ajouter une nouvelle personne comme père ou mère de la personne sélectionnée. Saisissez le nom, les informations de naissance et de décès, c'est tout. Si vous ne possédez pas une des informations, laissez le champ correspondant à blanc.<br /><br />Pour ajouter d'autres faits ou événements en sus de la naissance ou du décès, créer d'abord la personne en confirmant la mise à jour. Après, cliquez sur le nom de la personne apparaissant maintenant sur la page de la Famille ou dans l'onglet #pgv_lang[relatives]# pour voir la page des #pgv_lang[indi_info]# de la personne. À partir de cette page #pgv_lang[indi_info]#, vous pouvez ajouter des informations détaillées.<br /><br />";
$pgv_lang["edit_add_spouse_help"]       = "~Ajout d'une nouvelle femme ou d'un nouvel époux~<br /><br />Avec cette page, vous pouvez ajouter une nouvelle personne comme épouse ou époux de la personne sélectionnée. Saisissez le nom, les informations de naissance et de décès, c'est tout. Si vous ne possédez pas une des informations, laissez le champ correspondant à blanc.<br /><br />Pour ajouter d'autres faits ou événements en sus de la naissance ou du décès, créer d'abord la personne en confirmant la mise à jour. Après, cliquez sur le nom de la personne apparaissant maintenant sur la page de la Famille ou dans l'onglet #pgv_lang[relatives]# pour voir la page des #pgv_lang[indi_info]# de la personne. À partir de cette page #pgv_lang[indi_info]#, vous pouvez ajouter des informations détaillées.<br /><br />";
$pgv_lang["edit_death_help"]            = "~#pgv_lang[death]#~<br /><br />Vous pouvez entrer ici les informations de décès. Saisissez en premier la date du décès, au format généalogique (1 JAN 2004). Vous pouvez cliquer sur l'icône  du calendrier afin de sélectionner une date. Entrez ensuite le lieu. Vous pouvez utiliser le lien #pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base.<br /><br />";
$pgv_lang["edit_birth_help"]            = "~#pgv_lang[birth]#~<br /><br />Vous pouvez entrer ici les informations de naissance. Saisissez en premier la date de celle-ci, au format généalogique (1 JAN 2004). Vous pouvez cliquer sur l'icône  du calendrier afin de sélectionner une date. Entrez ensuite le lieu. Vous pouvez utiliser le lien #pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base.<br /><br />";
$pgv_lang["edit_sex_help"]              = "~#pgv_lang[sex]#~<br /><br />Choisissez le sexe approprié dans la liste déroulante. Choisissez <b>inconnu</b> si vous n'avez pas l'information.<br /><br />";
$pgv_lang["edit_name_help"]             = "~#pgv_lang[name]#~<br /><br />C'est le champ le plus important dans l'enregistrement du nom d'un individu. Ce champ peut être rempli automatiquement en remplissant les champs particuliers qui suivent, (méthode préférable), il est fourni de façon à ce que vous puisssiez saisir ces information selon vos préférences personnelles. Ce champ doit être saisi selon les standards de la norme GEDCOM 5.5.1, avec le nom de famille entouré de «/». Par exemple, le nom «John Robert Finlay Jr.» doit être entré : «John Robert /Finlay/ Jr.».<br /><br />";
$pgv_lang["edit_suffix_help"]           = "~#pgv_lang[suffix]#~<br /><br />Ce champ optionnel vous permet de rentrer le suffixe du nom de la personne. Pa rexemple, «Sr.», «Jr.», ou «III».<br /><br />";
$pgv_lang["edit_surname_help"]          = "~#pgv_lang[surname]#~<br /><br />Saisir dans ce champ le nom de famille. Par exemple, «Dupont», pour une personne s'appellant «Jean pierre Dupont».<br /><br />";
$pgv_lang["edit_NICK_help"]             = "~#factarray[NICK]#~<br /><br />Dans ce champ, vous pouvez saisir le ou les surnoms de la personne. <br />Il s'agit d'un champ optionnel.<br /><br />";
$pgv_lang["edit_given_name_help"]       = "~#pgv_lang[given_name]#~<br /><br />Saisissez dans ce champ le ou les prénoms de la personne. Par exemple, si le nom de la personne est «Jean Pierre Dupont», saisissez «Jean Pierre».<br /><br />";
$pgv_lang["edit_NPFX_help"]             = "~#factarray[NAME]# #factarray[NPFX]#~<br /><br />Ce champ vous permet de saisir un préfixe du nom, tel «Dr.», ce qui donnera «Dr Jean Dupont».<br />À ne pas confondre avec le préfixe du nom de famille (particule, par ex.), qui est saisi dans le champ «Préfixe du nom de famille» ci-dessous.<br /><br />";
$pgv_lang["edit_add_child_help"]        = "~#pgv_lang[add_child]#~<br /><br />Avec cette page, vous pouvez ajouter une nouvelle personne comme enfant de la famille sélectionnée. Saisissez le nom, les informations de naissance et de décès, c'est tout. Si vous ne possédez pas une des informations, laissez le champ correspondant à blanc.<br /><br />Pour ajouter d'autres faits ou événements en sus de la naissance ou du décès, créer d'abord la personne en confirmant la mise à jour. Après, cliquez sur le nom de la personne apparaissant maintenant sur la page de la Famille ou dans l'onglet #pgv_lang[relatives]# pour voir la page des #pgv_lang[indi_info]# de la personne. À partir de cette page #pgv_lang[indi_info]#, vous pouvez ajouter des informations détaillées.<br /><br />";
$pgv_lang["review_changes_help"]        = "~Modifications non acceptées~<br /><br />Ce bloc liste tous les enregistrements qui ont été mis à jour en ligne, et qui doivent être vérifiés et acceptés.<br /><br />";
$pgv_lang["quick_update_name_help"]     = "~Modification du nom~<br /><br />Utilisez <b>Modif nom</b> pour mettre à jour le nom de la personne choisie. Vous avez un champ pour le nom propre et un champ pour le ou les prénoms. Par exemple, si la personne s'appelle «Jean Pierre Dupont», entrez «Jean Pierre» dans le champ <b>Prénom(s)</b> et «Dupont» dans le champ <b>Nom de famille</b>.<br /><br /> Remplir ces champs <u>modifiera</u> les noms de la personne,  cela n'ajoutera pas de nouveau nom.<br /><br /><i>Note : vous ne devez <u>pas</u> utiliser cette méthode si la modification est due à un nouveau mariage. Dans ce cas, utilisez le champ <b>Ajouter un nouvel époux</b> ci-dessous</i><br /><br />";
$pgv_lang["quick_update_fact_help"]     = "~Modification d'un événemenT~<br /><br />Utilisez les champs <b>Modif événement</b> pour ajouter ou pour mettre à jour un événement concernant la personne choisie. Choisissez un événement dans la liste déroulante, puis entrez la date à laquelle cet événement est survenu, en respectant le standard généalogique du format des dates  (1 JAN 2004). Vous pouvez cliquer sur l'icône du calendrier pour selectionner une date dans celui-ci. Entrez ensuite le lieu de cet événement. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour sélectionner un lieu déjà existant dans la base.<br /><br />Comme l'ensemble des champs de cette page, votre information remplacera l'information existante si elle existe, ou créera une nouvelle entrée.<br /><br />";
$pgv_lang["quick_update_address_help"]  = "~Modification adresse~<br /><br />Utilisez <b>Modification adresse</b> pour modifier celle-ci, ou le numéro de téléphone, de fax ou le mail de la personne choisie.<br /><br />Comme pour l'ensemble des champs de cette page, votre information remplacera celle existante si elle existe ou créera une nouvelle entrée.<br /><br />";
$pgv_lang["quick_update_spouse_help"]   = "~Ajouter un mari ou une femme~<br /><br />Utilisez ces champs quand vous désirez <u>ajouter</u> une épouse ou un époux à la personne choisie. Saisissez le nom du conjoint et les informations de naissance dans les champs concernés, puis entrez la date du mariage dans le champ correspondant. Entrez les dates dans le format du standard généalogique (1 JAN 1908). Vous pouvez cliquer sur l'icône du calendrier pour selectionner une date dans celui-ci. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour selectionner un lieu déjà existant dans la base.<br /><br />Ces champs peuvent seulement <u>ajouter</u> un conjoint, il ne sont pas faits pour mettre à jour un conjoint existant. Pour mettre à jour une personne déjà existante, fermez cette fenêtre et cliquez sur le nom de la personne concernée dans l'onglet <b>#pgv_lang[relatives]#</b>. Puis procédez à sa mise à jour avec cette même fenêtre.<br /><br />";
$pgv_lang["quick_update_marriage_help"] = "~Modification mariage~<br /><br />Vous pouvez employer ces champs conjointement avec les champs pour ajouter un nouveau conjoint si vous voulez enregistrer un nouveau mariage. Autrement, les données entrées dans ces champs modifieront les informations sur le dernier mariage de la personne. Entrez les dates dans le format généalogique (1 JAN 1908). Vous pouvez cliquer sur l'icône du calendrier afin de selectionner une date dans celui-ci. Vous pouver cliquer sur le lien <b>#pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base.<br /><br />";
$pgv_lang["quick_update_child_help"]    = "~Ajouter un nouvel enfant~<br /><br />Utilisez ces champs afin d'ajouter un nouvel enfant à la personne choisie. Entrez son ou ses prénoms et son sexe. Entrez ensuite le lieu et la date de naissance. Entrez les dates au format généalogique (1 JAN 1908). Vous pouvez cliquer sur l'icône du calendrier afin de choisir une date dans celui-ci. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour sélectionner un lieu déjà existant dans le base.<br /><br /> Ces champs servent seulement à <u>ajouter</u> un nouvel enfant. Ils ne peuvent mettre à jour un enfant déjà existant. Pour mettre à jour une personne déjà existante dans la base, fermez cette fenêtre, cliquez sur son nom dans l'onglet <b>#pgv_lang[relatives]#</b>. Il s'agira alors de la personne sélectionnée, et vous aurez accès à toutes les modifications la concernant.<br /><br />";
$pgv_lang["index_top10_pageviews_help"] = "~Les faits les plus consultés~<br /><br />Ce bloc liste les 10 individus, familles ou sources ayant étés le plus vus par les visiteurs. Pour que ce bloc fonctionne, l'administrateur doit avoir activé le compteur de visites.<br /><br />";
$pgv_lang["index_cookiepolicy_help"]		= "~#pgv_lang[block_cookiepolicy]#~<br /><br />Ce bloc affiche la politique de ce site concernant les cookies.";
$pgv_lang["cookiepolicy_link_help"]			= "~#pgv_lang[block_cookiepolicy_link]#~<br /><br />Laissez ce champ vide si vous voulez utiliser le texte standard.<br /><br />Si vous voulez utiliser le texte standard et aussi fournir un lien vers un fichier texte ou une page HTML ou autre qui contient des détails sur la politique de ce site concernant les cookies, vous devez entrer l'URL de cette page dans ce champ.<br /><br />Par exemple, l'entrée <b>http://foo.bar.com/policy/cookies.txt</b> peut vous mener à un fichier en texte simple, <b>http://foo.bar.com/policy/cookies.htm</b> peut décrire un lien à une page formatée en HTML, et <b>http://foo.bar.com/policy/cookies.doc</b> peut vous montrer un document codé en Microsoft Word.";
$pgv_lang["cookiepolicy_link_advice"]		= "Videz ce champ pour utiliser le texte standard.<br />Codez un URL comme <b>http://foo.bar.com/policy/cookies.txt</b> pour lier à une page ou un document qui contient plus de détails sur les politiques de ce site concernant les cookies.";
$pgv_lang["useradmin_user_default_tab_help"]= "~Onglet ouvert par défaut~<br /><br />Cette option vous permet de spécifier quel est l'onglet ouvert automatiquement lorsque l'utilisateur accède à la page #pgv_lang[indi_info]#. Si il a l'autorisation d'éditer son compte, l'utilisateur peut modifier cette option par la suite.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]= "~Onglet ouvert par défaut~<br /><br />Cette option vous permet de spécifier quel est l'onglet ouvert automatiquement lorsque vous ouvrez la page #pgv_lang[indi_info]#.<br /><br />";
$pgv_lang["reorder_children_help"]      = "~Re-ordonner les enfants~<br /><br />Les enfants apparaissent dans l'ordre dans lequel ils figurent dans l'enregistrement de la famille. Les enfants ne sont pas triés sur la date de naissance, car souvent celles-ci sont inconnues, alors que <u>l'ordre</u> des naissance l'est.<br /><br />Cette option vous permet de changer cet ordre. Si vous voulez trier les enfants sur la date de leur naissance, cliquez sur le bouton indiqué à ce fin. Vous pouvez aussi faire glisser toute case d'information et la déposer dans l'ordre voulu.<br /><br />";
$pgv_lang["rss_feed_help"]              = "~Réglages des flux RSS~<br /><br />Le flux ATOM/RSS disponible dans PhpGedView permet à n'importe qui de visualiser, en utilisant un agrégateur d'informations approprié, le contenu de votre page d'accueil de votre site sans le visiter. La plupart des agrégateurs notifient les utilisateurs d'une modification de l'information sur votre page d'accueil ou sur une quelconque page surveillée via ATOM/RSS. Ceci permet essentiellement à n'importe qui de suivre votre site PhpGedView sans avoir besoin de le visiter régulièrement.<br /><br />Le bloc de flux est configuré pour adapter le lien aux flux d'information, permettant des flux RSS de type spéficique (la plupart des lecteurs RSS peuvent traiter la plupart des types de flux, aussi le réglage de celui-ci peut habituellement être laissé par défaut), ainsi que le module spécifique que vous souhaiteriez utiliser pour vos flux RSS. Le language du flux d'information et du GEDCOM utilisés seront basés sur sur le language et le GEDCOM actifs dans PhpGedView quand vous sélectionnez le flux.<br /><br />Les types de flux qui peuvent être produits incluent ATOM, RSS 2.0, RSS 1.0, RSS 0.92, HTML et JavaScript. Les quatre premiers types sont destinés à des agrégateurs d'information, alors que le Javascript et le HTML sont censés permettre l'intégration de l'information dans d'autres pages web. Notez que les numéros de version de flux RSS indiquent différents modes de flux et non une version différente.<br /><br />Il y a une option pour choisir le mode d'authentification qui permettra la connexion de l'utilisateur, et permettra à l'utilisateur d'afficher, en utilisant un agrégateur de flux RSS approprié, n'importe quelle information qu'il pourrait visualiser normalement en visitant votre site. L'authentification de base utilise <i>l'authentification HTTP de base</i> pour connecter l'utilisateur. De futures améliorations pourraient permettre  <i>une authentification avec la méthode «digest» </i>.<br /><br />Cet <a href='http://en.wikipedia.org/wiki/RSS_(file_format)' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>article de Wikipedia</b></a> contient des informations et des liens complets sur RSS et les différents formats de RSS. <i>L'authentification HTTP de base</i> est débattue dans cet <a href='http://en.wikipedia.org/wiki/Basic_authentication_scheme' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>article de Wikipedia</b></a>, tandis que <i>la méthode d'authentification «Digest» </i> est discuttée dans cet article <a http://en.wikipedia.org/wiki/Digest_access_authentication' target='_blank' alt='Wikipedia article' title='Wikipedia article'><b>de Wikipedia</b></a>.<br /><br />";
$pgv_lang["upload_media_folder_help"]   = "~#pgv_lang[folder]#~<br /><br />Votre configuration GEDCOM permet jusqu'à  #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveaux de répertoires au delà du répertoire par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b> là où les fichiers média téléchargés sont normalement stockés. Ceci vous laisse organiser vos fichiers média, et ainsi vous n'avez pas à vous soucier de maintenir des noms uniques pour chacun des médias stocké.<br /><br />Dans ce champ, vous indiquez le répertoire de destination sur votre serveur où le fichier média doit être téléchargé et stocké.  Soyez attentif à l'utilisation des minuscules ou majuscules quand vous sélectionnez ou saisissez des noms de fichiers ou de dossiers, puisque ces noms sont sensibles aux majuscules/minuscules.<br /><br />Si le nom du répertoire que vous saisissez ici n'existe pas, il sera créé automatiquement. Si vous entrez plus de sous-dossiers ou sous-répertoires que les #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveaux de répertoires autorisés par votre configuration GEDCOM, les informations entrées seront tronquées en conséquence.<br /><br />Les vignettes (miniatures) seront téléchargées ou créées dans une structure indentique, commençant par <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
$pgv_lang["upload_media_file_help"]     = "~#pgv_lang[media_file]#~<br /><br />Dans ce champ vous spécifiez la localisation et le nom, sur votre ordinateur local, du fichier média que vous souhaitez télécharger sur le serveur. Vous pouvez utiliser le bouton <b>Parcourir</b> pour rechercher sur votre ordinateur le fichier souhaité.<br /><br />Le fichier téléchargé conservera le même nom sur le serveur et il sera téléchargé vers le répertoire spécifié dans le champ <b>#pgv_lang[folder]#</b>.  Si vous ne voyez pas ce champ ou ne pouvez pas le changer, la configuration de votre fichier GEDCOM a été paramétrée pour vous interdire l'ajout de sous-répertoires au-delà du niveau de répertoire par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b> où sont normalement stockés les fichiers média.<br /><br />Vous pouvez laisser ce champ vide si vous voulez uniquement mettre à jour la vignette et faire de la vignette l'image principale.<br /><br />";
$pgv_lang["upload_thumbnail_file_help"] = "~#pgv_lang[thumbnail]#~<br /><br />Dans ce champ vous spécifiez la localisation et le nom, sur votre ordinateur local, du fichier média que vous souhaitez télécharger sur le serveur. Vous pouvez utiliser le boutton <b>Parcourir</b> pour rechercher sur votre ordinateur le fichier souhaité.  Quand ce champ est complété, la case à cocher <b>#pgv_lang[auto_thumbnail]#</b> est ignorée.<br /><br />Si le champ <b>#pgv_lang[media_file]#</b> a été complété, le fichier correspondant à votre vignette sera mis à jour et renommé selon le contenu de ce champ, indépendamment du nom indiqué sur votre ordinateur local.  Si ce champ est vide, la vignette mise à jour sera copiée à deux endroits sur le serveur : dans le répertoire indiqué dans le champ <b>#pgv_lang[folder]#</b>, et ensuite dans une structure de dossier identique commençant par <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Si vous ne voyez pas le champ <b>#pgv_lang[folder]#</b> ou si vous ne pouvez pas le modifier, la configuration de votre fichier GEDCOM a été paramétrée pour vous interdire l'ajout de sous-répertoires au-delà du niveau de répertoire par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b> où sont normalement stockés les fichiers média.<br /><br />";
//-- GENERAL
$pgv_lang["help_header"]                = "Aide sur : ";
$pgv_lang["privacy_error_help"]         = "<b>Détails privés</b><br /><br />Plusieurs raisons possibles à ce message :<dl><dt>1. Vous n'êtes pas inscrit sur ce site</dt><dd>Les détails sur les personnes vivantes sont masqués.<br />Les visiteurs non authentifiés ont accès aux fiches des personnes décédées uniquement.<br />Vous pouvez faire une demande de compte.</dd><dt>2. Vous disposez d'un compte et d'un mot de passe</dt><dd>mais vous avez oublié de vous connecter.</dd><dt>3. Information marque «Privé»</dt><dd>La personne sélectionnée a demandé ce verrouillage à l'administrateur<br />Dans ce cas, seul l'administrateur a l'accès aux détails sur cette personne.</dd><dt>4. Vous n'avez pas de lien direct</dt><dd>Même pour les utilisateurs déclarés et connectés, certaines informations ne sont accessibles qu'aux proches, suivant le degré fixé par l'administrateur.<br />Exemples :<br />Pour le degré <b>1</b>, vous verrez les détails de votre propre famille, père, mère, frère, sœur (mais pas leurs conjoints ni vos neveux et nièces)<br />Pour le degré <b>2</b>, vous verrez en plus les conjoints de vos frères/sœurs et vos neveux/nièces.<br />Plus le degré est élevé, plus vous voyez de proches.<br />Si vous pouvez justifier d'un lien de parenté, contacter l'administrateur.</dd></dl>";
$pgv_lang["more_help"]                  = "<br />Pour une aide plus détaillée, vérifier l'option <b>#pgv_lang[show_context_help]#</b> dans le menu <b>#pgv_lang[page_help]#</b>, et suivre les liens <b>#pgv_lang[qm]#</b> de la page.<br />";
$pgv_lang["more_config_help"]           = "<br /><b>Aide détaillée</b><br />Une aide plus détaillée est disponible.<br />Suivre les liens <b>?</b> de la page.<br /><br />";
$pgv_lang["start_admin_help"]           = "+++ Début du complément d'informations de l'administrateur +++";
$pgv_lang["end_admin_help"]             = "--- Fin du complément d'informations de l'administrateur ---";
$pgv_lang["multiple_help"]              = "<span class='center'>--- Aide commune à plusieurs pages ---</span>";
$pgv_lang["header_general_help"]        = "<div class='name_head center'><b>Informations générales</b></div><br />";
$pgv_lang["best_display_help"]          = "~#pgv_lang[resolution]#~<br />PhpGedView est prévu pour une taille d'écran de 1024x768 pixels.<br />Il s'agit de la valeur minimum pour que tout s'affiche correctement.<br />Avec une résolution inférieure, par exemple 800x600, vous devrez souvent utiliser les ascenceurs (scrolling).<br />";
$pgv_lang["preview_help"]               = "~#pgv_lang[print]#~<br />Le lien <b>#pgv_lang[print_preview]#</b> en bas de chaque page permet une impression plus propre en n'affichant pas les menus, les liens, les boutons d'aide...<br /><br />Le lien <b>#pgv_lang[print_preview]#</b> devient alors <b>#pgv_lang[print]#</b>, et affiche votre menu d'impression habituel.<br />Après l'impression, utilisez simplement le bouton <b>Retour</b> de votre navigateur.<br /><br /><b>Note :</b><br />En mode <b>#pgv_lang[print_preview]#</b> la plupart des liens sont cachés. Les liens sur les cases et les personnes restent néanmoins actifs.<br />";
$pgv_lang["readme_help"]                = "<span class='center'>Voir le fichier <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> pour davantage d'informations.</span>";
$pgv_lang["is_user_help"]               = "--- Texte identique à l'aide visiteur. --- <br />--- Pour économiser de la place, il n'y a pas de texte spécial administrateur ici. ---";
$pgv_lang["edit_raw_gedcom_help"]       = "~#pgv_lang[edit_raw]#~<br /><br />En cliquant sur ce lien, une nouvelle fenêtre s'ouvre permettant la <B>modification</B> de l'enregistrement GEDCOM.<br />Respecter impérativement la syntaxe GEDCOM 5.5 car aucun contrôle n'est réalisé.<br />Les modifications effectuées seront soumises à l'approbation de l'administrateur.";
$pgv_lang["RESN_help"]                  = "~Restrictions d'accès sur un enregistrement~<br /><br />En plus des règles globales de restrictions d'accès, PhpGedView offre la possibilité d'ajouter des restrictions d'accès en lecture et/ou écriture à certains enregistrements concernant une Famille ou un Individu.<br /><br />Valeurs possibles pour ce champ :<br /><ul><li><b>#pgv_lang[none]#</b><br />Les administrateurs du site ou du fichier GEDCOM, ainsi que les utilisateurs avec privilèges, peuvent modifier l'information. Pour les autres, la lecture est autorisée conformément aux règles de restrictions globales.</li><li><b>#pgv_lang[locked]#</b><br />Le droit de modification est réservé aux administrateurs, et à l'utilisateur dont ce sont les propres informations.</li><li><b>#pgv_lang[privacy]#</b><br />L'information est cachée, sauf aux administrateurs et à l'utilisateur concerné.</li><li><b>#pgv_lang[confidential]#</b><br />Information accessible aux seuls administrateurs.</li></ul><br /><table><tr><th></th><th colspan=2>Admin</th><th colspan=2>Individu</th><th colspan=2>Autres</th></tr><tr><th></th><th>R</th><th>W</th><th>R</th><th>W</th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\"/> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\"/> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\"/> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\" /></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\"/> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr></table><ul><li>R : droit de lire</li><li>W : droit de modifier</li><li><img src=\"images/checked_qm.gif\"/> : droits selon les règles de restrictions globales</li></ul>";
//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]                 = "~#pgv_lang[welcome_page]#~<br />Bienvenue sur la page d'accueil du fichier <a href=\"#def_gedcom\">GEDCOM</a> sélectionné. À tout moment vous pouvez revenir sur cette page par le bouton <b>#pgv_lang[welcome_page]#</b> du menu principal. Si plusieurs fichiers GEDCOM sont disponibles, faîtes-votre choix dans le menu déroulant<br /><br /><b>Ici vous trouverez de l'aide sur :</b><br /><li><a href=\"#header_general\">Informations générales</a><li><a href=\"#header\">#pgv_lang[header]#</a><li><a href=\"#menu\">Menus</a><li><a href=\"#index_portal\">#pgv_lang[welcome_page]#</a><li><a href=\"#def\">Définitions</a><br /><br />La version #VERSION# de <a href=\"#def_pgv\">PhpGedView</a> apporte des améliorations sur la présentation, les menus, la page d'accueil, et de nombreuses fonctions ont été revues.<br /><br />";
//-- Index-page Header
$pgv_lang["header_help"]                = "<div class='name_head center'><b>#pgv_lang[header]#</b></div><br />En haut de chaque page s'affichent des boutons et liens utilisables à tout moment.<br />La présentation du site étant personnalisable, le bandeau est variable selon le <a href=\"#def_theme\">thème</a> choisi.<br /><br /><b>Voici la liste des liens que vous pourrez y trouver :</b><li><a href=\"#header_search\">#pgv_lang[search]#</a><li><a href=\"#header_lang_select\">#pgv_lang[change_lang]#</a><li><a href=\"#header_user_links\">#pgv_lang[login]#</a><li><a href=\"#header_favorites\">#pgv_lang[gedcom_favorites]#</a><li><a href=\"#header_theme\">#pgv_lang[change_theme]#</a><br />";
$pgv_lang["header_search_help"]         = "~#pgv_lang[header]# «#pgv_lang[search]#»~<br />Cette case de recherche est petite mais puissante.<br />Laissez PhpGedView chercher pour vous.<br />Vous trouverez une aide détaillée sur la page de recherche.<br />";
$pgv_lang["header_lang_select_help"]    = "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br />PhpGedView est multi-langues. Par défaut il démarre dans la langue de votre navigateur.<br />Vous pouvez changer de langue en utilisant le <B>menu déroulant</B> ou bien la liste des <B>drapeaux</B> en couleur.<br />";
$pgv_lang["header_user_links_help"]     = "~#pgv_lang[header]# «#pgv_lang[login]#»~<br />Cette liste de liens reste présente au même endroit sur toutes les pages (sauf si vous changez le thème).<br />Non connecté, vous voyez uniquement le lien <B>#pgv_lang[login]#</B>.<br />Connecté, vous voyez <b>#pgv_lang[logged_in_as]#</b>. Ce lien vous donne l'accès à votre compte. Cliquer sur <B>#pgv_lang[logout]#</B> pour vous déconnecter.<br />Si vous avez les droits d'administrateur, le lien <B>#pgv_lang[admin]#</B> s'affiche.<br />";
$pgv_lang["header_favorites_help"]      = "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br />Cette liste affiche les liens favoris que vous avez sélectionnés. S'y ajoutent les favoris enregistrés pour ce fichier GEDCOM par l'administrateur.<br />Ces liens vous offrent l'accès direct à la page détaillée de l'individu choisi.<br />Pour savoir comment ajouter un favori, consulter l'aide sur la page <B>#pgv_lang[my_favorites]#</B>.<br />";
$pgv_lang["header_theme_help"]          = "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br />Si l'administrateur l'autorise, vous pouvez choisir votre thème dans une liste, et modifier ainsi l'affichage du site. Si vous êtes connecté, ce thème sera mémorisé et deviendra votre thème par défaut.<br />";
//-- Index-page Menu
$pgv_lang["menu_help"]                  = "<div class='name_head center'><b>Menus</b></div><br />En passant votre souris sur l'icone d'un menu, un sous-menu s'affiche.<br />Un clic vous emmène sur la page du premier sous-menu.<br /><br />Liste des menus disponibles :</b><br /><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /><li><a href=\"#menu_rslog\">#pgv_lang[research_assistant]#</a><br /><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a><br /><br />";
$pgv_lang["menu_famtree_help"]          = "~#pgv_lang[menu]# «#pgv_lang[welcome_page]#»~<br />Tous les fichiers GEDCOM disponibles sur le site sont présentés ici. Chacun ayant sa propre présentation.<br />Quand le site ne présente qu'un seul fichier GEDCOM, ce sous-menu est vide.<br /><br />";
$pgv_lang["menu_myged_help"]            = "~#pgv_lang[menu]# «#pgv_lang[mygedview]#»~<br />Si vous êtes connecté, ce menu présente les choix suivants :<dl><dt>#pgv_lang[mygedview]#</dt><dd>Vous renvoie sur votre propre #pgv_lang[welcome_page]#.</dd><dt>#pgv_lang[editowndata]#</dt><dd>Pour modifier vos paramètres personnels.</dd><dt>#pgv_lang[my_pedigree]#</dt><dd>Si vous avez choisi un #pgv_lang[root_person]# pour ce fichier GEDCOM, son #pgv_lang[index_header]# s'affichera</dd><dt>#pgv_lang[my_indi]#</dt><dd>Lien vers votre page individuelle, où se trouvent les données de votre propre famille.</dd></dl>";
$pgv_lang["menu_charts_help"]           = "~#pgv_lang[menu]# «#pgv_lang[charts]#»~<br />Liste des diagrammes disponibles :<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Affiche les parents de l'individu racine du fichier GEDCOM. Vous pouvez le modifier si vous êtes connecté.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Même principe. Affiche la liste des enfants.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Affiche les événements d'une ou plusieurs personnes sur une même ligne de temps, permettant de les comparer.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Recherche du lien de parenté entre deux personnes</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Présentation sous forme #pgv_lang[ancestry_list]# ou #pgv_lang[ancestry_booklet]#</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Présentation en roue ou en éventail.</dd></dl>";
$pgv_lang["menu_lists_help"]            = "~#pgv_lang[menu]# «#pgv_lang[lists]#»~<br />Les choix suivants sont présentés dans ce menu :<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dd>Présentation alphabétique des individus du fichier GEDCOM.</dd><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>Présentation alphabétique des familles du fichier GEDCOM.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Liste des sources d'informations citées dans ce fichier GEDCOM.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Liste par lieux sur deux colonnes : à gauche les individus et à droite les familles.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Cette option ne s'affiche que si l'administrateur l'a autorisé.<br />Liens vers tous les OBJEts MultiMédia de ce fichier GEDCOM.</dd></dl>";
$pgv_lang["menu_annical_help"]          = "~#pgv_lang[menu]# «#pgv_lang[anniversary_calendar]#»~<br />Affiche les événements ayant eu lieu à une certaine date.<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Ces éléments de menu vous amèneront au #pgv_lang[anniversary_calendar]# pour afficher une liste de tous les événements pour le jour, le mois ou l'année en cours.</li></ol><br />";
$pgv_lang["menu_clip_help"]             = "~#pgv_lang[menu]# «#pgv_lang[clippings_cart]#»~<br />Si l'administrateur l'a autorisé, ce menu s'affiche sur le bandeau.<br />Un panier vous permet de collecter des informations.<br /><br />";
$pgv_lang["menu_search_help"]           = "~#pgv_lang[menu]# «#pgv_lang[search]#»~<br />Accès à une page de recherche très puissante.<br /><br />";
$pgv_lang["menu_help_help"]             = "~#pgv_lang[menu]# «#pgv_lang[page_help]#»~<br />#pgv_lang[help_help_items]#";
//-- Index-page Portal
$pgv_lang["index_portal_head_help"]     = "<div class='name_head center'><b>#pgv_lang[welcome_page]#</b></div><br />";
$pgv_lang["index_portal_help"]          = "La #pgv_lang[welcome_page]# présente plusieurs blocs séparés, et elle est personnalisable. Ainsi, chaque fichier GEDCOM de ce site peut avoir sa propre #pgv_lang[welcome_page]#.<br /><br />Voici la liste des blocs disponibles :<ul><li><a href=\"#index_welcome\">#pgv_lang[welcome_block]#</a><li><a href=\"#index_login\">#pgv_lang[login_block]#</a><li><a href=\"#index_events\">#pgv_lang[upcoming_events_block]#</a><li><a href=\"#index_onthisday\">#pgv_lang[todays_events_block]#</a><li><a href=\"#index_favorites\">#pgv_lang[gedcom_favorites_block]#</a><li><a href=\"#index_stats\">#pgv_lang[gedcom_stats_block]#</a><li><a href=\"#index_media\">#pgv_lang[random_media_block]#</a><li><a href=\"#index_loggedin\">#pgv_lang[logged_in_users_block]#</a><li><a href=\"#gedcom_news\">#pgv_lang[gedcom_news_block]#</a><li><a href=\"#recent_changes\">#pgv_lang[recent_changes_block]#</a></ul>";
$pgv_lang["index_welcome_help"]         = "~#pgv_lang[welcome_block]#~<br />Ce bloc affiche :<br />Le fichier GEDCOM actif, et suivant la configuration : la date, l'heure et le compteur de visites.<br />Le compteur ne fonctionne que sur les pages #pgv_lang[welcome_page]# et «Individu». Il enregistre le nombre d'accès (<i>hits</i>) à ces pages.<br />Le compteur ne vérifiée pas la provenance des visites, donc quand un même visiteur revisite une page aprèsThe counter does not check the URL of a visitor, so when somebody revisits a page after some time, it will be counted as another Hit.<br />";
$pgv_lang["index_login_help"]           = "~#pgv_lang[login_block]#~<br />Vous n'aurez accès aux informations protégées qu'une fois connecté.<br />Pour cela, entrez votre <b>nom d'utilisateur</b> et votre <b>mot de passe</b>.<br /><br />#pgv_lang[new_password_help]#<br /><br />";
$pgv_lang["index_events_help"]          = "~#pgv_lang[upcoming_events_block]#~<br />#pgv_lang[upcoming_events_descr]#<br />";
$pgv_lang["todo_help"]                  = "~&quot;TO DO&quot; BLOCK~<br />Ce bloc vous aide à conserver une trace des tâches <b>_TODO</b> dans la base de données.<br /><br />Pour ajouter des tâches &quot;To Do&quot; à vos enregistrements, vous pouvez en premier lieu amender la configuration du GEDCOM afin que le fait <b>_TODO</b> apparaisse dans la liste des faits qui peuvent être ajoutés aux enregistrements des individus, familles, sources, et dépôts d'archives. Chacune de ces listes, que vous trouverez dans la section Modifier les options de la configuration du GEDCOM, est indépendante. L'ordre des entrées de la liste n'est pasimportant; vous pouvez ajouter les nouvelles entrées au début de chacune des listes.<br /><br />";
$pgv_lang["todo_show_other_help"]       = "Show &quot;To Do&quot; tâches assignées aux autres utilisateurs";
$pgv_lang["todo_show_unassigned_help"]  = "Show &quot;To Do&quot; tâches qui ne sont assignées à aucun utilisateur";
$pgv_lang["todo_show_future_help"]      = "Show &quot;To Do&quot; tâches qui ont une date dans le futur. Sinon seuls les items qui ont une date dans le passé sont affichés. ";
$pgv_lang["yahrzeit_help"]              ="~Bloc Yahrzeiten~<br />Ce bloc montre les Yahrzeiten qui vont arriver dans un avenir proche.<br /><br />Les Yahrzeiten (singulier : Yahrzeit) sont les anniversaires du décès d'une personne.  Ces anniversaires sont célébrés dans la tradition juive ; ils ne le sont partiquement plus dans les autres traditions.  «Yahrzeit» peut aussi être épelé «Jahrzeit» ou «Yartzeit».<br /><br />L'administrateur détermine l'apparence de ce bloc. Vous pouvez par la suite améliorer l'affichage de ce bloc en faisant appel aux options de configuration.<br /><br />";
$pgv_lang["days_to_show_help"]          = "~#pgv_lang[days_to_show]#~<br /><br />Saisissez le nombre de jours à afficher. Ce nombre ne pourra pas excéder <b>#DAYS_TO_SHOW_LIMIT#</b>.  Si vous entrez une valeur plus grande, la valeur limite sera utilisée.<br /><br />La limite est spécifiée par l'administrateur dans la configuration du GEDCOM, section «Affichage», sous-section «Cacher/Montrer».";
$pgv_lang["random_media_persons_or_all_help"]= "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Cette option vous permet de déterminer le type de média visualisé. <br /><br />Quand vous choisissez <b>#pgv_lang[random_media_persons]#</b>, seuls les médias associées à des individus seront visibles. Habituellement, ce sera la photographie d'un individu. Quand vous sélectionnez <b>#pgv_lang[random_media_events]#</b>, seuls les médias associés à des faits ou des événements seront visibles. Il peut s'agir d'une image ou d'un document numérisé. Quand vous sélectionnez <b>#pgv_lang[all]#</b>, ce bloc montrera tous les types de média.";
$pgv_lang["random_media_filter_help"]   = "~#pgv_lang[filter]#~<br /><br />Vous pouvez restreindre ce que le bloc «Une image au hasard» a le droit d'afficher en fonction du format et du type de média.  Quand vous cochez la case correspondant à votre choix, ce bloc est autorisé à afficher les média correspondant au format ou au type que vous avez sélectionné.<br /><br />Les formats ou les types de média qui existent dans votre base de données mais qui ne figurent pas dans ces listes à cocher, sont supposées avoir leur case déjà cochée. Par exemple, si votre base de données contient des média au format <b><i>pdf</i></b>, le bloc «Une image au hasard» a l'autorisation d'afficher les média de ce type.  De même, si votre base de données contient des média du type <b><i>special</i></b>, ce bloc Une image au hasard a l'autorisation d'afficher les média de ce type.";
$pgv_lang["basic_or_all_help"]          = "~#pgv_lang[basic_or_all]#~<br /><br />Cette option vous permet de supprimer quelques événements datés.  Par exemple, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. devraient systématiquement être datés.<br /><br />Quand vous choisissez <b>#pgv_lang[yes]#</b>, seuls les naissances, les décès, et les mariages seront affichés. Quand vous choisissez <b>#pgv_lang[no]#</b>, tous les événements datés seront affichés.";
$pgv_lang["style_help"]                 = "~#pgv_lang[style]#~<br /><br />Cette option contrôle comment les informations sont présentées.<br /><br />Quand vous sélectionnez <b>#pgv_lang[style1]#</b>, les informations sont présentées sous la forme de textes, semblables à ce que vous pouvez voir dans les divers diagrammes.  Ce format convient aux blocs de texte qui apparaissent sur le côté droit de la page.<br /><br />Quand vous sélectionnez <b>#pgv_lang[style2]#</b>, les informations sont présentes sous la forme d'un tableau qui convient mieux aux blocs qui sont affichés du côté gauche de la page.";
$pgv_lang["cal_dowload_help"]           = "~#pgv_lang[cal_download]#~<br /><br />Cette option contrôle l'affichage du bouton permettant de télécharger le calendrier des événements. Le fichier du calendrier téléchargé peut être importé dans un programme compatible comme Microsoft Outlook, par exemple, générant automatiquement des rappels d'anniversaires par courriel.<br /><br />Quand le réglage est <b>#pgv_lang[no]#</b>, l'utilisateur connecté ne pourra pas télécharger le calendrier. Quand le réglage est <b>#pgv_lang[yes]#</b>, le bouton de téléchargement est visible. Le bouton est toujours masqué si l'utilisateur n'est pas connecté.";
$pgv_lang["index_charts_help"]          = "~#pgv_lang[charts_block]#~<br />Ce bloc permet l'affichage d'un arbre d'ascendance, de descendance, ou un  roue d'ascendance sur la page d'accueil ou la page personnelle Mon portail de l'utilisateur. En raison des limitations de place, les diagrammes ne doivent être affichés que sur la partie gauche de la page.<br /><br />Quand ce bloc est affiché sur la page d'accuail, la personne racine et le type de diagramme affiché sont définis par l'administrateur. Quand ce bloc est affiché sur la page personnelle Mon portail de l'utilisateur, ces options sont définies par l'utilisateur.<br /><br />Le comportement de ces diagrammes est identique à leur comportement quand ils sont affichés depuis les barres de menu. Si vous cliquez sur la case d'une personne vous obtiendrez des détails supplémentaires sur cette personne.<br /><br />";
$pgv_lang["index_onthisday_help"]       = "~#pgv_lang[todays_events_block]#~<br />Ce bloc fonctionne comme le #pgv_lang[upcoming_events_block]#, sauf qu'il affiche les événements d'aujourd'hui.<br />";
$pgv_lang["index_favorites_help"]       = "~#pgv_lang[gedcom_favorites_block]#~<br />Fonctionnement identique au bloc «Mes Favoris», mais il n'est modifiable que par l'administrateur.<br /><br />Son but est d'attirer l'attention des visiteurs sur une personne qui présente un intérêt particulier. La liste déroulante des favoris est disponible à tout moment sur chaque page. Le lien vous conduira vers la page détaillée de l'individu choisi.<br />";
$pgv_lang["index_add_favorites_help"]   = "~Ajouter un favori~<br />Ce formulaire vous permet d'ajouter un nouveau favori à votre liste de favoris. Vous devez entrer l'ID de l'individu ou de la famille ou la source que vous voulez enregistrer comme favori, sinon vous pouvez saisir un URL et un titre. Le champ Notes est optionnel et peut être utilisé pour décrire le favori.  N'importe quel commentaire écrit dans le champ Notes sera affiché dans le bloc favoris après celui-ci.<br /><br />";
$pgv_lang["index_stats_help"]           = "~#pgv_lang[gedcom_stats_block]#~<br />Ce bloc présente quelques chiffres concernant ce fichier GEDCOM.<br />Si vous souhaitez d'autres informations, utilisez le lien <B>Contact</B> en bas de page.<br /><br />#pgv_lang[index_common_names_help]#";
$pgv_lang["index_common_names_help"]    = "~#pgv_lang[common_surnames]#~<br />Ce bloc affiche la liste des noms de familles les plus fréquents. Leur nombre est déterminé par l'administrateur.<br /><br />En cliquant sur un nom de la liste, vous afficherez la page <b>#pgv_lang[individual_list]#</b>, qui vous donnera davantage de détails.<br />";
$pgv_lang["index_common_given_names_help"]= "~#pgv_lang[most_common_given_names]#~<br />Ce bloc affiche une liste des noms de familles les plus nombreux dans la base de données. Vous pouvez choisir le nombre de noms de familles que vous voulez voir apparaître dans la liste. <br /><br />";
$pgv_lang["index_media_help"]           = "~#pgv_lang[random_media_block]#~<br />Ce bloc affiche de façon aléatoire un OBJEt MultiMédia de la base GEDCOM.<br />En cliquant sur l'objet, il s'affichera en taille réelle.<br /><br />Au-dessous de l'objet, vous trouverez un lien vers la fiche de la personne associée à cet objet.<br />";
$pgv_lang["index_loggedin_help"]        = "~#pgv_lang[logged_in_users_block]#~<br />Ce bloc affiche le nombre d'utilisateurs actuellement connectés.";
$pgv_lang["index_gedcom_news_help"]     = "~#pgv_lang[gedcom_news_block]#~<br />Ce bloc fonctionne comme un tableau d'affichage.<br /><br />L'administrateur y affiche des annonces importantes ou des nouveautés intéressantes.<br /><br />Si vous avez quelquechose d'y afficher, vous devez contacter l'administrateur qui peut le faire pour vous.<br />";
$pgv_lang["recent_changes_help"]        = "~#pgv_lang[recent_changes_block]#~<br />Ce bloc affiche les modifications les plus récentes suivant les marqueurs CHAN du fichier GEDCOM.";
$pgv_lang["gedcom_news_limit_help"]     = "Vous pouvez limiter le nombre de nouveaux articles affichés, réduisant de ce fait la taille du bloc des nouvelles du GEDCOM.<br /><br />Cette option détermine si des limites doivent être appliquées ou si la limite du nombre d'articles doit être contrôlée à partir de l'ancienneté de l'article ou le nombre total d'articles.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]      = "Saisissez la valeur limite ici.<br /><br />Si vous avez opté pour la limite de l'affichage des articles à partir de leur date de publication, tout article plus vieux que le nombre de jours spécifiés sera masqué. Si vous avez opté pour limiter le nombre d'articles selon leur nombre, seulement le nombre spécifié d'articles parmi les plus récents sera affiché.  Les articles restants seront masqués.<br /><br />Un Zéro saisi ici supprimera toutes limites, affichant tous les articles.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]   = "Afin de réduire la hauteur du bloc «Nouvelles», l'administrateur a caché certains articles. Vous pouvez les visualiser en cliquant sur <b>#pgv_lang[gedcom_news_archive]#</b> link.<br /><br />";
$pgv_lang["index_htmlplus_help"]        = "~#pgv_lang[htmlplus_block_name]#~<br />Ce bloc permet à l'administrateur d'ajouter des informations sur la page d'index ou sur la page du portail (page d'accueil). Son but est semblable aux blocs #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, et #pgv_lang[gedcom_stats_block]#, mais l'administrateur dispose d'un plus grand contrôle sur son aspect et sa mise en forme.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]  = "~#factarray[TITL]#~<br />Ce champ titre du bloc de texte doit être laissé vide ou alors rempli très succinctement.  S'il est laissé vide, le bloc en HTML avancé sera visualisé sur la page d'index ou sur la page d'accueil du portail comme un bloc de texte plein, comme le bloc en HTML standard.  Quand il y a du texte, le bloc en HTML avancé sera visualisé comme les autres blocs, complet avec une barre de titre pour le bloc contenant le texte que vous avez saisi ici.<br /><br />";
$pgv_lang["index_htmlplus_template_help"]= "~#pgv_lang[htmlplus_block_templates]#~<br />Pour vous aider à travailler avec ce bloc, nous avons créé plusieurs modèles standards. Quand vous sélectionnez l'un de ces modèles, l'espace de saisie du texte contient une copie que vous pouvez modifier et personnaliser selon les exigences de votre site.<br /><br />";
$pgv_lang["index_htmlplus_content_help"]= "~#pgv_lang[htmlplus_block_content]#~<br />À la différence des blocs #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, et #pgv_lang[gedcom_stats_block]#, vous avez le contrôle complet de l'aspect du bloc. Vous pouvez utiliser des balises HTML, les blocs utilisent les feuilles de style CSS de votre thème actif. Vous pouvez faire référence aux informations contenues dans votre base généalogique active en utilisant des champ de fusion.<br /><br />Les éléments de référence à votre base de données généalogiques sont identifiés dans le texte grâce à l'utilisation de mots clés entourés par des balises comme <b>&#35;</b>. Par exemple, <b>&#35;totalFamilies&#35;</b> représente le nombre de familles dans la base de données.  Occasionnellement vous pouvez souhaiter utiliser une référence à votre base de données comme du texte courant. Pour réaliser cela, vous devez remplacer les symboles (balises) <b>&#35;</b> autour des mots-clés (référence à la base) par leur symboles équivalents. Par exemple, si votre texte contient <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b> il sera affiché comme <b>&#35;totalFamilies&#35;</b> au lieu de devenir une référence à la base de données active.<br /><br />Pour un exemple complet d'utilisation de ce bloc, étudiez SVP les modèles de bloc <b>#pgv_lang[gedcom_stats_block]#</b> enregistrés dans le répertoire blocks, il emploie la plupart des modèles de balises, incluant la syntaxe et les liens du texte d'aide.<br /><br />Les modèles <b>#pgv_lang[htmlplus_block_keyword]#</b> contiennent une liste complète des mots-clés supportés.<br /><br />";
$pgv_lang["index_htmlplus_compat_help"] = "~#pgv_lang[htmlplus_block_compat]#~<br />Permet la compatibilité avec des versions plus anciennes des blocs. Quand ils sont vérifiés, les anciens et les nouveaux mots-clés seront reconnus indifféremment.<br /><br />Par exemple, le texte <b>&#35;TOTAL_FAM&#35;</b> sera reconnu comme équivalent de <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> pour <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> pour <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />À moins que ce ne soit absolument nécessaire, vous ne devriez pas employer le mode compatibilité.<br /><br />";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br />Choisissez la base de données à laquelle sont liés les mots clés.<br /><br />Votre site supporte plusieurs bases de données. Les mots clés tels que <b>&#35;totalFamilies&#35;</b> se réfèrent uniquement à une seule base de données.  Vous pouvez identifier la base de données qui doit être consultée par tous les mots-clés.  Chaque bloc #pgv_lang[htmlplus_block_name]# ne peut accéder qu'à une seule base de données.<br /><br />";
$pgv_lang["showUnknown_help"]           = "~#pgv_lang[showUnknown]#~<br />Montrer ou masquer la liste des noms de famille des personnes dont le sexe est inconnu. <br /><br />Le bloc #pgv_lang[block_givn_top10]# masque toujours la liste des noms de famille quand aucune personne de ce sexe n'existe dans la base de données. Cette option vous permet de masquer la liste des personnes de sexe inconnu même s'il existe de telles personnes dans votre base de données. <br /><br />";
//-- Index-Page Help
$pgv_lang["help_help"]                  = "La plupart des fonctions peuvent s'utiliser sans explication.<br />Cependant, certains de nos visiteurs ne sont pas très familiers avec l'ordinateur et Internet. Nous leur offrons de l'aide à plusieurs endroits.<br />Dans le menu Aide, vous trouverez les chapitres suivants :<br />";
$pgv_lang["help_page_help"]             = "<dl><dt><b>#pgv_lang[help_for_this_page]#</b></dt><dd>Il existe un texte d'aide pour chaque page. En cliquant sur <b>#pgv_lang[page_help]#</b>, vous aurez une aide générale sur la page active.<br />Pour une aide plus détaillée, ou de l'aide  sur un champ, cliquer sur <B>#pgv_lang[qm]#</B> qui affichera l'aide contextuelle.</dd></dl>";
$pgv_lang["help_content_help"]          = "<dl><dt><b>Sommaire de l'aide</b></dt><dd>Ce menu affiche la liste de tous les textes d'aide disponibles.</dd></dl>";
$pgv_lang["help_faq_help"]              = "<dl><dt><b>Liste des FAQ (Foire aux questions)</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_qm_help"]               = "<dl><dt><b>#pgv_lang[show_context_help]#</b></dt><dd>L'aide contextuelle est la façon la plus confortable d'obtenir de l'aide.<br />Il suffit de cliquer sur le lien <B>#pgv_lang[qm]#</B> présent en de nombreux endroits.<br />Cette option est débrayable en choisissant <B>#pgv_lang[hide_context_help]#</B>.</dd></dl>";
//-- Index-page Definitions
$pgv_lang["def_help"]                   = "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Voici quelques explications sur les termes qui sont utilisés dans ce texte d'Aide :<ul><li><a href=\"#def_gedcom\"><b>GEDCOM</b></a><br /></li><li><a href=\"#def_gedcom_date\"><b>Dates</b></a></li><li><a href=\"#def_pdf_format\"><b>fichier au format PDF</b></a></li><li><a href=\"#def_pgv\"><b>PhpGedView</b></a></li><li><a href=\"#def_portal\"><b>Portail</b></a></li><li><a href=\"#def_theme\"><b>Thème</b></a></li></ul><br />";
$pgv_lang["def_portal_help"]            = "~Portail~<br />Le portail de ce site est un peu comme l'entrée d'un restaurant ou d'une bibliothèque. C'est le lieu par lequel vous entrez, mais vous pouvez aussi y trouver des informations importantes telles que des explications, des menus, etc.<br /><br />";
$pgv_lang["def_gedcom_help"]            = "~Fichier GEDCOM~<br />Voici un extrait de l'introduction au standard GEDCOM 5.5.1 :<div class=\"list_value_wrap\">GEDCOM a été développé par le département de l'histoire des familles de l'Eglise de Jésus-Christ des Saints des derniers jours (Mormons) afin de fournir un format flexible et unforme permettant l'échange de données généalogiques informatisées.&nbsp; GEDCOM est l'acronyme de <i><b>GE</b></i>néalogique <i><b>D</b></i>onnées <i><b>Com</b></i>munication (COMmunication de Données GEnéalogiques).&nbsp; Son objectif est de faciliter l'échange d'informations généalogiques et le développement d'un éventail important de logiciels inter-operables afin de faciliter le travail des génealogistes, historiens, et autres chercheurs.</div><br />Une <u>copie de travail</u> du standard GEDCOM 5.5.1, auquel PhpGedView adhère, peut être téléchargée au format PDF ici:&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\">GEDCOM 5.5.1 Standard</a> Ce standard n'est disponible qu'en anglais.<br /><br />Le fichier GEDCOM contient toutes les informations sur la famille.&nbsp; Tous les faits, les dates, les événements, etc. sont enregistrés ici.&nbsp; Les fichiers GEDCOM doivent suivre des règles strictes afin de pouvoir être échangés entre beaucoup de programmes différents, indépendamment de la plateforme ou du système d'exploitation utilisé.<br /><br />";
$pgv_lang["def_gedcom_date_help"]       = "~Dates GEDCOM~<br />Le format des enregistrements d'un fichier GEDCOM doit suivre les règles de cette norme, et il y a bien sûr une convention concernant les dates.<br /><br /> Le champ date est un champ libre (ce qui signifie que vous pourriez taper du texte libre), mais les conventions de saisie sont les suivantes :<br />La date entière est entrée dans le format JJ MM AAAA, comme ceci :<br /><b>01 Mar 1801</b> ou <b>14 Dec 1950</b><br />Si vous ne connaissez pas une partie de la date, vous pouvez l'omettre, ce qui donne :<br /><b>Mar 1801 </b> ou  <b>14 Dec</b><br />Si votre information est imprécise, vous pouvez indiquer :<br /><b>abt Mar 1801</b> (abt = about = environ)</b><br /><b>bef 20 Dec 1950</b> (bef = before = avant) ou <b>< 20 Dec 1950</b><br /><b>aft 1949</b> (aft = after = après) ou <b>>1949</b><br />Vous devez entrer ces informations en Anglais, car les fichiers GEDCOM sont échangeables et les programmes doivent traduire les dates dans les diffrentes langues.<br /> Les programmes ont aussi à effectuer des calculs à partir de ces dates. Une date non conforme rendra son utilisation impossible ou donnera des résultats erronés.<br />Les abréviations sont les suivantes :<br />JAN janvier,<br />FEB fevrier,<br />MAR mars,<br />APR avril,<br />MAY mai,<br />JUN juin,<br />JUL juillet,<br />AUG aoùt,<br />SEP septembre,<br />OCT octobre,<br />NOV novembre,<br />DEC décembre.<br />bef ou < = avant,<br />abt = environ,<br />aft ou > = après.";
$pgv_lang["def_gramps_help"]            = "~GRAMPS XML Database file~<br />Un mot du projet GRAMPS :<div class=\"list_value_wrap\">GRAMPS vous aide à pister votre arbre familial. Il vous permet de stocker, éditer et rechercher des données généalogiques. GRAMPS essaye de fournir toutes les possibilités communes aux autres programmes généalogiques, mais plus important, de vous fournir des fonctions supplémentaires permettant une capacité d'intégration d'informations généalogiques non disponible dans d'autres programmes. C'est la capacité d'entrer n'importe quel élément d'information directement dans GRAMPS et de manipuler, réarranger n'importe quels événements dans la base (dans n'importe quel ordre) pour aider l'utilisateur dans ses recherches, dans ses analyses en corrélation avec le potentiel des relations pouvant être définies entre les individus et les événements.</div><br />Une copie du format XML de GRAMPS v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">peut être téléchargé ici</a> dans les formats RELAX NG et DTD.<br /><br />Pour plus d'informations à propos du projet GRAMPS, visitez <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]               = "~PhpGedView~<br />PhpGedView (ou PGV) ne fait pas que placer des pages statiques sur le Web; il est dynamique et peut être personnalisé de multiples façons.<br /><br />PhpGedView a été créé par John Finlay dans le but de pouvoir visualiser des fichiers GEDCOM en ligne. John a commencé à développer le programme tout seul. Une équipe internationale de développeurs et de traducteurs l'a rejoint depuis et travaille à l'amélioration du programme. Parmi les fonctions les plus significatives qui ont été ajoutées ou améliorées dans le programme on peut citer son support important de nombreuses langues, et sa capacité à ajouter et modifier des événements en ligne.<br /><br />";
$pgv_lang["def_theme_help"]             = "~Theme~<br />Ce site peut avoir différentes\"apparences\", appelées Thèmes.<br /><br />L'administrateur du site choisit le thème par défaut, qui sera affiché par toute personne qui se connectera pour la première fois. Quand l'administrateur l'a autorisé, tous les utilisateurs peuvent choisir leur propre Thème. PhpGedView se souvient du dernier thème choisi par chaque utilisateur enregistré, afin que cet utilisateur verra affiché ce Thème la prochaine fois qu'il se connectera. Les Thèmes peuvent être utilisés comme un moyen pour différencier les différentes bases de données qui sont hébergées sur un même site. Chaque base de données peut avoir son propre Thème par défaut.<br /><br />";
//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]      = "~#pgv_lang[mygedview]#~<br />Il s'agit de votre page #pgv_lang[mgv]# personnelle.<br /><br />Vous pourrez trouver sur cette page des liens pour accéder à vos données personnelles telles que <b>Mon compte</b>, <b>Mon indi</b> (il s'agit de votre page #pgv_lang[indi_info]# individuelle), et <b>Mon ascendance</b>. Vous pouvez avoir des blocs avec des <b>Messages</b>, un <b>Journal</b> et beaucoup d'autres choses.<br /><br />La structure de cette page est similaire à la page d'accueil qui est affichée lorsque vous accédez pour la première fois au site. Tandis que les différentes parties de la page d'accueil sont choisies par l'administrateur du site,vous pouvez choisir quelles sont les parties que vous voulez intégrer sur cette page personnelle. Vous trouverez le lien qui vous permettra de personnaliser la page dans le bloc de bienvenue ou séparément si le bloc de bienvenue n'est pas présent. <br /><br />Vous pouvez choisir parmi les blocs suivants:<ul><li><a href=\"#mygedview_welcome\"><b>Bienvenue</b></a></li><li><a href=\"#mygedview_customize\"><b>Personnaliser votre page d'accueil</b></a></li><li><a href=\"#mygedview_message\"><b>Mes Messages</b></a></li><li><a href=\"#mygedview_events\"><b>Prochains anniversaires</b></a></li><li><a href=\"#mygedview_onthisday\"><b>Ce jour là</b></a></li><li><a href=\"#mygedview_charts\"><b>Diagrammes</b></a></li><li><a href=\"#mygedview_favorites\"><b>Mes favoris</b></a></li><li><a href=\"#mygedview_stats\"><b>Statistiques GEDCOM</b></a></li><li><a href=\"#mygedview_myjournal\"><b>Mon Journal</b></a></li><li><a href=\"#mygedview_media\"><b>Une image au hasard</b></a></li><li><a href=\"#mygedview_loggedin\"><b>Utilisateurs connectés</b></a></li><li><a href=\"#mygedview_recent_changes\"><b>Modifications récentes</b></a></li></ul><br />";
$pgv_lang["mygedview_customize_help"]   = "~PERSONNALISER #pgv_lang[mygedview]#~<br />Lorsque vous entrez sur cette page pour la première fois, vous avez déjà des blocs sur cette page. Si vous le souhaitez, vous pouvez personnbaliser cette page qui s'appelle Mon portail.<br /><br />Si vous cliquez sur ce lien vous serez dirigé vers un formulaire sur lequel vous pourrez ajouter, déplacer, ou supprimer des blocs. Des explications supplémentaires sont disponibles sur ce formulaire.<br /><br />";
$pgv_lang["mygedview_message_help"]     = "~BLOC MES MESSAGES ~<br />Dans ce bloc vous trouverez les messages qui vous ont été envoyés par les autres utilisateurs ou par l'administrateur du site. Vous pouvez également envoyer des messages aux autres utilisateurs ou à l'administrateur à partir de ce bloc.<br /><br />Le système de mail de PhpGedView a été conçu pour protéger votre vie privée. Vous n'avez pas besoin de laisser votre adresse email ici et les autres utilisateurs ne pourront pas voir votre adresse email.<br /><br />Pour voir la totalité d'un message, cliquez sur l'objet du message ou sur le symbole \"<b>+</b>\" qui se trouve à côté. Vous pouvez supprimer plusieurs messages en cochant les petites boites qui se trouvent à côté de chacun des messages que vous voulez supprimer et en cliquant sur le bouton <b>Supprimer les messages sélectionnés</b>.<br /><br />";
$pgv_lang["mygedview_favorites_help"]   = "~BLOC MES FAVORIS~<br />Les favoris sont similaires aux signets.<br /><br />Supposons que vous ayez quelqu'un dans votre arbre familial dont vous voulez consulter l'enregistrement régulièrement. Il vous suffit de vous rendre sur la page  #pgv_lang[indi_info]# de cette personne et de sélectionner l'option <b>Ajouter à mes favoris</b> depuis le menu déroulant Favoris. Cette personne est maintenant enregistrée dans vos favoris. <br /><br />Où que vous vous trouviers ur le site, vous pouvez cliquer sur un nom dans la menu déroulant \"Mes Favoris\" qui se trouve dans la barre de menus. Cela vous amènera à la page #pgv_lang[indi_info]# de cette personne.<br /><br />";
$pgv_lang["mygedview_myjournal_help"]   = "~BLOC MON JOURNAL~<br />Vous pouvez utiliser ce journal pour écrire des notes ou des rappels pour votre usage personnel. Quand écrivez des notes, elles seront encore présentes lors de votre prochaine visite du site. <br /><br />Ces notes sont privées et ne seront pas visibles par d'autres personnes.<br /><br />";
$pgv_lang["mygedview_welcome_help"]     = "~BLOC BIENVENUE~<br />Le bloc Bienvenue vous affiche:<ul><li>Le fichier GEDCOM courant</li><li>La date et l'heure</li><li>Des liens vers:<ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></li></ul><br /><b>Note:</b><br />Vous verrez des liens vers <b>Ma fiche</b>et<b>Mon arbre</b> uniquement si vous êtes connu du fichier GEDCOM courant. Vous pouvez avoir un enregistrement dans un fichier GEDCOM et donc voir les liens vers<b>Ma fiche</b> et <b>Mon arbre</b>, tandis que dans un autre fichier GEDCOM vous n'avez aucun enregistrement vous concernant et donc ces liens ne sont pas affichés.";
//-- Pedigree-page
$pgv_lang["help_pedigree.php"]          = "~#pgv_lang[index_header]#.~<br /><br />L'arbre d'ascendance d'une personne est la liste de ses ancêtres : son père, sa mère, leurs parents, etc...<br />Les informations concernant chaque personne s'affichent dans des cases, et offrent des liens vers d'autres pages.<dl><dt>Cases</dt><dd>Avec l'option <a href=\"?help=show_full_help\">#pgv_lang[show_details]#</a>, les informations principales (naissance, mariage, décès) sont affichées. Dans le cas contraire, seul le nom est indiqué. En cliquant sur le nom, vous êtes redirigé vers la page <a href=\"?help=help_individual.php\">#pgv_lang[personal_facts]#</a> de l'individu.<br /></dd><dt>Sous-menu</dt><dd>Avec l'option <a href=\"?help=show_full_help\">#pgv_lang[show_details]#</a>, une première image dans la case affiche un sous-menu. Ce sous-menu est similaire au <a href=\"?help=menu_charts_help\">#pgv_lang[menu]# «#pgv_lang[charts]#»</a>, sauf que l'#pgv_lang[root_person]# est remplacé par la personne indiquée dans la case. D'autres liens permettent de naviguer vers conjoints et enfants.</dd><dt>Zoom</dt><dd>Une deuxième image offre un zoom donnant davantage de détails sur l'individu choisi.</dd><dt>Flèches</dt><dd>Aux extrêmes gauche et droite du graphique, des flèches facilitent la navigation par génération.</dd></dl>";
$pgv_lang["show_full_help"]             = "~#pgv_lang[show_details]#~<br /><br />Option pour afficher les détails de chaque individu sur le diagramme.<br /><br />Détails masqués, vous pouvez afficher davantage de personnes sur une page. Pour voir les détails, il suffit alors soit de cliquer, soit de passer la souris sur la case. Cela dépend de la configuration choisie par l'administrateur.";
$pgv_lang["talloffset_help"]            = "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />#pgv_lang[PEDIGREE_LAYOUT_help]#<br />Utile avec un écran pivotable, ou pour faire une impression d'écran (print-screen).";
$pgv_lang["rootid_help"]                = "~#pgv_lang[rootid]#~<br /><br />Pour démarrer d'une autre personne, entrez son code, appelé identifiant GEDCOM, ou plus simplement ID. Par exemple <b>I65</b>. Si vous ne le connaissez pas, utilisez le lien «#pgv_lang[find_id]#».";
$pgv_lang["PEDIGREE_GENERATIONS_help"]  = "~#pgv_lang[generations]#~<br /><br />#pgv_lang[generations]# à afficher sur cette page. À règler en fonction de la taille de votre écran, et suivant que vous affichez les détails ou non.";
//-- LOGIN-page
$pgv_lang["login_page_help"]            = "~#pgv_lang[login]#~<br /><br />Sur cette page vous pouvez : vous connecter, #pgv_lang[requestaccount]# ou #pgv_lang[requestpassword]#.<br />";
$pgv_lang["username_help"]              = "~#pgv_lang[username]#~<br /><br />Entrer ici votre nom d'utilisateur. Respecter majuscules/minuscules.";
$pgv_lang["password_help"]              = "~#pgv_lang[password]#~<br /><br />Entrer ici votre mot de passe. Respecter majuscules/minuscules.";
$pgv_lang["login_buttons_help"]         = "~#pgv_lang[login]# / #pgv_lang[admin]#~<br /><br />Sur cette page, deux boutons vous sont proposés :<dl><dt>#pgv_lang[login]#</dt><dd>Ce bouton vous ramènera vers la page par laquelle vous êtes venu.</dd><dt>#pgv_lang[admin]#</dt><dd>Si vous avez les droits administrateur, vous pouvez utiliser ce bouton pour accéder directement à la page Administration.</dd></dl>";
$pgv_lang["login_buttons_aut_help"]     = "~Authentication mode login buttons~<br /><br />Vous avez deux boutons pour vous connecter au système.<br /><br />La page vers laquelle vous serez dirigé après votre authentification dépend du bouton sur lequel vous cliquez.<br /><ul><li>Le bouton <b>#pgv_lang[login]#</b> <br /> En cliquant sur ce bouton, vous êtres dirigé vers votre page #pgv_lang[mygedview]#, où vous pourrez mettre à jour vos paramêtres personnels, vos favoris, envoyer et lire vos messages, etc.</li><br /><li>Le bouton <b>#pgv_lang[admin]#</b> <br />Si vous cliquez sur ce bouton, et que vous avez les droits d'Administrateur, vous serez dirigé vers la page Administration.</li></ul><br />";
$pgv_lang["new_password_help"]          = "~#pgv_lang[requestpassword]#~<br />Si vous avez perdu votre mot de passe, cliquez sur ce lien. Vous serez redirigé vers le formulaire de «#pgv_lang[lost_pw_reset]#».";
$pgv_lang["new_user_help"]              = "~#pgv_lang[requestaccount]#~<br /><br />Si vous souhaitez demander un compte d'accès personnel, cliquez sur ce lien. Vous serez redirigé vers le formulaire de demande de compte.";
$pgv_lang["mygedview_login_help"]       = "Pour accéder au portail «#pgv_lang[mygedview]#», vous devez vous identifier.<br /><br />Avec le portail «#pgv_lang[mygedview]#» vous pourrez mémoriser vos préférences, conserver un journal, gérer vos messages, voir les autres utilisateurs connectés...<br /><br />Connectez-vous :";
$pgv_lang["new_user_firstname_help"]    = "~#pgv_lang[firstname]#~<br /><br />Entrez ici votre prénom.";
$pgv_lang["new_user_lastname_help"]     = "~#pgv_lang[lastname]#~<br /><br />Entrez ici votre nom de famille.<br /><br />C'est ce nom qui s'affichera aux autres utilisateurs connectés.<br /><br />Ce nom est nécessaire pour vérifier votre parenté et vous donner les droits appropriés.";
$pgv_lang["register_info_01"]           = "Respect de la vie privée : certaines informations sont en accès restreint.<br /><br />Pour obtenir l'accès, vous devez créer un compte. Enregistrez-vous en remplissant le formulaire. L'administrateur examinera votre demande.<br /><br />Une fois connecté, vous pourrez consulter les informations privées de tous les individus, ou uniquement de vos proches, selon le choix de l'administrateur. Il peut aussi vous accorder le droit d'ajouter ou modifier certaines informations.<br /><br />Note : vous devez justifier d'un lien de parenté pour obtenir un compte sur cette base.<br /><br />Dans le cas contraire, l'accès vous sera refusé.<br /><br />Pour toute question, contacter l'administrateur (lien en bas de cette page).<br /><br />";
$pgv_lang["register_info_02"]           = "~Demander un nouveau compte utilisateur~<br /><br />La quantité de données qui peuvent être publiquement publiées sur ce site web peut être limitées en raison de l'application des lois et décrets concernant la protection de la vie privée. Beaucoup de gens ne veulent pas que leurs données personnelles soient publiées sur Internet. Des données personnelles pourraient être utilisées pour du spam ou à des fins commerciales.<br /><br />L'accès à ce site n'est possible qu'aux utilisateurs <u>autorisés</u>. Après que l'administrateur a vérifié et approuvé votre demande d'inscription, vous serez autorisé à vous connecter et visualiser les informations d'ordre privé.<br /><br />Si le contrôle des liens familiaux a été activé, vous ne pourrez visualiser que les individus liés directement à votre arbre proche. L'administrateur peut également permettre l'édition et la manipulation des données à certains utilisateurs, ils peuvent ainsi ajouter ou modifier de l'information.<br /><br />Si vous souhaitez plus d'informations, utilisez le lien pour contacter l'administrateur du site.<br /><br />";
$pgv_lang["register_info_03"]           = "~Demander un nouveau compte utilisateur~<br /><br />La quantité de données qui peuvent être publiquement publiées sur ce site web peut être limitées en raison de l'application des lois et décrets concernant la protection de la vie privée. Beaucoup de gens ne veulent pas que leurs données personnelles soient publiées sur Internet. Des données personnelles pourraient être utilisées pour du spam ou à des fins commerciales.<br /><br />L'accès à ce site n'est possible qu'aux <u>membres de la famille uniquement</u>. Après que l'administrateur a vérifié et approuvé votre demande d'inscription, vous serez autorisé à vous connecter et visualiser les informations d'ordre privé.<br /><br />Si le contrôle des liens familiaux a été activé, vous ne pourrez visualiser que les individus liés directement à votre arbre proche. L'administrateur peut également permettre l'édition et la manipulation des données à certains utilisateurs, ils peuvent ainsi ajouter ou modifier de l'information.<br /><br />Si vous souhaitez plus d'informations, utilisez le lien pour contacter l'administrateur du site.<br /><br />";
//-- Descendancy-page
$pgv_lang["help_descendancy.php"]       = "~#pgv_lang[descend_chart]#~<br /><br />L'arbre de descendance d'une personne est la liste de ses enfants, petits-enfants, etc... avec leurs conjoints.<br /><br />Fonctionnement des boutons, sous-menus et liens similaire à l'<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.<br />Pour davantage de lisibilité, chaque branche peut s'ouvrir <img src=\"images/plus.gif\" /> ou se fermer <img src=\"images/minus.gif\" /> d'un simple clic.<br />La <a href=\"?help=box_width_help\">#pgv_lang[box_width]#</a> est également modifiable.<br /><br />En marge est indiqué le numéro de descendant selon le système d'Aboville.<br />Ainsi le 1.2.5 est le cinquième enfant du deuxième enfant de l'individu racine.";
$pgv_lang["desc_rootid_help"]           = "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]      = "#pgv_lang[PEDIGREE_GENERATIONS_help]#";
//-- Time line-page
$pgv_lang["help_lifespan.php"]          = "~Diagramme de ligne de temps~<br /><br />Sur ce diagramme vous pouvez afficher un ou plusieurs individus le long d'un axe chronologique horizontal. Ce diagramme vous permet de voir comment les vies de différents individus se suivent ou se juxtaposent.<br /><br />Vous pouvez ajouter individuellement des individus à ce diagramme ou par famille. La liste précédente sera mémorisée au fur et à mesure que vous ajouterez des individus au diagramme. Vous pouvez vider le diagramme à n'importe quel moment avec le bouton <b>Effacer tout</b>.<br /><br />Vous pouvez également ajouter des individus au diagramme en les recherchant par date ou lieux.<br /><br />";
$pgv_lang["lifespan_add_person_help"]   = "#pgv_lang[add_person_help]#~Inclure la proche famille~<br />L'option Inclure la proche famille est paramétrée par défaut. En laissant cette case cochée, vous visualiserez sur la ligne de temps le père, la mère, l'épouse, les frères et sœurs, ainsi que les enfants des individus qui sont ajoutés à la ligne de temps.  Désélectionnez cette option si vous souhaitez enlever la famille proche.<br /><br />";
$pgv_lang["help_timeline.php"]          = "~#pgv_lang[timeline_chart]#~<br /><br />Affiche les événements d'une ou plusieurs personnes sur une même ligne de temps, permettant de les comparer.";
$pgv_lang["add_person_help"]            = "~#pgv_lang[add_another]#~<br /><br />Pour ajouter une personne, entrez son identifiant GEDCOM (exemple : <b>I65</b>).<br />Si vous ne le connaissez pas, utilisez le lien «#pgv_lang[find_id]#».";
$pgv_lang["remove_person_help"]         = "~#pgv_lang[remove_person]#~<br /><br />Pour retirer une personne du diagramme.<br />La fiche de cette personne n'est ni modifiée, ni supprimée.";
$pgv_lang["show_age_marker_help"]       = "~#pgv_lang[show_age]#~<br /><br />Option pour activer le marqueur d'âge, affichant l'âge de la personne à une année donnée.<br />Le marqueur se déplace sur la ligne de temps avec la souris.<br />Il existe un marqueur pour chacune des personnes sur le diagramme.";
$pgv_lang["timeline_control_help"]      = "~Commandes ligne de vie~<br /><br />~VITESSE~<br />Cliquez le menu déroulant pour changer la vitesse de défilement de l'axe chronologique.<br /><br />~Année de départ~<br />Entrer l'année de départ de la chronologie.<br /><br />~Année de fin~<br />Entrer l'année de fin de la chronologie.<br /><br />~Recherche~<br />Cliquez sur le bouton de recherche pour commencer la recherche d'événements qui se sont produits durant la période définie par les années de début et de fin.<br /><br />";
//-- Relationship-page
$pgv_lang["help_relationship.php"]      = "~#pgv_lang[relationship_chart]#~<br /><br />Recherche du lien de parenté entre deux personnes.<br />Il peut s'agir d'un lien direct (de sang) ou d'un lien indirect (par mariage).";
$pgv_lang["relationship_id_help"]       = "~#pgv_lang[id]# #pgv_lang[person1]# #pgv_lang[person2]#~</b><br /><br />Si, sur la page précédente, vous avez cliqué «#pgv_lang[relationship_to_me]#», les deux champs sont déjà renseignés.<br />Sinon, sélectionnez deux individus en entrant leur ID, ou en cliquant sur «#pgv_lang[find_id]#»";
$pgv_lang["next_path_help"]             = "~#pgv_lang[next_path]#~<br /><br />Bouton pour afficher le prochain lien de parenté, s'il existe.<br />Pour réafficher un lien de parenté précédent, cliquer sur son numéro dans la liste.";
$pgv_lang["follow_spouse_help"]         = "~#pgv_lang[follow_spouse]#~<br /><br />Option pour élargir la recherche aux liens par mariage.<br />Sinon, seuls les liens de sang sont pris en compte.";
$pgv_lang["line_up_generations_help"]   = "~#pgv_lang[line_up_generations]#~<br /><br />Option pour afficher les personnes de même génération sur une ligne horizontale.<br />Sinon, les individus sont affichés à la suite sur la page, sans tenir compte des générations.";
$pgv_lang["oldest_top_help"]            = "~#pgv_lang[oldest_top]#~<br /><br />Option pour afficher les résultats dans le sens parents-enfants du haut vers le bas.<br />Par défaut, c'est l'inverse : les individus les plus jeunes sont affichés en premier.<br /><br />Ne fonctionne que si l'option <a href=\"?help=line_up_generations_help\">#pgv_lang[line_up_generations]#</a> est activée.";
//-- Ancestry-page
$pgv_lang["help_ancestry.php"]          = "~#pgv_lang[ancestry_chart]#~<br /><br />Cette page affiche les ancêtres d'une personne, comme l'<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mais d'une façon plus détaillée, et avec plusieurs choix de <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />À chaque ancêtre est attribué un numéro unique, selon le système <i>Sosa-Stradonitz</i>, le plus répandu dans le monde :<br /> - pair pour les hommes (double de celui de son enfant)<br /> - impair pour les femmes (numéro de son mari +1) avec une exception pour le <b>1</b><br /><br />Ainsi le <b>7</b> est la femme du <b>6</b>, la mère du <b>3</b>, et la fille des <b>14</b> et <b>15</b>.";
$pgv_lang["box_width_help"]             = "~#pgv_lang[box_width]#~</b><br /><br />Vous pouvez faire varier la largeur des cases entre 50% et 300%.<br />La valeur initiale est 100% : chaque case fait environ 270 pixels de large.";
$pgv_lang["chart_style_help"]           = "~#pgv_lang[chart_style]#~<br /><br />Choix entre :<dl><dt>#pgv_lang[ancestry_list]#</dt><dd>L'arbre, présenté verticalement, comporte autant de niveaux que de générations, avec à chaque fois deux branches : celle du père (numéro pair) et celle de la mère (numéro impair).</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>Présentation d'une famille par page avec les parents, les grand-parents et la liste de tous les enfants connus. Ce format est idéal pour imprimer le récapitulatif d'une famille et l'offrir à vos proches</dd></dl>";
//-- Fan chart-page
$pgv_lang["help_fanchart.php"]          = "~#pgv_lang[fan_chart]#~<br /><br />Cette page affiche les ancêtres d'une personne, comme l'<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mais d'une façon plus visuelle : sous la forme d'une roue ou d'un éventail.<br />L'individu racine est au centre, ses parents sur la première couronne, les grand-parents sur la seconde ...<br /><br />Pour chaque personne, figurent son nom et ses dates de naissance et décès.";
$pgv_lang["fan_width_help"]             = "~#pgv_lang[fan_width]#~</b><br /><br />Vous pouvez faire varier la taille de la roue entre 50% et 300%.<br />La valeur initiale est 100% : l'image de la roue fait environ 640 pixels de large.";
$pgv_lang["fan_style_help"]             = "~#pgv_lang[chart_style]#~<br /><br /><dl><dt>1/2</dt><dd>Demi-roue (180°)</dd><dt>3/4</dt><dd>Trois-quarts de roue (270°) ou «Roue du paon»</dd><dt>4/4</dt><dd>Roue entière (360°)</dd></dl>";
//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]         = "~#pgv_lang[hourglass_chart]#~<br /><br />Le «sablier» présente les ascendants et les descendants de la personne séléctionnée au sein d'un même diagramme. Ce graphe est une combinaison du diagramme «ascendants» et du diagramme «descendants».<br /><br />La personne sélectionnée est au centre de la page, les descendants listés à gauche, les ascendants listés à droite, chaque génération alignée en colonne, partant de la plus récente pour finir à la plus ancienne.<br /><br />";
//-- Family Book chart-page
$pgv_lang["help_familybook.php"]        = "~#pgv_lang[familybook_chart]#~<br /><br />Ce diagramme est très semblable au diagramme Sablier. Il montrera les ascendants et les descendants de l'individu sélectionné sur le même diagramme. Il montrera également les descendants de l'individu dans le même format que le diagramme Sablier.<br /><br />L'individu sélectionné est centré au milieu de la page avec ses descendants énumérés à gauche et ses ascendants à sa droite. Dans cette vue, chaque génération est alignée sur la page en commençant par la première génération et en terminant par la dernière.<br /><br />Chaque descendant de l'individu sélectionné deviendra l'individu principal d'un Sablier supplémentaire, affiché sur la même page. Cette procédure d'affichage est répétée jusqu'au nombre indiqué de générations de descendants affiché.";
$pgv_lang["fambook_descent_help"]       = "~#pgv_lang[descent_steps]#~<br /><br />Cette valeur détermine le nombre de générations de descendants de l'individu racine qui sera affiché dans le format Sablier.<br /><br />";
//-- Indilist-page
$pgv_lang["help_indilist.php"]          = "~Liste des individus~<br /><br />Cette page permet de lister les individus. Les listes sont présentées par nom de famille et par ordre alphabétique.<br /><br />La liste de noms affichée dépend de :<ol><li>La lettre sur laquelle vous avez cliqué dans l'index alphabétique, ou si vous avez cliqué sur le bouton <b>Tous</b>. </li><li>Si vous avez choisi l'option <b>Afficher tous les noms</b> ou <b>Afficher la liste des noms</b> en bas de page.</li></ol>#pgv_lang[context_help]#<br /><br />";
$pgv_lang["alpha_help"]                 = "~Index alphabétique~<br /><br />Cliquer sur une des lettres affichera la liste des noms (ou l'ensemble des personnes) dont le nom de famille commence par cette lettre.<br /><br />Si le choix <b>#pgv_lang[NN]#</b> apparait en avant dernière position de l'index, cela signifie qu'il y a dans la base au moins un individu dont le nom de famille n'est pas connu (c.a.d. vide). Les noms de familles inconnus sont souvent remplacés par un <b>?</b>, et ces noms seront reconnus comme inconnus (<b>#pgv_lang[NN]#</b>) par PhpGedView.<br /><br /><b>Note :</b><br />Les noms de famille enregistrés sous la forme, par exemple, <b>Nn</b>, <b>NN</b>, <b>Inconnu</b>, ou <b>N.N.</b> ne figureront <u>pas</u> dans la liste affichée en cliquant sur <b>#pgv_lang[NN]#</b>. Ils figureront dans les listes affichées en cliquant sur <b>N</b> ou <b>I</b> puisqu'il s'agit de leur «initiale». PhpGedView ne peut en effet pas prendre en compte toutes les possibilités d'enregistrer un nom inconnu. Il n'existe pas de convention pour cela.<br /><br />À la fin de l'index, vous avez le choix <b>Tous</b>. Lorsque vous cliquez sur cette case, vous affichez tous les noms de famille de la base.<br /><br /><b>Caractères manquants :</b><br />Si l'index alphabétique est incomplet, cela signifie qu'il n'y a pas dans la base de nom de famille commençant par les lettres manquantes.<br /><br />";
$pgv_lang["name_list_help"]             = "~Liste des noms~<br /><br />Cette case affiche une liste des noms ou tous les noms (tous les individus) correspondants à l'initiale que vous avez cliquée dans l'index alphabétique, sauf si vous avez cliqué sur <b>Tous</b>.<br /><br /> L'affichage de la «Liste des nom» ou de «Tous les noms» dépend du statut <b>Afficher tous les noms / Afficher la liste des noms</b> du lien ci-dessous.<br /><br />";
$pgv_lang["skip_sublist_help"]          = "~Sauter la sous-liste~<br /><br />Par défaut, en cliquant sur un caractère alphabétique, vous faites apparaitre la liste des noms commençant par cette lettre, et pour chacun, le nombre d'individus ayant ce nom. Si vous cliquez sur ce lien, vous ferez apparaitre, de la même façon, tous les individus ayant un nom commençant par cette lettre.<br /><br />";
//-- Families-page
$pgv_lang["help_famlist.php"]           = "~Liste des familles~<br /><br />Cette page permet de lister les familles. Les listes sont présentées par nom de famille et par ordre alphabétique.<br /><br />La sélection dépend de :<ol><li>La lettre de l'index sur laquelle vous avez cliqué,</li><li>du choix entre <b>Afficher la liste des noms</b> ou <b>Afficher tous les noms</b> que vous aurez fait.</li></ol>Vous pouvez chercher sur le nom du mari ou de la femme, les deux sont inclus dans les listes.<br /><br /> #pgv_lang[context_help]#<br /><br />";
$pgv_lang["help_family.php"]            = "~Détail de la famille~<br /><br />Cette page vous présente une vue d'ensemble de la famille que vous avez sélectionnée sur une page précédente.<br /><br />De haut en bas,  sont présentés le mari et ses parents, l'épouse et ses parents, les enfants. En bas à droite le bloc <b>Informations sur la famille</b> présente les événements enregistrés sur cette famille, tels que mariage, contrats, leurs sources, ainsi que les notes, objets multimédias, etc...<br /><br />La présentation des membres de la famille est la même que les diagrammes d'ascendance ou de descendance, chaque individu étant présenté dans une case, où figurent les détails le concernant.<br /><br />À la droite des parents, une flèche apparaît si la génération supérieure existe dans la base. Quand vous cliquez sur cette flèche, vous faites apparaître une nouvelle famille dont l'époux et l'épouse sont les parents précédents.<br /><br /> Sur la droite des cases, vous avez une loupe qui vous permet de mieux voir le contenu de celle-ci. De même, un menu vous permet d'aller sur les pages de diagramme ou d'autre détails. Certains de ces menus disposent de sous-menus qui apparaissent lorsque votre pointeur passe sur les lignes du menu principal.  Dans les différentes cases, quand vous cliquez sur le nom d'une personne, vous êtes dirigés vers la page <b>#pgv_lang[indi_info]#</b> la concernant.<br /><br /> Dans le cadre <b>Informations sur la famille</b>, en cliquant<br /> - sur un lieu, vous êtes dirigé vers la liste des lieux,  où tous les familles et individus reliés à ce lieu sont affichés.<br /> - sur une date, vous êtes dirigés vers le calendrier, où tous les événements arrivés ce jour ou ce mois sont affichés.<br /> - sur un objet multimédia, vous ouvrez une fenêtre vous présentant celui-ci.<br /> - sur une source, vous ouvrez la page source où celle-ci vous est présentée en détail.<br /><br /> Si vous en avez les autorisations, en bas de page, apparaît le lien <b>Ajouter un enfant à cette famille</b>. Apparaît aussi les liens d'édition de création et/ou modification dans les différentes parties du bloc <b>Information sur cette famille</b>. <br /><br />Comme sur la page <b>#pgv_lang[indi_info]#</b>, vous avez en haut à droite un menu, dont les entrées vous permettent différentes taches ou vous proposent d'autres informations concernant cette famille.<br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]             = "~Ajouter un enfant à cette famille~<br /><br />Ce lien vous permet d'ajouter un enfant à cette famille.<br /><br />Ajouter un enfant est simple : cliquez sur le lien, remplissez les champs proposés par le formulaire, sauvegardez, c'est tout. Vos modifications seront définitives après validation par un administrateur de la base.<br /><br />";
$pgv_lang["show_fam_gedcom_help"]       = "~Voir les balises GEDCOM~<br /><br />Ce lien vous permet d'afficher l'information sur la famille, telle qu'elle est enregistrée dans le fichier GEDCOM.<br /><br />";
$pgv_lang["add_fam_clip_help"]          = "Ajout famille au panier~<br /><br />Vous pouvez ajouter tout ou partie de cette information familiale à votre #pgv_lang[clip_cart]#. À la prochaine étape vous pourrez choisir avec précision combien d'informations vous souhaitez ajouter :<ol><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ol><br />";
$pgv_lang["show_fam_timeline_help"]     = "~Montrer les couples sur le diagramme d'échelle de temps~<br /><br />Quand vous cliquez sur ce lien, vous passez au diagramme échelle de temps, où tous les événements du couple sont affichés sur une échelle de temps chronologique.<br /><br />";
//-- Source list-page
$pgv_lang["help_sourcelist.php"]        = "~Liste des sources~<br /><br />Cette page affiche la liste des sources figurant dans la base.<br /><br />À la différence des pages «Liste des individus» et «Liste des familles», il n'y a pas d'index alphabétique.<br /><br />Une source peut être un archivage public, privé, une institution, une adresse Internet, etc... À cause de cette diversité, il n'est pas possible de décider d'un ordre de tri qui soit significatif pour l'ensemble des cas. Néanmoins, PhpGedView tri les sources sur le champ <u>»Titre»</u> de l'enregistrement «Source».<br /><br /><b>SOURCES</b><br />Une source peut être liée à plusieurs individus et/ou plusieurs événements (par ex., un contrat de mariage, avec les mariés, les parents présents ou cités, les témoins, constitue une source possible pour l'ensemble de ces individus). <br />De même un individu peut être lié à plusieurs sources pour chaque événement.<br /><br />";
$pgv_lang["sourcelist_listbox_help"]    = "~Case de la liste des sources~<br /><br />Dans cette case vous visualisez le nom des sources telles qu'elles sont enregistrées dans le GEDCOM.<br /><br />Les noms sont classés par ordre alphabétique.  Si vous cliquez sur l'un des nom dans la liste, vous irez sur la page de la source où elle sera affichée en détail. Cette liste vous indique quels individus sont liés à cette source.<br /><br />";
//-- Sources-page
$pgv_lang["help_source.php"]            = "~Détails d'une source~<br /><br />Cette page présente le détail d'une source. Les sources sont principales en Généalogie, et permettent d'authentifier dans la mesure du possible  l'information qu'elles renseignent pour les autres généalogistes.<br /><br />Figurent les information «Titre», «Abréviation», «Auteur», «Publication», «Dépositaire» où la source est conservée. En fonction des différents types de source, les informations ne sont pas toujours les mêmes.<br /><br />Si un média, tel qu'une image, existe pour cette source, vous pouvez la voir en cliquant sur son nom ou sur la miniature.<br /><br />Au bas de la page figurent les individus et les familles reliées à cette sources. Cela vous permet d'identifier l'ensemble des informations obtenues ou validées à partir de cette source.<br /><br />Si l'administrateur l'a prévu, vous avez sur la page une ou deux icones supplémentaires :<ol><li><b>#pgv_lang[view_gedcom]#</b><br /> qui visualise l'enregistrement GEDCOM de cette source.</li><br /><li><b>#pgv_lang[add_to_cart]#</b><br /> qui vous permet de stocker cette information dans votre panier pour pouvoir la télécharger plus tard et l'importer dans votre logiciel de généalogie.</li></ol><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["sources_listbox_help"]       = "~Autres enregistrements liés à cette source~<br /><br />Liste des individus et des familles qui sont liés à cette source.<br /><br />Les noms sont listés dans l'ordre alphabétique. En cliquant sur un nom, vous êtes dirigés sur la page de l'individu ou de la famille correspondant.<br /><br />";
$pgv_lang["show_source_gedcom_help"]    = "~Voir l'enregistrement gedcom~<br /><br />Ce lien vous permet de visualiser l'enregistrement du fichier GEDCOM correspondant à cette source.<br /><br />";
$pgv_lang["add_source_clip_help"]       = "~Ajouter au panier~<br /><br />En cliquant sur ce lien vous ajoutez l'enregistrement de cette source à votre panier,  pour pouvoir le télécharger et l'importer plus tard dans votre programme de généalogie.<br /><br />";
$pgv_lang["delete_source_help"]         = "~Supprimer cette source du fichier GEDCOM~<br /><br />Quand vous cliquez sur cette option, vous marquez cette source «à supprimer» de la base.<br /><br />Qu'est que cela signifie ?<br />Supposons que vous ayez une bonne raison pour vouloir supprimer cette source. En cliquant sur le lien, vous aurez une demande de confirmation de votre suppresssion. En continuant, vous aurez confirmation (après quelques instants) de la suppression.<br /><br />En naviguant sur le site, vous pourrez voir que la suppression n'est pas effective et que la source est toujours utilisable.<br /><br /><b>Ce n'est <u>pas</u> une erreur.</b> Comme toute modification demandée dans la base, celle-ci doit être validée par un administrateur, qui peut accepter ou refuser la modification. <br />C'est seulement après cette validation que la modification sera définitive, irréversible et effective pour l'ensemble des utilisateurs. Si il y a un doute sur votre demande, un administrateur prendra contact avec vous.<br /><br />";
//-- Persons per Place-page
$pgv_lang["help_placelist.php"]         = "~Hierarchie des lieux~<br /><br />Cette page vous liste les lieux connus dans la base, par niveau de lieux, et auquels les individus et les familles sont liés.<br /><br />La liste des individus et des familles liées à un lieu sont présentés en deux colonnes, les individus et les familles.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]      = "~Ordre des lieux~<br /><br /><b>ORDRE PAR DEFAUT</b><br />Ceci signifie qu'il n'y a pas de déclaration de hiérarchie des lieux dans le fichier GEDCOM de cette base. L'ordre employé est donc l'ordre par défaut. <br /><br />Si un format avait été déclaré dans le fichier GEDCOM, il aurait été présenté ici et utilisé.<br /><br />";
$pgv_lang["ppp_match_one_help"]         = "~Ordre des lieux~<br /><br />ORDRE DU GEDCOM<br />La hiérarchie des lieux est celle qui a été déclarée dans le fichier GEDCOM. Cette déclaration remplace l'ordre par défaut.<br /><br />";
$pgv_lang["ppp_numfound_help"]          = "~Liens trouvés entre lieux~<br /><br />Le nombre de liens trouvés est affiché ici. Si vous trouvez encore une liste avec des lieux sans liens, vous n'avez pas atteint le niveau le plus bas.<br /><br />Vous pouvez choisir de regarder tous les enregistrements liés à ce lieu ou vous pouvez affiner votre recherche en cliquant sur un autre lieu.<br /><br />";
$pgv_lang["ppp_levels_help"]            = "~Hierarchie des lieux~<br /><br />Dans un fichier GEDCOM, les lieux sont organisés de façon hiérarchique, du plus haut (en général le Pays) au plus bas (en général le lieux-dit, la rue...), chaque niveau étant composé des lieux du niveau inférieur. Vous voyez là le niveau dans les lieux auquel vous vous situez. La <b>Liste des lieux</b> ci-dessous correspond à tous les lieux contenus dans ce niveau  (le plus à gauche).<br /><br />EXEMPLE :<br />La hiérarchie par défaut (qui n'est peut être pas celle du fichier actuel) est #pgv_lang[default_form]#.<br />Si le niveau actuel est «sommaire», la liste présentera tous les Pays connus dans la base. <br />Si le niveau actuel est un département, la <b>Liste des lieux</b> présentera tous les lieux connus dans la base appartenant à ce département.<br />etc.<br /><br />En cliquant sur un lieu, vous afficherez tous les lieux en dépendant, descendant ainsi d'un niveau dans la hiérarchie des lieux.<br /><br />";
$pgv_lang["ppp_placelist_help"]         = "~Liste des lieux par niveau~<br /><br />Cette liste vous présente tous les lieux contenus dans le niveau géographique que vous avez sélectionné et qui sont connus dans la base. Si vous n'avez pas sélectionné de niveau, c'est le niveau géographique le plus élevé qui est listé (c.a.d. les Pays).<br /><br />En cliquant sur un lieu, vous listerez tous les lieux connus y appartenant.<br /><br />";
$pgv_lang["ppp_placelist_help2"]        = "~Liste des lieux~<br /><br />Dans cette liste vous pouvez voir les lieux qui ont été trouvés à ce stade de la recherche.<br /><br />Les noms des lieux qui apparaissent dans cette liste sont cliquables ; cliquer sur un lieu fonctionne comme un filtre, vous serez amené au niveau inférieur.<br /><br /> Seulement quand vous êtes au niveau supérieur, la liste des noms d'invididus ou de familles n'est pas affichée. À tous les niveaux inférieurs de recherche vous obtiendrez la liste des familles et des individus liés à ce lieu.<br /><br />";
$pgv_lang["ppp_view_records_help"]      = "~Voir tous les enregistrements~<br /><br />Cliquer sur ce lien vous affichera une liste complète des individus et des familles qui ont un événement lié à ce lieu. Quand vous arrivez au niveau de la ville ou du village, l'élement «racine» d'un lieu, la liste des noms sera affichée automatiquement.<br /><br />";
$pgv_lang["ppp_name_list_help"]         = "~Liste des noms~<br /><br />Cette case affiche une liste complète des individus et des familles liés à ce lieu.<br /><br />Les noms dans cette liste sont cliquables. Quand vous cliquez sur un nom, vous obtiendrez la page de détails correspondant à ce nom. Quand vous cliquez sur un lieu en haut de cette liste, vous modifiez le lieu sélectionné.<br /><br />";
//-- Multimedia-page
$pgv_lang["help_medialist.php"]         = "~Liste des objets multimédia~<br /><br />Cette page présente la liste des objets Multimédia contenus dans cette base.<br /><br />Pour chacun, vous pouvez voir le titre ou le nom de fichier, les noms des individus et/ou des familles qui y sont raccordés,  ainsi que les notes le concernant.<br /><br />En cliquant sur le titre ou sur la miniature, vous ouvrez le média dans le visualisateur de PhpGedView ou dans celui spécifié dans votre configuration navigateur.<br /><br />Quand vous cliquez sur le lien individu ou famille, vous ouvrez la page correspondante.<br /><br />";
//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]       = "~Chargement des fichiers multimédia~<br /><br />Charger les fichiers média est simple. Voici ce qu'il faut savoir :<br /><br /><b>Miniatures</b><br />Les miniatures doivent avoir une largeur d'environ 100 px. La miniature <u>doit</u> avoir exactement le même nom (casse, c.a.d. minuscules/majuscules comprise) que le média principal. Si votre système peut générer les miniatures automatiquement, une information est affichée sur la page de chargement.<br /><br /><b>Chargement</b><br />Les fichiers sont chargés automatiquement dans le répertoire  ../media pour le média principal, et dans  ../media/thumbs/ pour les miniatures.<br /><br />#pgv_lang[readme_help]#";
//-- Anniversaries-page
$pgv_lang["help_calendar.php"]          = "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>Informations générales</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Evènement</b></a></li><li><a href=\"#calendar_button\"><b>Boutons Vue par jour / Vue mensuelle / Vue annuelle</b></a></li><li><a href=\"#calendar_tip\"><b>Tip</b></a></li></ul><br /><a name=\"calendar_general\"></a>Le #pgv_lang[anniversary_calendar]# montre les individus et les familles qui sont liées à un événement à un certain jour ou mois ou pendant une période donnée. Un système avancé de filtrage sélectionne pour vous la bonne date, la bonne période et les événements.<dl><dt><b>Vue <a href=\"#calendar_day\">Jour</a></b></dt><dd>Ceci affiche les événements pour un certain jour, indépendamment de l'année sélectionnée. Le résultat sera une liste simple mentionnant le nom des individus ou des familles, ou une liste sur deux colonnes avec les individus d'un côté et les familles de l'autre.</dd><dt><b>Vue <a href=\"#calendar_month\">Mensuelle</a></b></dt><dd>Dans ce calendrier, les noms d'individus et de familles sont affichés par jour. Le calendrier est affich avec l'année sélectionnée dans la case année. Tous les événements qui se sont produits dans le passé jusqu'à cette année sont affichés.<br /><br />En combinaison avec cette option <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, vous obtiendrez une vue réaliste du calendrier de vos ascendants.</dd><dt><b>Vue <a href=\"#calendar_year\">Annuelle</a></b></dt><dd>Cette vue affiche les événements survenus pour une année donnée ou pour un nombre d'années donné. Le résultat affiché sera une liste des noms des individus ou des familles, ou une liste sur deux colonnes avec les individus d'un côté et les familles de l'autre.</dd></dl>Le jour et le mois en cours sont mis en surbrillance dans le calendrier.<br /><br />Tous les noms et les dates sont cliquables. Quand vous cliquez sur un nom, vous obtiendrez la page de détails correspondante. En cliquant sur une date, vous passerez en mode «Aujourd'hui» ou «Année», ce qui affichera tous les événements pour le jour ou le mois correspondant à la date sélectionnée.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]  = "~Sélection du jour~<br /><br />Le niveau le plus fin de la sélection de date est le <b>jour</b>. Sa fonction est évidente, vous sélectionnez un <b>jour</b> du mois. <br /><br />En cliquant sur un jour, vous passez (ou vous restez) en mode jour,  et compte tenu du mois sélectionné, vous affichez tous les événements qui figurent à ce jour et ce mois dans la base (par ex. tous les événements qui se sont passés un 17 juin). En cliquant sur un mois différent, vous affichez tous les événements du même jour mais de ce mois. <br /><br />À la droite de la liste des jours, vous pouvez voir un <b>lien</b> avec la date du jour. En cliquant sur ce <b>lien</b> vous affichez la liste de ce jour.";
$pgv_lang["annivers_month_select_help"] = "~Sélection du mois~<br /><br />En cliquant sur un mois de la liste, le résultat dépend selon que vous êtes en mode <b>jour</b> ou en mode <b>mois</b> :<br /><dl><dt><b>Mode jour</b></dt><dd>Dans ce mode, les événements qui se sont passés le jour et le mois sélectionné sont affichés (vous passez par exemple des événements passés un 17 juin à ceux passés un 17 mars, en cliquant sur mars, si vous étiez en juin précedement);</dd><br /><dt><b>Mode mois</b></dt><dd>Le calendrier du mois figurant à l'écran est remplacé par celui du mois sélectionné.<br /><br />À la fin de la liste des mois, figure un <b>lien</b> avec le mois en-cours. En cliquant sur ce lien, vous affichez le calendrier du mois, (donc en mode mois) quel que soit le mode dans lequel vous êtes.</dd></dl>";
$pgv_lang["annivers_year_select_help"]  = "~Saisie année~<br /><br />Cette case vous permet de changer l'année du calendrier.<br /><br /><b>Modes de saisie des années :</b> pour <b>#pgv_lang[viewyear]#<dl><dt>Série des années :</b></dt><dd>Vous pouvez chercher des dates sur une période recouvrant plusieurs années.<br /><br />Les dates sont inclusives, c'est à dire que la sélection part du 1er janvier de la première année jusqu'au 31 décembre de la dernière année. Par exemple :<br /><br /><b>1992-5</b> pour tous les événements de1992 à 1995.<br /><b>1972-89</b>  tous les événements de 1972 à 1989.<br /><b>1610-759</b> tous les événements de 1610 à 1759.<br /><b>1880-1905</b> tous les événements de 1880 à 1905.<br /><b>880-1105</b> tous les événements de 880 à 1105.<br /><br />Vous pouvez omettre le dernier chiffre d'une année afin de sélectionner la décade concernée :<br /><br /><b>197</b> pour tous les événements de 1970 à 1979.<br /><b>195-198</b> pour tous les événements de 1950 à 1989.</dd><dt><br /><b>Dates approximatives :</b></dt><dd>Quelquefois, la date précise d'un événement n'est pas connue. Les termes « avant », « après », « environ » caractérisent ce type de date.<br /><br />De telles dates sont stockées dans la base avec les abréviations anglaises de ces termes. En mode <b>année</b>, vous pouvez utiliser ces termes. Voici quelques exemples :<br /><br /><b>abt</b> 1800 ( <b>abt</b>= about = environ )<br /><b>bet</b> 1950-1959 ( <b>bet</b> = between=entre ) entrez : bet 1950-59 ou juste : 1950-59<br /><b>bef</b> 1950 ( <b>bef</b> = before=avant )<br /><b>aft</b> 1900 ( <b>aft</b> = after=après )<br /><br /><b>Note :</b> PhpGedView cherchera exactement les termes de votre demande. Quand vous demandez <b>abt&nbsp;1850</b>, une date figurant dans la base comme <b>abt&nbsp;oct&nbsp;1850</b> ne sera  <u>pas</u> sélectionnée.<br /><br />Vous pouvez entrer seulement une abréviation, afin de chercher toutes les dates concernées. </dd></dl>L'écran n'est pas rafraîchi lors de la saisie d'une date, vous devez cliquer sur <b>#pgv_lang[viewmonth]#</b> ou <b>#pgv_lang[viewyear]#</b> afin d'afficher la nouvelle sélection.<br /><br />";
$pgv_lang["annivers_show_help"]         = "~Montrer les événements de ...~<br />Les options suivantes sont disponibles :<br /><ol><li><b>Toutes les personnes</b><br />Avec cette option, tous les individus et toutes les familles figurant dans la base sont affichés.</li><br /><li><b>Evènements récents (-de 100 ans)</b><br />Les événement vieux de plus de 100 ans ne seront pas affichés.</li><br /><li><b>Personnes vivantes seulement</b><br />Sauf si l'administrateur a autorisé à ce que les personnes vivantes soient visibles de tous, vous ne pouvez sélectionner cette option sans être connecté.<br /><br />Avec cette option, seules les personnes vivantes seront sélectionnées.</li></ol>Quand vous cliquez, les événements correspondants à votre sélection sont affichés.<br /><br />Les sélections du jour, du mois et de l'année restent inchangés.<br /><br />";
$pgv_lang["annivers_sex_help"]          = "~Sélecteur de sexe~<br />Quand vous êtes connecté ou lorsque l'administrateur n'a pas désactivé l'option de protection des informations privées, vous pouvez sélectionner l'une de ces options :<ol><li><b>Tous</b> icon<br />C'est la valeur par défaut. Les événements de tous les individus et de toutes les familles sont affichés.</li><li><b>Masculin</b> icon<br />Seuls les événements des individus masculins sont affichés. Seuls les membres masculins des familles sont affichés avec les événements de cette famille.</li><li><b>Féminin</b> icon<br />Seuls les événements des individus féminins sont affichés. Seuls les membres féminins des familles sont affichés avec les événements de cette famille.</li></ol>Quand vous cliquez sur une option, les événements sélectionnés sont affichés.<br /><br />La configuration du jour, du mois et de l'année, tels que les modes <b>Jour</b> ou <b>Mensuelle</b>, demeure inchangée.<br /><br />";
$pgv_lang["annivers_event_help"]        = "~Sélecteur d'événement~<br />Ici vous choisissez d'afficher tous les événements pour les individus ou les familles affichées ou juste une sélection d'événements. Vous ne pouvez pas sélectionner plus d'une catégorie d'événements.<br /><br />Quand vous cliquez sur une option, les événements sélectionnés sont affichés.<br /><br />La configuration du jour, du mois et de l'année, tels que les modes <b>Jour</b> ou <b>Mensuelle</b>, demeure inchangée.<br /><br />";
$pgv_lang["annivers_tip_help"]          = "~Tip~<br />Ajustez le sélecteur de date sur n'importe quelle date dans le passé.<br /><br />Quand vous cliquez sur l'un des boutons de vue, vous pourrez afficher une liste ou un calendrier pour cette date.  Tous les âges, anniversaires, etc... ont été recaculés à partir de la date déterminée dans le sélecteur de date. Vous pouvez maintenant voir le calendrier ou une liste que vos ancêtres auraient pu voir il y a des années.<br /><br />";
$pgv_lang["day_month_help"]             = "~Boutons vue jour / vue mensuelle / vue annuelle~<br /><ul><li>Le bouton <b>Vue jour</b> montrera les événements de la date choisie dans une liste. Toutes les années sont balayées, ainsi seuls le jour et le mois sont indiqués ici. Changer l'année n'aura aucun effet.  Vous pouvez réduire la liste en choisissant l'option <b>Années récentes</b> ou <b>Individus vivants</b>.<br /><br />L'âge dans la liste sera calculé depuis l'année en cours.</li><li>Le bouton <b>Vue mensuelle</b> affiche un calendrier du mois et de l'année choisis. Ici vous pouvez réduire la liste en choisissant l'option <b>années récentes</b> ou <b>Individus vivants</b>.<br /><br />Vous obtiendrez une impression réaliste du calendrier que vos ancêtres pouvaient regarder chaque matin affiché sur le mur de la cuisine en choisissant une année dans le passé et en la combinant avec <b>Années récentes</b>. Tous les âges sur le calendrier sont affichés en fonction de l'année affichée dans le sélecteur d'année.</li><li>Le bouton <b>Vue annuelle</b> affichera une liste des événements survenus dans l'année sélectionnée.  Ici vous pouvez réduire la liste en choisissant l'option <b>Années récentes</b> ou <b>Individus vivants</b>.<br /><br />Vous pouvez afficher des événements pour une période d'années donnée.  Indiquez simplement l'année de début et l'année de fin de cette période, avec un trait d'union <b>-</b> entre les deux années.  Exemple :<br /><b>1992-4</b> pour afficher tous les événements survenus entre 1992 et 1994<br /><b>1976-1984</b> pour afficher tous les événements survenus entre 1976 et 1984<br /><br />Vous pouvez entrer les premiers chiffres de l'année pour sélectionner tous les événements qui se sont déroulés pendant les années commençant par ces chiffres. Par exemple, <b>197</b> pour tous les événements survenus entre 1970 et 1979.</li></ul>Quand vous voulez <b>modifier l'année</b> vous <b>devez</b> cliquer sur l'un de ces trois boutons.  Tous les autres réglages demeurent inchangés.<br /><br />";
//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]         = "~#pgv_lang[clippings_cart]#~<br />Cette fonction vous permet d'extraire certaines parties de l'arbre sous la forme d'un fichier au format GEDCOM, compatible avec d'autres logiciels de généalogie.<dl><dt>Comment choisir les parties à extraire ?</dt><dd>C'est très simple : sur la page détaillée d'un INDIvidu, d'une FAMille ou d'une SOURce, cliquer sur le bouton <b>#pgv_lang[add_to_cart]#</b></dd><dt>Comment enregistrer le panier ?</dt><dd>Pour récupérer le contenu de votre panier, ouvrir le menu <b>#pgv_lang[clippings_cart]#</b>, puis cliquer sur <b>#pgv_lang[download_now]#</b>.</dd></dl>";
$pgv_lang["clip_download_help"]         = "~#pgv_lang[download_now]#~<br /><br />By clicking this link, you will be forwarded to the next page.<br />If there are more option what to download, they will be displayed on that page.<br />Simply follow the instructions.";
$pgv_lang["empty_cart_help"]            = "~#pgv_lang[empty_cart]#~<br /><br />By clicking this link, your Clipping Cart will be totally emptied.<br /><br />If you don't want to remove all persons, families, etc. from the Clipping Cart, you can remove item by item by clicking the «Remove» link in the name boxes. ";
$pgv_lang["add_by_id_help"]             = "~Ajouter au panier par id~<br /><br />Cette case de saisie vous permet de saisir l'ID d'un individu pour l'ajouter au panier.  Une fois ajouté, vous avez la possibilité de lier les relations de cet individu à votre panier.<br /><br />Si vous ne connaissez pas l'ID de l'individu, vous pouvez effectuer une recherche par nom en cliquant sur l'icône de l'individu situé après le bouton Ajouter.<br /><br />";
$pgv_lang["zip_help"]                   = "~Contenu du panier au format zip~<br /><br />Sélectionnez cette option pour sauvegarder le contenu de votre panier dans un format compressé (fichier ZIP).  Pour plus d'informations sur le format ZIP, vous pouvez visiter <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.<br /><br />";
$pgv_lang["include_media_help"]         = "~Inclure des médias~<br /><br />Choisissez cette option pour inclure les fichiers média liés aux enregistrements d'invidus sélectionnés dans votre panier. En choisissant cette option, les fichiers média seront automatiquement zippés pendant le téléchargement.<br /><br />";
$pgv_lang["clip_cart_help"]             = "~Panier~<br /><br />Cette case montre le contenu de votre panier. Les <i>en-têtes</i> de colonnes indiquent le type de données sélectionnées, qui peuvent être des Individus (INDI), des familles (FAM), des Sources (SOUR), un dépôt d'archives (REPO), une note(NOTE), ou un média (OBJE) ; chacun est représenté par sa propre icône.  La colonne <i>ID</i> affiche le numéro ID pour chaque enregistrement de chaque type d'objets.  La colonne <i>Nom / Description</i> donne soit le nom de famille ou de l'individu ou une description de l'un ou l'autre.  Le bouton de suppression supprimera cet enregistrement du panier. <b>Attention, une confirmation de cette suppression ne vous sera pas demandé.</b><br /><br />";
//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]          = "~Montrer les modifications du gedcom~<br /><br />Quand vous voyez ce message, il peut signifier deux choses :<ol><li>Quelqu'un a réalisé des modifications dans le GEDCOM<br />Des enregistrements peuvent avoir été ajoutés, supprimés ou modifiés.</li><li>Les modifications n'ont pas encore été validées par l'administrateur.<br />Une fois que les modifications sont acceptées ou rejetées, vous ne voyez plus ce message.</li></ol>Vous pouvez voir les modifications qui ont été réalisées en cliquant sur le lien. Si la fiche n'est pas correcte (erreurs de saisie, mauvaises informations), SVP contactez l'administrateur.<br /><br />";
//-- Search-page
$pgv_lang["help_search.php"]            = "~La page de recherche~<br /><br />Bien que cette page soit très simple d'utilisation, nous avons mis à votre disposition un moteur de recherche particulièrement puissant et complexe. La plupart des logiciels de généalogie vous permettent seulement de faire une recherche sur le nom de l'individu. PhpGedView vous permet de rechercher presque n'importe quoi.<br /><br />La case de recherche sur le côté gauche de l'écran est identique à la case de recherche située en en-tête de chaque page du site.<br /><br />Si vous recherchez des individu en relation avec une année donnée, entrez simplement l'année. Le programme trouvera tous les liens pour vous.<br /><br />Vous recherchez un nom ou un lieu ?  Entrez simplement son nom ou le lieu, en entier ou seulement une partie de celui-ci, et PhpGedView fera le reste.<br /><br /><b>Méthode de recherche de Soundex</b><br />Avec la case de recherche du côté droit de l'écran, vous pouvez rechercher des noms d'individus ou de lieux, même si vous n'en connaissez pas l'orthographe précise.<br /><br />Lorsqu'il y a plusieurs bases de données généalogiques sur un même serveur et que l'administrateur a permis la commutation entre elles, votre recherche renverra des résultats pour toutes les bases.<br /><br />Vous trouverez plus d'aide au sujet de ces outils de recherche en cliquant sur <b>?</b> au dessus de chacune des cases.<br /><br />";
$pgv_lang["search_enter_terms_help"]    = "~#pgv_lang[enter_terms]#~<br /><br />Vous pouvez faire une recherche par date, nom, prénom, lieu, etc.<dl><dt>Jokers</dt><dd>Les jokers (comme * ou ?), ne sont pas autorisés, mais le programme en tient compte.<br />Comment ?<br />Supposons que vous avez saisi : «<b>Mar</b>»<br />Le résultat donnera :<br />Jean-<b>Mar</b>c Durand<br /><b>Mar</b>cel Lebrin<br />Paul <b>Mar</b>tin<br />une personne née à <b>Mar</b>seille<br />etc..</dd><dt>Dates</dt><dd>En entrant une date, vous obtiendrez la liste de toutes les personnes liées à cette date.<br /><B>1950</B>, par exemple, vous donnera la liste des personnes, nées en 1950, ou mariées, ou décédées, ou....tout autre événement de 1950.<br /><br />Avec <b>4 Dec</b>, toutes les personnes en rapport avec le 4 décembre de n'importe quelle année.<br />Mais aussi les événements du 14 et du 24 décembre.<br />Encore une fois, les jokers ne sont pas nécessaires.</dd><dt>Dates exactes</dt><dd>Attention, le programme cherche les dates au format interne GEDCOM.<br />Ainsi, pour faire une recherche concernant le 14 décembre, il faut taper : <b>14 dec</b>.<br />Saisir <b>dec 14</b>, vous afficherait les événements du 6 <b>dec</b>embre 19<b>14</b></dd></dl>.";
$pgv_lang["search_replace_help"]        = "~#pgv_lang[search_replace]#~<br /><br />Ici vous pouvez rechercher une faute d'orthographe ou toute autre information imprécise et la remplacer avec l'information correcte.<br /><br /><b>Rechercher</b><br />Cet outil effectue la recherche juste comme une <a href=\"help_text.php?help=search_enter_terms_help\">recherche normale</a>.<br /><br /><b>Remplacer</b><br />Tous les termes trouvés à partir de la recherche sont remplacés par le terme de remplacement dans la base de données.<br /><br /><b>Par exemple...</b><br />Supposez que vous ayez mal épelé le nom de votre grand-père Michael. Vous avez accidentellement écrit «Micheal»<br /><br />Vous entrerez <b>Micheal</b> dans la case de recherche, et <b>Michael</b> dans la case de remplacement.<br />Toutes les occurences de «Micheal» seront remplacées par «Michael»<br /><br /><b>Recherche de...</b><br />Choisissez l'étendue de votre recherche. Vous pouvez limiter la recherche aux noms ou aux endroits, ou n'appliquer aucune limite (Rechercher tout).  L'option <i>#pgv_lang[search_place_word]#</i> n'éffectuera la recherche que sur le mot entier dans les champs spécifiés par la recherche. Cela signifie qu'en recherchant <i>UT</i> vous n'obtiendrez que <b>UT</b> et non pas <i>UT</i> dans un autre mot comme Connectic<b>ut</b>.<br /><br />Ne soyez pas inquiet si vous remplaciez accidentellement un mot. Cliquez simplement sur le lien «Accepter/Rejeter les modifications» en bas de la page pour valider vos modifications ou les rejeter.<br /><br />Si vous avez besoin d'un complément d'informations sur le système de recherche, faites nous part de vos questions, nous les traiterons et les ajouterons aux rubriques d'aide.<br /><br />";
$pgv_lang["soundex_search_help"]        = "~#pgv_lang[soundex_search]#~<br /><br />Soundex est une méthode de codage des mots selon leur prononciation. Cela permet de rechercher des noms d'individus ou de lieux dans la base de données dont vous ne connaissez pas l'orthographe précise.  PhpGedView supporte deux algorithmes différents, chacun founissant des résultats différents.<ul><li><b>De base</b><br />Cette méthode, brevetée en 1918 par Russel, est très simple et peut-être réalisée à la main.<br /><br />Parce que cette méthode retient la première lettre du nom en tant qu'élement probant de résultat, cette méthode n'est pas très utile quand vous n'êtes pas certain de la première lettre. Cet algorithme de base n'est pas adapté aux langues différentes de l'anglais, et même pour l'anglais, les résultats sont quelquefois surprenants. Par exemple une recherche Soundex de base sur <b>Smith</b> retournera pas seulement <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, tous des variations du nom <b>Smith</b>, mais également <b>Smead, Sneed, Smoote, Sammett, Shand,</b> et <b>Snoddy</b>.<br /><br /></li><li><b>Daitch-Mokotoff</b><br />Cette méthode développée en 1985, est plus complexe que la méthode de base et n'est pas réalisable à la main.<br /><br />Une recherche Soundex utilisant cette méthode produira de meilleurs résultats.</li></ul>Pour plus de détails sur ces deux méthodes Soundex, visitez la page : <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a><br /><br />";
$pgv_lang["search_exclude_tags_help"]   = "~#pgv_lang[search_tagfilter]#~<br /><br />Le choix <b>#pgv_lang[search_tagfon]#</b> conduira la fonction de recherche à ignorer les balises (tags) GEDCOM suivantes :<div style=\"padding-left:30px;\"><b>_PGVU</b> - Dernière modification effectuée par<br /><b>CHAN</b> - Date de la dernière modification<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />En complément de ces balises ignorées éventuellement, la fonction de recherche exclut automatiquement les balises suivantes : <div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div><br /><br />";
$pgv_lang["search_include_ASSO_help"]   = "~#pgv_lang[search_asso_label]#~<br /><br />Cette option conduit PhpGedView à afficher tous les individus qui sont enregistrés comme ayant un lien de parenté avec la personne ou la famille qui a été trouvée en tant que résultat direct de la recherche. L'inverse n'est pas possible.<br /><br />Exemple : Supposons que la personne <b>A</b> est le parrain de la personne <b>B</b>. Le lien de parenté est enregistrée dans l'enregistrement de la personne <b>B</b> en utilisant une balise ASSO. Aucune balise correspondante n'existe dans l'enregistrement de la personne <b>A</b>.<br /><br />Lorsque cette option est paramétrée à <b>#pgv_lang[yes]#</b> et que la liste des les résultats de la recherche contient <b>B</b>, <b>A</b> sera inclus automatiquement à cause de la présence de la balise ASSO dans l'enregistrement GEDCOM de <b>B</b>. Toutefois, si la liste des les résultats de la recherche contient <b>A</b>, <b>B</b> ne sera pas inclus automatiquement puisqu'il n'y a pas de balise ASSO dans l'enregistrement de la personne <b>A</b>.<br /><br />";
//-- Individual Information-page
$pgv_lang["help_individual.php"]        = "~#pgv_lang[indi_info]# PAGE~<br /><br />Tous les détails d'un individu sont affichés sur cette page.<br /><br />S'il existe une image disponible, vous la verrez sur le côté gauche supérieur. Vous verrez le nom de l'individu à côté de l'image.<br /><br />Les noms peuvent être liés à des notes ou des sources. Si un quelconque de ces noms a des notes ou des sources, vous les verrez énumérées sous les noms auxquels elles sont liées.<br /><br />Un individu peut avoir un AKA (un surnom ou un pseudo sous lequel il est connu par ailleurs). Si c'est le cas, il sera affiché.<br /><br />Si vous y êtes autorisé, vous verrez également pour cet individu <b>Editer</b> et <b>Supprimer</b> à côté de l'individu édité.<br /><br />Sur cette page vous voyez des onglets pour <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, et <b>#pgv_lang[relatives]#</b>.  Ces onglets vous permettent d'accéder à toutes les informations concernant cet individu enregistrées dans la base de données.<br /><ul><li>L'onglet <b>#pgv_lang[personal_facts]#</b> affiche tous les événements et détails à propos de l'individu et tous les événements concernant ses mariages. En cliquant sur n'importe quelle date dans ce tableau, vous serez transféré à #pgv_lang[anniversary_calendar]# pour cette date, de sorte que vous puissiez voir d'autres événements qui se produit le même jour. En cliquant sur un des liens, vous serez positionné sur l'arbre généalogique à partir duquel vous pourrez visualiser d'autres individus qui ont ajouté des événements au même endroit. Pour les mariages et les autres événements familiaux, le nom du conjoint de l'individu est affiché de sorte que vous puissiez visualiser le conjoint ainsi que sa famille grâce aux liens existants.</li><li>L'onglet <b>#pgv_lang[notes]#</b> affiche toutes les notes générales relatives à cet individu.</li><li>L'onglet <b>#pgv_lang[ssourcess]#</b> affiche toutes les sources <u>générales</u> pour cet individu. Ces sources <u>ne sont pas</u> liées aux événements de l'individu, ni même aux noms de l'individu : elles sont associées à l'individu lui-même (ID).  En cliquant sur le titre de la source, vous obtiendrez des informations plus détaillées sur celle-ci ainsi que la liste des autres individus rattachés à cette source.</li><li>L'onglet <b>#pgv_lang[media]#</b> affiche l'ensemble des images ainsi que les autres média rattachés à cet individu. En cliquant sur la vignette de l'image, une vue plus grande de l'image sera affichée. En cliquant sur la légende de l'image, l'image sera affichée sur la page #pgv_lang[media_list]#.</li><li>L'onglet <b>#pgv_lang[relatives]#</b> liste les parents, les frères et sœurs et les enfants de l'individu ainsi que les conjoints de l'individu et les enfants qu'il a eu avec ces conjoints. Ces individus sont listés dans une case similaire aux diagrammes que vous avez déjà vues.</li></ul>Du côté droit de l'écran vous trouverez une case avec des liens.  Plusieurs des liens dans la case sont identiques aux liens dans le menu. Par exemple, en cliquant sur le lien <b>#pgv_lang[pedigree_chart]#</b> situé du côté des liens vous affichera l'arbre des ascendants de cet individu. La différence avec les liens du menu tient au fait qu'en utilisant le menu, <b>#pgv_lang[pedigree_chart]#</b>, vous afficherez le diagramme par défaut des ascendants pour cette base de données.<br /><br />Un des liens qui pourrait apparaître dans cette liste, s'il a été activé par l'administrateur, est le lien <b>#pgv_lang[view_gedcom]#</b>. Ce lien affiche l'enregistrement GEDCOM de cet individu.<br /><br />Si le #pgv_lang[clip_cart]# a été activé par l'administrateur, vous aurez la possibilité d'ajouter cet individu à votre #pgv_lang[clip_cart]#.<br /><br />Le lien <b>#pgv_lang[relationship_to_me]#</b> n'apparaît que si vous êtes connecté et votre identifiant de connexion est lié à votre ID dans le GEDCOM. Ce lien affiche automatiquement votre arbre généalogique et vous montre de quelle manière vous êtes lié ou non à l'individu dont vous consultez la fiche.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_person_help"]         = "~Supprimer un individu du GEDCOM~<br /><br />Quand vous sélectionnez cette option, vous marquez cet individu afin qu'il soit supprimé de la base de données.<br /><br />Qu'est-ce que cela signifie ?<br />Supposons que vous ayez une bonne raison de supprimer cet individu depuis la base de données. Vous cliquez sur ce lien. Vous serez invité à confirmer votre demande de suppression. Si vous décidez de poursuivre, cela prendra quelques instants avant qu'un message vous confirmant la suppression de l'individu s'affichera.<br /><br />Quand vous poursuivrez votre consultation du site, vous noterez que l'individu est encore visible et peut être utilisé comme si la suppression n'avait pas été confirmée.<br /><br /><b>Ce <u>n'est pas</u> une erreur.</b>  L'administrateur du site recevra un message comme quoi la base de données à été modifiée et l'individu a été supprimé.<br />L'administrateur peut refuser ou accepter cette suppression avant que celle-ci ne soit réellement définitive et irréversible. S'il y a le moindre doute à propos de cette suppression, l'administrateur vous contactera pour confirmation.<br /><br />";
$pgv_lang["delete_name_help"]           = "~Éditer ou supprimer un nom du GEDCOM~<br /><br /><b>ÉDITER UN NOM</b><br />Quand vous cliquez sur ce lien, une nouvelle fenêtre s'ouvre. Dans cette fenêtre, vous pouvez éditer le nom de l'individu. Saisissez uniquement les modifications dans les zones souhaitées et cliquez sur le bouton de fermeture de la fenêtre ; c'est tout.<br /><br /><b>SUPPRIMER UN NOM</b><br />En cliquant sur cette option, vous indiquerez que ce nom doit être supprimé de la base de données.  Notez que supprimer le nom est totalement différent de l'opération qui consiste à supprimer l'individu. Supprimer le nom supprime uniquement le nom de l'individu et non l'individu lui-même. Si c'est le pseudo ou le surnom (AKA) que vous souhaitez supprimer, l'individu conservera ses autres noms.  Si c'est <u>uniquement</u> le nom que vous voulez supprimer, l'individu ne sera pas supprimé, mais sera enregistré comme un individu anonyme (No Name - NN), <b>#pgv_lang[NN]#</b>.  L'individu conservera ses liens avec ses parents, les sources, les notes, etc.<br /><br />Comment cela fonctionne-t'il ?<br />Vous serez invité à confirmer votre demande de suppression. Si vous décidez de continuer, l'opération peut prendre quelques instants avant que vous soyez informé par un message que l'opération a été complétée avec succès.<br /><br />Quand vous reprendrez votre visite, vous noterez que le nom est toujours visible et peut être utilisé comme si la suppression n'avait pas été validée.<br /><br /><b>Ce <u>n'est pas</u> une erreur.</b>  L'administrateur du site recevra un message qu'une modification a été réalisée dans la base de données et que vous avez supprimé ce nom.<br />L'administrateur peut alors refuser ou accépter vos modifications. Le nom sera vraiment supprimé seulement après que l'administrateur ait accépté vos modifications, cette décision étant <u>irréversible</u>. S'il y a le moindre doute à propos de vos modifications, l'administrateur prendra contact avec vous pour confirmation.<br /><br />";
$pgv_lang["add_name_help"]              = "~Ajouter un nouveau nom~<br /><br />Ce lien vous permet d'ajouter un autre nom à cet individu.  Quelquefois certains individus sont connus sous leur nom et un alias (surnom).  Ce lien vous permet d'ajouter de nouveaux noms sans changer l'ancien nom.<br /><br />";
$pgv_lang["add_sibling_help"]           = "~#pgv_lang[add_sibling]#~<br /><br />Vous pouvez ajouter un enfant à cette famille quand vous cliquez sur ce lien.  «Famille proche», dans ce cas regroupe le père et la mère de l'individu.<br /><br />Conservez à l'esprit que vous allez ajouter un enfant aux mêmes parents que l'individu sélectionné. Ajouter un frère ou une sœur est très simple : un simple clic sur le lien, compléter le formulaire dans la fenêtre pop-up et c'est tout.<br /><br />Si vous devez ajouter un fils ou une fille à l'individu principal, faites défiler vers le bas le diagramme et cliquez sur le lien «Ajouter un frère ou une sœur» ou «#pgv_lang[as_spouse]#».<br /><br />";
$pgv_lang["add_son_daughter_help"]      = "~#pgv_lang[add_son_daughter]#~<br /><br />Vous pouvez ajouter un enfant à cette famille quand vous cliquez sur ce lien.  «Famille proche», dans ce cas, est l'individu principal de cet écran ainsi que son conjoint.<br /><br />Conservez à l'esprit que vous allez ajouter un fils ou une fille à cet individu.  Ajouter un fils ou une fille est très simple : cliquez tout simplement sur le lien, et remplissez le formulaire dans la fenêtre pop-up qui s'affiche ; c'est tout.<br /><br />Si vous devez ajouter un frère ou une sœur à l'individu principal, faites défiler l'écran jusqu'au lien suivant et cliquez «#pgv_lang[as_child]#».<br /><br />";
$pgv_lang["link_child_help"]            = "~#pgv_lang[link_as_child]#~<br /><br />Vous pouvez lier cet individu comme enfant à une famille déjà créée quand vous cliquez sur ce lien.<br /><br />Supposez qu'au moment de l'enregistrement de l'invidu, les parents de cet individu semblent inconnus, et que vous découvriez plus tard que les parents étaient déjà enregistrés dans la base.<br /><br />Cliquez simplement sur le lien, entrez l'ID de la famille, et la tâche est complète. Si vous ne connaissez pas l'ID de la famille, vous pouvez le rechercher.<br /><br />";
$pgv_lang["link_husband_help"]          = "~#pgv_lang[link_as_husband]#~<br /><br />Cette option vous permettra de lier l'individu courant en tant que mari à une famille qui est déjà enregistrée dans la base de données. En cliquant sur ce lien vous pouvez ajouter cet individu à une famille existante, pour laquelle le mari était inconnu jusqu'alors. Cet individu remplacera le mari inconnu jusqu'ici. Toutes les informations comme le mariage ou les enfants conserveront leurs liens avec cette famille.<br /><br />En cliquant simplement sur ce lien, entrez l'ID de la famille, et vous aurez compléter la tache. C'est une option d'édition avancée qui devrait seulement être employée si la famille que vous liez existe déjà. Si vous souhaitez ajouter une <u>nouvelle/u> famille à cet individu, utilisez le lien <b>#pgv_lang[add_new_wife]#</b>.<br /><br />";
$pgv_lang["add_husband_help"]           = "~#pgv_lang[add_new_husb]#~<br /><br />En cliquant sur ce lien, vous pouvez ajouter un <u>nouvel</u> individu masculin et lier cet individu à l'individu principal en tant que nouveau mari.<br /><br />En cliquant simplement sur le lien, remplissez le formulaire de la fenêtre pop-up qui s'affiche. Complétez autant que champs que vous pouvez et cliquez sur le bouton <b>Sauvegarder</b>.<br /><br />C'est tout.<br /><br />";
$pgv_lang["link_new_husb_help"]         = "~#pgv_lang[link_new_husb]#~<br />Ceci vous permettra de lier un autre individu, qui existe déjà, en tant que nouveau mari à cet individu. Cette opération crééra une nouvelle famille avec le mari que vous avez choisi. Vous aurez également l'option d'indiquer un mariage pour cette nouvelle famille.<br /><br />";
$pgv_lang["link_wife_help"]             = "~#pgv_lang[link_as_wife]#~<br /><br />Cette option vous permettra de lier l'individu courant en tant qu'épouse à une famille qui est déjà présente dans la base de données.<br /><br />C'est une option d'édition avancée qui ne doit être utilisée que si la famille que vous voulez lier à cet individu existe déjà.  Si vous voulez ajouter une <u>nouvelle</u> famille à cet individu, utilisez le lien <b>#pgv_lang[add_new_husb]#</b>.<br /><br />";
$pgv_lang["add_wife_help"]              = "~#pgv_lang[add_new_wife]#~<br /><br />En cliquant sur ce lien, vous pouvez ajouter un <u>nouvel</u> individu féminin et lier cet individu à l'individu principal en tant qu'épouse.<br /><br />Cliquez simplement sur le lien, et vous obtiendrez une fenêtre pop-up pour y ajouter ce nouvel individu. Remplissez le maximum de champs puis cliquez sur le bouton <b>Sauvegarder</b>.<br /><br />C'est tout.<br /><br />";
$pgv_lang["link_new_wife_help"]         = "~#pgv_lang[link_new_wife]#~<br />Ceci vous permettra de lier un autre individu, qui existe déjà, en tant que nouvelle épouse de cet individu.  Ceci crééra une nouvelle famille avec l'épouse que vous avez sélectionnée. Vous aurez également la possibilité d'indiquer un mariage pour cette nouvelle famille.<br /><br />";
$pgv_lang["add_new_parent_help"]        = "#pgv_lang[multiple_help]#<br />~AJOUTER UN NOUVEAU PÈRE ou UNE MÈRE~<br /><br />Il y a certainement beaucoup d'individus sans père ou mère dans le fichier GEDCOM.<br /><br /> Dans ce cas, sur la page <b>#pgv_lang[indi_info]#</b>, sur les onglets <b>#pgv_lang[relatives]#</b>, sur le tableau <b>#pgv_lang[as_child]#</b>, vous trouverez les liens pour ajouter un <u>nouveau</u> père ou une nouvelle mère à un individu.<br /><br />SVP gardez à l'esprit que ces liens ne doivent être utilisés que pour ajouter un <u>nouveau</u> père ou une nouvelle mère. Si le père ou la mère existent déjà dans la base de données, vous devez ajouter le lien <b>#pgv_lang[link_as_child]#</b>, que vous trouverez sur cette page <b>#pgv_lang[indi_info]#</b> après le dernier tableau. N'oubliez pas de faire les recherches nécessaires dans la base de données avant d'ajouter un nouveau père ou une nouvelle mère.<br /><br />";
$pgv_lang["show_fact_sources_help"]     = "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br />Quand cette option est sélectionnée, vous pouvez voir tous les enregistrements des Sources ou des Notes de cette personne. Quand cette option n'est pas sélectionnée, les enregistrements des Sources ou des Notes qui sont associés à d'autres faits concernant cette personne ne seront pas affichés.<br /><br />";
$pgv_lang["age_differences_help"]       = "~#pgv_lang[age_differences]#~<br />Quand cette option est cochée, l'onglet «#pgv_lang[relatives]#» affichera les différences de date comme suit :<br /><ul><li>dates de naissance des partenaires.<br />Une valeur négative indique que le second partenaire est plus âgé que le premier.<br /><br /></li><li>date de mariage et date de naissance du premier enfant.<br />Une valeur négative indique que l'enfant est né avant la date de mariage ou alors que la date de mariage ou la date de naissance est erronée.<br /><br /></li><li>dates de naissance des frères et soeurs.<br />Une valeur négative indique que ou bien l'ordre des enfants est faux ou que l'une des dates de naissance est fausse.</li></ul><br /><br />";
//-- Add Facts
$pgv_lang["add_facts_help"]             = "~Ajouter un nouvel événement~<br /><br />Ici vous pouvez ajouter un nouvel événement à un enregistrement en cours d'édition.<br /><br />Tout d'abord choisissez un événement depuis la liste, puis cliquez sur le bouton <b>Ajouter</b>.  Tous les événements que vous pourriez ajouter à un individu sont dans cette liste déroulante.<br /><br />";
$pgv_lang["add_custom_facts_help"]      = "~Ajouter un fait personnalisé~<br />Si vous ne pouvez ajouter un événement à partir des événements proposés dans la liste, vous pouvez aussi bien ajouter un <b>événement personnalisé</b>.<br /><br />Entrer un événement personnalisé est aussi simple que d'entrer un événement pré-défini. La seule différence réside dans le fait que vous devez nommer cet événement au lieu de le reprendre à partir de la liste. Vous devez le faire dans le champ en en-tête : <b>#pgv_lang[type]#</b><br /><br />";
$pgv_lang["add_note_help"]              = "#pgv_lang[multiple_help]#<br />~AJOUTER UNE NOUVELLE NOTE~<br />Si vous voulez ajouter une note sur cette personne, cliquez sur ce lien, qui ouvrira une fenêtre dans laquelle vous pouvez saisir ce que vous désirez. Quand vous avez fini votre saisie, cliquez sur le bouton <b>Ajouter</b> pour terminer.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]            = "#pgv_lang[multiple_help]#<br />~AJOUTER UNE NOUVELLE SOURCE D'ARCHIVE~<br />Ici vous pouvez ajouter une source <b>d'archive</b> à cet enregistrement.<br /><br />Cliquez simplement sur le lien, une fenêtre s'ouvrira, et vous pourrez choisir la source depuis la liste (recherche de l'ID) ou créer une nouvelle source d'archives puis l'ajouter.<br /><br />Renseigner les sources d'archives est une part importante et fondamentale du travail de généalogie, parce que cela permet à d'autre généalogistes de vérifier l'origine de vos informations.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]             = "~#pgv_lang[add_media]#~<br /><br />L'ajout d'OBJEts MultiMédia (MM) à votre base GEDCOM la rend très agréable à consulter.<dl><dt>Ce qu'il faut savoir sur les OBJEts MultiMédia.</dt><dd>De nombreux formats existent. PhpGedView en reconnaît la grande majorité</dd><dt>Formats</dt><dd>Les images peuvent s'enregistrer sous plusieurs formats (.jpg .png .bmp .gif ...)<br />Pour un affichage presque identique, la taille du fichier peut varier énormément selon le format choisi</dd><dt>Résolution</dt><dd>La résolution d'une image se mesure en «dpi» (dots per inch = points par pouce). Equivalent en photographie au grain du film 25ASA - 200ASA - 800ASA.<br />La qualité augmente avec la résolution, mais la taille du fichier aussi.<br />Pour une image web, 75 dpi est largement suffisant</dd><dt>Nombre de couleurs</dt><dd>L'autre moyen de diminuer la taille d'un fichier, c'est de réduire le nombre de couleurs utilisées.<br />Entre 8 couleurs et 65M de couleurs, le choix est large. 256 est suffisant</dd><dt>Pourquoi est-il important d'avoir des petits fichiers ?</dt><dd>D'abord parce que la place est limitée sur un serveur web, et l'augmenter coûte cher.<br />Ensuite parce que les gros fichiers sont longs à charger, pour vous et pour vos visiteurs.<br />Tout le monde ne dispose pas d'une connexion haut-débit</dd><dt>Comment ajouter un fichier MM ?</dt><dd>Pour toutes les raisons évoquées, seul l'administrateur possède les droits. Contactez-le. Il chargera le fichier sur le serveur.<br />Vous pourrez ensuite rattacher ce fichier à une personne ou un événement</dd></dl>";
$pgv_lang["gen_missing_thumbs_help"]    = "~#pgv_lang[gen_missing_thumbs]#~<br />Cette option génèrera des vignettes pour tous les fichiers qui se trouvent dans la répertoire actif et qui n'ont pas encore de vignette. Cela est beaucoup plus pratique que de cliquer sur le lien <b>#pgv_lang[gen_thumb]#</b> pour chacun des fichiers concernés.<br /><br />Si vous désirez vérifiez quels sont les fichiers qui doivent avoir des vignettes, vous ne devez pas utiliser cette option. Dans ce dernier cas, il vaut mieux cliquer sur les liens appropriés <b>#pgv_lang[gen_thumb]#</b>.<br /><br />";
$pgv_lang["add_facts_general_help"]     = "~General info about adding~<br />Quand vous ajoutez un événement, une note, une source ou un fichier multimédia à un individu de la base, cet ajout doit être approuvé par un utilisateur en ayant l'autorisation. <br /><br />Tant que ces modifications n'ont pas été approuvées, elles sont identifiées comme «en attente» par une couleur particulière de la bordure. Tous les utilisateurs ayant les autorisations de modifications peuvent voir ces modifications et l'information originale. Les utilisateurs n'ayant pas les droits de modification voient uniquement l'information originale. Quand la modification a été acceptée, les bords de couleur disparaissent et seule l'information modifiée est affichée normalement, remplaçant l'ancienne. À partir de là, cette information est visible par tous les utilisateurs.<br /><br />";
//-- Edit user
$pgv_lang["edituser_my_account_help"]   = "Ici vous pouvez modifier votre configuration et vos préférences.<br /><br />Vous pouvez changer votre identifiant, votre nom, votre mot de passe, votre adresse courriel, vos coordonnées, le thème par défaut du site web, et la méthode pour vous contacter (courriel, PhpGedView ...).<br /><br />Vous ne pouvez pas changer l'ID GEDCOM (INDI) enregistré et attaché à votre nom. Cette opération doit être réalisée par l'administrateur";
$pgv_lang["edituser_username_help"]     = "~#pgv_lang[username]#~<br /><br />Dans cette case, vous pouvez modifier votre nom d'utilisateur.  Si votre nom d'utilisateur ne vous convient pas ou si vous avez d'autres raisons pour le changer, vous pouvez le faire en utilisant ce formulaire.<br /><br />Le nom d'utilisateur <u>tient compte des majuscules ou des miniscules</u>. Cela signifie que <b>Jean</b> n'est pas identique à <b>jean</b> ou <b>JEAN</b>.<br /><br />Vous devez utiliser <u>uniquement</u> des charactères de l'alphabet que PhpGedView supporte. Vous pouvez employer les lettres majuscules et minuscules avec ou sans marques diacritiques, les nombres, les tiret (-), et le tiret bas (_). N'utilisez <u>pas</u> les signes de ponctuation ou les espaces.<br /><br />";
$pgv_lang["edituser_firstname_help"]    = "~#pgv_lang[firstname]#~<br /><br />Dans cette case vous pouvez changer votre prénom. C'est le prénom que les autres utilisateurs voient quand vous êtes connecté.<br /><br />Bien que le choix du prénom vous soit entièrement libre, vous devez informer l'administrateur quand vous le modifiez. Si les autres utilisateurs voyaient un utilisateur inconnu en ligne, elles pourraient être inquiètes et se poser des questions. L'administrateur peut le découvrir sans en avoir été informé par vos soins, aussi est-il recommandé de lui éviter une vérification inutile, informez-le après toute modification, merci.<br /><br />";
$pgv_lang["edituser_lastname_help"]     = "~#pgv_lang[lastname]#~<br /><br />Dans cette case vuos pouvez changer votre nom. C'est le nom que les autres utilisateurs voient quand vous êtes connecté.<br /><br />Bien que le choix du nom vous soit entièrement libre, vous devez informer l'administrateur quand vous le modifiez.  Si les autres utilisateurs voyaient un utilisateur inconnu en ligne, elles pourraient être inquiètes et se poser des questions.  L'administrateur peut le découvrir sans en avoir té informé par vos soins, aussi est-il recommandé de lui éviter une vérification inutile, informez-le après toute modification, merci.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]     = "~#pgv_lang[gedcomid]#~<br /><br />C'est un numéro d'identification qui vous relie à la base de données généalogiques.<br /><br />Vous ne pouvez pas le modifier ; il est défini par l'administrateur. Si vous pensez que ce numéro d'identification (ID) est incorrect, vous devrez contacter l'administrateur pour obtenir sa modification.<br /><br />";
$pgv_lang["edituser_rootid_help"]       = "~#pgv_lang[rootid]#~<br /><br />C'est l'individu racine (à l'origine) de votre diagramme.<br /><br />Si, par exemple, vous deviez cliquer sur le lien correspondant à votre arbre, vous verriez cet individu racine dans la case à l'extrême gauche de l'écran. Cet individu racine ne doit pas être vous ; vous pouvez commencer la construction de votre arbre avec n'importe quel individu (vos grand-parents ou votre tante par exemple), sous réserve que vous ayez les droits pour voir cet individu.<br /><br /> Vous pouvez modifier l'individu racine dans la plupart des diagrammes, mais uniquement pour la page en cours.<br /><br />";
$pgv_lang["edituser_password_help"]     = "~#pgv_lang[password]#~<br /><br />C'est une bonne habitude de changer de mot de passe régulièrement. Vous devez conserver à l'esprit que n'importe qui connaissant votre nom d'utilisateur et votre mot de passe pourra avoir accès à vos informations personnelles.<br /><br />Définissez un mot de passe à partir de 6 caractères au minimum, plus ce mot de passe sera long, mieux votre compte sera protégé. Vous pouvez employer les lettres majuscules ou minuscules avec ou sans caractères diacritiques, chiffres, tiret (-) ou tiret bas (_). Ne <u>jamais</u> utiliser de signes de ponctuation ou d'espaces. Utilisez une combinaison de lettres majuscules et minuscules, de chiffres ou d'autres caractères. Par exemple : <b>5Z_q\$P4=r9</b>.<br /><br />Comme pour le nom d'utilisateur, le mot de passe respecte les majuscules et minuscules. Ce qui signifie que le mot de passe<b>Motdepasse.Secret!#13</b> n'est pas identique à <b>motdepasse.secret!#13</b> ou <b>MOTDEPASSE.SECRET!#13</b>.<br /><br />";
$pgv_lang["edituser_conf_password_help"]= "~#pgv_lang[confirm]#~<br /><br />Si vous avez modifié votre mot de passe, vous devez le taper une seconde fois pour le confirmer. C'est uniquement pour vérifier que vous n'avez pas fait d'erreur de saisie et que les deux saisies sont identiques.<br /><br />Si la seconde saisie n'est pas identique à la première (contenu identique des deux champs de mot de passe), vous verrez s'afficher un message d'erreur. Vous devrez resaisir le bon mot de passe à nouveau deux fois pour confirmation.<br /><br />";
$pgv_lang["edituser_change_lang_help"]  = "~#pgv_lang[change_lang]#~<br /><br />Ici vous pouvez changer la langue de l'interface de PhpGedview et des messages qui sont affichés.<br /><br />Lors de votre première connexion au site, PhpGedView suppose que vous souhaitez conserver la même langue que celle utilisée dans votre navigateur web. Si cette supposition s'avérerait incorrecte, vous pourriez modifier le choix de la langue ici.  Par exemple, votre navigateur est configuré pour utiliser la langue anglaise, parce que c'est la langue la plus répandue sur le web. Cependant, pour des recherches généalogiques, vous préférez visualiser les informations en Suédois ou en Hébreu. C'est ici que vous pouvez le faire.<br /><br />L'administrateur choisit quelles langues seront disponibles aux utilisateurs. Si votre langue préférée n'est pas dans la liste, vous devrez contacter l'administrateur.<br /><br />SVP souvenez-vous que PhpGedView est un projet collaboratif international dont les membres sont bénévoles. Les experts vont et viennent.  En conséquence, l'intégration d'autres langues que l'anglais n'est pas d'aussi bonne qualité qu'elle le devrait.<br /><br />Si vous lisez quelque-chose de mal traduit ou avec des fautes d'orthographe, portez le à la connaissance de l'administrateur. L'administrateur saura contacter l'équipe de développeurs de PhpGedView pour apporter les corrections nécessaires. Participez à l'amélioration de cet outil, offrez une partie de votre temps. Votre aide sera la bienvenue.<br /><br />";
$pgv_lang["edituser_email_help"]        = "~#pgv_lang[emailadress]#~<br /><br />Une adresse courriel valide est indispensable pour nous permettre de rester en contact avec vous.<br /><br />Si vous changez d'adresse courriel, comme cela se produit quand vous changez de fournisseur d'accès Internet, s'il vous plaît, n'oubliez pas de changer votre adresse courriel ici également. Vous ne recevrez pas de message de confirmation de ce changement d'adresse, mais tous les prochains messages de ce site vous seront envoyés directement à cette nouvelle adresse.<br /><br />";
$pgv_lang["edituser_user_theme_help"]   = "~#pgv_lang[user_theme]#~<br /><br />L'interface de ce site est paramétrable et peut avoir plusieurs «aspects». D'autres programmes nomment ces interfaces des «skins», mais nous utiliserons le terme plus approprié de «thèmes».<br /><br />Chaque thème affiche les mêmes données, seule la présentation de ces données change. C'est comme poser une image dans un cadre différent et dans une autre pièce. L'image ne change pas, seul l'environnement est compltement différent.<br /><br />Essayez l'un des thèmes proposés. Regardez s'il vous convient, essayez en un autre. Conservez celui qui convient le mieux. À chaque connexion, vous retrouverez le thème sélectionné lors de votre dernière visite ; vous n'êtes pas obligé de sélectionner votre thème à chaque nouvelle connexion.<br /><br />";
$pgv_lang["edituser_contact_meth_help"] = "~#pgv_lang[user_contact_method]#~<br />PhpGedView utilise différentes méthodes pour gérer les messages entre utilisateurs. L'administrateur détermine quelle méthode sera la mieux adaptée. Vous avez le choix du mode de messagerie à utiliser pour <u>vous</u> contacter. Selon la configuration du site, certains modes de messagerie ne seront pas accessibles.<br />";
$pgv_lang["mail_option1_help"]          = "Avec cette option, la messagerie interne de PhpGedView sera utilisée et aucun courriel ne vous sera envoyé.<br /><br />Vous recevrez uniquement des messages <u>internes</u> des autres utilisateurs. Quand un autre utilisateur vous envoie un message, ce message apparaît dans votre case de réception des messages sur votre portail, page #pgv_lang[mygedview]#.  Si vous avez supprimé ce bloc (cette case) de votre page #pgv_lang[mygedview]#, vous ne verrez plus aucun message. Ils apparaîtront cependant quand vous reconfigurerez votre page #pgv_lang[mygedview]# pour afficher la case de réception des messages.<br /><br />";
$pgv_lang["mail_option2_help"]          = "Cette option est similaire à  #pgv_lang[messaging]#, mais avec un ajout.  En plus du message interne, une copie du message vous est adressée directement par courriel.<br /><br />C'est la méthode de messagerie par défaut et la plus complète.<br /><br />";
$pgv_lang["mail_option3_help"]          = "Avec cette option, vous recevrez uniquement les messages vers votre adresse courriel. Vous ne serez pas joignable par la messagerie interne.<br />";
$pgv_lang["mail_option4_help"]          = "Avec cette option, vous ne recevrez aucun message.<br />";
//-- Admin
$pgv_lang["admin_help"]                 = "Sur cette page vous trouverez les liens vers les pages de configuration, d'administration, de documentation et de connexion.<br /><br /><b>#pgv_lang[system_time]#</b>, juste au-dessous du titre de la page, est affichée l'heure du serveur sur lequel est hébergé votre site. Ceci signifie que si votre serveur d'hébergement est situé à New York alors que vous vous trouvez en France, l'heure indiquée aura 6 heures de décalage avec votre heure locale, à moins que le serveur ne soit réglé sur l'heure de Greenwich (Greenwich Mean Time - GMT).  L'heure du serveur est affichée lorsque vous ouvrez ou actualisez cette page.<br /><br /><b>ATTENTION</b><br />Quand vous voyez un message d'alerte rouge sous l'heure système, cela signifie que le fichier <i>config.php</i> est toujours modifiable. Une fois la configuration de votre site terminée, vous devez, pour plus de <b>sécurité</b>, modifier les options de ce fichier et n'autoriser que la lecture seule. Vous devez réaliser ces modifications via votre logiciel FTP <u>manuellement</u>, cette manipulation n'étant pas possible depuis PhpGedView.<br /><br />";
//-- User Admin
$pgv_lang["useradmin_help"]             = "~#pgv_lang[user_admin]#~<br /><br />Sur cette page vous pouvez administrer les utilisateurs ou en ajouter de nouveaux.<br /><br /><b>#pgv_lang[current_users]#</b><br />Dans ce tableau, les utilisateurs courants, leur statut et leurs droits sont affichés.  Vous pouvez <b>supprimer</b> ou <b>éditer</b> les utilisateurs.<br /><br /><b>#pgv_lang[add_user]#</b><br />Ce formulaire est presque identique à celui que les utilisateurs voient sur leur page <b>#pgv_lang[editowndata]#</b>.<br /><br />Pour différentes rubriques il n'existe pas de texte d'aide spécifique pour l'administrateur. Dans ces cas là vous verrez s'afficher le message suivant :";
$pgv_lang["useradmin_gedcomid_help"]    = "~#pgv_lang[gedcomid]#~<br /><br />Le #pgv_lang[gedcomid]# identifie chaque utilisateur. Il est spécifié par l'administrateur.<br /><br />Cet ID est utilisé comme ID de connexion et de paramétrage automatique des informations affichées dans plusieurs pages comme par exemple <b>#pgv_lang[my_indi]#</b> et <b>#pgv_lang[my_pedigree]#</b>.<br /><br />Vous pouvez spécifier l'ID GEDCOM des utilisateurs séparément pour chaque GEDCOM. Si un utilisateur n'a pas d'enregistrement le concernant dans le GEDCOM, vous laisserez ce champ vide.<br /><br />";
$pgv_lang["useradmin_rootid_help"]      = "~#pgv_lang[rootid]#~<br /><br />Pour chaque base de données généalogiques, vous pouvez spécifier un <b>individu racine</b> pour cet utilisateur.<br /><br />Cet individu racine n'est pas nécessairement l'utilisateur lui-même ; il peut être n'importe qui. L'utilisateur désirera sûrement commencer son arbre à partir de lui-même.  Vous le définissez, comme l'individu racine pour différents diagrammes, ici.<br /><br />Si l'utilisateur bénéficie de droits pour modifier son propre compte, il pourra modifier cet individu racine lui-même.<br /><br />";
$pgv_lang["useradmin_can_admin_help"]   = "~#pgv_lang[can_admin]# case à cocher~<br /><br />Si cette case est cochée, l'utilisateur aura les mêmes droits que vous.<dl><dt>Ces droits incluent :</dt><dd>Ajouter/ Supprimer / Editer les utilisateurs</dd><dd>Messages diffusés à tous les utilisateurs</dd><dd>Edition des messages sur la page d'accueil</dd><dd>Edition et configuration de la langue</dd><dt></dt><dd>Mise à jour de PhpGedView</dd><dd>Modifications du programme et de la configuration du fichier GEDCOM</dd><dd>Administration des GEDCOM</dd><dd>Modification des paramètres utilisateurs</dd><dd>Et d'autres réglages qui ne sont pas mentionnés ici.</dd></dl><br />L'utilisateur <u>ne peut rien</u> modifier sur votre serveur dehors de PhpGedView.";
$pgv_lang["useradmin_sync_gedcom_help"] = "~#pgv_lang[sync_gedcom]# case à cocher~<br /><br />Si cette case est cochée et si l'utilisateur a un enregistrement GEDCOM qui lui est associé, son compte d'utilisateur sera automatiquement synchronisé avec les données du GEDCOM le concernant. Ceci signifie que quand les données GEDCOM de l'utilisateur seront modifiées, quelques-unes de ces informations comme l'adresse courriel ou le nom seront copiées automatiquement dans le compte de l'utilisateur. Quand le compte de l'utilisateur est modifié, les modifications apportées sont copiées également vers l'enregistrement GEDCOM correspondant.";
$pgv_lang["useradmin_can_edit_help"]    = "~#pgv_lang[can_edit]#~<br /><br />L'utilisateur peut bénéficier de différents types d'accès et de privilèges en fonction des bases généalogiques pour lesquelles il est enregistré.<ul><li><b>#pgv_lang[none]# :</b> L'utilisateur ne peut accéder aux informations confidentielles dans ce GEDCOM.</li><li><b>#pgv_lang[access]# :</b> L'utilisateur ne peut pas éditer ou valider des données dans la base de données mais il peut visualiser les données d'ordre personnel.</li><li><b>#pgv_lang[edit]# :</b> L'utilisateur peut éditer et modifier des données mais ces modifications doivent être validées par un autre utilisateur qui dispose des privilèges <b>#pgv_lang[accept]#</b> avant que celles-ci ne soient enregistrées dans la base et accessible au public.</li><li><b>#pgv_lang[accept]# :</b> L'utilisateur peut éditer et modifier des données. Il peut également approuver des changements réalisés par d'autres utilisateurs.</li><li><b>#pgv_lang[admin_gedcom]# :</b> L'utilisateur peut éditer la configuration et les réglages du fichier <u>GEDCOM</u>.</li></ul>Les administrateurs système, identifiés par la case à cocher <b>#pgv_lang[can_admin]#</b>, disposent automatiquement des privilèges <b>#pgv_lang[admin_gedcom]#</b>.<br /><br />";
$pgv_lang["useradmin_verified_help"]    = "~#pgv_lang[verified]#~<br /><br /><b>Enregistrement d'un compte utilisateur</b><br />Un utilisateur peut solliciter un nouveau compte à l'aide du module <b>de demande d'un compte utilisateur</b>.<br /><br />S'il procède à cette demande, il recevra un courriel avec un lien lui permettant de vérifier et valider son nouveau compte. Une fois qu'il aura suivi les instructions de validation de son compte dans le courriel, vous constaterez que cette case est cochée et vous pourrez passer à l'étape suivante, <b>#pgv_lang[verified_by_admin]#</b>. Vous devez attendre que cette case soit cochée pour approuver le nouveau compte.<br /><br /><b>Ajouter un utilisateur manuellement</b><br />Si vous ajoutez un compte utilisateur manuellement, vous constaterez que la case est déjà cochée automatiquement.<br /><br />";
$pgv_lang["useradmin_verbyadmin_help"]  = "~#pgv_lang[verified_by_admin]#~<br /><br />Si un utilisateur a utilisé le module de demande d'un compte utilisateur et s'est enregistré lui-même, la dernière étape, avant que son compte ne devienne actif, est votre approbation (validation).<br /><br />Une fois que vous aurez approuvé cette demande de compte, l'utilisateur recevra un courriel. Ce courriel informera l'utilisateur que son compte a été activé et qu'il peut se connecter en utilisant l'identifiant et le mot de passe saisis lors de son enregistrement.<br /><br />";
$pgv_lang["useradmin_edit_user_help"]   = "~#pgv_lang[update_user]#~<br /><br />Ce formulaire est utilisé par l'administrateur pour modifier les comptes utilisateurs.<br /><br />Ce formulaire est similaire aux formulaires <b>#pgv_lang[add_user]#</b> et <b>#pgv_lang[update_myaccount]#</b>.<br /><br />";
$pgv_lang["useradmin_visibleonline_help"]= "~#pgv_lang[visibleonline]#~<br /><br />Option pour afficher le statut de connexion (en ligne / hors ligne) aux autres utilisateurs. Si la case est cochée, l'utilisateur sera visible. Sinon il restera caché.";
$pgv_lang["useradmin_editaccount_help"] = "~#pgv_lang[editaccount]#~<br /><br />Option pour autoriser la modification de certains paramètres du compte par l'utilisateur.<br /><br />Si la case n'est <b>pas</b> cochée, les modifications seront interdites.<br /><br />Cette fonction permet de créer un compte générique, utilisable par plusieurs personnes, mais en interdisant à chacun de le modifier.";
$pgv_lang["useradmin_relation_priv_help"]= "~#pgv_lang[user_relationship_priv]#~<br /><br />Si cette case est cochée, les utilisateurs ne peuvent accéder qu'aux individus vivants qui leur sont liés (liens de parenté directe). Ils ne sont en mesure de voir que les proches dans la limite du degré de parenté indiqué par <i>#pgv_lang[user_path_length]#</i>. Vous pouvez avoir besoin d'imposer à tous les utilisateurs ces restrictions d'accès au fichier GEDCOM en activant les options de restriction d'accs dans le GEDCOM.<br /><br />Ces réglages nécessitent que les utilisateurs soient associés à un ID GEDCOM pour être autorisés à voir n'importe quel individu vivant.<br /><br />";
$pgv_lang["useradmin_path_length_help"] = "~#pgv_lang[user_path_length]#~<br /><br />Si <i>#pgv_lang[user_relationship_priv]#</i> est actif, cet utilisateur ne pourra voir ou éditer que les individus vivants dans le degré de parenté indiqué.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"] = "~#pgv_lang[user_auto_accept]#~<br /><br />En cochant cette case, vous permettez au système d'accepter automatiquement toutes les modifications réalisées par cet utilisateur.  L'utilisateur doit également bénéficier des mêmes privilèges dans le GEDCOM pour que cette option soit active.<br /><br />";
//-- Manage Sites
$pgv_lang["help_managesites"]           = "~Gestion des sites~<br /><br />Sur cette page, vous pouvez ajouter des sites distants (ou serveur) ainsi que leur adresse IP.<br /><br />Les sites distants peuvent être ajoutés en indiquant leur titre, l'URL, l'identifiant de leur base de données (optionnel), le nom d'utilisateur et le mot de passe pour accéder aux web services.<br /><br />Une liste d'adresses IP interdites est créée en indiquant une plage d'adresses IP valides. Par exemple, 212.10.*.*  Les sites distants ne correspondant pas à cette plage IP seront enregistrés dans la liste des adresses rejetées et ne pourront pas accéder à vos services web. Vous pouvez interdire des adresses IP complètes également.";
//-- Adding Remote Links
$pgv_lang["help_remotesites"]           = "~Ajouter des sites distants~<br /><br />Pour ajouter un site distant, indiquez le titre du site, l'URL des services web, l'ID de la base de données ainsi que le nom d'utilisateur et le mot de passe. Cliquez sur le bouton «ajouter» pour terminer la procédure. Si le serveur distant autorise des connexions anonymes, vous devez laisser les champs «utilisateur» et «mot de passe» vides.";
//-- IP Address Banning
$pgv_lang["help_banning"]               = "~Interdiction d'adresses IP~<br /><br />Pour interdire l'accès de sites distants à vos services web, saisissez son adresse IP ou une plage d'adresses IP, par exemple, 212.10.*.* et cliquez sur le bouton de validation.";
$pgv_lang["help_manual_search_engines"] = "~Designation manuelle de moteurs de recherche~<br /><br />PhpGedView fournit automatiquement à des moteurs de recherche de plus petits fichiers de données avec peu de liens. Les données sont limitées aux individus et à leur famille proche, sans ajout d'information sur leurs grand-parents ou leurs petits-enfants. De nombreux rapports et des pages de données lourdes comme le calendrier sont en dehors des limites des moteurs de recherche.<br /><br />Si un moteur de recherche n'est pas automatiquement reconnu et que vous souhaitez lui fournir des données à indexer, vous pouvez les lister ici.  Si vous ne voulez pas fournir de données, vous indiquerez les références du moteur dans la liste des adresses IP interdites ci-dessous.<br /><br />Si vous souhaitez voir quelles sont vos données qui sont indéxées par les moteurs de recherche, spécifiez votre propre adresse IP ici.  <span class='warning'>ATTENTION :</span> Ceci vous déconnectera de l'interface d'administration, et vous devrez enlever cette adresse IP en vous connectant depuis une autre machine ou en éditant manuellement le fichier <i>/index/search_engines.php</i>.<br /><br />Pour désigner manuellement un site distant comme un moteur de recherche et d'indexation, fournissez une adresse IP ou une plage d'adresses IP valides, par exemple, 212.10.*.* et cliquez sur le bouton de validation. La plupart des moteurs de recherche comme Google ou Yahoo seront détectés automatiquement.";
//-- Search_engines.php
$pgv_lang["search_engine_landing_page"] = "~Moteurs de recherche détectés~<br /><br />PhpGedView fournit automatiquement à des moteurs de recherche de plus petits fichiers de données avec peu de liens. Les données sont limitées aux individus et à leur famille proche, sans ajout d'information sur leurs grand-parents ou leurs petits-enfants.  De nombreux rapports et des pages de données lourdes comme le calendrier sont en dehors des limites des moteurs de recherche.<br /><br />Les tentatives des robots de recherche pour accéder à ces pages aboutissent à montrer ces pages. Si vous voyez ce texte, le logiciel pense que vous êtes un moteur de recherche et d'indexation. Ci-dessous ce trouve la liste des pages qui peuvent être indexées et fournissent des données abrégées aux moteurs.<br /><br />Les utilisateurs qui suivront les liens proposés par les moteurs de recherche jusqu'à ce site, accéderont aux pages complètes et non à cette page.";
//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]     = "~#pgv_lang[add_gedcom]# / #pgv_lang[upload_gedcom]#~<dl><dt>#pgv_lang[upload_gedcom]#</dt><dd>Le chargement d'un fichier sur le serveur peut se faire directement ici, sans programme de type ftp.</dd><dt>#pgv_lang[add_gedcom]#</dt><dd>Quand un GEDCOM est déjà présent sur le serveur, il suffit de le reconfigurer.</dd></dl>Les deux procédures se déroulent très simplement en 4 étapes, seule la première diffère.";
$pgv_lang["gedcom_configfile_help"]     = "~Fichier de configuration GEDCOM~<br /><br />C'est le fichier où la configuration de base relative à la base de données généalogiques est enregistré. Il existe un fichier pour chaque base de données.<br /><br />Vous trouverez le chemin et le nom de chaque fichier de configuration dans le tableau <b>#pgv_lang[current_gedcoms]#</b> sur la page <b>#pgv_lang[gedcom_adm_head]#</b>.<br /><br />";
$pgv_lang["default_gedcom_help"]        = "~GEDCOM par défaut~<br /><br />Si vous avez plusieurs GEDCOM en ligne, vous pouvez en désigner un comme GEDCOM par défaut pour les visiteurs du site ou les utilisateurs non encore connectés.<br /><br />Les utilisateurs autorisés peuvent modifier cette valeur par défaut en changeant les paramètres de leur compte.";
$pgv_lang["delete_gedcom_help"]         = "~Supprimer un GEDCOM~<br /><br />PhpGedView crée sa base de données à partir d'un fichier GEDCOM qui a été préalablement téléchargé. Quand vous sélectionnez <b>Supprimer</b>, cette partie de la base de données sera effacée. Vous devez confirmer votre demande de suppression.<br /><br />À moins que vous ne l'ayez délibérement supprimé en dehors de PhpGedView, le fichier original GEDCOM se trouve dans le répertoire dans lequel il a été téléchargé. Si vous souhaitez retravailler avec ce fichier GEDCOM plus tard, vous n'aurez pas à le télécharger à nouveau. Vous pouvez choisir la fonction <b>#pgv_lang[add_gedcom]#</b>.<br /><br />";
$pgv_lang["add_gedcom_help"]            = "~#pgv_lang[add_gedcom]#~<br /><br />Cela suppose que le fichier GEDCOM a déjà été chargé sur le serveur, via ftp par exemple.<br /><br />Vous serez guidé tout au long de la procédure.";
$pgv_lang["add_new_gedcom_help"]        = "~#pgv_lang[add_new_gedcom]#~<br /><br />Vous pouvez commencer une nouvelle base de données généalogiques à partir de zéro.<br /><br />Cette procédure implique tout simplement de suivre ces étapes. L'étape 1 est différente de ce que vous connaissez déjà (téléchargement ou ajout). Les autres étapes vous seront familières.<ol><li><b>Nommer le nouveau GEDCOM</b><br />Saisissez le nom du nouveau GEDCOM <u>sans</u> l'extension <b>.ged</b>. Le nouveau fichier sera créé dans le répertoire nommé au-dessus de la case dans laquelle vous entrez le nom.  Cliquez sur <b>Ajoutez</b>.</li><li><b>Page de configuration</b><br />Vous connaissez déjà cette page ; vous configurez les nouveaux paramètres de votre nouveau fichier GEDCOM.</li><li><b>Validez</b><br />Vous connaissez également cette page ; le nouveau GEDCOM est validé. Puisqu'il est vide, il sera OK.</li><li><b>Importer des enregistrements</b><br />Puisqu'il n'y aura qu'un seul enregistrement à importer, cette étape sera très rapide.</li></ol>C'est tout.  Maintenant vous pouvez vous rendre sur votre arbre généalogique et voir votre premier individu dans le nouveau GEDCOM. Cliquez sur le nom de l'individu et modifiez-le. Maintenant vous pouvez lier de nouveaux individus à ce premier enregistrement.<br /><br />";
$pgv_lang["download_gedcom_help"]       = "~#pgv_lang[download_gedcom]#~<br /><br />À partir de cette page, vous pouvez télécharger votre base de données généalogiques au format GEDCOM. Vous pouvez vouloir importer des données dans un autre programme généalogique, ou partager ces données avec d'autres.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]          = "~#pgv_lang[gedcom_adm_head]#~<br /><br />La page  #pgv_lang[gedcom_adm_head]# est le centre de contrôle pour administrer toutes vos bases de données généalogiques.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />En en-tête du tableau <b>#pgv_lang[current_gedcoms]#</b>, vous verrez une barre d'outils avec 4 liens.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>Dans le tableau <b>#pgv_lang[current_gedcoms]#</b> chaque base de données généalogique est listée séparément, et vous disposez des options suivantes pour chacune d'elles :<ul><li>Importer</li><li>Supprimer</li><li>Télécharger</li><li>Configurer</li><li>Restrictions d'accès</li><li>Journal des recherches</li></ul>L'édition des restrictions d'accès apparaît ici parce que chaque GEDCOM a son propre fichier de restrictions d'accès.<br /><br />Chacune des lignes de ce tableau est explicite. PhpGedView peut être configuré pour enregistrer toutes les recherches sur la base de données.  Le journal des recherches peut être analysé à partir des liens sur cette page.<br />#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]    = "~Configuration GEDCOM~<br /><br />Toutes les bases de données généalogiques utilisées avec PhpGedView ont leur propre <b>fichier de configuration</b>.<br /><br />Dans ce formulaire, vous pouvez configurer de nombreuses options telles que le titre de la base de données, la langue utilisée, le format des calendriers, les options du courriel, la journalisation des recherches dans la base de données, les balises META en en-tête des pages HTML, l'extraction des noms de famille depuis la liste des noms de famille les plus fréquents, etc.<br /><br />";
$pgv_lang["import_gedcom_help"]         = "~Import GEDCOM~<br /><br />Dans la plupart des cas l'importation d'un fichier GEDCOM, déjà créé par un autre programme, est l'une des étapes qui a pour conséquence une modification en bloc de la base de données généalogiques.<br /><br />Ces étapes respectent un ordre logique et doivent être accomplies dans l'ordre indiqué de sorte que la base de données généalogiques soit correctement installée.<br /><br />Si, pour quelques raisons que ce soit, vous ne respectiez pas l'ordre indiqué, un message <u>d'alterte</u> vous indiquera que le GEDCOM n'est pas encore importé. Pour corriger ce problème, cliquez sur le lien <b>Importation GEDCOM</b> pour importer le fichier.<br /><br />La configuration existante du GEDCOM ne sera pas modifiée quand vous ré-importerez le GEDCOM. Les données existantes seront écrasées lors de l'importation.<br /><br />";
$pgv_lang["upload_gedcom_help"]         = "~#pgv_lang[upload_gedcom]#~<br /><br />Le chargement d'un fichier sur le serveur peut se faire directement ici, sans programme de type ftp.<br /><br />Il suffit de sélectionner un fichier GEDCOM sur votre poste, soit en entrant le chemin complet comme par exemple <i>C:\\Program Files\\PAF\\famille.ged</i>, soit en utilisant le sélecteur de fichier sur la page.<br /><br />D'autres textes d'aide seront disponibles pendant le déroulement de la procédure.";
$pgv_lang["validate_gedcom_help"]       = "~Vérifier le GEDCOM~<br /><br />C'est la troisième étape de la procédure pour ajouter à votre base de données généalogiques un fichier GEDCOM qui a été créé par un autre programme.<br /><br />PhpGedView examinera le fichier en entrée, notamment le format des dates, des lieux, le jeu de caractères utilisé, etc.  Quelques variantes par rapport à la norme GEDCOM 5.5.1, à laquelle PhpGedView adhère, pourront être corrigées automatiquement. Par exemple sur les Macintosh, la gestion du retour chariot en fin de ligne ou le formatage incorrect des noms de lieux.  Quand ces erreurs sont corrigées, un message vous avertira des modifications apportées par votre programme. Concernant d'autres anomalies, vous recevrez un message d'avertissement accompagné d'une solution recommandée.<br /><br /><b>Outils facultatifs</b><br />À ce jour il n'existe qu'un seul outil facultatif :<br /><b>Changer l'ID de l'individu pour...</b>.<br />#pgv_lang[more_config_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]      = "~Convertir du format ANSI vers le format UTF-8~<br /><br />Pour être certain que les informations qui sont importées depuis votre fichier GEDCOM sont traitées correctement, les fichiers sont encodés au format UTF-8.<br /><br />Certains programmes de généalogie plus récents peuvent exporter leurs données dans un GEDCOM encodé en UTF-8. Les anciens programmes n'ont souvent pas cette possibilité. Si votre programme ne vous permet pas d'utiliser cette option, PhpGedView pourra convertir vos fichiers pour vous.<br /><br />Quand PhpGedView valide le fichier en entrée, il détectera son type d'encodage et vous alertera en conséquence.<br /><br />";
$pgv_lang["detected_ansi2utf_help"]     = "~Encodage au format ANSI a été détecté~<br /><br />Le GEDCOM qui vient d'être validé est encodé selon le format de caractères ANSI. Il vous est fortement recommandé de le convertir au format UTF-8.<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]         = "~Format erroné de date détecté~<br /><br /><b>LE FORMAT DE DATE SERA CHANGÉ</b><br /><br />Le format de date standard pour PhpGedView qui est également celui qui est recommandé par la norme GEDCOM 5.5.1 : <b>DD&nbsp;MMM&nbsp;YYYY</b> (e.g. 01&nbsp;JAN&nbsp;2004)<br /><br />Si, après la validation du GEDCOM, vous voyez un message vous alertant que les dates sont mal formatées, PhpGedView convertira les dates comme spécifié par le standard GEDCOM 5.5.1.<br /><br />Vous avez cependant la possibilité de choisir entre «<b>jour</b> avant le mois» (DD&nbsp;MMM&nbsp;YYYY), ou «<b>mois</b> avant le jour» (MMM&nbsp;DD&nbsp;YYYY).<br /><br />Nous vous recommandons d'utiliser le premier format (jour avant mois).<br /><br />";
$pgv_lang["change_indi2id_help"]        = "~Modifier l'ID d'un individu pour....~<br /><br />Cet outil a été conçu pour les utilisateurs dont les programmes de généalogie utilisent un ID GEDCOM différent lors de l'exportation des individus. Par exemple, lors de la première exportation du GEDCOM, l'ID d'un individu peut être I100 mais lors de l'exportation suivante l'ID du même individu a été modifié en I234. Ces changements d'ID rendent difficile l'administration de PhpGedView car l'ID est le seul élément qui permet d'identifier les individus.<br /><br />La plupart des programmes de généalogie emploient la balise RIN ou REFN pour assigner à chaque individu un identifiant unique qui pourra être utilisé pour référencer l'individu. Cet outil remplace tous les identifiants des individus dans le GEDCOM par l'un des champs RIN ou REFN en fonction de vos préférences.<br /><br />";
$pgv_lang["edit_privacy_help"]          = "Sur cette page vous pouvez définir les règles d'accès pour le GEDCOM sélectionné.<br /><br />Vous pouvez vérifier sous le titre de la page que vous éditez le bon fichier des restrictions d'accès. Il est affiché comme ceci : (chemin/nomgedcom_priv.php)<br /><br />Si vous avez besoin d'apporter des réglages supplémentaires, vous pouvez réaliser les modifications directement dans le fichier des restrictions d'accès à la main. Vous pourrez en lire plus sur cette opération sur le site web de PhpGedView.<br /><br />";
$pgv_lang["BOM_detected_help"]          = "~Une marque d'ordre des octets (BOM) a été détectée~<br /><br />Le fichier GEDCOM que vous importez comporte un code spécial de 3 octets en en-tête. Ce code spécifique est utilisé par certains programmes pour indiquer que le fichier a été enregistré au format de caractères UTF-8.<br /><br />Bien que ce code spécial ne soit pas une erreur, PhpGedView ne fonctionne pas correctement avec les fichiers comportant ce code. Vous devez laisser PhpGedView supprimer ce code.<br /><br />";
$pgv_lang["invalid_header_help"]        = "~En-tête de GEDCOM invalide~<br /><br />Un fichier GEDCOM doit commencer par <b>0&nbsp;HEAD</b>. PhpGedView détecte si le fichier GEDCOM que vous êtes en train d'importer n'a pas de <b>0&nbsp;HEAD</b> à la première ligne. Quand vous cliquez sur le bouton de nettoyage de code, toutes les lignes situées avant la première ligne <b>0&nbsp;HEAD</b> seront supprimées.<br /><br />Cette erreur signifie habituellement que le programme que vous aviez l'habitude d'utiliser pour créer votre GEDCOM ne fonctionnait pas proprement. Vous devriez vérifier que vous téléchargez le bon fichier, et qu'il commence bien par la ligne <b>0&nbsp;HEAD</b> et se termine par la ligne <b>0&nbsp;TRLR</b>.<br /><br />";
$pgv_lang["macfile_detected_help"]      = "~Fichier au format Macintosh~<br />PhpGedView a détecté que votre fichier GEDCOM provient d'un ordinateur Macintosh. Les marqueurs de fin de ligne sont différents sur Macintosh (r), sur Unix (n) ou sur Windows (rn). Pour être utilisable par PhpGedView, ces caractères vont être modifiés.<br />";
$pgv_lang["cleanup_places_help"]        = "~Nettoyage des lieux~<br /><br />PhpGedView a détecté que votre fichier GEDCOM utilisait des balises de nom de lieux de manière erronée.<br /><br />De nombreux programmes de généalogie, comme Family Tree Maker, crééront ce type de fichier GEDCOM. PhpGedView fonctionnera avec ces fichiers GEDCOM, mais des lieux invalides seront affichés dans la hiérarchie des noms de lieux. <br /><br />Par exemple, votre GEDCOM contient l'encodage suivant <br />1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Programmeur<br /><br />Selon le standard GEDCOM 5.5.1 le lieu devrait s'afficher tel qu'écrit ici :<br />1 SSN 123-45-6789<br />1 OCCU Programmeur<br /><br />Si vous sélectionnez <b>Oui</b>, PhpGedView corrigera automatiquement ces erreurs d'encodage ou de format.<br /><br />";
$pgv_lang["empty_lines_detected_help"]  = "~Lignes vides détectées~<br /><br />PhpGedView a détecté des lignes vides dans votre fichier d'entrée. Ces lignes peuvent provoquer des erreurs et doivent être supprimées du fichier avant son importation.<br /><br />";
//-- Edit Config
$pgv_lang["help_editconfig.php"]        = "~Configurer PhpGedView~<br /><br />Sur cette page vous définissez les variables des paramètres de PhpGedView. Vous devez réaliser ces réglages après avoir installé PhpGedView pour la première fois.<br /><br />#pgv_lang[review_readme]#Comme ces réglages sont <b>globaux</b>, ils s'appliquent au programme en entier et aux différentes bases de données généalogiques que vous utilisez avec PhpGedView.<br /><br />Chaque base de données généalogiques dispose également de ses propres options de configuration que vous pouvez régler en cliquant sur le lien <b>#pgv_lang[admin_gedcoms]#</b> sur cette page.<br /><br />Vous pouvez également accéder aux fonctions #pgv_lang[gedcom_adm_head]# depuis la page principale d'administration, dont le lien se trouve sous l'icône #pgv_lang[mgv]# ou en en-tête de certaines pages. Sur la page d'administration, le lien approprié se nomme <b>#pgv_lang[manage_gedcoms]#</b>.<br /><br />";
//-- merge records
$pgv_lang["help_edit_merge.php"]        = "~#pgv_lang[merge_records]#~<br /><br />Cette page vous permettra de fusionner deux enregistrements GEDCOM depuis le même fichier GEDCOM.<br /><br />C'est utile pour les personnes qui ont fusionné plusieurs GEDCOM et constatent maintenant que de nombreux individus, familles ou sources sont en double.<br /><br />La page est décomposée en trois étapes.<br /><ol><li>Vous saisissez les deux IDs des deux GEDCOMs.  Les IDs <u>doivent</u> être du même type.  Vous ne pouvez pas fusionner un individu et une famille ou une famille et une source, par exemple.<br />Dans le champ <b>#pgv_lang[merge_to]#</b> saisissez l'ID de l'enregistrement que vous souhaitez définir comme nouvel enregistrement après la fusion complète des deux enregistrements.<br />Dans le champ <b>#pgv_lang[merge_from]#</b> saisissez l'ID du second dont les informations vont être fusionnées dans le #pgv_lang[merge_to]# enregistrement.  Cet enregistrement sera détruit après la fusion.</li><li>Vous choisissez quels événements vous voulez conserver depuis les deux enregistrements quand ils seront fusionnés. Cochez simplement les cases de ceux que vous souhaitez conserver.</li><li>Vous vérifierez le résultat de la fusion, comme n'importe quelle modification réalisée en ligne.</li></ol>Quelqu'un disposant des droits de validation devra valider votre fusion avant que ces changements soient définitifs.<br />";
//-- report engine
$pgv_lang["help_reportengine.php"]      = "~#pgv_lang[reports]#~<br />PhpGedView utilise un modèle XML pour générer automatiquement un rapport au format PDF.<br /><br />Choisir d'abord un type de rapport dans la liste. Cette liste est générée dynamiquement à partir du contenu du répertoire <i>reports</i>. Renseigner ensuite les quelques champs comme le code individu ou le code famille.<br /><br />Pour afficher le résultat dans votre navigateur, cliquez sur <b>#pgv_lang[run_report]#</b>. Pour l'enregistrer sur votre poste, cliquez sur <b>#pgv_lang[download_report]#</b>.<br /><br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]        = "~Format de fichier PDF~<br />Le moteur de rapports de PhpGedView produit des fichiers au format PDF (Adobe) téléchargeables.  Les spécifications du format standard GEDCOM 5.5.1, mentionnées ailleurs dans le fichier d'aide sont également téléchargeables au format PDF.  PDF est un acronyme pour <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />Les fichiers PDF ne peuvent pas être affichés ou édités par les logiciels de base de votre PC. Si vous disposez déjà de la version d'Acrobat Reader installée sur votre PC (souvent livrée en standard avec d'autres logiciels), vous n'aurez pas besoin de la remplacer ou de la mettre à jour pour lire les rapports produits par PhpGedView.<br /><br />Acrobat Reader, le programme de lecture et d'impression pour ce type de fichiers, est disponible gratuitement auprès de son éditeur Adobe Systems Inc.  La version gratuite d'Adobe est téléchargeable à l'adresse Internet suivante : <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Adobe Systems Inc.</b></a>.  Vous pouvez trouver des copies du logiciel Acrobat Reader disponibles pour le téléchargement sur d'autres sites Internet, mais nous vous conseillons fortement de faire confiance <u>uniquement</u> à Adobe Systems Inc.<br /><br />Acrobat Reader est disponible pour plusieurs plateformes système, incluant Microsoft Windows, Linux et Apple Macintosh, dans de nombreuses langues autres que l'anglais. Si vous avez Windows 95, assurez vous de télécharger Acrobat Reader version 5.0.5.  Les versions plus récentes ne peuvent s'installer sous Windows 95.<br /><br /><a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>télécharger Adobe Acrobat Reader ici</b></a><br /><br />";
$pgv_lang["help_ahnentafel.xml"]        = "~#pgv_lang[ahnentafel_report]#~<br />Il s'agit d'un rapport sur l'individu sélectionné et ses ascendants, imprimé au format du livret de famille. Il commence par le premier individu puis continue avec ses parents, grand-parents, etc.<br /><br />Notez que le rapport «ahnentafel» n'est disponible qu'en anglais à ce jour.<br /><br />";
$pgv_lang["help_birthlist.xml"]         = "~#pgv_lang[birth_report]#~<br />Avec ce rapport vous pouvez lister tous les individus qui sont nés à une date donnée ou dans un lieu spécifique.<br /><br />";
$pgv_lang["help_relativelist.xml"]      = "~#pgv_lang[relatives_report]#~<br />Ce rapport énuméra tous les parents de l'individu sélectionné. Vous pouvez choisir quels parents seront affichés sur le rapport.<ul><li><b>#pgv_lang[child-family]#</b> affichera les individus sélectionnés, ses parents et ses frères et sœurs.</li><li><b>#pgv_lang[spouse-family]#</b> affichera l'individu avec ses conjoints et leurs enfants.</li><li><b>#pgv_lang[direct-ancestors]#</b> affichera l'individu, ses parents, ses grand-parents, ses arrières grand-parents et ainsi de suite jusqu'au haut de l'arbre, énumérant ainsi tous les individus ancêtres en ligne directe de l'individu sélectionné.</li><li><b>#pgv_lang[ancestors]#</b> affichera tous les individus issus de la liste #pgv_lang[direct-ancestors]# mais également en y incluant oncles et tantes, grands-oncles et grandes-tantes, et en conséquence les enfants des ascendants issus du même arbre généalogique. Il n'affichera pas les enfants issus de cousins.</li><li><b>#pgv_lang[descendants]#</b> affichera la liste des descendants (enfants, petits enfants, arrières petits enfants, etc).</li><li><b>#pgv_lang[all]#</b> cette option est une combinaison de #pgv_lang[descendants]# et de #pgv_lang[ancestors]# dans un seul rapport.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]           = "~Moteur de rapports~<br />Le moteur de rapports de PhpGedView utilise des modèles XML pour générer automatiquement des rapports au format PDF.<br /><br />Les rapports disponibles dans la liste <b>#pgv_lang[select_report]#</b> sont générés à partir de fichiers XML enregistrés dans le répertoire «reports».  Vous pouvez créer vos propres rapports en faisant une copie de n'importe quel modèle XML fourni et en le modifiant. Pour ajouter votre rapport personnalisé, enregistrez-le simplement dans le répertoire «reports» et PhpGedView le détectera automatiquement, le rendant disponible dans la liste <b>#pgv_lang[select_report]#</b>.<br /><br />";
//-- Help Contents
$pgv_lang["help_contents_head_help"]    = "<b>Sommaire de l'aide</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]  = "Informations du fichier GEDCOM";
$pgv_lang["help_contents_gedcom_places"]= "Lieux du fichier GEDCOM";
//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]= "<b>Sommaire<br /><br /><span class=\"error\"><small>Note : l'aide pour les fonctions <u>administrateur</u> est en début de liste.</small></span></b><br /><br />";
// $pgv_lang["ah1_help"]                = "_Upgrade";
$pgv_lang["ah2_help"]                   = "_Configurer PhpGedView";
$pgv_lang["ah3_help"]                   = "_GEDCOM : Ajouter vs Charger";
$pgv_lang["ah4_help"]                   = "_GEDCOM : Fichier de Configuration";
$pgv_lang["ah5_help"]                   = "_GEDCOM : Fichier par Défaut";
$pgv_lang["ah6_help"]                   = "_GEDCOM : Suppression";
$pgv_lang["ah7_help"]                   = "_GEDCOM : Ajout";
$pgv_lang["ah8_help"]                   = "_GEDCOM : Création";
$pgv_lang["ah9_help"]                   = "_GEDCOM : Réception (download)";
$pgv_lang["ah10_help"]                  = "_GEDCOM : Administration";
$pgv_lang["ah11_help"]                  = "_GEDCOM : Configuration";
$pgv_lang["ah12_help"]                  = "_GEDCOM : Import";
$pgv_lang["ah13_help"]                  = "_GEDCOM : Envoi sur serveur (upload)";
$pgv_lang["ah14_help"]                  = "_GEDCOM : Validation";
$pgv_lang["ah15_help"]                  = "_GEDCOM : Conversion ANSI en UTF-8";
$pgv_lang["ah16_help"]                  = "_GEDCOM : Règles de confidentialité";
$pgv_lang["ah17_help"]                  = "_Gestion des utilisateurs";
$pgv_lang["ah18_help"]                  = "_Administration";
$pgv_lang["ah19_help"]                  = "_GEDCOM : Outils Média";
$pgv_lang["ah20_help"]                  = "_GEDCOM : Conversion ID en RIN";
$pgv_lang["ah21_help"]                  = "_Fichiers de langues";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]                  = "_Configuration des langues supportées";
$pgv_lang["ah24_help"]                  = "_Migration des informations de l'utilisateur (Index -->> SQL)";
$pgv_lang["ah25_help"]                  = "_Sauvegarde (backup) de PhpGedView ";
$pgv_lang["ah26_help"]                  = "_Liste des FAQ: modification";
//--Statistics Help
$pgv_lang["help_statisticsplot.php"]    = "~Statistiques graphiques~<br /><br />Il s'agit de la page de résultats, qui montre le graphique des statistiques de votre base de données qui a été réalisé à partir des données d'entrée que vous avez communiquées sur la page précédente.<br /><br />";
$pgv_lang["help_statistics.php"]        = "~Statistiques graphiques~<br /><br />Cette page vous permet de définir les critères qui permettront de produire un affichage graphique de différentes statistiques sur votre base de données généalogiques.<br /><br />";
$pgv_lang["stat_help"]                  = "~Options pour les graphiques statistiques~<br /><br />Un certain nombre de statistiques sous forme graphique peuvent être produites.<br /><br />Sélectionnez les paramètres à partir des cases de menus déroulants, puis ajustez ces options dans la deuxième sélection.<br /><br />Les nombres qui sont proposés dépendent des données qui sont disponibles dans votre base de données. Ainsi, des individus dont on ne connaît pas le mois de naissance (par exemple on sait seulement qu'ils sont nés en 1856) ne pourront pas être inclus dans la staistique des naissances par mois.<br /><br />";
$pgv_lang["stat_help_x"]                = "~Options pour les graphiques statistiques~<br /><br />~AXE DES X~<br />Les options suivantes sont disponibles pour l'axe des X (horizontal). Chacun sera ensuite représenté selon les options suivantes qui concernent les axes Y et Z.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;individus nés chaque mois.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;individus qui sont décédés chaque mois.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;mariages qui se sont réalisés chaque mois.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;le nombre des premières naissances pour chaque famille par mois.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;le nombre des premiers mariages par mois.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;le nombre de mois entre le mariage et la naissance du premier enfant de ce couple.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;âge du décès, mis en rapport avec la période temporelle qui comprend l'année de naissance de chaque personne.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;âge du décès, mis en rapport avec la période temporelle qui comprend l'année de décès de chaque personne.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;l'âge moyen des individus au moment de leur mariage.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;l'âge moyen des individus au moment de leur premier mariage.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;tailles moyennes des familles.</p>";
$pgv_lang["stat_help_y"]                = "~Options pour les graphiques statistiques~<br /><br />~AXE DES Y~<br />Les options suivantes sont disponibles pour l'axe des Y (vertical). Ces options modifient la façon dont les rubriques qui figurent sur l'axe des X sont affichées.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;affiche le nombre d'individus dans chacune des catégories définie par l'axe des X.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;calcule et affiche la proportion de chaque rubrique dans les catégories de l'axe des X.</p>";
$pgv_lang["stat_help_z"]                = "~Options pour les graphiques statistiques~<br /><br />~AXE DES Z~<br />Les options suivantes sont disponibles pour l'axe des Z. Ces options fournissent une subdivision des categories qui ont été choisies pour l'axe des X.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;affiche les rubriques sur une seule colonne pour chaque catégorie de l'axe des X.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;affiche les rubriques dans 2 colonnes (homme et femme) pour chaque catégorie de l'axe des X.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;affiche les rubriques dans un nombre de colonne qui dépend des périodes temporelles qui sont choisies dans la section suivante, pour chaque catégorie de l'axe des X.</p>";
$pgv_lang["stat_help_gwx"]              = "~Options pour les graphiques statistiques~<br /><br />~Échelles pour l'axe des X~<br />Vous pouvez modifier les plages d'échelles. Soyez prudent lorsque vous effectuez des modifications ; aucune vérification de compatibilité n'est faite.<br /><br />Chaque nombre que vous entrez est une plage d'échelles. Par exemple, <b>-24,-12,0,6,12,24</b> affichera les plages suivantes : <b>en dessous de -24, de -24 à -12, de -12 à zéro, de zéro à 6, de 6 à 12, de 12  24, au-dessus de 24</b><br /><br />Vous pouvez faire de même pour le mois. Quand vous voulez représenter des trimestres vous devez entrer : <b>3,6,9,12</b>. Vous obtiendrez alors Q1, Q2, Q3, Q4 (Q signifie Quarter (trimestre) en anglais.<br /><br />La même chose est possible pour les semestres en entrant <b>6,12</b>";
$pgv_lang["stat_help_gwz"]              = "~Options pour les graphiques statistiques~<br /><br />~Échelles pour l'axe des Z~<br />Vous pouvez modifier les plages d'échelles. Soyez prudent lorsque vous effectuez des modifications ; aucune vérification de compatibilité n'est faite.<br /><br />Chaque nombre que vous entrez est une plage d'échelles. Par exemple, <b>1800,1900,1950</b> affichera les plages suivantes : <b>avant 1800, de 1800 à 1900, de 1900 à 1950, après 1950</b>";
//-- Find Media Help
$pgv_lang["manage_media_help"]          = "~#pgv_lang[manage_media]#~<br /><br />Sur cette page vous pouvez facilement gérer vos fichiers média et vos répertoires média.<br /><br />Quand vous créez un nouveau sous-répertoire média, PhpGedView s'assure que la structure des sous-répertoires est maintenue dans le répertoire <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs</b>.  Quand vous téléchargez un nouveau fichier média, PhpGedView peut automatiquement créer la vignette de l'image pour vous.<br /><br />Près de chaque image, dans la liste des média, vous trouverez les options suivantes. Les options actuellement affichées dépendent du statut en cours du média.<ul><li><b>#pgv_lang[edit]#</b>&nbsp;&nbsp;Quand vous validez cette option, vous verrez une page où vous pourrez changer le titre de l'objet média. Si l'objet média n'est pas encore lié à un individu, à une famille ou à une source dans la base de données courante, vous pouvez définir un lien ici.  Vous pouvez renommer le fichier ou même changer son emplacement grâce à la structure de répertoire <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Si nécessaire, PhpGedView crééra le sous-répertoire requis ou n'importe quelle vignette manquante.</li><li><b>#pgv_lang[edit_raw]#</b>&nbsp;&nbsp;Cette option est seulement disponible si l'administrateur l'a activé.  Vous pouvez voir ou éditer l'enregistrement GEDCOM associé au média. Vous devez être prudent quand vous utilisez cette option.</li><li><b>#pgv_lang[delete_file]#</b>&nbsp;&nbsp;Cette option vous permet d'effacer tous les média de la base de données courante. Les autres bases de données ne seront pas affectées. Si des fichiers média ne sont liés à aucune base de données, le fichier et sa vignette seront supprimés.</li><li><b>#pgv_lang[remove_object]#</b>&nbsp;&nbsp;Cette option vous permet de supprimer tous les fichiers média dans la base de données courante.  Les autres bases de données ne seront pas affectées. Les fichiers média, et les vignettes associées, ne seront pas supprimés.</li><li><b>#pgv_lang[remove_links]#</b>&nbsp;&nbsp;Cette option vous permet de supprimer tous les liens entre les fichiers média et la base de données courante.  Les fichiers ne seront pas supprimés, et les objets média connus dans la base de données seront maintenus. Les autres bases de données ne seront pas affectées.</li><li><b>#pgv_lang[set_link]#</b>&nbsp;&nbsp;Cette option vous permet d'établir des liens entre les fichiers média et les individus, familles, ou sources de la base de données courante. Si nécessaire, PhpGedView générera l'objet média par lequel le fichier média est connu dans la base de données.</li><li><b>#pgv_lang[gen_thumb]#</b>&nbsp;&nbsp;Quand vous sélectionnez cette option, PhpGedView générera les vignettes manquantes.</li></ul><br /><br />";
$pgv_lang["simple_filter_help"]         = "~#pgv_lang[filter]#~<br /><br />Recherche simple à partir des caractères saisis, aucun caractère de remplacement n'est accepté (troncature).<br /><br />";
$pgv_lang["show_thumb_help"]            = "~#pgv_lang[show_thumbnail]#~<br /><br />Les vignettes seront affichées si vous cochez cette case.<br /><br />";
$pgv_lang["new_dir_help"]               = "~#pgv_lang[add_directory]#~<br /><br />En tant qu'administrateur, vous pouvez créer les répertoires exigés pour organiser vos fichiers média. Créer des répertoires depuis cette page vous garantit que le répertoire des vignettes a été créé correctement et q'une page index.php est enregistrée dans chaque répertoire.<br /><br />Cliquez sur ce lien pour saisir le nom du répertoire que vous souhaitez créer.<br /><br />";
$pgv_lang["find_media_help"]            = "~#pgv_lang[find_media]#~<br /><br />Ceci vous permet de réaliser une recherche dans la structure des répertoires pour trouver le média que vous voulez lier.<br /><br />";
//-- Add / Edit Media Help
$pgv_lang["add_media_linkid"]           = "~ID de lien~<br /><br />Chaque objet Multimédia devrait être associé à un ou plusieurs individus, une famille ou une source d'informations dans votre base de données.<br /><br />Pour établir un tel lien, vous pouvez saisir ou rechercher l'ID de l'individu, de la famille ou de la source en même temps que vous créez l'objet Multimédia.  Vous pouvez également établir le lien plus tard en éditant les options sur la page de gestion des objets Multimédia, ou en ajoutant des objets Multimédia grâce au lien d'ajout d'un objet Multimédia, disponible sur les pages consacrées aux détails de l'individu, de la famille ou des sources.<br /><br />";
$pgv_lang["upload_server_file_help"]    = "~#pgv_lang[server_file]#~<br /><br />Le fichier Multimédia que vous avez téléchargé peut, et probablement devrait, porter un nom différent sur le serveur que celui qu'il portait sur votre ordinateur personnel. Ce changement de nom est conseillé car vous aviez donné un nom à votre fichier en local en fonction de vos besoins personnels (signification particulière du nom pour vous), alors qu'une fois enregistré sur le site, le nom du fichier aura perdu toute signification pour les autres utilisateurs de ce site.  Prenez en compte également la possibilité que quelqu'un tente de télécharger différents objets Multimédia tous nommés «grandpapa.jpg».<br /><br />Dans ce champ, vous spécifiez un nouveau nom pour le fichier que vous téléchargez. Le nom que vous saisissez ici sera également utilisé par la vignette, qui peut être téléchargée séparément ou générée automatiquement. Vous n'avez pas besoin de saisir l'extension du fichier (jpg, gif, pdf, doc, etc.)<br /><br />Laissez ce champ vide pour conserver le nom original du fichier que vous téléchargez.<br /><br />";
$pgv_lang["upload_server_folder_help"]  = "~#pgv_lang[server_folder]#~<br /><br />L'administrateur a autorisé #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveaux de répertoires en dessous du niveau par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Ceci pour vous aider à organiser vos fichiers Multimédia et réduire le risque de conflits de noms de fichiers.<br /><br />Dans ce champ, vous précisez le répertoire de destination où le fichier Multimédia sera enregistré. Le fichier vignette rattaché, qu'il soit téléchargé séparément ou généré automatiquement, sera enregistré dans un répertoire identique commençant par <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> au lieu de <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  Vous n'avez pas besoin de saisir le <b>#GLOBALS[MEDIA_DIRECTORY]#</b> partie du nom du répertoire de destination.<br /><br />Si vous n'êtes pas certain de ce que vous devez saisir ici, vous devez contacter l'administrateur du site pour conseil.<br /><br />";
$pgv_lang["view_server_folder_help"]    = "~#pgv_lang[server_folder]#~<br /><br />L'administrateur a autorisé jusqu'à #GLOBALS[MEDIA_DIRECTORY_LEVELS]# niveaux de répertoire en dessous du répertoire par défaut <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Cela vous facilite l'organisation des fichiers Multimédia et réduit la possibilité de conflits de noms.<br /><br />Dans ce champ, vous choisissez le répertoire des objets Multimédia dont vous voulez afficher le contenu.  Quand vous choisissez <b>#pgv_lang[all]#</b>, tous les fichiers Multimédia seront affichés automatiquement indépendamment du répertoire dans lequel ils se trouvent. Cela peut produire une liste très longue de fichiers Multimédia.<br /><br />";
//--Repository Help
$pgv_lang["help_repolist.php"]          = "~#pgv_lang[repo_list]#~<br /><br />Une liste de dépôts d'archives est affichée sur cette page.<br /><br />Les noms des dépôts d'archives sont classés par ordre alphabétique.<br /><br /><b>DÉPÔTS</b><br />Sans archives, nous ne pourrions construire cette base. Il existe une source pour chaque information enregistrée dans cette base. Un dépôt d'archives peut correspondre à des archives personnelles, familiales, aux archives notariales ou départementales, à celles de la mairie ou appartenir à une institution, une administration gouvernementale, une église, un site Internet, etc. Pour obtenir l'accès à une archive, en connaître son lieu de dépôt et ses références (cotes), les sources d'archives doivent être renseignées. Toutes les informations permettant d'identifier les sources d'archives doivent être enregistrées.<br /><br />Une source d'archives peut être liée à plusieurs individus.<br /><br />";
$pgv_lang["help_repo.php"]              = "~#pgv_lang[repo_info]#~<br /><br />Les détails de la source d'archives sont affichés ici. De la même manière que les sources, les dépôts d'archives sont très importants pour les généalogistes.  Grâce à une information précise sur la source et le dépôt d'archives utilisés, vous pouvez suivre pas à pas un autre généalogiste pour trouver ou contrôler les informations que vous cherchez. Vous devez être capable de retrouver les mêmes informations en utilisant à nouveau les mêmes sources.<br /><br />Sur cette page, sont affichées le titre du dépôt d'archives, son adresse, une adresse email et l'adresse Internet d'un site web.<br /><br />Après cette liste détaillée des informations sur le dépôt d'archives, est affichée une liste de toutes les sources liées à ce dépôt. Cette liste vous permet de prendre connaissance de toutes les informations ou archives utilisées à partir d'un centre d'archives.<br /><br />Si cette option a été active par l'administrateur, vous disposerez d'une ou de deux icônes supplémentaires sur cette page (menu) :<br /><b>#pgv_lang[view_gedcom]#</b>, qui affiche l'information dans le format GEDCOM.<br /><b>#pgv_lang[add_to_cart]#</b>, qui vous permet de stocker l'information dans votre #pgv_lang[clip_cart]#. À partir d'ici vous pouvez télécharger l'information dans un fichier au format GEDCOM et l'importer dans votre propre programme de généalogie.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_repo_help"]           = "~#pgv_lang[delete_repo]#~<br /><br />Quand vous cliquez sur cette option, vous indiquez que ce dépôt d'archives doit être supprimé de la base de données.<br /><br />Qu'est-ce que cela signifie ?<br />Supposons que vous avez de bonnes raisons de supprimer ce dépôt de la base de données. Vous cliquez sur le lien. Il vous sera demandé de confirmer votre demande de suppression. Si vous décidez de poursuivre, quelques instants seront nécessaires pour voir s'afficher un message vous informant que le dépôt a été supprimé.<br /><br />Si vous poursuivez la consultation du site, vous noterez que le dépôt est toujours visible et peut être utilisé comme s'il n'avait pas été supprimé.<br /><br /><b>ce n'est <u>pas une erreur</u>.</b>  L'administrateur du site recevra un message l'alertant que des modifications ont été réalisées dans la base de données, et que vous avez supprimé ce dépôt d'archives.<br />L'administrateur peut accepter ou rejeter vos modifications. Ce n'est qu'après que l'administrateur aura validé vos modifications, que le dépôt sera vraiment supprimé <u>de manière irréversible</u>. S'il a le moindre doute à propos de vos modifications, l'administrateur vous contactera.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]      = "~#pgv_lang[view_gedcom]#~<br /><br />Quand vous cliquez sur ce lien, les informations à propos du dépôt d'archives, telles qu'enregistrées dans la base de données, sont affichées dans une fenêtre popup.<br /><br />";
$pgv_lang["add_repository_clip_help"]   = "~#pgv_lang[add_to_cart]#~<br /><br />Quand vous cliquez sur ce lien, vous pouvez ajouter le dépôt d'archives, tel qu'il est enregistré dans le GEDCOM, à votre #pgv_lang[clip_cart]#.<br /><br />";
$pgv_lang["repolist_listbox_help"]      = "~#pgv_lang[repo_list]#~<br /><br />Dans cette case sont affichés les noms des dépôts d'archives tels qu'ils sont enregistrés dans la base de données.<br /><br />Les noms sont affichés dans l'ordre alphabétique.<br /><br />Si vous cliquez sur un nom dans la liste, la page #pgv_lang[repo_info]# sera affichée et vous pourrez y découvrir la liste des sources d'archives qui sont liées à ce dépôt.<br /><br />";
$pgv_lang["repos_listbox_help"]         = "~#pgv_lang[other_repo_records]#~<br /><br />Dans cette case, s'affichent les noms des sources qui sont liées à un dépôt d'archives.<br /><br />Les noms sont affichés par ordre alphabétique.<br /><br />Si vous cliquez sur un nom dans la liste, vous obtiendrez l'affichage des détails de la source.<br /><br />";
// Index-Edit
$pgv_lang["block_move_up_help"]         = "~Déplacer les entrées d'une liste~<br /><br />Utilisez ces boutons pour réorganiser l'ordre d'affichage des entrées dans la liste. Les listes seront imprimées dans l'ordre dans lequel elles sont affichées.<br /><br />Mettez en surbrillance (sélectionnez) l'entrée de la liste que vous souhaitez déplacer, puis cliquez sur l'un des boutons pour l'abaisser ou la remonter.<br /><br />";
$pgv_lang["block_move_right_help"]      = "~Déplacer les entrées d'une liste~<br /><br />Utilisez ces boutons pour déplacer une entrée d'une liste vers une autre.<br /><br />Mettez en surbrillance (sélectionnez) l'entrée à déplacer, puis cliquez sur le bouton pour déplacer ou copier cette entrée dans la direction de la flèche.  Utilisez les boutons <b>&raquo;</b> et <b>&laquo;</b> pour déplacer l'entrée en surbrillance de l'extrême gauche vers l'extrême droite de la liste ou vice-versa. Utilisez les boutons <b>&gt;</b> et <b>&lt;</b> pour déplacer l'entrée en surbrillance entre la liste #pgv_lang[available_blocks]# et la liste à sa droite ou à sa gauche.<br /><br />Les entrées dans la liste #pgv_lang[available_blocks]# ne changent pas, indépendamment de ce que vous faites avec les boutons #pgv_lang[move_right]# et #pgv_lang[move_left]#.  C'est pourquoi le même bloc peut apparaître plusieurs fois sur la même page. Le bloc HTML est un bon exemple du pourquoi d'une telle manipulation.<br /><br />";
$pgv_lang["block_default_index"]        = "Blocs par défaut de la page #pgv_lang[welcome]#~<br /><br />Quand vous supprimez toutes les entrées des listes #pgv_lang[main_section]# et #pgv_lang[right_section]#, ou quand vous cliquez sur le bouton <b>#pgv_lang[reset_default_blocks]#</b>, le bloc de listes sera organisé comme suit :<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span><br />";
$pgv_lang["block_default_portal"]       = "~Bloc par défaut de la page #pgv_lang[mygedview]#~<br /><br />Quand vous supprimez toutes les entrées depuis les listes #pgv_lang[main_section]# et #pgv_lang[right_section]#, ou quand vous cliquez sur le bouton <b>#pgv_lang[reset_default_blocks]#</b>, le bloc de listes sera organisé comme suit :<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span><br />";
// FAQ page
$pgv_lang["help_faq.php"]               = "~Questions Fréquemment Posées~<br />#pgv_lang[text_faq_help]#<br />";
$pgv_lang["text_faq_help"]              = "La page FAQ (Questions Fréquemment Posées) peut contenir une vue d'ensemble du site ou une liste de questions et de réponses sur son utilisation.<br /><br />Le mode d'utilisation de la page FAQ est du ressort de l'administrateur. L'administrateur du site en contrôle le contenu ainsi que l'organisation.";
// Help search
$pgv_lang["hs_title_help"]              = "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]                   = "Vous pouvez effectuer des recherches approfondies dans le système d'aide de PhpGedView.  Le dispositif #pgv_lang[hs_title]# vous permet un haut degré de contrôle sur les fonctions de recherche ; vous devriez pouvoir trouver ce que vous recherchez facilement.";
$pgv_lang["hs_keyword_advice"]          = "~#pgv_lang[hs_keyword]#~<br />Vous saisissez la phrase ou les mots que vous recherchez.<br /><br />Le système de recherche ne tient pas compte des minuscules et majuscules des termes saisis pour la recherche. Ce qui signifie que si vous avez entré <b>Individu</b>, vous pourrez trouver le texte contenant <b>Individu</b>, <b>individu</b>, ou <b>INDIVIDU</b>.  Vous pourrez obtenir également un résultat contenant <b>individus</b>, etc, étant donné que le mode de recherche s'attache à la recherche d'une chaine de caractères et non de mots.<br /><br />Vous pouvez rechercher plusieurs mots en même temps. Saisissez tous les mots sur lesquels porte votre recherche, séparés uniquement par un espace, comme ceci : <b>individu&nbsp;famille&nbsp;enfant</b>.  Quand plus d'un mot est saisi, la signification de ce que vous avez entré est clarifiée dans le champ #pgv_lang[hs_searchhow]#.<br />";
$pgv_lang["hs_searchin_advice"]         = "~#pgv_lang[hs_searchin]#~<br />Vous déterminez la portée de votre recherche ici.<br /><br />Les administrateurs ont le choix d'utiliser le mode de recherche utilisateur ou l'aide avancée ou les deux.  Les utilisateurs n'ont pas ce choix ; parce qu'ils n'ont aucun accès à la configuration du site, ils ne peuvent utiliser que le mode de recherche utilisateur (fichier d'aide aux utilisateurs).<br /><br />Les fichiers d'aide contiennent non seulement le texte d'aide mais également certains codes utilisés pour générer des formulaires ou d'autres contenus. Cette option vous permet de contrôler si le fichier d'aide peut être lu en entier ou si uniquement le texte d'aide devrait être analysé.<br />";
$pgv_lang["hs_searchhow_advice"]        = "~#pgv_lang[hs_searchhow]#~<br />Vous clarifiez le sens de ce que vous avez saisi dans le champ #pgv_lang[hs_keyword]# en sélectionnant l'une des possibilités (options) présentées ici.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Si vous avez saisi <b>individu&nbsp;famille&nbsp;enfant</b>, cette option trouvera le texte d'aide qui contient un des mots énumérés.  L'ordre des mots n'a pas d'importance. Le sens de la recherche est : «Trouvez le texte d'aide qui contient <b>individu</b> <u>ou</u> <b>famille</b> <u>ou</u> <b>enfant</b>».</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Si vous avez saisi <b>individu&nbsp;famille&nbsp;enfant</b>, cette option trouvera le texte d'aide qui contient tous les mots saisis.  L'ordre des mots n'a pas d'importance. Le sens de la recherche est : «Trouvez le texte d'aide contenant <b>individu</b> <u>et</u> <b>famille</b> <u>et</u> <b>enfant</b>».</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Si vous avez saisi <b>individu&nbsp;famille&nbsp;enfant</b>, cette option trouvera le texte d'aide contenant tous les mots saisis dans l'ordre indiqué.  Le sens de cette recherche est : «Trouvez le texte d'aide contenant les mots <b>individu&nbsp;famille&nbsp;enfant</b> dans cet ordre sans d'autres mots ou caractères entre».  Vous ne trouverez probablement pas cette suite de mots dans tout le texte d'aide.<br /><br />Il existe quelques limites à ce type de recherche. Certains caractères spéciaux comme <b>&quot; &lt; &gt;</b> etc. sont contenus dans le texte d'aide sous forme informatique et ne seront pas trouvés si ils font partie du texte que vous entrez.  Quelques textes d'aide contiennent un genre spécial de caractères représentés par <b>&amp;nbsp;</b> et vous ne pourrez pas trouver les phrases contenant ces caractères.</dd></dl>";
// Directory cleanup tool
$pgv_lang["help_dir_editor.php"]        = "~#pgv_lang[index_dir_cleanup]#~<br /><br />Cet outil peut aider l'administrateur du site à supprimer les fichiers qui sont présents dans le répertoire Index.<br /><br />Au fur et à mesure de l'utilisation du programme PhpGedView, des fichiers tels que les fichiers de logs, les anciens fichiers GEDCOM, et les anciens fichiers de sauvegarde viennent encombrer le répertoire index.  Puisque beaucoup de ces fichiers sont générés par le programme, ils peuvent être la propriété de l'utilisateur du serveur web. S'ils sont la propriété de l'utilisateur du serveur web, vous pouvez ne pas disposer des droits suffisants pour les supprimer. Cet outil vous permet de supprimer ces fichiers même s'ils sont la propriété de l'utilisateur du serveur web.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
?>
