<?php
/**
 * Dutch Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2010  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @package PhpGedView
 * @subpackage Languages
 * @authors Erik Bent, Jans B. Luder, Boudewijn Sjouke, Eduard Wustenveld
 * @version $Id: configure_help.nl.php 6979 2010-09-09 02:04:28Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["SHOW_LIST_PLACES"]				= "Toon Plaatsen nivo's op lijsten";
$pgv_lang["SHOW_LIST_PLACES_help"]			= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Hier bepaalt u hoeveel van de Plaatsen Informatie wordt getoond, in de Plaatsen velden, op lijsten.<br /><br />Indien de waarde op <b>9</b> wordt gezet, wordt alle Plaats Informatie getoond.<br />Als de waarde op <b>0</b> (nul) wordt gezet, worden Plaatsen geheel verborgen.<br />Ingesteld op <b>1</b>, wordt het bovenste nivo getoond. Dat is, normaal gesproken, het land.<br />Wordt hier <b>2</b> ingevuld, dan worden de twee hoogste nivo's getoond.  Het tweede nivo, onder het land, is meestal een provincie (NL), staat of territorium, enz.<br />";
                                    	
$pgv_lang["new_gedcom_title"]				= "Genealogie van [#GEDCOMFILE#]";
$pgv_lang["keep_media_help"]				= "~#pgv_lang[keep_media]#~<br /><br />Moeten bestaande media links in de database behouden blijven, als een vervangend GEDCOM bestand is ge-upload?<br />De optie <b>Nee</b> zal alle bestaande media links uit de database verwijderen. De optie <b>Ja</b> zal de bestaande links behouden.<br /><br />Deze optie is handig als u uw GEDCOM van PhpGedView naar een off-line GEDCOM onderhouds programma exporteert, dat niet goed de ingesloten media verwijzingen afhandelt, en dan later de gewijzigde GEDCOM weer in  PhpGedView importeert.  Onder zulke omstandigheden kunnen de media verwijzingen in de GEDOM, die u exporteerde naar uw off-line Gedcom programma, ontregeld raken of verdwijnen. U zou dan, na het opnieuw importeren van de GEDCOM in PhpGedView, alle media opnieuw moeten linken aan de juiste Personen, Gezinnen en Bronnen.<br /><br />De <b>Ja</b> optie vertelt PhpGedView om alle bestaande media links te behouden, zodat u deze niet opnieuw hoeft te maken na het her-importeren van de gewijzigde GEDCOM. Dit vereist wel dat u  de ID-nummers van Personen, Gezinnen en Bronnen <b>niet</b> mag wijzigen in het off-line programma! <br /><br /><i>Family Tree Maker</i> is een van de diverse off-line programma's dat <u>niet</u> goed kan omgaan met media object verwijzingen binnen de GEDCOM.  <i>Legacy</i>, onder vele anderen, gaat <u>wel</u> goed om met deze verwijzingen.<br />";
$pgv_lang["USE_MEDIA_VIEWER"]				= "Gebruik Media Viewer";
$pgv_lang["USE_MEDIA_VIEWER_help"]			= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Als de optie <b>#pgv_lang[yes]#</b> is gekozen, wordt de Media Viewer pagina geopend, als op een afbeelding wordt geklikt. Deze pagina toont dan details van de afbeelding. Als de gebruiker voldende rechten heeft, kan hij of zij dan ook de details wijzigen.<br /><br />Als de optie <b>#pgv_lang[no]#</b> wordt gekozen, wordt een volledig formaat afbeelding geopend in een nieuw venster.<br />";
$pgv_lang["USE_MEDIA_FIREWALL"]				= "Gebruik Media Firewall";
$pgv_lang["USE_MEDIA_FIREWALL_help"]		= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Hier kiest u  of u de Media Firewall wel of niet wilt gebruiken.<br /><br />Wilt u meer informatie kijk dan op de Wiki voor uitleg over de werking en het gebruik van de Media Firewall. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a><br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Media Firewall Start (root) map";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Map waarin de beveiligde Media mappen kunnen worden gemaakt. <br />#pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#<br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Als dit veld leeg blijft, zal de  <b>#GLOBALS[INDEX_DIRECTORY]#</b> map worden gebruikt.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Beveilig miniweergaves van Beveiligde Afbeeldingen";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]		= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Als een afbeelding in de beveiligde Media map is opgeslagen, moet dan de mini-weergave eveneens worden beveiligd?<br />";
$pgv_lang["SHOW_SPIDER_TAGLINE"]			= "Toon spider tagline";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />Op voor zoekmachines gegenereerde pagina's,  toon de naam v.d. zoekmachine die de pagina detecteerde.<br />Als deze optie aan staat,  kan het  Google&reg; AdSense voortrekken bij zoekmachine optimalisatie tools.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Met deze optie behoudt u de familie links in geprivatiseerde gegevens.<br />Dit betekent dat u lege \"privé\" vakken ziet in de Kwartierstaat en andere diagrammen met gegevens van privé personen.<br /><br />Dit is overeenkomstig het gedrag van PhpGedView versies van voor v4.0.<br /><br />Deze instelling staat standaard op <b>Nee</b>.<br />Het wordt aanbevolen om als Startpersoon van uw stamboom, iemand te kiezen, wiens gegevens niet (meer) privé zijn, i.p.v. deze optie op <b>Ja</b> te zetten.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]		= "Toon privé verwantschappen";
$pgv_lang["SYNC_GEDCOM_FILE_help"]			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />In eerdere versies van PGV werden de lopende wijzigingen opgeslagen in het GEDCOM bestand. De gewijzigde gegevens werden vervolgens  \"geaccepteerd\" in de database.<br /><br />Beginnend met v4.1 van PGV, werden lopende wijzigingen niet langer opgeslagen in het GEDCOM bestand, maar in het wijzigingen-bestand. <br /><br />Als hier de waarde op \"<b>Ja</b>\" wordt gezet, dan wordt het GEDCOM bestand bijgewerkt zodra de wijzigingen zijn geaccepteerd in de database. Op deze wijze blijft het GEDCOM bestand gesynchroniseerd met de database.<br />Voor betere compatibiliteit met eerdere versies is de standaard waarde voor dit veld <b>Ja</b>.<br /><br />U kunt dit uit zetten om geheugen te besparen, als u de wijzigingen accepteert.<br />";
$pgv_lang["SYNC_GEDCOM_FILE"]				= "Synchronseer wijzigingen naar GEDCOM bestand";
$pgv_lang["COMMIT_COMMAND_help"]			= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />U kunt een versiecontrolesysteem toepassen om wijzigingen te archiveren.<br /> Als u een versiecontrolesysteem, zoals CVS, wilt gebruiken om wijzigingen aan uw GEDCOM bestand en configuratie of privacy instellingen, vul dan hier het te gebruiken systeem in.<br />Laat de instelling op \"<b>Geen</b>\" als u dit systeem niet wilt gebruiken.<br /><br />Geldige opties zijn <b>CVS</b> en <b>SVN</b>.<br />";
$pgv_lang["COMMIT_COMMAND"]					= "Versie Controle Uitvoeren";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]		= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Multi-site Zoeken stelt gebruikers in staat om te zoeken op meerdere PhpGedView websites, die u heeft ingesteld in de \"Beheer Sites\" instellingen of waaraan u heeft gelinked (Linken aan andere sites).<br /><br />Met deze optie bepaalt u of  Multi-site Zoeken mogelijkheid beschikbaar is voor iedereen, of alleen voor bepaalde gebruikers.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]			= "Toon zoeken op Multi-Sites";
$pgv_lang["SHOW_NO_WATERMARK"]				= "Wie kan ongemerkte afbeeldingen bekijken?";
$pgv_lang["SHOW_NO_WATERMARK_help"]			= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Als de Media Firewall is ingeschakeld, zullen gebruikers afbeeldingen met watermerken zien, als deze gebruikers niet de rechten, die u hier kunt aangeven.<br />";
$pgv_lang["WATERMARK_THUMB"]				= "Watermerken toevoegen aan miniweergaves?";
$pgv_lang["WATERMARK_THUMB_help"]			= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Moeten mini weergave afbeeldingen worden voorzien van een watermerk, indien de Media Firewall is ingeschakeld? Uw media lijsten zullen sneller worden geladen, als u de miniweergaves niet voorsiet van watermerken.<br />";
$pgv_lang["SAVE_WATERMARK_THUMB"]			= "Miniweergaves met watermerk opslaan op server";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]		= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Moet een kopie van een mini weergave afbeelding, met watermerk, worden opgeslagen op de server, evenals dezefde afbeelding zonder watermerk, indien de Media Firewall is ingeschakeld?<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b> worden de, miniweergaves, met watermerk, sneller getoond. Dit gaat echter wel ten koste van meer schijf-ruimte op de server.<br />";
$pgv_lang["SAVE_WATERMARK_IMAGE"]			= " Volledige afbeeldingen met watermerk opslaan op server";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]		= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Moet een kopie van een full size afbeelding, met watermerk, worden opgeslagen op de server, evenals dezefde afbeelding zonder watermerk, indien de Media Firewall is ingeschakeld?<br /><br />Indien ingesteld op <b>#pgv_lang[yes]#</b> worden de, full-size afbeeldingen, met watermerk, sneller getoond. Dit gaat echter wel ten koste van meer schijf-ruimte op de server.<br />";
$pgv_lang["DB_UTF8_COLLATION"]				= "Gebruik database voor UTF-8 collatie";
$pgv_lang["DB_UTF8_COLLATION_help"]			= "~#pgv_lang[DB_UTF8_COLLATION]#~<br /><br />Hiermee bepaalt of PhpGedView de ingebouwde sorteer en collatie mogelijkheden van de databse moet gebruiken.<br /><br />Doorgaans is het sneller als de datbase wordt gebruikt, om gegevens te sorteren en te filteren, dan dit door PHP te laten uitvoeren.<br />Niet alle databases/versies bieden echter deze mogelijkheid.<br />De gebruikte collatie volgorde voor elke taal wordt ingesteld op de Taal Instellingen pagina.<br /><br /><span class=\"warning\">BELANGRIJK:<br />U mag deze instelling alleen op JA zetten als u dit doet VOORDAT de database tabellen voor de eerste keer worden samengesteld.<br />Het wijzigen van deze instelling bij een bestaande database, kan resulteren in beschadiging van uw gegevens.</span><br /><br />MySQL en PostgreSQL bieden goede ondersteuning voor UTF-8, hoewel niet alle collatie volgordes aanwezig zijn in eerdere versies van MySQL.<br />Andere databases bieden weinig, of geen, ondersteuning voor UTF-8.<br /><br />Als u niet zeker bent of uw database ondersteuning beidt voor UTF-8, stelt u hier de waarde in op <b>Nee</b>.<br /><br />Dit <a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia artikel'><b>Wikipedia artikel</b></a> bevat uitgebreide informatie en links over UTF-8.<br />";
$pgv_lang["INDI_FACTS_ADD"]					= "Feiten voor personen";
$pgv_lang["INDI_FACTS_ADD_help"]			= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Dit is de lijst met GEDCOM feiten, die uw gebruikers kunnen toevoegen aan personen.  U kunt deze lijst aanpassen door feiten, zelfs aangepaste, toe te voegen of te verwijderen.  Feiten, die in deze lijst voorkomen, mogen niet voorkomen in de <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> lijst.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"]				= "Unieke feiten voor personen";
$pgv_lang["INDI_FACTS_UNIQUE_help"]			= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Dit is de lijst met GEDCOM feiten, die uw gebruikers slechts <u>een keer</u> kunnen toevoegen aan personen.  <br />Bijvoorbeeld: als BIRT in de lijst voorkomt, kunnen gebruikers niet meer dan 1 BIRT kaart toevoegen aan een persoon.  Feiten, die in deze lijst voorkomen, mogen niet voorkomen in de <i>#pgv_lang[INDI_FACTS_ADD]#</i> lijst.<br />";
$pgv_lang["INDI_FACTS_QUICK"]				= "Snelinvoer Persoonlijke Feiten";
$pgv_lang["INDI_FACTS_QUICK_help"]			= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Dit de snelinvoerlijst van GEDCOM personen-feiten, die naast de volledige lijst wordt getoond. De feiten kunnen worden toegevoegd met 1 simpele klik..<br />";
$pgv_lang["FAM_FACTS_ADD"]					= "Feiten voor gezinnen";
$pgv_lang["FAM_FACTS_ADD_help"]				= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Dit is de lijst met GEDCOM feiten, die uw gebruikers kunnen toevoegen aan families.  U kunt deze lijst aanpassen door feiten, zelfs aangepaste, toe te voegen of te verwijderen.  Feiten, die in deze lijst voorkomen, mogen niet voorkomen in de  <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i> lijst.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"]				= "Unieke feiten voor gezinnen";
$pgv_lang["FAM_FACTS_UNIQUE_help"]			= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Dit is de lijst met GEDCOM feiten, die uw gebruikers slechts <u>een keer</u> kunnen toevoegen aan families.  <br />Bijvoorbeeld: als MARR in de lijst voorkomt, kunnen gebruikers niet meer dan 1 MARR kaart toevoegen aan een familie.  Feiten, die in deze lijst voorkomen, mogen niet voorkomen in de <i>#pgv_lang[FAM_FACTS_ADD]#</i> lijst.<br />";
$pgv_lang["FAM_FACTS_QUICK"]				= "Snelinvoer Gezins Feiten";
$pgv_lang["FAM_FACTS_QUICK_help"]			= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Dit de snelinvoerlijst van GEDCOM familie-feiten, die naast de volledige lijst wordt getoond. De feiten kunnen worden toegevoegd met 1 simpele klik..<br />";
$pgv_lang["SOUR_FACTS_ADD"]					= "Feiten van Bronnen";
$pgv_lang["SOUR_FACTS_ADD_help"]			= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Dit is de lijst met GEDCOM feiten, die uw gebruikers kunnen toevoegen aan bronnen. U kunt deze lijst aanpassen door feiten, zelfs aangepaste, toe te voegen of te verwijderen.  Feiten, die in deze lijst voorkomen, mogen niet voorkomen in de <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i> lijst.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"]				= "Unieke Feiten van Bronnen";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]			= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Dit is de lijst met GEDCOM feiten, die uw gebruikers slechts <u>een keer</u> kunnen toevoegen aan bronnen.  <br />Bijvoorbeeld: als TITL in de lijst voorkomt, kunnen gebruikers niet meer dan 1 TITL kaart toevoegen aan een bron.  Feiten, die in deze lijst voorkomen, mogen niet voorkomen in de <i>#pgv_lang[SOUR_FACTS_ADD]#</i> lijst.<br />";
$pgv_lang["SOUR_FACTS_QUICK"]				= "Snelinvoer Feiten van Bronnen";
$pgv_lang["SOUR_FACTS_QUICK_help"]			= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Dit de snelinvoerlijst van GEDCOM bronnen-feiten, die naast de volledige lijst wordt getoond. De feiten kunnen worden toegevoegd met 1 simpele klik..<br />";
$pgv_lang["REPO_FACTS_ADD"]					= "Feiten voor bewaarplaatsen";
$pgv_lang["REPO_FACTS_ADD_help"]			= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Dit is de lijst met GEDCOM feiten, die uw gebruikers kunnen toevoegen aan bewaarplaatsen.  U kunt deze lijst aanpassen door feiten, zelfs aangepaste, toe te voegen of te verwijderen.  Feiten, die in deze lijst voorkomen, mogen niet voorkomen in de <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i> lijst.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"]				= "Unieke feiten voor bewaarplaatsen";
$pgv_lang["REPO_FACTS_UNIQUE_help"]			= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Dit is de lijst met GEDCOM feiten, die uw gebruikers slechts <u>een keer</u> kunnen toevoegen aan bewaarplaatsen.  <br />Bijvoorbeeld: als NAME in de lijst voorkomt, kunnen gebruikers niet meer dan 1 NAME kaart toevoegen aan een bewaarplaats.  Feiten, die in deze lijst voorkomen, mogen niet voorkomen in de <i>#pgv_lang[REPO_FACTS_ADD]#</i> lijst.<br />";
$pgv_lang["REPO_FACTS_QUICK"]				= "Snelinvoer Feiten voor Bewaarplaatsen";
$pgv_lang["REPO_FACTS_QUICK_help"]			= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Dit de snelinvoerlijst van GEDCOM bewaarplaatsen-feiten, die naast de volledige lijst wordt getoond. De feiten kunnen worden toegevoegd met 1 simpele klik..<br />";
$pgv_lang["LANG_SELECTION_help"]			= "~#pgv_lang[LANG_SELECTION]#~<br /><br />U kunt de lijst,  met door uw PhpGedView site ondersteunde talen, wijzigen door hier vinkjes toe te voegen, of te verwijderen.<br />Dit wijzigt het aantal talen waaruit uw gebruikers of bezoekers kunnen kiezen.<br /><br />U kunt hetzelfde bereiken via de <b>#pgv_lang[enable_disable_lang]#</b> link in het #pgv_lang[admin]# menu.<br />Daar kunt u echter meer instellingen wijzigen, zoals de bij de taal behorende vlag,  het datum-formaat en of de achternaam altijd eerst moet worden getoond.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]				= "Voorvoegsel media-ID";
$pgv_lang["MEDIA_ID_PREFIX_help"]			= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Als een nieuw media item online wordt toegevoegd aan PhpGedView, wordt automatisch ook een nieuwe ID voor dat media bestand gemaakt.<br /><br />Het media ID zal het voorvoegsel krijgen dat u hier invult.<br />";
$pgv_lang["FAM_ID_PREFIX"]					= "Voorvoegsel gezins-ID";
$pgv_lang["FAM_ID_PREFIX_help"]				= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Als met behulp van PhpGedView een nieuwe familie wordt aangemaakt, wordt hiervoor automatisch een ID aangemaakt. Het familie-ID heeft het hier opgegeven voorvoegsel, gevolgd door een volgnummer.<br />";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]		= "Altijd deze feiten voor gezinnen tonen in \"Snel wijzigen\"";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]	= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Dit is een, door komma's gescheiden, lijst van GEDCOM feiten-tags, die altijd worden getoond op de Familie tabs van het Snel Wijzigen formulier, ongeacht of ze al dan niet bestaan in de gezins gegevens.  <br />Bijvoorbeeld: als MARR op de lijst voorkomt, worden velden voor huwelijks datum en -plaats altijd getoond op het formulier.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]				= "Deze feiten voor gezinnen tonen in \"Snel wijzigen\"";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Dit is een, door komma's gescheiden, lijst van GEDCOM feiten-tags, die wordt getoond on the Family tabs of the Snel Wijzigen formulier.<br /><br />Alleen de feiten in deze lijst worden getoond op het formulier, of beschikbaar worden gesteld voor selectie, in het gebied waar u nieuwe feiten op het formulier toevoegd.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Deze feiten altijd tonen in \"Snel Wijzigen\"";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Dit is een, door komma's gescheiden, lijst van GEDCOM feiten-tags, die altijd worden getoond op het Snel Wijzigen formulier, ongeacht of ze al dan niet bestaan in de persoons gegevens.  <br />Bijvoorbeeld: als BIRT op de lijst voorkomt, worden velden voor geboorte datum en -plaats altijd getoond op het formulier.<br />";
$pgv_lang["QUICK_ADD_FACTS"]				= "Deze feiten tonen in \"Snel wijzigen\"";
$pgv_lang["QUICK_ADD_FACTS_help"]			= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Dit is een, door komma's gescheiden, lijst van GEDCOM feiten-tags, die wordt getoond op het Snel Wijzigen formulier.<br /><br />Alleen de feiten in deze lijst worden getoond op het formulier, of beschikbaar worden gesteld voor selectie, in het gebied waar u nieuwe feiten op het formulier toevoegd.<br />";
$pgv_lang["SURNAME_TRADITION_help"]			= "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Als u nieuwe gezinsleden toevoegt, kan PhpGedView voorzien in standaard waardes voor achternamen. Deze standaard waardes zijn dan volgens regionaal gebruik.<br /><br /><ul><li>In de <b>Vaderlijke </b> traditie delen alle gezinsleden de achternaam van de vader.</li><li>In de <b>Spaanse</b> en <b>Portugese</b> traditie krijgen de kinderen een achternaam van elk van de ouders.</li><li>In de <b>IJslandise</b> traditie krijgen de kinderen de voornaam van de vader als achternaam, met daarbij nog een achtervoegsel dat het geslacht aanduidt.</li><li>In de <b>Poolse</b> traditie delen alle gezinsleden de achternaam van de vader. Bij sommige achternamen geeft een achtervoegsel het geslacht aan.  De achtervoegsels <i>ski</i>, <i>cki</i>, en <i>dzki</i> zijn mannelijk, terwijl de  corresponderende achtervoegsels <i>ska</i>, <i>cka</i>, en <i>dzka</i> vrouwelijk zijn.</li></ul><br />";
$pgv_lang["ADVANCED_NAME_FACTS_help"]		= "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Dit is een, door komma's gescheiden, lijst van GEDCOM feiten-tags, die wordt getoond op het Namen-toevoegen/wijzigen formulier.<br /><br />Als u gebruikt maakt van niet-Latijnse alfabets zoals Hebreeuws, Grieks, Cyrillisch of Arabisch, kunt u tags zoals _HEB, ROMN, FONE, enz. toevoegen, zodat u plaatsnamen in diverse verschillende alfabets kunt opslaan.<br />";
$pgv_lang["ADVANCED_PLAC_FACTS_help"]		= "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Dit is een, door komma's gescheiden, lijst van GEDCOM feiten-tags, die wordt getoond op het Plaatsnamen-toevoegen/wijzigen formulier.<br /><br />Als u gebruikt maakt van niet-Latijnse alfabets zoals Hebreeuws, Grieks, Cyrillisch of Arabisch, kunt u tags zoals _HEB, ROMN, FONE, enz. toevoegen, zodat u plaatsnamen in diverse verschillende alfabets kunt opslaan.<br />";
$pgv_lang["USE_GEONAMES"]					= "Gebruik GeoNames database";
$pgv_lang["USE_GEONAMES_help"]				= "~#pgv_lang[USE_GEONAMES]#~<br /><br />Moet de  GeoNames database worden gebruikt om meer suggesties voor plaatsnamen te tonen?<br /><br />Als deze optie op <b>#pgv_lang[yes]#</b> is gezet, wordt de GeoNames database doorzocht om suggesties te kunnen geven als een plaatsnaam wordt ingevuld.<br />Als deze optie op <b>#pgv_lang[no]#</b> is gezet, wordt alleen de huidige genealogische database doorzocht.  Als er meer letters van de plaatsnaam worden ingevuld, wordt de suggestie nauwkeuriger.<br />Deze optie kan wel de gegevensinvoer vertragen, vooral bij een tragere Internet verbinding.<br /><br />De GeoNames geografische database is gratis toegankelijk. Het beavt momenteel meer dan 8.000.000 geografische namen.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Miniweergaves automatisch maken";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Kiest u voor <b>Ja</b> als u wilt dat de miniweergavebestanden automatich door het programma worden gemaakt.Kiest u voor <b>Nee</b>, dan gebeurt dat uiteraard niet automatisch.<br /><br />Mocht het niet lukken om automatisch miniweergave bestanden te laten maken, zou dat aan uw PHP installatie kunnen liggen.<br />";
$pgv_lang["phpinfo_help"]					= "~#pgv_lang[phpinfo]#~<br /><br />De PHP info pagina toont zeer uitgebreide informatie over de server, waarop uw  PhpGedView wordt gehost.<br /><br />Veel details over de instellingen van de server's software, speciaal in relatie tot PHP en PhpGedView, kan hier worden bekeken.<br />";
$pgv_lang["config_help_help"]				= "~#pgv_lang[config_help]#~<br /><br />Op deze pagina zijn alle belangrijke onderwerpen van de Configuratie Help verzameld.<br />U kunt de informatie op uw scherm bekijken, maar natuurlijk ook afdrukken voor eventueel later gebruik.<br />";
$pgv_lang["more_help_advice"]				= "<br /><b>Meer Help</b><br />Meer help is beschikbaar door op de  <b>?</b>,  naast de  items op de pagina, te klikken.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]				= "Breedte van gegenereerde miniweergaves";
$pgv_lang["THUMBNAIL_WIDTH_help"]			= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Dit is de breedte (in pixels) die PhpGedView gebruikt voor automatisch gegenereerde miniweergaves. De standaard waarde is 100 pixels.<br /><br />";
$pgv_lang["USE_SILHOUETTE"]					= "Gebruik silhouetten";
$pgv_lang["USE_SILHOUETTE_help"]			= "~#pgv_lang[USE_SILHOUETTE]#~<br /><br />Gebruik silhouet beelden wanneer er geen afbeelding voor die persoon is gespecificeerd.  De silhouetten zijn specifiek voor het geslacht van de persoon.<br /><br /><table><tr><td wrap valign=\"middle\">Dit beeld word gebruikt bij het geslacht onbekend is: </td><td><img src=\"images/silhouette_unknown.gif\" width=\"40\" alt=\"Silhouette image\" title=\"Silhouette image\" /></td></tr></table><br />";
$pgv_lang["SHOW_SOURCES"]					= "Toon bronnen";
$pgv_lang["SHOW_SOURCES_help"]				= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Dit stelt privacybeperking in op alle bronnen. Als de gebruiker geen toegang heeft tot bronnen, wordt de bronnen-tab op de personen-pagina verwijderd en wordt de optie \"Bronnen\" in het menu \"Detailgegevens\" verborgen.<br /><br />";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"] = "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Als de optie \"#pgv_lang[USE_REGISTRATION_MODULE]#\" is aangezet, moeten nieuwe aanmeldingen voor een gebruikersnaam door een beheerder worden goedgekeurd. De gebruiker moet hier, na de eigen verificatie van de gegevens, op wachten.<br />Als deze optie wordt uitgezet, wordt de aanmelding na verificatie door de gebruiker automatisch goedgekeurd, en kunnen de gebruikers direct toegang krijgen met hun gebruikersnaam en wachtwoord.";
$pgv_lang["SPLIT_PLACES"]					= "Locaties splitsen bij wijzigen";
$pgv_lang["SPLIT_PLACES_help"]				= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Deze optie zorgt ervoor dat locaties worden opgesplitst in delen (plaats, gemeente, provincie/staat, land), om het wijzigen ervan makkelijker te maken.<br />Voorbeeld<br /><ol><li>Standaard:<br /><u>Locatie</u>: Sloten, Amsterdam, Noord Holland, Nederland<br /></li><li>Gesplitst:<br /><u>Land</u>: Nederland<br /><u>Provincie</u>: Noord Holland<br /><u>Gemeente</u>: Amsterdam<br /><u>Plaats</u>: Sloten</li></ol><br /><br />";
$pgv_lang["UNDERLINE_NAME_QUOTES"]			= "Namen tussen aanhalingstekens onderstrepen";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]		= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Veel genealogieprogramma's geven de voorkeurs-voornaam in het bestand aan door deze tussen dubbele aanhalingstekens te plaatsen. Hierdoor wordt deze onderstreept weergegeven. Het inschakelen van deze optie zorgt ervoor, dat alle namen waar omheen dubbele aanhalingstekens staan worden omgezet naar \"span\" met een CSS class \"starredname\".<br /><br />Als bijvoorbeeld in het bestand een regel voorkomt als 1 NAME Jan \"Nicolaas\" Pieter/de Groot/, dan wordt dit omgezet naar Jan <span class=\"starredname\">Nicolaas</span> Pieter de Groot.";
$pgv_lang["PRIVACY_BY_RESN"]				= "Gebruik GEDCOM (RESN) toegangsbeperking";
$pgv_lang["PRIVACY_BY_RESN_help"]			= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />In de GEDCOM 5.5 standaard is opgenomen, dat de toegang tot informatie kan worden beperkt door RESN (restriction) tags. Als deze optie wordt aangezet, kijkt PhpGedView naar 1 RESN tags. Als deze aanwezig is, betekent het dat de toegang tot een niveau 0 object (persoon, gezin) is beperkt.<br /><br />RESN tags op niveau 2 en hoger (feiten, gebeurtenissen) worden automatisch verwerkt door PhpGedView en worden dus niet benvloed door deze optie.<br /><br />Let op: aanzetten van deze optie kan tot vertraging leiden van sommige functies van PhpGedView, zoals de personenlijst.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]				= "Toon codes HLD-gebeurtenissen in overzichtsvakken";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]		= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Als deze optie is ingeschakeld, worden de codes voor HLD-gebeurtenissen getoond in de overzichtsvakken van personen.<ul><li><b>B</b> - HLD Doop</li><li><b>E</b> - HLD Gave</li><li><b>S</b> - HLD ega verzegeling</li><li><b>P</b> - HLD kind verzegeling</li></ul>Een persoon waarbij al deze gebeurtenissen hebben plaatsgevonden, heeft \"<b>BESP</b>\" afgedrukt achter de naam. Als een van de gebeurtenissen ontbreekt, wordt de code getoond als bijvoorbeeld \"<b>BE__</b>\" met _ voor de ontbrekende gebeurtenis.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]				= "Standaard tabblad op persoonspagina";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]		= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Met deze optie kunt u instellen welk tabblad standaard wordt getoond op de persoonspagina.";
$pgv_lang["SHOW_MARRIED_NAMES"]				= "Toon huwelijkse namen in personenlijst";
$pgv_lang["SHOW_MARRIED_NAMES_help"]		= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Met deze optie worden de huwelijkse namen van vrouwen getoond in de personenlijst. Uiteraard moeten deze bij het importeren van het GEDCOM-bestand wel zijn vervaardigd.";
$pgv_lang["SHOW_QUICK_RESN"]				= "Toon vak Beperking in Snel toevoegen/wijzigen";
$pgv_lang["SHOW_QUICK_RESN_help"]			= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Hiermee kunt u aangeven, of in het formulier \"Snel toevoegen/wijzigen\" voor feiten een instelling voor beperking van toegang wordt getoond. De gebruiker kan hierdoor de toegang tot de door hem ingebrachte gegevens zelf instellen als extra bovenop bestaande algemene privacy instellingen.";
$pgv_lang["USE_QUICK_UPDATE"]				= "Gebruik #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]			= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Deze optie stelt aangemelde gebruikers in staat om wijzigingen aan te brengen middels het formulier \"Snel toevoegen/wijzigen\".";
$pgv_lang["SEARCHLOG_CREATE"]				= "Archiveer logbestand zoeken";
$pgv_lang["SEARCHLOG_CREATE_help"]			= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Hiermee stelt u in, hoe vaak het logbestand voor zoekacties wordt gearchiveerd.";
$pgv_lang["CHANGELOG_CREATE"]				= "Archiveer logbestand wijzigingen";
$pgv_lang["CHANGELOG_CREATE_help"]			= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Hoe vaak moet het programma de  Changelog bestanden archiveren?<br />";
$pgv_lang["CHART_BOX_TAGS"]					= "Andere feiten in overzichten";
$pgv_lang["CHART_BOX_TAGS_help"]			= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Voer hier de GEDCOM-tags in van feiten die u in overzichten (zoals de kwartierstaat) extra in de vakken wilt laten zien. Als u bijvoorbeeld het beroep wilt toevoegen, kunt u hier \"OCCU\" invullen.";
$pgv_lang["FULL_SOURCES"]					= "Gebruik volledige bronvermeldingen";
$pgv_lang["FULL_SOURCES_help"]				= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Bron vermeldingen kunnen velden voor gegevens bevatten, zoals gegevens over de kwaliteit van de vermelding (primair, secundair, enz.) en de datum dat de gebeurtenis was vastgele.<br />Als u deze velden niet gebruikt, kunt u deze uitschakelen als u een nieuwe bronvermelding maakt.<br />";
$pgv_lang["PREFER_LEVEL2_SOURCES"]			= "Soort Bron";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Als u nieuwe Verwanten toevoegt, kunt u bronvermeldingen aan de gegevens toevoegen (bijv. INDI, FAM) of de feiten (BIRT, MARR, DEAT).<br />Met deze optie  bepaalt u welke checkboxen standaard zijn aangevinkt.<br />";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]					= "Basisinstellingen";
$pgv_lang["media_conf"]						= "Multimedia";
$pgv_lang["media_general_conf"]				= "Algemeen";
$pgv_lang["media_firewall_conf"]			= "Media Firewall";
$pgv_lang["accpriv_conf"]					= "Toegang en privacy";
$pgv_lang["displ_conf"]						= "Tonen en opmaak";
$pgv_lang["displ_names_conf"]				= "Namen";
$pgv_lang["displ_comsurn_conf"]				= "Meest voorkomende achternamen";
$pgv_lang["displ_layout_conf"]				= "Opmaak";
$pgv_lang["displ_hide_conf"]				= "Tonen & verbergen";
$pgv_lang["editopt_conf"]					= "Opties voor wijzigen";
$pgv_lang["useropt_conf"]					= "Opties voor gebruikers";
$pgv_lang["contact_conf"]					= "Contactinformatie";
$pgv_lang["meta_conf"]						= "Website en META-tags";
$pgv_lang["gedconf_head"]					= "GEDCOM-instellingen";
$pgv_lang["other_theme"]					= "Ander, typ in";
$pgv_lang["performing_update"]				= "Update uitvoeren.";
$pgv_lang["config_file_read"]				= "Lezen instellingenbestand.";
$pgv_lang["does_not_exist"]					= "bestaat niet";
$pgv_lang["media_drive_letter"]				= "In het pad naar de multimediamap kan geen driveletter worden opgenomen. Een foutief multimediapad leidt ertoe, dat multimedia-items niet worden weergegeven.";
$pgv_lang["db_setup_bad"]					= "De huidige databaseconfiguratie is corrupt. Controleer de database-verbindingsparameters en configureer opnieuw.";
$pgv_lang["bad_host_user_pass"]				= "PhpGedView kan geen verbinding maken met uw SQL databaseserver. Controleer de naam van de SQL database machine, de SQL database gebruikersnaam en het SQL database wachtwoord. ";
$pgv_lang["bad_database_name"]				= "PhpGedView kan verbinding maken met de SQL database machine, maar krijgt geen toegang tot de opgegeven database. Controleer de databasenaam, de gebruikersnaam en de toegekende rechten.";
$pgv_lang["db"]								= "Database";
$pgv_lang["current_gedcoms"]				= "Huidige GEDCOM-bestanden";
$pgv_lang["ged_gedcom"]						= "GEDCOM-bestand";
$pgv_lang["ged_title"]						= "GEDCOM-titel";
$pgv_lang["ged_config"]						= "Instellingenbestand";
$pgv_lang["ged_search"]						= "Logbestand Zoeken";
$pgv_lang["ged_change"]						= "ChangeLog bestanden";
$pgv_lang["ged_privacy"]					= "Privacybestand";
$pgv_lang["disabled"]						= "Uitgeschakeld";
$pgv_lang["mouseover"]						= "Door muisaanwijzer erover";
$pgv_lang["mousedown"]						= "Door muisknop ingedrukt";
$pgv_lang["click"]							= "Door muisklik";
$pgv_lang["enter_db_pass"]					= "Om beveiligingsredenen moet u de database gebruikersnaam en het database wachtwoord opnieuw invoeren bij het wijzigen van de configuratie.";
$pgv_lang["server_url_note"]				= "Dit behoort de URL naar uw PhpGedView-map te zijn. Wijzig deze waarde alleen als u de consequenties overziet. PhpGedView heeft de SERVER_URL samengesteld als #GUESS_URL#.";

$pgv_lang["DBTYPE"]							= "Type database";
$pgv_lang["DBTYPE_help"]					= "~#pgv_lang[DBTYPE]#~<br /><br />Het type PEAR ondersteunende database om verbinding mee te maken. De mogelijkheden zijn: MySQL, PostgreSQL en SQLite. De eerste twee hebben extra bibliotheken van PHP nodig. SQLite wordt standaard met PHP5 meegeleverd.<br />Als u SQLite gebruikt, hoeven database machine, database gebruikersnaam en database wachtwoord niet ingevuld te worden. In plaats daarvan vult u in het vak \"Databasenaam\" het pad en de naam van de database in.";
$pgv_lang["DBHOST"]							= "Database-machine";
$pgv_lang["DBHOST_help"]					= "~#pgv_lang[DBHOST]#~<br /><br />De DNS-naam of het IP-adres van the computer waar de database staat.<br />Als zowel PHP als de database op dezelfde machine staan, volstaat localhost.  Deze instelling wordt niet gebruikt als u een SQLite database heeft ingesteld.";
$pgv_lang["DBPORT"]							= "Database Poort";
$pgv_lang["DBPORT_help"]					= "~#pgv_lang[DBPORT]#~<br /><br />Dst is de TCP Poort, die moet worden gebruikt om een verbinding met uw database server tot stand te brengen.<br /><br />Vul niets bij deze instelling in om de standaard poort, voor uw type database, te gebruiken.<br />Deze instelling wordt genegeerd als u een SQLite database gebruikt.<br />";
$pgv_lang["DBUSER"]							= "Database-gebruikersnaam";
$pgv_lang["DBUSER_help"]					= "~#pgv_lang[DBUSER]#~<br /><br />De database gebruikersnaam die nodig is om in te loggen op de database. Deze instelling wordt niet gebruikt als u een SQLite database heeft ingesteld.";
$pgv_lang["DBPASS"]							= "Database-wachtwoord";
$pgv_lang["DBPASS_help"]					= "~#pgv_lang[DBPASS]#~<br /><br />Het database wachtwoord van de gebruiker. Deze instelling wordt niet gebruikt als u een SQLite database heeft ingesteld.";
$pgv_lang["DBNAME"]							= "Databasenaam";
$pgv_lang["DBNAME_help"]					= "~#pgv_lang[DBNAME]#~<br /><br />De database in de machine die PhpGedView moet gebruiken. De gebruikersnaam in het gebruikersveld moet create, insert, update, delete, en select privilege op deze database hebben.<br />Voor SQLite dient u een bestandsnaam aan te geven in een map die schrijfbaar is voor PhpGedView. Voorbeeld: index/phpgedview.db.";
$pgv_lang["TBLPREFIX_help"]					= "~#pgv_lang[TBLPREFIX]#~<br /><br />Een voorvoegsel voor de SQL tabellen die gemaakt zijn door PhpGedView. Door het veranderen van deze waarde kunt u meerdere PhpGedView sites gebruik laten maken van dezelfde database maar met verschillende tabellen.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]		= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Als u deze optie op \"Ja\" zet, kunnen gebruikers wisselen van GEDCOM-bestand. Dit is alleen mogelijk als op uw site meerdere GEDCOM-bestanden aanwezig zijn.";
$pgv_lang["upload_path"]					= "Upload pad";
$pgv_lang["upload_path_help"]				= "~#pgv_lang[upload_path]#~<br /><br />Dit is het pad ( op de lokale computer) waar het GEDCOM bestand, dat u wilt uploaden, kan worden gevonden.<br />Om het pad te selecteren, klik op <b>Bladeren</b> en navigeer naar uw GEDCOM bestand en klik op  <b>Openen</b>.";
$pgv_lang["gedcom_path"]					= "Map en naam GEDCOM-bestand";
$pgv_lang["gedcom_path_help"]				= "~#pgv_lang[gedcom_path]#~<br /><br />Upload eerst uw GEDCOM-bestand naar een locatie op de server die door PHP bereikt kan worden. Voer dan het pad naar dat bestand en de bestandsnaam hier in.<br /><br />Voorbeeld: ./index/myged.ged<br /><br />Zie het <a href=\"readme.txt\">readme.txt</a> bestand voor meer uitleg.";
$pgv_lang["CHARACTER_SET"]					= "Karakterset codering";
$pgv_lang["CHARACTER_SET_help"]				= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Dit is de karakterset van uw GEDCOM-bestand. UTF-8 is de standaard en moet voor bijna alle sites werken. Als het GEDCOM-bestand de IBM-Windowscodering gebruikt dan moet u hier WINDOWS neerzetten.<br /><br />N.B.: PHP ondersteunt geen UNICODE (UTF-16); zet dat er dus niet en om vervolgens te gaan klagen bij de PHP ondersteuners :-)";
$pgv_lang["LANGUAGE"]						= "Taal";
$pgv_lang["LANGUAGE_help"]					= "~#pgv_lang[LANGUAGE]#~<br /><br />Stelt de standaardtaal in voor de website. Gebruikers hebben de mogelijkheid om deze instelling aan te passen via de browserinstellingen of via het keuzeveld op het scherm, indien ENABLE_MULTI_LANGUAGE = true.<br /><br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]			= "Laat de gebruiker de taal wijzigen";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"]		= "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Zet dit op \"Ja\" om de gebruikers de mogelijkheid te geven een andere taal te kiezen via het keuzevak op het scherm. De standaard is de taalinstelling van de browser.<br /><br />";
$pgv_lang["CALENDAR_FORMAT"]				= "Kalenderformaat";
$pgv_lang["CALENDAR_FORMAT_help"]			= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Hiermee specificeert u het type kalender, dat u wilt gebruiken met dit GEDCOM-bestand.<br />Hebreeuws is hetzelfde als de Joodse kalender, maar dan met Hebreeuwse karakters. Let op: de Joods/Hebreeuwse datums worden berekend met behulp van Gregoriaanse/Juliaanse datums. Omdat de Joodse kalender bij zonsondergang start, wordt bij gebeurtenissen die plaatsvinden tussen zonsondergang en middernacht een datum weergegeven die een dag eerder ligt dan de juiste Joodse datum. Verder kan weergave van Hebreeuws een probleem zijn voor oude Internet Verkenners. Ze tonen het Hebreeuws achterstevoren of geheel niet.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]		= "Geef Joodse duizendtallen weer";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Toon Alafim in Joodse kalenders. \"JA\" geeft het jaar 1969 weer als <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; , \"NEE\" als <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Dit beïnvloedt de waarde van het Joodse jaar niet, deze blijft ongewijzigd 5729 ongeacht deze instelling.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Toon Joods Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Toon dubbele en enkele aanhalingstekens bij het weergeven van Joodse datums. Deze waarde op JA toont de datum van 8 februari 1969 als <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; deze waarde op NEE toont het als <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dit heeft geen invloed op het Joodse jaartal, omdat aanhalingstekens in Joodse datums worden weergegeven met de Latin karakterset.<br />Let op: Deze waarde is gelijk aan de PHP 5.0 kalender constanten CAL_JEWISH_ADD_ALAFIM_GERESH en CAL_JEWISH_ADD_GERESHAYIM. Deze waarde beïnvloedt beide.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]	= "Joods Ashkenazi woordgebruik";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Kies Joods Ashkenazi woordgebruik.<br /> Bij \"JA\" worden de maanden Cheshvan en Teves gespeld met Ashkenazi woordgebruik. Bij \"NEE\" blijven deze ongewijzigd.<br />Dit heeft alleen effect op de Joodse instelling. Indien ingesteld op Hebreeuws, wordt het Hebreeuwse alfabet gebruikt.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]	= "Generaties kwartierstaat";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] = "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Stelt het aantal generaties dat standaard afgebeeld moet worden in de kwartierstaat.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Max. aantal generaties kwartierstaat";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Stelt het maximum aantal generaties in, dat in de kwartierstaat wordt getoond.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]	= "Max. aantal generaties nakomelingen";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"] = "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Stelt het maximum aantal generaties in, dat in het nakomelingen diagram wordt getoond.";
$pgv_lang["USE_RIN"]						= "Gebruik RIN in plaats van GEDCOM-ID";
$pgv_lang["USE_RIN_help"]					= "~#pgv_lang[USE_RIN]#~<br /><br />Kies \"Ja\" om RIN-nrs. te gebruiken in plaats van GEDCOM-ID's. Deze worden gebruikt in configuratiebestanden, gebruikersinstellingen en overzichten. Dit is nuttig voor genealogieprogramma's, die geen bijbehorende ID's exporteren maar altijd dezelfde RIN gebruiken.";
$pgv_lang["GENERATE_GUID"]					= "Maak automatisch globaal unieke IDs";
$pgv_lang["GENERATE_GUID_help"]				= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> is in deze context een afkorting voor «Globaal Unieke ID».<br /><br />GUID's zijn bedoeld om elke individu te helpen identificeren, op een herhaalbare wijze. Zodoende kunnen centrale organisaties zoals bijv. de \"Family History Center of the LDS Church in Salt Lake City\", of zelfs compatible programma's op uw eigen server, bepalen of ze met dezelfde persoon hebben te maken, ongeacht waar de GEDCOM oorspronkelijk vandaan komt.<br /><br />Het doel van de Family History Center is een gecentraliseerde bewaarplaats te hebben voor genealogische gegevens en via web diensten deze weer ter beschikking te stellen. Dit stelt elk programma in staat toegang te krijgen tot de gegevens en hun eigen gegevens bij te werken.<br /><br />Als het niet uw bedoeling is om uw GEDCOM met anderen te delen, hoeft u PhpGedView niet deze GUID's te laten maken; het kan echter ook geen kwaad om het wel te doen. Het kan hooguit gebeuren dat de omvang van uw GEDCOM een weinig toeneemt door deze nummers.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"]				= "Beginpersoon kwartierstaat en nakomelingen";
$pgv_lang["PEDIGREE_ROOT_ID_help"]			= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Stelt het ID van de beginpersoon in voor kwartierstaat en nakomelingenoverzicht.";
$pgv_lang["GEDCOM_ID_PREFIX"]				= "Voorvoegsel GEDCOM-ID";
$pgv_lang["GEDCOM_ID_PREFIX_help"]			= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Bij weergave van de kwartierstaat, nakomelingen, verwantschap en andere weergaven wordt gebruikers gevraagd een ID in te voeren. Als hierbij geen voorvoegsel wordt ingevoerd, wordt deze toegevoegd.";
$pgv_lang["SOURCE_ID_PREFIX"]				= "Voorvoegsel bron-ID";
$pgv_lang["SOURCE_ID_PREFIX_help"]			= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Als met behulp van PhpGedView een nieuwe bron wordt aangemaakt, wordt hiervoor automatisch een ID aangemaakt. Het bron-ID heeft het hier opgegeven voorvoegsel, gevolgd door een volgnummer.";
$pgv_lang["REPO_ID_PREFIX"]					= "Voorvoegsel bewaarplaats-ID";
$pgv_lang["REPO_ID_PREFIX_help"]			= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Als met behulp van PhpGedView een nieuwe bewaarplaats wordt aangemaakt, wordt hiervoor automatisch een ID aangemaakt. Het bewaarplaats-ID heeft het hier opgegeven voorvoegsel, gevolgd door een volgnummer.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]			= "Laat geboorte- en overlijdensgegevens zien in kwartierstaat en nakomelingenoverzicht";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] 	= "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Geeft aan of de geboorte- en overlijdensgegevens van een persoon zichtbaar worden.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]			= "Toon geslacht's ikoon op diagrammen";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]		= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Met deze optie bepaalt u of op de diagrammen een ikoontje voor het geslacht wordt getoond bij de personen.<br /><br />Omdat het geslacht van een persoon eveneens wordt aangegeven door de kleur van het personen-vak, verbergt het ontbreken van dat ikoontje het geslacht niet. De optie verwijdert enkel wat dubbele informatie uit het vak.<br />";
$pgv_lang["PEDIGREE_LAYOUT"]				= "Standaard opmaak kwartierstaat";
$pgv_lang["PEDIGREE_LAYOUT_help"]			= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Geeft aan of de kwartierstaat staand of liggend moet worden weergegeven.";
$pgv_lang["SHOW_EMPTY_BOXES"]				= "Toon lege vakken in de kwartierstaat";
$pgv_lang["SHOW_EMPTY_BOXES_help"]			= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Kies hier, of lege vakken worden getoond in de kwartierstaat.";
$pgv_lang["ZOOM_BOXES"]						= "Inzoomen op vakken in de weergave";
$pgv_lang["ZOOM_BOXES_help"]				= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Geeft een gebruiker de mogelijkheid om in te zoomen op de vakken en zodoende meer informatie te tonen. \"Uitschakelen\" zet deze functie uit, \"Door muisaanwijzer erover\" activeert de functie wanneer de muisaanwijzer op het scherm op het icoon komt, \"Door muisknop ingedrukt\" activeert de zoomfunctie, zolang de knop blijft ingedrukt, \"Door muisklik\" wordt de functie afwisselend aan en uit geschakeld.";
$pgv_lang["LINK_ICONS"]						= "Popup met koppelingen in weergaven";
$pgv_lang["LINK_ICONS_help"]				= "~#pgv_lang[LINK_ICONS]#~<br /><br />Geeft een gebruiker de mogelijkheid om door te springen naar andere weergaven en verwanten van de persoon. \"Uitschakelen\" zet deze functie uit, \"Door muisaanwijzer erover\" activeert de functie wanneer het pijltje op het scherm op het icoon komt, \"Door muisknop ingedrukt\" activeert de functie, zolang de knop blijft ingedrukt, \"Door muisklik\" wordt de functie afwisselend aan en uit geschakeld.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]		= "Afgekorte veldtitels";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]	= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Geeft aan of titels bij gegevens worden afgekort: \"G\" in plaats van \"Geboren\".";
$pgv_lang["SHOW_AGE_DIFF"]					= "Toon datum verschillen";
$pgv_lang["SHOW_AGE_DIFF_help"]				= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Met deze optie bepaalt u of op het Verwanten tabblad de datumverschillen toont tussen de geboortedatums van partners, tussen de huwelijksdatum en geboortedatum v.h. eerste kind, en tussen de geboortedata van de kinderen.<br />";
$pgv_lang["SHOW_PARENTS_AGE"]				= "Toon leeftijd ouders bij geboortedatum kind";
$pgv_lang["SHOW_PARENTS_AGE_help"]			= "~TOON LEEFTIJD OUDERS BIJ GEBOORTEDATUM KIND~<br /><br />Hiermee wordt het tonen van de leeftijd van de ouders bij de geboorte van het kind al dan niet ingeschakeld.<br /><br />";
$pgv_lang["SHOW_RELATIVES_EVENTS"]			= "Toon gebeurtenissen van verwanten op Persoons pagina";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"]		= "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Geboortes, huwelijken en het overlijden van verwanten zijn belangrijke gebeurtenissen in een ieders leven. Met deze optie bepaalt u of deze gebeurtenissen wel of niet worden getoond op het <i>Persoonlijke feiten en details</i> tabblad op de Personen pagina.<br /><br />De gebeurtenissen, waarop deze optie betrekking heeft, zijn:<ul><li>Overlijden van de partner</li><li>Geboortes en overlijden van kinderen</li><li>Overlijden van ouders</li><li>Geboortes en overlijden van broers en zussen</li><li>Overlijden van grootouders</li><li>Geboortes en overlijden van broers en zussen van ouders</li></ul><br />";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]		= "Automatisch uitbreiden van gebeurtenissenlijst van verwanten";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"]	= "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Met deze optie bepaalt u of de <i>#pgv_lang[relatives_events]#</i> lijst automatisch wordt uitgebreid.<br />";
$pgv_lang["EXPAND_SOURCES"]					= "Automatisch uitbreiden van  bronnen";
$pgv_lang["EXPAND_SOURCES_help"]			= "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Met deze optie bepaalt u of automatisch gegevens van een <i>Bron</i> worden getoond op de Persoons pagina.<br />";
$pgv_lang["EXPAND_NOTES"]					= "Automatisch uitbreiden van  notities";
$pgv_lang["EXPAND_NOTES_help"]				= "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Met deze optie bepaalt u of automatisch de inhoud van een <i>Notitie</i> wordt getoond op de  Persoons pagina.<br />";
$pgv_lang["SHOW_LEVEL2_NOTES"]				= "Toon alle referenties naar Notities en Bronnen op betreffende tabbladen";
$pgv_lang["SHOW_LEVEL2_NOTES_help"]			= "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Met deze optie bepaalt u of referenties naar Notities en Bronnen, die zijn verbonden aan Feiten, moeten worden getoond, op de Notities- en Bronnen- tabs, op de Personen pagina.<br /><br />Normaal gesproken worden op de Notities- en Bronnen- tabs alleen de referenties getoond, die direct aan de persoonlijke gegevens zijn verbonden. Dat zijn <i>Nivo 1</i> Notities- en Bronnen- referenties.<br /><br />Als voor de optie <b>Ja</b> wordt gekozen, worden op deze tabs eveneens Notities- en Bronnen- referenties getoond, die deel uitmaken van diverse Feiten van de persoonlijke gegevens.<br />Dit zijn <i>Nivo 2</i> Notities-  en Bronnen- referenties, omdat de verschillende Feiten van Nivo 1 zijn.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"]				= "Gebruik privacyinstellingen";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]			= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Met deze optie kunt u de privacymodule inschakelen en de details van levende personen verbergen. Levende personen hebben geen gebeurtenis die meer dan het aantal jaren, zoals gedefinieerd in de variabele \$MAX_ALIVE_AGE geleden gebeurd zijn en geen kinderen geboren zijn.<br />In de privacymodule kunt u de privacyinstellingen verder bewerken.";
$pgv_lang["REQUIRE_AUTHENTICATION"]			= "Vereis bezoekersauthenticatie";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Door deze optie in te schakelen worden alle bezoekers in te loggen, voordat ze gegevens op de site kunnen bekijken.";
$pgv_lang["PAGE_AFTER_LOGIN"]				= "Te tonen pagina na inloggen";
$pgv_lang["PAGE_AFTER_LOGIN_help"]			= "~#pgv_lang[PAGE_AFTER_LOGIN]#~<br /><br />Welke pagina wordt getoond aan de gebruikers, nadat ze zich hebben aangemeld?<br /><br />De keuze, die hier wordt gemaakt, bepaalt of een bezoeker naar de #pgv_lang[welcome_page]# gaat of naar MyGedView, nadat hij of zij zich heeft aangemeld vanaf de #pgv_lang[welcome_page]#.<br /><br />Als een gebruiker zich aanmeld, nadat hij op de aanmeld-link in de header van een bepaalde pagina heeft geklikt, zal die gebruiker na het aanmelden naar die pagina terug gaan.<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]			= "Welkomsttekst op de aanmeldpagina.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Kies hier de tekst, die op het aanmeldscherm verschijnt in geval bezoekers zich moeten aanmelden bij deze site (authenticatie vereist).<br />U kunt uitproberen welke standaard tekst op uw situatie van toepassing is.<br />U kunt er ook voor kiezen, om zelf een tekst in te voeren in het onderstaande vak.<br /><br />Let op: deze tekst wordt niet vertaald in de taal van uw gebruikers.U kunt echter wel een referentie aanbrengen naar een taalvariabele, die u heeft gemaakt in de verschillende <i>languages/extra.xx.php</i> bestanden. U kunt dan toch een vertaalde tekst tonen.<br />Kijk ook eens bij de Help tekst, behoeren bij het <b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#</b> veld, voor meer informatie.<br /><br />De voorgedefinieerde teksten zijn:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Geen voorgedefinieerde tekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Voorgedefinieerde tekst: Alle bezoekers kunnen een gebruikersnaam aanvragen";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Voorgedefinieerde tekst: De sitebeheerder is selectief toekennen van toegangsrechten";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Voorgedefinieerde tekst: Alleen familieleden kunnen een gebruikersnaam aanvragen";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Kies zelf gedefinieerde tekst hieronder";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Zelf gedefinieerde Welkomtekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Als u heeft gekozen om een zelf gedefinieerde tekst te tonen op het aanmeldscherm, dan kunt u hier de desbetreffende tekst intypen.<br />Let op: de tekst wordt weergegeven zoals u die intypt en wordt dus NIET vertaald in de taal van de bezoekers. U kunt echter wel een referentie aanbrengen naar een taalvariabele, die u heeft gemaakt in de verschillende <i>languages/extra.xx.php</i> bestanden. U kunt dan toch een vertaalde tekst tonen.<br /><br />Als u wilt, kunt u in de tekst HTML-tekens gebruiken voor opmaak.<br /><br />De volgende tekst, die is genomen uit de helpteksten voor de VGV lijst, is ook op die manier toepasbaar voor een zelfgedfinieerde Welkomtekst.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standaard koptekst voor zelf gedefinieerde Welkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Kies deze optie om, aan uw eigen welkomsttekst bij \"aanmelden vereist\", een standaard koptekst vanuit PhpGedView toe te voegen.<br />Als uw gebruikers een andere taal kiezen, zal deze header in de nieuwe taal worden getoond.<br /><br />Als u kiest voor <b>Yes</b>, zal de header er als volgt uitzien:<div class=\"list_value_wrap\">#pgv_lang[welcome_text_cust_head]#</div>";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Toon Accepteer Gebruikersovereenkomst op de «Aanvraag  nieuw gebruikers account» pagina";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Als deze optie op <b>#pgv_lang[yes]#</b> is gezet, zal de volgende boodschap worden getoond, boven de invulvakjes op de  «#pgv_lang[requestaccount]#» pagina:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"]				= "Controleer datums van de kinderen";
$pgv_lang["CHECK_CHILD_DATES_help"]			= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Controleer de datums van de kinderen om te bepalen of een persoon overleden is. Op oudere systemen en bij grote GEDCOM-bestanden verlaagt dit de response tijd van uw website.";
$pgv_lang["MAX_ALIVE_AGE"]					= "Leeftijd waarboven iemand geacht wordt overleden te zijn";
$pgv_lang["MAX_ALIVE_AGE_help"]				= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />De maximum leeftijd die een persoon kan hebben of de maximum leeftijd van hun kinderen om te bepalen waarneer iemand overleden is of niet.";
$pgv_lang["SHOW_GEDCOM_RECORD"]				= "Sta toe dat gebruikers de GEDCOM-regels zien";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]		= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Door deze optie op 'ja' te zetten worden er, bij personen, gezinnen en bronnen, koppelingen geplaatst die gebruikers een nieuw venster geven met de gegevens uit het GEDCOM-bestand.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]				= "Sta wijzigen toe";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]			= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Stelt functionaliteit ter beschikking om in de toepassing gegevens te wijzigen. De desbetreffende gebruikers moeten hier dan nog expliciet voor worden geautoriseerd.";
$pgv_lang["ENABLE_AUTOCOMPLETE"]			= "Auto-aanvullen inschakelen";
$pgv_lang["ENABLE_AUTOCOMPLETE_help"]		= "~#pgv_lang[ENABLE_AUTOCOMPLETE]#~<br /><br />Met deze optie bepaalt u of het Automatisch aanvullen actief is, als informatie wordt ingevoerd in bepaalde velden op bepaalde invul-formulieren.<br />Als deze optie op <b>#pgv_lang[yes]#</b> is ingesteld, worden tekst invoervelden, waarvoor Auto-aanvullen is ingeschakeld, aangegeven door een afwijkende achtergrondkleur van die velden.<br /><br />Als het Automatisch aanvullen actief is, zal PhpGedView in de database zoeken naar mogelijke overeenkomstige gegevens, aan de hand van wat reeds is ingevuld.  Als meer informatie wordt ingevuld, wordt de lijst met mogelijke overeenkomsten nauwkeuriger.  Als u de gewenste gegevens ziet in de lijst met overeenkomstige gegevens, kunt u op die regel in de lijst klikken, om de gegevens over te nemen.<br /><br />Nadelen van Auto-aanvullen zijn dat de uitvoering van het programma kan worden vertraagd, meer databasebewerkingen moeten worden uitgevoerd en meer gegevens naar de browser moeten worden verzonden.<br />Het beste kunt u zelf eens uitproberen of deze nadelen opwegen tot de voordelen.<br />";
$pgv_lang["EDIT_AUTOCLOSE"]					= "Wijzigen-venster Automatich sluiten";
$pgv_lang["EDIT_AUTOCLOSE_help"]			= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Met deze optie bepaalt u of het wijzigen venster automatisch wordt gesloten na het bijwerken.<br />";
$pgv_lang["INDEX_DIRECTORY_help"]			= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Het pad naar een lees- en schrijfbare map waar PhpGedView de indexbestanden moet opslaan (inclusief de \"/\" aan het eind).";
$pgv_lang["POSTAL_CODE"]					= "Positie postcode";
$pgv_lang["POSTAL_CODE_help"]				= "~#pgv_lang[POSTAL_CODE]#~<br /><br />Verschillende landen gebruiken andere manieren om de adressen te schrijven.<br /><br />Met deze optie kunt u instellen of de postcodes voor of achter de plaatsnamen wordt getoond.<br />";
$pgv_lang["SUBLIST_TRIGGER_I"]				= "Maximum aantal achternamen";
$pgv_lang["SUBLIST_TRIGGER_I_help"]			= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Lange lijsten van personen met de zelfde achternaam, kunnen worden verdeeld in kleinere deel-lijsten volgens de 1ste letter van de voornaam.<br /><br />Met deze optie bepaalt u vanaf welke aantallen deel-lijsten van personen zullen worden gemaakt.<br /><br />Zet deze optie op nul, om deel-lijsten helemaal uit te schakelen.<br />";
$pgv_lang["SUBLIST_TRIGGER_F"]				= "Maximum aantal familie namen";
$pgv_lang["SUBLIST_TRIGGER_F_help"]			= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Lange lijsten van families met de zelfde naam, kunnen worden verdeeld in kleinere deel-lijsten volgens de 1ste letter van de voornaam.<br /><br />Met deze optie bepaalt u vanaf welke aantallen deel-lijsten van familienamen zullen worden gemaakt.<br /><br />Zet deze optie op nul, om deel-lijsten helemaal uit te schakelen.<br />";
$pgv_lang["SURNAME_LIST_STYLE"]				= "Stijl van Achternamen-lijst";
$pgv_lang["SURNAME_LIST_STYLE_help"]		= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Lijsten met achternamen, zoals ze voorkomen in het #pgv_lang[block_top10]# blok, de #pgv_lang[individual_list]#- en de #pgv_lang[family_list]# lijst, kunnen op verschillende manieren worden getoond.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;In deze stijl worden de achternamen getoond in een tabel. De namen kunnen worden gesorteerd op achternaam of op aantal.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;In deze stijl worden de achternamen getoond in een lijst. De lettergrootte die voor elke naam wordt gebruikt is afhankelijk van het aantal keren dat de naam voorkomt in de database.  De lijst is niet sorteerbaar.</li></ul><br />";
$pgv_lang["SHOW_ID_NUMBERS_help"]			= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Toon ID-nummers tussen haakjes achter de persoonsnaam in de vakken.";
$pgv_lang["SHOW_LAST_CHANGE"]				= "Toon laatste datum van wijziging GEDCOM record";
$pgv_lang["SHOW_LAST_CHANGE_help"]			= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Met deze optie bepaalt u of de datum, van de laatste wijziging van GEDCOM gegevens, wel of niet op lijsten wordt getoond.<br />";
$pgv_lang["SHOW_EST_LIST_DATES"]			= "Toon geschatte datums voor geboorte en dood";
$pgv_lang["SHOW_EST_LIST_DATES_help"]		= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Met deze optie bepaalt u of geschatte datums van geboorte en overlijden worden getoond, i.p.v. het niet tonen ervan. Dit geldt voor personen lijsten en diagrammmen, bij personen waarvan deze data niet bekend zijn.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"]			= "Toon plaatsen in persoonsvakken";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]		= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Stelt in, hoeveel niveaus van plaatsinformatie worden weergegeven bij geboorte- en overlijdensdata in de kwartierstaat- en nakomelingendiagrammen. De waarde 9 laat alle niveaus zien, de waarde 0 geen enkele. De waarde 1 toont alleen het eerste niveau, 2 ook het tweede, etc.";
$pgv_lang["MULTI_MEDIA"]					= "Multimedia mogelijkheden aanzetten";
$pgv_lang["MULTI_MEDIA_help"]				= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5 bevat de mogelijkheid om afbeeldingen, video's en andere multimedia-objecten op te nemen in het GEDCOM-bestand. Als u geen multimedia-objecten in uw GEDCOM-bestand heeft dan kunt u deze optie op 'Nee' zetten om de multimediamogelijkheden uit te zetten.<br />Zie de multimediaparagraaf het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie over het opnemen van media in uw website.";
$pgv_lang["MEDIA_EXTERNAL"]					= "Behoudt koppelingen";
$pgv_lang["MEDIA_EXTERNAL_help"]			= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Als een multimedia-item wordt gevonden waarvan de naam start met bijvoorbeeld http://, ftp:// of mms://, wordt de naam ongewijzigd gelaten als deze optie aan staat. Bijvoorbeeld: http://www.mijnfamilie.nl/foto/vader.jpg blijft http://www.mijnfamilie.nl/foto/vader.jpg. Als de optie uit staat, wordt de naam behandeld als standaardverwijzing en wordt het aantal niveaus van de multimediamappen toegepast. Bijvoorbeeld: http://www.mijnfamilie.nl/foto/vader.jpg wordt ./media/vader.jpg.";
$pgv_lang["MEDIA_DIRECTORY"]				= "Multimediamappen";
$pgv_lang["MEDIA_DIRECTORY_help"]			= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Het pad naar de map waar PhpGedView de lokale mediagegevens ophaalt (met de laatste \"/\" achter de padnaam).<br />Het pad moet een relatief pad zijn binnen de PGV website, bijvoorbeeld: ./media/<br />Ook een URL naar een website kan als pad NIET worden gebruikt, aangezien dit niet in alle gevallen werkt.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]			= "Aantal niveaus van de Multimediamappen";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Een waarde van 0 zal alle mappen overslaan in het pad van het media object. Een waarde van 1 zal ook de eerste map van het object gebruiken. Door het verhogen van het getal wordt het aantal niveaus van mappen verhoogd dat gebruikt wordt.<br />Bijvoorbeeld: als er een koppeling naar het object staat met het pad C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg dan zal een waarde van 0 vertaald worden in het pad ./media/grandpa.jpg. Een waarde van 1 zal vertaald worden naar ./media/Surname Line/grandpa.jpg, enz. De meeste mensen zullen met een 0 kunnen volstaan. Let op: het is mogelijk dat sommige media objecten met dezelfde naam elkaar overschrijven. Dit maakt het mogelijk om enige structuur aan te brengen in de media map en voorkomt het voorkomen van dubbele namen.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"]		= "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Als de multimedia mogelijkheden op uw site zijn ingeschakeld, dan kunt u PhpGedView een mini-afbeelding, in overzichten en vakjes, laten tonen naast de naam van de persoon.  Op dit moment gebruikt PhpGedView het eerste multimedia-object, genoemd in de GEDCOM-gegevens van de persoon, als de voorkeursafbeelding.  Voor personen met meerdere afbeeldingen zou u de multimedia objecten zodanig moeten indelen, dat de afbeelding die u wilt tonen, vooraan in de lijst staat.<br />Bekijk ook de multimediasectie in het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie over het gebruik van media op uw site.";
$pgv_lang["USE_THUMBS_MAIN"]				= "Gebruik miniweergaven";
$pgv_lang["USE_THUMBS_MAIN_help"]			= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Afhankelijk van de omvang van de afbeeldingen kan het beter zijn om in plaats van de afbeeldingen de miniatuurweergaven te gebruiken naast de naam van de persoon. Als de afbeeldingen erg groot zijn, kan de tijd die nodig is voor het opbouwen van de pagina erg lang worden. Let er wel op dat uw miniatuurweergaven van voldoende kwaliteit zijn.<br /><br />Zet deze waarde op \"Ja\" om miniatuurweergaven te gebruiken en \"Nee\" om de oorspronkelijke afbeeldingen te gebruiken.";
$pgv_lang["SHOW_MEDIA_FILENAME"]			= "Toon bestandsnaam in Media Viewer";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]		= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />De Media Viewer kan de naam tonen van het Media bestand dat wordt bekeken.<br />Deze optie bepaalt of die naam aan de gebruikers wordt getoond, of juist niet.<br /><br />(Mogelijk wilt u de bestandsnamen verbergen, vanwege de beveiling.)<br />";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]			= "Toon download link in Media Viewer";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]		= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />De Media Viewer kan een link tonen, waarmee een Media bestand kan worden gedownload naar een lokale PC, als op die link wordt geklikt.<br /><br />(Mogelijk wilt u de bestandsnamen verbergen, vanwege de beveiling.)<br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"]			= "Knipselbak aanzetten";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"]		= "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />De knipselbak maakt het voor bezoekers mogelijk om informatie toe te voegen aan een GEDCOM-knipselbestand.<br />De bezoeker kan dit bestand downloaden als een GEDCOM-bestand en in zijn of haar genealogiesoftware inlezen.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]				= "Verberg GEDCOM-fouten";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]		= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Door deze optie op 'Ja' te zetten worden fouten niet getoond als PhpGedView een GEDCOM-code tegenkomt die het niet herkent. PhpGedView voldoet aan de GEDCOM 5.5 standaard, maar veel genealogieprogramma's bevatten aangepaste of eigen codes. Zie het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie.";
$pgv_lang["WORD_WRAPPED_NOTES"]				= "Toevoegen spaties als notities zijn afgebroken";
$pgv_lang["WORD_WRAPPED_NOTES_help"]		= "~#pgv_lang[WORD_WRAPPED_NOTES]#~<br /><br />Sommige genealogie programma's breken opmerkingen af op woorden terwijl andere de opmerkingen op een willekeurige plek afbreken. Hierdoor is het mogelijk dat PhpGedView woorden aan elkaar plakt. Door dit op 'Ja' te zetten wordt er een spatie tussen woorden gezet.";
$pgv_lang["SHOW_CONTEXT_HELP"]				= "Toon <b>?</b> helpkoppelingen op de pagina's";
$pgv_lang["SHOW_CONTEXT_HELP_help"]			= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Door middel van deze optie kunt op de pagina's vraagtekens weergeven naast de verschillende koppelingen en velden. Bezoekers kunnen hierop klikken en krijgen dan informatie over het desbetreffende item.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]				= "Binnenkort.... blok dagen limiet";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"]		= "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Vul het  maximaal aantal te tonen dagen in voor de Binnenkort.... blokken.<br />Dit getal mag niet groter zijn dan 30. Indien toch een groter getal wordt ingevuld, dan wordt 30 dagen aangehouden.<br /><br />De waarde, die u hier ingeeft, bepaalt hoever PhpGedView vooruit kijkt met het zoeken naar gegevens voor het Binnenkort ... blok.  De resultaten van deze zoekactie, die een keer per dag wordt uitgevoerd, wordt opgeslagen in een tijdelijk bestand.<br /><br />Geen Binnenkort... blok, op de Index- of Portaal- pagina's kunnen meer dagen dan deze waarde aanvragen.  Des te groter u dit getal maakt, des te langer het duurt om het dagelijkse database-uittreksel te maken. Ook de tijd om dit blok tonen is afhankelijk van de grootte van dit getal, zelfs als u aangeeft om minder dagen te tonen dan hier is ingesteld.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]			= "Minimum aantal voor \"Meest voorkomende achternamen\"";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Dit is het aantal malen dat een achternaam moet voorkomen in de genealogie, voordat hij verschijnt in de \"Meest voorkomende achternamen\" op de Welkomstpagina.";
$pgv_lang["COMMON_NAMES_ADD"]				= "Namen om toe te voegen aan \"Meest voorkomende achternamen\"";
$pgv_lang["COMMON_NAMES_ADD_help"]			= "~#pgv_lang[COMMON_NAMES_ADD]#~~<br /><br />Als het aantal malen dat een achternaam in de genealogie voorkomt lager is dan de drempelwaarde, zal de naam niet in de lijst met Meest voorkomende achternamen verschijnen. De achternaam kan dan hier handmatig worden toegevoegd. Als er meer namen worden opgegeven, moeten ze met een komma worden gescheiden.<br />Let op: de opgegeven namen zijn hoofdlettergevoelig!";
$pgv_lang["COMMON_NAMES_REMOVE"]			= "Namen om te verwijderen uit Meest voorkomende achternamen (komma gescheiden)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]		= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Als u een achternaam wilt verwijderen uit de Meest voorkomende achternamen, zonder de drempelwaarde daarvoor te verhogen, kunt u de naam hier invoeren. Als er meer namen worden opgegeven, moeten ze met een komma worden gescheiden.<br />Let op: de opgegeven namen zijn hoofdlettergevoelig!";
$pgv_lang["HOME_SITE_URL"]					= "Website-URL";
$pgv_lang["HOME_SITE_URL_help"]				= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Het adres dat in de standaard themabestanden zorgt voor een koppeling naar uw website.";
$pgv_lang["HOME_SITE_TEXT"]					= "Website-tekst";
$pgv_lang["HOME_SITE_TEXT_help"]			= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />De tekst die gebruikt wordt voor de koppeling naar uw website.";
$pgv_lang["CONTACT_EMAIL"]					= "E-mail genealogische vragen";
$pgv_lang["CONTACT_EMAIL_help"]				= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Het e-mailadres dat gebruikt moet worden als er vragen zijn over de genealogische gegevens op deze website.";
$pgv_lang["CONTACT_METHOD"]					= "Verzendwijze genealogische vragen";
$pgv_lang["CONTACT_METHOD_help"]			= "#pgv_lang[CONTACT_METHOD]#~<br /><br />De methode die bezoekers zullen gebruiken om contact op te nemen met de contactpersoon voor genealogische vragen.<br />De 'mailto' optie zal een 'mailto' koppeling toevoegen, waarop de bezoekers kunnen klikken om u een e-mail te sturen, d.m.v. hun eigen mailprogramma.<br />De 'berichten' optie zal het ingebouwde PhpGedView berichtensysteem gebruiken en er worden geen e-mails verzonden.<br />De 'berichten met e-mails' optie is de standaardoptie en zal het PhpGedView berichtensysteem gebruiken, maar zal eveneens een kopie van de berichten per e-mail verzenden.<br />De optie 'E-mails zonder opslag' zorgt ervoor, dat berichten weliswaar per e-mail worden verzonden, maar dat ze niet in PhpGedView worden opgeslagen.<br />Als u de optie voor 'geen berichten' kiest, zal er geen mogelijkheid zijn voor de bezoekers om contact met u op te nemen.";
$pgv_lang["PHPGEDVIEW_EMAIL"]				= "PhpGedView antwoord adres";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]			= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Het emailadres dat wordt gebruikt in het &laquo;Van:&raquo;  (afzender) veld, van emails die automatisch door PhpGedView worden gemaakt.<br /><br />PhpGedView kan automatisch emails maken om beheerders te waarschuwen dat aangebrachte wijzigingen moeten worden beoordeeld.  PhpGedView stuurt ook emails met informatie aan bezoekers, die een gebruikers account hebben aangevraagd.<br /><br />Meestal bevat het &laquo;Van:&raquo; veld iets zoals  <i>Van: phpgedview-noreply@yoursite</i> om te tonen dat geen antwoord email nodig is.<br /><br />Om spam, of ander email-misbruik tegen te gaan verlangen sommige email-systemen dat een geldig emailadres in het &laquo;Van:&raquo; veld wordt ingevuld als bewijs dat een geldig email account wordt gebruikt. Soms worden emails van <i>phpgedview-noreply</i> geweigerd.<br />";
$pgv_lang["WEBMASTER_EMAIL"]				= "E-mail Sitebeheerder";
$pgv_lang["WEBMASTER_EMAIL_help"]			= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Het e-mail adres dat gebruikt moet worden als er vragen zijn over de techniek of als er fouten worden gevonden op de website.";
$pgv_lang["SUPPORT_METHOD"]					= "Verzendwijze ondersteuningsvragen";
$pgv_lang["SUPPORT_METHOD_help"]			= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />De methode die bezoekers zullen gebruiken om contact op te nemen met de Sitebeheerder.   <br />De 'mailto' optie zal een 'mailto' koppeling toevoegen, waarop de bezoekers kunnen klikken om u een e-mail te sturen, d.m.v. hun eigen mailprogramma.  <br />De 'berichten' optie zal het ingebouwde PhpGedView berichtensysteem gebruiken en er worden geen e-mails verzonden.  <br />De 'berichten met e-mails' optie is de standaardoptie en zal het PhpGedView berichtensysteem gebruiken, maar zal eveneens een kopie van de berichten per e-mail verzenden.  <br />De optie 'E-mails zonder opslag' zorgt ervoor, dat berichten weliswaar per e-mail worden verzonden, maar dat ze niet in PhpGedView worden opgeslagen.<br />Als u de optie voor 'geen berichten' kiest, zal er geen mogelijkheid zijn voor de bezoekers om contact met u op te nemen.";
$pgv_lang["SHOW_FACT_ICONS"]				= "Toon Feiten ikoontjes";
$pgv_lang["SHOW_FACT_ICONS_help"]			= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Stel dit in op <b>#pgv_lang[yes]#</b> om ikoontjes te tonen naast de namen van Feiten op de #pgv_lang[personal_facts]# pagina.<br />Ikoontjes voor Feiten kunnen alleen worden getoond als deze ikoontjes bestaan in de <i>images/facts</i> map  van het gebruikte thema.<br />";
$pgv_lang["FAVICON"]						= "Favorieten icoon";
$pgv_lang["FAVICON_help"]					= "~#pgv_lang[FAVICON]#~<br /><br />Wijzig dit in het icoon dat getoond moet worden in de favorieten als mensen de website markeren.";
$pgv_lang["THEME_DIR"]						= "Themamap";
$pgv_lang["THEME_DIR_help"]					= "~#pgv_lang[THEME_DIR]#~<br /><br />De map waar de PhpGedView thema bestanden staan. U kunt elk standaard thema aanpassen die met PhpGedView worden meegeleverd om uw website op een unieke manier te tonen.<br /> Zie de paragraaf over thema-aanpassing in het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie.";
$pgv_lang["TIME_LIMIT"]						= "PHP tijdslimiet";
$pgv_lang["TIME_LIMIT_help"]				= "~#pgv_lang[TIME_LIMIT]#~<br /><br />De maximale tijd in seconden dat PhpGedView mag draaien. De standaard tijd is één minuut. Afhankelijk van de omvang van het GEDCOM-bestand is het mogelijk dat deze waarde verhoogt moet worden tijdens het opbouwen van de indexen. Met de waarde 0 mag PHP altijd blijven draaien.<br />OPGELET: door deze waarde op 0 te zetten of een andere hoge waarde is het mogelijk dat de website blijft hangen op bepaalde bewerkingen zolang het script draait. Door de waarde op 0 te zetten is het mogelijk dat het script nooit gestopt wordt behalve als het door de server beheerder wordt gestopt of de machine herstart. Een grote genealogietabel kan zeer lang draaien; door deze waarde zo laag mogelijk te houden wordt voorkomen dat iemand de webserver kan laten stoppen door een 1000 generatie lijst op te vragen.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"]		= "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />De map, waarin de PhpGedView sessiebestanden worden opgeslagen. Op sommige computers is PHP niet goed ingesteld en worden sessiegegevens niet bewaard tijdens schermwisselingen. Door deze instelling is het mogelijk om zelf te bepalen in welke map deze bestanden worden opgeslagen. De ./INDEX/ map is een goede keuze als aanpassing nodig is. Als deze waarde leeg wordt gelaten, wordt de map gebruikt die in het php.ini bestand is aangegeven.";
$pgv_lang["SERVER_URL_help"]				= "~PhpGedView-URL~<br /><br />Type hier de URL van uw server, als u https of een andere dan de standaardpoort gebruikt.";
$pgv_lang["LOGIN_URL"]						= "URL voor aanmelden";
$pgv_lang["LOGIN_URL_help"]					= "~#pgv_lang[LOGIN_URL]#~<br /><br />De URL voor aanmelden vult u alleen in, als u een andere site of locatie wilt opgeven waar uw gebruikers zich moeten aanmelden. Dit is bijvoorbeeld nuttig voor het geval u om wilt schakelen naar https voor aanmelden. De volledige URL naar het login.php-bestand dient hier ingevoerd te worden, bijv. https://www.mijnserver.nl/phpgedview/login.php.";
$pgv_lang["PGV_SESSION_TIME_help"]			= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />De tijd in seconden, dat een PhpGedView sessie actief blijft, voordat opnieuw aanmelden noodzakelijk is. Standaard is 120 minuten.";
$pgv_lang["SHOW_STATS"]						= "Toon verwerkingsgegevens";
$pgv_lang["SHOW_STATS_help"]				= "~#pgv_lang[SHOW_STATS]#~<br /><br />Toont verwerkingsgegevens en database bevragingen onder aan ieder scherm.";
$pgv_lang["SHOW_COUNTER"]					= "Toon bezoekteller";
$pgv_lang["SHOW_COUNTER_help"]				= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Toont de bezoekteller op de MyGedView-pagina, de Genealogie-infopagina en op de personen-pagina.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Geeft gebruikers de mogelijkheid zich op de site te registreren.<br />De gebruiker ontvangt daarna een e-mail met verificatiegegevens.<br />Beheerders moeten de registratie na verificatie goedkeuren opdat die actief wordt.";
$pgv_lang["ALLOW_USER_THEMES_help"]			= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Geeft gebruikers de mogelijkheid hun eigen opmaakthema te kiezen.";
$pgv_lang["PGV_SIMPLE_MAIL_help"]			= "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />Normaliter worden in externe mailberichten zowel het e-mailadres als de naam van de geadresseerde en de afzender gebruikt. Sommige mailsystemen accepteren dit niet. Bij de waarde \"Ja\" wordt alleen het e-mailadres gebruikt.";
$pgv_lang["PGV_SMTP_ACTIVE_help"]			= "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Gebruik SMTP om emails vanuit PhpGedViewte verzenden.<br /><br />Deze optie vereist toegang tot een SMTP mail server.<br />Als hier voor <b>Nee</b> wordt gekozen, zal PhpGedView het, in PHP, ingebouwde email systeem gebruiken.<br />";
$pgv_lang["PGV_SMTP_HOST_help"]				= "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Dit is de naam van de SMTP mail server.><br />Bijvoorbeeld: <b>smtp.foo.bar.com</b>.<br /><br />Configuratie waardes van sommige email providers:<br /><br /><b>Gmail:</b><br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b> smtp.gmail.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b> 465 or 587<br /><b>#pgv_lang[PGV_SMTP_SSL]#:</b> SSL<br /><br /><b>Hotmail:</b><br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b> smtp.live.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b> 25 or 587<br /><b>#pgv_lang[PGV_SMTP_SSL]#:</b> TLS<br /><br /><b>Yahoo Mail Plus:</b><br />(momenteel een niet-gratis service)<br /><b>#pgv_lang[PGV_SMTP_HOST]#:</b> smtp.mail.yahoo.com<br /><b>#pgv_lang[PGV_SMTP_PORT]#:</b> 25<br />";
$pgv_lang["PGV_SMTP_HELO_help"]				= "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Dit is het domein deel van een geldig emailadres op de SMTP server.<br /><br /><br />Bijvoorbeeld:<br />Als u een email-account zoals <b>yourname@abc.xyz.com</b> hebt, moet u hier <b>abc.xyz.com</b> invullen.<br />";
$pgv_lang["PGV_SMTP_PORT_help"]				= "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Het poort-nummer dat wordt gebruikt voor verbindingen met de SMTP server.<br />In het algemeen zal dit poort <b>25</b> zijn.<br />";
$pgv_lang["PGV_SMTP_AUTH_help"]				= "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Gebruik naam en wachtwoord authenticatie om een verbinding met de SMTP server tot stand te brengen.<br /><br />Sommige SMTP servers vereisen dat alle verbingen worden geauthenticeerd, voordat ze uitgaande emails accepteren.<br />";
$pgv_lang["PGV_SMTP_AUTH_USER_help"]		= "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />De vereiste gebruikersnaam voor de authenticatie met de SMTP server.<br />";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"]		= "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />Het vereiste wachtwoord voor authenticatie met de SMTP server.<br />";
$pgv_lang["PGV_SMTP_SSL_help"]				= "~#pgv_lang[PGV_SMTP_SSL]#~<br /><br />Transport Layer Security (TLS) en Secure Sockets Layer (SSL) zijn Internet data encryptie protocollen.<br /><br />TLS 1.0, 1.1 en 1.2 zijn gestandardiseerde ontwikkelingen van SSL 3.0.<br />TLS 1.0 en SSL 3.1 zijn equivalent.<br /> Meer werk aan SSL wordt momenteel gedaan onder de nieuwe naam <b>TLS</b>.<br /><br />Als uw SMTP Server het SSL protocol vereist bij de login, moet u de <b>SSL</b> optie selecteren.<br />Als uw SMTP Server het TLS protocol vereist bij de login, moet u de <b>TLS</b> optie selecteren.<br />";
$pgv_lang["PGV_SMTP_FROM_NAME_help"]		= "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Voer hier de naam in, die gebruikt gaat worden in het &laquo;Van:&raquo;  veld van de emails, die vanaf deze site worden verzonden.<br /><br />Bijvoorbeeld:<br />Als uw naam <b>John Smith</b> is en u bent de beheerder van een site, die bekend is onder de naam: <b>Jones Genealogie</b>, kunt u hier iets als <b>John Smith</b> of <b>Jones Genealogie</b> invullen. Of misschien zelfs <b>John Smith, Beheerder van: Jones Genealogie</b>.<br /><br />U kunt hier invullen wat u wilt, maar HTML is <b>niet</b> toegestaan.<br />";
$pgv_lang["gedcom_title"]					= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]				= "~#pgv_lang[gedcom_title]#~<br /><br />Voer een titel in, welke de inhoud van dit GEDCOM-bestand beschrijft.";
$pgv_lang["LOGFILE_CREATE"]					= "Archiveer Logbestanden";
$pgv_lang["LOGFILE_CREATE_help"]			= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Geef aan hoe vaak het programma de log bestanden moet archiveren.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]			= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Het maximum geheugen dat PHP-scripts kunnen gebruiken. De standaardwaarde is 16 Mb. Op veel machines is de optie om deze waarde voor PHP in te stellen uitgeschakeld. Het instellen van deze waarde heeft daarom niet altijd invloed op de werkelijke maximumwaarde.";
$pgv_lang["PGV_STORE_MESSAGES_help"]		= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Hiermee wordt aangegeven, of berichten, die door PhpGedView worden verzonden, opgeslagen worden. Bij de waarde \"Ja\" kunnen gebruikers, bij aanmelden, hun ontvangen berichten lezen. Bij de waarde \"Nee\" worden de berichten alleen via externe e-mail verzonden.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]			= "Toon keuzelijst voor wijziging thema";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]		= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Deze optie geeft gebruikers de mogelijkheid om hun eigen site-opmaak te kiezen uit een keuzelijst.<br />de optie \"#ALLOW_USER_THEMES#\" moet eveneens ingeschakeld staan.";
$pgv_lang["MAX_VIEW_RATE"]					= "Maximum pagina's per seconde";
$pgv_lang["MAX_VIEW_RATE_help"]				= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Met deze optie beperkt u de snelheid waarmee iemand de pagina's kan bekijken.<br /><br />De verhouding wordt aangegeven in <i>aantal pagina's per seconde</i>.<br />Als die verhouding wordt overschreden, zal PhpGedView de betreffende sessie behandeling als een poging tot hacken. De sessie wordt afgebroken met een passende boodschap.<br /><br />Deze twee waardes zou een redelijke limiet moeten stellen aan de bandbreedte en gedownloade bytes van de server.<br />Deze mogelijkheid kan worden uitgeschakeld door de tijdinterval op 0 (nul) te zetten.<br />";
$pgv_lang["META_AUTHOR"]					= "META-tag auteur";
$pgv_lang["META_AUTHOR_help"]				= "~#pgv_lang[META_AUTHOR]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor de auteur in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de volledige naam van de contactpersoon opgenomen.";
$pgv_lang["META_AUTHOR_descr"]				= "Laat dit veld leeg om de volledige naam van de contactpersoon voor de desbetreffende genealogie te gebruiken.";
$pgv_lang["META_PUBLISHER"]					= "META-tag uitgever";
$pgv_lang["META_PUBLISHER_help"]			= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor de uitgever in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de volledige naam van de contactpersoon voor de desbetreffende genealogie opgenomen.";
$pgv_lang["META_PUBLISHER_descr"]			= "Laat dit veld leeg om de volledige naam van de contactpersoon voor de desbetreffende genealogie te gebruiken.";
$pgv_lang["META_COPYRIGHT"]					= "META-tag copyright";
$pgv_lang["META_COPYRIGHT_help"]			= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor copyright in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de volledige naam van de contactpersoon voor de desbetreffende genealogie opgenomen.";
$pgv_lang["META_COPYRIGHT_descr"]			= "Laat dit veld leeg om de volledige naam van de contactpersoon voor de desbetreffende genealogie te gebruiken.";
$pgv_lang["META_DESCRIPTION"]				= "META-tag omschrijving";
$pgv_lang["META_DESCRIPTION_help"]			= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor de omschrijving van de pagina, in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de naam van de actieve genealogie opgenomen.";
$pgv_lang["META_DESCRIPTION_descr"]			= "Laat dit veld leeg om voor deze waarde de naam van de actieve genealogie te gebruiken.";
$pgv_lang["META_PAGE_TOPIC"]				= "META-tag paginaonderwerp";
$pgv_lang["META_PAGE_TOPIC_help"]			= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor het onderwerp van de pagina, in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de naam van de actieve genealogie opgenomen.";
$pgv_lang["META_PAGE_TOPIC_descr"]			= "Laat dit veld leeg om voor deze waarde de naam van de actieve genealogie te gebruiken.";
$pgv_lang["META_AUDIENCE"]					= "META-tag doelgroep";
$pgv_lang["META_AUDIENCE_help"]				= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor de doelgroep van de pagina, in de kop van de HTML-pagina.";
$pgv_lang["META_PAGE_TYPE"]					= "META-tag paginatype";
$pgv_lang["META_PAGE_TYPE_help"]			= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor paginatype, in de kop van de HTML-pagina.";
$pgv_lang["META_ROBOTS"]					= "META-tag robots";
$pgv_lang["META_ROBOTS_help"]				= "~#pgv_lang[META_ROBOTS]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor robots, in de kop van de HTML-pagina. Let op: veel zoek-robots negeren deze waarde.<";
$pgv_lang["META_REVISIT"]					= "META-tag herbezoek";
$pgv_lang["META_REVISIT_help"]				= "~#pgv_lang[META_REVISIT]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor herbezoek door zoekrobots, in de kop van de HTML-pagina.";
$pgv_lang["META_KEYWORDS"]					= "META-tag sleutelwoorden";
$pgv_lang["META_KEYWORDS_help"]				= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Deze waarde wordt geplaatst in de META-tag voor sleutelwoorden, in de kop van de HTML-pagina. Veel zoekmachines gebruiken de sleutelwoorden om de pagina te ontsluiten. Aan wat hier wordt opgegeven, worden automatisch de lijst met veel voorkomende achternamen en de statistieken voor de genealogie toegevoegd.";
$pgv_lang["META_TITLE"]						= "META-tag toevoegen aan titel";
$pgv_lang["META_TITLE_help"]				= "~#pgv_lang[META_TITLE]#~<br /><br />Alles wat hier wordt opgegeven, wordt toegevoegd aan de titel-metatag, achter de paginatitel en voor de PhpGedView informatie.";

$pgv_lang["ENABLE_RSS"]						= "RSS inschakelen";
$pgv_lang["ENABLE_RSS_help"]				= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Met deze optie kunt u de  RSS mogelijkheid in- of uitschakelen.<br /><br />Met RSS kunnen gebruikers wijzigingen op de Index pagina van uw site in de gaten houden, zonder deze daadwerkelijk te bezoeken.<br />Als teveel gebruikers van deze mogelijkheid gebruik maken, of als ze de ververs-frekwentie te hoog hebben ingesteld, kan RSS teveel bbandbreedte van uw server gebruiken.<br /><br />Dit <a href='http://nl.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia article'><b>Wikipedia artikel</b></a> bevat uitgebreide informatie over RSS en de diverse RSS formats.<br />";
$pgv_lang["RSS_FORMAT"]						= "RSS-indeling";
$pgv_lang["RSS_FORMAT_help"]				= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Het formaat dat wordt gebruikt als het standaard feed-formaat voor de site. <br />De getallen aan het eind  geven <u>niet</u> een versie aan: ze geven het formaat aan.  Bijvoorbeeld: RSS 2.0 is niet nieuwer dan RSS 1.0, maar een ander  formaat.<br />Feed readers horen in staat te zijn om elk formaat te lezen.<br /><br />Dit <a href='http://nl.wikipedia.org/wiki/RSS' target='_blank'title='Wikipedia artikel'><b>Wikipedia artikel</b></a> bevat uitgebreide informatie en links over RSS en de diverse RSS formats.<br />";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Controleer of GEDCOM bestanden download-baar zijn";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"]= "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Om veiligheidsredenen moeten de GEDCOM bestanden niet op een lokatie zijn opgeslagen, vanwaar ze direct kunnen worden gedownload, zodoende voorbijgaand aan de  privacy controles.<br />Als u op deze link klikt, wordt er gecontroleerd of uw GEDCOM bestanden via het netwerk dowloadbaar zijn.<br /><br />Het is bekend dat op sommige systemen deze controle erg lang kan duren, of zelfs niet wordt afgerond. Als dat bij u het geval is, probeer dan zelf of u, via uw browser, uw GEDCOM bestand(en) kunt downloaden.<br />";
$pgv_lang["gedcom_download_secure"]			= "#GEDCOM# kan niet worden gedownload.";

$pgv_lang["welcome_new2"]					= "<br /><br />Aangezien u deze pagina ziet, heeft u met succes PhpGedView op uw server geïnstalleerd en bent u nu zover dat u kunt beginnen met het programma in te stellen volgens uw wensen.<br />";
$pgv_lang["welcome_new_help"]				= "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#Dit Help-venster zal u behulpzaam zijn bij het configuratieproces.  Omdat u diverse velden moet invullen, kan dit venster u van aanvullende informatie voorzien, over het veld waarin u bent. U kunt dit venster sluiten, om het weer te openen klik op een van de \"?\" vraagtekens naast het label van het veld.";
$pgv_lang["return_editconfig"]				= "U kunt ten allen tijde terugkeren naar deze pagina, door te klikken op de koppeling <b>Instellingen</b> op de Pagina <b>Beheer</b>, of met uw internet verkenner het bestand editconfig.php op te roepen.<br />";
$pgv_lang["return_editconfig_gedcom"]		= "U kunt ten allen tijde terugkeren naar deze pagina, door te klikken op de koppeling <b>Wijzig</b> in de tabel <b>Huidige GEDCOM-bestanden</b> op de Pagina <b>Beheer GEDCOM-bestanden en privacy instellingen</b>, of met uw internet verkenner het bestand editconfig_gedcom.php op te roepen.<br />";
$pgv_lang["save_config"]					= "Instellingen opslaan";
$pgv_lang["download_gedconf"]				= "Download de GEDCOM-configuratie.";
$pgv_lang["not_writable"]					= "Er is geconstateerd dat PHP geen schrijftoegang heeft tot uw configuratie bestand. Klik op de download-knop om het bestand elders te plaatsen. Later kan dit handmatig op de juiste locatie geplaatst worden.";
$pgv_lang["upload_to_index"]				= "Upload het bestand naar de index-map.";
$pgv_lang["import_sql"]						= "Er zijn SQL bestanden gevonden in uw index-map. Omdat deze afkomstig kunnen zijn van \"Migreren gebruikersinformatie\", heeft u hier de mogelijkheid om de informatie te importeren in uw database. Wilt u nu proberen deze bestanden te importeren? Alle bestaande gebruikersinformatie(gebruiker, nieuws, boodschappen, vak-indelingen en favorieten) gaat verloren.<br /><br />Als u doorgaat, zal PhpGedView trachten om de gegevens te importeren. Als dit niet succesvol verloopt, zal u worden gevraagd om een Administrator account aan te maken.<br /><br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]					= "Wijzig privacy";
$pgv_lang["edit_privacy_title"]				= "Wijzig GEDCOM privacy-instellingen";
$pgv_lang["save_changed_settings"]			= "Wijzigingen opslaan";
$pgv_lang["add_new_pp_setting"]				= "Nieuwe privacy instelling voor persoon toevoegen";
$pgv_lang["add_new_up_setting"]				= "Nieuwe privacy instelling voor gebruiker toevoegen";
$pgv_lang["add_new_gf_setting"]				= "Nieuwe algemene instelling voor gegevens toevoegen";
$pgv_lang["add_new_pf_setting"]				= "Nieuwe specifieke instelling voor gegevens toevoegen";
$pgv_lang["file_read_error"]				= "F O U T !!! Kan het Privacybestand niet lezen!";
$pgv_lang["edit_exist_person_privacy_settings"] = "Wijzig bestaande privacy instellingen voor persoon";
$pgv_lang["edit_exist_user_privacy_settings"] = "Wijzig bestaande privacy instellingen voor een gebruiker";
$pgv_lang["edit_exist_global_facts_settings"] = "Wijzig bestaande algemene instellingen voor gegevens";
$pgv_lang["edit_exist_person_facts_settings"] = "Wijzig bestaande specifieke instellingen voor gegevens van een persoon";
$pgv_lang["general_privacy"]				= "Algemene privacy-instellingen";
$pgv_lang["general_privacy_help"]			= "De <b>#pgv_lang[general_privacy]#.</b><br />Hier maakt u de basisinstellingen voor deze genealogie. Let erop, dat u de instellingen van de juiste genealogie aanpast, want als u meer genealogieën in PhpGedView beschikbaar heeft, gelden voor iedere genealogie eigen privacy-instellingen.<br />Afwijkingen van de basisinstellingen zijn mogelijk, door de andere instellingen op deze pagina te gebruiken.<br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy"]					= "Privacy instellingen voor een persoon";
$pgv_lang["person_privacy_help"]			= "De <b>#pgv_lang[person_privacy]#.</b><br /><br />Deze instellingen geven beheerders de mogelijkheid om de standaard privacy-instellingen voor een bepaalde persoon, in het GEDCOM-bestand, te niet te doen. Veronderstel bijv. dat er een kind is, dat jong overleed. Normaal gesproken, zouden de details zichtbaar zijn voor alle gebruikers, aangezien het kind is overleden. Maar de rest van de familie is nog steeds privé. U wilt niet de gegevens van het overlijden van het kind verwijderen, maar u wilt de details verbergen en privé maken. Veronderstel dat het kind het ID I100 had, dan zou u de volgende privacy instellingen moeten invoeren: <br /><br />ID: I100<br />Zichtbaar voor: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Omgekeerd werkt dit eveneens. Als u de details openbaar wilt maken van iemand (ID 101), waarvan u weet dat hij overleden is, maar waarvan u geen overlijdensdatum heeft, kunt u het volgende toevoegen:<br /><br />ID: I101<br />Zichtbaar voor: \"Zichtbaar voor ALLE bezoekers\"";
$pgv_lang["user_privacy"]					= "Privacy instellingen voor een gebruiker";
$pgv_lang["user_privacy_help"]				= "De <b>#pgv_lang[user_privacy]#.</b><br /><br />Deze instellingen geven beheerders de mogelijkheid om de standaard privacy-instellingen te niet te doen, voor personen in het GEDCOM-bestand, gebaseerd op de gebruikersnaam van de gebruiker.<br /><br />Dus, als u niet wilt dat de gebruikersnaam \"John\" uw details kan zien, en u heeft het ID 100 in het GEDCOM-bestand, kunt u het als volgt instellen:<br /><br />Gebruikersnaam: John<br />ID: I100<br />Zichtbaar?: \"Verbergen\"<br /><br />en uw details zullen alleen verborgen zijn voor de Gebruikernaam \"John\".<br /><br />Om de details van I101 (welke normaal gesproken verborgen zijn, omdat I101 nog in leven is) zichtbaar te maken voor de gebruikernaam \"John\" stelt u het als volgt in:<br /><br />Gebruikersnaam: John<br />ID: I101<br />Zichtbaar?: \"Toon\"";
$pgv_lang["global_facts"]					= "Algemene instellingen voor gegevens";
$pgv_lang["global_facts_help"]				= "De <b>#pgv_lang[global_facts]#.</b><br /><br />Met deze instellingen regelt u, op algemeen niveau, welke gegevens van alle personen in het GEDCOM-bestand verborgen moeten blijven.<br /><br />Het [\"Omschrijving gegevens\"] element bepaalt welk gegeven verborgen moet blijven. Het element [\"Keuze\"] kiest het gegeven, of de daaraan gerelateerde details. Het element [\"Zichtbaar voor\"] bepaalt bij welk toegangsniveau het gegeven zichtbaar is.<br /><br />De algemene instellingen voor gegevens zijn bedoeld om bepaalde gegevens van alle personen te verbergen, zowel van levende als overleden personen, zoals opgeslagen per GEDCOM-tag. Standaard is al de SSN (sofi-nummer) tag verborgen voor publieke bezoekers. Dit is om te voorkomen dat dit soort gegevens kan worden gestolen en dat misbruik wordt gemaakt van bijv. Sofi-nummers van overleden verwanten. Dit is waarschijnlijk het meest relevant voor de V.S. <br />Indien u alle huwelijken voor publieke bezoekers zou willen verbergen, kunt u het volgende instellen:<br /><br />Omschrijving gegevens: (MARR) - Huwelijk<br />Keuze: \"Gegeven zichtbaar\"<br />Zichtbaar voor?: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Omschrijving gegevens: (MARR) - Huwelijk<br />Keuze: \"Details gegevens zichtbaar\"<br />Zichtbaar voor?: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Met deze instellingen zijn alle huwelijken (en gerelateerde details) verborgen, behalve voor beheerders en gebruikers, die zich hebben aangemeld.";
$pgv_lang["person_facts"]					= "Specifieke instellingen voor gegevens";
$pgv_lang["person_facts_help"]				= "De <b>#pgv_lang[person_facts]#.</b><br /><br />Met deze instellingen regelt u, per bepaald persoon in het GEDCOM-bestand, welke gegevens en op welk niveau verborgen zijn.<br /><br />Het eerste element is het ID van de persoon, het tweede element is het gegeven.<br />Het element [\"Keuze\"] kiest het gegeven, of de daaraan gerelateerde details. Het element [\"Zichtbaar voor\"] bepaalt bij welk toegangsniveau het gegeven zichtbaar is.<br /><br />Deze instellingen werken op dezelfde wijze als de algemene instellingen, behalve dat u hier ook het GEDCOM-ID van de persoon, waarvan u gegevens wilt verbergen, instelt. Dus kunt u bijvoorbeeld de gegevens van het huwelijk van een bepaald persoon verbergen.";
$pgv_lang["accessible_by"]					= "Zichtbaar voor?";
$pgv_lang["hide"]							= "Verbergen";
$pgv_lang["show_question"]					= "Zichtbaar?";
$pgv_lang["user_name"]						= "Gebruikersnaam";
$pgv_lang["name_of_fact"]					= "Omschrijving gegevens";
$pgv_lang["choice"]							= "Keuze";
$pgv_lang["fact_show"]						= "Gegeven zichtbaar";
$pgv_lang["fact_details"]					= "Details gegeven zichtbaar";
$pgv_lang["privacy_header"]					= "Wijzig interne privacy instellingen";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan geen persoon met dit ID vinden";
$pgv_lang["save_and_import"]				= "Nadat u deze GEDCOM-configuratie heeft opgeslagen, moet u opnieuw het GEDCOM-bestand importeren door op de knop <b>Importeer GEDCOM</b> te klikken of te gaan naar <b>Beheren->Beheer GEDCOMs->Importeren GEDCOM-bestand</b>";
$pgv_lang["help_info"]						= "U kunt hulp krijgen, voor elk onderwerp, door te klikken op het rode \"?\" naast het label van elk veld.";
$pgv_lang["SHOW_LIVING_NAMES"]				= "Namen levende personen zichtbaar";
$pgv_lang["SHOW_LIVING_NAMES_help"]			= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Hiermee wordt ingesteld, voor welke groep gebruikers de namen van nog levende personen zichtbaar zijn.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]		= "Toon Onderzoeks Helper";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]	= "~#pgv_lang[SHOW_RESEARCH_ASSISTANT]#~<br /><br />Welke gebruikers mogen de Onderzoeks Helper bekijken, indien deze is geïnstalleerd?<br />";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Gebruik relatie privacy";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br />Een 'Nee' waarde betekent dat geautoriseerde gebruikers de details van alle levende personen kunnen zien.<br />Een 'Ja' waarde betekent dat gebruikers alleen de privé-informatie kunnen zien van levende personen, aan wie ze verwant zijn.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. lengte relatie-pad";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Indien voor relatieprivacy is gekozen, stelt u hiermee in, welke andere personen een gebruiker kan zien. Als de waarde 3 wordt gekozen, kan hij dit maximaal 3 personen ver zien. Bijvoorbeeld zijn vaders broers vrouw (zijn tante) of de zoon van zijn moeders zuster (neef).";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Controleer relaties door huwelijk";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Controleer de verwantschap door huwelijksrelaties, als voor relatieprivacy is gekozen. Staat dit op \"Ja\", dan kan de gebruiker, bij een relatiepad van 3, de vrouw van zijn vaders broer zien. Staat het op \"Nee\", dan kan dit niet. Echter, wanneer het relatiepad dan op 4 wordt gezet, dan is het pad weer mogelijk door vader - broer van vader - kind - moeder van kind.";
$pgv_lang["SHOW_DEAD_PEOPLE"]				= "Overleden personen zichtbaar";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]			= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Stelt het privacy-toegangsniveau in voor alle overleden personen.";
$pgv_lang["select_privacyfile_button"]		= "Geselecteerd privacybestand";
$pgv_lang["PRIVACY_BY_YEAR"]				= "Beperk privacy door de ouderdom van de gebeurtenis.";
$pgv_lang["PRIVACY_BY_YEAR_help"]			= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />De optie <b>#pgv_lang[PRIVACY_BY_YEAR]#</b> verbergt de details van personen, gebaseerd op hoe oud ze waren ten tijde van een gebeurtenis en onafhankelijk van of ze zijn overleden of niet. Gebruik deze optie in combinatie met de optie \"Leeftijd waarboven iemand geacht wordt overleden te zijn\".<br /><br />Bijvoorbeeld: als u deze optie aanzet en de waarde op 100 jaar instelt, worden alle personen die minder dan 100 jaar geleden zijn geboren, verborgen. Personen die minder dan 85 jaar geleden zijn gehuwd en personen die minder dan 75 jaar geleden overleden zijn worden eveneens verborgen.<br /><br />Let op: deze optie verlaagt de prestaties van PhpGedView enigszins.";

// Google Translate
$pgv_lang["google_translate"]				= "Google&reg; Vertalen";
$pgv_lang["commit"]							= "Uitvoeren";
$pgv_lang["commit_google"]					= "Alle door Google&reg; Vertalen wijzigingen doorvoeren";
$pgv_lang["commit_google_help"]				= "~#pgv_lang[commit_google]#~<br /><br />Als u op deze link klikt, worden alle verzamelde vertalingen, door het Google&reg; Vertalen systeem, die nog niet zijn opgeslagen, nu in een keer opgeslagen.<br /><br />De aanwijzer toont de voortgang van het verwerken en opslaan.<br /><br />";
$pgv_lang["google_translate_help"]			= "~#pgv_lang[google_translate]#~<br /><br />Deze tool gebruikt Google&reg; Vertalen om de vertaler hints te geven. Het is <b>niet</b> bedoeld om vertalingen te vervangen, die zijn uitgevoerd door een persoon die bron- en doel talen volledig begrijpt.<br />Denkt u er aan dat de Google&reg; Vertaal hulp niet betrouwbaar is en ook niet altijd een vertaling kan uitvoeren.<br /><br />Indien een tekst al is vertaald, zal er geeen link zijn naar Google&reg; Vertalen.<br /><br />Voor elke tekst, waarbij u de Google&reg; Vertaal hulp wilt gebruiken, klikt u op de <b>#pgv_lang[google_translate]#</b> link.  Nadat de pagina is herladen, moet u controleren op foute vertalingen en deze zelf corrigeren.<br /><b>Er is geen garantie dat de Google&reg; vertaling correct zal zijn.</b><br />Speciale karakters zoals: #, <, >, / en HTML tags zult u handmatig moeten corrigeren. Evenals referenties naar andere taal- of globale variabelen in de vertaalde tekst, zodat het resultaat overeenkomt met de orginele, onvertaalde, tekst.<br />Opmerking:   Google&reg; Vertalen plaats een spatie na elke HTML tag.  U moet beslist deze extra spaties verwijderen.<br /><br />Als u tevreden bent met het resultaat, klikt u  op <b>#pgv_lang[commit]#</b>, om het resultaat op te slaan.<br />Als u niet op <b>#pgv_lang[commit]#</b> klikt, worden de wijzigingen verzameld totdat u op de <b>#pgv_lang[commit_google]#</b> link, onderaan de pagina, klikt om alle gewijzigde tekst in een keer op te slaan.<br /><br />";

//-- language edit utility
$pgv_lang["lang_edit_help"]					= "~#pgv_lang[translator_tools]#~<br /><br />Deze pagina is bedoeld om te worden gebruikt door vertalers.<br />U kunt taalbestanden vertalen, vergelijken en exporteren.  Er is tevens een optie om vertalers te helpen vaststellen wat de oorsprong is van de tekst, die door PhpGedView wordt getoond.<br /><br />U kunt de volgende opties en hulpprogramma's gebruiken:<br />";
$pgv_lang["edit_langdiff"]					= "Bewerk en configureer de taalbestanden";
$pgv_lang["bom_check"]						= "BOM-controle taalbestanden";
$pgv_lang["bom_check_help"]					= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#<br /><br />";
$pgv_lang["bom_check_desc"]					= "Middels deze controle worden BOM's (Byte Order Mark) in alle taalbestanden opgespoord.<br />Indien een BOM wordt gevonden, wordt deze uit het betreffende bestand verwijderd.<br />Deze speciale code kan problemen opleveren in sommige programmadelen van PhpGedView.<br /><br />";
$pgv_lang["lang_debug"]						= "Helptekst foutzoeken";
$pgv_lang["lang_debug_help"]				= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br /><br />";
$pgv_lang["lang_debug_desc"]				= "Als u deze optie aanzet, worden de namen van de taalvariabelen die in de helptekst worden gebruikt, in het popup-venster getoond. Dit helpt vertalers om de naam van de variabele te bepalen, als de tekst moet worden aangepast.<br /><br />Deze optie blijft alleen gedurende uw huidige PhpGedView-sessie aanstaan.";
$pgv_lang["lang_debug_use"]					= "Gebruik optie foutzoeken in helptekst ";
$pgv_lang["bom_not_found"]					= "Geen BOM gevonden in de taalbestanden.";
$pgv_lang["bom_found"]						= "BOM gevonden in ";
$pgv_lang["edit_lang_utility"]				= "Bewerkingsprogramma taalbestand";
$pgv_lang["edit_lang_utility_help"]			= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#<br />";
$pgv_lang["edit_lang_utility_desc"]			= "U kunt dit programma gebruiken om een taalbestand te wijzigen aan de hand van het Engelstalige bestand.<br />Het programma geeft een lijst weer van teksten in het Engelse taalbestand en de bijbehorende teksten in het door u gekozen taalbestand.<br />U kunt een tekst in het gekozen taalbestand wijzigen door erop te klikken en de tekst vervolgens aan te passen. Daarna kunt u de wijzigingen opslaan.<br />De teksten kunnen elk 6144 karakters groot zijn.<br /><br />";
$pgv_lang["edit_lang_utility_warning"]		= "LET OP!<br /><br />Het gebruik van de knop #close_window_without_refresh# kan leiden tot verminking van het taalbestand!<br /><br />Als u deze knop heeft gebruikt, wordt de tekst in het venster van het vertaalprogramma niet ververst. De aangebrachte wijzigingen zijn dan niet zichtbaar.<br />Bovendien leidt opnieuw wijzigen van de desbetreffende tekst tot fouten in het taalbestand.<br />Als u een tekst toch opnieuw wilt wijzigen, herlaadt deze dan eerst door op de knop \"Wijzig\" te klikken boven aan het scherm.";
$pgv_lang["language_to_edit"]				= "Taal om te wijzigen";
$pgv_lang["language_to_edit_help"]			= "~#pgv_lang[language_to_edit]#~<br /><br />Uit deze keuzelijst kiest u de taal, waarvan u de berichten wilt wijzigen.<br />";
$pgv_lang["file_to_edit"]					= "Taalbestandstype om te wijzigen";
$pgv_lang["file_to_edit_help"]				= "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["lang_file_descriptions"]			= "PhpGedView heeft ondersteuning voor veel verschillende talen geïmplementeerd.  We hebben dit kunnen bereiken door alle tekst, die voor gebruikers zichtbaar kan zijn, volledig gescheiden te houden van het hoofdprogramma.<br />Er is een set van acht bestanden voor elke ondersteunde taal. De diverse teksten zijn, afhankelijk van hun functie, verdeeld over deze acht bestanden.<br /><b>Niet alle taalbestanden hoeven aanwezig te zijn.</b><br />Als een bepaalde tekst nog niet is vertaald, zal PhpGedView altijd de Engels versie gebruiken.<br /><br />De bestanden in elke talen-set zijn:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat termen en uitdrukkingen, die worden gebruikt bij het beheer van PhpGedView en de genealogische databases.<br /><br /></li><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de Help teksten voor gebruik tijdens de configuratie van PhpGedView.  Deze Help teksten zijn niet bedoeld om te worden bekeken door de gewone gebruikers.<br /><br /></li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dit is een lijst met de namen van landen. De lijst is genomen van de Web site van de Statistics Division, United Nations Department of Economic and Social Affairs.<br />Dit is de relevante <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> naar de Engelse lijst. De lijst is beschikbaar in het Engels en in het Frans.<br /><br /></li><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat termen en uitdrukkingen, die worden gebruikt bij het wijzigen van gegevens van de genealogische databases.<br /><br /></li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de tekstuele equivalenten van de GEDCOM Feiten codes, die staan in de GEDCOM 5.5.1 Standaard.<br />Het bevat eveneens extra Feiten codes, die niet in de Standaard staan, maar wel worden gebruikt door diverse genealogie programma's.<br /><br />Een Engelstalige kopie van de <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> kan worden ge-download als PDF (Portable Document Format).<br /><br /></li><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;FAQ is de afkorting van <b>F</b>requently <b>A</b>sked <b>Q</b>uestions. In de vertaling hebben we gekozen voor VGV: <b>V</b>eel <b>G</b>estelde <b>V</b>ragen.<br /><br />Het faqlist.xx.php bestand bevat een aantal vragen en antwoorden, die zijn verzameld door het PhpGedView ontwikkel team.  Elke VGV heeft twee vermeldingen in dit bestand. De ene vermelding is de VGV koptekst (doorgaans de vraag). De andere is de VGV tekst (doorgaans het antwoord).<br />Vervangingen voor de <b><i>faqlist.xx.php</i></b> bestanden, die regelmatig worden bijgewerkt, kunnen worden gedownload van de PhpGedView home site.<br /><br />De beheerder kan de VGV's in dit bestand gebruiken, of aanpassen, om zijn eigen VGV-lijst te maken, die beter bij zijn site past.<br /><br /></li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de Help-teksten voor de gewone gebruikers.  Sommige Help onderwerpen zijn t.a.v. de beheerders. Deze zijn verborgen voor gebruikers, die geen beheerdersrechten hebben.<br /><br /></li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Hierin staan de overige teksten en uitdrukkingen, die in het hele programma worden gebruikt.</li></ul><br />PhpGedView ondersteunt ook nog een negende taalbestand: <b><i>extra.xx.php</i></b>.  Dit bestand wordt altijd geladen <b>na</b> alle andere taalbestanden. Zodoende kan de beheerder, middels de taalvariabelen in dit bestand, elke standaard tekst in een geselecteerde taal \"overrulen\".<br />Het kan ook worden gebruikt om voor elke taal een aangepaste titel voor uw site of voor de  genealogische databases te maken.<br /><br />De inhoud van dit extra bestand wordt geheel bepaald door de beheerder. Het bestand zal <b>nooit</b> worden verspreid met de andere taalbestanden, of een versie van PhpGedView.<br />De beheerder zou nooit de standaard taalbestanden moeten wijzigen. Alle lokale wijzigingen moeten worden uitgevoerd in dit extra bestand.<br />";
$pgv_lang["check"]							= "Controleer";
$pgv_lang["lang_save"]						= "Opslaan";
$pgv_lang["contents"]						= "Inhoud";
$pgv_lang["listing"]						= "Lijst";
$pgv_lang["no_content"]						= "Geen inhoud";
$pgv_lang["editlang"]						= "Wijzigen";
$pgv_lang["editlang_help"]					= "Wijzig bericht in taalbestand";
$pgv_lang["savelang"]						= "Opslaan";
$pgv_lang["savelang_help"]					= "Sla aangepast bericht op";
$pgv_lang["original_message"]				= "Origineel bericht";
$pgv_lang["message_to_edit"]				= "Te wijzigen bericht";
$pgv_lang["changed_message"]				= "Gewijzigde inhoud";
$pgv_lang["message_empty_warning"]			= "WAARSCHUWING! De tekst van deze boodschap ontbreekt in [#LANGUAGE_FILE#]";
$pgv_lang["language_to_export"]				= "Kies taal voor export";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />M.b.v. deze keuzelijst kunt u de taal kiezen van de berichten die u wilt exporteren.<br /><br />De routine kan momenteel alleen de inhoud van de volgende taalbestanden exporteren: <i>configure_help.xx.php</i>, <i>help_text.xx.php</i>, en <i>lang.xx.php</i>.<br />De output is een HTML bestand, welke u  vanuit uw browser kunt printen.<br />";
$pgv_lang["export_lang_utility"]			= "Hulpprogramma export taalbestand";
$pgv_lang["export"]							= "Export";
$pgv_lang["export_lang_utility_help"]		= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#<br />";
$pgv_lang["export_lang_utility_desc"]		= "Kies een taal om de helpinformatie uit het gekozen configuration_help taalbestand te exporteren naar een documentatiebestand.<br /><br />";
$pgv_lang["export_ok"]						= "Helpinformatie is geëxporteerd.";
$pgv_lang["compare_lang_utility"]			= "Hulpprogramma vergelijking taalbestanden";
$pgv_lang["compare_lang_utility_help"]		= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#<br />";
$pgv_lang["compare_lang_utility_desc"]		= "Deze module vergelijkt twee taalbestanden en maakt een lijst van verschillen. Aangegeven wordt, welke variabelen ten opzichte van het eerste bestand niet meer voorkomen of er juist zijn bijgekomen.<br /><br />In het bestand [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>] in de languages-map staan nog andere wijzigingen vermeld. Hierin kunt u vinden welke variabelen qua inhoud zijn gewijzigd.<br /><br />";
$pgv_lang["new_language"]					= "Eerste taal";
$pgv_lang["new_language_help"]				= "~#pgv_lang[new_language]#~<br /><br />Uit deze keuzelijst kunt u  de taal selecteren, waarmee u de tweede taal wilt vergelijken.<br /><br />Bij programma-wijzigingen, of tekstaanpassingen, worden altijd eerst de <b>Engelse</b> taal bestanden gewijzigd. Deze Engelse taalbestanden kunt u dan het beste selecteren, om er de tweede taal mee te vergelijken.<br />";
$pgv_lang["old_language"]					= "Tweede taal";
$pgv_lang["old_language_help"]				= "~#pgv_lang[old_language]#~<br /><br />Uit deze keuzelijst kunt u  de taal selecteren, waarmee u de taal wilt vergelijken, die u heeft gekozen uit de keuzelijst van de  <b>Eerste taal</b>.<br /><br />Nadat u uw keus heeft gemaakt, klikt u op de <b>Vergelijk</b> knop. Vervolgens krijgt u een lijst met alle toevoegingen en verwijderingen in alle vier bestanden van beide gekozen talen.<br /><br />Even ter herinnering:<br /><b>Toevoegingen</b> betekent: Het is <u>in</u> het Eerste bestand, maar <u>niet</u> in het Tweede bestand.<br /><br /><b>Verwijderingen</b> betekent: Het is <u>niet</u> in het Eerste bestand, maar het <u>is</u> in het Tweede bestand.  Dit kan het geval zijn als een bepaald bericht, of tekst, niet meer wordt gebruikt en daarom werd verwijderd uit de Engelse bestanden.  U kunt dan veilig de corresponderende tekst verwijderen uit de tweede taalbestanden.<br />";
$pgv_lang["compare"]						= "Vergelijk";
$pgv_lang["comparing"]						= "Vergeleken taalbestanden";
$pgv_lang["additions"]						= "Toevoegingen";
$pgv_lang["no_additions"]					= "Geen toevoegingen";
$pgv_lang["subtractions"]					= "Verwijderingen";
$pgv_lang["no_subtractions"]				= "Geen verwijderingen";
$pgv_lang["config_lang_utility"]			= "Configuratie ondersteunde talen";
$pgv_lang["config_lang_utility_help"]		= "~#pgv_lang[config_lang_utility]#~<br /><br />Met behulp van deze module kunt u eenvoudig de ondersteunde talen in PhpGedView in- of uitschakelen.<br />Tevens kunt u een aantal land- en taalspecifieke instellingen aanpassen.<br /><br />Let op: Als u de originele instellingen wijzigt, wordt een nieuw instellingenbestand aangemaakt in uw #INDEX_DIRECTORY#-map. Vanaf dat moment gebruikt PhpGedView dit nieuwe bestand. Ook latere wijzigingen op de ondersteunde talen worden steeds hierin opgeslagen.<br /><br />Als u problemen heeft met taalinstellingen en u rapporteert dit, vermeldt er dan bij dat u gebruik maakt van aangepaste taalinstellingen.<br /><br />";
$pgv_lang["active"]							= "Actief";
$pgv_lang["active_help"]					= "~#pgv_lang[active]#~<br /><br />Sta de gebruikers toe deze taal te kiezen, indien het is toegestaan om een andere taal te selecteren.";
$pgv_lang["edit_settings"]					= "Wijzig instellingen";
$pgv_lang["lang_edit"]						= "Wijzig";
$pgv_lang["lang_language"]					= "Taal";
$pgv_lang["export_filename"]				= "Naam van het bestand met de geëxporteerde gegevens:";
$pgv_lang["lang_back"]						= "Terug naar het Hoofdmenu om taalbestanden te wijzigen en te configureren";
$pgv_lang["lang_back_admin"]				= "Terug naar menu Beheer";
$pgv_lang["lang_back_manage_gedcoms"]		= "Terug naar menu Beheer GEDCOM-bestanden";
$pgv_lang["lang_name_arabic"]				= "Arabisch";
$pgv_lang["lang_name_catalan"]				= "Catalaans (Valenciaans)";
$pgv_lang["lang_name_chinese"]				= "Chinees";
$pgv_lang["lang_name_croatian"]				= "Kroatisch";
$pgv_lang["lang_name_czech"]				= "Tsjechisch";
$pgv_lang["lang_name_danish"]				= "Deens";
$pgv_lang["lang_name_dutch"]				= "Nederlands";
$pgv_lang["lang_name_english"]				= "Engels";
$pgv_lang["lang_name_english (uk)"]			= "Engels (GB)";
$pgv_lang["lang_name_english (us)"]			= "Engels (VS)";
$pgv_lang["lang_name_estonian"]				= "Estlands";
$pgv_lang["lang_name_finnish"]				= "Fins";
$pgv_lang["lang_name_french"]				= "Frans";
$pgv_lang["lang_name_german"]				= "Duits";
$pgv_lang["lang_name_greek"]				= "Grieks";
$pgv_lang["lang_name_hebrew"]				= "Hebreeuws";
$pgv_lang["lang_name_hungarian"]			= "Hongaars";
$pgv_lang["lang_name_indonesian"]			= "Indonesisch";
$pgv_lang["lang_name_italian"]				= "Italiaans";
$pgv_lang["lang_name_lithuanian"]			= "Litouws";
$pgv_lang["lang_name_norwegian"]			= "Noors";
$pgv_lang["lang_name_polish"]				= "Pools";
$pgv_lang["lang_name_portuguese"]			= "Portugees";
$pgv_lang["lang_name_romanian"]				= "Romaans";
$pgv_lang["lang_name_russian"]				= "Russisch";
$pgv_lang["lang_name_serbian-la"]			= "Servisch (Latijns alfabet)";
$pgv_lang["lang_name_slovak"]				= "Slowaaks";
$pgv_lang["lang_name_slovenian"]			= "Sloweens";
$pgv_lang["lang_name_spanish"]				= "Spaans";
$pgv_lang["lang_name_spanish-ar"]			= "Spaans (Latijns-Amerikaans)";
$pgv_lang["lang_name_swedish"]				= "Zweeds";
$pgv_lang["lang_name_turkish"]				= "Turks";
$pgv_lang["lang_name_vietnamese"]			= "Vietnamees";
$pgv_lang["lang_new_language"]				= "Nieuwe taal";
$pgv_lang["original_lang_name"]				= "Originele naam van de taal in het #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]		= "~Originele naam van de taal~<br /><br />Hiermee geeft u aan, hoe deze taal in die taal zelf wordt genoemd.<br />Voorbeelden: Engels: English, Duits: Deutsch, Nederlands: Nederlands.";
$pgv_lang["lang_shortcut"]					= "Afkorting van de taal";
$pgv_lang["lang_shortcut_help"]				= "~#pgv_lang[lang_shortcut]#~<br /><br />Met deze optie stelt u in, hoe de taal in twee letters wordt afgekort.<br />Meestal is dit de eerste code, die in de taaldetectiecodes is opgenomen.<br />De afkorting wordt gebruikt voor de naamgeving van de taalbestanden. ";
$pgv_lang["lang_langcode"]					= "Taaldetectiecodes";
$pgv_lang["lang_langcode_help"]				= "~#pgv_lang[lang_langcode]#~<br /><br />Met behulp van deze codes kan PhpGedView detecteren welke taalinstelling de Internetverkenner van de gebruiker gebruikt voor het bekijken van de PhpGedView pagina's. De codes moeten worden gescheiden door een puntkomma \";\". ";
$pgv_lang["lang_filenames"]					= "Taalbestand";
$pgv_lang["lang_filenames_help"]			= "~#pgv_lang[lang_filenames]#~<br /><br />PhpGedView ondersteunt een groot aantal talen. Hiertoe worden alle teksten in het programma per taal opgeslagen in aparte bestanden, gescheiden van het programma zelf. Per taal zijn de teksten ondergebracht in vijf bestanden. In welk bestand een bepaalde tekst is opgeslagen, hangt af van de functie van de tekst. Als een bepaalde tekst niet is vertaald in een gekozen taal, wordt de Engelse tekst getoond.<br /><br />De bestanden voor elke taal zijn:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de teksten, uitdrukkingen en helpinformatie die bij het instellen van PhpGedView worden gebruikt. De helpinformatie wordt niet aan gewone gebruikers getoond.<br /></li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dit is een lijst met landcodes en -namen, afkomstig van de website van de Statistics Division, United Nations Department of Economic and Social Affairs. Dit is de link naar de Engelstalige lijst: <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a>. De lijst is beschikbaar in het Engels en in het Frans.<br /></li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de teksten die horen bij de GEDCOM-feitcodes uit de GEDCOM 5.5.1 Standaard. Het bevat eveneens niet-standaard codes die door verschillende genealogie-programma's worden gebruikt.<br /><br />U kunt de Engelstalige versie van de <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standaard</b></a> downloaden in PDF (Portable Document Format).<br /></li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;In dit bestand zijn alle helpteksten voor gewonde gebruikers opgeslagen. Sommige teksten, die specifiek voor beheerders zijn bedoeld, worden niet aan gebruikers zonder beheerdersrechten getoond.<br /></li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat alle teksten die bij het gebruik van PhpGedview op de pagina's te zien zijn.</li></ul>";
$pgv_lang["flagsfile"] 						= "Vlagbestand";
$pgv_lang["flagsfile_help"]					= "~#pgv_lang[flagsfile]#~<br /><br />Naam en pad van het afbeeldingbestand van de nationale vlag van de geselecteerde taal.";
$pgv_lang["text_direction"]					= "Richting van de tekst:";
$pgv_lang["text_direction_help"]			= "~#pgv_lang[text_direction]#~<br /><br />Hiermee stelt u in, op welke wijze teksten worden weergegeven. In de meeste talen is dit van links naar rechts, maar met name in veel Semitische talen zoals het Arabisch, Aramees en Hebreeuws is dit van rechts naar links.";
$pgv_lang["date_format"]					= "Datumformaat";
$pgv_lang["date_format_help"]				= "~#pgv_lang[date_format]#~<br /><br />Verschillende landen hebben verschillende manieren om de datum te tonen. In het Nederlands is dit standaard \"Dag Maand Jaar\", terwijl in het Engels vaak \"Maand Dag Jaar\" wordt gehanteerd.<br /><br />Met deze optie stelt u in, hoe PhpGedView de datum in de gekozen taal toont. Dit betreft zowel datumweergave vanuit PhpGedView als de weergave van datums die in de gegevens voorkomen.<br />U kunt het <b>Standaard</b> of het <b>Geavanceerde</b> formaat gebruiken.<ul><li><b>Standaard</b><br />De volgende codes worden gebruikt om verschillende elementen van een datum te representeren.  Opmerking: <b>D</b> en <b>M</b> hebben een andere betekenis in het <b>Geavanceerde</b> formaat.<p style=\"padding-left: 25px\"><b>D</b>&nbsp;&nbsp;dag v.d. maand, zonder voorafgaande nullen: 1 t/m 31<br /><b>M</b>&nbsp;&nbsp;naam v.d. maand: Januari, Februari, enz.<br /><b>Y</b>&nbsp;&nbsp;volledig geschreven jaar, bijv. 1999 of 44V.C.<br /><b>R</b>&nbsp;&nbsp;Kalender Conversie.  Zie verder het onderwerp: <b>Kalender Conversie</b>, iets naar beneden, voor uitleg van deze code.</p>Deze codes kunnen in elke volgorde worden gecombineerd, compleet met spaties en/of punten.<br />Bijv.: We nemen aan dat uw GEDCOM de datum 20&nbsp;AUG&nbsp;1965 bevat.<p style=\"padding-left: 25px\">Een <b>Nederlandse</b> gebruiker kan het formaaat instellen op <b>D&nbsp;M&nbsp;Y</b> en krijgt dan <b>20&nbsp;August&nbsp;1965</b>.<br />Een <b>Amerikaanse</b> gebruiker kan het formaaat instellen op <b>M&nbsp;D,&nbsp;Y</b> om dan <b>August&nbsp;20,&nbsp;1965</b> te krijgen<br />Een <b>Duitse</b> gebruiker kan het formaaat instellen op <b>D.&nbsp;M&nbsp;Y</b> en krijgt dan <b>20.&nbsp;August&nbsp;1965</b><br />E <b>Hongaarse</b> gebruiker kan het formaat instellen op <b>Y.&nbsp;M&nbsp;D.</b> en krijgt dan <b>1965.&nbsp;augusztus&nbsp;20.</b></p><br /></li><li><b>Geavanceerd</b><br />Complexere formatteer opties zijn beschikbaar.</b>Als uw datum formaat een andere letter dan <b>D</b>, <b>M</b>, <b>Y</b>, of <b>R</b> bevat, wordt autmatisch het <b>Geavanceerde</b> formaat toegepast.<br /><br />De volgende codes worden gebruikt om verschillende elementen van een datum te representeren.  Opmerking: <b>D</b> en <b>M</b> hebben een andere betekenis in het <b>Standaard</b> formaat.<p style=\"padding-left: 25px\"><b>d</b>&nbsp;&nbsp;dag v.d. maand, met voorafgaande nullen:  01 t/m 31<br /><b>j</b>&nbsp;&nbsp;dag v.d. maand, zonder voorafgaande nullen: 1 t/m 31<br /><b>S</b>&nbsp;&nbsp;rangtelwoord achtervoegsel voor een dag-nummer, bijv., de letters <b>th</b> in <b>4th&nbsp;July</b>.<br /><b>l</b> (de kleine letter \"L\")&nbsp;&nbsp;dag v.d. week: Maandag, Dinsdag, enz.<br /><b>D</b>&nbsp;&nbsp;afkorting van de dag v.d. week: M, Di, W, Do, V, Za, Zo<br /><b>N</b>&nbsp;&nbsp;ISO dag nummer: 0 t/m 6<br /><b>w</b>&nbsp;&nbsp;nummeriek dag nummer: 1 t/m 7<br /><b>z</b>&nbsp;&nbsp;dag v.h. jaar: 1 t/m 365 (366)<br /><b>F</b>&nbsp;&nbsp;maand naam: Januari, Februari, enz.<br /><b>M</b>&nbsp;&nbsp;afkorting v.d. maand: Jan, Feb, enz.<br /><b>m</b>&nbsp;&nbsp;maand nummer, met voorafgaande nul: 01 t/m 12<br /><b>n</b>&nbsp;&nbsp;maand nummer, zonder voorafgaande nul: 1 t/m 12<br /><b>Y</b>&nbsp;&nbsp;volledig geschreven jaar, bijv. 1999 of 44V.C.<br /><b>y</b>&nbsp;&nbsp;afkorting van het jaar.  Bij sommige kalenders mag het jaar worden afgekort.  Bij de Joodse kalender is dit het jaar, zonder de duizendtallen.  Bij de Gregoriaanse kalender is dit hetzelfde als het volledige jaar.<br /><b>R</b>&nbsp;&nbsp;Kalender Conversie.  Zie verder het onderwerp: <b>Kalender Conversie</b>, iets naar beneden, voor uitleg van deze code.<br /><b>@&nbsp;A&nbsp;O&nbsp;E</b>&nbsp;&nbsp;intern GEDCOM formaat</p><p style=\"padding-left: 50px\"><b>@</b>&nbsp;&nbsp;kalender code, bijv.: @#DGREGORIAN@, @#DHEBREW@, enz.<br /><b>A</b>&nbsp;&nbsp;da: 01 t/m 31<br /><b>O</b>&nbsp;&nbsp;maand: JAN, FEB, MAR, enz.<br /><b>E</b>&nbsp;&nbsp;jaar: 1776, 1867, 2007, enz.<br /><br />Om de niet-geconverteerde data te zien, gebruik: <b>A&nbsp;O&nbsp;E</b> of <b>@&nbsp;A&nbsp;O&nbsp;E</b></p><b>Enkele voorbeelden</b>, we nemen de datum 08&nbsp;SEP&nbsp;1965:<p style=\"padding-left: 25px\"><b>d&nbsp;M&nbsp;Y</b> = 08&nbsp;Sep&nbsp;1965<br /><b>D&nbsp;j&nbsp;F&nbsp;Y</b> = W&nbsp;8&nbsp;September&nbsp;1965<br /><b>j&nbsp;M&nbsp;y</b> = 8&nbsp;Sep&nbsp;65<br /><b>l&nbsp;-&nbsp;d&nbsp;-&nbsp;F&nbsp;-&nbsp;Y</b> = Woensdag&nbsp;-&nbsp;08&nbsp;-&nbsp;September&nbsp;-&nbsp;1965<br /><b>y/m/d</b> = 1965/09/08</p><br /></li>#pgv_lang[date_format_help2]#";
$pgv_lang["date_format_help2"]				= "<li><b>Kalender Conversie</b><br />De code <b>R</b> is enigszins ongebruikelijk in z'n gedrag.  Als deze code voorkomt in het datum formaat, wordt de gewone datum een 2de keer getoond, maar volgens een ander kalender systeem.<br />De elementen van deze andere kalender volgen dezelfde regels als die van de gewone formaat specificatie, behalve dat de output van de <b>R</b> formaat code is ingesloten door haakjes om het van de reguliere datum te onderscheiden.<br />De voorbeelden, gegeven bij de <b>Franse Revolutionaire</b> kalender, zullen dit iets duidelijker maken.<br /><br />Welke alternatieve kalender wordt toegepast, als de <b>R</b> code wordt gebruikt, is afhankelijk van de huidge taal van de pagina's.  Als de gebruikte taal Hebreeuws is, zal de <b>Joodse</b> kalender worden gebruikt.  Als de huidige taal Arabisch is, zal de <b>Hijri</b> kalender worden gebruikt.  Voor alle overige talen zal de  <b>Franse Revolutionaire</b> kalender worden gebruikt.<br /><br />De actie van de code is gelijk aan de keuze van het kalender formaat, dat u kunt maken op de GEDCOM Instellingen pagina.<br />Het verschil tussen de twee methodes is:<br />De <b>R</b> code, ingesteld op het nivo Taal Instellingen, werkt alleen bij de geselecteerde talen, maar bij alle GEDCOMs op de site.<br />De kalender optie, ingesteld op het nivo GEDCOM Instellingen, werkt bij alle talen, maar alleen bij die GEDCOMs, waarvoor die optie is ingesteld.<br /><ul><li><b>Franse Revolutionaire</b> kalender.&nbsp;&nbsp;Deze kalender wordt ook wel de <b>Franse Republikeinse</b> kalender genoemd.<br /><br />Behalve een zeer korte periode in Mei 1871, was dit kalender systeem allen in gebruik in Frankrijk en dan ook alleen maar tussen 22&nbsp;SEP&nbsp;1792 and 31&nbsp;DEC&nbsp;1805.<br />Als gevolg daarvan is het Franse Revolutionaire kalender-formaat alleen van toepassing indien een datum binnen dat bereik valt.<br /><br />Twee voorbeelden van dit datum formaat, hierbij wordt er vanuit gegaan dat de huidige taal is ingesteld op Nederlands, verduidelijken de actie van de <b>R</b> code:<br /><b>Y.m.d&nbsp;R</b> kan resulteren in <b>1805.04.26&nbsp;(XIII.08.06)</b> of <b>1806.01.01</b><br /> <b>j&nbsp;F&nbsp;Y&nbsp;R</b> kan resulteren in <b>13&nbsp;Oktober&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> or <b>1&nbsp;Januari&nbsp;1806</b>.</li></ul><br /></li><li><b>Taal alternatieven</b>&nbsp;&nbsp;&nbsp;De afgekorte tekst voor de Geadvanceerde codes <b>D</b> en <b>M</b> zijn ingesteld in het bestand <i>languages/lang.xx.php</i>, door declaraties te gebruiken zoals: <code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";</code>&nbsp;&nbsp; en&nbsp;&nbsp; <code>\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Deze kunnen worden gewijzigd door een <i>languages/extra.xx.php</i> bestand te gebruiken, zoals is omschreven in Wiki en ReadMe tekst voor taalaanpassingen, bijvoorbeeld:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code><br /><br /><br /></li><li><b>Lokalisatie</b>&nbsp;&nbsp;&nbsp;Voor een aantal talen zijn er speciale formattering regels., in het bijzonder verbuigingen van de maandnamen, afhankelijk hoe de datum wordt uitgesproken.  Deze speciale regels zijn opgenomen in de diverse <i>includes/extras/functions.xx.php</i> bestanden.</li></ul>";
$pgv_lang["time_format"]					= "Tijdformaat";
$pgv_lang["time_format_help"]				= "~#pgv_lang[time_format]#~<br /><br />Verschillende landen hebben verschillende manieren om de tijd weer te geven. Met deze variabele stelt u in, hoe de tijd in de desbetreffende taal wordt weergegeven.<br /><br />In Nederland wordt vaak de 24-uurs klok gebruikt, terwijl in Engelstalige landen de 12-uurs klok gangbaar is, met de toevoeging AM of PM.<br />Hiermee stelt u in, hoe PhpGedView de tijd in de gekozen taal weergeeft.<br /><br />Variabelen die u kunt gebruiken zijn:<br /><b>a</b> - Aanduiding voor am/pm in kleine letters.<br /><b>A</b> - Aanduiding voor AM/PM in hoofdletters.<br /><b>B</b> - Swatch internettijd, 000 - 999.<br /><b>c</b> - ISO 8601 datum (toegevoegd in PHP 5) 2004-02-12T15:19:21+00:00.<br /><b>d</b> - Dag van de maand in cijfers met voorloopnullen (00 - 31).<br /><b>D</b> - Dag van de week in drie letters in het Engels (Mon - Sun).<br /><b>F</b> - Naam van de maand in letters (Januari - December).<br /><b>g</b> - Uren in cijfers, 12-urige klok, zonder voorloopnullen (0 - 12).<br /><b>G</b> - Uren in cijfers, 24-urige klok, zonder voorloopnullen (0 - 23).<br /><b>h</b> - Uren in cijfers, 12-urige klok, met voorloopnullen (00 - 12).<br /><b>H</b> - Uren in cijfers, 24-urige klok, met voorloopnullen (00 - 23).<br /><b>i</b> - Minuten in cijfers, met voorloopnullen (00-59).<br /><b>I</b> - (Hoofdletter i) Geeft aan of de tijd in zomertijd is weergegeven. 1 is wel, 0 is niet.<br /><b>j</b> - Dag van de maand in cijfers, zonder voorloopnullen (1 - 31).<br /><b>l</b> - (kleine letter L) Dag van de week in letters (Zondag - Zaterdag).<br /><b>L</b> Schrikkeljaar, 1 is wel, 0 is niet.<br /><b>m</b> - Maand in cijfers, met voorloopnullen (01 - 12).<br /><b>M</b> - Maand in drie letters tekst (Jan - Dec).<br /><b>n</b> - Maand in cijfers, zonder voorloopnullen (1 - 12).<br /><b>O</b> - Verschil met Greenwich Mean Time (GMT) in aantal uren, bijvoorbeeld +0200.<br /><b>r</b></b> - Datum in het formaat van RFC2822, bijvoorbeeld: Thu, 21 Dec 2000 16:01:07 +0200.<br /><b>s</b> - Seconden in cijfers met voorloopnullen (00 - 59).<br /><b>S</b> - Engelse toevoeging op het dagnummer, bijvoorbeeld 1st, 2nd, 3rd, 4th. Kan gebruikt worden in combinatie met \"j\".<br /><b>t</b> - Aantal dagen in de desbetreffende maand (28 - 31).<br /><b>T</b> - Instelling van de tijdzone voor deze machine, bijvoorbeeld CEST, EST, MDT, etc.<br /><b>U</b> - Aantal seconden vanaf de start van de UNIX-tijd (1 januari 1970, 00:00:00 GMT).<br /><b>w</b> - Dag van de week in cijfers ( 0 - 6, voor Zondag - Maandag).<br /><b>W</b> - Weeknummer volgens ISO-8601 (01 - 53). De week start op maandag.<br /><b>Y</b> - Jaartal in 4 cijfers, bijvoorbeeld 1995, 2004.<br /><b>y</b> - Jaartal in twee cijfers, bijvoorbeeld 95, 04.<br /><b>z</b> - Dagnummer binnen het jaar (0 - 364) of (0 - 365 in een schrikkeljaar).<br /><b>Z</b> - Verschil van de tijdzone met UTC in seconden. Ten westen van UTC zijn de waarden altijd negatief, ten oosten positief (<b> -43200 t/m 43200</b>)<br /><br />U kunt zowel de volgorde van de variabelen zelf bepalen, als de tussenliggende tekens, zoals \"-\" of \":\".<br /><br />Bijvoorbeeld:<br />In Nederland bevat dit veld meestal <b>H:i:s</b> om <b>09:01:25</b> te krijgen.<br />Engelsen stellen meestal het tijdformaat in als <b>g:i:sa</b> om <b>9:01:25am</b> te krijgen.<br /><br />In het 24-hour system is middernacht 00:00.<br />In het 12-uur systeem, is middernacht 12:00am en het middaguur is 12:00pm.<br />";
$pgv_lang["week_start"]						= "Week begint op";
$pgv_lang["week_start_help"]				= "~#pgv_lang[week_start]#~<br /><br />De dag van de week, waarop in deze taal een week begint. In de meeste landen start de week op zondag, maar sommigen starten op maandag of een andere dag.";
$pgv_lang["name_reverse"]					= "Achternaam eerst";
$pgv_lang["name_reverse_help"]				= "~#pgv_lang[name_reverse]#~<br /><br />In sommige talen wordt de achternaam eerst genoemd, voor de voornaam, in plaats van andersom, wat standaard is. Met deze optie stelt u in dat de achternaam eerst wordt weergegeven.";
$pgv_lang["ltr"]							= "links naar rechts";
$pgv_lang["rtl"]							= "rechts naar links";
$pgv_lang["file_does_not_exist"]			= "FOUT! Het bestand bestaat niet!...";
$pgv_lang["optional_file_not_exist"]		= "Dit optioneel bestand bestaat niet.";
$pgv_lang["alphabet_upper"]					= "Alfabet hoofdletters";
$pgv_lang["alphabet_upper_help"]			= "~#pgv_lang[alphabet_upper]#~<br /><br />Alfabet van hoofdletters in deze taal. Dit alfabet wordt gebruikt voor het sorteren van namen in hoofdletters in de namenlijsten van PhpGedView.";
$pgv_lang["alphabet_lower"]					= "Alfabet kleine letters";
$pgv_lang["alphabet_lower_help"]			= "~#pgv_lang[alphabet_lower]#~<br /><br />Alfabet van kleine letters in deze taal. Dit alfabet wordt gebruikt voor het sorteren van namen in kleine letters in de namenlijsten van PhpGedView.";
$pgv_lang["multi_letter_alphabet"]			= "Multi-letter alfabet";
$pgv_lang["multi_letter_alphabet_help"]		= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Multi-letter combinaties die moeten worden behandeld als een enkele letter, bij het sorteren van lijsten met namen en titels, in deze taal.<br /><br />Sommige talen, zoals bijv. Hongaars en Slowaaks, beschouwen sommige lettercombinaties als een enkele letter. <br />De volgorde waarin u deze lettercombinaties opgeeft, bepaalt de volgorde waarin ze worden tussengevoegd in het normale alfabet, tijdens het sorteren.  Dit is belangrijk als meerdere multi-letter combinaties dezelfde beginletter hebben.<br />Behalve bij <b>ch</b>, worden deze lettercombinaties in het normale alfabet tussengevoegd aan de hand van hun eerste letter.  <b>ch</b> wordt altijd tussengevoegd na de letter <b>h</b>.<br />";
$pgv_lang["multi_letter_equiv"]				= "Multi-letter equivalenten";
$pgv_lang["multi_letter_equiv_help"]		= "~#pgv_lang[multi_letter_equiv]#~<br /><br />In sommige talen worden multi-letter combinaties behandelt als een equivalent van een enkele letter, bij het maken van bijv. lijsten met namen.<br /><br />Bijvoorbeeld:<br />In het Nederlands worden namen, die beginnen met een IJ, in de lijsten opgenomen tussen de namen die beginnen met een Y.<br />In het Noors worden namen, die beginnen met AA, in de lijsten opgenomen tussen de namen die beginnen met een &Aring;.<br />In sommige talen zijn er letters die kunnen worden geschreven als een karakter, of als twee. In bijv. het Slowaaks kunnen de twee karakters D en \xC5\xBE worden geschreven als een enkel karakter \xC7\x85.<br /><br />Door hier equivalenten op te geven, kunt u namen, die met deze letters beginnen,  laten groeperen op de diverse lijsten.<br /><br />De lijst met equivalenten dient u op te geven, gescheiden door komma's.<br />Om databases, die geen UTF-8 codering ondersteunen, moet u zowel de equivaleneten in hoofdletters als ook in kleine letters opgeven.<br /><br />Dit voorbeeld toont het te gebruiken formaat:<br />Aa=&Aring;,aa=&aring;<br />";
$pgv_lang["dictionary_sort"]				= "Gebruik woordenboek-regels bij het sorteren";
$pgv_lang["dictionary_sort_help"]			= "~#pgv_lang[dictionary_sort]#~<br /><br />Met deze optie bepaalt u hoe karakters met diakritische tekens worden behandeld bij het sorteren van lijsten met namen en/of titels.<br /><br />Een diakritisch teken is een teken dat boven, onder of door een letter gezet wordt en nodig is voor de uitspraak. Voorbeelden zijn de Umlaut, Trema, enz.<br /><br />Als hier voor <b>Ja</b> wordt gekozen, worden alle karakters met diakritische tekens behandeld alsof ze geen tekens zouden hebben.  Onderscheid in woorden met Diakritische tekens wordt alleen gemaakt als de twee woorden verder identiek zijn.<br />Als hier voor <b>Nee</b> wordt gekozen, worden alle letters behandeld als zijnde uniek, ongeacht of diakritische tekens wel of niet aanwezig zijn.<br />";
$pgv_lang["collation"]						= "Database collatie volgorde";
$pgv_lang["collation_help"]					= "~#pgv_lang[collation]#~<br /><br />Wat is de #pgv_lang[collation]#?<br />Onder collatie wordt verstaan de regels die gebruikt worden om tekens met elkaar te vergelijken bij het zoeken en sorteren in een database.<br /><br />Als u de ingebouwde collatie-regels van uw database gebruikt, dan wordt bij deze optie aangegeven welke collatie volgorde voor deze taal moet worden gebruikt.<br />U moet u er van overtuigen dat uw database de collatie volgorde, die u willt gebruiken, ondersteunt.<br /><br />Het gebruik van database collatie wordt bepaald in de site configuratie instellingen.<br />";
$pgv_lang["lang_config_write_error"]		= "Fout bij het wegschrijven van de taalinstellingen in het bestand  [language_settings.php]. Controleer de schrijfrechten en probeer het opnieuw.";
$pgv_lang["translation_forum"]				= "Koppeling naar het vertalerforum op de PhpGedView site van SourceForge";
$pgv_lang["translation_forum_help"]			= "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["translation_forum_desc"]			= "Deze koppeling opent een nieuw venster in uw Internet Verkenner, naar het vertalerforum van PhpGedView (http://sourceforge.net/forum/forum.php?forum_id=294245). Hier kunt u vragen stellen over vertalingen, problemen voorleggen en (als u wilt) u aanmelden voor het leveren van een bijdrage aan de vertalingen.<br />Als u moeite heeft met de Engelse taal, dan kunt u uw bericht in het Nederlands stellen.<br /><br />";
$pgv_lang["lang_set_file_read_error"]		= "F O U T !!! Kan het bestand [language_settings.php] niet lezen!";
$pgv_lang["add_new_language_desc"]			= "Met behulp van deze optie kunt u nieuwe, nog niet ondersteunde talen aan PhpGedView toevoegen. In het volgende scherm kunt u hiervoor de instellingen aanbrengen.<br />Nadat de nieuwe taal is toegevoegd, kunt u met het bewerkingsprogramma taalbestand alle teksten en berichten in die taal aanmaken.";
$pgv_lang["add_new_language_help"]			= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_lang_button"]			= "Nieuwe taal toevoegen";
$pgv_lang["hide_translated"]				= "Verberg vertalingen";
$pgv_lang["hide_translated_help"]			= "~#pgv_lang[hide_translated]#~<br /><br />Als u hier voor <b>Ja</b> kiest, worden alleen die berichten getoond, die nog niet zijn vertaald.  Dit betekent dat een nieuw bericht <u>niet</u> verschijnt in het doel-taalbestand.<br /><br />Sommige taalbestanden bevatten Engelse tekst voor diverse onvertaalde berichten. Deze routine kan deze onvertaalde items niet herkennen, omdat ze al aanwezig zijn in het doel-bestand.<br />Er wordt van het volgende uit gegaan:<br />   \"Als een bericht aanwezig is in het doel-bestand, dan is het ook vertaald.\"<br />";
$pgv_lang["lang_file_write_error"]			= "F O U T !!!<br /><br />De wijzigingen kunnen niet in het geselecteerde taalbestand worden weggeschreven!<br />Controleer de schrijfrechten op (#lang_filename#)|";
$pgv_lang["no_open"]						= "F O U T !!!<br /><br />Kan bestand niet openen: #lang_filename#";
$pgv_lang["users_langs"]					= "Gebruikers per taal";
$pgv_lang["configured_languages"]			= "Gebruikte talen";

//-- User Migration Tool messages
$pgv_lang["um_header"]						= "Migreren gebruikersinformatie";
$pgv_lang["um_proceed"]						= "Doorgaan met importeren/exporteren van gebruikersinformatie?<br /><br />";
$pgv_lang["um_creating"]					= "Aanmaken";
$pgv_lang["um_sql_index"]					= "Dit programma maakt het bestand \"authenticate.php\" en diverse <b>.dat</b> bestanden aan in uw indexmap.<br />Nadat de bestanden succesvol zijn aangemaakt, kunt u overschakelen naar index-modus met beoud van alle gebruikersinstellingen, berichten, favorieten, nieuwsberichten en opmaak van de genealogie-startpagina en MGedView-pagina's.<br /><br />Let op: Na het overschakelen naar index-modus moet u uw GEDCOM-bestand(en) opnieuw importeren.<br /><br />";
$pgv_lang["um_file_create_fail1"]			= "Aanmaken van nieuw bestand is mislukt, een bestand met deze naam bestaat al:";
$pgv_lang["um_file_create_fail2"]			= "Aanmaken niet mogelijk van";
$pgv_lang["um_file_create_fail3"]			= "Controleer uw toegangsrechten tot deze map.";
$pgv_lang["um_file_create_succ1"]			= "Bestand succesvol aangemaakt:";
$pgv_lang["um_file_not_created"]			= "Bestand is niet aangemaakt.";
$pgv_lang["um_nomsg"]						= "Er zijn geen berichten aanwezig in het systeem.";
$pgv_lang["um_nofav"]						= "Er zijn geen favorieten aanwezig in het systeem.";
$pgv_lang["um_nonews"]						= "Er zijn geen nieuwsberichten aanwezig in het systeem.";
$pgv_lang["um_nofiles"]						= "Geen bestanden gevonden voor de backup.";
$pgv_lang["um_noblocks"]					= "Er zijn geen indelingsdefinities aanwezig in het systeem.";
$pgv_lang["um_index_sql"]					= "Dit programma importeert de gegevens uit het \"authenticate.php\" bestand en uit de .dat bestanden in uw indexmap, in uw database.<br />";
$pgv_lang["um_noaction"]					= "Er zijn nu geen handelingen nodig om de gebruikersinformatie naar SQL-modus over te zetten.<br />Zodra u bent overgeschakeld naar SQL-modus, kunt u dit programma opnieuw starten om alle gebruikersgegevens in uw SQL-database te importeren.<br />U dient het bestand \"authenticate.php\" en de .dat bestanden <b>niet</b> uit uw indexmap te verwijderen bij het overschakelen.<br />";
$pgv_lang["um_import"]						= "Import";
$pgv_lang["um_export"]						= "Export";
$pgv_lang["um_explain"]						= "Dit programma heeft twee functies: het exporteert gebruikersgegevens van SQL- naar index-modus, of het importeert gebruikersgegevens van index- naar sql-modus.<br /><br />Gebruikersgegevens, favorieten, vakdefinities op de Welkomst- en MyGedView-pagina's, berichten en nieuwsberichten zijn na migratie weer beschikbaar.<br /><br /><b>LET OP!</b><br />U kunt dit programma niet gebruiken om gegevens te migreren tussen verschillende versies van PhpGedView. Overtuig u ervan, dat de gegevens afkomstig zijn en geïmporteerd worden in dezelfde versie van PhpGedView.<br /><br /><b>IMPORT</b><br />Als u ervoor kiest om gegevens vanuit index-modus te importeren, dan worden de bestaande gebruikersgegevens in de SQL-database <b>overschreven</b>. Dit programma voegt de gegevens <b>niet</b> samen. Zodra u de import heeft uitgevoerd, kunt op op geen enkele wijze via PhpGedView de oude gegevens terugkrijgen.<br /><br /><b>EXPORT</b><br />Als u voor exporteren kiest, zal dit programma de gebruikersinformatie uit de SQL-database opslaan in een formaat dat voor de index-modus bruikbaar is. Het bestand <i>authenticate.php</i> en een aantal <i>.dat</i> bestanden worden in uw index-map aangemaakt. Indien al bestanden met dezelfde naam bestaan, wordt u gevraagd of deze moeten worden overschreven. Na het overschakelen naar index-modus zijn alle gegevens direct beschikbaar.<br /><br /><b>LET OP:</b><br />Na het overschakelen naar index-modus dient u uw GEDCOM-bestand(en) opnieuw te importeren.<br /><br />";
$pgv_lang["um_tool_help"]					= "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"]				= "~Migreren gebruikers van SQL- naar Index modus~<br /><br />#pgv_lang[um_sql_index]#|";
$pgv_lang["um_index_sql_help"]				= "~Migreren gebruikersgegevens van Index naar SQL-modus~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"]					= "Importeren gebruikers";
$pgv_lang["um_imp_blocks"]					= "Importeren vakindelingen";
$pgv_lang["um_imp_favorites"]				= "Importeren favorieten";
$pgv_lang["um_imp_messages"]				= "Importeren berichten";
$pgv_lang["um_imp_news"]					= "Importeren nieuwsberichten";
$pgv_lang["um_nousers"]						= "Bestand \"authenticate.php\" niet gevonden in uw indexmap. Migratie is afgebroken.";
$pgv_lang["um_imp_succ"]					= "Import gereed";
$pgv_lang["um_imp_fail"]					= "Importfout";
$pgv_lang["um_backup"]						= "Backup";
$pgv_lang["um_zip_succ"]					= "ZIP-bestand succesvol aangemaakt.";
$pgv_lang["um_zip_dl"]						= "Download ZIP-bestand met backup";
$pgv_lang["um_bu_explain"]					= "Dit programma maakt een backup van verschillende soorten gegevens in PhpGedView.<br /><br />De gegevens die u hieronder voor de backup selecteert worden verzameld en in een ZIP-bestand opgeslagen.<br />Dit kunt u downloaden met de koppeling die dan onderaan de pagina verschijnt.<br />Het ZIP-bestand blijft aanwezig in uw index-map totdat u dit handmatig verwijdert.";
$pgv_lang["um_bu_help"]						= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"]					= "PhpGedView instellingenbestand";
$pgv_lang["um_bu_gedcoms"]					= "GEDCOM bestanden";
$pgv_lang["um_bu_gedsets"]					= "GEDCOM bestands- en privacy-instellingen";
$pgv_lang["um_bu_logs"]						= "GEDCOM tellers, zoek-logbestanden en PhpGedView-logbestanden";
$pgv_lang["um_bu_usinfo"]					= "Gebruikersinstellingen, vakinstellingen. favorieten, berichten en nieuwsberichten.";
$pgv_lang["um_bu_media"]					= "Media bestanden";
$pgv_lang["um_mk_bu"]						= "Maak backup";
$pgv_lang["um_nofiles"]						= "Geen bestanden gevonden voor de backup.";
$pgv_lang["um_files_exist"]					= "Een of meer bestanden bestaat al. Wilt u deze overschrijven?";
$pgv_lang["um_results"]						= "Resultaten";
$pgv_lang["preview_faq_item"]				= "Preview alle FAQ items";
$pgv_lang["preview_faq_item_help"]			= "~#pgv_lang[preview_faq_item]#~<br />Met deze optie kan een beheerder de VGV pagina bekijken, zonder alle wijzigen opties en andere links.<br /><br />Behalve een enkele <b>Wijzigen</b> link boven het eerste VGV onderwerp, zal de VGV pagina er uit zien, zoals ook de gewonde bezoeker deze zal zien.<br />Deze speciale <b>Wijzigen</b> link laat de VGV pagina weer in de volledige Wijzigen functionaliteit zien aan de beheerder.<br />";
$pgv_lang["restore_faq_edits"]				= "Herstel wijzigen functionaliteit v.d. VGV-pagina.";
$pgv_lang["restore_faq_edits_help"]			= "~#pgv_lang[restore_faq_edits]#~<br />Met deze optie wordt de VGV pagina weer getoond, zoals de beheerder deze, normaal gesproken, ziet. De VGV onderwerpen kunnen dan eventueel weer worden aangepast..<br />";
$pgv_lang["add_faq_item"]					= "VGV onderwerp toevoegen";
$pgv_lang["add_faq_item_help"]				= "~#pgv_lang[add_faq_item]#~<br />Met deze optie kunt u een onderwerp toevoegen aan de VGV pagina.<br />";
$pgv_lang["edit_faq_item"]					= "Wijzig VGV item";
$pgv_lang["edit_faq_item_help"]				= "~#pgv_lang[edit_faq_item]#~<br />Deze optie stelt u in staat een item op de VGV pagina te wijzigen.<br />";
$pgv_lang["delete_faq_item"]				= "Verwijder VGV onderwerp";
$pgv_lang["delete_faq_item_help"]			= "~#pgv_lang[delete_faq_item]#~<br />Met deze optie kunt u een onderwerp verwijderen van de VGV pagina.<br />";
$pgv_lang["moveup_faq_item"]				= "Verplaats VGV-item naar boven";
$pgv_lang["moveup_faq_item_help"]			= "~#pgv_lang[moveup_faq_item]#~<br />Deze optie laat u een VGV onderwerp naar boven verplaatsen op de VGV pagina.<br /><br />Elke keer dat u deze optie gebruikt, wordt het positie-nummer, van het VGV onderwerp, met 1 verminderd.  U kunt hetzelfde effect bereiken, door het gewenste onderwerp te wijzigen en dan een ander getal in te voeren in het positie-nummer veld.<br />Als meerdere VGV items hetzelfde positie-nummer hebben, zal slechts een van deze onderwerpen worden getoond.<br />";
$pgv_lang["movedown_faq_item"]				= "Verplaats VGV-item naar beneden";
$pgv_lang["movedown_faq_item_help"]			= "~#pgv_lang[movedown_faq_item]#~<br />Deze optie laat u een VGV onderwerp naar beneden verplaatsen op de VGV pagina.<br /><br />Elke keer dat u deze optie gebruikt, wordt het positie-nummer, van het VGV onderwerp, met 1 vermeerderd.  U kunt hetzelfde effect bereiken, door het gewenste onderwerp te wijzigen en dan een ander getal in te voeren in het positie-nummer veld.<br />Als meerdere VGV items hetzelfde positie-nummer hebben, zal slechts een van deze onderwerpen worden getoond.<br />";
$pgv_lang["add_faq_header_help"]			= "~#pgv_lang[add_faq_header]#~<br />Hier wordt de titel van het VGV onderwerp ingevuld.<br /><br />Wat u hier invult kan worden geformatteerd. HTML tags zoals &lt;b&gt; en &lt;br /&gt; zijn toegestaan, evenals HTML entiteiten als &amp;amp; en &amp;nbsp;.<br />Ander HTML tags dan &lt;br /&gt; zijn waarschijnlijk niet erg bruikbaar in een VGV titel en kunnen beter worden vermeden.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_body_help"]				= "~#pgv_lang[add_faq_body]#~<br />De tekst van het VGV onderwerp wordt hier ingevuld.<br /><br />De tekst kan worden geformatteerd. HTML tags zoals &lt;b&gt; en &lt;br /&gt; zijn toegestaan, evenals HTML entiteiten als &amp;amp; en &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_HTML"]					= "HTML entiteiten zijn een gemakkelijke manier om speciale karakters aan uw VGV titels en tekst toe te voegen.  U kunt symbolische namen, decimale of hexadecimale getallen, gebruiken.  Een complete lijst met HTML entiteiten, hun codes en hun weergave in een browser kan hier worden gevonden:  <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML entiteiten lijst.</a><br /><br />In sommige gevallen wilt u wellicht een Tilde karakter&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;of een Nummer Teken&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;gebruiken in uw URL's of tekst.  Deze karakters hebben echter een speciale betekenis binnen het PhpGedView Help systeem en kunnen alleen maar worden ingevoerd in hun  hexadecimale of decimale formaat.<br />De&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;en&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;karakters, die gebruikelijk HTML tags insluiten, moeten eveneens in hun hexadecimale of decimale formaat worden ingevoerd, zodat ze worden behandeld als normale tekst, i.p.v. te worden herkend als insluiters van een HTML tag. <ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;&nbsp;of&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;resulteert in&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;&nbsp;of&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;resulteert in&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;&nbsp;of&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;resulteert in&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;of&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;resulteert in&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Er is een&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML entiteit, maar dit symbool wordt niet geïnterpreteerd als een Tilde als het wordt gebruikt in URL's.";
$pgv_lang["add_faq_pgvLangRefs"]			= "U kunt referenties naar variabelen v.d. taalbestanden of waardes van globale variabelen, invoegen.<br />Voorbeelden: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de taal variabele \$pgv_lang[\"add_to_cart\"]. Als het in dit veld ingevoerd zou zijn, zou het worden getoond als <b>#pgv_lang[add_to_cart]#</b>, indien de VGV lijst wordt bekeken in de huidige taal.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de Feiten Naam \$factarray[\"AFN\"]. Als het in dit veld ingevoerd zou zijn, zou het worden getoond als <b>#factarray[AFN]#</b>, indien de VGV lijst wordt bekeken in de huidige taal. </li><li><b>&#x23;GLOBALS[VERSION]&#x23;&nbsp;&#x23;GLOBALS[VERSION_RELEASE]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de globale variabele \$VERSION, een spatie, vervolgens een referentie naar de globale variabele \$VERSION_RELEASE. Als ze in dit veld ingevoerd zouden zijn, zouden ze worden getoond als <b>#GLOBALS[VERSION]#&nbsp;#GLOBALS[VERSION_RELEASE]#</b>, indien de VGV lijst wordt bekeken in de huidige taal.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de globale variabele \$GEDCOM, wat de naam is van het huidige GEDCOM bestand. Als het in dit veld ingevoerd zou zijn, zou het worden getoond als <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp;is een referentie naar de globale variabele \$GEDCOM_TITLE, welke de titel is van het huidige GEDCOM bestand.  Als het in dit veld ingevoerd zou zijn, zou het worden getoond als <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Deze eigenschap is zeer bruikabaar als u VGV lijsten wilt maken, die verschillend zijn voor elke taal, die uw site ondersteunt.  U moet dan uw aangepaste VGV titels en teksten opslaan in variabelen in de  <i>languages/extra.xx.php</i> bestanden (<i>xx</i> is de code voor elke taal). U genruikt dan het volgende formaat:<br />\$pgv_lang[\"faq_title1\"] = \"Dit is een voorbeeld VGV titel\";<br />\$pgv_lang[\"faq_body1\"] = \"Dit is een voorbeeld VGV tekst.\";<br />";
$pgv_lang["add_faq_order_help"]				= "~#pgv_lang[add_faq_order]#~<br />In dit veld bepaalt op welke plaats in de VGV-lijst u dit onderwerp wil tonen.<br /><br />U hoeft geen opeenvolgende getallen te gebruiken. Als u gaten laat in de nummering, kunt u later gemakkelijker onderwerpen tussenvoegen.<br />Bijvoorbeeld: Als u begint met het gebruiken van de getallen 5, 10, 15, 20, enz., kunt u later onderwerpen tussenvoegen, door dan getallen toe te wijzen die tussen, of voor, al bestaande getallen vallen.<br /><br />Negatieve getallen en nul zijn eveneens toegestaan. Die kunnen worden gebruikt om onderwpen voor het allereerste onderwerp te plaatsen.<br /><br />Indien meerdere VGV onderwerpen hetzelfde nummer hebben, wordt slechts een ervan getoond.<br />";
$pgv_lang["add_faq_visibility_help"]		= "~#pgv_lang[add_faq_visibility]#~<br />U kunt hier bepalen of dit VGV onderwerp voor alle GEDCOM's wordt getoond, of alleen voor de huidige GEDCOM.<br /><br />U heeft de volgende keuzes:<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;Het VGV onderwerp wordt getoond in alle VGV-lijsten, ongeacht welke  GEDCOM actief is.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;Het VGV onderwerp wordt getoond in de VGV-lijst van de huidig actieve GEDCOM.</li></ul><br />";
$pgv_lang["index_gedcom_news_adm_help"]		= "Het GEDCOM Prikbord staat het gebruik van <b>HTML tags</b> en <b>HTML entiteiten</b> toe.  HTML moet niet worden gebruikt in Titels.<br /><br />Zorg er, bij het gebruik van HTML tags, voor dat u zowel start- als einde- tags gebruikt. Als web site beheerder is het het van nut om enige kennis van HTML te hebben.<br />Dit programma gebruikt eveneens <b>Cascading Style Sheets (CSS)</b>.<br />Voor elk thema wordt een bijbehorende CSS toegepast. U kunt classes van deze style sheets gebruiken om te bepalen hoe uw berichten worden afgebeeld.<br /><br />Als u hierbij meer hulp nodig heeft, kunt u op de  PhpGedView web site een aantal voorbeelden vinden hoe u deze HTML tags in uw  GEDCOM Prikbord blok kunt gebruiken.<br /><br />Zoals ook bij de VGV-lijst, mogen de GEDCOM Prikbord titels en tekst referenties naar variabelen van \$pgv_lang, \$factarray, en \$GLOBALS bevatten, om zodoende complete flexibiliteit te waarborgen bij het maken van Prikbord items, die afhankelijk zijn van de huidige actieve taal.<br /><br />De volgende omschrijving, die is geleend van de Help tekst voor de VGV-lijst, is gelijkwaardig toepasbaar voor de GEDCOM Prikbord items.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["time_limit_help"]				= "~#pgv_lang[time_limit]#~<br /><br />De maximale tijd dat de import routine mag draaien om het GEDCOM bestand te verwerken.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"]				= "Gevonden resultaten:";
$pgv_lang["ged_filter_reset"]				= "Reset zoektekst";
$pgv_lang["ged_filter_description"]			= "Zoek-optie tekst";
$pgv_lang["ged_filter_description_help"]	= "~#pgv_lang[ged_filter_description]#~<br />Met deze optie kunt u tekst, met betrekking tot de configuratie opties, zoeken.<br /><br />Tijdens het typen van letters, worden al de configuratie opties gevonden, welke die lettervolgorde bevatten.  De zoekoptie wordt uiteraard nauwkeuriger als er meer letters worden ingetypt.<br />";

?>
