<?php
/**
 * Swedish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2017  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Patrik Hansson
 * @version $Id: help_text.sv.php 7161 2017-08-12 18:20:51Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- GENERAL
$pgv_lang["help_header"]			= "Extra information om:";

$pgv_lang["privacy_error_help"]			= "<b>INTEGRITETSDETALJER</b><br /><br />Det finns flera tänkbara orsaker för detta meddelande:<br /><br /><ul><li> Information om levande personer är satt till \"Privata\".</b><br />Oregistrerade besökare och besökare som inte är inloggade kan endast se fullständig information om döda personer. Om Systemadministratören tillåter det, registera dig som användare genom att klicka på \"logga in\"-knappen, sedan på #pgv_lang[requestpassword]#-länken.<br /></li><br /><li><b>Du är en beökare med användarnamn och lösenord...</b><br />men du har glömt att logga in eller har varit inaktiv för länge.<br /></li><br /><li><b> Informationen är satt till \"Privat\"</b><br />Personen som du klickade på har bett adminstratören att bli behandlad som \"Privat\" eller att inte synas alls(Dold).<br />Integriteten kan sättas till:<br /><ol><li>#pgv_lang[PRIV_USER]#</li><li>#pgv_lang[PRIV_NONE]#</li><li>#pgv_lang[PRIV_HIDE]#</li></ol></li><br /><li><b>Utanför Släktleden</b><br />Även om du är en registrerad användare <u>och</u> inloggad kan det ändå hända att du ser detta meddeladet.<br />Administratören kan sätta begränsningar på hur avlägsna släktingar man får se.<br /><br />Exempel:<br />När längden på släktskapsförhållande är satt till <b>1</b> kan du endast se detaljer för din egen familj, inte på ingifta eller dina syskons barn.<br /><br />När längden på släktskapsförhållande är satt till <b>2</b> kan du dessutom se din brors fru och deras barn men inte barnens respektive.<br />Ju högre längden är satt ju fler avlägsna släktingar kan du se.<br /></li></ul><br />Om du tycker att du har rätt att se vissa detaljer bör du kontakta adminstratören eller klicka på \"kontakta\"-länken.<br /><br />";

$pgv_lang["more_help"]				= "<br />Om du vill ha kontext hjälp tillgänglig, kontrollera att <b>#pgv_lang[show_context_help]#</b> (i hjälp menyn) är påslagen, och klicka på <b>?</b> efter ämnet.<br />";

$pgv_lang["more_config_help"]			= "<br /><b<Mer hjälp</b><br />#pgv_lang[context_help]#<br /><br />";

$pgv_lang["start_admin_help"]			= "+++ Början av extra administratörsinformation +++";

$pgv_lang["end_admin_help"]			= "--- Slut på extra administratörsinformation ---";

$pgv_lang["multiple_help"]			= "<span class='center'>--- Detta är en generell hjälptext för flera sidor ---</span>";
$pgv_lang["header_general_help"]		= "<div class='name_head center'><b>ALLMÄN INFORMATION</b></div><br />";

$pgv_lang["best_display_help"]			= "~Din skärm~<br />PhpGedView är utvecklad för en skärmupplösning på 1024x768 punkter.<br />Om du har en lägre upplösning (t.ex. 800x600 punkter), kommer du behöva scrolla horisontellt.<br />";

$pgv_lang["preview_help"]			= "~Utskrift~<br />Klicka på \"Utskriftvänlig version\"-länken och detaljer som inte blir bra på utskrifter (menyer, \"rutor\", extra \"länkar\", frågetecknena för kontextuell hjälp, etc.) kommer att tas bort.<br /><br />På den utskriftsvänliga sidan hittar du en \"skriv ut\"-länk längst ner. Bara klicka på den och din skrivardialog öppnas. Efter du har skrivit ut, klicka på \"tillbaka\"-länken och skärmen laddas om till sitt standardutseende.<br /><br />Tips: Även om den utskriftsvänliga sidan har många länkar borttagna från skärmen, är de kvarvarande fortfarande klickbara.<br />";

$pgv_lang["readme_help"]			= "<span class='center'>Se <a href=\"readme.txt\"=\"_blank\"><b>Readme.txt</b></a> för ytterligare information.</span>";

$pgv_lang["is_user_help"]			= "--- Denna hjälptext är samma för administratörer, användare och besökare. ---<br />--- För att spara plats, har vi inte gjort någon speciell administratörstext för denna artikel. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~REDIGERA RÅ GEDCOM-DATA~<br /><br />När du klickar på denna länk, ett nytt fönster kommer att öppnas med den råa GEDCOM-datan angånde detaljerna på denna sida.<br />Här kan du redigera GEDCOM-datan direkt. försäkra dig om att du skriver in korrekt GEDCOM 5.5.1 data, eftersom ingen validitetskontroll kommer att göras.<br />Den ändrade eller tillagda datan kommer att visas i PhpGedView som ändringar och måste godkännas av en användare med acceptera rättigheter.<br /><br />";
$pgv_lang["RESN_help"]				= "~SÄTTA RESTRIKTIONER PÅ FAKTA~<br /><br />Förutom generalla integritetsinställnignar kan PhpGedView sätta restriktioner för visning och redigering av fakta för personer och familjer. Restriktionerna kan sättas av alla som kan redigera informationen, förutom om integritets eller tidigare satta restriktioner förhindrar detta.<br /><br />Följande värde kan användas:<br /><ul><li>><b>#pgv_lang[none]#</b><br/>Sajtadminstratören, GEDCOM-adminstratören och användare som har rättigheter att redigera kan ändra informationen. Faktainformationen kan ses enligt integritetsinställningar satta av administratören.</li><li><b>#pgv_lang[locked]#</b><br />Denna inställning har ingen påverkan på synligheten av datan. Den sätter redigeringsrättighter till sajtadministratörer eller GEDCOM-administratörer. Om informationen berör honom själv kan han också se och om han har redigeringsrättighter, redigera dem.</li><li><b>#pgv_lang[privacy]#</b><br />Den sätter visnings och redigeringsrättighter till sajtadministratörer eller GEDCOM-administratörer. Om informationen berör användaren själv kan han också se och om han har redigeringsrättighter, redigera dem. Den kommer att var dold för alla andra användare oberoende av deras inloggningsstatus.</li><li><b>#pgv_lang[confidential]#</b><br />Den sätter visnings och redigeringsrättighter till sajtadministratörer eller GEDCOM-administratörer. Den kommer att var dold för alla andra användare oberoende av deras inloggningsstatus.</li></ul><br /><table><tr><th></th><th colspan=\"2\">Admin</th><th colspan=\"2\">Ägare</th><th colspan=\"2\">Andra</th></tr><tr><th></th><th>R</th><th>W</th><th>R</th><th>W</th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\"/> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\"/> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\"/> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\" /></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\"/> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr></table><ul><li>R : kan läsa</li><li>W : kan redigera</li><li><img src=\"images/checked_qm.gif\"/> : beror på globala integritetsinställningar</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~VÄLKOMSTSIDAN~<br /><br />Denna sida är välkomstsidan. Den välkomnar dig till den valda <a href=\"#def_gedcom\">GEDCOM</a> filen. Du kan återvända till denna sida genom att välja välkomstsidan i toppmenyn. Om det finns flera GEDCOM-filer på denna sajt, kan du välja en GEDCOM-fil från rullgardinsmenyn.<br /><b>Du kan hitta information om:</b> (eftersom detta är huvudsidan för PhpGedViewsajten)<ul><li><a href=\"#index_portal\">Välkomstsidan</a><li><a href=\"#header\">Rubrikområden</a><li><a href=\"#menu\">Menyer</a><li><a href=\"#header_general\">Allmän information</a><li><a href=\"#def\">Definitioner</a></ul><br />Version #VERSION# kommer med ett nytt utseende för <a href=\"#def_pgv\">PhpGedView</a>. Menyer, startsidan och många andra funktioner är förbättrade och/eller omgjorda.<br /><br />";


//-- Index-page Header
$pgv_lang["header_help"]			= "<div class='name_head center'><b>RUBRIKOMRÅDE</b></div><br />Rubriken är översta delen av sidan och återkommer på alla sidor.<br />Rubriken innehåller värdefulla länkar som du kan använda överallt.<br />Eftersom sajten kan ha olika utseende beroende av det valda <a href=\"#def_theme\">temat</a>, rubriker kan påverkas och länkar kan variera.<br /><br /><b>Länkar som du kanske hittar är:</b><ul><li><a href=\"#header_search\">Sök Box</a><li><a href=\"#header_lang_select\">Språkväljare</a><li><a href=\"#header_user_links\">Användarlänkar</a><li><a href=\"#header_favorites\">Favoriter</a></ul>";

$pgv_lang["header_search_help"]			= "~Rubrikområde: Sökbox~<br />Denna sökbox är liten men kraftfull.<br />Du kan låta PhpGedView söka efter nästan vad som helst. När du klickar på '<b>></b>' eller <b>Sök</b> knappen, kommer du till huvudsidan för sökning, för att där se resultatet av din sökning.<br />Du kommer att hitta utökad hjälp för sökning på huvudsidan för sökning.<br />";

$pgv_lang["header_lang_select_help"]		= "~Rubrikområde: Språkväljaren~<br />En av de viktigaste funktionerna för PhpGedView är flerspråksstödet och att språk ställs in automatiskt för varje besökare efter webläsarens inställning.<br />Ibland kan det hända att bytet inte sker automatiskt på det sätt som besökare förväntar sig (t.ex. genom att det språk man föredrar inte är korrekt inställt in din nätbläddrare). Adminstratören kan vbegränsa tillgången till visa språk. Beroende på sajtkonfigurationen kan du ändra språket i PhpGedView genom att välja ett passande språk från rullgardinsmenyn eller genom att klicka på en flaggikon. Om du är en registrerad användare, kan du konfigurera PhpGedView att byta till ditt önskade språk efter inloggning, oberoende av din webläsares inställning.<br /><br />";

$pgv_lang["header_user_links_help"]		= "~Rubrikområde: Användarlänkar~<br />Användarlänkar är ett litet område med användbara länkar, som användare kan hitta på samma ställe överallt på hela sajten (så länge som användaren inte ändrar tema).<br />När man inte har loggat in, syns bara <b>Logga in</b>-länken.<br />När du är inloggad kommer du att se:<ul><li><b>Inloggad som (ditt användarnamn)</b>. Om du klickar på den länken kommer du till ditt konto.</li><li><b>Logga ut</b> är uppenbar: den gör exakt det.</li><li>Om du har administratörsrättighter kommer du också se <b>Admin</b>. Om du klickar på den länken kommer du direkt till Administrationshuvudsidan.</li></ul><br />";

$pgv_lang["header_favorites_help"]		= "~Rubrikområde: Mina favoriter~<br />Denna listbox kommer att visa dig dina favoriter som du (kan) har valt på din Personliga portal. Den visar också sajtadminstratörens valda favoriter för den aktiva GEDCOM-filen. Klicka på på en av dina favoriter, kommer att föra dig direkt till #pgv_lang[indi_info]#-sidan för den personen.<br />Mer hjälp för att lägga till favoriter är tillgängliga i den personliga portal.<br />";
$pgv_lang["header_theme_help"]		= "~Rubrikområde: Ändra tema~<br />När detta val är igångsatt av sajtadministratören, ändra temans rullgardinsmeny visar dig en lista på teman du kan använda för denna sajt.<br /><br /> Om du väljer ett tema från menyn så byts temat för sajten. Om du är inloggad, kommer det också att ändra ditt användartema till det du valt.<br /><br />";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class='name_head center'><b>MENYER</b></div><br />I sidhuvudena rullgardinsmenyer.<br />Om du rör muspekaren över en menyikon ger dig en undermeny.<br />Klickar du på menyikonen kommer du till sidan för det första valet i menyn.<br /><br /><b>Du kan välja mellan följande huvudmenyer:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~Välkomstsidans meny~<br />Alla tillgängliga GEDCOM-filer för sajten är listade i denna meny. Alla GEDCOM-filer har sin egen skräddarsydda startsida, som den här. Om det bara finns en GEDCOM-fil på denna sajt så finns det ingen undermeny under välkomstsidans ikon.<br /><br />";
$pgv_lang["menu_myged_help"]			= "~#pgv_lang[mygedview]# Meny~<br />Om du är inloggad, hittar du dessa saker i menyn:<ol><li>#pgv_lang[mygedview]#<br />Denna för dig till din egen \"startsida\".</li><br /><li>#pgv_lang[editowndata]#<br />Du kan redigera dina personliga data här.</li><br /><li>#pgv_lang[my_pedigree]#<br />Om du har valt en startperson för denna GEDCOM, tar detta val dig till antavlan för den personen.</li><br /><li>#pgv_lang[my_indi]#<br /> Denna länk för dig till #pgv_lang[indi_info]#-sidan, där all genealogisk data finns för dig själv och din familj.</li></ol><br />";
$pgv_lang["menu_charts_help"]			= "~Tavelmeny~<br />Alla tillgängliga tavlor är listade i denna meny:<ol><li><a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a><br />Denna länk leder till antavlan för denna filen. Antavlan kommer att starta med probandet i GEDCOM-filen. När du är inloggad däremot kan probandet var du eller någon annan persom du valt.</li><br /><li><a href=\"?help=help_descendancy.php\"><b>#pgv_lang[descend_chart]#</b></a><br />Stamtavlan är mer eller mindre en upp och ner vänd <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>.<br />Jämförelsen är inte riktigt korrekt, medan en antavla visar alla dina anor från en startperson, kommer stamtavlan att visa alla ättlingar efter en startperson.</li><br /><li><a href=\"?help=help_timeline.php\"><b>#pgv_lang[timeline_chart]#</b></a><br />Här visar händelser för en person längs en tidsaxel.</li><br /><li><a href=\"?help=help_relationship.php\"><b>#pgv_lang[relationship_chart]#</b></a><br />Här kan du kontrollera släktskapet mellan en personer med dig själv, eller med en annan person.</li><br /><li><a href=\"?help=help_ancestry.php\"><b>#pgv_lang[ancestry_chart]#</b></a><br />Väldigt lik <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, men med fler detlajer och alternativ <a href=\"?help=chart_style_help\"><b>#pgv_lang[chart_style]#</b></a> visning.</li><br /><li><a href=\"?help=help_fanchart.php\"><b>#pgv_lang[fan_chart]#</b></a><br />Väldigt lik <a href=\"?help=help_pedigree.php\"><b>#pgv_lang[index_header]#</b></a>, men mer grafisk.</li></ol><br />";
$pgv_lang["menu_lists_help"]			= "~Listmeny~<br />Följande listor är tillgängliga i denna meny:<ol><li><a href=\"?help=help_indilist.php\"><b>#pgv_lang[individual_list]#</b></a></li><li><a href=\"?help=help_famlist.php\"><b>#pgv_lang[family_list]#</b></a><br />I dessa två listor kan du lista personer eller familjer i denna GEDCOM i alfabetisk ordning.</li><br /><li><a href=\"?help=help_sourcelist.php\"><b>#pgv_lang[source_list]#</b></a><br />Denna lista returnerar alla källor som används i GEDCOM-filen.</li><br /><li><a href=\"?help=help_placelist.php\"><b>#pgv_lang[place_list]#</b></a><br />Här kan du leta efter personer utifrån orter. En dubbel lista kommer att returneras. Personer är listade till vänster, familjerna till höger.</li><br /><li><a href=\"?help=help_medialist.php\"><b>#pgv_lang[media_list]#</b></a><br />Du kan endast se denna meny om den är tillgängliggjord av administratören. Den kommer att visa en länk till alla multimediafiler som används i GEDCOM-filen.</li></ol><br />";
$pgv_lang["menu_annical_help"]			= "~#pgv_lang[anniversary_calendar]#-meny~<br />#pgv_lang[anniversary_calendar]#  visar händelser i en GEDCOM-fil en bestämd dag, månad eller år.<ol><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewday]#</b></a></li><li><a href=\"?help=day_month_help\"><b>#pgv_lang[viewmonth]#</b></li><li></a><a href=\"?help=day_month_help\"><b>#pgv_lang[viewyear]#</b></a><br />Dessa menyval för dig till #pgv_lang[anniversary_calendar]# för att visa alla händelser för den valda dagen, månad eller år.</li></ol><br />";
$pgv_lang["menu_clip_help"]			= "~Släktträdets urklippskorgsmeny~<br />Om tillgängliggjord av administratören för denna GEDCOM-fil, kommer du att se detta val i menyn.<br />Urklippskorgen tillåter dig att välja personer, familjer och källor och spara dem som familjeträdurklipp i urklippskorgen så att du senare kan ladda ner dem i GEDCOM 5.5 format.<br /><br />";
$pgv_lang["menu_search_help"]			= "~Sökmeny~<br />Söksidan som du kommer till genom att klicka på denna länk, är den mer kraftfulla storebrodern till söklänken som du ibland kan se i huvudet på sidan.<br /><br />";
$pgv_lang["menu_help_help"]			= "~Hjälpmeny~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class='name_head center'><b>VÄLKOMSTSIDAN</b></div><br />";
$pgv_lang["index_portal_help"]			= "Välkomstsidan består av flera separata områden och kan skräddarsys. Så för varje GEDCOM-fil på sajten, på sajter där det finns mer än en, kan du få se olika välkomstsidan.<br /><br /><b>Beroende på hur administratören har ställt in sajten kan du se följande områden på denna välkomstsidan:</b><ul><li><a href=\"#index_welcome\">Välkommen</a><li><a href=\"#index_login\">Inloggning</a><li><a href=\"#index_events\">Kommande händelser</a><li><a href=\"#index_onthisday\">Historiska händelser denna dag</a><li><a href=\"#index_favorites\">GEDCOM favoriter</a><li><a href=\"#index_stats\">GEDCOM-statistik</a><li><a href=\"#index_media\">Slumpmässig Media</a><li><a href=\"#index_loggedin\">Inloggade användare</a><li><a href=\"#gedcom_news\">GEDCOM-nyheter</a><li><a href=\"#recent_changes\">Senaste ändringar</a></ul><br />";
$pgv_lang["index_welcome_help"]			= "~VÄLKOMSTOMRÅDE~<br />Det välkomstområde visar dig:<br />Den nuvarande GEDCOM-filen, datum och tid och (om igångsatt av administratören) träffräknaren.<br />Denna träffräknare hittar du bara i välkomstblocket och på #pgv_lang[indi_info]#-sidan.<br />Denna räknare räknar \"träffarna\" på dessa sidor. Detta betyder: den räknar hur många gånger dessa sidor blir besökta.<br />Räknaren kontrollerar inte länken för besökaren, så när en besökare kommer tillbaka efter en tid kommer han att räknas som en ny träff.<br /><br />";
$pgv_lang["index_login_help"]			= "~INLOGGNINGSOMRÅDE~<br />Även om du kan logga in på nästan vilken sida som helst i programmet, vill du oftast logga in på första sidan, eftersom du endast kan komma åt tillåten information när du är inloggad.<br />Du kan logga in genom att skriva ditt <b>användarnamn</b> och <b>lösenord</b> och klicka på logga in knappen.<br /><br />";
$pgv_lang["index_events_help"]			= "~KOMMANDE HÄNDELSEROMRÅDE~<br />Detta område kommer att visa händelser från idag och den kommande månaden.<br /><br />";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br /> Skriv in det antal dagar som ska visas. Man kan inte ange nummer högre än <b>#DAYS_TO_SHOW_LIMIT#</b>. Om du anger ett högre tal kommer den gränsen att användas.<br /><br />Begränsningen som visas är satt av administratören i GEDCOM-konfigurationen, Visa och Layout sektionen, Dölj & Visa undersektionen.<br />";
$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />Detta val låter dig välja vilken typ av media som ska visas.<br /><br />När du väljer <b>#pgv_lang[random_media_persons]#</b> kommer endast media associerad med personer att visas. Det äe vanligtvis personens fotografi. När du väljer <b>#pgv_lang[random_media_events]#</b> kommer endast media associerade med fakta eller händelser att visas. Det kan vara en bild av ett certifikat. När du väljer <b>#pgv_lang[all]#</b> kommer all media att visas.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Denna inställning låter dig tabort visa daterade händelser. T.ex. #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. ska alla vara daterade.<br /><br />När du väljer <b>Ja</b> kommer endast födelse, döds och vigslar att visas. När du väljer <b>Nej></b> kommer alla händelser att visas.";
$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />Denna funktion kontrollerar hur informationen presenteras.<br /><br />När du väljer <b>#pgv_lang[style1]#</b>, visas informationen i textformat, liknande det du ser i de olika tavlornas rutor. Detta format är väl lämpat för områden som skriver på högersidan av sidan.<br /><br />När du väljer <b>#pgv_lang[style2]#</b>, visas informationen i tabellform och lämpar sig bättre till de stora områdena som visas på vänstersidan av sidan.";
$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />Denna funktion kontrollerar om knappen för nerladdning av kalenderhändelser visas för inloggade användare. Den nerladdad kalenderfilen kan importeras i kompatibla program som Microsoft Outlook för att t.ex. generera automatiska e-postmeddelande för högtidsdagar.<br /><br />När du sätter den till <b>#pgv_lang[no]#</b>, kommer den inloggade användaren inte kunna ladda ner kalenderfilen. När du sätter den till  <b>#pgv_lang[yes]#</b>, visas nerladdningsknappen. Denna knapp visas aldrig för användare som inte är inloggade.";
$pgv_lang["index_onthisday_help"]		= "~PÅ DENNA DAGEN, I DIN HISTORIA~<br />Detta område har fungerar på samma sätt som området \"Kommande händelser\" det som skiljer är att här visas händelser för i dag.<br /><br />";
$pgv_lang["index_favorites_help"]		= "~GEDCOMFAVORITOMRÅDE~<br />GEDCOM-favoriter är, mer eller mindre, lika dan som \"Mina favoriter\" i #pgv_lang[mygedview]#-sidan. Med i detta fall, endast administratören, eller en användare med administratörsrättigheter, kan lägga till, ta bort, eller ändra favoriter.<br /><br />Meningen med GEDCOM-favoriter är att dra uppmärksamheten till en person (eller personer) av stort intresse.<br />På varje sida i på sajten, är \"Denna GEDCOMs favoriter\" tillgänglig från rullgardinsmenyn i rubrikområdet.<br /><br />Detta kommer att flytta dig till #pgv_lang[indi_info]#-sidan.<br /><br />";
$pgv_lang["index_add_favorites_help"]	= "~LÄGG TILL EN FAVORIT~<br />Detta formulär tillåter dig att lägga till ett nytt favoritobjekt till din lista över favoriter. Du måste skriva in antingen ett ID för personen, familjen eller källan som du vill lägga till som favorit elelr så lägger du till en URL och en titel. Anteckningsfältet är valfritt och kan användas för att beskriva favoriten. Det som skrivs in i antevkningsfältet kommer att visas favoritområdet efter objektet.<br /><br />";
$pgv_lang["index_stats_help"]			= "~GEDCOMSTATISTIKOMRÅDE~<br />I detta block kommer du att se lite statistik om den nuvarande GEDCOM-filen.<br />Om du vill ha mer information kan du sända ett meddelande till kontakten längst ner på sidan.<br /><br />";
$pgv_lang["index_common_names_help"]		= "~DE VANLIGASTE EFTERNAMNEN~<br />I denna del visas de efternamn som är vanligast i denna GEDCOM-fil. Antalet namn som visas ställs in av administratören.<br />(Den nuvarande inställningen är efternamn som finns i GEDCOM-filen fler gånger än #COMMON_NAMES_THRESHOLD#)<br /><br />Namnet är klickbara. Klicka på ett namn tar dig till #pgv_lang[individual_list]#, Där du får mer information om namnet.<br /><br />";
$pgv_lang["index_media_help"]			= "~SLUMPMÄSSIG MEDIA OMRÅDE~<br />I detta område väljer PhpGedView slumpmässigt ut en mediafil vid varje besök på denna sida.<br /><br />Klicka på bilden eller på dess namn kommer att ge dig den fullskaliga versionen av bilden. Under bilden finns en länk till personen som har anknytningen till bilden. Klicka på personens namn och du kommer att förflyttas till denna #pgv_lang[indi_info]#-sida.<br /><br />";
$pgv_lang["index_loggedin_help"]		= "~INLOGGADE ANVÄNDAROMRÅDE~<br />Detta område kommer att visa dig antalet användare som för tillfället är inloggade.<br /><br />";
$pgv_lang["index_gedcom_news_help"]		= "~GEDCOMNYHETSOMRÅDE~<br />Nyhetsområdet är som en anslagstavla för denna GEDCOM-fil. Administratören kan lägga upp viktiga meddelande eller intressanta nyheter här.<br /><br />Om du har något intressant att visa, kontakta administratören så kan han lägga upp ditt meddelande på anslagstavlan.<br /><br />";
$pgv_lang["recent_changes_help"]			= "~NYLIGEN ÄNDRAT OMRÅDE~<br />Detta område visar dig de senaste ändringarna som har gjorts i GEDCOM-filen enligt CHAN GEDCOM-taggen.<br /><br />";
$pgv_lang["gedcom_news_limit_help"]		= "Du kan begränsa antalet nyhetsartiklar som visas och därigenom minska höjden för GEDCOM-nyhetsområdet.<br /><br />Detta val bestämmer om det ska finnas någon gräns eller om gränsen ska vara efter ålder för nyheten eller efter antalet artiklar.<br /><br />";
$pgv_lang["gedcom_news_flag_help"]		= "Skriv in det begränsande värdet här.<br /><br />Om du har valt att begränsa visningen av nyheter via ålder, kommer alla artikler äldre än det antalet dagar du skriver in här att gömmas. Om du har valt att begränsa visningen av antalet nyhetsartiklar via antal, kommer endast det antalet som specificeras här, i åldersordning, att visas. De resterande artiklarna kommer att gömmas.<br /><br />Skriver du in nollor här kommer alla artiklar att visas.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]	= "För att minska höjden på nyhetområdet har administratören dolt vissa artiklar, Du kan visa dessa dolda artiklar genom att klicka på <b>#pgv_lang[gedcom_news_archive]#</b>.<br />";
$pgv_lang["index_htmlplus_help"]		= "~AVANCERAT HTML OMRÅDE~<br />Detta område låter administratören att lägga till information till index eller portalsidan. Meningen med området är ungefär detsamma som med HTML, nyheter och GEDOM statistik området, men adminsitratören har mer kontroll över dess utseende.<br /><br />";
$pgv_lang["index_htmlplus_title_help"]	= "Denna text ska vara kort eller tom. När den är tom, kommer det avancerade HTML-området visas på index eller portal sidan som ett vanligt område. När det finns en text, kommer Avancerade HTML-området att visas som alla andra områden komplett med rubrik som innehåller texten du skrivit in här.";
$pgv_lang["index_htmlplus_template_help"]	= "För att hjälpa dig komma igång med det område har vi skapat flera standardmallar. När du väljer en av de mallarna kommer textområdet att innehålla en kopia som du kan ändra så att den passar din sajt.";
$pgv_lang["index_htmlplus_content_help"]	= "Till skillnad ifrån HTML, nyheter och GEDCOM-statistikområdet så har du full kontroll över utseendet på detta område. Du kan använda HTML-taggar och området använder CSS stilscheman ifrån det aktiva temat. Referenser till infromation i den aktiva databasen kan inkluderas i texten.<br /><br />Databasreferenser signalleras i texten genom att innesluta nyckelord inom par av <b>&#35;</b> symboler. T.ex <b>&#35;TOTAL_FAM&#35;</b> representerar antalet familjer i databasen. Du kanske ibland vill använda en databasreferens som text istället för dess igentliga mening. För att göra det måste du byta ut <b>&#35;</b> symbolerna som finns runt nyckelordet med deras symboliska motsvarighet. T.ex. om din text inehåller <b>&&#35;35;TOTAL_FAM&amp&#35;35;</b> kommer den att skrivas ut som <b>&#35;TOTAL_FAM&#35;</b> istället för att bli en databasreferens. Listan av nyckelord är:<br /><table><tr valign=top><td><ul><li>COMMON_SURNAMES</li><li>TOTAL_INDI</li><li>TOTAL_FAM</li><li>TOTAL_SOUR</li><li>TOTAL_OTHER</li><li>TOTAL_SURNAMES</li><li>TOTAL_MALES</li><li>TOTAL_FEMALES</li><li>TOTAL_UNKNOWN_SEX</li><li>TOTAL_EVENTS</li><li>TOTAL_EVENTS_BIRTH</li><li>TOTAL_EVENTS_DEATH</li><li>TOTAL_EVENTS_MARRIAGE</li><li>TOTAL_EVENTS_OTHER</li><li>TOTAL_USERS</li><li>FIRST_EVENT</li><li>FIRST_EVENT_TYPE</li><li>FIRST_EVENT_NAME</li><li>FIRST_EVENT_YEAR</li><li>LAST_EVENT</li><li>LAST_EVENT_TYPE</li><li>LAST_EVENT_NAME</li><li>LAST_EVENT_YEAR</li><li>FIRST_BIRTH</li><li>FIRST_BIRTH_NAME</li><li>FIRST_BIRTH_YEAR</li></ul></td><td><ul><li>LAST_BIRTH</li><li>LAST_BIRTH_NAME</li><li>LAST_BIRTH_YEAR</li><li>LONG_LIFE</li><li>LONG_LIFE_NAME</li><li>LONG_LIFE_AGE</li><li>TOP10_OLDEST</li><li>AVG_LIFE</li><li>MOST_CHILD</li><li>MOST_CHILD_NAME</li><li>MOST_CHILD_TOTAL</li><li>TOP10_BIGFAM</li><li>AVG_CHILD</li><li>HIGHLIGHT</li><li>GEDCOM</li><li>GEDCOM_ID</li><li>GEDCOM_TITLE</li><li>CREATED_SOFTWARE</li><li>CREATED_VERSION</li><li>CREATED_DATE</li><li>GEDCOM_UPDATED</li><li>GEDCOM_CONTACT</li><li>WEBMASTER_CONTACT</li></ul></td></tr></table><br />";
$pgv_lang["index_htmlplus_compat_help"]	= "Kryssa i detta val for kompatibilitet med äldre versioner av detta block. Detta tillåter användning av det äldre tag-formatet med en liten förlust i hastighet.<br /><br />Användning av denna inställning är inte rekomenderad.<br /><br />";
$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br />Välj databasen för vilket nyckelorden avses.<br /><br />Din sajt stöder flera databaser. Nyckelord som <b>&#35;totalFamilies&#35;</b> kan endast referara till en databas. Du kan ange databas för som ska användas för dessa typer av nyckelord. Varje #pgv_lang[htmlplus_block_name]#-område kan endast accessa en databas.<br /><br />";

//-- Index-Page Help
$pgv_lang["help_help"]				= "Det hade förstås varit perfekt att göra ett program som är så enklet att det inte behöver några förklaringar alls.<br /><br />Det skulle vara lika enkelt som att läsa en bok.<br />Även om programmet är ganska komplicerat så märker du inte det i användargrännsnittet. Nästan allt kan användas utan förklaring. Men eftersom vi har många besökare och användare som inte är så erfarna med att använda datorer eller internet så erbjuder vi hjälp lite hjälp på visa ställen.<br /><br />I hjälpmenyn hittar du följande artiklar:";
$pgv_lang["help_page_help"]			= "<dl><dt><b>Hjälp med denna sida</b></dt><dd>För alla sidor finns det en allmän \"hjälpsida\" tillgänglig.<br />När du är på en sida kan du klicka på denna artikel i menyn kommer du att få upp \"Sidhjälp\" som informera dig om artiklarna du kan hitta på just denna sida.<br />Sidhjälpen är för det mesta kortfattad.<br />Om du behöver mer hjälp, eller information, om en viss artikel på sidan så finns det tredje alternativet på hjälpmenyn: \"Kontextuell hjälp\".</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>artikel Hjälp innehåll</b></dt><dd>Om du klickar på denna meny får du upp hjälpfönstret, som visar ett index över de större hjälpartiklar.<br />Detta index kommer ha fler artiklar, inom en snar framtid, eftersom också de mindre hjälpartiklarna kommer att indexeras.</dd></dl>";
$pgv_lang["help_faq_help"]			= "<dl><dt><b>FAQ Lista</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]			= "<dl><dt><b>Dölj / Visa kontextuell hjälp</b></dt><dd>Detta sista menyval är kanske det mest behändiga för dig. klicka på denna länk kommer antingen sätta på eller stänga av den \"Kontextuella hjälpen\".<br />Vad är \"Kontextuell hjälp\"?<br />När den är aktiv, hittar du frågetecken till höger om länkar rullgardinsmenyer eller knappar. Klickar man på detta <b>?</b> öppnas ett litet hjälpfönster med lite mer information om detta objekt.<br />Naturligtvis d??ljs alla frågetecken när du klicka på \"Dölj kontextuell hjälp\".</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class='name_head center'><b>#pgv_lang[definitions]#</b></div><br />Några definitioner av ord som används i hjälptexterna:<ul><li><a href=\"#def_gedcom\">GEDCOM</a><br /><li><a href=\"#def_gedcom_date\">Datum</a><li><a href=\"#def_pgv\">PhpGedView</a><li><a href=\"#def_portal\">Portal</a><li><a href=\"#def_theme\">Tema</a></ul><br />";
$pgv_lang["def_portal_help"]			= "~Portal~<br />Också på denna sida är en portal som en lobby på en resturang. Det är stället där du startar, men du kan också få viktig information som förklaringar, menyer och liknande..<br /><br />";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM-fil~<br />Ett citat från introduktion för GEDCOM 5.5.1 standarden:<div class=\"list_value_wrap\">GEDCOM är utvecklad av Family History Department inom kyrkan Jesu Kristi Kyrka av Sista Dagars Heliga(LDS) för att erbjuda ett flexibelt, enhetligt format för att utbyta genealogisk data.&nbsp; GEDCOM är en förkortning för<br /><i><b>GE</b></i>nealogical <i><b>D</b></i>ata<i><b>Com</b></i>munication.&nbsp; Syftet är att gynna utbyte av genealogisk information och utvecklingen av stor variation av sammarbetande mjukvaruprodukter för att hjälpa släktforskare, historiker och andra forskare.</div><br />En kopia av GEDCOM 5.5.1 <u>förslag</u> till standard, vilket PhpGedView följer, kan laddas ner i pdfformat från <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank>GEDCOM 5.5.1 Standard</a> standraden finns endast på engelska.<br /><br />GEDCOM-filen är den fil som innehåller all information om familjen. Alla fakta, datumar, händelser o.s.v. är sparade i GEDCOM-filen. En GEDCOM-fil måste följa strikta regler, eftersom den är utbytbar mellan måna progam, oberoende av platform och/eller system.<br /><br />";
$pgv_lang["def_gedcom_date_help"]		= "~Datum i en GEDCOM-fil~<br />Även om datumfältet i GEDCOM-filen är ett fritt fält (vilket betyder att du kan egentligen skriva in vad som helst), det finns en del regler för hur datum ska skrivas enligt GEDCOM 5.5.1 standarden.<ol><li>Ett fullständigt datum ser ut så här DD MMM ÅÅÅÅ t.ex.:<b>01 Mar 1801</b> eller <b>14 dec 1950</b>.</li><li>Om du saknar en del av datumet kan du hoppa över den delen t.ex.:<b>abt Mar 1801 (abt=omkring)</b> eller <b>14&nbsp;Dec</b> <b>bef 20 Dec 1950</b> (bef=före)<b>aft 1949</b> (aft=efter)</li></ol><b>Försäkra dig om att skriva in dessa datum och förkortningar på <u>Engelska</u></b>, eftersom då blir GEDCOM-filen möjlig att flytta mellan olika program och programmet kommer att översätta alla datum och förkortningar korrekt till önskat språk. Programmet måste också räkna med datumar. Om du skrivit in felaktiga datum i datumfältet i GEDCOM-filen, kommer programmet in kunna beräkna datum korrekt.<br /><br />Klicka på kalenderikonen för hjälp att välja ett datum.<br /><br />";
$pgv_lang["def_gramps_help"]		= "~GRAMPS XML Databasfil~<br />Ett citat från GRAMPS projektet: <div class=\"list_value_wrap\">GRAMPS helps you track your family tree. It allows you to store, edit, and research genealogical data. GRAMPS attempts to provide all of the common capabilities of other genealogical programs, but, more importantly, to provide an additional capability of integration not common to these programs. This is the ability to input any bits and pieces of information directly into GRAMPS and rearrange/manipulate any/all data events in the entire data base (in any order or sequence) to assist the user in doing research, analysis and correlation with the potential of filling relationship gaps.</div><br />En kopia av av GRAMPS XML format v.1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">kan hittas här</a> i både RELAX NG schema format och DTD format.<br /><br />För mer information om GRAMPS projektet besök  <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]			= "~PhpGedView~<br />PhpGedView (eller PGV) är ett program, designat av John Finlay för att visa GEDCOM-filer på internet.<br /><br />Som du ser skapar inte programmet statiska sidor för visningen på internet, utan är dynamiskt och kan bli anpassat på många sätt. John började utvecklingen av programet själv, men nu så arbetar ett helt internationellt lag av utvecklare och översättare för att förbättra programmet.<br />Förutom att visa GEDCOM-innehållet kan anv??ndaren även lägga till och ändra händelser direkt på nätet.<br /><br />";
$pgv_lang["def_theme_help"]			= "~Tema~<br />Denna sajt kan några olika utseende, kallade teman.<br /><br />Sajtadministratören väljer ett tema för uppstarten. Alla som kommer till sajten kommer att de samma utseende(tema)på sajten. När administratören satt upp sajten så att inloggade användare kan välja sitt eget tema, kan de själv välja vilket som de tycker ser bäst ut. Om en användare har valt ett eget tema, kommer han/hon ha det utseendet på sajten så snart hon loggat in.<br /><br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[mygedview]#~<br />Detta är din personliga #pgv_lang[mgv]#sidan.<br />Du kan här hitta snabblänkar till dina personliga data, som <b>Mitt konto, Min person</b> (detta är din ansedel), <b>Min antavla</b>.<br />Dessutom kan du ha områden för <b>Meddelande</b>, <b>Anteckningar</b> och många fler.<br /><br />Utseendet på denna sida är detsamma som välkomstsidan.<br />Medan välkomstsidan är ihopsatt av administratören, kan du välja mellan många olika områden, för att bygga sidan som du vill ha den (inom vissa gränser).<br /><br />I välkomstområdet på denna sida hittar du länken för att skräddarsy denna sida.<br /><br /><b>Du kan välja mellan följande områden:</b><ul><li><a href=\"#mygedview_welcome\">Välkommen</a><li><a href=\"#mygedview_customize\">Skräddarsy min GedView</a><li><a href=\"#mygedview_message\">Meddelande</a><li><a href=\"#mygedview_events\">Kommande händelser</a><li><a href=\"#mygedview_onthisday\">Historiska händelser denna dag</a><li><a href=\"#mygedview_favorites\">Mina Favoriter</a><li><a href=\"#mygedview_stats\">GEDCOM-Statistik</a><li><a href=\"#mygedview_myjournal\">Mina anteckningar</a><li><a href=\"#mygedview_media\">Slumpmässiga Media</a><li><a href=\"#mygedview_loggedin\">Inloggade användare</a>href=\"#mygedview_recent_changes\"><b>Nyligen gjorda förändringar</b></a></ul><br />";
$pgv_lang["mygedview_customize_help"]		= "~SKRÄDDARSY #pgv_lang[mygedview]#~<br />När du kom hit för första gången, fanns det redan några områden på sidan. Om du vill kan du skräddarsy denna portal.<br /><br />Om du klickar på denna länk kommer du till ett formulär i ett nytt fönster, i vilket du kan lägga till, ta bort, eller flytta omkring områdena. Mer hjälp finns i formuläret.<br /><br />";
$pgv_lang["mygedview_message_help"]		= "~MEDDELANDEOMRÅDE~<br />I detta område hittar du meddelandena skickade till dig från andra användare, eller från administratören.<br />Du kan självklart skicka egna meddelanden till andra användare eller administratören.<br /><br />PhpGedViews e-postsystem är designat för att skydda din integritet. Du behöver inte lämna ut din e-postadress här och andra kommer inte att se din e-postadress.<br /><br />För att expandera ett meddelande klicka på ämnesraden för meddelandet eller \"<b>+</b>\"-tecknet sidan om det. Du kan radera flera meddelande genom att kryssa i rutan sidan om ett meddelande som du vill radera och klicka på \"Radera markerade meddelande\" knappen.<br /><br />";
$pgv_lang["mygedview_favorites_help"]		= "~MINA FAVORITEROMRÅDE~<br />Mina favorter fungerar som att lägga till bokmärken.<br /><br />Anta du har någon i ditt släktträd, vilkens post du vill kontrollera regelbundet.<br />Då går du bara till den personens #pgv_lang[indi_info]#-sida och klickar på länken <b>Lägg till mina favoriter</b>. Denna person är nu tillagd som bokmärke i dina favoriter listan. Var du än är på sajten, kan du klicka på ett namn i rullgardinsmenyn i huvudet.<br />Detta kommer att flytta dig till #pgv_lang[indi_info]# för denna person.<br /><br />";
$pgv_lang["mygedview_myjournal_help"]		= "~MITT ANTECKNINGSOMRÅDE~<br />Du kan använda denna journal att skriva anteckningar (eller påminnelser) för ditt eget bruk.<br />När du gör en anteckning kommer den förstås att vara kvar nästa gång du besöker sidan.<br /><br />Dessa anteckningar kommer inte att vara synliga för andra.<br /><br />";
$pgv_lang["mygedview_welcome_help"]		= "~VÄLKOMSTOMRÅDE~<dt>Detta välkomstområde visar dig:<ul><li>Den aktuella GEDCOM-filen.</li><li>Datum och tid</li><li>Länkar till:</li><ul><li>#pgv_lang[myuserdata]#</li><li>#pgv_lang[my_pedigree]#</li><li>#pgv_lang[my_indi]#</li><li>#pgv_lang[customize_page]#</li></ul></ul><br /><b>Anmärkning:</b><br />Du ser bara länkarna till <b>Min person</b> och <b>Min antavla</b> om du har en känd för den aktuella GEDCOM-filen. Så det kan vara så att i en GEDCOM-fil har du en post och därför ser länkarna medan i en annan ser du inte länkarna.<br /><br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~ANTAVLANS SIDA.~<br /><br />Antavlan är en uppräkning av alla anor till startpersonen.<br />När du kommer till denna sajt är startpersonen personen längst till vänster(när du loggar in kan du välja din egen startperson).<br /><br />Så alla anor betyder far och mor coch deras far och mor osv. På denna sida ser du anorna i en grafisk vy. Du behöver inte kämpa igenom sidor av text för att hitta dina anor. Alla personer visas i namnboxar på skärmen.<br /><ul><li><b>Namnboxar i antavlan</b><br />Om antavlan är satt att visa detaljer, kommer du att se personens namn och datumet för födelse och död.<br />Du kan klicka på en persons namn, du blir du förflyttad till personens #pgv_lang[indi_info]#.<br /><br />När <b>visa detljer</b> är på så finns det två ikoner inuti namnboxen.</li><br /><li><b>Antavleikonen inuti namnboxen</b><br />När <b>visa detaljer</b> är på, kan du se en antavleikon inuti namnboxen. Beroende på sajt-inställningar måste du sväva över ikonen eller klicka på den.<br />Så, när du klickar på den eller svävar över den, visar sig en liten undermenyn.<br />Valen <b>#pgv_lang[index_header]#</b> och <b>#pgv_lang[descend_chart]#</b>är lika dem i huvudmenyn, skillnaden är att personen i namnboxen blir startperson. Dessutom ser du <b>#pgv_lang[as_spouse]#</b>. Du ser namnet på maken/an följt av namnet/n på barnen. Alla namnen är klickbara.</li><br /><li><b>Förstoringsglaset inuti namnboxen</b><br />Beroende på sajt-inställningar, måste du sväva över eller klicka på det.<br />Detta förstorar namnboxen, så att fler detaljer visas.<br />Du ser fler händelser och datum. Namnen är klickbara.</li><br /><li><b>Pilarna</b><br />Till vänster eller höger om de yttersta namnboxarna kan du se pilar.<br />Om man klickar på dessa pilar så \"skiftar man\" skärmen i pilens riktning.</li></ul><br />#pgv_lang[context_help]#<br/ ><br />";
$pgv_lang["show_full_help"]			= "~GÖM ELLER VISA DETALJER~<br /><br />Med denna inställning kan du antingen visa eller dölja detljererna i namnboxarna. Med detljerna dolda kan du visa fler boxar på skärmen.<br /><br />När du väljer inställningen göm detaljer kan du ändå se detaljerna via förstoringsglaset om det är igång i normal vy.<br /><br />Detta beror på hur adminstratören har konfigurerat programmet. Om du normalt behöver klicka på förstoringsglaset för att zooma in rutan då kan du visa detljerna genom att klicka på namnboxen. Om du normalt zoomar in genom att sväva över rutan så fungerar det på samma sätt över den \"enklare boxen\".<br /><br />";
$pgv_lang["talloffset_help"]			= "~SID LAYOUT~<br /><br />Med denna inställning bestämmer du Sidlayoutens orientering.<br /><br />Ändring av denna inställning kan var användbar om du vill göra en skärm dump eller om du har en ovanlig skärmtyp. Väljer du stående kommer att göra trädet högre, så att en 4 generationers tavla bör få plats på en stående sida. Liggande gör trädet bredare så att det bör få plats på en liggande sida.<br /><br />";
$pgv_lang["rootid_help"]			= "~NY STARTPERSON~<br /><br />Om du vill visa trädet med en ny startperson, då kan du  skriva in den nya personens ID i denna ruta.<br /><br />Om du inte vet personens ID, använd <b>Sök ID</b> länken.<br /><br /><b>IDNUMMER</b><br />Idnummerna som används inuti PhpGedView är <u>inte</u> personens personnummer!<br />Idnummret är endast ett nummer som används i GEDCOM-filen och ges av det släktforskningsprogram som användes för att skapa GEDCOM-filen som importeras av PhpGedView.<br /><br />";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~ANTAL GENERATIONER~<br /><br />Här kan ställa in antalet generationer du vill visa på denna sida.<br /><br />Vad som är bra för dig beror på storleken på skärmen och om du har visa detaljer på. Processtiden kommer att öka med antelet generationerna.<br /><br />";

//-- LOGIN-page
$pgv_lang["login_page_help"]		= "~LOGINSIDAN~<br /><br />På denna sida kan du logga in, begära ett nytt lösenord eller begära ett nytt användarkonto.<br />";
$pgv_lang["username_help"]			= "~ANVÄNDARNAMN~<br /><br />I denna box skriver du ditt användarnamn.<br /><br />Användarnamnet måste skrivas korrekt med stora och små bokstäver.<br /><br />";
$pgv_lang["password_help"]			= "~LÖSENORD~<br /><br />I denna box skriver du in lösenordet.<br /><br />Lösenordet måste skrivas in korrekt med små och stora bokstäver.<br /><br />";
$pgv_lang["login_buttons_help"]		= "~LOGINKNAPPAR~<br /><br />Här ser du två inloggningsknappar för att logga in på systemet.<br />Till vilken sida du blir förflyttad till, beror på vilken knapp du trycker på efter att skrivit in ditt användarnamn och lösenord.<br /></ul><li><b>#pgv_lang[login]#</b> knappen<br />Om du trycker på denna knapp, återvänder du till sidan du kom ifrån.<br />Alltså om du klickade på <b>#pgv_lang[login]#</b> när du var på antavlan återvänder du till den sidan. Om du klickar på denna knapp när du var på huvud välkomstsidan, kommer du till #pgv_lang[mygedview]#-sidan.</li><br /><li><b>#pgv_lang[admin]#</b>-knapppen<br />Om du har adminstratörsrättigheter kan du klicka på denna knapp och förflyttas direkt till huvudadminsrationssidan.</li></ul><br />";
$pgv_lang["login_buttons_aut_help"]	= "~AUTENTICIERINGSMOD INLOGGNINGSKNAPPAR~<br /><br />Här ser du två knappar för att logga in på systemet.<br /><br />Till vilken sida du blir förflyttad beror på vilken knapp du trycker på efter att du skrivit in ditt användarnanmn och lösenord.<br /><ul><li>The <b>#pgv_lang[login]#</b>-knappen<br />Om du trycker på denna knapp, kommer du till direkt till #pgv_lang[mygedview]#-sidan, där du kan ändra dina inställningar, lägga till och editera favoriter, skicka och läsa meddelande osv.</li><br /><li>The <b>#pgv_lang[admin]#</b>-knapppen<br />Om du har adminstratörsrättigheter kan du klicka på denna knapp och förflyttas direkt till huvudadminstrationssidan.</li></ul><br />";
$pgv_lang["new_password_help"]		= "~BEGÄR NYTT LÖSENORD~<br />Om du glömt dit lösenord kan du klicka på denna länk och begära ett nytt<br /><br />Du kommer att flyttas till \"Förlorat lösenordssidan\".<br /><br />";
$pgv_lang["new_user_help"]			= "~BEGÄR NYTT ANVÄNDARKONTO~<br /><br />Om du är besökare på denna sida och vill begära att få ett användarkonto ska du klicka på denna länk.<br /><br />Du kommer att flyttas till \"Registera konto\"-sidan.<br /><br />";
$pgv_lang["mygedview_login_help"]	= "För att kunna besöka #pgv_lang[mygedview]# måste du vara en registrerad användare på systemet.<br /><br />Med #pgv_lang[mygedview]# kan du sätta bokmärke på dina favorit personer, hålla en användarjournal, hantera meddelande, se andra inloggade användare och skräddarsy din upplevelse av PhpGedView.<br /><br />Skriv in användarnamn och lösenord i fälten, med detta namn loggar du in på min #pgv_lang[mgv]#.<br /><br />";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I denna ruta ska du skriva in ditt förnamn.<br /><br />Vi behöver ditt förnamn och efternamn för att kunna avgöra om du kan få ett konto på denna sajt och vilka rättigheter du bör få. Dessa namn kommer att vara synliga för andra inloggade användare.<br /><br />";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I denna ruta ska du skriva in ditt efternamn.<br /><br />Vi behöver ditt förnamn och efternamn för att kunna avgöra om du kan få ett konto på denna sajt och vilka rättigheter du bör få. Dessa namn kommer att vara synliga för andra inloggade användare.<br /><br />";
$pgv_lang["register_info_01"]		= "~BEGÄR NYTT ANVÄNDARKONTO~<br /><br />Mängden data som kan ses av alla på denna sajt kan vara begränsad pga lagar som rör personers privatliv (PUL). De flesta människor vill inte ha sin personliga information tillgänglig på internet, då sådan information kan missbrukas för t ex spam eller identitetsstöld.<br /><br />För att få tillgång till den privata informationen måste du ha ett konto på denna sajt. Du kan registrera dig för att få konto och efter att administratören har kontrollerat och godkänt din ansökan, så kan du logga in och se den privata informationen.<br /><br />Om dessutom finessen relationssäkerhet är aktiverad, kommer du bara att kunna se privat information om dina egna nära släktingar. Administratören kan också ge rättigheter för att ändra och lägga till information i databasen.<br /><br />Om du behöver mer hjälp, använd länken nedan och kontakta administratören.<br /><br /> ";
$pgv_lang["register_info_02"]		= "~BEGÄR NYTT ANVÄNDARKONTO~<br /><br />Mängden data som kan ses av alla på denna sajt kan vara begränsad pga lagar som rör personers privatliv (PUL). De flesta människor vill inte ha sin personliga information tillgänglig på internet, då sådan information kan missbrukas för t ex spam eller identitetsstöld.<br /><br />Tillgång till denna sajt är endast tillgänglig för <u>behöriga</u> användare. Efter administratören har verifierat och godkänt din kontoansökan, kan du logga in och för att se privat data.<br /><br />Om dessutom finessen relationssäkerhet är aktiverad, kommer du bara att kunna se privat information om dina egna nära släktingar. Administratören kan också ge rättigheter för att ändra och lägga till information i databasen.<br /><br />Om du behöver mer hjälp, använd länken nedan och kontakta administratören.<br /><br /> ";
$pgv_lang["register_info_03"]		= "~REQUEST NEW USER ACCOUNT~<br /><br />Mängden data som kan ses av alla på denna sajt kan vara begränsad pga lagar som rör personers privatliv (PUL). De flesta människor vill inte ha sin personliga information tillgänglig på internet, då sådan information kan missbrukas för t ex spam eller identitetsstöld.<br /><br />Tillgång till denna sajt är endast tillgänglig för <u>familjemedlemar</u>. Efter administratören har verifierat och godkänt din kontoansökan, kan du logga in och för att se privat data.<br /><br />Om dessutom finessen relationssäkerhet är aktiverad, kommer du bara att kunna se privat information om dina egna nära släktingar. Administratören kan också ge rättigheter för att ändra och lägga till information i databasen.<br /><br />Om du inte är en nära släkting kommer du troligen inte att få några rättighter så det är inte värt besväret att försöka.<br />Om du behöver mer hjälp, använd länken nedan och kontakta administratören.<br /><br /> ";
//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~STAMTAVLA~<br /><br />Denna sida visar ättlingar till en person.<br />Du kan välja en annan startperson för stamtavlan på denna sida eller du kan länkas till denna sida genom klicka på <b>#pgv_lang[descend_chart]#</b> från en annan sida.<br />Klicka på upp-pilen för att komma högre upp i trädet. Klicka på tavleikonen i en personruta för att göra denna person till rot i trädet.<br /><br />";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";
$pgv_lang["help_lifespan.php"]			= "~LIVSLINJETAVLA~<br /><br />I denna tavla kan du visa en eller flera personer längs en horizontel tidslinje. Denna tavla låter dig se hur liven för olika personer överlappar.<br /><br />Du kan lägga till personer till tavlan en och en eller som familjegrupp via deras ID. Den tidigare listan koms ihåg medan du lägger till fler personer till tavlan. Du kan rensa tavlan när du vill med <b>Rensa tavla</b>-knappen.<br /><br />Du kan också lägga till personer till tavlan genom att söka via datumområde eller orter.<br /><br />";
$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#~Inkludera närstående familj kryssruta~<br />Inkludera närstående familj är i kryssad som standard. Lämna den i kryssad för att visa föräldrar, make/maka, syskon och barn för personen som läggs till tidslinjen. Tabort krysset om du inte vill att den närstående familjen ska visas.<br /><br />";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]			= "~TIDSLINJE~<br /><br />På denna sida visa en eller flera personer längs en tidslinje. På detta sätt du t.ex. visa statusen för två eller flera personer vid ett visst tillfälle.<br /><br />Om du klickar på <b>Tidslinje</b> länken från en annan sida kommer du se den personen på tidslinjetavlan.<br />Om du klickar på <b>Tidslinjetavlan</b> i menyn, kommer du att behöva skriva in ID på en person att starta med.<br /><br />";
$pgv_lang["add_person_help"]			= "~LÄGG TILL PERSON TILL TAVLAN~<br /><br />Du kan ange flera personer på tidslinjen.<br /><br />Använd boxen för att fylla en persons ID. Om du inte vet personens ID kan du klicka på <b>Sök ID</b> länken sidan om boxen.<br /><br />";
$pgv_lang["remove_person_help"]			= "~TABORT PERSON FRÅN TAVLAN~<br /><br />Klicka på denna länk för att ta bort personen från tidslinjen.<br /><br />";
$pgv_lang["show_age_marker_help"]		= "~VISA ÅLDERSMARKÖR~<br /><br />Om du klickar i denna box kommer du se en åldersmarkör som du kan flytta upp och ner längs tidslinjen.<br /><br />Denna glidande åldersmarkör är ett trevligt verktyg för att kontrollera en persons ålder vid ett visst tillfälle. Du kan sätta på eller stänga av ådersmarkören för varje personen.<br /><br />";
$pgv_lang["timeline_control_help"] = "|~LIVSKINJEKONTROLLER~<br/><br/>~HASTIGHET~<br/>Klicka på rullgardinsmenyn för att välja hastigheten som tidslinjen rullar.<br /><br />~Börja år~<br />Skriv in startåret för området.<br /><br />~Sluta år~<br />Skriv in slutåret för området.<br /><br />~Sök~<br />Klicka på sök-knappen för att börja söka efter händelser som hänt inom området du angivit enligt ovan.<br /><br />";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~SLÄKTSKAPSSIDAN~<br /><br />På denna sida kan visa släktskapet mellan två personer. Det betyder inte att dessa personer behöver vara släkt via blodsband. Vilket förhållande som helst kommer att hittas.<br /><br />";
$pgv_lang["relationship_id_help"]		= "~ID FÖR PERSON 1 OCH 2~<br /><br />Om du kommer från en annan sida till denna t.ex. genom att klicka på <b>förhållande till mig</b>, då kommer du att förhållandet mellan dessa personer.<br /><br />Annars måste du skriva in IDt för de två personer som du vill se förhållandet mellan.<br />Om du inte vet IDt för personerna kan klicka på<b>Sök ID</b> länken.<br /><br />";
$pgv_lang["next_path_help"]			= "~HITTA ANNAN VÄG~<br /><br />Du kan klicka på denna knapp för att se om det finns ett annat förhållande mellan två personer. Den föregående förhållandet kan visas igen genom att klicka på länken med förhållande numret.<br /><br />";
$pgv_lang["follow_spouse_help"]			= "~KONTROLLERA FÖRHÅLLANDE VIA VIGSEL - KRYSSRUTA~<br /><br />Med denna kryssruta <b>ej</b> ikryssad, kontrolleras endast förhållandet via blodslinjer. Med kryssrutan ikryssad kontrolleras även förhållande genom vigsel. Du kommer troligen att hitta fler relationer genom att låta rutan vara ikryssad.<br /><br />";
$pgv_lang["line_up_generations_help"]	= "~RADA UPP GENERATIONER - KRYSSRUTA~<br /><br />När denna kryssruta är vald kommer tavlan att skrivas ut med samma generationer radad upp horisontellt på denna sida, ej i kryssad kommer varje generationer att visas under varandra på sidan oavsett om det är ett föräldra- eller barn-relationer.<br /><br />";
$pgv_lang["oldest_top_help"]          = "~VISA ÄLDSTA ÖVERST - Kryssruta~<br /><br />Med denna kryssruta vald kommer tavlan att skrivas ut med de äldsta personerna överst annars vissa de yngsta överst.<br /><br />Obs! Detta val fungerar endast om <i>#pgv_lang[line_up_generations]#</i> är vald.<br /><br />";
$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]# sida~<br /><br />Väldigt likt <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, med fler detaljer och många <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />Varje ana visas med ett unikt nummer från <i>Sosa-Stradonitz</i> systemet:<ul><b>Jämna</b> för men (barn*2)<br /><b>udda</b> för kvinnor (Make+1) utom för <b>1</b></ul><br />Ex: <br /><ul>rotpersonen är <b>1</b>, oavsett kön.<br /><b>1</b>'s fader är <b>2</b> (<b>1</b> * 2), moder är <b>3</b> (<b>2</b> + 1).<br /><b>2</b>'s fader är <b>4</b> (<b>2</b> * 2), moder är <b>5</b> (<b>4</b> + 1).<br /><b>3</b>'s fader är <b>6</b> (<b>3</b> * 2), moder är <b>7</b> (<b>6</b> + 1).<br /><b>7</b>'s fader är <b>14</b> (<b>7</b> * 2), moder är <b>15</b> (<b>14</b> +1).<br />etc.</ul><br />";
$pgv_lang["box_width_help"]		= "~#pgv_lang[ancestry_chart]# boxvidd~<br /><br />Här kan du ändra vidden av boxen mellan 50% till 300% . Vid 100% är varje box ca 270 pixel bred.<br /><br />";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[ancestry_chart]# stil~<br />Två tavelstilar är tillgängliga:<ul><li><b>#pgv_lang[ancestry_list]#</b><br />Vertikalt träd med familjer som kan döljas eller visas.</li><br /><li>pgv_lang[ancestry_booklet]#</b><br />En fammilj per sida, med föräldrar, far/mor-föräldrar och alla kända barn.<br /><br />Lätt att skriva ut och ge till släktingar.</li></ul><br />";
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]# sida~<br /><br />Väldigt likt <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, fast med en mer grafisk inriktning.<br /><br />Rotpersonen är i centrum, hans föräldrar i den första ringen, far/mor-föräldrar i den andra ringen...<br /><br />Födelseåret och dödsåret skrivs ut om det är känt.<br /><br />Klicka på ett namn i tavlan öppnar en länk till en meny specifik för den personen. Från denna meny kan du välja flytta den personen till centrum av solfjädertavlan eller till en av persons nära släktingar, eller du kan flytta till personens #pgv_lang[indi_info]#-sida eller en annan tavla för personen.<br /><br />";
$pgv_lang["fan_width_help"]		= "~#pgv_lang[fan_chart]# bredd~<br /><br />Du kan ändra solfjäderns bredd från 50% till 300%. Standard värde är 100% : resultatbilden är omkring 640 pixel bred.<br /><br />";
$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]#stil~<br /><br />Detta val kontrollerar utseendet av solfjädernul><li><b>1/2</b><br />Halvcirkelformad fjäder (180 grader)</li><br /><li><b>3/4</b><br />Trekvartsformad fjäder (270 grader) eller <i>Änglavinge</i></li><br /><li><b>4/4</b><br />Helt cirkelformad fjäder (360 grader)</li></ul><br />";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PERSONLISTNINGSSIDAN~<br /><br />På denna sida kan du visa en lista på personer. Namnen kommer att visa efternamn först och sorterad i alfabetisk ordning.<br /><br />Listans utseende beror på:<ol><li>Bokstaven som du klickade på i den alfabetiska listan.</li><li>Beroende på klickade \"Hoppa över\" eller \"Visa\" efternamnslista.</li></ol>#pgv_lang[context_help]#<br /><br />";
$pgv_lang["alpha_help"]				= "~ALFABETISKT INDEX~<br /><br />Klicka på en bokstav i alfabetet kommer att visa en lista med namn som börjar med bokstaven du klickade på.<br /><br />Näst sist i indexet kan det finnas <b>#pgv_lang[NN]#</b> Dessa visas om det finns personer i GEDCOM-filen vars efternamn inte är infört i personen GEDCOM-post eller inte innehåller bokstäver för det stödda språken.<br />En okänd person alltså.<br /><br /><b>Obs</b><br />Om man i en personens GEDCOM-post är infört som t.ex.: <b>Nn</b>, <b>NN</b>, <b>okänt</b> eller <b>N.N</b> kommer den <u>inte</u> att visas om man klickar på <b>#pgv_lang[NN]#.</b>.<br />Du kommer att hitta dessa genom att klicka på \"<b>N</b>\" eller \"<b>O</b>.<br />Det är för att programmet kommer bara att kontrollera om det finns en efternamn i personens post i GEDCOM-filen.<br /><br />I slutet på det alfabetiska indexet ser du <b>ALLA</b>. Klicka på denna länk kommer att visa en lista på alla efternamn i GEDCOM-filen.<br /><br /><b>Missade bokstäver?</b><br />Det kan vara så, att en eller flera bokstäver \"fattas\". De fattas inte det betyder bara att det inte finns någon med ett efternamn som börjar på denna bokstav.<br /><br />";
$pgv_lang["name_list_help"]			= "~NAMNLISTA~<br /><br />Denna box kommer antingen att visa en Efternamnslista eller en komplett namnlista.<br />I båda fallen kommer efternamnenslistan att starta med den bokstav du klickat på i alfabetindexen förutom om du klickat på <b>ALL</b><br /><br />Om du kommer att se en efternamnslista eller en komplett lista beror på statusen på <b>Visa/Dölj Efternamnslistan</b>-länken under boxen.<br /><br />";
$pgv_lang["skip_sublist_help"]			= "~HOPPA ÖVER UNDERLISTA~<br /><br />Standars inställningen är att du får en underlista med efternamn efter att du klickat på en bokstav i alfabetet. Om du klickar på denna länken kommer efternamnslistan att skippas och alla namn kommer att visas direkt.<br /><br />";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~FAMILJESIDAN~<br /><br />På denna sida kan du visa en lista av familjer. Namnen kommer att visas efternamn först och sorterade i bokstavsordning.<br /><br />Utskriften från namnlistan beror på:<ol><li>Bokstaven du klickade på i alfabetet.</li><li>Du klickade på \"Hoppa över\" eller \"Visa\" efternamnslista.</li></ol>Du kan söka efter makens eller makans efternamn, båda finns i listan.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["help_family.php"]			= "~FAMILJDETALJSIDAN~<br /><br />Denna sida kommer att visa en översikt av familjen som du valt på en tidigare sida.<br />Från högst upp till längst ner kommer du att se boxar med:<br />Maken och hans föräldrar, makan och hennes föräldrar och barnen.<br /><br />Utseendet och innehållet för namnboxarna är det samma som namnboxarna som de redan känner till i antavlan och stamtavlan.<br />Till höger om namnboxarna ser du en pil. Klickar du på den pilen kommer du en generation bakåt till den familjens familjesida.<br />På höger sida <i>i</i> namnboxen kan du se ett förstoringsglas som ger mer detaljerad information om personen. Klickar man på namnet kommer man till personens detaljsida.<br />Dessutom finns det på höger sida en liten meny som kan ta dig till sidor med mer information eller andra tavlor.<br /><br />Familjegruppens information visar alla kända fakta och information om familjen, som vigsel, multimediaobjekt och anteckningar. För faktainformationen, klickar man på en ort kommer man till ortslistan, där alla andra familjer och personer kopplade till orten visas. Klicka på ett datum och du kommer till dagkalendern, vilket kommer att visa alla händelser som hänt denna dag och månad i det förflutna. Multimediaobjekt kan också klickas på, detta kommer att öppna ett nytt fönster i vilket objektet visas. Om du klickar på en käll-länk kommer detaljerna om källan att visas på källsidan.<br /><br />Under namnboxarna för barn(en) hittar du en länk till \"Lägg till ett barn till familjen\".<br />Intill namnboxen för barnen ser du \"familjegruppsinformationen\".<br />Om du har tillräckligt med rättigheter kan du här, ändra, lägga till och ta bort data och fakta.<br /><br />På den högra sidan av skärmen ser du ikoner och länkar för(om tillåtet):<br /><b>Visa GEDCOM-post</b>, vilket visar informationen i GEDCOM-format.<br /><b>Lägg till i urklippskorgen</b> viklet gör det möjligt för dig att spara denna information i urklippskorgen. Därifrån kan du sedan ladda ner informationen och importera den i ditt eget släktforskningprogram.<br /><b>Visa par på tidslinjen</b>, vilket kommer att föra dig till en tidslinjetavla och visa alla fakta om paret på en tidsaxel.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~LÄGG TILL BARN TILL DENNA FAMILJ~<br /><br />Genom att klicka på denna länk, kan du lägga till barn till denna familj.<br />Lägga till ett barn är enkelt: Bara klicka på länken, fyll i boxarna i fönstret, det är allt.<br /><br />";
$pgv_lang["show_fam_gedcom_help"]	= "~VISA GEDCOM-POST~<br /><br />Genom att klicka på denna länk kommer informationen om familjen att visas i ett fönster som den ser ut i GEDCOM-filen.<br /><br />";
$pgv_lang["add_fam_clip_help"]		= "~LÄGG TILL FAMILJ I URKLIPPSKORGEN~<br /><br />Genom att klicka på denna länk kan du lägga till familjeinformationen som den är sparad i GEDCOM-filen till #pgv_lang[clip_cart]#. På nästa sida kan välja exakt vilken information som du vill lägga till:ol><li>#pgv_lang[just_family]</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#<li></li>#pgv_lang[parents_desc]#</li></ol><br />";
$pgv_lang["show_fam_timeline_help"]	= "~VISA PAR PÅ TIDSLINJE~<br /><br />Genom att klicka på denna länk kommer du att hoppa till tidslinjesidan, där alla fakta om paret kommer att visas på tidslinjen.<br /><br />";
//-- same variable as individuals page

//-- Sourcelist-page
$pgv_lang["help_sourcelist.php"]		= "~KÄLLSIDAN~<br /><br />På denna sidan visas en lista av källor.<br />Skillnaden mot #pgv_lang[indi_info]# och familjesidan är att det inte finns något alfabet överst. Detta beror på att källor kan vara personer med, förstås, för och efternamn, men det kan också vara databaser, kyrkböcker etc.<br />Detta betyder att det är svårt att sortera. Men PhpGedView <u>sorterar</u> källorna i alfabetiska ordning.<br /><br /><b>KÄLLOR</b><br />Utan källor kan vi inte bygga en databas eftersom all information i databasen är en källa. Detta kan vara en släkting ett institut, publik databas etc.<br /><br />En källa kan vara länkad till många personer. Men en person kan också vara länkad till många källor. Du kan ha olika källor för varje händelse, oavsett om det är ett födelsedatum, yrke, vigsel, barn, etc, etc.<br /><br />";
$pgv_lang["sourcelist_listbox_help"]		= "~KÄLLLISTAN~<br /><br />I denna box ser du namnen på källorna, som de är sparade i GEDCOM-filen. Namnen visas i alfabetisk ordning.<br /><br />När du klickar på ett namn i listan kommer du till den källans sida dären lista visas för alla personer och/eller familjer som är länkade till denna källa.<br /><br />";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~KÄLLDETALJSIDAN~<br /><br />På denna sida visas detljerna om källan. Källor är väldigt viktiga för släktforskare och låter dig följa en annan släktforskare spår för att finna informationen.<br /><br />På sidan kan du se information om källans titel, författare, publicering och var källan finns. Eftersom det finns så många typer av källor kan vissa källor visa mer information än andra.<br /><br />Om ett multimediaobjekt(t.ex. ett scannat document) är knutet till en källa kan du se objektet i ett större fönster genom att antingen klicka på objektet eller på filnamnet sidan om det.<br /><br />Efter källdetaljeran visas en lista med namn på personer och familjer som är länkade till källan. Det gör det möjligt att se all information som man fått från samma källa.<br /><br />Om adminstratören satt på möjligheten så finns det ytterligare en eller två menyikoner på denna sidan:<ol><li><b>#pgv_lang[view_gedcom]#</b><br />vilket visar informationen i GEDCOM-format.</li><br /><li><b>#pgv_lang[add_to_cart]#</b><br /> vilket låter dig spara denna information i din #pgv_lang[clip_cart]#. Därifrån kan du sedan ladda ner informationen och importera den till eget släktforskningsprogram.</li></ol><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["sources_listbox_help"]		= "~POSTER LÄNKAD TILL DENNA KÄLLA~<br /><br />I denna box visas namnen på personer och familjer som är länkade till denna källa.<br />Namnen visas i alfabetisk ordning.<br /><br />När du klickar på ett namn i listan kommer du till den källans sida dären lista visas för alla personer och/eller familjer som är länkade till denna källa.<br /><br />";
$pgv_lang["show_source_gedcom_help"]		= "~VISA GEDCOM-POST~<br /><br />Genom att klicka på denna länk kommer informationen om källan, som den är sparad i GEDCOM-filen, visas i ett pop-up fönster.<br /><br />";
$pgv_lang["add_source_clip_help"]		= "~LÄGG TILL KÄLLA I URKLIPSKORGEN~<br /><br />Genom att klicka på länken kan du lägga till en källa, som den är sparad i GEDCOM-filen, till din #pgv_lang[clip_cart]# för att senare ladda ner och importera till ditt eget släktforskarprogram.<br /><br />";
$pgv_lang["delete_source_help"]			= "~RADERA KÄLLOR FRÅN GEDCOM~<br /><br />Genom att klicka på detta val så markeras källan för radering.<br />Vad betyder det?<br />Låt oss anta att du har en god anledning att radera denna källa från GEDCOM-filen. Du klickar på länken och efter det kommer det upp ett pop-up fönster som frågar om du är säker på att du vill radera källan.<br /><br />Om du fullföljer raderingen kan det ta lite tid innan du får ett nytt pop-up fönster med meddelandet att k??llan blivit raderad.<br /><br />När du fortsätter ditt besök, kommer du att märka att källan fortfarande syns och går att använda precis som förut.<br /><br />Detta beror <b>inte</b> på något fel.<br />Sidadministratören kommer att få ett meddelande om att en ändring har gjorts på GEDCOM-filen och att du tagit bort källan.<br />Administratören bestämmer sedan om han accepterar din ändring eller inte. Endast efter detta kan raderingen inte återställas.<br />Om det finns några frågor kommer administratören att kontakta dig.<br /><br />";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~ORTSHIERARKI~<br />(eller personer per ort)<br /><br />På denna sida kommer du se en hierarki av orter från GEDCOM-filen och vilka personer eller familjer som är kopplade till orten.<br /><br />Om det finns en koppling mellan en person eller familj och en händelse på en bestämd ort kommer programmet att hitta det åt dig.<br /><br />Resultater visas i en dubbel lista, En för personer och en för familjer.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~ORDNINGEN FÖR ORTERNA~<br /><br /><b>STANDARDORDNING</b><br />Detta betyder att det inte finns någon speciell ortsordning i GEDCOM-filen.<br /><br />I detta fall används en standardordningen.<br /><br />Om någon annan ordning hittades i GEDCOM-filen, skulle den visats mellan <b>(</b> och <b>)</b> i slutet på raden.<br /><br />";
$pgv_lang["ppp_match_one_help"]			= "~ORDNINGEN FÖR ORTER~<br /><br />GEDCOM-ORDNING<br />Orterna är i den ordning som de hittades i GEDCOM-filen.<br />Denna ordning har företräde före standardordning som används när ingen ordning hittas i GEDCOM-filen.";
$pgv_lang["ppp_numfound_help"]			= "~HITTADE ORTSKOPPLINGAR~<br /><br />Här visas antalet hittade kopplingar. Om du fortfarande ser en lista med orter, betyder det att du inte nått den lägsta nivån ännu.<br /><br />Du kan välja att visa alla poster för orten eller du kan förfina sökningen genom att klicka på en annan ort.<br /><br />";
$pgv_lang["ppp_levels_help"]			= "~ORTSNIVÅER~<br /><br />Detta visar nivåerna som visas nu.<br />Listboxen, som visar orterna, är faktiskt en underlista av den översta vänsta nivån.<br /><br />EXAMPLE:<br />(Standard)ordningen år:#pgv_lang[default_form]#<br />Om det nuvarande nivån är \"översta nivån\" då kommer boxen visa en lista alla länder i GEDCOM-filen.<br />Om den nuvarande nivån visar \"U.S.A., Översta nivån\", kommer boxen att visa alla staterna i U.S.A.<br />etc.<br />Du kan klicka på en nivå för att gå tillbaka ett eller flera steg.<br /><br />";
$pgv_lang["ppp_placelist_help"]			= "~ORTSLISTA~<br /><br />I denna lista kan du se orterna som hittats under den nuvarande orten som du valt. Om du inte har valt någon ort, kommer du att se en lista av den översta nivån av orter (t.ex länder eller län).<br /><br />Namnen på platerna går att klicka på. Klicka på en ort fungerar som ett filter. Det gör att du kommer ner en nivå i listan.<br /><br />";
$pgv_lang["ppp_placelist_help2"]		= "~ORTSLISTA~<br /><br />I denna lista kan du se alla platser som har hittats hittills.<br /><br />Namnen på platserna i listan är klickbara. Klickandet på en ort fungerar som ett filter. Det kommer att föra dig en nivå längre ner.<br /><br />När du är på den högsta nivån kommer namnlistan inte visas. På alla andra lägre nivåer kommer du få se en lista på alla personer och/eller familjer som haft samröre med orten.<br /><br />";
$pgv_lang["ppp_view_records_help"]		= "~VISA ALLA POSTER~<br /><br />Klicka på denna länk kommer att visa en lista av alla individer och familjer som har händelser som har inträffat på denna ort. När du kommer till slutet av platslistan t.ex. en by eller stad, kommer namnen att visas automatiskt.<br /><br />";
$pgv_lang["ppp_name_list_help"]			= "~NAMNLISTA~<br /><br />Denna boxen visar en komplett lista på personer och/eller familjer som relaterade på något sätt till orten.<br /><br />Namnen i listan klickbara. När du klickar på ett namn, kommer du till ansedeln för personen eller familjen. Du kan också välja att ändra ditt val genom att klicka på orten överst i listan.<br /><br />";

//-- Mulitmedia-page
$pgv_lang["help_medialist.php"]			= "~MULTIMEDIA OBJEKTLISTA~<br /><br />Denna sida listar alla multimediaobjekt(MMO) som hittas i denna GEDCOM-fil.<br /><br />För varje mediaartikel ser du titeln eller filnamnet för objektet, namnet på personen eller familjen som är kopplade till MMO-objektet och eventuella anteckningar.<br /><br />Klicka på namnet för personen eller familjen så förflyttas du till ansedeln eller familjesidan.<br /><br />Klikar man på namnet på MMO så har det samma effekt som att klicka på själva MMO-objektet.<br />Beroende på formatet för MMO (*.gif,*.jpg), kommer MMO att öppnas i den interna PGV-visaren eller i en visare kopplade till din nätbläddare.<br /><br />Klickar man på visa-länken intill personen eller familjen kommer att föra dig till personens eller familjen detaljsida.<br /><br />";
$pgv_lang["help_uploadmedia.php"]		= "~UPPLADNING AV MEDIAFILER~<br /><br />Ladda upp filer är enkelt, men här kommer lite extra information.<br /><br /><b>Miniatyrbilder</b><br />Miniatyrbilder bör ha en storlek omkring 100 pixlar bred.<br />Filnamnet måste vara samma som för orginalbilden.<br /><br /><b>Uppladdning</b><br />Filerna kommer att automatiskt laddat upp till katalogen ./media för de stora bilderna och till ./media/thumbs för miniatyrbilderna.<br /><br />#pgv_lang[readme_help]#";



//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~#pgv_lang[anniversary_calendar]#~<br /><br />><ul><li><a href=\"#calendar_general\">Generell information</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Händelse</a><li><a href=\"#calendar_button\">Välja mod (knappar)</a><li><a href=\"#calendar_tip\">Tips</a></ul><br /><a name=\"calendar_general\"></a>Funktionen i jubileumskalendern är att visa personer eller familjer som är kopplade till en händelse en viss dag och/eller månad eller under en viss tid. Den har ett avancerat filter för att välja ut rätt datum eller period och händelser för dig.<dl><dt><b>Visa <a href=\"#calendar_day\">Dagmod</b></dt><dd>Denna visar händelser en vissa dag oberoende av det valda året. Resultatet blir antingen en enkel lista med namn på personer eller familjer eller en dubbellista med på ena sidan personer och på andra sidan familjer.</dd><dt><b>Visa <a href=\"#calendar_month\">Månadsmod</a></b></dt><dd>I <b>kalendern</b> visas namnen på både personer och familjer inom boxen. Kalendern visas som den såg ut vid det år du skrev in i årsboxen. Alla händelser som hänt i det förflutna fram till året du angav visas. I kombination med valet \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" ger det en realistisk bild av hur en kalender såg ut för våra anor.</dd><dt><b>Visa <a href=\"#calendar_year\">År</a></b></dt><dd>Detta val visar händelser ett visst år eller under ett antal år. Resultatet blir antingen en enkel lista med namn på personer eller familjer eller en dubbellista med på ena sidan personer och på andra sidan familjer.</dd></dl>I en markerad färg visas den nuvarande dag, månad och vilka händelser som visas.<br /><br />Namnen som visas i listan eller kalendern är klickbara.<br />Klicka på ett namn och du kommer till ansedeln för denna person eller familj, klicka på ett datum kommer att föra dig till \"Idag\"-mod (eller år)som kommer att visa alla händelser för den dag och månad som du klickade på.<br /><br />><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~DATUMVÄLJARE~<br /><br />Översta raden av \"väljartabellen\" är <b>Dagväljaren</b>.<br />Meningen med den är uppenbar: Du väljer en dag.<br />Resultatet av att klicka på en dag beror på om du är i \"dagmod\" eller \"månadsmod\".<br /><br /><b>Dagmod</b>:<br />I denna mod när du klicka på en dag, kommer skärmen att laddas om och listan för dagen du tryckt visas.<br /><br /><b>Månadsmod</b>:<br />När du har kalendern för en viss månad på skärmen och klicka på en dag i \"dagraden\" i väljartabellen, skärmen kommer att laddas om, men du kommer fortfarande se månaden du hade innan.<br />Orsaken till detta är att du fortfarande kan välja en annan månad, år eller händelse att visa innan du klickar på <b>#pgv_lang[viewday]#</b> eller <b>#pgv_lang[viewmonth]#</b> knappen.<br /><br />I slutet av dagraden ser du <b>\"snabblänkar\"</b> med dagens datum.<br />Klicka på den \"snabblänken\" kommer att visa dagen lista, i \"dagmod\", oavsett om du är månadsmod eller dagmod.<br />";
$pgv_lang["annivers_month_select_help"]		= "~MÅNADSVÄLJAREN~<br /><br />Mittenraden i \"väljartabellen\" är <b>Månadsväljare</b>.<br />Liksom \"datumväljaren\" är meningen med den uppenbar: Du väljer en månad.<br /><br />Och också liksom datumväljare blir resultatet av att klicka på en månad i \"dagläget\" olikt att klicka på en månad i \"månadsläget\".<br /><br /><b>Dagläget</b>:<br />I detta läget när du klickat på en månad kommer skärmen att laddas om och listan kommer att visas med datumen för den nya valda månaden.<br />Alla andra inställningar som dag, månad, år och händelser kommer att förbli desamma.<br /><br /><b>Månadsläget</b>:<br />När du har kalendern i månadsläge på skärmen och klickar på en månad i \"månadsraden\" i väljartabellen, kommer den nya månaden att visas.<br /><br />Vid slutet på månadsraden i väljartabellen kommer du att se <b>\"Snabblänk\"</b> till den nuvarande månaden.<br />Klicka på \"snabb länken\" och den nuvarande månaden kommer att visa, oavsett om du är i månadsläget eller dagläget.<br />";
$pgv_lang["annivers_year_select_help"]		= "~ÅRSBOXEN~<br /><br />Denna box är till för att ändra året i din lista i \"månadsläget\" eller ändra året för kalendern i \"Årsläget\".<br />I \"dagläget\" gör det ingen skillnad att ändra året eftersom alla händelser för alla år visas.<dl><dt><b>Avancerade finesser</b> för <b>#pgv_lang[viewyear]#:<br />Mer än ett år</b></dt><dd>Du kan söka efter mer än ett år genom att skriva in i årsfältet:<br />- Ex. 1:<b>1992-5</b> för att få alla händelser från 1992 till 1995.<br />- Ex. 2: <b>1972-89</b>för alla händelser från 1972 till 1989.<br />- Ex. 3: <b>1610-759</b> för alla händelser från 1610 till 1759.<br />- Ex. 4: <b>1880-1905</b> för alla händelser från 1880 till 1905.<br />- Ex. 5: <b>880-1105</b> för alla händelser från 880 till 1105.<br /><br />Du kan också låta bli att skriva in den sista siffran för året för att få alla händelser för ett visst datum under ett årtionde.<br />- Ex <b>197</b> för alla händelser från 1970 till 1979.</dd><dt><br /><b>Förkortningar</b></dt><dd> Ibland kan man inte säkert säga när en händelse ägde rum. Vid sådana fall kan man lägga till termer som \"Efter\", \"Före\", och \"Omkring\" till ett datum. Datumar sparas i GEDCOM-filen tillsammans med en förkortning av termen. I årsläget kan du också utföra sökningar på termen med eller utan datumet angivet. Några exempel av dessa sökninar är:<br /><b>abt</b> 1800 (abt = omkring)<br /><b>bet</b> 1950-1959 (bet = omkring) skriv in: bet 1950 eller bara 1950-59<br /><b>bef</b> 1950 (bef = före)<br /><b>aft</b> 1900 (aft = efter)<br /><br /><b>Obs:</b> PhpGedView söker efter den exakta strängen du skrivit in. När du söker efter \"abt 1850\", ett datum sparad i GEDCOM-filen som \"abt oct 1850\" kommer <b>inte</b> att komma med i sökningen. - Du kan skriva in förkortningen utan år för att få alla händelser som innehåller förkortningen.</dd></dl>Skriva in ett annat år kommer inte direkt att uppdatera sidan.<br />Eftersom inskrivningsrutan inte är en länk, måste du klicka på <b>#pgv_lang[viewmonth]#</b> eller <b>#pgv_lang[viewyear]#</b>-knappen innan du kan se den nya sidan.<br />";
$pgv_lang["annivers_show_help"]			= "~VISA HÄNDELSER FÖR ...~<br />När du inte är inloggad kan du välja mellan två val:<br /><ol><li><b>Alla Personer</b><br />Med detta val, alla personer och familjer visas.</li><br /><li><b>Nyligen inträffade händlese(<100 år)</b><br />Med detta val kommer du att se alla händelser under den valda dagen/månaden, men inte händelser äldre än 100 år.</li><br /><li><b>Levande personer</b><br />När du väljer detta val, visas endast levande personer. För detta måste du antingen vara inloggad eller måste administratören ha satt upp systemet så att alla kan se levande personer.</li></ol>När du klickar på ett val, händelserna kommer att visas beroende ditt val.<br /><br />Inställningar för dag, månad och år, precis som <b>dag</b> eller <b>månad</b>-mod kommer att förbli som de var.<br /><br />";
$pgv_lang["annivers_sex_help"]			= "~VAL AV KÖN~<br />När du är inloggad (eller om administratören har valt bort integritetsinställningar) har du tre val:<ol><li><b>Alla ikonen</b> Med detta val(standard) visas händelser för alla personer och familjer.</li><br /><li><b>Mans-ikonen</b>Vid detta val visas endast händelser för manliga personer. Manliga medlemmar i familjer kommer att visas vid familjehändelser.</li><br /><li><b>Kvinno-ikonen</b> Vid detta val visas endast händelser för kvinnliga personer. Kvinnliga medlemmar i familjer kommer att visas vid familjehändelser.</li></ol>Om man klickar på ett av valen kommer skärmen att uppdateras och händelserna som du valt kommer att visas.<br />Andra inställningar för dag, månad, år och händelser och mod kommer att förbli som de var.<br /><br />";
$pgv_lang["annivers_event_help"]		= "~HÄNDELSEVÄLJARE~<br />Här väljer du om du vill att alla händleser för personer och familjer ska visas eller bara de händelser du valt.<br /><br />Klicka på ett val kommer att uppdatera skärmen och de valda händelserna kommer att visas.<br /><br />Andra inställningar som dag, månad, år och händleser och mod kommer att förbli som de var.<br /><br />";
$pgv_lang["annivers_tip_help"]			= "~TIPS~<br />Tänk dig att du har en släkting som var född den 25 Januari 1875.<br />Ändra datumväljaren till detta datum. När du nu klickar på någon av visa knapparna, kommer du att se en lista eller en kalender för det datum. Alla åldrar, jubileum, etc. är omräknade tillbaka till datumet du satt i datumväljaren. Nu ser du faktiskt en kalender som den kan ha sätt ut för din släkting för länge sedan.<br /><br />";
$pgv_lang["day_month_help"]			= "~VISA DAG / VISA MÅNAD / VISA ÅR KNAPPEN~<br /><br /><b>Visa dag</b>-knappen kommer visa händelser av den valda dagen i en lista. Alla år scannas, så endast dag och månad kan sättas. Ändring av året har ingen effekt.<br />Du kan begränsa valen med \"senaste åren\" eller, om tillgänglig, \"levande personer\". Årtalen i listan kommer att beräknas från det innevarande året.<br /><br /><b>Visa månad</b>-knappen kommer att visa en kalender för den valda månaden och året. Även här kan du begränsa valen med \"senaste åren\" eller \"levande personer\".<br />Genom att välja ett år i det förflutna i kombination med \"\"senaste året\", kommer du att få ett realistisk intryck av vad en kalender på väggen hos dina anfäder skulle sätt ut. Alla årtal på kalendern visas relativt till årtalet i årsrutan.<br /><br /><b>Visa året</b>-knappen kommer att visa dig en lista av händelser för det valda året.<br />Även här kan du begränsa valen med \"senaste åren\" eller \"levande personer\".<br />Ett trevlig val är möjligheten att välja händelser från mer än ett år: Skriv bara nummret på det sista året direkt efter det första året med ett \"-\" i mellan (t.ex. 1992-4 för alla händelser från 1992 till 1994, eller 1976-1984 för alla händleser från 1976 till 1984).<br />-Du kan också skriva in de första siffrorna i årtalet för att få alla händelser som startar med de siffrorna (t.ex. 197 för alla händelser från 1970 till 1979)<br /><br />När du vill <b>ändra året måste</b> du trycka på en av tre knappar.<br /><br />Alla andra inställningar kommer att förbli som de var, när du klickar på dessa knappar.<br />";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]			="~SLÄKTTRÄDETS URKLIPPSKORG~<br />Tillåter dig att göra #pgv_lang[clip_cart]#  från detta släktträd och packa ihop dem till en nedladdningsbar GEDCOM-fil.<br /><ul><li>Hur gör man urklipp?<br />Detta är väldigt enkelt. Så fort du ser ett klickbart namn (person, familj eller källa) kan du gå till detaljsidan för det namnet. Härifrån kommer du se valet \"Lägg till\" i <b>#pgv_lang[add_to_cart]#</b><br />Om du klickar på den länken kommer du till en sida d??r du erbjuds ett antal möjligheter för nedladdning.</li><br /><li>Hur laddar man ner?<br />När du har saker i urklippskorgen, kan du ladda ner dem genom att klicka på <b>Ladda ner nu</b> länken.<br />Följ sedan instruktionerna och länkarna.</li></ul><br />";
$pgv_lang["clip_download_help"]			="~LADDA NER URKLIPPEN~<br /><br />Genom att klicka på denna länk, kommer du att flyttas till nästa sida. Om det finns fler val av vad som ska laddas ner kommer de att visas på denna sida.<br />Följ bara instruktionerna.<br /><br />";
$pgv_lang["empty_cart_help"]			="~TÖM URKLIPPSKORGEN~<br /><br />Genom att klicka på denna länk kommer #pgv_lang[clip_cart]# att tömmas helt.<br /><br />Om du inte vill ta bort alla personer, familjer etc. från #pgv_lang[clip_cart]# kan du ta bort dem en och en genom att klicka på <b>Tabort</b> länken i namnboxarna. Det finns <u>ingen</u> konfirmationsdialog när du klickar på någon av dessa länkar, raderingen sker omedelbart.<br /><br />";
$pgv_lang["add_by_id_help"]				= "~URKLIPPSKORG LÄGG TILL VIA ID~<br /><br />Denna box låter dig skriva in en persons ID-nummer så att han kan läggas till i urklippskorgen. Väl tillagd kommer du få frågan om du vill lägga till personens relationer till urklippskorgen.<br /><br />Om du inte vet en persons ID-nummer kan du utföra en sökning via namn genom att trycka på personikonen intill Lägg till knappen.<br /><br />";
$pgv_lang["zip_help"]					= "~ZIP-URKLIPP~<br /><br />Välj detta val för att spara din urklipp i en ZIP-fil. För mer information om ZIP-filer, besök <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.<br /><br />";
$pgv_lang["include_media_help"]			= "~INKLUDERA MEDIA~<br /><br />Välj detta val för att inkludera mediafiler associerade med poster som finns i din urklippskorg. Om du väljer detta val kommer filerna automatiskt zipas vid nerladdning.<br /><br />";
$pgv_lang["clip_cart_help"]				= "~URKLIPPSKORG~<br /><br />Detta område visar dig innehållet i din urklippskorg. <i>Typ<\i>-kolumnen visar typen för varje post, som kan var Person (INDI), familj (FAM), källa (SOUR), arkiv (REPO), anteckning (NOTE) och media (OBJE) varje är representerad av ssin egen ikon. <i>ID<\i>-kolumnen visar ID-nummret för varje post av den typen. <i>Namn / beskrivning<\i>-kolumnen ger antingen namnet på familjen eller personen eller en beskrivning av posten. Tabort knappen tar bort den psoten från urklippskorgen.<b>Bekräftelse på borttagning kommer INTE att ges.</b><br /><br />";

//-- GEDCOM Edit Utillity
$pgv_lang["show_changes_help"]			="~VISA ÄNDRINGAR I GEDCOM-FILEN~<br /><br />När du ser detta meddelande, betyder det två saker:<ol><li>Någon har gjort ändringar i GEDCOM-filen<br />Post(er) kan ha lagts till, raderats eller ändrats.</li><br /><li>Ändringarna har inte ännu accepterats av administratören.<br />När ändringarna har accepterats (eller inte blivit accepterad), försvinner detta meddelande.</li></ol>Genom att klicka på länken, kan du se vad för ändringar som gjorts. Om du upptäcker att än ändring är felaktig, var snäll och meddela administratören.<br /><br />";

//-- Search-page
$pgv_lang["help_search.php"]			="~SÖKSIDAN~<br /><br />Även om denna sida ser väldigt enkel ut, så bakom de två formulären på sidan finns en väldigt kraftfull sökmotor.<br /><br />De flesta genealogiska sajter låter dig endast söka efter efternamn.<br />På denna sida kan nästan söka efter vad som helst.<br /><br />Sökboxen på vänster sida av skärmen är densamma som i huvudet.<br /><br />Om du letar efter personer med anknytning till ett visst år, skriv bara årtalet. Progammet kommer att hitta alla kopplingar åt dig.<br /><br />Letar du efter ett namn, eller ort?<br />Skriv bara in namnet eller orten, komplett eller bara delar av det och programmet gör resten.<br /><br />SOUNDEX-sökmetod.<br />Med sökboxen på höder sida, kan du söka efter namn eller platser även om du inte vet hur de hur de stavas.<br /><br />Du får mer hjälp om du söker om dessa två boxar genom att klicka på <b>?</b> ovanför boxarna.<br /><br />";
$pgv_lang["search_enter_terms_help"]		="~SKRIV IN SÖKTERM~<br /><br />I sökboxen kan du skriva in kriterier som datum, förnamn, efternamn, orter, multimedia, etc.<br /><br /><b>Jokertecken</b><br />Vanliga jokertecken (som * eller ?) är inte tillåtna, men programmet använder alltid jokertecken.<br />Vad betyder detta?<br />Antag att du skriver in följande:\"<b>Pete</b>\"<br />Resultatet (namnen måste naturligtvis finnas i databasen) blir:<br /><b>Pete</b> Smith<br /><b>Pete</b>r Johnes<br />Will <b>Pete</b>rson<br />Någon född den 01 Januari 1901 i <b>Pete</b>rsburg<br />etc., etc.<br /><br /><b>Datum</b><br />Om man skriver in ett år i sökboxen blir resultatet, alla namn på personer som på något sätt har anknytning till detta år.<br />Om du skriver 1950 blir resultatet alla personer, födda 1950, eller vigda, eller döda, eller... något annan händelse kopplad till 1950.<br /><br />Om du skriver \"4 Dec\", då kommer alla personer kopplade till detta datum att oavsett år att visas.<br />Men också personer kopplade till händelser med datum 14 eller 24 december att listas.<br />Som du ser används jokertecken automatiskt så du behöver inte tänka på dem.<br /><br /><b>Korrekt datum</b><br />Programmet söker efter data som de är skrivna i GEDCOM-filen.<br />Så om du vill söka efter en händelse den 14 december, bör du skriva:<br /><b>14 dec</b><br />eftersom det är på detta sätt som datum är sparade i GEDCOM-filen.<br />Om du skriver <b>dec 14</b>, då blir resultatet personer kopplade till händelser 08<b>dec</b>ember 18<b>14</b>. Du kan också använda reguljära uttryck i din sökning om du är bekant med dem. T.ex om du vill hitta alla personer som har datum i det 1900-talet, kan du skriva 19[0-9][0-9] och du kommer att få träff på alla personer med datum från 1900-1999.<br /><br />Om du behöver mer hjälp om söksystemet, kontakta oss, så att vi kan utöka denna hjälpfil.<br /><br />";
$pgv_lang["search_replace_help"]		= "~SÖK OCH ERSÄTT~<br /><br />Här kan du söka efter en felstavning eller annan felaktig information och ersätta den med korrekt information.<br /><br /><b>Sökning</b><br />Denna funktion gör en sökning precis som <a href=\"help_text.php?help=search_enter_terms_help\">normal sökning<\a>.<br /><br /><b>Ersättning</b>Alla träffar från sökningen kommer att ersättas med ersättningstermen i databasen.<br /><br /><b>Till exempel...</b><br />Antag att du av misstag stavade fel till farfar Michaels namn. Du skrev av misstag 'Micheal'.<br /><br />Då skriver du <b>Micheal</b> i sökrutan och <b>Michael</b> i ersättningsrutan.<br />Alla träffar för \"Micheal\" kommer då att ersättas med \"Michael\"<br /><br /><b>Sök efter...</b><br />Välj område för sökningen. Du kan begränsa sökningen till namn, orter eller allt. Detta är behändigt om du du inte vill ändra ett ortnamn utan bara person namn.<br /><br />Oroa dig inte om du oavsiktligt råkar ersätta något som du inte ville ersätta. Bara klicka på \"acceptera\förkasta ändringar\"-länken på botten av sidan för att acceptera de ändringar du vill och förkasta de ändringar som du inte vill ändra.<br /><br />Om du behöver mer hjälp med detta söksystem, kontakta oss, så att vi kan utöka denna hjälp mer.<br /><br />";
$pgv_lang["soundex_search_help"]		="~SÖK SOM DU TROR NAMNET STAVS (SOUNDEX):~<br /><br />SOUNDEX-namnsökning är också ett kraftigt verktyg.<br />Först en kort förklaring av Soundex:<br /><br />Soundex sorterar efternamn som låter liknade men har olika stavning. En soundexkod börjar med första bokstaven i efternamnet följt av en 3 siffrig kod som representerar de 3 första återstående konsonanterna. Man lägger till nollor för namn som inte är tillräckligt långa för att koda.<br /><br />Detta betyder att:<br />Om du söker efter \"Smith\", kan du få resultatet:<br />Smith - Smid - Smit - Schmidt - Smyth - Smithe, Smithee, Schmitt, Smead, Sneed, Smoote etc.<br /><br />Du behöver inte bry dig om soundexkoder.<br />Skriv bara in namnet du söker och programmet sköter resten.<br /><br />Soundex systemet är väldigt bra att använda: Ibland vet man vad någon heter men inte hur det stavas.<br />Det kan blivit fleskrivningar när namnen skrevs in i databasen. Med soundexsökning kommer du kunna hitta namnet iallafall.<br /><br />För att vänja dig vid namnet systemet, sök efter ett visst namn men skriv in namnet på lite olika sätt med olika stavningar.<br /><br />I denna soundexsökning är ett vilket namn som helst tillräckligt för att starta en sökning.<br />Du kan söka på förnamn, efternamn eller orter.<br />Fylla i mer än ett fält fungerar som \"OCH\".<br />Du kan också begränsa din sökning genom att ange ett årtal eller ett antal år. T.ex. 1960 eller 19[5-7][0-9] vilket motsvarar 1950 till 1979.<br />Sökresultat kommer att innehålla alla personer med någon händelse vid den angivna platsen, mellan de angivan åratalen.<br /><br />";

//-- Individuals-page
$pgv_lang["help_individual.php"]		= "~#pgv_lang[indi_info]#-SIDAN<br /><br />På denna sida visas alla detaljer om personen.<br /><br />Om det finns bilder tillgängliga, kommer du att se dem överst till vänster.<br />Intill bilden(om den finns) kommer du att se namnet på personen.<br />Under namnet kan du få se käller och anteckningar. Igen, om de finns.<br />En person kan ha ett smeknamn (Kanske är han känd under ett annat namn). Om detta är fallet kommer det att visas.<br /><br />Om du har tillr??ckliga rättigheter, Kommer du att se länkar under namnen, för att editera eller radera namnen eller personen.<br /><br />På denna sida kommer du att se ett antal flikar för \"Personliga fakta och detaljer\", \"Anteckningar\", \"Källor\", \"Media\" och \"Nära släktingar\"<br /><br />På dessa flikar kommer du att hitta alla den information som finns sparad i GEDCOM-filen.<br /><br />Den personliga detaljfliken kommer att visa fakta och detaljer om personen och fakta om eventuella vigslar. Om du klickar på ngon datum så kommer du att föras till kalendern för detta datum, så att du kan se andra händelser för denna dag. Klickar du på ett ortsnamn så förs du till ortsregistret så att du kan se andra personer med händelser från samma ort. För vigslar och andra familjerelaterade fakta är namnet på makan/maken tillgängliga så att du kan visa denna person och en länk till familjen är också tillgänglig.<br /><br />Anteckningsfliken visar dig generella anteckningar om personen.<br /><br />Källfliken visar dig alla generella källor kopplade till källan. Klicka på titeln för källan för att komma till en sida med mer detaljerad information om källan och alla personer som är kopplade till källan.<br /><br />\"Mediafliken\" listar alla bilder och andra mediaobjekt som är kopplade till personen. Klicka på miniatyren av bilden och då får en stor bild.<br /><br />\"Nära släktingfliken\" listar personens föräldrar och syskon, dessutom alla makar/makor och barn som personen haft. Personerna listas i rutor liknande de som du redan sätt.<br /><br />På höger sida på skärmen, ser du en box med länkar.<br />Länkarna i boxen har samma namn som menyerna i huvudet, har samma funktion, förutom att startpersonen är inte probandet i GEDCOM-filen, utan huvudpersonen för denna sida.<br /><br />En av länkarna som kan finnas, om påslagen, är \"Visa GEDCOM-post\" länk. Denna länk kommer att visa den råa GEDCOM-posten för personen.<br /><br />Om urklippskorgen är påslagen finns det också en länk för att lägga personen i korgen.<br /><br />\"Förhållande till mig\" länken visas endast om du är inloggad och är kopplad till ett nummer i GEDCOM-filen. Länken för dig till en antavla för att visa dig förhållandet mellan dig och personen du tittar på.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_person_help"]			= "~RADERA PERSON FRÅN GEDCOM-FIL~<br /><br />Genom att klicka på detta val kommer du att markera personen för radering från GEDCOM-filen.<br /><br />Vad betyder detta?<br />Antag att det finns en bra anledning att radera denna person från GEDCOM-filen. Klicka på länken, då får du upp ett fönster som frågar om du är säker på eller om du avbryta.<br /><br />Om du fortsätter med radereringen, kan det ta ett tag, innan ett fönster visar sig som säger att personen är raderad.<br /><br />När fortsätter med besöket kommer du att märka att personen fortfarande är synlig och kan fortfarande användas som innan.<br /><br />Detta är <b>inte</b> ett fel.<br />Administratören kommer att få ett meddelande att en ändring har skett i GEDCOM-filen och att du har raderat en person.<br />Administratören måste acceptera eller förkasta din ändringen. Endast efter detta steg är processen oåterkallelig.<br />Vid tvivel kommer administratören att kontakta dig.<br /><br />";
$pgv_lang["delete_name_help"]			= "~EDITERA ELLER RADERA NAMN FRÅN GEDCOM-FIL~<br /><br /><b>EDITERA NAMN</b><br />Genom att klicka på denna länk, öpnnas ett fönster, som du kan editera namnet på personen.<br />Det är enkelt, bara skriv in ändringarna i rutan, klicka på knappen, stäng fönstret, och allt är klart.<br /><br /><b>RADERA NAMN</b><br /><br />Genom att klicka på detta val kommer du att markera namnet för radering ur GEDCOM-filen.<br />Kom ihåg att radera namnet är helt annerlunda en att radera personen.<br />Radering av namnet tar bara bort namnet från personen. Personen kommer inte att raderas.<br />Om det är ett alias du vill radera så kommer personen ha kvar sitt vanliga namn.<br />Om det är personens ända namn som du vill radera kommer personen ändå inte att bli raderad utan bli kvar som \"okänd\".<br />Personen kommer inte häller att kopplas ifrån alla andra kopplingar som släktingar, källor, anteckningar etc.<br /><br />Hur fungerar detta?<br />Låt oss anta att du har en bra anledning att radera namnet ur GEDCOM-filen.. Du klickar på länken och efter detta kommer ett fönster upp med frågan om du är säker eller vill avbryta.<br /><br />Om du fullföljer raderingen av namnet kan du ta ett tag innan du får upp ett meddelande att namnet är borttaget.<br /><br />När du fortsätter ditt besök på sajten, kommer du att märka att namnet fortfarande syns och kan t.o.m. användas som förut.<br /><br />Detta är <b>inte</b> ett fel.<br />Administratören kommer att få ett meddelande att en ändring har gjort i GEDCOM-filen, och att du tagir bort namnet.<br />Adminstratören måste acceptera (eller förkasta) din ändring. Endast efter detta är processen oåterkallelig.<br />Vid tvivel kommer administratören att kontakta dig.<br /><br />";
$pgv_lang["add_name_help"]				= "~LÄGG TILL NYTT NAMN~<br /><br />Denna länk kommer att tillåta dig att lägga till en annat namn till en person. Ibland är personer kända under andra namn och alias. Denna länk tillåter dig att lägga till nya namn till en person utan att ändra det gamla.<br /><br />";
$pgv_lang["add_sibling_help"]			= "~#pgv_lang[add_sibling]#~<br /><br />Genom att klicka på denna länk kan du lägga till en ett barn till denna familj.<br /><br />\"Denna familj\", i detta fall, är fadern eller modern till huvudpersonen för denna sida.<br />Så, tänk på att du kommer att lägga till en bror eller syster till denna person.<br />Bara klicka på länken och du kommer att få ett nytt fönster för att lägga till en ny person.<br />Fyll i så många boxar som du kan och klicka sedan på \"Spara\". Det är allt.<br /><br />Om du vill lägga till en son eller dotter för huvudpersonen, rull ner fönstret lite och klicka på länken i #pgv_lang[as_spouse]#\".<br /><br />";
$pgv_lang["add_son_daughter_help"]		= "~#pgv_lang[add_son_daughter]#~<br /><br />Genom att klicka på denna länk kan du lägga till en ett barn till denna familj.<br /><br />\"Denna familj\", i detta fall, är huvudpersonen för denna sida och hans/hennes gemål.<br />Så, tänk på att du kommer att lägga till en son eller dotter till denna person.<br />Bara klicka på länken och du kommer att få ett nytt fönster för att lägga till en ny person.<br />Fyll i så många boxar som du kan och klicka sedan på \"Spara\". Det är allt.<br /><br />Om du vill lägga till en broder eller syster för huvudpersonen, rull upp fönstret lite och klicka på länken i \"#pgv_lang[as_child]#\".<br /><br />";
$pgv_lang["link_child_help"]			= "~#pgv_lang[link_as]# #pgv_lang[child]#~<br /><br />Genom att klicka på denna länk kan du länka denna person som ett barn till en existerande familj.<br /><br />Anta att föräldrarna till denna person var okända, men att du får reda på att de (föräldrarna) har en post i denna GEDCOM-fil.<br /><br />Klicka bara på länken, skriv in IDt för familjen (om du inte vet IDt, kan du söka reda på det i fönstret), och du slutfört uppgiften.<br /><br />";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as]# #pgv_lang[husband]#~<br /><br />Detta val tillåter dig att koppla den valda personen som make till en familj som redan finns i GEDCOM-filen. Genom att klicka på länken kan du lägga till personen till en existerande familj för vilken maken varit okänd tills nu. Personen kommer att ta den okändes plats. Alla händelser, vigselinformation och barn kommer att behålla sina nuvarande länkar till familjen.<br /><br />Klicka på länken, skriv in id-numret för familjen (om du inte vet id-nummret kan du söka efter det i popup-fönstret), och du har slutfört uppgiften. Detta är ett avancerad redigeringsmöjlighet som endast ska användas om familjen redan finns. Om du vill lägga till en <u>ny</u> familj, använd <b>#pgv_lang[add_new_wife]#</b>-länken istället.<br /><br />";
$pgv_lang["add_husband_help"]			= "~#pgv_lang[add_new_husb]#~<br /><br />Genom att klicka på denna länk kan du lägga till en <u>Ny</u> (manlig) person och länka denna person till någon huvudindivid som en ny fru.<br /><br />Bara klicka på länken och du kommer att få ett nytt fönster för att lägga till en ny person. Fyll i så många boxar som du kan och klicka sedan på <b>Spara</b>.<br /><br />Det är allt.<br /><br />";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br />Detta låter dig länka en annan person som redan är inlagd som en ny make för denna person. Detta kommer att skapa en ny familj med maken du valde. Du kommer också att ha möjligheten att lägga till en vigsel för den nya familjen.<br /><br />";
$pgv_lang["link_wife_help"]			= "~#pgv_lang[link_as]# #pgv_lang[wife]#~<br /><br />Detta val är för att länka den valda personen till en familj som redan finns i GEDCOM-filen.<br /><br />Detta är en avancerad redigeringsmöjlighet som endast ska användas om familjen du vill länka till redan finns. Om du bara vill lägga till en <u>ny</u> familj, använd länken för att <b>#pgv_lang[add_new_husb]#</b><br /><br />";
$pgv_lang["add_wife_help"]			= "~#pgv_lang[add_new_wife]#~<br /><br />Genom att klicka på denna länk kan du lägga till en \"ny\" (kvinnlig) person och länka denna person till någon huvudindivid som en ny fru.<br /><br />Bara klicka på länken och du kommer att få ett nytt fönster för att lägga till en ny person. Fyll i så många boxar som du kan och klicka sedan på <b>Spara</b>.<br /><br />Det är allt.<br /><br />";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br />Detta låter dig länka en annan person som redan är inlagd som en ny maka till denna person. Detta kommer att skapa en ny famlij med makan du valde. Du kommer också ha möjligheten att ange en vigsel för den nya familjen.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~LÄGG TILL NY FADER ELLER MODER~<br /><br />Naturligtvis kommer det att finnas många personer i GEDCOM-filen utan poster med en fader eller moder.<br /><br />I detta fall, på <b>ansedelsidan</b>, fliken <b>Nära släktingar</b>, tabellen <b>Familj med föräldrar</b>, hittar du länkar för att lägga till en ny <b>ny</b> fader och/eller moder för personen.<br /><br /><b>TIPS:</b><br />Observera att dessa länkar är för att lägga till <b>ny</b> fader och/eller moder.<br />Om fadern eller modern redan har en post i denna GEDCOM-fil, då måste du använda länken: <b>#pgv_lang[child]#</b>, vilken du också hittar på ansedelsidan, under den sista tabellen på sidan.<br /><br />";


//-- Add Facts
$pgv_lang["add_facts_help"]			= "~LÄGG TILL NY FAKTA~<br /><br />Här kan du lägga till ny fakta om personen (eller personerna).<br /><br />Först välj ett fakta från rullgardinsmenyn, Klicka sedan på <b>Lägg till/b>. I rullgardinsmenyn finns redan alla möjliga fakta som kan läggas till till GEDCOM-filen.<br /><br />";
$pgv_lang["add_custom_facts_help"]		= "~Lägg till egna fakta~<br />Om du inte hittar det fakta du vill lägga till, i listan av GEDCOM-fakta, kan du lägga till <b>egna fakta</b> också.<br />Lägga till ett eget fakta är lika enkelt som att lägga till de fördefinierade fakta.<br />Den ända skillnaden är att du måste namnge faktan också. Du måste göra detta i det översta fältet: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~LÄGG TILL NY ANTECKNING~<br />Om du har en anteckning som du vill lägga till till denna person (eller dessa personer), är detta platsen att göra detta.<br />Processen är enkel, klicka på länken, skriv in anteckningen i fönstret som öppnas.<br /><br />När du har skrivit klart, klicka på knappen under fönstret, stäng fönstret, och allt är klart.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~LÄGG TILL NY KÄLLHÄNVISNING~<br />Genom att klicka på denna länk kan du lägga till en käll<b>hänvisning</b> för denna person (eller dessa personer).<br />Ett fönster öppnas, du kan välja en källa från listan(Sök ID) och lägg till \"hänvisning\".<br /><br />Lägga till källor är en viktig del av släktforskning eftersom det ger andra forskare möjlighet att kontrollera din information.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~#pgv_lang[add_media]#~<br /><br />Lägga till multimediafiler(MM) till GEDCOM-filen är en väldigt trevlig funktion.<br />Även om detta program har ett snyggt utseendet utan media, om du lägger till bilder eller annan MM för din släktingar, kommer det bara bli bättre.<br /><br /><b>Vad du behöver veta om MM.</b><br />Som du troligen redan vet, finns det nästan en oändlig mängd format för MM. Även om PhpGedView kan hantera de flesta av dem, det finns ett par saker att tänka på.<br /><br /><b>Format</b><br />Bilder kan editeras och sparas i många format.<br />T.ex. bild.jpg/bild.png/bild.bmp/bild.gif/etc.<br />Alla bilder i exemplet kommer att ha samma storlek, när du tittar på dem, men det kommer att var en stor skillnad i storlek på filerna.<br /><br /><b>Upplösning</b><br />Upplösningen på bilden ges i \"dpi\"(dot per inch). Du kan, mer eller mindre, jämföra skillnaderna mellan 25ASA - 200 ASA - 800 ASA för traditionella fotografier.<br />Ju högre upplsning, ju bättre kvalitet, men också större filer.<br />Normalt för en bild på internet, 75 dpi är tillräckligt bra<br /><br /><b>Färgdjup</b><br />Det tredje sättet att få filerna att bli små, är att minska färgdjupet som du ser.<br />Antalet färger som kan skilja från rent svart och vit till ett \"true colours\" allt där i mellan.<br />Här kan man igen anta att ju fler färger ju större storlek på filen.<br /><br /><b>Varför är det viktigt att storleken blir liten på filen</b><br /><br />Först och främst: Vårt utrymme på internet är begränsat.<br />Ju fler stora filer, ju mer plats behövs på vår server. Ju mer plats vi behöver ju mer kostar det.<br /><br />Nedladdnigstid. Om du stora filer, användaren(även du själv) måste vänta länge på sidan att ladda sig. <br />Alla har ju inte bredband.<br /><br /><b>Hur laddar du upp dina MM</b><br />Det finns två sätt att ladda upp MM till sajten. Om du har mycket MM att ladda upp bör du kontakta adminstratören för att diskutera det bästa sättet. Om påsatt av administratören, kan du använda ladda upp formuläret i Min Gedview menyn. Du kan också använda uppladdnings möjligheten i multimedia formuläret för att ladda upp media.<br /><br />";
$pgv_lang["add_facts_general_help"]		= "~Generell information om att lägga till~<br />När du har lagt till en ny fakta, anteckning, källa eller multimediafil till en person eller personer, måste tilläget först godkännas av en användare med accepterarättighter.<br /><br />Under tiden kommer ändringarna vara synliga på sidorna markerad med en annan ram, för använadare med ändringsrättigheter men för den vanliga användaren. När tillägget har godkänts kommer ramarna att försvinna och den nya datan kommer att visas normalt.<br /><br />";

//-- Edit user
$pgv_lang["edituser_my_account_help"]		="På denna sida kan du ändra dina inställningar och preferenser.<br /><br />Du kan ändra dit användarnamn, fullständiga namn, lösenord, språk, e-post adress, tema för denna sajt och föredragen kontaktmetod.<br /><br />Det ända sak du inte kan ändra själv är GEDCOM-filens INDI posters ID nummer.";
$pgv_lang["edituser_username_help"]		="~#pgv_lang[username]#~<br /><br />I denna box kan du ändra ditt användarnamn.<br />Om du inte gillar ditt användarnamn längre, eller har andra anledningar att ändra det, kan du göra det genom att använda detta formulär.<br /><br />Användarnamnet är <b>känsligt för stora och små bokstäver</b>. Detta betyder att att \"John\" inte är samma namn som \"john\" eller \"JOHN\".<br /><br />Du bör <b>endast</b> använda tecken från alfabetet, siffror, bindesstrck(-) och understräck (_).<br /><br />Använd <b>inte</b> punkter, mellanslag eller andra tecken utanför det normala alfabetet.<br /><br />";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I denna ruta kan du ändra ditt förnamn. Detta är namnet som andra användare ser när du är inloggad.<br /><br />Även om valet av namn som du skriver i detta fält är ditt så bör du informera administratören när du ändrar det. När andra ser ett okänd person online, kan de undra och ställa frågor. Administratören kan ta reda på det utan att ha fått något meddelande, men du bör spara honom det onödiga arbetet.<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I denna ruta kan du ändra ditt efternamn. Detta är namnet som andra användare ser när du är inloggad.<br /><br />Även om valet av namn som du skriver i detta fält är ditt så bör du informera administratören när du ändrar det. När andra ser ett okänd person online, kan de undra och ställa frågor. Administratören kan ta reda på det utan att ha fått något meddelande, men du bör spara honom det onödiga arbetet.<br /><br />";
$pgv_lang["edituser_gedcomid_help"]		="~#pgv_lang[gedcomid]#~<br /><br />Detta är ett internt (GEDCOM-ID) som länkar dig till din egen data i GEDCOM-filen.<br /><br />Du kan inte ändra detta ID.<br />Denna länk är satt av administratören.<br />Om du tycker att ID inte är korrekt bör du kontakta administratörens för att få det ändrat.<br /><br />";
$pgv_lang["edituser_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />Detta är utgångspersonen för alla tavlor.<br />Utgångspersonen är personen som man startar med.<br />Om du t.ex. klickar på länken till antavlan, så kommer du att se denna person längst till vänster som startperson.<br />Denna person behöver inte vara dig själv. Du kan starta med vilken person som helst så länge den du har rättigheter att se personen.<br />I vissa tavlor kan du ändra startperson men det påvärkar bara dessa sidor.<br /><br />";
$pgv_lang["edituser_password_help"]		="~#pgv_lang[password]#~<br /><br />Det är god sed att ändra lösenord med regelbundna mellanrum.<br />Du måste komma ihåg att alla som vet dit användarnamn och lösenord kommer att ha tillgång till din data.<br />Skapa ett lösenord med minst sex tecken. Ju längre desto bättre. Du kan använda alla tecken i alfabetet, alla siffror och vilket annat tecken som du kan hitta på ditt tangentbord.<br /><b>Note:</b> Det är bättre att <b>inte</b> använda cituationstecken(enkla eller dubbla). Det kan fungera, men garanteras inte.<br /><br /><b>Gör en kombination av stora och små bokstäver, siffror och andra tecken</b>.T.ex. 5Z_q\$P4=r9.<br /><br />Precis som användarnamnet, lösenordet är också känsligt för <b>stora och små bokstäver</b>. Det betyder att \"Jo5hn\" inte är detsamma som \"jo5hn\" eller \"JO5HN\".<br /><br />";
$pgv_lang["edituser_conf_password_help"]	="~#pgv_lang[confirm]#~<br /><br />Om du har ändrat dit lösenord, så måste du bekräfta det också.<br />Detta är enbart för att kontrollera att du inte skrivit fel tecken i lösenordsfältet.<br />Om programmet upptäcker att lösenordet och bekräftelsen inte stämmer överens får du detta felmeddelandet:<br /><b>#pgv_lang[password_mismatch]#</b>.<br />Både lösenordsfältet och bekräftelsefältet töms och du kommer att behöva skriva in lösenordet på nytt i båda fältet.<br /><br />";
$pgv_lang["edituser_change_lang_help"]		="~#pgv_lang[change_lang]#~<br /><br />Här kan du sätta vilket språk som ska vara ditt standardspråk för sajten.<br />Programmet klarar av att känna igen din <b>föredragna språkinställning</b> för din nätblädrare, så i de flesta fall finns det ingen anledning att ändra ditt föredragna språk för programmet här.<br />Men om t.ex. din nätbläddrare har engelska som föredraget språk, men du vill att <b>sajtens språk</b> ska var på holländska eller hebreiska, så kan du ändra här.<br /><br />";
$pgv_lang["edituser_email_help"]		="~#pgv_lang[emailadress]#~<br /><br />Din e-post adress är förstås viktig för oss så att vi kan hålla kontakt med dig.<br />Om du får en ny mailadress, t.ex när du byter levrantör, var vänlig och glöm inte byta din adress här också.<br />Du har kanske fler en än e-post adress och vill att din meddelande från oss ska komma till en annan e-post adress, ändra här tack.<br /><br />";
$pgv_lang["edituser_user_theme_help"]		="~#pgv_lang[user_theme]#~<br /><br />På denna sajt finns det flera teman.<br />Du kan kalla det \"sajt utseende\" också. I varje tema kommer du att se samma data, bara med ett annat utseende.<br />Det är som att sätta in en bild i ett annan ram, och hänga den i ett annat rum dessutom. Bilden ändras inte men sättet du ser på den är helt annerlunda.<br />Gör ett försök. Ändra till ett annat tema. Titta på det, försök ett annat. Ändra tillbaka till den du gillade bäst.<br />Varje gång när du loggar in, kommer programmet att starta med ditt \"egna tema\" igen.<br /><br />";
$pgv_lang["edituser_contact_meth_help"]		="~#pgv_lang[user_contact_method]#~<br />Vårt e-post system och några olika kontakt metoder<br />Kontakt metoden att skicka e-post är satt av sajt administratören, så du kan inte ändra denna inställning.<br />Kontakt metoden att <b>ta emot e-post</b> kan ändras av dig.<br />För tillfället kan du välja en av fyra möjliga kontaktmetoder.<br />";
$pgv_lang["mail_option1_help"]			="Om du använder denna inställning, det inbyggda meddelandesystem i PhpGedView kommer att användas och inga e-postmeddelande kommer att skickas.<br />På detta sätt kommer du endast att få <b>interna meddelande</b> från de andra användarna.<br />När en annan användare skickar ett meddelande från denna sajt, kommer detta meddelande att finnas i dit meddelandeområde eller i ditt egen Min Gedview sida(om du inte har tagit bort detta område från din sida)<br /><br />";
$pgv_lang["mail_option2_help"]			="Denna inställning är likadan som #pgv_lang[messaging]#, med ett tillägg.<br />Kopier av meddelandena kommer också att skickas till din e-postadress, som du angett i ditt konto.<br /><br />Denna kontaktmetod är standardinställningen.<br /><br />";
$pgv_lang["mail_option3_help"]			="Med denna inställning, får du bara meddelande till din e-postadress. Det interna meddelandesystemet i PhpGedView komer inte att användas och det kommer inte att finnas några meddelande i Meddelandeområdet på din personkiga #pgv_lang[mygedview]#-sida.<br /><br />";
$pgv_lang["mail_option4_help"]			="Med denna inställning kommer du inte få några meddelande alls. Inte ens adminisratören kan nå dig.<br /><br />";

//-- Add user
//

//-- Admin
$pgv_lang["admin_help"]				="På denna sida ser du alla länkar till alla sidor om konfiguration, administration, dokumentation och loggfiler.<br /><br /><b>Systemtiden</b>, Precis under sidtiteln visas tiden för servern på ditt webhotell.. Tiden som visas är servertiden när du öppnar sidan(eller laddar om den).<br /><br /><b>VARNING</b><br />När du ser ett varningsmeddelande under systemtiden så betyder det att din <b>config.php</b> fortfarande är skrivbar!<br />Efter su har konfigurerat din sajt, bör du, för att öka  <b>säkerheten</b>, ändra rättigheterna till endast läsbar.<br />Du måste göra detta manuellt efter som PhpGedView inte kan göra det åt dig.<br /><br />Förutom för valen: Readme, användarmanual och loggfil, får du mer hjälp på respektive sida.<br /><br />";

//-- User Admin
$pgv_lang["useradmin_help"]			="~#pgv_lang[user_admin]#~<br /><br />På denna sida kan du administrera de nuvarande användaren och lägg till nya användare.<br /><br /><b>#pgv_lang[current_users]#</b><br />I denna tabell visas de nuvarande användarna, deras status och deras rättigheter.<br />Du kan <b>Radera</b> eller <b>Redigera</b> användare.<br /><br /><b>#pgv_lang[add_user]#</b><br />Detta formulär är nästan det samma som du känner till från <b>#pgv_lang[editowndata]#</b><br /><br />För flera ämnen har vi inte gjort speciella hjälptexter för administratören. I dessa fall kommer du att se följande meddelande:";
$pgv_lang["useradmin_gedcomid_help"]		="~#pgv_lang[gedcomid]#~<br /><br />Detta #pgv_lang[gedcomid]# för användaren måste ställas in av administratören.<br />Det kommer att identifiera användaren.<br /><br />Detta kommer att ge användaren access till hans/hennes <b>#pgv_lang[my_indi]#</b>  och <b>#pgv_lang[my_pedigree]#</b><br /><br />För varje GEDCOM som du använder i programmet, kan du sätta GEDCOM-personid för användaren. Om en användare inte har en post i GEDCOM-filen, lämna textrutan tom.<br /><br />";
$pgv_lang["useradmin_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />För varje GEDCOM-fil i program, du kan sätta en <b>startperson</b> till en användare.<br /><br />Troligen vill användare starta programmet med hans egen antavla, men detta är inte ett krav.<br /><br />Användaren kan ändra denna inställning själv i sitt konto.<br /><br />";
$pgv_lang["useradmin_can_admin_help"]		="~#pgv_lang[can_admin]# KRYSSRUTA~<br /><br />Om denna ruta är ikryssad, har användaren samma rättigheter som du själv i programmet.<br /><dl><dt>Så han/hon kan inte bara:</dt><dd>Lägg till / Radera / Redigera användare.</dd><dd>Redigera och konfigurera språkfiler.</dd><dt>Utan också:</dt><dd>Uppgradera program.</dd><dd>Ändra konfiguration.</dd><dd>Administrera GEDCOM-filer.</dd><dd>Ändra integritetsinställningar.</dd><dt>Och allting annat som inte nmns h??r.</dt><dd>Men inte dina sajt inställningar utanför programmet</dd></dl>";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]# kryssruta~<br /><br />Om denna ruta är ikryssad och användaren har ett GEDCOM-id satt för dem, kommer deras användarkonto automatiskt synkroniserat med deras GEDCOM-data. Detta betyder att när användarens GEDCOM-post redigeras kommer viss information som t.ex. epostadress och namn kopieras till användarkontot. När användarkontot redigeras kommer motsvarande information att kopieras till GEDCOM-posten.";
$pgv_lang["useradmin_can_edit_help"]		="~#pgv_lang[can_edit]#~<br /><br />För varje GEDCOM i detta system kan användare ha vissa access och redigeringsrättighter.<ul><li><b>#pgv_lang[none]#</b> betyder att användaren inte kan komma åt privata fakta.<br /><br />Satt till .</li><li><b>#pgv_lang[access]#</b> betyder att användaren inte kan redigera eller lägga till ny data men han kan se den privata faktan.</li><li><b>#pgv_lang[access]#</b>betyder att användaren kan redigera data men en annan användare med .</li><li><b>#pgv_lang[edit]#</b> måste godkänna ändringarna innan de läggs till till databasen och blir öppna för allmänheter.<br /><br />Satt till <b>Acceptera</b> ger användaren möjlighet att redigera och godkänna ändringar gjorda av andra användare.<br /><br />Satt till <b>Administratör</b> ger användaren möjlighet att redigera konfiguration och integritetsinställningar för denna GEDCOM.<br /><br />Systemadministratören har automatiskt <b>Accepteraprivilegier</b>";
$pgv_lang["useradmin_verified_help"]		="~#pgv_lang[verified]#~<br /><br /><b>Självregistrering</b><br />En användare kan ansöka om ett nytt konto, genom <b>självregisteringsmodulen</b>. Om han gjorde det, då kommer han att få ett e-postmeddelande med en länk för att verifiera sin ansökan.<br />Om han redan gjort så, kommer du att se kryssrutan ikryssad, och du kan forsätta med nästa steg: <b>Användare godkänd av administratören</b>.<br />Om användaren inte har verifierats sigsjlv, du bör v??nta med ditt godkännade.<br /><br /><b>Lägg till användare manuellt</b><br />Om du använder formuläret att lägga till användare manuellt, kommer du att se kryssrutorna ikryssade från början.<br /><br />";
$pgv_lang["useradmin_verbyadmin_help"]		="~#pgv_lang[verified_by_admin]#~<br /><br />Om en användare har använt självregistreringmodulen och har verifierat sigsjälv, då är det sista steget, innan kontot blir brukbart, är ditt godkännade.<br /><br />Efter ditt godkännade av ansökan för ditt nya konto, användaren kommer att få ett e-postmeddelande att hans konto är aktiverat och han kan logga in med användarnamn och lösenord, som han använde när han ansökte om sitt konto.<br /><br />";
$pgv_lang["useradmin_edit_user_help"]		="~#pgv_lang[update_user]#~<br /><br />Detta formulär används av administratören för att ändra ett användarkonto.<br /><br />Formuläret är ganska likt formuläret <b>#pgv_lang[add_user]#</b> eller formuläret <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]		= "~SYNLIG ONLINE~<br /><br />Om denna ruta är ikryssad kommer andra inloggad användare att kunna se när du är online och du kan se när de är online. Om du inte vill att andra ska se när du är online, då ska du inte kryssa i denna ruta men kommer då inte heller se när andra är online.";
$pgv_lang["useradmin_editaccount_help"]			= "~REDIGERA KONTOINFORMATION~<br /><br />Om denna ruta är ikryssad, kommer denna användare att kunna redigera deras kontoinformation. Om denna ruta inte är kryssad, kommer de inte att kunna redigera deras kontoinformation. Detta gör att man kan skapa ett ända användarnamn och lösenord för multipla användare och hindra dem från att redigera deras kontoinformation.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Om denna ruta är ikryssad, kommer användaren endast få tillgång till de levande personer de är släkt med. De kommer kunna se alla som är inom släktförhållande avståndet satt av <i>#pgv_lang[user_path_length]#</i> inställningen. Du kan kräva släktförhållandeintegritet för alla användare genom att sätta på det globala valet i GEDCOM-ingritetsinställningarna.<br /><br />Denna inställning kräver att användaren associeras med ett GEDCOM-id innan de kan se några levande personerna.<br /><br />";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Om <i>#pgv_lang[user_relationship_priv]#</i> är igång, kommer denna användare endast at se eller ändra peronerna inom detta antal släktskapssteg.<br /><br />";
$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />Genom att kryssa i denna ruta tillåter du systemet att automatiskt acceptera alla ändringar som denna användare gör. Användaren måste ha acceptera privilegier för GEDCOM-filen för att denna inställning ska ha någon effekt.<br /><br />";
$pgv_lang["help_managesites"] 			= "~HANTERA SAJTER~<br /><br />På denna sida kan du lägga till andra sajter och förbjuda IP-adresser.<br /><br />Andra sajter kan läggas till genom att ange sajtens titel, URL, databasens id(valfritt), användarnamn och lösenord.<br /><br />Förbjuda IP-adresser görs genom att ange vilken giltig IP-adress område som helst. T.ex. 212.10.*.* andra sajter inom detta IP-adressområde kan inte koplla sig till din webservice. Du kan även förbjuda specifika IP-adresser.";
$pgv_lang["help_remotesites"]			= "~Lägga till andra sajter~<br /><br />För att lägga till en annan sajt, ange sajtens rubrik, URL till den andra sajten, databasens id(valfritt) och användarnamn och lösenord. Klicka på Lägg till knappen för att avsluta processen. Om den andra sajten tillåter anonym inloggning ska du lämna användar och lösenordsfälten tomma.";
$pgv_lang["help_banning"]				= "~IP Address Banning~<br /><br />För att förbjuda en annan sajt att koppla sig mot din webservice, ange en specifik IP-adress eller ett korrekt IP-område. t.ex. 212.10.*.* och klicka på Skicka knappen.";
$pgv_lang["help_manual_search_engines"]				= "~Manuell sökmotor markering~<br /><br />PhpGedView ger sökmotorer mindre data filer automatiskt med färre länkar. Datan begränsas till personen och den närmaste familjen, utan att lägga till information om far/mor-föräldar eller barnbarn. Många rapporter och serverintensiva sidor som kalandern är förbjuden mark för sökmotorer.<br /><br />Om en sökmotor in känns igen automatiskt och du vill ge den data att indexera, så lista den här. Om du inte vill ge den någon data så lista den nedan under bannlysta IP-adress sektionen.<br /><br />Om du vill se vad för data som sökmotorer får att indexera, lista din een IP-adress här. <span class='warning'>WARNING:</span>Detta kommer att låsa dig ute från administrationssidorna så du måste logga in från en annan maskin för att tabort IP-adressen eller manuellt editera filen <i>/index/search_engines.php</i>.<br /><br />För att manuellt markera en annan sajt som en sökmotor så ange en specifik IP-adress eller en godkänd område, t.ex. 212.10.*.*, klicka sedan på skicka. Många sökmotorer som Google och Yahoo upptäcks automatiskt.";
$pgv_lang["search_engine_landing_page"]		= "~Sökmotor upptäckt~<br /><br />PhpGedView ger automatiskt sökmotorer med mindre datafiler med mindre antal länkar. Datan är begränsad till personen och den direkta familjen utan att lägga till information om farföräldrar och barnbarn. Många rapporter och serverintesiva sidor som kalender är förbjudet område för sökmotorerna.<br /><br />Försök av sökmotorer att gå till dessa sidor kommer att ge denna sida som resultat. Om du ser denna text så tror programmet att du är en sökmotor. Nedan finns listan av sidor som sökmotorer får lova att besöka och som kommer ge den förkortade versionen.<br /><br />Riktiga användare som följer sökmotorns länkar till din sajt kommer att se den kompletta sidan och inte den förkortade.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		="~LÄGGA TILL JÄMFÖRT MED ATT LADDA UPP~<br /><b>Ladda upp GEDCOM-fil</b><br />Ladda upp filer kan göras online.<br />Du kan ladda upp från vilken plats som helst, utan att använda ett ftp-program.<br /><b>Lägga till GEDCOM-fil</b><br />Om en fil fortfarande finns i din GEDCOM-katalog, kan du använda den utan att ladda upp den igen.<br />Ibland behöver du använda Lägga till istället för Ladda upp, beroende på filstorlek, eller uppladnings begränsningar.<br />Båda procedurerna Lägga till och Ladda upp kan avslutas i 4 steg.<br />Endast steg 1 sklijer sig.<br />";
$pgv_lang["gedcom_configfile_help"]		="~GEDCOM KONFIGURATIONSFIL~<br /><br />Detta är filen där alla grundläggande inställningar sparas för GEDCOM-filen.<br /><br />I kolumnen \"Konfigurationsfil\" på GEDCOM-administrationssidan visas sökvägen och namnet för konfigurationsfilen.";
$pgv_lang["default_gedcom_help"]		="~STANDARD-GEDCOM~<br /><br />Om du har mer än en GEDCOM-fil i programmet kan du här ställa in vilken som ska vara <b>standard</b> GEDCOM-fil.<br /><br />Detta kommer att vara den GEDCOM-fil som visas för besökare och användare som inte är inloggade än.<br /><br />Användare kan ändra denna standardinställning, när de ändrar inställningar för deras användarkonto.<br />";
$pgv_lang["delete_gedcom_help"]			="~RADERA GEDCOM-FIL~<br /><br />PhpGedView importerar poster från GEDCOM-filen. När du klickar på <b>Radera</b>, kommer programmet att radera de poster som importerades från GEDCOM-filen.<br />Den faktiska GEDCOM-filen kommer att bli kvar i katalogen som den laddades upp till.<br /><br />Om de senare vill arbeta med den GEDCOM-filen igen behöver du inte ladda upp den igen. Du kan då istället välja <b>Lägg till GEDCOM</b>.<br /><br />Efter att du klickat på Radera kommer att få <b>konfirmera</b> ditt val i en fönsterdialog.";
//
$pgv_lang["add_gedcom_help"]			="~#pgv_lang[add_gedcom]#~<br /><br />När du använder Lägg till GEDCOM-fil, antas det att du redan har laddat upp GEDCOM-filen till din server, <i>med hjälp av ett externt program</i>, t.ex. genom din ftpkoppling.<br />Om GEDCOM filen inte finns på din server än, så <b>måste</b> du göra det först, innan du kan börja lägga till.<br /><br />Du guidas steg för steg genom proceduren.<br /><br />";
$pgv_lang["add_new_gedcom_help"]		="~#pgv_lang[add_new_gedcom]#~<br /><br />Du har möjligheten att starta med en helt ny GEDCOM-fil.<br /><br />Du kan slutföra denna procedur i endast några få steg. Steg 1 skiljer sig från de du redan känner till genom uppladdning och att lägga till. De andra stegen är familjära.<br /><b>Steg 1: Namnge den nya filen.</b><br />Skriv in namnet på den nya filen utan tilläget '.ged'. Den nya filen kommer att skapas i katalogen som anges ovanför namnfältet som du skrev in namnet i.<br />Klicka på <b>Lägg till</b>.<br /><b>Steg 2: Konfigurationssidan.</b><br />Detta är den vanliga konfigurationssidan för GEDCOM-filer.<br /><b>Steg 3: Validera.</b><br />Också detta steg är det samma som vanligt. Den nya filen kontrolleras och godkännas.<br /><b>Steg4: Importera poster.</b><br />Eftersom det endast finns en post att importera så kommer detta att gå fort.<br /><b>Redo att skapa</b><br />Nu kan du gå till antavlan och se den första personen i din GEDCOM-fil. Klicka på namnet för personen och börja redigera. Efter det kan du börja lägga till nya personer till den första.<br /><br />";
$pgv_lang["download_gedcom_help"]		="~#pgv_lang[download_gedcom]#~<br /><br />Du har möjligheten att ladda ner en GEDCOM-fil från din sajt. Du vill kanske importera datan till ett annat genealogiska programmet, eller kanske vill du dela information med andra.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
$pgv_lang["edit_gedcoms_help"]			="~#pgv_lang[gedcom_adm_head]#~<br /><br />#pgv_lang[gedcom_adm_head]#-sidan är kontrollcenter för administrering av den alla GEDCOM-filer.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />I tabellen för <b>#pgv_lang[current_gedcoms]#</b> finns följande val.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>I tabellen för <b>#pgv_lang[current_gedcoms]#</b> listas varje GECOM-fil för sig och har följande val för varje GEDCOM-fil: :<ul><li>Import GEDCOM</li><li>Delete GEDCOM</li><li>Download GEDCOM</li><li>#pgv_lang[make_slklist]#</li><li>Redigera GEDCOM-konfiguration</li><li>Redigera GEDCOM-integritet</li><li>Sökloggfiler</li></ul>Editera integritet är ett val i denna tabell eftersom varje GEDCOM-fil har sin egen integritetsfil.<br /><br />Varje rad i tabellen bör vara självförklarande. PhpGedView kan konfigureras att logga alla databas sökningar. Sökloggsfilerna kan kontrolleras via länkar på denna sida.<br />#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]		="~ADMINISTRERA GEDCOM~<br /><br />Varje GEDCOM som du använder i programmet har sin egen <b>konfigurationsfil</b>.<br /><br />I detta formulär ställer du in standardinställningar som t.ex. språk, kalenderformat, e-postinställningar, etc., etc.<br />";
$pgv_lang["import_gedcom_help"]			="~IMPORTERA GEDCOM-FIL~<br /><br />I de flesta fall är importering av GEDCOM-fil ett steg i en procedur som, t.ex. lägga till, lägga till ny, ladda upp GEDCOM-fil.<br /><br />Dessa steg följer en logisk följd och måste slutföras, för att sedan kunna arbeta med filen.<br />Om du inte fullföljde sekvensen som beskrevs förut, kommer du att se ett </b>varningmeddelande</b> att GEDCOM-filen inte har importerats än. I detta fall, klicka på länken för att importera GEDCOM-filen igen.<br /><br /><b>Importera</b><br />Konfigurationinställningar för GEDCOM-filen kommer inte att ändras när du importerar filen igen.<br />Den nuvarande datan kommer att skrivas över.";
$pgv_lang["upload_gedcom_help"]			="~#pgv_lang[upload_gedcom]#~<br /><br />Till skillnad mot \"Lägg till GEDCOM-fil\", behöver du inte ha GEDCOM-filen på din server än.<br /><br />I steg 1 väljer du en GEDCOM-fil från din lokala dator. Skriv in den kompletta sökvägen och filnamnet i textboxen, eller använd <b>Browse</b> på sidan.<br /><br />Du hittar mer hjälp på de andra sidorna under proceduren.<br /><br />";
$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Ska AJAX bildspel starta automatiskt när sidan laddas.<br /><br />Denna funktion använder AJAX-teknik för att ändra innehållet i området utan att förladda information från servern och utan att ladda om hela sidan.<br /><br />";
$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />Du kan använda denna inställning för att sätta på och stänga av visningskontroller för det slumpmässiga mediaområdet. Visningskontrollerna tillåter användarna att hoppa till ett annat slumpmässigt media objekt eller att spela igenom slumpmässigt valda media som ett bildspel. Denna funktion använder AJAX-teknik för att ändra innehållet för området utan att förladda information från servern och utan att ladda om hela sidan.<br /><br />";
$pgv_lang["validate_gedcom_help"]		="~VALIDERA GEDCOM-FIL~<br /><br />Validera GEDCOM-filen som du laddar upp eller lägger till är steg tre i proceduren för att sätta upp programmet för att fungera med denna fil.<br /><br />Filen kontrolleras för korrekt användningen av: Datumformat, Orter och Teckenuppsättning, etc.<br />Några avikelser, som programmet hittar, kommer att rättas automatiskt. T.ex. Macintosh radslut och felaktiga ortsformat.<br />I dessa fall kommer du se ett meddelande att programmet har ändrat datan.<br />För andra avikelser kommer du få ett varningsmeddelande med en angiven lösning.<br /><br /><b>Frivilliga verktyg</b><br />För tillfället finns det två frivilliga verktyg:<br /><b>Ändra person ID till...</b> och <b>Lägg till media verktyg</b>.<br />Det sista verktyget är endast tillgängligt i <b>MySQL</b>-mod. Om du har GEDCOM-filen i <b>Index</b>-mod är detta val dolt.<br /><br /><b>Mer hjälp</b> finns tillgänglig i formuläret.#pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		="~KONVERTERA ANSI TILL UTF-8~<br /><br />För att vara säker på att programmet hanterar GEDCOM-filerna korrekt, bör filerna teckenkodning vara UTF-8.<br /><br />De flesta tredjeparts släktforskningsprogram har möjlighet att exportera en GEDCOM-filen i detta format.<br />Om programmet som du använder inte erbjuder denna möjlighet kan PhpGedView konvertera filen åt dig.<br /><br />När PhpGedView validerar den uppladdade (eller tillagda) filen, kommer programmet att upptäcka om filen är kodad i ANSI.<br /><br />";
$pgv_lang["detected_ansi2utf_help"]		="~ANSI KODNING UPPTÄCKT~<br /><br />GEDCOM-filen som valideras nu är kodad i ANSI.<br />Det rekomderas starkt att filen konverteras till UTF-8.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			="~FEL DATUMFORMAT UPPTÄCKT:~<br /><br /><b>DATUMFORMATET KOMMER ATT ÄNDRAS</b><br /><br />Datumformatet som är standard i PhpGedView och också enligt <b>GEDCOM 5.5.1 standarden</b> är: DD MMM YYY (alltså 01 JAN 2004)<br /><br />Om du ser, efter att din GEDCOM-fil har blivit validerad, ett meddelande att fel datumformat har upptäckts, kommer programmet att konvertera datumet till standarden.<br /><br />Du har, ändå, möjlighet att välja antingen \"<b>dag</b> före månad\" (DD MMM YYYY), eller \"<b>månad</b> före dag\" (MMM DD YYYY).<br />Vi rekomenderar att du beåller den föreslagna inställningen, alltså det första valet.<br /><br />";
$pgv_lang["change_indi2id_help"]		= "~ÄNDRA PERSONID TILL...~<br /><br />Detta verktyg var designat för personer med släktforskningsprogram som använder olika GEDCOM-id för personer varje gång de exporteras. T.ex. första gången GEDCOM-filen exporteras någon persons id är I100 men nästa gång GEDCOM-filen exporteras får samma person I234. Dessa föränderliga id gör det svårt för administrera PhpGedView eftersom Idna används för att referera till personer.<br /><br />De flesta släktforskningsprogram använder oftast dessutom RIN eller REFN taggen för att ge en person ett unik identifiering för att referera till en person. Detta verktyg ersätter alla personers id i GEDCOM-filen med värdet från vilket annat fält som du anger. Du kan välja RIN eller REFN fältet för att ersätta idna med.<br /><br />";
$pgv_lang["edit_privacy_help"]			="På denna sida du göra alla integritetsinställningar för den valda GEDCOM-filen(om du har mer än en).<br />Du kan kolla under sidtiteln om du editerar rätt integritetsfil.<br />Det visas så här:(sökväg/namnpådinGEDCOMfil_priv.php)<br /><br />Om du behöver fler inställningar, då kan du manuellt göra ändringar i integritetsfilen. Du kan läsa mer om detta på PhpGedViews hemsida.<br /><br />";
$pgv_lang["BOM_detected_help"]			= "~Byte Order Mark (BOM) upptäckta~<br /><br />GEDCOM-filen du importerar har en speciel 3-byte kod i början av filen. Denna speciella kod används av vissa program för att indikera att filen är kodad i UTF-8.<br /><br />Även om denna kod inte igentligen är ett fel, kommer PhpGedView inte att fungera ordenligt om filen innhåller denna kod. Du bör låta PhpGedView tabort denna kod.<br /><br />";
$pgv_lang["invalid_header_help"]		= "~FELAKTIG GEDCOM START~<br />En GEDCOM-fil måste starta med raden 0 HEAD. PhpGedView har upptäckt att din GEDCOM-fil inte startar med raden 0 HEAD. Efter du tryckt på städnings knappen kommer alla rader före dne första 0 HEAD raden att raderas från din GEDCOM-filen.<br /><br />Detta fel beror oftast på att programmet som användes för att skapa GEDCOM-filen inte gjorde det korrekt eller att filen inte är en GEDCOM-fil. Du bör kontrollera att du har laddat upp rätt GEDCOM-fil och att den startar med 0 HEAD och slutar med raden 0 TRLR.<br /><br />";
$pgv_lang["macfile_detected_help"]		= "~MACINTOSHFIL UPPTÄCKT~<br />PhpGedView har upptäckt att din GEDCOM-fil skapades med en Macintoshdator. Macintoshfiler använder annat radslut (r) än Unix (n) eller Windows (rn). PHPfunktioner som används av PhpGedView kräver att GEDCOM-filen måste vara Unix- eller DOS-fil. När du trycker på städknappen kommer filen att konverteras till en DOSfil.<br />";
$pgv_lang["cleanup_places_help"]		= "~RENSA ORTER~<br />PhpGedView har upptäckt att din GEDCOM-fil använder orter vid taggar som inte ska ha orter.<br /><br />Många släktforskningsprogram, som Family Tree Maker, skapar den typ av GEDCOM-fil. PhpGedView kommer att fungera med dessa GEDCOM-filer, men vissa felaktiga orter kommer att visas i din ortshierarki.<br /><br />Som exempel, Din GEDCOM-fil kan ha följande kodning<br />1 SSN<br />2 PLAC 123-45-6789<br />Enligt GEDCOM-standarden ska detta igentligen visas som<br />1 SSN 123-45-6789<br />Om du väljer <b>Ja</b>, kommer PhpGedView automatiskt upptäcka och rätta till denna typ av kodningfel.<br /><br />";
$pgv_lang["empty_lines_detected_help"]	= "~TOMMA RADER UPPTÄCKTA~<br />PhpGedView har upptäckt tomma rader i din GEDCOM-fil. Dessa rader kan orsaka fel och kommer att tas bort från GEDCOM-filen innan den importeras.<br /><br />";
$pgv_lang["skip_cleanup_help"]			= "~HOPPA ÖVER STÄDNING~<br />Det rekomenderas starkt att du låter PhpGedView städa upp din GEDCOM-fil före den är importerad, annars kanske inte alla funktioner fungerar som de ska.<br /><br />Men om du vill, kan du klicka på denna knapp för att hoppa över detta steg och fortsätta importen av GEDCOM-filen.<br /><br /><b>Tänk på att om du låter bli att städa upp filen kan vissa funktioner i PhpGedView generara oförutsägbara resultat.</b><br /><br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		="~KONFIGURERA PhpGedView~<br /><br />På denna sida måste du ställa in de globala inställningarna för programmet, när du precis har installerat PhpGedView på din server, och kör den för första gången.<br />#pgv_lang[review_readme]#<br /><br />Eftersom dessa inställningar är <b>globala</b>, är de för hela programmet och för alla GEDCOM-filer, som du använder i programmet.<br />För varje GEDCOM-fil kan du göra specifika inställningar genom att klicka på <b>#pgv_lang[admin_gedcoms]#</b> länken på denna sida.<br /><br />Du kan också komma till  #pgv_lang[gedcom_adm_head]# funktionen från huvudadministratörssidan, vars länk du hittar i menyn under #pgv_lang[mgv]#-ikonen. På administratörssidan är den relevanta länken <br /><b>#pgv_lang[manage_gedcoms]#.</b><br /><br />";
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Denna sida låter dig slå ihop två GEDCOM-poster i samma GEDCOM-fil.<br /><br />Detta är användbart för personer som har slagit ihop GEDCOM-filer och nu har många personer, familjer ocjh källor som är samma.<br /><br />Sidan betår av tre steg.<br /><ol><li>Du skriver in två GEDCOM-id. IDna <u>måste</u> vara av samma typ. Du kan inte slå ihop en person och en familj eller en familj och en källa t.ex.<br />I <b>#pgv_lang[merge_to]#</b>-fältet skriver du in idt för posten du vill ska vara den nya posten efter ihopslagningen är färdig.<br />I <b>#pgv_lang[merge_from]#</b>-fältet skriver du in id för posten vars information ska flyttas in i #pgv_lang[merge_to]#-posten. Denna poste kommer att raderas efter ihopslagningen.</li><br /><li>Du bestämmer vilka fakta du vill behålla ifrån de två posterna när de slås ihop. Klicka bara i kryssruterna intill de du vill behålla.</li><br /><li>Du kontrollerar resultatet av ihopslagningen precis som alla ändringar gjorda online.</li></ol>Någon med Accepterarättighter måste godkänna ändringarna för att göra dem permanenta.</li></ul><br />";

//-- Language Editor
$pgv_lang["help_reportengine.php"]	= "~RAPPORT~<br />Rapportmenyns val kommer att generera PDF-filer för utskrift.<br /><br />Första steget är att välja en rapport att köra. När du valt en rapport att köra kommer du att bli ombedd att ange lite information specifik för rapporten som t.ex. vilken person eller familj att börja med och om bilder ska visas eller inte. När du är redo att köra rapporten, klicka på \"#pgv_lang[download_report]#\"-knappen för att ladda ner rapporten till din dator.<br /><br /><br />#pgv_lang[help_xml_reports]#<br />#pgv_lang[def_pdf_format_help]#<br />#pgv_lang[help_ahnentafel.xml]#<br />#pgv_lang[help_birthlist.xml]#<br />#pgv_lang[help_relativelist.xml]#";
$pgv_lang["def_pdf_format_help"]	= "~PDF-FILFORMAT~<br />PhpGedViews rapportmotor skapar nerladdningsbara rapporter i Adobe&reg; PDF-format. GEDCOM 5.5.1 standardspecifikation, nämnd på annat ställe i hjälpfilen är också nerladdningsbar som PDF-fil. PDF är en förkortning för <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />PDF-filer kan inte visas eller skrivas ut med en PC standardprogram. Om du redan har Acrobat Reader installerat (det medföljer ofta andra program), behöver du inte ändra eller uppgradera det för att hantera rapportfilerna som skapas av PhpGedView.<br /><br />Acrobat Reader, visnings och utskriftsprogrammet för dessa filer finns tillgängligt gratis från Adobe Systems Inc. Den fria Adobe&reg; Acrobat Reader kan laddas ner från <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=_blank><b>Adobe Systems Inc.</b></a> websajt. Det finns kopier att ladda ner från andra websajter, men vi rekomendera dig att endast använda Adobe Systems Inc. sajt.<br /><br />Acrobat Reader finns tillgängligt för många olika system, t.ex. Microsoft&reg; Windows och Apple&reg; Macintosh, för många språk förutom engelska. Om du har ett Windows 95 system, kontrollera att du laddar ner Acrobat Reader version 5.0.5, nyare versioner fungerar inte för windows 95.<br /><br /><a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=_blank><b>Ladda ner Adobe Reader här</b></a><br /><br />";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br />Detta är en rapport om den valda personen och hans anor utskrivna i häftform. Den startar med den valda personen och fortsätter sedan med hans föräldrar, farförädrar, osv.<br /><br />Observera att antavlerapporten är endast tillgänglig på engelska för tillfället.<br /><br />";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br />Med denna rapport kan du lista alla personer som var födda på en bestämd plats eller ort.<br /><br />";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br />Denna rapport kommer att lista alla släktingar till den valda personen. Du kan välja vilka av personens släktingar som ska visas.<ul><li><b>#pgv_lang[child-family]#</b> kommer att visa den valda personen, hans föräldrar och hans syskon.</li><li><b>#pgv_lang[spouse-family]#</b> kommer att visa de personen med sin make/maka och deras barn.</li><li><b>#pgv_lang[direct-ancestors]#</b> kommer att visa personen, hans föräldrar, far- och morföräldrar osv. så långt bak som det finns registrerade personer.</li><li><b>#pgv_lang[ancestors]#</b> kommer att visa alla personer som #pgv_lang[direct-ancestors]# visar, dessutom kommer alla mor- farbröder, mostrar och fastrar osv. så att alla syskon till alla anfäder i personens anträd visas. Den kommer inte visa barnen till syskonen (kusinen).</li><li><b>#pgv_lang[descendants]#</b>kommer att lista alla personens ättlingar (barn, barnbarn, barnbarnsbarn, etc.).</li><li><b>#pgv_lang[all]#</b> detta är en kombination för #pgv_lang[descendants]# och #pgv_lang[ancestors]# i en enda rapport.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]	= "~Rapportmotor~<br />PhpGedViews rapportmotor använder XML-mallfiler för att automatiskt generera PDF-rapporter.<br /><br />Rapporterna som finns tillgängliga i <b>#pgv_lang[select_report]#</b> listan är genererade från rapport-XMLfilerna som finns i \"reports\"-mappen. Du kan skapa egna rapporter genom att göra en kopia av någon av XML-mallarna som finns tillgängliga och modifiera den. För att lägga till din egen rapport, så lägger du den bara i \"reports\"-mappen och PhpGedView kommer automatiskt att hitta den och göra den tillgänglig i <b>#pgv_lang[select_report]#</b>-menyn.<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>HJÄLP INNEHÅLL</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM-information";
$pgv_lang["help_contents_gedcom_places"]	= "Orter i GEDCOM-filen";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	="<b>HJÄLPINNEHÅLL<br /><br />ADMINISTRATÖRSHJÄLPARTIKLAR</b> tillagda till början av listan.<br /><br />";
$pgv_lang["ah2_help"]				="_Konfigurera PhpGedView";
$pgv_lang["ah3_help"]				="_GEDCOM: Lägg till kontra Ladda upp";
$pgv_lang["ah4_help"]				="_GEDCOM: Konfigurationsfil";
$pgv_lang["ah5_help"]				="_GEDCOM: Standard";
$pgv_lang["ah6_help"]				="_GEDCOM: Radera";
$pgv_lang["ah7_help"]				="_GEDCOM: Lägga till";
$pgv_lang["ah8_help"]				="_GEDCOM: Skapa ny";
$pgv_lang["ah9_help"]				="_GEDCOM: Ladda ner";
$pgv_lang["ah10_help"]				="_GEDCOM: Administratörssida";
$pgv_lang["ah11_help"]				="_GEDCOM: Konfigurera";
$pgv_lang["ah12_help"]				="_GEDCOM: Importera";
$pgv_lang["ah13_help"]				="_GEDCOM: Ladda upp";
$pgv_lang["ah14_help"]				="_GEDCOM: Validera";
$pgv_lang["ah15_help"]				="_GEDCOM: Konvertera ANSI till UTF-8";
$pgv_lang["ah16_help"]				="_GEDCOM: Integritetsinställningar";
$pgv_lang["ah17_help"]				="_Användaradministration";
$pgv_lang["ah18_help"]				="_Administration";
$pgv_lang["ah19_help"]				="_GEDCOM: Mediaverktyg";

$pgv_lang["ah20_help"]				="_GEDCOM: Ändra person-id till .....";
$pgv_lang["ah21_help"]				= "_Översättarverktyg";
$pgv_lang["ah23_help"]				= "_Konfigurera stödda språk";
$pgv_lang["ah24_help"]				= "_Användarinformation migrering (SQL <<-->> Index)";
$pgv_lang["ah25_help"]				= "_PhpGedView backup";
$pgv_lang["ah26_help"]				= "_FAQ Lista: Redigera";
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />Detta är steg två i kontrollen av uppladningen av mediafiler om du har mappnivåer konfigurerade under standard mediamappen.<br /><br />Som en adminstratör kan du skapa den mappstruktur du behöver för att hålla ordning på dina media filer. Skapa mappar från denna sida försäkrar dig om att miniatyrbildsmappar skapas dessutom skapas en passande index.php i varje mapp.<br /><br />Du kan flytta filer upp och ner i mappstrukturen med Flytta till --> länken. Ministyrbilden flyttas också så att filstrukturen hålls intakt.<br /><br />Om du inte laddade upp miniatyrbildsfiler eller glömde att kryssa <b>#pgv_lang[gen_thumb]#</b> kryssrutan under uppladningen har du valet att generara miniatyrbilder härifrån. Kryssa <b>#pgv_lang[show_thumbnail]#</b> rutan, om en miniatyrbild inte hittas kan du klicka på <b>#pgv_lang[gen_thumb]#</b>-länken för att skapa en.<br /><br />";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]~<br /><br />Enkelt sökfilter baserad på inskrivna bokstäver, inga jokertecken är tillåtna.<br /><br />";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]~<br /><br />Miniatyrbilder kommer att visa om du kryssar i denna ruta.<br /><br />";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />Som en administratören kan du skapa mappstrukturen som du behöver för att hålla dina mediafiler organisera. Skapa mappar från denna sida försäkrar dig om att miniatyrbildsmapparna blir skapade dessutom skapas en tillhörande index.php i varje mapp.<br /><br />Klicka på denna länk för att skriva in namnet på mappen som du vill skapa.<br /><br />";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]~<br /><br />Detta tillåter dig att söka igenom mediafilsystemet för att hitta mediaartiklar som du vill länka till.<br /><br />";
$pgv_lang["add_media_linkid"]		= "~Länk ID~<br /><br />Varje mediaobjekt skall vara associerad med en eller flera personer, familjer ller källori din databas.<br /><br />För att skapa en sådan länk kan du skriva in eller söka efter ett ID för personen, familjen eller källan på samma gång som du skapar mediaobjektet. Du kan också skapa länken senare genom att redigeringsvalet på Hantera media sidan eller genom att lägga till mediaobjekt via Lägg till medialänk som finns på person- familje- eller källsidan.<br /><br />";
$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />Mediafilen som du laddar upp kan och bör antagligen få ett annat namn på servern än den har på din lokala dator. Det är för att ofta så har filnamnet mening för dig men är mycket mindre meningsfullt för besökare på din sajt. Tänk också på att det fins en möjlighet att både du och någon annan försöker ladda upp olika filer som heter Granny.jpg.<br /><br />I detta fält specificerar du det nya namnet på filen som laddar upp. Namnet du anger kommer också att användas till namnet på miniatyrbilden, som kan laddas upp separat eller skapas automatiskt. Du behöver inte ange filtypen (jpg,gif,pdf,doc,etc.).<br /><br />Lämna detta fält tomt för att behålla orginalfilnamnet på filen du laddar upp.<br /><br />";
$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />Administratören är tillåtit upp till #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappnivåer lägre än standardnivån <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Detta hjälper dig att organisera dina mediafiler och minskar risken för namnkrockar.<br /><br />I detta fält specificerar du destinationsmappen var den uppladdade filen ska hamna. Den matchande miniatyrfilen, antingen uppladdad separat eller automatiskt genererad kommer att sparas in en liknande mappstruktur som startar på <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> istället för <b>#GLOBALS[MEDIA_DIRECTORY]#</b>. Du behöver inte skriva in <b>#GLOBALS[MEDIA_DIRECTORY]#</b> delen av destinationmappnamnet.<br /><br />Om du inte är säker på vad du ska skriva här, bör du kontakta sajtadministratören för råd.<br /><br />";
$pgv_lang["alive_in_year_help"]		= "~#pgv_lang[alive_in_year]#~<br /><br />Detta visar personerna som bör leva under det valda året.<br /><br />När det finns födelse och dödsdatum så markeras personen som levande om sökåret faller inom deras livstid.<br /><br />Skriv in ett annat år och klicka på <b>Visa</b>-knappen för att se vem som är i livet detta år. Resten av sidan fungerar precis som personlistan.<br /><br />";
$pgv_lang["year_help"]				= "~#pgv_lang[alive_in_year]~<br /><br />Skriv in det årtal där du söker efter levande personer.<br /><br />";
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />En lista av arkiv visas på denna sida.<br /><br />Namnen på arkivet är sorterad i alfabetisk ordning.<br /><br /><b>ARKIV</b><br />Utan arkiv kan vi inte bygga databasen. Det finns en källa för all information sparad i databasen och den källa förvaras i arkivet. Arkivet kan vara ett personligt arkiv hos en person, en instutition, en publik databas, en statlig eller kyrklig arkiv, en internet källa, etc. För att få access till en källa vill vi veta var och på vilken platd den finns. All nödvändig information för att hitta en källa ska sparas i arkivposten.<br /><br />Ett arkiv kan länkas till många källor.<br /><br />";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Detaljerna för arkivet visas här. Tillsammans med källor är arkiven väldigt viktiga för släktforskare. Med korrekta källor och arkivinformation kan du följa spåret efter hur andra forskare hittat informationen. Bör du kunna hitta samma information igen.<br /><br />På denna sida kan du hitta information om arkivtitel, adress, epost och websida.<br /><br />Efter detaljerna om arkivet kommer en lista om alla källor som är kopplade till detta arkiv. Detta låter dig se all information som har hittats i ett specifikt arkiv.<br /><br />Om påslaget av sajtadministratören kommer du att ha en eller två nya menyikonerpå dessa sidor::<br /><b>#pgv_lang[view_gedcom]#</b>, vilket visar informationen i GEDCOM-format.<br /><b>#pgv_lang[add_to_cart]#</b>, vilket låter dig spara informationen i urklippskorgen #pgv_lang[clip_cart]#. Från där kan du ladda ner informationen i GEDCOM-filformatet så att du kann importera det till ditt vanliga släktforskningprogram.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />När du klickar på detta val markerar du databasen för radering.<br /><br />Vad betyder detta?<br />Antag att du har en bra anledning att radera arkiv från databasen. Klicka på denna länk. Du kommer att tillfråagas om du är säker. Om du väljer att fortsätta kan det ta ett litet tag innan du får se meddelandet att arkivet är raderad.<br /><br />När du fortsätter besöket kommer du att märka att arkivet fortfarande syns och kan användas precis som om raderingen inte hänt.<br /><br /><b>Detta är <u>inte</u> ett fel.</b>Sajtadministratören kommer att få ett meddelande att en ändring gjorts i databasen och att du raderat arkivet.<br /><br />Administratören kan acceptera eller avslå din ändring. Endast efter att administratören har accepterat din ändring kommer radering verklingen att genomföras <u>oåterkalleligt</u>. Om det finns några frågor om raderingen så kommer administratören att kontakta dig.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />När du klickar på denna länk kommer informationen om arkivet, som den är sparad i databasen, att visas i ett popfönster.<br /><br />";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />När du klickar på denna länk kan du lägga till arkivet, som det är sparat i GEDCOM-filen, till din #pgv_lang[clip_cart]#.<br /><br />";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />I denna box ser du namnen på de arkiv som de är sparade i databasen.<br /><br />Namnen visas i alfabetisk ordning.<br /><br />När du klickar på ett namn i listan kommer du till  #pgv_lang[repo_info]#-sidan där du kommer att se en lista över de källor som är länkade till detta arkiv.<br /><br />";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />I denna box kan du se namnet på källor som är länkade till arkivet.<br /><br />Namnen visas i alfabetisk ordning.<br /><br />När du klickar på ett namn i listan, du kommer att flyttas till detaljsidan för källan.<br /><br />";
$pgv_lang["block_move_up_help"]		= "~Flytta listposter~<br /><br />Använd denna knapp för att ändra ordningen för posterna i listan. Områdena kommer att skrivas ut i den ordning som de visas.<br /><br />Markera posten som ska flyttas och klicka sedan på kanppen för att flytta posten upp eller ner.<br /><br />";
$pgv_lang["block_move_right_help"]	= "~Flytta listposter~<br /><br />Använd dessa knappar för att flytta en post från en lista till en annan.<br /><br />Markera posten som ska flyttas, klicka sedan på en knapp för att flytta eller kopiera posten i pilens riktning. Använd <b>&raquo;</b> och <b>&laquo;</b> knapparna för att flytta den markerade posten från längst ut till vänster till den längst ut till höger eller tvärtom. Använd <b>></b> och <b><</b> knapparna för att flytta den markerade posten mellan #pgv_lang[available_blocks]#-listan och listan till höger eller vänster om den.<br /><br />Posterna i #pgv_lang[available_blocks]#-listan ändras inte, oavsett vad du gör med #pgv_lang[move_right]# och #pgv_lang[move_left]#-knapparna. Detta är för att samma område kan förekomma på flera ställen på samma sida. HTML-området är ett bra exempel på varför du skulle vilja ha samma område på flera ställen.<br /><br />";
$pgv_lang["block_default_index"]	= "~Standardområdena på #pgv_lang[welcome]#-sidan~<br /><br />När du tar bort all poster från #pgv_lang[main_section]# och #pgv_lang[right_section]# listorna, eller när du klickar på <b>#pgv_lang[reset_default_blocks]#</b>-knappen, kommer områdena att listas enligt följande:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span><br />";
$pgv_lang["block_default_portal"]	= "~Standard områden på #pgv_lang[mygedview]#-sidan~<br /><br />När du tar bort alla poster från #pgv_lang[main_section]# och #pgv_lang[right_section]# listorna, eller när du klickar på <b>#pgv_lang[reset_default_blocks]#</b>-knappen, kommer områdeslistan att sättas som följer:<br /><br /><span class='center'><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></span><br />";
$pgv_lang["help_faq.php"] 			= "~Vanliga frågor (FAQ)~<br />#pgv_lang[text_faq_help]#<br />";
$pgv_lang["text_faq_help"] 			= "FAQ-sidan (vanliga frågor) kan innehålla en översikt eller en lista på frågor och svar om användningen av denna släktforskningsajt.<br /><br />Användningen av FAQ-sidan är upp till sajtens administratör. Sajtadministratören kontrollerar innehåll och ordningen som objekten visas på sidan. ";
$pgv_lang["hs_title_help"] 			= "<span class='center'>~#pgv_lang[hs_title]#~</span><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
$pgv_lang["hs_intro"]				= "Du kan söka i PhpGedViews hjälpsystem. #pgv_lang[hs_title]# funktionen ger dig en hög grad av kontroll över hur sökfunktionen fungerar, du bör kunna hitta vad du letar efter enkelt.";
$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br />Du skriver in det ord eller fras du vill hitta.<br /><br />Sökningen tar inte hänsyn till stora eller små bokstäver i sökuttrycket. Det betyder att om du söker efter <b>Person</b> kommer du att hitta text som innehåller <b>Person</b>, <b>person</b> eller <b>PERSON</b>. Du kommer också att hitta texter som innehåller <b>Personer</b> etc, eftersom sökningen letar efter sekvenser av bokstäver inte ord.<br /><br />Du kan låta sökningen leta efter flera ord samtidigt. Skriv in alla ord, separera dem med mellanslag, så här: <b>person&nbsp;familj&nbsp;barn</b>. När mer än ett ord skrivs in är meningen med vad du skrivit in förtydligat i #pgv_lang[hs_searchhow]# fältet.<br />";
$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />Du bestämmer vad sökningen ska söka i här.<br /><br />Administratörer har möjlighet att söka i användarhjälpen, konfigurationshjälpen eller båda. Användare har inte detta val eftersom de inte har tillgång till konfigurationsinställningarna, de kan bara söka i användarhjälpen.<br /><br />Hjälpfilen innehåller inte bara hjälptext utan också visa textsträngar som används för att bygga fomulär och andra material. Detta val låter dig bestäma om hela hjälpfilen ska genomsökas eller endast hjälptexterna.<br />";
$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br />Du förtydligar vad du skrivit in i #pgv_lang[hs_keyword]#-fältet genom att välja ett av möjlighterna som presenteras här.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>Om du har valt <b>person&nbsp;familj&nbsp;barn</b>, kommer detta val att hitta hjälptext som innehåller orden listade. Ordningen på orden spelar ingen roll. Betydelsen av sökningen är: Hitta \"hjälptext som innehåller <b>Person</b> <u>eller</u> <b>familj</b> <u>eller</u> <b>barn</b>\".</dd><br /><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>Om du har valt <b>person&nbsp;familj&nbsp;barn</b>, kommer detta val att hitta hjälptext som innehåller alla orden listade. Ordningen på orden spelar ingen roll. Betydelsen av sökningen är: Hitta \"hjälptext som innehåller <b>Person</b> <u>och</u> <b>familj</b> <u>och</u> <b>barn</b>\".</dd><br /><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>Om du har valt <b>person&nbsp;familj&nbsp;barn</b>, kommer detta val att hitta hjälptext som innehåller alla orden listade i den specifika ordningen de är inskrivna i. Betydelsen av sökningen är: Hitta \"hjälptext som innehåller <b>person&nbsp;familj&nbsp;barn</b> i exakt denna ordning utan boktäver eller ord imellan\". Du kommer antagligen inte hitta exakt denna mening i någon hjälptext.<br /><br />Det finns några begränsningar för denna typ av sökning. Vissa specialtecken som <b>&quot; < ></b> etc. finns i hjälptexten i symbolisk form och kommer inte hittas om de är en del av söktexten. Vissa hjälptexter innehåller en speciell sorts mellanslag representerad av <b>&nbsp;</b> och du kommer inte hitta fraser som innehåller detta tecken.</dd></dl>";
$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />Detta verktyg kan hjälpa sajtadministratörer rensa ut filer från indexmappen.<br /><br />Efterhand kommer filer som logfiler, gamla GEDCOM-filer och gamla backupfiler att samlas i indexmappen. Eftersom många av dessa filer skapas av programmet kan de ägas av en webserveranvändare. Om de ägs av en webserveranvändare är det inte säkert att du kan radera dem. Detta verktyg låter dig radera dessa filer även om de ägs av webserveranvändare.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";

$pgv_lang["edituser_user_default_tab_help"]	= "~STANDARDFLIKINSTÄLLNING FÖR ANVÄNDARE~<br /><br />Denna inställning tillåter dig att specifera vilken flik som är standard när du tittar på ansedeln för en individ.";
$pgv_lang["reorder_children_help"]	= "~ÄNDRA ORDNINGEN PÅ BARNEN~<br /><br />Barnen visas i den ordning de finns i familjeposten. Barnen är inte sorterade efter födelsedag eftersom det oftast saknas födelsedatum för vissa av barnen men ordningen för deras födsel <u>är</u> ofta känd.<br /><br />Det val ger dig möjlighet att ändra ordningen på barnen i familjeposten i GEDCOM-filen. Eftersom du troligen vill sortera barnen efter deras födelsedatum så finns det en knapp som gör detta automatiskt åt dig.<br /><br />";
$pgv_lang["rss_feed_help"]	= "~RSS MATNINGSINSTÄLLNINGAR~<br /><br />RSS-matningen som är tillgänglig i PhpGedView tillåter dig att visa huvudinnehållet på din välkomstsida ifrån din favorit RSS-matare utan att besöka sidan. De flesta matare skickar upp ett medelande och berättar när något har ändrats på indexsidan. Detta låter dig monitorera en PhpGedView-sajt utan att behöva besöka den regelbundet. Med RSS-matarområdet kontrollerar du länken till mataren, tillåter specifika typer (de flesta läsare kan hantera de flesta typer så detta kan oftast lämnas med standard intällning) och den specifika modul du vill ha i din matning. Språket i matningen kommer att baseras på det aktiva språket i PhpGedView när du väljer mataren. Typerna av matning som kan generaras inludera RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML och JavaScript. De första 4 typerna är matare, medan JavaScript och HTML är gjorda för inkludering på egna websida.<br /><br />Observera att de olika versionsnumrena för RSS matningen indikerar olika stilar, inte olika versioner.<br /><br />";
$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />Din GEDCOM-konfiguration tillåter upp till #GLOBALS[MEDIA_DIRECTORY_LEVELS]#-mappnivåer lägre än standardinställningen #GLOBALS[MEDIA_DIRECTORY_LEVELS]# som mediafiler normalt kan sparas i. Detta låter dig organisera dina mediafiler, och du behöver inte ha unika namn på alla filer.<br /><br />I detta fält specificerar du destinationsmappen på din server var den uppladdad filen ska sparas. Var nogrann och kontrollera små och stora bokstäver för vad du skriver eller väljer här, eftersom fil och mappnamn kan kräva att det är korrekt stavat med små och stora bokstäver.<br /><br />Om mappnamnet du skriver in här inte finns kommer det att skapas. Om du skriver in fler än det tillåtna antalet #GLOBALS[MEDIA_DIRECTORY_LEVELS]# mappnivåer tillåtna, kommer de extra nivåerna att ignoreras.<br /><br />Miniatyrbilder kommer att laddas upp eller skapas i en identisk mappstruktur som startar med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />I detta fält skriver du in platsen och namnet på filen på din lokala dator som du vill ladda upp. Du kan använda <b>Browse</b>-knappen för att söka efter den önskade filen på din lokala dator.<br /><br />Den uppladdade filen kommer att ha samma namn på servern och den kommer att ladda upp i mappen specificerad i <b>#pgv_lang[folder]#</b> fältet. Om du inte ser detta fält kan du inte ändra det, din GEDCOM-konfiguration är satt att inte tillåta några nivåer lägre än <b>#GLOBALS[MEDIA_DIRECTORY]#</b> där uppladdade mediafiler normalt sparas.<br /><br />Du kan lämna detta fält blankt om du vill ladda upp endast en miniatyrbild och vill att den filen också ska användas som huvudbild.<br /><br />";
$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />I detta fält skriver du in platsen och namnet på miniatyrfilen på din lokala dator som du vill ladda upp. Du kan använda <b>Browse</b>-knappen för att söka efter den önskade filen på din lokala dator. När detta fält är ifyllt kommer <b>#pgv_lang[auto_thumbnail]#</b>-kryssrutan att ignoreras.<br /><br />Om fältet <b>#pgv_lang[media_file]#</b> är ifyllt kommer din uppladdade miniatyrfil att namnges efter det som står i fältet utan hänsyn till vad filen heter på din lokala dator. Om fältet lämnas tomt kommer den uppladdade filen att kopieras till två ställen på servern, en kopia till servermappen nämnd in <b>#pgv_lang[folder]#</b>-fältet och sedan en kopia till den identiska mappstrukturen som startar med <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />Om du inte ser <b>#pgv_lang[folder]#</b>-fältet ellre inte kan ändra det, din GEDCOM-konfiguration är satt att inte tillåta några nivåer lägre än <b>#GLOBALS[MEDIA_DIRECTORY]#</b> där uppladdade mediafiler normalt sparas.<br /><br />";
$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />#factarray[TYPE]#-fältet tillåter dig att specificera en specialhändelse. Det är ett fritt fält där du kan skriva in vad du vill spara.<br /><br />";
$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]#~<br /><br />För LDS förordning, detta fält anger vilket tempel förordningen utfördes vid.<br /><br />";
$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#~<br /><br />Detta är ett valfritt statusfält och används oftast till LDS förordningar när de körs igenom TempleReady programmet.<br /><br />";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Använd detta fält för att visa att detta mediaartikel är det markerade eller primära artikeln för personen den tillhör. Den primära bilden är den som kommer att användas i tavlor och på ansedeln.<br /><br />";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Detta är ett specialfält i PGV som tillåter dig specificera en bild som ska användas i tavlorna även om det inte finns någon minatyrbild för den markerade bilden.<br /><br />";
$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#~<br /><br />Skriv in en titel för objektet du jobbar med. Om det är en titel för ett multimediaobjekt, skriv då in en beskrivande titel som identifierar objektet för användaren.<br /><br /> ";
$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#~<br /><br />Detta är det viktigaste fältet i multimediaobjektposten. Det berättar vilken fil som ska användas. Du måste minst ange filnamnet. Mer information om filens placering kan vara bra beroende på dina inställningar.<br /><br />Du kan använda #pgv_lang[find_media]#-länken för att hitta platsen för mediaobjektet som redan finns uppladdad till sajten.<br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#~<br /><br />Detta är ett frivilligt fält som kan användas för att ange filformatet för ett multimediaobjekt. Vissa släktforskningsprogram kan tänkas titta på detta fält för att avgöra hur man ska hantera mediaobjektet. Men eftersom media inte överförs speciellt bra mellan olika datorsystem så är fältet inte speciellt viktigt.<br /><br />";
$pgv_lang["generate_thumb_help"]		= "~GENERERA MINIATYRBILDER HJÄLP~<br /><br />Vi har upptäckt att ditt system har möjlighet att automatiskt kunna generera miniatyrbilder för vissa typer av bilder. PHP kan ha support för JPG, GIF och PNG bilder. Typerna som dit system stödjer listas i kryssrutorna.<br /><br />Genom att klicka på denna kryssruta så visar du systemet att du laddar upp en bild och att du vill att det ska genereras en miniatyrbild automatiskt för dem. Låt bli att kryssa rutam om du själv vill göra miniatyrbilder.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Denna sektion låter dig lägga till en ny anteckning till faktan du för tillfället redigerar. Anteckningar är ett fritt textfält och kommer att visas i faktadetaljsektionen för sidan.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Denna sektion göra att du kan lägga till nya källcitat till den fakta som du för närvarande redigerar.<br /><br />I källfältet skriver du in ID för källan. Klicka på <b>#pgv_lang[create_source]#</b>-länken om du behöver lägga till en nya källa. I citatdetaljfältet skriver du in sidnummer eller annan information som hjälper till att hitta informationen i källan igen. I textfältet skriver du av källans text.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# gör att du kan länka fakta med en associerad person på denna sajt. Detta är ett sätt att registrera att någon var faddrar till någon.<br /><br />";
$pgv_lang["edit_QUAY_help"]		= "~#factarray[QUAY]#~<br /><br />Du använder detta fält för att ange kvaliten eller tillförlitligheten för datan som finns i denna källa. Många släktforskningsprogram använder en siffra i detta fält. <b>1</b> kan betyda att källan är primär. <b>2</b> kan betyda att det är en sekundär källa. <b>3</b> kan betyda att informationen är otillförlitlig.<br /><br />";
$pgv_lang["edit_PAGE_help"]		= "~#factarray[PAGE]#~<br /><br />I källcitatfältet bör du skriva in sidnummret eller annan information som kan hjälpa för att hitta informationen i källan.<br /><br />";
$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#~<br /><br />I detta fältet ska du skriva in citattexten från källan. Exempel på datan kan vara avskrifter av texten i källan eller en beskrivning av som stod i citatet.<br /><br />";
$pgv_lang["edit_SOUR_help"]		= "~#factarray[SOUR]#~<br /><br />Detta fält låter dig ändra källposten som den fakta källcitat länkar till. Detta fält tar ett källID. Sidan om fältet listan titeln av det nuvarande källIDt. Använd <b>#pgv_lang[find_id]#</b>-länken för att hitta källID-nummret. För att tabort hela citatet ska du inte skriva in något id alls.<br /><br />";
$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Denna sida tillåter dig att redigera den råa GEDCOM-posten. Du bör använda denna sida men försiktighet, det kräver en bra förståelse för GEDCOM 5.5.1 standarden. För mer information om GEDCOM 5.5.1 standarden, läs hjälpen om <b>GEDCOM-fil</b>.<br /><br />PhpGedView erbjuder många sätta att lägga till och redigera information, men det kan finnas tillfällen när du behöver redigera GEDCOM-strukturen. När det är möjligt b??r du använda de formulär som finns för att lägga till information, men när det är omöjligt kan du använda detta formulär. När du skickar formuläret kommer din information att kontrolleras mot standarden och CHAN posten kommer att uppdateras.<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView tillåter dig att kopiera fakta till urklippskorgen. Du kan kopiera upp till 5 fakta och spara dem i urklippskorgen. Från \"Lägg till ny fakta\" rullgardinsmenyn kan du välja att klistra in en av faktan ifrpn urklippskorgen in till personposten. Detta är väldigt praktiskt när man lägger till likartade fakta, t.ex. födelseplatser för många persener.<br /><br />";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Orter bör skrivas enligt genealogisk standard. I genealogi är orter sparade med mest specifika information om orten först och sedan arbeta uppåt till den minst specifika informationen sist, nivåer separerade med kommatecken. Nivåerna som du sparar ortsinformationen bör representera de statliga eller kyrkliga nivåerna där de viktiga arkiven för orterna plats. Orter registreras normalt med gård,socken,län,land i sverige. Man kan även tänka sig att man byter ut län mot landskap. Om man inte vet någon av nivåerna bör man lämna den nivån tom t.ex gård, ,län,land om man inte vet vilket socken som personen kom ifrån. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att hjälp att hitta platser som redan finns i databasen.<br /><br />";
$pgv_lang["edit_add_parent_help"]	= "~LÄGG TILL MOR ELLER FAR~<br /><br />På denna sida kan du lägga till en mor eller far till den valda personen. Fyll i den nya personens namn och födelse och dödsdatum om de är kända. Om du inte känner till någon av informationen, lämna fältet tomt.<br /><br />För att lägga till fler fakta förutom födelse och dödsdatum, lägg först till personen till databasen genom att spara ändringarna. Klicka därefter på personens namn på den uppdaterade familje sidan eller #pgv_lang[relatives]#-fliken för att visa personens  #pgv_lang[indi_info]# sida. Från  #pgv_lang[indi_info]# sidan kan du lägga till mer detaljerad information.<br /><br />";
$pgv_lang["edit_add_spouse_help"]	= "~LÄGG TILL MAKE ELLER MAKA~<br /><br />På denna sida kan du lägga till en make eller maka till den valda personen. Fyll i den nya personens namn och födelse och dödsdatum om de är kända. Om du inte känner till någon av informationen, lämna fältet tomt.<br /><br />För att lägga till fler fakta förutom födelse och dödsdatum, lägg först till personen till databasen genom att spara ändringarna. Klicka därefter på personens namn på den uppdaterade familje sidan eller #pgv_lang[relatives]#-fliken för att visa personens  #pgv_lang[indi_info]# sida. Från  #pgv_lang[indi_info]# sidan kan du lägga till mer detaljerad information.<br /><br />";
$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />Detta fält tillåter att du skriver in dödsinformation. Skriv först in datum när personen dog i genealogiskt standardformat(1 JAN 2004). Du kan klicka på kalenderikonen för hjälp med att välja datum. Skriv sedan in platsen var personen dog. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att hitta platser som redan finns i databasen.<br /><br />";
$pgv_lang["edit_birth_help"] = "~#pgv_lang[birth]#~<br /><br />Detta fält tillåter att du skriver in födelseinformation. Skriv först in datum när personen föddes i genealogiskt standardformat(1 JAN 2004). Du kan klicka på kalenderikonen för hjälp med att välja datum. Skriv sedan in platsen var personen dog. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att hitta platser som redan finns i databasen.<br /><br />";
$pgv_lang["edit_sex_help"]	= "~#pgv_lang[sex]#~<br /><br />Välj det korrekta könet från rullgardinsmenyn. <b>Okänt</b>-valet visar på att könet inte är känt.<br /><br />";
$pgv_lang["edit_name_help"]	= "~#pgv_lang[name]#~<br /><br />Detta är det viktigaste fältet i personen namnpost. Detta fält ska fyllas i automatiskt medan de andra fälten fylls i, men visas så att du kan redigera inforamtionen enligt dina egna önskemål. Namnet i fältet ska skrivas in enligt GEDCOM 5.5.1 standarden med snedsträck \"/\" före och efter efternamnet. Som ett exempel ska namnet \"John Robert Finlay Jr.\" ska skrivas in som: \"John Robert /Finlay/ Jr.\".<br /><br /><br />";
$pgv_lang["edit_suffix_help"]	= "~#pgv_lang[suffix]#~<br /><br />I detta valfria fält ska du skriva in namnsuffix för personen. Exempel på namnsuffix är \"Sr.\", \"Jr.\" och \"III\".<br /><br />";
$pgv_lang["edit_surname_help"]	= "~#pgv_lang[surname]#~<br /><br />I detta fältet ska du skriva in personens efternamn. Som ett exempel ska namnet \"John Robert Finlay\" ska efternamnet \"Finlay skrivas in här.<br /><br />";
$pgv_lang["edit_NICK_help"]	= "~#factarray[NICK]#~<br /><br />I detta fältet ska du skriva in alla smeknamn för personen.<br />Detta är ett vafritt fält.<br /><br />Olika sätt att lägga till smeknamn är::<ul><li>Välj <b>Ändra namn</b> skriv in smeknamn och spara sedan</li><li>Välj <b>Lägg till nytt namn</b> Skriv in smeknamn OCH namn spara sedan</li><li>Välj <b>redigera GEDCOM-post</b> för att lägga till multipla [2&nbsp;NICK]-poster under huvudposten [1&nbsp;NAME].</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />I detta fält ska personens förnamn skrivas in. Som exempel ska \"John Robert Finlay\"s förnamn skrivas in som \"John Robert\"<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NAME]# #factarray[NPFX]# HJÄLP~<br /><br />Detta fält tillåter dig att skriva in ett namnprefix som \"Dr.\". Detta fält är frivilligt.<br /><br />";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />På denna sida kan du lägga till barn för den valda familjen. Fyll i barnets namn och födelse och dödsdatum om de är kända. Om du inte känner till någon av informationen, lämna fältet tomt.<br /><br />För att lägga till fler fakta förutom födelse och dödsdatum, lägg först till barnet till databasen genom att spara ändringarna. Klicka därefter på personens namn på den uppdaterade familjesidan eller #pgv_lang[relatives]#-fliken för att visa personens  #pgv_lang[indi_info]# sida. Från  #pgv_lang[indi_info]# sidan kan du lägga till mer detaljerad information.<br /><br />";
$pgv_lang["review_changes_help"]	= "~EJ ACCEPTERADE ÄNDRINGAR~<br /><br />Detta område listar alla poster som har ändrats online och som behöver kontrolleras och accepteras för att komma in i databasen.";
$pgv_lang["quick_update_name_help"] = "~UPPDATERA NAMN~<br /><br />Använd \"Uppdatera namn\"-fältet för att ändra namn på den person du redigerar. I förnamnsfältet dkriver du in personens förnamn. I Efternamnsfältet skriver du in efternamnet. T.ex. om namnet du vill skriva in är \"John Robert Finlay\" Du skriver du in \"John Robert\" i förnamnsfältet och \"Finlay\" i efternamnsfältet.<br /><br />Om man fyller i dessa fält kommer du att <u>ändra</u> namnet för personen det kommer inte att lägga till ett nytt namn.<br /><br /><i>OBS: Du ska <u>inte</u> använda denna metod om namnet ändras pga ett nytt gifte. Använd istället valet att lägga till ny make/maka nedan.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] = "~UPPDATERA FAKTA~<br /><br />Använd \"Uppdatera fakta\"-fältet för att lägga till ny fakta eller ändra existerande fakta för personen du redigerar. Välj först en fakta från rullgardinsmenyn. Skriv sedan in datum när händelsen ägde rum på det genealogiska standardformatet(1 JAN 2004). Du kan klicka på kalenderikonen för hjälp att välja datum. Skriv sedan i orten där händelsen inträffade. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att välja platser som redan finns i databasen.<br /><br />Som med de andra fälten in detta formuläret kommer informationen antingen ersätta den gammla eller skapa ny om det behövs.<br /><br />";
$pgv_lang["quick_update_photo_help"] = "~UPPDATERA FOTO~<br /><br />Använd \"Uppdatera foto\"-fältet för att ladda upp ett bild på den person som du redigerar. I titelfältet skriver du en beskrivande titel till bilden, t.ex. \"John Finlay 2004\". Klicak sedan på <b>öppna</b>-knappen för att söka efter bilden på din dator. Om personen har redan har ett kort kommer en kryssruta att låta dig välja om bilden ska ersätta det gammla eller lägga till det.<br /><br />";
$pgv_lang["quick_update_address_help"] = "~UPPDATERA ADRESS~<br /><br />Använd \"Uppdatera adress\"-fältet för att ändra adress, telefonnummer eller epostadress för personen du redigera.<br /><br />Som med alla andra fält i detta formuläret kommer din information att ersätta den gammla eller skapa ny om det behövs.<br /><br />";
$pgv_lang["quick_update_spouse_help"] = "~LÄGG TILL MAKE ELLER MAKA~<br /><br />På denna sida kan du lägga till en mor eller far till den personen du redigerar. Fyll i den nya personens namn och födelsedatum och skriv sedan datum för vigseln under vigselinformation. Skriv in datum på det genealogiska standardformatet(1 JAN 2004). Du kan klicka på kalenderikonen för hjälp att välja datum. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att välja platser som redan finns i databasen.<br /><br />Dessa fälten kommer bara att lägga till en <i>ny</i> partner, de kommer inte att uppdatera informationen för en gammal. För att redigera informationen för någon som redan finns sparad, stäng detta fönster och klicka på personens namn på #pgv_lang[relatives]#-fliken. Klicka sedan på redigera personmenyn för att redigera informationen.<br /><br />";
$pgv_lang["quick_update_marriage_help"] = "~UPPDATERA VIGSEL~<br /><br />Du kan använda detta fält tillsammans med fälten för att lägga till ny make/maka om du vill spara en ny vigsel. Annars kommer detta fält att ändra informationen i personens senaste vigsel. Skriv in datum på det genealogiska standardformatet(1 JAN 2004). Du kan klicka på kalenderikonen för hjälp att välja datum. Skriv sedan i orten för vigseln. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att välja platser som redan finns i databasen.<br /><br />";
$pgv_lang["quick_update_child_help"] = "~LÄGG TILL ETT NYTT BARN<br /><br />Använd dessa fält för att lägga till ett nytt barn till personen. Skriv först in barnets namn och välj kön. Skriv sedan in datum och plats var barnet är fött. Skriv in datum på det genealogiska standardformatet(1 JAN 2004). Du kan klicka på kalenderikonen för hjälp att välja datum. Du kan använda <b>#pgv_lang[find_place]#</b>-länken för att välja platser som redan finns i databasen.<br /><br />Dessa fälten kommer bara att lägga till en <i>nytt</i> barn, de kommer inte att uppdatera informationen för barn som redan är inskrivna. För att redigera informationen för någon som redan finns sparad, stäng detta fönster och klicka på personens namn på #pgv_lang[relatives]#-fliken. Klicka sedan på redigera personmenyn för att redigera informationen.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]		= "~MEST BESÖKTA ARTIKLAROMRÅDET~<br /><br />Detta block kommer att lista de top 10 mest besökta personer, familjer eller källor av besökare på sajten. För att detta område ska visas måste sjatadministratören sätta på träffräknaren.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~STANDARD ANVÄNDARFLIKINSTÄLLNING~<br /><br />Denna inställning gör att du kan specificera vilken flik son öppnas automatiskt när du kommer till #pgv_lang[indi_info]# sidan. Om användarna tillåts att redigera sina kontoinställningar kan han ändra denna inställning senare.";
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Timglastavlan visar både anorna och ättlingarna för den valda rotpersonen i samma tavla. Denna tavla är en sorts mix mellan en antavla och en stamtavla.<br /><br />Rotpersonen är centrerad i mitten på sidan med ättlingar till vänster och anor till höger. I denna vyn är varje generation uppställd så att den startar med den tidigaste generationer och slutar med den senaste.<br /><br />Om där finns en neråtpil på skärmen under rotpersonen, klicka på den och en lista med rotpersonens nära familjemedlemmar som du kan använda för att navigera nedför tavlan. Väljer man ett namn kommer man att ladda om tavlan med den valda personen som rotperson.";
$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />Denna tavla är väldigt likt timglastavlan. Den kommer att visa anorna och ättlingarna till den valda startpersonen i samma tavla. Den kommer också att visa ättlingarna till startpersonen i samma timglasstil.<br /><br />Startpersonen är centrerad i mitten på sidan med sina ättlingar till vänster och anorna till höger. I denna vy är varje generation uppradad över sidan med den äldsta generationen först och den yngsta sist.<br /><br />Varje ättling till startpersonen kommer att bli startperson för en ny timglasstavla, utskrivet på samma sida. Denna process upprepas till det angivna antalet generationer har skrivits ut.";
$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />Detta valet bestämmer hur många generationer ättlingar till startpersonen som kommer att skrivas ut i timglastavlan.<br /><br />";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Som standard visar inte denna tavla make/maka för ättlingar eftersom det gör tavlan svårar att läsa och förstå. Om man sätter på detta val så visas make/maka i tavlan.<br /><br />";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_familes}#~<br /><br />Familjer på #pgv_lang[relatives]#-fliken visas i den ordningen som de finns i personens GEDCOM-post. Många människor frågar sig varför familjerna inte är sorterade efter vigseldatum. Detta beror på att man ofta inte vet vigseldatumet men ofta <u>vet</u> man ordningen för vigslarna.<br /><br />Detta val tillåter att man ändrar ordning på familjerna som de visas på #pgv_lang[relatives]#-fliken. Eftersom du ofta vill sortera familjer efter vigseldatum så finns det en knapp som gör det automatiskt.<br /><br />";
$pgv_lang["import_marr_names_help"]		= "~#pgv_lang[import_marr_names]#~<br /><br />Om du väljer att importera vigdas namn kommer PhpGedView att söka igenom alla kvinnor i din GEDCOM-fil och automatiskt skapa ett vigselnamn underpost för dem i deras GEDCOM-post. Detta kommer att göra att man kan söka efter detta kvinnor via deras vigselnamn eller deras ogiftanamn.<br /><br />Detta val kommer också att ge dig möjligheten att visa vigselnamn i personlistan om du sätter på <b>#pgv_lang[SHOW_MARRIED_NAMES]#</b>-valet i GEDCOM-konfigurationsinställningar.<br /><br />";
$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Efternamnet du har valt innehåller fler än #GLOBALS[SUBLIST_TRIGGER_I]# presoner.<br /><br />För att hjälpa dig hitta personen du söker har listan blivit uppbruten i mindre listor efter första bokstaven i personens förnamn. Det alfabetiska under-indexet fungerar på samma sätt som för efternamn.<br /><ul><li>Klicka på en bokstav för att se alla förnamn som börjar med denna bokstav.</li><li>Välj <b>#pgv_lang[NN]#</b> för att lista personer med okänt förnamn.</li><li>Välj <b>#pgv_lang[all]#</b> kommer att visa alla personer med det föregående valda efternamnet.</li></ul>Eftersom det finns många namn kan det ta lång tid för listan att visa på skärmen.<br /><br /><br />";
$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />Efternamnet du har valt innehåller fler än #GLOBALS[SUBLIST_TRIGGER_F]# presoner.<br /><br />För att hjälpa dig hitta familjen du söker har listan blivit uppbruten i mindre listor efter första bokstaven i personens förnamn. Det alfabetiska under-indexet fungerar på samma sätt som för efternamn.<br /><ul><li>Klicka på en bokstav för att se alla förnamn som börjar med denna bokstav.</li><li>Välj <b>#pgv_lang[NN]#</b> för att lista personer med okänt förnamn.</li><li>Välj <b>#pgv_lang[all]#</b> kommer att visa alla personer med det föregående valda efternamnet.</li></ul>Eftersom det finns många namn kan det ta lång tid för listan att visa på skärmen.<br /><br />";
$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Alla personer i databasen har ett unikt idnummer på denna sajt. Om du vet ditt idnummer för dig själv, skriv in det här. Om du inte vet ditt idnummer, eller kan inte hitta det beroende på intgritetsinställningar, så var vänlig att ange tillräckligt med infromation i kommentarfältet för att hjälpa administratören att veta vilken person du är på sajten så att de kan sätta idt för dig.";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Använd detta fält för att berätta för administratören varför du begär ett konto och hur ditt släktförhållande är till de på sajten. Du kan också använda detta fält att skriva in andra kommentarer du har till sajtadministratören.";
$pgv_lang["utf8_ansi_help"]		= "~KONVERTERA IFRÅN UTF-8 TILL ANSI~<br /><br />För att få bästa möjliga visning på internet använder PhpGedView UTF-8 teckenuppsättning. Vissa program som Family Tree Maker stödjer inte import av GEDCOM-filer kodad i UTF-8. Kryssa i denna ruta så konverteras filen från <b>UTF-8</b> till <b>ANSI (ISO-8859-1)</b>.<br />Vilket format du behöver beror på vilket program du ska använda när du laddat ner GEDCOM-filen.<br />Kontrollera dokumentationen för programmet om du inte är säker.<br /><br />Observera att för att speciella tecken ska förbli oförändrade, måste du ladda ner den i UTF-8. Om du behöver konvertera till något annat format som ANSEL, måste du använda ett annat program.";
$pgv_lang["remove_tags_help"]	= "~TABORT SPECIAL PGV TAGGAR~<br /><br />Kryssa i detta val så tas alla PGV specialtaggar bort som har blivit tillagda till posterna.<br /><br />Speciella taggar som används av PhpGedView är _PGVU taggen som visar vilken PGV användare som ändrat poster online och _THUM taggen vilket visar PGV vilken bild som ska användas som miniatyrbild.<br /><br />Specialtaggar kan orsaka fel när man importera den nerladdaded GEDCOM-filen till andra släktforskningsprogram.";
$pgv_lang["download_zipped_help"]	= "~LADDA NER GEDCOM-FIL SOM ZIP-FIL~<br /><br />När du väljer denna inställning kommer en kopia av GEDCOM-filen komprimeras till en ZIP-fil innan nerladdningen börjar. Detta kommer att minska filstorleken väsentligt, men du behöver ett kompatibelt upppackningsprogram (WinZip, t.ex.) för att packa upp den nerladdade GEDCOM-filen innan du kan använda den.<br /><br />Detta är ett användbart alternativ för nerladdning av stora GEDCOM-filer. Det finns en risk att nerladdningen av en opackad fil kan överskrida den maximala exekverningstiden, vilket resulterar i ej kompletta filer. Valet av ZIP-packade filer bör minska nerladdningstiden med ca 75%.<br /><br />";
$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]# HJÄLP~<br /><br />Skriv in antal barn för denna person eller familj. Detta är ett frivilligt fält.<br /><br />";
$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]# HJÄLP~<br /><br />Skriv in tid för denna händelse. Giltigt format är HH:MM. Exempel: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]# HJÄLP~<br /><br />Anteckningar är ett fritt text fält och kommer att visas i faktadetalj delen av sidan.<br /><br />";
$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]# HJÄLP~<br /><br />Skriv in namnet på kyrkogården eller annan viloplats där personen är begravd.<br /><br />";
$pgv_lang["edit_ASSO_help"]		= "~#factarray[ASSO]# HJÄLP~<br /><br />Skriv in tillhörande GEDCOM-id.<br /><br />";
$pgv_lang["edit_RELA_help"]		= "~#factarray[RELA]# HJÄLP~<br /><br />Välj ett släktförhållandenamn i listan. Väljer man <b>gudfader</b> betyder detta: <i>den valda är gudfader till den nuvarande personen.</i><br /><br />";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Använd detta formulär för att lägga till en olänkad person.<br /><br />När du lägger till en olänkad person till ditt släktträd, personen kommer inte att länkas med någon annan i trädet förrän du länkar ihop dem. Du kan senare länka ihop personer ifrån #pgv_lang[relatives]#-fliken på #pgv_lang[indi_info]#-sidan.";
$pgv_lang["edit_URL_help"]			= "Skriv in URL adressen inkludera http://.<br /><br />Ett exempel URL ser ut så här: <b>http://www.phpgedview.net/</b> Lämna detta fält tomt om du inte vill inkludera en URL.";
$pgv_lang["edit_EMAIL_help"]		= "Skriv in epostadressen.<br /><br />Ett exempel på epostadress ser ut så här: <b>namn@hotmail.com</b> Lämna detta fält tomt om du inte vill inkludera en epostadressen.";
$pgv_lang["edit_FAX_help"]			= "Skriv in faxnumret inkludera lands och riktnummer.<br /><br />Lämna detta fält tomt om du inte vill ange något faxnummer. T.ex. ett nummer i Tyskland kan vara +49 25859 56 76 89 och ett nummer i USA eller Kanada +1 888 555-1212.";
$pgv_lang["edit_PHON_help"]			= "Skriv in ett telefonnummer inkludera lands och riktnummer.<br /><br />Lämna detta fält tomt om du inte vill inkludera ett telefonnummer. T.ex. ett nummer i tyskland kan vara +49 25859 56 76 89 och ett nummer i USA eller Kanada +1 888 555-1212.";
$pgv_lang["edit_ADDR_help"]			= "Skriv in adressen i detta fält precis som du skulle göra på ett kuvert.<br /><br />Lämna detta fält tomt om du inte vill inkludera en adress.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~Efternamnsprefix~<br /><br />Skriv in eller välj från listan ordet som ska föregå huvuddelen av efternamnet. Exempel på sådana ord är <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, etc.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Skriv in vigselnamnet för personen, använd samma formatteringsregler som gäller för namnfältet. Detta fält är valfritt.<br /><br />T.ex. om Mary Jane Brown gifter sig med John White, kan du skriva in (utan citationstecken tecken, så klart)<ul><li>Amerikansk användning:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>Europeisk användning:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Alternativ Europeisk användning:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" eller \"Mary Jane /Brown-White/\"</li></ul>Du ska göra detta endast om Mary Brown börjar använda det nya namnet efter att ha gift sig med John White. På vissa platser t.ex. Quebec(Kananda) är det olagligt att byta namn på detta sätt.<br /><br />Män byter ibland namn efter att ha gift sig, oftast används då dubbelnamnsformen men ibland så byter män namn till Makans efternamn.";
$pgv_lang["context_help"]			= "Mer hjälp finns tillgänglig genom att klicka på <b>?</b> intill artiklarna på sidorna.";
$pgv_lang["edit_ROMN_help"]			= "~ROMANISERADE NAMN~<br /><br />I många kulturer är det vanligt att ha ett traditionellt namn stavat med traditionella bokstäver och också en romaniserad version av namnet som det skulle stavas i ett romanskt språk som engelska. Om du föredrar at skriva ett traditionellt namn i det vanliga namnfältet, kan du använda detta fält för att skriva in den romaiserad versionen av samma namn. Det romaniserade namnet kommer också att visas i listor och tavlor.";
$pgv_lang["edit__HEB_help"]			= "~HEBREISKA NAMN~<br /><br />I många kulturer är det vanligt att ha ett traditionelt namn stavat med traditionella bokstäver och en romaniserad version av namnet som det skulle stavas eller uttalas i ett språk baserat på de latinska bokstäverna, som t.ex engelska.<br /><br />Om du föredrar att använda det latinska alfabetet för att ange namn i standardnamnfältet, då kan du använda detta fältet för att skriva samma namn i det icke latinska alfabetet som t.ex. grekiska, hebreiska, ryska, arabiska eller kinesiska. Båda versionen av namnet kommer att visas i listor och tavlor.<br /><br />Även om detta fält är märkt \"Hebreisk\", så är andra bokstäver tillåtna en de hebreiska. ";
$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />I detta fält skriver du in ID för personen som du länkar till (t.ex. I100).";
$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Använd denna sektion för att välja den alternativa databasidentifierare som innehåller personen som du länkar till.";
$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />I denna sektion specificerarar du parametrarna som är nödvändiga för att koppla dig till till den sajten som innehåller den data som du ska länka till. Du har valet att välja från en lista av sajter som användts tidigare eller skriv in #pgv_lang[label_site_url2]# och #pgv_lang[label_gedcom_id]#.<br /><br />In the <b>#pgv_lang[label_site_url2]#</b> fältet skriver du in URLn för att komma åt webaccessservicebeskrivningsfilen(WDSL) som berättar för phpGedView hur man kommer åt data på den andra sajten. För den andra phpGedViewsajten kommer URLn att se ut så här: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />. <b>#pgv_lang[label_gedcom_id]#</b> fältet används för att skriva in en valfri databasidentifierare för den andra sajter som kräver en sådan. För PhpGedView-sajter är detta namnet på GEDCOM-filen.<br /><br /><i>Notering: Andra PhpGedView-sajter måste använda version 4.0 eller senare, Tidigare versioner har inte den funtion.</i>";
$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />Detta val låter dig välja om datan för personen som du länkar till ligger på samma sajt men i en annan databas eller om data är på en annan sajt tillgänglig via internet.<br /><br />Om personen är på samma sajt kommer du att behöva ange databasens identifiering och personens ID.<br /><br />För en databas på an annan sajt behöver du ange URL, databasens identifiering och personens ID i den databasen.";
$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Använd detta val för att välja på vilket sätt personen på en annan sajt är relaterad till personen du länkar honom till på din sajt. T.ex. väljer du <i>Far</i> betyder det att personen på den andra sajten är fader till personen du länkar honom till lokalt.";
$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Använd detta formulär för att länka personer till andra personerantingen ifrån en annan sajt eller en annan genealogisk databas tillgänglig för din kopia av PhpGedView.<br /><br />För att lägga till en sådan länk måste du först välja relationstyp, sedan välja en sajt som redan är känd för PhpGedView eller skapa en ny sajt och sist lägga till den personens ID som du vill lägga till från den sajten. PhpGedView kommer sedan automatiskt att ladda ner den information ifrån den andra sajten som behövs. Den nerladdade informationen kommer <u>inte</u> bli en del av din genealogiska databas den kommer att finnas kvar på den urspungliga sajten men blir införlivade i de olika sidorna var denna person visas.<br /><br />Konsultera hjälplänkarna intill varje element på denna sida för att få mer information om dem. Du kan också kolla den engelska handledning fär mer information: <a href=\"http://www.phpgedview.net/pgvdocs/index.php/HowToRemoteLink\" target=\"_blank\">http://www.phpgedview.net/pgvdocs/index.php/HowToRemoteLink</a>";
$pgv_lang["edit_ABBR_help"]			= "~FÖRKORTAD TITEL~<br /><br />Använd detta fält för att spara en förkortad variant av en titel. Detta fält används i kombination med titelfältet för källor. Som standard kommer PGV att använda först titlen sedan förkortningen.<br /><br />Enligt GEDCOM 5.5 specifikationen, \"detta post är till för att tillhandahålla en kort titel som används vid sortering, insättning och hämtning av poster (pg 62).\"<br /><br />I PhpGedView är fältet valfritt, men i andra program är det ett krav att det används.";
$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Använd denna länk för att lägga till en ny källa till din databas utan att länka den till ett källsitat i en annan post. Den nya källan kommer att syans i källistan, men kommer inte att synas i några tavlor eller någon annan stans i programmet tills den är länkad till ett källcitat.";
$pgv_lang["import_options_help"] 	= "Du kan välja extra inställningsmöjlighter att avändas vid import av GEDCOM-fil";
$pgv_lang["verify_gedcom_help"]	= "Här kan du välja att antingen fortsätta eller avbryta uppladdning och import av GEDCOM-filen.";
$pgv_lang["add_gedcom_instructions"]= "Ange ett filnamn för den nya GEDCOM-filen. Den nya GEDCON-filen kommer att skapas i Indexkatalogen: #INDEX_DIRECTORY#";
$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />För att förbättra prestandan är flera av blocken på PhpGedViews välkomstsida sparade som cache-filer i indexmappen. Cache-filerna för de flesta blocken uppdateras en gång varje dag men de finns tillfälle där man vill uppdatera dem manuellt.<br /><br />Denna knapp låter dig uppdatera cache-filerna när du vill.";
$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Varje källa beskriver specifika händelser, vanligen för ett speciellt datum intervall för en orts juridiction. T.ex en folkräkning anger folkräkningshändelser och kyrkböcker anger födelse, vigsel och dödshändelser.<br /><br />Välj de händelser som är registrerade av denna källa från listan. Datumen ska anges i intervall format som <i>FRÅN 1900 TILL 1910</i>. Orten anges till den lägsta juridiska nivån för området. T.ex anges församling för kyrkböckerna och härad eller rådhusrätt för bouppteckningar eller domböcker.<br /><br />";
$pgv_lang["cache_life_help"]		= "~#pgv_lang[cache_life]#~<br /><br />För att förbättra prestandan sparas PhpGedViews välkomstområde som en cachefil. Du kan kontrollera hur ofta denna cachefil uppdateras.<br /><br /><ul><li><b>-1</b>betyder att cachefilen aldrig uppdateras automatiskt. För att få en uppdaterad cachefilen måste du radera alla cachefiler. Du kan göra detta via ändra välkomstsidan.</li><li><b>0</b>(noll)betyder att området aldrig cachas och varje gång området visas på välkomstsidan så ser du en ny kopia. Denna inställning används automatiskt för områden som ändras ofta som #pgv_lang[logged_in_users_block]# och #pgv_lang[random_media_block]# området.</li><li><b>1</b> (ett) betyder att en ny kopia skapas varje dag, <b>2</b>betyder att en ny kopia skapas varannan dag, <b>7</b> betyder att en ny kopia skapas varje vecka, osv.</li></ul><br /><br />";
$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br />Administratörer behöver ibland rensa och rätta data inskickade av användarna. T.ex. behövs kanske PLAC orten rättas för att innehålla landet. När administratörer gör sådana ändringar så ändras informationen om den ursprungliga ändringen. Detta är kanske inte önskvärt.<br /><br />När detta val är satt kommer PhpGedView att behålla den ursprungliga ändringen istället för att ersätta den med den nuvarande. När detta val är satt  har administratören också möjlighet att ändra eller radera informationen i den ursprungliga CHAN posten.<br /><br />";

?>
