<?php
/**
 * Norwegian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2017  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * # $Id: configure_help.no.php 7161 2017-08-12 18:20:51Z canajun2eh $
 *
 * @translator Geir Håkon Eikland
 * @translator Thomas Rindal
 * @package PhpGedView
 * @subpackage Languages
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

$pgv_lang["SHOW_LIST_PLACES"]	= "Stedsnivåer for å vise i lister";
$pgv_lang["SHOW_LIST_PLACES_help"]	= "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Dette valget bestemmer hvor mye stedinformasjon som vises i stedkolonnen i lister.<br /><br />Om du setter verdien til <b>9</b> sikrer du at all stedinformasjon vises.  Setter du verdien til <b>0</b> (null) skjuler du all stedinformasjon.  Verdien <b>1</b> vil vise det øverste nåvet, som normalt er landnavn.  Verdien <b>2</b> vil vise de to øverste nivåene.  Det nest øverste nivået, under land, er ofte fylke, delstat, provins osv.<br />";

$pgv_lang["new_gedcom_title"]		= "Slektsbase fra [#GEDCOMFILE#]";
$pgv_lang["keep_media_help"]		= "~#pgv_lang[keep_media]#~<br /><br />Ønsker du at eksisterende medialenker skal beholdes i databasen når en GEDCOM-fil lastes opp. Valget <b>Nei</b> fjerner eksisterende medialenker fra databasen, mens valget <b>Ja</b> beholder dem.<br /><br />Dette valget er nyttig når du eksporterer din GEDCOM-fil fra PhpGedView til et off-line slektsprogram som ikke håndterer inkluderte mediapekere skikkelig, og så senere re-importerer den endrede GEDCOM-filen inn til PhpGedView.  Under slike forhold, vil mediapekerne i GEDCOM-filen du eksporterte til ditt off-line slektsprogram bli ødelagt, og du må re-linke alle mediafilene til riktig person-, familie-, og kildeposter etter å ha re-importert GEDCOM-filen til PhpGedView.<br /><br />Valget <b>Ja</b> ber PhpGedView om å beholde de eksisterende medialenkene slik at du ikke behøver å lage dem på nytt etter å ha importert den endrede GEDCOM-filen, men dette krever at off-line slektsprogrammet alltid  lager de samme person-, familie-, og kildeidentifikasjonsnummre.<br /><br /><i>Family Tree Maker</i> er en av flere off-line slektsprogrammer som <u>ikke</u> håndterer mediapekere korrekt innenfor GEDCOM-filen.  <i>Legacy</i>, blant flere, <u>gjør</u> dette riktig.<br />";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Bruk Mediaviser";
$pgv_lang["USE_MEDIA_VIEWER_help"]		= "~#pgv_lang[USE_MEDIA_VIEWER]#~<br /><br />Når dette valget er <b>#pgv_lang[yes]#</b>, vil siden Mediaviser åpnes.  Denne siden viser detaljer om bildet.  Hvis du har tilstrekkelige rettigheter, kan du også redigere disse detaljene.<br /><br />Når dette valget er <b>#pgv_lang[no]#</b>, vil bildet vises i et nytt fullskjermsvindu når du klikker på bildet.<br />";
$pgv_lang["USE_MEDIA_FIREWALL"]			= "Bruk Mediabrannmur";
$pgv_lang["USE_MEDIA_FIREWALL_help"]	= "~#pgv_lang[USE_MEDIA_FIREWALL]#~<br /><br />Se Wikien for en beskrivelse av hvordan du kan bruke Mediabrannmuren. <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=Media_Firewall\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a><br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]			= "Rotkatalog for Mediabrannmur";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_help"]	= "~#pgv_lang[MEDIA_FIREWALL_ROOTDIR]#~<br /><br />Katalog som mappen for de beskyttede mediene kan opprettes i.  #pgv_lang[MEDIA_FIREWALL_ROOTDIR_note]#<br />";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]	= "Når dette feltet er tomt, vil katalogen <b>#GLOBALS[INDEX_DIRECTORY]#</b> bli brukt.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]			= "Beskytt miniatyrbilder av beskyttede bilder";
$pgv_lang["MEDIA_FIREWALL_THUMBS_help"]	= "~#pgv_lang[MEDIA_FIREWALL_THUMBS]#~<br /><br />Når et bilde er i den beskyttede mediakatalogen, skal det tilhørende miniatyrbildet beskyttes også?<br />";
$pgv_lang["SHOW_SPIDER_TAGLINE"]		= "Vis spider-tagline";
$pgv_lang["SHOW_SPIDER_TAGLINE_help"]		= "~#pgv_lang[SHOW_SPIDER_TAGLINE]#~<br /><br />På sider som genereres for søkemotorer, kan denne setningen vises som den siste linjen på siden denne søkemotorene oppdager.  Hvis dette alternativet er slått på, kan det påvirke Google&reg; AdSense i retning av søkemotorens optimatiseringsverktøy.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS_help"] = "~#pgv_lang[SHOW_PRIVATE_RELATIONSHIPS]#~<br /><br />Dette alternativet vil beholde familjebånd i private poster.  Dette betyr at du vil se tomme \"privat\"bokser i anetrediagrammet og på  andre diagrammer med private personer.<br /><br />Dette er samme adferd fra PhpGedView versjoner tidligere enn v4.0.<br /><br />Dette alternativet er AV som standard.  Det er anbefalt å istedenfor å slå alternativet på, å peke rotpersonen i GEDCOM-konfigurasjonen på en person som ikke er privat.<br />";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Vis private slektskap";
$pgv_lang["SYNC_GEDCOM_FILE_help"] 			= "~#pgv_lang[SYNC_GEDCOM_FILE]#~<br /><br />I tidligere versjoner av PGV ble listene av ventende endringer lagret i GEDCOM-filen og de endrede postene ble \"akseptert\" inn i databasen.  Fra og med v4.1 vil ventende endringer ikke lenger lagres i GEDCOM-filen, men i en endringsfil.  <br /><br />Hvis du setter dette alternativet til ja vil du oppdatere GEDCOM-filen når endringene er akseptert i databasen. Dette vil holde GEDCOM-filen synkronisert med databasen.  For bedre kompatibilitet med tidligere versjoner vil standardverdien på dette feltet være ja.<br /><br />Du kan slå det av for å spare minne når du aksepterer endringer.<br />";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Synkroniser endringer til GEDCOM-filen";
$pgv_lang["COMMIT_COMMAND_help"] 			= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />Hvis du ønsker å bruke et versjonskontrollsystem slik soms CVS for å arkivere endringer til din GEDCOM-fil, konfigurasjonen din eller personverninnstillinger, kan du skrive kommandoen her.  La boksen være blank hvis du ikke ønsker å bruke et versjonskontrollsystem.  Gyldige valg er <b>cvs</b> og <b>svn</b>.<br />";
$pgv_lang["COMMIT_COMMAND"] 			= "Kommando for Versjonskontroll-commit ";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Vis Multi-site søk tillater brukere å søke i flere websteder som du har definert i adminmenyen Oppsett for nettsteder.  Dette valget kontrollererom Multi-site søk-funksjonaliteten er tilgjengelig for alle eller bare godkjente brukere.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Vis Multi-Site søk";
$pgv_lang["SHOW_NO_WATERMARK"]			= "Hvem kan se ikke-vannmerkede bilder?";
$pgv_lang["SHOW_NO_WATERMARK_help"]		= "~#pgv_lang[SHOW_NO_WATERMARK]#~<br /><br />Hvis Mediabrannmuren er aktivert, vil brukerne se vannmerker hvis de ikke har tilgangsnivået som er spesifisert her.<br />";
$pgv_lang["WATERMARK_THUMB"]			= "Legge til vannmerke på miniatyrbilder?";
$pgv_lang["WATERMARK_THUMB_help"]		= "~#pgv_lang[WATERMARK_THUMB]#~<br /><br />Hvis Mediabrannmuren er aktivert, skal miniatyrbildene vannmerkes? Medialistene vill lastes hurtigere dersom du ikke vannmerker miniatyrbildene.<br />";
$pgv_lang["SAVE_WATERMARK_THUMB"]		= "Lagre vanmerkede miniatyrbilder på tjeneren?";
$pgv_lang["SAVE_WATERMARK_THUMB_help"]	= "~#pgv_lang[SAVE_WATERMARK_THUMB]#~<br /><br />Hvis Mediabrannmuren er aktivert, skal kopier av vannmerkede miniatyrbilder lagres på tjeneren i tillegg til de samme miniatyrbildene uten vannmerke?<br /><br />Hvis alternativet er satt til <b>#pgv_lang[yes]#</b>,  vil medialister som inneholder vannmerkede miniatyrbilder bli genererert raskere på bekostning av større krav til diskplass på tjeneren.<br />";
$pgv_lang["SAVE_WATERMARK_IMAGE"]		= "Lagre vannmerkede bilder i full størrelse på tjener?";
$pgv_lang["SAVE_WATERMARK_IMAGE_help"]	= "~#pgv_lang[SAVE_WATERMARK_IMAGE]#~<br /><br />Dersom Mediabrannmuren er aktivert, skal kopier av vannmerkede bilder i full størrelse lagres på tjeneren i tillegg til de samme bildene uten vannmerke?<br /><br />Hvis alternativet er satt til <b>#pgv_lang[yes]#</b>, vil vannmerkede bilder i fullskala størrelse bli vist raskere på bekostning av større krav til diskplass.<br />";
$pgv_lang["DBPERSIST"]					= "Bruk vedvarende databaseforbindelser";
$pgv_lang["DBPERSIST_help"]				= "Bestemmer om PhpGedView skal bruke vedvarende databasetilkoblinger ved oppkobling til databasen.<br /><br />Når valget er satt til <b>Yes</b>, kan PhpGedView bruke databaseforbindelsen om igjen og derved oppnå hurtgere etablering av databasetilganger.  Men dette kan skape feil dersom din vertskonfigurasjon har satt verdien for maks antall forbindelser for lavt.  Hvis du er usikkerpå om din vert støtter vedvarende tilkoblinger må du sette dette alternativet til <b>No</b>.<br />";
$pgv_lang["DB_UTF8_COLLATION"]			= "Bruk databasen til å skaffe UTF-8 kollasjoner";
$pgv_lang["DB_UTF8_COLLATION_help"]		= "Bestemmer om PhpGedView skal bruke databasens innebyggede funskjoner for sortering og sammenligning.  Som regel er det hurtigere å bruke databasen til å sortere og sammenligne data i forhold til å benytte PHP, men ikke alle databaser/versjoner har denne muligheten.  Rekkefølgen for sammenligning for hvert språk bestemmes for språket i siden for å konfigurere støttede språk.<br /><br /><span class=\"warning\">VIKTIG: Du må bare sette denne verdien til ja hvis du gjør det FØR databasetabellene er opprettet første gang. Velger du det på en eksisterende database kan datene bli ødelagt.</span><br /><br />MySQL tilbyr god støtte for UTF-8, selv om ikke alle sammenligningssekvenser er tilgjengelige i tidligere versjoner.  Andre databasemotorer tilbyr lite eller ingen støtte for UTF-8. Hvis du er usikker på din databases støtte for UTF-8, skal du sette denne verdien til <b>Nei</b>.<br /><br />Denne <a href='http://en.wikipedia.org/wiki/UTF-8' target='_blank' title='Wikipedia-artikkelen'><b>Wikipedia-artikkelen</b></a> inneholder fyldig informasjon og lenker om UTF-8.<br />";
$pgv_lang["INDI_FACTS_ADD"] 			= "Fakta å legge til for personer";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Dette er de GEDCOM-faktaene som dine brukere kan knytte til personer.  Du kan endre denne listen ved å fjerne eller legge til faktanavn, også egendefinerte om nødvendig.  Faktanavn i denne listen kan ikke samtidig være i <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i> -listen.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Unike fakta for personer";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Dette er rekken med GEDCOM fakta som dine brukere kan legge til <u>en gang</u> for en person.  For eksempel, hvis BIRT er på denne listen, vil brukerne ikke kunne legge til mer enn en BIRT-post til en person.  Faktanavn som er på denne listen kan ikke være på listen <i>#pgv_lang[INDI_FACTS_ADD]#</i>.<br />";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Hurtiglinker for personfakta";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Dette er et utvalg av GEDCOM-fakta for personer som vises ved siden av den komplette listen  og som kan legges til med et enkelt klikk.<br />";
$pgv_lang["FAM_FACTS_ADD"] 			= "Fakta å legge til for familier";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Dette er rekken av GEDCOM-fakta som dine brukere kan legge til familier.  Du kan endre denne listen ved å fjerne eller legge til faktanavn, også egendefinerte om nødvendig.  Faktanavn som er på denne listen kan ikke være på listen <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Unike fakta for familier";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Dette er rekken med GEDCOM fakta som dine brukere kan legge til <u>en gang</u> for en familie.  For eksempel, hvis MARR er på denne listen, vil brukerne ikke kunne legge til mer enn en MARR-hendelse til en familie.  Faktanavn som er på denne listen kan ikke samtidig være på <i>#pgv_lang[FAM_FACTS_ADD]#</i>-listen.<br />";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Hurtiglinker for familiefakta";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Dette er et utvalg av GEDCOM-fakta for personer som vises ved siden av den komplette listen og som kan legges til med et enkelt klikk.<br />";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Fakta å legge til for kilder";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Dette er rekken av GEDCOM-fakta som dine brukere kan legge til kilder.  Du kan endre denne listen ved å fjerne eller legge til faktanavn, også egendefinerte om nødvendig.  Faktanavn som er på denne listen kan ikke samtidig være på <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>-listen.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Unike fakta for kilder";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Dette er rekken med GEDCOM fakta som dine brukere kan legge til <u>en gang</u> for en kilde.  For eksempel, hvis TITL er på denne listen, vil brukerne ikke kunne legge til mer enn en TITL-fakta til en kilde.  Faktanavn på denne listen kan ikke samtidig være på <i>#pgv_lang[SOUR_FACTS_ADD]#</i>-listen.<br />";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Hurtiglinker for kildefakta";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Dette er et utvalg av GEDCOM-fakta for personer som vises ved siden av den komplette listen og som kan legges til med et enkelt klikk.<br />";
$pgv_lang["REPO_FACTS_ADD"] 			= "Fakta å legge til for oppbevaringssteder";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Dette er rekken av GEDCOM-fakta som dine brukere kan legge til oppbevaringssteder.  Du kan endre denne listen ved å fjerne eller legge til faktanavn, også egendefinerte om nødvendig.  Faktanavn på denne listen kan ikke samtidig være   på <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>-listen.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Unike fakta for oppbevaringssteder";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Dette er rekken av GEDCOM-fakta som dine brukere kan legge til oppbevaringssteder.  Du kan endre denne listen ved å fjerne eller legge til faktanavn, også egendefinerte om nødvendig.  Faktanavn som er på denne listen kan ikke samtidig være på <i>#pgv_lang[REPO_FACTS_ADD]#</i>-listen.<br />";
$pgv_lang["REPO_FACTS_QUICK"] 			= "Hurtiglinker for oppbevaringsstedfakta";
$pgv_lang["REPO_FACTS_QUICK_help"]	= "~#pgv_lang[REPO_FACTS_QUICK]#~<br /><br />Dette er et utvalg av GEDCOM-fakta for personer som vises ved siden av den komplette listen og som kan legges til med et enkelt klikk.<br />";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Du kan endre endre hvilke språk som skal støttes av ditt PhpGedView-nettsted ved å legge til eller fjerne hakene som du ønsker.  Dette endrer utvalget av språk som er tilgjengelig for dine brukere.<br /><br />Du kan oppnå det samme ved  <b>#pgv_lang[enable_disable_lang]#</b> lenken på #pgv_lang[admin]#menyen, hvor du også kan endre ting som språkets flagg-ikon, datoformater, eller om etternavn alltids skal skrives først.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Prefiks til Media-ID";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Når et mediaobjekt legges til online i PhpGedView, vil en ID for det mediaobjektet bli generert automatsk. Media ID-en vil få dette prefikset.<br />";
$pgv_lang["FAM_ID_PREFIX"]		= "Prefiks til Familie-ID";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Når en ny familie blir registert online i PhpGedView, vil en ny ID automatisk bli lagd for denne familien. Familie-IDen får da dette prefikset (standard er F).";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Vis alltid faktaopplysninger for familier ved Hurtig-oppdatering";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Dette er en komma-oppdelt list for faktamerker (GEDCOM-fakta) som alltid vil bli vist for familier i vinduet for Hurtig-oppdatering selv om disse allerede finnes for enkelte av personene i familien.<br />For eksempel, hvis MARR er i listen, så vil alltid feltene for bryllupsdato og -sted bli vist.";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Vis faktaopplysninger for familier ved Hurtig-oppdatering";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Dette er en komma-oppdelt liste for faktamerker (GEDCOM-fakta) som vil bli vist for familier i vinduet for Hurtig-oppdatering. Bare faktaopplysninger i denne listen vil bli vist eller valgbare for å legge til nye opplysninger.";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Fakta som alltid vises ved Hurtig-oppdatering";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Dette er en komma-oppdelt list for faktamerker (GEDCOM-fakta) som alltid vil bli vist i vinduet for Hurtig-oppdatering selv om disse allerede finnes fra før for personen.<br />For eksempel, hvis BIRT er i listen, så vil alltid feltene for fødselsdato og -sted bli vist.";
$pgv_lang["QUICK_ADD_FACTS"]			= "Fakta som vises ved Hurtig-oppdatering";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Dette er en komma-oppdelt liste for faktamerker (GEDCOM-fakta) som vil bli vist i vinduet for Hurtig-oppdatering. Bare faktaopplysninger i denne listen vil bli vist eller valgbare for å legge til nye opplysninger.";
$pgv_lang["SURNAME_TRADITION_help"] = "~#pgv_lang[SURNAME_TRADITION]#~<br /><br />Når du legger ny medlemmer til en familie kan PhpGedView foreslå standardverdier for etternavn i henhold til regionale tradisjoner og skikker.<br /><br /><ul><li>Ved tr<b>Paternalistisk</b>tradisjon, vil alle familiemedlemmene ha farens etternavn.</li><li>I  <b>Spansk</b> and <b>Portugisisk</b> tradisjon, vil barna få et etternavn fra hver av foreldrene.</li><li>I  <b>Islandsk</b> tradisjon, vil barna få farens fornavn som etternavn, med en endelse som viser kjønnet.</li><li>I  <b>Polsk</b> tradisjon, vil alle familiemedlemmene ha farens etternavn. For noen etternavn vil endelsen indikere personens kjønn. Endelsene <i>ski</i>, <i>cki</i>, og <i>dzki</i> indikerer hankjønn, men de korresponderende <i>ska</i>, <i>cka</i>, and <i>dzka</i> indikerer hunkjønn.</li></ul><br />";
$pgv_lang["ADVANCED_NAME_FACTS_help"] = "~#pgv_lang[ADVANCED_NAME_FACTS]#~<br /><br />Dette er en kommaseparert liste med GEDCOM-fakta som blir vist på skjermbildet for å legge til eller å endre navn.  Hvis du bruker ikke-latinsk alfabet slik som hebraisk, gresk, kyrillisk eller arabisk, vi du kanskje legge til fakta slik som _HEB, ROMN, FONE, etc. for å tillate lagring av navn i ulike alfabet.<br />";
$pgv_lang["ADVANCED_PLAC_FACTS_help"] = "~#pgv_lang[ADVANCED_PLAC_FACTS]#~<br /><br />Dette er en kommaseparert liste med GEDCOM-fakta som blir vist på skjermbildet for å legge til eller å stednavn.  Hvis du bruker ikke-latinsk alfabet slik som hebraisk, gresk, kyrillisk eller arabisk, vi du kanskje legge til fakta slik som _HEB, ROMN, FONE, etc. for å tillate lagring av navn i ulike alfabet.<br />";
$pgv_lang["USE_GEONAMES"]				= "Bruk GeoNames-database";
$pgv_lang["USE_GEONAMES_help"]			= "~#pgv_lang[USE_GEONAMES]#~<br /><br />Skal GeoNames-database brukes til å finne flere forslag for stednavn?<br /><br />Når dette valget er satt til <b>#pgv_lang[yes]#</b>, vil GeoNames-database bli søkt i for å finne forslag til stednavn som blir skrevet.  Når det er satt til <b>#pgv_lang[no]#</b>, vil kun den gjeldende stedtabellen bli søkt i.  Etterhvert som du legger inn flere stednavn, vil forslagene bli mer nøyaktige.  Dette valget kan forsinke inntastingen av data, hvis din internettforbindelse er treg.<br /><br />GeoNames geografisk database er gratis tilgjengelig. Den inneholder over 8,000,000 geografiske navn.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Lage automatisk miniatyrbilder";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Skal systemet automatisk lage miniatyrbilder for bilder som ikke har det fra før.<br />PS. Det kan hende at PHP-versjonen din ikke støtter denne funksjonen.";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Denne siden gir deg omfattende informasjon om nettjeneren din der PhpGedView er plassert.  Mange detaljer om konfigurasjonen blir vist om programvaren til tjeneren som er relatert til PHP og PhpGedView.";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Denne siden viser alle de viktigste emnene om hjelp for konfigurasjon på et sted.  Du kan se på eller skrive ut informasjonen for senere bruk.";
$pgv_lang["more_help_advice"]			= "<br /><b>Mer hjelp</b><br />Mer hjelp er tilgjengelig ved å klikke på <b>?</b> ved siden av hvert punkt på siden.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Bredde for laging av miniatyrbilder";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Dette er bredden (i punkter) som programmet vil bruke ved automatisk generering av miniatyrbilder.<br />Standardverdi er 100.";
$pgv_lang["SHOW_SOURCES"]				= "Vis kilder";
$pgv_lang["SHOW_SOURCES_help"]			= "Angi tilgangsnivå med hensyn til personvern for alle kilder.  Dersom brukeren ikke har tilgang til kilder, vil menyvalget for kilder bli fjernet under Lister og arkfanen for kilder vil ikke bli vist på faktasiden for personer eller familier.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "Dersom valget <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> er aktivert vil denne innstillingen kontrollere om admin må godkjenne registreringen.<br /><br />Velger du <b>Ja</b>, vil alle nye brukere først måtte bekrefte registreringen og deretter bli godkjent av en admin før de kan logge seg inn.  Velger du <b>Nei</b>, vil avmerkingboksen <b>#pgv_lang[verified_by_admin]#</b> bli aktivert automatisk når brukere bekrefter kontoen sin. Brukerene kan deretter logge seg inn direkte uten at admin trenger å godkjenne kontoen.";
$pgv_lang["SPLIT_PLACES"]				= "Splitt steder i Endringsvisning";
$pgv_lang["SPLIT_PLACES_help"]			= "Velger du <b>Ja</b> vil stedsfeltet bli splittet slik at hvert sted (separert med komma) bli vist i egne felt for enklere redigering.  Eksempel :<br /><ol><li>Standard oppsett<br /><u>Sted</u>: Gulset, Skien, Telemark, Norge<br /><br /><li>Splittet<br /><u>Land</u>: Norge<br /><u>Fylke</u>: Telemark<br/><u>Kommune</u>: Skien<br/><u>Bydel</u>: Gulset</ol>";
$pgv_lang["ALLOW_REMEMBER_ME_help"]		= "Mange nettsteder gir deg som bruker anledning til å velge om du (datamaskinen) skal bli gjenkjent neste gang du besøker dem.  Dersom du aktiverer dette valget, vil sjekkboksen <b>Husk meg</b> bli vist på siden for innlogging.  Når denne sjekkboksen er avmerket, har brukeren gitt PhpGedView tillatelse til å lagre en 'cookie' på datamaskinen til brukeren.  Denne 'cookien' vil gjøre at PhpGedView gjenkjenner brukeren neste gang nettstedet besøkes.";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Understrek navn omgitt av anførselstegn";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "Mange programmer vil sette det foretrukne fornavnet i \"anførselstegn\" i GEDCOM-filen.  Den vanligste visningen for dette er å understreke dette navnet.<br /><br />Eksempel:<br />Navn angitt i GEDCOM-filen som:<br /> 1&nbsp;NAME&nbsp;Per&nbsp;\"Anders\"&nbsp;Baklie&nbsp;/Jensen/<br />- Dersom valget er aktivert vil navnet bli vist som<br />(avhengig om etternavnet er angitt til å bli vist først eller sist):<br /><b>Per&nbsp;<u>Anders</u>&nbsp;Baklie&nbsp;Jensen</b><br />eller<br /><b>Jensen,&nbsp;Per&nbsp;<u>Anders</u> Baklie</b>";
$pgv_lang["PRIVACY_BY_RESN"]			= "Bruk GEDCOM (RESN) restriksjoner for personvern";
$pgv_lang["PRIVACY_BY_RESN_help"]		= "GEDCOM spesifikasjon 5.5.1 inkluderer et valg for å bruke RESN merker (tags)  for å angi valg for personvern for personer eller fakta i GEDCOM-filen.  Ved å aktivere dette valget, så vil det be programmet om å se etter nivå 1 RESN merker i GEDCOM-postene.  Nivå 2+ RESN merker vil også bli automatisk tilføyd, men vil ikke ha noen effekt med dette valget.  NB. Aktivering av dette valget kan gjøre at PhpGedView bruker lengre tid til å vise enkelte sider.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Vis LDS ordineringskoder i diagram-bokser";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "Ved å velge <b>Ja</b> her vil LDS (Mormonere) ordineringskoder bli vist i diagrambokser.<ul><li><b>B</b> - Døpt (Baptism)</li><li><b>E</b> - Gave (Endowed)</li><li><b>S</b> - Koblet til ektefelle (Sealed to spouse)</li><li><b>P</b> - Koblet til foreldre (Sealed to parents)</li></ul>En person som har alle utført ordineringene vil ha <b>BESP</b> skrevet ut etter navnet sitt.  Manglende ordineringer blir vist som <b>_</b> i stede for bokstavkoden.  For eksempel, <b>BE__</b> indikerer manglende <b>S</b> og <b>P</b> ordineringer.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Standard ark/kort som skal vises på faktasiden til personer";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "Dette valget gir deg mulighet til å bestemme hvilket ark/kort som skal vises først på faktasiden for personer.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Vis Navn som gift på personlister";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "Dette valget vil vise navn som gift for hustruer i personlisen.  Dette valget krever at du har kopiert etternavnet til ektemannen når du importerte GEDCOM-filen.";
$pgv_lang["SHOW_QUICK_RESN"]			= "Vis felt for personvern i #pgv_lang[quick_update_title]# skjemaet";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "Dette valget girt deg mulighet til å aktivere/deaktivere felt for personvern i #pgv_lang[quick_update_title]# skjemaet.  Feltene for personvern gir en bruker som legger til informasjon ved hjelp av skjemaet mulighet til å overstyre standard innstilling for personvern for faktaen som de redigerer.";
$pgv_lang["USE_QUICK_UPDATE"]			= "Bruke skjemaet #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "Dette valget gir brukere med rett til å endre mulighet til å gjøre dette med skjemaet #pgv_lang[quick_update_title]#.";
$pgv_lang["SEARCHLOG_CREATE"]			= "Arkivere søke-logg-filer";
$pgv_lang["SEARCHLOG_CREATE_help"]		= "Hvor ofte programmet skal arkivere søke-logg-filer.";
$pgv_lang["CHANGELOG_CREATE"]		= "Arkiver endringsloggfiler";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere filene for endringslogg?.<br />";
$pgv_lang["CHART_BOX_TAGS"]				= "Vise andre fakta i diagram";
$pgv_lang["CHART_BOX_TAGS_help"]		= "I tillegg til faktopplysninger om fødsel- og dødsdato vist i diagrammet Anetre, kan du her skrive inn fakta separert med mellomrom eller komma.  Denne listen krever at du bruker faktanavn slik de er beskrevet i GEDCOM 5.5.1 standarden.  For eksempel, dersom du ønsker å vise yrke i boksene, kan du legge til \"OCCU\" i feltet.";
$pgv_lang["FULL_SOURCES"]		= "Bruk fullstendige kildesiteringer";
$pgv_lang["FULL_SOURCES_help"]		= "~#pgv_lang[FULL_SOURCES]#~<br /><br />Kildehenvisninger kan inkludere felter for å lagre informasjon om kvaliteten på dataene (primærkilde, sekundærkilde, osv.) og datoen hendelsen ble inntatt i kilden.  Hvis du ikke bruker disse feltene kan du deaktivere dem når du oppretter ny kilder.<br />";
$pgv_lang["PREFER_LEVEL2_SOURCES"]		= "Foretrekk kilder til fakta";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"]		= "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Når du legger til nye fakta for nære slektninger, kan du legge til kildehenvisninger til postene (dvs INDI, FAM) eller faktaene (BIRT, MARR, DEAT).  Dette alternativet kontrollerer hvilke avkrysningsbokser som skal kukes av som default.<br />";


//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]				= "GEDCOM basisvalg";
$pgv_lang["media_conf"]					= "Multimedia";
$pgv_lang["media_general_conf"]	= "Generelt";
$pgv_lang["media_firewall_conf"]	= "Mediabrannmur";
$pgv_lang["accpriv_conf"]				= "Tilgang og personvern";
$pgv_lang["displ_conf"]					= "Visning og layout";
$pgv_lang["displ_names_conf"]			= "Navn";
$pgv_lang["displ_comsurn_conf"]			= "Mest brukte etternavn";
$pgv_lang["displ_layout_conf"]			= "Layout";
$pgv_lang["displ_hide_conf"]			= "Skjul & Vis";
$pgv_lang["editopt_conf"]		= "Redigeringsvalg";
$pgv_lang["useropt_conf"]				= "Bruker-valg";
$pgv_lang["contact_conf"]				= "Kontakt-informasjon";
$pgv_lang["meta_conf"]					= "META Tag/merker";
$pgv_lang["gedconf_head"]				= "Oppsett for GEDCOM";
$pgv_lang["other_theme"]				= "Annet, vennligst tast inn";
$pgv_lang["performing_update"]			= "Oppdaterer.";
$pgv_lang["config_file_read"]			= "Config-fil lest inn.";
$pgv_lang["does_not_exist"]				= "eksisterer ikke";
$pgv_lang["media_drive_letter"]			= "Stien til Medier bør ikke inneholde en stasjons-bokstav, fordi da vil kanskje ikke Medier bli vist.";
$pgv_lang["db_setup_bad"]				= "Det er feil i innstillingene til databasen din.  Sjekk de ulike valgene for oppkobling til databasen og gjør nødvendige endringere.";
$pgv_lang["bad_host_user_pass"]			= "PhpGedView klarte ikke å opprette en forbindelse til verten til databasen din. Sjekk at du har angitt rett navn på vert, brukernavn og passord.";
$pgv_lang["bad_database_name"]			= "PhpGedView greide å opprette en forbindelse til verten til databasen din, men fikk ikke tillatelse til å bruke databasen med det navnet du oppgav.  Sjekk at databasen finnes og at brukernavnet du oppgav har de nødvendige rettigheter i denne databasen.";
$pgv_lang["db"]							= "Database";
$pgv_lang["current_gedcoms"]			= "Aktive slektsfiler (GED)";
$pgv_lang["ged_gedcom"]					= "GEDCOMfil";
$pgv_lang["ged_title"]					= "Tittel til Slektsbasen";
$pgv_lang["ged_config"]					= "Konfigurasjonsfil";
$pgv_lang["ged_search"]					= "Søke-logg-filer";
$pgv_lang["ged_change"]			= "Filer for endringslogg";
$pgv_lang["ged_privacy"]				= "Personvernfil";
$pgv_lang["disabled"]					= "Ikke valgt";
$pgv_lang["mouseover"]					= "Ved å føre musen over";
$pgv_lang["mousedown"]					= "Ved å holde museknappen inne";
$pgv_lang["click"]						= "Ved å klikke med musen";
$pgv_lang["enter_db_pass"]				= "På grunn av hensyn til sikkerhet må du skrive inn brukernavnet og passordet ditt for databasen for å endre konfigurasjon-verdiene.";
$pgv_lang["server_url_note"]			= "Dette bør være URLen til din PhpGedView mappe/katalog.  Du bør bare endre dette valget dersom du er sikker på hva du gjør.  PhpGedView har sjekket ut at din SERVER_URL bør være #GUESS_URL#";

$pgv_lang["DBTYPE"]						= "Velg database";
$pgv_lang["DBTYPE_help"]				= "Ulike PEAR støttede databaser som kan benyttes.  Valgene er MySQL, PostgreSQL, Oracle og SQLite.";
$pgv_lang["DBHOST"] 					= "Database-vert";
$pgv_lang["DBHOST_help"] 				= "DNS eller IP-adressen til nettserveren hvor databasen din er installert.";
$pgv_lang["DBPORT"]			= "Database Port";
$pgv_lang["DBPORT_help"]		= "~#pgv_lang[DBPORT]#~<br /><br />TCP-porten som skal benyttes ved tilkobling til databasetjeneren.  La den være blank for å benytte defaultverdien for din databasetype.  Valget har ingen betydning dersom du bruker en SQLite database.<br />";
$pgv_lang["DBUSER"] 					= "Database-brukernavn";
$pgv_lang["DBUSER_help"] 				= "Brukernavnet ditt i databasen, som er nødvendig for å kunne logge inn på databasen din.";
$pgv_lang["DBPASS"] 					= "Database-passord";
$pgv_lang["DBPASS_help"] 				= "Passordet ditt i databasen, som er nødvendig for å kunne logge inn på databasen din.";
$pgv_lang["DBNAME"] 					= "Database-navn";
$pgv_lang["DBNAME_help"] 				= "Den databasen i serveren, som du vil ha PhpGedView til å bruke.  Det brukernavnet du tastet inn i brukerfeltet må ha rett til å lage, overskrive, oppdatere, slette og velge i denne databasen.";
$pgv_lang["TBLPREFIX_help"] 			= "En prefiks som legges til de tabeller som PhpGedView har opprettet.  Ved å endre denne verdi kan du sette flere PhpGedView-sider opp til å bruke den samme databasen men med forskellige tabeller.";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "Ved å sette denne valget til <b>Ja</b>, så gir du brukere av nettstedet ditt muligheten til å bytte slektsbase hvis du har lagt inn flere slektsbaser.<br /><br />Dersom du har valgt <b>Nei</b>, vil ingen brukere ha mulighet til å bytte slektsbase.";
$pgv_lang["upload_path"]			= "Bane for opplastning";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Dette er banen hvor GEDCOM-filen du ønsker å laste opp befinner seg. For å velge bane, klikk på <b>Bla gjennom</b> og naviger til GEDCOM-filen og klikk <b>Åpne</b>.";
$pgv_lang["gedcom_path"] 				= "Bane og navn til GEDCOM-filen";
$pgv_lang["gedcom_path_help"] 			= "Hent (upload) først GEDCOM-filen din til et sted som kan nås av php-installasjon på serveren din.  Angi deretter stien og navnet til filen som f.eks.: <b>./index/navn.ged</b>.<br /><br />Les <a href=\"readme.txt\" target=\"_blank\">Readme.txt</a> filen for mer hjelp.";
$pgv_lang["CHARACTER_SET"] 				= "Tegnsett";
$pgv_lang["CHARACTER_SET_help"] 		= "Dette er tegnsettet angitt for slektsfilen din.  UTF-8 anbefales, og burde fungere for de fleste sider.  Hvis du eksporterer slektsfilen din i IBM Windows tegnsett, skal du skrive WINDOWS her.<br /><br />NB: PHP støtter IKKE UNICODE (UTF-16) så det nytter ikke å klage over dette til PHP folk :-)";
$pgv_lang["LANGUAGE"] 					= "Språk";
$pgv_lang["LANGUAGE_help"] 				= "Velg det språk side din bruker som utgangspunkt.  Brukerne har mulighet til å overse denne innstillingen og i stede velge et eget språk selv, enten ved å la språkinnstillingen i nettleseren til brukeren velge, eller ved å angi eget språk selv, hvis \"Tillat brukere å skifte språk\" = Ja .";
$pgv_lang["ENABLE_MULTI_LANGUAGE"] 		= "Tillat brukere å skifte språk";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "Settes til 'ja' hvis brukerne skal få lov til å velge et annet språk fra en 'slipp ned'-liste på siden, eller bli styrt av språkinnstillingen i nettleseren til brukerne.";
$pgv_lang["CALENDAR_FORMAT"] 			= "Format på kalender";
$pgv_lang["CALENDAR_FORMAT_help"] 		= "Gir deg adgang til å spesifisere hvilken type kalender du vil bruke sammen med denne GEDCOMfilen. Hebraisk er det samme som den jødiske kalender med hebraiske tegn. NB: Verdiene for jødisk / hebraiske datoer er beregnet fra de Gregorianske / Julianske datoer. Ettersom den jødiske kalenderdag starter ved skumringen vil alle begivenheter som finner sted mellom skumringen og midnatt bli vist en dag tidligere enn den korrekte jødiske datoen. Gamle nettlesere kan ha problemer med å vise hebraisk. Visse gamle nettlesere viser hebraisk baklengs eller ikke det hele tatt.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Vis hebraiske tusentall";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] 	= "Vis Alafim i Hebraiske kalendere. Settes den til ja, vises året 1969 som <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; men settes den til nei, vises året som <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Dette har ingen innvirkning på det jødiske års innstillinger. Året blir vist som 5729 uansett denne innstillingen.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]	= "Vis hebraisk Geyrshayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"] = "Viser enkelt og dobbelt anførselstegn ved visning av hebraiske datoer. Ved ja-innstilling vises 8 februar 1969 som <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; kontra nei-innstillingen som viser datoen som <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dette påvirker ikke jødisk år innstillingen fordi det ikke brukes anførselstegn i jødiske datoer, som vises med Latin tegnsett.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] 	= "Jødisk Ashkenazi uttale";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "Bruk jødisk Ashkenazi uttale.<br />Hvis satt til ja vil månedene Cheshvan og Teves bli stavet med Ashkenazi uttale. Hvis satt til nei vil månedene bli stavet Hesvan og Tevet. <br />Dette berører kun den jødiske innstilling. Med hebraisk innstilling brukes det hebraiske alfabet.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"] 	= "Antall generasjoner i diagram / trær";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] = "Angi antall generasjoner som standard skal vises i slektstrær (diagram for aner/forfedre).";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]	= "Maks generasjoner for aner/forfedre";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] 	= "Lagrer maksimalt antall generasjoner som skal vises på slektstrær (diagram for aner/forfedre).";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] 	= "Maks generasjoner for etterkommere";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "Lagrer det maksimale antall generasjoner som skal vises i diagram for etterkommere.";
$pgv_lang["USE_RIN"] 					= "Bruk RIN# istedenfor GEDCOM ID";
$pgv_lang["USE_RIN_help"] 				= "Velg Ja for å bruke RIN nummeret istedenfor GEDCOM ID når PhpGedView spør etter IDen til personer i konfigurasjonsfiler, brukerinnstilliger, og diagram. Dette er nyttig der slektsprogrammer ikke eksporterer GEDCOM med ensartet person ID, men bruker alltid den samme RIN.";
$pgv_lang["GENERATE_GUID"]		= "Lag globale unike IDer automatisk";
$pgv_lang["GENERATE_GUID_help"]	= "~#pgv_lang[GENERATE_GUID]#~<br /><br /><b>GUID</b> er i denne sammenhengen en forkortelse for «Global Unik ID».<br /><br />GUIDer er ment for å identifisere hver person på en måte som er gjenbrukbar, slik at sentrale organisasjoner slik som Family History Center of the LDS Church i Salt Lake City, eller til og med kompatible programmer som kjører på din egen tjener, kan vite om de har å gjøre med den samme personen uansett hvor GEDCOM-filen kommer fra.  Målet til Family History Center er å skaffe seg e sentralt oppbevaringssted for genealogiske data og vise dem gjennom webtjenester. Dette vil gjøre det mulig for hvilket som helst program å få tilgang til data og oppdatere dataene.<br /><br />Hvis du ikke tenker å dele denne GEDCOM-filen med noen andre, behøver du ikke la PhpGedView lage disse GUIDene; uansett, ved å gjøre det gjør det ikke annen skade enn å øke størrelsen på GEDCOM-feilen din.<br />";
$pgv_lang["PEDIGREE_ROOT_ID"] 			= "Standard hovedID i slektsdiagram";
$pgv_lang["PEDIGREE_ROOT_ID_help"] 		= "Lagrer ID til den person, som standard er valgt som hovedperson ved visning av diagram for aner/forfedre (slektstre) og etterkommere.";
$pgv_lang["GEDCOM_ID_PREFIX"] 			= "GEDCOM ID prefiks";
$pgv_lang["GEDCOM_ID_PREFIX_help"] 		= "Med mindre brukerne selv legger til et prefiks når de taster inn en ID, vil dette prefiks bli brukt i forbindelse med diagram for aner/forfedre, etterkommere, og andre.";
$pgv_lang["SOURCE_ID_PREFIX"]			= "Kilde&nbsp;ID prefiks";
$pgv_lang["SOURCE_ID_PREFIX_help"]		= "Når en ny kilde blir lagt til online i PhpGedView, vil det automatisk bli generert en ny ID for denne kilden.  Kildens ID vil få denne prefiksen.";
$pgv_lang["REPO_ID_PREFIX"]				= "Oppbevaringssted&nbsp;ID prefiks";
$pgv_lang["REPO_ID_PREFIX_help"]		= "Når et nytt oppbevaringssted blir lagt til online i PhpGedView, vil det automatisk bli generert en ny ID for dette oppbevaringsstedet.  Oppbevaringsstedets ID vil få denne prefiksen.";
$pgv_lang["PEDIGREE_FULL_DETAILS"] 		= "Vise detaljer om fødsel og død i diagram / trær";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "Forteller hvorvidt detaljer om en persons fødsel og død skal vises som standard i boksene i diagrammene.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]	= "Vis ikoner for kjønn i diagrammer";
$pgv_lang["PEDIGREE_SHOW_GENDER_help"]	= "~#pgv_lang[PEDIGREE_SHOW_GENDER]#~<br /><br />Dette alternativet kontrollerer om du skal vise en persons kjønn med et ikon på diagrammer eller ikke.<br /><br />Siden kjønn også er vist med farge på boksene, vil ikke dette valget skjule en persons kjønn. Valget bare fjerner noe duplisert informasjon fra boksene.<br />";
$pgv_lang["PEDIGREE_LAYOUT"] 			= "Standard layout for diagram";
$pgv_lang["PEDIGREE_LAYOUT_help"] 		= "Dette bestemmer om diagrammet (slektstreet) skal skrives ut som liggende eller stående.";
$pgv_lang["SHOW_EMPTY_BOXES"] 			= "Vis tomme bokser i diagram";
$pgv_lang["SHOW_EMPTY_BOXES_help"] 		= "Bestemmer om det skal vises tomme bokser i diagrammene eller ikke.";
$pgv_lang["ZOOM_BOXES"] 				= "Endre størrelse på diagrambokser";
$pgv_lang["ZOOM_BOXES_help"] 			= "Gjør det mulig for en bruker å endre størrelsen på bokser i diagram og for å få mer informasjon.<dl><dt>Du kan velge mellom:</dt><dd><b>#pgv_lang[disabled]#</b> for å sperre dette valget.</dd><dd><b>#pgv_lang[mouseover]#</b> for at boksen skal bli større må man bevege musen over ikonet i boksen.</dd><dd><b>#pgv_lang[mousedown]#</b> for at boksen skal bli større når man holde museneknappe inne når man er over ikonet i boksen.</dd><dd><b>#$pgv_lang[click]#</b> for at boksen skal bli større må man klikke på ikonet i boksen.</dd></dl>";
$pgv_lang["LINK_ICONS"] 				= "Ikon for \"undermeny\" i diagrambokser";
$pgv_lang["LINK_ICONS_help"] 			= "Gjør det mulig for brukere å velge linker til andre diagram og nære slektninger til personen i boksen.<dl><dt>Du kan velge mellom:</dt><dd><b>#pgv_lang[disabled]#</b> for å sperre dette valget.</dd><dd><b>#pgv_lang[mouseover]#</b> for å vise en \"undermeny\" må man bevege musen over ikonet i boksen.</dd><dd><b>#pgv_lang[click]#</b> for å vise en \"undermeny\" må man klikke på ikonet i boksen.</dd></dl>";
$pgv_lang["ABBREVIATE_CHART_LABELS"]	= "Forkorte ledeord i diagram";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]	= "Her bestemmer du om ledeord brukt i diagram skal forkortes, som f.eks 'Født' skal kun vise forbokstaven 'F'.";
$pgv_lang["SHOW_AGE_DIFF"]			= "Vis aldersforskjeller";
$pgv_lang["SHOW_AGE_DIFF_help"]		= "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Dette valget bestemmer hvorvidt fanen Nære slektninger skal vise forskjellen mellom fødselsdatoer for ektefeller, mellom vielsesdato og fødselsdato for første barn og mellom barnas fødselsdatoer.<br />";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Vis alder til foreldre ved siden av fødselsdatoen til barna";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "Dette valget bestemmer om alderen til faren og moren til et barn skal vises ved siden av fødselsdatoen til barna i diagram";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Vis fødseldag og dødsdag for slektninger på faktasiden til personer";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Opplysninger om fødsel og død til slektninger er viktige hendelser. Dette valget gir deg mulighet til å vise disse hendelsene på arkfanen <i>Fakta og detaljer om personen</i> på faktasiden til personer.<br /><br />Hendelser som vises ved aktivering av dette valget, er:<ul><li>Dødsfall til ektefeller</li><li>Fødsel/dødfall til barn</li><li>Dødsfall til foreldre</li><li>Fødsel/dødsfall til søsken</li><li>Dødsfall til besteforeldre</li><li>Fødsel/dødsfall til søsken til foreldre</li></ul>";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Vis automatisk listen av hendelser for nære slektninger";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Dette valget bestemmer om du ønsker automatisk visning av <i>Hendelser til nære slektninger</i>.<br />";
$pgv_lang["EXPAND_SOURCES"]      = "Vis utvidede kilder automatisk";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Dette valget kontrollerer om du ønsker å automatisk vise innholdet i <i>Kilder</i> på siden for personer.<br />";
$pgv_lang["EXPAND_NOTES"]      = "Vis utvidede merknader automatisk";
$pgv_lang["EXPAND_NOTES_help"] = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Dette valget kontrollerer om du ønsker å automatisk vise innholdet i <i>Noter</i> på siden for personer.<br />";
$pgv_lang["SHOW_LEVEL2_NOTES"]      = "Vis alle merknader og kildereferanser på fanene for Merknader og Kilder";
$pgv_lang["SHOW_LEVEL2_NOTES_help"] = "~#pgv_lang[SHOW_LEVEL2_NOTES]#~<br /><br />Dette valget kontrollerer om hvorvidt noter og kildereferanser som er knyttet til fakta skal vises på fanene for noter og faktapå personsiden.<br /><br />Normalt viser noter- og kildefanene bare noter og kilder som er knyttet direkte til personens post.  Disse kalles <i>nivå 1</i> noter- og kildereferanser.<br /><br />Valget <b>#pgv_lang[yes]#</b> vil få disse fanene til også å vise noter og kildereferanser som er en del av heldelser og fakta knyttet til persones post i databasen.  Dette er <i>nivå 2</i>-noter og kilder fordi de ulike faktaene er nivå 1.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"] 			= "Aktivere <b>personvern</b>";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] 		= "Denne funksjon gir PhpGedView beskjed om å skjule personlige opplysninger til nålevende personer.  Nålevende personer defineres som de, som ikke har en begivenhet registreret lengre tilbake enn for ".(isset($MAX_ALIVE_AGE)?$MAX_ALIVE_AGE:"120")." år siden, og som ikke har noen barn, som ble født for mer enn ".(isset($MAX_ALIVE_AGE)?($MAX_ALIVE_AGE-20):"100")." år siden.";
$pgv_lang["REQUIRE_AUTHENTICATION"] 	= "Krev at besøkende<br /><b>MÅ</b> logge inn";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "Ved å angi denne valget, tvinges alle besøkende til å logges inn før de kan se data på siden.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]		= "Velkomsttekst<br />på siden for å logge inn hvis <br />\"Krev at besøkende <br /><b>MÅ</b> logge inn\" = Ja";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "Her kan du velge en tekst som vil vises på siden der du logger deg inn dersom du krever at <b>alle</b> besøkende må ha en brukerkonto. Sjekk hvilken av de forhåndsdefinerte tekstene som passer best for deg.<br /><br />- Du kan også velge å lage din egen selvkomponerte velkomstekst, men husk at denne ikke vil bli oversatt til besøkende med andre språk.<br /><br /><b>Du kan velge mellom disse tekstene:</b><br /><br /><li>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:<br /><br />#pgv_lang[welcome_text_auth_mode_1]#<br /><br /><li>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:<br /><br />#pgv_lang[welcome_text_auth_mode_2]#<br /><br /><li>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:<br /><br />#pgv_lang[welcome_text_auth_mode_3]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]	= "Ingen forhåndsdefinert tekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Forhåndsdefinert tekst som sier at ALLE besøkende kan søke om en brukerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Forhåndsdefinert tekst som sier at ADMIN vil vurdere en eventuell søknad om brukerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Forhåndsdefinert tekst som sier at BARE familiemedlemmer kan søke om en brukerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Egenkomponert velkomsttekst skrevet i feltet under";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Egenkomponert velkomsttekst dersom <br />\"Krev at besøkende <br /><b>MÅ</b> logge inn\" = Ja";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "Dersom du har valgt å bruke en egendefinert velkomsttekst i valgfeltet over, kan du skrive inn teksten her.<br />Teksten vil <b>ikke</b> bli oversatt for besøkende med annet språk, men vil bli vist nøyaktig som du har skrevet den.<br />Dersom du ønsker det, kan du bruke HTML-koder i teksten - Husk avslutningskoder!<br /><br /><b>PS!</b> Du kan bruke en forhåndsdefinert start på teksten din som vil bli oversatt til språket som den besøkende bruker. Velg \"Ja\" i feltet over for å bruke \"Standard start for ...\".";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"]	= "Standard start for egenkomponert tekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"]	= "Du kan velge å vise en (flerspråklig) standardtekst som start for den egenkomponerte velkomstteksten din.<br /><br />Dersom du velger \"Ja\", vil teksten start med følgende setninger:<br /><br />#pgv_lang[welcome_text_cust_head]#";
$pgv_lang["SHOW_REGISTER_CAUTION"]			= "Vis 'Avtale om akseptabel bruk' på «Be om ny brukerkonto» siden";
$pgv_lang["SHOW_REGISTER_CAUTION_help"]		= "~#pgv_lang[SHOW_REGISTER_CAUTION]#~<br /><br />Når dette valget er satt til <b>#pgv_lang[yes]#</b>, vil følgende melding vises over inputfeletene på «#pgv_lang[requestaccount]#» siden:<div class=\"list_value_wrap\">#pgv_lang[acceptable_use]#</div>";
$pgv_lang["CHECK_CHILD_DATES"] 			= "Sjekk datoer til barn";
$pgv_lang["CHECK_CHILD_DATES_help"] 	= "Undersøker datoer til barna for å bestemme om en person bør oppfattes som levende eller død.  På eldre PCer og store GEDCOM filer kan slike søk øke responstiden på siden din.";
$pgv_lang["MAX_ALIVE_AGE"] 				= "Antatt maks levetid for en person";
$pgv_lang["MAX_ALIVE_AGE_help"] 		= "Dette er den maksimale alder der det kan være en begivenhet for personen. Eller den maksimale alder til barn til en person, som igjen brukes til å bestemme om en person skal anses for å være død eller ikke.";
$pgv_lang["SHOW_GEDCOM_RECORD"] 		= "Tillat brukere å se GEDCOM poster";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "Settes dette til Ja, blir det lagt en link på personer, kilder, og familier, som gjør det mulig for brukere å åpne et eget vindu med GEDCOM koden hentet direkte fra GEDCOM-filen.";
$pgv_lang["ALLOW_EDIT_GEDCOM"] 			= "Aktivere online-redigering";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] 	= "Aktiverer online-redigering for denne slektsfilen så brukere med redigerings-rettigheter kan oppdatere denne slektsfilen online.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Lukk automatisk vindu for redigering";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Dette valget angir om vindu for redigering skal lukkes automatisk etter at oppdatering er utført uten feil.";
$pgv_lang["INDEX_DIRECTORY_help"] 		= "Dette er stien til en - lese- og skrivbar - mappe, der PhpGedView lagrer indekseringsfiler (husk å legge til avsluttende skråstrek \"/\")  PhpGedView krever ikke at mappen må være \"index\".<br /><br />Av hensyn til sikkerheten bør denne mappen være plassert på et sted på serveren som ikke tilgjengelig fra internett. <br />Eksempel:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Index:</b> dir1/dir4/dir5/dir6/index<br /><br />Da bør du skrive følgende i feltet: <b>../../dir4/dir5/dir6/index/</b>";
$pgv_lang["POSTAL_CODE"]  = "Plassering av postnummer";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Ulike land bruker forskjellig måte å skrive postadresser. Du kan her velge om postnummert skal komme før eller etter navnet på poststedet.";
$pgv_lang["SUBLIST_TRIGGER_I"]		= "Maks antall etternavn";
$pgv_lang["SUBLIST_TRIGGER_I_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_I]#~<br /><br />Lange lister med personer med samme etternavn kan brytes opp i mindre underlister i henhold til den første bokstaven i personenes fornavn.<br /><br />Dette valget bestemmer når underlister av etternavn skal benyttes.  For å deaktivere oppdeling i underlister fullstendig, sett dette valget til null.<br />";
$pgv_lang["SUBLIST_TRIGGER_F"]		= "Maks antall familienavn";
$pgv_lang["SUBLIST_TRIGGER_F_help"]	= "~#pgv_lang[SUBLIST_TRIGGER_F]#~<br /><br />Lange lister med familier med samme etternavn kan brytes opp i mindre underlister i henhold til den første bokstaven i personenes fornavn.<br /><br />Dette valget bestemmer når underlister av etternavn skal benyttes.  For å deaktivere oppdeling i underlister fullstendig, sett dette valget til null.<br />";
$pgv_lang["SURNAME_LIST_STYLE"]		= "Type etternavnliste";
$pgv_lang["SURNAME_LIST_STYLE_help"]	= "~#pgv_lang[SURNAME_LIST_STYLE]#~<br /><br />Lister med etternavn, slik som de fremkommer i #pgv_lang[block_top10]# blokken, #pgv_lang[individual_list]#, og #pgv_lang[family_list]#, kan vises i ulike stiler.<ul><li><b>#pgv_lang[style2]#</b>&nbsp;&nbsp;&nbsp;I denne stilen vil etternavn vises i en tabell som kan sorteres enten etter etternavn eller antall.</li><li><b>#pgv_lang[style3]#</b>&nbsp;&nbsp;&nbsp;I denne stilen vil etternavn vises i en liste og størrelsen på skrifttypen for hvert navn er avhengig av frekvensen av dette etternavnet i databasen. Denne listen kan du ikke sortere.</li></ul><br />";
$pgv_lang["SHOW_ID_NUMBERS_help"] 		= "Dette valget bestemmer om ID nummeret skal vises i parentes etter personnavnet i diagram og faktasiden til personer.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Vis GEDCOM-postens sist endret dato i listene";
$pgv_lang["SHOW_LAST_CHANGE_help"]	= "~#pgv_lang[SHOW_LAST_CHANGE]#~<br /><br />Dette valget kontroller om du skal vise GEDCOM-postens siste endringsdato eller ikke på lister.<br />";
$pgv_lang["SHOW_EST_LIST_DATES"]		= "Vis beregnet dato for fødsler og dødsfall";
$pgv_lang["SHOW_EST_LIST_DATES_help"]	= "~#pgv_lang[SHOW_EST_LIST_DATES]#~<br /><br />Dette valget kontrollerer om du skal vise beregnede datoer for fødsel og død istedenfor blank i personlister og diagrammer fpr personer der disse datoene ikke er kjent.<br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"] 		= "Stedsnavnsnivåer som vises i personboksene:";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "Viser hvor mye informasjon om stedsnavn som vises i personboksene i diagram. Velges 9 vil alle stedsnavnsnivåer bli vist. Velges 0, vil ingen stedsnavn bli vist. Velges 1, vises første nivå, 2 viser 2 nivåer osv.";
$pgv_lang["MULTI_MEDIA"] 				= "Aktivere multimedia-valg";
$pgv_lang["MULTI_MEDIA_help"] 			= "GEDCOM 5.5 gir deg tillatelse å linke bilder, videoer, og andre multimedia-objekter i din GEDCOM.  Hvis du ikke har inkluderet multimedia objekter i din GEDCOM, kan du deaktivere multimedia-valget ved å sette denne verdien til 'Nei'. <br />Se multimedia-avsnittet i <a href=\"".(file_exists('readme-norsk.txt')?"readme-norsk.txt":"readme.txt")."\" target=\"_blank\">readme".(file_exists('readme-norsk.txt')?"-norsk":"").".txt</a> filen for flere opplysning om å inkludere media på din side.";
$pgv_lang["MEDIA_EXTERNAL"]				= "Behold URL-linker";
$pgv_lang["MEDIA_EXTERNAL_help"]		= "Når dette valget er satt til Ja, vil en multimedia link som starter med f.eks. http://, ftp://, mms:// ikke bli endret.<br />Eksempel: http://www.minfamilie.no/bilder/pappa.jpg vil forbli uendret og linken http://www.minfamilie.no/bilder/pappa.jpg vil bli brukt.<br />Når satt til Nei, vil linken bli behandlet som en standard referense og mediamappen vil bli brukt.<br />Eksempel: http://www.minfamilie.no/bilder/pappa.jpg vil bli endret til ./media/pappa.jpg";
$pgv_lang["MEDIA_DIRECTORY"] 			= "Mappe for Multimedia";
$pgv_lang["MEDIA_DIRECTORY_help"] 		= "Stien til en leselig mappe, hvor PhpGedView skal lete etter lokale multimedia filer (husk å legge til avsluttende skråstrek \"/\").";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] 	= "Antall mappenivåer for multimedia";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] = "Verdien 0 ignoreres i alle mapper i media objektets fil-sti.  Verdien 1 vil bruke den første mappe som inneholder dette bilde.  Ved å øke verdien økes antall mappenivår som skal inkluderes i stien.  <br />Eksempel: hvis du kobler et bilde i GEDCOMen din med en sti som C:\\Documents and Settings\\User\\Mine Dokumenter\\Mine bilder\\Slekt\\Etternavn\\bestefar.jpg vil verdien 0 svare til stien ./media/bestefar.jpg.  Verdien 1 vil svare til  ./media/Etternavn/bestefar.jpg, osv.  De fleste vil kunne klare seg med verdien 0.  Men, forskellige media-objekt som heter det samme, vil da overskrive hverandre.  Denne innstillingen gir deg mulighet til å organisere dine media så navnesammenfall ikke gir problemer.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "Dersom du har aktiveret multimedia på siden din, kan PhpGedView vise små bilder (passfoto) ved siden av personenes navn i tabeller, diagram og bokser.  For tiden bruker PhpGedView det første multimedia-objekt som er listet i en GEDCOM post som det utvalgte bilde.  For personer med flere bilder, må du arrangere multimedia-objektene slik at det bilde du ønsker brukt er plasseret før de andre.<br />Se multimedia avsnittet i filen <a href=\"".(file_exists('readme-norsk.txt')?"readme-norsk.txt":"readme.txt")."\" target=\"_blank\">readme".(file_exists('readme-norsk.txt')?"-norsk":"").".txt</a> for mer informasjon om å inkludere medier på siden din.";
$pgv_lang["USE_THUMBS_MAIN"]			= "Bruk miniatyrbilde som hovedbilde på faktasiden til personer";
$pgv_lang["USE_THUMBS_MAIN_help"]		= "Avhengig av hvordan du lagre bildene dine, er det sannsynlig best å bruke miniatyrbilde som bilde på faktasiden til personer.  Dersom hovedbildet ditt er veldig stort, kan det ta lang tid å laste ned. Hvis miniatyrbildene dine har en god nok kvalitet, så kan disse brukes i stede for bildene i hel størrelse.<br />Setter du dette valget til \"Ja\", vil miniatyrbilde bli brukt.<br />Setter du det til \"Nei\", vil hovedbildet bli brukt.";
$pgv_lang["SHOW_MEDIA_FILENAME"]		= "Vis filnavn i Mediaviser";
$pgv_lang["SHOW_MEDIA_FILENAME_help"]	= "~#pgv_lang[SHOW_MEDIA_FILENAME]#~<br /><br />Mediaviseren kan vise navn på mediafilen som blir vist.  Dette valget bestemmer om du skal vise filnavnet eller ikke.<br /><br />Du vil kanskje skjule filnavnet av sikkerhetshensyn.<br />";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]		= "Vis lenke for nedlasting i mediaviseren";
$pgv_lang["SHOW_MEDIA_DOWNLOAD_help"]	= "~#pgv_lang[SHOW_MEDIA_DOWNLOAD]#~<br /><br />Mediaviseren kan vise en lenke, som hvis man klikker på den vil laste mediafilen ned til lokal PC.<br /><br />Du vil kanskje skjule nedlastningslinken av sikkerhetshensyn.<br />";
$pgv_lang["ENABLE_CLIPPINGS_CART"] 		= "Aktivere utklippsmappen";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "Utklippsmappen gir de besøkende på din side å ta utklipp fra dine data og legge disse til en utklippsfil, som de senere kan downloade som en GEDCOM fil og importere inn i deres eget slektsprogram.";
$pgv_lang["HIDE_GEDCOM_ERRORS"] 		= "Skjul GEDCOM feilmeldinger";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] 	= "Ved å velge 'Ja' her, skjules de feilmeldinger som PhpGedView lager, når den finner et ukjent GEDCOM-merke i din GEDCOM fil.  PhpGedView bestreber seg på å følge GEDCOM 5.5 standarden, men noen slektsprogram legger til deres egne spesielle merker (tags).  Se <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> filen for mer informasjon.";
$pgv_lang["WORD_WRAPPED_NOTES"] 		= "Legg til mellomrom<br />der linjer er delt";
$pgv_lang["WORD_WRAPPED_NOTES_help"] 	= "Noen slektsprogram deler linjer etter hele ord, mens andre deler linjer hvor som helst.  Dette kan føre til at PhpGedView kan komme til å slå sammen ord som ikke skal det.  Hvis du velger 'Ja' her, vil det bli lagt til et mellomrom hvor ord er delt i GEDCOM.";
$pgv_lang["SHOW_CONTEXT_HELP"]			= "Vis hjelp (?) til tekst<br />- som standard";
$pgv_lang["SHOW_CONTEXT_HELP_help"]		= "Dette valget vil vise klikkbare hjelpe-spørsmålstegn etter ulike valg. De besøkende har da mulighet til å få en hjelpetekst som forklarer mer om valget.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Antall dager for rammen Kommende hendelser";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Angi maks antall dager som skal vises i rammen Kommende hendelser.  Tallet kan ikke være større enn 30. Dersom du angir et større tall, vil 30 bli brukt.<br /><br />Verdien du angir vil bestemme hvor mange dager fram i tid PhpGedView vil se etter kommende hendelser.  Resultatet av søket, som utføres kun en gang om dagen, vil lagres i en midlertidig fil.<br /><br />PS 1. Brukere kan ikke velge flere dager enn angitt her på sine personlige sider.<br /><br />PS 2. Dersom du har en stor slektsbase, vil det ta lengre tid å lage den daglige filen, jo flere dager du angir. Det vil også ta lengre tid å vise rammen, selv om du/brukere angir færre dager på hovedsiden/personlige sider.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]		= "Antall ganger et etternavn<br />må finnes for å vises i<br /><i>Mest brukte etternavn</i>";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "Dette er hvor mange ganger personer med samme etternavn må finnes før etternavnet vil vises i listen med \"Mest brukte etternavn\" på hovedsiden.";
$pgv_lang["COMMON_NAMES_ADD"]			= "Legg til følgende etternavn i listen <i>Mest brukte etternavn</i> (komma-separert)";
$pgv_lang["COMMON_NAMES_ADD_help"]		= "Dersom et bestemt etternavn ikke finnes nok ganger til å kunne bli vist i listen over de mest brukte etternavnene, kan den her bli lagt til manuelt. Dersom det legges inn flere navn må de skilles med et komma. Opptellingen skiller om etternavn er skrevet med forskjellige små-/store bokstaver.";
$pgv_lang["COMMON_NAMES_REMOVE"]		= "Fjern følgende etternavn i listen <i>Mest brukte etternavn</i> (komma-separert)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "Dersom du ønsker å fjerne et bestemt etternavn fra listen med \"Mest brukte etternavn\", kan du oppgi etternavnet her. Dersom det legges inn flere navn må de skilles med et komma. Opptellingen skiller om etternavn er skrevet med forskjellige små-/store bokstaver.";
$pgv_lang["HOME_SITE_URL"] 				= "URL til hjemmesiden din";
$pgv_lang["HOME_SITE_URL_help"] 		= "Denne URL er inkluderet i toppfeltet til stilen, og brukes til å lage en link til din hjemmeside.";
$pgv_lang["HOME_SITE_TEXT"] 			= "Tittelen på hjemmesiden din";
$pgv_lang["HOME_SITE_TEXT_help"] 		= "Teksten på linken, som viser til din hjemmeside.";
$pgv_lang["CONTACT_EMAIL"] 				= "Kontaktperson for slektsspørsmål";
$pgv_lang["CONTACT_EMAIL_help"] 		= "Den brukeren besøkende kan kontakt vedrørende slektsmateriale på nettstedet ditt.";
$pgv_lang["CONTACT_METHOD"] 			= "Kontaktmåte (slekt)";
$pgv_lang["CONTACT_METHOD_help"] 		= "Her velger du den måten besøkende kan få formidlet spørsmål til <b>#pgv_lang[CONTACT_EMAIL]#</b>.  Linken for kontakt vil bli vist nederst på hver side.<dl><dt>Du har følgende valg:</dt><dd><b>#pgv_lang[mailto]#</b>. Besøkende må ha et e-post-program tilgjengelig på sin egen maskin.</dd><dd><b>#pgv_lang[messaging]#</b>. Dette bruker beskjedsystemet som er innebygd i PhpGedView, og det sender ingen ekstern e-post.</dd><dd><b>#pgv_lang[messaging2]#</b>. Dette valget er standard og bruker beskjedsystemet som er innebygd i PhpGedView, men sender også kopi av beskjedene med e-post.</dd><dd><b>#pgv_lang[messaging3]#</b>. Dette valget bruker beskjedsystemet som er innebygd i PhpGedView, men sender beskjedene med e-post uten å ta en kopi til det interne systemet.</dd><dd><b>#pgv_lang[no_messaging]#</b>. Dette gjør at besøkende ikke kan kontakte deg.</dd></dl>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "PhpGedView svaradresse";
$pgv_lang["PHPGEDVIEW_EMAIL_help"]	= "~#pgv_lang[PHPGEDVIEW_EMAIL]#~<br /><br />Dette er epostadressen som brukes i &laquo;Fra:&raquo;-feltet i eposter som PhpGedView lager automatisk.<br /><br />PhpGedView kan automatisk generere eposter for å informere administrator om endringer som må gjennomgås og godkjennes.  PhpGedView sender også disse informasjonsepostene ttil brukere som har bedt om konto.<br /><br />Normal vil &laquo;Fra:&raquo;-feltet i disse automatisk genererte epostene vær noe slikt som <i>Fra: phpgedview-noreply@dittnettsted</i> for å vise at svar på eposten ikke er forventet eller nødvendig.  For å verne mot spam eller annen misbruk av epost, vil noen epostsystemer kreve at hver melddings &laquo;Fra:&raquo;-felt faktisk er en gyldig epostkonto og vil ikke godta meldinger som kommer fra <i>phpgedview-noreply</i>.<br />";
$pgv_lang["WEBMASTER_EMAIL"] 			= "Kontaktperson for teknisk hjelp";
$pgv_lang["WEBMASTER_EMAIL_help"] 		= "Den brukeren besøkende kan kontakt vedrørende tekniske spørsmål eller feil de er støtt på under besøket på din side.";
$pgv_lang["SUPPORT_METHOD"] 			= "Kontaktmåte (tekn.)";
$pgv_lang["SUPPORT_METHOD_help"] 		= "Her velger du den måten besøkende kan få formidlet spørsmål til <b>#pgv_lang[WEBMASTER_EMAIL]#</b> om nettstedet.  Linken for kontakt vil bli vist nederst på hver side.<dl><dt>Du har følgende valg:</dt><dd><b>#pgv_lang[mailto]#</b>. Besøkende må ha et e-post-program tilgjengelig på sin egen maskin.</dd><dd><b>#pgv_lang[messaging]#</b>. Dette bruker beskjedsystemet som er innebygd i PhpGedView, og det sender ingen ekstern e-post.</dd><dd><b>#pgv_lang[messaging2]#</b>. Dette valget er standard og bruker beskjedsystemet som er innebygd i PhpGedView, men sender også kopi av beskjedene med e-post.</dd><dd><b>#pgv_lang[messaging3]#</b>. Dette valget bruker beskjedsystemet som er innebygd i PhpGedView, men sender beskjedene med e-post uten å ta en kopi til det interne systemet.</dd><dd><b>#pgv_lang[no_messaging]#</b>. Dette gjør at besøkende ikke kan kontakte deg.</dd></dl>";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Vis faktaikoner";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Sett til <b>#pgv_lang[yes]#</b> for å vise ikoner ved siden av faktanavn på #pgv_lang[personal_facts]# siden.  Faktaikoner vil kun vises hvi de eksisterer i <i>images/facts</i>-katalogen som tilhører stilen som er i bruk.<br />";
$pgv_lang["FAVICON"] 					= "Mappe til favoritt-ikon";
$pgv_lang["FAVICON_help"] 				= "Angi en sti til det ikonet du vil vise i dine besøkenes \"Mine linker\" meny, når de legger inn din side inn i deres \"Mine linker\" meny.";
$pgv_lang["THEME_DIR"] 					= "Tema og mappe";
$pgv_lang["THEME_DIR_help"] 			= "Mappen der PhpGedView stil-filene dine er lagret.  Du kan endre og/eller tilpasse hvilken som helst av de standard stilene (layoutene) som er levert med PhpGedView, for å gi siden din et eget design.  Se Theme i endring-avsnittet i <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> filen for mer informasjon.";
$pgv_lang["TIME_LIMIT"] 				= "PHP tidsbegrensning";
$pgv_lang["TIME_LIMIT_help"] 			= "Den maksimale tid i sekunder, som PhpGedView får lov til å arbeide.  Som standard er den satt til 1 minutt.  Avhengig av størrelsen på din GEDCOM fil, kan du evt. øke denne tidsbegrensning når du har bruk for å indeksere.  Hvis denne verdi settes til 0, tillater du PHP å kjøre uendelig.<br />ADVARSEL: Hvis verdien settes til 0 eller settes for høyt, kan få siden din til å \"henge\" på visse operativsystemer inntil scriptet avsluttes.  Å sette verdien til 0 betyr at scriptet ikke avsluttes før en nettverksadministrator stopper prosessen eller gjenstarter serveren.  Det kan ta lang tid å lage et stort slektstre, så ved å sette denne verdi så lavt som muligt, kan det hindre at en eller annen får din webserver til å bryte sammen, ved å forsøke, å lage et 1000 generasjoners tre.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "Sti til katalogen hvor PhpGedViews logg-filer lagres. Det er ikke alle webhotell som har konfigureret deres PHP korrekt, og derfor kan logg-data gå tapt ved bytte av side. Denne innstillingen gjør det mulig for administratorer å kompensere for denne webhotel-feilen, ved heller å lagre loggfiler i en lokal mappe på deres egen side. Til det formålt er ./index/ katalogen et opplagt valg, dersom det er nødvendig å endre på denne stien. Som standard skal boksen være tom, for da vil innstillingene fra php.ini filen brukes. Boksen skal kun fylles ut, hvis logg-data går tapt.";
$pgv_lang["SERVER_URL_help"] 			= "Hvis du bruker https eller en annen port enn standard porten, må du legge inn URLen her for å få tilgang til serveren din.";
$pgv_lang["LOGIN_URL"]					= "Logg inn URL";
$pgv_lang["LOGIN_URL_help"]				= "Du trenger bare å angi en Logg inn URL dersom du ønsker å forflytte til en annet nettsted eller plassering når brukere logger inn.  Dette kan være nyttig for eksempel, dersom du ønsker å bytte fra http til https når brukerene dine logger inn.  Inkluder hele URLen til filen login.php (f.eks. https://www.dinserver.no/phpgedview/login.php).";
$pgv_lang["PGV_SESSION_TIME_help"] 		= "Tid i sekunder før PhpGedView krever at en pålogget bruker må logge seg på på nytt. Standard er 30 minutter.";
$pgv_lang["SHOW_STATS"] 				= "Vis utførings-statistikk";
$pgv_lang["SHOW_STATS_help"] 			= "Vis runtime-statistikk og antall database-forespørsler på bunnen av hver side.";
$pgv_lang["SHOW_COUNTER"]				= "Vis Antall treff";
$pgv_lang["SHOW_COUNTER_help"]			= "Vis teller med antall treff på hovedsiden og person-sider.";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "Gir besøkende mulighet til å registere seg for å få en konto på nettstedet.<br /><br />Søkeren vil motta en epost-beskjed med en kode for å bekrefte søknaden.<br />Søknaden må godkjendes av en administrator før kontoen blir aktiveret.";
$pgv_lang["ALLOW_USER_THEMES_help"]		= "Gir brukere mulighet for selv å velge deres egen stil.";
$pgv_lang["PGV_SIMPLE_MAIL_help"]		= "I det vanlige epost-hodet for eksterne epost-meldinger oppgis det epost-adresse og navn. Noen epost-systemer godtar ikke dette. Ved å velge \"Ja\", vil bare epost-adressen bli brukt.";
$pgv_lang["PGV_SMTP_ACTIVE_help"] = "~#pgv_lang[PGV_SMTP_ACTIVE]#~<br /><br />Bruk SMTP for å sende epost fra PhpGedView.<br /><br />Dette valget krever tilgang til en SMTP eposttjener.  Når den er satt til <b>#pgv_lang[no]#</b> vil PhpGedView bruke epostsystemet som er innebygget i PHP på denne tjeneren.<br />";
$pgv_lang["PGV_SMTP_HOST_help"] = "~#pgv_lang[PGV_SMTP_HOST]#~<br /><br />Dette er navnet på SMTP eposttjeneren.  Eksempel: <b>smtp.online.no</b>.<br />";
$pgv_lang["PGV_SMTP_HELO_help"] = "~#pgv_lang[PGV_SMTP_HELO]#~<br /><br />Dette er domenedelen av en gyldig epostadresse på SMTP-tjeneren.<br /><br />For eksempel, hvis du har en epostkonto som <b>yourname@abc.xyz.com</b>, skal du skrive inn <b>abc.xyz.com</b> her.<br />";
$pgv_lang["PGV_SMTP_PORT_help"] = "~#pgv_lang[PGV_SMTP_PORT]#~<br /><br />Portnummeret som skal benyttes for oppkoblinger til SMTP-tjeneren.  Normalt er dette port <b>25</b>.<br />";
$pgv_lang["PGV_SMTP_AUTH_help"] = "~#pgv_lang[PGV_SMTP_AUTH]#~<br /><br />Bruk navn og passord for å autentisere oppkobling til SMTP-tjener.<br /><br />De fleste SMTP-tjenere  krever at alle oppkoblinger blir autentisert før de vil godta utgående eposter.<br />";
$pgv_lang["PGV_SMTP_AUTH_USER_help"] = "~#pgv_lang[PGV_SMTP_AUTH_USER]#~<br /><br />Brukernavnet som kreves for autentisering på SMTP-tjeneren.<br />";
$pgv_lang["PGV_SMTP_AUTH_PASS_help"] = "~#pgv_lang[PGV_SMTP_AUTH_PASS]#~<br /><br />Passordet for autentisering på SMTP-tjeneren.<br />";
$pgv_lang["PGV_SMTP_FROM_NAME_help"] = "~#pgv_lang[PGV_SMTP_FROM_NAME]#~<br /><br />Skriv navnet som skal brukes i &laquo;Fra:&raquo;-feltet i eposter fra dette nettstedet.<br /><br />For eksempel, hvis du heter <b>Svere Hansen</b> og du er administrator for nettstedet kjent som <b>Sverres slektstre</b>, kan du skrive inn <b>Sverre Hansen</b> eller <b>Sverres slektstre</b> eller til og med <b>Sverre Hansen, Administrator for Sverres slektstre</b>.  Du kan skrive inn hva du vil, men HTML er ikke tillatt.<br />";
$pgv_lang["gedcom_title"]				= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]			= "Tast inn en tittel, som beskriver innholdet i denne GEDCOM-filen. Denne vil besøkende kunne se når de skal velge slektsbase.";
$pgv_lang["LOGFILE_CREATE"]				= "Arkiver logfiler";
$pgv_lang["LOGFILE_CREATE_help"] 		= "Hvor ofte skal programmet arkivere loggfiler.";
$pgv_lang["PGV_MEMORY_LIMIT_help"]		= "Det maksimale minneforbruket som kan bli benyttet av PhpGedView skript.  Standard er 16M.  Mange verter slår dette valget av i sine PHP konfigurasjoner, så å endre denne verdien behøver nødvendigvis ikke bety noe for den maksiale minne-oppsettet.";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "Angi om beskjeder som er sendt via PhpGedView kan lagres i databasen.  Dersom du velger 'Ja', så vil brukere kunne få beskjedene deres når de logger seg inn i PGV.  Hvis 'Nei', så vil beskjedene bare bli sendt med vanlig epost.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Vis valgfelt for å bytte Stil";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "Gir brukere mulighet til å velge deres eget utseende (Stil).<br />fra en \"slipp-ned\"-meny (hvis klargjort i Stilen)<br />Trenger også at ALLOW_USER_THEMES er satt til Ja";
$pgv_lang["MAX_VIEW_RATE"]		= "Maks antall sider å vise";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Dette valget begrenser hvor ofte en bruker be om en side.<br /><br />Hvis verdien overstiges, vil PhpGedView behandle sesjonen som et hackingforsøk;  sesjonen vil bli terminert med en massende melding.  Disse to verdiene bør gi en fornuftig begrensning på båndbredde og nedlastede bytes fra serveren.  Denne funksjonaliteten kan skrues av ved å sette tidsintervallet til 0.<br />";
$pgv_lang["META_AUTHOR"]				= "META tag: Forfatter";
$pgv_lang["META_AUTHOR_help"]			= "Her kan du angi navnet på hovedansvarlig for nettsiden som vil plasseres i <meta> merket først på HTML siden.  Dersom feltet er tomt, vil det fulle navnet til slektsbasens kontaktperson bli brukt.";
$pgv_lang["META_AUTHOR_descr"]			= "La feltet være tomt for å bruke det fulle navnet til slektsbasens kontaktperson.";
$pgv_lang["META_PUBLISHER"]				= "META tag: Utgiver";
$pgv_lang["META_PUBLISHER_help"]		= "Her kan du angi navnet på utgiveren for nettsiden som vil plasseres i <meta> merket først på HTML siden.  Dersom feltet er tomt, vil det fulle navnet til slektsbasens kontaktperson bli brukt.";
$pgv_lang["META_PUBLISHER_descr"]		= "La feltet være tomt for å bruke det fulle navnet til slektsbasens kontaktperson.";
$pgv_lang["META_COPYRIGHT"]				= "META tag: Opphavsrett";
$pgv_lang["META_COPYRIGHT_help"]		= "Her kan du angi opphavsretten til nettsiden som vil plasseres i <meta> merket først på HTML siden.  Dersom feltet er tomt, vil det fulle navnet til slektsbasens kontaktperson bli brukt.";
$pgv_lang["META_COPYRIGHT_descr"]		= "La feltet være tomt for å bruke det fulle navnet til slektsbasens kontaktperson.";
$pgv_lang["META_DESCRIPTION"]			= "META tag: Beskrivelse";
$pgv_lang["META_DESCRIPTION_help"]		= "Her kan du angi en beskrivelse av nettstedet som vil plasseres i <meta> merket først på HTML siden.  Dersom feltet er tomt, vil titlen til den aktive slektsbasen bli brukt.";
$pgv_lang["META_DESCRIPTION_descr"]		= "La feltet være tomt for å bruke titlen til den aktive slektsbasen.";
$pgv_lang["META_PAGE_TOPIC"]			= "META tag: Sjanger (topic)";
$pgv_lang["META_PAGE_TOPIC_help"]		= "Her kan du angi en sjanger nettstedet hører inn under og som vil plasseres i <meta> merket først på HTML siden.  Dersom feltet er tomt, vil titlen til den aktive slektsbasen bli brukt.";
$pgv_lang["META_PAGE_TOPIC_descr"]		= "La feltet være tomt for å bruke titlen til den aktive slektsbasen.";
$pgv_lang["META_AUDIENCE"]				= "META tag: Målgruppe";
$pgv_lang["META_AUDIENCE_help"]			= "Her kan du angi en målgruppe som nettstedet retter seg mot og som vil plasseres i <meta> merket først på HTML siden.";
$pgv_lang["META_PAGE_TYPE"]				= "META tag: Type side";
$pgv_lang["META_PAGE_TYPE_help"]		= "Her kan du angi type side som vil plasseres i <meta> merket først på HTML siden.";
$pgv_lang["META_ROBOTS"]				= "META tag: Roboter";
$pgv_lang["META_ROBOTS_help"]			= "Her kan du angi roboter som vil plasseres i <meta> merket først på HTML siden.  Mange roboter eller nettsøkere/-snoker sjekker ikke denne verdien.";
$pgv_lang["META_REVISIT"]				= "META tag: Hvor ofte bør/skal søkeroboter sjekke nettstedet";
$pgv_lang["META_REVISIT_help"]			= "Her kan du angi hvor ofte du ønsker at nettstedet skal oppdateres av søkeroboter som vil plasseres i <meta> merket først på HTML siden.  Mange roboter eller nettsøkere/-snoker sjekker ikke denne verdien.";
$pgv_lang["META_KEYWORDS"]				= "META tag: Nøkkelord";
$pgv_lang["META_KEYWORDS_help"]			= "Her kan du angi nøkkelord som vil plasseres i <meta> merket først på HTML siden.  Mange søkeroboter vil bruke disse nøkkelordene for å kunne indeksere sidene dine.  I tillegg til det du angir her, vil også De mest brukte etternavnene som blir vist i rammen Statistikk på hovedsiden, bli vist.";
$pgv_lang["META_SURNAME_KEYWORDS"]		= "Legg til Mest brukte etternavn til nøkkelord META feltet";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "Dersom du velger <b>Ja</b> på dette valget vil etternavnene fra listen #pgv_lang[common_surnames]# bli lagt til som nøkkelord i meta-feltet.  Dette kan hjelpe søkemaskiner slik at de lettere kan finne siden din.";
$pgv_lang["META_TITLE"]					= "META tag: Tillegg i Tittel";
$pgv_lang["META_TITLE_help"]			= "Her kan du angi et tillegg til den ordinære tittelen i <meta> merket først på HTML siden.  Tillegget vil bli plassert etter standardtittelen og før PhpGedView navnet.";

$pgv_lang["ENABLE_RSS"]				= "Aktiver RSS";
$pgv_lang["ENABLE_RSS_help"]		= "~#pgv_lang[ENABLE_RSS]#~<br /><br />Dette valget lar deg deaktiver RSS-funksjonaliteten.<br /><br />RSS lar brukere overvåke webstedet ditt for endringer på Index-siden uten faktisk å besøke siden regelmessig.  Dersom for mange brukere benytter denne funksjonaliteten eller hvis oppfriskningsfrekvensen som er satt av disse brukerne er for høy, kan RSS bruke opp for mye båndbredde eller tjenerkapasitet.<br /><br />Denne <a href='http://en.wikipedia.org/wiki/RSS' target='_blank' title='Wikipedia article'><b>Wikipediaartikkelen</b></a> inneholder betydelig informasjon og lenker om RSS og de ulike RSS-formatene.<br />";
$pgv_lang["RSS_FORMAT"]				= "Format for RSS";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Formatet til RSS som skal brukes som standard for dette nettstedet. Nummeret på slutten er <u>ikke</u> versjonsnummere, men beskriver formatene.  For eksempel er RSS 2.0 ikke nyere enn RSS 1.0, men et annet format. RSS-lesere bør kunne lese alle formatene. Det er per i dag ikke forskjell på ATOM og ATOM 0.3, fordi begge bruker ATOM 0.3 spesifikasjonen.";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Sjekk om GEDCOM-filer er nedlastbare";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE_help"] = "~#pgv_lang[SECURITY_CHECK_GEDCOM_DOWNLOADABLE]#~<br /><br />Av sikkerhetsårsaker, bør ikke GEDCOM-filer plasseres på webtjeneren på en plassering som tillater direkte tilgang og nedlasting, og på den måten omgå personvernkontroller. Dersom du klikker på denne lenken vil systemet sjekke om dine GEDCOM-filer kan lastes ned over internett.<br /><br />På noen systemer er denne sjekken kjent for å ta lang tid eller eventuelt ikke fullfør i det hele tatt.  Hvis dette er tilfelle for deg,  bør du forsøke å peke din nettleser direkte på din GEDCOM-fil for å se om den kan lastes ned.<br />";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# kan ikke lastes ned.";

$pgv_lang["welcome_new2"]				= "Ettersom du kan se denne siden, har du lykkes med å installere PhpGedView på nettstedet ditt,<br />og kan nå fortsette med å konfigurere PhpGedView etter dine ønsker.";
$pgv_lang["welcome_new_help"]			= "Dette hjelpevinduet kan hjelpe deg gjennom prosessen med å konfigurere PhpGedView. Ved inntasting/valg av de forskjellige felt, vil dette vinduet inneholde opplysninger om det gjeldende felt. Du kan lukke dette vinduet dersom du ønsker det. For å åpne det igjen, kan du klikke på en av \"?\" spørsmålstegnene ut for det gjeldende felt.";
$pgv_lang["return_editconfig"]			= "Du kan gå tilbake til denne siden for konfigurasjon ved å klikke på linken <b>Program-innstillinger</b> på siden for <b>Administrasjon</b>,<br />eller ved å angi filen configure.php i adresselinjen i nettleseren din.";
$pgv_lang["return_editconfig_gedcom"]	= "Du kan gå tilbake til denne siden for konfigurasjon ved å klikke på linken <b>Endre</b> i tabellen <b>Aktive slektsfiler (GED)</b><br />på siden for administrasjon av <b>Slektsfil(er) og personvern</b>, eller ved å angi filen editconfig_gedcom.php i adresselinjen i nettleseren din.";
$pgv_lang["save_config"] 				= "Lagre konfigurasjon";
$pgv_lang["download_gedconf"]			= "Last ned (download) GEDCOM konfigurasjon.";
$pgv_lang["not_writable"]				= "Det har vist seg at PHP ikke kan skrive til konfigurasjonsfilen. Du kan derfor bruke \"Last ned\"-knappen til lagre innstillingene dine i en fil, som du etterpå henter (upload) manuelt.";
$pgv_lang["upload_to_index"]			= "Hent (upload) filen til din index-katalog:";
$pgv_lang["import_sql"]					= "SQL-filer er funnet i katalogen index. Siden det er sannsynlig at de stammer fra Overførings-verktøyet, kan du velge å importere informasjonen inn i databasen din. Ønsker du å importere disse filen inn i databasen nå?<br />NB! All eksisterende bruker-relaterte informasjon (brukere, nyheter, favoritter, oppsett for rammer og beskjeder) vil bli overskrevet!<br /><br />Dersom du ønsker å fortsette, vil PhpGedView prøve å importere dataene. Dersom det skulle vise seg å ikke gå, så vil du uansett få valget om å opprette den første administrator-kontoen.";

//-- edit privacy messages
$pgv_lang["edit_privacy"]				= "Endre personvernfilen";
$pgv_lang["edit_privacy_title"]			= "Endre slektsbasens personvern-innstillinger";
$pgv_lang["save_changed_settings"]		= "Lagre endringer";
$pgv_lang["add_new_pp_setting"]			= "Legg til ny personvern-innstilling for person";
$pgv_lang["add_new_up_setting"]			= "Legg til ny personvern-innstilling for bruker";
$pgv_lang["add_new_gf_setting"]			= "Legg til ny personvern-innstilling for generelle fakta";
$pgv_lang["add_new_pf_setting"]			= "Legg til ny personvern-innstilling for fakta";
$pgv_lang["file_read_error"]			= "F E I L !!! Personvernfilen kunne ikke leses!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Rediger eksisterende innstillinger for personer";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Rediger eksisterende innstillinger for bruker";
$pgv_lang["edit_exist_global_facts_settings"]	= "Rediger eksisterende innstillinger for generelle fakta";
$pgv_lang["edit_exist_person_facts_settings"]	= "Rediger eksisterende innstillinger for fakta knyttet til personer";
$pgv_lang["general_privacy"]			= "Standard innstillinger for personvern";
$pgv_lang["general_privacy_help"]		= "~<b>#pgv_lang[general_settings]#</b>~<br />Disse innstillingene vil være dine standard-innstillinger for den valgte slektsbasen.<br />Sjekk under tittelen på siden om du redigerer rett slektsbase (GEDCOM).<br /><br />Dette betyr også at for hver slektsbase (hvis du har flere enn en) du har i programmet, kan du ha forskjellige innstillinger.<br /><br />Du kan overstyre disse standard-innstillingene ved å bruke andre personvern-oppsett på #pgv_lang[edit_privacy_title]#-siden.<br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy"]				= "Personvern-innstillinger for personer";
$pgv_lang["person_privacy_help"]		= "~<b>#pgv_lang[person_privacy_settings]#~</b><br />Disse innstillingen gir administratorer mulighet for å endre personverns-innstillingen for en bestemt person i GEDCOMfilen. La oss si du f.eks. har et barn som døde som spedbarn. Normalt vil alle kunne se alle fakta, fordi barnet er dødt. Men, for deg og familien er disse opplysningene fremdeles private. Du vil ikke fjerne dødsoppføringen, men du vil skjule opplysningene og gjøre dem private. Hvis dette barn har ID I100 skal du sette inn følgende personverninnstilling: <br /><br />ID: I100<br />Vis til:\"Vis kun til godkjente brukere\"<br /><br />Dette virker også den andre veien. Hvis du vil vise alle opplysninger om en person (ID 101) som du vet er død, men som ikke er registreret som død, kan du legge til følgende:<br /><br />ID: I101<br />Vis til: \"Vis til alle\"";
$pgv_lang["user_privacy"]				= "Personvern-innstillinger for brukere";
$pgv_lang["user_privacy_help"]			= "~<b>#pgv_lang[user_privacy_settings]#~</b><br />Disse innstillingene gir administratorer mulighet til å omgå den normale personverninnstillingen for en person i slektsbasen baseret på en brukers brukernavn.<br /><br />Så hvis du ikke vil at brukernavnet \"John\" kan se dine private opplysninger, og du har ID I100 i slektsbasen, kan du gjøre slik:<br /><br />Brukernavn: John<br />ID: I100<br />Vis?: \"Skjul\"<br /><br />Etterpå vil dataene dine kun være skjult for brukerennavnet \"John\".<br /><br />For å vise I101's data (som normalt vil være skjult fordi I101 er nålevende) til brukernavnet \"John\" skal du velge:<br /><br />Brukernavn: John<br />ID: I101<br />Vis?: \"Vis\"";
$pgv_lang["global_facts"]				= "Personvern-innstillinger for generelle fakta";
$pgv_lang["global_facts_help"]			= "~<b>#pgv_lang[global_facts_settings]#~</b><br />Disse innstillingen definerer fakta, som på generelt skal skjules hos alle personer i slektsbasen.<br /><br />[\"Navn på fakta\"] valget bestemmer hvilke fakta som skal skjules. [\"Valg\"] valget bestemmer en fakta eller tilhørende opplysninger. [\"Vis til\"] valget bestemmer på hvilket adgangsnivå fakta vises.<br /><br />Den generelle fakta-tabellen er beregnet til - på basis av GEDCOM merker (tags) - å skjule visse fakta for alle personer, enten disse er nålevende eller døde. SSN tag er som standard skjult for vanlige besøkende. Dette forhindrer folk i å stjele personnummer og dermed stjele identiteten til dine døde, som egentlig er mest relevant for USA's vedkommende.<br />Hvis du vil skjule alle ekteskapsdata i slektsbasen din for vanlige besøkende, kan du velge:<br /><br />Navn på fakta: (MARR) - Ekteskap (Marriage)<br />Valg: \"Vis fakta\"<br />Vis til?: \"Vis kun til godkjente brukere\".<br /><br />Navn p fakta: (MARR) - Ekteskap<br />Valg: \"Vis faktaopplysninger\"<br />Vis til ?: \"Vis bare til godkjente brukere\"<br /><br />Disse innstillingene vil skjule ekteskap (og tilhørende opplysninger) til alle som ikke har rettigheter til å administrere.<br /><br />Til forskjell fra alle andre innstillinger, i \"generelle fakta\" kan du skjule fakta til og med for brukere med admin-rettigheter. Dette kan undertrykke uønskede fakta-opplysninger fullstendig.";
$pgv_lang["person_facts"]				= "Personvern-innstillinger for personlige Fakta";
$pgv_lang["person_facts_help"]			= "~<b>#pgv_lang[person_facts_settings]#~</b><br />Disse innstillingene definer fakta som skjules for en spesifik person i slektsbasen, samt på hvilket nivå disse fakta skal skjules.<br /><br />Det første valget er Id til personen, det neste valget er data.<br />[\"Valg\"] velger data eller tilhørende opplysninger. Valget [\"Vis til\"] bestemmer på hvilket adgangsnivå disse data skal vises.<br /><br />\"Fakta for personer\"-tabellen fungerer på samme måte som \"generelle fakta\"-tabellen med unntak av at du også kan angi ID til den personen hvor data skal skjules. Du kan altså skjule ekteskapsfeltet til en bestemt person.";
$pgv_lang["accessible_by"]				= "Vis til ?";
$pgv_lang["hide"]						= "Skjul";
$pgv_lang["show_question"]				= "Vis ?";
$pgv_lang["user_name"]					= "Brukernavn";
$pgv_lang["name_of_fact"]				= "Navn på fakta";
$pgv_lang["choice"]						= "Valg";
$pgv_lang["fact_show"]					= "Vis fakta";
$pgv_lang["fact_details"]				= "Vis detaljerte fakta";
$pgv_lang["privacy_header"]				= "Rediger personvern-innstillinger innenfra";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan ikke finne person med ID ";
$pgv_lang["save_and_import"]			= "Etter at du har lagret denne GEDCOM konfigurasjon er det nødvendigt å importere GEDCOM ved å klikke på knappen <b>Importer GEDCOM</b> eller fra <b>Administrasjon->Slektsfil(er) og personvern->Importer GEDCOM</b>";
$pgv_lang["help_info"]					= "Du kan få hjelp i hver enhet ved å klikke på det røde \"?\" ved ledeteksten ut for hvert felt.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Vis navn til nålevende";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~Vis navn til nålevende~<br /><br />Skal navn til nålevende personer vises til alle?";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Vis forsknings-logg";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]		= "Hvilke brukere som skal få se på forningsloggene dersom de er installert?";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]	= "Bruk personvern på slektskap";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~Bruk relasjonsbetinget personvernfil~<br /><br />'<b>Nei</b>' betyr at godkjente brukere kan se alle opplysninger til nålevende personer.<br />'<b>Ja</b>' betyr at brukere kan kun se privat informasjon om nålevende personer de er i slekt med.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]	= "Maks steglengde for slektskap";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~Maks steglengde for slektskap~<br /><br />Dersom <b>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</b> er aktiv, vil brukere som er logget inn bare kunne se og endre personer innenfor disse stegene for grad av slektskap.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]	= "Sjekk ekteskapsbånd";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~Sjekk ekteskapsbånd~<br /><br />Sjekk slektninger gjennom ekteskapsrelasjoner.";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Vis døde personer";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~Vis døde personer~<br /><br />Setter nivået for personvern for alle døde personer.";
$pgv_lang["select_privacyfile_button"]	= "Velg personvern-fil";
$pgv_lang["PRIVACY_BY_YEAR"]			= "Begrens personvern utfra dato i hendelse";
$pgv_lang["PRIVACY_BY_YEAR_help"]		= "Innstillingen for <i>Begrens personvern utfra dato i hendelse</i> vil skjule faktaopplysninger til personer basert på hvor gammel de var da hendelsen skjedde uavhengig av om de lever eller er døde.  Bruk denne  sammen med innstillingen \"#pgv_lang[MAX_ALIVE_AGE]#\".<br /><br />Eksempel: Dersom du setter alderen til å være 100 og aktiverer denne innstilling ved å angi \"Ja\", så vil alle personer, levende eller døde, som er født mindre enn for 100 år siden, bli vist som Privat.<br />Personer som ble gift mindre enn for 85 år siden, og personer som døde for mindre enn 75 år siden, vil også bli vist som Privat.<br /><br /><b>NB!</b>  <i>Vær oppmerksom på at dersom du aktiviserer denne innstillingen, så vil tiden det tar å vise en side øke noe.</i>";

// Google Translate
$pgv_lang["google_translate"]	= "Google&reg; Oversetter";
$pgv_lang["commit"]				= "Bruk";
$pgv_lang["commit_google"]		= "Bruk Google&reg; oversatte endringer";
$pgv_lang["commit_google_help"]	= "~#pgv_lang[commit_google]#~<br /><br />Når du klikker på denne lenken, vil alle akkumulerte oversettelser som er gjennomført med Google&reg; Oversetter-systemer som ikke allerede er lagret bli lagret.<br /><br />Indikatoren viser framdriften på lagreprosessen.<br /><br />";
$pgv_lang["google_translate_help"]	= "~#pgv_lang[google_translate]#~<br /><br />Dette verktøyet bruker Google&reg; Oversetter som en hjelp for oversetteren.  Den er <b>ikke</b> ment å erstatte oversetelser gjort av en person som fult ut forstår kilden and mål-språket.    Vær også oppmerksom på at Google&reg; oversetterverktøy verken er til å stole på eller alltid i stand til å utføre en oversettelse.<br /><br />Når en språktekst ellere er oversatt, vil det ikke være noen lenke til Google&reg; Oversetter.<br /><br />For hver tekst du ønsker å bruke Google&reg; Oversetter på, må du klikke <b>#pgv_lang[google_translate]#</b> lenken.  Etter at siden er lastet på nytt, bør du korrigere feiloversettelser for hånd. <b>Det er ingen garanti for at Google&reg; Oversetter er korrekt.</b> Du må korrigere spesialtegn som #, <, >, / og HTML-tagger og likeledes referanser til andre språk- eller globale variable i den oversatte teksten så resultatet matcher den originale uoversatte teksten.  Merk at Google&reg; Oversetter vil legge til et mellomrom etter hver HTML-tag.  Du må absolutt fjerne disse ekstra mellomrommene.<br /><br />Når du er fornøyd med resultatet, klikk <b>#pgv_lang[commit]#</b> for å lagre resultatet.  Hvis du ikke klikker <b>#pgv_lang[commit]#</b>, vil endringen blir akkumulert til du kilkker <b>#pgv_lang[commit_google]#</b> lenken på bunnen av siden for å effektuere alle lagrede tekster på en gang.<br /><br />";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Denne siden er først og fremst for oversettere.  Her kan du oversette, sammenligne og eksportere språkfiler.  Det er også et valg for å hjelpe oversettere for å sjekke tekst som PhpGedView lager.";
$pgv_lang["edit_langdiff"]				= "Språk / oversettelser";
$pgv_lang["bom_check"]					= "Sjekk av språkfilene (BOM)";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#";
$pgv_lang["bom_check_desc"]				= "Dette valget vil sjekke alle språkfilene om koden BOM (Byte Order Mark) finnes i filene. Disse tegnene som noen tekstbehandlere legger skjult i begynnelsen av filen, vil gjøre at PHP vise en feilmelding på toppen av hver side...<br />Dersom koden blir funnet, vil den bli fjernet.";
$pgv_lang["lang_debug"]					= "Feilsøking-informasjon i hjelptekster";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#";
$pgv_lang["lang_debug_desc"]			= "Når du aktivert dette valget, vil navnene til språk-variablene brukt i hjelpeteksten vises sammen med teksten i hjelpeviduet.<br />Dette kan hjelpe oversettere å finne det rette variabel-navnet som skal endres.<br /><br />Denne innstillingen vil ikke være aktivert neste gang du logger deg inn i PhpGedView.";
$pgv_lang["lang_debug_use"]				= "Bruk valget Feilsøking-informasjon i hjelpetekster";
$pgv_lang["bom_not_found"]				= "Ingen BOM koder ble funnet.";
$pgv_lang["bom_found"]					= "BOM koden ble funnet i ";
$pgv_lang["edit_lang_utility"]			= "Endre språk-fil";
$pgv_lang["edit_lang_utility_help"]	= "~#pgv_lang[edit_lang_utility]#~<br /><br />#pgv_lang[edit_lang_utility_desc]#";
$pgv_lang["edit_lang_utility_desc"]		= "Her kan du endre innholdet av en språk-fil ved å bruke den engelske teksten som referanse.<br />Innholdet av den originale engelske språk-filen vil bli listet opp sammen med teksten i ditt valgte språk.<br />Ved å klikke på en tekst i språkfilen din, vil et nytt vindu åpnes der du kan gjøre endringer i teksten.";
$pgv_lang["edit_lang_utility_warning"]	= "NB!<br />Dersom du velger å bruke knappen \"#close_window_without_refresh#\", skal du være oppmerksom på at du ikke vil se endringene med en gang på skjermen i språk-redigeringen før du manuelt trykker på knappen \"Last inn siden på nytt\".<br />Det kan også hende at språkfilen din kan bli ødelagt dersom du legger til en beskjed som ikke har vært i språkfilen fra før eller dersom du endrer den samme beskjeden på nytt.<br /><br /><b>Konklusjon:</b> Dersom du ikke er sikker på at du gjør rett, vennligst ikke bruk knappen \"#close_window_without_refresh#\".";
$pgv_lang["language_to_edit"]			= "Språk som skal endre";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />I denne listen velget du det språket der du ønsker å endre språlinjer.";
$pgv_lang["file_to_edit"]				= "Språkfil som skal endres";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />PhpGedView har support for mange forskjellige språk.  Dette er mulig fordi all tekst er lagret i egne filer.  Hvert språk har fire forskjellige filer utfra hvor teksten brukes og hvilken funksjon den har.  Dersom det er lagt til en tekst som enda ikke er oversatt, vil den engelske teksten bli vist.<br /><br />Filene i hvert språksett er:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder ledetekster, tekst for ulike valg og hjelpetekster for bruk under konfigureringen av PhpGedView.  Hjelpeteksten er ikke lagd for å vises for vanlige brukere.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dette er en liste med alle land i verden, hentet fra listen med betegnelsen ISO 3166-1.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder tekst i henhold til faktakoder i GEDCOM 5.5.1 standard.  Den inneholder også i tillegg faktakoder som ikke finnes i standarden, men som er brukt av ulike slektsprogram.<br /><br />En engelsk kopi av <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank><b>GEDCOM 5.5.1 Standard</b></a> kan hentes i PDF (Portable Document Format).</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder hjelpetekster for vanlige brukere.  Noen av emnene i denne filen er spesielt tilrettelagt for sdministratorer og er skjult for brukere som ikke har rettigheter som administrator.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder ord og uttrykk brukt i menyer, diagram, lister, rapporter og andre sider for vanlige bruk av PhpGedView.</li></ul>";
$pgv_lang["lang_file_descriptions"]		= "PhpGedView har implementert støtte for mange ulike språk.  Dette er gjort ved å lagre all tekst som er synlig for brukerne i filer som er fullstendig adskilt fra hovedprogrammet.  Det er et sett på åtte filer for hvert støttet språk og de ulike tekstene er plassert i en av disse filene ihht sin funksjon.  <b>Ikke alle språkfiler behøver å være tilstede.</b>  Hvis en gitt tekst enda ikke er tilgjengelig i oversatt form, vil PhpGedView alltid bruke den engelske versjonen.<br /><br />Filene i hvert språksett er:<br /><ul><li><b><i>admin.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder setninger og vanlige uttrykk for bruk ved administrasjon av PhpGedView og genealogidatabasene.<br /><br /></li><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder Helpetekster for bruk under konfigurering av PhpGedView.  Denne hjelpeteksten er ikke ment å bli sett av vanlige brukere.<br /><br /></li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dette er en liste over landnavn, tatt fra Statistikkontoret til FNs avdeling for økonomisk og sosialt arbeid.  Dette er den relevante <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a> engelske listen.  Denne listen er tilgjengelig på engelsk og fransk.<br /><br /></li><li><b><i>editor.xx.php</i></b>&nbsp;&nbsp;Denne fila inneholder setninger og vanlig uttrykk for bruk ved redigering av poster i slektsdatabasen.<br /><br /></li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder tekstversjonen av GEDCOM faktakoder som finnes i GEDCOM 5.5.1 Standarden.  Den inneholder også ytterligere faktakoder som ikke fnnes i standarden men som benyttes av ulike slektsprogrammer.<br /><br />En kopi på engelsk av <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standard</b></a> kan lastes ned i PDF (Portable Document Format).<br /><br /></li><li><b><i>faqlist.xx.php</i></b>&nbsp;&nbsp;Denne filen er et sett med <b>O</b>fte <b>S</b>tilte <b>s</b>pørsmål som er samlet inn av PhpGedViews utviklerteam .  Hver OSS har to oppføringer i denne filen.  En oppføring er OSS overskriften (Normalt spørsmålet), og den andre er OSS-elementet (normalt svaret).  En erstatning for <b><i>faqlist.xx.php</i></b> filen, som blir oppdatert jevnlig, kan lastes ned fra hjemmesiden til PhpGedView.<br /><br />Administratoren kan bruke OSSer i denne filen til å bygge en egen OSS-liste som er spesifikk til dennes nettsted.<br /><br /></li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder hjelptekster for vanlige brukere.  Noen hjelpetekst-emner i denne filen ivaretar en administrators behov, og er skjult for brukere som ikke har administrator-rettigheter.<br /><br /></li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Mange tekster og vanlige uttrykk finnes i denne filen.</li></ul><br />PhpGedView støtter også en valgfri niende fil, <b><i>extra.xx.php</i></b>.  Denne filen lastes alltid etter alle de andre og tilbyr en administrator en metode for å erstatte eller endre alle standardtekster i et valgt språk.  Den kan også brukes til å lage en alternativ tittel for slektsdatabasene som varierer med det aktive språket.<br /><br />Innholdet i disse tilleggsfilene bestemmes helt og holdent av administratoren for nettstedet;  denne filen vil <b>aldri</b> bli distribuert med noen versjon av PhpGedView.  Administratoren bør aldri gjøre endringer i de standard språkfilene;  alle lokale endringer bør konsentreres i denne valgfrie filen.<br />";
$pgv_lang["check"]						= "Sjekk";
$pgv_lang["lang_save"]					= "Lagre";
$pgv_lang["contents"]					= "Innhold";
$pgv_lang["listing"]					= "Vis liste";
$pgv_lang["no_content"]					= "Ikke noe innhold";
$pgv_lang["editlang"]					= "Endre";
$pgv_lang["editlang_help"]				= "Endre tekst/beskjed fra språk-fil";
$pgv_lang["savelang"]					= "Lagre";
$pgv_lang["savelang_help"]				= "Lagre endret tekst";
$pgv_lang["original_message"]			= "Original tekst";
$pgv_lang["message_to_edit"]			= "Tekst som skal endres";
$pgv_lang["changed_message"]			= "Endre innhold";
$pgv_lang["message_empty_warning"]		= "-> Advarsel!!! Dette beskjedfeltet er tomt [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"]			= "Eksportere språk";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />Her kan du velge det språket som skal brukes for å lage en dokumentasjon fra.<br /><br />Det er bare innholdet i filen <i>configure_help_xx.php</i> som eksporteres.  Det lages en fil (i HTML-format) som du kan se på og/eller skrive ut i nettleseren din.";
$pgv_lang["export_lang_utility"]		= "Eksport av språk-fil";
$pgv_lang["export"]						= "Eksporter";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />#pgv_lang[export_lang_utility_desc]#";
$pgv_lang["export_lang_utility_desc"]	= "Her kan du velge et språk og eksportere innholdet i hjelpe-tekst for konfigurasjon av PhpGedView<br />for å lage en dokumentasjon (i HTML-format) for programmet på det valgte språket.";
$pgv_lang["export_ok"]					= "Hjelpetekstene er eksportert";
$pgv_lang["compare_lang_utility"]		= "Sammenligne språk-filer";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />#pgv_lang[compare_lang_utility_desc]#";
$pgv_lang["compare_lang_utility_desc"]	= "Her kan du sammenligne to språk og få en liste med hva som er forskjellen mellom de ulike språk-filene.<br /><br />Se filen [<a href=\"languages\/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>] for andre endringer av språk-filer. Den engelske språkfilene er originalspråket og oversettelser må ta utgangspunkt i disse.";
$pgv_lang["new_language"]				= "Språk i kildefilene";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />Her kan du velge det språket som skal være utgangspunktet for å sammenligne mot et annet språk.<br /><br />Alle endringer og tillegg i språkfilene er først gjort i de <b>engelske</b> språkfilene, slik at til vanlig vil engelsk være valget her.";
$pgv_lang["old_language"]				= "Språk i de andre";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />Her kan du velge det språket som skal sammenlignes med valgt kildespråk.<br /><br />Etterpå klikker du på knappen <b>Sammenlign</b> for å se tillegg og/eller fjernede språklinjer i alle fire språkfilene.<ul><li><b>Tillegg</b> betyr at linjen bare finnes i kildefilen.</li><li><b>Fjernet (ikke i bruk lengre)</b> betyr at linjen ikke finnes i kildefilen lengre fordi den ikke brukes i denne versjonen av PhpGedView.";
$pgv_lang["compare"]					= "Sammenlign";
$pgv_lang["comparing"]					= "Språk-filene som er sammenlignet";
$pgv_lang["additions"]					= "Tillegg";
$pgv_lang["no_additions"]				= "Ikke noen tillegg";
$pgv_lang["subtractions"]				= "Fjernet (ikke i bruk lenger)";
$pgv_lang["no_subtractions"]			= "Ingen fjernet";
$pgv_lang["config_lang_utility"]		= "Støttede språk";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Her kan du bestemme hvilke <i><b>språk som skal være valgbare</b> (aktive).</i><br />Du kan for eksempel velge at engelsk og tysk språk skal være valgbare i tillegg til norsk.<br />Dette <i>kan</i> være nyttig dersom du for eksempel ikke kan kommunisere med brukere fra Frankrike.<br /><br />Du kan også endre andre innstillinger som har med egenarten til det enkelte språket, for eksempel, hvordan datoer skal vises.<br /><br />Språk som er aktive og har en grå farge, kan ikke deaktiveres fordi de er i bruk. Se nederst hvilke språk som er i bruk. Når et språk ikke er i bruk av en slektsbase eller en bruker, kan du deaktivere den.<br /><br />Alle innstillinger for språk lagres i en fil med navn <b>lang_settings.php</b> og som lagres i mappen <b>#INDEX_DIRECTORY#</b>.  Har du fått problemer i forhold til språk, så kan du få tilbake standardoppsettet ved å slette denne filen.";
$pgv_lang["active"]						= "Aktiv";
$pgv_lang["active_help"]				= "Gir deg mulighet til å velg om brukere skal kunne endre innholde av språkfilene.";
$pgv_lang["edit_settings"]				= "Endre innstillinger";
$pgv_lang["lang_edit"]					= "Endre";
$pgv_lang["lang_language"]				= "Språk";
$pgv_lang["export_filename"]			= "Navn på filen som inneholder eksport data:";
$pgv_lang["lang_back"]					= "Gå tilbake til hovedmenyen for å endre og konfigurere språk-filer";
$pgv_lang["lang_back_admin"]			= "Tilbake til Admin-meny";
$pgv_lang["lang_back_manage_gedcoms"]	= "Gå tilbake til siden til Slektsfil(er) og personvern";
$pgv_lang["lang_name_arabic"]			= "Arabisk";
$pgv_lang["lang_name_catalan"]			= "Catalansk (Valencian)";
$pgv_lang["lang_name_czech"]			= "Tsjekkisk";
$pgv_lang["lang_name_chinese"]			= "Kinesisk";
$pgv_lang["lang_name_danish"]			= "Dansk";
$pgv_lang["lang_name_dutch"]			= "Nederlandsk";
$pgv_lang["lang_name_english"]			= "Engelsk";
$pgv_lang["lang_name_estonian"]			= "Estisk";
$pgv_lang["lang_name_finnish"]			= "Finsk";
$pgv_lang["lang_name_french"]			= "Fransk";
$pgv_lang["lang_name_german"]			= "Tysk";
$pgv_lang["lang_name_greek"]			= "Gresk";
$pgv_lang["lang_name_hebrew"]			= "Hebraisk";
$pgv_lang["lang_name_hungarian"]		= "Ungarsk";
$pgv_lang["lang_name_italian"]			= "Italiensk";
$pgv_lang["lang_name_indonesian"]		= "Indonesisk";
$pgv_lang["lang_name_lithuanian"]		= "Litauisk";
$pgv_lang["lang_name_norwegian"]		= "Norsk";
$pgv_lang["lang_name_polish"]			= "Polsk";
$pgv_lang["lang_name_portuguese"]		= "Portugisisk";
$pgv_lang["lang_name_romanian"]			= "Rumensk";
$pgv_lang["lang_name_russian"]			= "Russisk";
$pgv_lang["lang_name_slovak"]			= "Slovakisk";
$pgv_lang["lang_name_slovenian"]		= "Slovensk";
$pgv_lang["lang_name_spanish"]			= "Spansk";
$pgv_lang["lang_name_spanish-ar"]		= "Latin-amerikansk spansk";
$pgv_lang["lang_name_swedish"]			= "Svensk";
$pgv_lang["lang_name_turkish"]			= "Tyrkisk";
$pgv_lang["lang_name_vietnamese"]		= "Vietnamesisk";
$pgv_lang["lang_new_language"]			= "Nytt språk";
$pgv_lang["original_lang_name"]			= "Original-navn til #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "Navnet til dette språket i sitt eget språkform.<br /><br />Engelsk er i engelsk språkdrakt: English<br />Tysk er i tysk språkdrakt: Deutsch<br />Nederlandsk er i nederlansk (Dutch) språkdrakt: Nederlands<br />osv.";
$pgv_lang["lang_shortcut"]				= "Kort-navn for språk-filer";
$pgv_lang["lang_shortcut_help"]			= "Denne koden definerer forkortelsen som er brukt for å navngi språkfilene for det valgte språket inne i PhpGedView.<br />Normalt er det første kode i 'Språk-gjenkjennings-koder' som kan bli definert i det neste feltet i språk-oppsett-vinduet.";
$pgv_lang["lang_langcode"]				= "Kode(r) for gjennkjenning av språk";
$pgv_lang["lang_langcode_help"]			= "Disse kodene gjør at PhpGedView kan finne innstillingen for språk i nettleseren til den brukeren som ser på PhpGedView-sidene dine. Kodene må være separert med en semikolon ';'";
$pgv_lang["lang_filenames"]				= "Navn på språk-filer";
$pgv_lang["lang_filenames_help"]		= "PhpGedView har support for mange forskjellige språk.  Dette er mulig fordi all tekst er lagret i egne filer.  Hvert språk har fire forskjellige filer utfra hvor teksten brukes og hvilken funksjon den har.  Dersom det er lagt til en tekst som enda ikke er oversatt, vil den engelske teksten bli vist.<br /><br />Filene i hvert språksett er:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder ledetekster, tekst for ulike valg og hjelpetekster for bruk under konfigureringen av PhpGedView.  Hjelpeteksten er ikke lagd for å vises for vanlige brukere.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dette er en liste med alle land i verden, hentet fra listen med betegnelsen ISO 3166-1.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder tekst i henhold til faktakoder i GEDCOM 5.5.1 standard.  Den inneholder også i tillegg faktakoder som ikke finnes i standarden, men som er brukt av ulike slektsprogram.<br /><br />En engelsk kopi av <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank><b>GEDCOM 5.5.1 Standard</b></a> kan hentes i PDF (Portable Document Format).</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder hjelpetekster for vanlige brukere.  Noen av emnene i denne filen er spesielt tilrettelagt for sdministratorer og er skjult for brukere som ikke har rettigheter som administrator.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Denne filen inneholder ord og uttrykk brukt i menyer, diagram, lister, rapporter og andre sider for vanlige bruk av PhpGedView.</li></ul>";
$pgv_lang["flagsfile"]					= "Navn på flagg-bildefil";
$pgv_lang["flagsfile_help"]				= "Navn og sti til bildefilen med nasjonsflagget for dette språket.";
$pgv_lang["text_direction"]				= "Tekst-retning";
$pgv_lang["text_direction_help"]		= "Definerer hvilken retning teksen blir skrevet i det valgte språket.<br /><br />Vanligvis viser alle vestlige språk en tekst fra venstre til høyre.<br />Men det er språk som Arabisk eller Hebraisk som viser en tekst fra høyre til venstre.";
$pgv_lang["date_format"]				= "Dato-format";
$pgv_lang["date_format_help"]			= "Dette feltet definerer formatet til dato som til vanlig er brukt i slektsfeltene til det valgte språket.<br /><br />Variabler du kan bruke er:<br />D for dag<br />M for måned<br />Y for år.<br /><br />Du kan endre rekkefølgen i feltet og/eller legge til skilletegn i det.<br /><br />Standard oppsett for norsk er 'D. M Y', som betyr at datoer inne i en GEDCOM-post slik som 'DATE 20 Nov 1965' vil bli vist i PhpGedView som '20. November 1965'.<br /><br />For eksempel i England har dette feltet innholdet: 'D M Y' som vil resultere i at PhpGedView i engelskspråklige drakt vil vise: '20 November 1965'.<br /><br />Et annet eksempel er det ungarske språket som definerer datoen som 'Y. M D.' og da vil denne datoen bli vist som '1965. marraskuuta 20.' i PhpGedView.<br />Enda et eksempel er det finske språket som definerer datoen som 'D. M#ta# Y' og da vil denne datoen bli vist som '20. marraskuuta 1965'.";
$pgv_lang["date_format_help2"] = "<li><b>Kalenderkonvertering</b><br />Koden<b>R</b> er noe uvanlig i måten den virker.  Når denne koden opptrer i datoformatet, vil den normale datoen bli vist en gang til, men i et annet kalendersystem.  Elementer av denne alternative kalenderdatoen vil følge de samme reglene som for hoveddelen av formatspesifikasjonen, med unntak av at visningen av <b>R</b> formatet er inkludert i parenteser for å skille det fra den ordinære datoen.  Eksemplene gitt under <b>den franske revolusjons</b>kalenderen gjør dette litt klarere.<br /><br />Den alternative kalenderen som skal brukes for <b>R</b> koden bestemmes i henhold til det valgte språket for siden.  Når språket er Hebraisk, er det <b>Jødisk</b> kalender som blir brukt.  Når språket er Arabisk, er det <b>Hijri</b>kalenderen som blir brukt.  For alle andre språk, er det <b>Den franske revolusjons</b>kalenderen som blir brukt.<br /><br />Håndteringen av denne koden er lignende valg av kalenderformat som du kan gjøre på GEDCOM konfigurasjonssiden.  Forskjellen mellom de to methodene er at <b>R</b>-koden, som blir definert på språk-konfigurasjonsnivå, virker kun på valgte språk men for alle GEDCOM-filer på nettstedet.  Kalendervalget som du setter på GEDCOM-konfigurasjonsnivå virker for alle språk men bare på den GEDCOM-filen som valget er definert for.<br /><ul><li><b>Den franske revolusjons</b>kalenderen&nbsp;&nbsp;&nbsp;Denne kalenderen kalles også <b>Fransk Republikansk</b> kalender.<br /><br />Unntatt for en veldig kort periode i mai 1871, dette kalendersystemet ble kun brukt i Frankrike og kun mellom 22&nbsp;SEP&nbsp;1792 og 31&nbsp;DEC&nbsp;1805.  Følgelig, det franske revolusjonskalenderformatet vil kun bli brukt når datoen er innenfor det tidsrommet.<br /><br />To eksempler på datoformater, forutsatt at språket er engelsk, vil illustrere håndteringen av <b>R</b>-koden:<br /><b>Y.m.d&nbsp;R</b> kan  vise <b>1805.04.26&nbsp;(XIII.08.06)</b> eller <b>1806.01.01</b>;&nbsp; <b>j&nbsp;F&nbsp;Y&nbsp;R</b> vil kunne vise <b>13&nbsp;oktober&nbsp;1797&nbsp;(22&nbsp;Vendémiaire&nbsp;VI)</b> eller <b>1&nbsp;januar&nbsp;1806</b>.</li></ul><br /></li><li><b>Språkalternativene</b>&nbsp;&nbsp;&nbsp;de forkortede tekstene for de avanserte kodene <b>D</b> og <b>M</b> settes i filen <i>languages/lang.xx.php</i>, ved å bruke uttrykk som <code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Su\";</code>&nbsp;&nbsp; and&nbsp;&nbsp; <code>\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"April\";</code><br /><br />Disse kan endres ved å bruke <i>languages/extra.xx.php</i> filen som beskrevet i Wiki og ReadMe teksten for språktilpasninger, for eksempel:<br /><code>\$pgv_lang[\"sunday_1st\"]&nbsp;=&nbsp;\"Sun\";<br />\$pgv_lang[\"apr_1st\"]&nbsp;=&nbsp;\"Apr\";</code><br /><br /><br /></li><li><b>Localization</b>&nbsp;&nbsp;&nbsp;Spesiellle formateringsregler finnes for et antall språk, spesielt hvordan navnet på måneden uttrykkes i forhold til hvordan datoen er uttalt.  Disse spesialreglene er implementert i de ulike <i>includes/extras/functions.xx.php</i> filene.</li></ul>";
$pgv_lang["time_format"]				= "Tid-format";
$pgv_lang["time_format_help"]			= "Dette feltet definerer formatet til klokkeslett som blir brukt i det valgte språket.<br /><br />Variablene som du kan bruke er:<br />a - Små bokstaver Ante meridiem og Post meridiem - 'am' eller 'pm'<br />A - Store bokstaver Ante meridiem og Post meridiem - 'AM' eller 'PM'<br />B - Swatch Internett tid - 000 til 999<br />c - ISO 8601 dato (inkludert i PHP 5) - 2004-02-12T15:19:21+00:00<br />d - Dag i måneden, 2 siffer med ledende 0 (null) - 01 til 31<br />D - En tekstbasert presentasjon av dagen, kun tre bokstaver - Man til Søn<br />F - En tekstbasert presentasjon av månden, hele navnet - Januar til Desember<br />g - 12-timers-format av timer uten en ledende 0 (null) - 1 til 12<br />G - 24-timers-format av timer uten ledende 0 (null) - 0 til 23<br />h - 12-timers-format av timer med ledende 0 (null) - 01 til 12<br />H - 24-timers-format av timer med ledende 0 (null) - 00 til 23<br />i - Minutter med ledende 0 (null) - 00 til 59<br />I - (stor i) Bestemmer om landet bruker justert Sommertid - 1 time i sommertiden, 0 i normal-/vintertiden.<br />j - Dag i måneden uten ledende 0 (null) - 1 til 31<br />l - (liten 'L') En teksbasert presentasjon av ukedagen, hele navnet - Søndag til Lørdag<br />M - En tekstbasert presentasjon av måneden, tre bokstaver - Jan til Des<br />O - Differansen til Greenwich tid (GMT) i timer - Eksempel: +0200<br />r - RFC 2822 formatert dato - Eksempel: Tor, 21 Des 2000 16:01:07 +0200<br />s - Sekunder, med ledende 0 (null) - 00 til 59<br />S - Engelsk ordensbetegnelse for dagen i måneden, 2 bokstaver - st, nd, rd eller th. Fungerer bra med j<br />T - Tidssone-oppsett til dnne maskinen - Eksempler: CEST, EST, MDT ...<br />U - Sekunder siden Unix Epoch (1. Januar 1970 00:00:00 GMT)<br />W - ISO-8601 ukenummer i året, uker starter på mandag (inkludert i PHP 4.1.0) Eksempel: 42 (uke 42 i dette året)<br />Y - En tallbasert presentasjon av et år, 4 siffer - Eksempler: 1999 eller 2003<br />y - En tallbasert presentasjon av et år - Eksempler: 99 eller 03<br />z - Dagen i året (starter fra 0) - 0 til 365<br />Z - Tidssone oppsett i sekunder. Oppsettet for tidssoner vest for UTC er alltid negativ, og for de øst for UTC er alltid positiv. - -43200 til 43200<br /><br />Du kan bytte rekkefølgen inne i dette feltet og/eller legge til skilletegn i det.<br />For eksempel i Norge har dette feltet innholdet: 'HI:i:s' som vil gi dette resultatet: '09:01:25'.<br />Den engelske standarden vil bli definert slik: 'g:i:sa' som vil gi dette resultatet: '9:01:25am'.";
$pgv_lang["week_start"]					= "Uke-start";
$pgv_lang["week_start_help"]			= "Ukedagen som starter en ny uke i dette språket.  I mange land starter uka på søndagen, mens i andre så starter den på mandag eller en annen dag.";
$pgv_lang["name_reverse"]				= "Etternavn først";
$pgv_lang["name_reverse_help"]			= "I noen språk bør etternavnet vises først i stede for som vanlig på slutten.  Ved å aktivere dette valget vil etternavnet bli vist først.";
$pgv_lang["ltr"]						= "Venstre til høyre";
$pgv_lang["rtl"]						= "Høyre til venstre";
$pgv_lang["file_does_not_exist"]		= "FEIL! Finner ikke filen...";
$pgv_lang["optional_file_not_exist"]	= "Denne valgfrie filen fnnes ikke.";
$pgv_lang["alphabet_upper"]				= "STORE bokstaver alfabetisk";
$pgv_lang["alphabet_upper_help"]		= "Språkets store bokstaver i alfabetisk rekkefølge. Dette brukes for at sortering av navnelister i PhpGedView for det valgte språk.";
$pgv_lang["alphabet_lower"]				= "Små bokstaver alfabetisk";
$pgv_lang["alphabet_lower_help"]		= "Språkets små bokstaver i alfabetisk rekkefølge. Dette brukes for at sortering av navnelister i PhpGedView for det valgte språk.";
$pgv_lang["multi_letter_alphabet"]		= "Flerbokstavs-alfabet";
$pgv_lang["multi_letter_alphabet_help"]	= "~#pgv_lang[multi_letter_alphabet]#~<br /><br />Multi-bokstav-kombinasjoner som skal behandles som en distinkt bokstav når sortering av lister med navn og titler i dette språket. <br /> <br /> Noen språk, ungarsk og slovakisk for eksempel vurdere visse kombinasjoner av bokstaver som egne bokstavene i seg selv. Rekkefølgen du angir disse bokstavkombinasjoner bestemmer rekkefølgen de er satt inn i normal alfabetisk under sortering. Dette er viktig når flere multi-bokstavs-kombinasjoner har samme første bokstav. Unntatt <b> ch </ b>, disse bokstav kombinasjoner er satt inn i normal alfabetisk etter deres første bokstav. <b> ch </ b> er alltid satt inn etter <b> h </ b>. <br /> ";
$pgv_lang["multi_letter_equiv"]		= "Flerbokstavsvarianter";
$pgv_lang["multi_letter_equiv_help"]	= "~#pgv_lang[multi_letter_equiv]#~<br /><br />I noen språk håndteres ofte flere bokstaver som jevnbyrdig til en enkelt bokstav når man generer personlister.<br /><br />For example, in Dutch, names beginning with IJ are listed together with names beginning with Y. In Norwegian, names beginning with AA are listed with &Aring;. In some languages, there are letters that can be written as one character or two. For example in Slovakian, the two characters D and \xC5\xBE can be written as the single character \xC7\x85. By specifying equivalents here, you can allow names beginning with these letters to be grouped together on the individual list pages.<br /><br />You should specify a comma-separated list of equivalents. To support databases that don't recognize UTF-8 encoding, you should specify both upper and lower case equivalents. This example demonstrates the format to use.<br /><br />Aa=&Aring;,aa=&aring;";
$pgv_lang["dictionary_sort"]		= "Bruk ordlisteregler ved sortering";
$pgv_lang["dictionary_sort_help"]	= "~#pgv_lang[dictionary_sort]#~<br /><br />Dette alternativet styren hvordan bokstaver med spesieller merker som accenter og tødler håndteres ved sortering av lister med  navn og titler.<br /><br />Når den er satt til <b>#pgv_lang[yes]#</b>, vil alle bokstaver med særmerker bli behandlet som om di ikke hadde noen spesielle merker.  Slike særmerker blir bare håndtert slik når to ord eller er identiske.  Når den er satt til <b>#pgv_lang[no]#</b>, blir alle tegn og bokstaver regnet som ulike, uansett om de har særmerker eller ikke.<br />";
$pgv_lang["collation"]		= "Database collationsrekkefølge";
$pgv_lang["collation_help"]	= "~#pgv_lang[collation]#~<br /><br />Hvis du bruker databasens innebyggede collationsregler, vil dette valget spesifisere kollationsrekkefølgen som skal brukes for dette språket.  Du bør forsikre deg om at din database støtter alle kollasjonsrekkefølgene du har tenkt å bruke.<br /><br />Bruken av databasekollasjon er kontrollert av konfigurasjonsvalgene for nettstedet.<br />";
$pgv_lang["lang_config_write_error"]	= "Feil ved skriving av språkets innstillinger til filen [language_settings.php]. Sjekk rettigheter og prøv igjen.";
$pgv_lang["translation_forum"]			= "Forum for oversettere av PhpGedView";
$pgv_lang["translation_forum_help"]	= "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#";
$pgv_lang["translation_forum_desc"]		= "På nettstedet til PhpGedView på SourceForge.net er det et <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" alt=\"Gå til forum i nytt vindu\" title=\"Gå til forum i nytt vindu\" target=_blank><b><i>Forum for oversettere</i></b></a><br />der du kan se på og/eller bidra med aktuelle problemstillinger   :-)";
$pgv_lang["lang_set_file_read_error"]	= "F E I L !!! Klarte ikke å lese filen [language_settings.php]!";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Du kan bruke dette verktøyet til å legge til et nytt og enda ikke støttet språk for PhpGedView.<br /><br />Du starter med å legge inn standardinnstillinger for det nye språket slik som skråkkoder, ukestart, datoformat, nasjonalt alfabet mm.<br /><br />Du vil få mer hjelp til dette på et språk som du velger blant de som allerede støttes av PhpGedView etter å ha klikket på knappen <b>#pgv_lang[add_new_lang_button]#</b>.";
$pgv_lang["add_new_lang_button"]		= "Legg til nytt språk";
$pgv_lang["hide_translated"]			= "Skjul oversatt tekst";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Hvis denne er satt til 'Ja', så vil du se språklinjene i den valgte språkfil din som ikke er blitt oversatt, som egentlig betyr at de ikke finnes i språkfilen din enda.<br />Etter å ha lagt til og oversatt språklinjen, vil denne meldingen ikke bli vist i listen lengre.<br /><br />Noen språkfiler inneholder engelsk tekst i noen språklinjer.  Dette valget kan ikke finne disse fordi de allerede finnes i både kilde- og målfilen som skal endres...";
$pgv_lang["lang_file_write_error"]	= "F E I L !!!<br /><br />Klarte ikke å lagre endringer til den valgte språkfilen.  Sjekk skriverettighetene på <b>#lang_filename#</b>";
$pgv_lang["no_open"]					= "F E I L !!!<br /><br />Klarte ikke å åpne filen #lang_filename#";
$pgv_lang["users_langs"]			= "Språkene til brukere";
$pgv_lang["configured_languages"]	= "Språk brukt";

//-- User Migration Tool messages
$pgv_lang["um_header"] 					= "Verktøy for konvertering til annen database";
$pgv_lang["um_proceed"] 				= "Starte eksport av datafilene om brukeren?";
$pgv_lang["um_creating"] 				= "Oppretter";
$pgv_lang["um_sql_index"]				= "Dette verktøyet vil lage filen <i>authenticate.php</i> og flere andre <i>.dat</i> filer i index-mappen din.<br /><br />Etter at filene er opprettet, kan du bytte til Index-database med alle registrerte brukere og bekjeden deres, favoritter, nyheter og MyGedview layout inntakt.<br /><br />NB! Etter at du har byttet til Index-database, må du importere GEDCOM-fil(ene) på nytt.";
$pgv_lang["um_file_create_fail1"] 		= "Klarte ikke å opprette filen fordi en fil med samme navn finnes fra før:";
$pgv_lang["um_file_create_fail2"] 		= "Klarte ikke å opprette filen";
$pgv_lang["um_file_create_fail3"] 		= "Sjekk rettighetene for å opprette en fil i denne katalogen.";
$pgv_lang["um_file_create_succ1"] 		= "Den nye filen er lagret:";
$pgv_lang["um_file_not_created"] 		= "Filen ble ikke lagd.";
$pgv_lang["um_nomsg"] 					= "Kunne ikke finne noen \"Beskjeder\" lagret i systemet.";
$pgv_lang["um_nofav"] 					= "Kunne ikke finne noen \"Favoritter\" lagret i systemet.";
$pgv_lang["um_nonews"] 					= "Kunne ikke finne noen \"Nyheter\" lagret i systemet.";
$pgv_lang["um_noblocks"] 				= "Kunne ikke finne noen \"Rammer\" lagret i systemet.";
$pgv_lang["um_index_sql"] 				= "Dette verktøyet vil importere filen <i>authenticate.php</i> og andre <i>.dat</i> filer fra index-mappen din inn i databasen din.";
$pgv_lang["um_noaction"] 				= "Det er ikke nødvendig å konvertere bruker-informasjon til SQL-modus nå.<br /><br />Når du har forandret oppsett til SQL-modus, må du imidlertid utføre konverteringen for å importere alle data inn i SQL-databasen.  PhpGedView da bruke de eksisterende filene fra Index-modus.<br /><br /><b>PS! <u>Ikke</u> fjerne filen <i>authenticate.php</i> og <i>.dat</i> filene fra index-mappen din under bytte-prosessen.</b>";
$pgv_lang["um_import"] 					= "Import";
$pgv_lang["um_export"] 					= "Eksport";
$pgv_lang["um_explain"] 				= "Dette verktøyet vil enten eksportere brukerdata fra SQL til Index-modus eller importere brukerdata fra Index-filer inn i SQL-tabeller.<br /><br />Brukerdata, favoritter, ramme-definisjoner, beskjeder og nyheter vil bli gjort tilgjengelig igjen etter at du har byttet modus.<br /><br /><b>ADVARSEL</b><br />Du kan ikke bruke dette verktøyet til å overføre brukerdata mellom ulike versjoner av PhpGedView.  Forsikre deg om at dataene stammer fra, eller er importert inn i den samme PhpGedView-versjonen.<br /><br /><b>IMPORTERE</b><br />Dersom du velger å importere brukerdata-filene fra Index-modus, vil eventuelle brukerdata som finnes fra før, bli <u>overskrevet</u>. Med andre ord så fletter <u>ikke</u> dette verktøyet informasjonen, men legger inn informasjonen på nytt. Når du er ferdig med importen, så er det ikke mulig å hente den gamle informasjonen igjen.<br /><br /><b>EKSPORTERE</b><br />Dersom du eksporterer brukerinformasjonen fra SQL-databasen din til Index-modu-filer, vil verktøyet lagre filen <i>authenticate.php</i> og flere <i>.dat</i> filer i index-mappen din. Dersom det finnes filer med samme navn fra før, vil du bli spurt om de skal overskrives. Etter at du har byttet til Index-modus, vil all informasjon være tilgjengelig direkte.<br /><br /><b>NB!</b> Etter at du har byttet til Index-modus, MÅ du importere GEDCOM-fil(ene) dine på nytt.";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Eksporter brukere fra SQL til Index modus~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Eksporter brukere fra Index til SQL modus~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] 				= "Importerer brukere";
$pgv_lang["um_imp_blocks"] 				= "Importerer rammer";
$pgv_lang["um_imp_favorites"] 			= "Importerer favoritter";
$pgv_lang["um_imp_messages"] 			= "Importerer beskjeder";
$pgv_lang["um_imp_news"] 				= "Importerer nyheter";
$pgv_lang["um_nousers"] 				= "Fant ikke filen <i>authenticate.php</i> katalogen ./index. Overføringen er avbrutt.";
$pgv_lang["um_imp_succ"] 				= "Importen er utført";
$pgv_lang["um_imp_fail"] 				= "Importen ble ikke fullført";
$pgv_lang["um_backup"] 					= "Sikkerhetskopi";
$pgv_lang["um_zip_succ"] 				= "ZIP-fil er nå lagd.";
$pgv_lang["um_zip_dl"] 					= "Hent ZIPet sikkerhetskopi-fil ";
$pgv_lang["um_bu_explain"] 				= "Her kan du lage en sikkerhetskopi av forskjellige data i PhpGedView.<br /><br />Dataene som du velger å ta sikkerhetskopi av, vil bli samlet i en ZIP-fil,<br />som det også er mulig å laste ned (download) ved å klikke på valget nederst på siden, etter at sikkerhetskopieringen er utført.<br /><br />ZIP-filen vil forbli i Index-mappen din til du fjerner den manuellt.";
$pgv_lang["um_bu_help"] 				= "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] 				= "PhpGedView konfigurasjonsfil";
$pgv_lang["um_bu_gedcoms"] 				= "GEDCOM-filer";
$pgv_lang["um_bu_gedsets"] 				= "GEDCOM-innstillinger, konfigurasjon og personvern-filer";
$pgv_lang["um_bu_logs"] 				= "GEDCOM tellere, søke-logger og PhpGedView logg-filer";
$pgv_lang["um_bu_usinfo"] 				= "Bruker-definisjoner, ramme-innstillinger, favoritter, beskjeder og nyheter";
$pgv_lang["um_bu_media"]				= "Mediafiler";
$pgv_lang["um_mk_bu"] 					= "Lag sikkerhetskopi";
$pgv_lang["um_nofiles"] 				= "Ingen filer funnet for sikkerhetskopiering.";
$pgv_lang["um_files_exist"] 			= "En eller flere filer finnes fra før. Ønsker du å overskrive dem?";
$pgv_lang["um_results"]		= "Resultater";
$pgv_lang["preview_faq_item"] = "Forhåndsvis alle FAQ-elementene";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br />Dette valget lar en adminbruker se FAQ-siden uten alle redigeringsalternativer og lenker.<br /><br />Unntatt for en enkelt<b>Rediger</b>-lenke over den første FAQ-elementet, vil utseendet på FAQ-siden være identisk med hva en ordinær bruker vil se. Denne spesielle <b>Rediger</b>-lenken vil ta deg tilbake til full redigeringsfunksjonalitet for FAQ-siden.<br />";
$pgv_lang["restore_faq_edits"] = "Tilbakestill FAQ-redigeringsfunksjonene";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br />Dette valget tilbakestiller FAQ-siden til det en adminbruker normalt ser, slik at indivituelle FAQ-elementer kan redigeres.<br />";
$pgv_lang["add_faq_item"] = "Legg til FAQ-elementer";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br />Dette valget lar deg legge til et element på FAQ-siden.<br />";
$pgv_lang["edit_faq_item"] = "Rediger FAQ-element";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br />Dette valget lar deg redigere et element på FAQ-siden.<br />";
$pgv_lang["delete_faq_item"] = "Slett FAQ-element";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br />Dette valget lar deg slette et element fra FAQ-siden<br />";
$pgv_lang["moveup_faq_item"] = "Flytt FAQ-element oppover";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br />Dette valget lar deg flytte et element oppover på FAQ-siden.<br /><br />Hver gang du bruker dette valget, vil FAQ-posisjonsnummeret for dette elementet reduseres med en.  Du kan få samme effekt ved å redigere det aktuelle elementet og endre FAQ-posisjonsfeltet.  Når mere enn ett element har samme posisjonsnummer, vil kun ett av elementene være synlig.<br />";
$pgv_lang["movedown_faq_item"] = "Flytt FAQ-element nedover";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br />Dette valget lar deg flytte et element nedeover på FAQ-siden.<br /><br />Hver gang du bruker dette valget, vil FAQ-posisjonsnummeret for dette elementet øke med en.  Du kan få samme effekt ved å redigere det aktuelle elementet og endre FAQ-posisjonsfeltet.  Når mere enn ett element har samme posisjonsnummer, vil kun ett av elementene være synlig.<br />";
$pgv_lang["add_faq_header_help"] = "~#pgv_lang[add_faq_header]#~<br />Dette er tittelen eller emnet for dette FAQ-elementet.<br /><br />Det du skriver inn her kan formateres. HTML-tagger som &lt;b&gt; og &lt;br /&gt; er tillatt, det er også HTML-entiteter som &amp;amp; og &amp;nbsp;.  Andre HTML-tager enn &lt;br /&gt; er muligens ikke  muligens ikke brukbart i en FAQ-tittel og bør unngås.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_body_help"] = "~#pgv_lang[add_faq_body]#~<br />Teksten i FAQ-elementet skrives inn her.<br /><br />Teksten kan formateres. HTML-tagger som &lt;b&gt; og &lt;br /&gt; er tillatt, det er også HTML-entiteter som &amp;amp; og &amp;nbsp;.<br /><br />#pgv_lang[add_faq_HTML]#<br /><br />#pgv_lang[add_faq_pgvLangRefs]#<br />";
$pgv_lang["add_faq_HTML"] = "Med HTML-entiteter  har du en veldig enkel metode for å legge til spesialtegn i FAQ-titler og tekst.  Du kan bruke symbolske navn, desimaltall, eller hexadesimale verdier.  En komplett liste over HTML-entiteter, koden, og representasjonen i din nettleser kan du finne her:  <a href=\"http://htmlhelp.com/reference/html40/entities/\" target=\"_blank\">HTML-entitetslister</a><br /><br />Noen ganger, kan det hende du må vise et tilde-tegn&nbsp;&nbsp;<b>&#x7E;</b>&nbsp;&nbsp;eller et tallsymboln&nbsp;&nbsp;<b>&#x23;</b>&nbsp;&nbsp;i dine URL'er eller tekst.  Disse tegnene har en spesiell funksjon i PhpGedViews hjelpesystem og kan bare legges inn i sin hexadesimale eller desimale form.  Likeledes, the&nbsp;&nbsp;<b>&lt;</b>&nbsp;&nbsp;and&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp;tegn  som vanligvis brukes til å lukke HTML-tagger må skrives inn i sin hexadesimale eller desimale former hvis de skal håndteres som normal tekst istedenfor å vise en HTML-tagg.<ul><li><b>&amp;&#x23;35;</b>&nbsp;&nbsp;or&nbsp;&nbsp;<b>&amp;&#x23;x23;</b>&nbsp;&nbsp;vil gi&nbsp;&nbsp;<b>&#x23;</b></li><li><b>&amp;&#x23;60;</b>&nbsp;&nbsp;or&nbsp;&nbsp;<b>&amp;&#x23;x3C;</b>&nbsp;&nbsp;vil gi&nbsp;&nbsp;<b>&#x3C;</b></li><li><b>&amp;&#x23;62;</b>&nbsp;&nbsp;or&nbsp;&nbsp;<b>&amp;&#x23;x3E;</b>&nbsp;&nbsp;vil gi&nbsp;&nbsp;<b>&#x3E;</b></li><li><b>&amp;&#x23;126;</b>&nbsp;&nbsp;or&nbsp;&nbsp;<b>&amp;&#x23;x7E;</b>&nbsp;&nbsp;vil gi&nbsp;&nbsp;<b>&#x7E;</b></li></ul>Det finnes en&nbsp;&nbsp;<b>&amp;tilde;</b>&nbsp;&nbsp;HTML-entitet, men dette tegnet blir ikke tolket som en Tilde når det er kodet i URLer.";
$pgv_lang["add_faq_pgvLangRefs"] = "Du kan sette inn referanser til en oppføring i en språkfil eller til verdier av globale variable.  Eksempler: <ul><li><b>&#x23;pgv_lang[add_to_cart]&#x23;</b>&nbsp;&nbsp;&nbsp;er  en  referanse ttil Språkvariabelen \$pgv_lang[\"add_to_cart\"], og hvis brukt i dette feltet, vil det vises som <b>#pgv_lang[add_to_cart]#</b> når OSS-listen vises i det gjeldende språket.</li><li><b>&#x23;factarray[AFN]&#x23;</b>&nbsp;&nbsp;&nbsp;er en referanse til faktanavnet \$factarray[\"AFN\"], og hvis det ble brukt i dette feltet ville det vises som <b>#factarray[AFN]#</b> når OSS-listen brukes i det gjeldende språket. </li><li><b>&#x23;GLOBALS[VERSION]&#x23;&nbsp;&#x23;GLOBALS[VERSION_RELEASE]&#x23;</b>&nbsp;&nbsp;&nbsp;er en referanse til den globale variabelen \$VERSION, et mellomrom, og en referanse til den globale variabelen \$VERSION_RELEASE, og brukt i dette feltet, vil det vises som <b>#GLOBALS[VERSION]#&nbsp;#GLOBALS[VERSION_RELEASE]#</b> Når OSS-listen vises i det gjeldende språket.</li><li><b>&#x23;GLOBALS[GEDCOM]&#x23;</b>&nbsp;&nbsp;&nbsp;er en referanse til den globale variabelen \$GEDCOM, som er navnet på den gjeldende GEDCOM-filen. Brukt i dette feltet, vil det vises som <b>#GLOBALS[GEDCOM]#</b>.</li><li><b>&#x23;GLOBALS[GEDCOM_TITLE]&#x23;</b>&nbsp;&nbsp;&nbsp; er en referanse til den globale variabelen \$GEDCOM_TITLE, som er tittelen på den gjeldende GEDCOM-filen.  Brukt i dette feltet, vil det vises som <b>#GLOBALS[GEDCOM_TITLE]#</b>.</li></ul><br />Denne funksjonalitet er nyttig når du ønsker å lage OSS-lister som er forskjellige for hver språk nettstedet støtter. Du bør plassere titlene og oppføringene til den tilpassede OSS-listen i <i>languages/extra.xx.php</i>-filen (<i>xx</i> er koden for hvert språk), ved å bruke følgende format:<br />\$pgv_lang[\"faq_title1\"] = \"Dette er et eksempel på OSS-tittel\";<br />\$pgv_lang[\"faq_body1\"] = \"Dette er eksempel på et OSS-avsnitt.\";<br />";
$pgv_lang["add_faq_order_help"] = "~#pgv_lang[add_faq_order]#~<br />Dette feltet styrer rekkefølgen som OSS-elementer vises i. <br /> <br /> Du trenger ikke å legge inn sekvensnumrene i rekkefølge. Hvis du lar det være hull i nummerrekkefølgen, kan du sette inn andre elementer senere. Hvis du for eksempel bruke tallene 1, 6, 11, 16, kan du senere setter inn elementer med de manglende sekvensnummer. Negative tall og null er tillatt, og kan brukes til å sette inn elementer foran det første. <br /> <br /> Når mer enn ett OSS-element har samme sekvensnummer, vil bare et av disse elementene være synlig.<br />";
$pgv_lang["add_faq_visibility_help"] = "~#pgv_lang[add_faq_visibility]#~<br />Du kan bestemme om denne OSS vil være synlig uansett GEDCOM, eller om den vil være synlig kun for gjeldende GEDCOM.<br /><ul><li><b>#pgv_lang[all]#</b>&nbsp;&nbsp;&nbsp;The FAQ will appear in all FAQ lists, regardless of GEDCOM.</li><li><b>#GLOBALS[GEDCOM]#</b>&nbsp;&nbsp;&nbsp;The FAQ will appear only in the currently active GEDCOM's FAQ list.</li></ul><br />";
$pgv_lang["index_gedcom_news_adm_help"]	= "I denne Nyhetsrammen til brukerne dine, har du adgang til å bruke <b>HTML koder</b>.<br />Du må selvsagt kunne litt om HTML for å bruke det.  Husk alltid på å bruker både start- og sluttkode!<br /><br />Dette programmet bruker <b>Stil-filer (CSS)</b> og disse er forskjellig for de ulike Stilene (layout).<br />Ved å se på en av disse filene (CSS), kan du bruke \"klasser\" fra disse stilene.<br /><br />Dersom du trenger mer hjelp rundt dette, kan du finne noen eksempler om hvordan du bruker disse kodene på nettsiden til <a href=\"http://PhpGedView.sourceforge.net/styleguide.html\" target=\"_blank\" />PhpGedView</a>.<br />";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Den maksimale tiden importfunksjonen kan å kjøre for å behandle GEDCOM-filen.";

// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"] = "Resultater funnet";
$pgv_lang["ged_filter_reset"] = "Blank søk";
$pgv_lang["ged_filter_description"] = "Søketekst";
$pgv_lang["ged_filter_description_help"] = "~#pgv_lang[ged_filter_description]#~<br />Dette valget lar deg søke i teksten som er forbundet med konfigureringsvalgene.<br /><br />Når du skriver inn bokstaver, vil søket finne alle konfigurasjonsvalg som inneholder den rekkefølgen av bokstaver.  Søket blir mer presist ettehvert som du skriver flere bokstaver.<br />";

?>
