
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `soft_gallery2`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AccessMap`
--

CREATE TABLE `[[dbprefix]]AccessMap` (
  `g_accessListId` int(11) NOT NULL,
  `g_userOrGroupId` int(11) NOT NULL,
  `g_permission` int(11) NOT NULL,
  PRIMARY KEY (`g_accessListId`,`g_userOrGroupId`),
  KEY `[[dbprefix]]AccessMap_83732` (`g_accessListId`),
  KEY `[[dbprefix]]AccessMap_48775` (`g_userOrGroupId`),
  KEY `[[dbprefix]]AccessMap_18058` (`g_permission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]AccessMap`
--

INSERT INTO `[[dbprefix]]AccessMap` VALUES
(26, 3, 4),
(28, 3, 4),
(9, 4, 7),
(10, 4, 7),
(11, 4, 263),
(12, 4, 8455),
(14, 4, 24839),
(15, 4, 57607),
(19, 4, 123143),
(20, 4, 516359),
(22, 4, 1040647),
(23, 4, 2089223),
(8, 6, 2147483647),
(9, 6, 2147483647),
(10, 3, 2147483647),
(10, 6, 2147483647),
(11, 3, 2147483647),
(11, 6, 2147483647),
(12, 3, 2147483647),
(12, 6, 2147483647),
(14, 3, 2147483647),
(14, 6, 2147483647),
(15, 3, 2147483647),
(15, 6, 2147483647),
(19, 3, 2147483647),
(19, 6, 2147483647),
(20, 3, 2147483647),
(20, 6, 2147483647),
(22, 3, 2147483647),
(22, 6, 2147483647),
(23, 3, 2147483647),
(23, 6, 2147483647);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AccessSubscriberMap`
--

CREATE TABLE `[[dbprefix]]AccessSubscriberMap` (
  `g_itemId` int(11) NOT NULL,
  `g_accessListId` int(11) NOT NULL,
  PRIMARY KEY (`g_itemId`),
  KEY `[[dbprefix]]AccessSubscriberMap_83732` (`g_accessListId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]AccessSubscriberMap`
--

INSERT INTO `[[dbprefix]]AccessSubscriberMap` VALUES
(7, 23),
(25, 26),
(27, 28);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AlbumItem`
--

CREATE TABLE `[[dbprefix]]AlbumItem` (
  `g_id` int(11) NOT NULL,
  `g_theme` varchar(32) DEFAULT NULL,
  `g_orderBy` varchar(128) DEFAULT NULL,
  `g_orderDirection` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]AlbumItem`
--

INSERT INTO `[[dbprefix]]AlbumItem` VALUES
(7, '', '', 'asc');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AnimationItem`
--

CREATE TABLE `[[dbprefix]]AnimationItem` (
  `g_id` int(11) NOT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CacheMap`
--

CREATE TABLE `[[dbprefix]]CacheMap` (
  `g_key` varchar(32) NOT NULL,
  `g_value` longtext,
  `g_userId` int(11) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_type` varchar(32) NOT NULL,
  `g_timestamp` int(11) NOT NULL,
  `g_isEmpty` int(1) DEFAULT NULL,
  PRIMARY KEY (`g_key`,`g_userId`,`g_itemId`,`g_type`),
  KEY `[[dbprefix]]CacheMap_75985` (`g_itemId`),
  KEY `[[dbprefix]]CacheMap_21979` (`g_userId`,`g_timestamp`,`g_isEmpty`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ChildEntity`
--

CREATE TABLE `[[dbprefix]]ChildEntity` (
  `g_id` int(11) NOT NULL,
  `g_parentId` int(11) NOT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]ChildEntity_52718` (`g_parentId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]ChildEntity`
--

INSERT INTO `[[dbprefix]]ChildEntity` VALUES
(7, 0),
(24, 0),
(25, 24),
(27, 24);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Comment`
--

CREATE TABLE `[[dbprefix]]Comment` (
  `g_id` int(11) NOT NULL,
  `g_commenterId` int(11) NOT NULL,
  `g_host` varchar(128) NOT NULL,
  `g_subject` varchar(128) DEFAULT NULL,
  `g_comment` text,
  `g_date` int(11) NOT NULL,
  `g_author` varchar(128) DEFAULT NULL,
  `g_publishStatus` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]Comment_95610` (`g_date`),
  KEY `[[dbprefix]]Comment_70722` (`g_publishStatus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CustomFieldMap`
--

CREATE TABLE `[[dbprefix]]CustomFieldMap` (
  `g_itemId` int(11) NOT NULL,
  `g_field` varchar(128) NOT NULL,
  `g_value` varchar(255) DEFAULT NULL,
  `g_setId` int(11) DEFAULT NULL,
  `g_setType` int(11) DEFAULT NULL,
  KEY `[[dbprefix]]CustomFieldMap_75985` (`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]DataItem`
--

CREATE TABLE `[[dbprefix]]DataItem` (
  `g_id` int(11) NOT NULL,
  `g_mimeType` varchar(128) DEFAULT NULL,
  `g_size` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Derivative`
--

CREATE TABLE `[[dbprefix]]Derivative` (
  `g_id` int(11) NOT NULL,
  `g_derivativeSourceId` int(11) NOT NULL,
  `g_derivativeOperations` varchar(255) DEFAULT NULL,
  `g_derivativeOrder` int(11) NOT NULL,
  `g_derivativeSize` int(11) DEFAULT NULL,
  `g_derivativeType` int(11) NOT NULL,
  `g_mimeType` varchar(128) NOT NULL,
  `g_postFilterOperations` varchar(255) DEFAULT NULL,
  `g_isBroken` int(1) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]Derivative_85338` (`g_derivativeSourceId`),
  KEY `[[dbprefix]]Derivative_25243` (`g_derivativeOrder`),
  KEY `[[dbprefix]]Derivative_97216` (`g_derivativeType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]DerivativeImage`
--

CREATE TABLE `[[dbprefix]]DerivativeImage` (
  `g_id` int(11) NOT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]DerivativePrefsMap`
--

CREATE TABLE `[[dbprefix]]DerivativePrefsMap` (
  `g_itemId` int(11) DEFAULT NULL,
  `g_order` int(11) DEFAULT NULL,
  `g_derivativeType` int(11) DEFAULT NULL,
  `g_derivativeOperations` varchar(255) DEFAULT NULL,
  KEY `[[dbprefix]]DerivativePrefsMap_75985` (`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]DerivativePrefsMap`
--

INSERT INTO `[[dbprefix]]DerivativePrefsMap` VALUES
(7, 0, 1, 'thumbnail|150'),
(7, 0, 2, 'scale|640');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]DescendentCountsMap`
--

CREATE TABLE `[[dbprefix]]DescendentCountsMap` (
  `g_userId` int(11) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_descendentCount` int(11) NOT NULL,
  PRIMARY KEY (`g_userId`,`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]DescendentCountsMap`
--

INSERT INTO `[[dbprefix]]DescendentCountsMap` VALUES
(5, 7, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Entity`
--

CREATE TABLE `[[dbprefix]]Entity` (
  `g_id` int(11) NOT NULL,
  `g_creationTimestamp` int(11) NOT NULL,
  `g_isLinkable` int(1) NOT NULL,
  `g_linkId` int(11) DEFAULT NULL,
  `g_modificationTimestamp` int(11) NOT NULL,
  `g_serialNumber` int(11) NOT NULL,
  `g_entityType` varchar(32) NOT NULL,
  `g_onLoadHandlers` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]Entity_76255` (`g_creationTimestamp`),
  KEY `[[dbprefix]]Entity_35978` (`g_isLinkable`),
  KEY `[[dbprefix]]Entity_44738` (`g_linkId`),
  KEY `[[dbprefix]]Entity_63025` (`g_modificationTimestamp`),
  KEY `[[dbprefix]]Entity_60702` (`g_serialNumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Entity`
--

INSERT INTO `[[dbprefix]]Entity` VALUES
(1, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryEntity', NULL),
(2, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryGroup', NULL),
(3, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryGroup', NULL),
(4, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryGroup', NULL),
(5, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryUser', NULL),
(6, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryUser', NULL),
(7, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryAlbumItem', NULL),
(13, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryEntity', NULL),
(16, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryEntity', NULL),
(21, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryEntity', NULL),
(24, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryChildEntity', NULL),
(25, [[timestamp]], 0, NULL, [[timestamp]], 6, 'ThumbnailImage', NULL),
(27, [[timestamp]], 0, NULL, [[timestamp]], 6, 'ThumbnailImage', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]EventLogMap`
--

CREATE TABLE `[[dbprefix]]EventLogMap` (
  `g_id` int(11) NOT NULL,
  `g_userId` int(11) DEFAULT NULL,
  `g_type` varchar(32) DEFAULT NULL,
  `g_summary` varchar(255) DEFAULT NULL,
  `g_details` text,
  `g_location` varchar(255) DEFAULT NULL,
  `g_client` varchar(128) DEFAULT NULL,
  `g_timestamp` int(11) NOT NULL,
  `g_referer` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]EventLogMap_24286` (`g_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ExifPropertiesMap`
--

CREATE TABLE `[[dbprefix]]ExifPropertiesMap` (
  `g_property` varchar(128) DEFAULT NULL,
  `g_viewMode` int(11) DEFAULT NULL,
  `g_sequence` int(11) DEFAULT NULL,
  UNIQUE KEY `g_property` (`g_property`,`g_viewMode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]ExifPropertiesMap`
--

INSERT INTO `[[dbprefix]]ExifPropertiesMap` VALUES
('Make', 1, 0),
('Model', 1, 1),
('ApertureValue', 1, 2),
('ColorSpace', 1, 3),
('ExposureBiasValue', 1, 4),
('ExposureProgram', 1, 5),
('Flash', 1, 6),
('FocalLength', 1, 7),
('ISO', 1, 8),
('MeteringMode', 1, 9),
('ShutterSpeedValue', 1, 10),
('DateTime', 1, 11),
('IPTC/Caption', 1, 12),
('IPTC/CopyrightNotice', 1, 13),
('Make', 2, 0),
('Model', 2, 1),
('ApertureValue', 2, 2),
('ColorSpace', 2, 3),
('ExposureBiasValue', 2, 4),
('ExposureProgram', 2, 5),
('Flash', 2, 6),
('FocalLength', 2, 7),
('ISO', 2, 8),
('MeteringMode', 2, 9),
('ShutterSpeedValue', 2, 10),
('DateTime', 2, 11),
('IPTC/Caption', 2, 12),
('IPTC/CopyrightNotice', 2, 13),
('IPTC/Keywords', 2, 14),
('ImageType', 2, 15),
('Orientation', 2, 16),
('PhotoshopSettings', 2, 17),
('ResolutionUnit', 2, 18),
('xResolution', 2, 19),
('yResolution', 2, 20),
('Compression', 2, 21),
('BrightnessValue', 2, 22),
('Contrast', 2, 23),
('ExposureMode', 2, 24),
('FlashEnergy', 2, 25),
('Saturation', 2, 26),
('SceneType', 2, 27),
('Sharpness', 2, 28),
('SubjectDistance', 2, 29);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ExternalIdMap`
--

CREATE TABLE `[[dbprefix]]ExternalIdMap` (
  `g_externalId` varchar(128) NOT NULL,
  `g_entityType` varchar(32) NOT NULL,
  `g_entityId` int(11) NOT NULL,
  PRIMARY KEY (`g_externalId`,`g_entityType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]FactoryMap`
--

CREATE TABLE `[[dbprefix]]FactoryMap` (
  `g_classType` varchar(128) DEFAULT NULL,
  `g_className` varchar(128) DEFAULT NULL,
  `g_implId` varchar(128) DEFAULT NULL,
  `g_implPath` varchar(128) DEFAULT NULL,
  `g_implModuleId` varchar(128) DEFAULT NULL,
  `g_hints` varchar(255) DEFAULT NULL,
  `g_orderWeight` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]FactoryMap`
--

INSERT INTO `[[dbprefix]]FactoryMap` VALUES
('GalleryEntity', 'GalleryEntity', 'GalleryEntity', 'modules/core/classes/GalleryEntity.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryChildEntity', 'GalleryChildEntity', 'modules/core/classes/GalleryChildEntity.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryAlbumItem', 'GalleryAlbumItem', 'modules/core/classes/GalleryAlbumItem.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryUser', 'GalleryUser', 'modules/core/classes/GalleryUser.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryGroup', 'GalleryGroup', 'modules/core/classes/GalleryGroup.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryDerivative', 'GalleryDerivative', 'modules/core/classes/GalleryDerivative.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryDerivativeImage', 'GalleryDerivativeImage', 'modules/core/classes/GalleryDerivativeImage.class', 'core', 'N;', '4'),
('GalleryDerivative', 'GalleryDerivativeImage', 'GalleryDerivativeImage', 'modules/core/classes/GalleryDerivativeImage.class', 'core', 'a:1:{i:0;s:1:"*";}', '4'),
('GalleryEntity', 'GalleryMovieItem', 'GalleryMovieItem', 'modules/core/classes/GalleryMovieItem.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryAnimationItem', 'GalleryAnimationItem', 'modules/core/classes/GalleryAnimationItem.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryPhotoItem', 'GalleryPhotoItem', 'modules/core/classes/GalleryPhotoItem.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryUnknownItem', 'GalleryUnknownItem', 'modules/core/classes/GalleryUnknownItem.class', 'core', 'N;', '4'),
('GalleryItem', 'GalleryPhotoItem', 'GalleryPhotoItem', 'modules/core/classes/GalleryPhotoItem.class', 'core', 'a:2:{i:0;s:7:"image/*";i:1;s:21:"application/photoshop";}', '4'),
('GalleryItem', 'GalleryMovieItem', 'GalleryMovieItem', 'modules/core/classes/GalleryMovieItem.class', 'core', 'a:1:{i:0;s:7:"video/*";}', '4'),
('GalleryItem', 'GalleryAnimationItem', 'GalleryAnimationItem', 'modules/core/classes/GalleryAnimationItem.class', 'core', 'a:2:{i:0;s:22:"application/x-director";i:1;s:29:"application/x-shockwave-flash";}', '4'),
('GalleryItem', 'GalleryUnknownItem', 'GalleryUnknownItem', 'modules/core/classes/GalleryUnknownItem.class', 'core', 'a:1:{i:0;s:1:"*";}', '4'),
('GalleryDynamicAlbum', 'GalleryDynamicAlbum', 'GalleryDynamicAlbum', 'modules/core/classes/GalleryDynamicAlbum.class', 'core', 'N;', '4'),
('GallerySearchInterface_1_0', 'GalleryCoreSearch', 'GalleryCoreSearch', 'modules/core/classes/GalleryCoreSearch.class', 'core', 'N;', '4'),
('ItemEditPlugin', 'ItemEditItem', 'ItemEditItem', 'modules/core/ItemEditItem.inc', 'core', 'N;', '1'),
('ItemEditPlugin', 'ItemEditAnimation', 'ItemEditAnimation', 'modules/core/ItemEditAnimation.inc', 'core', 'N;', '2'),
('ItemEditPlugin', 'ItemEditMovie', 'ItemEditMovie', 'modules/core/ItemEditMovie.inc', 'core', 'N;', '2'),
('ItemEditPlugin', 'ItemEditAlbum', 'ItemEditAlbum', 'modules/core/ItemEditAlbum.inc', 'core', 'N;', '2'),
('ItemEditPlugin', 'ItemEditTheme', 'ItemEditTheme', 'modules/core/ItemEditTheme.inc', 'core', 'N;', '3'),
('ItemEditPlugin', 'ItemEditPhoto', 'ItemEditPhoto', 'modules/core/ItemEditPhoto.inc', 'core', 'N;', '2'),
('ItemEditPlugin', 'ItemEditRotateAndScalePhoto', 'ItemEditRotateAndScalePhoto', 'modules/core/ItemEditRotateAndScalePhoto.inc', 'core', 'N;', '3'),
('ItemEditPlugin', 'ItemEditPhotoThumbnail', 'ItemEditPhotoThumbnail', 'modules/core/ItemEditPhotoThumbnail.inc', 'core', 'N;', '4'),
('ItemAddPlugin', 'ItemAddFromBrowser', 'ItemAddFromBrowser', 'modules/core/ItemAddFromBrowser.inc', 'core', 'N;', '2'),
('ItemAddOption', 'CreateThumbnailOption', 'CreateThumbnailOption', 'modules/core/CreateThumbnailOption.inc', 'core', 'N;', '8'),
('MaintenanceTask', 'OptimizeDatabaseTask', 'OptimizeDatabaseTask', 'modules/core/classes/OptimizeDatabaseTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'DatabaseBackupTask', 'DatabaseBackupTask', 'modules/core/classes/DatabaseBackupTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'FlushTemplatesTask', 'FlushTemplatesTask', 'modules/core/classes/FlushTemplatesTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'FlushDatabaseCacheTask', 'FlushDatabaseCacheTask', 'modules/core/classes/FlushDatabaseCacheTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'BuildDerivativesTask', 'BuildDerivativesTask', 'modules/core/classes/BuildDerivativesTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'ResetViewCountsTask', 'ResetViewCountsTask', 'modules/core/classes/ResetViewCountsTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'SystemInfoTask', 'SystemInfoTask', 'modules/core/classes/SystemInfoTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'SetOriginationTimestampTask', 'SetOriginationTimestampTask', 'modules/core/classes/SetOriginationTimestampTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'DeleteSessionsTask', 'DeleteSessionsTask', 'modules/core/classes/DeleteSessionsTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'ConvertDatabaseToUtf8Task', 'ConvertDatabaseToUtf8Task', 'modules/core/classes/ConvertDatabaseToUtf8Task.class', 'core', 'N;', '4'),
('CaptchaAdminOption', 'CoreCaptchaAdminOption', 'CoreCaptchaAdminOption', 'modules/core/classes/CoreCaptchaAdminOption.class', 'core', 'N;', '4'),
('GalleryAuthPlugin', 'SessionAuthPlugin', 'SessionAuthPlugin', 'modules/core/classes/GallerySession.class', 'core', 'N;', '4'),
('GalleryEventListener', 'GalleryItemHelper_medium', 'GalleryItemHelper_medium', 'modules/core/classes/helpers/GalleryItemHelper_medium.class', 'core', 'a:4:{i:0;s:27:"gallery::viewabletreechange";i:1;s:25:"gallery::removepermission";i:2;s:19:"galleryentity::save";i:3;s:21:"galleryentity::delete";}', '4'),
('GalleryEventListener', 'GalleryUserHelper_medium', 'GalleryUserHelper_medium', 'modules/core/classes/helpers/GalleryUserHelper_medium.class', 'core', 'a:2:{i:0;s:20:"gallery::failedlogin";i:1;s:14:"gallery::login";}', '4'),
('GalleryEventListener', 'AlbumSelectModule', 'AlbumSelectModule', 'modules/albumselect/module.inc', 'albumselect', 'a:3:{i:0;s:27:"gallery::viewabletreechange";i:1;s:18:"gallery::itemorder";i:2;s:19:"galleryentity::save";}', '5'),
('GalleryToolkit', 'ArchiveExtractToolkit', 'ArchiveUpload', 'modules/archiveupload/classes/ArchiveExtractToolkit.class', 'archiveupload', 'N;', '5'),
('GalleryValidationPlugin', 'CaptchaValidationPlugin', 'CaptchaValidationPlugin', 'modules/captcha/classes/CaptchaValidationPlugin.inc', 'captcha', 'N;', '5'),
('MaintenanceTask', 'ResetFailureCountsTask', 'ResetFailureCountsTask', 'modules/captcha/classes/ResetFailureCountsTask.class', 'captcha', 'N;', '5'),
('ColorPackInterface_1_0', 'ColorPackImpl', 'ColorPack', 'modules/colorpack/classes/ColorPackImpl.class', 'colorpack', 'N;', '5'),
('GalleryEventListener', 'GalleryCommentHelper', 'GalleryCommentHelper', 'modules/comment/classes/GalleryCommentHelper.class', 'comment', 'a:2:{i:0;s:21:"galleryentity::delete";i:1;s:19:"galleryentity::save";}', '5'),
('GalleryEntity', 'GalleryComment', 'GalleryComment', 'modules/comment/classes/GalleryComment.class', 'comment', 'N;', '5'),
('GallerySearchInterface_1_0', 'GalleryCommentSearch', 'comment', 'modules/comment/classes/GalleryCommentSearch.class', 'comment', 'N;', '5'),
('CaptchaAdminOption', 'CommentCaptchaAdminOption', 'CommentCaptchaAdminOption', 'modules/comment/classes/CommentCaptchaAdminOption.class', 'comment', 'N;', '5'),
('NotificationEvent_1_0', 'CommentAddNotification', 'CommentAddNotification', 'modules/comment/classes/CommentAddNotification.class', 'comment', 'a:1:{i:0;s:19:"galleryentity::save";}', '5'),
('ItemEditPlugin', 'CustomFieldItemEdit', 'CustomFieldItemEdit', 'modules/customfield/CustomFieldItemEdit.inc', 'customfield', 'N;', '5'),
('CustomFieldInterface_1_0', 'CustomFieldHelper', 'CustomField', 'modules/customfield/classes/CustomFieldHelper.class', 'customfield', 'N;', '5'),
('GallerySearchInterface_1_0', 'CustomFieldSearch', 'CustomField', 'modules/customfield/classes/CustomFieldSearch.class', 'customfield', 'N;', '5'),
('GalleryEventListener', 'CustomFieldHelper', 'CustomFieldHelper', 'modules/customfield/classes/CustomFieldHelper.class', 'customfield', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('CartPluginInterface_1_0', 'DigibugCartPlugin', 'digibug', 'modules/digibug/classes/DigibugCartPlugin.class', 'digibug', 'N;', '5'),
('CartPluginInterface_1_1', 'DigibugCartPlugin', 'digibug', 'modules/digibug/classes/DigibugCartPlugin.class', 'digibug', 'N;', '5'),
('CaptchaAdminOption', 'EcardCaptchaAdminOption', 'EcardCaptchaAdminOption', 'modules/ecard/classes/EcardCaptchaAdminOption.class', 'ecard', 'N;', '5'),
('ExifInterface_1_0', 'ExifExtractor', 'Exif', 'modules/exif/classes/ExifExtractor.class', 'exif', 'N;', '5'),
('GalleryToolkit', 'ExifToolkit', 'Exif', 'modules/exif/classes/ExifToolkit.class', 'exif', 'N;', '5'),
('ItemAddOption', 'ExifDescriptionOption', 'ExifDescriptionOption', 'modules/exif/ExifDescriptionOption.inc', 'exif', 'N;', '5'),
('GalleryRenderer', 'FlashVideoRenderer', 'FlashVideoRenderer', 'modules/flashvideo/classes/FlashVideoRenderer.class', 'flashvideo', 'N;', '5'),
('ItemAddOption', 'FlashVideoOption', 'FlashVideoOption', 'modules/flashvideo/FlashVideoOption.inc', 'flashvideo', 'N;', '5'),
('CartPluginInterface_1_0', 'FotokastenCartPlugin', 'fotokasten', 'modules/fotokasten/classes/FotokastenCartPlugin.class', 'fotokasten', 'N;', '5'),
('CartPluginInterface_1_1', 'FotokastenCartPlugin', 'fotokasten', 'modules/fotokasten/classes/FotokastenCartPlugin.class', 'fotokasten', 'N;', '5'),
('Getid3Interface_1_0', 'Getid3Extractor', 'Getid3', 'modules/getid3/classes/Getid3Extractor.class', 'getid3', 'N;', '5'),
('GalleryToolkit', 'Getid3Toolkit', 'Getid3', 'modules/getid3/classes/Getid3Toolkit.class', 'getid3', 'N;', '5'),
('ItemAddOption', 'Getid3DescriptionOption', 'Getid3DescriptionOption', 'modules/getid3/Getid3DescriptionOption.inc', 'getid3', 'N;', '5'),
('GalleryEventListener', 'HiddenModule', 'HiddenModule', 'modules/hidden/module.inc', 'hidden', 'a:3:{i:0;s:27:"gallery::viewabletreechange";i:1;s:19:"galleryentity::save";i:2;s:21:"galleryentity::delete";}', '5'),
('GalleryOnLoadHandler', 'HiddenModule', 'Hidden', 'modules/hidden/module.inc', 'hidden', 'N;', '5'),
('ItemEditOption', 'HiddenItemOption', 'HiddenItemOption', 'modules/hidden/HiddenItemOption.inc', 'hidden', 'a:1:{i:0;s:12:"itemedititem";}', '5'),
('HiddenInterface_1_0', 'HiddenHelper', 'Hidden', 'modules/hidden/classes/HiddenHelper.class', 'hidden', 'N;', '5'),
('GalleryAuthPlugin', 'HttpAuthPlugin', 'HttpAuthPlugin', 'modules/httpauth/classes/HttpAuthPlugin.class', 'httpauth', 'N;', '5'),
('HttpAuthInterface_1_0', 'HttpAuthHelper', 'HttpAuthInterface', 'modules/httpauth/classes/HttpAuthHelper.class', 'httpauth', 'N;', '5'),
('GalleryEventListener', 'HttpAuthModule', 'HttpAuthModule', 'modules/httpauth/module.inc', 'httpauth', 'a:3:{i:0;s:23:"gallery::activateplugin";i:1;s:14:"gallery::error";i:2;s:15:"gallery::logout";}', '5'),
('IconsInterface_1_0', 'IconsImpl', 'Icons', 'modules/icons/classes/IconsImpl.class', 'icons', 'N;', '5'),
('GalleryEventListener', 'ImageBlockHelper', 'ImageBlockHelper', 'modules/imageblock/classes/ImageBlockHelper.class', 'imageblock', 'a:3:{i:0;s:27:"gallery::viewabletreechange";i:1;s:21:"galleryentity::delete";i:2;s:19:"galleryentity::save";}', '5'),
('ItemEditOption', 'ImageBlockOption', 'ImageBlockOption', 'modules/imageblock/ImageBlockOption.inc', 'imageblock', 'a:1:{i:0;s:13:"itemeditalbum";}', '5'),
('ImageFrameInterface_1_1', 'ImageFrameImpl', 'ImageFrame', 'modules/imageframe/classes/ImageFrameImpl.class', 'imageframe', 'N;', '5'),
('ItemAddPlugin', 'ItemAddFromWeb', 'ItemAddFromWeb', 'modules/itemadd/ItemAddFromWeb.inc', 'itemadd', 'N;', '3'),
('ItemAddPlugin', 'ItemAddFromServer', 'ItemAddFromServer', 'modules/itemadd/ItemAddFromServer.inc', 'itemadd', 'N;', '4'),
('GalleryEntity', 'GalleryLinkItem', 'GalleryLinkItem', 'modules/linkitem/classes/GalleryLinkItem.class', 'linkitem', 'N;', '5'),
('ItemAddPlugin', 'ItemAddLinkItem', 'ItemAddLinkItem', 'modules/linkitem/ItemAddLinkItem.inc', 'linkitem', 'N;', '5'),
('ItemEditOption', 'LinkItemOption', 'LinkItemOption', 'modules/linkitem/LinkItemOption.inc', 'linkitem', 'a:1:{i:0;s:12:"itemedititem";}', '5'),
('GalleryToolkit', 'LinkItemToolkit', 'LinkItemToolkit', 'modules/linkitem/classes/LinkItemToolkit.class', 'linkitem', 'N;', '5'),
('GalleryEventListener', 'LinkItemModule', 'LinkItemModule', 'modules/linkitem/module.inc', 'linkitem', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('GalleryEventListener', 'MigrateModule', 'MigrateModule', 'modules/migrate/module.inc', 'migrate', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('ItemAddOption', 'RestrictMimeOption', 'RestrictMimeOption', 'modules/mime/RestrictMimeOption.inc', 'mime', 'N;', '5'),
('GalleryRenderer', 'MP3AudioRenderer', 'MP3AudioRenderer', 'modules/mp3audio/classes/MP3AudioRenderer.class', 'mp3audio', 'N;', '5'),
('ItemAddOption', 'MP3AudioOption', 'MP3AudioOption', 'modules/mp3audio/MP3AudioOption.inc', 'mp3audio', 'N;', '5'),
('ItemEditPlugin', 'MultiLangItemEdit', 'MultiLangItemEdit', 'modules/multilang/MultiLangItemEdit.inc', 'multilang', 'N;', '5'),
('GalleryOnLoadHandler', 'MultiLangModule', 'MultiLang', 'modules/multilang/module.inc', 'multilang', 'N;', '5'),
('GallerySearchInterface_1_0', 'MultiLangSearch', 'MultiLang', 'modules/multilang/classes/MultiLangSearch.class', 'multilang', 'N;', '5'),
('GalleryEventListener', 'MultiLangModule', 'MultiLangModule', 'modules/multilang/module.inc', 'multilang', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('GallerySortInterface_1_2', 'NewItemsSortOrder', 'NewItems', 'modules/newitems/classes/NewItemsSortOrder.class', 'newitems', 'N;', '5'),
('NotificationHandler_1_0', 'NotificationMethodEmail', 'NotificationMethodEmail', 'modules/notification/classes/NotificationMethodEmail.class', 'notification', 'N;', '5'),
('GalleryEventListener', 'NotificationItemStateChangeHandler', 'NotificationItemStateChangeHandler', 'modules/notification/classes/NotificationItemStateChangeHandler.class', 'notification', 'a:2:{i:0;s:21:"galleryentity::delete";i:1;s:19:"galleryentity::save";}', '5'),
('ItemAddOption', 'NotificationItemsAddedOption', 'NotificationItemsAddedOption', 'modules/notification/NotificationItemsAddedOption.inc', 'notification', 'N;', '9'),
('NotificationEvent_1_0', 'ActivatePluginNotification', 'ActivatePluginNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:23:"gallery::activateplugin";}', '5'),
('NotificationEvent_1_0', 'DeactivatePluginNotification', 'DeactivatePluginNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:25:"gallery::deactivateplugin";}', '5'),
('NotificationEvent_1_0', 'ErrorNotification', 'ErrorNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:14:"gallery::error";}', '5'),
('NotificationEvent_1_0', 'ItemOrderNotification', 'ItemOrderNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:18:"gallery::itemorder";}', '5'),
('NotificationEvent_1_0', 'LoginNotification', 'LoginNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:14:"gallery::login";}', '5'),
('NotificationEvent_1_0', 'FailedLoginNotification', 'FailedLoginNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:20:"gallery::failedlogin";}', '5'),
('NotificationEvent_1_0', 'LogoutNotification', 'LogoutNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:15:"gallery::logout";}', '5'),
('NotificationEvent_1_0', 'RemovePermissionNotification', 'RemovePermissionNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:25:"gallery::removepermission";}', '5'),
('NotificationEvent_1_0', 'UninstallPluginNotification', 'UninstallPluginNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:24:"gallery::uninstallplugin";}', '5'),
('NotificationEvent_1_0', 'AlbumStructureChangeNotification', 'AlbumStructureChangeNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:27:"gallery::viewabletreechange";}', '5'),
('NotificationEvent_1_0', 'SaveNotification', 'SaveNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:19:"galleryentity::save";}', '5'),
('NotificationEvent_1_0', 'DeleteNotification', 'DeleteNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('NotificationEvent_1_0', 'ItemAddedNotification', 'ItemAddedNotification', 'modules/notification/classes/GalleryCoreEventNotifications.class', 'notification', 'a:1:{i:0;s:18:"gallery::itemadded";}', '5'),
('GalleryEventListener', 'NotificationRouter', 'NotificationRouter', 'modules/notification/classes/NotificationRouter.class', 'notification', 'N;', '4'),
('GalleryRenderer', 'PanoramaRenderer', 'PanoramaRenderer', 'modules/panorama/classes/PanoramaRenderer.class', 'panorama', 'N;', '5'),
('ItemEditOption', 'PanoramaOption', 'PanoramaOption', 'modules/panorama/PanoramaOption.inc', 'panorama', 'a:1:{i:0;s:13:"itemeditphoto";}', '5'),
('GalleryEventListener', 'PasswordModule', 'PasswordModule', 'modules/password/module.inc', 'password', 'a:1:{i:0;s:19:"galleryentity::save";}', '5'),
('GalleryOnLoadHandler', 'PasswordModule', 'Password', 'modules/password/module.inc', 'password', 'N;', '5'),
('ItemEditOption', 'PasswordOption', 'PasswordOption', 'modules/password/PasswordOption.inc', 'password', 'a:1:{i:0;s:12:"itemedititem";}', '5'),
('PasswordInterface_1_0', 'PasswordHelper', 'Password', 'modules/password/classes/PasswordHelper.class', 'password', 'N;', '5'),
('CaptchaAdminOption', 'PasswordCaptchaAdminOption', 'PasswordCaptchaAdminOption', 'modules/password/classes/PasswordCaptchaAdminOption.class', 'password', 'N;', '5'),
('ItemEditOption', 'PermalinksOption', 'PermalinksOption', 'modules/permalinks/PermalinksOption.inc', 'permalinks', 'a:1:{i:0;s:12:"itemedititem";}', '5'),
('GalleryEventListener', 'PermalinksModule', 'PermalinksModule', 'modules/permalinks/module.inc', 'permalinks', 'a:3:{i:0;s:25:"gallery::deactivateplugin";i:1;s:21:"galleryentity::delete";i:2;s:19:"galleryentity::save";}', '5'),
('CartPluginInterface_1_0', 'PhotoAccessCartPlugin', 'photoaccess', 'modules/photoaccess/classes/PhotoAccessCartPlugin.class', 'photoaccess', 'N;', '5'),
('CartPluginInterface_1_1', 'PhotoAccessCartPlugin', 'photoaccess', 'modules/photoaccess/classes/PhotoAccessCartPlugin.class', 'photoaccess', 'N;', '5'),
('ItemAddPlugin', 'ItemAddFromPicasa', 'ItemAddFromPicasa', 'modules/picasa/ItemAddFromPicasa.inc', 'picasa', 'N;', '5'),
('ItemAddPlugin', 'ItemAddPublishXp', 'ItemAddPublishXp', 'modules/publishxp/ItemAddPublishXp.inc', 'publishxp', 'N;', '5'),
('GalleryEventListener', 'QuotasModule', 'QuotasModule', 'modules/quotas/module.inc', 'quotas', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('ItemAddOption', 'DiskQuotaOption', 'DiskQuotaOption', 'modules/quotas/DiskQuotaOption.inc', 'quotas', 'N;', '9'),
('GalleryOnLoadHandler', 'RandomHighlightModule', 'RandomHighlight', 'modules/randomhighlight/module.inc', 'randomhighlight', 'N;', '5'),
('GalleryOnLoadHandler', 'RandomHighlightModule', 'RandomHighlightPrivate', 'modules/randomhighlight/module.inc', 'randomhighlight', 'N;', '5'),
('ItemEditOption', 'RandomHighlightOption', 'RandomHighlightOption', 'modules/randomhighlight/RandomHighlightOption.inc', 'randomhighlight', 'a:1:{i:0;s:13:"itemeditalbum";}', '5'),
('GalleryEventListener', 'RatingModule', 'RatingModule', 'modules/rating/module.inc', 'rating', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('ItemEditOption', 'RatingItemEdit', 'RatingItemEdit', 'modules/rating/RatingItemEdit.inc', 'rating', 'a:1:{i:0;s:13:"itemeditalbum";}', '5'),
('GallerySortInterface_1_2', 'RatingSortOrder', 'RatingSortOrder', 'modules/rating/classes/RatingSortOrder.class', 'rating', 'N;', '5'),
('GalleryEntity', 'GalleryPendingUser', 'GalleryPendingUser', 'modules/register/classes/GalleryPendingUser.class', 'register', 'N;', '5'),
('CaptchaAdminOption', 'RegisterCaptchaAdminOption', 'RegisterCaptchaAdminOption', 'modules/register/classes/RegisterCaptchaAdminOption.class', 'register', 'N;', '5'),
('ItemAddPlugin', 'ItemAddGalleryRemote', 'ItemAddGalleryRemote', 'modules/remote/ItemAddGalleryRemote.inc', 'remote', 'N;', '5'),
('ItemEditOption', 'ReuploadPhotoOption', 'ReuploadPhotoOption', 'modules/reupload/ReuploadPhotoOption.inc', 'reupload', 'a:1:{i:0;s:27:"itemeditrotateandscalephoto";}', '5'),
('GalleryEventListener', 'RssModule', 'RssModule', 'modules/rss/module.inc', 'rss', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('CartPluginInterface_1_0', 'ShutterflyCartPlugin', 'shutterfly', 'modules/shutterfly/classes/ShutterflyCartPlugin.class', 'shutterfly', 'N;', '5'),
('CartPluginInterface_1_1', 'ShutterflyCartPlugin', 'shutterfly', 'modules/shutterfly/classes/ShutterflyCartPlugin.class', 'shutterfly', 'N;', '5'),
('GalleryEventListener', 'SizelimitModule', 'SizelimitModule', 'modules/sizelimit/module.inc', 'sizelimit', 'a:1:{i:0;s:19:"galleryentity::save";}', '5'),
('ItemEditOption', 'SizeLimitOption', 'SizeLimitOption', 'modules/sizelimit/SizeLimitOption.inc', 'sizelimit', 'a:1:{i:0;s:13:"itemeditalbum";}', '5'),
('ItemAddOption', 'SetSizeOption', 'SetSizeOption', 'modules/sizelimit/SetSizeOption.inc', 'sizelimit', 'N;', '5'),
('SlideshowInterface_1_0', 'SlideshowImpl', 'Slideshow', 'modules/slideshow/classes/SlideshowImpl.class', 'slideshow', 'N;', '5'),
('GalleryEventListener', 'SlideshowModule', 'SlideshowModule', 'modules/slideshow/module.inc', 'slideshow', 'a:1:{i:0;s:22:"gallery::beforedisplay";}', '5'),
('CartPluginInterface_1_0', 'SnapGalaxyCartPlugin', 'snapgalaxy', 'modules/snapgalaxy/classes/SnapGalaxyCartPlugin.class', 'snapgalaxy', 'N;', '5'),
('CartPluginInterface_1_1', 'SnapGalaxyCartPlugin', 'snapgalaxy', 'modules/snapgalaxy/classes/SnapGalaxyCartPlugin.class', 'snapgalaxy', 'N;', '5'),
('GalleryEntity', 'ThumbnailImage', 'ThumbnailImage', 'modules/thumbnail/classes/ThumbnailImage.class', 'thumbnail', 'N;', '5'),
('GalleryToolkit', 'ThumbnailToolkit', 'Thumbnail', 'modules/thumbnail/classes/ThumbnailToolkit.class', 'thumbnail', 'N;', '5'),
('ItemEditOption', 'CustomThumbnailOption', 'CustomThumbnailOption', 'modules/thumbnail/CustomThumbnailOption.inc', 'thumbnail', 'a:1:{i:0;s:12:"itemedititem";}', '5'),
('GalleryEventListener', 'ThumbnailModule', 'ThumbnailModule', 'modules/thumbnail/module.inc', 'thumbnail', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('ItemAddPlugin', 'ItemAddUploadApplet', 'ItemAddUploadApplet', 'modules/uploadapplet/ItemAddUploadApplet.inc', 'uploadapplet', 'N;', '5'),
('GalleryEventListener', 'UserAlbumModule', 'UserAlbumModule', 'modules/useralbum/module.inc', 'useralbum', 'a:3:{i:0;s:21:"galleryentity::delete";i:1;s:19:"galleryentity::save";i:2;s:14:"gallery::login";}', '5'),
('GalleryEntity', 'WatermarkImage', 'WatermarkImage', 'modules/watermark/classes/WatermarkImage.class', 'watermark', 'N;', '5'),
('ItemEditPlugin', 'ItemEditWatermark', 'ItemEditWatermark', 'modules/watermark/ItemEditWatermark.inc', 'watermark', 'N;', '5'),
('ItemAddOption', 'WatermarkOption', 'WatermarkOption', 'modules/watermark/WatermarkOption.inc', 'watermark', 'N;', '5'),
('GalleryEventListener', 'WatermarkModule', 'WatermarkModule', 'modules/watermark/module.inc', 'watermark', 'a:1:{i:0;s:21:"galleryentity::delete";}', '5'),
('GalleryOnLoadHandler', 'WebCamModule', 'WebCam', 'modules/webcam/module.inc', 'webcam', 'N;', '5'),
('ItemAddPlugin', 'ItemAddWebCam', 'ItemAddWebCam', 'modules/webcam/ItemAddWebCam.inc', 'webcam', 'N;', '5'),
('ItemAddPlugin', 'ItemAddWebDav', 'ItemAddWebDav', 'modules/webdav/ItemAddWebDav.inc', 'webdav', 'N;', '5'),
('GalleryEventListener', 'WebDavModule', 'WebDavModule', 'modules/webdav/module.inc', 'webdav', 'a:1:{i:0;s:23:"gallery::activateplugin";}', '5'),
('CartPluginInterface_1_0', 'ZipCartPlugin', 'zipcart', 'modules/zipcart/classes/ZipCartPlugin.class', 'zipcart', 'N;', '5'),
('CartPluginInterface_1_1', 'ZipCartPlugin', 'zipcart', 'modules/zipcart/classes/ZipCartPlugin.class', 'zipcart', 'N;', '5'),
('GalleryToolkit', 'GdToolkit', 'Gd', 'modules/gd/classes/GdToolkit.class', 'gd', 'N;', '5');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]FailedLoginsMap`
--

CREATE TABLE `[[dbprefix]]FailedLoginsMap` (
  `g_userName` varchar(32) NOT NULL,
  `g_count` int(11) NOT NULL,
  `g_lastAttempt` int(11) NOT NULL,
  PRIMARY KEY (`g_userName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]FileSystemEntity`
--

CREATE TABLE `[[dbprefix]]FileSystemEntity` (
  `g_id` int(11) NOT NULL,
  `g_pathComponent` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]FileSystemEntity_3406` (`g_pathComponent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]FileSystemEntity`
--

INSERT INTO `[[dbprefix]]FileSystemEntity` VALUES
(7, NULL),
(25, 'G2audio.jpg'),
(27, 'G2video.jpg');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]G1MigrateMap`
--

CREATE TABLE `[[dbprefix]]G1MigrateMap` (
  `g_itemId` int(11) NOT NULL,
  `g_g1album` varchar(128) NOT NULL,
  `g_g1item` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_itemId`),
  KEY `[[dbprefix]]G1MigrateMap_41836` (`g_g1album`,`g_g1item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Getid3PropsMap`
--

CREATE TABLE `[[dbprefix]]Getid3PropsMap` (
  `g_property` varchar(128) DEFAULT NULL,
  `g_viewMode` int(11) DEFAULT NULL,
  `g_sequence` int(11) DEFAULT NULL,
  UNIQUE KEY `g_property` (`g_property`,`g_viewMode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Getid3PropsMap`
--

INSERT INTO `[[dbprefix]]Getid3PropsMap` VALUES
('Artist', 1, 0),
('Album', 1, 1),
('Track', 1, 2),
('Title', 1, 3),
('DateTime', 1, 4),
('Artist', 2, 0),
('Album', 2, 1),
('Track', 2, 2),
('Title', 2, 3),
('Genre', 2, 4),
('Year', 2, 5),
('DateTime', 2, 6),
('AudioBitRate', 2, 7),
('AudioBitRateMode', 2, 8),
('AudioChannels', 2, 9),
('AudioCodec', 2, 10),
('ChannelMode', 2, 11),
('VideoBitRate', 2, 12),
('VideoBitRateMode', 2, 13),
('VideoCodec', 2, 14);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Group`
--

CREATE TABLE `[[dbprefix]]Group` (
  `g_id` int(11) NOT NULL,
  `g_groupType` int(11) NOT NULL,
  `g_groupName` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  UNIQUE KEY `g_groupName` (`g_groupName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Group`
--

INSERT INTO `[[dbprefix]]Group` VALUES
(2, 2, 'Registered Users'),
(3, 3, 'Site Admins'),
(4, 4, 'Everybody');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ImageBlockCacheMap`
--

CREATE TABLE `[[dbprefix]]ImageBlockCacheMap` (
  `g_userId` int(11) NOT NULL,
  `g_itemType` int(11) NOT NULL,
  `g_itemTimestamp` int(11) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_random` int(11) DEFAULT NULL,
  KEY `[[dbprefix]]ImageBlockCacheMap_48758` (`g_userId`,`g_itemType`,`g_random`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ImageBlockDisabledMap`
--

CREATE TABLE `[[dbprefix]]ImageBlockDisabledMap` (
  `g_itemId` int(11) NOT NULL,
  PRIMARY KEY (`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Item`
--

CREATE TABLE `[[dbprefix]]Item` (
  `g_id` int(11) NOT NULL,
  `g_canContainChildren` int(1) NOT NULL,
  `g_description` text,
  `g_keywords` varchar(255) DEFAULT NULL,
  `g_ownerId` int(11) NOT NULL,
  `g_renderer` varchar(128) DEFAULT NULL,
  `g_summary` varchar(255) DEFAULT NULL,
  `g_title` varchar(128) DEFAULT NULL,
  `g_viewedSinceTimestamp` int(11) NOT NULL,
  `g_originationTimestamp` int(11) NOT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]Item_99070` (`g_keywords`),
  KEY `[[dbprefix]]Item_21573` (`g_ownerId`),
  KEY `[[dbprefix]]Item_54147` (`g_summary`),
  KEY `[[dbprefix]]Item_90059` (`g_title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Item`
--

INSERT INTO `[[dbprefix]]Item` VALUES
(7, 1, 'This is the main page of your Gallery', NULL, 6, NULL, NULL, 'Gallery', [[timestamp]], [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ItemAttributesMap`
--

CREATE TABLE `[[dbprefix]]ItemAttributesMap` (
  `g_itemId` int(11) NOT NULL,
  `g_viewCount` int(11) DEFAULT NULL,
  `g_orderWeight` int(11) DEFAULT NULL,
  `g_parentSequence` varchar(255) NOT NULL,
  PRIMARY KEY (`g_itemId`),
  KEY `[[dbprefix]]ItemAttributesMap_95270` (`g_parentSequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]ItemAttributesMap`
--

INSERT INTO `[[dbprefix]]ItemAttributesMap` VALUES
(7, 1, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ItemHiddenMap`
--

CREATE TABLE `[[dbprefix]]ItemHiddenMap` (
  `g_itemId` int(11) NOT NULL,
  PRIMARY KEY (`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]LinkItem`
--

CREATE TABLE `[[dbprefix]]LinkItem` (
  `g_id` int(11) NOT NULL,
  `g_link` text NOT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Lock`
--

CREATE TABLE `[[dbprefix]]Lock` (
  `g_lockId` int(11) DEFAULT NULL,
  `g_readEntityId` int(11) DEFAULT NULL,
  `g_writeEntityId` int(11) DEFAULT NULL,
  `g_freshUntil` int(11) DEFAULT NULL,
  `g_request` int(11) DEFAULT NULL,
  KEY `[[dbprefix]]Lock_11039` (`g_lockId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]MaintenanceMap`
--

CREATE TABLE `[[dbprefix]]MaintenanceMap` (
  `g_runId` int(11) NOT NULL,
  `g_taskId` varchar(128) NOT NULL,
  `g_timestamp` int(11) DEFAULT NULL,
  `g_success` int(1) DEFAULT NULL,
  `g_details` text,
  PRIMARY KEY (`g_runId`),
  KEY `[[dbprefix]]MaintenanceMap_21687` (`g_taskId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]MimeTypeMap`
--

CREATE TABLE `[[dbprefix]]MimeTypeMap` (
  `g_extension` varchar(32) NOT NULL,
  `g_mimeType` varchar(128) NOT NULL,
  `g_viewable` int(1) DEFAULT NULL,
  PRIMARY KEY (`g_extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]MimeTypeMap`
--

INSERT INTO `[[dbprefix]]MimeTypeMap` VALUES
('ai', 'application/postscript', 0),
('aif', 'audio/x-aiff', 0),
('aifc', 'audio/x-aiff', 0),
('aiff', 'audio/x-aiff', 0),
('asc', 'text/plain', 0),
('asf', 'video/x-ms-asf', 0),
('asx', 'video/x-ms-asx', 0),
('au', 'audio/basic', 0),
('avi', 'video/x-msvideo', 0),
('bcpio', 'application/x-bcpio', 0),
('bin', 'application/octet-stream', 0),
('bmp', 'image/bmp', 0),
('cdf', 'application/x-netcdf', 0),
('class', 'application/octet-stream', 0),
('cpio', 'application/x-cpio', 0),
('cpt', 'application/mac-compactpro', 0),
('csh', 'application/x-csh', 0),
('css', 'text/css', 0),
('dcr', 'application/x-director', 0),
('dir', 'application/x-director', 0),
('djv', 'image/vnd.djvu', 0),
('djvu', 'image/vnd.djvu', 0),
('dll', 'application/octet-stream', 0),
('dms', 'application/octet-stream', 0),
('doc', 'application/msword', 0),
('dvi', 'application/x-dvi', 0),
('dxr', 'application/x-director', 0),
('eps', 'application/postscript', 0),
('etx', 'text/x-setext', 0),
('exe', 'application/octet-stream', 0),
('ez', 'application/andrew-inset', 0),
('flv', 'video/x-flv', 0),
('gif', 'image/gif', 1),
('gtar', 'application/x-gtar', 0),
('gz', 'application/x-gzip', 0),
('hdf', 'application/x-hdf', 0),
('hqx', 'application/mac-binhex40', 0),
('ice', 'x-conference/x-cooltalk', 0),
('ief', 'image/ief', 0),
('iges', 'model/iges', 0),
('igs', 'model/iges', 0),
('jp2', 'image/jp2', 0),
('jpe', 'image/jpeg', 1),
('jpeg', 'image/jpeg', 1),
('jpf', 'image/jpx', 0),
('jpg', 'image/jpeg', 1),
('jpg2', 'image/jp2', 0),
('jpgcmyk', 'image/jpeg-cmyk', 0),
('jpgm', 'image/jpgm', 0),
('jpm', 'image/jpm', 0),
('jpx', 'image/jpx', 0),
('js', 'application/x-javascript', 0),
('kar', 'audio/midi', 0),
('latex', 'application/x-latex', 0),
('lha', 'application/octet-stream', 0),
('lzh', 'application/octet-stream', 0),
('m3u', 'audio/x-mpegurl', 0),
('man', 'application/x-troff-man', 0),
('me', 'application/x-troff-me', 0),
('mesh', 'model/mesh', 0),
('mid', 'audio/midi', 0),
('midi', 'audio/midi', 0),
('mif', 'application/vnd.mif', 0),
('mj2', 'video/mj2', 0),
('mjp2', 'video/mj2', 0),
('mov', 'video/quicktime', 0),
('movie', 'video/x-sgi-movie', 0),
('mp2', 'audio/mpeg', 0),
('mp3', 'audio/mpeg', 0),
('mp4', 'video/mp4', 0),
('mpe', 'video/mpeg', 0),
('mpeg', 'video/mpeg', 0),
('mpg', 'video/mpeg', 0),
('mpga', 'audio/mpeg', 0),
('ms', 'application/x-troff-ms', 0),
('msh', 'model/mesh', 0),
('mxu', 'video/vnd.mpegurl', 0),
('nc', 'application/x-netcdf', 0),
('oda', 'application/oda', 0),
('pbm', 'image/x-portable-bitmap', 0),
('pcd', 'image/x-photo-cd', 0),
('pdb', 'chemical/x-pdb', 0),
('pdf', 'application/pdf', 0),
('pgm', 'image/x-portable-graymap', 0),
('pgn', 'application/x-chess-pgn', 0),
('png', 'image/png', 1),
('pnm', 'image/x-portable-anymap', 0),
('ppm', 'image/x-portable-pixmap', 0),
('ppt', 'application/vnd.ms-powerpoint', 0),
('ps', 'application/postscript', 0),
('psd', 'application/photoshop', 0),
('qt', 'video/quicktime', 0),
('ra', 'audio/x-realaudio', 0),
('ram', 'audio/x-pn-realaudio', 0),
('ras', 'image/x-cmu-raster', 0),
('rgb', 'image/x-rgb', 0),
('rm', 'audio/x-pn-realaudio', 0),
('roff', 'application/x-troff', 0),
('rpm', 'audio/x-pn-realaudio-plugin', 0),
('rtf', 'text/rtf', 0),
('rtx', 'text/richtext', 0),
('sgm', 'text/sgml', 0),
('sgml', 'text/sgml', 0),
('sh', 'application/x-sh', 0),
('shar', 'application/x-shar', 0),
('silo', 'model/mesh', 0),
('sit', 'application/x-stuffit', 0),
('skd', 'application/x-koan', 0),
('skm', 'application/x-koan', 0),
('skp', 'application/x-koan', 0),
('skt', 'application/x-koan', 0),
('smi', 'application/smil', 0),
('smil', 'application/smil', 0),
('snd', 'audio/basic', 0),
('so', 'application/octet-stream', 0),
('spl', 'application/x-futuresplash', 0),
('src', 'application/x-wais-source', 0),
('sv4cpio', 'application/x-sv4cpio', 0),
('sv4crc', 'application/x-sv4crc', 0),
('svg', 'image/svg+xml', 0),
('swf', 'application/x-shockwave-flash', 0),
('t', 'application/x-troff', 0),
('tar', 'application/x-tar', 0),
('tcl', 'application/x-tcl', 0),
('tex', 'application/x-tex', 0),
('texi', 'application/x-texinfo', 0),
('texinfo', 'application/x-texinfo', 0),
('tga', 'image/tga', 0),
('tif', 'image/tiff', 0),
('tifcmyk', 'image/tiff-cmyk', 0),
('tiff', 'image/tiff', 0),
('tr', 'application/x-troff', 0),
('tsv', 'text/tab-separated-values', 0),
('txt', 'text/plain', 0),
('ustar', 'application/x-ustar', 0),
('vcd', 'application/x-cdlink', 0),
('vrml', 'model/vrml', 0),
('vsd', 'application/vnd.visio', 0),
('wav', 'audio/x-wav', 0),
('wbmp', 'image/vnd.wap.wbmp', 0),
('wbxml', 'application/vnd.wap.wbxml', 0),
('wma', 'audio/x-ms-wma', 0),
('wmf', 'image/wmf', 0),
('wml', 'text/vnd.wap.wml', 0),
('wmlc', 'application/vnd.wap.wmlc', 0),
('wmls', 'text/vnd.wap.wmlscript', 0),
('wmlsc', 'application/vnd.wap.wmlscriptc', 0),
('wmv', 'video/x-ms-wmv', 0),
('wrl', 'model/vrml', 0),
('xbm', 'image/x-xbitmap', 0),
('xls', 'application/vnd.ms-excel', 0),
('xpm', 'image/x-xpixmap', 0),
('xsl', 'text/xml', 0),
('xwd', 'image/x-xwindowdump', 0),
('xyz', 'chemical/x-xyz', 0),
('z', 'application/x-compress', 0),
('zip', 'application/zip', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]MovieItem`
--

CREATE TABLE `[[dbprefix]]MovieItem` (
  `g_id` int(11) NOT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  `g_duration` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]MultiLangItemMap`
--

CREATE TABLE `[[dbprefix]]MultiLangItemMap` (
  `g_itemId` int(11) NOT NULL,
  `g_language` varchar(32) NOT NULL,
  `g_title` varchar(128) DEFAULT NULL,
  `g_summary` varchar(255) DEFAULT NULL,
  `g_description` text,
  PRIMARY KEY (`g_itemId`,`g_language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PendingUser`
--

CREATE TABLE `[[dbprefix]]PendingUser` (
  `g_id` int(11) NOT NULL,
  `g_userName` varchar(32) NOT NULL,
  `g_fullName` varchar(128) DEFAULT NULL,
  `g_hashedPassword` varchar(128) DEFAULT NULL,
  `g_email` varchar(128) DEFAULT NULL,
  `g_language` varchar(128) DEFAULT NULL,
  `g_registrationKey` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  UNIQUE KEY `g_userName` (`g_userName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PermalinksMap`
--

CREATE TABLE `[[dbprefix]]PermalinksMap` (
  `g_aliasName` varchar(128) NOT NULL,
  `g_destId` int(11) NOT NULL,
  PRIMARY KEY (`g_aliasName`),
  KEY `[[dbprefix]]PermalinksMap_84225` (`g_destId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PermissionSetMap`
--

CREATE TABLE `[[dbprefix]]PermissionSetMap` (
  `g_module` varchar(128) NOT NULL,
  `g_permission` varchar(128) NOT NULL,
  `g_description` varchar(255) DEFAULT NULL,
  `g_bits` int(11) NOT NULL,
  `g_flags` int(11) NOT NULL,
  UNIQUE KEY `g_permission` (`g_permission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]PermissionSetMap`
--

INSERT INTO `[[dbprefix]]PermissionSetMap` VALUES
('cart', 'cart.add', '[cart] Add to cart', 256, 0),
('comment', 'comment.add', '[comment] Add comments', 512, 0),
('comment', 'comment.all', '[comment] All access', 7680, 2),
('comment', 'comment.delete', '[comment] Delete comments', 2048, 0),
('comment', 'comment.edit', '[comment] Edit comments', 1024, 0),
('comment', 'comment.view', '[comment] View comments', 4096, 0),
('core', 'core.addAlbumItem', '[core] Add sub-album', 8, 0),
('core', 'core.addDataItem', '[core] Add sub-item', 16, 0),
('core', 'core.all', 'All access', 2147483647, 3),
('core', 'core.changePermissions', '[core] Change item permissions', 64, 0),
('core', 'core.delete', '[core] Delete item', 128, 0),
('core', 'core.edit', '[core] Edit item', 32, 0),
('core', 'core.view', '[core] View item', 1, 0),
('core', 'core.viewAll', '[core] View all versions', 7, 2),
('core', 'core.viewResizes', '[core] View resized version(s)', 2, 0),
('core', 'core.viewSource', '[core] View original version', 4, 0),
('digibug', 'digibug.print', '[digibug] Print', 8192, 0),
('ecard', 'ecard.send', '[ecard] Send eCards', 16384, 0),
('fotokasten', 'fotokasten.print', '[fotokasten] Print', 32768, 0),
('photoaccess', 'photoaccess.print', '[photoworks] Print', 65536, 0),
('rating', 'rating.add', '[rating] Add ratings', 131072, 0),
('rating', 'rating.all', '[rating] All access', 393216, 2),
('rating', 'rating.view', '[rating] View ratings', 262144, 0),
('shutterfly', 'shutterfly.print', '[shutterfly] Print', 524288, 0),
('snapgalaxy', 'snapgalaxy.print', '[snapgalaxy] Print', 1048576, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PhotoItem`
--

CREATE TABLE `[[dbprefix]]PhotoItem` (
  `g_id` int(11) NOT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PluginMap`
--

CREATE TABLE `[[dbprefix]]PluginMap` (
  `g_pluginType` varchar(32) NOT NULL,
  `g_pluginId` varchar(32) NOT NULL,
  `g_active` int(1) NOT NULL,
  PRIMARY KEY (`g_pluginType`,`g_pluginId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]PluginMap`
--

INSERT INTO `[[dbprefix]]PluginMap` VALUES
('module', 'albumselect', 1),
('module', 'archiveupload', 1),
('module', 'captcha', 1),
('module', 'cart', 1),
('module', 'colorpack', 1),
('module', 'comment', 1),
('module', 'core', 1),
('module', 'customfield', 1),
('module', 'dcraw', 0),
('module', 'debug', 1),
('module', 'digibug', 1),
('module', 'dynamicalbum', 1),
('module', 'ecard', 1),
('module', 'exif', 1),
('module', 'ffmpeg', 0),
('module', 'flashvideo', 1),
('module', 'fotokasten', 1),
('module', 'gd', 1),
('module', 'getid3', 1),
('module', 'hidden', 1),
('module', 'httpauth', 1),
('module', 'icons', 1),
('module', 'imageblock', 1),
('module', 'imageframe', 1),
('module', 'imagemagick', 0),
('module', 'itemadd', 1),
('module', 'jpegtran', 0),
('module', 'keyalbum', 1),
('module', 'linkitem', 1),
('module', 'members', 1),
('module', 'migrate', 1),
('module', 'mime', 1),
('module', 'mp3audio', 1),
('module', 'multilang', 1),
('module', 'multiroot', 0),
('module', 'netpbm', 0),
('module', 'newitems', 1),
('module', 'nokiaupload', 0),
('module', 'notification', 1),
('module', 'panorama', 1),
('module', 'password', 1),
('module', 'permalinks', 1),
('module', 'photoaccess', 1),
('module', 'picasa', 1),
('module', 'publishxp', 1),
('module', 'quotas', 1),
('module', 'randomhighlight', 1),
('module', 'rating', 1),
('module', 'rearrange', 1),
('module', 'register', 1),
('module', 'remote', 1),
('module', 'replica', 1),
('module', 'reupload', 1),
('module', 'rewrite', 0),
('module', 'rss', 1),
('module', 'search', 1),
('module', 'shutterfly', 1),
('module', 'sitemap', 1),
('module', 'sizelimit', 1),
('module', 'slideshow', 1),
('module', 'slideshowapplet', 1),
('module', 'snapgalaxy', 1),
('module', 'squarethumb', 0),
('module', 'thumbnail', 1),
('module', 'thumbpage', 0),
('module', 'uploadapplet', 1),
('module', 'useralbum', 1),
('module', 'watermark', 1),
('module', 'webcam', 1),
('module', 'webdav', 1),
('module', 'zipcart', 1),
('theme', 'matrix', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PluginPackageMap`
--

CREATE TABLE `[[dbprefix]]PluginPackageMap` (
  `g_pluginType` varchar(32) NOT NULL,
  `g_pluginId` varchar(32) NOT NULL,
  `g_packageName` varchar(32) NOT NULL,
  `g_packageVersion` varchar(32) NOT NULL,
  `g_packageBuild` varchar(32) NOT NULL,
  `g_locked` int(1) NOT NULL,
  KEY `[[dbprefix]]PluginPackageMap_80596` (`g_pluginType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]PluginPackageMap`
--

INSERT INTO `[[dbprefix]]PluginPackageMap` VALUES
('theme', 'matrix', 'base', '1.1.6', '20955', 1),
('theme', 'matrix', 'lang-af', '15342', '18175', 1),
('theme', 'matrix', 'lang-ar', '15342', '20954', 1),
('theme', 'matrix', 'lang-ca', '15342', '18175', 1),
('theme', 'matrix', 'lang-cs', '15342', '18175', 1),
('theme', 'matrix', 'lang-da', '15342', '18175', 1),
('theme', 'matrix', 'lang-de', '15342', '18175', 1),
('theme', 'matrix', 'lang-el', '15342', '18175', 1),
('theme', 'matrix', 'lang-en_GB', '15342', '18175', 1),
('theme', 'matrix', 'lang-es_AR', '15342', '18175', 1),
('theme', 'matrix', 'lang-es_MX', '15342', '20954', 1),
('theme', 'matrix', 'lang-es', '15342', '18175', 1),
('theme', 'matrix', 'lang-eu', '15342', '18175', 1),
('theme', 'matrix', 'lang-fa', '15342', '18175', 1),
('theme', 'matrix', 'lang-fi', '15342', '18175', 1),
('theme', 'matrix', 'lang-fr', '15342', '20954', 1),
('theme', 'matrix', 'lang-ga', '15342', '20954', 1),
('theme', 'matrix', 'lang-he', '15342', '18175', 1),
('theme', 'matrix', 'lang-hu', '15342', '18175', 1),
('theme', 'matrix', 'lang-is', '15342', '20954', 1),
('theme', 'matrix', 'lang-it', '15342', '18175', 1),
('theme', 'matrix', 'lang-ja', '15342', '18175', 1),
('theme', 'matrix', 'lang-ko', '15342', '18175', 1),
('theme', 'matrix', 'lang-lt', '15342', '18175', 1),
('theme', 'matrix', 'lang-lv', '15342', '18175', 1),
('theme', 'matrix', 'lang-nl', '15342', '18175', 1),
('theme', 'matrix', 'lang-no', '15342', '18175', 1),
('theme', 'matrix', 'lang-pl', '15342', '18175', 1),
('theme', 'matrix', 'lang-pt_BR', '15342', '20954', 1),
('theme', 'matrix', 'lang-pt', '15342', '20954', 1),
('theme', 'matrix', 'lang-ro', '15342', '20954', 1),
('theme', 'matrix', 'lang-ru', '15342', '18175', 1),
('theme', 'matrix', 'lang-sk', '15342', '20954', 1),
('theme', 'matrix', 'lang-sr', '15342', '18175', 1),
('theme', 'matrix', 'lang-sv', '15342', '18175', 1),
('theme', 'matrix', 'lang-tr', '15342', '18175', 1),
('theme', 'matrix', 'lang-uk', '15342', '18175', 1),
('theme', 'matrix', 'lang-vi', '15342', '18175', 1),
('theme', 'matrix', 'lang-zh_CN', '15342', '18175', 1),
('theme', 'matrix', 'lang-zh_TW', '15342', '18175', 1),
('module', 'core', 'base', '1.3.0.2', '20997', 1),
('module', 'core', 'lang-af', '18153', '18173', 1),
('module', 'core', 'lang-ar', '18153', '18173', 1),
('module', 'core', 'lang-bg', '18153', '18173', 1),
('module', 'core', 'lang-ca', '18153', '18173', 1),
('module', 'core', 'lang-cs', '18153', '18173', 1),
('module', 'core', 'lang-da', '18153', '18173', 1),
('module', 'core', 'lang-de', '18153', '18173', 1),
('module', 'core', 'lang-el', '18153', '20954', 1),
('module', 'core', 'lang-en_GB', '18153', '18173', 1),
('module', 'core', 'lang-es_AR', '18153', '18173', 1),
('module', 'core', 'lang-es_MX', '18153', '18173', 1),
('module', 'core', 'lang-es', '18153', '18173', 1),
('module', 'core', 'lang-et', '18153', '18173', 1),
('module', 'core', 'lang-eu', '18153', '18173', 1),
('module', 'core', 'lang-fa', '18153', '18173', 1),
('module', 'core', 'lang-fi', '18153', '18173', 1),
('module', 'core', 'lang-fr', '18153', '20954', 1),
('module', 'core', 'lang-ga', '18153', '18173', 1),
('module', 'core', 'lang-he', '18153', '18173', 1),
('module', 'core', 'lang-hu', '18153', '18173', 1),
('module', 'core', 'lang-is', '18153', '18173', 1),
('module', 'core', 'lang-it', '18153', '18173', 1),
('module', 'core', 'lang-ja', '18153', '18173', 1),
('module', 'core', 'lang-ko', '18153', '18173', 1),
('module', 'core', 'lang-lt', '18153', '18173', 1),
('module', 'core', 'lang-lv', '18153', '18173', 1),
('module', 'core', 'lang-nl', '18153', '18173', 1),
('module', 'core', 'lang-no', '18153', '18173', 1),
('module', 'core', 'lang-pl', '18153', '18173', 1),
('module', 'core', 'lang-pt_BR', '18153', '18173', 1),
('module', 'core', 'lang-pt', '18153', '18173', 1),
('module', 'core', 'lang-ro', '18153', '18173', 1),
('module', 'core', 'lang-ru', '18153', '18173', 1),
('module', 'core', 'lang-sk', '18153', '20954', 1),
('module', 'core', 'lang-sl', '18153', '20954', 1),
('module', 'core', 'lang-sr', '18153', '18173', 1),
('module', 'core', 'lang-sv', '18153', '18173', 1),
('module', 'core', 'lang-tr', '18153', '18173', 1),
('module', 'core', 'lang-uk', '18153', '18173', 1),
('module', 'core', 'lang-vi', '18153', '18173', 1),
('module', 'core', 'lang-zh_CN', '18153', '18173', 1),
('module', 'core', 'lang-zh_TW', '18153', '20954', 1),
('module', 'albumselect', 'base', '1.0.11', '20955', 1),
('module', 'albumselect', 'lang-af', '15342', '18173', 1),
('module', 'albumselect', 'lang-ar', '15342', '20954', 1),
('module', 'albumselect', 'lang-bg', '15342', '18173', 1),
('module', 'albumselect', 'lang-ca', '15342', '18173', 1),
('module', 'albumselect', 'lang-cs', '15342', '20954', 1),
('module', 'albumselect', 'lang-da', '15342', '18173', 1),
('module', 'albumselect', 'lang-de', '15342', '18173', 1),
('module', 'albumselect', 'lang-el', '15342', '20954', 1),
('module', 'albumselect', 'lang-en_GB', '15342', '18173', 1),
('module', 'albumselect', 'lang-es', '15342', '18173', 1),
('module', 'albumselect', 'lang-et', '15342', '18173', 1),
('module', 'albumselect', 'lang-eu', '15342', '18173', 1),
('module', 'albumselect', 'lang-fa', '15342', '18173', 1),
('module', 'albumselect', 'lang-fi', '15342', '20954', 1),
('module', 'albumselect', 'lang-fr', '15342', '20954', 1),
('module', 'albumselect', 'lang-he', '15342', '18173', 1),
('module', 'albumselect', 'lang-hu', '15342', '18173', 1),
('module', 'albumselect', 'lang-is', '15342', '20954', 1),
('module', 'albumselect', 'lang-it', '15342', '18173', 1),
('module', 'albumselect', 'lang-ja', '15342', '18173', 1),
('module', 'albumselect', 'lang-ko', '15342', '18173', 1),
('module', 'albumselect', 'lang-lt', '15342', '18173', 1),
('module', 'albumselect', 'lang-lv', '15342', '18173', 1),
('module', 'albumselect', 'lang-nl', '15342', '18173', 1),
('module', 'albumselect', 'lang-no', '15342', '20954', 1),
('module', 'albumselect', 'lang-pl', '15342', '18173', 1),
('module', 'albumselect', 'lang-pt_BR', '15342', '18173', 1),
('module', 'albumselect', 'lang-ro', '15342', '18173', 1),
('module', 'albumselect', 'lang-ru', '15342', '18173', 1),
('module', 'albumselect', 'lang-sk', '15342', '20954', 1),
('module', 'albumselect', 'lang-sl', '15342', '18173', 1),
('module', 'albumselect', 'lang-sr', '15342', '18173', 1),
('module', 'albumselect', 'lang-sv', '15342', '18173', 1),
('module', 'albumselect', 'lang-tr', '15342', '18173', 1),
('module', 'albumselect', 'lang-uk', '15342', '18173', 1),
('module', 'albumselect', 'lang-vi', '15342', '18173', 1),
('module', 'albumselect', 'lang-zh_CN', '15342', '18173', 1),
('module', 'albumselect', 'lang-zh_TW', '15342', '20954', 1),
('module', 'archiveupload', 'base', '1.0.10', '20955', 1),
('module', 'archiveupload', 'lang-af', '17028', '18173', 1),
('module', 'archiveupload', 'lang-ar', '17028', '20954', 1),
('module', 'archiveupload', 'lang-bg', '17028', '20954', 1),
('module', 'archiveupload', 'lang-ca', '17028', '18173', 1),
('module', 'archiveupload', 'lang-cs', '17028', '18173', 1),
('module', 'archiveupload', 'lang-da', '17028', '18173', 1),
('module', 'archiveupload', 'lang-de', '17028', '18173', 1),
('module', 'archiveupload', 'lang-el', '17028', '20954', 1),
('module', 'archiveupload', 'lang-en_GB', '17028', '18173', 1),
('module', 'archiveupload', 'lang-es', '17028', '18173', 1),
('module', 'archiveupload', 'lang-eu', '17028', '18173', 1),
('module', 'archiveupload', 'lang-fa', '17028', '18173', 1),
('module', 'archiveupload', 'lang-fi', '17028', '18173', 1),
('module', 'archiveupload', 'lang-fr', '17028', '20954', 1),
('module', 'archiveupload', 'lang-hu', '17028', '18173', 1),
('module', 'archiveupload', 'lang-is', '17028', '20954', 1),
('module', 'archiveupload', 'lang-it', '17028', '18173', 1),
('module', 'archiveupload', 'lang-ja', '17028', '18173', 1),
('module', 'archiveupload', 'lang-ko', '17028', '18173', 1),
('module', 'archiveupload', 'lang-lt', '17028', '18173', 1),
('module', 'archiveupload', 'lang-nl', '17028', '20954', 1),
('module', 'archiveupload', 'lang-no', '17028', '18173', 1),
('module', 'archiveupload', 'lang-pl', '17028', '18173', 1),
('module', 'archiveupload', 'lang-pt_BR', '17028', '18173', 1),
('module', 'archiveupload', 'lang-ro', '17028', '18173', 1),
('module', 'archiveupload', 'lang-ru', '17028', '18173', 1),
('module', 'archiveupload', 'lang-sk', '17028', '20954', 1),
('module', 'archiveupload', 'lang-sr', '17028', '18173', 1),
('module', 'archiveupload', 'lang-sv', '17028', '18173', 1),
('module', 'archiveupload', 'lang-tr', '17028', '18173', 1),
('module', 'archiveupload', 'lang-uk', '17028', '18173', 1),
('module', 'archiveupload', 'lang-vi', '17028', '18173', 1),
('module', 'archiveupload', 'lang-zh_CN', '17028', '18173', 1),
('module', 'archiveupload', 'lang-zh_TW', '17028', '20954', 1),
('module', 'captcha', 'base', '1.1.7', '20955', 1),
('module', 'captcha', 'lang-af', '16934', '18173', 1),
('module', 'captcha', 'lang-ar', '16934', '20954', 1),
('module', 'captcha', 'lang-bg', '16934', '20954', 1),
('module', 'captcha', 'lang-ca', '16934', '18173', 1),
('module', 'captcha', 'lang-cs', '16934', '18173', 1),
('module', 'captcha', 'lang-da', '16934', '18173', 1),
('module', 'captcha', 'lang-de', '16934', '18173', 1),
('module', 'captcha', 'lang-el', '16934', '20954', 1),
('module', 'captcha', 'lang-en_GB', '16934', '18173', 1),
('module', 'captcha', 'lang-es', '16934', '18173', 1),
('module', 'captcha', 'lang-et', '16934', '18173', 1),
('module', 'captcha', 'lang-eu', '16934', '18173', 1),
('module', 'captcha', 'lang-fi', '16934', '18173', 1),
('module', 'captcha', 'lang-fr', '16934', '20954', 1),
('module', 'captcha', 'lang-hu', '16934', '18173', 1),
('module', 'captcha', 'lang-it', '16934', '18173', 1),
('module', 'captcha', 'lang-ja', '16934', '18173', 1),
('module', 'captcha', 'lang-ko', '16934', '18173', 1),
('module', 'captcha', 'lang-lt', '16934', '18173', 1),
('module', 'captcha', 'lang-nl', '16934', '18173', 1),
('module', 'captcha', 'lang-no', '16934', '18173', 1),
('module', 'captcha', 'lang-pl', '16934', '18173', 1),
('module', 'captcha', 'lang-pt_BR', '16934', '18173', 1),
('module', 'captcha', 'lang-ro', '16934', '18173', 1),
('module', 'captcha', 'lang-ru', '16934', '18173', 1),
('module', 'captcha', 'lang-sk', '16934', '20954', 1),
('module', 'captcha', 'lang-sr', '16934', '18173', 1),
('module', 'captcha', 'lang-sv', '16934', '18173', 1),
('module', 'captcha', 'lang-tr', '16934', '18173', 1),
('module', 'captcha', 'lang-uk', '16934', '18173', 1),
('module', 'captcha', 'lang-vi', '16934', '18173', 1),
('module', 'captcha', 'lang-zh_CN', '16934', '18173', 1),
('module', 'captcha', 'lang-zh_TW', '16934', '20954', 1),
('module', 'cart', 'base', '1.0.12', '20955', 1),
('module', 'cart', 'lang-af', '15342', '18173', 1),
('module', 'cart', 'lang-ar', '15342', '20954', 1),
('module', 'cart', 'lang-bg', '15342', '18173', 1),
('module', 'cart', 'lang-ca', '15342', '18173', 1),
('module', 'cart', 'lang-cs', '15342', '20954', 1),
('module', 'cart', 'lang-da', '15342', '18173', 1),
('module', 'cart', 'lang-de', '15342', '18173', 1),
('module', 'cart', 'lang-el', '15342', '20954', 1),
('module', 'cart', 'lang-en_GB', '15342', '18173', 1),
('module', 'cart', 'lang-es', '15342', '18173', 1),
('module', 'cart', 'lang-et', '15342', '18173', 1),
('module', 'cart', 'lang-eu', '15342', '18173', 1),
('module', 'cart', 'lang-fi', '15342', '18173', 1),
('module', 'cart', 'lang-fr', '15342', '18173', 1),
('module', 'cart', 'lang-ga', '15342', '20954', 1),
('module', 'cart', 'lang-hu', '15342', '18173', 1),
('module', 'cart', 'lang-is', '15342', '20954', 1),
('module', 'cart', 'lang-it', '15342', '18173', 1),
('module', 'cart', 'lang-ja', '15342', '18173', 1),
('module', 'cart', 'lang-ko', '15342', '18173', 1),
('module', 'cart', 'lang-lt', '15342', '18173', 1),
('module', 'cart', 'lang-nl', '15342', '20954', 1),
('module', 'cart', 'lang-no', '15342', '20954', 1),
('module', 'cart', 'lang-pl', '15342', '18173', 1),
('module', 'cart', 'lang-pt_BR', '15342', '20954', 1),
('module', 'cart', 'lang-ro', '15342', '18173', 1),
('module', 'cart', 'lang-ru', '15342', '18173', 1),
('module', 'cart', 'lang-sk', '15342', '18173', 1),
('module', 'cart', 'lang-sr', '15342', '18173', 1),
('module', 'cart', 'lang-sv', '15342', '18173', 1),
('module', 'cart', 'lang-tr', '15342', '18173', 1),
('module', 'cart', 'lang-uk', '15342', '18173', 1),
('module', 'cart', 'lang-vi', '15342', '18173', 1),
('module', 'cart', 'lang-zh_CN', '15342', '18173', 1),
('module', 'cart', 'lang-zh_TW', '15342', '20954', 1),
('module', 'colorpack', 'base', '1.0.7', '20955', 1),
('module', 'colorpack', 'lang-af', '15342', '18173', 1),
('module', 'colorpack', 'lang-bg', '15342', '20954', 1),
('module', 'colorpack', 'lang-ca', '15342', '18173', 1),
('module', 'colorpack', 'lang-cs', '15342', '18173', 1),
('module', 'colorpack', 'lang-da', '15342', '18173', 1),
('module', 'colorpack', 'lang-de', '15342', '18173', 1),
('module', 'colorpack', 'lang-el', '15342', '20954', 1),
('module', 'colorpack', 'lang-en_GB', '15342', '18173', 1),
('module', 'colorpack', 'lang-es', '15342', '18173', 1),
('module', 'colorpack', 'lang-eu', '15342', '18173', 1),
('module', 'colorpack', 'lang-fi', '15342', '18173', 1),
('module', 'colorpack', 'lang-fr', '15342', '18173', 1),
('module', 'colorpack', 'lang-hu', '15342', '18173', 1),
('module', 'colorpack', 'lang-it', '15342', '18173', 1),
('module', 'colorpack', 'lang-ja', '15342', '18173', 1),
('module', 'colorpack', 'lang-ko', '15342', '18173', 1),
('module', 'colorpack', 'lang-lt', '15342', '18173', 1),
('module', 'colorpack', 'lang-nl', '15342', '18173', 1),
('module', 'colorpack', 'lang-no', '15342', '18173', 1),
('module', 'colorpack', 'lang-pl', '15342', '18173', 1),
('module', 'colorpack', 'lang-pt_BR', '15342', '18173', 1),
('module', 'colorpack', 'lang-ro', '15342', '18173', 1),
('module', 'colorpack', 'lang-ru', '15342', '18173', 1),
('module', 'colorpack', 'lang-sk', '15342', '18173', 1),
('module', 'colorpack', 'lang-sl', '15342', '18173', 1),
('module', 'colorpack', 'lang-sr', '15342', '18173', 1),
('module', 'colorpack', 'lang-sv', '15342', '18173', 1),
('module', 'colorpack', 'lang-tr', '15342', '18173', 1),
('module', 'colorpack', 'lang-uk', '15342', '18173', 1),
('module', 'colorpack', 'lang-zh_CN', '15342', '18173', 1),
('module', 'colorpack', 'lang-zh_TW', '15342', '18173', 1),
('module', 'comment', 'base', '1.1.14', '20955', 1),
('module', 'comment', 'lang-af', '17527', '18173', 1),
('module', 'comment', 'lang-ar', '17527', '20954', 1),
('module', 'comment', 'lang-bg', '17527', '18173', 1),
('module', 'comment', 'lang-ca', '17527', '18173', 1),
('module', 'comment', 'lang-cs', '17527', '18173', 1),
('module', 'comment', 'lang-da', '17527', '18173', 1),
('module', 'comment', 'lang-de', '17527', '18173', 1),
('module', 'comment', 'lang-el', '17527', '20954', 1),
('module', 'comment', 'lang-en_GB', '17527', '18173', 1),
('module', 'comment', 'lang-es_AR', '17527', '20954', 1),
('module', 'comment', 'lang-es_MX', '17527', '20954', 1),
('module', 'comment', 'lang-es', '17527', '18173', 1),
('module', 'comment', 'lang-et', '17527', '18173', 1),
('module', 'comment', 'lang-eu', '17527', '18173', 1),
('module', 'comment', 'lang-fa', '17527', '18173', 1),
('module', 'comment', 'lang-fi', '17527', '18173', 1),
('module', 'comment', 'lang-fr', '17527', '18173', 1),
('module', 'comment', 'lang-ga', '17527', '20954', 1),
('module', 'comment', 'lang-he', '17527', '18173', 1),
('module', 'comment', 'lang-hu', '17527', '18173', 1),
('module', 'comment', 'lang-is', '17527', '20954', 1),
('module', 'comment', 'lang-it', '17527', '18173', 1),
('module', 'comment', 'lang-ja', '17527', '18173', 1),
('module', 'comment', 'lang-ko', '17527', '18173', 1),
('module', 'comment', 'lang-lt', '17527', '18173', 1),
('module', 'comment', 'lang-lv', '17527', '18173', 1),
('module', 'comment', 'lang-nl', '17527', '18173', 1),
('module', 'comment', 'lang-no', '17527', '18173', 1),
('module', 'comment', 'lang-pl', '17527', '18173', 1),
('module', 'comment', 'lang-pt_BR', '17527', '18173', 1),
('module', 'comment', 'lang-pt', '17527', '20954', 1),
('module', 'comment', 'lang-ro', '17527', '18173', 1),
('module', 'comment', 'lang-ru', '17527', '20954', 1),
('module', 'comment', 'lang-sk', '17527', '18173', 1),
('module', 'comment', 'lang-sl', '17527', '20954', 1),
('module', 'comment', 'lang-sr', '17527', '18173', 1),
('module', 'comment', 'lang-sv', '17527', '18173', 1),
('module', 'comment', 'lang-tr', '17527', '18173', 1),
('module', 'comment', 'lang-uk', '17527', '18173', 1),
('module', 'comment', 'lang-vi', '17527', '18173', 1),
('module', 'comment', 'lang-zh_CN', '17527', '18173', 1),
('module', 'comment', 'lang-zh_TW', '17527', '18173', 1),
('module', 'customfield', 'base', '1.0.13', '20955', 1),
('module', 'customfield', 'lang-af', '15447', '18173', 1),
('module', 'customfield', 'lang-ar', '15447', '20954', 1),
('module', 'customfield', 'lang-ca', '15447', '18173', 1),
('module', 'customfield', 'lang-cs', '15447', '20954', 1),
('module', 'customfield', 'lang-da', '15447', '18173', 1),
('module', 'customfield', 'lang-de', '15447', '18173', 1),
('module', 'customfield', 'lang-el', '15447', '20954', 1),
('module', 'customfield', 'lang-en_GB', '15447', '18173', 1),
('module', 'customfield', 'lang-es', '15447', '18173', 1),
('module', 'customfield', 'lang-eu', '15447', '18173', 1),
('module', 'customfield', 'lang-fi', '15447', '18173', 1),
('module', 'customfield', 'lang-fr', '15447', '20954', 1),
('module', 'customfield', 'lang-hu', '15447', '18173', 1),
('module', 'customfield', 'lang-is', '15447', '20954', 1),
('module', 'customfield', 'lang-it', '15447', '18173', 1),
('module', 'customfield', 'lang-ja', '15447', '18173', 1),
('module', 'customfield', 'lang-ko', '15447', '18173', 1),
('module', 'customfield', 'lang-lt', '15447', '18173', 1),
('module', 'customfield', 'lang-nl', '15447', '18173', 1),
('module', 'customfield', 'lang-no', '15447', '18173', 1),
('module', 'customfield', 'lang-pl', '15447', '18173', 1),
('module', 'customfield', 'lang-ro', '15447', '18173', 1),
('module', 'customfield', 'lang-ru', '15447', '18173', 1),
('module', 'customfield', 'lang-sk', '15447', '18173', 1),
('module', 'customfield', 'lang-sr', '15447', '18173', 1),
('module', 'customfield', 'lang-sv', '15447', '18173', 1),
('module', 'customfield', 'lang-tr', '15447', '18173', 1),
('module', 'customfield', 'lang-uk', '15447', '18173', 1),
('module', 'customfield', 'lang-vi', '15447', '18173', 1),
('module', 'customfield', 'lang-zh_CN', '15447', '18173', 1),
('module', 'customfield', 'lang-zh_TW', '15447', '18173', 1),
('module', 'dcraw', 'base', '1.0.13', '20955', 1),
('module', 'dcraw', 'lang-af', '17028', '18173', 1),
('module', 'dcraw', 'lang-ar', '17028', '20954', 1),
('module', 'dcraw', 'lang-ca', '17028', '18173', 1),
('module', 'dcraw', 'lang-cs', '17028', '18173', 1),
('module', 'dcraw', 'lang-da', '17028', '18173', 1),
('module', 'dcraw', 'lang-de', '17028', '18173', 1),
('module', 'dcraw', 'lang-el', '17028', '20954', 1),
('module', 'dcraw', 'lang-en_GB', '17028', '18173', 1),
('module', 'dcraw', 'lang-es', '17028', '18173', 1),
('module', 'dcraw', 'lang-eu', '17028', '18173', 1),
('module', 'dcraw', 'lang-fi', '17028', '18173', 1),
('module', 'dcraw', 'lang-fr', '17028', '18173', 1),
('module', 'dcraw', 'lang-hu', '17028', '18173', 1),
('module', 'dcraw', 'lang-it', '17028', '18173', 1),
('module', 'dcraw', 'lang-ja', '17028', '18173', 1),
('module', 'dcraw', 'lang-ko', '17028', '18173', 1),
('module', 'dcraw', 'lang-lt', '17028', '18173', 1),
('module', 'dcraw', 'lang-nl', '17028', '18173', 1),
('module', 'dcraw', 'lang-no', '17028', '18173', 1),
('module', 'dcraw', 'lang-pl', '17028', '18173', 1),
('module', 'dcraw', 'lang-ro', '17028', '18173', 1),
('module', 'dcraw', 'lang-ru', '17028', '18173', 1),
('module', 'dcraw', 'lang-sk', '17028', '20954', 1),
('module', 'dcraw', 'lang-sr', '17028', '18173', 1),
('module', 'dcraw', 'lang-sv', '17028', '18173', 1),
('module', 'dcraw', 'lang-tr', '17028', '18173', 1),
('module', 'dcraw', 'lang-uk', '17028', '18173', 1),
('module', 'dcraw', 'lang-vi', '17028', '18173', 1),
('module', 'dcraw', 'lang-zh_CN', '17028', '18173', 1),
('module', 'dcraw', 'lang-zh_TW', '17028', '20954', 1),
('module', 'debug', 'base', '1.0.8', '20955', 1),
('module', 'debug', 'lang-af', '15342', '18173', 1),
('module', 'debug', 'lang-ar', '15342', '20954', 1),
('module', 'debug', 'lang-ca', '15342', '18173', 1),
('module', 'debug', 'lang-cs', '15342', '20954', 1),
('module', 'debug', 'lang-da', '15342', '18173', 1),
('module', 'debug', 'lang-de', '15342', '18173', 1),
('module', 'debug', 'lang-el', '15342', '18173', 1),
('module', 'debug', 'lang-en_GB', '15342', '18173', 1),
('module', 'debug', 'lang-es_AR', '15342', '20954', 1),
('module', 'debug', 'lang-es', '15342', '18173', 1),
('module', 'debug', 'lang-eu', '15342', '18173', 1),
('module', 'debug', 'lang-fi', '15342', '18173', 1),
('module', 'debug', 'lang-fr', '15342', '20954', 1),
('module', 'debug', 'lang-ga', '15342', '20954', 1),
('module', 'debug', 'lang-hu', '15342', '20954', 1),
('module', 'debug', 'lang-is', '15342', '20954', 1),
('module', 'debug', 'lang-it', '15342', '20954', 1),
('module', 'debug', 'lang-ja', '15342', '18173', 1),
('module', 'debug', 'lang-ko', '15342', '18173', 1),
('module', 'debug', 'lang-lt', '15342', '18173', 1),
('module', 'debug', 'lang-lv', '15342', '18173', 1),
('module', 'debug', 'lang-nl', '15342', '20954', 1),
('module', 'debug', 'lang-no', '15342', '18173', 1),
('module', 'debug', 'lang-pl', '15342', '18173', 1),
('module', 'debug', 'lang-ro', '15342', '18173', 1),
('module', 'debug', 'lang-ru', '15342', '18173', 1),
('module', 'debug', 'lang-sk', '15342', '20954', 1),
('module', 'debug', 'lang-sr', '15342', '18173', 1),
('module', 'debug', 'lang-sv', '15342', '18173', 1),
('module', 'debug', 'lang-tr', '15342', '18173', 1),
('module', 'debug', 'lang-uk', '15342', '18173', 1),
('module', 'debug', 'lang-vi', '15342', '18173', 1),
('module', 'debug', 'lang-zh_CN', '15342', '18173', 1),
('module', 'debug', 'lang-zh_TW', '15342', '20954', 1),
('module', 'digibug', 'base', '1.0.8', '20955', 1),
('module', 'digibug', 'lang-af', '17686', '18173', 1),
('module', 'digibug', 'lang-ar', '17686', '20954', 1),
('module', 'digibug', 'lang-ca', '17686', '18173', 1),
('module', 'digibug', 'lang-cs', '17686', '18173', 1),
('module', 'digibug', 'lang-da', '17686', '18173', 1),
('module', 'digibug', 'lang-de', '17686', '18173', 1),
('module', 'digibug', 'lang-el', '17686', '20954', 1),
('module', 'digibug', 'lang-en_GB', '17686', '18173', 1),
('module', 'digibug', 'lang-es', '17686', '18173', 1),
('module', 'digibug', 'lang-eu', '17686', '18173', 1),
('module', 'digibug', 'lang-fi', '17686', '18173', 1),
('module', 'digibug', 'lang-fr', '17686', '18173', 1),
('module', 'digibug', 'lang-hu', '17686', '20954', 1),
('module', 'digibug', 'lang-is', '17686', '20954', 1),
('module', 'digibug', 'lang-it', '17686', '18173', 1),
('module', 'digibug', 'lang-ja', '17686', '18173', 1),
('module', 'digibug', 'lang-ko', '17686', '18173', 1),
('module', 'digibug', 'lang-lt', '17686', '18173', 1),
('module', 'digibug', 'lang-nl', '17686', '20954', 1),
('module', 'digibug', 'lang-no', '17686', '18173', 1),
('module', 'digibug', 'lang-pl', '17686', '18173', 1),
('module', 'digibug', 'lang-ro', '17686', '18173', 1),
('module', 'digibug', 'lang-ru', '17686', '18173', 1),
('module', 'digibug', 'lang-sk', '17686', '18173', 1),
('module', 'digibug', 'lang-sr', '17686', '18173', 1),
('module', 'digibug', 'lang-sv', '17686', '18173', 1),
('module', 'digibug', 'lang-tr', '17686', '18173', 1),
('module', 'digibug', 'lang-uk', '17686', '18173', 1),
('module', 'digibug', 'lang-vi', '17686', '18173', 1),
('module', 'digibug', 'lang-zh_CN', '17686', '18173', 1),
('module', 'digibug', 'lang-zh_TW', '17686', '20954', 1),
('module', 'dynamicalbum', 'base', '1.0.3', '20955', 1),
('module', 'dynamicalbum', 'lang-af', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-ar', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-bg', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-ca', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-cs', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-da', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-de', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-el', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-en_GB', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-es_AR', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-es_MX', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-es', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-et', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-eu', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-fi', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-fr', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-ga', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-he', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-hu', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-it', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-ja', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-ko', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-lt', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-nl', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-no', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-pl', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-pt_BR', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-pt', '15447', '20954', 1),
('module', 'dynamicalbum', 'lang-ro', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-ru', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-sk', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-sl', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-sr', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-sv', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-tr', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-uk', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-vi', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-zh_CN', '15447', '18173', 1),
('module', 'dynamicalbum', 'lang-zh_TW', '15447', '20954', 1),
('module', 'ecard', 'base', '1.0.4', '20955', 1),
('module', 'ecard', 'lang-af', '16284', '18173', 1),
('module', 'ecard', 'lang-ar', '16284', '20954', 1),
('module', 'ecard', 'lang-ca', '16284', '18173', 1),
('module', 'ecard', 'lang-cs', '16284', '18173', 1),
('module', 'ecard', 'lang-da', '16284', '18173', 1),
('module', 'ecard', 'lang-de', '16284', '18173', 1),
('module', 'ecard', 'lang-el', '16284', '20954', 1),
('module', 'ecard', 'lang-en_GB', '16284', '18173', 1),
('module', 'ecard', 'lang-es', '16284', '20954', 1),
('module', 'ecard', 'lang-et', '16284', '18173', 1),
('module', 'ecard', 'lang-eu', '16284', '18173', 1),
('module', 'ecard', 'lang-fi', '16284', '18173', 1),
('module', 'ecard', 'lang-fr', '16284', '18173', 1),
('module', 'ecard', 'lang-hu', '16284', '18173', 1),
('module', 'ecard', 'lang-it', '16284', '18173', 1),
('module', 'ecard', 'lang-ja', '16284', '18173', 1),
('module', 'ecard', 'lang-ko', '16284', '18173', 1),
('module', 'ecard', 'lang-lt', '16284', '18173', 1),
('module', 'ecard', 'lang-nl', '16284', '18173', 1),
('module', 'ecard', 'lang-no', '16284', '18173', 1),
('module', 'ecard', 'lang-pl', '16284', '18173', 1),
('module', 'ecard', 'lang-pt_BR', '16284', '18173', 1),
('module', 'ecard', 'lang-ro', '16284', '18173', 1),
('module', 'ecard', 'lang-ru', '16284', '18173', 1),
('module', 'ecard', 'lang-sk', '16284', '18173', 1),
('module', 'ecard', 'lang-sr', '16284', '18173', 1),
('module', 'ecard', 'lang-sv', '16284', '18173', 1),
('module', 'ecard', 'lang-tr', '16284', '18173', 1),
('module', 'ecard', 'lang-uk', '16284', '18173', 1),
('module', 'ecard', 'lang-vi', '16284', '18173', 1),
('module', 'ecard', 'lang-zh_CN', '16284', '18173', 1),
('module', 'ecard', 'lang-zh_TW', '16284', '18173', 1),
('module', 'exif', 'base', '1.2.6', '20961', 1),
('module', 'exif', 'lang-af', '16853', '18173', 1),
('module', 'exif', 'lang-ar', '16853', '20954', 1),
('module', 'exif', 'lang-ca', '16853', '18173', 1),
('module', 'exif', 'lang-cs', '16853', '18173', 1),
('module', 'exif', 'lang-da', '16853', '18173', 1),
('module', 'exif', 'lang-de', '16853', '18173', 1),
('module', 'exif', 'lang-el', '16853', '20954', 1),
('module', 'exif', 'lang-en_GB', '16853', '18173', 1),
('module', 'exif', 'lang-es', '16853', '18173', 1),
('module', 'exif', 'lang-eu', '16853', '18173', 1),
('module', 'exif', 'lang-fa', '16853', '18173', 1),
('module', 'exif', 'lang-fi', '16853', '18173', 1),
('module', 'exif', 'lang-fr', '16853', '20954', 1),
('module', 'exif', 'lang-ga', '16853', '20954', 1),
('module', 'exif', 'lang-hu', '16853', '18173', 1),
('module', 'exif', 'lang-is', '16853', '20954', 1),
('module', 'exif', 'lang-it', '16853', '18173', 1),
('module', 'exif', 'lang-ja', '16853', '18173', 1),
('module', 'exif', 'lang-ko', '16853', '18173', 1),
('module', 'exif', 'lang-lt', '16853', '18173', 1),
('module', 'exif', 'lang-nl', '16853', '20954', 1),
('module', 'exif', 'lang-no', '16853', '18173', 1),
('module', 'exif', 'lang-pl', '16853', '18173', 1),
('module', 'exif', 'lang-pt_BR', '16853', '20954', 1),
('module', 'exif', 'lang-ro', '16853', '18173', 1),
('module', 'exif', 'lang-ru', '16853', '18173', 1),
('module', 'exif', 'lang-sk', '16853', '18173', 1),
('module', 'exif', 'lang-sl', '16853', '20954', 1),
('module', 'exif', 'lang-sr', '16853', '18173', 1),
('module', 'exif', 'lang-sv', '16853', '18173', 1),
('module', 'exif', 'lang-tr', '16853', '18173', 1),
('module', 'exif', 'lang-uk', '16853', '18173', 1),
('module', 'exif', 'lang-vi', '16853', '18173', 1),
('module', 'exif', 'lang-zh_CN', '16853', '18173', 1),
('module', 'exif', 'lang-zh_TW', '16853', '20954', 1),
('module', 'ffmpeg', 'base', '1.0.14', '20955', 1),
('module', 'ffmpeg', 'lang-af', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-ar', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-ca', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-cs', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-da', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-de', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-el', '18154', '20954', 1),
('module', 'ffmpeg', 'lang-en_GB', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-es', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-eu', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-fi', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-fr', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-ga', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-hu', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-is', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-it', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-ja', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-ko', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-lt', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-nl', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-no', '18154', '20954', 1),
('module', 'ffmpeg', 'lang-pl', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-pt', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-ro', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-ru', '18154', '20954', 1),
('module', 'ffmpeg', 'lang-sk', '18154', '20954', 1),
('module', 'ffmpeg', 'lang-sr', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-sv', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-tr', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-uk', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-vi', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-zh_CN', '18154', '18173', 1),
('module', 'ffmpeg', 'lang-zh_TW', '18154', '18173', 1),
('module', 'flashvideo', 'base', '1.0.3', '20955', 1),
('module', 'flashvideo', 'lang-ca', '17316', '18173', 1),
('module', 'flashvideo', 'lang-cs', '17316', '18173', 1),
('module', 'flashvideo', 'lang-da', '17316', '18173', 1),
('module', 'flashvideo', 'lang-de', '17316', '18173', 1),
('module', 'flashvideo', 'lang-el', '17316', '20954', 1),
('module', 'flashvideo', 'lang-en_GB', '17316', '18173', 1),
('module', 'flashvideo', 'lang-es', '17316', '18173', 1),
('module', 'flashvideo', 'lang-eu', '17316', '18173', 1),
('module', 'flashvideo', 'lang-fi', '17316', '18173', 1),
('module', 'flashvideo', 'lang-fr', '17316', '18173', 1),
('module', 'flashvideo', 'lang-hu', '17316', '18173', 1),
('module', 'flashvideo', 'lang-it', '17316', '18173', 1),
('module', 'flashvideo', 'lang-ja', '17316', '18173', 1),
('module', 'flashvideo', 'lang-lv', '17316', '18173', 1),
('module', 'flashvideo', 'lang-no', '17316', '18173', 1),
('module', 'flashvideo', 'lang-pl', '17316', '18173', 1),
('module', 'flashvideo', 'lang-ro', '17316', '18173', 1),
('module', 'flashvideo', 'lang-ru', '17316', '20954', 1),
('module', 'flashvideo', 'lang-sk', '17316', '18173', 1),
('module', 'flashvideo', 'lang-sr', '17316', '18173', 1),
('module', 'flashvideo', 'lang-sv', '17316', '18173', 1),
('module', 'flashvideo', 'lang-tr', '17316', '18173', 1),
('module', 'flashvideo', 'lang-uk', '17316', '18173', 1),
('module', 'flashvideo', 'lang-zh_TW', '17316', '18173', 1),
('module', 'fotokasten', 'base', '1.0.12', '20961', 1),
('module', 'fotokasten', 'lang-af', '17414', '18173', 1),
('module', 'fotokasten', 'lang-ar', '17414', '20954', 1),
('module', 'fotokasten', 'lang-ca', '17414', '18173', 1),
('module', 'fotokasten', 'lang-cs', '17414', '18173', 1),
('module', 'fotokasten', 'lang-da', '17414', '18173', 1),
('module', 'fotokasten', 'lang-de', '17414', '20954', 1),
('module', 'fotokasten', 'lang-el', '17414', '20954', 1),
('module', 'fotokasten', 'lang-en_GB', '17414', '18173', 1),
('module', 'fotokasten', 'lang-es', '17414', '18173', 1),
('module', 'fotokasten', 'lang-eu', '17414', '18173', 1),
('module', 'fotokasten', 'lang-fi', '17414', '18173', 1),
('module', 'fotokasten', 'lang-fr', '17414', '18173', 1),
('module', 'fotokasten', 'lang-hu', '17414', '18173', 1),
('module', 'fotokasten', 'lang-is', '17414', '20954', 1),
('module', 'fotokasten', 'lang-it', '17414', '18173', 1),
('module', 'fotokasten', 'lang-ja', '17414', '18173', 1),
('module', 'fotokasten', 'lang-ko', '17414', '18173', 1),
('module', 'fotokasten', 'lang-lt', '17414', '18173', 1),
('module', 'fotokasten', 'lang-nl', '17414', '20954', 1),
('module', 'fotokasten', 'lang-no', '17414', '18173', 1),
('module', 'fotokasten', 'lang-pl', '17414', '18173', 1),
('module', 'fotokasten', 'lang-ro', '17414', '18173', 1),
('module', 'fotokasten', 'lang-ru', '17414', '20954', 1),
('module', 'fotokasten', 'lang-sk', '17414', '18173', 1),
('module', 'fotokasten', 'lang-sr', '17414', '18173', 1),
('module', 'fotokasten', 'lang-sv', '17414', '18173', 1),
('module', 'fotokasten', 'lang-tr', '17414', '18173', 1),
('module', 'fotokasten', 'lang-uk', '17414', '18173', 1),
('module', 'fotokasten', 'lang-vi', '17414', '18173', 1),
('module', 'fotokasten', 'lang-zh_CN', '17414', '18173', 1),
('module', 'fotokasten', 'lang-zh_TW', '17414', '20954', 1),
('module', 'getid3', 'base', '1.0.7', '20961', 1),
('module', 'getid3', 'lang-af', '16376', '20954', 1),
('module', 'getid3', 'lang-ar', '16376', '20954', 1),
('module', 'getid3', 'lang-ca', '16376', '20954', 1),
('module', 'getid3', 'lang-cs', '16376', '20954', 1),
('module', 'getid3', 'lang-da', '16376', '18173', 1),
('module', 'getid3', 'lang-de', '16376', '18173', 1),
('module', 'getid3', 'lang-el', '16376', '20954', 1),
('module', 'getid3', 'lang-en_GB', '16376', '18173', 1),
('module', 'getid3', 'lang-es', '16376', '18173', 1),
('module', 'getid3', 'lang-eu', '16376', '20954', 1),
('module', 'getid3', 'lang-fi', '16376', '18173', 1),
('module', 'getid3', 'lang-fr', '16376', '20954', 1),
('module', 'getid3', 'lang-hu', '16376', '20954', 1),
('module', 'getid3', 'lang-it', '16376', '18173', 1),
('module', 'getid3', 'lang-ja', '16376', '20954', 1),
('module', 'getid3', 'lang-ko', '16376', '20954', 1),
('module', 'getid3', 'lang-lt', '16376', '18173', 1),
('module', 'getid3', 'lang-nl', '16376', '20954', 1),
('module', 'getid3', 'lang-no', '16376', '20954', 1),
('module', 'getid3', 'lang-pl', '16376', '18173', 1),
('module', 'getid3', 'lang-ro', '16376', '20954', 1),
('module', 'getid3', 'lang-ru', '16376', '20954', 1),
('module', 'getid3', 'lang-sk', '16376', '18173', 1),
('module', 'getid3', 'lang-sr', '16376', '18173', 1),
('module', 'getid3', 'lang-sv', '16376', '18173', 1),
('module', 'getid3', 'lang-tr', '16376', '18173', 1),
('module', 'getid3', 'lang-uk', '16376', '18173', 1),
('module', 'getid3', 'lang-vi', '16376', '20954', 1),
('module', 'getid3', 'lang-zh_CN', '16376', '20954', 1),
('module', 'getid3', 'lang-zh_TW', '16376', '20954', 1),
('module', 'hidden', 'base', '1.0.9', '20955', 1),
('module', 'hidden', 'lang-ca', '15352', '17594', 1),
('module', 'hidden', 'lang-cs', '15352', '17594', 1),
('module', 'hidden', 'lang-da', '15352', '17594', 1),
('module', 'hidden', 'lang-de', '15352', '17594', 1),
('module', 'hidden', 'lang-el', '15352', '20954', 1),
('module', 'hidden', 'lang-en_GB', '15352', '17594', 1),
('module', 'hidden', 'lang-es', '15352', '17594', 1),
('module', 'hidden', 'lang-eu', '15352', '17594', 1),
('module', 'hidden', 'lang-fi', '15352', '17594', 1),
('module', 'hidden', 'lang-fr', '15352', '17594', 1),
('module', 'hidden', 'lang-hu', '15352', '17594', 1),
('module', 'hidden', 'lang-it', '15352', '17594', 1),
('module', 'hidden', 'lang-ja', '15352', '17594', 1),
('module', 'hidden', 'lang-ko', '15352', '17594', 1),
('module', 'hidden', 'lang-lv', '15352', '17594', 1),
('module', 'hidden', 'lang-nl', '15352', '17594', 1),
('module', 'hidden', 'lang-no', '15352', '17594', 1),
('module', 'hidden', 'lang-pl', '15352', '17594', 1),
('module', 'hidden', 'lang-ro', '15352', '17594', 1),
('module', 'hidden', 'lang-ru', '15352', '17594', 1),
('module', 'hidden', 'lang-sk', '15352', '17925', 1),
('module', 'hidden', 'lang-sr', '15352', '17594', 1),
('module', 'hidden', 'lang-sv', '15352', '17594', 1),
('module', 'hidden', 'lang-tr', '15352', '17594', 1),
('module', 'hidden', 'lang-uk', '15352', '17594', 1),
('module', 'hidden', 'lang-zh_CN', '15352', '17594', 1),
('module', 'hidden', 'lang-zh_TW', '15352', '17594', 1),
('module', 'httpauth', 'base', '1.0.4', '20961', 1),
('module', 'httpauth', 'lang-af', '15727', '18173', 1),
('module', 'httpauth', 'lang-ar', '15727', '20954', 1),
('module', 'httpauth', 'lang-ca', '15727', '18173', 1),
('module', 'httpauth', 'lang-cs', '15727', '18173', 1),
('module', 'httpauth', 'lang-da', '15727', '18173', 1),
('module', 'httpauth', 'lang-de', '15727', '18173', 1),
('module', 'httpauth', 'lang-el', '15727', '20954', 1),
('module', 'httpauth', 'lang-en_GB', '15727', '18173', 1),
('module', 'httpauth', 'lang-es', '15727', '18173', 1),
('module', 'httpauth', 'lang-eu', '15727', '18173', 1),
('module', 'httpauth', 'lang-fi', '15727', '18173', 1),
('module', 'httpauth', 'lang-fr', '15727', '18173', 1),
('module', 'httpauth', 'lang-hu', '15727', '20954', 1),
('module', 'httpauth', 'lang-it', '15727', '18173', 1),
('module', 'httpauth', 'lang-ja', '15727', '18173', 1),
('module', 'httpauth', 'lang-ko', '15727', '18173', 1),
('module', 'httpauth', 'lang-lt', '15727', '18173', 1),
('module', 'httpauth', 'lang-no', '15727', '18173', 1),
('module', 'httpauth', 'lang-pl', '15727', '18173', 1),
('module', 'httpauth', 'lang-ro', '15727', '18173', 1),
('module', 'httpauth', 'lang-ru', '15727', '20954', 1),
('module', 'httpauth', 'lang-sk', '15727', '20954', 1),
('module', 'httpauth', 'lang-sr', '15727', '18173', 1),
('module', 'httpauth', 'lang-sv', '15727', '18173', 1),
('module', 'httpauth', 'lang-tr', '15727', '18173', 1),
('module', 'httpauth', 'lang-uk', '15727', '18173', 1),
('module', 'httpauth', 'lang-vi', '15727', '18173', 1),
('module', 'httpauth', 'lang-zh_CN', '15727', '18173', 1),
('module', 'httpauth', 'lang-zh_TW', '15727', '20954', 1),
('module', 'icons', 'base', '1.1.5', '20955', 1),
('module', 'icons', 'lang-af', '15342', '18173', 1),
('module', 'icons', 'lang-ar', '15342', '20954', 1),
('module', 'icons', 'lang-bg', '15342', '18173', 1),
('module', 'icons', 'lang-ca', '15342', '18173', 1),
('module', 'icons', 'lang-cs', '15342', '18173', 1),
('module', 'icons', 'lang-da', '15342', '18173', 1),
('module', 'icons', 'lang-de', '15342', '18173', 1),
('module', 'icons', 'lang-el', '15342', '20954', 1),
('module', 'icons', 'lang-en_GB', '15342', '18173', 1),
('module', 'icons', 'lang-es', '15342', '18173', 1),
('module', 'icons', 'lang-eu', '15342', '18173', 1),
('module', 'icons', 'lang-fa', '15342', '18173', 1),
('module', 'icons', 'lang-fi', '15342', '18173', 1),
('module', 'icons', 'lang-fr', '15342', '18173', 1),
('module', 'icons', 'lang-hu', '15342', '18173', 1),
('module', 'icons', 'lang-it', '15342', '18173', 1),
('module', 'icons', 'lang-ja', '15342', '18173', 1),
('module', 'icons', 'lang-ko', '15342', '18173', 1),
('module', 'icons', 'lang-lt', '15342', '18173', 1),
('module', 'icons', 'lang-nl', '15342', '20954', 1),
('module', 'icons', 'lang-no', '15342', '18173', 1),
('module', 'icons', 'lang-pl', '15342', '18173', 1),
('module', 'icons', 'lang-pt_BR', '15342', '20954', 1),
('module', 'icons', 'lang-ro', '15342', '18173', 1),
('module', 'icons', 'lang-ru', '15342', '18173', 1),
('module', 'icons', 'lang-sk', '15342', '20954', 1),
('module', 'icons', 'lang-sl', '15342', '18173', 1),
('module', 'icons', 'lang-sr', '15342', '18173', 1),
('module', 'icons', 'lang-sv', '15342', '18173', 1),
('module', 'icons', 'lang-tr', '15342', '18173', 1),
('module', 'icons', 'lang-uk', '15342', '18173', 1),
('module', 'icons', 'lang-vi', '15342', '18173', 1),
('module', 'icons', 'lang-zh_CN', '15342', '18173', 1),
('module', 'icons', 'lang-zh_TW', '15342', '20954', 1),
('module', 'imageblock', 'base', '1.1.9', '20955', 1),
('module', 'imageblock', 'lang-af', '16934', '18173', 1),
('module', 'imageblock', 'lang-ar', '16934', '20954', 1),
('module', 'imageblock', 'lang-bg', '16934', '18173', 1),
('module', 'imageblock', 'lang-ca', '16934', '20954', 1),
('module', 'imageblock', 'lang-cs', '16934', '18173', 1),
('module', 'imageblock', 'lang-da', '16934', '18173', 1),
('module', 'imageblock', 'lang-de', '16934', '18173', 1),
('module', 'imageblock', 'lang-el', '16934', '20954', 1),
('module', 'imageblock', 'lang-en_GB', '16934', '18173', 1),
('module', 'imageblock', 'lang-es', '16934', '18173', 1),
('module', 'imageblock', 'lang-et', '16934', '18173', 1),
('module', 'imageblock', 'lang-eu', '16934', '18173', 1),
('module', 'imageblock', 'lang-fa', '16934', '18173', 1),
('module', 'imageblock', 'lang-fi', '16934', '20954', 1),
('module', 'imageblock', 'lang-fr', '16934', '18173', 1),
('module', 'imageblock', 'lang-ga', '16934', '20954', 1),
('module', 'imageblock', 'lang-he', '16934', '18173', 1),
('module', 'imageblock', 'lang-hu', '16934', '18173', 1),
('module', 'imageblock', 'lang-is', '16934', '20954', 1),
('module', 'imageblock', 'lang-it', '16934', '18173', 1),
('module', 'imageblock', 'lang-ja', '16934', '18173', 1),
('module', 'imageblock', 'lang-ko', '16934', '18173', 1),
('module', 'imageblock', 'lang-lt', '16934', '18173', 1),
('module', 'imageblock', 'lang-lv', '16934', '18173', 1),
('module', 'imageblock', 'lang-nl', '16934', '18173', 1),
('module', 'imageblock', 'lang-no', '16934', '18173', 1),
('module', 'imageblock', 'lang-pl', '16934', '18173', 1),
('module', 'imageblock', 'lang-pt_BR', '16934', '20954', 1),
('module', 'imageblock', 'lang-ro', '16934', '18173', 1),
('module', 'imageblock', 'lang-ru', '16934', '18173', 1),
('module', 'imageblock', 'lang-sk', '16934', '20954', 1),
('module', 'imageblock', 'lang-sl', '16934', '18173', 1),
('module', 'imageblock', 'lang-sr', '16934', '18173', 1),
('module', 'imageblock', 'lang-sv', '16934', '18173', 1),
('module', 'imageblock', 'lang-tr', '16934', '18173', 1),
('module', 'imageblock', 'lang-uk', '16934', '18173', 1),
('module', 'imageblock', 'lang-vi', '16934', '18173', 1),
('module', 'imageblock', 'lang-zh_CN', '16934', '18173', 1),
('module', 'imageblock', 'lang-zh_TW', '16934', '20954', 1),
('module', 'imageframe', 'base', '1.0.7', '20955', 1),
('module', 'imageframe', 'lang-af', '15342', '17580', 1),
('module', 'imageframe', 'lang-ca', '15342', '17580', 1),
('module', 'imageframe', 'lang-cs', '15342', '17580', 1),
('module', 'imageframe', 'lang-da', '15342', '17580', 1),
('module', 'imageframe', 'lang-de', '15342', '17791', 1),
('module', 'imageframe', 'lang-el', '15342', '20954', 1),
('module', 'imageframe', 'lang-en_GB', '15342', '17580', 1),
('module', 'imageframe', 'lang-es', '15342', '17594', 1),
('module', 'imageframe', 'lang-eu', '15342', '17580', 1),
('module', 'imageframe', 'lang-fi', '15342', '17580', 1),
('module', 'imageframe', 'lang-fr', '15342', '17956', 1),
('module', 'imageframe', 'lang-hu', '15342', '17580', 1),
('module', 'imageframe', 'lang-is', '15342', '20954', 1),
('module', 'imageframe', 'lang-it', '15342', '17580', 1),
('module', 'imageframe', 'lang-ja', '15342', '17580', 1),
('module', 'imageframe', 'lang-ko', '15342', '17580', 1),
('module', 'imageframe', 'lang-lt', '15342', '17580', 1),
('module', 'imageframe', 'lang-lv', '15342', '17580', 1),
('module', 'imageframe', 'lang-nl', '15342', '20954', 1),
('module', 'imageframe', 'lang-no', '15342', '17580', 1),
('module', 'imageframe', 'lang-pl', '15342', '17580', 1),
('module', 'imageframe', 'lang-ro', '15342', '17580', 1),
('module', 'imageframe', 'lang-ru', '15342', '17580', 1),
('module', 'imageframe', 'lang-sk', '15342', '20954', 1),
('module', 'imageframe', 'lang-sl', '15342', '17688', 1),
('module', 'imageframe', 'lang-sr', '15342', '17580', 1),
('module', 'imageframe', 'lang-sv', '15342', '17580', 1),
('module', 'imageframe', 'lang-tr', '15342', '17580', 1),
('module', 'imageframe', 'lang-uk', '15342', '17580', 1),
('module', 'imageframe', 'lang-zh_CN', '15342', '17580', 1),
('module', 'imageframe', 'lang-zh_TW', '15342', '20954', 1),
('module', 'imagemagick', 'base', '1.1.6', '20961', 1),
('module', 'imagemagick', 'lang-af', '17028', '18173', 1),
('module', 'imagemagick', 'lang-ar', '17028', '20954', 1),
('module', 'imagemagick', 'lang-ca', '17028', '18173', 1),
('module', 'imagemagick', 'lang-cs', '17028', '18173', 1),
('module', 'imagemagick', 'lang-da', '17028', '18173', 1),
('module', 'imagemagick', 'lang-de', '17028', '18173', 1),
('module', 'imagemagick', 'lang-el', '17028', '20954', 1),
('module', 'imagemagick', 'lang-en_GB', '17028', '18173', 1),
('module', 'imagemagick', 'lang-es_AR', '17028', '20954', 1),
('module', 'imagemagick', 'lang-es', '17028', '18173', 1),
('module', 'imagemagick', 'lang-eu', '17028', '18173', 1),
('module', 'imagemagick', 'lang-fi', '17028', '18173', 1),
('module', 'imagemagick', 'lang-fr', '17028', '20954', 1),
('module', 'imagemagick', 'lang-ga', '17028', '20954', 1),
('module', 'imagemagick', 'lang-hu', '17028', '20954', 1),
('module', 'imagemagick', 'lang-is', '17028', '20954', 1),
('module', 'imagemagick', 'lang-it', '17028', '18173', 1),
('module', 'imagemagick', 'lang-ja', '17028', '18173', 1),
('module', 'imagemagick', 'lang-ko', '17028', '18173', 1),
('module', 'imagemagick', 'lang-lt', '17028', '18173', 1),
('module', 'imagemagick', 'lang-lv', '17028', '18173', 1),
('module', 'imagemagick', 'lang-nl', '17028', '18173', 1),
('module', 'imagemagick', 'lang-no', '17028', '18173', 1),
('module', 'imagemagick', 'lang-pl', '17028', '18173', 1),
('module', 'imagemagick', 'lang-pt_BR', '17028', '20954', 1),
('module', 'imagemagick', 'lang-pt', '17028', '20954', 1),
('module', 'imagemagick', 'lang-ro', '17028', '18173', 1),
('module', 'imagemagick', 'lang-ru', '17028', '18173', 1),
('module', 'imagemagick', 'lang-sk', '17028', '20954', 1),
('module', 'imagemagick', 'lang-sl', '17028', '20954', 1),
('module', 'imagemagick', 'lang-sr', '17028', '18173', 1),
('module', 'imagemagick', 'lang-sv', '17028', '18173', 1),
('module', 'imagemagick', 'lang-tr', '17028', '18173', 1),
('module', 'imagemagick', 'lang-uk', '17028', '18173', 1),
('module', 'imagemagick', 'lang-vi', '17028', '18173', 1),
('module', 'imagemagick', 'lang-zh_CN', '17028', '18173', 1),
('module', 'imagemagick', 'lang-zh_TW', '17028', '20954', 1),
('module', 'itemadd', 'base', '1.0.9', '20955', 1),
('module', 'itemadd', 'lang-af', '17565', '18173', 1),
('module', 'itemadd', 'lang-ar', '17565', '18173', 1),
('module', 'itemadd', 'lang-bg', '17565', '18173', 1),
('module', 'itemadd', 'lang-ca', '17565', '18173', 1),
('module', 'itemadd', 'lang-cs', '17565', '18173', 1),
('module', 'itemadd', 'lang-da', '17565', '18173', 1),
('module', 'itemadd', 'lang-de', '17565', '18173', 1),
('module', 'itemadd', 'lang-el', '17565', '20954', 1),
('module', 'itemadd', 'lang-en_GB', '17565', '18173', 1),
('module', 'itemadd', 'lang-es_AR', '17565', '18173', 1),
('module', 'itemadd', 'lang-es_MX', '17565', '18173', 1),
('module', 'itemadd', 'lang-es', '17565', '18173', 1),
('module', 'itemadd', 'lang-et', '17565', '18173', 1),
('module', 'itemadd', 'lang-eu', '17565', '18173', 1),
('module', 'itemadd', 'lang-fi', '17565', '18173', 1),
('module', 'itemadd', 'lang-fr', '17565', '18173', 1),
('module', 'itemadd', 'lang-ga', '17565', '18173', 1),
('module', 'itemadd', 'lang-he', '17565', '18173', 1),
('module', 'itemadd', 'lang-hu', '17565', '18173', 1),
('module', 'itemadd', 'lang-is', '17565', '18173', 1),
('module', 'itemadd', 'lang-it', '17565', '18173', 1),
('module', 'itemadd', 'lang-ja', '17565', '18173', 1),
('module', 'itemadd', 'lang-ko', '17565', '18173', 1),
('module', 'itemadd', 'lang-lt', '17565', '18173', 1),
('module', 'itemadd', 'lang-nl', '17565', '18173', 1),
('module', 'itemadd', 'lang-no', '17565', '18173', 1),
('module', 'itemadd', 'lang-pl', '17565', '18173', 1),
('module', 'itemadd', 'lang-pt_BR', '17565', '18173', 1),
('module', 'itemadd', 'lang-pt', '17565', '18173', 1),
('module', 'itemadd', 'lang-ro', '17565', '18173', 1),
('module', 'itemadd', 'lang-ru', '17565', '18173', 1),
('module', 'itemadd', 'lang-sk', '17565', '18173', 1),
('module', 'itemadd', 'lang-sl', '17565', '18173', 1),
('module', 'itemadd', 'lang-sr', '17565', '18173', 1),
('module', 'itemadd', 'lang-sv', '17565', '18173', 1),
('module', 'itemadd', 'lang-tr', '17565', '18173', 1),
('module', 'itemadd', 'lang-uk', '17565', '18173', 1),
('module', 'itemadd', 'lang-vi', '17565', '18173', 1),
('module', 'itemadd', 'lang-zh_CN', '17565', '18173', 1),
('module', 'itemadd', 'lang-zh_TW', '17565', '20954', 1),
('module', 'jpegtran', 'base', '1.0.1', '20955', 1),
('module', 'jpegtran', 'lang-af', '17028', '20954', 1),
('module', 'jpegtran', 'lang-ar', '17028', '20954', 1),
('module', 'jpegtran', 'lang-bg', '17028', '20954', 1),
('module', 'jpegtran', 'lang-ca', '17028', '18174', 1),
('module', 'jpegtran', 'lang-cs', '17028', '20954', 1),
('module', 'jpegtran', 'lang-da', '17028', '18174', 1),
('module', 'jpegtran', 'lang-de', '17028', '18174', 1),
('module', 'jpegtran', 'lang-el', '17028', '20954', 1),
('module', 'jpegtran', 'lang-en_GB', '17028', '18174', 1),
('module', 'jpegtran', 'lang-es_AR', '17028', '20954', 1),
('module', 'jpegtran', 'lang-es_MX', '17028', '20954', 1),
('module', 'jpegtran', 'lang-es', '17028', '18174', 1),
('module', 'jpegtran', 'lang-et', '17028', '18174', 1),
('module', 'jpegtran', 'lang-eu', '17028', '20954', 1),
('module', 'jpegtran', 'lang-fi', '17028', '20954', 1),
('module', 'jpegtran', 'lang-fr', '17028', '20954', 1),
('module', 'jpegtran', 'lang-ga', '17028', '20954', 1),
('module', 'jpegtran', 'lang-he', '17028', '18174', 1),
('module', 'jpegtran', 'lang-hu', '17028', '18174', 1);
INSERT INTO `[[dbprefix]]PluginPackageMap` VALUES
('module', 'jpegtran', 'lang-it', '17028', '18174', 1),
('module', 'jpegtran', 'lang-ja', '17028', '20954', 1),
('module', 'jpegtran', 'lang-ko', '17028', '20954', 1),
('module', 'jpegtran', 'lang-lt', '17028', '18174', 1),
('module', 'jpegtran', 'lang-lv', '17028', '20954', 1),
('module', 'jpegtran', 'lang-nl', '17028', '20954', 1),
('module', 'jpegtran', 'lang-no', '17028', '20954', 1),
('module', 'jpegtran', 'lang-pl', '17028', '18174', 1),
('module', 'jpegtran', 'lang-pt_BR', '17028', '20954', 1),
('module', 'jpegtran', 'lang-pt', '17028', '18174', 1),
('module', 'jpegtran', 'lang-ro', '17028', '20954', 1),
('module', 'jpegtran', 'lang-ru', '17028', '18174', 1),
('module', 'jpegtran', 'lang-sk', '17028', '20954', 1),
('module', 'jpegtran', 'lang-sl', '17028', '18174', 1),
('module', 'jpegtran', 'lang-sr', '17028', '18174', 1),
('module', 'jpegtran', 'lang-sv', '17028', '18174', 1),
('module', 'jpegtran', 'lang-tr', '17028', '18174', 1),
('module', 'jpegtran', 'lang-uk', '17028', '18174', 1),
('module', 'jpegtran', 'lang-vi', '17028', '20954', 1),
('module', 'jpegtran', 'lang-zh_CN', '17028', '20954', 1),
('module', 'jpegtran', 'lang-zh_TW', '17028', '20954', 1),
('module', 'keyalbum', 'base', '1.0.6', '20955', 1),
('module', 'keyalbum', 'lang-af', '17316', '18174', 1),
('module', 'keyalbum', 'lang-ar', '17316', '20954', 1),
('module', 'keyalbum', 'lang-bg', '17316', '20954', 1),
('module', 'keyalbum', 'lang-ca', '17316', '18174', 1),
('module', 'keyalbum', 'lang-cs', '17316', '18174', 1),
('module', 'keyalbum', 'lang-da', '17316', '18174', 1),
('module', 'keyalbum', 'lang-de', '17316', '18174', 1),
('module', 'keyalbum', 'lang-el', '17316', '20954', 1),
('module', 'keyalbum', 'lang-en_GB', '17316', '18174', 1),
('module', 'keyalbum', 'lang-es_AR', '17316', '20954', 1),
('module', 'keyalbum', 'lang-es_MX', '17316', '20954', 1),
('module', 'keyalbum', 'lang-es', '17316', '18174', 1),
('module', 'keyalbum', 'lang-et', '17316', '18174', 1),
('module', 'keyalbum', 'lang-eu', '17316', '18174', 1),
('module', 'keyalbum', 'lang-fa', '17316', '18174', 1),
('module', 'keyalbum', 'lang-fi', '17316', '18174', 1),
('module', 'keyalbum', 'lang-fr', '17316', '20954', 1),
('module', 'keyalbum', 'lang-ga', '17316', '20954', 1),
('module', 'keyalbum', 'lang-he', '17316', '18174', 1),
('module', 'keyalbum', 'lang-hu', '17316', '20954', 1),
('module', 'keyalbum', 'lang-it', '17316', '18174', 1),
('module', 'keyalbum', 'lang-ja', '17316', '18174', 1),
('module', 'keyalbum', 'lang-ko', '17316', '18174', 1),
('module', 'keyalbum', 'lang-lt', '17316', '18174', 1),
('module', 'keyalbum', 'lang-nl', '17316', '18174', 1),
('module', 'keyalbum', 'lang-no', '17316', '18174', 1),
('module', 'keyalbum', 'lang-pl', '17316', '18174', 1),
('module', 'keyalbum', 'lang-pt_BR', '17316', '20954', 1),
('module', 'keyalbum', 'lang-pt', '17316', '20954', 1),
('module', 'keyalbum', 'lang-ro', '17316', '18174', 1),
('module', 'keyalbum', 'lang-ru', '17316', '18174', 1),
('module', 'keyalbum', 'lang-sk', '17316', '18174', 1),
('module', 'keyalbum', 'lang-sl', '17316', '18174', 1),
('module', 'keyalbum', 'lang-sr', '17316', '18174', 1),
('module', 'keyalbum', 'lang-sv', '17316', '18174', 1),
('module', 'keyalbum', 'lang-tr', '17316', '18174', 1),
('module', 'keyalbum', 'lang-uk', '17316', '18174', 1),
('module', 'keyalbum', 'lang-vi', '17316', '18174', 1),
('module', 'keyalbum', 'lang-zh_CN', '17316', '18174', 1),
('module', 'keyalbum', 'lang-zh_TW', '17316', '20954', 1),
('module', 'linkitem', 'base', '1.1.7', '20955', 1),
('module', 'linkitem', 'lang-af', '15342', '18174', 1),
('module', 'linkitem', 'lang-ar', '15342', '20954', 1),
('module', 'linkitem', 'lang-bg', '15342', '20954', 1),
('module', 'linkitem', 'lang-ca', '15342', '18174', 1),
('module', 'linkitem', 'lang-cs', '15342', '18174', 1),
('module', 'linkitem', 'lang-da', '15342', '18174', 1),
('module', 'linkitem', 'lang-de', '15342', '18174', 1),
('module', 'linkitem', 'lang-el', '15342', '20954', 1),
('module', 'linkitem', 'lang-en_GB', '15342', '18174', 1),
('module', 'linkitem', 'lang-es_AR', '15342', '20954', 1),
('module', 'linkitem', 'lang-es_MX', '15342', '20954', 1),
('module', 'linkitem', 'lang-es', '15342', '18174', 1),
('module', 'linkitem', 'lang-et', '15342', '18174', 1),
('module', 'linkitem', 'lang-eu', '15342', '18174', 1),
('module', 'linkitem', 'lang-fi', '15342', '18174', 1),
('module', 'linkitem', 'lang-fr', '15342', '18174', 1),
('module', 'linkitem', 'lang-ga', '15342', '20954', 1),
('module', 'linkitem', 'lang-he', '15342', '18174', 1),
('module', 'linkitem', 'lang-hu', '15342', '18174', 1),
('module', 'linkitem', 'lang-it', '15342', '18174', 1),
('module', 'linkitem', 'lang-ja', '15342', '18174', 1),
('module', 'linkitem', 'lang-ko', '15342', '18174', 1),
('module', 'linkitem', 'lang-lt', '15342', '18174', 1),
('module', 'linkitem', 'lang-nl', '15342', '18174', 1),
('module', 'linkitem', 'lang-no', '15342', '18174', 1),
('module', 'linkitem', 'lang-pl', '15342', '18174', 1),
('module', 'linkitem', 'lang-pt_BR', '15342', '20954', 1),
('module', 'linkitem', 'lang-pt', '15342', '20954', 1),
('module', 'linkitem', 'lang-ro', '15342', '18174', 1),
('module', 'linkitem', 'lang-ru', '15342', '18174', 1),
('module', 'linkitem', 'lang-sk', '15342', '18174', 1),
('module', 'linkitem', 'lang-sl', '15342', '20954', 1),
('module', 'linkitem', 'lang-sr', '15342', '18174', 1),
('module', 'linkitem', 'lang-sv', '15342', '18174', 1),
('module', 'linkitem', 'lang-tr', '15342', '18174', 1),
('module', 'linkitem', 'lang-uk', '15342', '18174', 1),
('module', 'linkitem', 'lang-vi', '15342', '18174', 1),
('module', 'linkitem', 'lang-zh_CN', '15342', '18174', 1),
('module', 'linkitem', 'lang-zh_TW', '15342', '18174', 1),
('module', 'members', 'base', '1.0.8', '20955', 1),
('module', 'members', 'lang-af', '15342', '18174', 1),
('module', 'members', 'lang-ar', '15342', '20954', 1),
('module', 'members', 'lang-bg', '15342', '18174', 1),
('module', 'members', 'lang-ca', '15342', '18174', 1),
('module', 'members', 'lang-cs', '15342', '20954', 1),
('module', 'members', 'lang-da', '15342', '18174', 1),
('module', 'members', 'lang-de', '15342', '18174', 1),
('module', 'members', 'lang-el', '15342', '20954', 1),
('module', 'members', 'lang-en_GB', '15342', '18174', 1),
('module', 'members', 'lang-es_AR', '15342', '20954', 1),
('module', 'members', 'lang-es_MX', '15342', '20954', 1),
('module', 'members', 'lang-es', '15342', '18174', 1),
('module', 'members', 'lang-et', '15342', '18174', 1),
('module', 'members', 'lang-eu', '15342', '18174', 1),
('module', 'members', 'lang-fi', '15342', '18174', 1),
('module', 'members', 'lang-fr', '15342', '20954', 1),
('module', 'members', 'lang-ga', '15342', '20954', 1),
('module', 'members', 'lang-he', '15342', '18174', 1),
('module', 'members', 'lang-hu', '15342', '18174', 1),
('module', 'members', 'lang-is', '15342', '20954', 1),
('module', 'members', 'lang-it', '15342', '18174', 1),
('module', 'members', 'lang-ja', '15342', '18174', 1),
('module', 'members', 'lang-ko', '15342', '18174', 1),
('module', 'members', 'lang-lt', '15342', '18174', 1),
('module', 'members', 'lang-lv', '15342', '18174', 1),
('module', 'members', 'lang-nl', '15342', '20954', 1),
('module', 'members', 'lang-no', '15342', '20954', 1),
('module', 'members', 'lang-pl', '15342', '18174', 1),
('module', 'members', 'lang-pt_BR', '15342', '20954', 1),
('module', 'members', 'lang-pt', '15342', '20954', 1),
('module', 'members', 'lang-ro', '15342', '18174', 1),
('module', 'members', 'lang-ru', '15342', '18174', 1),
('module', 'members', 'lang-sk', '15342', '20954', 1),
('module', 'members', 'lang-sl', '15342', '20954', 1),
('module', 'members', 'lang-sr', '15342', '18174', 1),
('module', 'members', 'lang-sv', '15342', '18174', 1),
('module', 'members', 'lang-tr', '15342', '18174', 1),
('module', 'members', 'lang-uk', '15342', '18174', 1),
('module', 'members', 'lang-vi', '15342', '18174', 1),
('module', 'members', 'lang-zh_CN', '15342', '20954', 1),
('module', 'members', 'lang-zh_TW', '15342', '18174', 1),
('module', 'migrate', 'base', '1.0.14', '20955', 1),
('module', 'migrate', 'lang-af', '16284', '18174', 1),
('module', 'migrate', 'lang-ar', '16284', '20954', 1),
('module', 'migrate', 'lang-ca', '16284', '18174', 1),
('module', 'migrate', 'lang-cs', '16284', '20954', 1),
('module', 'migrate', 'lang-da', '16284', '18174', 1),
('module', 'migrate', 'lang-de', '16284', '18174', 1),
('module', 'migrate', 'lang-el', '16284', '20954', 1),
('module', 'migrate', 'lang-en_GB', '16284', '18174', 1),
('module', 'migrate', 'lang-es', '16284', '18174', 1),
('module', 'migrate', 'lang-eu', '16284', '18174', 1),
('module', 'migrate', 'lang-fi', '16284', '18174', 1),
('module', 'migrate', 'lang-fr', '16284', '20954', 1),
('module', 'migrate', 'lang-ga', '16284', '20954', 1),
('module', 'migrate', 'lang-hu', '16284', '20954', 1),
('module', 'migrate', 'lang-is', '16284', '20954', 1),
('module', 'migrate', 'lang-it', '16284', '18174', 1),
('module', 'migrate', 'lang-ja', '16284', '20954', 1),
('module', 'migrate', 'lang-ko', '16284', '18174', 1),
('module', 'migrate', 'lang-lt', '16284', '18174', 1),
('module', 'migrate', 'lang-nl', '16284', '18174', 1),
('module', 'migrate', 'lang-no', '16284', '20954', 1),
('module', 'migrate', 'lang-pl', '16284', '18174', 1),
('module', 'migrate', 'lang-pt', '16284', '20954', 1),
('module', 'migrate', 'lang-ro', '16284', '18174', 1),
('module', 'migrate', 'lang-ru', '16284', '18174', 1),
('module', 'migrate', 'lang-sk', '16284', '18174', 1),
('module', 'migrate', 'lang-sr', '16284', '18174', 1),
('module', 'migrate', 'lang-sv', '16284', '18174', 1),
('module', 'migrate', 'lang-tr', '16284', '18174', 1),
('module', 'migrate', 'lang-uk', '16284', '18174', 1),
('module', 'migrate', 'lang-vi', '16284', '18174', 1),
('module', 'migrate', 'lang-zh_CN', '16284', '20954', 1),
('module', 'migrate', 'lang-zh_TW', '16284', '20954', 1),
('module', 'mime', 'base', '1.1.5', '20955', 1),
('module', 'mime', 'lang-af', '15447', '18174', 1),
('module', 'mime', 'lang-ar', '15447', '20954', 1),
('module', 'mime', 'lang-bg', '15447', '20954', 1),
('module', 'mime', 'lang-ca', '15447', '18174', 1),
('module', 'mime', 'lang-cs', '15447', '18174', 1),
('module', 'mime', 'lang-da', '15447', '18174', 1),
('module', 'mime', 'lang-de', '15447', '18174', 1),
('module', 'mime', 'lang-el', '15447', '20954', 1),
('module', 'mime', 'lang-en_GB', '15447', '18174', 1),
('module', 'mime', 'lang-es_AR', '15447', '20954', 1),
('module', 'mime', 'lang-es_MX', '15447', '20954', 1),
('module', 'mime', 'lang-es', '15447', '18174', 1),
('module', 'mime', 'lang-et', '15447', '18174', 1),
('module', 'mime', 'lang-eu', '15447', '18174', 1),
('module', 'mime', 'lang-fi', '15447', '18174', 1),
('module', 'mime', 'lang-fr', '15447', '20954', 1),
('module', 'mime', 'lang-ga', '15447', '20954', 1),
('module', 'mime', 'lang-he', '15447', '18174', 1),
('module', 'mime', 'lang-hu', '15447', '20954', 1),
('module', 'mime', 'lang-it', '15447', '18174', 1),
('module', 'mime', 'lang-ja', '15447', '18174', 1),
('module', 'mime', 'lang-ko', '15447', '18174', 1),
('module', 'mime', 'lang-lt', '15447', '18174', 1),
('module', 'mime', 'lang-nl', '15447', '18174', 1),
('module', 'mime', 'lang-no', '15447', '18174', 1),
('module', 'mime', 'lang-pl', '15447', '18174', 1),
('module', 'mime', 'lang-pt_BR', '15447', '20954', 1),
('module', 'mime', 'lang-pt', '15447', '20954', 1),
('module', 'mime', 'lang-ro', '15447', '18174', 1),
('module', 'mime', 'lang-ru', '15447', '20954', 1),
('module', 'mime', 'lang-sk', '15447', '18174', 1),
('module', 'mime', 'lang-sl', '15447', '18174', 1),
('module', 'mime', 'lang-sr', '15447', '18174', 1),
('module', 'mime', 'lang-sv', '15447', '18174', 1),
('module', 'mime', 'lang-tr', '15447', '18174', 1),
('module', 'mime', 'lang-uk', '15447', '18174', 1),
('module', 'mime', 'lang-vi', '15447', '18174', 1),
('module', 'mime', 'lang-zh_CN', '15447', '18174', 1),
('module', 'mime', 'lang-zh_TW', '15447', '20954', 1),
('module', 'mp3audio', 'base', '1.0.3', '20955', 1),
('module', 'mp3audio', 'lang-af', '17316', '18174', 1),
('module', 'mp3audio', 'lang-ar', '17316', '20954', 1),
('module', 'mp3audio', 'lang-bg', '17316', '20954', 1),
('module', 'mp3audio', 'lang-ca', '17316', '18174', 1),
('module', 'mp3audio', 'lang-cs', '17316', '18174', 1),
('module', 'mp3audio', 'lang-da', '17316', '18174', 1),
('module', 'mp3audio', 'lang-de', '17316', '18174', 1),
('module', 'mp3audio', 'lang-el', '17316', '20954', 1),
('module', 'mp3audio', 'lang-en_GB', '17316', '18174', 1),
('module', 'mp3audio', 'lang-es_AR', '17316', '20954', 1),
('module', 'mp3audio', 'lang-es_MX', '17316', '20954', 1),
('module', 'mp3audio', 'lang-es', '17316', '18174', 1),
('module', 'mp3audio', 'lang-et', '17316', '18174', 1),
('module', 'mp3audio', 'lang-eu', '17316', '18174', 1),
('module', 'mp3audio', 'lang-fi', '17316', '18174', 1),
('module', 'mp3audio', 'lang-fr', '17316', '20954', 1),
('module', 'mp3audio', 'lang-ga', '17316', '20954', 1),
('module', 'mp3audio', 'lang-he', '17316', '18174', 1),
('module', 'mp3audio', 'lang-hu', '17316', '20954', 1),
('module', 'mp3audio', 'lang-it', '17316', '18174', 1),
('module', 'mp3audio', 'lang-ja', '17316', '18174', 1),
('module', 'mp3audio', 'lang-ko', '17316', '18174', 1),
('module', 'mp3audio', 'lang-lt', '17316', '18174', 1),
('module', 'mp3audio', 'lang-nl', '17316', '20954', 1),
('module', 'mp3audio', 'lang-no', '17316', '18174', 1),
('module', 'mp3audio', 'lang-pl', '17316', '18174', 1),
('module', 'mp3audio', 'lang-pt_BR', '17316', '20954', 1),
('module', 'mp3audio', 'lang-pt', '17316', '20954', 1),
('module', 'mp3audio', 'lang-ro', '17316', '18174', 1),
('module', 'mp3audio', 'lang-ru', '17316', '20954', 1),
('module', 'mp3audio', 'lang-sk', '17316', '18174', 1),
('module', 'mp3audio', 'lang-sr', '17316', '18174', 1),
('module', 'mp3audio', 'lang-sv', '17316', '18174', 1),
('module', 'mp3audio', 'lang-tr', '17316', '18174', 1),
('module', 'mp3audio', 'lang-uk', '17316', '18174', 1),
('module', 'mp3audio', 'lang-vi', '17316', '18174', 1),
('module', 'mp3audio', 'lang-zh_CN', '17316', '18174', 1),
('module', 'mp3audio', 'lang-zh_TW', '17316', '20954', 1),
('module', 'multilang', 'base', '1.0.12', '20955', 1),
('module', 'multilang', 'lang-af', '16284', '18174', 1),
('module', 'multilang', 'lang-ar', '16284', '20954', 1),
('module', 'multilang', 'lang-ca', '16284', '18174', 1),
('module', 'multilang', 'lang-cs', '16284', '20954', 1),
('module', 'multilang', 'lang-da', '16284', '18174', 1),
('module', 'multilang', 'lang-de', '16284', '20954', 1),
('module', 'multilang', 'lang-el', '16284', '20954', 1),
('module', 'multilang', 'lang-en_GB', '16284', '18174', 1),
('module', 'multilang', 'lang-es', '16284', '18174', 1),
('module', 'multilang', 'lang-eu', '16284', '18174', 1),
('module', 'multilang', 'lang-fi', '16284', '18174', 1),
('module', 'multilang', 'lang-fr', '16284', '20954', 1),
('module', 'multilang', 'lang-hu', '16284', '18174', 1),
('module', 'multilang', 'lang-is', '16284', '20954', 1),
('module', 'multilang', 'lang-it', '16284', '18174', 1),
('module', 'multilang', 'lang-ja', '16284', '18174', 1),
('module', 'multilang', 'lang-ko', '16284', '18174', 1),
('module', 'multilang', 'lang-lt', '16284', '18174', 1),
('module', 'multilang', 'lang-nl', '16284', '20954', 1),
('module', 'multilang', 'lang-no', '16284', '18174', 1),
('module', 'multilang', 'lang-pl', '16284', '18174', 1),
('module', 'multilang', 'lang-ro', '16284', '18174', 1),
('module', 'multilang', 'lang-ru', '16284', '20954', 1),
('module', 'multilang', 'lang-sk', '16284', '18174', 1),
('module', 'multilang', 'lang-sr', '16284', '18174', 1),
('module', 'multilang', 'lang-sv', '16284', '18174', 1),
('module', 'multilang', 'lang-tr', '16284', '18174', 1),
('module', 'multilang', 'lang-uk', '16284', '18174', 1),
('module', 'multilang', 'lang-vi', '16284', '18174', 1),
('module', 'multilang', 'lang-zh_CN', '16284', '18174', 1),
('module', 'multilang', 'lang-zh_TW', '16284', '20954', 1),
('module', 'multiroot', 'base', '1.0.3', '20955', 1),
('module', 'multiroot', 'lang-af', '15342', '18174', 1),
('module', 'multiroot', 'lang-ar', '15342', '20954', 1),
('module', 'multiroot', 'lang-bg', '15342', '20954', 1),
('module', 'multiroot', 'lang-ca', '15342', '18174', 1),
('module', 'multiroot', 'lang-cs', '15342', '18174', 1),
('module', 'multiroot', 'lang-da', '15342', '18174', 1),
('module', 'multiroot', 'lang-de', '15342', '18174', 1),
('module', 'multiroot', 'lang-el', '15342', '20954', 1),
('module', 'multiroot', 'lang-en_GB', '15342', '18174', 1),
('module', 'multiroot', 'lang-es_AR', '15342', '20954', 1),
('module', 'multiroot', 'lang-es_MX', '15342', '20954', 1),
('module', 'multiroot', 'lang-es', '15342', '18174', 1),
('module', 'multiroot', 'lang-et', '15342', '18174', 1),
('module', 'multiroot', 'lang-eu', '15342', '18174', 1),
('module', 'multiroot', 'lang-fi', '15342', '18174', 1),
('module', 'multiroot', 'lang-fr', '15342', '20954', 1),
('module', 'multiroot', 'lang-ga', '15342', '20954', 1),
('module', 'multiroot', 'lang-he', '15342', '18174', 1),
('module', 'multiroot', 'lang-hu', '15342', '20954', 1),
('module', 'multiroot', 'lang-it', '15342', '18174', 1),
('module', 'multiroot', 'lang-ja', '15342', '18174', 1),
('module', 'multiroot', 'lang-ko', '15342', '18174', 1),
('module', 'multiroot', 'lang-lt', '15342', '18174', 1),
('module', 'multiroot', 'lang-nl', '15342', '20954', 1),
('module', 'multiroot', 'lang-no', '15342', '18174', 1),
('module', 'multiroot', 'lang-pl', '15342', '18174', 1),
('module', 'multiroot', 'lang-pt_BR', '15342', '20954', 1),
('module', 'multiroot', 'lang-pt', '15342', '20954', 1),
('module', 'multiroot', 'lang-ro', '15342', '18174', 1),
('module', 'multiroot', 'lang-ru', '15342', '18174', 1),
('module', 'multiroot', 'lang-sk', '15342', '18174', 1),
('module', 'multiroot', 'lang-sl', '15342', '18174', 1),
('module', 'multiroot', 'lang-sr', '15342', '18174', 1),
('module', 'multiroot', 'lang-sv', '15342', '18174', 1),
('module', 'multiroot', 'lang-tr', '15342', '18174', 1),
('module', 'multiroot', 'lang-uk', '15342', '18174', 1),
('module', 'multiroot', 'lang-zh_CN', '15342', '18174', 1),
('module', 'multiroot', 'lang-zh_TW', '15342', '20954', 1),
('module', 'netpbm', 'base', '1.1.5', '20955', 1),
('module', 'netpbm', 'lang-af', '17028', '18174', 1),
('module', 'netpbm', 'lang-ar', '17028', '20954', 1),
('module', 'netpbm', 'lang-ca', '17028', '18174', 1),
('module', 'netpbm', 'lang-cs', '17028', '18174', 1),
('module', 'netpbm', 'lang-da', '17028', '18174', 1),
('module', 'netpbm', 'lang-de', '17028', '18174', 1),
('module', 'netpbm', 'lang-el', '17028', '20954', 1),
('module', 'netpbm', 'lang-en_GB', '17028', '18174', 1),
('module', 'netpbm', 'lang-es_AR', '17028', '20954', 1),
('module', 'netpbm', 'lang-es', '17028', '18174', 1),
('module', 'netpbm', 'lang-eu', '17028', '18174', 1),
('module', 'netpbm', 'lang-fi', '17028', '18174', 1),
('module', 'netpbm', 'lang-fr', '17028', '20954', 1),
('module', 'netpbm', 'lang-ga', '17028', '20954', 1),
('module', 'netpbm', 'lang-he', '17028', '20954', 1),
('module', 'netpbm', 'lang-hu', '17028', '20954', 1),
('module', 'netpbm', 'lang-is', '17028', '20954', 1),
('module', 'netpbm', 'lang-it', '17028', '18174', 1),
('module', 'netpbm', 'lang-ja', '17028', '18174', 1),
('module', 'netpbm', 'lang-ko', '17028', '18174', 1),
('module', 'netpbm', 'lang-lt', '17028', '18174', 1),
('module', 'netpbm', 'lang-lv', '17028', '18174', 1),
('module', 'netpbm', 'lang-nl', '17028', '18174', 1),
('module', 'netpbm', 'lang-no', '17028', '18174', 1),
('module', 'netpbm', 'lang-pl', '17028', '18174', 1),
('module', 'netpbm', 'lang-pt_BR', '17028', '20954', 1),
('module', 'netpbm', 'lang-pt', '17028', '20954', 1),
('module', 'netpbm', 'lang-ro', '17028', '18174', 1),
('module', 'netpbm', 'lang-ru', '17028', '18174', 1),
('module', 'netpbm', 'lang-sk', '17028', '20954', 1),
('module', 'netpbm', 'lang-sl', '17028', '18174', 1),
('module', 'netpbm', 'lang-sr', '17028', '18174', 1),
('module', 'netpbm', 'lang-sv', '17028', '18174', 1),
('module', 'netpbm', 'lang-tr', '17028', '18174', 1),
('module', 'netpbm', 'lang-uk', '17028', '18174', 1),
('module', 'netpbm', 'lang-vi', '17028', '18174', 1),
('module', 'netpbm', 'lang-zh_CN', '17028', '18174', 1),
('module', 'netpbm', 'lang-zh_TW', '17028', '20954', 1),
('module', 'newitems', 'base', '1.0.8', '20955', 1),
('module', 'newitems', 'lang-af', '15342', '18174', 1),
('module', 'newitems', 'lang-ar', '15342', '20954', 1),
('module', 'newitems', 'lang-bg', '15342', '18174', 1),
('module', 'newitems', 'lang-ca', '15342', '20954', 1),
('module', 'newitems', 'lang-cs', '15342', '20954', 1),
('module', 'newitems', 'lang-da', '15342', '18174', 1),
('module', 'newitems', 'lang-de', '15342', '20954', 1),
('module', 'newitems', 'lang-el', '15342', '20954', 1),
('module', 'newitems', 'lang-en_GB', '15342', '18174', 1),
('module', 'newitems', 'lang-es', '15342', '18174', 1),
('module', 'newitems', 'lang-et', '15342', '18174', 1),
('module', 'newitems', 'lang-eu', '15342', '18174', 1),
('module', 'newitems', 'lang-fa', '15342', '20954', 1),
('module', 'newitems', 'lang-fi', '15342', '18174', 1),
('module', 'newitems', 'lang-fr', '15342', '20954', 1),
('module', 'newitems', 'lang-hu', '15342', '18174', 1),
('module', 'newitems', 'lang-is', '15342', '20954', 1),
('module', 'newitems', 'lang-it', '15342', '18174', 1),
('module', 'newitems', 'lang-ja', '15342', '18174', 1),
('module', 'newitems', 'lang-ko', '15342', '18174', 1),
('module', 'newitems', 'lang-lt', '15342', '18174', 1),
('module', 'newitems', 'lang-nl', '15342', '20954', 1),
('module', 'newitems', 'lang-no', '15342', '20954', 1),
('module', 'newitems', 'lang-pl', '15342', '18174', 1),
('module', 'newitems', 'lang-pt_BR', '15342', '18174', 1),
('module', 'newitems', 'lang-ro', '15342', '18174', 1),
('module', 'newitems', 'lang-ru', '15342', '18174', 1),
('module', 'newitems', 'lang-sk', '15342', '18174', 1),
('module', 'newitems', 'lang-sr', '15342', '18174', 1),
('module', 'newitems', 'lang-sv', '15342', '18174', 1),
('module', 'newitems', 'lang-tr', '15342', '18174', 1),
('module', 'newitems', 'lang-uk', '15342', '18174', 1),
('module', 'newitems', 'lang-vi', '15342', '18174', 1),
('module', 'newitems', 'lang-zh_CN', '15342', '18174', 1),
('module', 'newitems', 'lang-zh_TW', '15342', '18174', 1),
('module', 'nokiaupload', 'base', '1.0.12', '20955', 1),
('module', 'nokiaupload', 'lang-af', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-ar', '15342', '20954', 1),
('module', 'nokiaupload', 'lang-ca', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-cs', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-da', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-de', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-el', '15342', '20954', 1),
('module', 'nokiaupload', 'lang-en_GB', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-es', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-eu', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-fi', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-fr', '15342', '20954', 1),
('module', 'nokiaupload', 'lang-hu', '15342', '20954', 1),
('module', 'nokiaupload', 'lang-is', '15342', '20954', 1),
('module', 'nokiaupload', 'lang-it', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-ja', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-ko', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-lt', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-nl', '15342', '20954', 1),
('module', 'nokiaupload', 'lang-no', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-pl', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-ro', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-ru', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-sk', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-sr', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-sv', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-tr', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-uk', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-vi', '15342', '18174', 1),
('module', 'nokiaupload', 'lang-zh_CN', '15342', '20954', 1),
('module', 'nokiaupload', 'lang-zh_TW', '15342', '20954', 1),
('module', 'notification', 'base', '1.0.3', '20955', 1),
('module', 'notification', 'lang-de', '17925', '18174', 1),
('module', 'notification', 'lang-en_GB', '17925', '18174', 1),
('module', 'notification', 'lang-es', '17925', '18174', 1),
('module', 'notification', 'lang-fr', '17925', '18174', 1),
('module', 'notification', 'lang-it', '17925', '18174', 1),
('module', 'notification', 'lang-ja', '17925', '18174', 1),
('module', 'notification', 'lang-pl', '17925', '18174', 1),
('module', 'notification', 'lang-ru', '17925', '18174', 1),
('module', 'notification', 'lang-sk', '17925', '20954', 1),
('module', 'notification', 'lang-sl', '17925', '20954', 1),
('module', 'notification', 'lang-sr', '17925', '18174', 1),
('module', 'notification', 'lang-sv', '17925', '18174', 1),
('module', 'notification', 'lang-zh_TW', '17925', '20954', 1),
('module', 'panorama', 'base', '1.0.10', '20955', 1),
('module', 'panorama', 'lang-af', '15342', '18174', 1),
('module', 'panorama', 'lang-ar', '15342', '20954', 1),
('module', 'panorama', 'lang-ca', '15342', '18174', 1),
('module', 'panorama', 'lang-cs', '15342', '18174', 1),
('module', 'panorama', 'lang-da', '15342', '18174', 1),
('module', 'panorama', 'lang-de', '15342', '18174', 1),
('module', 'panorama', 'lang-el', '15342', '20954', 1),
('module', 'panorama', 'lang-en_GB', '15342', '18174', 1),
('module', 'panorama', 'lang-es', '15342', '18174', 1),
('module', 'panorama', 'lang-eu', '15342', '18174', 1),
('module', 'panorama', 'lang-fi', '15342', '18174', 1),
('module', 'panorama', 'lang-fr', '15342', '20954', 1),
('module', 'panorama', 'lang-hu', '15342', '20954', 1),
('module', 'panorama', 'lang-is', '15342', '20954', 1),
('module', 'panorama', 'lang-it', '15342', '18174', 1),
('module', 'panorama', 'lang-ja', '15342', '18174', 1),
('module', 'panorama', 'lang-ko', '15342', '20954', 1),
('module', 'panorama', 'lang-lt', '15342', '18174', 1),
('module', 'panorama', 'lang-nl', '15342', '20954', 1),
('module', 'panorama', 'lang-no', '15342', '20954', 1),
('module', 'panorama', 'lang-pl', '15342', '18174', 1),
('module', 'panorama', 'lang-pt_BR', '15342', '18174', 1),
('module', 'panorama', 'lang-ro', '15342', '18174', 1),
('module', 'panorama', 'lang-ru', '15342', '18174', 1),
('module', 'panorama', 'lang-sk', '15342', '18174', 1),
('module', 'panorama', 'lang-sr', '15342', '18174', 1),
('module', 'panorama', 'lang-sv', '15342', '18174', 1),
('module', 'panorama', 'lang-tr', '15342', '18174', 1),
('module', 'panorama', 'lang-uk', '15342', '18174', 1),
('module', 'panorama', 'lang-vi', '15342', '18174', 1),
('module', 'panorama', 'lang-zh_CN', '15342', '18174', 1),
('module', 'panorama', 'lang-zh_TW', '15342', '20954', 1),
('module', 'password', 'base', '1.0.9', '20955', 1),
('module', 'password', 'lang-af', '17686', '18174', 1),
('module', 'password', 'lang-ar', '17686', '20954', 1),
('module', 'password', 'lang-ca', '17686', '18174', 1),
('module', 'password', 'lang-cs', '17686', '18174', 1),
('module', 'password', 'lang-da', '17686', '18174', 1),
('module', 'password', 'lang-de', '17686', '18174', 1),
('module', 'password', 'lang-el', '17686', '20954', 1),
('module', 'password', 'lang-en_GB', '17686', '18174', 1),
('module', 'password', 'lang-es', '17686', '18174', 1),
('module', 'password', 'lang-eu', '17686', '18174', 1),
('module', 'password', 'lang-fa', '17686', '18174', 1),
('module', 'password', 'lang-fi', '17686', '18174', 1),
('module', 'password', 'lang-fr', '17686', '18174', 1),
('module', 'password', 'lang-hu', '17686', '18174', 1),
('module', 'password', 'lang-it', '17686', '18174', 1),
('module', 'password', 'lang-ja', '17686', '18174', 1),
('module', 'password', 'lang-ko', '17686', '18174', 1),
('module', 'password', 'lang-lt', '17686', '18174', 1),
('module', 'password', 'lang-nl', '17686', '18174', 1),
('module', 'password', 'lang-no', '17686', '18174', 1),
('module', 'password', 'lang-pl', '17686', '18174', 1),
('module', 'password', 'lang-ro', '17686', '18174', 1),
('module', 'password', 'lang-ru', '17686', '18174', 1),
('module', 'password', 'lang-sk', '17686', '18174', 1),
('module', 'password', 'lang-sr', '17686', '18174', 1),
('module', 'password', 'lang-sv', '17686', '18174', 1),
('module', 'password', 'lang-tr', '17686', '18174', 1),
('module', 'password', 'lang-uk', '17686', '18174', 1),
('module', 'password', 'lang-vi', '17686', '18174', 1),
('module', 'password', 'lang-zh_CN', '17686', '18174', 1),
('module', 'password', 'lang-zh_TW', '17686', '20954', 1),
('module', 'permalinks', 'base', '1.0.12', '20955', 1),
('module', 'permalinks', 'lang-af', '15342', '18174', 1),
('module', 'permalinks', 'lang-ar', '15342', '20954', 1),
('module', 'permalinks', 'lang-ca', '15342', '18174', 1),
('module', 'permalinks', 'lang-cs', '15342', '18174', 1),
('module', 'permalinks', 'lang-da', '15342', '18174', 1),
('module', 'permalinks', 'lang-de', '15342', '18174', 1),
('module', 'permalinks', 'lang-el', '15342', '20954', 1),
('module', 'permalinks', 'lang-en_GB', '15342', '18174', 1),
('module', 'permalinks', 'lang-es', '15342', '18174', 1),
('module', 'permalinks', 'lang-eu', '15342', '18174', 1),
('module', 'permalinks', 'lang-fi', '15342', '18174', 1),
('module', 'permalinks', 'lang-fr', '15342', '18174', 1),
('module', 'permalinks', 'lang-hu', '15342', '20954', 1),
('module', 'permalinks', 'lang-it', '15342', '18174', 1),
('module', 'permalinks', 'lang-ja', '15342', '18174', 1),
('module', 'permalinks', 'lang-ko', '15342', '18174', 1),
('module', 'permalinks', 'lang-lt', '15342', '18174', 1),
('module', 'permalinks', 'lang-nl', '15342', '18174', 1),
('module', 'permalinks', 'lang-no', '15342', '18174', 1),
('module', 'permalinks', 'lang-pl', '15342', '18174', 1),
('module', 'permalinks', 'lang-ro', '15342', '18174', 1),
('module', 'permalinks', 'lang-ru', '15342', '18174', 1),
('module', 'permalinks', 'lang-sk', '15342', '18174', 1),
('module', 'permalinks', 'lang-sr', '15342', '18174', 1),
('module', 'permalinks', 'lang-sv', '15342', '18174', 1),
('module', 'permalinks', 'lang-tr', '15342', '18174', 1),
('module', 'permalinks', 'lang-uk', '15342', '18174', 1),
('module', 'permalinks', 'lang-vi', '15342', '18174', 1),
('module', 'permalinks', 'lang-zh_CN', '15342', '18174', 1),
('module', 'permalinks', 'lang-zh_TW', '15342', '18174', 1),
('module', 'photoaccess', 'base', '1.0.13', '20955', 1),
('module', 'photoaccess', 'lang-af', '16969', '18174', 1),
('module', 'photoaccess', 'lang-bg', '16969', '20954', 1),
('module', 'photoaccess', 'lang-ca', '16969', '18174', 1),
('module', 'photoaccess', 'lang-cs', '16969', '20954', 1),
('module', 'photoaccess', 'lang-da', '16969', '18174', 1),
('module', 'photoaccess', 'lang-de', '16969', '18174', 1),
('module', 'photoaccess', 'lang-el', '16969', '20954', 1),
('module', 'photoaccess', 'lang-en_GB', '16969', '18174', 1),
('module', 'photoaccess', 'lang-es_AR', '16969', '20954', 1),
('module', 'photoaccess', 'lang-es_MX', '16969', '20954', 1),
('module', 'photoaccess', 'lang-es', '16969', '18174', 1),
('module', 'photoaccess', 'lang-et', '16969', '18174', 1),
('module', 'photoaccess', 'lang-eu', '16969', '20954', 1),
('module', 'photoaccess', 'lang-fi', '16969', '18174', 1),
('module', 'photoaccess', 'lang-fr', '16969', '20954', 1),
('module', 'photoaccess', 'lang-ga', '16969', '20954', 1),
('module', 'photoaccess', 'lang-hu', '16969', '18174', 1),
('module', 'photoaccess', 'lang-is', '16969', '20954', 1),
('module', 'photoaccess', 'lang-it', '16969', '18174', 1),
('module', 'photoaccess', 'lang-ja', '16969', '18174', 1),
('module', 'photoaccess', 'lang-ko', '16969', '18174', 1),
('module', 'photoaccess', 'lang-nl', '16969', '20954', 1),
('module', 'photoaccess', 'lang-no', '16969', '18174', 1),
('module', 'photoaccess', 'lang-pl', '16969', '18174', 1),
('module', 'photoaccess', 'lang-pt_BR', '16969', '20954', 1),
('module', 'photoaccess', 'lang-ro', '16969', '20954', 1),
('module', 'photoaccess', 'lang-ru', '16969', '18174', 1),
('module', 'photoaccess', 'lang-sr', '16969', '18174', 1),
('module', 'photoaccess', 'lang-sv', '16969', '18174', 1),
('module', 'photoaccess', 'lang-tr', '16969', '18174', 1),
('module', 'photoaccess', 'lang-vi', '16969', '20954', 1),
('module', 'photoaccess', 'lang-zh_CN', '16969', '18174', 1),
('module', 'photoaccess', 'lang-zh_TW', '16969', '20954', 1),
('module', 'picasa', 'base', '1.0.10', '20955', 1),
('module', 'picasa', 'lang-af', '16284', '18174', 1),
('module', 'picasa', 'lang-ar', '16284', '20954', 1),
('module', 'picasa', 'lang-ca', '16284', '18174', 1),
('module', 'picasa', 'lang-cs', '16284', '18174', 1),
('module', 'picasa', 'lang-da', '16284', '18174', 1),
('module', 'picasa', 'lang-de', '16284', '18174', 1),
('module', 'picasa', 'lang-el', '16284', '20954', 1),
('module', 'picasa', 'lang-en_GB', '16284', '18174', 1),
('module', 'picasa', 'lang-es', '16284', '18174', 1),
('module', 'picasa', 'lang-eu', '16284', '18174', 1),
('module', 'picasa', 'lang-fi', '16284', '18174', 1),
('module', 'picasa', 'lang-fr', '16284', '18174', 1),
('module', 'picasa', 'lang-hu', '16284', '20954', 1),
('module', 'picasa', 'lang-it', '16284', '18174', 1),
('module', 'picasa', 'lang-ja', '16284', '18174', 1),
('module', 'picasa', 'lang-ko', '16284', '18174', 1),
('module', 'picasa', 'lang-lt', '16284', '18174', 1),
('module', 'picasa', 'lang-nl', '16284', '18174', 1),
('module', 'picasa', 'lang-no', '16284', '18174', 1),
('module', 'picasa', 'lang-pl', '16284', '18174', 1),
('module', 'picasa', 'lang-ro', '16284', '18174', 1),
('module', 'picasa', 'lang-ru', '16284', '18174', 1),
('module', 'picasa', 'lang-sk', '16284', '18174', 1),
('module', 'picasa', 'lang-sr', '16284', '18174', 1),
('module', 'picasa', 'lang-sv', '16284', '18174', 1),
('module', 'picasa', 'lang-tr', '16284', '18174', 1),
('module', 'picasa', 'lang-uk', '16284', '18174', 1),
('module', 'picasa', 'lang-vi', '16284', '18174', 1),
('module', 'picasa', 'lang-zh_CN', '16284', '18174', 1),
('module', 'picasa', 'lang-zh_TW', '16284', '18174', 1),
('module', 'publishxp', 'base', '1.0.14', '20955', 1),
('module', 'publishxp', 'lang-af', '17417', '18174', 1),
('module', 'publishxp', 'lang-ar', '17417', '20954', 1),
('module', 'publishxp', 'lang-ca', '17417', '18174', 1),
('module', 'publishxp', 'lang-cs', '17417', '18174', 1),
('module', 'publishxp', 'lang-da', '17417', '18174', 1),
('module', 'publishxp', 'lang-de', '17417', '18174', 1),
('module', 'publishxp', 'lang-el', '17417', '20954', 1),
('module', 'publishxp', 'lang-en_GB', '17417', '18174', 1),
('module', 'publishxp', 'lang-es', '17417', '18174', 1),
('module', 'publishxp', 'lang-eu', '17417', '18174', 1),
('module', 'publishxp', 'lang-fi', '17417', '20954', 1),
('module', 'publishxp', 'lang-fr', '17417', '18174', 1),
('module', 'publishxp', 'lang-hu', '17417', '20954', 1),
('module', 'publishxp', 'lang-it', '17417', '18174', 1),
('module', 'publishxp', 'lang-ja', '17417', '18174', 1),
('module', 'publishxp', 'lang-ko', '17417', '18174', 1),
('module', 'publishxp', 'lang-lt', '17417', '18174', 1),
('module', 'publishxp', 'lang-nl', '17417', '20954', 1),
('module', 'publishxp', 'lang-no', '17417', '20954', 1),
('module', 'publishxp', 'lang-pl', '17417', '18174', 1),
('module', 'publishxp', 'lang-ro', '17417', '18174', 1),
('module', 'publishxp', 'lang-ru', '17417', '18174', 1),
('module', 'publishxp', 'lang-sk', '17417', '18174', 1),
('module', 'publishxp', 'lang-sr', '17417', '18174', 1),
('module', 'publishxp', 'lang-sv', '17417', '18174', 1),
('module', 'publishxp', 'lang-tr', '17417', '18174', 1),
('module', 'publishxp', 'lang-uk', '17417', '18174', 1),
('module', 'publishxp', 'lang-vi', '17417', '18174', 1),
('module', 'publishxp', 'lang-zh_CN', '17417', '18174', 1),
('module', 'publishxp', 'lang-zh_TW', '17417', '20954', 1),
('module', 'quotas', 'base', '1.1.4', '20955', 1),
('module', 'quotas', 'lang-af', '15448', '18174', 1),
('module', 'quotas', 'lang-ar', '15448', '20954', 1),
('module', 'quotas', 'lang-ca', '15448', '20954', 1),
('module', 'quotas', 'lang-cs', '15448', '18174', 1),
('module', 'quotas', 'lang-da', '15448', '18174', 1),
('module', 'quotas', 'lang-de', '15448', '18174', 1),
('module', 'quotas', 'lang-el', '15448', '20954', 1),
('module', 'quotas', 'lang-en_GB', '15448', '18174', 1),
('module', 'quotas', 'lang-es', '15448', '18174', 1),
('module', 'quotas', 'lang-et', '15448', '18174', 1),
('module', 'quotas', 'lang-eu', '15448', '18174', 1),
('module', 'quotas', 'lang-fi', '15448', '18174', 1),
('module', 'quotas', 'lang-fr', '15448', '18174', 1),
('module', 'quotas', 'lang-hu', '15448', '20954', 1),
('module', 'quotas', 'lang-it', '15448', '18174', 1),
('module', 'quotas', 'lang-ja', '15448', '18174', 1),
('module', 'quotas', 'lang-ko', '15448', '18174', 1),
('module', 'quotas', 'lang-lt', '15448', '18174', 1),
('module', 'quotas', 'lang-nl', '15448', '20954', 1),
('module', 'quotas', 'lang-no', '15448', '18174', 1),
('module', 'quotas', 'lang-pl', '15448', '18174', 1),
('module', 'quotas', 'lang-ro', '15448', '18174', 1),
('module', 'quotas', 'lang-ru', '15448', '18174', 1),
('module', 'quotas', 'lang-sk', '15448', '20954', 1),
('module', 'quotas', 'lang-sl', '15448', '18174', 1),
('module', 'quotas', 'lang-sr', '15448', '18174', 1),
('module', 'quotas', 'lang-sv', '15448', '18174', 1),
('module', 'quotas', 'lang-tr', '15448', '18174', 1),
('module', 'quotas', 'lang-uk', '15448', '18174', 1),
('module', 'quotas', 'lang-vi', '15448', '18174', 1),
('module', 'quotas', 'lang-zh_CN', '15448', '18174', 1),
('module', 'quotas', 'lang-zh_TW', '15448', '18174', 1),
('module', 'randomhighlight', 'base', '1.0.9', '20955', 1),
('module', 'randomhighlight', 'lang-af', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-ar', '15342', '20954', 1),
('module', 'randomhighlight', 'lang-ca', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-cs', '15342', '20954', 1),
('module', 'randomhighlight', 'lang-da', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-de', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-el', '15342', '20954', 1),
('module', 'randomhighlight', 'lang-en_GB', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-es', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-eu', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-fi', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-fr', '15342', '20954', 1),
('module', 'randomhighlight', 'lang-hu', '15342', '20954', 1),
('module', 'randomhighlight', 'lang-is', '15342', '20954', 1),
('module', 'randomhighlight', 'lang-it', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-ja', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-ko', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-lt', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-nl', '15342', '20954', 1),
('module', 'randomhighlight', 'lang-no', '15342', '20954', 1),
('module', 'randomhighlight', 'lang-pl', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-pt_BR', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-ro', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-ru', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-sk', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-sr', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-sv', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-tr', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-uk', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-vi', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-zh_CN', '15342', '18174', 1),
('module', 'randomhighlight', 'lang-zh_TW', '15342', '20954', 1),
('module', 'rating', 'base', '1.0.13', '20955', 1),
('module', 'rating', 'lang-af', '16284', '18174', 1),
('module', 'rating', 'lang-ar', '16284', '20954', 1),
('module', 'rating', 'lang-ca', '16284', '18174', 1),
('module', 'rating', 'lang-cs', '16284', '18174', 1),
('module', 'rating', 'lang-da', '16284', '18174', 1),
('module', 'rating', 'lang-de', '16284', '18174', 1),
('module', 'rating', 'lang-el', '16284', '20954', 1),
('module', 'rating', 'lang-en_GB', '16284', '18174', 1),
('module', 'rating', 'lang-es', '16284', '18174', 1),
('module', 'rating', 'lang-et', '16284', '18174', 1),
('module', 'rating', 'lang-eu', '16284', '18174', 1),
('module', 'rating', 'lang-fa', '16284', '18174', 1),
('module', 'rating', 'lang-fi', '16284', '18174', 1),
('module', 'rating', 'lang-fr', '16284', '18174', 1),
('module', 'rating', 'lang-he', '16284', '18174', 1),
('module', 'rating', 'lang-hu', '16284', '20954', 1),
('module', 'rating', 'lang-it', '16284', '18174', 1),
('module', 'rating', 'lang-ja', '16284', '18174', 1),
('module', 'rating', 'lang-ko', '16284', '18174', 1),
('module', 'rating', 'lang-lt', '16284', '18174', 1),
('module', 'rating', 'lang-lv', '16284', '18174', 1),
('module', 'rating', 'lang-nl', '16284', '18174', 1),
('module', 'rating', 'lang-no', '16284', '18174', 1),
('module', 'rating', 'lang-pl', '16284', '18174', 1),
('module', 'rating', 'lang-ro', '16284', '18174', 1),
('module', 'rating', 'lang-ru', '16284', '20954', 1),
('module', 'rating', 'lang-sk', '16284', '20954', 1),
('module', 'rating', 'lang-sl', '16284', '18174', 1),
('module', 'rating', 'lang-sr', '16284', '18174', 1),
('module', 'rating', 'lang-sv', '16284', '18174', 1),
('module', 'rating', 'lang-tr', '16284', '18174', 1),
('module', 'rating', 'lang-uk', '16284', '18174', 1),
('module', 'rating', 'lang-vi', '16284', '18174', 1),
('module', 'rating', 'lang-zh_CN', '16284', '18174', 1),
('module', 'rating', 'lang-zh_TW', '16284', '18174', 1),
('module', 'rearrange', 'base', '1.0.9', '20955', 1),
('module', 'rearrange', 'lang-af', '15342', '18174', 1),
('module', 'rearrange', 'lang-ar', '15342', '20954', 1),
('module', 'rearrange', 'lang-bg', '15342', '20954', 1),
('module', 'rearrange', 'lang-ca', '15342', '18174', 1),
('module', 'rearrange', 'lang-cs', '15342', '20954', 1),
('module', 'rearrange', 'lang-da', '15342', '18174', 1),
('module', 'rearrange', 'lang-de', '15342', '18174', 1),
('module', 'rearrange', 'lang-el', '15342', '20954', 1),
('module', 'rearrange', 'lang-en_GB', '15342', '18174', 1),
('module', 'rearrange', 'lang-es', '15342', '18174', 1),
('module', 'rearrange', 'lang-eu', '15342', '18174', 1),
('module', 'rearrange', 'lang-fa', '15342', '18174', 1),
('module', 'rearrange', 'lang-fi', '15342', '18174', 1),
('module', 'rearrange', 'lang-fr', '15342', '20954', 1),
('module', 'rearrange', 'lang-hu', '15342', '18174', 1),
('module', 'rearrange', 'lang-is', '15342', '20954', 1),
('module', 'rearrange', 'lang-it', '15342', '18174', 1),
('module', 'rearrange', 'lang-ja', '15342', '18174', 1),
('module', 'rearrange', 'lang-ko', '15342', '18174', 1),
('module', 'rearrange', 'lang-lt', '15342', '18174', 1),
('module', 'rearrange', 'lang-nl', '15342', '20954', 1),
('module', 'rearrange', 'lang-no', '15342', '18174', 1),
('module', 'rearrange', 'lang-pl', '15342', '18174', 1),
('module', 'rearrange', 'lang-pt_BR', '15342', '20954', 1),
('module', 'rearrange', 'lang-ro', '15342', '18174', 1),
('module', 'rearrange', 'lang-ru', '15342', '18174', 1),
('module', 'rearrange', 'lang-sk', '15342', '20954', 1),
('module', 'rearrange', 'lang-sl', '15342', '18174', 1),
('module', 'rearrange', 'lang-sr', '15342', '18174', 1),
('module', 'rearrange', 'lang-sv', '15342', '18174', 1),
('module', 'rearrange', 'lang-tr', '15342', '18174', 1),
('module', 'rearrange', 'lang-uk', '15342', '18174', 1),
('module', 'rearrange', 'lang-vi', '15342', '18174', 1),
('module', 'rearrange', 'lang-zh_CN', '15342', '18174', 1),
('module', 'rearrange', 'lang-zh_TW', '15342', '18174', 1),
('module', 'register', 'base', '1.0.14', '20955', 1),
('module', 'register', 'lang-af', '17028', '18174', 1),
('module', 'register', 'lang-ar', '17028', '20954', 1),
('module', 'register', 'lang-bg', '17028', '18174', 1),
('module', 'register', 'lang-ca', '17028', '20954', 1),
('module', 'register', 'lang-cs', '17028', '20954', 1),
('module', 'register', 'lang-da', '17028', '18174', 1),
('module', 'register', 'lang-de', '17028', '20954', 1),
('module', 'register', 'lang-el', '17028', '20954', 1),
('module', 'register', 'lang-en_GB', '17028', '18174', 1),
('module', 'register', 'lang-es', '17028', '18174', 1),
('module', 'register', 'lang-et', '17028', '18174', 1),
('module', 'register', 'lang-eu', '17028', '18174', 1),
('module', 'register', 'lang-fi', '17028', '18174', 1),
('module', 'register', 'lang-fr', '17028', '20954', 1),
('module', 'register', 'lang-he', '17028', '18174', 1),
('module', 'register', 'lang-hu', '17028', '18174', 1),
('module', 'register', 'lang-is', '17028', '20954', 1),
('module', 'register', 'lang-it', '17028', '18174', 1),
('module', 'register', 'lang-ja', '17028', '18174', 1),
('module', 'register', 'lang-ko', '17028', '18174', 1),
('module', 'register', 'lang-lt', '17028', '18174', 1),
('module', 'register', 'lang-lv', '17028', '18174', 1),
('module', 'register', 'lang-nl', '17028', '20954', 1),
('module', 'register', 'lang-no', '17028', '18174', 1),
('module', 'register', 'lang-pl', '17028', '18174', 1),
('module', 'register', 'lang-pt_BR', '17028', '18174', 1),
('module', 'register', 'lang-ro', '17028', '18174', 1),
('module', 'register', 'lang-ru', '17028', '18174', 1),
('module', 'register', 'lang-sk', '17028', '20954', 1),
('module', 'register', 'lang-sl', '17028', '20954', 1),
('module', 'register', 'lang-sr', '17028', '18174', 1),
('module', 'register', 'lang-sv', '17028', '18174', 1),
('module', 'register', 'lang-tr', '17028', '18174', 1),
('module', 'register', 'lang-uk', '17028', '18174', 1),
('module', 'register', 'lang-vi', '17028', '18174', 1),
('module', 'register', 'lang-zh_CN', '17028', '18174', 1),
('module', 'register', 'lang-zh_TW', '17028', '20954', 1),
('module', 'remote', 'base', '1.0.18', '20955', 1),
('module', 'remote', 'lang-af', '16539', '18174', 1),
('module', 'remote', 'lang-ar', '16539', '20954', 1),
('module', 'remote', 'lang-ca', '16539', '18174', 1),
('module', 'remote', 'lang-cs', '16539', '20954', 1),
('module', 'remote', 'lang-da', '16539', '18174', 1),
('module', 'remote', 'lang-de', '16539', '18174', 1),
('module', 'remote', 'lang-el', '16539', '20954', 1),
('module', 'remote', 'lang-en_GB', '16539', '18174', 1),
('module', 'remote', 'lang-es', '16539', '18174', 1),
('module', 'remote', 'lang-eu', '16539', '18174', 1),
('module', 'remote', 'lang-fi', '16539', '20954', 1),
('module', 'remote', 'lang-fr', '16539', '20954', 1),
('module', 'remote', 'lang-hu', '16539', '18174', 1),
('module', 'remote', 'lang-is', '16539', '20954', 1),
('module', 'remote', 'lang-it', '16539', '18174', 1),
('module', 'remote', 'lang-ja', '16539', '18174', 1),
('module', 'remote', 'lang-ko', '16539', '18174', 1),
('module', 'remote', 'lang-lt', '16539', '18174', 1),
('module', 'remote', 'lang-nl', '16539', '20954', 1),
('module', 'remote', 'lang-no', '16539', '18174', 1),
('module', 'remote', 'lang-pl', '16539', '18174', 1),
('module', 'remote', 'lang-pt_BR', '16539', '20954', 1),
('module', 'remote', 'lang-ro', '16539', '18174', 1),
('module', 'remote', 'lang-ru', '16539', '18174', 1),
('module', 'remote', 'lang-sk', '16539', '18174', 1),
('module', 'remote', 'lang-sl', '16539', '20954', 1),
('module', 'remote', 'lang-sr', '16539', '18174', 1),
('module', 'remote', 'lang-sv', '16539', '18174', 1),
('module', 'remote', 'lang-tr', '16539', '18174', 1),
('module', 'remote', 'lang-uk', '16539', '18174', 1),
('module', 'remote', 'lang-vi', '16539', '18174', 1),
('module', 'remote', 'lang-zh_CN', '16539', '18174', 1),
('module', 'remote', 'lang-zh_TW', '16539', '20954', 1),
('module', 'replica', 'base', '1.0.5', '20955', 1),
('module', 'replica', 'lang-af', '15342', '18174', 1),
('module', 'replica', 'lang-ar', '15342', '18174', 1),
('module', 'replica', 'lang-bg', '15342', '18174', 1),
('module', 'replica', 'lang-ca', '15342', '18174', 1),
('module', 'replica', 'lang-cs', '15342', '18174', 1),
('module', 'replica', 'lang-da', '15342', '18174', 1),
('module', 'replica', 'lang-de', '15342', '18174', 1),
('module', 'replica', 'lang-el', '15342', '20954', 1),
('module', 'replica', 'lang-en_GB', '15342', '18174', 1),
('module', 'replica', 'lang-es_AR', '15342', '18174', 1),
('module', 'replica', 'lang-es_MX', '15342', '18174', 1),
('module', 'replica', 'lang-es', '15342', '18174', 1),
('module', 'replica', 'lang-eu', '15342', '18174', 1),
('module', 'replica', 'lang-fi', '15342', '18174', 1),
('module', 'replica', 'lang-fr', '15342', '18174', 1),
('module', 'replica', 'lang-ga', '15342', '18174', 1),
('module', 'replica', 'lang-he', '15342', '18174', 1),
('module', 'replica', 'lang-hu', '15342', '18174', 1),
('module', 'replica', 'lang-is', '15342', '18174', 1),
('module', 'replica', 'lang-it', '15342', '18174', 1),
('module', 'replica', 'lang-ja', '15342', '18174', 1),
('module', 'replica', 'lang-ko', '15342', '18174', 1),
('module', 'replica', 'lang-lt', '15342', '18174', 1),
('module', 'replica', 'lang-nl', '15342', '18174', 1),
('module', 'replica', 'lang-no', '15342', '18174', 1),
('module', 'replica', 'lang-pl', '15342', '18174', 1),
('module', 'replica', 'lang-pt_BR', '15342', '18174', 1),
('module', 'replica', 'lang-pt', '15342', '18174', 1),
('module', 'replica', 'lang-ro', '15342', '18174', 1),
('module', 'replica', 'lang-ru', '15342', '20954', 1),
('module', 'replica', 'lang-sk', '15342', '18174', 1),
('module', 'replica', 'lang-sl', '15342', '18174', 1),
('module', 'replica', 'lang-sr', '15342', '18174', 1),
('module', 'replica', 'lang-sv', '15342', '18174', 1),
('module', 'replica', 'lang-tr', '15342', '18174', 1),
('module', 'replica', 'lang-uk', '15342', '18174', 1),
('module', 'replica', 'lang-vi', '15342', '18174', 1),
('module', 'replica', 'lang-zh_CN', '15342', '18174', 1),
('module', 'replica', 'lang-zh_TW', '15342', '18174', 1),
('module', 'reupload', 'base', '1.0.7', '20955', 1),
('module', 'reupload', 'lang-af', '16951', '18174', 1),
('module', 'reupload', 'lang-ar', '16951', '20954', 1),
('module', 'reupload', 'lang-ca', '16951', '18174', 1),
('module', 'reupload', 'lang-cs', '16951', '18174', 1),
('module', 'reupload', 'lang-da', '16951', '18174', 1),
('module', 'reupload', 'lang-de', '16951', '18174', 1),
('module', 'reupload', 'lang-el', '16951', '20954', 1),
('module', 'reupload', 'lang-en_GB', '16951', '18174', 1),
('module', 'reupload', 'lang-es', '16951', '18174', 1),
('module', 'reupload', 'lang-eu', '16951', '18174', 1),
('module', 'reupload', 'lang-fi', '16951', '18174', 1),
('module', 'reupload', 'lang-fr', '16951', '18174', 1),
('module', 'reupload', 'lang-hu', '16951', '18174', 1),
('module', 'reupload', 'lang-it', '16951', '18174', 1),
('module', 'reupload', 'lang-ja', '16951', '18174', 1),
('module', 'reupload', 'lang-ko', '16951', '18174', 1),
('module', 'reupload', 'lang-lt', '16951', '18174', 1),
('module', 'reupload', 'lang-nl', '16951', '18174', 1),
('module', 'reupload', 'lang-no', '16951', '18174', 1),
('module', 'reupload', 'lang-pl', '16951', '18174', 1),
('module', 'reupload', 'lang-ro', '16951', '18174', 1),
('module', 'reupload', 'lang-ru', '16951', '20954', 1),
('module', 'reupload', 'lang-sk', '16951', '18174', 1),
('module', 'reupload', 'lang-sr', '16951', '18174', 1),
('module', 'reupload', 'lang-sv', '16951', '18174', 1),
('module', 'reupload', 'lang-tr', '16951', '18174', 1),
('module', 'reupload', 'lang-uk', '16951', '18174', 1);
INSERT INTO `[[dbprefix]]PluginPackageMap` VALUES
('module', 'reupload', 'lang-vi', '16951', '18174', 1),
('module', 'reupload', 'lang-zh_CN', '16951', '18174', 1),
('module', 'reupload', 'lang-zh_TW', '16951', '20954', 1),
('module', 'rewrite', 'base', '1.1.19', '20955', 1),
('module', 'rewrite', 'lang-af', '15945', '18174', 1),
('module', 'rewrite', 'lang-ar', '15945', '20954', 1),
('module', 'rewrite', 'lang-ca', '15945', '18174', 1),
('module', 'rewrite', 'lang-cs', '15945', '18174', 1),
('module', 'rewrite', 'lang-da', '15945', '18174', 1),
('module', 'rewrite', 'lang-de', '15945', '18174', 1),
('module', 'rewrite', 'lang-el', '15945', '20954', 1),
('module', 'rewrite', 'lang-en_GB', '15945', '18174', 1),
('module', 'rewrite', 'lang-es', '15945', '18174', 1),
('module', 'rewrite', 'lang-eu', '15945', '18174', 1),
('module', 'rewrite', 'lang-fa', '15945', '18174', 1),
('module', 'rewrite', 'lang-fi', '15945', '18174', 1),
('module', 'rewrite', 'lang-fr', '15945', '18174', 1),
('module', 'rewrite', 'lang-hu', '15945', '20954', 1),
('module', 'rewrite', 'lang-it', '15945', '18174', 1),
('module', 'rewrite', 'lang-ja', '15945', '18174', 1),
('module', 'rewrite', 'lang-ko', '15945', '18174', 1),
('module', 'rewrite', 'lang-lt', '15945', '18174', 1),
('module', 'rewrite', 'lang-nl', '15945', '20954', 1),
('module', 'rewrite', 'lang-no', '15945', '18174', 1),
('module', 'rewrite', 'lang-pl', '15945', '18174', 1),
('module', 'rewrite', 'lang-pt_BR', '15945', '20954', 1),
('module', 'rewrite', 'lang-ro', '15945', '18174', 1),
('module', 'rewrite', 'lang-ru', '15945', '18174', 1),
('module', 'rewrite', 'lang-sk', '15945', '20954', 1),
('module', 'rewrite', 'lang-sr', '15945', '18174', 1),
('module', 'rewrite', 'lang-sv', '15945', '18174', 1),
('module', 'rewrite', 'lang-tr', '15945', '18174', 1),
('module', 'rewrite', 'lang-uk', '15945', '18174', 1),
('module', 'rewrite', 'lang-vi', '15945', '18174', 1),
('module', 'rewrite', 'lang-zh_CN', '15945', '18174', 1),
('module', 'rewrite', 'lang-zh_TW', '15945', '18174', 1),
('module', 'rss', 'base', '1.1.8', '20955', 1),
('module', 'rss', 'lang-af', '17316', '18174', 1),
('module', 'rss', 'lang-ar', '17316', '20954', 1),
('module', 'rss', 'lang-ca', '17316', '18174', 1),
('module', 'rss', 'lang-cs', '17316', '18174', 1),
('module', 'rss', 'lang-da', '17316', '18174', 1),
('module', 'rss', 'lang-de', '17316', '18174', 1),
('module', 'rss', 'lang-el', '17316', '20954', 1),
('module', 'rss', 'lang-en_GB', '17316', '18174', 1),
('module', 'rss', 'lang-es', '17316', '18174', 1),
('module', 'rss', 'lang-eu', '17316', '18174', 1),
('module', 'rss', 'lang-fi', '17316', '18174', 1),
('module', 'rss', 'lang-fr', '17316', '18174', 1),
('module', 'rss', 'lang-he', '17316', '18174', 1),
('module', 'rss', 'lang-hu', '17316', '20954', 1),
('module', 'rss', 'lang-it', '17316', '18174', 1),
('module', 'rss', 'lang-ja', '17316', '18174', 1),
('module', 'rss', 'lang-ko', '17316', '18174', 1),
('module', 'rss', 'lang-lt', '17316', '18174', 1),
('module', 'rss', 'lang-nl', '17316', '18174', 1),
('module', 'rss', 'lang-no', '17316', '18174', 1),
('module', 'rss', 'lang-pl', '17316', '18174', 1),
('module', 'rss', 'lang-pt_BR', '17316', '18174', 1),
('module', 'rss', 'lang-ro', '17316', '18174', 1),
('module', 'rss', 'lang-ru', '17316', '18174', 1),
('module', 'rss', 'lang-sk', '17316', '20954', 1),
('module', 'rss', 'lang-sr', '17316', '18174', 1),
('module', 'rss', 'lang-sv', '17316', '18174', 1),
('module', 'rss', 'lang-tr', '17316', '18174', 1),
('module', 'rss', 'lang-uk', '17316', '18174', 1),
('module', 'rss', 'lang-vi', '17316', '18174', 1),
('module', 'rss', 'lang-zh_CN', '17316', '18174', 1),
('module', 'rss', 'lang-zh_TW', '17316', '20954', 1),
('module', 'search', 'base', '1.0.8', '20955', 1),
('module', 'search', 'lang-af', '16208', '18174', 1),
('module', 'search', 'lang-ar', '16208', '20954', 1),
('module', 'search', 'lang-bg', '16208', '18174', 1),
('module', 'search', 'lang-ca', '16208', '18174', 1),
('module', 'search', 'lang-cs', '16208', '20954', 1),
('module', 'search', 'lang-da', '16208', '18174', 1),
('module', 'search', 'lang-de', '16208', '18174', 1),
('module', 'search', 'lang-el', '16208', '20954', 1),
('module', 'search', 'lang-en_GB', '16208', '18174', 1),
('module', 'search', 'lang-es_AR', '16208', '20954', 1),
('module', 'search', 'lang-es', '16208', '18174', 1),
('module', 'search', 'lang-et', '16208', '18174', 1),
('module', 'search', 'lang-eu', '16208', '18174', 1),
('module', 'search', 'lang-fa', '16208', '18174', 1),
('module', 'search', 'lang-fi', '16208', '18174', 1),
('module', 'search', 'lang-fr', '16208', '18174', 1),
('module', 'search', 'lang-ga', '16208', '20954', 1),
('module', 'search', 'lang-hu', '16208', '18174', 1),
('module', 'search', 'lang-is', '16208', '20954', 1),
('module', 'search', 'lang-it', '16208', '18174', 1),
('module', 'search', 'lang-ja', '16208', '18174', 1),
('module', 'search', 'lang-ko', '16208', '18174', 1),
('module', 'search', 'lang-lt', '16208', '18174', 1),
('module', 'search', 'lang-lv', '16208', '18174', 1),
('module', 'search', 'lang-nl', '16208', '20954', 1),
('module', 'search', 'lang-no', '16208', '20954', 1),
('module', 'search', 'lang-pl', '16208', '18174', 1),
('module', 'search', 'lang-pt_BR', '16208', '20954', 1),
('module', 'search', 'lang-pt', '16208', '20954', 1),
('module', 'search', 'lang-ro', '16208', '18174', 1),
('module', 'search', 'lang-ru', '16208', '18174', 1),
('module', 'search', 'lang-sk', '16208', '20954', 1),
('module', 'search', 'lang-sl', '16208', '20954', 1),
('module', 'search', 'lang-sr', '16208', '18174', 1),
('module', 'search', 'lang-sv', '16208', '18174', 1),
('module', 'search', 'lang-tr', '16208', '18174', 1),
('module', 'search', 'lang-uk', '16208', '18174', 1),
('module', 'search', 'lang-vi', '16208', '18174', 1),
('module', 'search', 'lang-zh_CN', '16208', '18174', 1),
('module', 'search', 'lang-zh_TW', '16208', '20954', 1),
('module', 'shutterfly', 'base', '1.0.14', '20955', 1),
('module', 'shutterfly', 'lang-af', '15342', '18174', 1),
('module', 'shutterfly', 'lang-bg', '15342', '20954', 1),
('module', 'shutterfly', 'lang-ca', '15342', '18174', 1),
('module', 'shutterfly', 'lang-cs', '15342', '20954', 1),
('module', 'shutterfly', 'lang-da', '15342', '18174', 1),
('module', 'shutterfly', 'lang-de', '15342', '18174', 1),
('module', 'shutterfly', 'lang-el', '15342', '20954', 1),
('module', 'shutterfly', 'lang-en_GB', '15342', '18174', 1),
('module', 'shutterfly', 'lang-es_AR', '15342', '20954', 1),
('module', 'shutterfly', 'lang-es_MX', '15342', '20954', 1),
('module', 'shutterfly', 'lang-es', '15342', '18174', 1),
('module', 'shutterfly', 'lang-et', '15342', '18174', 1),
('module', 'shutterfly', 'lang-eu', '15342', '18174', 1),
('module', 'shutterfly', 'lang-fa', '15342', '18174', 1),
('module', 'shutterfly', 'lang-fi', '15342', '18174', 1),
('module', 'shutterfly', 'lang-fr', '15342', '18174', 1),
('module', 'shutterfly', 'lang-ga', '15342', '20954', 1),
('module', 'shutterfly', 'lang-hu', '15342', '18174', 1),
('module', 'shutterfly', 'lang-is', '15342', '20954', 1),
('module', 'shutterfly', 'lang-it', '15342', '18174', 1),
('module', 'shutterfly', 'lang-ja', '15342', '18174', 1),
('module', 'shutterfly', 'lang-ko', '15342', '18174', 1),
('module', 'shutterfly', 'lang-nl', '15342', '20954', 1),
('module', 'shutterfly', 'lang-no', '15342', '18174', 1),
('module', 'shutterfly', 'lang-pl', '15342', '18174', 1),
('module', 'shutterfly', 'lang-pt_BR', '15342', '20954', 1),
('module', 'shutterfly', 'lang-ro', '15342', '20954', 1),
('module', 'shutterfly', 'lang-ru', '15342', '18174', 1),
('module', 'shutterfly', 'lang-sk', '15342', '20954', 1),
('module', 'shutterfly', 'lang-sr', '15342', '18174', 1),
('module', 'shutterfly', 'lang-sv', '15342', '18174', 1),
('module', 'shutterfly', 'lang-tr', '15342', '18174', 1),
('module', 'shutterfly', 'lang-vi', '15342', '20954', 1),
('module', 'shutterfly', 'lang-zh_CN', '15342', '18174', 1),
('module', 'shutterfly', 'lang-zh_TW', '15342', '20954', 1),
('module', 'sitemap', 'base', '1.0.6', '20955', 1),
('module', 'sitemap', 'lang-cs', '15342', '18174', 1),
('module', 'sitemap', 'lang-da', '15342', '18174', 1),
('module', 'sitemap', 'lang-de', '15342', '18174', 1),
('module', 'sitemap', 'lang-el', '15342', '20954', 1),
('module', 'sitemap', 'lang-en_GB', '15342', '18174', 1),
('module', 'sitemap', 'lang-es', '15342', '18174', 1),
('module', 'sitemap', 'lang-eu', '15342', '18174', 1),
('module', 'sitemap', 'lang-fi', '15342', '18174', 1),
('module', 'sitemap', 'lang-fr', '15342', '18174', 1),
('module', 'sitemap', 'lang-he', '15342', '18174', 1),
('module', 'sitemap', 'lang-it', '15342', '18174', 1),
('module', 'sitemap', 'lang-ja', '15342', '18174', 1),
('module', 'sitemap', 'lang-ko', '15342', '20954', 1),
('module', 'sitemap', 'lang-lv', '15342', '18174', 1),
('module', 'sitemap', 'lang-nl', '15342', '18174', 1),
('module', 'sitemap', 'lang-no', '15342', '18174', 1),
('module', 'sitemap', 'lang-pl', '15342', '18174', 1),
('module', 'sitemap', 'lang-pt_BR', '15342', '20954', 1),
('module', 'sitemap', 'lang-ro', '15342', '20954', 1),
('module', 'sitemap', 'lang-ru', '15342', '18174', 1),
('module', 'sitemap', 'lang-sk', '15342', '20954', 1),
('module', 'sitemap', 'lang-sr', '15342', '18174', 1),
('module', 'sitemap', 'lang-sv', '15342', '18174', 1),
('module', 'sitemap', 'lang-tr', '15342', '18174', 1),
('module', 'sitemap', 'lang-uk', '15342', '18174', 1),
('module', 'sitemap', 'lang-zh_CN', '15342', '18174', 1),
('module', 'sitemap', 'lang-zh_TW', '15342', '18174', 1),
('module', 'sizelimit', 'base', '1.0.9', '20955', 1),
('module', 'sizelimit', 'lang-af', '15447', '18174', 1),
('module', 'sizelimit', 'lang-ar', '15447', '20954', 1),
('module', 'sizelimit', 'lang-ca', '15447', '18174', 1),
('module', 'sizelimit', 'lang-cs', '15447', '20954', 1),
('module', 'sizelimit', 'lang-da', '15447', '18174', 1),
('module', 'sizelimit', 'lang-de', '15447', '18174', 1),
('module', 'sizelimit', 'lang-el', '15447', '20954', 1),
('module', 'sizelimit', 'lang-en_GB', '15447', '18174', 1),
('module', 'sizelimit', 'lang-es', '15447', '18174', 1),
('module', 'sizelimit', 'lang-eu', '15447', '18174', 1),
('module', 'sizelimit', 'lang-fi', '15447', '18174', 1),
('module', 'sizelimit', 'lang-fr', '15447', '20954', 1),
('module', 'sizelimit', 'lang-hu', '15447', '20954', 1),
('module', 'sizelimit', 'lang-is', '15447', '20954', 1),
('module', 'sizelimit', 'lang-it', '15447', '18174', 1),
('module', 'sizelimit', 'lang-ja', '15447', '18174', 1),
('module', 'sizelimit', 'lang-ko', '15447', '18174', 1),
('module', 'sizelimit', 'lang-lt', '15447', '18174', 1),
('module', 'sizelimit', 'lang-nl', '15447', '20954', 1),
('module', 'sizelimit', 'lang-no', '15447', '18174', 1),
('module', 'sizelimit', 'lang-pl', '15447', '18174', 1),
('module', 'sizelimit', 'lang-pt_BR', '15447', '18174', 1),
('module', 'sizelimit', 'lang-ro', '15447', '18174', 1),
('module', 'sizelimit', 'lang-ru', '15447', '18174', 1),
('module', 'sizelimit', 'lang-sk', '15447', '18174', 1),
('module', 'sizelimit', 'lang-sl', '15447', '18174', 1),
('module', 'sizelimit', 'lang-sr', '15447', '18174', 1),
('module', 'sizelimit', 'lang-sv', '15447', '18174', 1),
('module', 'sizelimit', 'lang-tr', '15447', '18174', 1),
('module', 'sizelimit', 'lang-uk', '15447', '18174', 1),
('module', 'sizelimit', 'lang-vi', '15447', '18174', 1),
('module', 'sizelimit', 'lang-zh_CN', '15447', '18174', 1),
('module', 'sizelimit', 'lang-zh_TW', '15447', '20954', 1),
('module', 'slideshow', 'base', '2.0.0', '20955', 1),
('module', 'slideshow', 'lang-af', '17527', '18100', 1),
('module', 'slideshow', 'lang-ar', '17527', '18100', 1),
('module', 'slideshow', 'lang-bg', '17527', '18100', 1),
('module', 'slideshow', 'lang-ca', '17527', '18100', 1),
('module', 'slideshow', 'lang-cs', '17527', '18100', 1),
('module', 'slideshow', 'lang-da', '17527', '18100', 1),
('module', 'slideshow', 'lang-de', '17527', '18100', 1),
('module', 'slideshow', 'lang-el', '17527', '20954', 1),
('module', 'slideshow', 'lang-en_GB', '17527', '18118', 1),
('module', 'slideshow', 'lang-es', '17527', '18100', 1),
('module', 'slideshow', 'lang-eu', '17527', '18100', 1),
('module', 'slideshow', 'lang-fa', '17527', '18100', 1),
('module', 'slideshow', 'lang-fi', '17527', '18100', 1),
('module', 'slideshow', 'lang-fr', '17527', '18100', 1),
('module', 'slideshow', 'lang-hu', '17527', '18100', 1),
('module', 'slideshow', 'lang-is', '17527', '18100', 1),
('module', 'slideshow', 'lang-it', '17527', '18100', 1),
('module', 'slideshow', 'lang-ja', '17527', '18100', 1),
('module', 'slideshow', 'lang-ko', '17527', '18100', 1),
('module', 'slideshow', 'lang-lt', '17527', '18100', 1),
('module', 'slideshow', 'lang-lv', '17527', '18100', 1),
('module', 'slideshow', 'lang-nl', '17527', '18100', 1),
('module', 'slideshow', 'lang-no', '17527', '18100', 1),
('module', 'slideshow', 'lang-pl', '17527', '18100', 1),
('module', 'slideshow', 'lang-pt_BR', '17527', '18100', 1),
('module', 'slideshow', 'lang-pt', '17527', '18100', 1),
('module', 'slideshow', 'lang-ro', '17527', '18100', 1),
('module', 'slideshow', 'lang-ru', '17527', '20954', 1),
('module', 'slideshow', 'lang-sk', '17527', '20954', 1),
('module', 'slideshow', 'lang-sl', '17527', '20954', 1),
('module', 'slideshow', 'lang-sr', '17527', '18100', 1),
('module', 'slideshow', 'lang-sv', '17527', '18113', 1),
('module', 'slideshow', 'lang-tr', '17527', '18100', 1),
('module', 'slideshow', 'lang-uk', '17527', '18100', 1),
('module', 'slideshow', 'lang-vi', '17527', '18100', 1),
('module', 'slideshow', 'lang-zh_CN', '17527', '18100', 1),
('module', 'slideshow', 'lang-zh_TW', '17527', '20954', 1),
('module', 'slideshowapplet', 'base', '1.0.13', '20955', 1),
('module', 'slideshowapplet', 'lang-af', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-ar', '16376', '20954', 1),
('module', 'slideshowapplet', 'lang-bg', '16376', '20954', 1),
('module', 'slideshowapplet', 'lang-ca', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-cs', '16376', '20954', 1),
('module', 'slideshowapplet', 'lang-da', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-de', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-el', '16376', '20954', 1),
('module', 'slideshowapplet', 'lang-en_GB', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-es', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-et', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-eu', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-fi', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-fr', '16376', '20954', 1),
('module', 'slideshowapplet', 'lang-hu', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-it', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-ja', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-ko', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-lt', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-nl', '16376', '20954', 1),
('module', 'slideshowapplet', 'lang-no', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-pl', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-ro', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-ru', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-sk', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-sl', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-sr', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-sv', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-tr', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-uk', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-vi', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-zh_CN', '16376', '18174', 1),
('module', 'slideshowapplet', 'lang-zh_TW', '16376', '20954', 1),
('module', 'snapgalaxy', 'base', '1.0.0', '20955', 1),
('module', 'snapgalaxy', 'lang-af', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-ar', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-bg', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-ca', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-cs', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-da', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-de', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-el', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-en_GB', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-es_AR', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-es_MX', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-es', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-et', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-eu', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-fi', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-fr', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-ga', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-he', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-hu', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-it', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-ja', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-ko', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-lt', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-lv', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-nl', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-no', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-pl', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-pt_BR', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-pt', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-ro', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-ru', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-sk', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-sl', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-sr', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-sv', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-tr', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-uk', '17426', '18174', 1),
('module', 'snapgalaxy', 'lang-vi', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-zh_CN', '17426', '20954', 1),
('module', 'snapgalaxy', 'lang-zh_TW', '17426', '20954', 1),
('module', 'squarethumb', 'base', '1.0.9', '20955', 1),
('module', 'squarethumb', 'lang-af', '16376', '18174', 1),
('module', 'squarethumb', 'lang-ar', '16376', '20954', 1),
('module', 'squarethumb', 'lang-ca', '16376', '18174', 1),
('module', 'squarethumb', 'lang-cs', '16376', '20954', 1),
('module', 'squarethumb', 'lang-da', '16376', '18174', 1),
('module', 'squarethumb', 'lang-de', '16376', '18174', 1),
('module', 'squarethumb', 'lang-el', '16376', '20954', 1),
('module', 'squarethumb', 'lang-en_GB', '16376', '18174', 1),
('module', 'squarethumb', 'lang-es', '16376', '18174', 1),
('module', 'squarethumb', 'lang-eu', '16376', '18174', 1),
('module', 'squarethumb', 'lang-fi', '16376', '18174', 1),
('module', 'squarethumb', 'lang-fr', '16376', '20954', 1),
('module', 'squarethumb', 'lang-hu', '16376', '20954', 1),
('module', 'squarethumb', 'lang-is', '16376', '20954', 1),
('module', 'squarethumb', 'lang-it', '16376', '18174', 1),
('module', 'squarethumb', 'lang-ja', '16376', '18174', 1),
('module', 'squarethumb', 'lang-ko', '16376', '18174', 1),
('module', 'squarethumb', 'lang-lt', '16376', '18174', 1),
('module', 'squarethumb', 'lang-nl', '16376', '20954', 1),
('module', 'squarethumb', 'lang-no', '16376', '18174', 1),
('module', 'squarethumb', 'lang-pl', '16376', '18174', 1),
('module', 'squarethumb', 'lang-ro', '16376', '18174', 1),
('module', 'squarethumb', 'lang-ru', '16376', '18174', 1),
('module', 'squarethumb', 'lang-sk', '16376', '18174', 1),
('module', 'squarethumb', 'lang-sr', '16376', '18174', 1),
('module', 'squarethumb', 'lang-sv', '16376', '18174', 1),
('module', 'squarethumb', 'lang-tr', '16376', '18174', 1),
('module', 'squarethumb', 'lang-uk', '16376', '18174', 1),
('module', 'squarethumb', 'lang-vi', '16376', '18174', 1),
('module', 'squarethumb', 'lang-zh_CN', '16376', '18174', 1),
('module', 'squarethumb', 'lang-zh_TW', '16376', '20954', 1),
('module', 'thumbnail', 'base', '1.0.14', '20955', 1),
('module', 'thumbnail', 'lang-af', '15342', '18174', 1),
('module', 'thumbnail', 'lang-ar', '15342', '20954', 1),
('module', 'thumbnail', 'lang-ca', '15342', '18174', 1),
('module', 'thumbnail', 'lang-cs', '15342', '18174', 1),
('module', 'thumbnail', 'lang-da', '15342', '18174', 1),
('module', 'thumbnail', 'lang-de', '15342', '18174', 1),
('module', 'thumbnail', 'lang-el', '15342', '20954', 1),
('module', 'thumbnail', 'lang-en_GB', '15342', '18174', 1),
('module', 'thumbnail', 'lang-es', '15342', '18174', 1),
('module', 'thumbnail', 'lang-eu', '15342', '18174', 1),
('module', 'thumbnail', 'lang-fi', '15342', '18174', 1),
('module', 'thumbnail', 'lang-fr', '15342', '20954', 1),
('module', 'thumbnail', 'lang-hu', '15342', '18174', 1),
('module', 'thumbnail', 'lang-is', '15342', '20954', 1),
('module', 'thumbnail', 'lang-it', '15342', '18174', 1),
('module', 'thumbnail', 'lang-ja', '15342', '18174', 1),
('module', 'thumbnail', 'lang-ko', '15342', '18174', 1),
('module', 'thumbnail', 'lang-lt', '15342', '18174', 1),
('module', 'thumbnail', 'lang-nl', '15342', '18174', 1),
('module', 'thumbnail', 'lang-no', '15342', '18174', 1),
('module', 'thumbnail', 'lang-pl', '15342', '18174', 1),
('module', 'thumbnail', 'lang-ro', '15342', '18174', 1),
('module', 'thumbnail', 'lang-ru', '15342', '18174', 1),
('module', 'thumbnail', 'lang-sk', '15342', '18174', 1),
('module', 'thumbnail', 'lang-sr', '15342', '18174', 1),
('module', 'thumbnail', 'lang-sv', '15342', '18174', 1),
('module', 'thumbnail', 'lang-tr', '15342', '18174', 1),
('module', 'thumbnail', 'lang-uk', '15342', '18174', 1),
('module', 'thumbnail', 'lang-vi', '15342', '18174', 1),
('module', 'thumbnail', 'lang-zh_CN', '15342', '18174', 1),
('module', 'thumbnail', 'lang-zh_TW', '15342', '20954', 1),
('module', 'thumbpage', 'base', '1.0.8', '20955', 1),
('module', 'thumbpage', 'lang-af', '15447', '18174', 1),
('module', 'thumbpage', 'lang-ar', '15447', '20954', 1),
('module', 'thumbpage', 'lang-ca', '15447', '18174', 1),
('module', 'thumbpage', 'lang-cs', '15447', '20954', 1),
('module', 'thumbpage', 'lang-da', '15447', '18174', 1),
('module', 'thumbpage', 'lang-de', '15447', '18174', 1),
('module', 'thumbpage', 'lang-el', '15447', '20954', 1),
('module', 'thumbpage', 'lang-en_GB', '15447', '18174', 1),
('module', 'thumbpage', 'lang-es', '15447', '18174', 1),
('module', 'thumbpage', 'lang-eu', '15447', '18174', 1),
('module', 'thumbpage', 'lang-fi', '15447', '18174', 1),
('module', 'thumbpage', 'lang-fr', '15447', '20954', 1),
('module', 'thumbpage', 'lang-hu', '15447', '20954', 1),
('module', 'thumbpage', 'lang-is', '15447', '20954', 1),
('module', 'thumbpage', 'lang-it', '15447', '18174', 1),
('module', 'thumbpage', 'lang-ja', '15447', '18174', 1),
('module', 'thumbpage', 'lang-ko', '15447', '18174', 1),
('module', 'thumbpage', 'lang-lt', '15447', '18174', 1),
('module', 'thumbpage', 'lang-nl', '15447', '20954', 1),
('module', 'thumbpage', 'lang-no', '15447', '18174', 1),
('module', 'thumbpage', 'lang-pl', '15447', '18174', 1),
('module', 'thumbpage', 'lang-ro', '15447', '18174', 1),
('module', 'thumbpage', 'lang-ru', '15447', '18174', 1),
('module', 'thumbpage', 'lang-sk', '15447', '18174', 1),
('module', 'thumbpage', 'lang-sr', '15447', '18174', 1),
('module', 'thumbpage', 'lang-sv', '15447', '18174', 1),
('module', 'thumbpage', 'lang-tr', '15447', '18174', 1),
('module', 'thumbpage', 'lang-uk', '15447', '18174', 1),
('module', 'thumbpage', 'lang-vi', '15447', '18174', 1),
('module', 'thumbpage', 'lang-zh_CN', '15447', '18174', 1),
('module', 'thumbpage', 'lang-zh_TW', '15447', '20954', 1),
('module', 'uploadapplet', 'base', '1.0.11', '20955', 1),
('module', 'uploadapplet', 'lang-af', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-ar', '16376', '20954', 1),
('module', 'uploadapplet', 'lang-ca', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-cs', '16376', '20954', 1),
('module', 'uploadapplet', 'lang-da', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-de', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-el', '16376', '20954', 1),
('module', 'uploadapplet', 'lang-en_GB', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-es', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-et', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-eu', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-fi', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-fr', '16376', '20954', 1),
('module', 'uploadapplet', 'lang-hu', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-is', '16376', '20954', 1),
('module', 'uploadapplet', 'lang-it', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-ja', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-ko', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-lt', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-lv', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-nl', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-no', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-pl', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-pt_BR', '16376', '20954', 1),
('module', 'uploadapplet', 'lang-ro', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-ru', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-sk', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-sl', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-sr', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-sv', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-tr', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-uk', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-vi', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-zh_CN', '16376', '18174', 1),
('module', 'uploadapplet', 'lang-zh_TW', '16376', '20954', 1),
('module', 'useralbum', 'base', '1.0.11', '20955', 1),
('module', 'useralbum', 'lang-af', '15447', '18174', 1),
('module', 'useralbum', 'lang-ar', '15447', '20954', 1),
('module', 'useralbum', 'lang-bg', '15447', '18174', 1),
('module', 'useralbum', 'lang-ca', '15447', '20954', 1),
('module', 'useralbum', 'lang-cs', '15447', '20954', 1),
('module', 'useralbum', 'lang-da', '15447', '18174', 1),
('module', 'useralbum', 'lang-de', '15447', '18174', 1),
('module', 'useralbum', 'lang-el', '15447', '20954', 1),
('module', 'useralbum', 'lang-en_GB', '15447', '18174', 1),
('module', 'useralbum', 'lang-es', '15447', '18174', 1),
('module', 'useralbum', 'lang-et', '15447', '18174', 1),
('module', 'useralbum', 'lang-eu', '15447', '18174', 1),
('module', 'useralbum', 'lang-fi', '15447', '18174', 1),
('module', 'useralbum', 'lang-fr', '15447', '20954', 1),
('module', 'useralbum', 'lang-he', '15447', '18174', 1),
('module', 'useralbum', 'lang-hu', '15447', '18174', 1),
('module', 'useralbum', 'lang-is', '15447', '20954', 1),
('module', 'useralbum', 'lang-it', '15447', '18174', 1),
('module', 'useralbum', 'lang-ja', '15447', '18174', 1),
('module', 'useralbum', 'lang-ko', '15447', '18174', 1),
('module', 'useralbum', 'lang-lt', '15447', '18174', 1),
('module', 'useralbum', 'lang-lv', '15447', '18174', 1),
('module', 'useralbum', 'lang-nl', '15447', '18174', 1),
('module', 'useralbum', 'lang-no', '15447', '18174', 1),
('module', 'useralbum', 'lang-pl', '15447', '18174', 1),
('module', 'useralbum', 'lang-ro', '15447', '18174', 1),
('module', 'useralbum', 'lang-ru', '15447', '18174', 1),
('module', 'useralbum', 'lang-sk', '15447', '18174', 1),
('module', 'useralbum', 'lang-sl', '15447', '18174', 1),
('module', 'useralbum', 'lang-sr', '15447', '18174', 1),
('module', 'useralbum', 'lang-sv', '15447', '18174', 1),
('module', 'useralbum', 'lang-tr', '15447', '18174', 1),
('module', 'useralbum', 'lang-uk', '15447', '18174', 1),
('module', 'useralbum', 'lang-vi', '15447', '18174', 1),
('module', 'useralbum', 'lang-zh_CN', '15447', '18174', 1),
('module', 'useralbum', 'lang-zh_TW', '15447', '20954', 1),
('module', 'watermark', 'base', '1.1.8', '20955', 1),
('module', 'watermark', 'lang-af', '17527', '18174', 1),
('module', 'watermark', 'lang-ar', '17527', '20954', 1),
('module', 'watermark', 'lang-ca', '17527', '18174', 1),
('module', 'watermark', 'lang-cs', '17527', '18174', 1),
('module', 'watermark', 'lang-da', '17527', '18174', 1),
('module', 'watermark', 'lang-de', '17527', '18174', 1),
('module', 'watermark', 'lang-el', '17527', '20954', 1),
('module', 'watermark', 'lang-en_GB', '17527', '18174', 1),
('module', 'watermark', 'lang-es', '17527', '18174', 1),
('module', 'watermark', 'lang-eu', '17527', '18174', 1),
('module', 'watermark', 'lang-fi', '17527', '18174', 1),
('module', 'watermark', 'lang-fr', '17527', '18174', 1),
('module', 'watermark', 'lang-hu', '17527', '18174', 1),
('module', 'watermark', 'lang-is', '17527', '20954', 1),
('module', 'watermark', 'lang-it', '17527', '18174', 1),
('module', 'watermark', 'lang-ja', '17527', '18174', 1),
('module', 'watermark', 'lang-ko', '17527', '18174', 1),
('module', 'watermark', 'lang-lt', '17527', '18174', 1),
('module', 'watermark', 'lang-nl', '17527', '18174', 1),
('module', 'watermark', 'lang-no', '17527', '18174', 1),
('module', 'watermark', 'lang-pl', '17527', '18174', 1),
('module', 'watermark', 'lang-pt_BR', '17527', '20954', 1),
('module', 'watermark', 'lang-ro', '17527', '18174', 1),
('module', 'watermark', 'lang-ru', '17527', '18174', 1),
('module', 'watermark', 'lang-sk', '17527', '18174', 1),
('module', 'watermark', 'lang-sl', '17527', '20954', 1),
('module', 'watermark', 'lang-sr', '17527', '18174', 1),
('module', 'watermark', 'lang-sv', '17527', '18174', 1),
('module', 'watermark', 'lang-tr', '17527', '18174', 1),
('module', 'watermark', 'lang-uk', '17527', '18174', 1),
('module', 'watermark', 'lang-vi', '17527', '18174', 1),
('module', 'watermark', 'lang-zh_CN', '17527', '18174', 1),
('module', 'watermark', 'lang-zh_TW', '17527', '20954', 1),
('module', 'webcam', 'base', '1.1.7', '20955', 1),
('module', 'webcam', 'lang-af', '17316', '18174', 1),
('module', 'webcam', 'lang-ar', '17316', '20954', 1),
('module', 'webcam', 'lang-ca', '17316', '18174', 1),
('module', 'webcam', 'lang-cs', '17316', '20954', 1),
('module', 'webcam', 'lang-da', '17316', '18174', 1),
('module', 'webcam', 'lang-de', '17316', '18174', 1),
('module', 'webcam', 'lang-el', '17316', '20954', 1),
('module', 'webcam', 'lang-en_GB', '17316', '18174', 1),
('module', 'webcam', 'lang-es', '17316', '18174', 1),
('module', 'webcam', 'lang-eu', '17316', '18174', 1),
('module', 'webcam', 'lang-fi', '17316', '18174', 1),
('module', 'webcam', 'lang-fr', '17316', '20954', 1),
('module', 'webcam', 'lang-hu', '17316', '20954', 1),
('module', 'webcam', 'lang-is', '17316', '20954', 1),
('module', 'webcam', 'lang-it', '17316', '18174', 1),
('module', 'webcam', 'lang-ja', '17316', '18174', 1),
('module', 'webcam', 'lang-ko', '17316', '18174', 1),
('module', 'webcam', 'lang-lt', '17316', '18174', 1),
('module', 'webcam', 'lang-nl', '17316', '20954', 1),
('module', 'webcam', 'lang-no', '17316', '18174', 1),
('module', 'webcam', 'lang-pl', '17316', '18174', 1),
('module', 'webcam', 'lang-ro', '17316', '18174', 1),
('module', 'webcam', 'lang-ru', '17316', '18174', 1),
('module', 'webcam', 'lang-sk', '17316', '18174', 1),
('module', 'webcam', 'lang-sr', '17316', '18174', 1),
('module', 'webcam', 'lang-sv', '17316', '18174', 1),
('module', 'webcam', 'lang-tr', '17316', '18174', 1),
('module', 'webcam', 'lang-uk', '17316', '18174', 1),
('module', 'webcam', 'lang-vi', '17316', '18174', 1),
('module', 'webcam', 'lang-zh_CN', '17316', '18174', 1),
('module', 'webcam', 'lang-zh_TW', '17316', '20954', 1),
('module', 'webdav', 'base', '1.0.10', '20955', 1),
('module', 'webdav', 'lang-cs', '15749', '18174', 1),
('module', 'webdav', 'lang-da', '15749', '18174', 1),
('module', 'webdav', 'lang-de', '15749', '18174', 1),
('module', 'webdav', 'lang-el', '15749', '20954', 1),
('module', 'webdav', 'lang-en_GB', '15749', '18174', 1),
('module', 'webdav', 'lang-es', '15749', '18174', 1),
('module', 'webdav', 'lang-fi', '15749', '18174', 1),
('module', 'webdav', 'lang-fr', '15749', '18174', 1),
('module', 'webdav', 'lang-it', '15749', '18174', 1),
('module', 'webdav', 'lang-ja', '15749', '18174', 1),
('module', 'webdav', 'lang-lt', '15749', '18174', 1),
('module', 'webdav', 'lang-no', '15749', '18174', 1),
('module', 'webdav', 'lang-pl', '15749', '18174', 1),
('module', 'webdav', 'lang-ru', '15749', '18174', 1),
('module', 'webdav', 'lang-sr', '15749', '18174', 1),
('module', 'webdav', 'lang-sv', '15749', '18174', 1),
('module', 'webdav', 'lang-tr', '15749', '18174', 1),
('module', 'webdav', 'lang-zh_TW', '15749', '20954', 1),
('module', 'zipcart', 'base', '1.0.15', '20955', 1),
('module', 'zipcart', 'lang-af', '17028', '18174', 1),
('module', 'zipcart', 'lang-ar', '17028', '20954', 1),
('module', 'zipcart', 'lang-ca', '17028', '18174', 1),
('module', 'zipcart', 'lang-cs', '17028', '20954', 1),
('module', 'zipcart', 'lang-da', '17028', '18174', 1),
('module', 'zipcart', 'lang-de', '17028', '18174', 1),
('module', 'zipcart', 'lang-el', '17028', '20954', 1),
('module', 'zipcart', 'lang-en_GB', '17028', '18174', 1),
('module', 'zipcart', 'lang-es', '17028', '18174', 1),
('module', 'zipcart', 'lang-et', '17028', '18174', 1),
('module', 'zipcart', 'lang-eu', '17028', '18174', 1),
('module', 'zipcart', 'lang-fi', '17028', '18174', 1),
('module', 'zipcart', 'lang-fr', '17028', '20954', 1),
('module', 'zipcart', 'lang-hu', '17028', '20954', 1),
('module', 'zipcart', 'lang-is', '17028', '20954', 1),
('module', 'zipcart', 'lang-it', '17028', '18174', 1),
('module', 'zipcart', 'lang-ja', '17028', '18174', 1),
('module', 'zipcart', 'lang-ko', '17028', '18174', 1),
('module', 'zipcart', 'lang-lt', '17028', '18174', 1),
('module', 'zipcart', 'lang-nl', '17028', '20954', 1),
('module', 'zipcart', 'lang-no', '17028', '18174', 1),
('module', 'zipcart', 'lang-pl', '17028', '18174', 1),
('module', 'zipcart', 'lang-ro', '17028', '18174', 1),
('module', 'zipcart', 'lang-ru', '17028', '18174', 1),
('module', 'zipcart', 'lang-sk', '17028', '18174', 1),
('module', 'zipcart', 'lang-sr', '17028', '18174', 1),
('module', 'zipcart', 'lang-sv', '17028', '18174', 1),
('module', 'zipcart', 'lang-tr', '17028', '18174', 1),
('module', 'zipcart', 'lang-uk', '17028', '18174', 1),
('module', 'zipcart', 'lang-vi', '17028', '18174', 1),
('module', 'zipcart', 'lang-zh_CN', '17028', '18174', 1),
('module', 'zipcart', 'lang-zh_TW', '17028', '20954', 1),
('module', 'gd', 'base', '1.1.6', '20961', 1),
('module', 'gd', 'lang-af', '15342', '17580', 1),
('module', 'gd', 'lang-ar', '15342', '20954', 1),
('module', 'gd', 'lang-ca', '15342', '17580', 1),
('module', 'gd', 'lang-cs', '15342', '17580', 1),
('module', 'gd', 'lang-da', '15342', '17580', 1),
('module', 'gd', 'lang-de', '15342', '17580', 1),
('module', 'gd', 'lang-el', '15342', '20954', 1),
('module', 'gd', 'lang-en_GB', '15342', '17580', 1),
('module', 'gd', 'lang-es', '15342', '17594', 1),
('module', 'gd', 'lang-et', '15342', '17580', 1),
('module', 'gd', 'lang-eu', '15342', '17580', 1),
('module', 'gd', 'lang-fa', '15342', '17580', 1),
('module', 'gd', 'lang-fi', '15342', '17580', 1),
('module', 'gd', 'lang-fr', '15342', '20954', 1),
('module', 'gd', 'lang-hu', '15342', '17580', 1),
('module', 'gd', 'lang-is', '15342', '20954', 1),
('module', 'gd', 'lang-it', '15342', '17580', 1),
('module', 'gd', 'lang-ja', '15342', '17580', 1),
('module', 'gd', 'lang-ko', '15342', '17580', 1),
('module', 'gd', 'lang-lt', '15342', '17580', 1),
('module', 'gd', 'lang-lv', '15342', '17580', 1),
('module', 'gd', 'lang-nl', '15342', '17828', 1),
('module', 'gd', 'lang-no', '15342', '17580', 1),
('module', 'gd', 'lang-pl', '15342', '17580', 1),
('module', 'gd', 'lang-pt_BR', '15342', '20954', 1),
('module', 'gd', 'lang-ro', '15342', '17580', 1),
('module', 'gd', 'lang-ru', '15342', '17580', 1),
('module', 'gd', 'lang-sk', '15342', '20954', 1),
('module', 'gd', 'lang-sl', '15342', '17688', 1),
('module', 'gd', 'lang-sr', '15342', '17580', 1),
('module', 'gd', 'lang-sv', '15342', '17580', 1),
('module', 'gd', 'lang-tr', '15342', '17580', 1),
('module', 'gd', 'lang-uk', '15342', '17580', 1),
('module', 'gd', 'lang-vi', '15342', '17580', 1),
('module', 'gd', 'lang-zh_CN', '15342', '20954', 1),
('module', 'gd', 'lang-zh_TW', '15342', '20954', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PluginParameterMap`
--

CREATE TABLE `[[dbprefix]]PluginParameterMap` (
  `g_pluginType` varchar(32) NOT NULL,
  `g_pluginId` varchar(32) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_parameterName` varchar(128) NOT NULL,
  `g_parameterValue` text NOT NULL,
  UNIQUE KEY `g_pluginType` (`g_pluginType`,`g_pluginId`,`g_itemId`,`g_parameterName`),
  KEY `[[dbprefix]]PluginParameterMap_80596` (`g_pluginType`),
  KEY `[[dbprefix]]PluginParameterMap_12808` (`g_pluginType`,`g_pluginId`,`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]PluginParameterMap`
--

INSERT INTO `[[dbprefix]]PluginParameterMap` VALUES
('module', 'albumselect', 0, 'sort', 'manual'),
('module', 'albumselect', 0, 'treeCloseSameLevel', '0'),
('module', 'albumselect', 0, 'treeCookies', '0'),
('module', 'albumselect', 0, 'treeExpandCollapse', '0'),
('module', 'albumselect', 0, 'treeIcons', '0'),
('module', 'albumselect', 0, 'treeLines', '1'),
('module', 'albumselect', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'albumselect', 0, '_requiredCoreApi', '7,34'),
('module', 'albumselect', 0, '_requiredModuleApi', '3,6'),
('module', 'albumselect', 0, '_templateVersion', '1'),
('module', 'albumselect', 0, '_version', '1.0.11'),
('module', 'archiveupload', 0, 'removeMeta', '1'),
('module', 'archiveupload', 0, 'unzipPath', '/usr/bin/unzip'),
('module', 'archiveupload', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'archiveupload', 0, '_requiredCoreApi', '7,20'),
('module', 'archiveupload', 0, '_requiredModuleApi', '3,6'),
('module', 'archiveupload', 0, '_templateVersion', '1'),
('module', 'archiveupload', 0, '_version', '1.0.10'),
('module', 'captcha', 0, 'failedAttemptThreshold', '3'),
('module', 'captcha', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'captcha', 0, '_requiredCoreApi', '7,20'),
('module', 'captcha', 0, '_requiredModuleApi', '3,6'),
('module', 'captcha', 0, '_templateVersion', '1'),
('module', 'captcha', 0, '_version', '1.1.7'),
('module', 'cart', 0, '_callbacks', 'getItemLinks'),
('module', 'cart', 0, '_requiredCoreApi', '7,27'),
('module', 'cart', 0, '_requiredModuleApi', '3,9'),
('module', 'cart', 0, '_templateVersion', '1'),
('module', 'cart', 0, '_version', '1.0.12'),
('module', 'colorpack', 0, '_callbacks', ''),
('module', 'colorpack', 0, '_requiredCoreApi', '7,20'),
('module', 'colorpack', 0, '_requiredModuleApi', '3,6'),
('module', 'colorpack', 0, '_templateVersion', '1'),
('module', 'colorpack', 0, '_version', '1.0.7'),
('module', 'comment', 0, 'comments.latest', '1'),
('module', 'comment', 0, 'comments.moderate', '0'),
('module', 'comment', 0, 'comments.show', '10'),
('module', 'comment', 0, 'validation.level', 'HIGH'),
('module', 'comment', 0, '_callbacks', 'getItemLinks|getItemSummaries|getSiteAdminViews|getItemAdminViews'),
('module', 'comment', 0, '_requiredCoreApi', '7,41'),
('module', 'comment', 0, '_requiredModuleApi', '3,9'),
('module', 'comment', 0, '_templateVersion', '1'),
('module', 'comment', 0, '_version', '1.1.14'),
('module', 'core', 0, 'acceleration', 'a:2:{s:5:"guest";a:1:{s:4:"type";s:4:"none";}s:4:"user";a:1:{s:4:"type";s:4:"none";}}'),
('module', 'core', 0, 'core.repositories', 'a:1:{s:8:"released";i:1;}'),
('module', 'core', 0, 'default.language', 'en_US'),
('module', 'core', 0, 'default.newAlbumsUseDefaults', 'false'),
('module', 'core', 0, 'default.orderBy', 'orderWeight'),
('module', 'core', 0, 'default.orderDirection', '1'),
('module', 'core', 0, 'default.theme', 'matrix'),
('module', 'core', 0, 'exec.beNice', '0'),
('module', 'core', 0, 'exec.expectedStatus', '0'),
('module', 'core', 0, 'format.date', '%x'),
('module', 'core', 0, 'format.datetime', '%c'),
('module', 'core', 0, 'format.time', '%X'),
('module', 'core', 0, 'id.accessListCompacterLock', '1'),
('module', 'core', 0, 'id.adminGroup', '3'),
('module', 'core', 0, 'id.allUserGroup', '2'),
('module', 'core', 0, 'id.anonymousUser', '5'),
('module', 'core', 0, 'id.everybodyGroup', '4'),
('module', 'core', 0, 'id.rootAlbum', '7'),
('module', 'core', 0, 'language.useBrowserPref', '0'),
('module', 'core', 0, 'lock.system', 'flock'),
('module', 'core', 0, 'misc.markup', 'bbcode'),
('module', 'core', 0, 'permissions.directory', '0755'),
('module', 'core', 0, 'permissions.file', '0644'),
('module', 'core', 0, 'repository.updateTime', '0'),
('module', 'core', 0, 'session.inactivityTimeout', '604800'),
('module', 'core', 0, 'session.lifetime', '1814400'),
('module', 'core', 0, 'session.siteAdministrationTimeout', '1800'),
('module', 'core', 0, 'smarty.compile_check', '0'),
('module', 'core', 0, 'validation.level', 'MEDIUM'),
('module', 'core', 0, '_callbacks', 'getItemLinks|getSystemLinks|getItemAdminViews|getSiteAdminViews|getUserAdminViews'),
('module', 'core', 0, '_requiredCoreApi', '7,53'),
('module', 'core', 0, '_requiredModuleApi', '3,8'),
('module', 'core', 0, '_templateVersion', '1'),
('module', 'core', 0, '_version', '1.3.0.2'),
('module', 'customfield', 0, '_callbacks', 'getSiteAdminViews|getItemSummaries'),
('module', 'customfield', 0, '_requiredCoreApi', '7,34'),
('module', 'customfield', 0, '_requiredModuleApi', '3,9'),
('module', 'customfield', 0, '_templateVersion', '1'),
('module', 'customfield', 0, '_version', '1.0.13'),
('module', 'dcraw', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'dcraw', 0, '_requiredCoreApi', '7,20'),
('module', 'dcraw', 0, '_requiredModuleApi', '3,6'),
('module', 'dcraw', 0, '_templateVersion', '1'),
('module', 'dcraw', 0, '_version', '1.0.13'),
('module', 'debug', 0, '_callbacks', 'getItemLinks'),
('module', 'debug', 0, '_requiredCoreApi', '7,27'),
('module', 'debug', 0, '_requiredModuleApi', '3,6'),
('module', 'debug', 0, '_templateVersion', '1'),
('module', 'debug', 0, '_version', '1.0.8'),
('module', 'digibug', 0, 'digibugCustomerId', '3153'),
('module', 'digibug', 0, 'digibugIdChoice', 'gallery'),
('module', 'digibug', 0, 'digibugPricelistId', '8491'),
('module', 'digibug', 0, '_callbacks', 'getSiteAdminViews|getItemLinks'),
('module', 'digibug', 0, '_requiredCoreApi', '7,43'),
('module', 'digibug', 0, '_requiredModuleApi', '3,9'),
('module', 'digibug', 0, '_templateVersion', '1'),
('module', 'digibug', 0, '_version', '1.0.8'),
('module', 'dynamicalbum', 0, 'description.date', ''),
('module', 'dynamicalbum', 0, 'description.random', ''),
('module', 'dynamicalbum', 0, 'description.views', ''),
('module', 'dynamicalbum', 0, 'itemlink.date', '0'),
('module', 'dynamicalbum', 0, 'itemlink.random', '0'),
('module', 'dynamicalbum', 0, 'itemlink.views', '0'),
('module', 'dynamicalbum', 0, 'size.date', '24'),
('module', 'dynamicalbum', 0, 'size.random', '24'),
('module', 'dynamicalbum', 0, 'size.views', '24'),
('module', 'dynamicalbum', 0, 'themeId', ''),
('module', 'dynamicalbum', 0, 'themeSettingsId', '13'),
('module', 'dynamicalbum', 0, 'type.date', 'data'),
('module', 'dynamicalbum', 0, 'type.random', 'data'),
('module', 'dynamicalbum', 0, 'type.views', 'data'),
('module', 'dynamicalbum', 0, '_callbacks', 'getSiteAdminViews|getItemLinks'),
('module', 'dynamicalbum', 0, '_requiredCoreApi', '7,27'),
('module', 'dynamicalbum', 0, '_requiredModuleApi', '3,6'),
('module', 'dynamicalbum', 0, '_templateVersion', '1'),
('module', 'dynamicalbum', 0, '_version', '1.0.3'),
('module', 'ecard', 0, 'bcc', ''),
('module', 'ecard', 0, 'footer', 'This eCard was sent with Gallery 2 - Your photos on your website'),
('module', 'ecard', 0, 'format', 'html'),
('module', 'ecard', 0, 'from', 'Gallery &lt;gallery&gt;'),
('module', 'ecard', 0, 'header', 'Hi %toName%!\n%fromName% (%from%) has sent you an eCard:'),
('module', 'ecard', 0, 'subject', 'You have been sent an eCard'),
('module', 'ecard', 0, 'validation.level', 'HIGH'),
('module', 'ecard', 0, '_callbacks', 'getItemLinks|getSiteAdminViews'),
('module', 'ecard', 0, '_requiredCoreApi', '7,27'),
('module', 'ecard', 0, '_requiredModuleApi', '3,9'),
('module', 'ecard', 0, '_templateVersion', '1'),
('module', 'ecard', 0, '_version', '1.0.4'),
('module', 'exif', 0, 'addOption', '4'),
('module', 'exif', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'exif', 0, '_requiredCoreApi', '7,41'),
('module', 'exif', 0, '_requiredModuleApi', '3,9'),
('module', 'exif', 0, '_templateVersion', '1'),
('module', 'exif', 0, '_version', '1.2.6'),
('module', 'ffmpeg', 0, 'path', ''),
('module', 'ffmpeg', 0, 'useWatermark', '0'),
('module', 'ffmpeg', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'ffmpeg', 0, '_requiredCoreApi', '7,27'),
('module', 'ffmpeg', 0, '_requiredModuleApi', '3,6'),
('module', 'ffmpeg', 0, '_templateVersion', '1'),
('module', 'ffmpeg', 0, '_version', '1.0.14'),
('module', 'flashvideo', 0, '_callbacks', ''),
('module', 'flashvideo', 0, '_requiredCoreApi', '7,27'),
('module', 'flashvideo', 0, '_requiredModuleApi', '3,6'),
('module', 'flashvideo', 0, '_templateVersion', '1'),
('module', 'flashvideo', 0, '_version', '1.0.3'),
('module', 'fotokasten', 0, 'affiliateId', '1927'),
('module', 'fotokasten', 0, 'affiliateIdPass', 'f12a65d90445f95b90e5fd30c75ee74e'),
('module', 'fotokasten', 0, '_callbacks', 'getSiteAdminViews|getItemLinks'),
('module', 'fotokasten', 0, '_requiredCoreApi', '7,30'),
('module', 'fotokasten', 0, '_requiredModuleApi', '3,6'),
('module', 'fotokasten', 0, '_templateVersion', '1'),
('module', 'fotokasten', 0, '_version', '1.0.12'),
('module', 'gd', 0, 'jpegQuality', '75'),
('module', 'gd', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'gd', 0, '_requiredCoreApi', '7,20'),
('module', 'gd', 0, '_requiredModuleApi', '3,6'),
('module', 'gd', 0, '_templateVersion', '1'),
('module', 'gd', 0, '_version', '1.1.6'),
('module', 'getid3', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'getid3', 0, '_requiredCoreApi', '7,27'),
('module', 'getid3', 0, '_requiredModuleApi', '3,6'),
('module', 'getid3', 0, '_templateVersion', '1'),
('module', 'getid3', 0, '_version', '1.0.7'),
('module', 'hidden', 0, '_callbacks', ''),
('module', 'hidden', 0, '_requiredCoreApi', '7,53'),
('module', 'hidden', 0, '_requiredModuleApi', '3,6'),
('module', 'hidden', 0, '_templateVersion', '1'),
('module', 'hidden', 0, '_version', '1.0.9'),
('module', 'httpauth', 0, 'authName', 'Gallery'),
('module', 'httpauth', 0, 'authtypePattern', '//'),
('module', 'httpauth', 0, 'httpAuthPlugin', '1'),
('module', 'httpauth', 0, 'useGlobally', ''),
('module', 'httpauth', 0, 'usernamePattern', '/^(.+\\\\)?([^\\\\@]+)(@.+)?$/'),
('module', 'httpauth', 0, 'usernameReplace', '$2'),
('module', 'httpauth', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'httpauth', 0, '_requiredCoreApi', '7,34'),
('module', 'httpauth', 0, '_requiredModuleApi', '3,6'),
('module', 'httpauth', 0, '_templateVersion', '1'),
('module', 'httpauth', 0, '_version', '1.0.4'),
('module', 'icons', 0, 'iconpack', 'silk'),
('module', 'icons', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'icons', 0, '_requiredCoreApi', '7,20'),
('module', 'icons', 0, '_requiredModuleApi', '3,6'),
('module', 'icons', 0, '_templateVersion', '1'),
('module', 'icons', 0, '_version', '1.1.5'),
('module', 'imageblock', 0, 'albumFrame', ''),
('module', 'imageblock', 0, 'itemFrame', ''),
('module', 'imageblock', 0, 'show', 'heading|title|date|views'),
('module', 'imageblock', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'imageblock', 0, '_requiredCoreApi', '7,47'),
('module', 'imageblock', 0, '_requiredModuleApi', '3,6'),
('module', 'imageblock', 0, '_templateVersion', '1'),
('module', 'imageblock', 0, '_version', '1.1.9'),
('module', 'imageframe', 0, '_callbacks', ''),
('module', 'imageframe', 0, '_requiredCoreApi', '7,27'),
('module', 'imageframe', 0, '_requiredModuleApi', '3,6'),
('module', 'imageframe', 0, '_templateVersion', '1'),
('module', 'imageframe', 0, '_version', '1.0.7'),
('module', 'imagemagick', 0, 'cmykSupport', 'none'),
('module', 'imagemagick', 0, 'jpegQuality', '75'),
('module', 'imagemagick', 0, 'path', ''),
('module', 'imagemagick', 0, 'useNewCoalesceOptions', '0'),
('module', 'imagemagick', 0, 'versionOk', ''),
('module', 'imagemagick', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'imagemagick', 0, '_requiredCoreApi', '7,20'),
('module', 'imagemagick', 0, '_requiredModuleApi', '3,6'),
('module', 'imagemagick', 0, '_templateVersion', '1'),
('module', 'imagemagick', 0, '_version', '1.1.6'),
('module', 'itemadd', 0, 'fromserver', 'on'),
('module', 'itemadd', 0, 'fromweb', 'admin'),
('module', 'itemadd', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'itemadd', 0, '_requiredCoreApi', '7,53'),
('module', 'itemadd', 0, '_requiredModuleApi', '3,6'),
('module', 'itemadd', 0, '_templateVersion', '1'),
('module', 'itemadd', 0, '_version', '1.0.9'),
('module', 'jpegtran', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'jpegtran', 0, '_requiredCoreApi', '7,20'),
('module', 'jpegtran', 0, '_requiredModuleApi', '3,6'),
('module', 'jpegtran', 0, '_templateVersion', '1'),
('module', 'jpegtran', 0, '_version', '1.0.1'),
('module', 'keyalbum', 0, 'description', ''),
('module', 'keyalbum', 0, 'orderBy', ''),
('module', 'keyalbum', 0, 'orderDirection', ''),
('module', 'keyalbum', 0, 'split', ';,'),
('module', 'keyalbum', 0, 'summaryLinks', 'all'),
('module', 'keyalbum', 0, 'themeId', ''),
('module', 'keyalbum', 0, 'themeSettingsId', '16'),
('module', 'keyalbum', 0, '_callbacks', 'getSiteAdminViews|getItemSummaries'),
('module', 'keyalbum', 0, '_requiredCoreApi', '7,27'),
('module', 'keyalbum', 0, '_requiredModuleApi', '3,6'),
('module', 'keyalbum', 0, '_templateVersion', '1'),
('module', 'keyalbum', 0, '_version', '1.0.6'),
('module', 'linkitem', 0, 'arrowWatermark', '1'),
('module', 'linkitem', 0, 'snapshotExec', 'khtml2png'),
('module', 'linkitem', 0, 'urlSnapshot', '0'),
('module', 'linkitem', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'linkitem', 0, '_requiredCoreApi', '7,41'),
('module', 'linkitem', 0, '_requiredModuleApi', '3,6'),
('module', 'linkitem', 0, '_templateVersion', '1'),
('module', 'linkitem', 0, '_version', '1.1.7'),
('module', 'members', 0, 'canViewEmailAddress', '0'),
('module', 'members', 0, 'canViewMembersModule', '4'),
('module', 'members', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'members', 0, '_requiredCoreApi', '7,27'),
('module', 'members', 0, '_requiredModuleApi', '3,6'),
('module', 'members', 0, '_templateVersion', '1'),
('module', 'members', 0, '_version', '1.0.8'),
('module', 'migrate', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'migrate', 0, '_requiredCoreApi', '7,53'),
('module', 'migrate', 0, '_requiredModuleApi', '3,6'),
('module', 'migrate', 0, '_templateVersion', '1'),
('module', 'migrate', 0, '_version', '1.0.14'),
('module', 'mime', 0, 'allowMime', 'all'),
('module', 'mime', 0, 'mimeList', ''),
('module', 'mime', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'mime', 0, '_requiredCoreApi', '7,20'),
('module', 'mime', 0, '_requiredModuleApi', '3,6'),
('module', 'mime', 0, '_templateVersion', '1'),
('module', 'mime', 0, '_version', '1.1.5'),
('module', 'mp3audio', 0, '_callbacks', ''),
('module', 'mp3audio', 0, '_requiredCoreApi', '7,27'),
('module', 'mp3audio', 0, '_requiredModuleApi', '3,6'),
('module', 'mp3audio', 0, '_templateVersion', '1'),
('module', 'mp3audio', 0, '_version', '1.0.3'),
('module', 'multilang', 0, 'languages', ''),
('module', 'multilang', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'multilang', 0, '_requiredCoreApi', '7,43'),
('module', 'multilang', 0, '_requiredModuleApi', '3,6'),
('module', 'multilang', 0, '_templateVersion', '1'),
('module', 'multilang', 0, '_version', '1.0.12'),
('module', 'multiroot', 0, '_callbacks', ''),
('module', 'multiroot', 0, '_requiredCoreApi', '7,27'),
('module', 'multiroot', 0, '_requiredModuleApi', '3,6'),
('module', 'multiroot', 0, '_templateVersion', '1'),
('module', 'multiroot', 0, '_version', '1.0.3'),
('module', 'netpbm', 0, 'bmptopnm', 'bmptopnm'),
('module', 'netpbm', 0, 'jpegQuality', '75'),
('module', 'netpbm', 0, 'path', ''),
('module', 'netpbm', 0, 'pnmcomp', 'pnmcomp'),
('module', 'netpbm', 0, 'pnmtojpeg', 'pnmtojpeg'),
('module', 'netpbm', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'netpbm', 0, '_requiredCoreApi', '7,20'),
('module', 'netpbm', 0, '_requiredModuleApi', '3,6'),
('module', 'netpbm', 0, '_templateVersion', '1'),
('module', 'netpbm', 0, '_version', '1.1.5'),
('module', 'newitems', 0, 'days.new', '7'),
('module', 'newitems', 0, 'days.updated', '7'),
('module', 'newitems', 0, '_callbacks', 'getSiteAdminViews|getItemSummaries'),
('module', 'newitems', 0, '_requiredCoreApi', '7,27'),
('module', 'newitems', 0, '_requiredModuleApi', '3,6'),
('module', 'newitems', 0, '_templateVersion', '1'),
('module', 'newitems', 0, '_version', '1.0.8'),
('module', 'nokiaupload', 0, '_callbacks', ''),
('module', 'nokiaupload', 0, '_requiredCoreApi', '7,53'),
('module', 'nokiaupload', 0, '_requiredModuleApi', '3,6'),
('module', 'nokiaupload', 0, '_templateVersion', '1'),
('module', 'nokiaupload', 0, '_version', '1.0.12'),
('module', 'notification', 0, 'id.eventMapLock', '17'),
('module', 'notification', 0, 'id.hintsLock', '18'),
('module', 'notification', 0, '_activeListeners', 'a:0:{}'),
('module', 'notification', 0, '_callbacks', 'getSiteAdminViews|getUserAdminViews|getItemLinks|getItemAdminViews'),
('module', 'notification', 0, '_requiredCoreApi', '7,37'),
('module', 'notification', 0, '_requiredModuleApi', '3,9'),
('module', 'notification', 0, '_templateVersion', '0'),
('module', 'notification', 0, '_version', '1.0.3'),
('module', 'panorama', 0, 'itemLink', '1'),
('module', 'panorama', 0, 'itemType', '1'),
('module', 'panorama', 0, 'width', '800'),
('module', 'panorama', 0, '_callbacks', 'getSiteAdminViews|getItemLinks'),
('module', 'panorama', 0, '_requiredCoreApi', '7,20'),
('module', 'panorama', 0, '_requiredModuleApi', '3,6'),
('module', 'panorama', 0, '_templateVersion', '1'),
('module', 'panorama', 0, '_version', '1.0.10'),
('module', 'password', 0, 'validation.level', 'MEDIUM'),
('module', 'password', 0, '_callbacks', ''),
('module', 'password', 0, '_requiredCoreApi', '7,53'),
('module', 'password', 0, '_requiredModuleApi', '3,6'),
('module', 'password', 0, '_templateVersion', '1'),
('module', 'password', 0, '_version', '1.0.9'),
('module', 'permalinks', 0, 'autoPermalink', '0'),
('module', 'permalinks', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'permalinks', 0, '_requiredCoreApi', '7,34'),
('module', 'permalinks', 0, '_requiredModuleApi', '3,6'),
('module', 'permalinks', 0, '_templateVersion', '1'),
('module', 'permalinks', 0, '_version', '1.0.12'),
('module', 'photoaccess', 0, '_callbacks', 'getItemLinks'),
('module', 'photoaccess', 0, '_requiredCoreApi', '7,43'),
('module', 'photoaccess', 0, '_requiredModuleApi', '3,9'),
('module', 'photoaccess', 0, '_templateVersion', '1'),
('module', 'photoaccess', 0, '_version', '1.0.13'),
('module', 'picasa', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'picasa', 0, '_requiredCoreApi', '7,45'),
('module', 'picasa', 0, '_requiredModuleApi', '3,6'),
('module', 'picasa', 0, '_templateVersion', '1'),
('module', 'picasa', 0, '_version', '1.0.10'),
('module', 'publishxp', 0, '_callbacks', ''),
('module', 'publishxp', 0, '_requiredCoreApi', '7,53'),
('module', 'publishxp', 0, '_requiredModuleApi', '3,6'),
('module', 'publishxp', 0, '_templateVersion', '1'),
('module', 'publishxp', 0, '_version', '1.0.14'),
('module', 'quotas', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'quotas', 0, '_requiredCoreApi', '7,34'),
('module', 'quotas', 0, '_requiredModuleApi', '3,6'),
('module', 'quotas', 0, '_templateVersion', '1'),
('module', 'quotas', 0, '_version', '1.1.4'),
('module', 'randomhighlight', 0, 'duration', '7200'),
('module', 'randomhighlight', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'randomhighlight', 0, '_requiredCoreApi', '7,27'),
('module', 'randomhighlight', 0, '_requiredModuleApi', '3,6'),
('module', 'randomhighlight', 0, '_templateVersion', '1'),
('module', 'randomhighlight', 0, '_version', '1.0.9'),
('module', 'rating', 0, 'allowAlbumRating', '0'),
('module', 'rating', 0, 'description', ''),
('module', 'rating', 0, 'minLimit', '2'),
('module', 'rating', 0, 'orderBy', 'RatingSortOrder'),
('module', 'rating', 0, 'orderDirection', 'desc'),
('module', 'rating', 0, 'themeId', ''),
('module', 'rating', 0, 'themeSettingsId', '21'),
('module', 'rating', 0, '_callbacks', 'getSiteAdminViews|getItemSummaries'),
('module', 'rating', 0, '_requiredCoreApi', '7,41'),
('module', 'rating', 0, '_requiredModuleApi', '3,6'),
('module', 'rating', 0, '_templateVersion', '1'),
('module', 'rating', 0, '_version', '1.0.13'),
('module', 'rearrange', 0, '_callbacks', 'getItemLinks|getItemAdminViews'),
('module', 'rearrange', 0, '_requiredCoreApi', '7,27'),
('module', 'rearrange', 0, '_requiredModuleApi', '3,9'),
('module', 'rearrange', 0, '_templateVersion', '1'),
('module', 'rearrange', 0, '_version', '1.0.9'),
('module', 'register', 0, 'adminsubject', 'New user registration'),
('module', 'register', 0, 'confirmation', 'admin'),
('module', 'register', 0, 'emailadmins', '1'),
('module', 'register', 0, 'emailusers', '1'),
('module', 'register', 0, 'from', 'webmaster@dad.nuftp.com'),
('module', 'register', 0, 'subject', 'Account activation'),
('module', 'register', 0, 'usersubject', 'Welcome to Gallery'),
('module', 'register', 0, 'validation.level', 'HIGH'),
('module', 'register', 0, '_callbacks', 'getSystemLinks|getUserAdminViews|getSiteAdminViews'),
('module', 'register', 0, '_requiredCoreApi', '7,35'),
('module', 'register', 0, '_requiredModuleApi', '3,6'),
('module', 'register', 0, '_templateVersion', '1'),
('module', 'register', 0, '_version', '1.0.14'),
('module', 'remote', 0, 'showItemAdd', '1'),
('module', 'remote', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'remote', 0, '_requiredCoreApi', '7,53'),
('module', 'remote', 0, '_requiredModuleApi', '3,6'),
('module', 'remote', 0, '_templateVersion', '1'),
('module', 'remote', 0, '_version', '1.0.18'),
('module', 'replica', 0, '_callbacks', 'getItemLinks|getItemAdminViews'),
('module', 'replica', 0, '_requiredCoreApi', '7,42'),
('module', 'replica', 0, '_requiredModuleApi', '3,9'),
('module', 'replica', 0, '_templateVersion', '1'),
('module', 'replica', 0, '_version', '1.0.5'),
('module', 'reupload', 0, '_callbacks', ''),
('module', 'reupload', 0, '_requiredCoreApi', '7,20'),
('module', 'reupload', 0, '_requiredModuleApi', '3,6'),
('module', 'reupload', 0, '_templateVersion', '1'),
('module', 'reupload', 0, '_version', '1.0.7'),
('module', 'rewrite', 0, 'accessList', 'a:0:{}'),
('module', 'rewrite', 0, 'activeRules', 'a:0:{}'),
('module', 'rewrite', 0, 'allowEmptyReferer', '1'),
('module', 'rewrite', 0, 'isapirewrite.embeddedLocation', ''),
('module', 'rewrite', 0, 'isapirewrite.forced', '0'),
('module', 'rewrite', 0, 'isapirewrite.galleryLocation', ''),
('module', 'rewrite', 0, 'isapirewrite.httpdini', ''),
('module', 'rewrite', 0, 'modrewrite.embeddedHtaccess', ''),
('module', 'rewrite', 0, 'modrewrite.embeddedLocation', ''),
('module', 'rewrite', 0, 'modrewrite.galleryLocation', ''),
('module', 'rewrite', 0, 'modrewrite.status', 'a:0:{}'),
('module', 'rewrite', 0, 'parserId', ''),
('module', 'rewrite', 0, 'pathinfo.forced', '0'),
('module', 'rewrite', 0, 'pathinfo.parser', 'a:0:{}'),
('module', 'rewrite', 0, 'shortUrls', 'a:0:{}'),
('module', 'rewrite', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'rewrite', 0, '_requiredCoreApi', '7,34'),
('module', 'rewrite', 0, '_requiredModuleApi', '3,6'),
('module', 'rewrite', 0, '_templateVersion', '1'),
('module', 'rewrite', 0, '_version', '1.1.19'),
('module', 'rss', 0, 'allowAlbums', '0'),
('module', 'rss', 0, 'allowCommentsAlbum', '0'),
('module', 'rss', 0, 'allowCommentsPhoto', '0'),
('module', 'rss', 0, 'allowCommentsRecursive', '0'),
('module', 'rss', 0, 'allowConfigurableFeed', '0'),
('module', 'rss', 0, 'allowPhotos', '0'),
('module', 'rss', 0, 'allowPhotosRandom', '0'),
('module', 'rss', 0, 'allowPhotosRandomRecursive', '0'),
('module', 'rss', 0, 'allowPhotosRecursive', '0'),
('module', 'rss', 0, 'allowSimpleFeed', '1'),
('module', 'rss', 0, 'defaultCopyright', ''),
('module', 'rss', 0, 'defaultCount', '10'),
('module', 'rss', 0, 'defaultTtl', '120'),
('module', 'rss', 0, 'defaultVersion', '2.0'),
('module', 'rss', 0, 'maxAge', '21'),
('module', 'rss', 0, 'maxCount', '50'),
('module', 'rss', 0, 'sfAlbumType', 'photos'),
('module', 'rss', 0, 'sfDate', 'new'),
('module', 'rss', 0, 'sfPhotosRecursiveLimit', '10'),
('module', 'rss', 0, '_callbacks', 'getSiteAdminViews|getItemLinks'),
('module', 'rss', 0, '_requiredCoreApi', '7,34'),
('module', 'rss', 0, '_requiredModuleApi', '3,6'),
('module', 'rss', 0, '_templateVersion', '1'),
('module', 'rss', 0, '_version', '1.1.8'),
('module', 'search', 0, '_callbacks', ''),
('module', 'search', 0, '_requiredCoreApi', '7,27'),
('module', 'search', 0, '_requiredModuleApi', '3,6'),
('module', 'search', 0, '_templateVersion', '1'),
('module', 'search', 0, '_version', '1.0.8'),
('module', 'shutterfly', 0, '_callbacks', 'getItemLinks'),
('module', 'shutterfly', 0, '_requiredCoreApi', '7,43'),
('module', 'shutterfly', 0, '_requiredModuleApi', '3,9'),
('module', 'shutterfly', 0, '_templateVersion', '1'),
('module', 'shutterfly', 0, '_version', '1.0.14'),
('module', 'sitemap', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'sitemap', 0, '_requiredCoreApi', '7,20'),
('module', 'sitemap', 0, '_requiredModuleApi', '3,6'),
('module', 'sitemap', 0, '_templateVersion', '1'),
('module', 'sitemap', 0, '_version', '1.0.6'),
('module', 'sizelimit', 0, '_callbacks', ''),
('module', 'sizelimit', 0, '_requiredCoreApi', '7,34'),
('module', 'sizelimit', 0, '_requiredModuleApi', '3,6'),
('module', 'sizelimit', 0, '_templateVersion', '1'),
('module', 'sizelimit', 0, '_version', '1.0.9'),
('module', 'slideshow', 0, '_callbacks', 'getItemLinks|getSiteAdminViews'),
('module', 'slideshow', 0, '_requiredCoreApi', '7,49'),
('module', 'slideshow', 0, '_requiredModuleApi', '3,9'),
('module', 'slideshow', 0, '_templateVersion', '1'),
('module', 'slideshow', 0, '_version', '2.0.0'),
('module', 'slideshowapplet', 0, 'slideshowdefaultVariables', 'slideshowRecursive=false|slideshowMaxPictures=0'),
('module', 'slideshowapplet', 0, 'slideshowoverrideVariables', 'toSysOut=true'),
('module', 'slideshowapplet', 0, '_callbacks', 'getItemLinks|getSiteAdminViews'),
('module', 'slideshowapplet', 0, '_requiredCoreApi', '7,27'),
('module', 'slideshowapplet', 0, '_requiredModuleApi', '3,9'),
('module', 'slideshowapplet', 0, '_templateVersion', '1'),
('module', 'slideshowapplet', 0, '_version', '1.0.13'),
('module', 'snapgalaxy', 0, 'snapgalaxyPartnerId', 'default'),
('module', 'snapgalaxy', 0, '_callbacks', 'getSiteAdminViews|getItemLinks'),
('module', 'snapgalaxy', 0, '_requiredCoreApi', '7,43'),
('module', 'snapgalaxy', 0, '_requiredModuleApi', '3,9'),
('module', 'snapgalaxy', 0, '_templateVersion', '1'),
('module', 'snapgalaxy', 0, '_version', '1.0.0'),
('module', 'squarethumb', 0, 'color', '000000'),
('module', 'squarethumb', 0, 'mode', 'crop'),
('module', 'squarethumb', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'squarethumb', 0, '_requiredCoreApi', '7,34'),
('module', 'squarethumb', 0, '_requiredModuleApi', '3,6'),
('module', 'squarethumb', 0, '_templateVersion', '1'),
('module', 'squarethumb', 0, '_version', '1.0.9'),
('module', 'thumbnail', 0, 'id.container', '24'),
('module', 'thumbnail', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'thumbnail', 0, '_requiredCoreApi', '7,45'),
('module', 'thumbnail', 0, '_requiredModuleApi', '3,6'),
('module', 'thumbnail', 0, '_templateVersion', '1'),
('module', 'thumbnail', 0, '_version', '1.0.14'),
('module', 'thumbpage', 0, '_callbacks', ''),
('module', 'thumbpage', 0, '_requiredCoreApi', '7,34'),
('module', 'thumbpage', 0, '_requiredModuleApi', '3,6'),
('module', 'thumbpage', 0, '_templateVersion', '1'),
('module', 'thumbpage', 0, '_version', '1.0.8'),
('module', 'uploadapplet', 0, 'uploaddefaultVariables', ''),
('module', 'uploadapplet', 0, 'uploadoverrideVariables', 'toSysOut=true|htmlEscapeCaptions=true'),
('module', 'uploadapplet', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'uploadapplet', 0, '_requiredCoreApi', '7,20'),
('module', 'uploadapplet', 0, '_requiredModuleApi', '3,6'),
('module', 'uploadapplet', 0, '_templateVersion', '1'),
('module', 'uploadapplet', 0, '_version', '1.0.11'),
('module', 'useralbum', 0, 'create', 'access'),
('module', 'useralbum', 0, 'fullSize', '1'),
('module', 'useralbum', 0, 'homeLink', '0'),
('module', 'useralbum', 0, 'loginRedirect', '0'),
('module', 'useralbum', 0, 'targetLocation', '7'),
('module', 'useralbum', 0, 'view', 'everybody'),
('module', 'useralbum', 0, '_callbacks', 'getSiteAdminViews|getSystemLinks'),
('module', 'useralbum', 0, '_requiredCoreApi', '7,53'),
('module', 'useralbum', 0, '_requiredModuleApi', '3,6'),
('module', 'useralbum', 0, '_templateVersion', '1'),
('module', 'useralbum', 0, '_version', '1.0.11'),
('module', 'watermark', 0, 'allowUserWatermarks', '1'),
('module', 'watermark', 0, 'defaultWatermarkId', ''),
('module', 'watermark', 0, 'forceDefaultWatermark', '0'),
('module', 'watermark', 0, 'hotlinkWatermarkId', ''),
('module', 'watermark', 0, '_callbacks', 'getSiteAdminViews|getUserAdminViews'),
('module', 'watermark', 0, '_requiredCoreApi', '7,45'),
('module', 'watermark', 0, '_requiredModuleApi', '3,6'),
('module', 'watermark', 0, '_templateVersion', '1'),
('module', 'watermark', 0, '_version', '1.1.8'),
('module', 'webcam', 0, 'duration', '600'),
('module', 'webcam', 0, 'fromweb', 'admin'),
('module', 'webcam', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'webcam', 0, '_requiredCoreApi', '7,45'),
('module', 'webcam', 0, '_requiredModuleApi', '3,6'),
('module', 'webcam', 0, '_templateVersion', '1'),
('module', 'webcam', 0, '_version', '1.1.7'),
('module', 'webdav', 0, '_callbacks', 'getItemLinks|getSiteAdminViews'),
('module', 'webdav', 0, '_requiredCoreApi', '7,53'),
('module', 'webdav', 0, '_requiredModuleApi', '3,6'),
('module', 'webdav', 0, '_templateVersion', '1'),
('module', 'webdav', 0, '_version', '1.0.10'),
('module', 'zipcart', 0, 'path', '/usr/bin/zip'),
('module', 'zipcart', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'zipcart', 0, '_requiredCoreApi', '7,30'),
('module', 'zipcart', 0, '_requiredModuleApi', '3,6'),
('module', 'zipcart', 0, '_templateVersion', '1'),
('module', 'zipcart', 0, '_version', '1.0.15'),
('theme', 'matrix', 0, 'albumBlocks', 'a:1:{i:0;a:2:{i:0;s:20:"comment.ViewComments";i:1;a:0:{}}}'),
('theme', 'matrix', 0, 'columns', '3'),
('theme', 'matrix', 0, 'dynamicLinks', 'browse'),
('theme', 'matrix', 0, 'photoBlocks', 'a:2:{i:0;a:2:{i:0;s:13:"exif.ExifInfo";i:1;a:0:{}}i:1;a:2:{i:0;s:20:"comment.ViewComments";i:1;a:0:{}}}'),
('theme', 'matrix', 0, 'rows', '3'),
('theme', 'matrix', 0, 'showAlbumOwner', '1'),
('theme', 'matrix', 0, 'showImageOwner', '0'),
('theme', 'matrix', 0, 'showMicroThumbs', '0'),
('theme', 'matrix', 0, 'sidebarBlocks', 'a:4:{i:0;a:2:{i:0;s:18:"search.SearchBlock";i:1;a:1:{s:16:"showAdvancedLink";b:1;}}i:1;a:2:{i:0;s:14:"core.ItemLinks";i:1;a:1:{s:11:"useDropdown";b:0;}}i:2;a:2:{i:0;s:13:"core.PeerList";i:1;a:0:{}}i:3;a:2:{i:0;s:21:"imageblock.ImageBlock";i:1;a:0:{}}}'),
('theme', 'matrix', 0, '_requiredCoreApi', '7,20'),
('theme', 'matrix', 0, '_requiredThemeApi', '2,4'),
('theme', 'matrix', 0, '_version', '1.1.6');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]QuotasMap`
--

CREATE TABLE `[[dbprefix]]QuotasMap` (
  `g_userOrGroupId` int(11) NOT NULL,
  `g_quotaSize` int(11) NOT NULL,
  PRIMARY KEY (`g_userOrGroupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]RatingCacheMap`
--

CREATE TABLE `[[dbprefix]]RatingCacheMap` (
  `g_itemId` int(11) NOT NULL,
  `g_averageRating` int(11) NOT NULL,
  `g_voteCount` int(11) NOT NULL,
  PRIMARY KEY (`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]RatingMap`
--

CREATE TABLE `[[dbprefix]]RatingMap` (
  `g_ratingId` int(11) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_userId` int(11) NOT NULL,
  `g_rating` int(11) NOT NULL,
  `g_sessionId` varchar(128) DEFAULT NULL,
  `g_remoteIdentifier` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`g_ratingId`),
  KEY `[[dbprefix]]RatingMap_75985` (`g_itemId`),
  KEY `[[dbprefix]]RatingMap_80383` (`g_itemId`,`g_userId`),
  KEY `[[dbprefix]]RatingMap_2369` (`g_itemId`,`g_remoteIdentifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]RecoverPasswordMap`
--

CREATE TABLE `[[dbprefix]]RecoverPasswordMap` (
  `g_userName` varchar(32) NOT NULL,
  `g_authString` varchar(32) NOT NULL,
  `g_requestExpires` int(11) NOT NULL,
  PRIMARY KEY (`g_userName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]RssMap`
--

CREATE TABLE `[[dbprefix]]RssMap` (
  `g_feedName` varchar(128) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_ownerId` int(11) NOT NULL,
  `g_params` text NOT NULL,
  PRIMARY KEY (`g_feedName`),
  KEY `[[dbprefix]]RssMap_75985` (`g_itemId`),
  KEY `[[dbprefix]]RssMap_21573` (`g_ownerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Schema`
--

CREATE TABLE `[[dbprefix]]Schema` (
  `g_name` varchar(128) NOT NULL,
  `g_major` int(11) NOT NULL,
  `g_minor` int(11) NOT NULL,
  `g_createSql` text,
  `g_pluginId` varchar(32) DEFAULT NULL,
  `g_type` varchar(32) DEFAULT NULL,
  `g_info` text,
  PRIMARY KEY (`g_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Schema`
--

INSERT INTO `[[dbprefix]]Schema` VALUES
('AccessMap', 1, 3, 'CREATE TABLE DB_TABLE_PREFIXAccessMap(\n DB_COLUMN_PREFIXaccessListId int(11) NOT NULL,\n DB_COLUMN_PREFIXuserOrGroupId int(11) NOT NULL,\n DB_COLUMN_PREFIXpermission int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId),\n INDEX DB_TABLE_PREFIXAccessMap_83732(DB_COLUMN_PREFIXaccessListId),\n INDEX DB_TABLE_PREFIXAccessMap_48775(DB_COLUMN_PREFIXuserOrGroupId),\n INDEX DB_TABLE_PREFIXAccessMap_18058(DB_COLUMN_PREFIXpermission)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''AccessMap'', 1, 3);\n\n', 'core', 'map', 'a:1:{s:16:"GalleryAccessMap";a:3:{s:12:"accessListId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:13:"userOrGroupId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:10:"permission";a:3:{s:4:"type";i:64;s:4:"size";i:4;s:7:"notNull";b:1;}}}'),
('AccessSubscriberMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXAccessSubscriberMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXaccessListId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXAccessSubscriberMap_83732(DB_COLUMN_PREFIXaccessListId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''AccessSubscriberMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:26:"GalleryAccessSubscriberMap";a:2:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:12:"accessListId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('AlbumItem', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXAlbumItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXtheme varchar(32),\n DB_COLUMN_PREFIXorderBy varchar(128),\n DB_COLUMN_PREFIXorderDirection varchar(32),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''AlbumItem'', 1, 1);\n\n', 'core', 'entity', 'a:1:{s:16:"GalleryAlbumItem";a:4:{s:7:"members";a:3:{s:5:"theme";a:2:{s:4:"type";i:2;s:4:"size";i:1;}s:7:"orderBy";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:14:"orderDirection";a:2:{s:4:"type";i:2;s:4:"size";i:1;}}s:6:"parent";s:11:"GalleryItem";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('AnimationItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXAnimationItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''AnimationItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:20:"GalleryAnimationItem";a:4:{s:7:"members";a:2:{s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}}s:6:"parent";s:15:"GalleryDataItem";s:6:"module";s:4:"core";s:6:"linked";a:2:{i:0;s:5:"width";i:1;s:6:"height";}}}'),
('CacheMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXCacheMap(\n DB_COLUMN_PREFIXkey varchar(32) NOT NULL,\n DB_COLUMN_PREFIXvalue longtext,\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXtype varchar(32) NOT NULL,\n DB_COLUMN_PREFIXtimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXisEmpty int(1),\n PRIMARY KEY(DB_COLUMN_PREFIXkey, DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXtype),\n INDEX DB_TABLE_PREFIXCacheMap_75985(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXCacheMap_21979(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXtimestamp, DB_COLUMN_PREFIXisEmpty)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''CacheMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:15:"GalleryCacheMap";a:7:{s:3:"key";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:5:"value";a:2:{s:4:"type";i:4;s:4:"size";i:4;}s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:4:"type";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:9:"timestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:7:"isEmpty";a:2:{s:4:"type";i:8;s:4:"size";i:2;}}}'),
('ChildEntity', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXChildEntity(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXparentId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXChildEntity_52718(DB_COLUMN_PREFIXparentId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ChildEntity'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:18:"GalleryChildEntity";a:4:{s:7:"members";a:1:{s:8:"parentId";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}}s:6:"parent";s:13:"GalleryEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('Comment', 1, 3, 'CREATE TABLE DB_TABLE_PREFIXComment(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXcommenterId int(11) NOT NULL,\n DB_COLUMN_PREFIXhost varchar(128) NOT NULL,\n DB_COLUMN_PREFIXsubject varchar(128),\n DB_COLUMN_PREFIXcomment text,\n DB_COLUMN_PREFIXdate int(11) NOT NULL,\n DB_COLUMN_PREFIXauthor varchar(128),\n DB_COLUMN_PREFIXpublishStatus int(11) NOT NULL DEFAULT ''0'',\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXComment_95610(DB_COLUMN_PREFIXdate),\n INDEX DB_TABLE_PREFIXComment_70722(DB_COLUMN_PREFIXpublishStatus)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Comment'', 1, 3);\n\n', 'comment', 'entity', 'a:1:{s:14:"GalleryComment";a:4:{s:7:"members";a:7:{s:11:"commenterId";a:3:{s:4:"type";i:1;s:4:"size";i:4;s:7:"notNull";i:1;}s:4:"host";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";i:1;}s:7:"subject";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:3;}s:7:"comment";a:3:{s:4:"type";i:4;s:4:"size";i:1;s:15:"external-access";i:3;}s:4:"date";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:6:"author";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:3;}s:13:"publishStatus";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:3;}}s:6:"parent";s:18:"GalleryChildEntity";s:6:"module";s:7:"comment";s:6:"linked";a:0:{}}}'),
('CustomFieldMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXCustomFieldMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXfield varchar(128) NOT NULL,\n DB_COLUMN_PREFIXvalue varchar(255),\n DB_COLUMN_PREFIXsetId int(11),\n DB_COLUMN_PREFIXsetType int(11),\n INDEX DB_TABLE_PREFIXCustomFieldMap_75985(DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''CustomFieldMap'', 1, 1);\n\n', 'customfield', 'map', 'a:1:{s:14:"CustomFieldMap";a:5:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:5:"field";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:5:"value";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:5:"setId";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:7:"setType";a:2:{s:4:"type";i:1;s:4:"size";i:2;}}}'),
('DataItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXDataItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128),\n DB_COLUMN_PREFIXsize int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''DataItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:15:"GalleryDataItem";a:4:{s:7:"members";a:2:{s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}s:4:"size";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}}s:6:"parent";s:11:"GalleryItem";s:6:"module";s:4:"core";s:6:"linked";a:2:{i:0;s:8:"mimeType";i:1;s:4:"size";}}}'),
('Derivative', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXDerivative(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXderivativeSourceId int(11) NOT NULL,\n DB_COLUMN_PREFIXderivativeOperations varchar(255),\n DB_COLUMN_PREFIXderivativeOrder int(11) NOT NULL,\n DB_COLUMN_PREFIXderivativeSize int(11),\n DB_COLUMN_PREFIXderivativeType int(11) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,\n DB_COLUMN_PREFIXpostFilterOperations varchar(255),\n DB_COLUMN_PREFIXisBroken int(1),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXDerivative_85338(DB_COLUMN_PREFIXderivativeSourceId),\n INDEX DB_TABLE_PREFIXDerivative_25243(DB_COLUMN_PREFIXderivativeOrder),\n INDEX DB_TABLE_PREFIXDerivative_97216(DB_COLUMN_PREFIXderivativeType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Derivative'', 1, 1);\n\n', 'core', 'entity', 'a:1:{s:17:"GalleryDerivative";a:4:{s:7:"members";a:8:{s:18:"derivativeSourceId";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:20:"derivativeOperations";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:15:"derivativeOrder";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}s:14:"derivativeSize";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}s:14:"derivativeType";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}s:8:"mimeType";a:4:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";i:1;s:15:"external-access";i:3;}s:20:"postFilterOperations";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:8:"isBroken";a:1:{s:4:"type";i:8;}}s:6:"parent";s:18:"GalleryChildEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('DerivativeImage', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXDerivativeImage(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''DerivativeImage'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:22:"GalleryDerivativeImage";a:4:{s:7:"members";a:2:{s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}}s:6:"parent";s:17:"GalleryDerivative";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('DerivativePrefsMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXDerivativePrefsMap(\n DB_COLUMN_PREFIXitemId int(11),\n DB_COLUMN_PREFIXorder int(11),\n DB_COLUMN_PREFIXderivativeType int(11),\n DB_COLUMN_PREFIXderivativeOperations varchar(255),\n INDEX DB_TABLE_PREFIXDerivativePrefsMap_75985(DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''DerivativePrefsMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:31:"GalleryDerivativePreferencesMap";a:4:{s:6:"itemId";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:5:"order";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:14:"derivativeType";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:20:"derivativeOperations";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('DescendentCountsMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXDescendentCountsMap(\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXdescendentCount int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''DescendentCountsMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:26:"GalleryDescendentCountsMap";a:3:{s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:15:"descendentCount";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('Entity', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXEntity(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXcreationTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXisLinkable int(1) NOT NULL,\n DB_COLUMN_PREFIXlinkId int(11),\n DB_COLUMN_PREFIXmodificationTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXserialNumber int(11) NOT NULL,\n DB_COLUMN_PREFIXentityType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXonLoadHandlers varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXEntity_76255(DB_COLUMN_PREFIXcreationTimestamp),\n INDEX DB_TABLE_PREFIXEntity_35978(DB_COLUMN_PREFIXisLinkable),\n INDEX DB_TABLE_PREFIXEntity_44738(DB_COLUMN_PREFIXlinkId),\n INDEX DB_TABLE_PREFIXEntity_63025(DB_COLUMN_PREFIXmodificationTimestamp),\n INDEX DB_TABLE_PREFIXEntity_60702(DB_COLUMN_PREFIXserialNumber)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Entity'', 1, 2);\n\n', 'core', 'entity', 'a:1:{s:13:"GalleryEntity";a:4:{s:7:"members";a:8:{s:2:"id";a:3:{s:4:"type";i:33;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:17:"creationTimestamp";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:3;}s:10:"isLinkable";a:2:{s:4:"type";i:8;s:7:"notNull";i:1;}s:6:"linkId";a:1:{s:4:"type";i:1;}s:21:"modificationTimestamp";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:12:"serialNumber";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:10:"entityType";a:4:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:14:"onLoadHandlers";a:2:{s:4:"type";i:2;s:4:"size";i:2;}}s:6:"parent";N;s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('EventLogMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXEventLogMap(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXuserId int(11),\n DB_COLUMN_PREFIXtype varchar(32),\n DB_COLUMN_PREFIXsummary varchar(255),\n DB_COLUMN_PREFIXdetails text,\n DB_COLUMN_PREFIXlocation varchar(255),\n DB_COLUMN_PREFIXclient varchar(128),\n DB_COLUMN_PREFIXtimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXreferer varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXEventLogMap_24286(DB_COLUMN_PREFIXtimestamp)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''EventLogMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:11:"EventLogMap";a:9:{s:2:"id";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"userId";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:4:"type";a:2:{s:4:"type";i:2;s:4:"size";i:1;}s:7:"summary";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:7:"details";a:2:{s:4:"type";i:4;s:4:"size";i:2;}s:8:"location";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:6:"client";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:9:"timestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:7:"referer";a:2:{s:4:"type";i:2;s:4:"size";i:2;}}}'),
('ExifPropertiesMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXExifPropertiesMap(\n DB_COLUMN_PREFIXproperty varchar(128),\n DB_COLUMN_PREFIXviewMode int(11),\n DB_COLUMN_PREFIXsequence int(11),\n UNIQUE (DB_COLUMN_PREFIXproperty, DB_COLUMN_PREFIXviewMode)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ExifPropertiesMap'', 1, 0);\n\n', 'exif', 'map', 'a:1:{s:17:"ExifPropertiesMap";a:3:{s:8:"property";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:8:"viewMode";a:2:{s:4:"type";i:1;s:4:"size";i:4;}s:8:"sequence";a:2:{s:4:"type";i:1;s:4:"size";i:4;}}}'),
('ExternalIdMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXExternalIdMap(\n DB_COLUMN_PREFIXexternalId varchar(128) NOT NULL,\n DB_COLUMN_PREFIXentityType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXentityId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXexternalId, DB_COLUMN_PREFIXentityType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ExternalIdMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:13:"ExternalIdMap";a:3:{s:10:"externalId";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:10:"entityType";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"entityId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('FactoryMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXFactoryMap(\n DB_COLUMN_PREFIXclassType varchar(128),\n DB_COLUMN_PREFIXclassName varchar(128),\n DB_COLUMN_PREFIXimplId varchar(128),\n DB_COLUMN_PREFIXimplPath varchar(128),\n DB_COLUMN_PREFIXimplModuleId varchar(128),\n DB_COLUMN_PREFIXhints varchar(255),\n DB_COLUMN_PREFIXorderWeight varchar(255)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''FactoryMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:17:"GalleryFactoryMap";a:7:{s:9:"classType";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:9:"className";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:6:"implId";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:8:"implPath";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:12:"implModuleId";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:5:"hints";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:11:"orderWeight";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('FailedLoginsMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXFailedLoginsMap(\n DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXcount int(11) NOT NULL,\n DB_COLUMN_PREFIXlastAttempt int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXuserName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''FailedLoginsMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:15:"FailedLoginsMap";a:3:{s:8:"userName";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:5:"count";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"lastAttempt";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('FileSystemEntity', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXFileSystemEntity(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXpathComponent varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXFileSystemEntity_3406(DB_COLUMN_PREFIXpathComponent)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''FileSystemEntity'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:23:"GalleryFileSystemEntity";a:4:{s:7:"members";a:1:{s:13:"pathComponent";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}}s:6:"parent";s:18:"GalleryChildEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('G1MigrateMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXG1MigrateMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXg1album varchar(128) NOT NULL,\n DB_COLUMN_PREFIXg1item varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXG1MigrateMap_41836(DB_COLUMN_PREFIXg1album, DB_COLUMN_PREFIXg1item)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''G1MigrateMap'', 1, 1);\n\n', 'migrate', 'map', 'a:1:{s:12:"G1MigrateMap";a:3:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:7:"g1album";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"g1item";a:2:{s:4:"type";i:2;s:4:"size";i:2;}}}'),
('Getid3PropsMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXGetid3PropsMap(\n DB_COLUMN_PREFIXproperty varchar(128),\n DB_COLUMN_PREFIXviewMode int(11),\n DB_COLUMN_PREFIXsequence int(11),\n UNIQUE (DB_COLUMN_PREFIXproperty, DB_COLUMN_PREFIXviewMode)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Getid3PropsMap'', 1, 0);\n\n', 'getid3', 'map', 'a:1:{s:14:"Getid3PropsMap";a:3:{s:8:"property";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:8:"viewMode";a:2:{s:4:"type";i:1;s:4:"size";i:4;}s:8:"sequence";a:2:{s:4:"type";i:1;s:4:"size";i:4;}}}'),
('Group', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXGroup(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXgroupType int(11) NOT NULL,\n DB_COLUMN_PREFIXgroupName varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n UNIQUE (DB_COLUMN_PREFIXgroupName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Group'', 1, 1);\n\n', 'core', 'entity', 'a:1:{s:12:"GalleryGroup";a:4:{s:7:"members";a:2:{s:9:"groupType";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}s:9:"groupName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}}s:6:"parent";s:13:"GalleryEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('ImageBlockCacheMap', 1, 3, 'CREATE TABLE DB_TABLE_PREFIXImageBlockCacheMap(\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXitemType int(11) NOT NULL,\n DB_COLUMN_PREFIXitemTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXrandom int(11),\n INDEX DB_TABLE_PREFIXImageBlockCacheMap_48758(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemType, DB_COLUMN_PREFIXrandom)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ImageBlockCacheMap'', 1, 3);\n\n', 'imageblock', 'map', 'a:1:{s:18:"ImageBlockCacheMap";a:5:{s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"itemType";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:13:"itemTimestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"random";a:2:{s:4:"type";i:1;s:4:"size";i:2;}}}'),
('ImageBlockDisabledMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXImageBlockDisabledMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ImageBlockDisabledMap'', 1, 0);\n\n', 'imageblock', 'map', 'a:1:{s:21:"ImageBlockDisabledMap";a:1:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('Item', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXcanContainChildren int(1) NOT NULL,\n DB_COLUMN_PREFIXdescription text,\n DB_COLUMN_PREFIXkeywords varchar(255),\n DB_COLUMN_PREFIXownerId int(11) NOT NULL,\n DB_COLUMN_PREFIXrenderer varchar(128),\n DB_COLUMN_PREFIXsummary varchar(255),\n DB_COLUMN_PREFIXtitle varchar(128),\n DB_COLUMN_PREFIXviewedSinceTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXoriginationTimestamp int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXItem_99070(DB_COLUMN_PREFIXkeywords),\n INDEX DB_TABLE_PREFIXItem_21573(DB_COLUMN_PREFIXownerId),\n INDEX DB_TABLE_PREFIXItem_54147(DB_COLUMN_PREFIXsummary),\n INDEX DB_TABLE_PREFIXItem_90059(DB_COLUMN_PREFIXtitle)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Item'', 1, 2);\n\n', 'core', 'entity', 'a:1:{s:11:"GalleryItem";a:4:{s:7:"members";a:9:{s:18:"canContainChildren";a:3:{s:4:"type";i:8;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:11:"description";a:3:{s:4:"type";i:4;s:4:"size";i:1;s:15:"external-access";i:3;}s:8:"keywords";a:3:{s:4:"type";i:2;s:4:"size";i:4;s:15:"external-access";i:3;}s:7:"ownerId";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}s:8:"renderer";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:7:"summary";a:3:{s:4:"type";i:2;s:4:"size";i:4;s:15:"external-access";i:3;}s:5:"title";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:3;}s:20:"viewedSinceTimestamp";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:20:"originationTimestamp";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:3;}}s:6:"parent";s:23:"GalleryFileSystemEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('ItemAttributesMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXItemAttributesMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXviewCount int(11),\n DB_COLUMN_PREFIXorderWeight int(11),\n DB_COLUMN_PREFIXparentSequence varchar(255) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXItemAttributesMap_95270(DB_COLUMN_PREFIXparentSequence)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ItemAttributesMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:24:"GalleryItemAttributesMap";a:4:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"viewCount";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:11:"orderWeight";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:14:"parentSequence";a:3:{s:4:"type";i:2;s:4:"size";i:4;s:19:"notNullEmptyAllowed";b:1;}}}'),
('ItemHiddenMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXItemHiddenMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ItemHiddenMap'', 1, 0);\n\n', 'hidden', 'map', 'a:1:{s:13:"ItemHiddenMap";a:1:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('LinkItem', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXLinkItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXlink text NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''LinkItem'', 1, 1);\n\n', 'linkitem', 'entity', 'a:1:{s:15:"GalleryLinkItem";a:4:{s:7:"members";a:1:{s:4:"link";a:4:{s:4:"type";i:4;s:4:"size";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}}s:6:"parent";s:11:"GalleryItem";s:6:"module";s:8:"linkitem";s:6:"linked";a:0:{}}}'),
('Lock', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXLock(\n DB_COLUMN_PREFIXlockId int(11),\n DB_COLUMN_PREFIXreadEntityId int(11),\n DB_COLUMN_PREFIXwriteEntityId int(11),\n DB_COLUMN_PREFIXfreshUntil int(11),\n DB_COLUMN_PREFIXrequest int(11),\n INDEX DB_TABLE_PREFIXLock_11039(DB_COLUMN_PREFIXlockId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Lock'', 1, 0);\n\n', 'core', NULL, NULL),
('MaintenanceMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXMaintenanceMap(\n DB_COLUMN_PREFIXrunId int(11) NOT NULL,\n DB_COLUMN_PREFIXtaskId varchar(128) NOT NULL,\n DB_COLUMN_PREFIXtimestamp int(11),\n DB_COLUMN_PREFIXsuccess int(1),\n DB_COLUMN_PREFIXdetails text,\n PRIMARY KEY(DB_COLUMN_PREFIXrunId),\n INDEX DB_TABLE_PREFIXMaintenanceMap_21687(DB_COLUMN_PREFIXtaskId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''MaintenanceMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:21:"GalleryMaintenanceMap";a:5:{s:5:"runId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"taskId";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"timestamp";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:7:"success";a:2:{s:4:"type";i:8;s:4:"size";i:2;}s:7:"details";a:2:{s:4:"type";i:4;s:4:"size";i:1;}}}'),
('MimeTypeMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXMimeTypeMap(\n DB_COLUMN_PREFIXextension varchar(32) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,\n DB_COLUMN_PREFIXviewable int(1),\n PRIMARY KEY(DB_COLUMN_PREFIXextension)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''MimeTypeMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:18:"GalleryMimeTypeMap";a:3:{s:9:"extension";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"viewable";a:2:{s:4:"type";i:8;s:4:"size";i:2;}}}'),
('MovieItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXMovieItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n DB_COLUMN_PREFIXduration int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''MovieItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:16:"GalleryMovieItem";a:4:{s:7:"members";a:3:{s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:8:"duration";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}}s:6:"parent";s:15:"GalleryDataItem";s:6:"module";s:4:"core";s:6:"linked";a:3:{i:0;s:5:"width";i:1;s:6:"height";i:2;s:8:"duration";}}}'),
('MultiLangItemMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXMultiLangItemMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXlanguage varchar(32) NOT NULL,\n DB_COLUMN_PREFIXtitle varchar(128),\n DB_COLUMN_PREFIXsummary varchar(255),\n DB_COLUMN_PREFIXdescription text,\n PRIMARY KEY(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXlanguage)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''MultiLangItemMap'', 1, 0);\n\n', 'multilang', 'map', 'a:1:{s:16:"MultiLangItemMap";a:5:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"language";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:5:"title";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:7:"summary";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:11:"description";a:2:{s:4:"type";i:4;s:4:"size";i:1;}}}'),
('PendingUser', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXPendingUser(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXfullName varchar(128),\n DB_COLUMN_PREFIXhashedPassword varchar(128),\n DB_COLUMN_PREFIXemail varchar(128),\n DB_COLUMN_PREFIXlanguage varchar(128),\n DB_COLUMN_PREFIXregistrationKey varchar(32),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n UNIQUE (DB_COLUMN_PREFIXuserName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PendingUser'', 1, 0);\n\n', 'register', 'entity', 'a:1:{s:18:"GalleryPendingUser";a:4:{s:7:"members";a:6:{s:8:"userName";a:4:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:8:"fullName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:3;}s:14:"hashedPassword";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:5:"email";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:8:"language";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:15:"registrationKey";a:2:{s:4:"type";i:2;s:4:"size";i:1;}}s:6:"parent";s:13:"GalleryEntity";s:6:"module";s:8:"register";s:6:"linked";a:0:{}}}'),
('PermalinksMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXPermalinksMap(\n DB_COLUMN_PREFIXaliasName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXdestId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXaliasName),\n INDEX DB_TABLE_PREFIXPermalinksMap_84225(DB_COLUMN_PREFIXdestId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PermalinksMap'', 1, 0);\n\n', 'permalinks', 'map', 'a:1:{s:13:"PermalinksMap";a:2:{s:9:"aliasName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"destId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('PermissionSetMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXPermissionSetMap(\n DB_COLUMN_PREFIXmodule varchar(128) NOT NULL,\n DB_COLUMN_PREFIXpermission varchar(128) NOT NULL,\n DB_COLUMN_PREFIXdescription varchar(255),\n DB_COLUMN_PREFIXbits int(11) NOT NULL,\n DB_COLUMN_PREFIXflags int(11) NOT NULL,\n UNIQUE (DB_COLUMN_PREFIXpermission)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PermissionSetMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:23:"GalleryPermissionSetMap";a:5:{s:6:"module";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:10:"permission";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"description";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:4:"bits";a:3:{s:4:"type";i:64;s:4:"size";i:2;s:7:"notNull";b:1;}s:5:"flags";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('PhotoItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXPhotoItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PhotoItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:16:"GalleryPhotoItem";a:4:{s:7:"members";a:2:{s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}}s:6:"parent";s:15:"GalleryDataItem";s:6:"module";s:4:"core";s:6:"linked";a:2:{i:0;s:5:"width";i:1;s:6:"height";}}}'),
('PluginMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXPluginMap(\n DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,\n DB_COLUMN_PREFIXactive int(1) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PluginMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:16:"GalleryPluginMap";a:3:{s:10:"pluginType";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"pluginId";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:6:"active";a:3:{s:4:"type";i:8;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('PluginPackageMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXPluginPackageMap(\n DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpackageName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpackageVersion varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpackageBuild varchar(32) NOT NULL,\n DB_COLUMN_PREFIXlocked int(1) NOT NULL,\n INDEX DB_TABLE_PREFIXPluginPackageMap_80596(DB_COLUMN_PREFIXpluginType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PluginPackageMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:23:"GalleryPluginPackageMap";a:6:{s:10:"pluginType";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"pluginId";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:11:"packageName";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:14:"packageVersion";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:12:"packageBuild";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:6:"locked";a:3:{s:4:"type";i:8;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('PluginParameterMap', 1, 3, 'CREATE TABLE DB_TABLE_PREFIXPluginParameterMap(\n DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXparameterName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXparameterValue text NOT NULL,\n UNIQUE (DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXparameterName),\n INDEX DB_TABLE_PREFIXPluginParameterMap_80596(DB_COLUMN_PREFIXpluginType),\n INDEX DB_TABLE_PREFIXPluginParameterMap_12808(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PluginParameterMap'', 1, 3);\n\n', 'core', 'map', 'a:1:{s:25:"GalleryPluginParameterMap";a:5:{s:10:"pluginType";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"pluginId";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:13:"parameterName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:14:"parameterValue";a:3:{s:4:"type";i:4;s:4:"size";i:1;s:19:"notNullEmptyAllowed";b:1;}}}'),
('QuotasMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXQuotasMap(\n DB_COLUMN_PREFIXuserOrGroupId int(11) NOT NULL,\n DB_COLUMN_PREFIXquotaSize int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXuserOrGroupId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''QuotasMap'', 1, 1);\n\n', 'quotas', 'map', 'a:1:{s:9:"QuotasMap";a:2:{s:13:"userOrGroupId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"quotaSize";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('RatingCacheMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXRatingCacheMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXaverageRating int(11) NOT NULL,\n DB_COLUMN_PREFIXvoteCount int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''RatingCacheMap'', 1, 0);\n\n', 'rating', 'map', 'a:1:{s:14:"RatingCacheMap";a:3:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:13:"averageRating";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"voteCount";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('RatingMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXRatingMap(\n DB_COLUMN_PREFIXratingId int(11) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXrating int(11) NOT NULL,\n DB_COLUMN_PREFIXsessionId varchar(128),\n DB_COLUMN_PREFIXremoteIdentifier varchar(255),\n PRIMARY KEY(DB_COLUMN_PREFIXratingId),\n INDEX DB_TABLE_PREFIXRatingMap_75985(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXRatingMap_80383(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXuserId),\n INDEX DB_TABLE_PREFIXRatingMap_2369(DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXremoteIdentifier)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''RatingMap'', 1, 0);\n\n', 'rating', 'map', 'a:1:{s:9:"RatingMap";a:6:{s:8:"ratingId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"rating";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"sessionId";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:16:"remoteIdentifier";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('RecoverPasswordMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXRecoverPasswordMap(\n DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXauthString varchar(32) NOT NULL,\n DB_COLUMN_PREFIXrequestExpires int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXuserName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''RecoverPasswordMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:25:"GalleryRecoverPasswordMap";a:3:{s:8:"userName";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:10:"authString";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:14:"requestExpires";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('RssMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXRssMap(\n DB_COLUMN_PREFIXfeedName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXownerId int(11) NOT NULL,\n DB_COLUMN_PREFIXparams text NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXfeedName),\n INDEX DB_TABLE_PREFIXRssMap_75985(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXRssMap_21573(DB_COLUMN_PREFIXownerId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''RssMap'', 1, 0);\n\n', 'rss', 'map', 'a:1:{s:6:"RssMap";a:4:{s:8:"feedName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:7:"ownerId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"params";a:3:{s:4:"type";i:4;s:4:"size";i:1;s:7:"notNull";b:1;}}}'),
('Schema', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXSchema(\n DB_COLUMN_PREFIXname varchar(128) NOT NULL,\n DB_COLUMN_PREFIXmajor int(11) NOT NULL,\n DB_COLUMN_PREFIXminor int(11) NOT NULL,\n DB_COLUMN_PREFIXcreateSql text,\n DB_COLUMN_PREFIXpluginId varchar(32),\n DB_COLUMN_PREFIXtype varchar(32),\n DB_COLUMN_PREFIXinfo text,\n PRIMARY KEY(DB_COLUMN_PREFIXname)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Schema'', 1, 2);\n\n', 'core', NULL, NULL),
('SessionMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXSessionMap(\n DB_COLUMN_PREFIXid varchar(32) NOT NULL,\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXremoteIdentifier varchar(128) NOT NULL,\n DB_COLUMN_PREFIXcreationTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXmodificationTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXdata longtext,\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXSessionMap_53500(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXcreationTimestamp, DB_COLUMN_PREFIXmodificationTimestamp)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''SessionMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:17:"GallerySessionMap";a:6:{s:2:"id";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:16:"remoteIdentifier";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:17:"creationTimestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:21:"modificationTimestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:4:"data";a:2:{s:4:"type";i:4;s:4:"size";i:4;}}}'),
('SubscriptionMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXSubscriptionMap(\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXnotificationName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXhandlerName varchar(128) NOT NULL,\n INDEX DB_TABLE_PREFIXSubscriptionMap_25141(DB_COLUMN_PREFIXnotificationName),\n INDEX DB_TABLE_PREFIXSubscriptionMap_76924(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''SubscriptionMap'', 1, 0);\n\n', 'notification', 'map', 'a:1:{s:15:"SubscriptionMap";a:4:{s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:16:"notificationName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"handlerName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('ThumbnailImage', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXThumbnailImage(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128),\n DB_COLUMN_PREFIXsize int(11),\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n DB_COLUMN_PREFIXitemMimeTypes varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ThumbnailImage'', 1, 2);\n\n', 'thumbnail', 'entity', 'a:1:{s:14:"ThumbnailImage";a:4:{s:7:"members";a:5:{s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}s:4:"size";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:13:"itemMimeTypes";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}}s:6:"parent";s:23:"GalleryFileSystemEntity";s:6:"module";s:9:"thumbnail";s:6:"linked";a:0:{}}}'),
('TkOperatnMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkOperatnMap(\n DB_COLUMN_PREFIXname varchar(128) NOT NULL,\n DB_COLUMN_PREFIXparametersCrc varchar(32) NOT NULL,\n DB_COLUMN_PREFIXoutputMimeType varchar(128),\n DB_COLUMN_PREFIXdescription varchar(255),\n PRIMARY KEY(DB_COLUMN_PREFIXname)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkOperatnMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:26:"GalleryToolkitOperationMap";a:4:{s:4:"name";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:13:"parametersCrc";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:14:"outputMimeType";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:11:"description";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('TkOperatnMimeTypeMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkOperatnMimeTypeMap(\n DB_COLUMN_PREFIXoperationName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXtoolkitId varchar(128) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,\n DB_COLUMN_PREFIXpriority int(11) NOT NULL,\n INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_2014(DB_COLUMN_PREFIXoperationName),\n INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_79463(DB_COLUMN_PREFIXmimeType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkOperatnMimeTypeMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:34:"GalleryToolkitOperationMimeTypeMap";a:4:{s:13:"operationName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"toolkitId";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"priority";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('TkOperatnParameterMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkOperatnParameterMap(\n DB_COLUMN_PREFIXoperationName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXposition int(11) NOT NULL,\n DB_COLUMN_PREFIXtype varchar(128) NOT NULL,\n DB_COLUMN_PREFIXdescription varchar(255),\n INDEX DB_TABLE_PREFIXTkOperatnParameterMap_2014(DB_COLUMN_PREFIXoperationName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkOperatnParameterMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:35:"GalleryToolkitOperationParameterMap";a:4:{s:13:"operationName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"position";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:4:"type";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"description";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('TkPropertyMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkPropertyMap(\n DB_COLUMN_PREFIXname varchar(128) NOT NULL,\n DB_COLUMN_PREFIXtype varchar(128) NOT NULL,\n DB_COLUMN_PREFIXdescription varchar(128) NOT NULL\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkPropertyMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:25:"GalleryToolkitPropertyMap";a:3:{s:4:"name";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:4:"type";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"description";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('TkPropertyMimeTypeMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkPropertyMimeTypeMap(\n DB_COLUMN_PREFIXpropertyName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXtoolkitId varchar(128) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,\n INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_52881(DB_COLUMN_PREFIXpropertyName),\n INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_79463(DB_COLUMN_PREFIXmimeType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkPropertyMimeTypeMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:33:"GalleryToolkitPropertyMimeTypeMap";a:3:{s:12:"propertyName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"toolkitId";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}}}');
INSERT INTO `[[dbprefix]]Schema` VALUES
('UnknownItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXUnknownItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''UnknownItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:18:"GalleryUnknownItem";a:4:{s:7:"members";a:0:{}s:6:"parent";s:15:"GalleryDataItem";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('User', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXUser(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXfullName varchar(128),\n DB_COLUMN_PREFIXhashedPassword varchar(128),\n DB_COLUMN_PREFIXemail varchar(255),\n DB_COLUMN_PREFIXlanguage varchar(128),\n DB_COLUMN_PREFIXlocked int(1) DEFAULT ''0'',\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n UNIQUE (DB_COLUMN_PREFIXuserName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''User'', 1, 2);\n\n', 'core', 'entity', 'a:1:{s:11:"GalleryUser";a:4:{s:7:"members";a:6:{s:8:"userName";a:4:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:8:"fullName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:3;}s:14:"hashedPassword";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:5:"email";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:8:"language";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}s:6:"locked";a:1:{s:4:"type";i:8;}}s:6:"parent";s:13:"GalleryEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('UserGroupMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXUserGroupMap(\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXgroupId int(11) NOT NULL,\n INDEX DB_TABLE_PREFIXUserGroupMap_69068(DB_COLUMN_PREFIXuserId),\n INDEX DB_TABLE_PREFIXUserGroupMap_89328(DB_COLUMN_PREFIXgroupId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''UserGroupMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:19:"GalleryUserGroupMap";a:2:{s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:7:"groupId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('WatermarkImage', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXWatermarkImage(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXapplyToPreferred int(1),\n DB_COLUMN_PREFIXapplyToResizes int(1),\n DB_COLUMN_PREFIXapplyToThumbnail int(1),\n DB_COLUMN_PREFIXname varchar(128) NOT NULL,\n DB_COLUMN_PREFIXfileName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128),\n DB_COLUMN_PREFIXsize int(11),\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n DB_COLUMN_PREFIXownerId int(11),\n DB_COLUMN_PREFIXxPercentage varchar(32),\n DB_COLUMN_PREFIXyPercentage varchar(32),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n UNIQUE (DB_COLUMN_PREFIXfileName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''WatermarkImage'', 1, 1);\n\n', 'watermark', 'entity', 'a:1:{s:14:"WatermarkImage";a:4:{s:7:"members";a:12:{s:16:"applyToPreferred";a:2:{s:4:"type";i:8;s:15:"external-access";i:1;}s:14:"applyToResizes";a:2:{s:4:"type";i:8;s:15:"external-access";i:1;}s:16:"applyToThumbnail";a:1:{s:4:"type";i:8;}s:4:"name";a:4:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:8:"fileName";a:4:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}s:4:"size";a:1:{s:4:"type";i:1;}s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}s:7:"ownerId";a:1:{s:4:"type";i:1;}s:11:"xPercentage";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:15:"external-access";i:1;}s:11:"yPercentage";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:15:"external-access";i:1;}}s:6:"parent";s:13:"GalleryEntity";s:6:"module";s:9:"watermark";s:6:"linked";a:0:{}}}'),
('WebDavLockMap', 0, 1, 'CREATE TABLE DB_TABLE_PREFIXWebDavLockMap(\n DB_COLUMN_PREFIXdepth varchar(128),\n DB_COLUMN_PREFIXowner varchar(128),\n DB_COLUMN_PREFIXexpires int(11),\n DB_COLUMN_PREFIXtoken varchar(128),\n DB_COLUMN_PREFIXpath varchar(128),\n DB_COLUMN_PREFIXgalleryLockId int(11)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''WebDavLockMap'', 0, 1);\n\n', 'webdav', 'map', 'a:1:{s:13:"WebDavLockMap";a:6:{s:5:"depth";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:5:"owner";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:7:"expires";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:5:"token";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:4:"path";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:13:"galleryLockId";a:2:{s:4:"type";i:1;s:4:"size";i:2;}}}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SequenceEventLog`
--

CREATE TABLE `[[dbprefix]]SequenceEventLog` (
  `id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]SequenceEventLog`
--

INSERT INTO `[[dbprefix]]SequenceEventLog` VALUES
(1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SequenceId`
--

CREATE TABLE `[[dbprefix]]SequenceId` (
  `id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]SequenceId`
--

INSERT INTO `[[dbprefix]]SequenceId` VALUES
(28);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SequenceLock`
--

CREATE TABLE `[[dbprefix]]SequenceLock` (
  `id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]SequenceLock`
--

INSERT INTO `[[dbprefix]]SequenceLock` VALUES
(0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SessionMap`
--

CREATE TABLE `[[dbprefix]]SessionMap` (
  `g_id` varchar(32) NOT NULL,
  `g_userId` int(11) NOT NULL,
  `g_remoteIdentifier` varchar(128) NOT NULL,
  `g_creationTimestamp` int(11) NOT NULL,
  `g_modificationTimestamp` int(11) NOT NULL,
  `g_data` longtext,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]SessionMap_53500` (`g_userId`,`g_creationTimestamp`,`g_modificationTimestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SubscriptionMap`
--

CREATE TABLE `[[dbprefix]]SubscriptionMap` (
  `g_userId` int(11) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_notificationName` varchar(128) NOT NULL,
  `g_handlerName` varchar(128) NOT NULL,
  KEY `[[dbprefix]]SubscriptionMap_25141` (`g_notificationName`),
  KEY `[[dbprefix]]SubscriptionMap_76924` (`g_userId`,`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ThumbnailImage`
--

CREATE TABLE `[[dbprefix]]ThumbnailImage` (
  `g_id` int(11) NOT NULL,
  `g_mimeType` varchar(128) DEFAULT NULL,
  `g_size` int(11) DEFAULT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  `g_itemMimeTypes` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]ThumbnailImage`
--

INSERT INTO `[[dbprefix]]ThumbnailImage` VALUES
(25, 'image/jpeg', 15472, 400, 352, 'audio/mpeg|audio/x-wav|audio/x-aiff|audio/midi|audio/basic|audio/x-ms-wma'),
(27, 'image/jpeg', 15777, 400, 352, 'video/mpeg|video/quicktime|video/x-msvideo|video/x-ms-asf|video/x-ms-wmv|video/x-flv');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkOperatnMap`
--

CREATE TABLE `[[dbprefix]]TkOperatnMap` (
  `g_name` varchar(128) NOT NULL,
  `g_parametersCrc` varchar(32) NOT NULL,
  `g_outputMimeType` varchar(128) DEFAULT NULL,
  `g_description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`g_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkOperatnMap`
--

INSERT INTO `[[dbprefix]]TkOperatnMap` VALUES
('composite', '1204337430', NULL, 'Overlay source image with a second one'),
('compress', '340908721', NULL, 'Reduce image quality to reach target file size'),
('convert-to-image/jpeg', '0', 'image/jpeg', 'Get image for linkitem thumbnail'),
('crop', '729751051', NULL, 'Crop the image'),
('extract', '0', '', 'extract files from an archive'),
('resize', '3155881288', NULL, 'Resize the image to the target dimensions'),
('rotate', '340908721', NULL, 'Rotate the image'),
('scale', '3155881288', NULL, 'Scale the image to the target size, maintain aspect ratio'),
('thumbnail', '3155881288', NULL, 'Scale the image to the target size, maintain aspect ratio');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkOperatnMimeTypeMap`
--

CREATE TABLE `[[dbprefix]]TkOperatnMimeTypeMap` (
  `g_operationName` varchar(128) NOT NULL,
  `g_toolkitId` varchar(128) NOT NULL,
  `g_mimeType` varchar(128) NOT NULL,
  `g_priority` int(11) NOT NULL,
  KEY `[[dbprefix]]TkOperatnMimeTypeMap_2014` (`g_operationName`),
  KEY `[[dbprefix]]TkOperatnMimeTypeMap_79463` (`g_mimeType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkOperatnMimeTypeMap`
--

INSERT INTO `[[dbprefix]]TkOperatnMimeTypeMap` VALUES
('extract', 'ArchiveUpload', 'application/zip', 5),
('convert-to-image/jpeg', 'LinkItemToolkit', 'gallery/linkitem', 5),
('thumbnail', 'Thumbnail', 'audio/mpeg', 50),
('thumbnail', 'Thumbnail', 'audio/x-wav', 50),
('thumbnail', 'Thumbnail', 'audio/x-aiff', 50),
('thumbnail', 'Thumbnail', 'audio/midi', 50),
('thumbnail', 'Thumbnail', 'audio/basic', 50),
('thumbnail', 'Thumbnail', 'audio/x-ms-wma', 50),
('thumbnail', 'Thumbnail', 'video/mpeg', 50),
('thumbnail', 'Thumbnail', 'video/quicktime', 50),
('thumbnail', 'Thumbnail', 'video/x-msvideo', 50),
('thumbnail', 'Thumbnail', 'video/x-ms-asf', 50),
('thumbnail', 'Thumbnail', 'video/x-ms-wmv', 50),
('thumbnail', 'Thumbnail', 'video/x-flv', 50),
('convert-to-image/jpeg', 'Gd', 'image/gif', 21),
('convert-to-image/jpeg', 'Gd', 'image/jpeg', 21),
('convert-to-image/jpeg', 'Gd', 'image/png', 21),
('convert-to-image/jpeg', 'Gd', 'image/vnd.wap.wbmp', 21),
('convert-to-image/jpeg', 'Gd', 'image/x-xbitmap', 21),
('scale', 'Gd', 'image/gif', 21),
('scale', 'Gd', 'image/jpeg', 21),
('scale', 'Gd', 'image/png', 21),
('scale', 'Gd', 'image/vnd.wap.wbmp', 21),
('scale', 'Gd', 'image/x-xbitmap', 21),
('thumbnail', 'Gd', 'image/gif', 21),
('thumbnail', 'Gd', 'image/jpeg', 21),
('thumbnail', 'Gd', 'image/png', 21),
('thumbnail', 'Gd', 'image/vnd.wap.wbmp', 21),
('thumbnail', 'Gd', 'image/x-xbitmap', 21),
('resize', 'Gd', 'image/gif', 21),
('resize', 'Gd', 'image/jpeg', 21),
('resize', 'Gd', 'image/png', 21),
('resize', 'Gd', 'image/vnd.wap.wbmp', 21),
('resize', 'Gd', 'image/x-xbitmap', 21),
('rotate', 'Gd', 'image/gif', 21),
('rotate', 'Gd', 'image/jpeg', 21),
('rotate', 'Gd', 'image/png', 21),
('rotate', 'Gd', 'image/vnd.wap.wbmp', 21),
('rotate', 'Gd', 'image/x-xbitmap', 21),
('crop', 'Gd', 'image/gif', 21),
('crop', 'Gd', 'image/jpeg', 21),
('crop', 'Gd', 'image/png', 21),
('crop', 'Gd', 'image/vnd.wap.wbmp', 21),
('crop', 'Gd', 'image/x-xbitmap', 21),
('composite', 'Gd', 'image/gif', 21),
('composite', 'Gd', 'image/jpeg', 21),
('composite', 'Gd', 'image/png', 21),
('composite', 'Gd', 'image/vnd.wap.wbmp', 21),
('composite', 'Gd', 'image/x-xbitmap', 21),
('compress', 'Gd', 'image/jpeg', 21);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkOperatnParameterMap`
--

CREATE TABLE `[[dbprefix]]TkOperatnParameterMap` (
  `g_operationName` varchar(128) NOT NULL,
  `g_position` int(11) NOT NULL,
  `g_type` varchar(128) NOT NULL,
  `g_description` varchar(255) DEFAULT NULL,
  KEY `[[dbprefix]]TkOperatnParameterMap_2014` (`g_operationName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkOperatnParameterMap`
--

INSERT INTO `[[dbprefix]]TkOperatnParameterMap` VALUES
('thumbnail', 0, 'int', 'target width (# pixels or #% of full size)'),
('thumbnail', 1, 'int', '(optional) target height, defaults to same as width'),
('scale', 0, 'int', 'target width (# pixels or #% of full size)'),
('scale', 1, 'int', '(optional) target height, defaults to same as width'),
('resize', 0, 'int', 'target width (# pixels or #% of full size)'),
('resize', 1, 'int', 'target height (# pixels or #% of full size)'),
('rotate', 0, 'int', 'rotation degrees'),
('crop', 0, 'float', 'left edge %'),
('crop', 1, 'float', 'top edge %'),
('crop', 2, 'float', 'width %'),
('crop', 3, 'float', 'height %'),
('composite', 0, 'string', 'overlay path'),
('composite', 1, 'string', 'overlay mime type'),
('composite', 2, 'int', 'overlay width'),
('composite', 3, 'int', 'overlay height'),
('composite', 4, 'string', 'alignment type'),
('composite', 5, 'int', 'alignment x %'),
('composite', 6, 'int', 'alignment y %'),
('compress', 0, 'int', 'target size in kb');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkPropertyMap`
--

CREATE TABLE `[[dbprefix]]TkPropertyMap` (
  `g_name` varchar(128) NOT NULL,
  `g_type` varchar(128) NOT NULL,
  `g_description` varchar(128) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkPropertyMap`
--

INSERT INTO `[[dbprefix]]TkPropertyMap` VALUES
('originationTimestamp', 'int', 'Get the origination timestamp'),
('dimensions', 'int,int', 'Get the width and height of the image');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkPropertyMimeTypeMap`
--

CREATE TABLE `[[dbprefix]]TkPropertyMimeTypeMap` (
  `g_propertyName` varchar(128) NOT NULL,
  `g_toolkitId` varchar(128) NOT NULL,
  `g_mimeType` varchar(128) NOT NULL,
  KEY `[[dbprefix]]TkPropertyMimeTypeMap_52881` (`g_propertyName`),
  KEY `[[dbprefix]]TkPropertyMimeTypeMap_79463` (`g_mimeType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkPropertyMimeTypeMap`
--

INSERT INTO `[[dbprefix]]TkPropertyMimeTypeMap` VALUES
('originationTimestamp', 'Exif', 'image/jpeg'),
('originationTimestamp', 'Exif', 'image/pjpeg'),
('originationTimestamp', 'Exif', 'image/jpeg-cmyk'),
('originationTimestamp', 'Exif', 'image/pjpeg-cmyk'),
('originationTimestamp', 'Exif', 'image/x-dcraw'),
('originationTimestamp', 'Getid3', 'video/x-msvideo'),
('dimensions', 'Gd', 'image/gif'),
('dimensions', 'Gd', 'image/jpeg'),
('dimensions', 'Gd', 'image/png'),
('dimensions', 'Gd', 'image/vnd.wap.wbmp'),
('dimensions', 'Gd', 'image/x-xbitmap'),
('dimensions', 'Gd', 'application/x-shockwave-flash');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]UnknownItem`
--

CREATE TABLE `[[dbprefix]]UnknownItem` (
  `g_id` int(11) NOT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]User`
--

CREATE TABLE `[[dbprefix]]User` (
  `g_id` int(11) NOT NULL,
  `g_userName` varchar(32) NOT NULL,
  `g_fullName` varchar(128) DEFAULT NULL,
  `g_hashedPassword` varchar(128) DEFAULT NULL,
  `g_email` varchar(255) DEFAULT NULL,
  `g_language` varchar(128) DEFAULT NULL,
  `g_locked` int(1) DEFAULT '0',
  PRIMARY KEY (`g_id`),
  UNIQUE KEY `g_userName` (`g_userName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]User`
--

INSERT INTO `[[dbprefix]]User` VALUES
(5, 'guest', 'Guest', 'IWF142725cd75da8e7cc8bf169d56c43a9de', NULL, NULL, 0),
(6, '[[admin_username]]', '[[admin_realname]]', '[[admin_pass]]', '[[admin_email]]', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]UserGroupMap`
--

CREATE TABLE `[[dbprefix]]UserGroupMap` (
  `g_userId` int(11) NOT NULL,
  `g_groupId` int(11) NOT NULL,
  KEY `[[dbprefix]]UserGroupMap_69068` (`g_userId`),
  KEY `[[dbprefix]]UserGroupMap_89328` (`g_groupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]UserGroupMap`
--

INSERT INTO `[[dbprefix]]UserGroupMap` VALUES
(5, 4),
(6, 2),
(6, 4),
(6, 3);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]WatermarkImage`
--

CREATE TABLE `[[dbprefix]]WatermarkImage` (
  `g_id` int(11) NOT NULL,
  `g_applyToPreferred` int(1) DEFAULT NULL,
  `g_applyToResizes` int(1) DEFAULT NULL,
  `g_applyToThumbnail` int(1) DEFAULT NULL,
  `g_name` varchar(128) NOT NULL,
  `g_fileName` varchar(128) NOT NULL,
  `g_mimeType` varchar(128) DEFAULT NULL,
  `g_size` int(11) DEFAULT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  `g_ownerId` int(11) DEFAULT NULL,
  `g_xPercentage` varchar(32) DEFAULT NULL,
  `g_yPercentage` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  UNIQUE KEY `g_fileName` (`g_fileName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]WebDavLockMap`
--

CREATE TABLE `[[dbprefix]]WebDavLockMap` (
  `g_depth` varchar(128) DEFAULT NULL,
  `g_owner` varchar(128) DEFAULT NULL,
  `g_expires` int(11) DEFAULT NULL,
  `g_token` varchar(128) DEFAULT NULL,
  `g_path` varchar(128) DEFAULT NULL,
  `g_galleryLockId` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
