
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `gallery2`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AccessMap`
--

CREATE TABLE `[[dbprefix]]AccessMap` (
  `g_accessListId` int(11) NOT NULL,
  `g_userOrGroupId` int(11) NOT NULL,
  `g_permission` int(11) NOT NULL,
  PRIMARY KEY (`g_accessListId`,`g_userOrGroupId`),
  KEY `[[dbprefix]]AccessMap_83732` (`g_accessListId`),
  KEY `[[dbprefix]]AccessMap_48775` (`g_userOrGroupId`),
  KEY `[[dbprefix]]AccessMap_18058` (`g_permission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]AccessMap`
--

INSERT INTO `[[dbprefix]]AccessMap` VALUES
(9, 4, 7),
(10, 4, 7),
(8, 6, 2147483647),
(9, 6, 2147483647),
(10, 3, 2147483647),
(10, 6, 2147483647);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AccessSubscriberMap`
--

CREATE TABLE `[[dbprefix]]AccessSubscriberMap` (
  `g_itemId` int(11) NOT NULL,
  `g_accessListId` int(11) NOT NULL,
  PRIMARY KEY (`g_itemId`),
  KEY `[[dbprefix]]AccessSubscriberMap_83732` (`g_accessListId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]AccessSubscriberMap`
--

INSERT INTO `[[dbprefix]]AccessSubscriberMap` VALUES
(7, 10);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AlbumItem`
--

CREATE TABLE `[[dbprefix]]AlbumItem` (
  `g_id` int(11) NOT NULL,
  `g_theme` varchar(32) DEFAULT NULL,
  `g_orderBy` varchar(128) DEFAULT NULL,
  `g_orderDirection` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]AlbumItem`
--

INSERT INTO `[[dbprefix]]AlbumItem` VALUES
(7, '', '', 'asc');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]AnimationItem`
--

CREATE TABLE `[[dbprefix]]AnimationItem` (
  `g_id` int(11) NOT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]CacheMap`
--

CREATE TABLE `[[dbprefix]]CacheMap` (
  `g_key` varchar(32) NOT NULL,
  `g_value` longtext,
  `g_userId` int(11) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_type` varchar(32) NOT NULL,
  `g_timestamp` int(11) NOT NULL,
  `g_isEmpty` int(1) DEFAULT NULL,
  PRIMARY KEY (`g_key`,`g_userId`,`g_itemId`,`g_type`),
  KEY `[[dbprefix]]CacheMap_75985` (`g_itemId`),
  KEY `[[dbprefix]]CacheMap_21979` (`g_userId`,`g_timestamp`,`g_isEmpty`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ChildEntity`
--

CREATE TABLE `[[dbprefix]]ChildEntity` (
  `g_id` int(11) NOT NULL,
  `g_parentId` int(11) NOT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]ChildEntity_52718` (`g_parentId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]ChildEntity`
--

INSERT INTO `[[dbprefix]]ChildEntity` VALUES
(7, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]DataItem`
--

CREATE TABLE `[[dbprefix]]DataItem` (
  `g_id` int(11) NOT NULL,
  `g_mimeType` varchar(128) DEFAULT NULL,
  `g_size` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Derivative`
--

CREATE TABLE `[[dbprefix]]Derivative` (
  `g_id` int(11) NOT NULL,
  `g_derivativeSourceId` int(11) NOT NULL,
  `g_derivativeOperations` varchar(255) DEFAULT NULL,
  `g_derivativeOrder` int(11) NOT NULL,
  `g_derivativeSize` int(11) DEFAULT NULL,
  `g_derivativeType` int(11) NOT NULL,
  `g_mimeType` varchar(128) NOT NULL,
  `g_postFilterOperations` varchar(255) DEFAULT NULL,
  `g_isBroken` int(1) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]Derivative_85338` (`g_derivativeSourceId`),
  KEY `[[dbprefix]]Derivative_25243` (`g_derivativeOrder`),
  KEY `[[dbprefix]]Derivative_97216` (`g_derivativeType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]DerivativeImage`
--

CREATE TABLE `[[dbprefix]]DerivativeImage` (
  `g_id` int(11) NOT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]DerivativePrefsMap`
--

CREATE TABLE `[[dbprefix]]DerivativePrefsMap` (
  `g_itemId` int(11) DEFAULT NULL,
  `g_order` int(11) DEFAULT NULL,
  `g_derivativeType` int(11) DEFAULT NULL,
  `g_derivativeOperations` varchar(255) DEFAULT NULL,
  KEY `[[dbprefix]]DerivativePrefsMap_75985` (`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]DerivativePrefsMap`
--

INSERT INTO `[[dbprefix]]DerivativePrefsMap` VALUES
(7, 0, 1, 'thumbnail|150'),
(7, 0, 2, 'scale|640');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]DescendentCountsMap`
--

CREATE TABLE `[[dbprefix]]DescendentCountsMap` (
  `g_userId` int(11) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_descendentCount` int(11) NOT NULL,
  PRIMARY KEY (`g_userId`,`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Entity`
--

CREATE TABLE `[[dbprefix]]Entity` (
  `g_id` int(11) NOT NULL,
  `g_creationTimestamp` int(11) NOT NULL,
  `g_isLinkable` int(1) NOT NULL,
  `g_linkId` int(11) DEFAULT NULL,
  `g_modificationTimestamp` int(11) NOT NULL,
  `g_serialNumber` int(11) NOT NULL,
  `g_entityType` varchar(32) NOT NULL,
  `g_onLoadHandlers` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]Entity_76255` (`g_creationTimestamp`),
  KEY `[[dbprefix]]Entity_35978` (`g_isLinkable`),
  KEY `[[dbprefix]]Entity_44738` (`g_linkId`),
  KEY `[[dbprefix]]Entity_63025` (`g_modificationTimestamp`),
  KEY `[[dbprefix]]Entity_60702` (`g_serialNumber`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Entity`
--

INSERT INTO `[[dbprefix]]Entity` VALUES
(1, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryEntity', NULL),
(2, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryGroup', NULL),
(3, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryGroup', NULL),
(4, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryGroup', NULL),
(5, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryUser', NULL),
(6, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryUser', NULL),
(7, [[timestamp]], 0, NULL, [[timestamp]], 1, 'GalleryAlbumItem', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]EventLogMap`
--

CREATE TABLE `[[dbprefix]]EventLogMap` (
  `g_id` int(11) NOT NULL,
  `g_userId` int(11) DEFAULT NULL,
  `g_type` varchar(32) DEFAULT NULL,
  `g_summary` varchar(255) DEFAULT NULL,
  `g_details` text,
  `g_location` varchar(255) DEFAULT NULL,
  `g_client` varchar(128) DEFAULT NULL,
  `g_timestamp` int(11) NOT NULL,
  `g_referer` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]EventLogMap_24286` (`g_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ExternalIdMap`
--

CREATE TABLE `[[dbprefix]]ExternalIdMap` (
  `g_externalId` varchar(128) NOT NULL,
  `g_entityType` varchar(32) NOT NULL,
  `g_entityId` int(11) NOT NULL,
  PRIMARY KEY (`g_externalId`,`g_entityType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]FactoryMap`
--

CREATE TABLE `[[dbprefix]]FactoryMap` (
  `g_classType` varchar(128) DEFAULT NULL,
  `g_className` varchar(128) DEFAULT NULL,
  `g_implId` varchar(128) DEFAULT NULL,
  `g_implPath` varchar(128) DEFAULT NULL,
  `g_implModuleId` varchar(128) DEFAULT NULL,
  `g_hints` varchar(255) DEFAULT NULL,
  `g_orderWeight` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]FactoryMap`
--

INSERT INTO `[[dbprefix]]FactoryMap` VALUES
('GalleryEntity', 'GalleryEntity', 'GalleryEntity', 'modules/core/classes/GalleryEntity.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryChildEntity', 'GalleryChildEntity', 'modules/core/classes/GalleryChildEntity.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryAlbumItem', 'GalleryAlbumItem', 'modules/core/classes/GalleryAlbumItem.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryUser', 'GalleryUser', 'modules/core/classes/GalleryUser.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryGroup', 'GalleryGroup', 'modules/core/classes/GalleryGroup.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryDerivative', 'GalleryDerivative', 'modules/core/classes/GalleryDerivative.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryDerivativeImage', 'GalleryDerivativeImage', 'modules/core/classes/GalleryDerivativeImage.class', 'core', 'N;', '4'),
('GalleryDerivative', 'GalleryDerivativeImage', 'GalleryDerivativeImage', 'modules/core/classes/GalleryDerivativeImage.class', 'core', 'a:1:{i:0;s:1:"*";}', '4'),
('GalleryEntity', 'GalleryMovieItem', 'GalleryMovieItem', 'modules/core/classes/GalleryMovieItem.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryAnimationItem', 'GalleryAnimationItem', 'modules/core/classes/GalleryAnimationItem.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryPhotoItem', 'GalleryPhotoItem', 'modules/core/classes/GalleryPhotoItem.class', 'core', 'N;', '4'),
('GalleryEntity', 'GalleryUnknownItem', 'GalleryUnknownItem', 'modules/core/classes/GalleryUnknownItem.class', 'core', 'N;', '4'),
('GalleryItem', 'GalleryPhotoItem', 'GalleryPhotoItem', 'modules/core/classes/GalleryPhotoItem.class', 'core', 'a:2:{i:0;s:7:"image/*";i:1;s:21:"application/photoshop";}', '4'),
('GalleryItem', 'GalleryMovieItem', 'GalleryMovieItem', 'modules/core/classes/GalleryMovieItem.class', 'core', 'a:1:{i:0;s:7:"video/*";}', '4'),
('GalleryItem', 'GalleryAnimationItem', 'GalleryAnimationItem', 'modules/core/classes/GalleryAnimationItem.class', 'core', 'a:2:{i:0;s:22:"application/x-director";i:1;s:29:"application/x-shockwave-flash";}', '4'),
('GalleryItem', 'GalleryUnknownItem', 'GalleryUnknownItem', 'modules/core/classes/GalleryUnknownItem.class', 'core', 'a:1:{i:0;s:1:"*";}', '4'),
('GalleryDynamicAlbum', 'GalleryDynamicAlbum', 'GalleryDynamicAlbum', 'modules/core/classes/GalleryDynamicAlbum.class', 'core', 'N;', '4'),
('GallerySearchInterface_1_0', 'GalleryCoreSearch', 'GalleryCoreSearch', 'modules/core/classes/GalleryCoreSearch.class', 'core', 'N;', '4'),
('ItemEditPlugin', 'ItemEditItem', 'ItemEditItem', 'modules/core/ItemEditItem.inc', 'core', 'N;', '1'),
('ItemEditPlugin', 'ItemEditAnimation', 'ItemEditAnimation', 'modules/core/ItemEditAnimation.inc', 'core', 'N;', '2'),
('ItemEditPlugin', 'ItemEditMovie', 'ItemEditMovie', 'modules/core/ItemEditMovie.inc', 'core', 'N;', '2'),
('ItemEditPlugin', 'ItemEditAlbum', 'ItemEditAlbum', 'modules/core/ItemEditAlbum.inc', 'core', 'N;', '2'),
('ItemEditPlugin', 'ItemEditTheme', 'ItemEditTheme', 'modules/core/ItemEditTheme.inc', 'core', 'N;', '3'),
('ItemEditPlugin', 'ItemEditPhoto', 'ItemEditPhoto', 'modules/core/ItemEditPhoto.inc', 'core', 'N;', '2'),
('ItemEditPlugin', 'ItemEditRotateAndScalePhoto', 'ItemEditRotateAndScalePhoto', 'modules/core/ItemEditRotateAndScalePhoto.inc', 'core', 'N;', '3'),
('ItemEditPlugin', 'ItemEditPhotoThumbnail', 'ItemEditPhotoThumbnail', 'modules/core/ItemEditPhotoThumbnail.inc', 'core', 'N;', '4'),
('ItemAddPlugin', 'ItemAddFromBrowser', 'ItemAddFromBrowser', 'modules/core/ItemAddFromBrowser.inc', 'core', 'N;', '2'),
('ItemAddOption', 'CreateThumbnailOption', 'CreateThumbnailOption', 'modules/core/CreateThumbnailOption.inc', 'core', 'N;', '8'),
('MaintenanceTask', 'OptimizeDatabaseTask', 'OptimizeDatabaseTask', 'modules/core/classes/OptimizeDatabaseTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'DatabaseBackupTask', 'DatabaseBackupTask', 'modules/core/classes/DatabaseBackupTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'FlushTemplatesTask', 'FlushTemplatesTask', 'modules/core/classes/FlushTemplatesTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'FlushDatabaseCacheTask', 'FlushDatabaseCacheTask', 'modules/core/classes/FlushDatabaseCacheTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'BuildDerivativesTask', 'BuildDerivativesTask', 'modules/core/classes/BuildDerivativesTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'ResetViewCountsTask', 'ResetViewCountsTask', 'modules/core/classes/ResetViewCountsTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'SystemInfoTask', 'SystemInfoTask', 'modules/core/classes/SystemInfoTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'SetOriginationTimestampTask', 'SetOriginationTimestampTask', 'modules/core/classes/SetOriginationTimestampTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'DeleteSessionsTask', 'DeleteSessionsTask', 'modules/core/classes/DeleteSessionsTask.class', 'core', 'N;', '4'),
('MaintenanceTask', 'ConvertDatabaseToUtf8Task', 'ConvertDatabaseToUtf8Task', 'modules/core/classes/ConvertDatabaseToUtf8Task.class', 'core', 'N;', '4'),
('CaptchaAdminOption', 'CoreCaptchaAdminOption', 'CoreCaptchaAdminOption', 'modules/core/classes/CoreCaptchaAdminOption.class', 'core', 'N;', '4'),
('GalleryAuthPlugin', 'SessionAuthPlugin', 'SessionAuthPlugin', 'modules/core/classes/GallerySession.class', 'core', 'N;', '4'),
('GalleryEventListener', 'GalleryItemHelper_medium', 'GalleryItemHelper_medium', 'modules/core/classes/helpers/GalleryItemHelper_medium.class', 'core', 'a:4:{i:0;s:27:"gallery::viewabletreechange";i:1;s:25:"gallery::removepermission";i:2;s:19:"galleryentity::save";i:3;s:21:"galleryentity::delete";}', '4'),
('GalleryEventListener', 'GalleryUserHelper_medium', 'GalleryUserHelper_medium', 'modules/core/classes/helpers/GalleryUserHelper_medium.class', 'core', 'a:2:{i:0;s:20:"gallery::failedlogin";i:1;s:14:"gallery::login";}', '4'),
('GalleryToolkit', 'GdToolkit', 'Gd', 'modules/gd/classes/GdToolkit.class', 'gd', 'N;', '5');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]FailedLoginsMap`
--

CREATE TABLE `[[dbprefix]]FailedLoginsMap` (
  `g_userName` varchar(32) NOT NULL,
  `g_count` int(11) NOT NULL,
  `g_lastAttempt` int(11) NOT NULL,
  PRIMARY KEY (`g_userName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]FileSystemEntity`
--

CREATE TABLE `[[dbprefix]]FileSystemEntity` (
  `g_id` int(11) NOT NULL,
  `g_pathComponent` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]FileSystemEntity_3406` (`g_pathComponent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]FileSystemEntity`
--

INSERT INTO `[[dbprefix]]FileSystemEntity` VALUES
(7, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Group`
--

CREATE TABLE `[[dbprefix]]Group` (
  `g_id` int(11) NOT NULL,
  `g_groupType` int(11) NOT NULL,
  `g_groupName` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`g_id`),
  UNIQUE KEY `g_groupName` (`g_groupName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Group`
--

INSERT INTO `[[dbprefix]]Group` VALUES
(2, 2, 'Registered Users'),
(3, 3, 'Site Admins'),
(4, 4, 'Everybody');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Item`
--

CREATE TABLE `[[dbprefix]]Item` (
  `g_id` int(11) NOT NULL,
  `g_canContainChildren` int(1) NOT NULL,
  `g_description` text,
  `g_keywords` varchar(255) DEFAULT NULL,
  `g_ownerId` int(11) NOT NULL,
  `g_renderer` varchar(128) DEFAULT NULL,
  `g_summary` varchar(255) DEFAULT NULL,
  `g_title` varchar(128) DEFAULT NULL,
  `g_viewedSinceTimestamp` int(11) NOT NULL,
  `g_originationTimestamp` int(11) NOT NULL,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]Item_99070` (`g_keywords`),
  KEY `[[dbprefix]]Item_21573` (`g_ownerId`),
  KEY `[[dbprefix]]Item_54147` (`g_summary`),
  KEY `[[dbprefix]]Item_90059` (`g_title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Item`
--

INSERT INTO `[[dbprefix]]Item` VALUES
(7, 1, 'This is the main page of your Gallery', NULL, 6, NULL, NULL, 'Gallery', [[timestamp]], [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ItemAttributesMap`
--

CREATE TABLE `[[dbprefix]]ItemAttributesMap` (
  `g_itemId` int(11) NOT NULL,
  `g_viewCount` int(11) DEFAULT NULL,
  `g_orderWeight` int(11) DEFAULT NULL,
  `g_parentSequence` varchar(255) NOT NULL,
  PRIMARY KEY (`g_itemId`),
  KEY `[[dbprefix]]ItemAttributesMap_95270` (`g_parentSequence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]ItemAttributesMap`
--

INSERT INTO `[[dbprefix]]ItemAttributesMap` VALUES
(7, 0, 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Lock`
--

CREATE TABLE `[[dbprefix]]Lock` (
  `g_lockId` int(11) DEFAULT NULL,
  `g_readEntityId` int(11) DEFAULT NULL,
  `g_writeEntityId` int(11) DEFAULT NULL,
  `g_freshUntil` int(11) DEFAULT NULL,
  `g_request` int(11) DEFAULT NULL,
  KEY `[[dbprefix]]Lock_11039` (`g_lockId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]MaintenanceMap`
--

CREATE TABLE `[[dbprefix]]MaintenanceMap` (
  `g_runId` int(11) NOT NULL,
  `g_taskId` varchar(128) NOT NULL,
  `g_timestamp` int(11) DEFAULT NULL,
  `g_success` int(1) DEFAULT NULL,
  `g_details` text,
  PRIMARY KEY (`g_runId`),
  KEY `[[dbprefix]]MaintenanceMap_21687` (`g_taskId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]MimeTypeMap`
--

CREATE TABLE `[[dbprefix]]MimeTypeMap` (
  `g_extension` varchar(32) NOT NULL,
  `g_mimeType` varchar(128) NOT NULL,
  `g_viewable` int(1) DEFAULT NULL,
  PRIMARY KEY (`g_extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]MimeTypeMap`
--

INSERT INTO `[[dbprefix]]MimeTypeMap` VALUES
('ai', 'application/postscript', 0),
('aif', 'audio/x-aiff', 0),
('aifc', 'audio/x-aiff', 0),
('aiff', 'audio/x-aiff', 0),
('asc', 'text/plain', 0),
('asf', 'video/x-ms-asf', 0),
('asx', 'video/x-ms-asx', 0),
('au', 'audio/basic', 0),
('avi', 'video/x-msvideo', 0),
('bcpio', 'application/x-bcpio', 0),
('bin', 'application/octet-stream', 0),
('bmp', 'image/bmp', 0),
('cdf', 'application/x-netcdf', 0),
('class', 'application/octet-stream', 0),
('cpio', 'application/x-cpio', 0),
('cpt', 'application/mac-compactpro', 0),
('csh', 'application/x-csh', 0),
('css', 'text/css', 0),
('dcr', 'application/x-director', 0),
('dir', 'application/x-director', 0),
('djv', 'image/vnd.djvu', 0),
('djvu', 'image/vnd.djvu', 0),
('dll', 'application/octet-stream', 0),
('dms', 'application/octet-stream', 0),
('doc', 'application/msword', 0),
('dvi', 'application/x-dvi', 0),
('dxr', 'application/x-director', 0),
('eps', 'application/postscript', 0),
('etx', 'text/x-setext', 0),
('exe', 'application/octet-stream', 0),
('ez', 'application/andrew-inset', 0),
('flv', 'video/x-flv', 0),
('gif', 'image/gif', 1),
('gtar', 'application/x-gtar', 0),
('gz', 'application/x-gzip', 0),
('hdf', 'application/x-hdf', 0),
('hqx', 'application/mac-binhex40', 0),
('ice', 'x-conference/x-cooltalk', 0),
('ief', 'image/ief', 0),
('iges', 'model/iges', 0),
('igs', 'model/iges', 0),
('jp2', 'image/jp2', 0),
('jpe', 'image/jpeg', 1),
('jpeg', 'image/jpeg', 1),
('jpf', 'image/jpx', 0),
('jpg', 'image/jpeg', 1),
('jpg2', 'image/jp2', 0),
('jpgcmyk', 'image/jpeg-cmyk', 0),
('jpgm', 'image/jpgm', 0),
('jpm', 'image/jpm', 0),
('jpx', 'image/jpx', 0),
('js', 'application/x-javascript', 0),
('kar', 'audio/midi', 0),
('latex', 'application/x-latex', 0),
('lha', 'application/octet-stream', 0),
('lzh', 'application/octet-stream', 0),
('m3u', 'audio/x-mpegurl', 0),
('man', 'application/x-troff-man', 0),
('me', 'application/x-troff-me', 0),
('mesh', 'model/mesh', 0),
('mid', 'audio/midi', 0),
('midi', 'audio/midi', 0),
('mif', 'application/vnd.mif', 0),
('mj2', 'video/mj2', 0),
('mjp2', 'video/mj2', 0),
('mov', 'video/quicktime', 0),
('movie', 'video/x-sgi-movie', 0),
('mp2', 'audio/mpeg', 0),
('mp3', 'audio/mpeg', 0),
('mp4', 'video/mp4', 0),
('mpe', 'video/mpeg', 0),
('mpeg', 'video/mpeg', 0),
('mpg', 'video/mpeg', 0),
('mpga', 'audio/mpeg', 0),
('ms', 'application/x-troff-ms', 0),
('msh', 'model/mesh', 0),
('mxu', 'video/vnd.mpegurl', 0),
('nc', 'application/x-netcdf', 0),
('oda', 'application/oda', 0),
('pbm', 'image/x-portable-bitmap', 0),
('pcd', 'image/x-photo-cd', 0),
('pdb', 'chemical/x-pdb', 0),
('pdf', 'application/pdf', 0),
('pgm', 'image/x-portable-graymap', 0),
('pgn', 'application/x-chess-pgn', 0),
('png', 'image/png', 1),
('pnm', 'image/x-portable-anymap', 0),
('ppm', 'image/x-portable-pixmap', 0),
('ppt', 'application/vnd.ms-powerpoint', 0),
('ps', 'application/postscript', 0),
('psd', 'application/photoshop', 0),
('qt', 'video/quicktime', 0),
('ra', 'audio/x-realaudio', 0),
('ram', 'audio/x-pn-realaudio', 0),
('ras', 'image/x-cmu-raster', 0),
('rgb', 'image/x-rgb', 0),
('rm', 'audio/x-pn-realaudio', 0),
('roff', 'application/x-troff', 0),
('rpm', 'audio/x-pn-realaudio-plugin', 0),
('rtf', 'text/rtf', 0),
('rtx', 'text/richtext', 0),
('sgm', 'text/sgml', 0),
('sgml', 'text/sgml', 0),
('sh', 'application/x-sh', 0),
('shar', 'application/x-shar', 0),
('silo', 'model/mesh', 0),
('sit', 'application/x-stuffit', 0),
('skd', 'application/x-koan', 0),
('skm', 'application/x-koan', 0),
('skp', 'application/x-koan', 0),
('skt', 'application/x-koan', 0),
('smi', 'application/smil', 0),
('smil', 'application/smil', 0),
('snd', 'audio/basic', 0),
('so', 'application/octet-stream', 0),
('spl', 'application/x-futuresplash', 0),
('src', 'application/x-wais-source', 0),
('sv4cpio', 'application/x-sv4cpio', 0),
('sv4crc', 'application/x-sv4crc', 0),
('svg', 'image/svg+xml', 0),
('swf', 'application/x-shockwave-flash', 0),
('t', 'application/x-troff', 0),
('tar', 'application/x-tar', 0),
('tcl', 'application/x-tcl', 0),
('tex', 'application/x-tex', 0),
('texi', 'application/x-texinfo', 0),
('texinfo', 'application/x-texinfo', 0),
('tga', 'image/tga', 0),
('tif', 'image/tiff', 0),
('tifcmyk', 'image/tiff-cmyk', 0),
('tiff', 'image/tiff', 0),
('tr', 'application/x-troff', 0),
('tsv', 'text/tab-separated-values', 0),
('txt', 'text/plain', 0),
('ustar', 'application/x-ustar', 0),
('vcd', 'application/x-cdlink', 0),
('vrml', 'model/vrml', 0),
('vsd', 'application/vnd.visio', 0),
('wav', 'audio/x-wav', 0),
('wbmp', 'image/vnd.wap.wbmp', 0),
('wbxml', 'application/vnd.wap.wbxml', 0),
('wma', 'audio/x-ms-wma', 0),
('wmf', 'image/wmf', 0),
('wml', 'text/vnd.wap.wml', 0),
('wmlc', 'application/vnd.wap.wmlc', 0),
('wmls', 'text/vnd.wap.wmlscript', 0),
('wmlsc', 'application/vnd.wap.wmlscriptc', 0),
('wmv', 'video/x-ms-wmv', 0),
('wrl', 'model/vrml', 0),
('xbm', 'image/x-xbitmap', 0),
('xls', 'application/vnd.ms-excel', 0),
('xpm', 'image/x-xpixmap', 0),
('xsl', 'text/xml', 0),
('xwd', 'image/x-xwindowdump', 0),
('xyz', 'chemical/x-xyz', 0),
('z', 'application/x-compress', 0),
('zip', 'application/zip', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]MovieItem`
--

CREATE TABLE `[[dbprefix]]MovieItem` (
  `g_id` int(11) NOT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  `g_duration` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PermissionSetMap`
--

CREATE TABLE `[[dbprefix]]PermissionSetMap` (
  `g_module` varchar(128) NOT NULL,
  `g_permission` varchar(128) NOT NULL,
  `g_description` varchar(255) DEFAULT NULL,
  `g_bits` int(11) NOT NULL,
  `g_flags` int(11) NOT NULL,
  UNIQUE KEY `g_permission` (`g_permission`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]PermissionSetMap`
--

INSERT INTO `[[dbprefix]]PermissionSetMap` VALUES
('core', 'core.addAlbumItem', '[core] Add sub-album', 8, 0),
('core', 'core.addDataItem', '[core] Add sub-item', 16, 0),
('core', 'core.all', 'All access', 2147483647, 3),
('core', 'core.changePermissions', '[core] Change item permissions', 64, 0),
('core', 'core.delete', '[core] Delete item', 128, 0),
('core', 'core.edit', '[core] Edit item', 32, 0),
('core', 'core.view', '[core] View item', 1, 0),
('core', 'core.viewAll', '[core] View all versions', 7, 2),
('core', 'core.viewResizes', '[core] View resized version(s)', 2, 0),
('core', 'core.viewSource', '[core] View original version', 4, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PhotoItem`
--

CREATE TABLE `[[dbprefix]]PhotoItem` (
  `g_id` int(11) NOT NULL,
  `g_width` int(11) DEFAULT NULL,
  `g_height` int(11) DEFAULT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PluginMap`
--

CREATE TABLE `[[dbprefix]]PluginMap` (
  `g_pluginType` varchar(32) NOT NULL,
  `g_pluginId` varchar(32) NOT NULL,
  `g_active` int(1) NOT NULL,
  PRIMARY KEY (`g_pluginType`,`g_pluginId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]PluginMap`
--

INSERT INTO `[[dbprefix]]PluginMap` VALUES
('module', 'core', 1),
('module', 'gd', 1),
('module', 'imagemagick', 0),
('module', 'netpbm', 0),
('theme', 'matrix', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PluginPackageMap`
--

CREATE TABLE `[[dbprefix]]PluginPackageMap` (
  `g_pluginType` varchar(32) NOT NULL,
  `g_pluginId` varchar(32) NOT NULL,
  `g_packageName` varchar(32) NOT NULL,
  `g_packageVersion` varchar(32) NOT NULL,
  `g_packageBuild` varchar(32) NOT NULL,
  `g_locked` int(1) NOT NULL,
  KEY `[[dbprefix]]PluginPackageMap_80596` (`g_pluginType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]PluginPackageMap`
--

INSERT INTO `[[dbprefix]]PluginPackageMap` VALUES
('theme', 'matrix', 'base', '1.1.6', '20955', 0),
('module', 'core', 'base', '1.3.0.2', '20997', 0),
('module', 'imagemagick', 'base', '1.1.6', '20961', 0),
('module', 'netpbm', 'base', '1.1.5', '20955', 0),
('module', 'gd', 'base', '1.1.6', '20961', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]PluginParameterMap`
--

CREATE TABLE `[[dbprefix]]PluginParameterMap` (
  `g_pluginType` varchar(32) NOT NULL,
  `g_pluginId` varchar(32) NOT NULL,
  `g_itemId` int(11) NOT NULL,
  `g_parameterName` varchar(128) NOT NULL,
  `g_parameterValue` text NOT NULL,
  UNIQUE KEY `g_pluginType` (`g_pluginType`,`g_pluginId`,`g_itemId`,`g_parameterName`),
  KEY `[[dbprefix]]PluginParameterMap_80596` (`g_pluginType`),
  KEY `[[dbprefix]]PluginParameterMap_12808` (`g_pluginType`,`g_pluginId`,`g_itemId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]PluginParameterMap`
--

INSERT INTO `[[dbprefix]]PluginParameterMap` VALUES
('module', 'core', 0, 'acceleration', 'a:2:{s:5:"guest";a:1:{s:4:"type";s:4:"none";}s:4:"user";a:1:{s:4:"type";s:4:"none";}}'),
('module', 'core', 0, 'core.repositories', 'a:1:{s:8:"released";i:1;}'),
('module', 'core', 0, 'default.language', 'en_US'),
('module', 'core', 0, 'default.newAlbumsUseDefaults', 'false'),
('module', 'core', 0, 'default.orderBy', 'orderWeight'),
('module', 'core', 0, 'default.orderDirection', '1'),
('module', 'core', 0, 'default.theme', 'matrix'),
('module', 'core', 0, 'exec.beNice', '0'),
('module', 'core', 0, 'exec.expectedStatus', '0'),
('module', 'core', 0, 'format.date', '%x'),
('module', 'core', 0, 'format.datetime', '%c'),
('module', 'core', 0, 'format.time', '%X'),
('module', 'core', 0, 'id.accessListCompacterLock', '1'),
('module', 'core', 0, 'id.adminGroup', '3'),
('module', 'core', 0, 'id.allUserGroup', '2'),
('module', 'core', 0, 'id.anonymousUser', '5'),
('module', 'core', 0, 'id.everybodyGroup', '4'),
('module', 'core', 0, 'id.rootAlbum', '7'),
('module', 'core', 0, 'language.useBrowserPref', '0'),
('module', 'core', 0, 'lock.system', 'flock'),
('module', 'core', 0, 'misc.markup', 'bbcode'),
('module', 'core', 0, 'permissions.directory', '0755'),
('module', 'core', 0, 'permissions.file', '0644'),
('module', 'core', 0, 'repository.updateTime', '0'),
('module', 'core', 0, 'session.inactivityTimeout', '604800'),
('module', 'core', 0, 'session.lifetime', '1814400'),
('module', 'core', 0, 'session.siteAdministrationTimeout', '1800'),
('module', 'core', 0, 'smarty.compile_check', '0'),
('module', 'core', 0, 'validation.level', 'MEDIUM'),
('module', 'core', 0, '_callbacks', 'getItemLinks|getSystemLinks|getItemAdminViews|getSiteAdminViews|getUserAdminViews'),
('module', 'core', 0, '_requiredCoreApi', '7,53'),
('module', 'core', 0, '_requiredModuleApi', '3,8'),
('module', 'core', 0, '_templateVersion', '1'),
('module', 'core', 0, '_version', '1.3.0.2'),
('module', 'gd', 0, 'jpegQuality', '75'),
('module', 'gd', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'gd', 0, '_requiredCoreApi', '7,20'),
('module', 'gd', 0, '_requiredModuleApi', '3,6'),
('module', 'gd', 0, '_templateVersion', '1'),
('module', 'gd', 0, '_version', '1.1.6'),
('module', 'imagemagick', 0, 'cmykSupport', 'none'),
('module', 'imagemagick', 0, 'jpegQuality', '75'),
('module', 'imagemagick', 0, 'path', ''),
('module', 'imagemagick', 0, 'useNewCoalesceOptions', '0'),
('module', 'imagemagick', 0, 'versionOk', ''),
('module', 'imagemagick', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'imagemagick', 0, '_requiredCoreApi', '7,20'),
('module', 'imagemagick', 0, '_requiredModuleApi', '3,6'),
('module', 'imagemagick', 0, '_templateVersion', '1'),
('module', 'imagemagick', 0, '_version', '1.1.6'),
('module', 'netpbm', 0, 'bmptopnm', 'bmptopnm'),
('module', 'netpbm', 0, 'jpegQuality', '75'),
('module', 'netpbm', 0, 'path', ''),
('module', 'netpbm', 0, 'pnmcomp', 'pnmcomp'),
('module', 'netpbm', 0, 'pnmtojpeg', 'pnmtojpeg'),
('module', 'netpbm', 0, '_callbacks', 'getSiteAdminViews'),
('module', 'netpbm', 0, '_requiredCoreApi', '7,20'),
('module', 'netpbm', 0, '_requiredModuleApi', '3,6'),
('module', 'netpbm', 0, '_templateVersion', '1'),
('module', 'netpbm', 0, '_version', '1.1.5'),
('theme', 'matrix', 0, 'albumBlocks', 'a:1:{i:0;a:2:{i:0;s:20:"comment.ViewComments";i:1;a:0:{}}}'),
('theme', 'matrix', 0, 'columns', '3'),
('theme', 'matrix', 0, 'dynamicLinks', 'browse'),
('theme', 'matrix', 0, 'photoBlocks', 'a:2:{i:0;a:2:{i:0;s:13:"exif.ExifInfo";i:1;a:0:{}}i:1;a:2:{i:0;s:20:"comment.ViewComments";i:1;a:0:{}}}'),
('theme', 'matrix', 0, 'rows', '3'),
('theme', 'matrix', 0, 'showAlbumOwner', '1'),
('theme', 'matrix', 0, 'showImageOwner', '0'),
('theme', 'matrix', 0, 'showMicroThumbs', '0'),
('theme', 'matrix', 0, 'sidebarBlocks', 'a:4:{i:0;a:2:{i:0;s:18:"search.SearchBlock";i:1;a:1:{s:16:"showAdvancedLink";b:1;}}i:1;a:2:{i:0;s:14:"core.ItemLinks";i:1;a:1:{s:11:"useDropdown";b:0;}}i:2;a:2:{i:0;s:13:"core.PeerList";i:1;a:0:{}}i:3;a:2:{i:0;s:21:"imageblock.ImageBlock";i:1;a:0:{}}}'),
('theme', 'matrix', 0, '_requiredCoreApi', '7,20'),
('theme', 'matrix', 0, '_requiredThemeApi', '2,4'),
('theme', 'matrix', 0, '_version', '1.1.6');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]RecoverPasswordMap`
--

CREATE TABLE `[[dbprefix]]RecoverPasswordMap` (
  `g_userName` varchar(32) NOT NULL,
  `g_authString` varchar(32) NOT NULL,
  `g_requestExpires` int(11) NOT NULL,
  PRIMARY KEY (`g_userName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]Schema`
--

CREATE TABLE `[[dbprefix]]Schema` (
  `g_name` varchar(128) NOT NULL,
  `g_major` int(11) NOT NULL,
  `g_minor` int(11) NOT NULL,
  `g_createSql` text,
  `g_pluginId` varchar(32) DEFAULT NULL,
  `g_type` varchar(32) DEFAULT NULL,
  `g_info` text,
  PRIMARY KEY (`g_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]Schema`
--

INSERT INTO `[[dbprefix]]Schema` VALUES
('AccessMap', 1, 3, 'CREATE TABLE DB_TABLE_PREFIXAccessMap(\n DB_COLUMN_PREFIXaccessListId int(11) NOT NULL,\n DB_COLUMN_PREFIXuserOrGroupId int(11) NOT NULL,\n DB_COLUMN_PREFIXpermission int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXaccessListId, DB_COLUMN_PREFIXuserOrGroupId),\n INDEX DB_TABLE_PREFIXAccessMap_83732(DB_COLUMN_PREFIXaccessListId),\n INDEX DB_TABLE_PREFIXAccessMap_48775(DB_COLUMN_PREFIXuserOrGroupId),\n INDEX DB_TABLE_PREFIXAccessMap_18058(DB_COLUMN_PREFIXpermission)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''AccessMap'', 1, 3);\n\n', 'core', 'map', 'a:1:{s:16:"GalleryAccessMap";a:3:{s:12:"accessListId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:13:"userOrGroupId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:10:"permission";a:3:{s:4:"type";i:64;s:4:"size";i:4;s:7:"notNull";b:1;}}}'),
('AccessSubscriberMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXAccessSubscriberMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXaccessListId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXAccessSubscriberMap_83732(DB_COLUMN_PREFIXaccessListId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''AccessSubscriberMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:26:"GalleryAccessSubscriberMap";a:2:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:12:"accessListId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('AlbumItem', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXAlbumItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXtheme varchar(32),\n DB_COLUMN_PREFIXorderBy varchar(128),\n DB_COLUMN_PREFIXorderDirection varchar(32),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''AlbumItem'', 1, 1);\n\n', 'core', 'entity', 'a:1:{s:16:"GalleryAlbumItem";a:4:{s:7:"members";a:3:{s:5:"theme";a:2:{s:4:"type";i:2;s:4:"size";i:1;}s:7:"orderBy";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:14:"orderDirection";a:2:{s:4:"type";i:2;s:4:"size";i:1;}}s:6:"parent";s:11:"GalleryItem";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('AnimationItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXAnimationItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''AnimationItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:20:"GalleryAnimationItem";a:4:{s:7:"members";a:2:{s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}}s:6:"parent";s:15:"GalleryDataItem";s:6:"module";s:4:"core";s:6:"linked";a:2:{i:0;s:5:"width";i:1;s:6:"height";}}}'),
('CacheMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXCacheMap(\n DB_COLUMN_PREFIXkey varchar(32) NOT NULL,\n DB_COLUMN_PREFIXvalue longtext,\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXtype varchar(32) NOT NULL,\n DB_COLUMN_PREFIXtimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXisEmpty int(1),\n PRIMARY KEY(DB_COLUMN_PREFIXkey, DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXtype),\n INDEX DB_TABLE_PREFIXCacheMap_75985(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXCacheMap_21979(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXtimestamp, DB_COLUMN_PREFIXisEmpty)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''CacheMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:15:"GalleryCacheMap";a:7:{s:3:"key";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:5:"value";a:2:{s:4:"type";i:4;s:4:"size";i:4;}s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:4:"type";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:9:"timestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:7:"isEmpty";a:2:{s:4:"type";i:8;s:4:"size";i:2;}}}'),
('ChildEntity', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXChildEntity(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXparentId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXChildEntity_52718(DB_COLUMN_PREFIXparentId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ChildEntity'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:18:"GalleryChildEntity";a:4:{s:7:"members";a:1:{s:8:"parentId";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}}s:6:"parent";s:13:"GalleryEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('DataItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXDataItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128),\n DB_COLUMN_PREFIXsize int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''DataItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:15:"GalleryDataItem";a:4:{s:7:"members";a:2:{s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}s:4:"size";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}}s:6:"parent";s:11:"GalleryItem";s:6:"module";s:4:"core";s:6:"linked";a:2:{i:0;s:8:"mimeType";i:1;s:4:"size";}}}'),
('Derivative', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXDerivative(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXderivativeSourceId int(11) NOT NULL,\n DB_COLUMN_PREFIXderivativeOperations varchar(255),\n DB_COLUMN_PREFIXderivativeOrder int(11) NOT NULL,\n DB_COLUMN_PREFIXderivativeSize int(11),\n DB_COLUMN_PREFIXderivativeType int(11) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,\n DB_COLUMN_PREFIXpostFilterOperations varchar(255),\n DB_COLUMN_PREFIXisBroken int(1),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXDerivative_85338(DB_COLUMN_PREFIXderivativeSourceId),\n INDEX DB_TABLE_PREFIXDerivative_25243(DB_COLUMN_PREFIXderivativeOrder),\n INDEX DB_TABLE_PREFIXDerivative_97216(DB_COLUMN_PREFIXderivativeType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Derivative'', 1, 1);\n\n', 'core', 'entity', 'a:1:{s:17:"GalleryDerivative";a:4:{s:7:"members";a:8:{s:18:"derivativeSourceId";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:20:"derivativeOperations";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:15:"derivativeOrder";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}s:14:"derivativeSize";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}s:14:"derivativeType";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}s:8:"mimeType";a:4:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";i:1;s:15:"external-access";i:3;}s:20:"postFilterOperations";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:8:"isBroken";a:1:{s:4:"type";i:8;}}s:6:"parent";s:18:"GalleryChildEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('DerivativeImage', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXDerivativeImage(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''DerivativeImage'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:22:"GalleryDerivativeImage";a:4:{s:7:"members";a:2:{s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}}s:6:"parent";s:17:"GalleryDerivative";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('DerivativePrefsMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXDerivativePrefsMap(\n DB_COLUMN_PREFIXitemId int(11),\n DB_COLUMN_PREFIXorder int(11),\n DB_COLUMN_PREFIXderivativeType int(11),\n DB_COLUMN_PREFIXderivativeOperations varchar(255),\n INDEX DB_TABLE_PREFIXDerivativePrefsMap_75985(DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''DerivativePrefsMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:31:"GalleryDerivativePreferencesMap";a:4:{s:6:"itemId";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:5:"order";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:14:"derivativeType";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:20:"derivativeOperations";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('DescendentCountsMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXDescendentCountsMap(\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXdescendentCount int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''DescendentCountsMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:26:"GalleryDescendentCountsMap";a:3:{s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:15:"descendentCount";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('Entity', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXEntity(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXcreationTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXisLinkable int(1) NOT NULL,\n DB_COLUMN_PREFIXlinkId int(11),\n DB_COLUMN_PREFIXmodificationTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXserialNumber int(11) NOT NULL,\n DB_COLUMN_PREFIXentityType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXonLoadHandlers varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXEntity_76255(DB_COLUMN_PREFIXcreationTimestamp),\n INDEX DB_TABLE_PREFIXEntity_35978(DB_COLUMN_PREFIXisLinkable),\n INDEX DB_TABLE_PREFIXEntity_44738(DB_COLUMN_PREFIXlinkId),\n INDEX DB_TABLE_PREFIXEntity_63025(DB_COLUMN_PREFIXmodificationTimestamp),\n INDEX DB_TABLE_PREFIXEntity_60702(DB_COLUMN_PREFIXserialNumber)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Entity'', 1, 2);\n\n', 'core', 'entity', 'a:1:{s:13:"GalleryEntity";a:4:{s:7:"members";a:8:{s:2:"id";a:3:{s:4:"type";i:33;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:17:"creationTimestamp";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:3;}s:10:"isLinkable";a:2:{s:4:"type";i:8;s:7:"notNull";i:1;}s:6:"linkId";a:1:{s:4:"type";i:1;}s:21:"modificationTimestamp";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:12:"serialNumber";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:10:"entityType";a:4:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:14:"onLoadHandlers";a:2:{s:4:"type";i:2;s:4:"size";i:2;}}s:6:"parent";N;s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('EventLogMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXEventLogMap(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXuserId int(11),\n DB_COLUMN_PREFIXtype varchar(32),\n DB_COLUMN_PREFIXsummary varchar(255),\n DB_COLUMN_PREFIXdetails text,\n DB_COLUMN_PREFIXlocation varchar(255),\n DB_COLUMN_PREFIXclient varchar(128),\n DB_COLUMN_PREFIXtimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXreferer varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXEventLogMap_24286(DB_COLUMN_PREFIXtimestamp)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''EventLogMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:11:"EventLogMap";a:9:{s:2:"id";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"userId";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:4:"type";a:2:{s:4:"type";i:2;s:4:"size";i:1;}s:7:"summary";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:7:"details";a:2:{s:4:"type";i:4;s:4:"size";i:2;}s:8:"location";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:6:"client";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:9:"timestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:7:"referer";a:2:{s:4:"type";i:2;s:4:"size";i:2;}}}'),
('ExternalIdMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXExternalIdMap(\n DB_COLUMN_PREFIXexternalId varchar(128) NOT NULL,\n DB_COLUMN_PREFIXentityType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXentityId int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXexternalId, DB_COLUMN_PREFIXentityType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ExternalIdMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:13:"ExternalIdMap";a:3:{s:10:"externalId";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:10:"entityType";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"entityId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('FactoryMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXFactoryMap(\n DB_COLUMN_PREFIXclassType varchar(128),\n DB_COLUMN_PREFIXclassName varchar(128),\n DB_COLUMN_PREFIXimplId varchar(128),\n DB_COLUMN_PREFIXimplPath varchar(128),\n DB_COLUMN_PREFIXimplModuleId varchar(128),\n DB_COLUMN_PREFIXhints varchar(255),\n DB_COLUMN_PREFIXorderWeight varchar(255)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''FactoryMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:17:"GalleryFactoryMap";a:7:{s:9:"classType";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:9:"className";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:6:"implId";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:8:"implPath";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:12:"implModuleId";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:5:"hints";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:11:"orderWeight";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('FailedLoginsMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXFailedLoginsMap(\n DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXcount int(11) NOT NULL,\n DB_COLUMN_PREFIXlastAttempt int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXuserName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''FailedLoginsMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:15:"FailedLoginsMap";a:3:{s:8:"userName";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:5:"count";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"lastAttempt";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('FileSystemEntity', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXFileSystemEntity(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXpathComponent varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXFileSystemEntity_3406(DB_COLUMN_PREFIXpathComponent)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''FileSystemEntity'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:23:"GalleryFileSystemEntity";a:4:{s:7:"members";a:1:{s:13:"pathComponent";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}}s:6:"parent";s:18:"GalleryChildEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('Group', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXGroup(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXgroupType int(11) NOT NULL,\n DB_COLUMN_PREFIXgroupName varchar(128),\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n UNIQUE (DB_COLUMN_PREFIXgroupName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Group'', 1, 1);\n\n', 'core', 'entity', 'a:1:{s:12:"GalleryGroup";a:4:{s:7:"members";a:2:{s:9:"groupType";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}s:9:"groupName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}}s:6:"parent";s:13:"GalleryEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('Item', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXcanContainChildren int(1) NOT NULL,\n DB_COLUMN_PREFIXdescription text,\n DB_COLUMN_PREFIXkeywords varchar(255),\n DB_COLUMN_PREFIXownerId int(11) NOT NULL,\n DB_COLUMN_PREFIXrenderer varchar(128),\n DB_COLUMN_PREFIXsummary varchar(255),\n DB_COLUMN_PREFIXtitle varchar(128),\n DB_COLUMN_PREFIXviewedSinceTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXoriginationTimestamp int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXItem_99070(DB_COLUMN_PREFIXkeywords),\n INDEX DB_TABLE_PREFIXItem_21573(DB_COLUMN_PREFIXownerId),\n INDEX DB_TABLE_PREFIXItem_54147(DB_COLUMN_PREFIXsummary),\n INDEX DB_TABLE_PREFIXItem_90059(DB_COLUMN_PREFIXtitle)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Item'', 1, 2);\n\n', 'core', 'entity', 'a:1:{s:11:"GalleryItem";a:4:{s:7:"members";a:9:{s:18:"canContainChildren";a:3:{s:4:"type";i:8;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:11:"description";a:3:{s:4:"type";i:4;s:4:"size";i:1;s:15:"external-access";i:3;}s:8:"keywords";a:3:{s:4:"type";i:2;s:4:"size";i:4;s:15:"external-access";i:3;}s:7:"ownerId";a:2:{s:4:"type";i:1;s:7:"notNull";i:1;}s:8:"renderer";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:7:"summary";a:3:{s:4:"type";i:2;s:4:"size";i:4;s:15:"external-access";i:3;}s:5:"title";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:3;}s:20:"viewedSinceTimestamp";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:20:"originationTimestamp";a:3:{s:4:"type";i:1;s:7:"notNull";i:1;s:15:"external-access";i:3;}}s:6:"parent";s:23:"GalleryFileSystemEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('ItemAttributesMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXItemAttributesMap(\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXviewCount int(11),\n DB_COLUMN_PREFIXorderWeight int(11),\n DB_COLUMN_PREFIXparentSequence varchar(255) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXitemId),\n INDEX DB_TABLE_PREFIXItemAttributesMap_95270(DB_COLUMN_PREFIXparentSequence)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''ItemAttributesMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:24:"GalleryItemAttributesMap";a:4:{s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"viewCount";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:11:"orderWeight";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:14:"parentSequence";a:3:{s:4:"type";i:2;s:4:"size";i:4;s:19:"notNullEmptyAllowed";b:1;}}}'),
('Lock', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXLock(\n DB_COLUMN_PREFIXlockId int(11),\n DB_COLUMN_PREFIXreadEntityId int(11),\n DB_COLUMN_PREFIXwriteEntityId int(11),\n DB_COLUMN_PREFIXfreshUntil int(11),\n DB_COLUMN_PREFIXrequest int(11),\n INDEX DB_TABLE_PREFIXLock_11039(DB_COLUMN_PREFIXlockId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Lock'', 1, 0);\n\n', 'core', NULL, NULL),
('MaintenanceMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXMaintenanceMap(\n DB_COLUMN_PREFIXrunId int(11) NOT NULL,\n DB_COLUMN_PREFIXtaskId varchar(128) NOT NULL,\n DB_COLUMN_PREFIXtimestamp int(11),\n DB_COLUMN_PREFIXsuccess int(1),\n DB_COLUMN_PREFIXdetails text,\n PRIMARY KEY(DB_COLUMN_PREFIXrunId),\n INDEX DB_TABLE_PREFIXMaintenanceMap_21687(DB_COLUMN_PREFIXtaskId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''MaintenanceMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:21:"GalleryMaintenanceMap";a:5:{s:5:"runId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:6:"taskId";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"timestamp";a:2:{s:4:"type";i:1;s:4:"size";i:2;}s:7:"success";a:2:{s:4:"type";i:8;s:4:"size";i:2;}s:7:"details";a:2:{s:4:"type";i:4;s:4:"size";i:1;}}}'),
('MimeTypeMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXMimeTypeMap(\n DB_COLUMN_PREFIXextension varchar(32) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,\n DB_COLUMN_PREFIXviewable int(1),\n PRIMARY KEY(DB_COLUMN_PREFIXextension)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''MimeTypeMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:18:"GalleryMimeTypeMap";a:3:{s:9:"extension";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"viewable";a:2:{s:4:"type";i:8;s:4:"size";i:2;}}}'),
('MovieItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXMovieItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n DB_COLUMN_PREFIXduration int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''MovieItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:16:"GalleryMovieItem";a:4:{s:7:"members";a:3:{s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}s:8:"duration";a:2:{s:4:"type";i:1;s:15:"external-access";i:3;}}s:6:"parent";s:15:"GalleryDataItem";s:6:"module";s:4:"core";s:6:"linked";a:3:{i:0;s:5:"width";i:1;s:6:"height";i:2;s:8:"duration";}}}'),
('PermissionSetMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXPermissionSetMap(\n DB_COLUMN_PREFIXmodule varchar(128) NOT NULL,\n DB_COLUMN_PREFIXpermission varchar(128) NOT NULL,\n DB_COLUMN_PREFIXdescription varchar(255),\n DB_COLUMN_PREFIXbits int(11) NOT NULL,\n DB_COLUMN_PREFIXflags int(11) NOT NULL,\n UNIQUE (DB_COLUMN_PREFIXpermission)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PermissionSetMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:23:"GalleryPermissionSetMap";a:5:{s:6:"module";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:10:"permission";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"description";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:4:"bits";a:3:{s:4:"type";i:64;s:4:"size";i:2;s:7:"notNull";b:1;}s:5:"flags";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('PhotoItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXPhotoItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXwidth int(11),\n DB_COLUMN_PREFIXheight int(11),\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PhotoItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:16:"GalleryPhotoItem";a:4:{s:7:"members";a:2:{s:5:"width";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}s:6:"height";a:2:{s:4:"type";i:1;s:15:"external-access";i:1;}}s:6:"parent";s:15:"GalleryDataItem";s:6:"module";s:4:"core";s:6:"linked";a:2:{i:0;s:5:"width";i:1;s:6:"height";}}}'),
('PluginMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXPluginMap(\n DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,\n DB_COLUMN_PREFIXactive int(1) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PluginMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:16:"GalleryPluginMap";a:3:{s:10:"pluginType";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"pluginId";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:6:"active";a:3:{s:4:"type";i:8;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('PluginPackageMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXPluginPackageMap(\n DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpackageName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpackageVersion varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpackageBuild varchar(32) NOT NULL,\n DB_COLUMN_PREFIXlocked int(1) NOT NULL,\n INDEX DB_TABLE_PREFIXPluginPackageMap_80596(DB_COLUMN_PREFIXpluginType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PluginPackageMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:23:"GalleryPluginPackageMap";a:6:{s:10:"pluginType";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"pluginId";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:11:"packageName";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:14:"packageVersion";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:12:"packageBuild";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:6:"locked";a:3:{s:4:"type";i:8;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('PluginParameterMap', 1, 3, 'CREATE TABLE DB_TABLE_PREFIXPluginParameterMap(\n DB_COLUMN_PREFIXpluginType varchar(32) NOT NULL,\n DB_COLUMN_PREFIXpluginId varchar(32) NOT NULL,\n DB_COLUMN_PREFIXitemId int(11) NOT NULL,\n DB_COLUMN_PREFIXparameterName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXparameterValue text NOT NULL,\n UNIQUE (DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId, DB_COLUMN_PREFIXparameterName),\n INDEX DB_TABLE_PREFIXPluginParameterMap_80596(DB_COLUMN_PREFIXpluginType),\n INDEX DB_TABLE_PREFIXPluginParameterMap_12808(DB_COLUMN_PREFIXpluginType, DB_COLUMN_PREFIXpluginId, DB_COLUMN_PREFIXitemId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''PluginParameterMap'', 1, 3);\n\n', 'core', 'map', 'a:1:{s:25:"GalleryPluginParameterMap";a:5:{s:10:"pluginType";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:8:"pluginId";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:6:"itemId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:13:"parameterName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:14:"parameterValue";a:3:{s:4:"type";i:4;s:4:"size";i:1;s:19:"notNullEmptyAllowed";b:1;}}}'),
('RecoverPasswordMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXRecoverPasswordMap(\n DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXauthString varchar(32) NOT NULL,\n DB_COLUMN_PREFIXrequestExpires int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXuserName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''RecoverPasswordMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:25:"GalleryRecoverPasswordMap";a:3:{s:8:"userName";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:10:"authString";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:14:"requestExpires";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('Schema', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXSchema(\n DB_COLUMN_PREFIXname varchar(128) NOT NULL,\n DB_COLUMN_PREFIXmajor int(11) NOT NULL,\n DB_COLUMN_PREFIXminor int(11) NOT NULL,\n DB_COLUMN_PREFIXcreateSql text,\n DB_COLUMN_PREFIXpluginId varchar(32),\n DB_COLUMN_PREFIXtype varchar(32),\n DB_COLUMN_PREFIXinfo text,\n PRIMARY KEY(DB_COLUMN_PREFIXname)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''Schema'', 1, 2);\n\n', 'core', NULL, NULL),
('SessionMap', 1, 1, 'CREATE TABLE DB_TABLE_PREFIXSessionMap(\n DB_COLUMN_PREFIXid varchar(32) NOT NULL,\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXremoteIdentifier varchar(128) NOT NULL,\n DB_COLUMN_PREFIXcreationTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXmodificationTimestamp int(11) NOT NULL,\n DB_COLUMN_PREFIXdata longtext,\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n INDEX DB_TABLE_PREFIXSessionMap_53500(DB_COLUMN_PREFIXuserId, DB_COLUMN_PREFIXcreationTimestamp, DB_COLUMN_PREFIXmodificationTimestamp)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''SessionMap'', 1, 1);\n\n', 'core', 'map', 'a:1:{s:17:"GallerySessionMap";a:6:{s:2:"id";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:16:"remoteIdentifier";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:17:"creationTimestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:21:"modificationTimestamp";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:4:"data";a:2:{s:4:"type";i:4;s:4:"size";i:4;}}}'),
('TkOperatnMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkOperatnMap(\n DB_COLUMN_PREFIXname varchar(128) NOT NULL,\n DB_COLUMN_PREFIXparametersCrc varchar(32) NOT NULL,\n DB_COLUMN_PREFIXoutputMimeType varchar(128),\n DB_COLUMN_PREFIXdescription varchar(255),\n PRIMARY KEY(DB_COLUMN_PREFIXname)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkOperatnMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:26:"GalleryToolkitOperationMap";a:4:{s:4:"name";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:13:"parametersCrc";a:3:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";b:1;}s:14:"outputMimeType";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:11:"description";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('TkOperatnMimeTypeMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkOperatnMimeTypeMap(\n DB_COLUMN_PREFIXoperationName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXtoolkitId varchar(128) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,\n DB_COLUMN_PREFIXpriority int(11) NOT NULL,\n INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_2014(DB_COLUMN_PREFIXoperationName),\n INDEX DB_TABLE_PREFIXTkOperatnMimeTypeMap_79463(DB_COLUMN_PREFIXmimeType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkOperatnMimeTypeMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:34:"GalleryToolkitOperationMimeTypeMap";a:4:{s:13:"operationName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"toolkitId";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"priority";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('TkOperatnParameterMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkOperatnParameterMap(\n DB_COLUMN_PREFIXoperationName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXposition int(11) NOT NULL,\n DB_COLUMN_PREFIXtype varchar(128) NOT NULL,\n DB_COLUMN_PREFIXdescription varchar(255),\n INDEX DB_TABLE_PREFIXTkOperatnParameterMap_2014(DB_COLUMN_PREFIXoperationName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkOperatnParameterMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:35:"GalleryToolkitOperationParameterMap";a:4:{s:13:"operationName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"position";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:4:"type";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"description";a:2:{s:4:"type";i:2;s:4:"size";i:4;}}}'),
('TkPropertyMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkPropertyMap(\n DB_COLUMN_PREFIXname varchar(128) NOT NULL,\n DB_COLUMN_PREFIXtype varchar(128) NOT NULL,\n DB_COLUMN_PREFIXdescription varchar(128) NOT NULL\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkPropertyMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:25:"GalleryToolkitPropertyMap";a:3:{s:4:"name";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:4:"type";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:11:"description";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('TkPropertyMimeTypeMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXTkPropertyMimeTypeMap(\n DB_COLUMN_PREFIXpropertyName varchar(128) NOT NULL,\n DB_COLUMN_PREFIXtoolkitId varchar(128) NOT NULL,\n DB_COLUMN_PREFIXmimeType varchar(128) NOT NULL,\n INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_52881(DB_COLUMN_PREFIXpropertyName),\n INDEX DB_TABLE_PREFIXTkPropertyMimeTypeMap_79463(DB_COLUMN_PREFIXmimeType)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''TkPropertyMimeTypeMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:33:"GalleryToolkitPropertyMimeTypeMap";a:3:{s:12:"propertyName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:9:"toolkitId";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}s:8:"mimeType";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:7:"notNull";b:1;}}}'),
('UnknownItem', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXUnknownItem(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n PRIMARY KEY(DB_COLUMN_PREFIXid)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''UnknownItem'', 1, 0);\n\n', 'core', 'entity', 'a:1:{s:18:"GalleryUnknownItem";a:4:{s:7:"members";a:0:{}s:6:"parent";s:15:"GalleryDataItem";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('User', 1, 2, 'CREATE TABLE DB_TABLE_PREFIXUser(\n DB_COLUMN_PREFIXid int(11) NOT NULL,\n DB_COLUMN_PREFIXuserName varchar(32) NOT NULL,\n DB_COLUMN_PREFIXfullName varchar(128),\n DB_COLUMN_PREFIXhashedPassword varchar(128),\n DB_COLUMN_PREFIXemail varchar(255),\n DB_COLUMN_PREFIXlanguage varchar(128),\n DB_COLUMN_PREFIXlocked int(1) DEFAULT ''0'',\n PRIMARY KEY(DB_COLUMN_PREFIXid),\n UNIQUE (DB_COLUMN_PREFIXuserName)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''User'', 1, 2);\n\n', 'core', 'entity', 'a:1:{s:11:"GalleryUser";a:4:{s:7:"members";a:6:{s:8:"userName";a:4:{s:4:"type";i:2;s:4:"size";i:1;s:7:"notNull";i:1;s:15:"external-access";i:1;}s:8:"fullName";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:3;}s:14:"hashedPassword";a:2:{s:4:"type";i:2;s:4:"size";i:2;}s:5:"email";a:2:{s:4:"type";i:2;s:4:"size";i:4;}s:8:"language";a:3:{s:4:"type";i:2;s:4:"size";i:2;s:15:"external-access";i:1;}s:6:"locked";a:1:{s:4:"type";i:8;}}s:6:"parent";s:13:"GalleryEntity";s:6:"module";s:4:"core";s:6:"linked";a:0:{}}}'),
('UserGroupMap', 1, 0, 'CREATE TABLE DB_TABLE_PREFIXUserGroupMap(\n DB_COLUMN_PREFIXuserId int(11) NOT NULL,\n DB_COLUMN_PREFIXgroupId int(11) NOT NULL,\n INDEX DB_TABLE_PREFIXUserGroupMap_69068(DB_COLUMN_PREFIXuserId),\n INDEX DB_TABLE_PREFIXUserGroupMap_89328(DB_COLUMN_PREFIXgroupId)\n) DB_TABLE_TYPE\n/*!40100 DEFAULT CHARACTER SET utf8 */;\n\nINSERT INTO DB_TABLE_PREFIXSchema (\n DB_COLUMN_PREFIXname,\n DB_COLUMN_PREFIXmajor,\n DB_COLUMN_PREFIXminor\n) VALUES(''UserGroupMap'', 1, 0);\n\n', 'core', 'map', 'a:1:{s:19:"GalleryUserGroupMap";a:2:{s:6:"userId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}s:7:"groupId";a:3:{s:4:"type";i:1;s:4:"size";i:2;s:7:"notNull";b:1;}}}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SequenceEventLog`
--

CREATE TABLE `[[dbprefix]]SequenceEventLog` (
  `id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `[[dbprefix]]SequenceEventLog`
--

INSERT INTO `[[dbprefix]]SequenceEventLog` VALUES
(0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SequenceId`
--

CREATE TABLE `[[dbprefix]]SequenceId` (
  `id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `[[dbprefix]]SequenceId`
--

INSERT INTO `[[dbprefix]]SequenceId` VALUES
(10);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SequenceLock`
--

CREATE TABLE `[[dbprefix]]SequenceLock` (
  `id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `[[dbprefix]]SequenceLock`
--

INSERT INTO `[[dbprefix]]SequenceLock` VALUES
(0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]SessionMap`
--

CREATE TABLE `[[dbprefix]]SessionMap` (
  `g_id` varchar(32) NOT NULL,
  `g_userId` int(11) NOT NULL,
  `g_remoteIdentifier` varchar(128) NOT NULL,
  `g_creationTimestamp` int(11) NOT NULL,
  `g_modificationTimestamp` int(11) NOT NULL,
  `g_data` longtext,
  PRIMARY KEY (`g_id`),
  KEY `[[dbprefix]]SessionMap_53500` (`g_userId`,`g_creationTimestamp`,`g_modificationTimestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkOperatnMap`
--

CREATE TABLE `[[dbprefix]]TkOperatnMap` (
  `g_name` varchar(128) NOT NULL,
  `g_parametersCrc` varchar(32) NOT NULL,
  `g_outputMimeType` varchar(128) DEFAULT NULL,
  `g_description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`g_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkOperatnMap`
--

INSERT INTO `[[dbprefix]]TkOperatnMap` VALUES
('composite', '1204337430', NULL, 'Overlay source image with a second one'),
('compress', '340908721', NULL, 'Reduce image quality to reach target file size'),
('convert-to-image/jpeg', '0', 'image/jpeg', 'Convert to a JPEG'),
('crop', '729751051', NULL, 'Crop the image'),
('resize', '3155881288', NULL, 'Resize the image to the target dimensions'),
('rotate', '340908721', NULL, 'Rotate the image'),
('scale', '3155881288', NULL, 'Scale the image to the target size, maintain aspect ratio'),
('thumbnail', '3155881288', NULL, 'Scale the image to the target size, maintain aspect ratio');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkOperatnMimeTypeMap`
--

CREATE TABLE `[[dbprefix]]TkOperatnMimeTypeMap` (
  `g_operationName` varchar(128) NOT NULL,
  `g_toolkitId` varchar(128) NOT NULL,
  `g_mimeType` varchar(128) NOT NULL,
  `g_priority` int(11) NOT NULL,
  KEY `[[dbprefix]]TkOperatnMimeTypeMap_2014` (`g_operationName`),
  KEY `[[dbprefix]]TkOperatnMimeTypeMap_79463` (`g_mimeType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkOperatnMimeTypeMap`
--

INSERT INTO `[[dbprefix]]TkOperatnMimeTypeMap` VALUES
('convert-to-image/jpeg', 'Gd', 'image/gif', 21),
('convert-to-image/jpeg', 'Gd', 'image/jpeg', 21),
('convert-to-image/jpeg', 'Gd', 'image/png', 21),
('convert-to-image/jpeg', 'Gd', 'image/vnd.wap.wbmp', 21),
('convert-to-image/jpeg', 'Gd', 'image/x-xbitmap', 21),
('scale', 'Gd', 'image/gif', 21),
('scale', 'Gd', 'image/jpeg', 21),
('scale', 'Gd', 'image/png', 21),
('scale', 'Gd', 'image/vnd.wap.wbmp', 21),
('scale', 'Gd', 'image/x-xbitmap', 21),
('thumbnail', 'Gd', 'image/gif', 21),
('thumbnail', 'Gd', 'image/jpeg', 21),
('thumbnail', 'Gd', 'image/png', 21),
('thumbnail', 'Gd', 'image/vnd.wap.wbmp', 21),
('thumbnail', 'Gd', 'image/x-xbitmap', 21),
('resize', 'Gd', 'image/gif', 21),
('resize', 'Gd', 'image/jpeg', 21),
('resize', 'Gd', 'image/png', 21),
('resize', 'Gd', 'image/vnd.wap.wbmp', 21),
('resize', 'Gd', 'image/x-xbitmap', 21),
('rotate', 'Gd', 'image/gif', 21),
('rotate', 'Gd', 'image/jpeg', 21),
('rotate', 'Gd', 'image/png', 21),
('rotate', 'Gd', 'image/vnd.wap.wbmp', 21),
('rotate', 'Gd', 'image/x-xbitmap', 21),
('crop', 'Gd', 'image/gif', 21),
('crop', 'Gd', 'image/jpeg', 21),
('crop', 'Gd', 'image/png', 21),
('crop', 'Gd', 'image/vnd.wap.wbmp', 21),
('crop', 'Gd', 'image/x-xbitmap', 21),
('composite', 'Gd', 'image/gif', 21),
('composite', 'Gd', 'image/jpeg', 21),
('composite', 'Gd', 'image/png', 21),
('composite', 'Gd', 'image/vnd.wap.wbmp', 21),
('composite', 'Gd', 'image/x-xbitmap', 21),
('compress', 'Gd', 'image/jpeg', 21);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkOperatnParameterMap`
--

CREATE TABLE `[[dbprefix]]TkOperatnParameterMap` (
  `g_operationName` varchar(128) NOT NULL,
  `g_position` int(11) NOT NULL,
  `g_type` varchar(128) NOT NULL,
  `g_description` varchar(255) DEFAULT NULL,
  KEY `[[dbprefix]]TkOperatnParameterMap_2014` (`g_operationName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkOperatnParameterMap`
--

INSERT INTO `[[dbprefix]]TkOperatnParameterMap` VALUES
('scale', 0, 'int', 'target width (# pixels or #% of full size)'),
('scale', 1, 'int', '(optional) target height, defaults to same as width'),
('thumbnail', 0, 'int', 'target width (# pixels or #% of full size)'),
('thumbnail', 1, 'int', '(optional) target height, defaults to same as width'),
('resize', 0, 'int', 'target width (# pixels or #% of full size)'),
('resize', 1, 'int', 'target height (# pixels or #% of full size)'),
('rotate', 0, 'int', 'rotation degrees'),
('crop', 0, 'float', 'left edge %'),
('crop', 1, 'float', 'top edge %'),
('crop', 2, 'float', 'width %'),
('crop', 3, 'float', 'height %'),
('composite', 0, 'string', 'overlay path'),
('composite', 1, 'string', 'overlay mime type'),
('composite', 2, 'int', 'overlay width'),
('composite', 3, 'int', 'overlay height'),
('composite', 4, 'string', 'alignment type'),
('composite', 5, 'int', 'alignment x %'),
('composite', 6, 'int', 'alignment y %'),
('compress', 0, 'int', 'target size in kb');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkPropertyMap`
--

CREATE TABLE `[[dbprefix]]TkPropertyMap` (
  `g_name` varchar(128) NOT NULL,
  `g_type` varchar(128) NOT NULL,
  `g_description` varchar(128) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkPropertyMap`
--

INSERT INTO `[[dbprefix]]TkPropertyMap` VALUES
('dimensions', 'int,int', 'Get the width and height of the image');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]TkPropertyMimeTypeMap`
--

CREATE TABLE `[[dbprefix]]TkPropertyMimeTypeMap` (
  `g_propertyName` varchar(128) NOT NULL,
  `g_toolkitId` varchar(128) NOT NULL,
  `g_mimeType` varchar(128) NOT NULL,
  KEY `[[dbprefix]]TkPropertyMimeTypeMap_52881` (`g_propertyName`),
  KEY `[[dbprefix]]TkPropertyMimeTypeMap_79463` (`g_mimeType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]TkPropertyMimeTypeMap`
--

INSERT INTO `[[dbprefix]]TkPropertyMimeTypeMap` VALUES
('dimensions', 'Gd', 'image/gif'),
('dimensions', 'Gd', 'image/jpeg'),
('dimensions', 'Gd', 'image/png'),
('dimensions', 'Gd', 'image/vnd.wap.wbmp'),
('dimensions', 'Gd', 'image/x-xbitmap'),
('dimensions', 'Gd', 'application/x-shockwave-flash');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]UnknownItem`
--

CREATE TABLE `[[dbprefix]]UnknownItem` (
  `g_id` int(11) NOT NULL,
  PRIMARY KEY (`g_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]User`
--

CREATE TABLE `[[dbprefix]]User` (
  `g_id` int(11) NOT NULL,
  `g_userName` varchar(32) NOT NULL,
  `g_fullName` varchar(128) DEFAULT NULL,
  `g_hashedPassword` varchar(128) DEFAULT NULL,
  `g_email` varchar(255) DEFAULT NULL,
  `g_language` varchar(128) DEFAULT NULL,
  `g_locked` int(1) DEFAULT '0',
  PRIMARY KEY (`g_id`),
  UNIQUE KEY `g_userName` (`g_userName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]User`
--

INSERT INTO `[[dbprefix]]User` VALUES
(5, 'guest', 'Guest', 'hpbT931b54187442bfe50fed0fc91781b1df', NULL, NULL, 0),
(6, '[[admin_username]]', '[[admin_realname]]', '[[admin_pass]]', '[[admin_email]]', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]UserGroupMap`
--

CREATE TABLE `[[dbprefix]]UserGroupMap` (
  `g_userId` int(11) NOT NULL,
  `g_groupId` int(11) NOT NULL,
  KEY `[[dbprefix]]UserGroupMap_69068` (`g_userId`),
  KEY `[[dbprefix]]UserGroupMap_89328` (`g_groupId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]UserGroupMap`
--

INSERT INTO `[[dbprefix]]UserGroupMap` VALUES
(5, 4),
(6, 2),
(6, 4),
(6, 3);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
