<?php
/*-------------------------------------------------------+
| PHPFusion Content Management System
| Copyright (C) PHP Fusion Inc
| https://phpfusion.com/
+--------------------------------------------------------+
| Filename: download_submit.php
| Author: Frederick MC Chan (Chan)
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
defined('IN_FUSION') || exit;

$locale = fusion_get_locale('', DOWNLOAD_ADMIN_LOCALE);
$dl_settings = get_settings("downloads");
$userdata = fusion_get_userdata();

add_to_title($locale['download_0041']);

opentable("<i class='fa fa-download fa-lg fa-fw'></i>".$locale['download_0041']);
if (iMEMBER && $dl_settings['download_allow_submission'] && checkgroup($dl_settings['download_submission_access'])) {
    $criteriaArray = [
        "download_title"             => "",
        "download_cat"               => 0,
        "download_keywords"          => "",
        "download_description_short" => "",
        "download_description"       => "",
        "download_url"               => "",
        "download_license"           => "",
        "download_os"                => "",
        "download_version"           => "",
        "download_homepage"          => "",
        "download_copyright"         => "",
    ];
    if (isset($_POST['submit_download'])) {
        $criteriaArray = [
            'download_title'             => form_sanitizer($_POST['download_title'], '', 'download_title'),
            'download_keywords'          => form_sanitizer($_POST['download_keywords'], '', 'download_keywords'),
            'download_description'       => form_sanitizer($_POST['download_description'], '', 'download_description'),
            'download_description_short' => form_sanitizer($_POST['download_description_short'], '', 'download_description_short'),
            'download_cat'               => form_sanitizer($_POST['download_cat'], '0', 'download_cat'),
            'download_homepage'          => form_sanitizer($_POST['download_homepage'], '', 'download_homepage'),
            'download_license'           => form_sanitizer($_POST['download_license'], '', 'download_license'),
            'download_copyright'         => form_sanitizer($_POST['download_copyright'], '', 'download_copyright'),
            'download_os'                => form_sanitizer($_POST['download_os'], '', 'download_os'),
            'download_version'           => form_sanitizer($_POST['download_version'], '', 'download_version'),
            'download_file'              => '',
            'download_url'               => '',
            'download_image'             => '',
            'download_image_thumb'       => '',
            'download_filesize'          => ''
        ];
        /**
         * Download File Section
         */
        if (fusion_safe() && !empty($_FILES['download_file']['name']) && is_uploaded_file($_FILES['download_file']['tmp_name'])) {

            $upload = form_sanitizer($_FILES['download_file'], '', 'download_file');
            $criteriaArray['download_filesize'] = parsebytesize($_FILES['download_file']['size']);

            if (empty($upload['error']) && !empty($_FILES['download_file']['size'])) {
                if (!empty($upload['image_name'])) {
                    $criteriaArray['download_file'] = $upload['image_name'];
                } else if (!empty($upload['target_file'])) {
                    $criteriaArray['download_file'] = $upload['target_file'];
                } else {
                    fusion_stop();
                    addnotice('warning', $locale['download_0113']);
                }
            }
            unset($upload);
        } else if (!empty($_POST['download_url']) && empty($data['download_file'])) {
            $criteriaArray['download_url'] = form_sanitizer($_POST['download_url'], '', 'download_url');
        } else if (empty($data['download_file']) && empty($data['download_url'])) {
            fusion_stop();
            addnotice('danger', $locale['download_0111']);
        }
        // Screenshot submissions
        if ($dl_settings['download_screenshot']) {
            if (fusion_safe() && !empty($_FILES['download_image']['name']) && is_uploaded_file($_FILES['download_image']['tmp_name'])) {
                $upload = form_sanitizer($_FILES['download_image'], '', 'download_image');
                if (empty($upload['error'])) {
                    $criteriaArray['download_image'] = $upload['image_name'];
                    $criteriaArray['download_image_thumb'] = $upload['thumb1_name'];
                    unset($upload);
                }
            } else {
                if ($dl_settings['download_screenshot_required']) {
                    fusion_stop();
                    \Defender::setInputError("download_image");
                }
            }
        }

        if (fusion_safe()) {
            $inputArray = [
                'submit_type'      => 'd',
                'submit_user'      => $userdata['user_id'],
                'submit_datestamp' => time(),
                'submit_criteria'  => serialize($criteriaArray)
            ];
            dbquery_insert(DB_SUBMISSIONS, $inputArray, "save");
            addnotice("success", $locale['download_0042']);
            redirect(clean_request("submitted=d", ["stype"]));
        }
    }
    if (isset($_GET['submitted']) && $_GET['submitted'] == "d") {
        echo "<div class='well text-center'><p><strong>".$locale['download_0042']."</strong></p>";
        echo "<p><a href='".BASEDIR."submit.php?stype=d'>".$locale['download_0043']."</a></p>";
        echo "<p><a href='".BASEDIR."index.php'>".str_replace("[SITENAME]", fusion_get_settings("sitename"), $locale['download_0039'])."</a></p>\n";
        echo "</div>\n";
    } else {
        /**
         * The form
         */
        // must have category
        if (dbcount("(download_cat_id)", DB_DOWNLOAD_CATS, multilang_table("DL") ? in_group('download_cat_language', LANGUAGE) : "")) {
            echo "<div class='alert alert-info m-b-20 submission-guidelines'>".str_replace("[SITENAME]", fusion_get_settings("sitename"), $locale['download_0044'])."</div>\n";
            echo openform('submit_form', 'post', BASEDIR."submit.php?stype=d", ['enctype' => TRUE]);
            echo form_text('download_title', $locale['download_0200'], $criteriaArray['download_title'], [
                'required'   => TRUE,
                "inline"     => TRUE,
                'error_text' => $locale['download_0110']
            ]);
            echo form_select_tree("download_cat", $locale['download_0207'], $criteriaArray['download_cat'], [
                "inline"      => TRUE,
                "no_root"     => TRUE,
                "placeholder" => $locale['choose'],
                "query"       => (multilang_table("DL") ? "WHERE ".in_group('download_cat_language', LANGUAGE) : "")
            ], DB_DOWNLOAD_CATS, "download_cat_name", "download_cat_id", "download_cat_parent");
            echo form_select('download_keywords', $locale['download_0203'], $criteriaArray['download_keywords'], [
                "placeholder" => $locale['download_0203a'],
                'max_length'  => 320,
                "inline"      => TRUE,
                'width'       => '100%',
                'tags'        => 1,
                'multiple'    => 1
            ]);

            $textArea_opts_short = [
                "required"   => TRUE,
                "type"       => 'bbcode',
                "autosize"   => TRUE,
                "error_text" => $locale['download_0112'],
                "form_name"  => "submit_form",
            ];
            $textArea_opts = [
                "required"      => TRUE,
                "type"          => fusion_get_settings("tinymce_enabled") ? "tinymce" : "html",
                "tinymce"       => fusion_get_settings("tinymce_enabled") && iADMIN ? "advanced" : "simple",
                'tinymce_image' => FALSE,
                "autosize"      => TRUE,
                "error_text"    => $locale['download_0112'],
                "form_name"     => "submit_form",
                'path'          => IMAGES_D
            ];

            echo form_textarea('download_description_short', $locale['download_0202'], $criteriaArray['download_description_short'], $textArea_opts_short);

            $textArea_opts['required'] = $dl_settings['download_extended_required'];
            $textArea_opts['error_text'] = $locale['download_0201'];

            echo form_textarea('download_description', $locale['download_0202a'], $criteriaArray['download_description'], $textArea_opts);

            $tab_title['title'][] = "1 -".$locale['download_0214'];
            $tab_title['id'][] = 'dlf';
            $tab_title['icon'][] = 'fa fa-file-zip-o fa-fw';
            $tab_title['title'][] = "2 -".$locale['download_0215'];
            $tab_title['id'][] = 'dll';
            $tab_title['icon'][] = 'fa fa-plug fa-fw';
            $tab_active = tab_active($tab_title, 0);
            echo "<div class='list-group-item m-b-10'>\n";
            echo "<div class='well'>\n";
            echo "<strong>".$locale['download_0204']."</strong>\n";
            echo "</div>\n";
            echo opentab($tab_title, $tab_active, 'downloadtab');
            echo opentabbody($tab_title['title'][0], 'dlf', $tab_active);
            $file_options = [
                "class"       => "m-10 p-10",
                "inline"      => TRUE,
                //"required"    => TRUE,
                "upload_path" => DOWNLOADS."submissions/",
                "max_byte"    => $dl_settings['download_max_b'],
                'valid_ext'   => $dl_settings['download_types'],
                'error_text'  => $locale['download_0115'],
                "width"       => "100%",
                "thumbnail"   => FALSE,
                "thumbnail2"  => FALSE,
                "type"        => "object",
                "preview_off" => TRUE,
            ];
            echo form_fileinput('download_file', $locale['download_0214'], '', $file_options);
            echo "<div class='text-right'>\n<small>\n";
            echo sprintf($locale['download_0218'], parsebytesize($dl_settings['download_max_b']),
                    str_replace(',', ' ', $dl_settings['download_types']))."<br />\n";
            echo "</small>\n</div>\n";
            echo closetabbody();
            echo opentabbody($tab_title['title'][1], 'dll', $tab_active);
            echo form_text('download_url', $locale['download_0206'], "", [
                "class"       => "m-10 p-10",
                "error_text"  => $locale['download_0116'],
                "inline"      => TRUE,
                //"required"    => TRUE,
                "placeholder" => "http://"
            ]);
            echo closetabbody();
            echo closetab();
            echo "</div>\n";
            if ($dl_settings['download_screenshot']) {
                $screenshot_options = [
                    "inline"           => TRUE,
                    "upload_path"      => DOWNLOADS."submissions/images/",
                    "required"         => $dl_settings['download_screenshot_required'],
                    "max_width"        => $dl_settings['download_screen_max_w'],
                    "max_height"       => $dl_settings['download_screen_max_h'],
                    "max_byte"         => $dl_settings['download_screen_max_b'],
                    "type"             => "image",
                    "delete_original"  => FALSE,
                    "thumbnail_folder" => "",
                    "thumbnail"        => TRUE,
                    "thumbnail_suffix" => "_thumb",
                    "thumbnail_w"      => $dl_settings['download_thumb_max_w'],
                    "thumbnail_h"      => $dl_settings['download_thumb_max_h'],
                    "thumbnail2"       => 0,
                    "error_text"       => $locale['download_0114'],
                    "template"         => "modern"
                ];
                echo form_fileinput('download_image', $locale['download_0220'], '', $screenshot_options);
            }

            echo "<div class='text-right m-b-10'>\n<small>\n";

            echo sprintf($locale['download_0219'],
                    parsebytesize($dl_settings['download_screen_max_b']),
                    str_replace(',', ' ', ".jpg,.gif,.png"),
                    $dl_settings['download_screen_max_w'],
                    $dl_settings['download_screen_max_h'])."\n";
            echo "</small>\n</div>\n";

            echo form_text('download_license', $locale['download_0208'], $criteriaArray['download_license'], ["inline" => TRUE]);

            echo form_text('download_os', $locale['download_0209'], $criteriaArray['download_os'], ["inline" => TRUE]);

            echo form_text('download_version', $locale['download_0210'], $criteriaArray['download_version'], ["inline" => TRUE]);

            echo form_text('download_homepage', $locale['download_0221'], $criteriaArray['download_homepage'], ["inline" => TRUE]);

            echo form_text('download_copyright', $locale['download_0222'], $criteriaArray['download_copyright'], ["inline" => TRUE]);

            echo form_hidden('calc_upload', '', '1');

            echo form_button('submit_download', $locale['download_0041'], $locale['download_0041'], ['class' => 'btn-success', 'icon' => 'fa fa-hdd-o']);

            echo closeform();

        } else {
            echo "<div class='well text-center'>".$locale['download_0249']."<br /><br />\n</div>\n";
        }
    }
} else {
    echo "<div class='well text-center'>".$locale['download_0040']."</div>\n";
}
closetable();
